package CXC::DB::DDL::Types;

# ABSTRACT: Types, oh my!

use v5.26;
use strict;
use warnings;

our $VERSION = '0.14';

use CXC::DB::DDL::Constants -all;

use Type::Library -base, -declare => ( qw(
      Index
      Indexes
      Constraint
) );

use Type::Utils -all;
use Types::Standard qw( ArrayRef Bool CodeRef Dict Enum HashRef Optional Str );















declare Indexes, as ArrayRef [Index];

coerce Indexes, from ArrayRef [Str], q/ [ { fields => $_ } ] /;


























declare Index,
  as Dict [
    name    => Optional [Str],
    fields  => Optional [ Str | ArrayRef [Str] ],
    type    => Optional [ Enum [SCHEMA_CONSTANTS] ],
    options => Optional [HashRef],
  ];

coerce Index, from ArrayRef [Str], q[ { fields => $_ } ];




























































use constant ArrayRefFromStr => ArrayRef->of( Str )->plus_coercions( Str, q{[$_]} ), coercion => 1;

declare Constraint,
  as Dict [
    type              => Enum [SCHEMA_CONSTANTS],
    name              => Optional [Str],
    deferrable        => Optional [Bool],
    expression        => Optional [ Str | CodeRef ],
    fields            => Optional [ArrayRefFromStr],
    referenced_fields => Optional [ArrayRefFromStr],
    reference_table   => Optional [Str],
    match_type        => Optional [ Enum [SCHEMA_CONSTRAINT_MATCH_TYPES] ],
    on_delete         => Optional [ Enum [SCHEMA_CONSTRAINT_ON_DELETE] ],
    on_update         => Optional [ Enum [SCHEMA_CONSTRAINT_ON_UPDATE] ],
    options           => Optional [HashRef],
  ],
  coercion => 1;


1;

#
# This file is part of CXC-DB-DDL
#
# This software is Copyright (c) 2022 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

__END__

=pod

=for :stopwords Diab Jerius Smithsonian Astrophysical Observatory coercible deferrable

=head1 NAME

CXC::DB::DDL::Types - Types, oh my!

=head1 VERSION

version 0.14

=head1 SYNOPSIS

  use CXC::DB::DDL::Types -all;

  say "yup, it's an index" if is_Index($index);

=head1 DESCRIPTION

Types used by L<CXC::DB::DDL> and associated modules.  Enumerated
values are typically generated by the enumeration functions in
L<CXC::DB::DDL::Constants>; see that for more information.

=head1 TYPES

=head2 Indexes

An array of values which pass the L</Index> type constraint.

Coercible from an B<< ArrayRef [Str] >> as

    [ { fields => $aref } ]

=head2 Index

A hashref with the following fields (all of which are optional, but
that would result in a bogus constraint, so don't do that):

=over

=item name    => Optional [Str]

Z<>

=item fields  => Optional [ Str | ArrayRef [Str] ]

Z<>

=item type    => Optional [ Enum [SCHEMA_CONSTANTS] ]

Z<>

=item options => Optional [HashRef]

=back

=head2 Constraint

A hashref with the following fields (all of which are optional, but
that would result in a bogus constraint, so don't do that):

=over

=item type              => Optional [ Enum [SCHEMA_CONSTANTS] ]

Z<>

=item name              => Optional [Str]

Z<>

=item deferrable        => Optional [Bool]

Z<>

=item expression        => Optional [Str|CodeRef]

Z<>

=item fields            => Optional [ Str | ArrayRef [Str] ]

Z<>

=item referenced_fields => Optional [ Str | ArrayRef [Str] ]

Z<>

=item reference_table   => Optional [Str]

Z<>

=item match_type        => Optional [ Enum [SCHEMA_CONSTRAINT_MATCH_TYPES] ]

Z<>

=item on_delete         => Optional [ Enum [SCHEMA_CONSTRAINT_ON_DELETE] ]

Z<>

=item on_update         => Optional [ Enum [SCHEMA_CONSTRAINT_ON_UPDATE] ]

Z<>

=item options           => Optional [HashRef]

Z<>

=back

=head1 SUPPORT

=head2 Bugs

Please report any bugs or feature requests to bug-cxc-db-ddl@rt.cpan.org  or through the web interface at: L<https://rt.cpan.org/Public/Dist/Display.html?Name=CXC-DB-DDL>

=head2 Source

Source is available at

  https://gitlab.com/djerius/cxc-db-ddl

and may be cloned from

  https://gitlab.com/djerius/cxc-db-ddl.git

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<CXC::DB::DDL|CXC::DB::DDL>

=back

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
