## no critic: TestingAndDebugging::RequireUseStrict
package Task::BeLike::PERLANCAR::Used;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-07-07'; # DATE
our $DIST = 'Task-BeLike-PERLANCAR-Used'; # DIST
our $VERSION = '0.002'; # VERSION

1;
# ABSTRACT: All my modules which I currently use and install on a new perl installation

__END__

=pod

=encoding UTF-8

=head1 NAME

Task::BeLike::PERLANCAR::Used - All my modules which I currently use and install on a new perl installation

=head1 VERSION

version 0.002

=head1 SYNOPSIS

Here's how I usually bootstrap a fresh perl installation (e.g. after a
C<perlbrew install>):

 % cpanm -n App::cpanm::perlancar
 % cpanm-perlancar -n Task::BeLike::PERLANCAR::Used

=head1 TASK CONTENTS

=head2 Included modules

=head3 L<Acme::CM::Get> 0

=head3 L<Acme::CPAN::Testers::DevelCheckOS> 0

=head3 L<Acme::CPANAuthors::CPAN::MostScripts> 0

=head3 L<Acme::CPANAuthors::CPAN::TopDepended> 0

=head3 L<Acme::CPANAuthors::CPAN::TopDepended::ByOthers> 0

=head3 L<Acme::CPANAuthors::Indonesian> 0

=head3 L<Acme::CPANModules> 0.1.7

=head3 L<Acme::CPANModules::API::Dead::Currency> 0

=head3 L<Acme::CPANModules::API::Domain::Registrar> 0

=head3 L<Acme::CPANModules::AliasingModuleName> 0

=head3 L<Acme::CPANModules::ArrayClassBuilder> 0

=head3 L<Acme::CPANModules::Assert> 0

=head3 L<Acme::CPANModules::BloomFilters> 0

=head3 L<Acme::CPANModules::BrowserUtilities> 0

=head3 L<Acme::CPANModules::BrowsingTableInteractively> 0

=head3 L<Acme::CPANModules::CLI::Sort> 0

=head3 L<Acme::CPANModules::CLI::Wrapper::UnixCommand> 0.006

=head3 L<Acme::CPANModules::CLIWithUndo> 0

=head3 L<Acme::CPANModules::COLOR> 0

=head3 L<Acme::CPANModules::CPANModules> 0

=head3 L<Acme::CPANModules::CPANModules::API> 0

=head3 L<Acme::CPANModules::CalculatingDayOfWeek> 0

=head3 L<Acme::CPANModules::CheckingModuleInstalledLoadable> 0

=head3 L<Acme::CPANModules::ColorEnv> 0

=head3 L<Acme::CPANModules::ColorThemed> 0

=head3 L<Acme::CPANModules::ContainingJustData> 0

=head3 L<Acme::CPANModules::ConvertingFromRegex> 0

=head3 L<Acme::CPANModules::ConvertingRadix> 0

=head3 L<Acme::CPANModules::ConvertingToRegex> 0

=head3 L<Acme::CPANModules::CreatingPaletteOfVisuallyDistinctColors> 0

=head3 L<Acme::CPANModules::CryptoExchange::API> 0

=head3 L<Acme::CPANModules::CustomCPAN> 0

=head3 L<Acme::CPANModules::DataStructureWalker> 0

=head3 L<Acme::CPANModules::Dead> 0

=head3 L<Acme::CPANModules::DescribeAModuleBadly> 0

=head3 L<Acme::CPANModules::DescribeAModuleBadly::PERLANCAR> 0

=head3 L<Acme::CPANModules::Desktop> 0

=head3 L<Acme::CPANModules::DiffWrappers> 0

=head3 L<Acme::CPANModules::DiffingStructuredData> 0

=head3 L<Acme::CPANModules::DiffingStuffs> 0

=head3 L<Acme::CPANModules::DumpingDataForDebugging> 0

=head3 L<Acme::CPANModules::EscapingAndQuoting> 0

=head3 L<Acme::CPANModules::FooThis> 0

=head3 L<Acme::CPANModules::Foozilla> 0

=head3 L<Acme::CPANModules::Frameworks> 0

=head3 L<Acme::CPANModules::Getopt> 0

=head3 L<Acme::CPANModules::GettingTempDir> 0

=head3 L<Acme::CPANModules::GrepVariants> 0

=head3 L<Acme::CPANModules::HTMLTable> 0

=head3 L<Acme::CPANModules::HashUtilities> 0

=head3 L<Acme::CPANModules::HaveWebsite> 0

=head3 L<Acme::CPANModules::HidingModules> 0

=head3 L<Acme::CPANModules::Import::CPANRatings::User::perlancar> 0

=head3 L<Acme::CPANModules::Import::CPANRatings::User::stevenharyanto> 0

=head3 L<Acme::CPANModules::Interop::Ruby> 0

=head3 L<Acme::CPANModules::KitchenSinks> 0

=head3 L<Acme::CPANModules::ListsOfWordsAndNames> 0

=head3 L<Acme::CPANModules::LocalCPANIndex> 0

=head3 L<Acme::CPANModules::LocalCPANMirror> 0

=head3 L<Acme::CPANModules::MagicVariableTechnique> 0

=head3 L<Acme::CPANModules::ManagingMultipleRepositories> 0

=head3 L<Acme::CPANModules::MockModules> 0

=head3 L<Acme::CPANModules::ModernPreambles> 0

=head3 L<Acme::CPANModules::ModuleAutoinstallers> 0

=head3 L<Acme::CPANModules::ModuleAutoloaders> 0

=head3 L<Acme::CPANModules::MooseStyleClassBuilder> 0

=head3 L<Acme::CPANModules::NO_COLOR> 0

=head3 L<Acme::CPANModules::NewDistributions::202001> 0

=head3 L<Acme::CPANModules::NonMooseStyleClassBuilder> 0

=head3 L<Acme::CPANModules::OneAndTwoDecimalDigitsVersionTrap> 0

=head3 L<Acme::CPANModules::OneLetter> 0

=head3 L<Acme::CPANModules::OneLinerTools> 0

=head3 L<Acme::CPANModules::Org> 0

=head3 L<Acme::CPANModules::OrganizingCPAN> 0

=head3 L<Acme::CPANModules::PAUSE> 0

=head3 L<Acme::CPANModules::PERLANCAR::Dummy> 0

=head3 L<Acme::CPANModules::PERLANCAR::Forked> 0

=head3 L<Acme::CPANModules::PERLANCAR::InfoFromCPANTesters> 0

=head3 L<Acme::CPANModules::PERLANCAR::RsyncEnhancements> 0

=head3 L<Acme::CPANModules::PERLANCAR::Temp::Plus> 0

=head3 L<Acme::CPANModules::Parse::HumanDate> 0

=head3 L<Acme::CPANModules::Parse::UnixCommands> 0

=head3 L<Acme::CPANModules::Parse::UnixConfigs> 0

=head3 L<Acme::CPANModules::Parse::UnixShellCommandLine> 0

=head3 L<Acme::CPANModules::PickingRandomItemsFromList> 0

=head3 L<Acme::CPANModules::PickingRandomLinesFromFile> 0

=head3 L<Acme::CPANModules::PodConverters> 0

=head3 L<Acme::CPANModules::PortedFrom::Clojure> 0

=head3 L<Acme::CPANModules::PortedFrom::Go> 0

=head3 L<Acme::CPANModules::PortedFrom::Java> 0

=head3 L<Acme::CPANModules::PortedFrom::NPM> 0

=head3 L<Acme::CPANModules::PortedFrom::PHP> 0

=head3 L<Acme::CPANModules::PortedFrom::Python> 0

=head3 L<Acme::CPANModules::PortedFrom::Ruby> 0

=head3 L<Acme::CPANModules::RandomData> 0

=head3 L<Acme::CPANModules::RandomPassword> 0

=head3 L<Acme::CPANModules::RandomPerson> 0

=head3 L<Acme::CPANModules::ReadingFilesBackward> 0

=head3 L<Acme::CPANModules::RenamingFiles> 0

=head3 L<Acme::CPANModules::Roles> 0

=head3 L<Acme::CPANModules::RsyncWrappers> 0

=head3 L<Acme::CPANModules::SExpression> 0

=head3 L<Acme::CPANModules::SQLite> 0

=head3 L<Acme::CPANModules::Set> 0

=head3 L<Acme::CPANModules::ShellCompleters> 0

=head3 L<Acme::CPANModules::StructuredDATA> 0

=head3 L<Acme::CPANModules::Sudoku> 0

=head3 L<Acme::CPANModules::Symlink> 0

=head3 L<Acme::CPANModules::TextTable> 0

=head3 L<Acme::CPANModules::UUID> 0

=head3 L<Acme::CPANModules::Unbless> 0

=head3 L<Acme::CPANModules::UpsideDownTextWithUnicode> 0

=head3 L<Acme::CPANModules::VersionNumber::Perl> 0

=head3 L<Acme::CPANModules::WordListBundle::Proverbs> 0

=head3 L<Acme::CPANModules::WorkingWithCSV> 0

=head3 L<Acme::CPANModules::WorkingWithTree> 0

=head3 L<Acme::CPANModules::WorkingWithURL> 0

=head3 L<Acme::CPANModules::WorkingWithXLS> 0

=head3 L<Acme::CPANModules::WrappingText> 0

=head3 L<Acme::CPANModules::XSVersions> 0

=head3 L<Acme::CPANModules::fgets> 0

=head3 L<Acme::CPANModulesBundle::Import> 0

=head3 L<Acme::CPANModulesBundle::Import::BKB> 0

=head3 L<Acme::CPANModulesBundle::Import::DAVECROSS> 0

=head3 L<Acme::CPANModulesBundle::Import::MJGARDNER> 0

=head3 L<Acme::CPANModulesBundle::Import::MojoliciousAdvent::2017> 0

=head3 L<Acme::CPANModulesBundle::Import::MojoliciousAdvent::2018> 0

=head3 L<Acme::CPANModulesBundle::Import::NEILB> 0

=head3 L<Acme::CPANModulesBundle::Import::PERLANCAR::Advent::2014> 0

=head3 L<Acme::CPANModulesBundle::Import::PERLANCAR::GetoptModules> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2000> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2001> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2002> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2003> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2004> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2005> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2006> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2007> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2008> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2009> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2010> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2011> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2012> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2013> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2014> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2015> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2016> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2017> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlAdvent::2018> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlDancerAdvent::2010> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlDancerAdvent::2011> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlDancerAdvent::2012> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlDancerAdvent::2014> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlDancerAdvent::2016> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlDancerAdvent::2018> 0

=head3 L<Acme::CPANModulesBundle::Import::PerlTricks> 0

=head3 L<Acme::CPANModulesBundle::Import::RSAVAGE> 0

=head3 L<Acme::CPANModulesBundle::Import::SHARYANTO> 0

=head3 L<Acme::CPANModulesBundle::PERLANCAR> 0

=head3 L<Acme::CPANModulesBundle::PERLANCAR::Self> 0

=head3 L<Acme::CPANModulesUtil::Bencher> 0

=head3 L<Acme::CPANModulesUtil::FeatureMatrix> 0

=head3 L<Acme::CPANModulesUtil::Misc> 0

=head3 L<Acme::CPANRatings> 0

=head3 L<Acme::ID::CompanyName> 0

=head3 L<Acme::LastWords> 0

=head3 L<Acme::MetaSyntactic::WordList> 0

=head3 L<Acme::MetaSyntactic::boboiboy> 0

=head3 L<Acme::MetaSyntactic::chinese_zodiac> 0

=head3 L<Acme::MetaSyntactic::christmas> 0

=head3 L<Acme::MetaSyntactic::countries> 0

=head3 L<Acme::MetaSyntactic::dangdut> 0

=head3 L<Acme::MetaSyntactic::display_resolution> 0

=head3 L<Acme::MetaSyntactic::frasier> 0

=head3 L<Acme::MetaSyntactic::gavan> 0

=head3 L<Acme::MetaSyntactic::id_beverages> 0

=head3 L<Acme::MetaSyntactic::id_dishes> 0

=head3 L<Acme::MetaSyntactic::id_names> 0

=head3 L<Acme::MetaSyntactic::metal_heroes> 0

=head3 L<Acme::MetaSyntactic::newsradio> 0

=head3 L<Acme::MetaSyntactic::ozark> 0

=head3 L<Acme::MetaSyntactic::seinfeld> 0

=head3 L<Acme::MetaSyntactic::unyil> 0

=head3 L<Algorithm::Backoff> 0.006

=head3 L<Algorithm::History::Levels> 0

=head3 L<Android::Releases> 0

=head3 L<Apachish> 0

=head3 L<Apachish::Examples> 0

=head3 L<App::ANSIColorUtils> 0

=head3 L<App::ASCIIUtils> 0

=head3 L<App::AcmeCpanauthors> 0

=head3 L<App::AdditivesUtils> 0

=head3 L<App::AlgorithmBackoffUtils> 0

=head3 L<App::AlgorithmDiffUtils> 0

=head3 L<App::ArgUtils> 0

=head3 L<App::BIP39Utils> 0

=head3 L<App::BPOMUtils::Additives> 0

=head3 L<App::BPOMUtils::NutritionFacts> 0

=head3 L<App::BPOMUtils::RPO::Checker> 0

=head3 L<App::BPOMUtils::Table::FoodAdditive> 0

=head3 L<App::BPOMUtils::Table::FoodCategory> 0

=head3 L<App::BPOMUtils::Table::FoodIngredient> 0

=head3 L<App::BPOMUtils::Table::FoodType> 0

=head3 L<App::BPOMUtils::Table::MicrobeInput> 0

=head3 L<App::BPOMUtils::Table::RegCodePrefix> 0

=head3 L<App::BashHistoryUtils> 0

=head3 L<App::BencherUtils> 0

=head3 L<App::BinPackUtils> 0

=head3 L<App::BlockWebFlooders> 0

=head3 L<App::BloomUtils> 0

=head3 L<App::BluetoothUtils> 0

=head3 L<App::BorderStyleUtils> 0

=head3 L<App::BraveUtils> 0

=head3 L<App::BrowserOpenUtils> 0

=head3 L<App::BrowserUtils> 0.018

=head3 L<App::CLITestUtils> 0

=head3 L<App::CPAN::Changes> 0

=head3 L<App::CPANChangesCwaliteeUtils> 0

=head3 L<App::CPANChangesUtils> 0

=head3 L<App::CPANMetaUtils> 0

=head3 L<App::CPANModulesUtils> 0

=head3 L<App::CPANURLUtils> 0

=head3 L<App::CSVUtils> 0.032

=head3 L<App::CSelUtils> 0.084

=head3 L<App::CalcAccumulatedDiscounts> 0

=head3 L<App::CalcAccumulatedInflation> 0

=head3 L<App::CalendarDatesUtils> 0

=head3 L<App::CdUtils> 0

=head3 L<App::CekBpom> 0

=head3 L<App::CheckArchiveFilename> 0

=head3 L<App::CheckDigitsUtils> 0

=head3 L<App::ChemistryUtils> 0

=head3 L<App::ChromeUtils> 0

=head3 L<App::ClipboardUtils> 0

=head3 L<App::ColorThemeUtils> 0

=head3 L<App::CommonMarkUtils> 0

=head3 L<App::CompleteCLIs> 0

=head3 L<App::CompleteUtils> 0

=head3 L<App::ConvertLogAnyToLogGer> 0

=head3 L<App::CreateAcmeCPANModulesImportCPANRatingsModules> 0

=head3 L<App::CreateAcmeCPANModulesImportModules> 0

=head3 L<App::CreateRandomFile> 0

=head3 L<App::CreateSelfSignedSSLCert> 0

=head3 L<App::CronUtils> 0

=head3 L<App::CrossPericmd> 0

=head3 L<App::CryptoCurrencyUtils> 0

=head3 L<App::DAVThis> 0

=head3 L<App::DBIUtils> 0

=head3 L<App::DNSZoneUtils> 0

=head3 L<App::DataDirUtils> 0

=head3 L<App::DataPackUtils> 0

=head3 L<App::DataSectionSeekableUtils> 0

=head3 L<App::DateUtils> 0

=head3 L<App::DesktopOpenUtils> 0

=head3 L<App::DiffCPANReleases> 0

=head3 L<App::DiffDBSchemaUtils> 0

=head3 L<App::DiffDocText> 0

=head3 L<App::DiffPDFText> 0

=head3 L<App::DiffTarballs> 0

=head3 L<App::DiffXlsText> 0

=head3 L<App::DisplayResolutionUtils> 0

=head3 L<App::DistUtils> 0

=head3 L<App::DistroWatchUtils> 0

=head3 L<App::DumpChromeHistory> 0.005

=head3 L<App::DumpFirefoxHistory> 0

=head3 L<App::DumpOperaHistory> 0

=head3 L<App::DumpPERLANCARSampleTree> 0

=head3 L<App::DumpVivaldiHistory> 0

=head3 L<App::DuplicateFilesUtils> 0

=head3 L<App::DzilUtils> 0

=head3 L<App::ENumberUtils> 0

=head3 L<App::EscapeUtils> 0

=head3 L<App::ExecIf> 0

=head3 L<App::ExifUtils> 0

=head3 L<App::ExtractCPANModulesFromHTML> 0

=head3 L<App::ExtractDate> 0

=head3 L<App::FTPThis> 0

=head3 L<App::FatPackUtils> 0

=head3 L<App::FfmpegUtils> 0

=head3 L<App::FileCommonUtils> 0

=head3 L<App::FileCreateLayoutUtils> 0

=head3 L<App::FileDigestCLIs> 0

=head3 L<App::FileModifyUtils> 0

=head3 L<App::FileRemoveUtils> 0.004

=head3 L<App::FileRenameUtils> 0

=head3 L<App::FileTestUtils> 0

=head3 L<App::FilenameUtils> 0

=head3 L<App::FinanceUtils> 0

=head3 L<App::FindUtils> 0

=head3 L<App::FireDiamondUtils> 0

=head3 L<App::FirefoxMultiAccountContainersUtils> 0

=head3 L<App::FirefoxUtils> 0.012

=head3 L<App::FishCompleteUtils> 0

=head3 L<App::FontUtils> 0

=head3 L<App::FoodAdditivesUtils> 0

=head3 L<App::FormatCPANChanges::PERLANCAR> 0

=head3 L<App::GamesWordlist> 0

=head3 L<App::GenPericmdCompleterScript> 0.123

=head3 L<App::GenPericmdScript> 0

=head3 L<App::GetoptLongDescriptiveUtils> 0

=head3 L<App::GetoptLongExamples> 0

=head3 L<App::GetoptLongMoreUtils> 0

=head3 L<App::GetoptLongSubcommandUtils> 0

=head3 L<App::GetoptLongUtils> 0

=head3 L<App::GetoptStdUtils> 0

=head3 L<App::GitHubUtils> 0

=head3 L<App::GitUtils> 0.004

=head3 L<App::GnuplotUtils> 0

=head3 L<App::GoogleAuthUtils> 0

=head3 L<App::GoogleSearchPerlIRCLogs> 0

=head3 L<App::GoogleSearchPerlmonksUser> 0

=head3 L<App::GoogleSearchUtils> 0

=head3 L<App::GraphicsColorNamesUtils> 0

=head3 L<App::GrepUtils> 0

=head3 L<App::HTMLUtils::Grep> 0

=head3 L<App::HTTPSThis> 0

=head3 L<App::HTTPTinyUtils> 0

=head3 L<App::HTTPUserAgentUtils> 0

=head3 L<App::HasPrereqs> 0

=head3 L<App::IDXUtils> 0

=head3 L<App::IMDBUtils> 0

=head3 L<App::INIUtils> 0

=head3 L<App::IODCounterSimpleUtils> 0

=head3 L<App::IODUtils> 0

=head3 L<App::IPUtils> 0

=head3 L<App::ISBNUtils> 0

=head3 L<App::ImageInfoUtils> 0

=head3 L<App::ImageMagickUtils> 0

=head3 L<App::IncrementUtils> 0

=head3 L<App::IndonesianBankingUtils> 0

=head3 L<App::IndonesianFinanceUtils> 0

=head3 L<App::IndonesianHolidayUtils> 0

=head3 L<App::IndonesianLocaleUtils> 0

=head3 L<App::IndonesianNumberUtils> 0

=head3 L<App::KBLIUtils> 0

=head3 L<App::KwaliteeUtils> 0

=head3 L<App::LTSVUtils> 0

=head3 L<App::LWPUtils> 0

=head3 L<App::LanguageExprUtils> 0

=head3 L<App::LedgerUtils> 0

=head3 L<App::LibreOfficeUtils> 0

=head3 L<App::LinguaENUtils> 0

=head3 L<App::LinguaIDUtils> 0

=head3 L<App::LinguaIdentifyAnyUtils> 0

=head3 L<App::LinguaSUUtils> 0

=head3 L<App::LintPrereqs> 0

=head3 L<App::ListAndroidReleases> 0

=head3 L<App::ListCentosReleases> 0

=head3 L<App::ListCountries> 0

=head3 L<App::ListCurrencies> 0

=head3 L<App::ListDebianReleases> 0

=head3 L<App::ListIntlPhoneCodes> 0

=head3 L<App::ListLanguages> 0

=head3 L<App::ListLinuxmintReleases> 0

=head3 L<App::ListNewCPANDists> 0.011

=head3 L<App::ListPerlReleases> 0

=head3 L<App::ListRedhatReleases> 0

=head3 L<App::ListSoftwareLicenses> 0

=head3 L<App::ListUbuntuReleases> 0

=head3 L<App::ListUtils> 0

=head3 L<App::LocaleCodesUtils> 0

=head3 L<App::LocaleTextDomainUtils> 0

=head3 L<App::LogGerUtils> 0

=head3 L<App::MSOfficeUtils> 0

=head3 L<App::MTPUtils> 0

=head3 L<App::MacVictimUtils> 0

=head3 L<App::ManUtils> 0

=head3 L<App::ManagePoolStyleRepo> 0

=head3 L<App::MarkdownUtils> 0

=head3 L<App::MediaInfo> 0.126

=head3 L<App::MediaInfoUtils> 0

=head3 L<App::MetaCPANUtils> 0

=head3 L<App::ModuleAbstractCwaliteeUtils> 0

=head3 L<App::ModuleFeaturesUtils> 0

=head3 L<App::ModulePatchUtils> 0

=head3 L<App::ModuleReleaseSelectUtils> 0

=head3 L<App::ModuleVersionDiffUtils> 0

=head3 L<App::MysqlUtils> 0

=head3 L<App::NYTProfUtils> 0

=head3 L<App::NetworkUtils> 0

=head3 L<App::NumberUtilRangeUtils> 0

=head3 L<App::OfficeUtils> 0.005

=head3 L<App::OperaUtils> 0

=head3 L<App::OrgUtils> 0.44

=head3 L<App::OverlapUtils> 0

=head3 L<App::PDFUtils> 0.012

=head3 L<App::PDRUtils> 0

=head3 L<App::PMUtils> 0

=head3 L<App::PMVersionsUtils> 0

=head3 L<App::PODUtils> 0

=head3 L<App::PPH21Utils> 0

=head3 L<App::PPIUtils> 0

=head3 L<App::PackUtils> 0

=head3 L<App::ParseBounceMessage> 0

=head3 L<App::ParseCPANChanges> 0

=head3 L<App::ParseCommandLineUtils> 0

=head3 L<App::ParseHosts> 0

=head3 L<App::ParseNetstat> 0

=head3 L<App::ParseSearchStringFromURL> 0

=head3 L<App::ParseServices> 0

=head3 L<App::PasswordWordListUtils> 0

=head3 L<App::PathNaiveUtils> 0

=head3 L<App::PayPalUtils> 0

=head3 L<App::PericmdUtils> 0

=head3 L<App::PerinciUtils> 0

=head3 L<App::PerlCriticUtils> 0

=head3 L<App::PerlReleaseUtils> 0

=head3 L<App::PerlbrewUtils> 0

=head3 L<App::PermuteNamed> 0

=head3 L<App::PhoneNumberUtils> 0

=head3 L<App::PhysicsUnitUtils> 0

=head3 L<App::PickRandomLines> 0

=head3 L<App::PlUtils> 0

=head3 L<App::PlatformInfo> 0

=head3 L<App::PlatformMatchUtils> 0

=head3 L<App::PowerManagementUtils> 0

=head3 L<App::PrettyRes> 0

=head3 L<App::PrimesPericmd> 0

=head3 L<App::ProcUtils> 0

=head3 L<App::ProgUtils> 0

=head3 L<App::ProveAuthor> 0

=head3 L<App::ProveDeps> 0

=head3 L<App::ProveDirs> 0

=head3 L<App::ProveDists> 0

=head3 L<App::ProveMods> 0

=head3 L<App::ProveRdeps> 0

=head3 L<App::ProveWithPrereqsOnly> 0

=head3 L<App::QRCodeUtils> 0

=head3 L<App::RGBColorUtils> 0

=head3 L<App::RcloneUtils> 0

=head3 L<App::RegexpCommonUtils> 0

=head3 L<App::RegexpPatternUtils> 0

=head3 L<App::ReleaseUtils> 0

=head3 L<App::SQLiteCounterSimpleUtils> 0

=head3 L<App::SQLiteKeyValueStoreSimpleUtils> 0

=head3 L<App::SQLiteUtils> 0

=head3 L<App::SahUtils> 0

=head3 L<App::ScanPrereqs> 0

=head3 L<App::ScreensaverUtils> 0

=head3 L<App::ScriptXUtils> 0

=head3 L<App::SeqPericmd> 0

=head3 L<App::SerializeUtils> 0

=head3 L<App::ShellCompleter::CpanUpload> 0

=head3 L<App::ShellCompleter::YoutubeDl> 0

=head3 L<App::ShellCompleter::YtDlp> 0

=head3 L<App::ShellCompleter::cpanm> 0.210

=head3 L<App::ShellCompleter::emacs> 0

=head3 L<App::ShellCompleter::meta> 0

=head3 L<App::ShellCompleter::mpv> 0.060

=head3 L<App::ShellCompleter::pause> 0

=head3 L<App::ShellCompleter::perlbrew> 0

=head3 L<App::ShellUtils> 0

=head3 L<App::ShowPERLANCARSampleHTMLTree> 0

=head3 L<App::SortByLines> 0

=head3 L<App::SortSubUtils> 0

=head3 L<App::Spanel::BuildBindZones> 0

=head3 L<App::Spanel::BuildBindZonesFromPowerDNSDB> 0

=head3 L<App::Spanel::TailWeblog> 0

=head3 L<App::SpreadsheetUtils> 0

=head3 L<App::StatisticsUtils> 0

=head3 L<App::StockExchangeUtils> 0

=head3 L<App::StringQueryToRegexpUtils> 0

=head3 L<App::StringUtilRangeUtils> 0

=head3 L<App::StringWildcardUtils> 0

=head3 L<App::SubtitleUtils> 0

=head3 L<App::SystemdUtils> 0

=head3 L<App::TOMLUtils> 0

=head3 L<App::TSVUtils> 0

=head3 L<App::TableDataUtils> 0

=head3 L<App::Tables::CLI> 0

=head3 L<App::TaggedDirUtils> 0

=head3 L<App::TermAttrUtils> 0

=head3 L<App::TextDiffUUtils> 0

=head3 L<App::TextFragmentUtils> 0

=head3 L<App::TextTableUtils> 0

=head3 L<App::TextWrapUtils> 0

=head3 L<App::ThisDist> 0.012

=head3 L<App::ThisDist::OnMetaCPAN> 0

=head3 L<App::TimeZoneUtils> 0

=head3 L<App::TouchpadUtils> 0

=head3 L<App::TouchscreenUtils> 0

=head3 L<App::TrimHistories> 0

=head3 L<App::URIInfoUtils> 0

=head3 L<App::URIUtils> 0

=head3 L<App::UniqFiles> 0.136

=head3 L<App::UniqUtils> 0

=head3 L<App::UnixUIDUtils> 0

=head3 L<App::UpfUtils> 0

=head3 L<App::UuidUtils> 0

=head3 L<App::VersioningSchemeUtils> 0

=head3 L<App::VitaminUtils> 0

=head3 L<App::VivaldiUtils> 0

=head3 L<App::WHMCSUtils> 0

=head3 L<App::WHOGrowthReferenceUtils> 0

=head3 L<App::WeaverUtils> 0

=head3 L<App::WebSearchUtils> 0

=head3 L<App::WordListUtils> 0

=head3 L<App::XTermUtils> 0

=head3 L<App::YouTubeUtils> 0

=head3 L<App::YoutubeDlIf> 0

=head3 L<App::YoutubeDlIfNotYet> 0

=head3 L<App::YoutubeDlUtils> 0

=head3 L<App::ZodiacUtils> 0

=head3 L<App::ZodiacUtils::Lite> 0

=head3 L<App::ZshCompleteUtils> 0

=head3 L<App::abgrep> 0

=head3 L<App::adr2org> 0

=head3 L<App::after> 0

=head3 L<App::arraydata> 0

=head3 L<App::audioinfo> 0

=head3 L<App::bwk::mn> 0

=head3 L<App::cal::idn> 0

=head3 L<App::calx> 0

=head3 L<App::chalk> 0

=head3 L<App::coinbasepro::lite> 0

=head3 L<App::colorxform> 0

=head3 L<App::column::run> 0

=head3 L<App::corruptor> 0

=head3 L<App::cpanm::cpanmodules> 0

=head3 L<App::cpanm::namespace> 0

=head3 L<App::cpanm::perlancar> 0

=head3 L<App::cpanm::script> 0

=head3 L<App::cpanm::shcompgen> 0

=head3 L<App::cpanm::task> 0

=head3 L<App::cpanminus::script::Patch::Blacklist> 0

=head3 L<App::cpanminus::script::Patch::RunShcompgen> 0

=head3 L<App::cpanminus::script::Patch::UseURIFromFoundMirror> 0

=head3 L<App::cpanmodules> 0

=head3 L<App::cryp::arbit> 0

=head3 L<App::cryp::exchange> 0

=head3 L<App::cryp::mn> 0

=head3 L<App::daftarnama::reseller> 0

=head3 L<App::datecalc> 0

=head3 L<App::dateseq> 0.102

=head3 L<App::dateseq::idn> 0

=head3 L<App::dbinfo> 0.003

=head3 L<App::depak> 0.584

=head3 L<App::depakable> 0

=head3 L<App::diffdb> 0

=head3 L<App::diffwc> 0

=head3 L<App::diffwc::ColorSchemes::Kuler> 0

=head3 L<App::dt> 0

=head3 L<App::durseq> 0

=head3 L<App::dux> 0

=head3 L<App::envset> 0

=head3 L<App::errno> 0

=head3 L<App::errnos> 0

=head3 L<App::eta2zero> 0

=head3 L<App::fiatx> 0

=head3 L<App::finddo> 0

=head3 L<App::finquote> 0

=head3 L<App::finquotehist> 0

=head3 L<App::freqtable> 0.006

=head3 L<App::fsql> 0

=head3 L<App::genlines> 0

=head3 L<App::genpw> 0.011

=head3 L<App::genpw::base56> 0

=head3 L<App::genpw::base58> 0

=head3 L<App::genpw::base64> 0

=head3 L<App::genpw::ind> 0

=head3 L<App::genpw::wordlist> 0.004

=head3 L<App::github::cmd> 0.003

=head3 L<App::gitwrap> 0

=head3 L<App::govproc::pericmd> 0

=head3 L<App::grep::email> 0

=head3 L<App::grep::url> 0

=head3 L<App::grepdate> 0

=head3 L<App::host::struct> 0

=head3 L<App::hr> 0

=head3 L<App::hr::Lite> 0

=head3 L<App::html::css::sel> 0

=head3 L<App::html2text> 0

=head3 L<App::html2wp> 0

=head3 L<App::htmlsel> 0

=head3 L<App::httpstatus::more> 0

=head3 L<App::idxdb> 0

=head3 L<App::imgsize> 0

=head3 L<App::inplace> 0

=head3 L<App::instopt> 0

=head3 L<App::isbn> 0

=head3 L<App::jpath> 0

=head3 L<App::jsonsel> 0

=head3 L<App::lcpan> 1.066

=head3 L<App::lcpan::Bootstrap> 0

=head3 L<App::lcpan::Call> 0.11

=head3 L<App::lcpan::CmdBundle::backpan> 0

=head3 L<App::lcpan::CmdBundle::bencher> 0

=head3 L<App::lcpan::CmdBundle::borderstyle> 0

=head3 L<App::lcpan::CmdBundle::bugs> 0

=head3 L<App::lcpan::CmdBundle::changes> 0

=head3 L<App::lcpan::CmdBundle::colortheme> 0

=head3 L<App::lcpan::CmdBundle::core_or_pp> 0

=head3 L<App::lcpan::CmdBundle::cpanauthors> 0

=head3 L<App::lcpan::CmdBundle::cpanlists> 0

=head3 L<App::lcpan::CmdBundle::cpanmodules> 0

=head3 L<App::lcpan::CmdBundle::cpanratings> 0

=head3 L<App::lcpan::CmdBundle::cpantesters> 0

=head3 L<App::lcpan::CmdBundle::cwalitee> 0

=head3 L<App::lcpan::CmdBundle::debian> 0

=head3 L<App::lcpan::CmdBundle::deps> 0

=head3 L<App::lcpan::CmdBundle::depsort> 0

=head3 L<App::lcpan::CmdBundle::dzil> 0

=head3 L<App::lcpan::CmdBundle::files> 0

=head3 L<App::lcpan::CmdBundle::gh> 0

=head3 L<App::lcpan::CmdBundle::metacpan> 0

=head3 L<App::lcpan::CmdBundle::metasyntactic> 0

=head3 L<App::lcpan::CmdBundle::nearest> 0

=head3 L<App::lcpan::CmdBundle::rt> 0

=head3 L<App::lcpan::CmdBundle::sah> 0

=head3 L<App::lcpan::CmdBundle::sco> 0

=head3 L<App::lcpan::CmdBundle::scripts> 0

=head3 L<App::lcpan::CmdBundle::similar_authors> 0

=head3 L<App::lcpan::CmdBundle::ver> 0

=head3 L<App::lcpan::CmdBundle::weaver> 0

=head3 L<App::lcpan::Daemon> 0

=head3 L<App::lcpan::Manual> 0

=head3 L<App::lens> 0

=head3 L<App::lensort> 0

=head3 L<App::linenum> 0

=head3 L<App::linerange> 0

=head3 L<App::linespeed> 0

=head3 L<App::manwrap::pm> 0

=head3 L<App::metastasize> 0

=head3 L<App::metasyn> 0

=head3 L<App::mimic> 0

=head3 L<App::mysqlinfo> 0

=head3 L<App::nauniq> 0

=head3 L<App::norepeat> 0

=head3 L<App::nrand> 0

=head3 L<App::numseq> 0

=head3 L<App::numspeed> 0

=head3 L<App::org2wp> 0

=head3 L<App::orgadb> 0

=head3 L<App::orgsel> 0

=head3 L<App::osnames> 0

=head3 L<App::pause> 0

=head3 L<App::pause::Unpacked> 0

=head3 L<App::perlmv> 0.604

=head3 L<App::perlmv::scriptlet::add_prefix> 0

=head3 L<App::perlmv::scriptlet::add_suffix> 0

=head3 L<App::perlmv::scriptlet::number_tracks> 0

=head3 L<App::perlmv::scriptlet::prefix_with_number> 0

=head3 L<App::perlmv::scriptlet::to_random> 0

=head3 L<App::perlmv::scriptlet::to_uuid> 0

=head3 L<App::perlmv::u> 0

=head3 L<App::plstrace> 0

=head3 L<App::pmhiderename> 0

=head3 L<App::pmpatcher> 0

=head3 L<App::pod2wp> 0

=head3 L<App::podsel> 0.004

=head3 L<App::podtohtml> 0

=head3 L<App::ppgrep> 0

=head3 L<App::ppisel> 0

=head3 L<App::pretty> 0

=head3 L<App::printenv::perl> 0

=head3 L<App::progpatcher> 0

=head3 L<App::quickabspath> 0

=head3 L<App::rank> 0

=head3 L<App::realpath> 0

=head3 L<App::relpath> 0

=head3 L<App::renlikewd> 0

=head3 L<App::renwd> 0

=head3 L<App::reposdb> 0

=head3 L<App::resolvetable> 0

=head3 L<App::riap> 0

=head3 L<App::rimetadb> 0.221

=head3 L<App::rmhere> 0

=head3 L<App::rpgrep> 0

=head3 L<App::rsync::new2old> 0.007

=head3 L<App::rsync::retry> 0

=head3 L<App::rsynccolor> 0

=head3 L<App::ruler> 0

=head3 L<App::seq::intrange> 0

=head3 L<App::seq::numseq> 0

=head3 L<App::seq::pl> 0

=head3 L<App::setop> 0

=head3 L<App::shcompgen> 0

=head3 L<App::short> 0

=head3 L<App::smtpstatus> 0

=head3 L<App::sorted> 0

=head3 L<App::sponge> 0

=head3 L<App::squidauth> 0

=head3 L<App::sshwrap::hostcolor> 0

=head3 L<App::stopw> 0

=head3 L<App::streamfinder> 0

=head3 L<App::subsort> 0

=head3 L<App::summ> 0

=head3 L<App::swcat> 0.015

=head3 L<App::tabify> 0

=head3 L<App::tabledata> 0

=head3 L<App::tailswitch> 0

=head3 L<App::tchart> 0

=head3 L<App::td> 0.097

=head3 L<App::texttable> 0

=head3 L<App::throttle> 0

=head3 L<App::timecalc> 0

=head3 L<App::toposort> 0

=head3 L<App::tracepm> 0

=head3 L<App::trash::all::empty::files::u> 0

=head3 L<App::trash::u> 0

=head3 L<App::unicomb> 0

=head3 L<App::upf> 0

=head3 L<App::wget::retry> 0

=head3 L<App::wordlist> 0.270

=head3 L<App::wordstat> 0

=head3 L<App::wp::xmlrpc> 0

=head3 L<App::xsum> 0

=head3 L<App::yamlsel> 0

=head3 L<AppBase::Grep> 0.010

=head3 L<AppBase::Grep::ColorSchemes::Kuler> 0

=head3 L<AppLib::CreateSelfSignedSSLCert> 0

=head3 L<AppLib::sshwrap> 0

=head3 L<Array::AllUtils> 0

=head3 L<Array::Find> 0

=head3 L<Array::Iter> 0

=head3 L<Array::Iterator> 0

=head3 L<Array::OverlapFinder> 0.003

=head3 L<Array::Pick::Scan> 0.005

=head3 L<Array::Sample::Partition> 0

=head3 L<Array::Sample::SimpleRandom> 0

=head3 L<Array::Sample::SysRand> 0

=head3 L<Array::Sample::WeightedRandom> 0.004

=head3 L<Array::Set> 0

=head3 L<Array::Set::Naive> 0

=head3 L<Array::Util::Shuffle> 0

=head3 L<ArrayData> 0.2.1

=head3 L<ArrayData::Lingua::Word::EN::Enable> 0

=head3 L<ArrayData::Lingua::Word::EN::Medical::Glutanimate> 0

=head3 L<ArrayData::Lingua::Word::EN::Wordle> 0

=head3 L<ArrayData::Lingua::Word::ID::KBBI> 0

=head3 L<ArrayData::Lingua::Word::ID::Wordle> 0

=head3 L<ArrayData::Number::Prime::First1000> 0

=head3 L<ArrayData::WordList> 0

=head3 L<ArrayDataBundle::Char::Latin1> 0

=head3 L<ArrayDataRole::BinarySearch::LinesInHandle> 0

=head3 L<ArrayDataRoles::Standard> 0

=head3 L<Bash::History::Read> 0

=head3 L<Begin::Eval::Env> 0

=head3 L<Begin::Eval::FirstArg> 0

=head3 L<Bencher::BPM> 0

=head3 L<Bencher::Backend> 1.062

=head3 L<Bencher::Mark> 0

=head3 L<Bencher::Scenario::AcmePERLANCARTestPerformance> 0

=head3 L<Bencher::Scenario::Allocations> 0

=head3 L<Bencher::Scenario::App::Sorted> 0

=head3 L<Bencher::Scenario::AppSorted> 0

=head3 L<Bencher::Scenario::Array::Sample::Partition> 0

=head3 L<Bencher::Scenario::ArraySamplePartition> 0

=head3 L<Bencher::Scenario::ArrayVsHashBuilding> 0

=head3 L<Bencher::Scenario::BagComparison> 0

=head3 L<Bencher::Scenario::BigFloat> 0

=head3 L<Bencher::Scenario::BigInt> 0

=head3 L<Bencher::Scenario::BinarySearch> 0

=head3 L<Bencher::Scenario::BinarySearch::File> 0

=head3 L<Bencher::Scenario::Bless> 0

=head3 L<Bencher::Scenario::CPANMetaValidation> 0

=head3 L<Bencher::Scenario::CSVParsingModules> 0

=head3 L<Bencher::Scenario::CallStack> 0

=head3 L<Bencher::Scenario::Caller> 0

=head3 L<Bencher::Scenario::CmdLineParsingModules> 0

=head3 L<Bencher::Scenario::Color::RGB::Util> 0

=head3 L<Bencher::Scenario::ColorRGBUtil> 0

=head3 L<Bencher::Scenario::ComparingArrays> 0

=head3 L<Bencher::Scenario::ComparisonOps> 0

=head3 L<Bencher::Scenario::CryptDicewareWordlistModules> 0

=head3 L<Bencher::Scenario::Data::Cmp> 0

=head3 L<Bencher::Scenario::Data::Undump> 0

=head3 L<Bencher::Scenario::DataCmp> 0

=head3 L<Bencher::Scenario::DataThrottling> 0

=head3 L<Bencher::Scenario::DataUndump> 0

=head3 L<Bencher::Scenario::Digest> 0

=head3 L<Bencher::Scenario::Digest::MD5> 0

=head3 L<Bencher::Scenario::Digest::SHA1> 0

=head3 L<Bencher::Scenario::DigestMD5> 0

=head3 L<Bencher::Scenario::DigestSHA1> 0

=head3 L<Bencher::Scenario::EnsuringAllPatternsInString> 0

=head3 L<Bencher::Scenario::File::Which::Cached> 0

=head3 L<Bencher::Scenario::FileWhichCached> 0

=head3 L<Bencher::Scenario::FormattingISO8601DateTime> 0

=head3 L<Bencher::Scenario::GamesWordlistModules> 0

=head3 L<Bencher::Scenario::GetoptLongSpecParsing> 0

=head3 L<Bencher::Scenario::GetoptModules> 0

=head3 L<Bencher::Scenario::Glob> 0

=head3 L<Bencher::Scenario::GraphTopologicalSortModules> 0

=head3 L<Bencher::Scenario::Hash::Unique> 0

=head3 L<Bencher::Scenario::HashBuilding> 0

=head3 L<Bencher::Scenario::HashUnique> 0

=head3 L<Bencher::Scenario::INIParsingModules> 0

=head3 L<Bencher::Scenario::IODParsingModules> 0

=head3 L<Bencher::Scenario::IPC::System::Options> 0

=head3 L<Bencher::Scenario::IPCSystemOptions> 0

=head3 L<Bencher::Scenario::IntValidation> 0

=head3 L<Bencher::Scenario::Interpreters> 0

=head3 L<Bencher::Scenario::List::MoreUtils> 0

=head3 L<Bencher::Scenario::List::Util> 0

=head3 L<Bencher::Scenario::ListFlatten> 0

=head3 L<Bencher::Scenario::ListingProcesses> 0

=head3 L<Bencher::Scenario::MathPrimeModules> 0

=head3 L<Bencher::Scenario::MemoryInfo> 0

=head3 L<Bencher::Scenario::Module::Path::More> 0

=head3 L<Bencher::Scenario::ModuleInstalledTiny> 0

=head3 L<Bencher::Scenario::ModulePathMore> 0

=head3 L<Bencher::Scenario::NormalRandom> 0

=head3 L<Bencher::Scenario::Nums2WordsModules> 0

=head3 L<Bencher::Scenario::PERLANCAR::Tree::Examples> 0

=head3 L<Bencher::Scenario::PERLANCARTreeExamples> 0

=head3 L<Bencher::Scenario::Perl::Startup> 0

=head3 L<Bencher::Scenario::PerlPhase> 0

=head3 L<Bencher::Scenario::PermuteNamedModules> 0

=head3 L<Bencher::Scenario::RandomLineModules> 0

=head3 L<Bencher::Scenario::RandomUserAgentModules> 0

=head3 L<Bencher::Scenario::Regexp::Assemble> 0

=head3 L<Bencher::Scenario::Regexp::IPv4> 0

=head3 L<Bencher::Scenario::Regexp::IPv6> 0

=head3 L<Bencher::Scenario::Regexp::Pattern::Git> 0

=head3 L<Bencher::Scenario::RegexpAssemble> 0

=head3 L<Bencher::Scenario::RegexpIPv4> 0

=head3 L<Bencher::Scenario::RegexpIPv6> 0

=head3 L<Bencher::Scenario::RegexpPatternGit> 0

=head3 L<Bencher::Scenario::SamplingFromList> 0

=head3 L<Bencher::Scenario::Scalar::Cmp> 0

=head3 L<Bencher::Scenario::Scalar::Util::Numeric> 0

=head3 L<Bencher::Scenario::ScalarCmp> 0

=head3 L<Bencher::Scenario::ScalarUtilNumeric> 0

=head3 L<Bencher::Scenario::Serializers> 0

=head3 L<Bencher::Scenario::SetComparison> 0

=head3 L<Bencher::Scenario::SetOperationModules> 0

=head3 L<Bencher::Scenario::ShellQuote::Any> 0

=head3 L<Bencher::Scenario::ShellQuoteAny> 0

=head3 L<Bencher::Scenario::Sort::BySpec> 0

=head3 L<Bencher::Scenario::Sort::HashKeys> 0

=head3 L<Bencher::Scenario::Sort::Key::Top> 0

=head3 L<Bencher::Scenario::SortBySpec> 0

=head3 L<Bencher::Scenario::SortHashKeys> 0

=head3 L<Bencher::Scenario::SortKeyTop> 0

=head3 L<Bencher::Scenario::SortingByKey> 0

=head3 L<Bencher::Scenario::Sprintf> 0

=head3 L<Bencher::Scenario::SprintfVsUnpack> 0

=head3 L<Bencher::Scenario::String::Interpolate> 0

=head3 L<Bencher::Scenario::String::PodQuote> 0

=head3 L<Bencher::Scenario::String::SimpleEscape> 0

=head3 L<Bencher::Scenario::StringEliding> 0

=head3 L<Bencher::Scenario::StringInterpolate> 0

=head3 L<Bencher::Scenario::StringPodQuote> 0

=head3 L<Bencher::Scenario::StringSimpleEscape> 0

=head3 L<Bencher::Scenario::TOMLParsingModules> 0

=head3 L<Bencher::Scenario::TSVParsingModules> 0

=head3 L<Bencher::Scenario::Test::Sleep> 0

=head3 L<Bencher::Scenario::Test::SleepCmd> 0

=head3 L<Bencher::Scenario::Text::sprintfn> 0

=head3 L<Bencher::Scenario::Textsprintfn> 0

=head3 L<Bencher::Scenario::TruncatingString> 0

=head3 L<Bencher::Scenario::URIEscaping> 0

=head3 L<Bencher::Scenario::WordListModules> 0

=head3 L<Bencher::Scenario::Words2NumsModules> 0

=head3 L<Bencher::Scenario::ZodiacModules> 0

=head3 L<Bencher::Scenario::crypt> 0

=head3 L<Bencher::Scenario::preloadable> 0

=head3 L<Bencher::Scenario::shuffle> 0

=head3 L<Bencher::Scenario::strftimeq> 0

=head3 L<Bencher::ScenarioUtil::Completion> 0

=head3 L<Bencher::Scenarios::Accessors> 0

=head3 L<Bencher::Scenarios::Algorithm::Diff> 0

=head3 L<Bencher::Scenarios::AlgorithmDiff> 0

=head3 L<Bencher::Scenarios::AppHr> 0

=head3 L<Bencher::Scenarios::AppLcpan> 0

=head3 L<Bencher::Scenarios::ArchiveTarModules> 0

=head3 L<Bencher::Scenarios::ArgPassing> 0

=head3 L<Bencher::Scenarios::Array::Sample::WeightedRandom> 0

=head3 L<Bencher::Scenarios::Array::Set> 0

=head3 L<Bencher::Scenarios::ArrayData> 0

=head3 L<Bencher::Scenarios::ArraySet> 0

=head3 L<Bencher::Scenarios::BIP39> 0

=head3 L<Bencher::Scenarios::Bencher> 0

=head3 L<Bencher::Scenarios::BitManipulation> 0

=head3 L<Bencher::Scenarios::CBlocks> 0

=head3 L<Bencher::Scenarios::CPANInstallers> 0

=head3 L<Bencher::Scenarios::CloneModules> 0

=head3 L<Bencher::Scenarios::Color::ANSI::Util> 0

=head3 L<Bencher::Scenarios::ColorANSIUtil> 0

=head3 L<Bencher::Scenarios::Complete::Util> 0

=head3 L<Bencher::Scenarios::CompleteUtil> 0

=head3 L<Bencher::Scenarios::Crypt::Diceware::Wordlist> 0

=head3 L<Bencher::Scenarios::Data::CSel> 0

=head3 L<Bencher::Scenarios::Data::CSel::WrapStruct> 0

=head3 L<Bencher::Scenarios::Data::Dmp> 0

=head3 L<Bencher::Scenarios::Data::ModeMerge> 0

=head3 L<Bencher::Scenarios::Data::Walk::More> 0

=head3 L<Bencher::Scenarios::DataCSel> 0

=head3 L<Bencher::Scenarios::DataCSelWrapStruct> 0

=head3 L<Bencher::Scenarios::DataCleansing> 0

=head3 L<Bencher::Scenarios::DataComparisonModules> 0

=head3 L<Bencher::Scenarios::DataDmp> 0

=head3 L<Bencher::Scenarios::DataModeMerge> 0

=head3 L<Bencher::Scenarios::DataSah> 0

=head3 L<Bencher::Scenarios::DataSahParams> 0

=head3 L<Bencher::Scenarios::DataSahResolve> 0

=head3 L<Bencher::Scenarios::DataSahVSTypeTiny> 0

=head3 L<Bencher::Scenarios::DateModules> 0

=head3 L<Bencher::Scenarios::DateTimeFormatAlami> 0

=head3 L<Bencher::Scenarios::DateTimeFormatDurationISO8601> 0

=head3 L<Bencher::Scenarios::DateTimeFormatISO8601> 0

=head3 L<Bencher::Scenarios::DateTimeFormatISO8601Format> 0

=head3 L<Bencher::Scenarios::DateTimeOfDay> 0

=head3 L<Bencher::Scenarios::DigestSHA> 0

=head3 L<Bencher::Scenarios::Examples> 0

=head3 L<Bencher::Scenarios::Exporters> 0

=head3 L<Bencher::Scenarios::FileFlockRetry> 0

=head3 L<Bencher::Scenarios::FileWriteRotate> 0

=head3 L<Bencher::Scenarios::Games::Wordlist> 0

=head3 L<Bencher::Scenarios::GetoptLong> 0

=head3 L<Bencher::Scenarios::GetoptLongComplete> 0

=head3 L<Bencher::Scenarios::GetoptLongEvenLess> 0

=head3 L<Bencher::Scenarios::HTTPTinyPatchRetry> 0

=head3 L<Bencher::Scenarios::HTTPTinyPlugin> 0

=head3 L<Bencher::Scenarios::HashSlicing> 0

=head3 L<Bencher::Scenarios::HumanDateParsingModules> 0

=head3 L<Bencher::Scenarios::IOFilterModules> 0

=head3 L<Bencher::Scenarios::IPCRun> 0

=head3 L<Bencher::Scenarios::IPManipulation> 0

=head3 L<Bencher::Scenarios::ISBN> 0

=head3 L<Bencher::Scenarios::JSONDecodeRegexp> 0

=head3 L<Bencher::Scenarios::LanguageExpr> 0

=head3 L<Bencher::Scenarios::LevenshteinModules> 0

=head3 L<Bencher::Scenarios::List::Utils::MoveElement> 0

=head3 L<Bencher::Scenarios::ListingModules> 0

=head3 L<Bencher::Scenarios::LocaleTextDomainIfEnv> 0

=head3 L<Bencher::Scenarios::LogAny> 0

=head3 L<Bencher::Scenarios::LogDispatch> 0

=head3 L<Bencher::Scenarios::LogDispatchFileRotate> 0

=head3 L<Bencher::Scenarios::LogGer> 0

=head3 L<Bencher::Scenarios::LoggingModules> 0

=head3 L<Bencher::Scenarios::ManipulatingSymbolTable> 0

=head3 L<Bencher::Scenarios::MathBigFloat> 0

=head3 L<Bencher::Scenarios::MathScientificNotationUtil> 0

=head3 L<Bencher::Scenarios::MemoryCacheModules> 0

=head3 L<Bencher::Scenarios::ModuleInstalledTiny> 0

=head3 L<Bencher::Scenarios::MojoDOM> 0

=head3 L<Bencher::Scenarios::MonkeyPatchAction> 0

=head3 L<Bencher::Scenarios::OrgParsers> 0

=head3 L<Bencher::Scenarios::PERLANCAR> 0

=head3 L<Bencher::Scenarios::PERLANCARModuleList> 0

=head3 L<Bencher::Scenarios::PERLANCARParseArithmetic> 0

=head3 L<Bencher::Scenarios::PackageMoreUtil> 0

=head3 L<Bencher::Scenarios::ParamsSah> 0

=head3 L<Bencher::Scenarios::PathNaive> 0

=head3 L<Bencher::Scenarios::Perinci> 0

=head3 L<Bencher::Scenarios::PerinciAccessLite> 0

=head3 L<Bencher::Scenarios::PerinciCmdLine> 0

=head3 L<Bencher::Scenarios::PerinciSubGetArgsArgv> 0

=head3 L<Bencher::Scenarios::PerinciSubGetArgsWebForm> 0

=head3 L<Bencher::Scenarios::PerinciSubUtil> 0

=head3 L<Bencher::Scenarios::PerinciSubValidateArgs> 0

=head3 L<Bencher::Scenarios::PerinciTxManager> 0

=head3 L<Bencher::Scenarios::Perl> 0

=head3 L<Bencher::Scenarios::ProgressAny> 0

=head3 L<Bencher::Scenarios::RangeIterators> 0

=head3 L<Bencher::Scenarios::RefUtil> 0

=head3 L<Bencher::Scenarios::RegexpCommon> 0

=head3 L<Bencher::Scenarios::RegexpCommonVsRegexpPattern> 0

=head3 L<Bencher::Scenarios::RegexpGrammars> 0

=head3 L<Bencher::Scenarios::RegexpPattern> 0

=head3 L<Bencher::Scenarios::RoleTinyCommonsTree> 0

=head3 L<Bencher::Scenarios::SPVM> 0

=head3 L<Bencher::Scenarios::ShellGuess> 0

=head3 L<Bencher::Scenarios::SortSub> 0

=head3 L<Bencher::Scenarios::StringFunctions> 0

=head3 L<Bencher::Scenarios::TextANSIUtil> 0

=head3 L<Bencher::Scenarios::TextLevenshteinFlexible> 0

=head3 L<Bencher::Scenarios::TextTableTiny> 0

=head3 L<Bencher::Scenarios::TimeDurationParse> 0

=head3 L<Bencher::Scenarios::TimeHiRes> 0

=head3 L<Bencher::Scenarios::TreeObject> 0

=head3 L<Bencher::Scenarios::URI::Info> 0

=head3 L<Bencher::Scenarios::Z> 0

=head3 L<Bencher::Tiny> 0

=head3 L<Benchmark::Command> 0

=head3 L<Bitcoin::BIP39> 0

=head3 L<Bluetooth::Any> 0

=head3 L<Borang> 0

=head3 L<Border::Style> 0

=head3 L<BorderStyle> 3.0.0

=head3 L<BorderStyles::Standard> 0

=head3 L<BorderStyles::Test> 0

=head3 L<Browser::Find::Windows> 0

=head3 L<Builtin::Logged> 0

=head3 L<Business::BankCard> 0

=head3 L<Business::BankCard::Indonesia> 0.070

=head3 L<Business::BankList> 0

=head3 L<Business::BankList::Indonesia> 0.080

=head3 L<Business::ID::BCA> 0

=head3 L<Business::ID::Mandiri> 0

=head3 L<Business::ID::NIK> 0

=head3 L<Business::ID::NKK> 0

=head3 L<Business::ID::NOPPBB> 0

=head3 L<Business::ID::NPWP> 0

=head3 L<Business::ID::POM> 0

=head3 L<Business::ID::SIM> 0

=head3 L<Business::Inventory::Valuation> 0.006

=head3 L<Business::Tax::ID::PPH21> 0.066

=head3 L<CLI::Meta::YoutubeDl> 0

=head3 L<CLI::Meta::YtDlp> 0

=head3 L<CLI::Meta::cp> 0

=head3 L<CLI::Meta::diff> 0

=head3 L<CLI::Meta::mv> 0

=head3 L<CLI::MetaUtil::Getopt::Long> 0.002

=head3 L<CLI::MetaUtil::Getopt::Long::Complete> 0

=head3 L<CPAN::Changes::Cwalitee> 0

=head3 L<CPAN::Critic::Module::Abstract> 0

=head3 L<CPAN::Info::FromRepoName> 0

=head3 L<CPAN::Info::FromURL> 0

=head3 L<CPAN::Meta::X> 0

=head3 L<CPAN::Mini::NoLargeFiles> 0

=head3 L<CSV::Examples> 0

=head3 L<CSVJF> 0

=head3 L<CSel::Examples> 0

=head3 L<Calendar::Dates> 0.2.3

=head3 L<Calendar::Dates::Academic::ID::UT::PPs> 0

=head3 L<Calendar::Dates::CFA> 0

=head3 L<Calendar::Dates::FRM> 0

=head3 L<Calendar::Dates::ID::Holiday> 0

=head3 L<Calendar::Dates::Perl> 0

=head3 L<Calendar::Dates::UnitedNations::InternationalDays> 0

=head3 L<Calendar::DatesRoles::DataPreparer::CalendarVar::FromDATA::Simple> 0

=head3 L<Calendar::DatesRoles::DataPreparer::CalendarVar::FromData> 0

=head3 L<Calendar::DatesRoles::DataUser::CalendarVar> 0.003

=head3 L<Calendar::DatesRoles::ReturnDateTimeObjects> 0

=head3 L<Calendar::DatesRoles::ReturnTimeMomentObjects> 0

=head3 L<Calendar::Indonesia::Holiday> 0.338

=head3 L<Carp::Always::DieOnly> 0

=head3 L<Carp::Always::SyntaxHighlightSource> 0

=head3 L<Carp::Patch::Config> 0

=head3 L<Carp::Patch::Verbose> 0

=head3 L<CentOS::Releases> 0

=head3 L<Chrome::Util::Profile> 0.004

=head3 L<Class::Accessor::Array> 0.031

=head3 L<Class::Accessor::Array::Glob> 0

=head3 L<Class::Accessor::Array::Slurpy> 0

=head3 L<Class::Accessor::PackedString> 0

=head3 L<Class::Accessor::PackedString::Set> 0

=head3 L<Class::Build::Array::Glob> 0

=head3 L<Class::GenSource> 0

=head3 L<Class::MaybeXSAccessor> 0

=head3 L<Clipboard::Any> 0.011

=head3 L<Clone::Util> 0.03

=head3 L<Code::Embeddable> 0

=head3 L<Color::ANSI::Util> 0.164

=head3 L<Color::HSL::Util> 0

=head3 L<Color::HSV::Util> 0

=head3 L<Color::RGB::Util> 0.600

=head3 L<Color::Theme> 0

=head3 L<Color::Theme::Role> 0

=head3 L<Color::Theme::Util> 0.020

=head3 L<Color::Theme::Util::ANSI> 0

=head3 L<ColorTheme> 2.1.0

=head3 L<ColorTheme::Distinct::WhiteBG> 0

=head3 L<ColorTheme::GraphicsColorNames> 0

=head3 L<ColorTheme::Harmony::Analogous> 0

=head3 L<ColorTheme::Harmony::Monochromatic> 0

=head3 L<ColorTheme::Lens::Darken> 0

=head3 L<ColorTheme::Lens::Lighten> 0

=head3 L<ColorTheme::Lens::Tint> 0

=head3 L<ColorTheme::Search::Light> 0

=head3 L<ColorThemeBase::Static> 0.006

=head3 L<ColorThemeRole::ANSI> 0

=head3 L<ColorThemeUtil::ANSI> 0

=head3 L<ColorThemes::Standard> 0

=head3 L<ColorThemes::Test> 0

=head3 L<ColorTransforms::Standard> 0

=head3 L<Complete> 0.202

=head3 L<Complete::Acme::MetaSyntactic> 0.002

=head3 L<Complete::Bash> 0.333

=head3 L<Complete::Bash::History> 0

=head3 L<Complete::Chrome> 0

=head3 L<Complete::Common> 0.22

=head3 L<Complete::Country> 0

=head3 L<Complete::Currency> 0

=head3 L<Complete::Cwalitee> 0

=head3 L<Complete::Dist> 0

=head3 L<Complete::Dist::Zilla> 0

=head3 L<Complete::Dpkg> 0

=head3 L<Complete::Env> 0

=head3 L<Complete::FS> 0

=head3 L<Complete::File> 0.440

=head3 L<Complete::Finance::SE::IDX> 0

=head3 L<Complete::Firefox> 0

=head3 L<Complete::Fish> 0

=head3 L<Complete::Fish::Gen::FromGetoptLong> 0.08

=head3 L<Complete::Fish::Gen::FromGetoptLongDescriptive> 0

=head3 L<Complete::Fish::Gen::FromPerinciCmdLine> 0

=head3 L<Complete::Getopt::Long> 0.481

=head3 L<Complete::Host> 0.03

=head3 L<Complete::Kernel> 0

=head3 L<Complete::Language> 0

=head3 L<Complete::Locale> 0

=head3 L<Complete::MAC> 0

=head3 L<Complete::Man> 0.100

=head3 L<Complete::Module> 0.263

=head3 L<Complete::Number> 0

=head3 L<Complete::PPR> 0

=head3 L<Complete::Path> 0.251

=head3 L<Complete::Perl> 0

=head3 L<Complete::Pod> 0

=head3 L<Complete::Pod::Weaver> 0

=head3 L<Complete::Program> 0

=head3 L<Complete::RPM> 0

=head3 L<Complete::Random> 0

=head3 L<Complete::Rclone> 0

=head3 L<Complete::Regexp::Pattern> 0

=head3 L<Complete::Riap> 0

=head3 L<Complete::Riap::Clientless> 0

=head3 L<Complete::Sah> 0.012

=head3 L<Complete::Sequence> 0.002

=head3 L<Complete::Spanel> 0

=head3 L<Complete::TZ> 0.080

=head3 L<Complete::Tcsh> 0

=head3 L<Complete::Unix> 0.07

=head3 L<Complete::Util> 0.616

=head3 L<Complete::Vivaldi> 0

=head3 L<Complete::Zsh> 0

=head3 L<Complete::Zsh::Gen::FromGetoptLong> 0

=head3 L<Complete::Zsh::Gen::FromGetoptLongDescriptive> 0

=head3 L<Complete::Zsh::Gen::FromPerinciCmdLine> 0

=head3 L<Config::Apachish::Reader> 0

=head3 L<Config::IOD> 0.353

=head3 L<Config::IOD::Reader> 0.344

=head3 L<Crypt::Password::Util> 0

=head3 L<CryptoCurrency::Catalog> 20180308

=head3 L<CryptoExchange::Catalog> 20180510

=head3 L<Cwalitee::Common> 0.004

=head3 L<DBIx::CSV> 0

=head3 L<DBIx::Conn::MySQL> 0

=head3 L<DBIx::Conn::Pg> 0

=head3 L<DBIx::Conn::SQLite> 0

=head3 L<DBIx::Connect::Any> 0

=head3 L<DBIx::Connect::MySQL> 0

=head3 L<DBIx::Diff::Schema> 0.094

=head3 L<DBIx::FunctionalAPI> 0

=head3 L<DBIx::TSV> 0

=head3 L<DBIx::TextTableAny> 0

=head3 L<DBIx::UpdateTable::FromHoH> 0.002

=head3 L<DBIx::Util::Schema> 0

=head3 L<DD::Dummy> 0

=head3 L<DNS::Zone::PowerDNS::To::BIND> 0

=head3 L<DNS::Zone::Struct::Common> 0.004

=head3 L<DNS::Zone::Struct::To::BIND> 0

=head3 L<DNS::ZoneStruct::To::BIND> 0

=head3 L<Data::CSel> 0.128

=head3 L<Data::CSel::WrapStruct> 0.004

=head3 L<Data::Check::Structure> 0.050

=head3 L<Data::Circular::Util> 0

=head3 L<Data::Clean> 0.505

=head3 L<Data::Clean::ForJSON> 0

=head3 L<Data::Clean::ForJSON::Pregen> 0

=head3 L<Data::Clean::FromJSON::Pregen> 0

=head3 L<Data::Clean::JSON> 0

=head3 L<Data::Clean::ToStringyNumber> 0

=head3 L<Data::CleanJSON> 0

=head3 L<Data::Cmp> 0.002

=head3 L<Data::Decrement> 0

=head3 L<Data::Dmp> 0.242

=head3 L<Data::Dmp::Org> 0

=head3 L<Data::Dmp::Prune> 0

=head3 L<Data::Dump::Color> 0.246

=head3 L<Data::Dump::ObjectAsString> 0

=head3 L<Data::Dump::OneLine> 0

=head3 L<Data::Dump::Options> 0

=head3 L<Data::Dump::Patch::Deparse> 0

=head3 L<Data::Dump::Patch::ReplaceWithDataDmp> 0

=head3 L<Data::Dump::SExpression> 0

=head3 L<Data::Dump::SortKeys> 0

=head3 L<Data::Format::Pretty::Console> 0

=head3 L<Data::Format::Pretty::HTML> 0

=head3 L<Data::Format::Pretty::JSON> 0

=head3 L<Data::Format::Pretty::Perl> 0

=head3 L<Data::Format::Pretty::Ruby> 0

=head3 L<Data::Format::Pretty::YAML> 0

=head3 L<Data::Graph::Util> 0

=head3 L<Data::ModeMerge> 0

=head3 L<Data::Random::Tree> 0

=head3 L<Data::Sah> 0.914

=head3 L<Data::Sah::Coerce> 0.050

=head3 L<Data::Sah::Coerce::perl::To_array::From_str::csv_row> 0

=head3 L<Data::Sah::Coerce::perl::To_array::From_str::tsv_row> 0

=head3 L<Data::Sah::Coerce::perl::To_date::From_str::alami> 0

=head3 L<Data::Sah::Coerce::perl::To_date::From_str::alami_en> 0

=head3 L<Data::Sah::Coerce::perl::To_date::From_str::alami_id> 0

=head3 L<Data::Sah::Coerce::perl::To_date::From_str::flexible> 0

=head3 L<Data::Sah::Coerce::perl::To_date::From_str::natural> 0

=head3 L<Data::Sah::Coerce::perl::To_duration::From_str::alami_en> 0

=head3 L<Data::Sah::Coerce::perl::To_duration::From_str::alami_id> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::ToCryptoCurrencyCode> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::ToCryptoCurrencySafename> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::ToCryptoExchangeCurrencyPair> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::ToCryptoExchangeSafename> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::ToCurrencyPair> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::ToFiatOrCryptoCurrencyCode> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::ToUpper> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::to_cryptocurrency_code> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::to_cryptocurrency_safename> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::to_cryptoexchange_currency_pair> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::to_cryptoexchange_safename> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::to_currency_pair> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::to_fiat_or_cryptocurrency_code> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::to_upper> 0

=head3 L<Data::Sah::Coerce::perl::To_str::From_str::trim> 0

=head3 L<Data::Sah::CoerceBundle::App::cryp> 0

=head3 L<Data::Sah::CoerceBundle::To_array::From_str::comma_sep> 0

=head3 L<Data::Sah::CoerceBundle::To_array::From_str::int_range> 0

=head3 L<Data::Sah::CoerceBundle::To_array::From_str::int_range_and_comma_sep> 0

=head3 L<Data::Sah::CoerceBundle::To_num::From_str::num_en> 0

=head3 L<Data::Sah::CoerceBundle::To_num::From_str::num_id> 0

=head3 L<Data::Sah::DefaultValue> 0

=head3 L<Data::Sah::Filter> 0.015

=head3 L<Data::Sah::Filter::perl::Str::replace_dashes_with_underscores> 0

=head3 L<Data::Sah::Filter::perl::Str::replace_underscores_with_dashes> 0

=head3 L<Data::Sah::Filter::perl::Str::try_decode_json> 0

=head3 L<Data::Sah::FilterBundle::Phone> 0

=head3 L<Data::Sah::FilterBundle::Regexp> 0

=head3 L<Data::Sah::Format> 0

=head3 L<Data::Sah::Format::perl::boolstr> 0

=head3 L<Data::Sah::Format::perl::sci2dec> 0

=head3 L<Data::Sah::From::JSONSchema> 0

=head3 L<Data::Sah::JS> 0

=head3 L<Data::Sah::Normalize> 0.051

=head3 L<Data::Sah::Object> 0

=head3 L<Data::Sah::Params> 0

=head3 L<Data::Sah::Resolve> 0.010

=head3 L<Data::Sah::Terse> 0

=head3 L<Data::Sah::Tiny> 0

=head3 L<Data::Sah::Util::Subschema> 0.005

=head3 L<Data::Sah::Util::Type> 0.45

=head3 L<Data::Sah::ValueBundle::Date> 0

=head3 L<Data::Sah::ValueBundle::Path> 0

=head3 L<Data::Section::Seekable> 0

=head3 L<Data::Serializer::Data::Dmp> 0

=head3 L<Data::Serializer::Data::Dump> 0

=head3 L<Data::TableData::Lookup> 0

=head3 L<Data::TableData::Object> 0.116

=head3 L<Data::TableData::Pick> 0

=head3 L<Data::TableData::Rank> 0

=head3 L<Data::Throttler_CHI> 0

=head3 L<Data::Transmute> 0.039

=head3 L<Data::Transmute::Rules::DNS::Zone::Struct::FromSpanel> 0

=head3 L<Data::Transmute::Rules::TreeNodeHash::StringifyChildren> 0

=head3 L<Data::Transmute::Rules::TreeNodeHash::StringifyParent> 0

=head3 L<Data::Unixish> 1.572

=head3 L<Data::Unixish::ANSI> 0

=head3 L<Data::Unixish::DNS> 0

=head3 L<Data::Unixish::Perl> 0

=head3 L<Data::Walk::More> 0

=head3 L<Data::xmute> 0

=head3 L<DataDist> 0

=head3 L<Date::Extract::ID> 0

=head3 L<Date::Extract::PERLANCAR> 0

=head3 L<Date::Format::ISO8601> 0

=head3 L<Date::TimeOfDay> 0.003

=head3 L<Date::strftimeq> 0

=head3 L<DateTime::Duration::Patch::StringifyAsISO8601> 0

=head3 L<DateTime::Format::Alami> 0.13

=head3 L<DateTime::Format::Duration::ConciseHMS> 0

=head3 L<DateTime::Format::Duration::ISO8601> 0

=head3 L<DateTime::Format::ISO8601::Format> 0

=head3 L<DateTime::Format::Indonesian> 0

=head3 L<DateTime::Format::Strftimeq> 0

=head3 L<DateTime::Patch::AddDowNameToYmd> 0

=head3 L<DateTimeX::Duration::Lite> 0

=head3 L<DateTimeX::Tiny::Compact> 0

=head3 L<DateTimeX::strftimeq> 0.002

=head3 L<Debian::Releases::PERLANCAR> 0

=head3 L<Debug::Print> 0

=head3 L<DefHash> 2.0.0

=head3 L<DefHash::Examples> 0

=head3 L<Desktop::Detect> 0

=head3 L<Desktop::Open> 0

=head3 L<Devel::Caller::Util> 0.042

=head3 L<Devel::Confess::Patch::UseDataDmp> 0

=head3 L<Devel::Confess::Patch::UseDataDumpObjectAsString> 0

=head3 L<Devel::DieHandler::DumpDieArgs> 0

=head3 L<Devel::DieHandler::DumpINC> 0

=head3 L<Devel::DieHandler::PrintINCVersion> 0

=head3 L<Devel::DieHandler::Pwd> 0

=head3 L<Devel::End::PrintINC> 0

=head3 L<Devel::End::PrintINCVersion> 0

=head3 L<Devel::EndStats> 0.210

=head3 L<Devel::EndStats::LoadedMods> 0

=head3 L<Devel::Platform::Match> 0.004

=head3 L<Dir::Write::Rotate> 0

=head3 L<Display::Resolution> 0

=head3 L<Dist::Util> 0.070

=head3 L<Dist::Util::Current> 0.003

=head3 L<Dist::Util::Debian> 0.006

=head3 L<Dist::Zilla::Plugin::Acme::CPANModules> 0

=head3 L<Dist::Zilla::Plugin::Acme::CPANModules::Blacklist> 0

=head3 L<Dist::Zilla::Plugin::Acme::MetaSyntactic> 0

=head3 L<Dist::Zilla::Plugin::AddFile::FromCode> 0

=head3 L<Dist::Zilla::Plugin::AddFile::FromCommand> 0

=head3 L<Dist::Zilla::Plugin::AddFile::FromFS> 0

=head3 L<Dist::Zilla::Plugin::AddModule::FromFS> 0

=head3 L<Dist::Zilla::Plugin::Bencher::Scenario> 0

=head3 L<Dist::Zilla::Plugin::BorderStyle> 0

=head3 L<Dist::Zilla::Plugin::Calendar::Dates> 0

=head3 L<Dist::Zilla::Plugin::ColorTheme> 0

=head3 L<Dist::Zilla::Plugin::Comment> 0

=head3 L<Dist::Zilla::Plugin::CopyrightYearFromGit> 0

=head3 L<Dist::Zilla::Plugin::Data::Sah> 0

=head3 L<Dist::Zilla::Plugin::Data::Sah::Coerce> 0

=head3 L<Dist::Zilla::Plugin::Data::Sah::Filter> 0

=head3 L<Dist::Zilla::Plugin::Depak> 0

=head3 L<Dist::Zilla::Plugin::EnsureDepakable> 0

=head3 L<Dist::Zilla::Plugin::EnsureSQLSchemaVersionedTest> 0

=head3 L<Dist::Zilla::Plugin::Extras> 0

=head3 L<Dist::Zilla::Plugin::For::App::shcompgen> 0

=head3 L<Dist::Zilla::Plugin::For::Data::Sah> 0

=head3 L<Dist::Zilla::Plugin::For::DefHash::Examples> 0

=head3 L<Dist::Zilla::Plugin::GenPericmdScript> 0.423

=head3 L<Dist::Zilla::Plugin::GenShellCompletion> 0

=head3 L<Dist::Zilla::Plugin::IfBuilt> 0

=head3 L<Dist::Zilla::Plugin::InsertBlock> 0

=head3 L<Dist::Zilla::Plugin::InsertCodeOutput> 0

=head3 L<Dist::Zilla::Plugin::InsertCodeResult> 0

=head3 L<Dist::Zilla::Plugin::InsertCommandOutput> 0

=head3 L<Dist::Zilla::Plugin::InsertDistImage> 0

=head3 L<Dist::Zilla::Plugin::InsertExecsList> 0

=head3 L<Dist::Zilla::Plugin::InsertModulesList> 0

=head3 L<Dist::Zilla::Plugin::LintPrereqs> 0

=head3 L<Dist::Zilla::Plugin::Lump> 0

=head3 L<Dist::Zilla::Plugin::Module::Features> 0

=head3 L<Dist::Zilla::Plugin::OSPrereqs::POSIX> 0

=head3 L<Dist::Zilla::Plugin::OSPrereqs::Unix> 0

=head3 L<Dist::Zilla::Plugin::OurDate> 0

=head3 L<Dist::Zilla::Plugin::OurDist> 0

=head3 L<Dist::Zilla::Plugin::PERLANCAR::Authority> 0

=head3 L<Dist::Zilla::Plugin::PERLANCAR::CheckDepDists> 0

=head3 L<Dist::Zilla::Plugin::PERLANCAR::CheckPendingRelease> 0

=head3 L<Dist::Zilla::Plugin::PERLANCAR::EnsurePrereqToSpec> 0

=head3 L<Dist::Zilla::Plugin::PERLANCAR::GenTodoMd> 0

=head3 L<Dist::Zilla::Plugin::PERLANCAR::MetaResources> 0

=head3 L<Dist::Zilla::Plugin::PERLANCAR::OurPkgVersion> 0

=head3 L<Dist::Zilla::Plugin::PatchModule> 0

=head3 L<Dist::Zilla::Plugin::Perinci::CmdLine> 0

=head3 L<Dist::Zilla::Plugin::PerlStripper> 0

=head3 L<Dist::Zilla::Plugin::PodnameFromFilename> 0

=head3 L<Dist::Zilla::Plugin::PrecomputeVariable> 0

=head3 L<Dist::Zilla::Plugin::Preload> 0

=head3 L<Dist::Zilla::Plugin::Prereqs::CheckCircular> 0

=head3 L<Dist::Zilla::Plugin::Prereqs::EnsureCoreOrPP> 0

=head3 L<Dist::Zilla::Plugin::Prereqs::EnsureVersion> 0

=head3 L<Dist::Zilla::Plugin::Prereqs::SetMinimumVersion::FromPmVersions> 0

=head3 L<Dist::Zilla::Plugin::Regexp::Pattern> 0

=head3 L<Dist::Zilla::Plugin::RenderTemplate> 0

=head3 L<Dist::Zilla::Plugin::Rinci::AbstractFromMeta> 0

=head3 L<Dist::Zilla::Plugin::Rinci::AddPrereqs> 0

=head3 L<Dist::Zilla::Plugin::Rinci::AddToDb> 0.020

=head3 L<Dist::Zilla::Plugin::Rinci::EmbedValidator> 0

=head3 L<Dist::Zilla::Plugin::Rinci::GenSchemaV> 0

=head3 L<Dist::Zilla::Plugin::Rinci::Validate> 0

=head3 L<Dist::Zilla::Plugin::Rinci::Wrap> 0

=head3 L<Dist::Zilla::Plugin::Sah::Schemas> 0

=head3 L<Dist::Zilla::Plugin::ScriptX> 0

=head3 L<Dist::Zilla::Plugin::SetEnv> 0

=head3 L<Dist::Zilla::Plugin::ShareDir::Clean> 0

=head3 L<Dist::Zilla::Plugin::Sort::Sub> 0

=head3 L<Dist::Zilla::Plugin::TableData> 0

=head3 L<Dist::Zilla::Plugin::Test::Perl::Critic::Subset> 3.001.005

=head3 L<Dist::Zilla::Plugin::Test::ProveRdeps> 0

=head3 L<Dist::Zilla::Plugin::Test::Rinci> 0

=head3 L<Dist::Zilla::Plugin::UploadToCPAN::WWWPAUSESimple> 0

=head3 L<Dist::Zilla::Plugin::WordList> 0

=head3 L<Dist::Zilla::Plugin::WordListC> 0

=head3 L<Dist::Zilla::Plugin::perlmv> 0

=head3 L<Dist::Zilla::Plugin::shcompgen::InitOnInstall> 0

=head3 L<Dist::Zilla::PluginBundle::Author::PERLANCAR> 0.600

=head3 L<Dist::Zilla::Role::CheckPackageDeclared> 0

=head3 L<Dist::Zilla::Role::DumpPerinciCmdLineScript> 0

=head3 L<Dist::Zilla::Role::GetSharedFileURL> 0

=head3 L<Dist::Zilla::Role::PERLANCAR::WriteModules> 0

=head3 L<Dist::Zilla::Role::RequireFromBuild> 0

=head3 L<Dist::Zilla::Role::Rinci::CheckDefinesMeta> 0

=head3 L<Dist::Zilla::Util::MergePrereqsFromDistInis> 0

=head3 L<Dist::Zilla::Util::ParsePrereqsFromDistIni> 0

=head3 L<End::Eval::Env> 0

=head3 L<End::Eval::FirstArg> 0

=head3 L<Eval::Util> 0

=head3 L<Examples::Generator> 0

=head3 L<Exporter::Rinci> 0

=head3 L<File::Append::Undoable> 0

=head3 L<File::Common> 0.003

=head3 L<File::Copy::Undoable> 0.11

=head3 L<File::Create::Layout> 0.060

=head3 L<File::Digest> 0.009

=head3 L<File::Flock::Retry> 0.631

=head3 L<File::MoreUtil> 0.625

=head3 L<File::Move::Undoable> 0.08

=head3 L<File::Patch::Undoable> 0.08

=head3 L<File::Prepend::Undoable> 0

=head3 L<File::Random::Pick> 0

=head3 L<File::RsyBak> 0

=head3 L<File::RsyBak::Unpacked> 0

=head3 L<File::Slurper::Dash> 0

=head3 L<File::Slurper::Shortcuts> 0

=head3 L<File::Slurper::Temp> 0.008

=head3 L<File::SortedSeek::PERLANCAR> 0

=head3 L<File::Symlink::Util> 0.003

=head3 L<File::Temp::MoreUtils> 0

=head3 L<File::Temp::Patch::NoCleanup> 0

=head3 L<File::Temp::Patch::VarOptions> 0

=head3 L<File::Temp::VarOptions> 0

=head3 L<File::Trash::EmptyFiles::Undoable> 0

=head3 L<File::Trash::FreeDesktop> 0

=head3 L<File::Trash::Undoable> 0.230

=head3 L<File::Truncate::Undoable> 0

=head3 L<File::Unsaved> 0

=head3 L<File::Util::Tempdir> 0.032

=head3 L<File::Which::Patch::Hide> 0

=head3 L<File::Write::Rotate> 0.28

=head3 L<File::chown> 0

=head3 L<Filename::Archive> 0

=head3 L<Filename::Audio> 0.004

=head3 L<Filename::Backup> 0

=head3 L<Filename::Compressed> 0

=head3 L<Filename::Ebook> 0

=head3 L<Filename::Executable> 0

=head3 L<Filename::Image> 0.004

=head3 L<Filename::Media> 0.003

=head3 L<Filename::Video> 0.004

=head3 L<Filesys::Cap> 0

=head3 L<Filesys::Ext2::Dump> 0

=head3 L<Finance::Bank::ID::BCA> 0.45

=head3 L<Finance::Bank::ID::BPRKS> 0

=head3 L<Finance::Bank::ID::Mandiri> 0

=head3 L<Finance::BitFlip> 0

=head3 L<Finance::CoinbasePro::Lite> 0

=head3 L<Finance::Currency::Convert::BCA> 0

=head3 L<Finance::Currency::Convert::BI> 0.05

=head3 L<Finance::Currency::Convert::GMC> 0.004

=head3 L<Finance::Currency::Convert::Mandiri> 0

=head3 L<Finance::Currency::FiatX> 0.010

=head3 L<Finance::GDAX::Lite> 0

=head3 L<Finance::ID::KSEI> 0

=head3 L<Finance::Indodax> 0.011

=head3 L<Finance::SE::IDX> 0.006

=head3 L<Finance::SE::IDX::Any> 0

=head3 L<Finance::SE::IDX::Static> 20210118.0.0

=head3 L<Firefox::Util::Profile> 0.005

=head3 L<Float::Util> 0

=head3 L<Function::Fallback::CoreOrPP> 0

=head3 L<Games::ArrangeNumber> 0

=head3 L<Games::Hangman> 0

=head3 L<Games::TabNoun> 0

=head3 L<Games::TabRace> 0

=head3 L<Games::Word::Guess> 0

=head3 L<Games::Word::Phraselist> 0

=head3 L<Games::Word::Phraselist::CCIC> 0

=head3 L<Games::Word::Phraselist::Proverb::ChineseTools> 0

=head3 L<Games::Word::Phraselist::Proverb::KBBI> 0

=head3 L<Games::Word::Phraselist::Proverb::TWW> 0

=head3 L<Gen::Test::Rinci::FuncResult> 0

=head3 L<Generic::ColorTheme::Kuler> 0

=head3 L<Getopt::Long::Any> 0

=head3 L<Getopt::Long::Complete> 0

=head3 L<Getopt::Long::Descriptive::Dump> 0

=head3 L<Getopt::Long::Descriptive::Util> 0

=head3 L<Getopt::Long::Dump> 0.112

=head3 L<Getopt::Long::EvenLess> 0.111

=head3 L<Getopt::Long::EvenLess::Dump> 0

=head3 L<Getopt::Long::Less> 0

=head3 L<Getopt::Long::Less::Dump> 0

=head3 L<Getopt::Long::More> 0.007

=head3 L<Getopt::Long::More::Dump> 0

=head3 L<Getopt::Long::More::Util> 0

=head3 L<Getopt::Long::Negate::EN> 0.060

=head3 L<Getopt::Long::Negate::ID> 0

=head3 L<Getopt::Long::Subcommand> 0.102

=head3 L<Getopt::Long::Subcommand::Dump> 0

=head3 L<Getopt::Long::Subcommand::Util> 0

=head3 L<Getopt::Long::Util> 0.899

=head3 L<Getopt::Panjang> 0

=head3 L<Getopt::Std::Dump> 0

=head3 L<Getopt::Std::Util> 0

=head3 L<Git::Bunch> 0.627

=head3 L<Graphics::ColorNames::HTML_ID> 0

=head3 L<Graphics::ColorNamesLite::All> 0

=head3 L<Graphics::ColorNamesLite::HTML_ID> 0

=head3 L<Graphics::ColorNamesLite::WWW> 0

=head3 L<HTML::Extract::CPANModules> 0

=head3 L<HTML::FormatText::Any> 0

=head3 L<HTML::Tree::Create::Callback> 0

=head3 L<HTTP::Daemon::UNIX> 0

=head3 L<HTTP::Headers::Patch::DontUseStorable> 0

=head3 L<HTTP::Tiny::Cache> 0

=head3 L<HTTP::Tiny::Cache_CustomRetry> 0

=head3 L<HTTP::Tiny::CustomRetry> 0

=head3 L<HTTP::Tiny::NewestFirefox> 0

=head3 L<HTTP::Tiny::Patch::Cache> 0

=head3 L<HTTP::Tiny::Patch::Delay> 0

=head3 L<HTTP::Tiny::Patch::LogGer> 0

=head3 L<HTTP::Tiny::Patch::Plugin> 0

=head3 L<HTTP::Tiny::Patch::Retry> 0

=head3 L<HTTP::Tiny::Patch::SetUserAgent> 0

=head3 L<HTTP::Tiny::Plugin> 0.004

=head3 L<HTTP::Tiny::Plugin::Cache> 0

=head3 L<HTTP::Tiny::Plugin::CustomRetry> 0

=head3 L<HTTP::Tiny::Plugin::Delay> 0

=head3 L<HTTP::Tiny::Plugin::NewestFirefox> 0

=head3 L<HTTP::Tiny::Plugin::Retry> 0

=head3 L<HTTP::Tiny::ProgressAny> 0

=head3 L<HTTP::Tiny::Retry> 0

=head3 L<HTTP::Tiny::UNIX> 0

=head3 L<HTTP::UserAgentStr::Util::ByNickname> 0

=head3 L<Hash::DefHash> 0.072

=head3 L<Hash::DefHash::Normalize> 0

=head3 L<Hash::Key::Quote> 0

=head3 L<Hash::Subset> 0.007

=head3 L<Hash::Util::Regexp> 0

=head3 L<HashData> 0

=head3 L<HashDataBundle::CPAN> 0

=head3 L<HashDataRoles::Standard> 0

=head3 L<Health::BladderDiary::GenChart> 0

=head3 L<Health::BladderDiary::GenTable> 0.006

=head3 L<IMDB::TitleID::SearchByTitle> 0

=head3 L<IMDB::TitlePage::Extract> 0.005

=head3 L<INI::Examples> 0

=head3 L<IO::Prompt::I18N> 0

=head3 L<IO::Socket::UNIX::Util> 0

=head3 L<IOD> 0.9.11

=head3 L<IOD::Counter::Simple> 0

=head3 L<IOD::Examples> 0.201

=head3 L<IPC::Run::Patch::Setuid> 0.003

=head3 L<IPC::System::Options> 0.339

=head3 L<ISBN::SearchByTitle> 0

=head3 L<IntRange::Iter> 0.003

=head3 L<JSON::Color> 0

=head3 L<JSON::Decode::Marpa> 0

=head3 L<JSON::Decode::Regexp> 0

=head3 L<JSON::Encode::TableData> 0

=head3 L<LWP::Protocol::Patch::CountBytesIn> 0

=head3 L<LWP::Protocol::clipboard> 0

=head3 L<LWP::UserAgent::Patch::Delay> 0

=head3 L<LWP::UserAgent::Patch::FilterMirror> 0

=head3 L<LWP::UserAgent::Patch::HTTPSHardTimeout> 0

=head3 L<LWP::UserAgent::Patch::LogRequestContent> 0.04

=head3 L<LWP::UserAgent::Patch::LogResponse> 0.11

=head3 L<LWP::UserAgent::Patch::Plugin> 0

=head3 L<LWP::UserAgent::Patch::Retry> 0

=head3 L<LWP::UserAgent::Patch::SetUserAgent> 0

=head3 L<LWP::UserAgent::Plugin> 0.004

=head3 L<LWP::UserAgent::Plugin::Cache> 0

=head3 L<LWP::UserAgent::Plugin::Delay> 0

=head3 L<LWP::UserAgent::Plugin::Retry> 0

=head3 L<LWP::UserAgent::ProgressAny> 0

=head3 L<Language::Expr> 0.29

=head3 L<Ledger::Examples> 0

=head3 L<Ledger::Parser> 0

=head3 L<Lingua::EN::Number::Format::MixWithWords> 0

=head3 L<Lingua::ID::Number::Format::MixWithWords> 0

=head3 L<Lingua::ID::Nums2Words> 0

=head3 L<Lingua::ID::Words2Nums> 0

=head3 L<Lingua::Identify::Any> 0

=head3 L<Lingua::SU::Nums2Words> 0

=head3 L<LinuxMint::Releases> 0

=head3 L<List::AllUtils::Null> 0

=head3 L<List::Permute::Limit> 0

=head3 L<List::Rank> 0

=head3 L<List::Util::ArrayRef::PP> 0

=head3 L<List::Util::Find> 0

=head3 L<List::Util::Uniq> 0.005

=head3 L<Locale::ID::GuessGender::FromFirstName> 0

=head3 L<Locale::ID::Locality> 0.120

=head3 L<Locale::ID::Province> 0.110

=head3 L<Locale::Set> 0

=head3 L<Locale::TextDomain::IfEnv> 0

=head3 L<Locale::TextDomain::UTF8> 0

=head3 L<Locale::TextDomain::UTF8::IfEnv> 0

=head3 L<Locale::Tie> 0

=head3 L<Log::Any::Adapter::Callback> 0

=head3 L<Log::Any::Adapter::LogGer> 0

=head3 L<Log::Any::Adapter::Screen> 0

=head3 L<Log::Dispatch::ArrayWithLimits> 0

=head3 L<Log::Dispatch::Dir> 0

=head3 L<Log::Dispatch::FileWriteRotate> 0.04

=head3 L<Log::Log4perl::Appender::LogGer> 0

=head3 L<Log::err> 0

=head3 L<Log::ger> 0.038

=head3 L<Log::ger::App> 0.024

=head3 L<Log::ger::DBI::Query> 0

=head3 L<Log::ger::For::Builtins> 0

=head3 L<Log::ger::For::Class> 0

=head3 L<Log::ger::For::LWP> 0

=head3 L<Log::ger::Format::Block> 0

=head3 L<Log::ger::Format::Flogger> 0

=head3 L<Log::ger::Format::HashArgs> 0

=head3 L<Log::ger::Format::Hashref> 0

=head3 L<Log::ger::Format::Join> 0

=head3 L<Log::ger::Format::Sprintfn> 0

=head3 L<Log::ger::Layout::ConvertCase> 0

=head3 L<Log::ger::Layout::JSON> 0

=head3 L<Log::ger::Layout::LTSV> 0

=head3 L<Log::ger::Layout::Pattern> 0.008

=head3 L<Log::ger::Layout::Pattern::Multiline> 0

=head3 L<Log::ger::Layout::YAML> 0

=head3 L<Log::ger::Level::FromEnv> 0

=head3 L<Log::ger::Level::FromVar> 0

=head3 L<Log::ger::Level::Like::LogAny> 0

=head3 L<Log::ger::Level::Like::Mojo> 0

=head3 L<Log::ger::Level::Like::PythonLogging> 0

=head3 L<Log::ger::Level::Like::RubyLogging> 0

=head3 L<Log::ger::Level::Like::Syslog> 0

=head3 L<Log::ger::Level::Set> 0

=head3 L<Log::ger::Like::Log4perl> 0

=head3 L<Log::ger::Like::LogAny> 0

=head3 L<Log::ger::LogException> 0

=head3 L<Log::ger::Manual> 0

=head3 L<Log::ger::Output::ArrayRotate> 0

=head3 L<Log::ger::Output::Callback> 0

=head3 L<Log::ger::Output::Composite> 0.016

=head3 L<Log::ger::Output::DirWriteRotate> 0

=head3 L<Log::ger::Output::File> 0.002

=head3 L<Log::ger::Output::FileWriteRotate> 0

=head3 L<Log::ger::Output::Journald> 0

=head3 L<Log::ger::Output::LogAny> 0.003

=head3 L<Log::ger::Output::LogDispatchOutput> 0.003

=head3 L<Log::ger::Output::Perl> 0

=head3 L<Log::ger::Output::Screen> 0.018

=head3 L<Log::ger::Output::SimpleFile> 0

=head3 L<Log::ger::Output::Syslog> 0

=head3 L<Log::ger::Output::Test::Counter> 0

=head3 L<Log::ger::Plugin::Debug::DumpRoutines> 0

=head3 L<Log::ger::Plugin::HashArgs> 0

=head3 L<Log::ger::Plugin::Multisets> 0

=head3 L<Log::ger::Plugin::OptAway> 0

=head3 L<Log::ger::Plugin::WithWarn> 0

=head3 L<Log::ger::Screen> 0

=head3 L<Log::ger::Screen::ColorSchemes::Kuler> 0

=head3 L<Log::ger::UseBaheForDump> 0

=head3 L<Log::ger::UseDataDmpPrune> 0

=head3 L<Log::ger::UseDataDump> 0

=head3 L<Log::ger::UseDataDumpColor> 0

=head3 L<Log::ger::UseDataDumpObjectAsString> 0

=head3 L<Log::ger::UseDataDumpOptions> 0

=head3 L<Log::ger::UseDataDumper> 0

=head3 L<Log::ger::UseDataDumperCompact> 0

=head3 L<Log::ger::UseDataPrinter> 0

=head3 L<Log::ger::UseJSONForDump> 0

=head3 L<Log::ger::UseYAMLForDump> 0

=head3 L<Logfile::Tail::Switch> 0.004

=head3 L<Markdown::To::POD> 0

=head3 L<MarpaX::Simple> 0

=head3 L<Math::Image::CalcResized> 0.004

=head3 L<Math::ScientificNotation::Util> 0

=head3 L<Media::Info> 0.131

=head3 L<Media::Info::Ffmpeg> 0.006

=head3 L<Media::Info::Mediainfo> 0.004

=head3 L<Media::Info::Mplayer> 0.100

=head3 L<MediaWiki::Table::Tiny> 0

=head3 L<Module::Abstract> 0

=head3 L<Module::Abstract::Cwalitee> 0.008

=head3 L<Module::CPANfile::FromDistINI> 0

=head3 L<Module::CheckVersion> 0

=head3 L<Module::CoreList::List> 0

=head3 L<Module::CoreList::More> 0

=head3 L<Module::DataPack> 0.21

=head3 L<Module::Depakable> 0

=head3 L<Module::FatPack> 0.16

=head3 L<Module::Features> 0.1.7

=head3 L<Module::Features::Dummy> 0

=head3 L<Module::Features::PerlTrove> 0

=head3 L<Module::Features::PythonTrove> 0

=head3 L<Module::Features::Set> 0

=head3 L<Module::Features::TextTable> 0

=head3 L<Module::FeaturesUtil::Check> 0.005

=head3 L<Module::FeaturesUtil::Get> 0.004

=head3 L<Module::HideRename> 0

=head3 L<Module::Installed::Tiny> 0.011

=head3 L<Module::List::More> 0.004007

=head3 L<Module::List::More::Patch::Hide> 0

=head3 L<Module::List::Patch::Hide> 0

=head3 L<Module::List::Tiny> 0

=head3 L<Module::List::Tiny::Patch::Hide> 0

=head3 L<Module::List::Wildcard> 0

=head3 L<Module::List::Wildcard::Patch::Hide> 0

=head3 L<Module::Load::DiffINC> 0

=head3 L<Module::Load::In::INIT> 0.004

=head3 L<Module::Load::Util> 0.009

=head3 L<Module::Loadable> 0

=head3 L<Module::Patch> 0.276

=head3 L<Module::Path::More> 0.32

=head3 L<Module::Path::More::Patch::Hide> 0

=head3 L<Module::Path::Patch::Hide> 0

=head3 L<Module::Release::Select> 0

=head3 L<Module::XSOrPP> 0

=head3 L<Monkey::Patch::Action> 0.060

=head3 L<MooX::Role::Parameterized::With::Keyword> 0

=head3 L<Mooish> 0

=head3 L<Mooish::Caller::Util> 0

=head3 L<Net::Blogger> 0

=head3 L<Net::HTTP::Methods::Patch::LogRequest> 0.10

=head3 L<Nodejs::Util> 0.007

=head3 L<NumSeq::Iter> 0.002

=head3 L<Number::Closest::NonOO> 0

=head3 L<Number::Format::BigFloat> 0

=head3 L<Number::Format::Metric> 0

=head3 L<Number::Pad> 0

=head3 L<Number::Util::Range> 0.003

=head3 L<Object::Dumb> 0

=head3 L<Object::Util::Stringify> 0

=head3 L<Org::Dump> 0.551

=head3 L<Org::Examples> 0

=head3 L<Org::Parser> 0.558

=head3 L<Org::Parser::Tiny> 0.005

=head3 L<Org::Shell> 0

=head3 L<Org::To::ANSIText> 0

=head3 L<Org::To::HTML> 0.18

=head3 L<Org::To::HTML::WordPress> 0

=head3 L<Org::To::Pod> 0

=head3 L<Org::To::Text> 0.050

=head3 L<Org::To::VCF> 0

=head3 L<PERLANCAR::AppUtil::PerlStripper> 0

=head3 L<PERLANCAR::Exporter::Lite> 0.02

=head3 L<PERLANCAR::File::HomeDir> 0

=head3 L<PERLANCAR::HTML::Tree::Examples> 0

=head3 L<PERLANCAR::JSON::Match> 0

=head3 L<PERLANCAR::List::Util::PP> 0

=head3 L<PERLANCAR::Module::List> 0.004004

=head3 L<PERLANCAR::Module::List::Patch::Hide> 0

=head3 L<PERLANCAR::Parse::Arithmetic> 0

=head3 L<PERLANCAR::Permute::Named> 0

=head3 L<PERLANCAR::ShellQuote::Any> 0

=head3 L<PERLANCAR::Sort::Sub> 0

=head3 L<PERLANCAR::Text::Levenshtein> 0

=head3 L<PERLANCAR::Tree::Examples> 0

=head3 L<PERLANCAR::YAML::Any> 0

=head3 L<PERLANCAR::warnings::all> 0

=head3 L<PHPLive::Report> 0

=head3 L<PMVersions::Util> 0

=head3 L<Package::CopyContents> 0

=head3 L<Package::Util::Lite> 0

=head3 L<Params::Sah> 0.071

=head3 L<Parse::CommandLine::Regexp> 0

=head3 L<Parse::Date::Month::ID> 0

=head3 L<Parse::FireDiamond> 0.004

=head3 L<Parse::Hosts> 0

=head3 L<Parse::IPCommand> 0

=head3 L<Parse::Netstat> 0

=head3 L<Parse::Number::EN> 0

=head3 L<Parse::Number::ID> 0.06

=head3 L<Parse::PayPal::TxDetailReport> 0.006

=head3 L<Parse::PayPal::TxDetailReport::Old> 0

=head3 L<Parse::PayPal::TxFinderReport> 0.003

=head3 L<Parse::PhoneNumber::ID> 0

=head3 L<Parse::Services> 0

=head3 L<Parse::Sums> 0

=head3 L<Parse::VarName> 0

=head3 L<Patch::DBI::WriteCSV> 0

=head3 L<Patch::chdir::Print> 0

=head3 L<Patch::rand::Secure> 0

=head3 L<Path::Naive> 0.043

=head3 L<Path::Util> 0

=head3 L<Perinci> 0

=head3 L<Perinci::Access> 0

=head3 L<Perinci::Access::Base> 0

=head3 L<Perinci::Access::HTTP::Client> 0

=head3 L<Perinci::Access::HTTP::Server> 0

=head3 L<Perinci::Access::Lite> 0

=head3 L<Perinci::Access::Perl> 0.895

=head3 L<Perinci::Access::Schemeless::DBI> 0.009

=head3 L<Perinci::Access::Schemeless::Hash> 0

=head3 L<Perinci::Access::Simple::Client> 0

=head3 L<Perinci::Access::Simple::Server> 0

=head3 L<Perinci::AccessUtil> 0

=head3 L<Perinci::CLI> 0

=head3 L<Perinci::Class::Base> 0

=head3 L<Perinci::CmdLine> 0

=head3 L<Perinci::CmdLine::Any> 0

=head3 L<Perinci::CmdLine::Base::Patch::DumpConfigAfterRun> 0

=head3 L<Perinci::CmdLine::Base::Patch::DumpGetoptLongSpec> 0

=head3 L<Perinci::CmdLine::Call> 0

=head3 L<Perinci::CmdLine::Classic> 1.770

=head3 L<Perinci::CmdLine::Classic::Examples> 0

=head3 L<Perinci::CmdLine::Dump> 0.120

=head3 L<Perinci::CmdLine::Easy> 0

=head3 L<Perinci::CmdLine::Gen> 0.497

=head3 L<Perinci::CmdLine::Help> 0.175

=head3 L<Perinci::CmdLine::Inline> 0.547

=head3 L<Perinci::CmdLine::Lite> 1.924

=head3 L<Perinci::CmdLine::Lite::Patch::DumpMeta> 0

=head3 L<Perinci::CmdLine::Lite::Patch::ShowArgsAfterValidation> 0

=head3 L<Perinci::CmdLine::Lite::Patch::ShowArgsBeforeValidation> 0

=head3 L<Perinci::CmdLine::NonOO> 0

=head3 L<Perinci::CmdLine::POD> 0.038

=head3 L<Perinci::CmdLine::Server> 0

=head3 L<Perinci::CmdLine::Util> 0.13

=head3 L<Perinci::CmdLine::Util::Config> 1.725

=head3 L<Perinci::CmdLine::cryp> 0.006

=head3 L<Perinci::CmdLine::pause> 0

=head3 L<Perinci::CmdLine::sero> 0

=head3 L<Perinci::CmdLineX::CommonOptions::SelfUpgrade> 0.003

=head3 L<Perinci::Declare> 0

=head3 L<Perinci::Easy> 0

=head3 L<Perinci::Examples> 0.822

=head3 L<Perinci::Examples::Bin::Any> 0

=head3 L<Perinci::Examples::Bin::Any::ArgsAs> 0

=head3 L<Perinci::Examples::Bin::Any::Completion> 0

=head3 L<Perinci::Examples::Bin::Any::Config> 0

=head3 L<Perinci::Examples::Bin::Any::ResultNaked> 0

=head3 L<Perinci::Examples::Bin::Any::SahSchemas> 0

=head3 L<Perinci::Examples::Bin::Classic> 0

=head3 L<Perinci::Examples::Bin::Inline> 0

=head3 L<Perinci::Examples::Bin::Lite> 0

=head3 L<Perinci::Examples::Config> 0

=head3 L<Perinci::Examples::HTML> 0

=head3 L<Perinci::Examples::ResMeta::Table> 0

=head3 L<Perinci::Examples::SahSchemas> 0.003

=head3 L<Perinci::Exporter> 0.080

=head3 L<Perinci::Gen::ForModule> 0

=head3 L<Perinci::Import> 0

=head3 L<Perinci::Manual> 0

=head3 L<Perinci::Object> 0.311

=head3 L<Perinci::Package::CopyContents> 0

=head3 L<Perinci::Result::Format> 0

=head3 L<Perinci::Result::Format::Lite> 0.286

=head3 L<Perinci::Result::Util> 0

=head3 L<Perinci::Script::Any> 0

=head3 L<Perinci::Sub::ArgEntity> 0

=head3 L<Perinci::Sub::ArgEntity::dirname> 0

=head3 L<Perinci::Sub::ArgEntity::distname> 0

=head3 L<Perinci::Sub::ArgEntity::filename> 0

=head3 L<Perinci::Sub::ArgEntity::modulename> 0

=head3 L<Perinci::Sub::ArgEntity::perl_version> 0

=head3 L<Perinci::Sub::ArgEntity::riap_url> 0

=head3 L<Perinci::Sub::ArgEntity::sah::type_name> 0

=head3 L<Perinci::Sub::ArgEntity::software_license> 0

=head3 L<Perinci::Sub::ArgEntity::timezone> 0

=head3 L<Perinci::Sub::ArgEntity::unix_user> 0

=head3 L<Perinci::Sub::Args::Common> 0

=head3 L<Perinci::Sub::Complete> 0.944

=head3 L<Perinci::Sub::Convert::default_lang> 0

=head3 L<Perinci::Sub::Convert::v> 0

=head3 L<Perinci::Sub::ConvertArgs::Argv> 0

=head3 L<Perinci::Sub::ConvertArgs::Array> 0

=head3 L<Perinci::Sub::Dep::pm> 0

=head3 L<Perinci::Sub::DepChecker> 0

=head3 L<Perinci::Sub::DepUtil> 0

=head3 L<Perinci::Sub::FeatureUtil> 0

=head3 L<Perinci::Sub::Gen> 0

=head3 L<Perinci::Sub::Gen::AccessTable> 0.592

=head3 L<Perinci::Sub::Gen::AccessTable::DBI> 0

=head3 L<Perinci::Sub::Gen::AccessTable::Simple> 0.002

=head3 L<Perinci::Sub::Gen::FromClass> 0

=head3 L<Perinci::Sub::Gen::FromFormulas> 0

=head3 L<Perinci::Sub::GetArgs::Argv> 0.846

=head3 L<Perinci::Sub::GetArgs::Array> 0.170

=head3 L<Perinci::Sub::GetArgs::WebForm> 0

=head3 L<Perinci::Sub::Normalize> 0.205

=head3 L<Perinci::Sub::Property::arg::cmdline> 0

=head3 L<Perinci::Sub::Property::arg::form> 0

=head3 L<Perinci::Sub::Property::cmdline> 0

=head3 L<Perinci::Sub::Property::curry> 0

=head3 L<Perinci::Sub::Property::dies_on_error> 0

=head3 L<Perinci::Sub::Property::drops_privilege> 0

=head3 L<Perinci::Sub::Property::exit_on_error> 0

=head3 L<Perinci::Sub::Property::hide_args> 0

=head3 L<Perinci::Sub::Property::memoize> 0

=head3 L<Perinci::Sub::Property::result::object> 0

=head3 L<Perinci::Sub::Property::result::table> 0

=head3 L<Perinci::Sub::Property::result_postfilter> 0

=head3 L<Perinci::Sub::Property::retry> 0

=head3 L<Perinci::Sub::Property::timeout> 0

=head3 L<Perinci::Sub::PropertyUtil> 0.11

=head3 L<Perinci::Sub::To::CLIDocData> 0.304

=head3 L<Perinci::Sub::To::FishComplete> 0

=head3 L<Perinci::Sub::Util> 0.471

=head3 L<Perinci::Sub::Util::DepModule> 0

=head3 L<Perinci::Sub::Util::PropertyModule> 0

=head3 L<Perinci::Sub::ValidateArgs> 0.012

=head3 L<Perinci::Sub::Wrapper> 0.83

=head3 L<Perinci::Sub::Wrapper::Patch::HandlePHPArray> 0

=head3 L<Perinci::Sub::XCompletion> 0.08

=head3 L<Perinci::Sub::XCompletionBundle::App::cryp> 0

=head3 L<Perinci::Sub::XCompletionBundle::Color> 0

=head3 L<Perinci::Sub::XCompletionBundle::CryptoCurrency> 0

=head3 L<Perinci::Sub::XCompletionBundle::DBI> 0

=head3 L<Perinci::Sub::XCompletionBundle::Finance::SE::IDX> 0

=head3 L<Perinci::Sub::XCompletionBundle::Perl> 0

=head3 L<Perinci::Sub::XCompletionBundle::Riap> 0

=head3 L<Perinci::Sub::XCompletionBundle::lcpan> 0

=head3 L<Perinci::To::Doc> 0.874

=head3 L<Perinci::To::HTML> 0

=head3 L<Perinci::Tx::Manager> 0.56

=head3 L<Perinci::Tx::Util> 0

=head3 L<Perinci::Use> 0

=head3 L<Perinci::Web> 0

=head3 L<Perinci::WebScript::JSON> 0

=head3 L<Perl::Critic::PolicyBundle::PERLANCAR> 0

=head3 L<Perl::Examples> 0

=head3 L<Perl::Examples::Accessors> 0.11

=head3 L<Perl::LineNumber::Comment> 0

=head3 L<Perl::Stripper> 0

=head3 L<Perl::osnames> 0.121

=head3 L<PerlIO::via::as_is> 0

=head3 L<PerlX::ifor> 0

=head3 L<Permute::Named::Iter> 0

=head3 L<Pipe::Find> 0

=head3 L<Plack::App::dbi2http> 0

=head3 L<Pod::Cookbook> 0

=head3 L<Pod::Elide> 0.003

=head3 L<Pod::From::Acme::CPANModules> 0.012

=head3 L<Pod::Weaver::Plugin::Acme::CPANModules> 0

=head3 L<Pod::Weaver::Plugin::App::lcpan> 0

=head3 L<Pod::Weaver::Plugin::AppendPrepend> 0

=head3 L<Pod::Weaver::Plugin::ArrayData> 0

=head3 L<Pod::Weaver::Plugin::Bencher::Scenario> 0

=head3 L<Pod::Weaver::Plugin::BorderStyle> 0

=head3 L<Pod::Weaver::Plugin::Calendar::Dates> 0

=head3 L<Pod::Weaver::Plugin::ColorTheme> 0

=head3 L<Pod::Weaver::Plugin::Data::Sah::Coerce> 0

=head3 L<Pod::Weaver::Plugin::Data::Sah::Filter> 0

=head3 L<Pod::Weaver::Plugin::Eval> 0

=head3 L<Pod::Weaver::Plugin::Module::Features> 0

=head3 L<Pod::Weaver::Plugin::PERLANCAR::SortSections> 0

=head3 L<Pod::Weaver::Plugin::PatchModule> 0

=head3 L<Pod::Weaver::Plugin::Perinci::CmdLine> 0

=head3 L<Pod::Weaver::Plugin::Regexp::Pattern> 0

=head3 L<Pod::Weaver::Plugin::Rinci> 0

=head3 L<Pod::Weaver::Plugin::Run> 0

=head3 L<Pod::Weaver::Plugin::Sah::Schemas> 0

=head3 L<Pod::Weaver::Plugin::ScriptX> 0

=head3 L<Pod::Weaver::Plugin::Sort::Sub> 0

=head3 L<Pod::Weaver::Plugin::SortSections> 0

=head3 L<Pod::Weaver::Plugin::TableData> 0

=head3 L<Pod::Weaver::Plugin::WordList> 0

=head3 L<Pod::Weaver::Plugin::WordListC> 0

=head3 L<Pod::Weaver::Plugin::perlmv> 0

=head3 L<Pod::Weaver::PluginBundle::Author::PERLANCAR> 0

=head3 L<Pod::Weaver::Role::AddTextToSection> 0.06

=head3 L<Pod::Weaver::Role::DetectPerinciCmdLineScript> 0

=head3 L<Pod::Weaver::Role::DumpPerinciCmdLineScript> 0

=head3 L<Pod::Weaver::Role::RequireFromBuild> 0

=head3 L<Pod::Weaver::Role::SectionText::HasCompletion> 0

=head3 L<Pod::Weaver::Role::SectionText::SelfCompletion> 0

=head3 L<Pod::Weaver::Role::SortSections> 0

=head3 L<Pod::Weaver::Section::BorderStyles::ANSITable> 0

=head3 L<Pod::Weaver::Section::Bugs::DefaultRT> 0

=head3 L<Pod::Weaver::Section::Changes> 0

=head3 L<Pod::Weaver::Section::ColorThemes::ANSITable> 0

=head3 L<Pod::Weaver::Section::Completion::GetoptLongComplete> 0

=head3 L<Pod::Weaver::Section::Completion::GetoptLongMore> 0

=head3 L<Pod::Weaver::Section::Completion::GetoptLongSubcommand> 0

=head3 L<Pod::Weaver::Section::Completion::PerinciCmdLine> 0

=head3 L<Pod::Weaver::Section::Homepage::DefaultCPAN> 0

=head3 L<Pod::Weaver::Section::ReplaceSource::DefaultGitHub> 0

=head3 L<Pod::Weaver::Section::Source::DefaultGitHub> 0

=head3 L<PowerManagement::Any> 0.002

=head3 L<Proc::ChildError> 0

=head3 L<Proc::Daemon::Prefork> 0.711

=head3 L<Proc::Find> 0.051

=head3 L<Proc::Find::Parents> 0.631

=head3 L<Proc::Govern> 0.211

=head3 L<Progress::Any> 0.219

=head3 L<Progress::Any::Examples> 0

=head3 L<Progress::Any::Output::Callback> 0

=head3 L<Progress::Any::Output::DesktopNotify> 0

=head3 L<Progress::Any::Output::TermMessage> 0

=head3 L<Progress::Any::Output::TermProgressBarColor> 0

=head3 L<Progress::Any::Output::TermSpin> 0

=head3 L<RSS::From::Forum::vBulletin> 0

=head3 L<RSS::From::Twitter> 0

=head3 L<Random::Any> 0.003

=head3 L<Range::ArrayIter> 0

=head3 L<Range::HandleIter> 0

=head3 L<Range::HashIter> 0

=head3 L<Range::Iter> 0

=head3 L<Range::Iterator> 0

=head3 L<Range::ScalarIter> 0

=head3 L<Rclone::Util> 0.002

=head3 L<RedHat::Releases> 0

=head3 L<Regexp::Common::RegexpPattern> 0

=head3 L<Regexp::Common::json> 0

=head3 L<Regexp::EN::NumVerbage> 0

=head3 L<Regexp::From::String> 0.005

=head3 L<Regexp::ID::NumVerbage> 0

=head3 L<Regexp::IPv4> 0

=head3 L<Regexp::Pattern> 0.2.7

=head3 L<Regexp::Pattern::CPAN> 0.006

=head3 L<Regexp::Pattern::DefHash> 0

=head3 L<Regexp::Pattern::Email> 0

=head3 L<Regexp::Pattern::Filename::Archive> 0

=head3 L<Regexp::Pattern::Filename::Audio> 0

=head3 L<Regexp::Pattern::Filename::Backup> 0

=head3 L<Regexp::Pattern::Filename::Compressed> 0

=head3 L<Regexp::Pattern::Filename::Ebook> 0

=head3 L<Regexp::Pattern::Filename::Image> 0

=head3 L<Regexp::Pattern::Filename::Image::WhatsApp> 0

=head3 L<Regexp::Pattern::Filename::Media> 0

=head3 L<Regexp::Pattern::Filename::Media::WhatsApp> 0

=head3 L<Regexp::Pattern::Filename::Video> 0

=head3 L<Regexp::Pattern::Filename::Video::WhatsApp> 0

=head3 L<Regexp::Pattern::Float> 0

=head3 L<Regexp::Pattern::Git> 0.002

=head3 L<Regexp::Pattern::Int> 0

=head3 L<Regexp::Pattern::IntRange> 0

=head3 L<Regexp::Pattern::JSON> 0

=head3 L<Regexp::Pattern::Net> 0

=head3 L<Regexp::Pattern::OS> 0

=head3 L<Regexp::Pattern::Palindrome> 0

=head3 L<Regexp::Pattern::Path> 0

=head3 L<Regexp::Pattern::Perl> 0

=head3 L<Regexp::Pattern::RegexpCommon> 0

=head3 L<Regexp::Pattern::Test::re_engine> 0

=head3 L<Regexp::Pattern::Twitter> 0

=head3 L<Regexp::Pattern::URI> 0

=head3 L<Regexp::Pattern::YouTube> 0

=head3 L<Regexp::Stringify> 0

=head3 L<Release::Util::Git> 0.007

=head3 L<Reply::Plugin::DataDmp> 0

=head3 L<Reply::Plugin::DataDumpColor> 0

=head3 L<Require::Hook> 0

=head3 L<Require::Hook::MetaCPAN> 0

=head3 L<Require::Hook::More> 0

=head3 L<Require::Hook::Noop> 0

=head3 L<Require::Hook::Source::DzilBuild> 0

=head3 L<Require::Hook::Source::MetaCPAN> 0

=head3 L<Require::HookChain> 0

=head3 L<Require::HookChain::source::dzil_build> 0

=head3 L<Require::HookChain::source::metacpan> 0

=head3 L<Require::Util> 0

=head3 L<Retry::Backoff> 0

=head3 L<Riap> 0

=head3 L<Rinci> 1.1.102

=head3 L<Role::TinyCommons> 0

=head3 L<Role::TinyCommons::BinarySearch::LinesInHandle> 0

=head3 L<Role::TinyCommons::CSel> 0

=head3 L<Role::TinyCommons::Collection> 0

=head3 L<Role::TinyCommons::Iterator> 0

=head3 L<Role::TinyCommons::TermAttr::Color> 0

=head3 L<Role::TinyCommons::TermAttr::Interactive> 0

=head3 L<Role::TinyCommons::TermAttr::Size> 0

=head3 L<Role::TinyCommons::TermAttr::Software> 0

=head3 L<Role::TinyCommons::Tree> 0

=head3 L<RoleBundle::TinyCommons::Collection> 0

=head3 L<RoleBundle::TinyCommons::Iterator> 0

=head3 L<RoleBundle::TinyCommons::Tree> 0

=head3 L<SExpression::Decode::Marpa> 0

=head3 L<SPVM::Examples> 0.004

=head3 L<SQL::AlterTable::SQLite> 0

=head3 L<SQL::Schema::Versioned> 0.234

=head3 L<SQL::Statement::Functions::ArgMinMax> 0

=head3 L<SQL::Statement::Functions::Date> 0

=head3 L<SQL::Statement::Functions::Logic> 0

=head3 L<SQLite::Counter::Simple> 0.003

=head3 L<SQLite::KeyValueStore::Simple> 0.002

=head3 L<Sah> 0.9.50

=head3 L<Sah::Examples> 0

=head3 L<Sah::Manual> 0

=head3 L<Sah::PSchema> 0

=head3 L<Sah::PSchemas> 0

=head3 L<Sah::PSchemas::Perl> 0

=head3 L<Sah::PSchemas::Re> 0

=head3 L<Sah::Schemas> 0

=head3 L<Sah::Schemas::App::cryp> 0

=head3 L<Sah::Schemas::Array> 0

=head3 L<Sah::Schemas::ArrayData> 0

=head3 L<Sah::Schemas::Bencher> 0

=head3 L<Sah::Schemas::Binary> 0

=head3 L<Sah::Schemas::Bool> 0

=head3 L<Sah::Schemas::BorderStyle> 0

=head3 L<Sah::Schemas::CPAN> 0

=head3 L<Sah::Schemas::CPANMeta> 0

=head3 L<Sah::Schemas::CPANModules> 0

=head3 L<Sah::Schemas::Chrome> 0

=head3 L<Sah::Schemas::Collection> 0

=head3 L<Sah::Schemas::Color> 0

=head3 L<Sah::Schemas::ColorTheme> 0

=head3 L<Sah::Schemas::Country> 0

=head3 L<Sah::Schemas::CryptoCurrency> 0

=head3 L<Sah::Schemas::Currency> 0

=head3 L<Sah::Schemas::DBI> 0

=head3 L<Sah::Schemas::DNS> 0

=head3 L<Sah::Schemas::Data::Sah> 0

=head3 L<Sah::Schemas::DataSizeSpeed> 0

=head3 L<Sah::Schemas::Date> 0

=head3 L<Sah::Schemas::Date::ID> 0

=head3 L<Sah::Schemas::DefHash> 0

=head3 L<Sah::Schemas::Domain> 0

=head3 L<Sah::Schemas::EAN> 0

=head3 L<Sah::Schemas::Email> 0

=head3 L<Sah::Schemas::Examples> 0

=head3 L<Sah::Schemas::FileHandle> 0

=head3 L<Sah::Schemas::Finance::SE::IDX> 0

=head3 L<Sah::Schemas::Firefox> 0

=head3 L<Sah::Schemas::Float> 0

=head3 L<Sah::Schemas::Git> 0

=head3 L<Sah::Schemas::GraphicsColorNames> 0

=head3 L<Sah::Schemas::ISBN> 0

=head3 L<Sah::Schemas::Int> 0

=head3 L<Sah::Schemas::IntRange> 0

=head3 L<Sah::Schemas::JSON> 0

=head3 L<Sah::Schemas::Language> 0

=head3 L<Sah::Schemas::Math> 0

=head3 L<Sah::Schemas::ModuleFeatures> 0

=head3 L<Sah::Schemas::Net> 0

=head3 L<Sah::Schemas::NumSeq> 0

=head3 L<Sah::Schemas::Path> 0

=head3 L<Sah::Schemas::Perl> 0

=head3 L<Sah::Schemas::Phone> 0

=head3 L<Sah::Schemas::PhysicalQuantity> 0

=head3 L<Sah::Schemas::Re> 0

=head3 L<Sah::Schemas::RegexpPattern> 0

=head3 L<Sah::Schemas::Riap> 0

=head3 L<Sah::Schemas::Rinci> 0

=head3 L<Sah::Schemas::Sah> 0.9.46.0

=head3 L<Sah::Schemas::Software> 0

=head3 L<Sah::Schemas::SortSub> 0

=head3 L<Sah::Schemas::Str> 0

=head3 L<Sah::Schemas::TableData> 0

=head3 L<Sah::Schemas::Twitter> 0

=head3 L<Sah::Schemas::URL> 0

=head3 L<Sah::Schemas::Unix> 0

=head3 L<Sah::Schemas::Vivaldi> 0

=head3 L<Sah::Schemas::WordList> 0

=head3 L<Sah::Schemas::YouTube> 0

=head3 L<Scalar::Cmp> 0

=head3 L<Scalar::Util::LooksLikeNumber> 0

=head3 L<Scalar::Util::Numeric::PP> 0

=head3 L<Screensaver::Any> 0.007

=head3 L<ScriptX> 0.000004

=head3 L<ScriptX::Rinci> 0

=head3 L<ScriptX_Util> 0

=head3 L<Set::IntSpan::Util> 0

=head3 L<Setup> 0

=head3 L<Setup::File> 0

=head3 L<Setup::File::Layout> 0

=head3 L<Setup::File::Line> 0

=head3 L<Setup::File::Symlink> 0

=head3 L<Setup::File::TextFragment> 0

=head3 L<Setup::Unix::User> 0

=head3 L<Shell::Cap> 0

=head3 L<Shell::Completer> 0

=head3 L<ShellCompleter::Util> 0.030

=head3 L<ShellQuote::Any::PERLANCAR> 0

=head3 L<ShellQuote::Any::Tiny> 0

=head3 L<Shorthand> 0

=head3 L<Shorthand::Entropy::UseLocal> 0

=head3 L<Shorthand::Perinci::CmdLine::Any::main::app> 0

=head3 L<Simple::Timer> 0

=head3 L<Software::Catalog> 0

=head3 L<Software::Catalog::SW::bulwark::qt> 0

=head3 L<Software::Catalog::SW::dummy::undownloadable> 0

=head3 L<Software::Catalog::SW::filezilla> 0

=head3 L<Software::Catalog::SW::firefox> 0

=head3 L<Software::Catalog::SW::kdenlive> 0

=head3 L<Software::Catalog::SW::phpmyadmin> 0

=head3 L<Software::Catalog::SW::zcoin::qt> 0

=head3 L<Software::Catalog::SW::zotero> 0

=head3 L<Software::Release::Watch> 0

=head3 L<Sort::BySpec> 0.03

=head3 L<Sort::Sub> 0.120

=head3 L<Sort::Sub::by_date_in_text> 0

=head3 L<Sort::Sub::by_dmp> 0

=head3 L<Sort::Sub::by_example> 0

=head3 L<Sort::Sub::by_several> 0

=head3 L<Sort::Sub::data_struct_by_data_cmp> 0

=head3 L<Sort::Sub::filevercmp> 0

=head3 L<Sort::SubBundle::PERLANCAR> 0

=head3 L<Sort::SubList> 0

=head3 L<Spreadsheet::Open> 0

=head3 L<String::CommonPrefix> 0

=head3 L<String::Elide::FromArray> 0

=head3 L<String::Elide::Lines> 0.003

=head3 L<String::Elide::Parts> 0.07

=head3 L<String::Elide::Tiny> 0

=head3 L<String::Flogger::Patch::UseDataDmp> 0

=head3 L<String::Flogger::Patch::UseDataDump> 0

=head3 L<String::Indent> 0

=head3 L<String::JS> 0

=head3 L<String::LineNumber> 0

=head3 L<String::Pad> 0.021

=head3 L<String::PerlQuote> 0

=head3 L<String::PodQuote> 0

=head3 L<String::Query::To::Regexp> 0.002

=head3 L<String::SimpleEscape> 0

=head3 L<String::Trim::More> 0

=head3 L<String::Trim::NonRegex> 0

=head3 L<String::Util::Match> 0

=head3 L<String::Util::Range> 0

=head3 L<String::Wildcard::Bash> 0.044

=head3 L<String::Wildcard::SQL> 0.030

=head3 L<Sub::Iterator> 0

=head3 L<Sub::NoRepeat> 0

=head3 L<SyntaxHighlight::Any> 0

=head3 L<Sys::LoopDevice> 0

=head3 L<Sys::Run::Safer> 0

=head3 L<Sys::RunAlone::Flexible> 0

=head3 L<Sys::RunAlone::Flexible2> 0

=head3 L<Systemd::Util> 0

=head3 L<TOML::Examples> 0

=head3 L<TSV::Examples> 0

=head3 L<TableData> 0.2.0

=head3 L<TableData::Locale::US::State> 0

=head3 L<TableData::Perl::CPAN::Release::Static::2022> 0

=head3 L<TableData::Quote::JamesFT> 0

=head3 L<TableData::Size::DisplayResolution> 0

=head3 L<TableDataBundle::Business::ID::BBIA> 0

=head3 L<TableDataBundle::Business::ID::BPOM> 0

=head3 L<TableDataBundle::Business::ID::DGIP> 0

=head3 L<TableDataBundle::Business::ID::KBLI> 0

=head3 L<TableDataBundle::Lingua::Word::EN::Adjective> 0

=head3 L<TableDataBundle::Lingua::Word::EN::Adverb> 0

=head3 L<TableDataBundle::Lingua::Word::EN::Noun> 0

=head3 L<TableDataBundle::Locale::JP::City> 0

=head3 L<TableDataBundle::Perl::CPAN::Release> 0

=head3 L<TableDataBundle::Perl::CPAN::Release::Static::Older> 0

=head3 L<TableDataBundle::Perl::Release> 0

=head3 L<TableDataBundle::Software::License> 0

=head3 L<TableDataBundle::Test> 0

=head3 L<TableDataRole::Spec::TableDef> 0

=head3 L<TableDataRoles::Standard> 0

=head3 L<TableDef> 0

=head3 L<Task::CryptoExchange::API> 0

=head3 L<Task::FooThis> 0

=head3 L<Task::Software::Catalog::SW> 0

=head3 L<Task::Tmp::spanel> 0

=head3 L<Task::genpw> 0

=head3 L<Term::ANSIColor::Conditional> 0

=head3 L<Term::ANSIColor::Patch::Conditional> 0

=head3 L<Term::ANSIColor::WithWin32> 0

=head3 L<Term::App::Roles> 0

=head3 L<Term::App::Util::Color> 0

=head3 L<Term::App::Util::Interactive> 0.002

=head3 L<Term::App::Util::Size> 0

=head3 L<Term::Detect::Software> 0

=head3 L<Test::Deeply::Float> 0

=head3 L<Test::Module::Features> 0

=head3 L<Test::Perinci::CmdLine> 1.480

=head3 L<Test::ProveRdeps> 0

=head3 L<Test::RandomResult> 0

=head3 L<Test::Regexp::Pattern> 0.005

=head3 L<Test::Rinci> 0.151

=head3 L<Test::Rinci::CmdLine> 0

=head3 L<Test::Sah> 0

=head3 L<Test::Sah::Filter> 0.005

=head3 L<Test::Sah::Schema> 0.010

=head3 L<Test::WithDB> 0.100

=head3 L<Text::ANSI::Util> 0.22

=head3 L<Text::ANSI::WideUtil> 0

=head3 L<Text::ANSITable> 0.602

=head3 L<Text::ANSITable::ColorTheme::Extra> 0

=head3 L<Text::CSV::FromAOH> 0

=head3 L<Text::CSV_XS::Backslash> 0

=head3 L<Text::CSV_XS::TSV> 0

=head3 L<Text::Chart> 0

=head3 L<Text::Column::Util> 0

=head3 L<Text::DiffU> 0

=head3 L<Text::DumbTemplate> 0

=head3 L<Text::Fragment> 0

=head3 L<Text::Head> 0

=head3 L<Text::NonWideChar::Util> 0

=head3 L<Text::Sprintf::Length> 0

=head3 L<Text::Table::ASV> 0

=head3 L<Text::Table::Any> 0.111

=head3 L<Text::Table::CSV> 0.022

=head3 L<Text::Table::HTML> 0.008

=head3 L<Text::Table::HTML::DataTables> 0.011

=head3 L<Text::Table::LTSV> 0

=head3 L<Text::Table::More> 0

=head3 L<Text::Table::Org> 0.031

=head3 L<Text::Table::Paragraph> 0

=head3 L<Text::Table::Sprintf> 0.006

=head3 L<Text::Table::TSV> 0

=head3 L<Text::Table::TickitWidget> 0

=head3 L<Text::Table::TinyBorderStyle> 0

=head3 L<Text::Table::TinyColor> 0

=head3 L<Text::Table::TinyColorWide> 0

=head3 L<Text::Table::TinyWide> 0

=head3 L<Text::Table::XLSX> 0

=head3 L<Text::WideChar::Util> 0

=head3 L<Text::WordDiff::Unified::ANSIColor> 0

=head3 L<Text::Wrap::NoStrip> 0.002

=head3 L<Text::sprintfn> 0

=head3 L<Tie::Array::Expire> 0

=head3 L<Tie::Array::File::LazyRead> 0

=head3 L<Tie::Array::IntSpan> 0

=head3 L<Tie::Array::Log> 0

=head3 L<Tie::FileHandle::Log> 0

=head3 L<Tie::Handle::FileWriteRotate> 0

=head3 L<Tie::Handle::Log> 0

=head3 L<Tie::Handle::LogAny> 0

=head3 L<Tie::Handle::LogGer> 0

=head3 L<Tie::Handle::TailSwitch> 0

=head3 L<Tie::Hash::Log> 0

=head3 L<Time::Duration::Parse::AsHash> 0

=head3 L<Time::Local::ISO8601> 0

=head3 L<Time::Local::More> 0

=head3 L<Timeout::Self> 0

=head3 L<Touchpad::Any> 0

=head3 L<Touchscreen::Any> 0

=head3 L<Tree::Create::Callback> 0

=head3 L<Tree::Create::Size> 0

=head3 L<Tree::Dump> 0

=head3 L<Tree::FSMethods> 0

=head3 L<Tree::From::ObjArray> 0

=head3 L<Tree::From::Struct> 0

=head3 L<Tree::From::Text> 0

=head3 L<Tree::Object> 0

=head3 L<Tree::ObjectXS> 0

=head3 L<Tree::Shell> 0

=head3 L<Tree::To::FS> 0

=head3 L<Tree::To::Text> 0

=head3 L<Types::Sah::Firefox> 0

=head3 L<URI::Escape::Any> 0

=head3 L<URI::Escape::Path> 0

=head3 L<URI::Info> 0

=head3 L<UUID::Random::PERLANCAR> 0.005

=head3 L<UUID::Random::Patch::UseMRS> 0

=head3 L<UUID::Random::Secure> 0.003

=head3 L<UUID::Tiny::Patch::UseMRS> 0

=head3 L<Ubuntu::Releases> 0

=head3 L<Unicode::Homoglyph> 0

=head3 L<Unix::Passwd::File> 0

=head3 L<Unix::setuid> 0

=head3 L<Unixish> 0

=head3 L<Version::Monotonic> 0

=head3 L<Version::Util> 0.731

=head3 L<Versioning::Scheme> 0.002

=head3 L<Versioning::Scheme::Python> 0

=head3 L<Vivaldi::Util::Profile> 0

=head3 L<WHO::GrowthReference::GenChart> 0

=head3 L<WHO::GrowthReference::GenTable> 0

=head3 L<WHO::GrowthReference::Table> 0.007

=head3 L<WWW::Amazon::Book::Extract> 0

=head3 L<WWW::DaftarNama::Reseller> 0.002

=head3 L<WWW::DistroWatch::ReleaseInfo> 0

=head3 L<WWW::PAUSE::Simple> 0.453

=head3 L<WWW::RT::CPAN> 0

=head3 L<WWW::phpEasyProject> 0

=head3 L<Web::Detect> 0

=head3 L<WebService::Blogger> 0

=head3 L<WordList> 0.7.6

=head3 L<WordList::ArrayData> 0

=head3 L<WordList::BEW::Betawi> 0

=head3 L<WordList::CPAN::PAUSEID> 0

=head3 L<WordList::ColorName::Any> 0

=head3 L<WordList::DBI> 0

=head3 L<WordList::Domain::PublicSuffix> 0

=head3 L<WordList::EN::BIP39> 0

=head3 L<WordList::EN::Color::WWW> 0

=head3 L<WordList::EN::Color::X> 0

=head3 L<WordList::EN::ColorName::WWW> 0

=head3 L<WordList::EN::ColorName::X> 0

=head3 L<WordList::EN::Common::COCA::Top1000> 0

=head3 L<WordList::EN::Common::EF::Top1000> 0

=head3 L<WordList::EN::Common::EF::Top3000> 0

=head3 L<WordList::EN::Corncob> 0

=head3 L<WordList::EN::CountryName> 0

=head3 L<WordList::EN::CountryNames> 0

=head3 L<WordList::EN::Enable> 0

=head3 L<WordList::EN::Medical::Glutanimate> 0

=head3 L<WordList::EN::Oxford3000::Learner> 0

=head3 L<WordList::EN::PersonName::Bible> 0

=head3 L<WordList::EN::SGB> 0

=head3 L<WordList::EN::StopWords> 0

=head3 L<WordList::EN::Wordle> 0

=head3 L<WordList::ES::BIP39> 0

=head3 L<WordList::FR::BIP39> 0

=head3 L<WordList::FR::ODS3> 0

=head3 L<WordList::FR::ODS3::7To8> 0

=head3 L<WordList::FR::WiktionaryES> 0

=head3 L<WordList::FromFile::Line> 0

=head3 L<WordList::FromFile::Word> 0

=head3 L<WordList::HTTP::UserAgentString::Browser::Chrome> 0

=head3 L<WordList::HTTP::UserAgentString::Browser::Firefox> 0

=head3 L<WordList::HTTP::UserAgentString::Browser::Safari> 0

=head3 L<WordList::HTTP::UserAgentString::PERLANCAR> 0

=head3 L<WordList::ID::Animal::PERLANCAR> 0

=head3 L<WordList::ID::AnimalName::PERLANCAR> 0

=head3 L<WordList::ID::BIP39> 0.002

=head3 L<WordList::ID::Color::HTML_ID> 0

=head3 L<WordList::ID::Color::PERLANCAR> 0

=head3 L<WordList::ID::ColorName::HTML_ID> 0

=head3 L<WordList::ID::ColorName::PERLANCAR> 0

=head3 L<WordList::ID::Fruit::PERLANCAR> 0

=head3 L<WordList::ID::FruitName::PERLANCAR> 0

=head3 L<WordList::ID::KBBI> 0

=head3 L<WordList::ID::Wordle> 0

=head3 L<WordList::IT::BIP39> 0

=head3 L<WordList::JA::BIP39> 0

=head3 L<WordList::KO::BIP39> 0

=head3 L<WordList::MetaSyntactic::Any> 0

=head3 L<WordList::MetaSyntactic::dangdut> 0

=head3 L<WordList::Number::Prime::First10000> 0

=head3 L<WordList::Password::10Million::Top100000> 0

=head3 L<WordList::Password::10Million::Top1000000> 0

=head3 L<WordList::Password::RockYou> 0

=head3 L<WordList::Password::RockYou::BloomOnly> 0

=head3 L<WordList::Phrase::EN::Idiom::Wiktionary> 0

=head3 L<WordList::Phrase::EN::Proverb::TWW> 0

=head3 L<WordList::Phrase::EN::Proverb::Wiktionary> 0

=head3 L<WordList::Phrase::EN::Quote::JamesFT> 0

=head3 L<WordList::Phrase::FR::Idiom::Wiktionary> 0

=head3 L<WordList::Phrase::FR::Proverb::ProverbesFrancais> 0

=head3 L<WordList::Phrase::FR::Proverb::Wikiquote> 0

=head3 L<WordList::Phrase::FR::Proverb::Wiktionary> 0

=head3 L<WordList::Phrase::ID::Proverb::KBBI> 0

=head3 L<WordList::Phrase::JV::Proverb::PeribahasaNet> 0

=head3 L<WordList::Phrase::SU::Proverb::PeribahasaNet> 0

=head3 L<WordList::Phrase::ZH::CCIC> 0

=head3 L<WordList::Phrase::ZH::Idiom::ChineseTools> 0

=head3 L<WordList::Phrase::ZH::Idiom::Wiktionary> 0

=head3 L<WordList::Phrase::ZH::Proverb::Wiktionary> 0

=head3 L<WordList::SU::LTIS> 0

=head3 L<WordList::Special::Stdin> 0

=head3 L<WordList::Tables> 0

=head3 L<WordList::Test::Dynamic::Number::10000> 0

=head3 L<WordList::Test::Dynamic::Number::10Million> 0

=head3 L<WordList::Test::Dynamic::RandomWord::1000> 0

=head3 L<WordList::Test::Empty> 0

=head3 L<WordList::Test::Number::1Million> 0

=head3 L<WordList::Test::Unicode::Currency> 0

=head3 L<WordList::ZH::HSK> 0

=head3 L<WordList::ZH::Simplified::BIP39> 0

=head3 L<WordList::ZH::Traditional::BIP39> 0

=head3 L<WordListBase::MetaSyntactic> 0

=head3 L<WordListRole::BinarySearch> 0

=head3 L<WordListRole::Bloom> 0.006

=head3 L<WordListRole::RandomSeekPick> 0

=head3 L<WordListRole::Source::ArrayData> 0

=head3 L<WordListUtil::CLI> 0

=head3 L<WordLists::Char::Latin1> 0

=head3 L<WordLists::EN::Adjective> 0

=head3 L<WordLists::EN::Adverb> 0

=head3 L<WordLists::EN::CommonException> 0

=head3 L<WordLists::EN::Noun> 0

=head3 L<WordLists::EN::PersonName::PopularBabyName::GB_EAW::ONS> 0

=head3 L<WordLists::EN::PersonName::PopularBabyName::US::SSA> 0

=head3 L<WordLists::ID::Common> 0

=head3 L<XTerm::Util> 0.006

=head3 L<YouTube::Util> 0

=head3 L<Zodiac::Chinese::Table> 0

=head3 L<Zodiac::Tiny> 0

=head3 L<alias::module> 0

=head3 L<anywhere> 0

=head3 L<class::with::roles> 0

=head3 L<colorize::stderr> 0

=head3 L<getopt> 0

=head3 L<if::Pragmas> 0

=head3 L<lib::filter> 0

=head3 L<lib::hiderename> 0

=head3 L<lib::noop> 0

=head3 L<lib::prereqs::only> 0

=head3 L<monkeypatch> 0

=head3 L<perleasyfail> 0

=head3 L<perlsnippets> 0

=head3 L<phpBB2::Simple> 0

=head3 L<preloadable> 0

=head3 L<subroutines> 0

=head3 L<tainting> 0

=head3 L<version::dev> 0

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
