/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.configuration;

import de.jollyday.configuration.ConfigurationProvider;
import de.jollyday.configuration.internal.DefaultConfigurationProvider;
import de.jollyday.configuration.internal.URLConfigurationProvider;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ConfigurationProviderManager {
    private static final Logger LOG = Logger.getLogger(ConfigurationProviderManager.class.getName());
    private ConfigurationProvider defaultConfigurationProvider = new DefaultConfigurationProvider();
    private ConfigurationProvider urlConfigurationProvider = new URLConfigurationProvider();

    public Properties getConfigurationProperties(Properties properties) {
        Properties unifiedProperties = new Properties();
        this.addInternalConfigurationProviderProperies(unifiedProperties);
        this.addCustomConfigurationProviderProperties(unifiedProperties);
        if (properties != null) {
            unifiedProperties.putAll((Map<?, ?>)properties);
        }
        return unifiedProperties;
    }

    private void addInternalConfigurationProviderProperies(Properties properties) {
        this.defaultConfigurationProvider.putConfiguration(properties);
        this.urlConfigurationProvider.putConfiguration(properties);
    }

    private void addCustomConfigurationProviderProperties(Properties properties) {
        String[] providersClassNames;
        Properties systemProps = System.getProperties();
        String providersStrList = systemProps.getProperty("de.jollyday.config.providers");
        if (providersStrList != null && (providersClassNames = providersStrList.split(",")) != null) {
            for (String providerClassName : providersClassNames) {
                if (providerClassName == null || "".equals(providerClassName)) continue;
                try {
                    Class<?> providerClass = Class.forName(providerClassName.trim(), true, Thread.currentThread().getContextClassLoader());
                    ConfigurationProvider configurationProvider = (ConfigurationProvider)ConfigurationProvider.class.cast(providerClass.newInstance());
                    configurationProvider.putConfiguration(properties);
                }
                catch (Exception e) {
                    LOG.warning("Cannot load configuration from provider class '" + providerClassName + "'. " + e.getClass().getSimpleName() + " (" + e.getMessage() + ").");
                }
            }
        }
    }
}

