/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.graph;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface Graph<V, E>
extends Serializable {
    public void add(V var1, V var2, E var3);

    public boolean addVertex(V var1);

    public boolean removeEdges(V var1, V var2);

    public boolean removeEdge(V var1, V var2, E var3);

    public boolean removeVertex(V var1);

    public boolean removeVertices(Collection<V> var1);

    public int getNumVertices();

    public List<E> getOutgoingEdges(V var1);

    public List<E> getIncomingEdges(V var1);

    public int getNumEdges();

    public Set<V> getParents(V var1);

    public Set<V> getChildren(V var1);

    public Set<V> getNeighbors(V var1);

    public void clear();

    public boolean containsVertex(V var1);

    public boolean isEdge(V var1, V var2);

    public boolean isNeighbor(V var1, V var2);

    public Set<V> getAllVertices();

    public List<E> getAllEdges();

    public boolean isEmpty();

    public void removeZeroDegreeNodes();

    public List<E> getEdges(V var1, V var2);

    public int getInDegree(V var1);

    public int getOutDegree(V var1);

    public List<Set<V>> getConnectedComponents();
}

