/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.EncodingPrintWriter;
import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.ChineseCharacterBasedLexicon;
import edu.stanford.nlp.parser.lexparser.ChineseLexicon;
import edu.stanford.nlp.parser.lexparser.ChineseLexiconAndWordSegmenter;
import edu.stanford.nlp.parser.lexparser.ChineseSimWordAvgDepGrammar;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.Extractor;
import edu.stanford.nlp.parser.lexparser.IntDependency;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammarExtractor;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.SisterAnnotationStats;
import edu.stanford.nlp.process.WordSegmenter;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.pennchinese.BikelChineseHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.CTBErrorCorrectingTreeNormalizer;
import edu.stanford.nlp.trees.international.pennchinese.CTBTreeReaderFactory;
import edu.stanford.nlp.trees.international.pennchinese.ChineseCollinizer;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalStructure;
import edu.stanford.nlp.trees.international.pennchinese.ChineseHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import edu.stanford.nlp.trees.international.pennchinese.SunJurafskyChineseHeadFinder;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class ChineseTreebankParserParams
extends AbstractTreebankParserParams {
    private ChineseTreebankLanguagePack ctlp = (ChineseTreebankLanguagePack)super.treebankLanguagePack();
    public boolean charTags = false;
    public boolean useCharacterBasedLexicon = false;
    public boolean useMaxentLexicon = false;
    public boolean useMaxentDepGrammar = false;
    public boolean segment = false;
    public boolean segmentMarkov = false;
    public boolean sunJurafskyHeadFinder = false;
    public boolean bikelHeadFinder = false;
    public boolean discardFrags = false;
    public boolean useSimilarWordMap = false;
    public String segmenterClass = null;
    private Lexicon lex;
    private WordSegmenter segmenter;
    private HeadFinder headFinder = null;
    public boolean chineseSplitDouHao = false;
    public boolean chineseSplitPunct = true;
    public boolean chineseSplitPunctLR = false;
    public boolean markVVsisterIP = true;
    public boolean markPsisterIP = true;
    public boolean markIPsisterVVorP = true;
    public boolean markADgrandchildOfIP = false;
    public boolean gpaAD = true;
    public boolean chineseVerySelectiveTagPA = false;
    public boolean chineseSelectiveTagPA = false;
    public boolean markIPsisterBA = true;
    public boolean markVPadjunct = true;
    public boolean markNPmodNP = true;
    public boolean markModifiedNP = true;
    public boolean markNPconj = true;
    public boolean markMultiNtag = false;
    public boolean markIPsisDEC = true;
    public boolean markIPconj = false;
    public boolean markIPadjsubj = false;
    public int chineseSplitVP = 3;
    public boolean mergeNNVV = false;
    public boolean unaryIP = false;
    public boolean unaryCP = false;
    public boolean paRootDtr = false;
    public boolean markPostverbalP = false;
    public boolean markPostverbalPP = false;
    public boolean splitBaseNP = false;
    public boolean tagWordSize = false;
    public boolean markCC = false;
    public boolean splitNPTMP = false;
    public boolean splitPPTMP = false;
    public boolean splitXPTMP = false;
    public boolean dominatesV = false;
    public static final boolean DEFAULT_USE_GOOD_TURNING_UNKNOWN_WORD_MODEL = false;
    public boolean useGoodTuringUnknownWordModel = false;
    public boolean useCharBasedUnknownWordModel = false;
    public double lengthPenalty = 5.0;
    public boolean useUnknownCharacterModel = true;
    public int penaltyType = 0;
    private int depGramFeatureLevel = 0;
    private static final long serialVersionUID = 2L;

    private static void printlnErr(String s) {
        EncodingPrintWriter.err.println(s, "GB18030");
    }

    public ChineseTreebankParserParams() {
        super(new ChineseTreebankLanguagePack());
    }

    @Override
    public HeadFinder headFinder() {
        if (this.headFinder == null) {
            if (this.sunJurafskyHeadFinder) {
                return new SunJurafskyChineseHeadFinder();
            }
            if (this.bikelHeadFinder) {
                return new BikelChineseHeadFinder();
            }
            return new ChineseHeadFinder();
        }
        return this.headFinder;
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return new ChineseSemanticHeadFinder();
    }

    @Override
    public Lexicon lex(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        if (this.useCharacterBasedLexicon) {
            this.lex = new ChineseCharacterBasedLexicon(this, wordIndex, tagIndex);
            return this.lex;
        }
        if (op.lexOptions.uwModelTrainer == null) {
            op.lexOptions.uwModelTrainer = "edu.stanford.nlp.parser.lexparser.ChineseUnknownWordModelTrainer";
        }
        ChineseLexicon clex = new ChineseLexicon(op, this, wordIndex, tagIndex);
        if (this.segmenterClass != null) {
            try {
                this.segmenter = (WordSegmenter)ReflectionLoading.loadByReflection(this.segmenterClass, this, wordIndex, tagIndex);
            }
            catch (ReflectionLoading.ReflectionLoadingException e) {
                this.segmenter = (WordSegmenter)ReflectionLoading.loadByReflection(this.segmenterClass, new Object[0]);
            }
        }
        this.lex = this.segmenter != null ? new ChineseLexiconAndWordSegmenter(clex, this.segmenter) : clex;
        return this.lex;
    }

    @Override
    public double[] MLEDependencyGrammarSmoothingParams() {
        return new double[]{5.8, 17.7, 6.5, 0.4};
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        CTBErrorCorrectingTreeNormalizer tn = new CTBErrorCorrectingTreeNormalizer(this.splitNPTMP, this.splitPPTMP, this.splitXPTMP, this.charTags);
        return new CTBTreeReaderFactory(tn, this.discardFrags);
    }

    @Override
    public DiskTreebank diskTreebank() {
        String encoding = this.inputEncoding;
        if (!Charset.isSupported(encoding)) {
            ChineseTreebankParserParams.printlnErr("Warning: desired encoding " + encoding + " not accepted. ");
            ChineseTreebankParserParams.printlnErr("Using UTF-8 to construct DiskTreebank");
            encoding = "UTF-8";
        }
        return new DiskTreebank(this.treeReaderFactory(), encoding);
    }

    @Override
    public MemoryTreebank memoryTreebank() {
        String encoding = this.inputEncoding;
        if (!Charset.isSupported(encoding)) {
            System.out.println("Warning: desired encoding " + encoding + " not accepted. ");
            System.out.println("Using UTF-8 to construct MemoryTreebank");
            encoding = "UTF-8";
        }
        return new MemoryTreebank(this.treeReaderFactory(), encoding);
    }

    @Override
    public TreeTransformer collinizer() {
        return new ChineseCollinizer(this.ctlp);
    }

    @Override
    public TreeTransformer collinizerEvalb() {
        return new ChineseCollinizer(this.ctlp, false);
    }

    @Override
    public String[] sisterSplitters() {
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public Tree transformTree(Tree t, Tree root) {
        String grandParentStr;
        Tree grandParent;
        String parentStr;
        Tree parent;
        if (t == null || t.isLeaf()) {
            return t;
        }
        if (root == null || t.equals(root)) {
            parent = null;
            parentStr = "";
        } else {
            parent = t.parent(root);
            parentStr = parent.label().value();
        }
        if (parent == null || parent.equals(root)) {
            grandParent = null;
            grandParentStr = "";
        } else {
            grandParent = parent.parent(root);
            grandParentStr = grandParent.label().value();
        }
        String baseParentStr = this.ctlp.basicCategory(parentStr);
        String baseGrandParentStr = this.ctlp.basicCategory(grandParentStr);
        CoreLabel lab = (CoreLabel)t.label();
        String word = lab.word();
        String tag = lab.tag();
        String baseTag = this.ctlp.basicCategory(tag);
        String category = lab.value();
        String baseCategory = this.ctlp.basicCategory(category);
        if (t.isPreTerminal()) {
            int i;
            boolean seenIP;
            List<String> leftAunts = this.listBasicCategories(SisterAnnotationStats.leftSisterLabels(parent, grandParent));
            List<String> rightAunts = this.listBasicCategories(SisterAnnotationStats.rightSisterLabels(parent, grandParent));
            if (this.chineseSplitPunct && baseTag.equals("PU")) {
                if (ChineseTreebankLanguagePack.chineseDouHaoAcceptFilter().accept(word)) {
                    tag = tag + "-DOU";
                } else if (ChineseTreebankLanguagePack.chineseCommaAcceptFilter().accept(word)) {
                    tag = tag + "-COMMA";
                } else if (ChineseTreebankLanguagePack.chineseColonAcceptFilter().accept(word)) {
                    tag = tag + "-COLON";
                } else if (ChineseTreebankLanguagePack.chineseQuoteMarkAcceptFilter().accept(word)) {
                    tag = this.chineseSplitPunctLR ? (ChineseTreebankLanguagePack.chineseLeftQuoteMarkAcceptFilter().accept(word) ? tag + "-LQUOTE" : tag + "-RQUOTE") : tag + "-QUOTE";
                } else if (ChineseTreebankLanguagePack.chineseEndSentenceAcceptFilter().accept(word)) {
                    tag = tag + "-ENDSENT";
                } else if (ChineseTreebankLanguagePack.chineseParenthesisAcceptFilter().accept(word)) {
                    tag = this.chineseSplitPunctLR ? (ChineseTreebankLanguagePack.chineseLeftParenthesisAcceptFilter().accept(word) ? tag + "-LPAREN" : tag + "-RPAREN") : tag + "-PAREN";
                } else if (ChineseTreebankLanguagePack.chineseDashAcceptFilter().accept(word)) {
                    tag = tag + "-DASH";
                } else if (ChineseTreebankLanguagePack.chineseOtherAcceptFilter().accept(word)) {
                    tag = tag + "-OTHER";
                } else {
                    ChineseTreebankParserParams.printlnErr("Unknown punct (you should add it to CTLP): " + tag + " |" + word + "|");
                }
            } else if (this.chineseSplitDouHao && ChineseTreebankLanguagePack.chineseDouHaoAcceptFilter().accept(word) && baseTag.equals("PU")) {
                tag = tag + "-DOU";
            }
            if (this.tagWordSize) {
                int l = word.length();
                tag = tag + "-" + l + "CHARS";
            }
            if (this.mergeNNVV && baseTag.equals("NN")) {
                tag = "VV";
            }
            if ((this.chineseSelectiveTagPA || this.chineseVerySelectiveTagPA) && (baseTag.equals("CC") || baseTag.equals("P"))) {
                tag = tag + "-" + baseParentStr;
            }
            if (this.chineseSelectiveTagPA && baseTag.equals("VV")) {
                tag = tag + "-" + baseParentStr;
            }
            if (this.markMultiNtag && tag.startsWith("N")) {
                for (int i2 = 0; i2 < parent.numChildren(); ++i2) {
                    if (!parent.children()[i2].label().value().startsWith("N") || parent.children()[i2] == t) continue;
                    tag = tag + "=N";
                }
            }
            if (this.markVVsisterIP && baseTag.equals("VV")) {
                seenIP = false;
                for (i = 0; i < parent.numChildren(); ++i) {
                    if (!parent.children()[i].label().value().startsWith("IP")) continue;
                    seenIP = true;
                }
                if (seenIP) {
                    tag = tag + "-IP";
                }
            }
            if (this.markPsisterIP && baseTag.equals("P")) {
                seenIP = false;
                for (i = 0; i < parent.numChildren(); ++i) {
                    if (!parent.children()[i].label().value().startsWith("IP")) continue;
                    seenIP = true;
                }
                if (seenIP) {
                    tag = tag + "-IP";
                }
            }
            if (this.markADgrandchildOfIP && baseTag.equals("AD") && baseGrandParentStr.equals("IP")) {
                tag = tag + "~IP";
            }
            if (this.gpaAD && baseTag.equals("AD")) {
                tag = tag + "~" + baseGrandParentStr;
            }
            if (this.markPostverbalP && leftAunts.contains("VV") && baseTag.equals("P")) {
                tag = tag + "^=lVV";
            }
            CategoryWordTag label = new CategoryWordTag(tag, word, tag);
            t.setLabel(label);
        } else {
            Tree[] kids = t.children();
            List<String> leftSis = this.listBasicCategories(SisterAnnotationStats.leftSisterLabels(t, parent));
            List<String> rightSis = this.listBasicCategories(SisterAnnotationStats.rightSisterLabels(t, parent));
            if (this.paRootDtr && baseParentStr.equals("ROOT")) {
                category = category + "^ROOT";
            }
            if (this.markIPsisterBA && baseCategory.equals("IP") && leftSis.contains("BA")) {
                category = category + "=BA";
            }
            if (this.dominatesV && ChineseTreebankParserParams.hasV(t.preTerminalYield())) {
                category = category + "-v";
            }
            if (this.markIPsisterVVorP && baseCategory.equals("IP") && (leftSis.contains("VV") || leftSis.contains("P"))) {
                category = category + "=VVP";
            }
            if (this.markIPsisDEC && baseCategory.equals("IP") && rightSis.contains("DEC")) {
                category = category + "=DEC";
            }
            if (baseCategory.equals("VP")) {
                if (this.chineseSplitVP == 3) {
                    boolean hasCC = false;
                    boolean hasPU = false;
                    boolean hasLexV = false;
                    for (Tree kid : kids) {
                        if (kid.label().value().startsWith("CC")) {
                            hasCC = true;
                            continue;
                        }
                        if (kid.label().value().startsWith("PU")) {
                            hasPU = true;
                            continue;
                        }
                        if (!StringUtils.lookingAt(kid.label().value(), "(V[ACEV]|VCD|VCP|VNV|VPT|VRD|VSB)")) continue;
                        hasLexV = true;
                    }
                    category = hasCC || hasPU && !hasLexV ? category + "-CRD" : (hasLexV ? category + "-COMP" : category + "-ADJT");
                } else if (this.chineseSplitVP >= 1) {
                    boolean hasBA = false;
                    for (Tree kid : kids) {
                        if (kid.label().value().startsWith("BA")) {
                            hasBA = true;
                            continue;
                        }
                        if (this.chineseSplitVP != 2 || !this.tlp.basicCategory(kid.label().value()).equals("VP")) continue;
                        Tree[] arr$ = kid.children();
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            Tree kidkid = arr$[i$];
                            if (!kidkid.label().value().startsWith("BA")) continue;
                            hasBA = true;
                        }
                    }
                    if (hasBA) {
                        category = category + "-BA";
                    }
                }
            }
            if (this.markVPadjunct && baseParentStr.equals("VP")) {
                Tree[] sisters = parent.children();
                boolean hasVPsister = false;
                boolean hasCC = false;
                boolean hasPU = false;
                boolean hasLexV = false;
                for (Tree sister : sisters) {
                    if (this.tlp.basicCategory(sister.label().value()).equals("VP")) {
                        hasVPsister = true;
                    }
                    if (sister.label().value().startsWith("CC")) {
                        hasCC = true;
                    }
                    if (sister.label().value().startsWith("PU")) {
                        hasPU = true;
                    }
                    if (!StringUtils.lookingAt(sister.label().value(), "(V[ACEV]|VCD|VCP|VNV|VPT|VRD|VSB)")) continue;
                    hasLexV = true;
                }
                if (hasVPsister && !hasCC && !hasPU && !hasLexV) {
                    category = category + "-VPADJ";
                }
            }
            if (this.markNPmodNP && baseCategory.equals("NP") && baseParentStr.equals("NP") && rightSis.contains("NP")) {
                category = category + "=MODIFIERNP";
            }
            if (this.markModifiedNP && baseCategory.equals("NP") && baseParentStr.equals("NP") && rightSis.isEmpty() && (leftSis.contains("ADJP") || leftSis.contains("NP") || leftSis.contains("DNP") || leftSis.contains("QP") || leftSis.contains("CP") || leftSis.contains("PP"))) {
                category = category + "=MODIFIEDNP";
            }
            if (this.markNPconj && baseCategory.equals("NP") && baseParentStr.equals("NP") && (rightSis.contains("CC") || rightSis.contains("PU") || leftSis.contains("CC") || leftSis.contains("PU"))) {
                category = category + "=CONJ";
            }
            if (this.markIPconj && baseCategory.equals("IP") && baseParentStr.equals("IP")) {
                Tree[] sisters = parent.children();
                boolean hasCommaSis = false;
                boolean hasIPSis = false;
                for (Tree sister : sisters) {
                    if (this.ctlp.basicCategory(sister.label().value()).equals("PU") && ChineseTreebankLanguagePack.chineseCommaAcceptFilter().accept(((Object)sister.children()[0].label()).toString())) {
                        hasCommaSis = true;
                    }
                    if (!this.ctlp.basicCategory(sister.label().value()).equals("IP") || sister == t) continue;
                    hasIPSis = true;
                }
                if (hasCommaSis && hasIPSis) {
                    category = category + "-CONJ";
                }
            }
            if (this.unaryIP && baseCategory.equals("IP") && t.numChildren() == 1) {
                category = category + "-U";
            }
            if (this.unaryCP && baseCategory.equals("CP") && t.numChildren() == 1) {
                category = category + "-U";
            }
            if (this.splitBaseNP && baseCategory.equals("NP") && t.isPrePreTerminal()) {
                category = category + "-B";
            }
            if (this.markPostverbalPP && leftSis.contains("VV") && baseCategory.equals("PP")) {
                category = category + "=lVV";
            }
            if ((this.markADgrandchildOfIP || this.gpaAD) && this.listBasicCategories(SisterAnnotationStats.kidLabels(t)).contains("AD")) {
                category = category + "^ADVP";
            }
            if (this.markCC) {
                for (int i = 1; i < kids.length - 1; ++i) {
                    String cat2 = kids[i].label().value();
                    if (!cat2.startsWith("CC")) continue;
                    category = category + "-CC";
                }
            }
            CategoryWordTag label = new CategoryWordTag(category, word, tag);
            t.setLabel(label);
        }
        return t;
    }

    @Override
    public void display() {
        String chineseParams = "Using ChineseTreebankParserParams chineseSplitDouHao=" + this.chineseSplitDouHao + " chineseSplitPunct=" + this.chineseSplitPunct + " chineseSplitPunctLR=" + this.chineseSplitPunctLR + " markVVsisterIP=" + this.markVVsisterIP + " markVPadjunct=" + this.markVPadjunct + " chineseSplitVP=" + this.chineseSplitVP + " mergeNNVV=" + this.mergeNNVV + " unaryIP=" + this.unaryIP + " unaryCP=" + this.unaryCP + " paRootDtr=" + this.paRootDtr + " markPsisterIP=" + this.markPsisterIP + " markIPsisterVVorP=" + this.markIPsisterVVorP + " markADgrandchildOfIP=" + this.markADgrandchildOfIP + " gpaAD=" + this.gpaAD + " markIPsisterBA=" + this.markIPsisterBA + " markNPmodNP=" + this.markNPmodNP + " markNPconj=" + this.markNPconj + " markMultiNtag=" + this.markMultiNtag + " markIPsisDEC=" + this.markIPsisDEC + " markIPconj=" + this.markIPconj + " markIPadjsubj=" + this.markIPadjsubj + " markPostverbalP=" + this.markPostverbalP + " markPostverbalPP=" + this.markPostverbalPP + " baseNP=" + this.splitBaseNP + " headFinder=" + (this.sunJurafskyHeadFinder ? "sunJurafsky" : (this.bikelHeadFinder ? "bikel" : "levy")) + " discardFrags=" + this.discardFrags + " dominatesV=" + this.dominatesV;
        ChineseTreebankParserParams.printlnErr(chineseParams);
    }

    private List<String> listBasicCategories(List<String> l) {
        ArrayList<String> l1 = new ArrayList<String>();
        for (String s : l) {
            l1.add(this.ctlp.basicCategory(s));
        }
        return l1;
    }

    private static boolean hasV(List tags) {
        int tsize = tags.size();
        for (int i = 0; i < tsize; ++i) {
            String str = tags.get(i).toString();
            if (!str.startsWith("V")) continue;
            return true;
        }
        return false;
    }

    @Override
    public int setOptionFlag(String[] args, int i) {
        if (args[i].equalsIgnoreCase("-paRootDtr")) {
            this.paRootDtr = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryIP")) {
            this.unaryIP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryCP")) {
            this.unaryCP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markPostverbalP")) {
            this.markPostverbalP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markPostverbalPP")) {
            this.markPostverbalPP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-baseNP")) {
            this.splitBaseNP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markVVsisterIP")) {
            this.markVVsisterIP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markPsisterIP")) {
            this.markPsisterIP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markIPsisterVVorP")) {
            this.markIPsisterVVorP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markIPsisterBA")) {
            this.markIPsisterBA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dominatesV")) {
            this.dominatesV = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-gpaAD")) {
            this.gpaAD = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markVPadjunct")) {
            this.markVPadjunct = Boolean.valueOf(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markNPmodNP")) {
            this.markNPmodNP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markModifiedNP")) {
            this.markModifiedNP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markNPconj")) {
            this.markNPconj = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseSplitPunct")) {
            this.chineseSplitPunct = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseSplitPunctLR")) {
            this.chineseSplitPunct = true;
            this.chineseSplitPunctLR = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseSelectiveTagPA")) {
            this.chineseSelectiveTagPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseVerySelectiveTagPA")) {
            this.chineseVerySelectiveTagPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markIPsisDEC")) {
            this.markIPsisDEC = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseSplitVP")) {
            this.chineseSplitVP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-tagWordSize")) {
            this.tagWordSize = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-vanilla")) {
            this.chineseSplitDouHao = false;
            this.chineseSplitPunct = false;
            this.chineseSplitPunctLR = false;
            this.markVVsisterIP = false;
            this.markPsisterIP = false;
            this.markIPsisterVVorP = false;
            this.markADgrandchildOfIP = false;
            this.gpaAD = false;
            this.markIPsisterBA = false;
            this.markVPadjunct = false;
            this.markNPmodNP = false;
            this.markModifiedNP = false;
            this.markNPconj = false;
            this.markMultiNtag = false;
            this.markIPsisDEC = false;
            this.markIPconj = false;
            this.markIPadjsubj = false;
            this.chineseSplitVP = 0;
            this.mergeNNVV = false;
            this.unaryIP = false;
            this.unaryCP = false;
            this.paRootDtr = false;
            this.markPostverbalP = false;
            this.markPostverbalPP = false;
            this.splitBaseNP = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-acl03chinese")) {
            this.chineseSplitDouHao = false;
            this.chineseSplitPunct = true;
            this.chineseSplitPunctLR = true;
            this.markVVsisterIP = true;
            this.markPsisterIP = true;
            this.markIPsisterVVorP = true;
            this.markADgrandchildOfIP = false;
            this.gpaAD = true;
            this.markIPsisterBA = false;
            this.markVPadjunct = true;
            this.markNPmodNP = true;
            this.markModifiedNP = true;
            this.markNPconj = true;
            this.markMultiNtag = false;
            this.markIPsisDEC = true;
            this.markIPconj = false;
            this.markIPadjsubj = false;
            this.chineseSplitVP = 3;
            this.mergeNNVV = false;
            this.unaryIP = true;
            this.unaryCP = true;
            this.paRootDtr = true;
            this.markPostverbalP = false;
            this.markPostverbalPP = false;
            this.splitBaseNP = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseFactored")) {
            this.chineseSplitDouHao = false;
            this.chineseSplitPunct = true;
            this.chineseSplitPunctLR = true;
            this.markVVsisterIP = true;
            this.markPsisterIP = true;
            this.markIPsisterVVorP = true;
            this.markADgrandchildOfIP = false;
            this.gpaAD = true;
            this.markIPsisterBA = true;
            this.markVPadjunct = true;
            this.markNPmodNP = true;
            this.markModifiedNP = true;
            this.markNPconj = true;
            this.markMultiNtag = false;
            this.markIPsisDEC = true;
            this.markIPconj = false;
            this.markIPadjsubj = false;
            this.chineseSplitVP = 3;
            this.mergeNNVV = false;
            this.unaryIP = true;
            this.unaryCP = true;
            this.paRootDtr = true;
            this.markPostverbalP = false;
            this.markPostverbalPP = false;
            this.splitBaseNP = false;
            this.chineseVerySelectiveTagPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chinesePCFG")) {
            this.chineseSplitDouHao = false;
            this.chineseSplitPunct = true;
            this.chineseSplitPunctLR = true;
            this.markVVsisterIP = true;
            this.markPsisterIP = false;
            this.markIPsisterVVorP = true;
            this.markADgrandchildOfIP = false;
            this.gpaAD = false;
            this.markIPsisterBA = true;
            this.markVPadjunct = true;
            this.markNPmodNP = true;
            this.markModifiedNP = true;
            this.markNPconj = false;
            this.markMultiNtag = false;
            this.markIPsisDEC = false;
            this.markIPconj = false;
            this.markIPadjsubj = false;
            this.chineseSplitVP = 0;
            this.mergeNNVV = false;
            this.unaryIP = false;
            this.unaryCP = false;
            this.paRootDtr = false;
            this.markPostverbalP = false;
            this.markPostverbalPP = false;
            this.splitBaseNP = false;
            this.chineseVerySelectiveTagPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-sunHead")) {
            this.sunJurafskyHeadFinder = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-bikelHead")) {
            this.bikelHeadFinder = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-discardFrags")) {
            this.discardFrags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-charLex")) {
            this.useCharacterBasedLexicon = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-charUnk")) {
            this.useCharBasedUnknownWordModel = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-rad")) {
            this.useUnknownCharacterModel = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-lengthPenalty") && i + 1 < args.length) {
            this.lengthPenalty = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-penaltyType") && i + 1 < args.length) {
            this.penaltyType = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-gtUnknown")) {
            this.useGoodTuringUnknownWordModel = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-maxentUnk")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-tuneSigma")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-trainCountThresh") && i + 1 < args.length) {
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markCC")) {
            this.markCC = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-segmentMarkov") || args[i].equalsIgnoreCase("-segmentWords")) {
            this.segment = true;
            this.segmentMarkov = true;
            this.segmenterClass = "edu.stanford.nlp.parser.lexparser.ChineseMarkovWordSegmenter";
            ++i;
        } else if (args[i].equalsIgnoreCase("-segmentMaxMatch")) {
            this.segment = true;
            this.segmentMarkov = false;
            this.segmenterClass = "edu.stanford.nlp.parser.lexparser.MaxMatchSegmenter";
            ++i;
        } else if (args[i].equalsIgnoreCase("-segmentDPMaxMatch")) {
            this.segment = true;
            this.segmentMarkov = false;
            this.segmenterClass = "edu.stanford.nlp.wordseg.MaxMatchSegmenter";
            ++i;
        } else if (args[i].equalsIgnoreCase("-maxentLex")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-fixUnkFunctionWords")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-similarWordSmoothing")) {
            this.useSimilarWordMap = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-maxentLexSeenTagsOnly")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-maxentLexFeatLevel") && i + 1 < args.length) {
            i += 2;
        } else if (args[i].equalsIgnoreCase("-maxentDepGrammarFeatLevel") && i + 1 < args.length) {
            this.depGramFeatureLevel = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-maxentDepGrammar")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitNPTMP")) {
            this.splitNPTMP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitPPTMP")) {
            this.splitPPTMP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitXPTMP")) {
            this.splitXPTMP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-segmenter")) {
            this.segment = true;
            this.segmentMarkov = false;
            this.segmenterClass = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-headFinder") && i + 1 < args.length) {
            try {
                this.headFinder = (HeadFinder)Class.forName(args[i + 1]).newInstance();
            }
            catch (Exception e) {
                System.err.println(e);
                System.err.println(this.getClass().getName() + ": Could not load head finder " + args[i + 1]);
                throw new RuntimeException(e);
            }
            i += 2;
        }
        return i;
    }

    @Override
    public Extractor<DependencyGrammar> dependencyGrammarExtractor(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        if (this.useSimilarWordMap) {
            return new MLEDependencyGrammarExtractor(op, wordIndex, tagIndex){

                @Override
                public MLEDependencyGrammar formResult() {
                    this.wordIndex.indexOf("UNK", true);
                    ChineseSimWordAvgDepGrammar dg = new ChineseSimWordAvgDepGrammar(this.tlpParams, this.directional, this.useDistance, this.useCoarseDistance, this.op.trainOptions.basicCategoryTagsInDependencyGrammar, this.op, (Index<String>)this.wordIndex, (Index<String>)this.tagIndex);
                    if (ChineseTreebankParserParams.this.lex == null) {
                        throw new RuntimeException("Attempt to create ChineseSimWordAvgDepGrammar before Lexicon!!!");
                    }
                    dg.setLex(ChineseTreebankParserParams.this.lex);
                    for (IntDependency dependency : this.dependencyCounter.keySet()) {
                        dg.addRule(dependency, this.dependencyCounter.getCount(dependency));
                    }
                    return dg;
                }
            };
        }
        return new MLEDependencyGrammarExtractor(op, wordIndex, tagIndex);
    }

    public ArrayList<Word> defaultTestSentence() {
        return Sentence.toUntaggedList("\u951f\u65a4\u62f7", "\u951f\u65a4\u62f7", "\u5b66\u6821", "\u951f\u65a4\u62f7", "\u5b66\u4e60", "\u951f\u65a4\u62f7");
    }

    @Override
    public List<GrammaticalStructure> readGrammaticalStructureFromFile(String filename) {
        try {
            return ChineseGrammaticalStructure.readCoNLLXGrammaticStructureCollection(filename);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public GrammaticalStructure getGrammaticalStructure(Tree t, Filter<String> filter, HeadFinder hf) {
        return new ChineseGrammaticalStructure(t, filter, hf);
    }

    public static void main(String[] args) {
        ChineseTreebankParserParams tlpp = new ChineseTreebankParserParams();
        System.out.println("Default encoding is: " + tlpp.diskTreebank().encoding());
        if (args.length < 2) {
            ChineseTreebankParserParams.printlnErr("Usage: edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams treesPath fileRange");
        } else {
            DiskTreebank m = tlpp.diskTreebank();
            m.loadPath(args[0], (FileFilter)new NumberRangesFileFilter(args[1], false));
            for (Tree t : m) {
                t.pennPrint(tlpp.pw());
            }
            System.out.println("There were " + m.size() + " trees.");
        }
    }
}

