/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.propagation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.maltparser.core.config.ConfigurationDir;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.propagation.PropagationException;
import org.maltparser.core.propagation.Propagations;
import org.maltparser.core.propagation.spec.PropagationSpecs;
import org.maltparser.core.propagation.spec.PropagationSpecsReader;
import org.maltparser.core.symbol.SymbolTableHandler;
import org.maltparser.core.syntaxgraph.edge.Edge;

public class PropagationManager {
    private ConfigurationDir configDirectory;
    private PropagationSpecs propagationSpecs;
    private Propagations propagations;
    private SymbolTableHandler symbolTables;

    public PropagationManager(ConfigurationDir configDirectory, SymbolTableHandler symbolTables) {
        this.setConfigDirectory(configDirectory);
        this.setSymbolTables(symbolTables);
        this.propagationSpecs = new PropagationSpecs();
    }

    private URL findURL(String propagationSpecFileName) throws MaltChainedException {
        URL url = null;
        File specFile = this.configDirectory.getFile(propagationSpecFileName);
        if (specFile.exists()) {
            try {
                url = new URL("file:///" + specFile.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                throw new PropagationException("Malformed URL: " + specFile, e);
            }
        } else {
            url = this.configDirectory.getConfigFileEntryURL(propagationSpecFileName);
        }
        return url;
    }

    public void loadSpecification(String propagationSpecFileName) throws MaltChainedException {
        PropagationSpecsReader reader = new PropagationSpecsReader();
        reader.load(this.findURL(propagationSpecFileName), this.propagationSpecs);
        this.propagations = new Propagations(this.propagationSpecs, this.symbolTables);
    }

    public void propagate(Edge e) throws MaltChainedException {
        if (this.propagations != null && e != null) {
            this.propagations.propagate(e);
        }
    }

    public PropagationSpecs getPropagationSpecs() {
        return this.propagationSpecs;
    }

    public ConfigurationDir getConfigDirectory() {
        return this.configDirectory;
    }

    public void setConfigDirectory(ConfigurationDir configDirectory) {
        this.configDirectory = configDirectory;
    }

    public SymbolTableHandler getSymbolTables() {
        return this.symbolTables;
    }

    public void setSymbolTables(SymbolTableHandler symbolTables) {
        this.symbolTables = symbolTables;
    }

    public Propagations getPropagations() {
        return this.propagations;
    }
}

