=encoding utf8

=head1

Locale::CLDR::Locales::Fa - Package for language Persian

=cut

package Locale::CLDR::Locales::Fa;
# This file auto generated from Data\common\main\fa.xml
#	on Sun  3 Feb  1:49:48 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => HashRef,
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(منفی →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(صفر),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← ممیز →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(یک),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(دو),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(سه),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(چهار),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(پنج),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(شش),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(هفت),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(هشت),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(نه),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ده),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(یازده),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(دوازده),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(سیزده),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(چهارده),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(پانزده),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(شانزده),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(هفده),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(هجده),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(نوزده),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(بیست[ و →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(سی[ و →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(چهل[ و →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(پنجاه[ و →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(شصت[ و →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(هفتاد[ و →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(هشتاد[ و →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(نود[ و →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(صد[ و →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(دویست[ و →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(سیصد[ و →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(چهارصد[ و →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(پانصد[ و →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(ششصد[ و →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(هفتصد[ و →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(هشتصد[ و →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(نهصد[ و →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←← هزار[ و →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←← میلیون[ و →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←← میلیارد[ و →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←← هزار میلیارد[ و →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}، {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'آفاری',
 				'ab' => 'آبخازی',
 				'ace' => 'آچئی',
 				'ach' => 'آچولیایی',
 				'ada' => 'آدانگمه‌ای',
 				'ady' => 'آدیجیایی',
 				'ae' => 'اوستایی',
 				'aeb' => 'عربی تونسی',
 				'af' => 'آفریکانس',
 				'afh' => 'آفریهیلی',
 				'agq' => 'آگیم',
 				'ain' => 'آینویی',
 				'ak' => 'آکان',
 				'akk' => 'اکدی',
 				'akz' => 'آلابامایی',
 				'ale' => 'آلئوتی',
 				'alt' => 'آلتایی جنوبی',
 				'am' => 'امهری',
 				'an' => 'آراگونی',
 				'ang' => 'انگلیسی باستان',
 				'anp' => 'آنگیکا',
 				'ar' => 'عربی',
 				'ar_001' => 'عربی رسمی',
 				'arc' => 'آرامی',
 				'arn' => 'ماپوچه‌ای',
 				'arp' => 'آراپاهویی',
 				'arq' => 'عربی الجزایری',
 				'arw' => 'آراواکی',
 				'ary' => 'عربی مراکشی',
 				'arz' => 'عربی مصری',
 				'as' => 'آسامی',
 				'asa' => 'آسو',
 				'ast' => 'آستوری',
 				'av' => 'آواری',
 				'awa' => 'اودهی',
 				'ay' => 'آیمارایی',
 				'az' => 'ترکی آذربایجانی',
 				'az@alt=short' => 'آذری',
 				'az@alt=variant' => 'آذربایجانی',
 				'az_Arab' => 'ترکی آذری جنوبی',
 				'ba' => 'باشقیری',
 				'bal' => 'بلوچی',
 				'ban' => 'بالیایی',
 				'bar' => 'باواریایی',
 				'bas' => 'باسایی',
 				'bax' => 'بمونی',
 				'be' => 'بلاروسی',
 				'bej' => 'بجایی',
 				'bem' => 'بمبایی',
 				'bez' => 'بنایی',
 				'bg' => 'بلغاری',
 				'bgn' => 'بلوچی غربی',
 				'bho' => 'بوجپوری',
 				'bi' => 'بیسلاما',
 				'bik' => 'بیکولی',
 				'bin' => 'بینی',
 				'bla' => 'سیکسیکا',
 				'bm' => 'بامبارایی',
 				'bn' => 'بنگالی',
 				'bo' => 'تبتی',
 				'bqi' => 'لری بختیاری',
 				'br' => 'برتون',
 				'bra' => 'براج',
 				'brh' => 'براهویی',
 				'brx' => 'بودویی',
 				'bs' => 'بوسنیایی',
 				'bua' => 'بوریاتی',
 				'bug' => 'بوگیایی',
 				'byn' => 'بلین',
 				'ca' => 'کاتالان',
 				'cad' => 'کادویی',
 				'car' => 'کاریبی',
 				'ce' => 'چچنی',
 				'ceb' => 'سبویی',
 				'cgg' => 'چیگا',
 				'ch' => 'چامورویی',
 				'chb' => 'چیبچا',
 				'chg' => 'جغتایی',
 				'chk' => 'چوکی',
 				'chm' => 'ماریایی',
 				'cho' => 'چوکتویی',
 				'chp' => 'چیپه‌ویه‌ای',
 				'chr' => 'چروکیایی',
 				'chy' => 'شایانی',
 				'ckb' => 'کردی مرکزی',
 				'co' => 'کورسی',
 				'cop' => 'قبطی',
 				'cr' => 'کریایی',
 				'crh' => 'ترکی کریمه',
 				'crs' => 'سیشل آمیختهٔ فرانسوی',
 				'cs' => 'چکی',
 				'csb' => 'کاشوبی',
 				'cu' => 'اسلاوی کلیسایی',
 				'cv' => 'چوواشی',
 				'cy' => 'ولزی',
 				'da' => 'دانمارکی',
 				'dak' => 'داکوتایی',
 				'dar' => 'دارقینی',
 				'dav' => 'تایتا',
 				'de' => 'آلمانی',
 				'de_AT' => 'آلمانی اتریش',
 				'de_CH' => 'آلمانی معیار سوئیس',
 				'del' => 'دلاواری',
 				'dgr' => 'دوگریب',
 				'din' => 'دینکایی',
 				'dje' => 'زرما',
 				'doi' => 'دوگری',
 				'dsb' => 'صُربی سفلی',
 				'dua' => 'دوآلایی',
 				'dum' => 'هلندی میانه',
 				'dv' => 'دیوهی',
 				'dyo' => 'دیولا فونی',
 				'dyu' => 'دایولایی',
 				'dz' => 'دزونگخا',
 				'dzg' => 'دازاگایی',
 				'ebu' => 'امبو',
 				'ee' => 'اوه‌ای',
 				'efi' => 'افیکی',
 				'egy' => 'مصری کهن',
 				'eka' => 'اکاجوک',
 				'el' => 'یونانی',
 				'elx' => 'عیلامی',
 				'en' => 'انگلیسی',
 				'en_AU' => 'انگلیسی استرالیا',
 				'en_CA' => 'انگلیسی کانادا',
 				'en_GB' => 'انگلیسی بریتانیا',
 				'en_GB@alt=short' => 'انگلیسی بریتانیا',
 				'en_US' => 'انگلیسی امریکا',
 				'en_US@alt=short' => 'انگلیسی امریکا',
 				'enm' => 'انگلیسی میانه',
 				'eo' => 'اسپرانتو',
 				'es' => 'اسپانیایی',
 				'es_419' => 'اسپانیایی امریکای لاتین',
 				'es_ES' => 'اسپانیایی اروپا',
 				'es_MX' => 'اسپانیایی مکزیک',
 				'et' => 'استونیایی',
 				'eu' => 'باسکی',
 				'ewo' => 'اواندو',
 				'fa' => 'فارسی',
 				'fa_AF' => 'دری',
 				'fan' => 'فانگی',
 				'fat' => 'فانتیایی',
 				'ff' => 'فولانی',
 				'fi' => 'فنلاندی',
 				'fil' => 'فیلیپینی',
 				'fj' => 'فیجیایی',
 				'fo' => 'فارویی',
 				'fon' => 'فونی',
 				'fr' => 'فرانسوی',
 				'fr_CA' => 'فرانسوی کانادا',
 				'fr_CH' => 'فرانسوی سوئیس',
 				'frc' => 'فرانسوی کادین',
 				'frm' => 'فرانسوی میانه',
 				'fro' => 'فرانسوی باستان',
 				'frr' => 'فریزی شمالی',
 				'frs' => 'فریزی شرقی',
 				'fur' => 'فریولیایی',
 				'fy' => 'فریزی غربی',
 				'ga' => 'ایرلندی',
 				'gaa' => 'گایی',
 				'gag' => 'گاگائوزیایی',
 				'gay' => 'گایویی',
 				'gba' => 'گبایایی',
 				'gbz' => 'دری زرتشتی',
 				'gd' => 'گیلی اسکاتلندی',
 				'gez' => 'گی‌ئزی',
 				'gil' => 'گیلبرتی',
 				'gl' => 'گالیسیایی',
 				'glk' => 'گیلکی',
 				'gmh' => 'آلمانی معیار میانه',
 				'gn' => 'گوارانی',
 				'goh' => 'آلمانی علیای باستان',
 				'gon' => 'گوندی',
 				'gor' => 'گورونتالو',
 				'got' => 'گوتی',
 				'grb' => 'گریبویی',
 				'grc' => 'یونانی کهن',
 				'gsw' => 'آلمانی سوئیسی',
 				'gu' => 'گجراتی',
 				'guz' => 'گوسی',
 				'gv' => 'مانی',
 				'gwi' => 'گویچ این',
 				'ha' => 'هوسیایی',
 				'hai' => 'هایدایی',
 				'haw' => 'هاوائیایی',
 				'he' => 'عبری',
 				'hi' => 'هندی',
 				'hif' => 'هندی فیجیایی',
 				'hil' => 'هیلی‌گاینونی',
 				'hit' => 'هیتی',
 				'hmn' => 'همونگ',
 				'ho' => 'موتویی هیری',
 				'hr' => 'کروات',
 				'hsb' => 'صُربی علیا',
 				'ht' => 'هائیتیایی',
 				'hu' => 'مجاری',
 				'hup' => 'هوپا',
 				'hy' => 'ارمنی',
 				'hz' => 'هریرویی',
 				'ia' => 'میان‌زبان',
 				'iba' => 'ایبانی',
 				'ibb' => 'ایبیبیو',
 				'id' => 'اندونزیایی',
 				'ie' => 'اکسیدنتال',
 				'ig' => 'ایگبویی',
 				'ii' => 'یی سیچوان',
 				'ik' => 'اینوپیک',
 				'ilo' => 'ایلوکویی',
 				'inh' => 'اینگوشی',
 				'io' => 'ایدو',
 				'is' => 'ایسلندی',
 				'it' => 'ایتالیایی',
 				'iu' => 'اینوکتیتوت',
 				'ja' => 'ژاپنی',
 				'jbo' => 'لوجبان',
 				'jgo' => 'نگومبا',
 				'jmc' => 'ماچامه‌ای',
 				'jpr' => 'فارسی یهودی',
 				'jrb' => 'عربی یهودی',
 				'jv' => 'جاوه‌ای',
 				'ka' => 'گرجی',
 				'kaa' => 'قره‌قالپاقی',
 				'kab' => 'قبایلی',
 				'kac' => 'کاچینی',
 				'kaj' => 'جو',
 				'kam' => 'کامبایی',
 				'kaw' => 'کاویایی',
 				'kbd' => 'کاباردینی',
 				'kcg' => 'تیاپی',
 				'kde' => 'ماکونده',
 				'kea' => 'کابووردیانو',
 				'kfo' => 'کورو',
 				'kg' => 'کنگویی',
 				'kha' => 'خاسیایی',
 				'kho' => 'ختنی',
 				'khq' => 'کوجراچینی',
 				'khw' => 'کهوار',
 				'ki' => 'کیکویویی',
 				'kiu' => 'کرمانجی',
 				'kj' => 'کوانیاما',
 				'kk' => 'قزاقی',
 				'kkj' => 'کاکایی',
 				'kl' => 'گرینلندی',
 				'kln' => 'کالنجین',
 				'km' => 'خمری',
 				'kmb' => 'کیمبوندویی',
 				'kn' => 'کانارا',
 				'ko' => 'کره‌ای',
 				'koi' => 'کومی پرمیاک',
 				'kok' => 'کنکانی',
 				'kpe' => 'کپله‌ای',
 				'kr' => 'کانوریایی',
 				'krc' => 'قره‌چایی‐بالکاری',
 				'krl' => 'کاریلیانی',
 				'kru' => 'کوروخی',
 				'ks' => 'کشمیری',
 				'ksb' => 'شامبالا',
 				'ksf' => 'بافیایی',
 				'ksh' => 'ریپواری',
 				'ku' => 'کردی',
 				'kum' => 'کومیکی',
 				'kut' => 'کوتنی',
 				'kv' => 'کومیایی',
 				'kw' => 'کرنوالی',
 				'ky' => 'قرقیزی',
 				'la' => 'لاتین',
 				'lad' => 'لادینو',
 				'lag' => 'لانگی',
 				'lah' => 'لاهندا',
 				'lam' => 'لامبا',
 				'lb' => 'لوگزامبورگی',
 				'lez' => 'لزگی',
 				'lg' => 'گاندایی',
 				'li' => 'لیمبورگی',
 				'lkt' => 'لاکوتا',
 				'ln' => 'لینگالا',
 				'lo' => 'لائوسی',
 				'lol' => 'مونگویی',
 				'lou' => 'زبان آمیختهٔ مادری لوئیزیانا',
 				'loz' => 'لوزیایی',
 				'lrc' => 'لری شمالی',
 				'lt' => 'لیتوانیایی',
 				'lu' => 'لوبایی‐کاتانگا',
 				'lua' => 'لوبایی‐لولوا',
 				'lui' => 'لویسنو',
 				'lun' => 'لوندایی',
 				'luo' => 'لوئویی',
 				'lus' => 'لوشه‌ای',
 				'luy' => 'لویا',
 				'lv' => 'لتونیایی',
 				'lzh' => 'چینی ادبی',
 				'mad' => 'مادورایی',
 				'mag' => 'ماگاهیایی',
 				'mai' => 'مایدیلی',
 				'mak' => 'ماکاسار',
 				'man' => 'ماندینگویی',
 				'mas' => 'ماسایی',
 				'mdf' => 'مکشایی',
 				'mdr' => 'ماندار',
 				'men' => 'منده‌ای',
 				'mer' => 'مرویی',
 				'mfe' => 'موریسین',
 				'mg' => 'مالاگاسیایی',
 				'mga' => 'ایرلندی میانه',
 				'mgh' => 'ماکوا متو',
 				'mgo' => 'متایی',
 				'mh' => 'مارشالی',
 				'mi' => 'مائوریایی',
 				'mic' => 'میکماکی',
 				'min' => 'مینانگ‌کابویی',
 				'mk' => 'مقدونی',
 				'ml' => 'مالایالامی',
 				'mn' => 'مغولی',
 				'mnc' => 'مانچویی',
 				'mni' => 'میته‌ای',
 				'moh' => 'موهاکی',
 				'mos' => 'ماسیایی',
 				'mr' => 'مراتی',
 				'ms' => 'مالایی',
 				'mt' => 'مالتی',
 				'mua' => 'ماندانگی',
 				'mul' => 'چندین زبان',
 				'mus' => 'کریکی',
 				'mwl' => 'میراندی',
 				'mwr' => 'مارواری',
 				'my' => 'برمه‌ای',
 				'myv' => 'ارزیایی',
 				'mzn' => 'مازندرانی',
 				'na' => 'نائورویی',
 				'nap' => 'ناپلی',
 				'naq' => 'نامایی',
 				'nb' => 'نروژی بوک‌مُل',
 				'nd' => 'انده‌بله‌ای شمالی',
 				'nds' => 'آلمانی سفلی',
 				'nds_NL' => 'ساکسونی سفلی',
 				'ne' => 'نپالی',
 				'new' => 'نواریایی',
 				'ng' => 'اندونگایی',
 				'nia' => 'نیاسی',
 				'niu' => 'نیویی',
 				'nl' => 'هلندی',
 				'nl_BE' => 'فلمنگی',
 				'nmg' => 'کوازیو',
 				'nn' => 'نروژی نی‌نُشک',
 				'nnh' => 'انگیمبونی',
 				'no' => 'نروژی',
 				'nog' => 'نغایی',
 				'non' => 'نرس باستان',
 				'nqo' => 'نکو',
 				'nr' => 'انده‌بله‌ای جنوبی',
 				'nso' => 'سوتویی شمالی',
 				'nus' => 'نویر',
 				'nv' => 'ناواهویی',
 				'nwc' => 'نواریایی کلاسیک',
 				'ny' => 'نیانجایی',
 				'nym' => 'نیام‌وزیایی',
 				'nyn' => 'نیانکوله‌ای',
 				'nyo' => 'نیورویی',
 				'nzi' => 'نزیمایی',
 				'oc' => 'اکسیتان',
 				'oj' => 'اوجیبوایی',
 				'om' => 'اورومویی',
 				'or' => 'اوریه‌ای',
 				'os' => 'آسی',
 				'osa' => 'اوسیجی',
 				'ota' => 'ترکی عثمانی',
 				'pa' => 'پنجابی',
 				'pag' => 'پانگاسینانی',
 				'pal' => 'پهلوی',
 				'pam' => 'پامپانگایی',
 				'pap' => 'پاپیامنتو',
 				'pau' => 'پالائویی',
 				'pcm' => 'نیم‌زبان نیجریه‌ای',
 				'pdc' => 'آلمانی پنسیلوانیایی',
 				'peo' => 'فارسی باستان',
 				'phn' => 'فنیقی',
 				'pi' => 'پالی',
 				'pl' => 'لهستانی',
 				'pon' => 'پانپیی',
 				'prg' => 'پروسی',
 				'pro' => 'پرووانسی باستان',
 				'ps' => 'پشتو',
 				'ps@alt=variant' => 'پختو',
 				'pt' => 'پرتغالی',
 				'pt_BR' => 'پرتغالی برزیل',
 				'pt_PT' => 'پرتغالی اروپا',
 				'qu' => 'کچوایی',
 				'quc' => 'کیچه‌',
 				'raj' => 'راجستانی',
 				'rap' => 'راپانویی',
 				'rar' => 'راروتونگایی',
 				'rm' => 'رومانش',
 				'rn' => 'روندیایی',
 				'ro' => 'رومانیایی',
 				'ro_MD' => 'مولداویایی',
 				'rof' => 'رومبویی',
 				'rom' => 'رومانویی',
 				'root' => 'ریشه',
 				'ru' => 'روسی',
 				'rup' => 'آرومانی',
 				'rw' => 'کینیارواندایی',
 				'rwk' => 'روایی',
 				'sa' => 'سانسکریت',
 				'sad' => 'سانداوه‌ای',
 				'sah' => 'یاقوتی',
 				'sam' => 'آرامی سامری',
 				'saq' => 'سامبورو',
 				'sas' => 'ساساکی',
 				'sat' => 'سانتالی',
 				'sba' => 'انگامبایی',
 				'sbp' => 'سانگویی',
 				'sc' => 'ساردینیایی',
 				'scn' => 'سیسیلی',
 				'sco' => 'اسکاتلندی',
 				'sd' => 'سندی',
 				'sdh' => 'کردی جنوبی',
 				'se' => 'سامی شمالی',
 				'seh' => 'سنا',
 				'sel' => 'سلکوپی',
 				'ses' => 'کویرابورا سنی',
 				'sg' => 'سانگو',
 				'sga' => 'ایرلندی باستان',
 				'sh' => 'صرب و کرواتی',
 				'shi' => 'تاچل‌هیت',
 				'shn' => 'شانی',
 				'shu' => 'عربی چادی',
 				'si' => 'سینهالی',
 				'sid' => 'سیدامویی',
 				'sk' => 'اسلواکی',
 				'sl' => 'اسلوونیایی',
 				'sli' => 'سیلزیایی سفلی',
 				'sm' => 'ساموآیی',
 				'sma' => 'سامی جنوبی',
 				'smj' => 'لوله سامی',
 				'smn' => 'ایناری سامی',
 				'sms' => 'اسکولت سامی',
 				'sn' => 'شونایی',
 				'snk' => 'سونینکه‌ای',
 				'so' => 'سومالیایی',
 				'sog' => 'سغدی',
 				'sq' => 'آلبانیایی',
 				'sr' => 'صربی',
 				'srn' => 'تاکی‌تاکی',
 				'srr' => 'سریری',
 				'ss' => 'سوازیایی',
 				'ssy' => 'ساهو',
 				'st' => 'سوتویی جنوبی',
 				'su' => 'سوندایی',
 				'suk' => 'سوکومایی',
 				'sus' => 'سوسویی',
 				'sux' => 'سومری',
 				'sv' => 'سوئدی',
 				'sw' => 'سواحیلی',
 				'sw_CD' => 'سواحیلی کنگو',
 				'swb' => 'کوموری',
 				'syc' => 'سریانی کلاسیک',
 				'syr' => 'سریانی',
 				'szl' => 'سیلزیایی',
 				'ta' => 'تامیلی',
 				'te' => 'تلوگویی',
 				'tem' => 'تمنه‌ای',
 				'teo' => 'تسویی',
 				'ter' => 'ترنو',
 				'tet' => 'تتومی',
 				'tg' => 'تاجیکی',
 				'th' => 'تایلندی',
 				'ti' => 'تیگرینیایی',
 				'tig' => 'تیگره‌ای',
 				'tiv' => 'تیوی',
 				'tk' => 'ترکمنی',
 				'tl' => 'تاگالوگی',
 				'tlh' => 'کلینگون',
 				'tli' => 'تلین‌گیتی',
 				'tmh' => 'تاماشقی',
 				'tn' => 'تسوانایی',
 				'to' => 'تونگایی',
 				'tog' => 'تونگایی نیاسا',
 				'tpi' => 'توک‌پیسینی',
 				'tr' => 'ترکی استانبولی',
 				'tr@alt=secondary' => 'ترکی',
 				'trv' => 'تاروکویی',
 				'ts' => 'تسونگایی',
 				'tsi' => 'تسیم‌شیانی',
 				'tt' => 'تاتاری',
 				'tum' => 'تومبوکایی',
 				'tvl' => 'تووالویی',
 				'tw' => 'توی‌یایی',
 				'twq' => 'تسواکی',
 				'ty' => 'تاهیتیایی',
 				'tyv' => 'تووایی',
 				'tzm' => 'آمازیغی اطلس مرکزی',
 				'udm' => 'اودمورتی',
 				'ug' => 'اویغوری',
 				'uga' => 'اوگاریتی',
 				'uk' => 'اوکراینی',
 				'umb' => 'امبوندویی',
 				'und' => 'زبان نامشخص',
 				'ur' => 'اردو',
 				'uz' => 'ازبکی',
 				'vai' => 'ویایی',
 				've' => 'وندایی',
 				'vi' => 'ویتنامی',
 				'vo' => 'ولاپوک',
 				'vot' => 'وتی',
 				'vun' => 'ونجو',
 				'wa' => 'والونی',
 				'wae' => 'والسر',
 				'wal' => 'والامو',
 				'war' => 'وارایی',
 				'was' => 'واشویی',
 				'wbp' => 'وارلپیری',
 				'wo' => 'ولوفی',
 				'xal' => 'قلموقی',
 				'xh' => 'خوسایی',
 				'xog' => 'سوگایی',
 				'yao' => 'یائویی',
 				'yap' => 'یاپی',
 				'yav' => 'یانگبنی',
 				'ybb' => 'یمبایی',
 				'yi' => 'یدی',
 				'yo' => 'یوروبایی',
 				'yue' => 'کانتونی',
 				'za' => 'چوانگی',
 				'zap' => 'زاپوتکی',
 				'zen' => 'زناگا',
 				'zgh' => 'آمازیغی معیار مراکش',
 				'zh' => 'چینی',
 				'zh_Hans' => 'چینی ساده‌شده',
 				'zh_Hant' => 'چینی سنتی',
 				'zu' => 'زولویی',
 				'zun' => 'زونیایی',
 				'zxx' => 'بدون محتوای زبانی',
 				'zza' => 'زازایی',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Aghb' => 'آلبانیایی قفقازی',
 			'Arab' => 'عربی',
 			'Arab@alt=variant' => 'فارسی‐عربی',
 			'Armi' => 'آرامی هخامنشی',
 			'Armn' => 'ارمنی',
 			'Avst' => 'اوستایی',
 			'Bali' => 'بالیایی',
 			'Batk' => 'باتاکی',
 			'Beng' => 'بنگالی',
 			'Blis' => 'نمادهای بلیس',
 			'Bopo' => 'بوپوموفو',
 			'Brah' => 'براهمی',
 			'Brai' => 'بریل',
 			'Bugi' => 'بوگیایی',
 			'Buhd' => 'بوهید',
 			'Cakm' => 'چاکمایی',
 			'Cari' => 'کاری',
 			'Cham' => 'چمی',
 			'Cher' => 'چروکیایی',
 			'Cirt' => 'کرت',
 			'Copt' => 'قبطی',
 			'Cprt' => 'قبرسی',
 			'Cyrl' => 'سیریلی',
 			'Deva' => 'دوناگری',
 			'Dsrt' => 'دیسرتی',
 			'Egyh' => 'کاهنی مصری',
 			'Egyp' => 'هیروگلیف مصری',
 			'Ethi' => 'اتیوپیایی',
 			'Geok' => 'گرجی خوتسوری',
 			'Geor' => 'گرجی',
 			'Glag' => 'گلاگولیتی',
 			'Goth' => 'گوتی',
 			'Grek' => 'یونانی',
 			'Gujr' => 'گجراتی',
 			'Guru' => 'گورومخی',
 			'Hanb' => 'هانبی',
 			'Hang' => 'هانگول',
 			'Hani' => 'هان',
 			'Hano' => 'هانونویی',
 			'Hans' => 'ساده‌شده',
 			'Hans@alt=stand-alone' => 'هان ساده‌شده',
 			'Hant' => 'سنتی',
 			'Hant@alt=stand-alone' => 'هان سنتی',
 			'Hebr' => 'عبری',
 			'Hira' => 'هیراگانا',
 			'Hluw' => 'هیروگلیف آناتولی',
 			'Hrkt' => 'سیلابی‌های ژاپنی',
 			'Hung' => 'مجاری باستان',
 			'Inds' => 'ایندوس',
 			'Ital' => 'ایتالی باستان',
 			'Jamo' => 'جامو',
 			'Java' => 'جاوه‌ای',
 			'Jpan' => 'ژاپنی',
 			'Kali' => 'کایالی',
 			'Kana' => 'کاتاکانا',
 			'Khmr' => 'خمری',
 			'Khoj' => 'خواجکی',
 			'Knda' => 'کانارا',
 			'Kore' => 'کره‌ای',
 			'Kthi' => 'کثی',
 			'Lana' => 'لانایی',
 			'Laoo' => 'لائوسی',
 			'Latf' => 'لاتینی فراکتور',
 			'Latg' => 'لاتینی گیلی',
 			'Latn' => 'لاتینی',
 			'Limb' => 'لیمبایی',
 			'Lina' => 'خطی الف',
 			'Linb' => 'خطی ب',
 			'Lyci' => 'لسیایی',
 			'Lydi' => 'لدیایی',
 			'Mand' => 'منده‌ای',
 			'Mani' => 'مانوی',
 			'Maya' => 'هیروگلیف مایایی',
 			'Mero' => 'مروییتی',
 			'Mlym' => 'مالایالامی',
 			'Mong' => 'مغولی',
 			'Moon' => 'مونی',
 			'Mtei' => 'مایک میتی',
 			'Mymr' => 'میانمار',
 			'Narb' => 'عربی شمالی باستان',
 			'Nbat' => 'نبطی',
 			'Ogam' => 'اوگامی',
 			'Orkh' => 'اورخونی',
 			'Orya' => 'اوریه‌ای',
 			'Palm' => 'پالمیرایی',
 			'Perm' => 'پرمی باستان',
 			'Phli' => 'پهلوی کتیبه‌ای',
 			'Phlp' => 'پهلوی زبوری',
 			'Phlv' => 'پهلوی کتابی',
 			'Phnx' => 'فنیقی',
 			'Prti' => 'پارتی کتیبه‌ای',
 			'Rjng' => 'رجنگی',
 			'Runr' => 'رونی',
 			'Samr' => 'سامری',
 			'Sara' => 'ساراتی',
 			'Sarb' => 'عربی جنوبی باستان',
 			'Saur' => 'سوراشترایی',
 			'Shaw' => 'شاوی',
 			'Sinh' => 'سینهالی',
 			'Sylo' => 'سیلوتی نگاری',
 			'Syrc' => 'سریانی',
 			'Syre' => 'سریانی سطرنجیلی',
 			'Syrj' => 'سریانی غربی',
 			'Syrn' => 'سریانی شرقی',
 			'Tagb' => 'تگبنوایی',
 			'Taml' => 'تامیلی',
 			'Telu' => 'تلوگویی',
 			'Teng' => 'تنگوار',
 			'Tfng' => 'تیفیناغی',
 			'Tglg' => 'تاگالوگی',
 			'Thaa' => 'تانه‌ای',
 			'Thai' => 'تایلندی',
 			'Tibt' => 'تبتی',
 			'Ugar' => 'اوگاریتی',
 			'Vaii' => 'ویایی',
 			'Visp' => 'گفتار قابل مشاهده',
 			'Xpeo' => 'فارسی باستان',
 			'Xsux' => 'میخی سومری‐اکدی',
 			'Yiii' => 'یی',
 			'Zinh' => 'موروثی',
 			'Zmth' => 'علائم ریاضی',
 			'Zsye' => 'اموجی',
 			'Zsym' => 'علائم',
 			'Zxxx' => 'نانوشته',
 			'Zyyy' => 'مشترک',
 			'Zzzz' => 'خط نامشخص',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'جهان',
 			'002' => 'افریقا',
 			'003' => 'امریکای شمالی',
 			'005' => 'امریکای جنوبی',
 			'009' => 'اقیانوسیه',
 			'011' => 'غرب افریقا',
 			'013' => 'امریکای مرکزی',
 			'014' => 'شرق افریقا',
 			'015' => 'شمال افریقا',
 			'017' => 'مرکز افریقا',
 			'018' => 'جنوب افریقا',
 			'019' => 'امریکا',
 			'021' => 'شمال امریکا',
 			'029' => 'کارائیب',
 			'030' => 'شرق آسیا',
 			'034' => 'جنوب آسیا',
 			'035' => 'جنوب شرق آسیا',
 			'039' => 'جنوب اروپا',
 			'053' => 'استرالزی',
 			'054' => 'ملانزی',
 			'057' => 'ناحیهٔ میکرونزی',
 			'061' => 'پلی‌نزی',
 			'142' => 'آسیا',
 			'143' => 'آسیای مرکزی',
 			'145' => 'غرب آسیا',
 			'150' => 'اروپا',
 			'151' => 'شرق اروپا',
 			'154' => 'شمال اروپا',
 			'155' => 'غرب اروپا',
 			'202' => 'افریقای سیاه',
 			'419' => 'امریکای لاتین',
 			'AC' => 'جزایر آسنسیون',
 			'AD' => 'آندورا',
 			'AE' => 'امارات متحدهٔ عربی',
 			'AF' => 'افغانستان',
 			'AG' => 'آنتیگوا و باربودا',
 			'AI' => 'آنگویلا',
 			'AL' => 'آلبانی',
 			'AM' => 'ارمنستان',
 			'AO' => 'آنگولا',
 			'AQ' => 'جنوبگان',
 			'AR' => 'آرژانتین',
 			'AS' => 'ساموآی امریکا',
 			'AT' => 'اتریش',
 			'AU' => 'استرالیا',
 			'AW' => 'آروبا',
 			'AX' => 'جزایر آلاند',
 			'AZ' => 'جمهوری آذربایجان',
 			'BA' => 'بوسنی و هرزگوین',
 			'BB' => 'باربادوس',
 			'BD' => 'بنگلادش',
 			'BE' => 'بلژیک',
 			'BF' => 'بورکینافاسو',
 			'BG' => 'بلغارستان',
 			'BH' => 'بحرین',
 			'BI' => 'بوروندی',
 			'BJ' => 'بنین',
 			'BL' => 'سن بارتلمی',
 			'BM' => 'برمودا',
 			'BN' => 'برونئی',
 			'BO' => 'بولیوی',
 			'BQ' => 'جزایر کارائیب هلند',
 			'BR' => 'برزیل',
 			'BS' => 'باهاما',
 			'BT' => 'بوتان',
 			'BV' => 'جزیرهٔ بووه',
 			'BW' => 'بوتسوانا',
 			'BY' => 'بلاروس',
 			'BZ' => 'بلیز',
 			'CA' => 'کانادا',
 			'CC' => 'جزایر کوکوس',
 			'CD' => 'کنگو - کینشاسا',
 			'CD@alt=variant' => 'کنگو (جمهوری دموکراتیک)',
 			'CF' => 'جمهوری افریقای مرکزی',
 			'CG' => 'کنگو - برازویل',
 			'CG@alt=variant' => 'کنگو (جمهوری)',
 			'CH' => 'سوئیس',
 			'CI' => 'ساحل عاج',
 			'CI@alt=variant' => 'ساحل‌عاج',
 			'CK' => 'جزایر کوک',
 			'CL' => 'شیلی',
 			'CM' => 'کامرون',
 			'CN' => 'چین',
 			'CO' => 'کلمبیا',
 			'CP' => 'جزایر کلیپرتون',
 			'CR' => 'کاستاریکا',
 			'CU' => 'کوبا',
 			'CV' => 'کیپ‌ورد',
 			'CW' => 'کوراسائو',
 			'CX' => 'جزیرهٔ کریسمس',
 			'CY' => 'قبرس',
 			'CZ' => 'جمهوری چک',
 			'DE' => 'آلمان',
 			'DG' => 'دیه‌گو گارسیا',
 			'DJ' => 'جیبوتی',
 			'DK' => 'دانمارک',
 			'DM' => 'دومینیکا',
 			'DO' => 'جمهوری دومینیکن',
 			'DZ' => 'الجزایر',
 			'EA' => 'سبته و ملیله',
 			'EC' => 'اکوادور',
 			'EE' => 'استونی',
 			'EG' => 'مصر',
 			'EH' => 'صحرای غربی',
 			'ER' => 'اریتره',
 			'ES' => 'اسپانیا',
 			'ET' => 'اتیوپی',
 			'EU' => 'اتحادیهٔ اروپا',
 			'EZ' => 'منطقه یورو',
 			'FI' => 'فنلاند',
 			'FJ' => 'فیجی',
 			'FK' => 'جزایر فالکلند',
 			'FK@alt=variant' => 'جزایر فالکلند (ایسلاس مالویناس)',
 			'FM' => 'میکرونزی',
 			'FO' => 'جزایر فارو',
 			'FR' => 'فرانسه',
 			'GA' => 'گابن',
 			'GB' => 'بریتانیا',
 			'GB@alt=short' => 'بریتانیا',
 			'GD' => 'گرنادا',
 			'GE' => 'گرجستان',
 			'GF' => 'گویان فرانسه',
 			'GG' => 'گرنزی',
 			'GH' => 'غنا',
 			'GI' => 'جبل‌الطارق',
 			'GL' => 'گرینلند',
 			'GM' => 'گامبیا',
 			'GN' => 'گینه',
 			'GP' => 'گوادلوپ',
 			'GQ' => 'گینهٔ استوایی',
 			'GR' => 'یونان',
 			'GS' => 'جزایر جورجیای جنوبی و ساندویچ جنوبی',
 			'GT' => 'گواتمالا',
 			'GU' => 'گوام',
 			'GW' => 'گینهٔ بیسائو',
 			'GY' => 'گویان',
 			'HK' => 'هنگ‌کنگ، منطقۀ ویژۀ اداری چین',
 			'HK@alt=short' => 'هنگ‌کنگ',
 			'HM' => 'جزیرهٔ هرد و جزایر مک‌دونالد',
 			'HN' => 'هندوراس',
 			'HR' => 'کرواسی',
 			'HT' => 'هائیتی',
 			'HU' => 'مجارستان',
 			'IC' => 'جزایر قناری',
 			'ID' => 'اندونزی',
 			'IE' => 'ایرلند',
 			'IL' => 'اسرائیل',
 			'IM' => 'جزیرهٔ من',
 			'IN' => 'هند',
 			'IO' => 'قلمرو بریتانیا در اقیانوس هند',
 			'IQ' => 'عراق',
 			'IR' => 'ایران',
 			'IS' => 'ایسلند',
 			'IT' => 'ایتالیا',
 			'JE' => 'جرزی',
 			'JM' => 'جامائیکا',
 			'JO' => 'اردن',
 			'JP' => 'ژاپن',
 			'KE' => 'کنیا',
 			'KG' => 'قرقیزستان',
 			'KH' => 'کامبوج',
 			'KI' => 'کیریباتی',
 			'KM' => 'کومور',
 			'KN' => 'سنت کیتس و نویس',
 			'KP' => 'کرهٔ شمالی',
 			'KR' => 'کرهٔ جنوبی',
 			'KW' => 'کویت',
 			'KY' => 'جزایر کِیمن',
 			'KZ' => 'قزاقستان',
 			'LA' => 'لائوس',
 			'LB' => 'لبنان',
 			'LC' => 'سنت لوسیا',
 			'LI' => 'لیختن‌اشتاین',
 			'LK' => 'سری‌لانکا',
 			'LR' => 'لیبریا',
 			'LS' => 'لسوتو',
 			'LT' => 'لیتوانی',
 			'LU' => 'لوکزامبورگ',
 			'LV' => 'لتونی',
 			'LY' => 'لیبی',
 			'MA' => 'مراکش',
 			'MC' => 'موناکو',
 			'MD' => 'مولداوی',
 			'ME' => 'مونته‌نگرو',
 			'MF' => 'سنت مارتین',
 			'MG' => 'ماداگاسکار',
 			'MH' => 'جزایر مارشال',
 			'MK' => 'مقدونیه',
 			'MK@alt=variant' => 'مقدونیه (جمهوری سابقاً یوگسلاو)',
 			'ML' => 'مالی',
 			'MM' => 'میانمار (برمه)',
 			'MN' => 'مغولستان',
 			'MO' => 'ماکائو، منطقۀ ویژۀ اداری چین',
 			'MO@alt=short' => 'ماکائو',
 			'MP' => 'جزایر ماریانای شمالی',
 			'MQ' => 'مارتینیک',
 			'MR' => 'موریتانی',
 			'MS' => 'مونت‌سرات',
 			'MT' => 'مالت',
 			'MU' => 'موریس',
 			'MV' => 'مالدیو',
 			'MW' => 'مالاوی',
 			'MX' => 'مکزیک',
 			'MY' => 'مالزی',
 			'MZ' => 'موزامبیک',
 			'NA' => 'نامیبیا',
 			'NC' => 'کالدونیای جدید',
 			'NE' => 'نیجر',
 			'NF' => 'جزیرهٔ نورفولک',
 			'NG' => 'نیجریه',
 			'NI' => 'نیکاراگوئه',
 			'NL' => 'هلند',
 			'NO' => 'نروژ',
 			'NP' => 'نپال',
 			'NR' => 'نائورو',
 			'NU' => 'نیوئه',
 			'NZ' => 'نیوزیلند',
 			'OM' => 'عمان',
 			'PA' => 'پاناما',
 			'PE' => 'پرو',
 			'PF' => 'پلی‌نزی فرانسه',
 			'PG' => 'پاپوا گینهٔ نو',
 			'PH' => 'فیلیپین',
 			'PK' => 'پاکستان',
 			'PL' => 'لهستان',
 			'PM' => 'سن پیر و میکلن',
 			'PN' => 'جزایر پیت‌کرن',
 			'PR' => 'پورتوریکو',
 			'PS' => 'سرزمین‌های فلسطینی',
 			'PS@alt=short' => 'فلسطین',
 			'PT' => 'پرتغال',
 			'PW' => 'پالائو',
 			'PY' => 'پاراگوئه',
 			'QA' => 'قطر',
 			'QO' => 'بخش‌های دورافتادهٔ اقیانوسیه',
 			'RE' => 'رئونیون',
 			'RO' => 'رومانی',
 			'RS' => 'صربستان',
 			'RU' => 'روسیه',
 			'RW' => 'رواندا',
 			'SA' => 'عربستان سعودی',
 			'SA@alt=short' => 'عربستان',
 			'SB' => 'جزایر سلیمان',
 			'SC' => 'سیشل',
 			'SD' => 'سودان',
 			'SE' => 'سوئد',
 			'SG' => 'سنگاپور',
 			'SH' => 'سنت هلن',
 			'SI' => 'اسلوونی',
 			'SJ' => 'اسوالبارد و جان‌ماین',
 			'SK' => 'اسلواکی',
 			'SL' => 'سیرالئون',
 			'SM' => 'سان‌مارینو',
 			'SN' => 'سنگال',
 			'SO' => 'سومالی',
 			'SR' => 'سورینام',
 			'SS' => 'سودان جنوبی',
 			'ST' => 'سائوتومه و پرینسیپ',
 			'SV' => 'السالوادور',
 			'SX' => 'سنت مارتن',
 			'SY' => 'سوریه',
 			'SZ' => 'سوازیلند',
 			'TA' => 'تریستان دا کونا',
 			'TC' => 'جزایر تورکس و کایکوس',
 			'TD' => 'چاد',
 			'TF' => 'سرزمین‌های جنوب فرانسه',
 			'TG' => 'توگو',
 			'TH' => 'تایلند',
 			'TJ' => 'تاجیکستان',
 			'TK' => 'توکلائو',
 			'TL' => 'تیمور-لسته',
 			'TL@alt=variant' => 'تیمور شرقی',
 			'TM' => 'ترکمنستان',
 			'TN' => 'تونس',
 			'TO' => 'تونگا',
 			'TR' => 'ترکیه',
 			'TT' => 'ترینیداد و توباگو',
 			'TV' => 'تووالو',
 			'TW' => 'تایوان',
 			'TZ' => 'تانزانیا',
 			'UA' => 'اوکراین',
 			'UG' => 'اوگاندا',
 			'UM' => 'جزایر دورافتادهٔ ایالات متحده',
 			'UN' => 'سازمان ملل متحد',
 			'UN@alt=short' => 'سازمان ملل',
 			'US' => 'ایالات متحده',
 			'US@alt=short' => 'ایالات متحده',
 			'UY' => 'اروگوئه',
 			'UZ' => 'ازبکستان',
 			'VA' => 'واتیکان',
 			'VC' => 'سنت وینسنت و گرنادین',
 			'VE' => 'ونزوئلا',
 			'VG' => 'جزایر ویرجین بریتانیا',
 			'VI' => 'جزایر ویرجین ایالات متحده',
 			'VN' => 'ویتنام',
 			'VU' => 'وانواتو',
 			'WF' => 'والیس و فوتونا',
 			'WS' => 'ساموآ',
 			'XK' => 'کوزوو',
 			'YE' => 'یمن',
 			'YT' => 'مایوت',
 			'ZA' => 'افریقای جنوبی',
 			'ZM' => 'زامبیا',
 			'ZW' => 'زیمبابوه',
 			'ZZ' => 'ناحیهٔ نامشخص',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'رسم‌الخط سنتی آلمانی',
 			'1996' => 'رسم‌الخط آلمانی ۱۹۹۶ میلادی',
 			'AREVELA' => 'ارمنی شرقی',
 			'AREVMDA' => 'ارمنی غربی',
 			'FONIPA' => 'فونتیک IPA',
 			'FONUPA' => 'فونتیک UPA',
 			'POSIX' => 'کامپیوتری',
 			'REVISED' => 'رسم‌الخط تجدیدنظرشده',
 			'ROZAJ' => 'روژان',
 			'SAAHO' => 'ساهویی',
 			'SCOTLAND' => 'انگلیسی معیار اسکاتلند',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'تقویم',
 			'cf' => 'قالب واحد پول',
 			'colalternate' => 'نادیده گرفتن مرتب‌سازی نمادها',
 			'colbackwards' => 'مرتب‌سازی معکوس براساس آکسان',
 			'colcasefirst' => 'ترتیب بر اساس حروف کوچک/بزرگ',
 			'colcaselevel' => 'مرتب‌سازی حساس به اندازه حروف',
 			'collation' => 'ترتیب',
 			'colnormalization' => 'مرتب‌سازی معمولی',
 			'colnumeric' => 'مرتب‌سازی عددی',
 			'colstrength' => 'قدرت مرتب‌سازی',
 			'currency' => 'واحد پول',
 			'hc' => 'دور ساعت (۱۲ در مقابل ۲۴)',
 			'lb' => 'شیوهٔ اعمال سرخط',
 			'ms' => 'دستگاه اندازه‌گیری',
 			'numbers' => 'اعداد',
 			'timezone' => 'منطقهٔ زمانی',
 			'va' => 'متغیر محلی',
 			'x' => 'استفادهٔ خصوصی',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{تقویم بودایی},
 				'chinese' => q{تقویم چینی},
 				'coptic' => q{تقویم قبطی},
 				'dangi' => q{تقویم دانگی},
 				'ethiopic' => q{تقویم اتیوپیایی},
 				'ethiopic-amete-alem' => q{تقویم اتیوپیایی عامت عالم},
 				'gregorian' => q{تقویم میلادی},
 				'hebrew' => q{تقویم عبری},
 				'indian' => q{تقویم ملی هند},
 				'islamic' => q{تقویم هجری قمری},
 				'islamic-civil' => q{تقویم هجری قمری جدولی مدنی},
 				'islamic-rgsa' => q{قویم هجری قمری هلالی عربستان سعودی},
 				'islamic-tbla' => q{تقویم هجری قمری جدولی نجومی},
 				'islamic-umalqura' => q{تقویم هجری قمری ام‌القری},
 				'iso8601' => q{تقویم ایزو ۸۶۰۱},
 				'japanese' => q{تقویم ژاپنی},
 				'persian' => q{تقویم هجری شمسی},
 				'roc' => q{تقویم جمهوری چین (تایوان)},
 			},
 			'cf' => {
 				'account' => q{قالب حسابداری واحد پول},
 				'standard' => q{قالب استاندارد واحد پول},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{مرتب‌سازی نمادها},
 				'shifted' => q{مرتب‌سازی با نادیده گرفتن نمادها},
 			},
 			'colbackwards' => {
 				'no' => q{مرتب‌سازی آکسان‌ها به صورت معمولی},
 				'yes' => q{مرتب‌سازی معکوس براساس آکسان},
 			},
 			'colcasefirst' => {
 				'lower' => q{ابتدا مرتب‌سازی حروف کوچک},
 				'no' => q{مرتب‌سازی به ترتیب معمولی بزرگ و کوچکی حروف},
 				'upper' => q{مرتب‌سازی بر اساس حرف بزرگ در ابتدا},
 			},
 			'colcaselevel' => {
 				'no' => q{مرتب‌سازی بدون توجه به کوچک و بزرگی حروف},
 				'yes' => q{مرتب‌سازی با حساسیت به اندازه حروف},
 			},
 			'collation' => {
 				'big5han' => q{ترتیب چینی سنتی - Big5},
 				'compat' => q{ترتیب پیشین، برای سازگاری},
 				'dictionary' => q{ترتیب فرهنگ لغت},
 				'ducet' => q{ترتیب پیش‌فرض یونی‌کد},
 				'emoji' => q{ترتیب ایموجی},
 				'eor' => q{قوانین ترتیب اروپایی},
 				'gb2312han' => q{ترتیب چینی ساده‌شده - GB2312},
 				'phonebook' => q{ترتیب دفتر تلفن},
 				'phonetic' => q{مرتب کردن بر اساس آوایی},
 				'pinyin' => q{ترتیب پین‌یین},
 				'reformed' => q{ترتیب اصلاح‌شده},
 				'search' => q{جستجوی عمومی},
 				'searchjl' => q{جستجو با صامت اول هانگول},
 				'standard' => q{ترتیب استاندارد},
 				'stroke' => q{ترتیب حرکتی},
 				'traditional' => q{ترتیب سنتی},
 				'unihan' => q{ترتیب رادیکالی-حرکتی},
 			},
 			'colnormalization' => {
 				'no' => q{مرتب‌سازی بدون عادی‌سازی},
 				'yes' => q{مرتب‌سازی یونی‌کد نرمال‌شده},
 			},
 			'colnumeric' => {
 				'no' => q{مرتب‌سازی ارقام بصورت مجزا},
 				'yes' => q{مرتب‌سازی شماره‌ها با سیستم عددی},
 			},
 			'colstrength' => {
 				'identical' => q{مرتب‌سازی همه},
 				'primary' => q{مرتب‌سازی فقط حروف پایه},
 				'quaternary' => q{مرتب‌سازی بر اساس آکسان/اندازه حروف/عرض/کانا},
 				'secondary' => q{مرتب‌سازی آکسان‌ها},
 				'tertiary' => q{مرتب‌سازی بر اساس آکسان/اندازه حرف/عرض},
 			},
 			'd0' => {
 				'fwidth' => q{تمام‌عرض},
 				'hwidth' => q{نیم‌عرض},
 				'npinyin' => q{سیستم اعداد},
 			},
 			'hc' => {
 				'h11' => q{سیستم ۱۲ ساعته (۰ تا ۱۱)},
 				'h12' => q{سیستم ۱۲ ساعته (۱ تا ۱۲)},
 				'h23' => q{سیستم ۲۴ ساعته (۰ تا ۲۳)},
 				'h24' => q{سیستم ۲۴ ساعته (۱ تا ۲۴)},
 			},
 			'lb' => {
 				'loose' => q{شیوهٔ ضعیف اعمال سرخط},
 				'normal' => q{شیوهٔ عادی اعمال سرخط},
 				'strict' => q{شیوهٔ قوی اعمال سرخط},
 			},
 			'm0' => {
 				'bgn' => q{ترانویسی انجمن نام‌های جغرافیایی ایالات متحده},
 				'ungegn' => q{ترانویسی گروه نام‌های جغرافیایی سازمان ملل},
 			},
 			'ms' => {
 				'metric' => q{دستگاه متریک},
 				'uksystem' => q{دستگاه اندازه‌گیری بریتانیایی},
 				'ussystem' => q{دستگاه اندازه‌گیری امریکایی},
 			},
 			'numbers' => {
 				'arab' => q{ارقام عربی},
 				'arabext' => q{ارقام فارسی},
 				'armn' => q{اعداد ارمنی},
 				'armnlow' => q{اعداد ارمنی با حروف کوچک},
 				'bali' => q{ارقام بالیایی},
 				'beng' => q{ارقام بنگالی},
 				'cyrl' => q{ارقام سیریلیک},
 				'deva' => q{ارقام دوناگری},
 				'ethi' => q{اعداد اتیوپیایی},
 				'finance' => q{سیستم عددی مالی},
 				'fullwide' => q{ارقام تمام‌عرض},
 				'geor' => q{اعداد گرجی},
 				'grek' => q{اعداد یونانی},
 				'greklow' => q{اعداد یونانی با حروف کوچک},
 				'gujr' => q{ارقام گجراتی},
 				'guru' => q{ارقام گورومخی},
 				'hanidec' => q{اعداد دهدهی چینی},
 				'hans' => q{اعداد چینی ساده‌شده},
 				'hansfin' => q{اعداد مالی چینی ساده‌شده},
 				'hant' => q{اعداد چینی سنتی},
 				'hantfin' => q{اعداد مالی چینی سنتی},
 				'hebr' => q{اعداد عبری},
 				'java' => q{ارقام جاوه‌ای},
 				'jpan' => q{اعداد ژاپنی},
 				'jpanfin' => q{اعداد مالی ژاپنی},
 				'khmr' => q{ارقام خمری},
 				'knda' => q{ارقام کاناده‌ای},
 				'laoo' => q{ارقام لائوسی},
 				'latn' => q{ارقام غربی},
 				'mlym' => q{ارقام مالایالامی},
 				'mong' => q{ارقام مغولی},
 				'mymr' => q{ارقام میانماری},
 				'mymrshan' => q{ارقام شان میانماری},
 				'native' => q{ارقام بومی},
 				'orya' => q{ارقام اوریه‌ای},
 				'roman' => q{اعداد رومی},
 				'romanlow' => q{اعداد رومی با حروف کوچک},
 				'taml' => q{اعداد سنتی تامیلی},
 				'tamldec' => q{ارقام تامیلی},
 				'telu' => q{ارقام تلوگویی},
 				'thai' => q{ارقام تایلندی},
 				'tibt' => q{ارقام تبتی},
 				'traditional' => q{سیستم اعداد سنتی},
 				'vaii' => q{ارقام وایی},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{متریک},
 			'UK' => q{بریتانیایی},
 			'US' => q{امریکایی},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'زبان: {0}',
 			'script' => 'خط: {0}',
 			'region' => 'ناحیه: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ـ‌‍‎‏ َ ِ ُ ْ ٖ ٰ إ ك ى ي]},
			index => ['آ', 'ا', 'ب', 'پ', 'ت', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ذ', 'ر', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ه', 'ی'],
			main => qr{[ً ٍ ٌ ّ ٔ آ ا ء أ ؤ ئ ب پ ت ث ج چ ح خ د ذ ر ز ژ س ش ص ض ط ظ ع غ ف ق ک گ ل م ن و ه ة ی]},
			numbers => qr{[‎ , ٫ ٬ . % ٪ ‰ ؉ + − 0۰ 1۱ 2۲ 3۳ 4۴ 5۵ 6۶ 7۷ 8۸ 9۹]},
			punctuation => qr{[\- ‐ ، ٫ ٬ ؛ \: ! ؟ . … ‹ › « » ( ) \[ \] * / \\]},
		};
	},
EOT
: sub {
		return { index => ['آ', 'ا', 'ب', 'پ', 'ت', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ذ', 'ر', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ه', 'ی'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{؟},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‹},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{›},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'' => {
						'name' => q(جهت اصلی),
					},
					'acre' => {
						'name' => q(جریب),
						'one' => q({0} جریب),
						'other' => q({0} جریب),
					},
					'acre-foot' => {
						'name' => q(جریب فوت),
						'one' => q({0} جریب فوت),
						'other' => q({0} جریب فوت),
					},
					'ampere' => {
						'name' => q(آمپر),
						'one' => q({0} آمپر),
						'other' => q({0} آمپر),
					},
					'arc-minute' => {
						'name' => q(دقیقهٔ قوسی),
						'one' => q({0} دقیقهٔ قوسی),
						'other' => q({0} دقیقهٔ قوسی),
					},
					'arc-second' => {
						'name' => q(ثانیهٔ قوسی),
						'one' => q({0} ثانیهٔ قوسی),
						'other' => q({0} ثانیهٔ قوسی),
					},
					'astronomical-unit' => {
						'name' => q(واحد نجومی),
						'one' => q({0} واحد نجومی),
						'other' => q({0} واحد نجومی),
					},
					'atmosphere' => {
						'name' => q(اتمسفر),
						'one' => q({0} اتمسفر),
						'other' => q({0} اتمسفر),
					},
					'bit' => {
						'name' => q(بیت),
						'one' => q({0} بیت),
						'other' => q({0} بیت),
					},
					'byte' => {
						'name' => q(بایت),
						'one' => q({0} بایت),
						'other' => q({0} بایت),
					},
					'calorie' => {
						'name' => q(کالری),
						'one' => q({0} کالری),
						'other' => q({0} کالری),
					},
					'carat' => {
						'name' => q(قیراط),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					'celsius' => {
						'name' => q(درجهٔ سلسیوس),
						'one' => q({0} درجهٔ سلسیوس),
						'other' => q({0} درجهٔ سلسیوس),
					},
					'centiliter' => {
						'name' => q(سانتی‌لیتر),
						'one' => q({0} سانتی‌لیتر),
						'other' => q({0} سانتی‌لیتر),
					},
					'centimeter' => {
						'name' => q(سانتی‌متر),
						'one' => q({0} سانتی‌متر),
						'other' => q({0} سانتی‌متر),
						'per' => q({0}/سانتی‌متر),
					},
					'century' => {
						'name' => q(سده),
						'one' => q({0} سده),
						'other' => q({0} سده),
					},
					'coordinate' => {
						'east' => q({0} شرقی),
						'north' => q({0} شمالی),
						'south' => q({0} جنوبی),
						'west' => q({0} غربی),
					},
					'cubic-centimeter' => {
						'name' => q(سانتی‌متر مکعب),
						'one' => q({0} سانتی‌متر مکعب),
						'other' => q({0} سانتی‌متر مکعب),
						'per' => q({0} در سانتی‌متر مکعب),
					},
					'cubic-foot' => {
						'name' => q(فوت مکعب),
						'one' => q({0} فوت مکعب),
						'other' => q({0} فوت مکعب),
					},
					'cubic-inch' => {
						'name' => q(اینچ مکعب),
						'one' => q({0} اینچ مکعب),
						'other' => q({0} اینچ مکعب),
					},
					'cubic-kilometer' => {
						'name' => q(کیلومتر مکعب),
						'one' => q({0} کیلومتر مکعب),
						'other' => q({0} کیلومتر مکعب),
					},
					'cubic-meter' => {
						'name' => q(متر مکعب),
						'one' => q({0} متر مکعب),
						'other' => q({0} متر مکعب),
						'per' => q({0} در متر مکعب),
					},
					'cubic-mile' => {
						'name' => q(مایل مکعب),
						'one' => q({0} مایل مکعب),
						'other' => q({0} مایل مکعب),
					},
					'cubic-yard' => {
						'name' => q(یارد مکعب),
						'one' => q({0} یارد مکعب),
						'other' => q({0} یارد مکعب),
					},
					'cup' => {
						'name' => q(پیمانه),
						'one' => q({0} پیمانه),
						'other' => q({0} پیمانه),
					},
					'cup-metric' => {
						'name' => q(پیمانهٔ متریک),
						'one' => q({0} پیمانهٔ متریک),
						'other' => q({0} پیمانهٔ متریک),
					},
					'day' => {
						'name' => q(روز),
						'one' => q({0} روز),
						'other' => q({0} روز),
						'per' => q({0} در روز),
					},
					'deciliter' => {
						'name' => q(دسی‌لیتر),
						'one' => q({0} دسی‌لیتر),
						'other' => q({0} دسی‌لیتر),
					},
					'decimeter' => {
						'name' => q(دسی‌متر),
						'one' => q({0} دسی‌متر),
						'other' => q({0} دسی‌متر),
					},
					'degree' => {
						'name' => q(درجه),
						'one' => q({0} درجه),
						'other' => q({0} درجه),
					},
					'fahrenheit' => {
						'name' => q(درجهٔ فارنهایت),
						'one' => q({0} درجهٔ فارنهایت),
						'other' => q({0} درجهٔ فارنهایت),
					},
					'fluid-ounce' => {
						'name' => q(اونس سیال),
						'one' => q({0} اونس سیال),
						'other' => q({0} اونس سیال),
					},
					'foodcalorie' => {
						'name' => q(کالری),
						'one' => q({0} کالری),
						'other' => q({0} کالری),
					},
					'foot' => {
						'name' => q(فوت),
						'one' => q({0} فوت),
						'other' => q({0} فوت),
						'per' => q({0}/فوت),
					},
					'g-force' => {
						'name' => q(نیروی جاذبه),
						'one' => q({0} نیروی جاذبه),
						'other' => q({0} جاذبه),
					},
					'gallon' => {
						'name' => q(گالن),
						'one' => q({0} گالن),
						'other' => q({0} گالن),
						'per' => q({0} در گالن),
					},
					'gallon-imperial' => {
						'name' => q(گالن امپریال),
						'one' => q({0} گالن امپریال),
						'other' => q({0} گالن امپریال),
						'per' => q({0} در گالن امپریال),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(گیگابیت),
						'one' => q({0} گیگابیت),
						'other' => q({0} گیگابیت),
					},
					'gigabyte' => {
						'name' => q(گیگابایت),
						'one' => q({0} گیگابایت),
						'other' => q({0} گیگابایت),
					},
					'gigahertz' => {
						'name' => q(گیگاهرتز),
						'one' => q({0} گیگاهرتز),
						'other' => q({0} گیگاهرتز),
					},
					'gigawatt' => {
						'name' => q(گیگاوات),
						'one' => q({0} گیگاوات),
						'other' => q({0} گیگاوات),
					},
					'gram' => {
						'name' => q(گرم),
						'one' => q({0} گرم),
						'other' => q({0} گرم),
						'per' => q({0} در گرم),
					},
					'hectare' => {
						'name' => q(هکتار),
						'one' => q({0} هکتار),
						'other' => q({0} هکتار),
					},
					'hectoliter' => {
						'name' => q(هکتولیتر),
						'one' => q({0} هکتولیتر),
						'other' => q({0} هکتولیتر),
					},
					'hectopascal' => {
						'name' => q(هکتوپاسکال),
						'one' => q({0} هکتوپاسکال),
						'other' => q({0} هکتوپاسکال),
					},
					'hertz' => {
						'name' => q(هرتز),
						'one' => q({0} هرتز),
						'other' => q({0} هرتز),
					},
					'horsepower' => {
						'name' => q(اسب بخار),
						'one' => q({0} اسب بخار),
						'other' => q({0} اسب بخار),
					},
					'hour' => {
						'name' => q(ساعت),
						'one' => q({0} ساعت),
						'other' => q({0} ساعت),
						'per' => q({0} در ساعت),
					},
					'inch' => {
						'name' => q(اینچ),
						'one' => q({0} اینچ),
						'other' => q({0} اینچ),
						'per' => q({0}/اینچ),
					},
					'inch-hg' => {
						'name' => q(اینچ جیوه),
						'one' => q({0} اینچ جیوه),
						'other' => q({0} اینچ جیوه),
					},
					'joule' => {
						'name' => q(ژول),
						'one' => q({0} ژول),
						'other' => q({0} ژول),
					},
					'karat' => {
						'name' => q(عیار),
						'one' => q({0} عیار),
						'other' => q({0} عیار),
					},
					'kelvin' => {
						'name' => q(درجهٔ کلوین),
						'one' => q({0} درجهٔ کلوین),
						'other' => q({0} درجهٔ کلوین),
					},
					'kilobit' => {
						'name' => q(کیلوبیت),
						'one' => q({0} کیلوبیت),
						'other' => q({0} کیلوبیت),
					},
					'kilobyte' => {
						'name' => q(کیلوبایت),
						'one' => q({0} کیلوبایت),
						'other' => q({0} کیلوبایت),
					},
					'kilocalorie' => {
						'name' => q(کیلوکالری),
						'one' => q({0} کیلوکالری),
						'other' => q({0} کیلوکالری),
					},
					'kilogram' => {
						'name' => q(کیلوگرم),
						'one' => q({0} کیلوگرم),
						'other' => q({0} کیلوگرم),
						'per' => q({0} در کیلوگرم),
					},
					'kilohertz' => {
						'name' => q(کیلوهرتز),
						'one' => q({0} کیلوهرتز),
						'other' => q({0} کیلوهرتز),
					},
					'kilojoule' => {
						'name' => q(کیلوژول),
						'one' => q({0} کیلوژول),
						'other' => q({0} کیلوژول),
					},
					'kilometer' => {
						'name' => q(کیلومتر),
						'one' => q({0} کیلومتر),
						'other' => q({0} کیلومتر),
						'per' => q({0}/کیلومتر),
					},
					'kilometer-per-hour' => {
						'name' => q(کیلومتر در ساعت),
						'one' => q({0} کیلومتر در ساعت),
						'other' => q({0} کیلومتر در ساعت),
					},
					'kilowatt' => {
						'name' => q(کیلووات),
						'one' => q({0} کیلووات),
						'other' => q({0} کیلووات),
					},
					'kilowatt-hour' => {
						'name' => q(کیلووات‌ساعت),
						'one' => q({0} کیلووات‌ساعت),
						'other' => q({0} کیلووات‌ساعت),
					},
					'knot' => {
						'name' => q(گره),
						'one' => q({0} گره),
						'other' => q({0} گره),
					},
					'light-year' => {
						'name' => q(سال نوری),
						'one' => q({0} سال نوری),
						'other' => q({0} سال نوری),
					},
					'liter' => {
						'name' => q(لیتر),
						'one' => q({0} لیتر),
						'other' => q({0} لیتر),
						'per' => q({0} در لیتر),
					},
					'liter-per-100kilometers' => {
						'name' => q(لیتر در ۱۰۰ کیلومتر),
						'one' => q({0} لیتر در ۱۰۰ کیلومتر),
						'other' => q({0} لیتر در ۱۰۰ کیلومتر),
					},
					'liter-per-kilometer' => {
						'name' => q(لیتر در کیلومتر),
						'one' => q({0} لیتر در کیلومتر),
						'other' => q({0} لیتر در کیلومتر),
					},
					'lux' => {
						'name' => q(لوکس),
						'one' => q({0} لوکس),
						'other' => q({0} لوکس),
					},
					'megabit' => {
						'name' => q(مگابیت),
						'one' => q({0} مگابیت),
						'other' => q({0} مگابیت),
					},
					'megabyte' => {
						'name' => q(مگابایت),
						'one' => q({0} مگابایت),
						'other' => q({0} مگابایت),
					},
					'megahertz' => {
						'name' => q(مگاهرتز),
						'one' => q({0} مگاهرتز),
						'other' => q({0} مگاهرتز),
					},
					'megaliter' => {
						'name' => q(مگالیتر),
						'one' => q({0} مگالیتر),
						'other' => q({0} مگالیتر),
					},
					'megawatt' => {
						'name' => q(مگاوات),
						'one' => q({0} مگاوات),
						'other' => q({0} مگاوات),
					},
					'meter' => {
						'name' => q(متر),
						'one' => q({0} متر),
						'other' => q({0} متر),
						'per' => q({0}/متر),
					},
					'meter-per-second' => {
						'name' => q(متر در ثانیه),
						'one' => q({0} متر در ثانیه),
						'other' => q({0} متر در ثانیه),
					},
					'meter-per-second-squared' => {
						'name' => q(متر بر مجذور ثانیه),
						'one' => q({0} متر بر مجذور ثانیه),
						'other' => q({0} متر بر مجذور ثانیه),
					},
					'metric-ton' => {
						'name' => q(تن متریک),
						'one' => q({0} تن متریک),
						'other' => q({0} تن متریک),
					},
					'microgram' => {
						'name' => q(میکروگرم),
						'one' => q({0} میکروگرم),
						'other' => q({0} میکروگرم),
					},
					'micrometer' => {
						'name' => q(میکرومتر),
						'one' => q({0} میکرومتر),
						'other' => q({0} میکرومتر),
					},
					'microsecond' => {
						'name' => q(میکروثانیه),
						'one' => q({0} میکروثانیه),
						'other' => q({0} میکروثانیه),
					},
					'mile' => {
						'name' => q(مایل),
						'one' => q({0} مایل),
						'other' => q({0} مایل),
					},
					'mile-per-gallon' => {
						'name' => q(مایل در گالن),
						'one' => q({0} مایل در گالن),
						'other' => q({0} مایل در گالن),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(مایل در امپریال گالن),
						'one' => q({0} مایل در امپریال گالن),
						'other' => q({0} مایل در امپریال گالن),
					},
					'mile-per-hour' => {
						'name' => q(مایل در ساعت),
						'one' => q({0} مایل در ساعت),
						'other' => q({0} مایل در ساعت),
					},
					'mile-scandinavian' => {
						'name' => q(مایل اسکاندیناوی),
						'one' => q({0} مایل اسکاندیناوی),
						'other' => q({0} مایل اسکاندیناوی),
					},
					'milliampere' => {
						'name' => q(میلی‌آمپر),
						'one' => q({0} میلی‌آمپر),
						'other' => q({0} میلی‌آمپر),
					},
					'millibar' => {
						'name' => q(میلی‌بار),
						'one' => q({0} میلی‌بار),
						'other' => q({0} میلی‌بار),
					},
					'milligram' => {
						'name' => q(میلی‌گرم),
						'one' => q({0} میلی‌گرم),
						'other' => q({0} میلی‌گرم),
					},
					'milligram-per-deciliter' => {
						'name' => q(میلی‌گرم در دسی‌لیتر),
						'one' => q({0} میلی‌گرم در دسی‌لیتر),
						'other' => q({0} میلی‌گرم در دسی‌لیتر),
					},
					'milliliter' => {
						'name' => q(میلی‌لیتر),
						'one' => q({0} میلی‌لیتر),
						'other' => q({0} میلی‌لیتر),
					},
					'millimeter' => {
						'name' => q(میلی‌متر),
						'one' => q({0} میلی‌متر),
						'other' => q({0} میلی‌متر),
					},
					'millimeter-of-mercury' => {
						'name' => q(میلی‌متر جیوه),
						'one' => q({0} میلی‌متر جیوه),
						'other' => q({0} میلی‌متر جیوه),
					},
					'millimole-per-liter' => {
						'name' => q(میلی‌مول در لیتر),
						'one' => q({0} میلی‌مول در لیتر),
						'other' => q({0} میلی‌مول در لیتر),
					},
					'millisecond' => {
						'name' => q(میلی‌ثانیه),
						'one' => q({0} میلی‌ثانیه),
						'other' => q({0} میلی‌ثانیه),
					},
					'milliwatt' => {
						'name' => q(میلی‌وات),
						'one' => q({0} میلی‌وات),
						'other' => q({0} میلی‌وات),
					},
					'minute' => {
						'name' => q(دقیقه),
						'one' => q({0} دقیقه),
						'other' => q({0} دقیقه),
						'per' => q({0} در دقیقه),
					},
					'month' => {
						'name' => q(ماه),
						'one' => q({0} ماه),
						'other' => q({0} ماه),
						'per' => q({0} در ماه),
					},
					'nanometer' => {
						'name' => q(نانومتر),
						'one' => q({0} نانومتر),
						'other' => q({0} نانومتر),
					},
					'nanosecond' => {
						'name' => q(نانوثانیه),
						'one' => q({0} نانوثانیه),
						'other' => q({0} نانوثانیه),
					},
					'nautical-mile' => {
						'name' => q(مایل دریایی),
						'one' => q({0} مایل دریایی),
						'other' => q({0} مایل دریایی),
					},
					'ohm' => {
						'name' => q(اهم),
						'one' => q({0} اهم),
						'other' => q({0} اهم),
					},
					'ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} در اونس),
					},
					'ounce-troy' => {
						'name' => q(اونس تروا),
						'one' => q({0} اونس تروا),
						'other' => q({0} اونس تروا),
					},
					'parsec' => {
						'name' => q(پارسک),
						'one' => q({0} پارسک),
						'other' => q({0} پارسک),
					},
					'part-per-million' => {
						'name' => q(بخش در میلیون),
						'one' => q({0} بخش در میلیون),
						'other' => q({0} بخش در میلیون),
					},
					'per' => {
						'1' => q({0} در {1}),
					},
					'percent' => {
						'name' => q(درصد),
						'one' => q({0} درصد),
						'other' => q({0} درصد),
					},
					'permille' => {
						'name' => q(هزارم),
						'one' => q({0} هزارم),
						'other' => q({0} هزارم),
					},
					'petabyte' => {
						'name' => q(پتابایت),
						'one' => q({0} پتابایت),
						'other' => q({0} پتابایت),
					},
					'picometer' => {
						'name' => q(پیکومتر),
						'one' => q({0} پیکومتر),
						'other' => q({0} پیکومتر),
					},
					'pint' => {
						'name' => q(پاینت),
						'one' => q({0} پاینت),
						'other' => q({0} پاینت),
					},
					'pint-metric' => {
						'name' => q(پاینت متریک),
						'one' => q({0} پاینت متریک),
						'other' => q({0} پاینت متریک),
					},
					'point' => {
						'name' => q(امتیاز),
						'one' => q({0} امتیاز),
						'other' => q({0} امتیاز),
					},
					'pound' => {
						'name' => q(پوند),
						'one' => q({0} پوند),
						'other' => q({0} پوند),
						'per' => q({0} در پوند),
					},
					'pound-per-square-inch' => {
						'name' => q(پوند در اینچ مربع),
						'one' => q({0} پوند در اینچ مربع),
						'other' => q({0} پوند در اینچ مربع),
					},
					'quart' => {
						'name' => q(کوارت),
						'one' => q({0} کوارت),
						'other' => q({0} کوارت),
					},
					'radian' => {
						'name' => q(رادیان),
						'one' => q({0} رادیان),
						'other' => q({0} رادیان),
					},
					'revolution' => {
						'name' => q(دور),
						'one' => q({0} دور),
						'other' => q({0} دور),
					},
					'second' => {
						'name' => q(ثانیه),
						'one' => q({0} ثانیه),
						'other' => q({0} ثانیه),
						'per' => q({0} در ثانیه),
					},
					'square-centimeter' => {
						'name' => q(سانتی‌متر مربع),
						'one' => q({0} سانتی‌متر مربع),
						'other' => q({0} سانتی‌متر مربع),
						'per' => q({0} در سانتی‌متر مربع),
					},
					'square-foot' => {
						'name' => q(فوت مربع),
						'one' => q({0} فوت مربع),
						'other' => q({0} فوت مربع),
					},
					'square-inch' => {
						'name' => q(اینچ مربع),
						'one' => q({0} اینچ مربع),
						'other' => q({0} اینچ مربع),
						'per' => q({0} در اینچ مربع),
					},
					'square-kilometer' => {
						'name' => q(کیلومتر مربع),
						'one' => q({0} کیلومتر مربع),
						'other' => q({0} کیلومتر مربع),
						'per' => q(کیلومتر مربع در {0}),
					},
					'square-meter' => {
						'name' => q(متر مربع),
						'one' => q({0} متر مربع),
						'other' => q({0} متر مربع),
						'per' => q({0} در متر مربع),
					},
					'square-mile' => {
						'name' => q(مایل مربع),
						'one' => q({0} مایل مربع),
						'other' => q({0} مایل مربع),
						'per' => q({0} در مایل مربع),
					},
					'square-yard' => {
						'name' => q(یارد مربع),
						'one' => q({0} یارد مربع),
						'other' => q({0} یارد مربع),
					},
					'tablespoon' => {
						'name' => q(قاشق غذاخوری),
						'one' => q({0} قاشق غذاخوری),
						'other' => q({0} قاشق غذاخوری),
					},
					'teaspoon' => {
						'name' => q(قاشق چای‌خوری),
						'one' => q({0} قاشق چای‌خوری),
						'other' => q({0} قاشق چای‌خوری),
					},
					'terabit' => {
						'name' => q(ترابیت),
						'one' => q({0} ترابیت),
						'other' => q({0} ترابیت),
					},
					'terabyte' => {
						'name' => q(ترابایت),
						'one' => q({0} ترابایت),
						'other' => q({0} ترابایت),
					},
					'ton' => {
						'name' => q(تن),
						'one' => q({0} تن),
						'other' => q({0} تن),
					},
					'volt' => {
						'name' => q(ولت),
						'one' => q({0} ولت),
						'other' => q({0} ولت),
					},
					'watt' => {
						'name' => q(وات),
						'one' => q({0} وات),
						'other' => q({0} وات),
					},
					'week' => {
						'name' => q(هفته),
						'one' => q({0} هفته),
						'other' => q({0} هفته),
						'per' => q({0} در هفته),
					},
					'yard' => {
						'name' => q(یارد),
						'one' => q({0} یارد),
						'other' => q({0} یارد),
					},
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0} در سال),
					},
				},
				'narrow' => {
					'' => {
						'name' => q(جهت),
					},
					'acre' => {
						'one' => q({0}جریب),
						'other' => q({0} جریب),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'name' => q(واحد نجومی),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					'bit' => {
						'name' => q(بیت),
					},
					'byte' => {
						'name' => q(بایت),
					},
					'celsius' => {
						'name' => q(‎°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'name' => q(سانت),
						'one' => q({0} سانت),
						'other' => q({0} سانت),
						'per' => q({0}/سانت),
					},
					'century' => {
						'name' => q(سده),
						'one' => q({0} سده),
						'other' => q({0} سده),
					},
					'coordinate' => {
						'east' => q({0} شرقی),
						'north' => q({0} شمالی),
						'south' => q({0} جنوبی),
						'west' => q({0} غربی),
					},
					'cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					'cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					'day' => {
						'name' => q(روز),
						'one' => q({0} روز),
						'other' => q({0} روز),
						'per' => q({0}/روز),
					},
					'decimeter' => {
						'name' => q(dm),
						'one' => q({0}dm),
						'other' => q({0}dm),
					},
					'degree' => {
						'name' => q(درجه),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'name' => q(‎°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'name' => q(فوت),
						'one' => q({0}ft),
						'other' => q({0}ft),
						'per' => q({0}/فوت),
					},
					'g-force' => {
						'name' => q(نیروی جاذبه),
						'one' => q({0}G),
						'other' => q({0}G),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigahertz' => {
						'name' => q(گ‌.هرتز),
						'one' => q({0} گ.هرتز),
						'other' => q({0} گ.هرتز),
					},
					'gram' => {
						'name' => q(گرم),
						'one' => q({0} گرم),
						'other' => q({0} گرم),
						'per' => q({0} در گرم),
					},
					'hectare' => {
						'one' => q({0}ha),
						'other' => q({0}ha),
					},
					'hectopascal' => {
						'name' => q(هکتوپاسکال),
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					'horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					'hour' => {
						'name' => q(ساعت),
						'one' => q({0} ساعت),
						'other' => q({0} ساعت),
						'per' => q({0}/ساعت),
					},
					'inch' => {
						'name' => q(اینچ),
						'one' => q({0}in),
						'other' => q({0}in),
						'per' => q({0}/اینچ),
					},
					'inch-hg' => {
						'name' => q(اینچ جیوه),
						'one' => q({0}inHg),
						'other' => q({0}inHg),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0}K),
						'other' => q({0}K),
					},
					'kilogram' => {
						'name' => q(کیلوگرم),
						'one' => q({0}kg),
						'other' => q({0}kg),
						'per' => q({0}/kg),
					},
					'kilohertz' => {
						'name' => q(ک.هرتز),
						'one' => q({0} ک.هرتز),
						'other' => q({0} ک.هرتز),
					},
					'kilometer' => {
						'name' => q(کیلومتر),
						'one' => q({0}km),
						'other' => q({0}km),
						'per' => q({0}/km),
					},
					'kilometer-per-hour' => {
						'name' => q(کیلومتر/ساعت),
						'one' => q({0}‎ km/h),
						'other' => q({0}‎ km/h),
					},
					'kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					'knot' => {
						'name' => q(گره),
						'one' => q({0} گره),
						'other' => q({0} گره),
					},
					'light-year' => {
						'name' => q(سال نوری),
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					'liter' => {
						'name' => q(لیتر),
						'one' => q({0} لیتر),
						'other' => q({0} لیتر),
					},
					'liter-per-100kilometers' => {
						'name' => q(لیتر/۱۰۰ کیلومتر),
						'one' => q({0} ل./۱۰۰ ک.م.),
						'other' => q({0} ل./۱۰۰ ک.م.),
					},
					'megahertz' => {
						'name' => q(مگاهرتز),
						'one' => q({0} مگاهرتز),
						'other' => q({0} مگاهرتز),
					},
					'meter' => {
						'name' => q(متر),
						'one' => q({0} متر),
						'other' => q({0} متر),
						'per' => q({0}/متر),
					},
					'meter-per-second' => {
						'name' => q(متر در ثانیه),
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					'meter-per-second-squared' => {
						'name' => q(متر/مجذور ثانیه),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'name' => q(تن متریک),
						'one' => q({0} تن),
						'other' => q({0} تن),
					},
					'microgram' => {
						'name' => q(میکروگرم),
					},
					'micrometer' => {
						'name' => q(µm),
						'one' => q({0}µm),
						'other' => q({0}µm),
					},
					'microsecond' => {
						'name' => q(میکروثانیه),
						'one' => q({0} م.ث.),
						'other' => q({0} م.ث.),
					},
					'mile' => {
						'name' => q(مایل),
						'one' => q({0}mi),
						'other' => q({0}mi),
					},
					'mile-per-hour' => {
						'name' => q(مایل در ساعت),
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					'millibar' => {
						'name' => q(میلی‌بار),
						'one' => q({0}mbar),
						'other' => q({0}mbar),
					},
					'milligram' => {
						'name' => q(میلی‌گرم),
						'one' => q({0} mg),
						'other' => q({0} mg),
					},
					'millimeter' => {
						'name' => q(م‌م),
						'one' => q({0} م‌م),
						'other' => q({0} م‌م),
					},
					'millimeter-of-mercury' => {
						'name' => q(میلی‌متر جیوه),
						'one' => q({0} م‌م جیوه),
						'other' => q({0} م‌م جیوه),
					},
					'millisecond' => {
						'name' => q(میلی‌ثانیه),
						'one' => q({0}ms),
						'other' => q({0}ms),
					},
					'minute' => {
						'name' => q(دقیقه),
						'one' => q({0} دقیقه),
						'other' => q({0} دقیقه),
						'per' => q({0}/دقیقه),
					},
					'month' => {
						'name' => q(ماه),
						'one' => q({0} ماه),
						'other' => q({0} ماه),
						'per' => q({0}/ماه),
					},
					'nanometer' => {
						'name' => q(نانومتر),
						'one' => q({0} نانومتر),
						'other' => q({0} نانومتر),
					},
					'nanosecond' => {
						'name' => q(نانوثانیه),
						'one' => q({0}ن.ث.),
						'other' => q({0}ن.ث.),
					},
					'ounce' => {
						'name' => q(اونس),
						'one' => q({0}oz),
						'other' => q({0}oz),
						'per' => q({0} در اونس),
					},
					'parsec' => {
						'name' => q(پارسک),
						'one' => q({0} پارسک),
						'other' => q({0} پارسک),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(٪),
						'one' => q({0}٪),
						'other' => q({0}٪),
					},
					'picometer' => {
						'name' => q(پیکومتر),
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					'pound' => {
						'name' => q(پوند),
						'one' => q({0}lb),
						'other' => q({0}lb),
						'per' => q({0} در پوند),
					},
					'pound-per-square-inch' => {
						'name' => q(پوند در اینچ مربع),
						'one' => q({0}‎ psi),
						'other' => q({0}‎ psi),
					},
					'radian' => {
						'name' => q(رادیان),
					},
					'second' => {
						'name' => q(ثانیه),
						'one' => q({0} ث),
						'other' => q({0} ث),
						'per' => q({0}/ث),
					},
					'square-foot' => {
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					'square-kilometer' => {
						'one' => q({0}km²),
						'other' => q({0}km²),
					},
					'square-meter' => {
						'one' => q({0}m²),
						'other' => q({0}m²),
					},
					'square-mile' => {
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					'square-yard' => {
						'name' => q(یارد مربع),
						'one' => q({0} یارد مربع),
						'other' => q({0} یارد مربع),
					},
					'stone' => {
						'name' => q(سنگ),
						'one' => q({0} سنگ),
						'other' => q({0} سنگ),
					},
					'ton' => {
						'name' => q(تن),
					},
					'watt' => {
						'one' => q({0}W),
						'other' => q({0}W),
					},
					'week' => {
						'name' => q(هفته),
						'one' => q({0} هفته),
						'other' => q({0} هفته),
						'per' => q({0}/هفته),
					},
					'yard' => {
						'name' => q(یارد),
						'one' => q({0} یارد),
						'other' => q({0} یارد),
					},
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0}/سال),
					},
				},
				'short' => {
					'' => {
						'name' => q(جهت),
					},
					'acre' => {
						'name' => q(جریب),
						'one' => q({0} جریب),
						'other' => q({0} جریب),
					},
					'acre-foot' => {
						'name' => q(جریب فوت),
						'one' => q({0} جریب فوت),
						'other' => q({0} جریب فوت),
					},
					'ampere' => {
						'name' => q(آمپر),
						'one' => q({0} آمپر),
						'other' => q({0} آمپر),
					},
					'arc-minute' => {
						'name' => q(دقیقهٔ قوسی),
						'one' => q({0} د.قوسی),
						'other' => q({0} د.قوسی),
					},
					'arc-second' => {
						'name' => q(ثانیهٔ قوسی),
						'one' => q({0} ث.قوسی),
						'other' => q({0} ث.قوسی),
					},
					'astronomical-unit' => {
						'name' => q(واحد نجومی),
						'one' => q({0} واحد نجومی),
						'other' => q({0} واحد نجومی),
					},
					'atmosphere' => {
						'name' => q(اتمسفر),
						'one' => q({0} atm),
						'other' => q({0} atm),
					},
					'bit' => {
						'name' => q(بیت),
						'one' => q({0} بیت),
						'other' => q({0} بیت),
					},
					'byte' => {
						'name' => q(بایت),
						'one' => q({0} بایت),
						'other' => q({0} بایت),
					},
					'calorie' => {
						'name' => q(کالری),
						'one' => q({0} کالری),
						'other' => q({0} کالری),
					},
					'carat' => {
						'name' => q(قیراط),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					'celsius' => {
						'name' => q(درجهٔ سلسیوس),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(سانتی‌لیتر),
						'one' => q({0} سانتی‌لیتر),
						'other' => q({0} سانتی‌لیتر),
					},
					'centimeter' => {
						'name' => q(سانت),
						'one' => q({0} سانت),
						'other' => q({0} سانت),
						'per' => q({0}/سانت),
					},
					'century' => {
						'name' => q(سده),
						'one' => q({0} سده),
						'other' => q({0} سده),
					},
					'coordinate' => {
						'east' => q({0} شرقی),
						'north' => q({0} شمالی),
						'south' => q({0} جنوبی),
						'west' => q({0} غربی),
					},
					'cubic-centimeter' => {
						'name' => q(سانتی‌متر مکعب),
						'one' => q({0}‎ cm³),
						'other' => q({0}‎ cm³),
						'per' => q({0}‎ /cm³),
					},
					'cubic-foot' => {
						'name' => q(فوت مکعب),
						'one' => q({0} فوت مکعب),
						'other' => q({0} فوت مکعب),
					},
					'cubic-inch' => {
						'name' => q(اینچ مکعب),
						'one' => q({0} اینچ مکعب),
						'other' => q({0} اینچ مکعب),
					},
					'cubic-kilometer' => {
						'name' => q(کیلومتر مکعب),
						'one' => q({0}‎ km³),
						'other' => q({0}‎ km³),
					},
					'cubic-meter' => {
						'name' => q(متر مکعب),
						'one' => q({0} متر مکعب),
						'other' => q({0} متر مکعب),
						'per' => q({0} در متر مکعب),
					},
					'cubic-mile' => {
						'name' => q(مایل مکعب),
						'one' => q({0} مایل مکعب),
						'other' => q({0} مایل مکعب),
					},
					'cubic-yard' => {
						'name' => q(یارد مکعب),
						'one' => q({0} یارد مکعب),
						'other' => q({0} یارد مکعب),
					},
					'cup' => {
						'name' => q(پیمانه),
						'one' => q({0} پیمانه),
						'other' => q({0} پیمانه),
					},
					'cup-metric' => {
						'name' => q(پیمانهٔ متریک),
						'one' => q({0} پیمانهٔ متریک),
						'other' => q({0} پیمانهٔ متریک),
					},
					'day' => {
						'name' => q(روز),
						'one' => q({0} روز),
						'other' => q({0} روز),
						'per' => q({0}/روز),
					},
					'deciliter' => {
						'name' => q(دسی‌لیتر),
						'one' => q({0} دسی‌لیتر),
						'other' => q({0} دسی‌لیتر),
					},
					'decimeter' => {
						'name' => q(دسی‌متر),
						'one' => q({0} دسی‌متر),
						'other' => q({0} دسی‌متر),
					},
					'degree' => {
						'name' => q(درجه),
						'one' => q({0} درجه),
						'other' => q({0} درجه),
					},
					'fahrenheit' => {
						'name' => q(درجهٔ فارنهایت),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'name' => q(اونس سیال),
						'one' => q({0}‎ fl oz),
						'other' => q({0}‎ fl oz),
					},
					'foodcalorie' => {
						'name' => q(کالری),
						'one' => q({0} کالری),
						'other' => q({0} کالری),
					},
					'foot' => {
						'name' => q(فوت),
						'one' => q({0} فوت),
						'other' => q({0} فوت),
						'per' => q({0}/فوت),
					},
					'g-force' => {
						'name' => q(نیروی جاذبه),
						'one' => q({0} جاذبه),
						'other' => q({0} جاذبه),
					},
					'gallon' => {
						'name' => q(گالن),
						'one' => q({0} گالن),
						'other' => q({0} گالن),
						'per' => q({0} در گالن),
					},
					'gallon-imperial' => {
						'name' => q(گالن امپریال),
						'one' => q({0} گالن امپریال),
						'other' => q({0} گالن امپریال),
						'per' => q({0}/گالن امپریال),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(گیگابیت),
						'one' => q({0} گیگابیت),
						'other' => q({0} گیگابیت),
					},
					'gigabyte' => {
						'name' => q(گیگابایت),
						'one' => q({0} گیگابایت),
						'other' => q({0} گیگابایت),
					},
					'gigahertz' => {
						'name' => q(گیگاهرتز),
						'one' => q({0} گیگاهرتز),
						'other' => q({0} گیگاهرتز),
					},
					'gigawatt' => {
						'name' => q(گیگاوات),
						'one' => q({0} گیگاوات),
						'other' => q({0} گیگاوات),
					},
					'gram' => {
						'name' => q(گرم),
						'one' => q({0} گرم),
						'other' => q({0} گرم),
						'per' => q({0} در گرم),
					},
					'hectare' => {
						'name' => q(هکتار),
						'one' => q({0} هکتار),
						'other' => q({0} هکتار),
					},
					'hectoliter' => {
						'name' => q(هکتولیتر),
						'one' => q({0} هکتولیتر),
						'other' => q({0} هکتولیتر),
					},
					'hectopascal' => {
						'name' => q(هکتوپاسکال),
						'one' => q({0}‎ hPa),
						'other' => q({0}‎ hPa),
					},
					'hertz' => {
						'name' => q(هرتز),
						'one' => q({0} هرتز),
						'other' => q({0} هرتز),
					},
					'horsepower' => {
						'name' => q(اسب بخار),
						'one' => q({0} اسب بخار),
						'other' => q({0} اسب بخار),
					},
					'hour' => {
						'name' => q(ساعت),
						'one' => q({0} ساعت),
						'other' => q({0} ساعت),
						'per' => q({0} در ساعت),
					},
					'inch' => {
						'name' => q(اینچ),
						'one' => q({0} اینچ),
						'other' => q({0} اینچ),
						'per' => q({0}/اینچ),
					},
					'inch-hg' => {
						'name' => q(اینچ جیوه),
						'one' => q({0} اینچ جیوه),
						'other' => q({0} اینچ جیوه),
					},
					'joule' => {
						'name' => q(ژول),
						'one' => q({0} ژول),
						'other' => q({0} ژول),
					},
					'karat' => {
						'name' => q(عیار),
						'one' => q({0} عیار),
						'other' => q({0} عیار),
					},
					'kelvin' => {
						'name' => q(درجهٔ کلوین),
						'one' => q(‎{0} K),
						'other' => q(‎{0} K),
					},
					'kilobit' => {
						'name' => q(کیلوبیت),
						'one' => q({0} کیلوبیت),
						'other' => q({0} کیلوبیت),
					},
					'kilobyte' => {
						'name' => q(کیلوبایت),
						'one' => q({0} کیلوبایت),
						'other' => q({0} کیلوبایت),
					},
					'kilocalorie' => {
						'name' => q(ک.کالری),
						'one' => q({0} ک.کالری),
						'other' => q({0} ک.کالری),
					},
					'kilogram' => {
						'name' => q(کیلوگرم),
						'one' => q({0} کیلوگرم),
						'other' => q({0} کیلوگرم),
						'per' => q({0} در کیلوگرم),
					},
					'kilohertz' => {
						'name' => q(ک.هرتز),
						'one' => q({0} ک.هرتز),
						'other' => q({0} ک.هرتز),
					},
					'kilojoule' => {
						'name' => q(ک.ژول),
						'one' => q({0} ک.ژول),
						'other' => q({0} ک.ژول),
					},
					'kilometer' => {
						'name' => q(کیلومتر),
						'one' => q({0} کیلومتر),
						'other' => q({0} کیلومتر),
						'per' => q({0}/کیلومتر),
					},
					'kilometer-per-hour' => {
						'name' => q(کیلومتر در ساعت),
						'one' => q({0}‎ km/h),
						'other' => q({0}‎ km/h),
					},
					'kilowatt' => {
						'name' => q(ک.وات),
						'one' => q({0} ک.وات),
						'other' => q({0} ک.وات),
					},
					'kilowatt-hour' => {
						'name' => q(ک.وات‌ساعت),
						'one' => q({0} ک.وات‌ساعت),
						'other' => q({0} ک.وات‌ساعت),
					},
					'knot' => {
						'name' => q(گره),
						'one' => q({0} گره),
						'other' => q({0} گره),
					},
					'light-year' => {
						'name' => q(سال نوری),
						'one' => q({0} سال نوری),
						'other' => q({0} سال نوری),
					},
					'liter' => {
						'name' => q(لیتر),
						'one' => q({0} لیتر),
						'other' => q({0} لیتر),
						'per' => q({0} در لیتر),
					},
					'liter-per-100kilometers' => {
						'name' => q(لیتر/۱۰۰ کیلومتر),
						'one' => q({0} ل./۱۰۰ ک.م.),
						'other' => q({0} ل./۱۰۰ ک.م.),
					},
					'liter-per-kilometer' => {
						'name' => q(لیتر/کیلومتر),
						'one' => q({0} ل./ک.م.),
						'other' => q({0} ل./ک.م.),
					},
					'lux' => {
						'name' => q(لوکس),
						'one' => q({0} لوکس),
						'other' => q({0} لوکس),
					},
					'megabit' => {
						'name' => q(مگابیت),
						'one' => q({0} مگابیت),
						'other' => q({0} مگابیت),
					},
					'megabyte' => {
						'name' => q(مگابایت),
						'one' => q({0} مگابایت),
						'other' => q({0} مگابایت),
					},
					'megahertz' => {
						'name' => q(مگاهرتز),
						'one' => q({0} مگاهرتز),
						'other' => q({0} مگاهرتز),
					},
					'megaliter' => {
						'name' => q(مگالیتر),
						'one' => q({0} مگالیتر),
						'other' => q({0} مگالیتر),
					},
					'megawatt' => {
						'name' => q(مگاوات),
						'one' => q({0} مگاوات),
						'other' => q({0} مگاوات),
					},
					'meter' => {
						'name' => q(متر),
						'one' => q({0} متر),
						'other' => q({0} متر),
						'per' => q({0}/متر),
					},
					'meter-per-second' => {
						'name' => q(متر در ثانیه),
						'one' => q({0} متردرثانیه),
						'other' => q({0} متردرثانیه),
					},
					'meter-per-second-squared' => {
						'name' => q(متر/مجذور ثانیه),
						'one' => q({0}<LRM> m/s²),
						'other' => q({0}<LRM> m/s²),
					},
					'metric-ton' => {
						'name' => q(تن متریک),
						'one' => q({0} تن متریک),
						'other' => q({0} تن متریک),
					},
					'microgram' => {
						'name' => q(میکروگرم),
						'one' => q({0} میکروگرم),
						'other' => q({0} میکروگرم),
					},
					'micrometer' => {
						'name' => q(میکرومتر),
						'one' => q({0} میکرومتر),
						'other' => q({0} میکرومتر),
					},
					'microsecond' => {
						'name' => q(میکروثانیه),
						'one' => q({0} میکروثانیه),
						'other' => q({0} میکروثانیه),
					},
					'mile' => {
						'name' => q(مایل),
						'one' => q({0} مایل),
						'other' => q({0} مایل),
					},
					'mile-per-gallon' => {
						'name' => q(مایل/گالن),
						'one' => q({0} مایل در گالن),
						'other' => q({0} مایل در گالن),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(مایل/امپریال گالن),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					'mile-per-hour' => {
						'name' => q(مایل در ساعت),
						'one' => q({0}‎ mph),
						'other' => q({0}‎ mph),
					},
					'mile-scandinavian' => {
						'name' => q(مایل اسکاندیناوی),
						'one' => q({0}‎ smi),
						'other' => q({0}‎ smi),
					},
					'milliampere' => {
						'name' => q(میلی‌آمپر),
						'one' => q({0} میلی‌آمپر),
						'other' => q({0} میلی‌آمپر),
					},
					'millibar' => {
						'name' => q(میلی‌بار),
						'one' => q({0} میلی‌بار),
						'other' => q({0} میلی‌بار),
					},
					'milligram' => {
						'name' => q(میلی‌گرم),
						'one' => q({0} میلی‌گرم),
						'other' => q({0} میلی‌گرم),
					},
					'milligram-per-deciliter' => {
						'name' => q(میلی‌گرم در دسی‌لیتر),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					'milliliter' => {
						'name' => q(میلی‌لیتر),
						'one' => q({0} میلی‌لیتر),
						'other' => q({0} میلی‌لیتر),
					},
					'millimeter' => {
						'name' => q(م‌م),
						'one' => q({0} م‌م),
						'other' => q({0} م‌م),
					},
					'millimeter-of-mercury' => {
						'name' => q(میلی‌متر جیوه),
						'one' => q({0} م‌م جیوه),
						'other' => q({0} م‌م جیوه),
					},
					'millimole-per-liter' => {
						'name' => q(میلی‌مول/لیتر),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					'millisecond' => {
						'name' => q(میلی‌ثانیه),
						'one' => q({0} میلی‌ثانیه),
						'other' => q({0} میلی‌ثانیه),
					},
					'milliwatt' => {
						'name' => q(میلی‌وات),
						'one' => q({0} میلی‌وات),
						'other' => q({0} میلی‌وات),
					},
					'minute' => {
						'name' => q(دقیقه),
						'one' => q({0} دقیقه),
						'other' => q({0} دقیقه),
						'per' => q({0}/دقیقه),
					},
					'month' => {
						'name' => q(ماه),
						'one' => q({0} ماه),
						'other' => q({0} ماه),
						'per' => q({0}/ماه),
					},
					'nanometer' => {
						'name' => q(نانومتر),
						'one' => q({0} نانومتر),
						'other' => q({0} نانومتر),
					},
					'nanosecond' => {
						'name' => q(نانوثانیه),
						'one' => q({0} نانوثانیه),
						'other' => q({0} نانوثانیه),
					},
					'nautical-mile' => {
						'name' => q(مایل دریایی),
						'one' => q({0} مایل دریایی),
						'other' => q({0} مایل دریایی),
					},
					'ohm' => {
						'name' => q(اهم),
						'one' => q({0} اهم),
						'other' => q({0} اهم),
					},
					'ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} در اونس),
					},
					'ounce-troy' => {
						'name' => q(اونس تروا),
						'one' => q({0} اونس تروا),
						'other' => q({0} اونس تروا),
					},
					'parsec' => {
						'name' => q(پارسک),
						'one' => q({0} پارسک),
						'other' => q({0} پارسک),
					},
					'part-per-million' => {
						'name' => q(بخش/میلیون),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(درصد),
						'one' => q({0}٪),
						'other' => q({0}٪),
					},
					'permille' => {
						'name' => q(هزارم),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'name' => q(پتابایت),
						'one' => q({0} پتابایت),
						'other' => q({0} پتابایت),
					},
					'picometer' => {
						'name' => q(پیکومتر),
						'one' => q({0} پیکومتر),
						'other' => q({0} پیکومتر),
					},
					'pint' => {
						'name' => q(پاینت),
						'one' => q({0} پاینت),
						'other' => q({0} پاینت),
					},
					'pint-metric' => {
						'name' => q(پاینت متریک),
						'one' => q({0} پاینت متریک),
						'other' => q({0} پاینت متریک),
					},
					'point' => {
						'name' => q(امتیاز),
						'one' => q({0} امتیاز),
						'other' => q({0} امتیاز),
					},
					'pound' => {
						'name' => q(پوند),
						'one' => q({0} پوند),
						'other' => q({0} پوند),
						'per' => q({0} در پوند),
					},
					'pound-per-square-inch' => {
						'name' => q(پوند در اینچ مربع),
						'one' => q({0}‎ psi),
						'other' => q({0}‎ psi),
					},
					'quart' => {
						'name' => q(کوارت),
						'one' => q({0} کوارت),
						'other' => q({0} کوارت),
					},
					'radian' => {
						'name' => q(رادیان),
						'one' => q({0} رادیان),
						'other' => q({0} رادیان),
					},
					'revolution' => {
						'name' => q(دور),
						'one' => q({0} دور),
						'other' => q({0} دور),
					},
					'second' => {
						'name' => q(ثانیه),
						'one' => q({0} ثانیه),
						'other' => q({0} ثانیه),
						'per' => q({0} در ثانیه),
					},
					'square-centimeter' => {
						'name' => q(سانتی‌متر مربع),
						'one' => q({0}‎ cm²),
						'other' => q({0}‎ cm²),
						'per' => q({0} در سانتی‌متر مربع),
					},
					'square-foot' => {
						'name' => q(فوت مربع),
						'one' => q({0} فوت مربع),
						'other' => q({0} فوت مربع),
					},
					'square-inch' => {
						'name' => q(اینچ مربع),
						'one' => q({0} اینچ مربع),
						'other' => q({0} اینچ مربع),
						'per' => q({0} در اینچ مربع),
					},
					'square-kilometer' => {
						'name' => q(کیلومتر مربع),
						'one' => q({0}‎ km²),
						'other' => q({0}‎ km²),
						'per' => q({0}/km²),
					},
					'square-meter' => {
						'name' => q(متر مربع),
						'one' => q({0} مترمربع),
						'other' => q({0} مترمربع),
						'per' => q({0} در متر مربع),
					},
					'square-mile' => {
						'name' => q(مایل مربع),
						'one' => q({0} مایل مربع),
						'other' => q({0} مایل مربع),
						'per' => q({0}/mi²),
					},
					'square-yard' => {
						'name' => q(یارد مربع),
						'one' => q({0} یارد مربع),
						'other' => q({0} یارد مربع),
					},
					'tablespoon' => {
						'name' => q(قاشق غ.),
						'one' => q({0} قاشق غ.),
						'other' => q({0} قاشق غ.),
					},
					'teaspoon' => {
						'name' => q(قاشق چ.),
						'one' => q({0} قاشق چ.),
						'other' => q({0} قاشق چ.),
					},
					'terabit' => {
						'name' => q(ترابیت),
						'one' => q({0} ترابیت),
						'other' => q({0} ترابیت),
					},
					'terabyte' => {
						'name' => q(ترابایت),
						'one' => q({0} ترابایت),
						'other' => q({0} ترابایت),
					},
					'ton' => {
						'name' => q(تن),
						'one' => q({0} تن),
						'other' => q({0} تن),
					},
					'volt' => {
						'name' => q(ولت),
						'one' => q({0} ولت),
						'other' => q({0} ولت),
					},
					'watt' => {
						'name' => q(وات),
						'one' => q({0} وات),
						'other' => q({0} وات),
					},
					'week' => {
						'name' => q(هفته),
						'one' => q({0} هفته),
						'other' => q({0} هفته),
						'per' => q({0}/هفته),
					},
					'yard' => {
						'name' => q(یارد),
						'one' => q({0} یارد),
						'other' => q({0} یارد),
					},
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0}/سال),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:بله|ب|آری|آ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نه|ن|خیر|خ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}،‏ {1}),
				middle => q({0}،‏ {1}),
				end => q({0}،‏ {1}),
				2 => q({0}،‏ {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arab' => {
			'decimal' => q(٫),
			'group' => q(٬),
			'infinity' => q(∞),
			'list' => q(؛),
			'perMille' => q(؉),
			'percentSign' => q(٪),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
		'arabext' => {
			'decimal' => q(٫),
			'exponential' => q(×۱۰^),
			'group' => q(٬),
			'infinity' => q(∞),
			'list' => q(؛),
			'minusSign' => q(‎−),
			'nan' => q(ناعدد),
			'perMille' => q(؉),
			'percentSign' => q(٪),
			'plusSign' => q(‎+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(‎−),
			'nan' => q(ناعدد),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(‎+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 هزار',
					'other' => '0 هزار',
				},
				'10000' => {
					'one' => '00 هزار',
					'other' => '00 هزار',
				},
				'100000' => {
					'one' => '000 هزار',
					'other' => '000 هزار',
				},
				'1000000' => {
					'one' => '0 میلیون',
					'other' => '0 میلیون',
				},
				'10000000' => {
					'one' => '00 میلیون',
					'other' => '00 میلیون',
				},
				'100000000' => {
					'one' => '000 م',
					'other' => '000 م',
				},
				'1000000000' => {
					'one' => '0 م',
					'other' => '0 م',
				},
				'10000000000' => {
					'one' => '00 م',
					'other' => '00 م',
				},
				'100000000000' => {
					'one' => '000 میلیارد',
					'other' => '000 میلیارد',
				},
				'1000000000000' => {
					'one' => '0 تریلیون',
					'other' => '0 تریلیون',
				},
				'10000000000000' => {
					'one' => '00 ت',
					'other' => '00 ت',
				},
				'100000000000000' => {
					'one' => '000 ت',
					'other' => '000 ت',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 هزار',
					'other' => '0 هزار',
				},
				'10000' => {
					'one' => '00 هزار',
					'other' => '00 هزار',
				},
				'100000' => {
					'one' => '000 هزار',
					'other' => '000 هزار',
				},
				'1000000' => {
					'one' => '0 میلیون',
					'other' => '0 میلیون',
				},
				'10000000' => {
					'one' => '00 میلیون',
					'other' => '00 میلیون',
				},
				'100000000' => {
					'one' => '000 میلیون',
					'other' => '000 میلیون',
				},
				'1000000000' => {
					'one' => '0 میلیارد',
					'other' => '0 میلیارد',
				},
				'10000000000' => {
					'one' => '00 میلیارد',
					'other' => '00 میلیارد',
				},
				'100000000000' => {
					'one' => '000 میلیارد',
					'other' => '000 میلیارد',
				},
				'1000000000000' => {
					'one' => '0 هزارمیلیارد',
					'other' => '0 هزارمیلیارد',
				},
				'10000000000000' => {
					'one' => '00 هزارمیلیارد',
					'other' => '00 هزارمیلیارد',
				},
				'100000000000000' => {
					'one' => '000 هزارمیلیارد',
					'other' => '000 هزارمیلیارد',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 هزار',
					'other' => '0 هزار',
				},
				'10000' => {
					'one' => '00 هزار',
					'other' => '00 هزار',
				},
				'100000' => {
					'one' => '000 هزار',
					'other' => '000 هزار',
				},
				'1000000' => {
					'one' => '0 میلیون',
					'other' => '0 میلیون',
				},
				'10000000' => {
					'one' => '00 میلیون',
					'other' => '00 میلیون',
				},
				'100000000' => {
					'one' => '000 م',
					'other' => '000 م',
				},
				'1000000000' => {
					'one' => '0 م',
					'other' => '0 م',
				},
				'10000000000' => {
					'one' => '00 م',
					'other' => '00 م',
				},
				'100000000000' => {
					'one' => '000 میلیارد',
					'other' => '000 میلیارد',
				},
				'1000000000000' => {
					'one' => '0 تریلیون',
					'other' => '0 تریلیون',
				},
				'10000000000000' => {
					'one' => '00 ت',
					'other' => '00 ت',
				},
				'100000000000000' => {
					'one' => '000 ت',
					'other' => '000 ت',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arab' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '‎¤#,##0.00',
					},
				},
			},
		},
		'arabext' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '‎¤#,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '‎(¤ #,##0.00)',
						'positive' => '‎¤ #,##0.00',
					},
					'standard' => {
						'positive' => '‎¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(پزتای آندورا),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(درهم امارات متحدهٔ عربی),
				'one' => q(درهم امارات متحدهٔ عربی),
				'other' => q(درهم امارات متحدهٔ عربی),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(افغانی افغانستان \(۱۹۲۷ تا ۲۰۰۲\)),
			},
		},
		'AFN' => {
			symbol => '؋',
			display_name => {
				'currency' => q(افغانی افغانستان),
				'one' => q(افغانی افغانستان),
				'other' => q(افغانی افغانستان),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(لک آلبانی),
				'one' => q(لک آلبانی),
				'other' => q(لک آلبانی),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(درام ارمنستان),
				'one' => q(درام ارمنستان),
				'other' => q(درام ارمنستان),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(گیلدر آنتیل هلند),
				'one' => q(گیلدر آنتیل هلند),
				'other' => q(گیلدر آنتیل هلند),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(کوانزای آنگولا),
				'one' => q(کوانزای آنگولا),
				'other' => q(کوانزای آنگولا),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(پزوی آرژانتین \(۱۹۸۳ تا ۱۹۸۵\)‏),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(پزوی آرژانتین),
				'one' => q(پزوی آرژانتین),
				'other' => q(پزوی آرژانتین),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(شیلینگ اتریش),
				'one' => q(شیلینگ اتریش),
				'other' => q(شیلینگ اتریش),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(دلار استرالیا),
				'one' => q(دلار استرالیا),
				'other' => q(دلار استرالیا),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(فلورین آروبا),
				'one' => q(فلورین آروبا),
				'other' => q(فلورین آروبا),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(منات جمهوری آذربایجان \(۱۹۹۳ تا ۲۰۰۶\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(منات جمهوری آذربایجان),
				'one' => q(منات جمهوری آذربایجان),
				'other' => q(منات جمهوری آذربایجان),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(دینار بوسنی و هرزگوین \(۱۹۹۲ تا ۱۹۹۴\)),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(مارک تبدیل‌پذیر بوسنی و هرزگوین),
				'one' => q(مارک تبدیل‌پذیر بوسنی و هرزگوین),
				'other' => q(مارک تبدیل‌پذیر بوسنی و هرزگوین),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(دلار باربادوس),
				'one' => q(دلار باربادوس),
				'other' => q(دلار باربادوس),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(تاکای بنگلادش),
				'one' => q(تاکای بنگلادش),
				'other' => q(تاکای بنگلادش),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(فرانک بلژیک),
				'one' => q(فرانک بلژیک),
				'other' => q(فرانک بلژیک),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(فرانک بلژیک \(مالی\)),
				'one' => q(فرانک بلژیک \(مالی\)),
				'other' => q(فرانک بلژیک \(مالی\)),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(لف بلغارستان),
				'one' => q(لف بلغارستان),
				'other' => q(لف بلغارستان),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(دینار بحرین),
				'one' => q(دینار بحرین),
				'other' => q(دینار بحرین),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(فرانک بوروندی),
				'one' => q(فرانک بوروندی),
				'other' => q(فرانک بوروندی),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(دلار برمودا),
				'one' => q(دلار برمودا),
				'other' => q(دلار برمودا),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(دلار برونئی),
				'one' => q(دلار برونئی),
				'other' => q(دلار برونئی),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(بولیویانوی بولیوی),
				'one' => q(بولیویانوی بولیوی),
				'other' => q(بولیویانوی بولیوی),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(پزوی بولیوی),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(رئال برزیل),
				'one' => q(رئال برزیل),
				'other' => q(رئال برزیل),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(دلار باهاما),
				'one' => q(دلار باهاما),
				'other' => q(دلار باهاما),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(انگولتروم بوتان),
				'one' => q(انگولتروم بوتان),
				'other' => q(انگولتروم بوتان),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(پولای بوتسوانا),
				'one' => q(پولای بوتسوانا),
				'other' => q(پولای بوتسوانا),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(روبل جدید بیلوروسی \(۱۹۹۴ تا ۱۹۹۹\)),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(روبل بلاروسی),
				'one' => q(روبل بلاروسی),
				'other' => q(روبل بلاروسی),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(روبل بلاروسی \(۲۰۱۶–۲۰۰۰\)),
				'one' => q(روبل بلاروسی \(۲۰۱۶–۲۰۰۰\)),
				'other' => q(روبل بلاروسی \(۲۰۱۶–۲۰۰۰\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(دلار بلیز),
				'one' => q(دلار بلیز),
				'other' => q(دلار بلیز),
			},
		},
		'CAD' => {
			symbol => '$CA',
			display_name => {
				'currency' => q(دلار کانادا),
				'one' => q(دلار کانادا),
				'other' => q(دلار کانادا),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(فرانک کنگو),
				'one' => q(فرانک کنگو),
				'other' => q(فرانک کنگو),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(فرانک سوئیس),
				'one' => q(فرانک سوئیس),
				'other' => q(فرانک سوئیس),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(پزوی شیلی),
				'one' => q(پزوی شیلی),
				'other' => q(پزوی شیلی),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(یوآن چین \(برون‌مرزی\)),
				'one' => q(یوآن چین \(برون‌مرزی\)),
				'other' => q(یوآن چین \(برون‌مرزی\)),
			},
		},
		'CNY' => {
			symbol => '¥CN',
			display_name => {
				'currency' => q(یوآن چین),
				'one' => q(یوآن چین),
				'other' => q(یوآن چین),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(پزوی کلمبیا),
				'one' => q(پزوی کلمبیا),
				'other' => q(پزوی کلمبیا),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(کولون کاستاریکا),
				'one' => q(کولون کاستاریکا),
				'other' => q(کولون کاستاریکا),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(دینار صربستان \(۲۰۰۲ تا ۲۰۰۶\)),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(پزوی تبدیل‌پذیر کوبا),
				'one' => q(پزوی تبدیل‌پذیر کوبا),
				'other' => q(پزوی تبدیل‌پذیر کوبا),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(پزوی کوبا),
				'one' => q(پزوی کوبا),
				'other' => q(پزوی کوبا),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(اسکودوی کیپ‌ورد),
				'one' => q(اسکودوی کیپ‌ورد),
				'other' => q(اسکودوی کیپ‌ورد),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(پوند قبرس),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(کورونای جمهوری چک),
				'one' => q(کورونای جمهوری چک),
				'other' => q(کورونای جمهوری چک),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(مارک آلمان شرقی),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(مارک آلمان),
				'one' => q(مارک آلمان),
				'other' => q(مارک آلمان),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(فرانک جیبوتی),
				'one' => q(فرانک جیبوتی),
				'other' => q(فرانک جیبوتی),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(کرون دانمارک),
				'one' => q(کرون دانمارک),
				'other' => q(کرون دانمارک),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(پزوی جمهوری دومینیکن),
				'one' => q(پزوی جمهوری دومینیکن),
				'other' => q(پزوی جمهوری دومینیکن),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(دینار الجزایر),
				'one' => q(دینار الجزایر),
				'other' => q(دینار الجزایر),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(پوند مصر),
				'one' => q(پوند مصر),
				'other' => q(پوند مصر),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(ناکفای اریتره),
				'one' => q(ناکفای اریتره),
				'other' => q(ناکفای اریتره),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(بیر اتیوپی),
				'one' => q(بیر اتیوپی),
				'other' => q(بیر اتیوپی),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(یورو),
				'one' => q(یورو),
				'other' => q(یورو),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(دلار فیجی),
				'one' => q(دلار فیجی),
				'other' => q(دلار فیجی),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(پوند جزایر فالکلند),
				'one' => q(پوند جزایر فالکلند),
				'other' => q(پوند جزایر فالکلند),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(فرانک فرانسه),
				'one' => q(فرانک فرانسه),
				'other' => q(فرانک فرانسه),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(پوند بریتانیا),
				'one' => q(پوند بریتانیا),
				'other' => q(پوند بریتانیا),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(لاری گرجستان),
				'one' => q(لاری گرجستان),
				'other' => q(لاری گرجستان),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(سدی غنا),
				'one' => q(سدی غنا),
				'other' => q(سدی غنا),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(پوند جبل‌الطارق),
				'one' => q(پوند جبل‌الطارق),
				'other' => q(پوند جبل‌الطارق),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(دالاسی گامبیا),
				'one' => q(دالاسی گامبیا),
				'other' => q(دالاسی گامبیا),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(فرانک گینه),
				'one' => q(فرانک گینه),
				'other' => q(فرانک گینه),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(دراخمای یونان),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(کتزال گواتمالا),
				'one' => q(کتزال گواتمالا),
				'other' => q(کتزال گواتمالا),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(پزوی گینهٔ بیسائو),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(دلار گویانا),
				'one' => q(دلار گویانا),
				'other' => q(دلار گویانا),
			},
		},
		'HKD' => {
			symbol => '$HK',
			display_name => {
				'currency' => q(دلار هنگ‌کنگ),
				'one' => q(دلار هنگ‌کنگ),
				'other' => q(دلار هنگ‌کنگ),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(لمپیرای هندوراس),
				'one' => q(لمپیرای هندوراس),
				'other' => q(لمپیرای هندوراس),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(دینار کرواسی),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(کونای کرواسی),
				'one' => q(کونای کرواسی),
				'other' => q(کونای کرواسی),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(گورد هائیتی),
				'one' => q(گورد هائیتی),
				'other' => q(گورد هائیتی),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(فورینت مجارستان),
				'one' => q(فورینت مجارستان),
				'other' => q(فورینت مجارستان),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(روپیهٔ اندونزی),
				'one' => q(روپیهٔ اندونزی),
				'other' => q(روپیهٔ اندونزی),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(پوند ایرلند),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(شقل جدید اسرائیل),
				'one' => q(شقل جدید اسرائیل),
				'other' => q(شقل جدید اسرائیل),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(روپیهٔ هند),
				'one' => q(روپیهٔ هند),
				'other' => q(روپیهٔ هند),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(دینار عراق),
				'one' => q(دینار عراق),
				'other' => q(دینار عراق),
			},
		},
		'IRR' => {
			symbol => 'ریال',
			display_name => {
				'currency' => q(ریال ایران),
				'one' => q(ریال ایران),
				'other' => q(ریال ایران),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(کرونای ایسلند),
				'one' => q(کرونای ایسلند),
				'other' => q(کرونای ایسلند),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(لیرهٔ ایتالیا),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(دلار جامائیکا),
				'one' => q(دلار جامائیکا),
				'other' => q(دلار جامائیکا),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(دینار اردن),
				'one' => q(دینار اردن),
				'other' => q(دینار اردن),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(ین ژاپن),
				'one' => q(ین ژاپن),
				'other' => q(ین ژاپن),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(شیلینگ کنیا),
				'one' => q(شیلینگ کنیا),
				'other' => q(شیلینگ کنیا),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(سوم قرقیزستان),
				'one' => q(سوم قرقیزستان),
				'other' => q(سوم قرقیزستان),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(ری‌یل کامبوج),
				'one' => q(ری‌یل کامبوج),
				'other' => q(ری‌یل کامبوج),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(فرانک کومورو),
				'one' => q(فرانک کومورو),
				'other' => q(فرانک کومورو),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(وون کرهٔ شمالی),
				'one' => q(وون کرهٔ شمالی),
				'other' => q(وون کرهٔ شمالی),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(وون کرهٔ جنوبی),
				'one' => q(وون کرهٔ جنوبی),
				'other' => q(وون کرهٔ جنوبی),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(دینار کویت),
				'one' => q(دینار کویت),
				'other' => q(دینار کویت),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(دلار جزایر کِیمن),
				'one' => q(دلار جزایر کِیمن),
				'other' => q(دلار جزایر کِیمن),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(تنگهٔ قزاقستان),
				'one' => q(تنگهٔ قزاقستان),
				'other' => q(تنگهٔ قزاقستان),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(کیپ لائوس),
				'one' => q(کیپ لائوس),
				'other' => q(کیپ لائوس),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(لیرهٔ لبنان),
				'one' => q(لیرهٔ لبنان),
				'other' => q(لیرهٔ لبنان),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(روپیهٔ سری‌لانکا),
				'one' => q(روپیهٔ سری‌لانکا),
				'other' => q(روپیهٔ سری‌لانکا),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(دلار لیبریا),
				'one' => q(دلار لیبریا),
				'other' => q(دلار لیبریا),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(لوتی لسوتو),
				'one' => q(لوتی لسوتو),
				'other' => q(لوتی لسوتو),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(لیتاس لیتوانی),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(فرانک لوکزامبورگ),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(فرانک مالی لوگزامبورگ),
				'one' => q(فرانک مالی لوگزامبورگ),
				'other' => q(فرانک مالی لوگزامبورگ),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(لاتس لتونی),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(روبل لتونی),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(دینار لیبی),
				'one' => q(دینار لیبی),
				'other' => q(دینار لیبی),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(درهم مراکش),
				'one' => q(درهم مراکش),
				'other' => q(درهم مراکش),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(فرانک مراکش),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(لئوی مولداوی),
				'one' => q(لئوی مولداوی),
				'other' => q(لئوی مولداوی),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(آریاری مالاگاسی),
				'one' => q(آریاری مالاگاسی),
				'other' => q(آریاری مالاگاسی),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(فرانک ماداگاسکار),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(دینار مقدونیه),
				'one' => q(دینار مقدونیه),
				'other' => q(دینار مقدونیه),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(فرانک مالی),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(کیات میانمار),
				'one' => q(کیات میانمار),
				'other' => q(کیات میانمار),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(توگریک مغولستان),
				'one' => q(توگریک مغولستان),
				'other' => q(توگریک مغولستان),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(پاتاکای ماکائو),
				'one' => q(پاتاکای ماکائو),
				'other' => q(پاتاکای ماکائو),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(اوگوئیای موریتانی \(۱۹۷۳ تا ۲۰۱۷\)),
				'one' => q(اوگوئیای موریتانی \(۱۹۷۳ تا ۲۰۱۷\)),
				'other' => q(اوگوئیای موریتانی \(۱۹۷۳ تا ۲۰۱۷\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(اوگوئیای موریتانی),
				'one' => q(اوگوئیای موریتانی),
				'other' => q(اوگوئیای موریتانی),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(لیرهٔ مالت),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(پوند مالت),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(روپیهٔ موریس),
				'one' => q(روپیهٔ موریس),
				'other' => q(روپیهٔ موریس),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(روپیهٔ مالدیو),
				'one' => q(روپیهٔ مالدیو),
				'other' => q(روپیهٔ مالدیو),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(کواچای مالاوی),
				'one' => q(کواچای مالاوی),
				'other' => q(کواچای مالاوی),
			},
		},
		'MXN' => {
			symbol => '$MX',
			display_name => {
				'currency' => q(پزوی مکزیک),
				'one' => q(پزوی مکزیک),
				'other' => q(پزوی مکزیک),
			},
		},
		'MXP' => {
			symbol => 'MXP',
			display_name => {
				'currency' => q(پزوی نقرهٔ مکزیک \(۱۸۶۱ تا ۱۹۹۲\)),
				'one' => q(پزوی نقرهٔ مکزیک \(۱۸۶۱ تا ۱۹۹۲\)),
				'other' => q(پزوی نقرهٔ مکزیک \(۱۸۶۱ تا ۱۹۹۲\)),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(رینگیت مالزی),
				'one' => q(رینگیت مالزی),
				'other' => q(رینگیت مالزی),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(اسکودوی موزامبیک),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(متیکال موزامبیک),
				'one' => q(متیکال موزامبیک),
				'other' => q(متیکال موزامبیک),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(دلار نامیبیا),
				'one' => q(دلار نامیبیا),
				'other' => q(دلار نامیبیا),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(نایرای نیجریه),
				'one' => q(نایرای نیجریه),
				'other' => q(نایرای نیجریه),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(کوردوبای نیکاراگوئه),
				'one' => q(کوردوبای نیکاراگوئه),
				'other' => q(کوردوبای نیکاراگوئه),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(گیلدر هلند),
				'one' => q(گیلدر هلند),
				'other' => q(گیلدر هلند),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(کرون نروژ),
				'one' => q(کرون نروژ),
				'other' => q(کرون نروژ),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(روپیهٔ نپال),
				'one' => q(روپیهٔ نپال),
				'other' => q(روپیهٔ نپال),
			},
		},
		'NZD' => {
			symbol => '$NZ',
			display_name => {
				'currency' => q(دلار زلاند نو),
				'one' => q(دلار زلاند نو),
				'other' => q(دلار زلاند نو),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ریال عمان),
				'one' => q(ریال عمان),
				'other' => q(ریال عمان),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(بالبوای پاناما),
				'one' => q(بالبوای پاناما),
				'other' => q(بالبوای پاناما),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(نوئووسول پرو),
				'one' => q(نوئووسول پرو),
				'other' => q(نوئووسول پرو),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(کینای پاپوا گینهٔ نو),
				'one' => q(کینای پاپوا گینهٔ نو),
				'other' => q(کینای پاپوا گینهٔ نو),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(پزوی فیلیپین),
				'one' => q(پزوی فیلیپین),
				'other' => q(پزوی فیلیپین),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(روپیهٔ پاکستان),
				'one' => q(روپیهٔ پاکستان),
				'other' => q(روپیهٔ پاکستان),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(زواتی لهستان),
				'one' => q(زواتی لهستان),
				'other' => q(زواتی لهستان),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(اسکودوی پرتغال),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(گوارانی پاراگوئه),
				'one' => q(گوارانی پاراگوئه),
				'other' => q(گوارانی پاراگوئه),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(ریال قطر),
				'one' => q(ریال قطر),
				'other' => q(ریال قطر),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(دلار رودزیا),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(لئوی رومانی),
				'one' => q(لئوی رومانی),
				'other' => q(لئوی رومانی),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(دینار صربستان),
				'one' => q(دینار صربستان),
				'other' => q(دینار صربستان),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(روبل روسیه),
				'one' => q(روبل روسیه),
				'other' => q(روبل روسیه),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(روبل روسیه \(۱۹۹۱ تا ۱۹۹۸\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(فرانک رواندا),
				'one' => q(فرانک رواندا),
				'other' => q(فرانک رواندا),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(ریال سعودی),
				'one' => q(ریال سعودی),
				'other' => q(ریال سعودی),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(دلار جزایر سلیمان),
				'one' => q(دلار جزایر سلیمان),
				'other' => q(دلار جزایر سلیمان),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(روپیهٔ سیشل),
				'one' => q(روپیهٔ سیشل),
				'other' => q(روپیهٔ سیشل),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(دینار سودان \(۱۹۹۲ تا ۲۰۰۷\)),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(پوند سودان),
				'one' => q(پوند سودان),
				'other' => q(پوند سودان),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(کرون سوئد),
				'one' => q(کرون سوئد),
				'other' => q(کرون سوئد),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(دلار سنگاپور),
				'one' => q(دلار سنگاپور),
				'other' => q(دلار سنگاپور),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(پوند سنت هلن),
				'one' => q(پوند سنت هلن),
				'other' => q(پوند سنت هلن),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(لئون سیرالئون),
				'one' => q(لئون سیرالئون),
				'other' => q(لئون سیرالئون),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(شیلینگ سومالی),
				'one' => q(شیلینگ سومالی),
				'other' => q(شیلینگ سومالی),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(دلار سورینام),
				'one' => q(دلار سورینام),
				'other' => q(دلار سورینام),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(گیلدر سورینام),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(پوند سودان جنوبی),
				'one' => q(پوند سودان جنوبی),
				'other' => q(پوند سودان جنوبی),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(دوبرای سائوتومه و پرنسیپ \(۱۹۷۷ تا ۲۰۱۷\)),
				'one' => q(دوبرای سائوتومه و پرنسیپ \(۱۹۷۷ تا ۲۰۱۷\)),
				'other' => q(دوبرای سائوتومه و پرنسیپ \(۱۹۷۷ تا ۲۰۱۷\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(دوبرای سائوتومه و پرنسیپ),
				'one' => q(دوبرای سائوتومه و پرنسیپ),
				'other' => q(دوبرای سائوتومه و پرنسیپ),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(روبل شوروی),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(لیرهٔ سوریه),
				'one' => q(لیرهٔ سوریه),
				'other' => q(لیرهٔ سوریه),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(لیلانگنی سوازیلند),
				'one' => q(لیلانگنی سوازیلند),
				'other' => q(لیلانگنی سوازیلند),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(بات تایلند),
				'one' => q(بات تایلند),
				'other' => q(بات تایلند),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(روبل تاجیکستان),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(سامانی تاجیکستان),
				'one' => q(سامانی تاجیکستان),
				'other' => q(سامانی تاجیکستان),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(منات ترکمنستان \(۱۹۹۳ تا ۲۰۰۹\)),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(منات ترکمنستان),
				'one' => q(منات ترکمنستان),
				'other' => q(منات ترکمنستان),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(دینار تونس),
				'one' => q(دینار تونس),
				'other' => q(دینار تونس),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(پاآنگای تونگا),
				'one' => q(پاآنگای تونگا),
				'other' => q(پاآنگای تونگا),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(اسکودوی تیمور),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(لیرهٔ ترکیه \(۱۹۲۲ تا ۲۰۰۵\)),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(لیرهٔ ترکیه),
				'one' => q(لیرهٔ ترکیه),
				'other' => q(لیرهٔ ترکیه),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(دلار ترینیداد و توباگو),
				'one' => q(دلار ترینیداد و توباگو),
				'other' => q(دلار ترینیداد و توباگو),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(دلار جدید تایوان),
				'one' => q(دلار جدید تایوان),
				'other' => q(دلار جدید تایوان),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(شیلینگ تانزانیا),
				'one' => q(شیلینگ تانزانیا),
				'other' => q(شیلینگ تانزانیا),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(هریونیای اوکراین),
				'one' => q(هریونیای اوکراین),
				'other' => q(هریونیای اوکراین),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(شیلینگ اوگاندا \(۱۹۶۶ تا ۱۹۸۷\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(شیلینگ اوگاندا),
				'one' => q(شیلینگ اوگاندا),
				'other' => q(شیلینگ اوگاندا),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(دلار امریکا),
				'one' => q(دلار امریکا),
				'other' => q(دلار امریکا),
			},
		},
		'USN' => {
			symbol => 'USN',
			display_name => {
				'currency' => q(دلار امریکا \(روز بعد\)),
				'one' => q(دلار امریکا \(روز بعد\)),
				'other' => q(دلار امریکا \(روز بعد\)),
			},
		},
		'USS' => {
			symbol => 'USS',
			display_name => {
				'currency' => q(دلار امریکا \(همان روز\)),
				'one' => q(دلار امریکا \(همان روز\)),
				'other' => q(دلار امریکا \(همان روز\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(پزوی اوروگوئه \(۱۹۷۵ تا ۱۹۹۳\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(پزوی اوروگوئه),
				'one' => q(پزوی اوروگوئه),
				'other' => q(پزوی اوروگوئه),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(سوم ازبکستان),
				'one' => q(سوم ازبکستان),
				'other' => q(سوم ازبکستان),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(بولیوار ونزوئلا \(۱۸۷۱ تا ۲۰۰۸\)),
				'one' => q(بولیوار ونزوئلا \(۱۸۷۱ تا ۲۰۰۸\)),
				'other' => q(بولیوار ونزوئلا \(۱۸۷۱ تا ۲۰۰۸\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(بولیوار ونزوئلا \(۲۰۰۸ تا ۲۰۱۸\)),
				'one' => q(بولیوار ونزوئلا \(۲۰۰۸ تا ۲۰۱۸\)),
				'other' => q(بولیوار ونزوئلا \(۲۰۰۸ تا ۲۰۱۸\)),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(بولیوار ونزوئلا),
				'one' => q(بولیوار ونزوئلا),
				'other' => q(بولیوار ونزوئلا),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(دانگ ویتنام),
				'one' => q(دانگ ویتنام),
				'other' => q(دانگ ویتنام),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(واتوی وانوواتو),
				'one' => q(واتوی وانوواتو),
				'other' => q(واتوی وانوواتو),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(تالای ساموا),
				'one' => q(تالای ساموا),
				'other' => q(تالای ساموا),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(فرانک CFA مرکز افریقا),
				'one' => q(فرانک CFA مرکز افریقا),
				'other' => q(فرانک CFA مرکز افریقا),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(نقره),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(طلا),
			},
		},
		'XCD' => {
			symbol => '$EC',
			display_name => {
				'currency' => q(دلار شرق کارائیب),
				'one' => q(دلار شرق کارائیب),
				'other' => q(دلار شرق کارائیب),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(فرانک طلای فرانسه),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(فرانک CFA غرب افریقا),
				'one' => q(فرانک CFA غرب افریقا),
				'other' => q(فرانک CFA غرب افریقا),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(پالادیم),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(فرانک اقیانوسیه),
				'one' => q(فرانک اقیانوسیه),
				'other' => q(فرانک اقیانوسیه),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(پلاتین),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(ارز نامشخص),
				'one' => q(\(واحد ارز نامشخص\)),
				'other' => q(\(ارز نامشخص\)),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(دینار یمن),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(ریال یمن),
				'one' => q(ریال یمن),
				'other' => q(ریال یمن),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(راند افریقای جنوبی),
				'one' => q(راند افریقای جنوبی),
				'other' => q(راند افریقای جنوبی),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(کواچای زامبیا \(۱۹۶۸ تا ۲۰۱۲\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(کواچای زامبیا),
				'one' => q(کواچای زامبیا),
				'other' => q(کواچای زامبیا),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(دلار زیمبابوه \(۱۹۸۰ تا ۲۰۰۸\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(دلار زیمبابوه \(۲۰۰۹\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(دلار زیمبابوه \(۲۰۰۸\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'توت',
							'پاوی',
							'اثور',
							'کواق',
							'طوفی',
							'ماخیر',
							'فامینوث',
							'فرموثی',
							'پاخون',
							'پاونی',
							'افیفی',
							'ماسوری',
							'ماه کوچک'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'توت',
							'پاوی',
							'اثور',
							'کواق',
							'طوفی',
							'ماخیر',
							'فامینوث',
							'فرموثی',
							'پاخون',
							'پاونی',
							'افیفی',
							'ماسوری',
							'ماه کوچک'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'توت',
							'پاوی',
							'اثور',
							'کواق',
							'طوفی',
							'ماخیر',
							'فامینوث',
							'فرموثی',
							'پاخون',
							'پاونی',
							'افیفی',
							'ماسوری',
							'ماه کوچک'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'توت',
							'پاوی',
							'اثور',
							'کواق',
							'طوفی',
							'ماخیر',
							'فامینوث',
							'فرموثی',
							'پاخون',
							'پاونی',
							'افیفی',
							'ماسوری',
							'ماه کوچک'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'مسکرم',
							'تکیمت',
							'هیدار',
							'طه‌ساز',
							'تر',
							'یکوتیت',
							'مگابیت',
							'میازیا',
							'گین‌بوت',
							'سنه',
							'حمله',
							'نحسه',
							'پاگومه'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'مسکرم',
							'تکیمت',
							'هیدار',
							'طه‌ساز',
							'تر',
							'یکوتیت',
							'مگابیت',
							'میازیا',
							'گین‌بوت',
							'سنه',
							'حمله',
							'نحسه',
							'پاگومه'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'مسکرم',
							'تکیمت',
							'هیدار',
							'طه‌ساز',
							'تر',
							'یکوتیت',
							'مگابیت',
							'میازیا',
							'گین‌بوت',
							'سنه',
							'حمله',
							'نحسه',
							'پاگومه'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'مسکرم',
							'تکیمت',
							'هیدار',
							'طه‌ساز',
							'تر',
							'یکوتیت',
							'مگابیت',
							'میازیا',
							'گین‌بوت',
							'سنه',
							'حمله',
							'نحسه',
							'پاگومه'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ژانویهٔ',
							'فوریهٔ',
							'مارس',
							'آوریل',
							'مهٔ',
							'ژوئن',
							'ژوئیهٔ',
							'اوت',
							'سپتامبر',
							'اکتبر',
							'نوامبر',
							'دسامبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ژ',
							'ف',
							'م',
							'آ',
							'م',
							'ژ',
							'ژ',
							'ا',
							'س',
							'ا',
							'ن',
							'د'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ژانویهٔ',
							'فوریهٔ',
							'مارس',
							'آوریل',
							'مهٔ',
							'ژوئن',
							'ژوئیهٔ',
							'اوت',
							'سپتامبر',
							'اکتبر',
							'نوامبر',
							'دسامبر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ژانویه',
							'فوریه',
							'مارس',
							'آوریل',
							'مه',
							'ژوئن',
							'ژوئیه',
							'اوت',
							'سپتامبر',
							'اکتبر',
							'نوامبر',
							'دسامبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ژ',
							'ف',
							'م',
							'آ',
							'م',
							'ژ',
							'ژ',
							'ا',
							'س',
							'ا',
							'ن',
							'د'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ژانویه',
							'فوریه',
							'مارس',
							'آوریل',
							'مه',
							'ژوئن',
							'ژوئیه',
							'اوت',
							'سپتامبر',
							'اکتبر',
							'نوامبر',
							'دسامبر'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'تشری',
							'حشوان',
							'کسلو',
							'طوت',
							'شباط',
							'آذار',
							'واذار',
							'نیسان',
							'ایار',
							'سیوان',
							'تموز',
							'آب',
							'ایلول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'واذار الثانی'
						],
					},
					narrow => {
						nonleap => [
							'ت',
							'ح',
							'ک',
							'ط',
							'ش',
							'آ',
							'و',
							'ن',
							'ا',
							'س',
							'ت',
							'آ',
							'ا'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'و'
						],
					},
					wide => {
						nonleap => [
							'تشری',
							'حشوان',
							'کسلو',
							'طوت',
							'شباط',
							'آذار',
							'واذار',
							'نیسان',
							'ایار',
							'سیوان',
							'تموز',
							'آب',
							'ایلول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'واذار الثانی'
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'تشری',
							'حشوان',
							'کسلو',
							'طوت',
							'شباط',
							'آذار',
							'واذار',
							'نیسان',
							'ایار',
							'سیوان',
							'تموز',
							'آب',
							'ایلول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'واذار الثانی'
						],
					},
					narrow => {
						nonleap => [
							'ت',
							'ح',
							'ک',
							'ط',
							'ش',
							'آ',
							'و',
							'ن',
							'ا',
							'س',
							'ت',
							'آ',
							'ا'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'و'
						],
					},
					wide => {
						nonleap => [
							'تشری',
							'حشوان',
							'کسلو',
							'طوت',
							'شباط',
							'آذار',
							'واذار',
							'نیسان',
							'ایار',
							'سیوان',
							'تموز',
							'آب',
							'ایلول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'واذار الثانی'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'چیتره',
							'ویشاکهه',
							'جییشته',
							'آشادهه',
							'شراونه',
							'بهادره',
							'آشوین',
							'کارتیکه',
							'آگرهینه',
							'پاوشه',
							'ماگهه',
							'پهالگونه'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'چیتره',
							'ویشاکهه',
							'جییشته',
							'آشادهه',
							'شراونه',
							'بهادره',
							'آشوین',
							'کارتیکه',
							'آگرهینه',
							'پاوشه',
							'ماگهه',
							'پهالگونه'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'چیتره',
							'ویشاکهه',
							'جییشته',
							'آشادهه',
							'شراونه',
							'بهادره',
							'آشوین',
							'کارتیکه',
							'آگرهینه',
							'پاوشه',
							'ماگهه',
							'پهالگونه'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'چیتره',
							'ویشاکهه',
							'جییشته',
							'آشادهه',
							'شراونه',
							'بهادره',
							'آشوین',
							'کارتیکه',
							'آگرهینه',
							'پاوشه',
							'ماگهه',
							'پهالگونه'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع‌الاول',
							'ربیع‌الثانی',
							'جمادی‌الاول',
							'جمادی‌الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذیقعدهٔ',
							'ذیحجهٔ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع‌الاول',
							'ربیع‌الثانی',
							'جمادی‌الاول',
							'جمادی‌الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذیقعدهٔ',
							'ذیحجهٔ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع‌الاول',
							'ربیع‌الثانی',
							'جمادی‌الاول',
							'جمادی‌الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذیقعده',
							'ذیحجه'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع‌الاول',
							'ربیع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذیقعده',
							'ذیحجه'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'فروردین',
							'اردیبهشت',
							'خرداد',
							'تیر',
							'مرداد',
							'شهریور',
							'مهر',
							'آبان',
							'آذر',
							'دی',
							'بهمن',
							'اسفند'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ف',
							'ا',
							'خ',
							'ت',
							'م',
							'ش',
							'م',
							'آ',
							'آ',
							'د',
							'ب',
							'ا'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'فروردین',
							'اردیبهشت',
							'خرداد',
							'تیر',
							'مرداد',
							'شهریور',
							'مهر',
							'آبان',
							'آذر',
							'دی',
							'بهمن',
							'اسفند'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'فروردین',
							'اردیبهشت',
							'خرداد',
							'تیر',
							'مرداد',
							'شهریور',
							'مهر',
							'آبان',
							'آذر',
							'دی',
							'بهمن',
							'اسفند'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ف',
							'ا',
							'خ',
							'ت',
							'م',
							'ش',
							'م',
							'آ',
							'آ',
							'د',
							'ب',
							'ا'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'فروردین',
							'اردیبهشت',
							'خرداد',
							'تیر',
							'مرداد',
							'شهریور',
							'مهر',
							'آبان',
							'آذر',
							'دی',
							'بهمن',
							'اسفند'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'دوشنبه',
						tue => 'سه‌شنبه',
						wed => 'چهارشنبه',
						thu => 'پنجشنبه',
						fri => 'جمعه',
						sat => 'شنبه',
						sun => 'یکشنبه'
					},
					narrow => {
						mon => 'د',
						tue => 'س',
						wed => 'چ',
						thu => 'پ',
						fri => 'ج',
						sat => 'ش',
						sun => 'ی'
					},
					short => {
						mon => '۲ش',
						tue => '۳ش',
						wed => '۴ش',
						thu => '۵ش',
						fri => 'ج',
						sat => 'ش',
						sun => '۱ش'
					},
					wide => {
						mon => 'دوشنبه',
						tue => 'سه‌شنبه',
						wed => 'چهارشنبه',
						thu => 'پنجشنبه',
						fri => 'جمعه',
						sat => 'شنبه',
						sun => 'یکشنبه'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'دوشنبه',
						tue => 'سه‌شنبه',
						wed => 'چهارشنبه',
						thu => 'پنجشنبه',
						fri => 'جمعه',
						sat => 'شنبه',
						sun => 'یکشنبه'
					},
					narrow => {
						mon => 'د',
						tue => 'س',
						wed => 'چ',
						thu => 'پ',
						fri => 'ج',
						sat => 'ش',
						sun => 'ی'
					},
					short => {
						mon => '۲ش',
						tue => '۳ش',
						wed => '۴ش',
						thu => '۵ش',
						fri => 'ج',
						sat => 'ش',
						sun => '۱ش'
					},
					wide => {
						mon => 'دوشنبه',
						tue => 'سه‌شنبه',
						wed => 'چهارشنبه',
						thu => 'پنجشنبه',
						fri => 'جمعه',
						sat => 'شنبه',
						sun => 'یکشنبه'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'س‌م۱',
						1 => 'س‌م۲',
						2 => 'س‌م۳',
						3 => 'س‌م۴'
					},
					narrow => {0 => '۱',
						1 => '۲',
						2 => '۳',
						3 => '۴'
					},
					wide => {0 => 'سه‌ماههٔ اول',
						1 => 'سه‌ماههٔ دوم',
						2 => 'سه‌ماههٔ سوم',
						3 => 'سه‌ماههٔ چهارم'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'س‌م۱',
						1 => 'س‌م۲',
						2 => 'س‌م۳',
						3 => 'س‌م۴'
					},
					narrow => {0 => '۱',
						1 => '۲',
						2 => '۳',
						3 => '۴'
					},
					wide => {0 => 'سه‌ماههٔ اول',
						1 => 'سه‌ماههٔ دوم',
						2 => 'سه‌ماههٔ سوم',
						3 => 'سه‌ماههٔ چهارم'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'chinese') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1700
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1700;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'noon' => q{ظ},
					'afternoon1' => q{ب.ظ.},
					'morning1' => q{ص},
					'evening1' => q{ع},
					'night1' => q{ش},
					'am' => q{ق},
					'midnight' => q{ن},
					'pm' => q{ب},
				},
				'wide' => {
					'midnight' => q{نیمه‌شب},
					'pm' => q{بعدازظهر},
					'am' => q{قبل‌ازظهر},
					'night1' => q{شب},
					'evening1' => q{عصر},
					'morning1' => q{صبح},
					'noon' => q{ظهر},
					'afternoon1' => q{بعدازظهر},
				},
				'abbreviated' => {
					'pm' => q{ب.ظ.},
					'midnight' => q{نیمه‌شب},
					'am' => q{ق.ظ.},
					'night1' => q{شب},
					'evening1' => q{عصر},
					'morning1' => q{صبح},
					'noon' => q{ظهر},
					'afternoon1' => q{ب.ظ.},
				},
			},
			'stand-alone' => {
				'wide' => {
					'noon' => q{ظهر},
					'afternoon1' => q{بعدازظهر},
					'morning1' => q{صبح},
					'evening1' => q{عصر},
					'night1' => q{شب},
					'am' => q{قبل‌ازظهر},
					'pm' => q{بعدازظهر},
					'midnight' => q{نیمه‌شب},
				},
				'narrow' => {
					'night1' => q{ش},
					'am' => q{ق.ظ.},
					'pm' => q{ب.ظ.},
					'midnight' => q{ن},
					'noon' => q{ظ},
					'afternoon1' => q{ب.ظ.},
					'morning1' => q{ص},
					'evening1' => q{ع},
				},
				'abbreviated' => {
					'evening1' => q{عصر},
					'morning1' => q{صبح},
					'afternoon1' => q{بعدازظهر},
					'noon' => q{ظهر},
					'pm' => q{ب.ظ.},
					'midnight' => q{نیمه‌شب},
					'am' => q{ق.ظ.},
					'night1' => q{شب},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'تقویم بودایی'
			},
			narrow => {
				'0' => 'تقویم بودایی'
			},
			wide => {
				'0' => 'تقویم بودایی'
			},
		},
		'chinese' => {
		},
		'coptic' => {
			abbreviated => {
				'0' => 'قبل از مسیح',
				'1' => 'پس از مسیح'
			},
			narrow => {
				'0' => 'ق.م.',
				'1' => 'ب.م.'
			},
			wide => {
				'0' => 'قبل از حلول مسیح',
				'1' => 'بعد از حلول مسیح'
			},
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			narrow => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			wide => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ق.م.',
				'1' => 'م.'
			},
			narrow => {
				'0' => 'ق',
				'1' => 'م'
			},
			wide => {
				'0' => 'قبل از میلاد',
				'1' => 'میلادی'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'تقویم عبری'
			},
			narrow => {
				'0' => 'تقویم عبری'
			},
			wide => {
				'0' => 'تقویم عبری'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'تقویم ساکا'
			},
			narrow => {
				'0' => 'تقویم ساکا'
			},
			wide => {
				'0' => 'تقویم ساکا'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'ه‍.ق.'
			},
			narrow => {
				'0' => 'ه‍.ق.'
			},
			wide => {
				'0' => 'هجری قمری'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'ه‍.ش.'
			},
			narrow => {
				'0' => 'ه‍.ش.'
			},
			wide => {
				'0' => 'هجری شمسی'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'قبل از R.O.C.',
				'1' => 'تقویم مینگو'
			},
			narrow => {
				'0' => 'قبل از R.O.C.',
				'1' => 'تقویم مینگو'
			},
			wide => {
				'0' => 'قبل از R.O.C.',
				'1' => 'تقویم مینگو'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{G EEEE d MMMM y},
			'long' => q{G d MMMM y},
			'medium' => q{G d MMM y},
			'short' => q{G d/M/y},
		},
		'gregorian' => {
			'full' => q{EEEE d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{y/M/d},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
			'full' => q{EEEE d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{y/M/d G},
		},
		'persian' => {
			'full' => q{y MMMM d, EEEE},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{y/M/d},
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{H:mm:ss (zzzz)},
			'long' => q{H:mm:ss (z)},
			'medium' => q{H:mm:ss},
			'short' => q{H:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1}، ساعت {0}},
			'long' => q{{1}، ساعت {0}},
			'medium' => q{{1}،‏ {0}},
			'short' => q{{1}،‏ {0}},
		},
		'gregorian' => {
			'full' => q{{1}، ساعت {0}},
			'long' => q{{1}، ساعت {0}},
			'medium' => q{{1}،‏ {0}},
			'short' => q{{1}،‏ {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'persian' => {
			y => q{y},
			yyyy => q{y},
			yyyyM => q{y/M},
			yyyyMEd => q{E y/M/d},
			yyyyMMM => q{MMM y},
			yyyyMMMEd => q{E d MMM y},
			yyyyMMMM => q{y MMMM},
			yyyyMMMd => q{d MMM y},
			yyyyMd => q{y/M/d},
			yyyyQQQ => q{QQQQ y},
			yyyyQQQQ => q{QQQQ y},
		},
		'islamic' => {
			E => q{ccc},
			Ed => q{E d},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{H},
			Hm => q{H:mm},
			HmZ => q{HH:mm (Z)},
			Hms => q{H:mm:ss},
			M => q{L},
			MEd => q{E M/d},
			MMM => q{LLL},
			MMMEd => q{E d LLL},
			MMMMEd => q{E d LLLL},
			MMMMd => q{d LLLL},
			MMMd => q{d LLL},
			Md => q{M/d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yM => q{y/M},
			yMEd => q{E y/M/d},
			yMMM => q{MMM y},
			yMMMEd => q{E d MMM y},
			yMMMM => q{MMMM y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yyyy => q{y G},
			yyyyM => q{y/M G},
			yyyyMEd => q{E y/M/d G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E d MMM y G},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{y/M/d G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{H},
			HHmmZ => q{HH:mm (Z)},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{L},
			MEd => q{E M/d},
			MMM => q{LLL},
			MMMEd => q{E d LLL},
			MMMMEd => q{E d LLLL},
			MMMMd => q{d LLLL},
			MMMd => q{d LLL},
			Md => q{M/d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{y/M G},
			yyyyMEd => q{E y/M/d G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E d MMM y G},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{y/M/d G},
			yyyyQQQ => q{QQQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E H:mm},
			EHms => q{E H:mm:ss},
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{H},
			HHmmZ => q{HH:mm (Z)},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E M/d},
			MMM => q{LLL},
			MMMEd => q{E d LLL},
			MMMMEd => q{E d LLLL},
			MMMMW => q{هفته W از MMM},
			MMMMd => q{d LLLL},
			MMMd => q{d LLL},
			Md => q{M/d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			mmss => q{mm:ss},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y/M},
			yMEd => q{E y/M/d},
			yMMM => q{MMM y},
			yMMMEd => q{E d MMM y},
			yMMMM => q{MMMM y},
			yMMMMEEEEd => q{EEEE d MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{y/M/d},
			yQQQ => q{QQQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{هفته w از Y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'Day-Of-Week' => '{1} {0}',
			'Timezone' => '{0} ({1})',
		},
		'gregorian' => {
			'Day-Of-Week' => '{1} {0}',
			'Timezone' => '{0} ({1})',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'persian' => {
			y => {
				y => q{y تا y},
			},
			yM => {
				M => q{y/M تا y/M},
				y => q{y/M تا y/M},
			},
			yMEd => {
				M => q{E y/M/d تا E y/M/d},
				d => q{E y/M/d تا E y/M/d},
				y => q{E y/M/d تا E y/M/d},
			},
			yMMM => {
				M => q{LLL تا MMM y},
				y => q{MMM y تا MMM y},
			},
			yMMMEd => {
				M => q{E d LLL تا E d MMM y},
				d => q{E d LLL تا E d MMM y},
				y => q{E d MMM y تا E d MMM y},
			},
			yMMMM => {
				M => q{LLLL تا MMMM y},
				y => q{MMMM y تا MMMM y},
			},
			yMMMd => {
				M => q{d LLL تا d MMM y},
				d => q{d تا d MMM y},
				y => q{d MMM y تا d MMM y},
			},
			yMd => {
				M => q{y/M/d تا y/M/d},
				d => q{y/M/d تا y/M/d},
				y => q{y/M/d تا y/M/d},
			},
		},
		'generic' => {
			H => {
				H => q{H تا H},
			},
			Hm => {
				H => q{H:mm تا H:mm},
				m => q{H:mm تا H:mm},
			},
			Hmv => {
				H => q{H:mm تا H:mm (v)},
				m => q{H:mm تا H:mm (v)},
			},
			Hv => {
				H => q{H تا H (v)},
			},
			M => {
				M => q{M تا M},
			},
			MEd => {
				M => q{E M/d تا E M/d},
				d => q{E M/d تا E M/d},
			},
			MMM => {
				M => q{MMM تا MMM},
			},
			MMMEd => {
				M => q{E d LLL تا E d LLL},
				d => q{E d LLL تا E d LLL},
			},
			MMMd => {
				M => q{d LLL تا d LLL},
				d => q{d تا d LLL},
			},
			Md => {
				M => q{M/d تا M/d},
				d => q{M/d تا M/d},
			},
			d => {
				d => q{d تا d},
			},
			fallback => '{0} تا {1}',
			h => {
				a => q{h a تا h a},
				h => q{h تا h a},
			},
			hm => {
				a => q{h:mm a تا h:mm a},
				h => q{h:mm تا h:mm a},
				m => q{h:mm تا h:mm a},
			},
			hmv => {
				a => q{h:mm a تا h:mm a (v)},
				h => q{h:mm تا h:mm a (v)},
				m => q{h:mm تا h:mm a (v)},
			},
			hv => {
				a => q{h a تا h a (v)},
				h => q{h تا h a (v)},
			},
			y => {
				y => q{y تا y G},
			},
			yM => {
				M => q{y/M تا y/M G},
				y => q{y/M تا y/M G},
			},
			yMEd => {
				M => q{E y/M/d تا E y/M/d G},
				d => q{E y/M/d تا E y/M/d G},
				y => q{E y/M/d تا E y/M/d G},
			},
			yMMM => {
				M => q{LLL تا MMM y G},
				y => q{MMM y تا MMM y G},
			},
			yMMMEd => {
				M => q{E d LLL تا E d MMM y G},
				d => q{E d LLL تا E d MMM y G},
				y => q{E d MMM y تا E d MMM y G},
			},
			yMMMM => {
				M => q{LLLL تا MMMM y G},
				y => q{MMMM y تا MMMM y G},
			},
			yMMMd => {
				M => q{d LLL تا d MMM y G},
				d => q{d تا d MMM y G},
				y => q{d MMM y تا d MMM y G},
			},
			yMd => {
				M => q{y/M/d تا y/M/d G},
				d => q{y/M/d تا y/M/d G},
				y => q{y/M/d تا y/M/d G},
			},
		},
		'gregorian' => {
			H => {
				H => q{H تا H},
			},
			Hm => {
				H => q{H:mm تا H:mm},
				m => q{H:mm تا H:mm},
			},
			Hmv => {
				H => q{H:mm تا H:mm v},
				m => q{H:mm تا H:mm v},
			},
			Hv => {
				H => q{H تا H v},
			},
			M => {
				M => q{M تا M},
			},
			MEd => {
				M => q{E M/d تا E M/d},
				d => q{E M/d تا E M/d},
			},
			MMM => {
				M => q{LLL تا LLL},
			},
			MMMEd => {
				M => q{E d LLL تا E d LLL},
				d => q{E d LLL تا E d LLL},
			},
			MMMd => {
				M => q{d LLL تا d LLL},
				d => q{d تا d LLL},
			},
			Md => {
				M => q{M/d تا M/d},
				d => q{M/d تا M/d},
			},
			d => {
				d => q{d تا d},
			},
			fallback => '{0} تا {1}',
			h => {
				a => q{h a تا h a},
				h => q{h تا h a},
			},
			hm => {
				a => q{h:mm a تا h:mm a},
				h => q{h:mm تا h:mm a},
				m => q{h:mm تا h:mm a},
			},
			hmv => {
				a => q{h:mm a تا h:mm a v},
				h => q{h:mm تا h:mm a v},
				m => q{h:mm تا h:mm a v},
			},
			hv => {
				a => q{h a تا h a v},
				h => q{h تا h a v},
			},
			y => {
				y => q{y تا y},
			},
			yM => {
				M => q{y/M تا y/M},
				y => q{y/M تا y/M},
			},
			yMEd => {
				M => q{E y/M/d تا E y/M/d},
				d => q{E y/M/d تا E y/M/d},
				y => q{E y/M/d تا E y/M/d},
			},
			yMMM => {
				M => q{LLL تا MMM y},
				y => q{MMM y تا MMM y},
			},
			yMMMEd => {
				M => q{E d LLL تا E d MMM y},
				d => q{E d LLL تا E d MMM y},
				y => q{E d MMM y تا E d MMM y},
			},
			yMMMM => {
				M => q{LLLL تا MMMM y},
				y => q{MMMM y تا MMMM y},
			},
			yMMMd => {
				M => q{d LLL تا d MMM y},
				d => q{d تا d MMM y},
				y => q{d MMM y تا d MMM y},
			},
			yMd => {
				M => q{y/M/d تا y/M/d},
				d => q{y/M/d تا y/M/d},
				y => q{y/M/d تا y/M/d},
			},
		},
	} },
);

has 'cyclic_name_sets' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
			'zodiacs' => {
				'format' => {
					'abbreviated' => {
						0 => q(موش),
						1 => q(گاو),
						2 => q(ببر),
						3 => q(خرگوش),
						4 => q(اژدها),
						5 => q(مار),
						6 => q(اسب),
						7 => q(بز),
						8 => q(میمون),
						9 => q(خروس),
						10 => q(سگ),
						11 => q(خوک),
					},
				},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(‎+HH:mm;‎−HH:mm),
		gmtFormat => q({0} گرینویچ),
		gmtZeroFormat => q(گرینویچ),
		regionFormat => q(وقت {0}),
		regionFormat => q(وقت تابستانی {0}),
		regionFormat => q(وقت عادی {0}),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#وقت افغانستان#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#آبیجان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#اکرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#آدیس آبابا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#الجزیره#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#اسمره#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#باماکو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بانگی#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بانجول#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بیسائو#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلانتیره#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برازویل#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بوجومبورا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#قاهره#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#کازابلانکا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#سبته#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#کوناکری#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#داکار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دارالسلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#جیبوتی#,
		},
		'Africa/Douala' => {
			exemplarCity => q#دوآلا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#العیون#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فری‌تاون#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#گابورون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#هراره#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ژوهانسبورگ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جوبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#کامپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#خارطوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#کیگالی#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#کینشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لاگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لیبرویل#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لومه#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لواندا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لوبومباشی#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لوزاکا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#مالابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ماپوتو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ماسرو#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مبابانه#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موگادیشو#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونروویا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نایروبی#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#انجامنا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نیامی#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نوآکشوت#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#اوآگادوگو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورتو نووو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#سائوتومه#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#طرابلس#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#شهر تونس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ویندهوک#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#وقت مرکز افریقا#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#وقت شرق افریقا#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#وقت عادی جنوب افریقا#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#وقت تابستانی غرب افریقا#,
				'generic' => q#وقت غرب افریقا#,
				'standard' => q#وقت عادی غرب افریقا#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#وقت تابستانی آلاسکا#,
				'generic' => q#وقت آلاسکا#,
				'standard' => q#وقت عادی آلاسکا#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#وقت تابستانی آلماآتا#,
				'generic' => q#وقت آلماآتا#,
				'standard' => q#وقت عادی آلماآتا#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#وقت تابستانی آمازون#,
				'generic' => q#وقت آمازون#,
				'standard' => q#وقت عادی آمازون#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#ایدک#,
		},
		'America/Anchorage' => {
			exemplarCity => q#انکوریج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#آنگوئیلا#,
		},
		'America/Antigua' => {
			exemplarCity => q#آنتیگوا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#آراگواینا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لاریوخا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ریوگالگوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالتا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سن‌خوان#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سن‌لوئیس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#توکومن#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اوشوایا#,
		},
		'America/Aruba' => {
			exemplarCity => q#اروبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#آسونسیون#,
		},
		'America/Bahia' => {
			exemplarCity => q#بایا#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#باهیا باندراس#,
		},
		'America/Barbados' => {
			exemplarCity => q#باربادوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بلم#,
		},
		'America/Belize' => {
			exemplarCity => q#بلیز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلان‐سابلون#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بوئاویستا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بوگوتا#,
		},
		'America/Boise' => {
			exemplarCity => q#بویسی#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بوئنوس‌آیرس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#کمبریج‌بی#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#کمپو گرانده#,
		},
		'America/Cancun' => {
			exemplarCity => q#کانکون#,
		},
		'America/Caracas' => {
			exemplarCity => q#کاراکاس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#کاتامارکا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#کاین#,
		},
		'America/Cayman' => {
			exemplarCity => q#کیمن#,
		},
		'America/Chicago' => {
			exemplarCity => q#شیکاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چیواوا#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اتکوکان#,
		},
		'America/Cordoba' => {
			exemplarCity => q#کوردووا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#کاستاریکا#,
		},
		'America/Creston' => {
			exemplarCity => q#کرستون#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#کویاوا#,
		},
		'America/Curacao' => {
			exemplarCity => q#کوراسائو#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#دانمارکس‌هاون#,
		},
		'America/Dawson' => {
			exemplarCity => q#داوسن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#داوسن کریک#,
		},
		'America/Denver' => {
			exemplarCity => q#دنور#,
		},
		'America/Detroit' => {
			exemplarCity => q#دیترویت#,
		},
		'America/Dominica' => {
			exemplarCity => q#دومینیکا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ادمونتون#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ایرونپه#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#السالوادور#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#فورت نلسون#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورتالزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گلیس‌بی#,
		},
		'America/Godthab' => {
			exemplarCity => q#نووک#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوس‌بی#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#گراند تورک#,
		},
		'America/Grenada' => {
			exemplarCity => q#گرنادا#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گوادلوپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گواتمالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گوایاکیل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گویان#,
		},
		'America/Halifax' => {
			exemplarCity => q#هلیفکس#,
		},
		'America/Havana' => {
			exemplarCity => q#هاوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ارموسیو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ناکس، ایندیانا#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#مارنگو، ایندیانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پیترزبرگ، ایندیانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#تل‌سیتی، ایندیانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ویوی، ایندیانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#وینسنس، اندیانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ویناماک، ایندیانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ایندیاناپولیس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#اینوویک#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ایکلوئت#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جامائیکا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#خوخوی#,
		},
		'America/Juneau' => {
			exemplarCity => q#جونو#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مانتیسلو، کنتاکی#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#کرالندیک#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لاپاز#,
		},
		'America/Lima' => {
			exemplarCity => q#لیما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لوس‌آنجلس#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوئیزویل#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#بخش شاهزاده‌‌نشین پایین#,
		},
		'America/Maceio' => {
			exemplarCity => q#ماسیو#,
		},
		'America/Managua' => {
			exemplarCity => q#ماناگوا#,
		},
		'America/Manaus' => {
			exemplarCity => q#ماناوس#,
		},
		'America/Marigot' => {
			exemplarCity => q#ماریگات#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارتینیک#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ماتاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ماساتلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مندوسا#,
		},
		'America/Menominee' => {
			exemplarCity => q#منامینی#,
		},
		'America/Merida' => {
			exemplarCity => q#مریدا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#متالاکاتلا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#مکزیکوسیتی#,
		},
		'America/Miquelon' => {
			exemplarCity => q#میکلون#,
		},
		'America/Moncton' => {
			exemplarCity => q#مانکتون#,
		},
		'America/Monterrey' => {
			exemplarCity => q#مونتری#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونته‌ویدئو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مونتسرات#,
		},
		'America/Nassau' => {
			exemplarCity => q#ناسائو#,
		},
		'America/New_York' => {
			exemplarCity => q#نیویورک#,
		},
		'America/Nipigon' => {
			exemplarCity => q#نیپیگان#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورونیا#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بیولا، داکوتای شمالی#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#سنتر، داکوتای شمالی#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نیوسالم، داکوتای شمالی#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#اخیناگا#,
		},
		'America/Panama' => {
			exemplarCity => q#پاناما#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#پانگنیرتونگ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پاراماریبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#فینکس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پورتوپرنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#پورت‌آواسپین#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پورتوولیو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پورتوریکو#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#پونتا آرناس#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#رینی‌ریور#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#خلیجک رنکین#,
		},
		'America/Recife' => {
			exemplarCity => q#ریسیفی#,
		},
		'America/Regina' => {
			exemplarCity => q#رجاینا#,
		},
		'America/Resolute' => {
			exemplarCity => q#رزولوت#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ریوبرانکو#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#سانتا ایزابل#,
		},
		'America/Santarem' => {
			exemplarCity => q#سنتارم#,
		},
		'America/Santiago' => {
			exemplarCity => q#سانتیاگو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سانتو دومینگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#سائوپائولو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#اسکورسبیسوند#,
		},
		'America/Sitka' => {
			exemplarCity => q#سیتکا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سنت بارتلمی#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سنت جان#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سنت کیتس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سنت لوسیا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سنت توماس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سنت وینسنت#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سویفت‌کارنت#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#تگوسیگالپا#,
		},
		'America/Thule' => {
			exemplarCity => q#تول#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#تاندربی#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تیخوانا#,
		},
		'America/Toronto' => {
			exemplarCity => q#تورنتو#,
		},
		'America/Tortola' => {
			exemplarCity => q#تورتولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ونکوور#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وایت‌هورس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#وینیپگ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#یاکوتات#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#یلونایف#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#وقت تابستانی مرکز امریکا#,
				'generic' => q#وقت مرکز امریکا#,
				'standard' => q#وقت عادی مرکز امریکا#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#وقت تابستانی شرق امریکا#,
				'generic' => q#وقت شرق امریکا#,
				'standard' => q#وقت عادی شرق امریکا#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#وقت تابستانی کوهستانی امریکا#,
				'generic' => q#وقت کوهستانی امریکا#,
				'standard' => q#وقت عادی کوهستانی امریکا#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#وقت تابستانی غرب امریکا#,
				'generic' => q#وقت غرب امریکا#,
				'standard' => q#وقت عادی غرب امریکا#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#وقت تابستانی آنادیر#,
				'generic' => q#وقت آنادیر#,
				'standard' => q#وقت عادی آنادیر#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#کیسی#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#دیویس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#دومون دورویل#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#مکواری#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ماوسون#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#مک‌موردو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پالمر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روترا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#شووا#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ترول#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#وستوک#,
		},
		'Apia' => {
			long => {
				'daylight' => q#وقت تابستانی آپیا#,
				'generic' => q#وقت آپیا#,
				'standard' => q#وقت عادی آپیا#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#وقت تابستانی عربستان#,
				'generic' => q#وقت عربستان#,
				'standard' => q#وقت عادی عربستان#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لانگ‌یربین#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#وقت تابستانی آرژانتین#,
				'generic' => q#وقت آرژانتین#,
				'standard' => q#وقت عادی آرژانتین#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#وقت تابستانی غرب آرژانتین#,
				'generic' => q#وقت غرب آرژانتین#,
				'standard' => q#وقت عادی غرب آرژانتین#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#وقت تابستانی ارمنستان#,
				'generic' => q#وقت ارمنستان#,
				'standard' => q#وقت عادی ارمنستان#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#عدن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#آلماتی#,
		},
		'Asia/Amman' => {
			exemplarCity => q#عمّان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#آنادیر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#آقتاو#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#آقتوبه#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#عشق‌آباد#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#آتیراو#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بحرین#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باکو#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بانکوک#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#بارنائول#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بیروت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بیشکک#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برونئی#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#کلکته#,
		},
		'Asia/Chita' => {
			exemplarCity => q#چیتا#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#چویبالسان#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#کلمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دمشق#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#داکا#,
		},
		'Asia/Dili' => {
			exemplarCity => q#دیلی#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دبی#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دوشنبه#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#فاماگوستا#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غزه#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#الخلیل#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#هنگ‌کنگ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#خوود#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ایرکوتسک#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جاکارتا#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جایاپورا#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#اورشلیم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#کابل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#کامچاتکا#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#کراچی#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کاتماندو#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#خاندیگا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#کراسنویارسک#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#کوالالامپور#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کوچینگ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#کویت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ماکائو#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ماگادان#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ماکاسار#,
		},
		'Asia/Manila' => {
			exemplarCity => q#مانیل#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مسقط#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نیکوزیا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نوووکوزنتسک#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نووسیبیریسک#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسک#,
		},
		'Asia/Oral' => {
			exemplarCity => q#اورال#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#پنوم‌پن#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونتیاناک#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#پیونگ‌یانگ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قطر#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#قیزیل‌اوردا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#یانگون#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ریاض#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#هوشی‌مین‌سیتی#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ساخالین#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سمرقند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سئول#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شانگهای#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سنگاپور#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#اسردنکولیمسک#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تایپه#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشکند#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#تفلیس#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تهران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#تیمفو#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#توکیو#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#تومسک#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اولان‌باتور#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ارومچی#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#اوست نرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وینتیان#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ولادی‌وستوک#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#یاکوتسک#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#یکاترینبرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ایروان#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#وقت تابستانی آتلانتیک#,
				'generic' => q#وقت آتلانتیک#,
				'standard' => q#وقت عادی آتلانتیک#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#آزور#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برمودا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#قناری#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#کیپ‌ورد#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فارو#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#مادیرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ریکیاویک#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#جورجیای جنوبی#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سنت هلنا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#استانلی#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#آدلاید#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#بریسبین#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروکن‌هیل#,
		},
		'Australia/Currie' => {
			exemplarCity => q#کوری#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#داروین#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#اوکلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#هوبارت#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لیندمن#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لردهاو#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ملبورن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پرت#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سیدنی#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#وقت تابستانی مرکز استرالیا#,
				'generic' => q#وقت مرکز استرالیا#,
				'standard' => q#وقت عادی مرکز استرالیا#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#وقت تابستانی مرکز-غرب استرالیا#,
				'generic' => q#وقت مرکز-غرب استرالیا#,
				'standard' => q#وقت عادی مرکز-غرب استرالیا#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#وقت تابستانی شرق استرالیا#,
				'generic' => q#وقت شرق استرالیا#,
				'standard' => q#وقت عادی شرق استرالیا#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#وقت تابستانی غرب استرالیا#,
				'generic' => q#وقت غرب استرالیا#,
				'standard' => q#وقت عادی غرب استرالیا#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#وقت تابستانی جمهوری آذربایجان#,
				'generic' => q#وقت جمهوری آذربایجان#,
				'standard' => q#وقت عادی جمهوری آذربایجان#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#وقت تابستانی آزور#,
				'generic' => q#وقت آزور#,
				'standard' => q#وقت عادی آزور#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#وقت تابستانی بنگلادش#,
				'generic' => q#وقت بنگلادش#,
				'standard' => q#وقت عادی بنگلادش#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#وقت بوتان#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#وقت بولیوی#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#وقت تابستانی برازیلیا#,
				'generic' => q#وقت برازیلیا#,
				'standard' => q#وقت عادی برازیلیا#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#وقت برونئی دارالسلام#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#وقت تابستانی کیپ‌ورد#,
				'generic' => q#وقت کیپ‌ورد#,
				'standard' => q#وقت عادی کیپ‌ورد#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#وقت عادی چامورو#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#وقت تابستانی چت‌هام#,
				'generic' => q#وقت چت‌هام#,
				'standard' => q#وقت عادی چت‌هام#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#وقت تابستانی شیلی#,
				'generic' => q#وقت شیلی#,
				'standard' => q#وقت عادی شیلی#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#وقت تابستانی چین#,
				'generic' => q#وقت چین#,
				'standard' => q#وقت عادی چین#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#وقت تابستانی چویبالسان#,
				'generic' => q#وقت چویبالسان#,
				'standard' => q#وقت عادی چویبالسان#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#وقت جزیرهٔ کریسمس#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#وقت جزایر کوکوس#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#وقت تابستانی کلمبیا#,
				'generic' => q#وقت کلمبیا#,
				'standard' => q#وقت عادی کلمبیا#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#وقت تابستانی جزایر کوک#,
				'generic' => q#وقت جزایر کوک#,
				'standard' => q#وقت عادی جزایر کوک#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#وقت تابستانی کوبا#,
				'generic' => q#وقت کوبا#,
				'standard' => q#وقت عادی کوبا#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#وقت دیویس#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#وقت دومون دورویل#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#وقت تیمور شرقی#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#وقت تابستانی جزیرهٔ ایستر#,
				'generic' => q#وقت جزیرهٔ ایستر#,
				'standard' => q#وقت عادی جزیرهٔ ایستر#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#وقت اکوادور#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#زمان هماهنگ جهانی#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#شهر نامشخص#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#آمستردام#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#آندورا#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#آستراخان#,
		},
		'Europe/Athens' => {
			exemplarCity => q#آتن#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بلگراد#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#برلین#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#براتیسلاوا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#بروکسل#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بخارست#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بوداپست#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بازنگن#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#کیشیناو#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#کپنهاگ#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#دوبلین#,
			long => {
				'daylight' => q#وقت عادی ایرلند#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#جبل‌الطارق#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#گرنزی#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#هلسینکی#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#جزیرهٔ من#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#استانبول#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جرزی#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#کالینینگراد#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#کیف#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#کیروف#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لیسبون#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#لیوبلیانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لندن#,
			long => {
				'daylight' => q#وقت تابستانی بریتانیا#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لوکزامبورگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#مادرید#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالت#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ماریه‌هامن#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#مینسک#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناکو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#مسکو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پاریس#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پادگاریتسا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراگ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ریگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#رم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سامارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سان‌مارینو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#سارایوو#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#ساراتوف#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سیمفروپل#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#اسکوپیه#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#صوفیه#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#استکهلم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#تالین#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#تیرانا#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#اولیانوفسک#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#اوژگورود#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#فادوتس#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#واتیکان#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#وین#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ویلنیوس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ولگاگراد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ورشو#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زاگرب#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#زاپوروژیا#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زوریخ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#وقت تابستانی مرکز اروپا#,
				'generic' => q#وقت مرکز اروپا#,
				'standard' => q#وقت عادی مرکز اروپا#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#وقت تابستانی شرق اروپا#,
				'generic' => q#وقت شرق اروپا#,
				'standard' => q#وقت عادی شرق اروپا#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#وقت تابستانی مکان‌های دیگر شرق اروپا#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#وقت تابستانی غرب اروپا#,
				'generic' => q#وقت غرب اروپا#,
				'standard' => q#وقت عادی غرب اروپا#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#وقت تابستانی جزایر فالکلند#,
				'generic' => q#وقت جزایر فالکلند#,
				'standard' => q#وقت عادی جزایر فالکلند#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#وقت تابستانی فیجی#,
				'generic' => q#وقت فیجی#,
				'standard' => q#وقت عادی فیجی#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#وقت گویان فرانسه#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#وقت سرزمین‌های جنوبی و جنوبگان فرانسه#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#وقت گرینویچ#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#وقت گالاپاگوس#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#وقت گامبیه#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#وقت تابستانی گرجستان#,
				'generic' => q#وقت گرجستان#,
				'standard' => q#وقت عادی گرجستان#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#وقت جزایر گیلبرت#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#وقت تابستانی شرق گرینلند#,
				'generic' => q#وقت شرق گرینلند#,
				'standard' => q#وقت عادی شرق گرینلند#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#وقت تابستانی غرب گرینلند#,
				'generic' => q#وقت غرب گرینلند#,
				'standard' => q#وقت عادی غرب گرینلند#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#وقت عادی گوام#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#وقت عادی خلیج فارس#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#وقت گویان#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#وقت تابستانی هاوایی‐الوشن#,
				'generic' => q#وقت هاوایی‐الوشن#,
				'standard' => q#وقت عادی هاوایی‐الوشن#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#وقت تابستانی هنگ‌کنگ#,
				'generic' => q#وقت هنگ‌کنگ#,
				'standard' => q#وقت عادی هنگ‌کنگ#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#وقت تابستانی خوود#,
				'generic' => q#وقت خوود#,
				'standard' => q#وقت عادی خوود#,
			},
		},
		'India' => {
			long => {
				'standard' => q#وقت هند#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#آنتاناناریوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#شاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#کریسمس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#کوکوس#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#کومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#کرگولن#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماهه#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالدیو#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#موریس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#مایوت#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#رئونیون#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#وقت اقیانوس هند#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#وقت هندوچین#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#وقت مرکز اندونزی#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#وقت شرق اندونزی#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#وقت غرب اندونزی#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#وقت تابستانی ایران#,
				'generic' => q#وقت ایران#,
				'standard' => q#وقت عادی ایران#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#وقت تابستانی ایرکوتسک#,
				'generic' => q#وقت ایرکوتسک#,
				'standard' => q#وقت عادی ایرکوتسک#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#وقت تابستانی اسرائیل#,
				'generic' => q#وقت اسرائیل#,
				'standard' => q#وقت عادی اسرائیل#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#وقت تابستانی ژاپن#,
				'generic' => q#وقت ژاپن#,
				'standard' => q#وقت عادی ژاپن#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#وقت تابستانی پتروپاولوسک‐کامچاتسکی#,
				'generic' => q#وقت پتروپاولوسک‐کامچاتسکی#,
				'standard' => q#وقت عادی پتروپاولوسک‐کامچاتسکی#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#وقت شرق قزاقستان#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#وقت غرب قزاقستان#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#وقت تابستانی کره#,
				'generic' => q#وقت کره#,
				'standard' => q#وقت عادی کره#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#وقت کوسرای#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#وقت تابستانی کراسنویارسک#,
				'generic' => q#وقت کراسنویارسک#,
				'standard' => q#وقت عادی کراسنویارسک#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#وقت قرقیزستان#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#وقت لانکا#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#وقت جزایر لاین#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#وقت تابستانی لردهو#,
				'generic' => q#وقت لردهو#,
				'standard' => q#وقت عادی لردهو#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#وقت تابستانی ماکائو#,
				'generic' => q#وقت ماکائو#,
				'standard' => q#وقت عادی ماکائو#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#وقت جزیرهٔ مکواری#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#وقت تابستانی ماگادان#,
				'generic' => q#وقت ماگادان#,
				'standard' => q#وقت عادی ماگادان#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#وقت مالزی#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#وقت مالدیو#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#وقت مارکوئز#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#وقت جزایر مارشال#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#وقت تابستانی موریس#,
				'generic' => q#وقت موریس#,
				'standard' => q#وقت عادی موریس#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#وقت ماوسون#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#وقت تابستانی شمال غرب مکزیک#,
				'generic' => q#وقت شمال غرب مکزیک#,
				'standard' => q#وقت عادی شمال غرب مکزیک#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#وقت تابستانی شرق مکزیک#,
				'generic' => q#وقت شرق مکزیک#,
				'standard' => q#وقت عادی شرق مکزیک#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#وقت تابستانی اولان‌باتور#,
				'generic' => q#وقت اولان‌باتور#,
				'standard' => q#وقت عادی اولان‌باتور#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#وقت تابستانی مسکو#,
				'generic' => q#وقت مسکو#,
				'standard' => q#وقت عادی مسکو#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#وقت میانمار#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#وقت نائورو#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#وقت نپال#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#وقت تابستانی کالدونیای جدید#,
				'generic' => q#وقت کالدونیای جدید#,
				'standard' => q#وقت عادی کالدونیای جدید#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#وقت تابستانی زلاند نو#,
				'generic' => q#وقت زلاند نو#,
				'standard' => q#وقت عادی زلاند نو#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#وقت تابستانی نیوفاندلند#,
				'generic' => q#وقت نیوفاندلند#,
				'standard' => q#وقت عادی نیوفاندلند#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#وقت نیوئه#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#وقت جزایر نورفولک#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#وقت تابستانی فرناندو دی نورونیا#,
				'generic' => q#وقت فرناندو دی نورونیا#,
				'standard' => q#وقت عادی فرناندو دی نورونیا#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#وقت جزایر ماریانای شمالی#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#وقت تابستانی نووسیبیرسک#,
				'generic' => q#وقت نووسیبیرسک#,
				'standard' => q#وقت عادی نووسیبیرسک#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#وقت تابستانی اومسک#,
				'generic' => q#وقت اومسک#,
				'standard' => q#وقت عادی اومسک#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#آپیا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#اوکلند#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#بوگنویل#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چتم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ایستر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#افاته#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#اندربری#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فاکائوفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فیجی#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فونافوتی#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گالاپاگوس#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گامبیر#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گوادال‌کانال#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گوام#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#هونولولو#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#جانستون#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#کریتیماتی#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#کوسرای#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#کواجیلین#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ماجورو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مارکوزه#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#میدوی#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#نائورو#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نیوئه#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نورفولک#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نومئا#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پاگوپاگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پالائو#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پیت‌کرن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پانپی#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پورت‌مورزبی#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروتونگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سایپان#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تاهیتی#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#تاراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#تونگاتاپو#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#چوک#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ویک#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#والیس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#وقت تابستانی پاکستان#,
				'generic' => q#وقت پاکستان#,
				'standard' => q#وقت عادی پاکستان#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#وقت پالائو#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#وقت پاپوا گینهٔ نو#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#وقت تابستانی پاراگوئه#,
				'generic' => q#وقت پاراگوئه#,
				'standard' => q#وقت عادی پاراگوئه#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#وقت تابستانی پرو#,
				'generic' => q#وقت پرو#,
				'standard' => q#وقت عادی پرو#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#وقت تابستانی فیلیپین#,
				'generic' => q#وقت فیلیپین#,
				'standard' => q#وقت عادی فیلیپین#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#وقت جزایر فونیکس#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#وقت تابستانی سنت‌پیر و میکلون#,
				'generic' => q#وقت سنت‌پیر و میکلون#,
				'standard' => q#وقت عادی سنت‌پیر و میکلون#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#وقت پیتکایرن#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#وقت پوناپه#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#وقت پیونگ‌یانگ#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#وقت تابستانی قیزیل‌اوردا#,
				'generic' => q#وقت قیزیل‌اوردا#,
				'standard' => q#وقت عادی قیزیل‌اوردا#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#وقت ریونیون#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#وقت روترا#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#وقت تابستانی ساخالین#,
				'generic' => q#وقت ساخالین#,
				'standard' => q#وقت عادی ساخالین#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#وقت تابستانی سامارا#,
				'generic' => q#وقت سامارا#,
				'standard' => q#وقت عادی سامارا#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#وقت تابستانی ساموا#,
				'generic' => q#وقت ساموا#,
				'standard' => q#وقت عادی ساموا#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#وقت سیشل#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#وقت سنگاپور#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#وقت جزایر سلیمان#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#وقت جورجیای جنوبی#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#وقت سورینام#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#وقت شووا#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#وقت تاهیتی#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#وقت تابستانی تایپه#,
				'generic' => q#وقت تایپه#,
				'standard' => q#وقت عادی تایپه#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#وقت تاجیکستان#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#وقت توکلائو#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#وقت تابستانی تونگا#,
				'generic' => q#وقت تونگا#,
				'standard' => q#وقت عادی تونگا#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#وقت چوئوک#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#وقت تابستانی ترکمنستان#,
				'generic' => q#وقت ترکمنستان#,
				'standard' => q#وقت عادی ترکمنستان#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#وقت تووالو#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#وقت تابستانی اروگوئه#,
				'generic' => q#وقت اروگوئه#,
				'standard' => q#وقت عادی اروگوئه#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#وقت تابستانی ازبکستان#,
				'generic' => q#وقت ازبکستان#,
				'standard' => q#وقت عادی ازبکستان#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#وقت تابستانی واناتو#,
				'generic' => q#وقت واناتو#,
				'standard' => q#وقت عادی واناتو#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#وقت ونزوئلا#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#وقت تابستانی ولادی‌وستوک#,
				'generic' => q#وقت ولادی‌وستوک#,
				'standard' => q#وقت عادی ولادی‌وستوک#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#وقت تابستانی ولگاگراد#,
				'generic' => q#وقت ولگاگراد#,
				'standard' => q#وقت عادی ولگاگراد#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#وقت وستوک#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#وقت جزیرهٔ ویک#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#وقت والیس و فوتونا#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#وقت تابستانی یاکوتسک#,
				'generic' => q#وقت یاکوتسک#,
				'standard' => q#وقت عادی یاکوتسک#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#وقت تابستانی یکاترینبورگ#,
				'generic' => q#وقت یکاترینبورگ#,
				'standard' => q#وقت عادی یکاترینبورگ#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
