=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Sd - Package for language Sindhi

=cut

package Locale::CLDR::Locales::Sd;
# This file auto generated from Data\common\main\sd.xml
#	on Fri  3 Nov  7:12:33 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.3');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'افار',
 				'ab' => 'ابقازیان',
 				'ace' => 'اچائينيز',
 				'ada' => 'ادنگمي',
 				'ady' => 'اديگهي',
 				'af' => 'آفريڪي',
 				'agq' => 'اگهيم',
 				'ain' => 'آئينو',
 				'ak' => 'اڪان',
 				'ale' => 'اليوٽ',
 				'alt' => 'ڏکڻ التائي',
 				'am' => 'امهاري',
 				'an' => 'ارگني',
 				'anp' => 'انجيڪا',
 				'ar' => 'عربي',
 				'ar_001' => 'جديد معياري عربي',
 				'arn' => 'ماپوچي',
 				'arp' => 'اراپائو',
 				'as' => 'آسامي',
 				'asa' => 'اسو',
 				'ast' => 'اسٽورين',
 				'av' => 'اويرس',
 				'awa' => 'اواڌي',
 				'ay' => 'ایمارا',
 				'az' => 'آزربائيجاني',
 				'az@alt=short' => 'ازري',
 				'ba' => 'بشڪر',
 				'ban' => 'بالي',
 				'bas' => 'باسا',
 				'be' => 'بيلاروسي',
 				'bem' => 'بيمبا',
 				'bez' => 'بينا',
 				'bg' => 'بلغاريائي',
 				'bho' => 'ڀوجپوري',
 				'bi' => 'بسلاما',
 				'bin' => 'بني',
 				'bla' => 'سڪسڪا',
 				'bm' => 'بمبارا',
 				'bn' => 'بنگلا',
 				'bo' => 'تبيتائي',
 				'br' => 'بريٽن',
 				'brx' => 'بودو',
 				'bs' => 'بوسنيائي',
 				'bug' => 'بگنيز',
 				'byn' => 'بلن',
 				'ca' => 'ڪيٽالان',
 				'ce' => 'چیچن',
 				'ceb' => 'سبوانو',
 				'cgg' => 'چگا',
 				'ch' => 'چمورو',
 				'chk' => 'چڪيز',
 				'chm' => 'ماري',
 				'cho' => 'چوڪ تو',
 				'chr' => 'چروڪي',
 				'chy' => 'چايان',
 				'ckb' => 'مرڪزي ڪردش',
 				'co' => 'ڪارسيڪائي',
 				'crs' => 'سيسلوا ڪريئول فرانسي',
 				'cs' => 'چيڪ',
 				'cu' => 'چرچ سلاوی',
 				'cv' => 'چو واش',
 				'cy' => 'ويلش',
 				'da' => 'ڊينش',
 				'dak' => 'ڊڪوٽا',
 				'dar' => 'ڊارگوا',
 				'dav' => 'تائيتا',
 				'de' => 'جرمن',
 				'de_AT' => 'آسٽريائي جرمن',
 				'de_CH' => 'سوئس هائي جرمن',
 				'dgr' => 'داگرب',
 				'dje' => 'زارما',
 				'dsb' => 'لوئر سوربين',
 				'dua' => 'ڊيولا',
 				'dv' => 'دويهي',
 				'dyo' => 'جولا فوني',
 				'dz' => 'زونخا',
 				'dzg' => 'دزاگا',
 				'ebu' => 'ايمبيو',
 				'ee' => 'ايو',
 				'efi' => 'ايفڪ',
 				'eka' => 'ايڪاجڪ',
 				'el' => 'يوناني',
 				'en' => 'انگريزي',
 				'en_AU' => 'آسٽريليائي انگريزي',
 				'en_CA' => 'ڪينيڊيائي انگريزي',
 				'en_GB' => 'برطانوي انگريزي',
 				'en_GB@alt=short' => 'برطانوي انگريزي',
 				'en_US' => 'آمريڪي انگريزي',
 				'en_US@alt=short' => 'انگريزي (آمريڪا)',
 				'eo' => 'ايسپرانٽو',
 				'es' => 'اسپيني',
 				'es_419' => 'لاطيني آمريڪي اسپينش',
 				'es_ES' => 'يورپي اسپيني',
 				'et' => 'ايستونائي',
 				'eu' => 'باسڪي',
 				'ewo' => 'اوانڊو',
 				'fa' => 'فارسي',
 				'ff' => 'فلاهه',
 				'fi' => 'فنش',
 				'fil' => 'فلپائني',
 				'fj' => 'فجي',
 				'fo' => 'فيروايس',
 				'fon' => 'فون',
 				'fr' => 'فرانسي',
 				'fr_CA' => 'ڪينيڊيائي فرانسيسي',
 				'fr_CH' => 'سوئس فرانسيسي',
 				'fur' => 'فرائي لئين',
 				'fy' => 'مغربي فريشن',
 				'ga' => 'آئرش',
 				'gaa' => 'گا',
 				'gd' => 'اسڪاٽش گيلڪ',
 				'gez' => 'جيز',
 				'gil' => 'گلبرٽيز',
 				'gl' => 'گليشئين',
 				'gn' => 'گواراني',
 				'gor' => 'گورنٽلو',
 				'gsw' => 'سوئس جرمن',
 				'gu' => 'گجراتي',
 				'guz' => 'گشي',
 				'gv' => 'مينڪس',
 				'gwi' => 'گوچن',
 				'ha' => 'هوسا',
 				'haw' => 'هوائي',
 				'he' => 'عبراني',
 				'hi' => 'هندي',
 				'hil' => 'هلي گيانان',
 				'hmn' => 'مونگ',
 				'hr' => 'ڪروشيائي',
 				'hsb' => 'اپر سربيائي',
 				'ht' => 'هيٽي ڪرولي',
 				'hu' => 'هنگري',
 				'hup' => 'هوپا',
 				'hy' => 'ارماني',
 				'hz' => 'هريرو',
 				'ia' => 'انٽرلنگئا',
 				'iba' => 'ايبن',
 				'ibb' => 'ابيبيو',
 				'id' => 'انڊونيشي',
 				'ig' => 'اگبو',
 				'ii' => 'سچوان يي',
 				'ilo' => 'الوڪو',
 				'inh' => 'انگش',
 				'io' => 'ادو',
 				'is' => 'آئيس لينڊڪ',
 				'it' => 'اطالوي',
 				'iu' => 'انو ڪتوت',
 				'ja' => 'جاپاني',
 				'jbo' => 'لوجبين',
 				'jgo' => 'نغومبا',
 				'jmc' => 'ميڪم',
 				'jv' => 'جاونيز',
 				'ka' => 'جارجين',
 				'kab' => 'ڪبائل',
 				'kac' => 'ڪچن',
 				'kaj' => 'پوڪيپسي',
 				'kam' => 'ڪئمبا',
 				'kbd' => 'ڪبارڊيئن',
 				'kcg' => 'تياپ',
 				'kde' => 'مڪوندي',
 				'kea' => 'ڪيبيو ويرڊيانو',
 				'kfo' => 'ڪورو',
 				'kha' => 'خاسي',
 				'khq' => 'ڪيورا چني',
 				'ki' => 'اڪويو',
 				'kj' => 'ڪنياما',
 				'kk' => 'قازق',
 				'kkj' => 'ڪڪو',
 				'kl' => 'ڪالا ليسٽ',
 				'kln' => 'ڪيلين جن',
 				'km' => 'خمر',
 				'kmb' => 'ڪمبونڊو',
 				'kn' => 'ڪناڊا',
 				'ko' => 'ڪوريائي',
 				'kok' => 'ڪونڪي',
 				'kpe' => 'ڪپيل',
 				'kr' => 'ڪنوري',
 				'krc' => 'ڪراچي بالڪر',
 				'krl' => 'ڪريلئين',
 				'kru' => 'ڪورخ',
 				'ks' => 'ڪشميري',
 				'ksb' => 'شمبالا',
 				'ksf' => 'بافيا',
 				'ksh' => 'ڪلونئين',
 				'ku' => 'ڪردي',
 				'kum' => 'ڪومڪ',
 				'kv' => 'ڪومي',
 				'kw' => 'ڪورنش',
 				'ky' => 'ڪرغيز',
 				'la' => 'لاطيني',
 				'lad' => 'لڊينو',
 				'lag' => 'لانگي',
 				'lb' => 'لگزمبرگ',
 				'lez' => 'ليزگهين',
 				'lg' => 'گاندا',
 				'li' => 'لمبرگش',
 				'lkt' => 'لڪوٽا',
 				'ln' => 'لنگالا',
 				'lo' => 'لائو',
 				'loz' => 'لوزي',
 				'lrc' => 'اتر لوري',
 				'lt' => 'ليٿونيائي',
 				'lu' => 'لوبا-ڪتانگا',
 				'lua' => 'لوبا-لولوا',
 				'lun' => 'لنڊا',
 				'luo' => 'لو',
 				'lus' => 'ميزو',
 				'luy' => 'لوهيا',
 				'lv' => 'لاتوين',
 				'mad' => 'مدورائي',
 				'mag' => 'مگاهي',
 				'mai' => 'ميٿلي',
 				'mak' => 'مڪاسر',
 				'mas' => 'مسائي',
 				'mdf' => 'موڪشا',
 				'men' => 'مينڊي',
 				'mer' => 'ميرو',
 				'mfe' => 'موریسیین',
 				'mg' => 'ملاگاسي',
 				'mgh' => 'مخووا ميتو',
 				'mgo' => 'ميتا',
 				'mh' => 'مارشليز',
 				'mi' => 'مائوري',
 				'mic' => 'ميڪ مڪ',
 				'min' => 'مناڪابوا',
 				'mk' => 'ميسي ڊونيائي',
 				'ml' => 'مليالم',
 				'mn' => 'منگولي',
 				'mni' => 'ماني پوري',
 				'moh' => 'موهاڪ',
 				'mos' => 'موسي',
 				'mr' => 'مراٺي',
 				'ms' => 'ملي',
 				'mt' => 'مالٽي',
 				'mua' => 'من دانگ',
 				'mul' => 'هڪ کان وڌيڪ ٻوليون',
 				'mus' => 'ڪريڪ',
 				'mwl' => 'مرانڊيز',
 				'my' => 'برمي',
 				'myv' => 'ايريزيا',
 				'mzn' => 'مزيندراني',
 				'na' => 'نائو',
 				'nap' => 'نيپولٽن',
 				'naq' => 'ناما',
 				'nb' => 'نارويائي بوڪمال',
 				'nd' => 'اتر دبيلي',
 				'ne' => 'نيپالي',
 				'new' => 'نيواري',
 				'ng' => 'ڊونگا',
 				'nia' => 'نياس',
 				'niu' => 'نووي',
 				'nl' => 'ڊچ',
 				'nl_BE' => 'فلیمش',
 				'nmg' => 'ڪويسيو',
 				'nn' => 'نارويائي نيوناسڪ',
 				'nnh' => 'نغيمبون',
 				'nog' => 'نوگائي',
 				'nqo' => 'نڪو',
 				'nr' => 'ڏکڻ دبيلي',
 				'nso' => 'اتر سوٿو',
 				'nus' => 'نيور',
 				'nv' => 'نواجو',
 				'ny' => 'نيانجا',
 				'nyn' => 'نايانڪول',
 				'oc' => 'آڪسيٽن',
 				'om' => 'اورومو',
 				'or' => 'اوڊيا',
 				'os' => 'اوسيٽڪ',
 				'pa' => 'پنجابي',
 				'pag' => 'پانگا سينان',
 				'pam' => 'پيم پينگا',
 				'pap' => 'پاپي امينٽو',
 				'pau' => 'پلون',
 				'pcm' => 'نائيجرين پجن',
 				'pl' => 'پولش',
 				'prg' => 'پرشن',
 				'ps' => 'پشتو',
 				'pt' => 'پرتگالي',
 				'pt_BR' => 'برازيلي پرتگالي',
 				'pt_PT' => 'يورپي پرتگالي',
 				'qu' => 'ڪيچوا',
 				'quc' => 'ڪچي',
 				'rap' => 'ريپنوئي',
 				'rar' => 'ريرو ٽينگو',
 				'rm' => 'رومانش',
 				'rn' => 'رونڊي',
 				'ro' => 'روماني',
 				'ro_MD' => 'مالديوي',
 				'rof' => 'رومبو',
 				'root' => 'روٽ',
 				'ru' => 'روسي',
 				'rup' => 'ارومينين',
 				'rw' => 'ڪنيار وانڊا',
 				'rwk' => 'روا',
 				'sa' => 'سنسڪرت',
 				'sad' => 'سنداوي',
 				'sah' => 'ساخا',
 				'saq' => 'سيمبورو',
 				'sat' => 'سنتالي',
 				'sba' => 'نغمبي',
 				'sbp' => 'سانگوو',
 				'sc' => 'سارڊيني',
 				'scn' => 'سسلي',
 				'sco' => 'اسڪاٽس',
 				'sd' => 'سنڌي',
 				'se' => 'اتر سامي',
 				'seh' => 'سينا',
 				'ses' => 'ڪيورابورو سيني',
 				'sg' => 'سانگو',
 				'shi' => 'تيچل هاتي',
 				'shn' => 'شان',
 				'si' => 'سنهالا',
 				'sk' => 'سلواڪي',
 				'sl' => 'سلوويني',
 				'sm' => 'ساموآن',
 				'sma' => 'ڏکڻ سامي',
 				'smj' => 'لولي سامي',
 				'smn' => 'اناري سامي',
 				'sms' => 'اسڪاٽ سامي',
 				'sn' => 'شونا',
 				'snk' => 'سونينڪي',
 				'so' => 'سومالي',
 				'sq' => 'الباني',
 				'sr' => 'سربيائي',
 				'srn' => 'سرانن تانگو',
 				'ss' => 'سواتي',
 				'ssy' => 'سهو',
 				'st' => 'ڏکڻ سوٿي',
 				'su' => 'سوڊاني',
 				'suk' => 'سڪوما',
 				'sv' => 'سويڊني',
 				'sw' => 'سواحيلي',
 				'sw_CD' => 'ڪونگو سواحيلي',
 				'swb' => 'ڪمورين',
 				'syr' => 'شامي',
 				'ta' => 'تامل',
 				'te' => 'تلگو',
 				'tem' => 'تمني',
 				'teo' => 'تيسو',
 				'tet' => 'تيتم',
 				'tg' => 'تاجڪي',
 				'th' => 'ٿائي',
 				'ti' => 'تگرينيائي',
 				'tig' => 'تگري',
 				'tk' => 'ترڪماني',
 				'tlh' => 'ڪلون',
 				'tn' => 'تسوانا',
 				'to' => 'تونگن',
 				'tpi' => 'تاڪ پسن',
 				'tr' => 'ترڪ',
 				'trv' => 'تاروڪو',
 				'ts' => 'سونگا',
 				'tt' => 'تاتري',
 				'tum' => 'تمبوڪا',
 				'tvl' => 'توالو',
 				'twq' => 'تساوڪي',
 				'ty' => 'تاهيتي',
 				'tyv' => 'تووينيائي',
 				'tzm' => 'وچ اٽلس تمازائيٽ',
 				'udm' => 'ادمورتيا',
 				'ug' => 'يوغور',
 				'uk' => 'يوڪراني',
 				'umb' => 'اومبنڊو',
 				'und' => 'اڻڄاتل ٻولي',
 				'ur' => 'اردو',
 				'uz' => 'ازبڪ',
 				'vai' => 'يا',
 				've' => 'وينڊا',
 				'vi' => 'ويتنامي',
 				'vo' => 'والپڪ',
 				'vun' => 'ونجو',
 				'wa' => 'ولون',
 				'wae' => 'والسر',
 				'wal' => 'وولايٽا',
 				'war' => 'واري',
 				'wo' => 'وولف',
 				'xal' => 'ڪيلمڪ',
 				'xh' => 'زھوسا',
 				'xog' => 'سوگا',
 				'yav' => 'يانگ بين',
 				'ybb' => 'ييمبا',
 				'yi' => 'يدش',
 				'yo' => 'يوروبا',
 				'yue' => 'ڪينٽونيز',
 				'zgh' => 'معياري مراڪشي تامازائيٽ',
 				'zh' => 'چيني',
 				'zh_Hans' => 'آسان چینی',
 				'zh_Hant' => 'روايتي چيني',
 				'zu' => 'زولو',
 				'zun' => 'زوني',
 				'zxx' => 'ڪوئي ٻولي جو مواد ڪونهي',
 				'zza' => 'زازا',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'عربي',
 			'Armn' => 'عرماني',
 			'Beng' => 'بنگلا',
 			'Bopo' => 'بوپوموفو',
 			'Brai' => 'بريلي',
 			'Cyrl' => 'سيريلي',
 			'Deva' => 'ديوناگري',
 			'Ethi' => 'ايٿوپيائي',
 			'Geor' => 'جيورجيائي',
 			'Grek' => 'يوناني',
 			'Gujr' => 'گجراتي',
 			'Guru' => 'گرمکي',
 			'Hanb' => 'بوپوموفو سان هين',
 			'Hang' => 'هنگول',
 			'Hani' => 'هين',
 			'Hans' => 'سادي',
 			'Hans@alt=stand-alone' => 'سادي هين',
 			'Hant' => 'روايتي',
 			'Hant@alt=stand-alone' => 'روايتي هين',
 			'Hebr' => 'عبراني',
 			'Hira' => 'هراگنا',
 			'Hrkt' => 'جاپاني لکت',
 			'Jamo' => 'جامو',
 			'Jpan' => 'جاپاني',
 			'Kana' => 'ڪٽاڪانا',
 			'Khmr' => 'خمر',
 			'Knda' => 'ڪناڊا',
 			'Kore' => 'ڪوريائي',
 			'Laoo' => 'لائو',
 			'Latn' => 'لاطيني',
 			'Mlym' => 'مليالم',
 			'Mong' => 'منگولي',
 			'Mymr' => 'ميانمر',
 			'Orya' => 'اوڊيا',
 			'Sinh' => 'سنهالا',
 			'Taml' => 'تامل',
 			'Telu' => 'تلگو',
 			'Thaa' => 'ٿانا',
 			'Thai' => 'ٿائي',
 			'Tibt' => 'تبيتن',
 			'Zmth' => 'رياضي جون نشانيون',
 			'Zsye' => 'ايموجي',
 			'Zsym' => 'نشانيون',
 			'Zxxx' => 'اڻ لکيل',
 			'Zyyy' => 'ڪامن',
 			'Zzzz' => 'اڻڄاتل لکت',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'دنيا',
 			'002' => 'آفريڪا',
 			'003' => 'اتر آمريڪا',
 			'005' => 'ڏکڻ آمريڪا',
 			'009' => 'سامونڊي',
 			'011' => 'اولهه آفريقا',
 			'013' => 'وچ آمريڪا',
 			'014' => 'اوڀر آفريڪا',
 			'015' => 'اترين آفريڪا',
 			'017' => 'وچ آفريڪا',
 			'018' => 'ڏاکڻي آمريڪا',
 			'019' => 'آمريڪا',
 			'021' => 'اترين آمريڪا',
 			'029' => 'ڪيريبين',
 			'030' => 'اوڀر ايشيا',
 			'034' => 'ڏکڻ ايشيا',
 			'035' => 'ڏکڻ اوڀر ايشيا',
 			'039' => 'ڏکڻ يورپ',
 			'053' => 'آسٽریلیشیا',
 			'054' => 'میلانیشیا',
 			'057' => 'مائڪرونيشائي خطو',
 			'061' => 'پولینیشیا',
 			'142' => 'ايشيا',
 			'143' => 'وچ ايشيا',
 			'145' => 'اولهه ايشيا',
 			'150' => 'يورپ',
 			'151' => 'اوڀر يورپ',
 			'154' => 'اترين يورپ',
 			'155' => 'اولهه يورپ',
 			'202' => 'سب-سهارا آفريڪا',
 			'419' => 'لاطيني آمريڪا',
 			'AC' => 'طلوع ٻيٽ',
 			'AD' => 'اندورا',
 			'AE' => 'متحده عرب امارات',
 			'AF' => 'افغانستان',
 			'AG' => 'انٽيگئا و بربودا',
 			'AI' => 'انگويلا',
 			'AL' => 'البانيا',
 			'AM' => 'ارمینیا',
 			'AO' => 'انگولا',
 			'AQ' => 'انٽارڪٽيڪا',
 			'AR' => 'ارجنٽينا',
 			'AS' => 'آمريڪي ساموا',
 			'AT' => 'آشٽريا',
 			'AU' => 'آسٽريليا',
 			'AW' => 'عروبا',
 			'AX' => 'الند ٻيٽ',
 			'AZ' => 'آذربائيجان',
 			'BA' => 'بوسنیا اور هرزیگوینا',
 			'BB' => 'باربڊوس',
 			'BD' => 'بنگلاديش',
 			'BE' => 'بيلجيم',
 			'BF' => 'برڪينا فاسو',
 			'BG' => 'بلغاريا',
 			'BH' => 'بحرين',
 			'BI' => 'برونڊي',
 			'BJ' => 'بينن',
 			'BL' => 'سینٽ برٿلیمی',
 			'BM' => 'برمودا',
 			'BN' => 'برونائي',
 			'BO' => 'بوليويا',
 			'BQ' => 'ڪيريبين نيدرلينڊ',
 			'BR' => 'برازيل',
 			'BS' => 'بهاماس',
 			'BT' => 'ڀوٽان',
 			'BV' => 'بووٽ ٻيٽ',
 			'BW' => 'بوٽسوانا',
 			'BY' => 'بیلارس',
 			'BZ' => 'بيليز',
 			'CA' => 'ڪئناڊا',
 			'CC' => 'ڪوڪوس ٻيٽ',
 			'CD' => 'ڪانگو -ڪنشاسا',
 			'CD@alt=variant' => 'ڪانگو',
 			'CF' => 'وچ آفريقي جمهوريه',
 			'CG' => 'ڪانگو - برازاویل',
 			'CG@alt=variant' => 'ڪانگو (جمهوري)',
 			'CH' => 'سوئزرلينڊ',
 			'CI' => 'آئيوري ڪنارو',
 			'CI@alt=variant' => 'آئيوري ڪوسٽ',
 			'CK' => 'ڪوڪ ٻيٽ',
 			'CL' => 'چلي',
 			'CM' => 'ڪيمرون',
 			'CN' => 'چين',
 			'CO' => 'ڪولمبيا',
 			'CP' => 'ڪلپرٽن ٻيٽ',
 			'CR' => 'ڪوسٽا رڪا',
 			'CU' => 'ڪيوبا',
 			'CV' => 'ڪيپ وردي',
 			'CW' => 'ڪيوراسائو',
 			'CX' => 'ڪرسمس ٻيٽ',
 			'CY' => 'سائپرس',
 			'CZ' => 'چيڪيا',
 			'CZ@alt=variant' => 'چيڪ جهموريو',
 			'DE' => 'جرمني',
 			'DG' => 'ڊئيگو گارسيا',
 			'DJ' => 'ڊجبيوتي',
 			'DK' => 'ڊينمارڪ',
 			'DM' => 'ڊومينيڪا',
 			'DO' => 'ڊومينيڪن جمهوريه',
 			'DZ' => 'الجيريا',
 			'EA' => 'سیوٽا ۽ میلیلا',
 			'EC' => 'ايڪواڊور',
 			'EE' => 'ايسٽونيا',
 			'EG' => 'مصر',
 			'EH' => 'اولهه صحارا',
 			'ER' => 'ايريٽيريا',
 			'ES' => 'اسپين',
 			'ET' => 'ايٿوپيا',
 			'EU' => 'يورپين يونين',
 			'EZ' => 'يورو زون',
 			'FI' => 'فن لينڊ',
 			'FJ' => 'فجي',
 			'FK' => 'فاڪ لينڊ ٻيٽ',
 			'FK@alt=variant' => 'فلڪ لينڊ ٻيٽ',
 			'FM' => 'مائڪرونيشيا',
 			'FO' => 'فارو ٻيٽ',
 			'FR' => 'فرانس',
 			'GA' => 'گبون',
 			'GB' => 'برطانيه',
 			'GB@alt=short' => 'برطانيه',
 			'GD' => 'گرينڊا',
 			'GE' => 'جارجيا',
 			'GF' => 'فرانسيسي گيانا',
 			'GG' => 'گورنسي',
 			'GH' => 'گهانا',
 			'GI' => 'جبرالٽر',
 			'GL' => 'گرين لينڊ',
 			'GM' => 'گيمبيا',
 			'GN' => 'گني',
 			'GP' => 'گواڊیلوپ',
 			'GQ' => 'ايڪوٽوريل گائينا',
 			'GR' => 'يونان',
 			'GS' => 'ڏکڻ جارجيا ۽ ڏکڻ سينڊوچ ٻيٽ',
 			'GT' => 'گوئٽي مالا',
 			'GU' => 'گوام',
 			'GW' => 'گني بسائو',
 			'GY' => 'گيانا',
 			'HK' => 'هانگ ڪانگ',
 			'HK@alt=short' => 'هانگ ڪانگ',
 			'HM' => 'هرڊ ۽ مڪڊونلڊ ٻيٽ',
 			'HN' => 'هنڊورس',
 			'HR' => 'ڪروئيشيا',
 			'HT' => 'هيٽي',
 			'HU' => 'چيڪ جهموريه',
 			'IC' => 'ڪينري ٻيٽ',
 			'ID' => 'انڊونيشيا',
 			'IE' => 'آئرلينڊ',
 			'IL' => 'اسرائيل',
 			'IM' => 'انسانن جو ٻيٽ',
 			'IN' => 'انڊيا',
 			'IO' => 'برطانوي هندي سمنڊ خطو',
 			'IQ' => 'عراق',
 			'IR' => 'ايران',
 			'IS' => 'آئس لينڊ',
 			'IT' => 'اٽلي',
 			'JE' => 'جرسي',
 			'JM' => 'جميڪا',
 			'JO' => 'اردن',
 			'JP' => 'جاپان',
 			'KE' => 'ڪينيا',
 			'KG' => 'ڪرغستان',
 			'KH' => 'ڪمبوڊيا',
 			'KI' => 'ڪرباتي',
 			'KM' => 'ڪوموروس',
 			'KN' => 'سينٽ ڪٽس و نيوس',
 			'KP' => 'اتر ڪوريا',
 			'KR' => 'ڏکڻ ڪوريا',
 			'KW' => 'ڪويت',
 			'KY' => 'ڪي مين ٻيٽ',
 			'KZ' => 'قازقستان',
 			'LA' => 'لائوس',
 			'LB' => 'لبنان',
 			'LC' => 'سينٽ لوسيا',
 			'LI' => 'لچي ٽينسٽين',
 			'LK' => 'سري لنڪا',
 			'LR' => 'لائبیریا',
 			'LS' => 'ليسوٿو',
 			'LT' => 'لٿونيا',
 			'LU' => 'لیگزمبرگ',
 			'LV' => 'لاتويا',
 			'LY' => 'لبيا',
 			'MA' => 'موروڪو',
 			'MC' => 'موناڪو',
 			'MD' => 'مالدووا',
 			'ME' => 'مونٽي نيگرو',
 			'MF' => 'سينٽ مارٽن',
 			'MG' => 'مداگيسڪر',
 			'MH' => 'مارشل ڀيٽ',
 			'MK' => 'ميسي ڊونيا',
 			'MK@alt=variant' => 'ميڪدونيا',
 			'ML' => 'مالي',
 			'MM' => 'ميانمار (برما)',
 			'MN' => 'منگوليا',
 			'MO' => 'مڪائو',
 			'MO@alt=short' => 'مڪائو',
 			'MP' => 'اتر مرينا ٻيٽ',
 			'MQ' => 'مارتينڪ',
 			'MR' => 'موريتانيا',
 			'MS' => 'مونٽسراٽ',
 			'MT' => 'مالٽا',
 			'MU' => 'موريشس',
 			'MV' => 'مالديپ',
 			'MW' => 'مالاوي',
 			'MX' => 'ميڪسيڪو',
 			'MY' => 'ملائيشيا',
 			'MZ' => 'موزمبیق',
 			'NA' => 'نيميبيا',
 			'NC' => 'نیو ڪالیڊونیا',
 			'NE' => 'نائيجر',
 			'NF' => 'نورفوڪ ٻيٽ',
 			'NG' => 'نائيجيريا',
 			'NI' => 'نڪراگوا',
 			'NL' => 'نيدرلينڊ',
 			'NO' => 'ناروي',
 			'NP' => 'نيپال',
 			'NR' => 'نائورو',
 			'NU' => 'نووي',
 			'NZ' => 'نيو زيلينڊ',
 			'OM' => 'عمان',
 			'PA' => 'پناما',
 			'PE' => 'پيرو',
 			'PF' => 'فرانسيسي پولينيشيا',
 			'PG' => 'پاپوا نیو گني',
 			'PH' => 'فلپائن',
 			'PK' => 'پاڪستان',
 			'PL' => 'پولينڊ',
 			'PM' => 'سینٽ پیئر و میڪوئیلون',
 			'PN' => 'پٽڪئرن ٻيٽ',
 			'PR' => 'پيوئرٽو ريڪو',
 			'PS' => 'فلسطيني حدون',
 			'PS@alt=short' => 'فلسطين',
 			'PT' => 'پرتگال',
 			'PW' => 'پلائو',
 			'PY' => 'پيراگوءِ',
 			'QA' => 'قطر',
 			'QO' => 'بيروني سامونڊي',
 			'RE' => 'ري يونين',
 			'RO' => 'رومانيا',
 			'RS' => 'سربيا',
 			'RU' => 'روس',
 			'RW' => 'روانڊا',
 			'SA' => 'سعودی عرب',
 			'SB' => 'سولومون ٻيٽَ',
 			'SC' => 'شي شلز',
 			'SD' => 'سوڊان',
 			'SE' => 'سوئيڊن',
 			'SG' => 'سينگاپور',
 			'SH' => 'سينٽ ھيلينا',
 			'SI' => 'سلوینیا',
 			'SJ' => 'سوالبارڊ ۽ جان ماین',
 			'SK' => 'سلوواڪيا',
 			'SL' => 'سيرا ليون',
 			'SM' => 'سین مرینو',
 			'SN' => 'سينيگال',
 			'SO' => 'سوماليا',
 			'SR' => 'سورينام',
 			'SS' => 'ڏکڻ سوڊان',
 			'ST' => 'سائو ٽوم ۽ پرنسپیي',
 			'SV' => 'ال سلواڊور',
 			'SX' => 'سنٽ مارٽن',
 			'SY' => 'شام',
 			'SZ' => 'سوازيلينڊ',
 			'TA' => 'ٽرسٽن دا ڪوها',
 			'TC' => 'ترڪ ۽ ڪيڪوس ٻيٽ',
 			'TD' => 'چاڊ',
 			'TF' => 'فرانسيسي ڏاکڻي علائقا',
 			'TG' => 'توگو',
 			'TH' => 'ٿائيليند',
 			'TJ' => 'تاجڪستان',
 			'TK' => 'ٽوڪلائو',
 			'TL' => 'تيمور ليستي',
 			'TL@alt=variant' => 'اوڀر تيمور',
 			'TM' => 'ترڪمانستان',
 			'TN' => 'تيونيسيا',
 			'TO' => 'ٽونگا',
 			'TR' => 'ترڪي',
 			'TT' => 'ٽريني ڊيڊ ۽ ٽوباگو ٻيٽ',
 			'TV' => 'توالو',
 			'TW' => 'تائیوان',
 			'TZ' => 'تنزانيا',
 			'UA' => 'يوڪرين',
 			'UG' => 'يوگنڊا',
 			'UM' => 'آمريڪي ٻاهريون ٻيٽ',
 			'UN' => 'اقوام متحده',
 			'US' => 'آمريڪا جون گڏيل رياستون',
 			'US@alt=short' => 'يوايس',
 			'UY' => 'يوروگوءِ',
 			'UZ' => 'ازبڪستان',
 			'VA' => 'ويٽڪين سٽي',
 			'VC' => 'سینٽ ونسنت ۽ گریناڊینز',
 			'VE' => 'وينزيلا',
 			'VG' => 'برطانوي ورجن ٻيٽ',
 			'VI' => 'آمريڪي ورجن ٻيٽ',
 			'VN' => 'ويتنام',
 			'VU' => 'وينيٽيو',
 			'WF' => 'والس ۽ فتونا',
 			'WS' => 'سموئا',
 			'XK' => 'ڪوسووو',
 			'YE' => 'يمن',
 			'YT' => 'مياتي',
 			'ZA' => 'ڏکڻ آفريقا',
 			'ZM' => 'زيمبيا',
 			'ZW' => 'زمبابوي',
 			'ZZ' => 'اڻڄاتل خطو',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'ڪئلينڊر',
 			'cf' => 'سڪي جو فارميٽ',
 			'collation' => 'ترتيب ڇانٽي',
 			'currency' => 'سڪو',
 			'hc' => 'ڪلاڪ سائيڪل',
 			'lb' => 'لائن ٽوڙڻ انداز',
 			'ms' => 'ماپڻ جو نظام',
 			'numbers' => 'انگ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ٻڌ ڌرم جو ڪئلينڊر},
 				'chinese' => q{چيني ڪئلينڊر},
 				'dangi' => q{دانگي ڪئلينڊر},
 				'ethiopic' => q{ايٿوپيائي ڪئلينڊر},
 				'gregorian' => q{جارجيائي ڪئلينڊر},
 				'hebrew' => q{عبراني ڪئلينڊر},
 				'islamic' => q{اسلامي ڪئلينڊر},
 				'iso8601' => q{ISO-8601 ڪئلينڊر},
 				'japanese' => q{جاپاني ڪئلينڊر},
 				'persian' => q{فارسي ڪئلينڊر},
 				'roc' => q{منگوو ڪئلينڊر},
 			},
 			'cf' => {
 				'account' => q{اڪائونٽنگ سڪو فارميٽ},
 				'standard' => q{معياري سڪو فارميٽ},
 			},
 			'collation' => {
 				'ducet' => q{ڊفالٽ يوني ڪوڊ ترتيب ڇانٽي},
 				'search' => q{عام مقصد جي ڳولا},
 				'standard' => q{معياري ترتيب ڇانٽي},
 			},
 			'hc' => {
 				'h11' => q{12 ڪلاڪ جو سسٽم (0–11)},
 				'h12' => q{12 ڪلاڪ جو سسٽم (1–12)},
 				'h23' => q{24 ڪلاڪ جو سسٽم (0–23)},
 				'h24' => q{24 ڪلاڪ جو سسٽم (1–24)},
 			},
 			'lb' => {
 				'loose' => q{لوز لائن ٽوڙ انداز},
 				'normal' => q{عام لائن ٽوڙ انداز},
 				'strict' => q{سخت لائن ٽوڙ انداز},
 			},
 			'ms' => {
 				'metric' => q{ميٽرڪ نظام},
 				'uksystem' => q{امپيريل ماپڻ جو نظام},
 				'ussystem' => q{آمريڪا جو ماپڻ جو نظام},
 			},
 			'numbers' => {
 				'arab' => q{عربي-هندي عدد},
 				'arabext' => q{وڌايل عربي-هندي عدد},
 				'armn' => q{ارمينيائي انگ},
 				'armnlow' => q{ارمينيائي ننڍا انگ},
 				'beng' => q{بنگلا عدد},
 				'deva' => q{ديوناگري عدد},
 				'ethi' => q{ايٿوپيائي انگ},
 				'fullwide' => q{پوري-ويڪر انگن},
 				'geor' => q{جيارجيائي انگ},
 				'grek' => q{يوناني انگ},
 				'greklow' => q{يوناني ننڍا انگ},
 				'gujr' => q{گجراتي عدد},
 				'guru' => q{گرمکي عدد},
 				'hanidec' => q{چيني اعشاري انگ},
 				'hans' => q{آسان چيني انگ},
 				'hansfin' => q{آسان چيني مالي انگ},
 				'hant' => q{روايتي چيني انگ},
 				'hantfin' => q{روايتي چيني مالي انگ},
 				'hebr' => q{عبراني انگ},
 				'jpan' => q{جاپاني انگ},
 				'jpanfin' => q{جاپاني مالي انگ},
 				'khmr' => q{خمر عدد},
 				'knda' => q{ڪناڊا عدد},
 				'laoo' => q{لائو عدد},
 				'latn' => q{مغربي عدد},
 				'mlym' => q{مليالم عدد},
 				'mymr' => q{ميانمار عدد},
 				'orya' => q{اوڊيا عدد},
 				'roman' => q{رومي انگ},
 				'romanlow' => q{رومي ننڍا انگ},
 				'taml' => q{روايتي تامل انگ},
 				'tamldec' => q{تامل عدد},
 				'telu' => q{تيلگو عدد},
 				'thai' => q{ٿائي عدد},
 				'tibt' => q{تبتي عدد},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{ميٽرڪ},
 			'UK' => q{برطانيه},
 			'US' => q{آمريڪا},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'زبان: {0}',
 			'script' => 'اسڪرپٽ: {0}',
 			'region' => 'خطو: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => 'top-to-bottom',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ئ]},
			index => ['ا', 'ب', 'ٻ', 'پ', 'ڀ', 'ت', 'ث', 'ٺ', 'ٽ', 'ٿ', 'ج', '{جھ}', 'ڃ', 'ڄ', 'چ', 'ڇ', 'ح', 'خ', 'د', 'ذ', 'ڊ', 'ڌ', 'ڍ', 'ڏ', 'ر', 'ز', 'ڙ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ڦ', 'ق', 'ک', 'ڪ', 'گ', '{گھ}', 'ڱ', 'ڳ', 'ل', 'م', 'ن', 'ڻ', 'ه', 'ھ', 'و', 'ي'],
			main => qr{[آ ا ب ٻ پ ڀ ت ث ٺ ٽ ٿ ج {جھ} ڃ ڄ چ ڇ ح خ د ذ ڊ ڌ ڍ ڏ ر ز ڙ س ش ص ض ط ظ ع غ ف ڦ ق ک ڪ گ {گھ} ڱ ڳ ل م ن ڻ ه ھ و ي]},
			numbers => qr{[\- , . % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[⹁ ⁏ \: ! ۔ ‘ ( ) \[ \] \{ \} /]},
		};
	},
EOT
: sub {
		return { index => ['ا', 'ب', 'ٻ', 'پ', 'ڀ', 'ت', 'ث', 'ٺ', 'ٽ', 'ٿ', 'ج', '{جھ}', 'ڃ', 'ڄ', 'چ', 'ڇ', 'ح', 'خ', 'د', 'ذ', 'ڊ', 'ڌ', 'ڍ', 'ڏ', 'ر', 'ز', 'ڙ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ڦ', 'ق', 'ک', 'ڪ', 'گ', '{گھ}', 'ڱ', 'ڳ', 'ل', 'م', 'ن', 'ڻ', 'ه', 'ھ', 'و', 'ي'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'' => {
						'name' => q(ڪارڊينل ڊائريڪشن),
					},
					'acre' => {
						'name' => q(ايڪڙ),
						'one' => q({0} ايڪڙ),
						'other' => q({0} ايڪڙ),
					},
					'acre-foot' => {
						'name' => q(ايڪڙ فٽ),
						'one' => q({0} ايڪڙ فٽ),
						'other' => q({0} ايڪڙ فٽ),
					},
					'ampere' => {
						'name' => q(ایمپئیر),
						'one' => q({0} ایمپئیر),
						'other' => q({0} ایمپئیر),
					},
					'arc-minute' => {
						'name' => q(آرڪ منٽز),
						'one' => q({0} آرڪ منٽز),
						'other' => q({0} آرڪ منٽز),
					},
					'arc-second' => {
						'name' => q(آرڪ سيڪنڊز),
						'one' => q({0} آرڪ سيڪنڊز),
						'other' => q({0} آرڪ سيڪنڊز),
					},
					'astronomical-unit' => {
						'name' => q(فلڪيات جا يونٽ),
						'one' => q({0} فلڪيات جا يونٽ),
						'other' => q({0} فلڪيات جا يونٽ),
					},
					'atmosphere' => {
						'name' => q(ايٽماس فيئر),
						'one' => q({0} ايٽماس فيئر),
						'other' => q({0} ايٽماس فيئر),
					},
					'bit' => {
						'name' => q(بٽز),
						'one' => q({0} بٽ),
						'other' => q({0} بٽز),
					},
					'byte' => {
						'name' => q(بائيٽز),
						'one' => q({0} بائيٽ),
						'other' => q({0} بائيٽز),
					},
					'calorie' => {
						'name' => q(ڪيلوري),
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوريز),
					},
					'carat' => {
						'name' => q(ڪيرٽ),
						'one' => q({0} ڪيرٽ),
						'other' => q({0} ڪيرٽ),
					},
					'celsius' => {
						'name' => q(ڊگري سيلسيس),
						'one' => q({0} ڊگري سيلسيس),
						'other' => q({0} ڊگري سيلسيس),
					},
					'centiliter' => {
						'name' => q(سينٽي ليٽر),
						'one' => q({0} سينٽي ليٽر),
						'other' => q({0} سينٽي ليٽر),
					},
					'centimeter' => {
						'name' => q(سينٽي ميٽر),
						'one' => q({0} سينٽي ميٽر),
						'other' => q({0} سينٽي ميٽر),
						'per' => q({0} في سينٽي ميٽر),
					},
					'century' => {
						'name' => q(صديون),
						'one' => q({0} c),
						'other' => q({0} صديون),
					},
					'coordinate' => {
						'east' => q({0} اوڀر),
						'north' => q({0} اتر),
						'south' => q({0} ڏکڻ),
						'west' => q({0} اولهه),
					},
					'cubic-centimeter' => {
						'name' => q(ڪيوبڪ سينٽي ميٽر),
						'one' => q({0} ڪيوبڪ سينٽي ميٽر),
						'other' => q({0} ڪيوبڪ سينٽي ميٽر),
						'per' => q({0} في ڪيوبڪ سينٽي ميٽر),
					},
					'cubic-foot' => {
						'name' => q(ڪيوبڪ فٽ),
						'one' => q({0} ڪيوبڪ فٽ),
						'other' => q({0} ڪيوبڪ فٽ),
					},
					'cubic-inch' => {
						'name' => q(ڪيوبڪ انچ),
						'one' => q({0} ڪيوبڪ انچ),
						'other' => q({0} ڪيوبڪ انچ),
					},
					'cubic-kilometer' => {
						'name' => q(ڪيوبڪ ڪلوميٽر),
						'one' => q({0} ڪيوبڪ ڪلوميٽر),
						'other' => q({0} ڪيوبڪ ڪلوميٽر),
					},
					'cubic-meter' => {
						'name' => q(ڪيوبڪ ميٽر),
						'one' => q({0} ڪيوبڪ ميٽر),
						'other' => q({0} ڪيوبڪ ميٽر),
						'per' => q({0} في ڪيوبڪ ميٽر),
					},
					'cubic-mile' => {
						'name' => q(ڪيوبڪ ميل),
						'one' => q({0} ڪيوبڪ ميل),
						'other' => q({0} ڪيوبڪ ميل),
					},
					'cubic-yard' => {
						'name' => q(ڪيوبڪ يارڊ),
						'one' => q({0} ڪيوبڪ يارڊ),
						'other' => q({0} ڪيوبڪ يارڊ),
					},
					'cup' => {
						'name' => q(ڪپ ماپو),
						'one' => q({0} ڪپ ماپو),
						'other' => q({0} ڪپ ماپو),
					},
					'cup-metric' => {
						'name' => q(ميٽرڪ ڪپ),
						'one' => q({0} ميٽرڪ ڪپ),
						'other' => q({0} ميٽرڪ ڪپ),
					},
					'day' => {
						'name' => q(ڏينهن),
						'one' => q({0} ڏينهن),
						'other' => q({0} ڏينهن),
						'per' => q({0} في ڏينهن),
					},
					'deciliter' => {
						'name' => q(ڊيسي ليٽر),
						'one' => q({0} ڊيسي ليٽر),
						'other' => q({0} ڊيسي ليٽر),
					},
					'decimeter' => {
						'name' => q(ڊيسي ميٽر),
						'one' => q({0} ڊيسي ميٽر),
						'other' => q({0} ڊيسي ميٽر),
					},
					'degree' => {
						'name' => q(ڊگريز),
						'one' => q({0} ڊگريز),
						'other' => q({0} ڊگريز),
					},
					'fahrenheit' => {
						'name' => q(ڊگريز فارن هائيٽ),
						'one' => q({0} ڊگريز فارن هائيٽ),
						'other' => q({0} ڊگريز فارن هائيٽ),
					},
					'fluid-ounce' => {
						'name' => q(پاڻياٺ اونس),
						'one' => q({0} پاڻياٺ اونس),
						'other' => q({0} پاڻياٺ اونس),
					},
					'foodcalorie' => {
						'name' => q(ڪيلوريز),
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوريز),
					},
					'foot' => {
						'name' => q(فوٽ),
						'one' => q({0} فوٽ),
						'other' => q({0} فوٽ),
						'per' => q({0} في فوٽ),
					},
					'g-force' => {
						'name' => q(ڪشش ثقل),
						'one' => q({0} ڪشش ثقل),
						'other' => q({0} ڪشش ثقل),
					},
					'gallon' => {
						'name' => q(گيلن),
						'one' => q({0} گيلن),
						'other' => q({0} گيلن),
						'per' => q({0} في گيلن),
					},
					'gallon-imperial' => {
						'name' => q(امپيريل گيلن),
						'one' => q({0} امپيريل گيلن),
						'other' => q({0} امپيريل گيلن),
						'per' => q({0} في امپيريل گيلن),
					},
					'generic' => {
						'name' => q(ڊگري),
						'one' => q({0} ڊگري),
						'other' => q({0} ڊگري),
					},
					'gigabit' => {
						'name' => q(گيگا بٽز),
						'one' => q({0} گيگا بٽز),
						'other' => q({0} گيگا بٽز),
					},
					'gigabyte' => {
						'name' => q(گيگا بائيٽز),
						'one' => q({0} گيگا بائيٽز),
						'other' => q({0} گيگا بائيٽز),
					},
					'gigahertz' => {
						'name' => q(گيگا هرٽز),
						'one' => q({0} گيگا هرٽز),
						'other' => q({0} گيگا هرٽز),
					},
					'gigawatt' => {
						'name' => q(گيگا واٽ),
						'one' => q({0} گيگا واٽ),
						'other' => q({0} گيگا واٽز),
					},
					'gram' => {
						'name' => q(گرامَ),
						'one' => q({0} گرام),
						'other' => q({0} گرامَ),
						'per' => q({0} في گرام),
					},
					'hectare' => {
						'name' => q(هيڪٽر),
						'one' => q({0} هيڪٽر),
						'other' => q({0} هيڪٽر),
					},
					'hectoliter' => {
						'name' => q(هيڪٽو ليٽر),
						'one' => q({0} هيڪٽو ليٽر),
						'other' => q({0} هيڪٽو ليٽر),
					},
					'hectopascal' => {
						'name' => q(هيڪٽوپاسڪلز),
						'one' => q({0} هيڪٽوپاسڪلز),
						'other' => q({0} هيڪٽوپاسڪلز),
					},
					'hertz' => {
						'name' => q(هرٽز),
						'one' => q({0} هرٽز),
						'other' => q({0} هرٽز),
					},
					'horsepower' => {
						'name' => q(هارس پاور),
						'one' => q({0} هارس پاور),
						'other' => q({0} هارس پاور),
					},
					'hour' => {
						'name' => q(ڪلاڪ),
						'one' => q({0} ڪلاڪ),
						'other' => q({0} ڪلاڪ),
						'per' => q({0} في ڪلاڪ),
					},
					'inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} في انچ),
					},
					'inch-hg' => {
						'name' => q(مرڪري جا انچز),
						'one' => q(مرڪري جا {0} انچز),
						'other' => q(مرڪري جا {0} انچز),
					},
					'joule' => {
						'name' => q(جول),
						'one' => q({0} جول),
						'other' => q({0} جولز),
					},
					'karat' => {
						'name' => q(قيراط),
						'one' => q({0} قيراط),
						'other' => q({0} قيراط),
					},
					'kelvin' => {
						'name' => q(ڪيلونز),
						'one' => q({0} ڪيلونز),
						'other' => q({0} ڪيلونز),
					},
					'kilobit' => {
						'name' => q(ڪلو بٽز),
						'one' => q({0} ڪلو بٽز),
						'other' => q({0} ڪلو بٽز),
					},
					'kilobyte' => {
						'name' => q(ڪلو بائيٽز),
						'one' => q({0} ڪلو بائيٽز),
						'other' => q({0} ڪلو بائيٽز),
					},
					'kilocalorie' => {
						'name' => q(ڪلو ڪيلوريز),
						'one' => q({0} ڪلو ڪيلوريز),
						'other' => q({0} ڪلو ڪيلوريز),
					},
					'kilogram' => {
						'name' => q(ڪلوگرامَ),
						'one' => q({0} ڪلوگرام),
						'other' => q({0}ڪلوگرامَ),
						'per' => q({0} في ڪلوگرام),
					},
					'kilohertz' => {
						'name' => q(ڪلو هرٽز),
						'one' => q({0} ڪلو هرٽز),
						'other' => q({0} ڪلو هرٽز),
					},
					'kilojoule' => {
						'name' => q(ڪلو جولز),
						'one' => q({0} ڪلو جول),
						'other' => q({0} ڪلو جولز),
					},
					'kilometer' => {
						'name' => q(ڪلوميٽر),
						'one' => q({0} ڪلوميٽر),
						'other' => q({0} ڪلوميٽر),
						'per' => q({0} في ڪلوميٽر),
					},
					'kilometer-per-hour' => {
						'name' => q(ڪلوميٽر في ڪلاڪ),
						'one' => q({0} ڪلوميٽر في ڪلاڪ),
						'other' => q({0} ڪلوميٽر في ڪلاڪ),
					},
					'kilowatt' => {
						'name' => q(ڪلو واٽز),
						'one' => q({0} ڪلو واٽ),
						'other' => q({0} ڪلو واٽز),
					},
					'kilowatt-hour' => {
						'name' => q(ڪلو واٽ في ڪلاڪ),
						'one' => q({0} ڪلو واٽ في ڪلڪ),
						'other' => q({0} ڪلو واٽ في ڪلڪ),
					},
					'knot' => {
						'name' => q(ناٽ),
						'one' => q({0} ناٽ),
						'other' => q({0} ناٽ),
					},
					'light-year' => {
						'name' => q(لائيٽ ايئرس),
						'one' => q({0} لائيٽ ايئرس),
						'other' => q({0} لائيٽ ايئرس),
					},
					'liter' => {
						'name' => q(ليٽر),
						'one' => q({0} ليٽر),
						'other' => q({0} ليٽر),
						'per' => q({0} في ليٽر),
					},
					'liter-per-100kilometers' => {
						'name' => q(ليٽرز في 100 ڪلو ميٽر),
						'one' => q({0} L/100km),
						'other' => q({0} ليٽرز في 100 ڪلو ميٽر),
					},
					'liter-per-kilometer' => {
						'name' => q(ليٽرز في ڪلو ميٽر),
						'one' => q({0} ليٽرز في ڪلو ميٽر),
						'other' => q({0} ليٽرز في ڪلو ميٽر),
					},
					'lux' => {
						'name' => q(لڪس),
						'one' => q({0} لڪس),
						'other' => q({0} لڪس),
					},
					'megabit' => {
						'name' => q(ميگا بٽز),
						'one' => q({0} ميگا بٽز),
						'other' => q({0} ميگا بٽز),
					},
					'megabyte' => {
						'name' => q(ميگا بائيٽز),
						'one' => q({0} ميگا بائيٽز),
						'other' => q({0} ميگا بائيٽز),
					},
					'megahertz' => {
						'name' => q(ميگا هرٽز),
						'one' => q({0} ميگا هرٽز),
						'other' => q({0} ميگا هرٽز),
					},
					'megaliter' => {
						'name' => q(ميگا ليٽر),
						'one' => q({0} ميگا ليٽر),
						'other' => q({0} ميگا ليٽر),
					},
					'megawatt' => {
						'name' => q(ميگا واٽز),
						'one' => q({0} ميگا واٽ),
						'other' => q({0} ميگا واٽز),
					},
					'meter' => {
						'name' => q(ميٽر),
						'one' => q({0} ميٽر),
						'other' => q({0} ميٽر),
						'per' => q({0} في ميٽر),
					},
					'meter-per-second' => {
						'name' => q(ميٽر في سيڪنڊ),
						'one' => q({0} ميٽر في سيڪنڊ),
						'other' => q({0} ميٽر في سيڪنڊ),
					},
					'meter-per-second-squared' => {
						'name' => q(ميٽر في سيڪنڊ اسڪوائر),
						'one' => q({0} m/s²),
						'other' => q({0} ميٽر في سيڪنڊ اسڪوائر),
					},
					'metric-ton' => {
						'name' => q(ميٽرڪ ٽَنَ),
						'one' => q({0} ميٽرڪ ٽَنُ),
						'other' => q({0} ميٽرڪ ٽَنَ),
					},
					'microgram' => {
						'name' => q(مائڪروگرامَ),
						'one' => q({0} مائڪروگرام),
						'other' => q({0} مائڪرو گرام),
					},
					'micrometer' => {
						'name' => q(مائڪرو ميٽر),
						'one' => q({0} مائڪرو ميٽر),
						'other' => q({0} مائڪرو ميٽر),
					},
					'microsecond' => {
						'name' => q(مائڪرو سيڪنڊ),
						'one' => q({0} مائڪرو سيڪنڊ),
						'other' => q({0} مائڪرو سيڪنڊ),
					},
					'mile' => {
						'name' => q(ميل),
						'one' => q({0} ميل),
						'other' => q({0} ميل),
					},
					'mile-per-gallon' => {
						'name' => q(ميل في گيلن),
						'one' => q({0} ميل في گيلن),
						'other' => q({0} ميل في گيلن),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(ميل في امپيريل گيلن),
						'one' => q({0} ميل في امپيريل گيلن),
						'other' => q({0} ميل في امپيريل گيلن),
					},
					'mile-per-hour' => {
						'name' => q(ميل في ڪلاڪ),
						'one' => q({0} ميل في ڪلاڪ),
						'other' => q({0} ميل في ڪلاڪ),
					},
					'mile-scandinavian' => {
						'name' => q(اسڪینڊي نیویائي ميل),
						'one' => q({0} اسڪینڊي نیویائي ميل),
						'other' => q({0} اسڪینڊي نیویائي ميل),
					},
					'milliampere' => {
						'name' => q(ملي ايمپئير),
						'one' => q({0} ملي ايمپئير),
						'other' => q({0} ملي ايمپئير),
					},
					'millibar' => {
						'name' => q(ملي بارز),
						'one' => q({0} ملي بارز),
						'other' => q({0} ملي بارز),
					},
					'milligram' => {
						'name' => q(ملي گرامَ),
						'one' => q({0} ملي گرام),
						'other' => q({0} ملي گرامَ),
					},
					'milligram-per-deciliter' => {
						'name' => q(ملي گرامز في ڊيسي ليٽر),
						'one' => q({0} mg/dL),
						'other' => q({0} ملي گرامز في ڊيسي ليٽر),
					},
					'milliliter' => {
						'name' => q(ملي ليٽر),
						'one' => q({0} ملي ليٽر),
						'other' => q({0} ملي ليٽر),
					},
					'millimeter' => {
						'name' => q(ملي ميٽر),
						'one' => q({0} ملي ميٽر),
						'other' => q({0} ملي ميٽر),
					},
					'millimeter-of-mercury' => {
						'name' => q(مرڪري جو ملي ميٽر),
						'one' => q(مرڪري جو {0} ملي ميٽر),
						'other' => q(مرڪري جو {0} ملي ميٽر),
					},
					'millimole-per-liter' => {
						'name' => q(ملي مولز في ليٽر),
						'one' => q({0} ملي مولز في ليٽر),
						'other' => q({0} ملي مولز في ليٽر),
					},
					'millisecond' => {
						'name' => q(ملي سيڪنڊ),
						'one' => q({0} ملي سيڪنڊ),
						'other' => q({0} ملي سيڪنڊ),
					},
					'milliwatt' => {
						'name' => q(ملي واٽز),
						'one' => q({0} ملي واٽ),
						'other' => q({0} ملي واٽز),
					},
					'minute' => {
						'name' => q(منٽ),
						'one' => q({0} منٽ),
						'other' => q({0} منٽ),
						'per' => q({0} في منٽ),
					},
					'month' => {
						'name' => q(مهينا),
						'one' => q({0} مهينا),
						'other' => q({0} مهينا),
						'per' => q({0} في مهيني),
					},
					'nanometer' => {
						'name' => q(نينو ميٽر),
						'one' => q({0} نينو ميٽر),
						'other' => q({0} نينو ميٽر),
					},
					'nanosecond' => {
						'name' => q(نينو سيڪنڊ),
						'one' => q({0} نينو سيڪنڊ),
						'other' => q({0} نينو سيڪنڊ),
					},
					'nautical-mile' => {
						'name' => q(سمندري ميل),
						'one' => q({0} سمندري ميل),
						'other' => q({0} سمندري ميل),
					},
					'ohm' => {
						'name' => q(اوهمس),
						'one' => q({0} اوهم),
						'other' => q({0} اوهمس),
					},
					'ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} في اونس),
					},
					'ounce-troy' => {
						'name' => q(ٽرائي اونس),
						'one' => q({0} ٽرائي اونس),
						'other' => q({0} ٽرائي اونس),
					},
					'parsec' => {
						'name' => q(پارسيڪ),
						'one' => q({0} pc),
						'other' => q({0} پارسيڪ),
					},
					'part-per-million' => {
						'name' => q(حصا في ملين),
						'one' => q({0} حصا في ملين),
						'other' => q({0} حصا في ملين),
					},
					'per' => {
						'1' => q(في {1} تي {0}),
					},
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'permille' => {
						'name' => q(‰),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'name' => q(پيرا بائيٽس),
						'one' => q({0} پيرا بائيٽس),
						'other' => q({0} پيرا بائيٽس),
					},
					'picometer' => {
						'name' => q(پيڪو ميٽر),
						'one' => q({0} پيڪو ميٽر),
						'other' => q({0} پيڪو ميٽر),
					},
					'pint' => {
						'name' => q(پنٽ),
						'one' => q({0} پنٽ),
						'other' => q({0} پنٽ),
					},
					'pint-metric' => {
						'name' => q(ميٽرڪ پنٽ),
						'one' => q({0} ميٽرڪ پنٽ),
						'other' => q({0} ميٽرڪ پنٽ),
					},
					'point' => {
						'name' => q(پوائينٽون),
						'one' => q({0} پوائينٽون),
						'other' => q({0} پوائينٽون),
					},
					'pound' => {
						'name' => q(پائونڊ),
						'one' => q({0} پائونڊ),
						'other' => q({0} پائونڊ),
						'per' => q({0} في پائونڊ),
					},
					'pound-per-square-inch' => {
						'name' => q(پائونڊز في اسڪوائر انچ),
						'one' => q({0} psi),
						'other' => q({0} پائونڊز في اسڪوائر انچ),
					},
					'quart' => {
						'name' => q(چوٿائي گيلن),
						'one' => q({0} چوٿائي گيلن),
						'other' => q({0} چوٿائي گيلن),
					},
					'radian' => {
						'name' => q(ريڊيئنز),
						'one' => q({0} ريڊيئنز),
						'other' => q({0} ريڊيئنز),
					},
					'revolution' => {
						'name' => q(گردش),
						'one' => q({0} گردشون),
						'other' => q({0} گردشون),
					},
					'second' => {
						'name' => q(سيڪنڊ),
						'one' => q({0} في سيڪنڊ),
						'other' => q({0} سيڪنڊ),
						'per' => q({0} في سيڪنڊ),
					},
					'square-centimeter' => {
						'name' => q(اسڪوائر سينٽي ميٽر),
						'one' => q({0} اسڪوائر سينٽي ميٽر),
						'other' => q({0} اسڪوائر سينٽي ميٽر),
						'per' => q({0} في اسڪوائر سينٽي ميٽر),
					},
					'square-foot' => {
						'name' => q(اسڪوائر فٽ),
						'one' => q({0} اسڪوائر فٽ),
						'other' => q({0} اسڪوائر فٽ),
					},
					'square-inch' => {
						'name' => q(اسڪوائر انچ),
						'one' => q({0} اسڪوائر انچ),
						'other' => q({0} اسڪوائر انچ),
						'per' => q({0} في اسڪوائر انچ),
					},
					'square-kilometer' => {
						'name' => q(اسڪوائر ڪلوميٽر),
						'one' => q({0} اسڪوائر ڪلوميٽر),
						'other' => q({0} اسڪوائر ڪلوميٽر),
						'per' => q({0} في اسڪوائر ڪلوميٽر),
					},
					'square-meter' => {
						'name' => q(اسڪوائر ميٽر),
						'one' => q({0} اسڪوائر ميٽر),
						'other' => q({0} اسڪوائر ميٽر),
						'per' => q({0} في اسڪوائر ميٽر),
					},
					'square-mile' => {
						'name' => q(اسڪوائر ميل),
						'one' => q({0} اسڪوائر ميل),
						'other' => q({0} اسڪوائر ميل),
						'per' => q({0} في اسڪوائر ميل),
					},
					'square-yard' => {
						'name' => q(اسڪوائر يارڊ),
						'one' => q({0} ااسڪوائر يارڊ),
						'other' => q({0} ااسڪوائر يارڊ),
					},
					'tablespoon' => {
						'name' => q(کاڌي جا چمچا),
						'one' => q({0} کاڌي جا چمچا),
						'other' => q({0} کاڌي جا چمچا),
					},
					'teaspoon' => {
						'name' => q(چانهن جا چمچا),
						'one' => q({0} چانهن جا چمچا),
						'other' => q({0} چانهن جا چمچا),
					},
					'terabit' => {
						'name' => q(ٽيرا بٽز),
						'one' => q({0} ٽيرا بٽز),
						'other' => q({0} ٽيرا بٽز),
					},
					'terabyte' => {
						'name' => q(ٽيرا بائيٽز),
						'one' => q({0} ٽيرا بائيٽز),
						'other' => q({0} ٽيرا بائيٽز),
					},
					'ton' => {
						'name' => q(ٽن),
						'one' => q({0} ٽن),
						'other' => q({0} ٽن),
					},
					'volt' => {
						'name' => q(وولٽز),
						'one' => q({0} وولٽ),
						'other' => q({0} وولٽز),
					},
					'watt' => {
						'name' => q(واٽز),
						'one' => q({0} واٽ),
						'other' => q({0} واٽز),
					},
					'week' => {
						'name' => q(هفتا),
						'one' => q({0} هفتا),
						'other' => q({0} هفتا),
						'per' => q({0} في هفتي),
					},
					'yard' => {
						'name' => q(گز),
						'one' => q({0} گز),
						'other' => q({0} گز),
					},
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0} في سال),
					},
				},
				'narrow' => {
					'' => {
						'name' => q(ڊائريڪشن),
					},
					'celsius' => {
						'name' => q(ڊگري سيلسيس),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'name' => q(سينٽي ميٽر),
						'one' => q({0} cm),
						'other' => q({0} cm),
					},
					'coordinate' => {
						'east' => q({0} اوڀر),
						'north' => q({0} اتر),
						'south' => q({0} ڏکڻ),
						'west' => q({0} اولهه),
					},
					'day' => {
						'name' => q(ڏينهن),
						'one' => q({0} ڏينهن),
						'other' => q({0} ڏينهن),
					},
					'gram' => {
						'name' => q(گرام),
						'one' => q({0}گـ.),
						'other' => q({0}گـ.),
						'per' => q({0}/گـ.),
					},
					'hour' => {
						'name' => q(ڪلاڪ),
						'one' => q({0} ڪلاڪ),
						'other' => q({0} ڪلاڪ),
					},
					'kilogram' => {
						'name' => q(ڪ.گـ.),
						'one' => q({0}ڪ.گـ.),
						'other' => q({0}ڪ.گـ.),
						'per' => q({0}/ڪ.گـ.),
					},
					'kilometer' => {
						'name' => q(ڪلوميٽر),
						'one' => q({0} ڪلوميٽر),
						'other' => q({0} ڪلوميٽر),
					},
					'kilometer-per-hour' => {
						'name' => q(ڪلوميٽر في ڪلاڪ),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'liter' => {
						'name' => q(ليٽر),
						'one' => q({0} ليٽر),
						'other' => q({0} ليٽر),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'meter' => {
						'name' => q(ميٽر),
						'one' => q({0} ميٽر),
						'other' => q({0} ميٽر),
					},
					'metric-ton' => {
						'name' => q(ٽَـ),
						'one' => q({0}ٽَـ),
						'other' => q({0}ٽَـ),
					},
					'milligram' => {
						'name' => q(مـ.گـ.),
						'one' => q({0}مـ.گـ.),
						'other' => q({0}مـ.گـ.),
					},
					'millimeter' => {
						'name' => q(ملي ميٽر),
						'one' => q({0} ملي ميٽر),
						'other' => q({0} ملي ميٽر),
					},
					'millisecond' => {
						'name' => q(ملي سيڪنڊ),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'name' => q(منٽ),
						'one' => q({0} منٽ),
						'other' => q({0} منٽ),
					},
					'month' => {
						'name' => q(مهينو),
						'one' => q({0} مهينا),
						'other' => q({0} مهينا),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'second' => {
						'name' => q(سيڪنڊ),
						'one' => q({0} s),
						'other' => q({0} سيڪنڊ),
					},
					'week' => {
						'name' => q(هفتو),
						'one' => q({0} هفتا),
						'other' => q({0} هفتي),
					},
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
					},
				},
				'short' => {
					'' => {
						'name' => q(ڊائريڪشن),
					},
					'acre' => {
						'name' => q(ايڪڙ),
						'one' => q({0} ايڪڙ),
						'other' => q({0} ايڪڙ),
					},
					'acre-foot' => {
						'name' => q(ايڪڙ فٽ),
						'one' => q({0} ايڪڙ فٽ),
						'other' => q({0} ايڪڙ فٽ),
					},
					'ampere' => {
						'name' => q(ایمپئیر),
						'one' => q({0} ایمپئیر),
						'other' => q({0} ایمپئیر),
					},
					'arc-minute' => {
						'name' => q(آرڪ منٽز),
						'one' => q({0} آرڪ منٽز),
						'other' => q({0} آرڪ منٽز),
					},
					'arc-second' => {
						'name' => q(آرڪ سيڪنڊز),
						'one' => q({0} آرڪ سيڪنڊز),
						'other' => q({0} آرڪ سيڪنڊز),
					},
					'astronomical-unit' => {
						'name' => q(فلڪيات جا يونٽ),
						'one' => q({0} فلڪيات جا يونٽ),
						'other' => q({0} فلڪيات جا يونٽ),
					},
					'atmosphere' => {
						'name' => q(ايٽماس فيئر),
						'one' => q({0} ايٽماس فيئر),
						'other' => q({0} ايٽماس فيئر),
					},
					'bit' => {
						'name' => q(بٽ),
						'one' => q({0} بٽ),
						'other' => q({0} بٽ),
					},
					'byte' => {
						'name' => q(بائيٽ),
						'one' => q({0} بائيٽ),
						'other' => q({0} بائيٽ),
					},
					'calorie' => {
						'name' => q(ڪيلوري),
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوري),
					},
					'carat' => {
						'name' => q(ڪيرٽ),
						'one' => q({0} ڪيرٽ),
						'other' => q({0} ڪيرٽ),
					},
					'celsius' => {
						'name' => q(ڊگري سيلسيس),
						'one' => q({0} ڊگري سيلسيس),
						'other' => q({0} ڊگري سيلسيس),
					},
					'centiliter' => {
						'name' => q(سينٽي ليٽر),
						'one' => q({0} سينٽي ليٽر),
						'other' => q({0} سينٽي ليٽر),
					},
					'centimeter' => {
						'name' => q(سينٽي ميٽر),
						'one' => q({0} سينٽي ميٽر),
						'other' => q({0} سينٽي ميٽر),
						'per' => q({0} في سينٽي ميٽر),
					},
					'century' => {
						'name' => q(c),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					'coordinate' => {
						'east' => q({0} اوڀر),
						'north' => q({0} اتر),
						'south' => q({0} ڏکڻ),
						'west' => q({0} اولهه),
					},
					'cubic-centimeter' => {
						'name' => q(ڪيوبڪ سينٽي ميٽر),
						'one' => q({0} ڪيوبڪ سينٽي ميٽر),
						'other' => q({0} ڪيوبڪ سينٽي ميٽر),
						'per' => q({0} في ڪيوبڪ سينٽي ميٽر),
					},
					'cubic-foot' => {
						'name' => q(ڪيوبڪ فٽ),
						'one' => q({0} ڪيوبڪ فٽ),
						'other' => q({0} ڪيوبڪ فٽ),
					},
					'cubic-inch' => {
						'name' => q(ڪيوبڪ انچ),
						'one' => q({0} ڪيوبڪ انچ),
						'other' => q({0} ڪيوبڪ انچ),
					},
					'cubic-kilometer' => {
						'name' => q(ڪيوبڪ ڪلوميٽر),
						'one' => q({0} ڪيوبڪ ڪلوميٽر),
						'other' => q({0} ڪيوبڪ ڪلوميٽر),
					},
					'cubic-meter' => {
						'name' => q(ڪيوبڪ ميٽر),
						'one' => q({0} ڪيوبڪ ميٽر),
						'other' => q({0} ڪيوبڪ ميٽر),
						'per' => q({0} في ڪيوبڪ ميٽر),
					},
					'cubic-mile' => {
						'name' => q(ڪيوبڪ ميل),
						'one' => q({0} ڪيوبڪ ميل),
						'other' => q({0} ڪيوبڪ ميل),
					},
					'cubic-yard' => {
						'name' => q(ڪيوبڪ يارڊ),
						'one' => q({0} ڪيوبڪ يارڊ),
						'other' => q({0} ڪيوبڪ يارڊ),
					},
					'cup' => {
						'name' => q(ڪپ ماپو),
						'one' => q({0} ڪپ ماپو),
						'other' => q({0} ڪپ ماپو),
					},
					'cup-metric' => {
						'name' => q(ميٽرڪ ڪپ),
						'one' => q({0} ميٽرڪ ڪپ),
						'other' => q({0} ميٽرڪ ڪپ),
					},
					'day' => {
						'name' => q(ڏينهن),
						'one' => q({0} ڏينهن),
						'other' => q({0} ڏينهن),
						'per' => q({0} في ڏينهن),
					},
					'deciliter' => {
						'name' => q(ڊيسي ليٽر),
						'one' => q({0} ڊيسي ليٽر),
						'other' => q({0} ڊيسي ليٽر),
					},
					'decimeter' => {
						'name' => q(ڊيسي ميٽر),
						'one' => q({0} ڊيسي ميٽر),
						'other' => q({0} ڊيسي ميٽر),
					},
					'degree' => {
						'name' => q(ڊگري),
						'one' => q({0} ڊگريز),
						'other' => q({0} ڊگريز),
					},
					'fahrenheit' => {
						'name' => q(ڊگريز فارن هائيٽ),
						'one' => q({0} ڊگريز فارن هائيٽ),
						'other' => q({0} ڊگريز فارن هائيٽ),
					},
					'fluid-ounce' => {
						'name' => q(پاڻياٺ اونس),
						'one' => q({0} پاڻياٺ اونس),
						'other' => q({0} پاڻياٺ اونس),
					},
					'foodcalorie' => {
						'name' => q(ڪيلوري),
						'one' => q({0} ڪيلوري),
						'other' => q({0} ڪيلوري),
					},
					'foot' => {
						'name' => q(فوٽ),
						'one' => q({0} فوٽ),
						'other' => q({0} فوٽ),
						'per' => q({0} في فوٽ),
					},
					'g-force' => {
						'name' => q(ڪشش ثقل),
						'one' => q({0} ڪشش ثقل),
						'other' => q({0} ڪشش ثقل),
					},
					'gallon' => {
						'name' => q(گيلن),
						'one' => q({0} گيلن),
						'other' => q({0} گيلن),
						'per' => q({0} في گيلن),
					},
					'gallon-imperial' => {
						'name' => q(امپيريل گيلن),
						'one' => q({0} امپيريل گيلن),
						'other' => q({0} امپيريل گيلن),
						'per' => q({0} في امپيريل گيلن),
					},
					'generic' => {
						'name' => q(ڊگري),
						'one' => q({0} ڊگري),
						'other' => q({0} ڊگري),
					},
					'gigabit' => {
						'name' => q(گيگا بٽ),
						'one' => q({0} گيگا بٽز),
						'other' => q({0} گيگا بٽز),
					},
					'gigabyte' => {
						'name' => q(گيگا بائيٽ),
						'one' => q({0} گيگا بائيٽز),
						'other' => q({0} گيگا بائيٽز),
					},
					'gigahertz' => {
						'name' => q(گيگا هرٽز),
						'one' => q({0} گيگا هرٽز),
						'other' => q({0} گيگا هرٽز),
					},
					'gigawatt' => {
						'name' => q(گيگا واٽ),
						'one' => q({0} گيگا واٽ),
						'other' => q({0} گيگا واٽ),
					},
					'gram' => {
						'name' => q(گرامَ),
						'one' => q({0} گـ),
						'other' => q({0} گـ.),
						'per' => q({0}/گـ.),
					},
					'hectare' => {
						'name' => q(هيڪٽر),
						'one' => q({0} هيڪٽر),
						'other' => q({0} هيڪٽر),
					},
					'hectoliter' => {
						'name' => q(هيڪٽو ليٽر),
						'one' => q({0} هيڪٽو ليٽر),
						'other' => q({0} هيڪٽو ليٽر),
					},
					'hectopascal' => {
						'name' => q(هيڪٽوپاسڪلز),
						'one' => q({0} هيڪٽوپاسڪلز),
						'other' => q({0} هيڪٽوپاسڪلز),
					},
					'hertz' => {
						'name' => q(هرٽز),
						'one' => q({0} هرٽز),
						'other' => q({0} هرٽز),
					},
					'horsepower' => {
						'name' => q(هارس پاور),
						'one' => q({0} هارس پاور),
						'other' => q({0} هارس پاور),
					},
					'hour' => {
						'name' => q(ڪلاڪ),
						'one' => q({0} ڪلاڪ),
						'other' => q({0} ڪلاڪ),
						'per' => q({0} في ڪلاڪ),
					},
					'inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} في انچ),
					},
					'inch-hg' => {
						'name' => q(مرڪري جا انچز),
						'one' => q(مرڪري جا {0} انچز),
						'other' => q(مرڪري جا {0} انچز),
					},
					'joule' => {
						'name' => q(جول),
						'one' => q({0} جول),
						'other' => q({0} جول),
					},
					'karat' => {
						'name' => q(قيراط),
						'one' => q({0} قيراط),
						'other' => q({0} قيراط),
					},
					'kelvin' => {
						'name' => q(ڪيلونز),
						'one' => q({0} ڪيلونز),
						'other' => q({0} ڪيلونز),
					},
					'kilobit' => {
						'name' => q(ڪلو بٽ),
						'one' => q({0} ڪلو بٽز),
						'other' => q({0} ڪلو بٽز),
					},
					'kilobyte' => {
						'name' => q(ڪلو بائيٽ),
						'one' => q({0} ڪلو بائيٽز),
						'other' => q({0} ڪلو بائيٽز),
					},
					'kilocalorie' => {
						'name' => q(ڪلو ڪيلوريز),
						'one' => q({0} ڪلو ڪيلوريز),
						'other' => q({0} ڪلو ڪيلوريز),
					},
					'kilogram' => {
						'name' => q(ڪلو گرام),
						'one' => q({0} ڪلو گرام),
						'other' => q({0} ڪ.گـ.),
						'per' => q({0}/ڪ.گـ.),
					},
					'kilohertz' => {
						'name' => q(ڪلو هرٽز),
						'one' => q({0} ڪلو هرٽز),
						'other' => q({0} ڪلو هرٽز),
					},
					'kilojoule' => {
						'name' => q(ڪلو جول),
						'one' => q({0} ڪلو جول),
						'other' => q({0} ڪلو جول),
					},
					'kilometer' => {
						'name' => q(ڪلوميٽر),
						'one' => q({0} ڪلوميٽر),
						'other' => q({0} ڪلوميٽر),
						'per' => q({0} في ڪلوميٽر),
					},
					'kilometer-per-hour' => {
						'name' => q(ڪلوميٽر في ڪلاڪ),
						'one' => q({0} ڪلوميٽر في ڪلاڪ),
						'other' => q({0} ڪلوميٽر في ڪلاڪ),
					},
					'kilowatt' => {
						'name' => q(ڪلو واٽ),
						'one' => q({0} ڪلو واٽ),
						'other' => q({0} ڪلو واٽ),
					},
					'kilowatt-hour' => {
						'name' => q(ڪلو واٽ في ڪلاڪ),
						'one' => q({0} ڪلو واٽ في ڪلڪ),
						'other' => q({0} ڪلو واٽ في ڪلڪ),
					},
					'knot' => {
						'name' => q(ناٽ),
						'one' => q({0} ناٽ),
						'other' => q({0} ناٽ),
					},
					'light-year' => {
						'name' => q(لائيٽ ايئرس),
						'one' => q({0} لائيٽ ايئرس),
						'other' => q({0} لائيٽ ايئرس),
					},
					'liter' => {
						'name' => q(ليٽر),
						'one' => q({0} ليٽر),
						'other' => q({0} ليٽر),
						'per' => q({0} في ليٽر),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'name' => q(ليٽرز في ڪلو ميٽر),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					'lux' => {
						'name' => q(لڪس),
						'one' => q({0} لڪس),
						'other' => q({0} لڪس),
					},
					'megabit' => {
						'name' => q(ميگا بٽ),
						'one' => q({0} ميگا بٽز),
						'other' => q({0} ميگا بٽز),
					},
					'megabyte' => {
						'name' => q(ميگا بائيٽ),
						'one' => q({0} ميگا بائيٽز),
						'other' => q({0} ميگا بائيٽز),
					},
					'megahertz' => {
						'name' => q(ميگا هرٽز),
						'one' => q({0} ميگا هرٽز),
						'other' => q({0} ميگا هرٽز),
					},
					'megaliter' => {
						'name' => q(ميگا ليٽر),
						'one' => q({0} ميگا ليٽر),
						'other' => q({0} ميگا ليٽر),
					},
					'megawatt' => {
						'name' => q(ميگا واٽ),
						'one' => q({0} ميگا واٽ),
						'other' => q({0} ميگا واٽ),
					},
					'meter' => {
						'name' => q(ميٽر),
						'one' => q({0} ميٽر),
						'other' => q({0} ميٽر),
						'per' => q({0} في ميٽر),
					},
					'meter-per-second' => {
						'name' => q(ميٽر في سيڪنڊ),
						'one' => q({0} ميٽر في سيڪنڊ),
						'other' => q({0} ميٽر في سيڪنڊ),
					},
					'meter-per-second-squared' => {
						'name' => q(ميٽر في سيڪنڊ اسڪوائر),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'name' => q(ٽَـ),
						'one' => q({0} ٽَـ),
						'other' => q({0} ٽَـ),
					},
					'microgram' => {
						'name' => q(مائڪرو گرام),
						'one' => q({0} مائڪرو گرام),
						'other' => q({0} مائڪرو گرام),
					},
					'micrometer' => {
						'name' => q(مائڪرو ميٽر),
						'one' => q({0} مائڪرو ميٽر),
						'other' => q({0} مائڪرو ميٽر),
					},
					'microsecond' => {
						'name' => q(مائڪرو سيڪنڊ),
						'one' => q({0} مائڪرو سيڪنڊ),
						'other' => q({0} مائڪرو سيڪنڊ),
					},
					'mile' => {
						'name' => q(ميل),
						'one' => q({0} ميل),
						'other' => q({0} ميل),
					},
					'mile-per-gallon' => {
						'name' => q(ميل في گيلن),
						'one' => q({0} ميل في گيلن),
						'other' => q({0} ميل في گيلن),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(ميل في امپيريل گيلن),
						'one' => q({0} ميل في امپيريل گيلن),
						'other' => q({0} ميل في امپيريل گيلن),
					},
					'mile-per-hour' => {
						'name' => q(ميل في ڪلاڪ),
						'one' => q({0} ميل في ڪلاڪ),
						'other' => q({0} ميل في ڪلاڪ),
					},
					'mile-scandinavian' => {
						'name' => q(اسڪینڊي نیویائي ميل),
						'one' => q({0} اسڪینڊي نیویائي ميل),
						'other' => q({0} اسڪینڊي نیویائي ميل),
					},
					'milliampere' => {
						'name' => q(ملي ايمپئير),
						'one' => q({0} ملي ايمپئير),
						'other' => q({0} ملي ايمپئير),
					},
					'millibar' => {
						'name' => q(ملي بارز),
						'one' => q({0} ملي بارز),
						'other' => q({0} ملي بارز),
					},
					'milligram' => {
						'name' => q(مـ.گـ.),
						'one' => q({0} مـ.گـ.),
						'other' => q({0} مـ.گـ.),
					},
					'milligram-per-deciliter' => {
						'name' => q(ملي گرامز في ڊيسي ليٽر),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					'milliliter' => {
						'name' => q(ملي ليٽر),
						'one' => q({0} ملي ليٽر),
						'other' => q({0} ملي ليٽر),
					},
					'millimeter' => {
						'name' => q(ملي ميٽر),
						'one' => q({0} ملي ميٽر),
						'other' => q({0} ملي ميٽر),
					},
					'millimeter-of-mercury' => {
						'name' => q(مرڪري جو ملي ميٽر),
						'one' => q(مرڪري جو {0} ملي ميٽر),
						'other' => q(مرڪري جو {0} ملي ميٽر),
					},
					'millimole-per-liter' => {
						'name' => q(ملي مولز في ليٽر),
						'one' => q({0} ملي مولز في ليٽر),
						'other' => q({0} ملي مولز في ليٽر),
					},
					'millisecond' => {
						'name' => q(ملي سيڪنڊ),
						'one' => q({0} ملي سيڪنڊ),
						'other' => q({0} ملي سيڪنڊ),
					},
					'milliwatt' => {
						'name' => q(ملي واٽ),
						'one' => q({0} ملي واٽ),
						'other' => q({0} ملي واٽ),
					},
					'minute' => {
						'name' => q(منٽ),
						'one' => q({0} منٽ),
						'other' => q({0} منٽ),
						'per' => q({0} في منٽ),
					},
					'month' => {
						'name' => q(مهينا),
						'one' => q({0} مهينا),
						'other' => q({0} مهينا),
						'per' => q({0} في مهيني),
					},
					'nanometer' => {
						'name' => q(نينو ميٽر),
						'one' => q({0} نينو ميٽر),
						'other' => q({0} نينو ميٽر),
					},
					'nanosecond' => {
						'name' => q(نينو سيڪنڊ),
						'one' => q({0} نينو سيڪنڊ),
						'other' => q({0} نينو سيڪنڊ),
					},
					'nautical-mile' => {
						'name' => q(سمندري ميل),
						'one' => q({0} سمندري ميل),
						'other' => q({0} سمندري ميل),
					},
					'ohm' => {
						'name' => q(اوهمس),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} في اونس),
					},
					'ounce-troy' => {
						'name' => q(ٽرائي اونس),
						'one' => q({0} ٽرائي اونس),
						'other' => q({0} ٽرائي اونس),
					},
					'parsec' => {
						'name' => q(پارسيڪ),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					'part-per-million' => {
						'name' => q(حصا في ملين),
						'one' => q({0} حصا في ملين),
						'other' => q({0} حصا في ملين),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'permille' => {
						'name' => q(‰),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'name' => q(پيرا بائيٽس),
						'one' => q({0} پيرا بائيٽس),
						'other' => q({0} پيرا بائيٽس),
					},
					'picometer' => {
						'name' => q(پيڪو ميٽر),
						'one' => q({0} پيڪو ميٽر),
						'other' => q({0} پيڪو ميٽر),
					},
					'pint' => {
						'name' => q(پنٽ),
						'one' => q({0} پنٽ),
						'other' => q({0} پنٽ),
					},
					'pint-metric' => {
						'name' => q(ميٽرڪ پنٽ),
						'one' => q({0} ميٽرڪ پنٽ),
						'other' => q({0} ميٽرڪ پنٽ),
					},
					'point' => {
						'name' => q(پوائينٽون),
						'one' => q({0} پوائينٽون),
						'other' => q({0} پوائينٽون),
					},
					'pound' => {
						'name' => q(پائونڊ),
						'one' => q({0} پائونڊ),
						'other' => q({0} پائونڊ),
						'per' => q({0} في پائونڊ),
					},
					'pound-per-square-inch' => {
						'name' => q(پائونڊز في اسڪوائر انچ),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'quart' => {
						'name' => q(چوٿائي گيلن),
						'one' => q({0} چوٿائي گيلن),
						'other' => q({0} چوٿائي گيلن),
					},
					'radian' => {
						'name' => q(ريڊيئن),
						'one' => q({0} ريڊيئنز),
						'other' => q({0} ريڊيئنز),
					},
					'revolution' => {
						'name' => q(گردش),
						'one' => q({0} گردشون),
						'other' => q({0} گردشون),
					},
					'second' => {
						'name' => q(سيڪنڊ),
						'one' => q({0} في سيڪنڊ),
						'other' => q({0} في سيڪنڊ),
						'per' => q({0} في سيڪنڊ),
					},
					'square-centimeter' => {
						'name' => q(اسڪوائر سينٽي ميٽر),
						'one' => q({0} اسڪوائر سينٽي ميٽر),
						'other' => q({0} اسڪوائر سينٽي ميٽر),
						'per' => q({0} في اسڪوائر سينٽي ميٽر),
					},
					'square-foot' => {
						'name' => q(اسڪوائر فٽ),
						'one' => q({0} اسڪوائر فٽ),
						'other' => q({0} اسڪوائر فٽ),
					},
					'square-inch' => {
						'name' => q(اسڪوائر انچ),
						'one' => q({0} اسڪوائر انچ),
						'other' => q({0} اسڪوائر انچ),
						'per' => q({0} في اسڪوائر انچ),
					},
					'square-kilometer' => {
						'name' => q(اسڪوائر ڪلوميٽر),
						'one' => q({0} اسڪوائر ڪلوميٽر),
						'other' => q({0} اسڪوائر ڪلوميٽر),
						'per' => q({0} اسڪوائر ڪلوميٽر),
					},
					'square-meter' => {
						'name' => q(اسڪوائر ميٽر),
						'one' => q({0} اسڪوائر ميٽر),
						'other' => q({0} اسڪوائر ميٽر),
						'per' => q({0} في اسڪوائر ميٽر),
					},
					'square-mile' => {
						'name' => q(اسڪوائر ميل),
						'one' => q({0} اسڪوائر ميل),
						'other' => q({0} اسڪوائر ميل),
						'per' => q({0} في اسڪوائر ميل),
					},
					'square-yard' => {
						'name' => q(اسڪوائر يارڊ),
						'one' => q({0} ااسڪوائر يارڊ),
						'other' => q({0} ااسڪوائر يارڊ),
					},
					'tablespoon' => {
						'name' => q(کاڌي جا چمچا),
						'one' => q({0} کاڌي جا چمچا),
						'other' => q({0} کاڌي جا چمچا),
					},
					'teaspoon' => {
						'name' => q(چانهن جا چمچا),
						'one' => q({0} چانهن جا چمچا),
						'other' => q({0} چانهن جا چمچا),
					},
					'terabit' => {
						'name' => q(ٽيرا بٽز),
						'one' => q({0} ٽيرا بٽز),
						'other' => q({0} ٽيرا بٽز),
					},
					'terabyte' => {
						'name' => q(ٽيرا بائيٽز),
						'one' => q({0} ٽيرا بائيٽز),
						'other' => q({0} ٽيرا بائيٽز),
					},
					'ton' => {
						'name' => q(ٽن),
						'one' => q({0} ٽن),
						'other' => q({0} ٽن),
					},
					'volt' => {
						'name' => q(وولٽ),
						'one' => q({0} وولٽ),
						'other' => q({0} وولٽ),
					},
					'watt' => {
						'name' => q(واٽز),
						'one' => q({0} واٽ),
						'other' => q({0} واٽ),
					},
					'week' => {
						'name' => q(هفتا),
						'one' => q({0} هفتا),
						'other' => q({0} هفتا),
						'per' => q({0} في هفتي),
					},
					'yard' => {
						'name' => q(گز),
						'one' => q({0} گز),
						'other' => q({0} گز),
					},
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0} في سال),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ها|ها|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نه|نه|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arab',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arab',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '000K',
					'other' => '000K',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0G',
					'other' => '0G',
				},
				'10000000000' => {
					'one' => '00G',
					'other' => '00G',
				},
				'100000000000' => {
					'one' => '000G',
					'other' => '000G',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ھزار',
					'other' => '0 ھزار',
				},
				'10000' => {
					'one' => '00 ھزار',
					'other' => '00K',
				},
				'100000' => {
					'one' => '000K',
					'other' => '000K',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0G',
					'other' => '0G',
				},
				'10000000000' => {
					'one' => '00G',
					'other' => '00G',
				},
				'100000000000' => {
					'one' => '000G',
					'other' => '000G',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '000K',
					'other' => '000K',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0G',
					'other' => '0G',
				},
				'10000000000' => {
					'one' => '00G',
					'other' => '00G',
				},
				'100000000000' => {
					'one' => '000G',
					'other' => '000G',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(گڏيل عرب امارات درهم),
				'one' => q(گڏيل عرب امارات درهم),
				'other' => q(گڏيل عرب امارات درهم),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(افغاني افغاني),
				'one' => q(افغاني افغاني),
				'other' => q(افغاني افغاني),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(الباني ليڪ),
				'one' => q(الباني ليڪ),
				'other' => q(الباني ليڪ),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(ارماني ڊرم),
				'one' => q(ارماني ڊرم),
				'other' => q(ارماني ڊرم),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(نيڌرلينڊ انٽليئن گلڊر),
				'one' => q(نيڌرلينڊ انٽليئن گلڊر),
				'other' => q(نيڌرلينڊ انٽليئن گلڊر),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(انگوليائي ڪوانزا),
				'one' => q(انگوليائي ڪوانزا),
				'other' => q(انگوليائي ڪوانزا),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(ارجنٽائن پيسو),
				'one' => q(ارجنٽائن پيسو),
				'other' => q(ارجنٽائن پيسو),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(آسٽريلوي ڊالر),
				'one' => q(آسٽريلوي ڊالر),
				'other' => q(آسٽريلوي ڊالر),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(اروبن فلورن),
				'one' => q(اروبن فلورن),
				'other' => q(اروبن فلورن),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(آذربائيجاني منت),
				'one' => q(آذربائيجاني منت),
				'other' => q(آذربائيجاني منت),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(بوسنيا هرزگوينا ڪنورٽبل مارڪ),
				'one' => q(بوسنيا هرزگوينا ڪنورٽبل مارڪ),
				'other' => q(بوسنيا هرزگوينا ڪنورٽبل مارڪ),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(باربيڊين ڊالر),
				'one' => q(باربيڊين ڊالر),
				'other' => q(باربيڊين ڊالر),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(بنگلاديشي ٽڪا),
				'one' => q(بنگلاديشي ٽڪا),
				'other' => q(بنگلاديشي ٽڪا),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(بلغارین لیو),
				'one' => q(بلغارین لیو),
				'other' => q(بلغارین لیو),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(بحريني دينار),
				'one' => q(بحريني دينار),
				'other' => q(بحريني دينار),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(برونڊي فرينڪ),
				'one' => q(برونڊي فرينڪ),
				'other' => q(برونڊي فرينڪ),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(برمودي ڊالر),
				'one' => q(برمودي ڊالر),
				'other' => q(برمودي ڊالر),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(برونائي ڊالر),
				'one' => q(برونائي ڊالر),
				'other' => q(برونائي ڊالر),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(بولیوین بولیویانو),
				'one' => q(بولیوین بولیویانو),
				'other' => q(بولیوین بولیویانو),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(برازيلي ريل),
				'one' => q(برازيلي ريل),
				'other' => q(برازيلي ريل),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(بهاماني ڊادلر),
				'one' => q(بهاماني ڊادلر),
				'other' => q(بهاماني ڊادلر),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ڀوٽاني گلٽرم),
				'one' => q(ڀوٽاني گلٽرم),
				'other' => q(ڀوٽاني گلٽرم),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(بوستواني پولا),
				'one' => q(بوستواني پولا),
				'other' => q(بوستواني پولا),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(بیلاروسی ربل),
				'one' => q(بیلاروسی ربل),
				'other' => q(بیلاروسی ربل),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(BYR),
				'one' => q(BYR),
				'other' => q(BYR),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(بيليز ڊالر),
				'one' => q(بيليز ڊالر),
				'other' => q(بيليز ڊالر),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(ڪئينڊيائي ڊالر),
				'one' => q(ڪئينڊيائي ڊالر),
				'other' => q(ڪئينڊيائي ڊالر),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(ڪانگو فرينڪ),
				'one' => q(ڪانگو فرينڪ),
				'other' => q(ڪانگو فرينڪ),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(سوئس فرينڪ),
				'one' => q(سوئس فرينڪ),
				'other' => q(سوئس فرينڪ),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(چلي پيسو),
				'one' => q(چلي پيسو),
				'other' => q(چلي پيسو),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(چيني يوآن \(غير ملڪي\)),
				'one' => q(چيني يوآن \(غير ملڪي\)),
				'other' => q(چيني يوآن \(غير ملڪي\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(چيني يوآن),
				'one' => q(چيني يوآن),
				'other' => q(چيني يوآن),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(ڪولمبيائي پيسو),
				'one' => q(ڪولمبيائي پيسو),
				'other' => q(ڪولمبيائي پيسو),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(ڪوسٽا ريڪا ڪولن),
				'one' => q(ڪوسٽا ريڪا ڪولن),
				'other' => q(ڪوسٽا ريڪا ڪولن),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(ڪيوبن ڪنورٽيبل پيسو),
				'one' => q(ڪيوبن ڪنورٽيبل پيسو),
				'other' => q(ڪيوبن ڪنورٽيبل پيسو),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(ڪيوبن پيسو),
				'one' => q(ڪيوبن پيسو),
				'other' => q(ڪيوبن پيسو),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(ڪيپ وردي ايسڪوڊو),
				'one' => q(ڪيپ وردي ايسڪوڊو),
				'other' => q(ڪيپ وردي ايسڪوڊو),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(چيڪ ڪرونا),
				'one' => q(چيڪ ڪرونا),
				'other' => q(چيڪ ڪرونا),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(جبوتي فرينڪ),
				'one' => q(جبوتي فرينڪ),
				'other' => q(جبوتي فرينڪ),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(دانش ڪرون),
				'one' => q(دانش ڪرون),
				'other' => q(دانش ڪرون),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ڊومينيڪن پيسو),
				'one' => q(ڊومينيڪن پيسو),
				'other' => q(ڊومينيڪن پيسو),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(الجيريائي دينار),
				'one' => q(الجيريائي دينار),
				'other' => q(الجيريائي دينار),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(مصري پائونڊ),
				'one' => q(مصري پائونڊ),
				'other' => q(مصري پائونڊ),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(ايريٽيريائي ناڪفا),
				'one' => q(ايريٽيريائي ناڪفا),
				'other' => q(ايريٽيريائي ناڪفا),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ايٿوپيائي بر),
				'one' => q(ايٿوپيائي بر),
				'other' => q(ايٿوپيائي بر),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(يورو),
				'one' => q(يورو),
				'other' => q(يورو),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(فجي ڊالر),
				'one' => q(فجي ڊالر),
				'other' => q(فجي ڊالر),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(فاڪلينڊ ٻيٽ پائونڊ),
				'one' => q(فاڪلينڊ ٻيٽ پائونڊ),
				'other' => q(فاڪلينڊ ٻيٽ پائونڊ),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(برطانوي پائونڊ),
				'one' => q(برطانوي پائونڊ),
				'other' => q(برطانوي پائونڊ),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(جارجيائي لاري),
				'one' => q(جارجيائي لاري),
				'other' => q(جارجيائي لاري),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(گهانين سيدي),
				'one' => q(گهانين سيدي),
				'other' => q(گهانين سيدي),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(جبرالٽر پائونڊ),
				'one' => q(جبرالٽر پائونڊ),
				'other' => q(جبرالٽر پائونڊ),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(گيمبيا دلاسائي),
				'one' => q(گيمبيا دلاسائي),
				'other' => q(گيمبيا دلاسائي),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(گني فرينڪ),
				'one' => q(گني فرينڪ),
				'other' => q(گني فرينڪ),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(گوئٽي مالا ڪٽزل),
				'one' => q(گوئٽي مالا ڪٽزل),
				'other' => q(گوئٽي مالا ڪٽزل),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(گيانا ڊالر),
				'one' => q(گيانا ڊالر),
				'other' => q(گيانا ڊالر),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(هانگ ڪانگ ڊالر),
				'one' => q(هانگ ڪانگ ڊالر),
				'other' => q(هانگ ڪانگ ڊالر),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(هونڊوراس ليمپرا),
				'one' => q(هونڊوراس ليمپرا),
				'other' => q(هونڊوراس ليمپرا),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(ڪروشيائي ڪونا),
				'one' => q(ڪروشيائي ڪونا),
				'other' => q(ڪروشيائي ڪونا),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(هيٽي گورڊي),
				'one' => q(هيٽي گورڊي),
				'other' => q(هيٽي گورڊي),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(هنگيرين فورنٽ),
				'one' => q(هنگيرين فورنٽ),
				'other' => q(هنگيرين فورنٽ),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(انڊونيشيائي رپيه),
				'one' => q(انڊونيشيائي رپيه),
				'other' => q(انڊونيشيائي رپيه),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(اسرائيلي نيو شيڪل),
				'one' => q(اسرائيلي نيو شيڪل),
				'other' => q(اسرائيلي نيو شيڪل),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(انڊين رپي),
				'one' => q(انڊين رپي),
				'other' => q(انڊين رپي),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(عراقي دينار),
				'one' => q(عراقي دينار),
				'other' => q(عراقي دينار),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ايراني ريال),
				'one' => q(ايراني ريال),
				'other' => q(ايراني ريال),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(آئيس لينڊي ڪرونا),
				'one' => q(آئيس لينڊي ڪرونا),
				'other' => q(آئيس لينڊي ڪرونا),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(جميڪائي ڊالر),
				'one' => q(جميڪائي ڊالر),
				'other' => q(جميڪائي ڊالر),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(اردني دينار),
				'one' => q(اردني دينار),
				'other' => q(اردني دينار),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(جاپاني يين),
				'one' => q(جاپاني يين),
				'other' => q(جاپاني يين),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(ڪينيائي سلنگ),
				'one' => q(ڪينيائي سلنگ),
				'other' => q(ڪينيائي سلنگ),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(ڪرغزستاني سوم),
				'one' => q(ڪرغزستاني سوم),
				'other' => q(ڪرغزستاني سوم),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(ڪمبوڊيائي ريال),
				'one' => q(ڪمبوڊيائي ريال),
				'other' => q(ڪمبوڊيائي ريال),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(ڪوموريائي فرينڪ),
				'one' => q(ڪوموريائي فرينڪ),
				'other' => q(ڪوموريائي فرينڪ),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(اتر ڪوريائي ون),
				'one' => q(اتر ڪوريائي ون),
				'other' => q(اتر ڪوريائي ون),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(ڏکڻ ڪوريائي ون),
				'one' => q(ڏکڻ ڪوريائي ون),
				'other' => q(ڏکڻ ڪوريائي ون),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(ڪويتي دينار),
				'one' => q(ڪويتي دينار),
				'other' => q(ڪويتي دينار),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(ڪيمين ٻيٽ ڊالر),
				'one' => q(ڪيمين ٻيٽ ڊالر),
				'other' => q(ڪيمين ٻيٽ ڊالر),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(قازقستان ٽينگا),
				'one' => q(قازقستان ٽينگا),
				'other' => q(قازقستان ٽينگا),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(لائوشيائي ڪپ),
				'one' => q(لائوشيائي ڪپ),
				'other' => q(لائوشيائي ڪپ),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(لبناني پائونڊ),
				'one' => q(لبناني پائونڊ),
				'other' => q(لبناني پائونڊ),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(سري لنڪن رپي),
				'one' => q(سري لنڪن رپي),
				'other' => q(سري لنڪن رپي),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(لائبیریائی ڊالر),
				'one' => q(لائبیریائی ڊالر),
				'other' => q(لائبیریائی ڊالر),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(لبيائي دينار),
				'one' => q(لبيائي دينار),
				'other' => q(لبيائي دينار),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(موروڪيائي درهم),
				'one' => q(موروڪيائي درهم),
				'other' => q(موروڪيائي درهم),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(مالديپ ليو),
				'one' => q(مالديپ ليو),
				'other' => q(مالديپ ليو),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(ملاگاسي اریاری),
				'one' => q(ملاگاسي اریاری),
				'other' => q(ملاگاسي اریاری),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(ميسي ڊوني دينار),
				'one' => q(ميسي ڊوني دينار),
				'other' => q(ميسي ڊوني دينار),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(ميانمار ڪياٽ),
				'one' => q(ميانمار ڪياٽ),
				'other' => q(ميانمار ڪياٽ),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(منگولي تجرڪ),
				'one' => q(منگولي تجرڪ),
				'other' => q(منگولي تجرڪ),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(ميڪانيز پٽاڪا),
				'one' => q(ميڪانيز پٽاڪا),
				'other' => q(ميڪانيز پٽاڪا),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(موريشيائي اوگوئیا \(1973–2017\)),
				'one' => q(موريشيائي اوگوئیا \(1973–2017\)),
				'other' => q(موريشيائي اوگوئیا \(1973–2017\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(موريشيائي اوگوئیا),
				'one' => q(موريشيائي اوگوئیا),
				'other' => q(موريشيائي اوگوئیا),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(ماريشيائي رپي),
				'one' => q(ماريشين روپي),
				'other' => q(ماريشيائي رپي),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(مالديپ روفيا),
				'one' => q(مالديپ روفيا),
				'other' => q(مالديپ روفيا),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(ملاوي ڪواچا),
				'one' => q(ملاوي ڪواچا),
				'other' => q(ملاوي ڪواچا),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(ميڪسيڪو پيسو),
				'one' => q(ميڪسيڪو پيسو),
				'other' => q(ميڪسيڪو پيسو),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(ملائيشيائي رنگٽ),
				'one' => q(ملائيشيائي رنگٽ),
				'other' => q(ملائيشيائي رنگٽ),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(موزمبيق ميٽيڪل),
				'one' => q(موزمبيق ميٽيڪل),
				'other' => q(موزمبيق ميٽيڪل),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(نميبائي ڊالر),
				'one' => q(نميبائي ڊالر),
				'other' => q(نميبائي ڊالر),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(نائجريائي نائرا),
				'one' => q(نائجريائي نائرا),
				'other' => q(نائجريائي نائرا),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(نڪارا گوا ڪارڊوبا),
				'one' => q(نڪارا گوا ڪارڊوبا),
				'other' => q(نڪارا گوا ڪارڊوبا),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(نارويائي ڪرون),
				'one' => q(نارويائي ڪرون),
				'other' => q(نارويائي ڪرون),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(نيپالي رپي),
				'one' => q(نيپالي رپي),
				'other' => q(نيپالي رپي),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(نيوزي لينڊي ڊالر),
				'one' => q(نيوزي لينڊي ڊالر),
				'other' => q(نيوزي لينڊي ڊالر),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(عماني ريال),
				'one' => q(عماني ريال),
				'other' => q(عماني ريال),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(پاناما پالبوا),
				'one' => q(پاناما پالبوا),
				'other' => q(پاناما پالبوا),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(پيرو سول),
				'one' => q(پيرو سول),
				'other' => q(پيرو سول),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(پاپوا نيو گني ڪنا),
				'one' => q(پاپوا نيو گني ڪنا),
				'other' => q(پاپوا نيو گني ڪنا),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(فلپائني پيسو),
				'one' => q(فلپائني پيسو),
				'other' => q(فلپائني پيسو),
			},
		},
		'PKR' => {
			symbol => 'Rs',
			display_name => {
				'currency' => q(پاڪستاني رپي),
				'one' => q(پاڪستاني رپي),
				'other' => q(پاڪستاني رپي),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(پولش زلاٽي),
				'one' => q(پولش زلاٽي),
				'other' => q(پولش زلاٽي),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(پيراگوئي گاراني),
				'one' => q(پيراگوئي گاراني),
				'other' => q(پيراگوئي گاراني),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(قطري ريال),
				'one' => q(قطري ريال),
				'other' => q(قطري ريال),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(رومانیائي لیو),
				'one' => q(رومانیائي لیو),
				'other' => q(رومانیائي لیو),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(سربيا دينار),
				'one' => q(سربيا دينار),
				'other' => q(سربيا دينار),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(روسي ربل),
				'one' => q(روسي ربل),
				'other' => q(روسي ربل),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(روانڊا فرينڪ),
				'one' => q(روانڊا فرينڪ),
				'other' => q(روانڊا فرينڪ),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(سعودي ريال),
				'one' => q(سعودي ريال),
				'other' => q(سعودي ريال),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(سولومان ٻيٽ ڊالر),
				'one' => q(سولومان ٻيٽ ڊالر),
				'other' => q(سولومان ٻيٽ ڊالر),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(سشلي رپي),
				'one' => q(سشلي رپي),
				'other' => q(سشلي رپي),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(سوڊاني پائونڊ),
				'one' => q(سوڊاني پائونڊ),
				'other' => q(سوڊاني پائونڊ),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(سويڊني ڪرونا),
				'one' => q(سويڊني ڪرونا),
				'other' => q(سويڊني ڪرونا),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(سنگاپوري ڊالر),
				'one' => q(سنگاپوري ڊالر),
				'other' => q(سنگاپوري ڊالر),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(سينٽ هيلنا پائونڊ),
				'one' => q(سينٽ هيلنا پائونڊ),
				'other' => q(سينٽ هيلنا پائونڊ),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(سیرا لیونيائي لیون),
				'one' => q(سیرا لیونيائي لیون),
				'other' => q(سیرا لیونيائي لیون),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(سومالي شلنگ),
				'one' => q(سومالي شلنگ),
				'other' => q(سومالي شلنگ),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(سرينامي ڊالر),
				'one' => q(سرينامي ڊالر),
				'other' => q(سرينامي ڊالر),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(ڏکڻ سوڊاني پائونڊ),
				'one' => q(ڏکڻ سوڊاني پائونڊ),
				'other' => q(ڏکڻ سوڊاني پائونڊ),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(سائو ٽوم ۽ پرنسپي دوبرا \(1977–2017\)),
				'one' => q(سائو ٽوم ۽ پرنسپي دوبرا \(1977–2017\)),
				'other' => q(سائو ٽوم ۽ پرنسپي دوبرا \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(سائو ٽوم ۽ پرنسپي دوبرا),
				'one' => q(سائو ٽوم ۽ پرنسپي دوبرا),
				'other' => q(سائو ٽوم ۽ پرنسپي دوبرا),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(سيريائي پائونڊ),
				'one' => q(سيريائي پائونڊ),
				'other' => q(سيريائي پائونڊ),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(سوازي للانگيني),
				'one' => q(سوازي للانگيني),
				'other' => q(سوازي للانگيني),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(ٿائي باهت),
				'one' => q(ٿائي باهت),
				'other' => q(ٿائي باهت),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(تاجڪستاني سوموني),
				'one' => q(تاجڪستاني سوموني),
				'other' => q(تاجڪستاني سوموني),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(ترڪمانستان منت),
				'one' => q(ترڪمانستان منت),
				'other' => q(ترڪمانستان منت),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(تیونس دینار),
				'one' => q(تیونس دینار),
				'other' => q(تیونس دینار),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(تونگن پانگا),
				'one' => q(تونگن پانگا),
				'other' => q(تونگن پانگا),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(ترڪي لرا),
				'one' => q(ترڪي لرا),
				'other' => q(ترڪي لرا),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ٽرينڊيڊ ۽ ٽوباگو ڊالر),
				'one' => q(ٽرينڊيڊ ۽ ٽوباگو ڊالر),
				'other' => q(ٽرينڊيڊ ۽ ٽوباگو ڊالر),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(نيو تائيوان ڊالر),
				'one' => q(نيو تائيوان ڊالر),
				'other' => q(نيو تائيوان ڊالر),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(تنزانيائي شلنگ),
				'one' => q(تنزانيائي شلنگ),
				'other' => q(تنزانيائي شلنگ),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(یوڪرائن هریونیا),
				'one' => q(یوڪرائن هریونیا),
				'other' => q(یوڪرائن هریونیا),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(يگانڊا شلنگ),
				'one' => q(يگانڊا شلنگ),
				'other' => q(يگانڊا شلنگ),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(آمريڪي ڊالر),
				'one' => q(آمريڪي ڊالر),
				'other' => q(آمريڪي ڊالر),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(يوروگوئي پيسو),
				'one' => q(يوروگوئي پيسو),
				'other' => q(يوروگوئي پيسو),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ازبڪستاني سوم),
				'one' => q(ازبڪستاني سوم),
				'other' => q(ازبڪستاني سوم),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(Venezuelan Bolívar \(2008–2018\)),
				'one' => q(وینزویلا بولیور \(2008–2018\)),
				'other' => q(وینزویلا بولیور \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(وینزویلا بولیور),
				'one' => q(وینزویلا بولیور),
				'other' => q(وینزویلا بولیور),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ويٽنامي ڊونگ),
				'one' => q(ويٽنامي ڊونگ),
				'other' => q(ويٽنامي ڊونگ),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(وانواتو واتو),
				'one' => q(وانواتو واتو),
				'other' => q(وانواتو واتو),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(ساموآن ٽالا),
				'one' => q(ساموآن ٽالا),
				'other' => q(ساموآن ٽالا),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(وچ آفريڪا فرينڪ),
				'one' => q(وچ آفريڪا فرينڪ),
				'other' => q(وچ آفريڪا فرينڪ),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(اوڀر ڪيريبين ڊالر),
				'one' => q(اوڀر ڪيريبين ڊالر),
				'other' => q(اوڀر ڪيريبين ڊالر),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(اولهه آفريڪا فرينڪ),
				'one' => q(اولهه آفريڪا فرينڪ),
				'other' => q(اولهه آفريڪا فرينڪ),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP فرينڪ),
				'one' => q(CFP فرينڪ),
				'other' => q(CFP فرينڪ),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(اڻڄاتل سڪو),
				'one' => q(اڻڄاتل سڪو),
				'other' => q(اڻڄاتل سڪو),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(يمني ريال),
				'one' => q(يمني ريال),
				'other' => q(يمني ريال),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(ڏکڻ آفريقي رانڊ),
				'one' => q(ڏکڻ آفريقي رانڊ),
				'other' => q(ڏکڻ آفريقي رانڊ),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(زمبائي ڪواچا),
				'one' => q(زمبائي ڪواچا),
				'other' => q(زمبائي ڪواچا),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'جنوري',
							'فيبروري',
							'مارچ',
							'اپريل',
							'مئي',
							'جون',
							'جولاءِ',
							'آگسٽ',
							'سيپٽمبر',
							'آڪٽوبر',
							'نومبر',
							'ڊسمبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'J',
							'F',
							'M',
							'A',
							'M',
							'J',
							'J',
							'A',
							'S',
							'O',
							'N',
							'D'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنوري',
							'فيبروري',
							'مارچ',
							'اپريل',
							'مئي',
							'جون',
							'جولاءِ',
							'آگسٽ',
							'سيپٽمبر',
							'آڪٽوبر',
							'نومبر',
							'ڊسمبر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'جنوري',
							'فيبروري',
							'مارچ',
							'اپريل',
							'مئي',
							'جون',
							'جولاءِ',
							'آگسٽ',
							'سيپٽمبر',
							'آڪٽوبر',
							'نومبر',
							'ڊسمبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'J',
							'F',
							'M',
							'A',
							'M',
							'J',
							'J',
							'A',
							'S',
							'O',
							'N',
							'D'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنوري',
							'فيبروري',
							'مارچ',
							'اپريل',
							'مئي',
							'جون',
							'جولاءِ',
							'آگسٽ',
							'سيپٽمبر',
							'آڪٽوبر',
							'نومبر',
							'ڊسمبر'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'سومر',
						tue => 'اڱارو',
						wed => 'اربع',
						thu => 'خميس',
						fri => 'جمعو',
						sat => 'ڇنڇر',
						sun => 'آچر'
					},
					narrow => {
						mon => 'سو',
						tue => 'اڱارو',
						wed => 'اربع',
						thu => 'خم',
						fri => 'جمعو',
						sat => 'ڇنڇر',
						sun => 'آچر'
					},
					short => {
						mon => 'سومر',
						tue => 'اڱارو',
						wed => 'اربع',
						thu => 'خميس',
						fri => 'جمعو',
						sat => 'ڇنڇر',
						sun => 'آچر'
					},
					wide => {
						mon => 'سومر',
						tue => 'اڱارو',
						wed => 'اربع',
						thu => 'خميس',
						fri => 'جمعو',
						sat => 'ڇنڇر',
						sun => 'آچر'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'سومر',
						tue => 'اڱارو',
						wed => 'اربع',
						thu => 'خميس',
						fri => 'جمعو',
						sat => 'ڇنڇر',
						sun => 'آچر'
					},
					narrow => {
						mon => 'سو',
						tue => 'اڱارو',
						wed => 'اربع',
						thu => 'خم',
						fri => 'جمعو',
						sat => 'ڇنڇر',
						sun => 'آچر'
					},
					short => {
						mon => 'سومر',
						tue => 'اڱارو',
						wed => 'اربع',
						thu => 'خميس',
						fri => 'جمعو',
						sat => 'ڇنڇر',
						sun => 'آچر'
					},
					wide => {
						mon => 'سومر',
						tue => 'اڱارو',
						wed => 'اربع',
						thu => 'خميس',
						fri => 'جمعو',
						sat => 'ڇنڇر',
						sun => 'آچر'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q5'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'پهرين ٽي ماهي',
						1 => 'ٻين ٽي ماهي',
						2 => 'ٽين ٽي ماهي',
						3 => 'چوٿين ٽي ماهي'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'پهرين ٽي ماهي',
						1 => 'ٻين ٽي ماهي',
						2 => 'ٽين ٽي ماهي',
						3 => 'چوٿين ٽي ماهي'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{صبح، منجهند},
					'pm' => q{شام، منجهند},
				},
				'narrow' => {
					'am' => q{صبح، منجهند},
					'pm' => q{منجهند، شام},
				},
				'wide' => {
					'am' => q{صبح، منجهند},
					'pm' => q{منجهند، شام},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'am' => q{صبح، منجهند},
					'pm' => q{منجهند، شام},
				},
				'narrow' => {
					'am' => q{صبح، منجهند},
					'pm' => q{منجهند، شام},
				},
				'wide' => {
					'am' => q{صبح، منجهند},
					'pm' => q{منجهند، شام},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'BC',
				'1' => 'CD'
			},
			wide => {
				'0' => 'مسيح کان اڳ',
				'1' => 'عيسوي کان پهرين'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{G y MMMM d, EEEE},
			'long' => q{G y MMMM d},
			'medium' => q{G y MMM d},
			'short' => q{GGGGG y-MM-dd},
		},
		'gregorian' => {
			'full' => q{y MMMM d, EEEE},
			'long' => q{y MMMM d},
			'medium' => q{y MMM d},
			'short' => q{y-MM-dd},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{MM-dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{MM-dd},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{GGGGG y-MM},
			yyyyMEd => q{GGGGG y-MM-dd, E},
			yyyyMMM => q{G y MMM},
			yyyyMMMEd => q{G y MMM d, E},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{G y MMM d},
			yyyyMd => q{GGGGG y-MM-dd},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{MM-dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMW => q{ھفتو W جو MMMM},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{MM-dd},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y-MM},
			yMEd => q{y-MM-dd, E},
			yMMM => q{y MMM},
			yMMMEd => q{y MMM d, E},
			yMMMM => q{y MMMM},
			yMMMd => q{y MMM d},
			yMd => q{y-MM-dd},
			yQQQ => q{y QQQ},
			yQQQQ => q{y QQQQ},
			yw => q{ھفتو w جو Y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM-dd, E – MM-dd, E},
				d => q{MM-dd, E – MM-dd, E},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{GGGGG y-MM – y-MM},
				y => q{GGGGG y-MM – y-MM},
			},
			yMEd => {
				M => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				d => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				y => q{GGGGG y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{G y MMM–MMM},
				y => q{G y MMM – y MMM},
			},
			yMMMEd => {
				M => q{G y MMM d, E – MMM d, E},
				d => q{G y MMM d, E – MMM d, E},
				y => q{G y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{G y MMMM–MMMM},
				y => q{G y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{G y MMM d – MMM d},
				d => q{G y MMM d–d},
				y => q{G y MMM d – y MMM d},
			},
			yMd => {
				M => q{GGGGG y-MM-dd – y-MM-dd},
				d => q{GGGGG y-MM-dd – y-MM-dd},
				y => q{GGGGG y-MM-dd – y-MM-dd},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM-dd, E – MM-dd, E},
				d => q{MM-dd, E – MM-dd, E},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{y-MM – y-MM},
				y => q{y-MM – y-MM},
			},
			yMEd => {
				M => q{y-MM-dd, E – y-MM-dd, E},
				d => q{y-MM-dd, E – y-MM-dd, E},
				y => q{y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{y MMM–MMM},
				y => q{y MMM – y MMM},
			},
			yMMMEd => {
				M => q{y MMM d, E – MMM d, E},
				d => q{y MMM d, E – MMM d, E},
				y => q{y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{y MMMM–MMMM},
				y => q{y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{y MMM d – MMM d},
				d => q{y MMM d–d},
				y => q{y MMM d – y MMM d},
			},
			yMd => {
				M => q{y-MM-dd – y-MM-dd},
				d => q{y-MM-dd – y-MM-dd},
				y => q{y-MM-dd – y-MM-dd},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} وقت),
		regionFormat => q({0} ڏينهن جو وقت),
		regionFormat => q({0} معياري وقت),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#افغانستان جو وقت#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#ابي جان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ايڪرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ايڊيس اببا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#الجيرز#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ازمارا#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#باماڪو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بنگي#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بينجال#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بسائو#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلنٽائر#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برازاويل#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بوجمبورا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#قائرا#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ڪاسابلانڪا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#سيوٽا#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ڪوناڪري#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ڊاڪار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دارالسلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#جبوتي#,
		},
		'Africa/Douala' => {
			exemplarCity => q#دوالا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ال ايون#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فري ٽائون#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#گيبورون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#هراري#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#جوهانسبرگ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جوبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ڪمپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#خرطوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ڪيگالي#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ڪنشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لاگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لیبرویلی#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لوم#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لوانڊا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لوبمباشی#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لوساڪا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ملابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ماپوتو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ماسيرو#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مبابين#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موغادیشو#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونروویا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نيروبي#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#نجامينا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نيامي#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نواڪشوط#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#آئوگو ڊائوگو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورٽو نوو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#سائو ٽوم#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ٽرپولي#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#تيونس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ونڊهوڪ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#مرڪزي آفريقا جو وقت#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#اوڀر آفريڪا جو وقت#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#ڏکڻ آفريڪا جو معياري وقت#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#اولهه آفريقا جي اونهاري جو وقت#,
				'generic' => q#اولهه آفريقا جو وقت#,
				'standard' => q#اولهه آفريقا جو معياري وقت#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#الاسڪا جي ڏينهن جو وقت#,
				'generic' => q#الاسڪا جو وقت#,
				'standard' => q#الاسڪا جو معياري وقت#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ايميزون جي اونهاري جو وقت#,
				'generic' => q#ايميزون جو وقت#,
				'standard' => q#ايميزون جو معياري وقت#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#ادڪ#,
		},
		'America/Anchorage' => {
			exemplarCity => q#اينڪريج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#انگويلا#,
		},
		'America/Antigua' => {
			exemplarCity => q#اينٽيگوا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#اراگویانا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لا ریئوجا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ریو گالیگوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالٽا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سان جوآن#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سان لوئیس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ٽوڪومين#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اوشوآئیا#,
		},
		'America/Aruba' => {
			exemplarCity => q#اروبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#اسانسیون#,
		},
		'America/Bahia' => {
			exemplarCity => q#باحيه#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#باهیا بیندراس#,
		},
		'America/Barbados' => {
			exemplarCity => q#بارباڊوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بیلم#,
		},
		'America/Belize' => {
			exemplarCity => q#بیلیز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلانڪ سبلون#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بائو وستا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بگوٽا#,
		},
		'America/Boise' => {
			exemplarCity => q#بوئس#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بيونوس ايئرس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ڪيمبرج بي#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ڪيمپو گرانڊي#,
		},
		'America/Cancun' => {
			exemplarCity => q#ڪانڪون#,
		},
		'America/Caracas' => {
			exemplarCity => q#ڪراڪس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ڪيٽا مارڪا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#ڪائين#,
		},
		'America/Cayman' => {
			exemplarCity => q#سيامن#,
		},
		'America/Chicago' => {
			exemplarCity => q#شڪاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چي هوا هوا#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اٽيڪوڪن#,
		},
		'America/Cordoba' => {
			exemplarCity => q#ڪارڊوبا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ڪوسٽا ريڪا#,
		},
		'America/Creston' => {
			exemplarCity => q#ڪريسٽن#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ڪوئيابا#,
		},
		'America/Curacao' => {
			exemplarCity => q#ڪيوراسائو#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ڊينمارڪ شون#,
		},
		'America/Dawson' => {
			exemplarCity => q#ڊاوسن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ڊاوسن ڪريڪ#,
		},
		'America/Denver' => {
			exemplarCity => q#ڊينور#,
		},
		'America/Detroit' => {
			exemplarCity => q#ڊيٽرائيٽ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ڊومينيڪا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ايڊمونٽن#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ايرونيپ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ايل سلواڊور#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#فورٽ نيلسن#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورٽاليزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گليس بي#,
		},
		'America/Godthab' => {
			exemplarCity => q#نيوڪ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوز بي#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#گرانڊ ترڪ#,
		},
		'America/Grenada' => {
			exemplarCity => q#گريناڊا#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گواڊيلوپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گوئٽي مالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گواياڪيل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گيانا#,
		},
		'America/Halifax' => {
			exemplarCity => q#هيلي فيڪس#,
		},
		'America/Havana' => {
			exemplarCity => q#هوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#هرموسلو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ناڪس، انڊيانا#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#مرينگو، انڊيانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پيٽرسبرگ، انڊيانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ٽيل سٽي، انڊيانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ويوي، انڊيانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ونسینیز، انڊیانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ويناميڪ، انڊيانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#انڊيانا پولس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#انووڪ#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#اڪالوئٽ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جمائڪا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ڪوڪوئي#,
		},
		'America/Juneau' => {
			exemplarCity => q#جونئو#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مونٽيسيلو، ڪينٽڪي#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ڪرالينڊڪ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لا پز#,
		},
		'America/Lima' => {
			exemplarCity => q#ليما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لاس اينجلس#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوئي ويل#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#لوئر پرنسز ڪوارٽر#,
		},
		'America/Maceio' => {
			exemplarCity => q#میسیئو#,
		},
		'America/Managua' => {
			exemplarCity => q#ماناگوا#,
		},
		'America/Manaus' => {
			exemplarCity => q#منائوس#,
		},
		'America/Marigot' => {
			exemplarCity => q#ميريگوٽ#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارٽينڪ#,
		},
		'America/Matamoros' => {
			exemplarCity => q#متاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#مزاٽلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مينڊوزا#,
		},
		'America/Menominee' => {
			exemplarCity => q#مینومیني#,
		},
		'America/Merida' => {
			exemplarCity => q#ميريڊا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#ميٽلاڪاٽالا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ميڪسيڪو شهر#,
		},
		'America/Miquelon' => {
			exemplarCity => q#میڪوئیلون#,
		},
		'America/Moncton' => {
			exemplarCity => q#مانڪٽن#,
		},
		'America/Monterrey' => {
			exemplarCity => q#مانٽيري#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونٽي ويڊيو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مانٽسريٽ#,
		},
		'America/Nassau' => {
			exemplarCity => q#ناسائو#,
		},
		'America/New_York' => {
			exemplarCity => q#نيويارڪ#,
		},
		'America/Nipigon' => {
			exemplarCity => q#نپيگان#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورانهيا#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بيولاه، اتر ڊڪوٽا#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#سينٽر، اتر ڊڪوٽا#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نيو سيلم، اتر ڊڪوٽا#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#اوڪيناگا#,
		},
		'America/Panama' => {
			exemplarCity => q#پناما#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#پینگنرٽنگ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پيراميريبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#فونيڪس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پورٽ او پرنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#اسپين جو ٻيٽ#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پورٽو ويلهو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پورٽو ريڪو#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#پنٽا اريناس#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ريني رور#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#رينڪن انليٽ#,
		},
		'America/Recife' => {
			exemplarCity => q#هيسيفي#,
		},
		'America/Regina' => {
			exemplarCity => q#ریجینا#,
		},
		'America/Resolute' => {
			exemplarCity => q#ريزوليوٽ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ريو برانڪو#,
		},
		'America/Santarem' => {
			exemplarCity => q#سنٽاريم#,
		},
		'America/Santiago' => {
			exemplarCity => q#سينٽياگو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سينٽو ڊومينگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#سائو پولو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#اٽوڪورٽومائٽ#,
		},
		'America/Sitka' => {
			exemplarCity => q#سٽڪا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سينٽ برٿليمي#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سينٽ جانز#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سينٽ ڪٽس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سينٽ لوسيا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سينٽ ٿامس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سينٽ ونسينٽ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سوئفٽ ڪرنٽ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ٽيگوسيگلپا#,
		},
		'America/Thule' => {
			exemplarCity => q#ٿولي#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#ٿنڊر بي#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تيجوانا#,
		},
		'America/Toronto' => {
			exemplarCity => q#ٽورنٽو#,
		},
		'America/Tortola' => {
			exemplarCity => q#ٽورٽولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#وينڪوور#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وائيٽ هائوس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#وني پيگ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ياڪوتات#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ييلو نائيف#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#مرڪزي ڏينهن جو وقت#,
				'generic' => q#مرڪزي وقت#,
				'standard' => q#مرڪزي معياري وقت#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#مشرقي ڏينهن جو وقت#,
				'generic' => q#مشرقي وقت#,
				'standard' => q#مشرقي معياري وقت#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#پهاڙي ڏينهن جو وقت#,
				'generic' => q#پهاڙي وقت#,
				'standard' => q#پهاڙي معياري وقت#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#پيسيفڪ ڏينهن جو وقت#,
				'generic' => q#پيسيفڪ وقت#,
				'standard' => q#پيسيفڪ معياري وقت#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ڪيسي#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ڊيوس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ڊومانٽ درويئل#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#مڪوائري#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#موسن#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ميڪ مرڊو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پامر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روڌرا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#سيووا#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ٽرول#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ووستوڪ#,
		},
		'Apia' => {
			long => {
				'daylight' => q#اپيا جي ڏينهن جو وقت#,
				'generic' => q#اپيا جو وقت#,
				'standard' => q#اپيا جو معياري وقت#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#عربين جي ڏينهن جو وقت#,
				'generic' => q#عربين جو وقت#,
				'standard' => q#عربين جو معياري وقت#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لانگ ائيربن#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ارجنٽائن جي اونهاري جو وقت#,
				'generic' => q#ارجنٽائن وقت#,
				'standard' => q#ارجنٽائن معياري وقت#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#مغربي ارجنٽائن جي اونهاري جو وقت#,
				'generic' => q#مغربي ارجنٽائن وقت#,
				'standard' => q#مغربي ارجنٽائن جو معياري وقت#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#آرمينيا جي اونهاري جو وقت#,
				'generic' => q#آرمينيا جو وقت#,
				'standard' => q#آرمينيا جو معياري وقت#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#عدن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#الماتي#,
		},
		'Asia/Amman' => {
			exemplarCity => q#امان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#انيدر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#اڪٽائو#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#ايڪٽوب#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#آشگاباد#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#آتيرائو#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بحرين#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باڪو#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بئنڪاڪ#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#برنل#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بيروت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بشڪيڪ#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برونائي#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ڪلڪتا#,
		},
		'Asia/Chita' => {
			exemplarCity => q#چيتا#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#چوئي بيلسن#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ڪولمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دمشق#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ڍاڪا#,
		},
		'Asia/Dili' => {
			exemplarCity => q#دلي#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دبئي#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دوشانبي#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#فاماگوستا#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غزه#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#هيبرون#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#هانگ ڪانگ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#هووڊ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ارڪتسڪ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جڪارتا#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جياپورا#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#يوروشلم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ڪابل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#ڪمچاسڪي#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ڪراچي#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کٽمنڊو#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#کندياگا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ڪريسنويارسڪ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ڪوللمپور#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کوچنگ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ڪويت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#مڪائو#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#مگادان#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ميڪاسر#,
		},
		'Asia/Manila' => {
			exemplarCity => q#منيلا#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مسقط#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نيڪوسيا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نووڪزنيتسڪ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نوواسبئيرسڪ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسڪ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#زباني#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#فنام پينه#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونٽيانڪ#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#شيانگ يانگ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قطر#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ڪيزلورڊا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#رنگون#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#رياض#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#هوچي من#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#شخالين#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سمرقند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سيول#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شنگهائي#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سنگاپور#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#سريديڪوليمسڪ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تائپي#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشقنت#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#تبليسي#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تهران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ٿمفو#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ٽوڪيو#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#تمسڪ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اولان باتر#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#يورمڪي#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#اسٽ نيرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وينٽيان#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ولادووستوڪ#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ياڪتسڪ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#یڪاٽرنبرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#يريوان#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#ايٽلانٽڪ جي ڏينهن جو وقت#,
				'generic' => q#ايٽلانٽڪ جو وقت#,
				'standard' => q#ايٽلانٽڪ جو معياري وقت#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ازورز#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برمودا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ڪينري#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ڪيپ ورڊي#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فيرو#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#ماڊيرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ريڪيوڪ#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ڏکڻ جورجيا#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سينٽ هيلينا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#اسٽينلي#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ايڊيلينڊ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#برسبين#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروڪن هل#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ڪري#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ڊارون#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#يوڪلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#هوبارٽ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لنڊمين#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لارڊ هائو#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ميلبورن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پرٿ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سڊني#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#آسٽريليا جو مرڪزي ڏينهن جو وقت#,
				'generic' => q#مرڪزي آسٽريليا جو وقت#,
				'standard' => q#آسٽريليا جو مرڪزي معياري وقت#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#آسٽريليا جو مرڪزي مغربي ڏينهن جو وقت#,
				'generic' => q#آسٽريليا جو مرڪزي مغربي وقت#,
				'standard' => q#آسٽريليا جو مرڪزي مغربي معياري وقت#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#آسٽريليا جو مشرقي ڏينهن جو وقت#,
				'generic' => q#اوڀر آسٽريليا جو وقت#,
				'standard' => q#آسٽريليا جو مشرقي معياري وقت#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#آسٽريليا جو مغربي ڏينهن جو وقت#,
				'generic' => q#مغربي آسٽريليا جو وقت#,
				'standard' => q#آسٽريليا جو مغربي معياري وقت#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#آذربائيجان جي اونهاري جو وقت#,
				'generic' => q#آذربائيجان جو وقت#,
				'standard' => q#آذربائيجان جو معياري وقت#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ازورز جي اونهاري جو وقت#,
				'generic' => q#ازورز جو وقت#,
				'standard' => q#ازورز جو معياري وقت#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#بنگلاديش جي اونهاري جو وقت#,
				'generic' => q#بنگلاديش جو وقت#,
				'standard' => q#بنگلاديش جو معياري وقت#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ڀوٽان جو وقت#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#بولويائي وقت#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#براسيليا جي اونهاري جو وقت#,
				'generic' => q#بريسيليائي وقت#,
				'standard' => q#براسيليا جو معياري وقت#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#برونائي داروالسلام جو وقت#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#ڪيپ ورڊ جي اونهاري جو وقت#,
				'generic' => q#ڪيپ ورڊ جو وقت#,
				'standard' => q#ڪيپ ورڊ جو معياري وقت#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#چمورو جو معياري وقت#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#چئٿم جي ڏينهن جو وقت#,
				'generic' => q#چئٿم جو وقت#,
				'standard' => q#چئٿم جو معياري وقت#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#چلي جي اونهاري جو وقت#,
				'generic' => q#چلي جو وقت#,
				'standard' => q#چلي جو معياري وقت#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#چائنا جي ڏينهن جو وقت#,
				'generic' => q#چائنا جو وقت#,
				'standard' => q#چائنا جو معياري وقت#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#چوئي بيلسن جي اونهاري جو وقت#,
				'generic' => q#چوئي بيلسن جو وقت#,
				'standard' => q#چوئي بيلسن جو معياري وقت#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ڪرسمس آئي لينڊ جو وقت#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#ڪوڪوس آئي لينڊ جو وقت#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#ڪولمبيا جي اونهاري جو وقت#,
				'generic' => q#ڪولمبيا جو وقت#,
				'standard' => q#ڪولمبيا جو معياري وقت#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#ڪوڪ آئي لينڊ جي اڌ اونهاري جو وقت#,
				'generic' => q#ڪوڪ آئي لينڊ جو وقت#,
				'standard' => q#ڪوڪ آئي لينڊ جو معياري وقت#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#ڪيوبا جي ڏينهن جو وقت#,
				'generic' => q#ڪيوبا جو وقت#,
				'standard' => q#ڪيوبا جو معياري وقت#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ڊيوس جو وقت#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ڊومانٽ درويئل جو وقت#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#اوڀر تيمور جو وقت#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ايسٽر آئي لينڊ جي اونهاري جو وقت#,
				'generic' => q#ايسٽر آئي لينڊ جو وقت#,
				'standard' => q#ايسٽر آئي لينڊ جو معياري وقت#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ايڪواڊور جو وقت#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#گڏيل دنياوي وقت#,
			},
			short => {
				'standard' => q#م ع و#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#اڻڄاتل شهر#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ايمسٽرڊيم#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#اندورا#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#آستراخان#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ايٿنز#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بلغراد#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#برلن#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#براتيسلوا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#برسلز#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بخاريسٽ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بداپيسٽ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بزيجين#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#چسينائو#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ڪوپن هيگن#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ڊبلن#,
			long => {
				'daylight' => q#آئرش جو معياري وقت#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#جبرالٽر#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#گرنزي#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#هيلسنڪي#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#آئيزل آف مين#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#استنبول#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جرسي#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ڪلينن گراڊ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#ڪيف#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#ڪيروف#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لسبن#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#لبليانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لنڊن#,
			long => {
				'daylight' => q#برطانيا جي اونهاري جو وقت#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لگزمبرگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#ميڊرڊ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالٽا#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ميريهام#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#منسڪ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناڪو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ماسڪو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اوسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پئرس#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پوڊگورسيا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراگ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#رگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#روم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سمارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سين مرينو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#سراجیوو#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#سراتو#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سمفروپول#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#اسڪوپي#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#سوفيا#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#اسٽاڪ هوم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ٽالن#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#اراني#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#اليانوسڪ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ازهارڊ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#وڊوز#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#وئٽيڪن#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#وينا#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ويلنيس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#وولگوگراد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#وارسا#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زغرب#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#زيپروزهايا#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زيورخ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#مرڪزي يورپي اونهاري جو وقت#,
				'generic' => q#مرڪزي يورپي وقت#,
				'standard' => q#مرڪزي يورپي معياري وقت#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#مشرقي يورپي اونهاري جو وقت#,
				'generic' => q#مشرقي يورپي وقت#,
				'standard' => q#مشرقي يورپي معياري وقت#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#وڌيڪ مشرقي يورپي وقت#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#مغربي يورپي ڏينهن جو وقت#,
				'generic' => q#مغربي يورپي وقت#,
				'standard' => q#مغربي يورپي معياري وقت#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#فاڪ لينڊ آئي لينڊ جي اونهاري جو وقت#,
				'generic' => q#فاڪ لينڊ آئي لينڊ جو وقت#,
				'standard' => q#فاڪ لينڊ آئي لينڊ جو معياري وقت#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#فجي جي اونهاري جو وقت#,
				'generic' => q#فجي جو وقت#,
				'standard' => q#فجي جو معياري وقت#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#فرانسيسي گيانا جو وقت#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#فرانسيسي ڏاکڻي ۽ انٽارڪٽڪ جو وقت#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#گرين وچ مين ٽائيم#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#گالاپاگوز جو وقت#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#گيمبيئر جو وقت#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#جارجيا جي اونهاري جو وقت#,
				'generic' => q#جارجيا جو وقت#,
				'standard' => q#جارجيا جو معياري وقت#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#گلبرٽ آئي لينڊ جو وقت#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#مشرقي گرين لينڊ جي اونهاري جو وقت#,
				'generic' => q#مشرقي گرين لينڊ جو وقت#,
				'standard' => q#مشرقي گرين لينڊ جو معياري وقت#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#مغربي گرين لينڊ جي اونهاري جو وقت#,
				'generic' => q#مغربي گرين لينڊ جو وقت#,
				'standard' => q#مغربي گرين لينڊ جو معياري وقت#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#خلج معياري وقت#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#گيانائي وقت#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#هوائي اليوٽين جي ڏينهن جو وقت#,
				'generic' => q#هوائي اليوٽين جو وقت#,
				'standard' => q#هوائي اليوٽين جو معياري وقت#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#هانگ ڪانگ جي اونهاري جو وقت#,
				'generic' => q#هانگ ڪانگ جو وقت#,
				'standard' => q#هانگ ڪانگ جو معياري وقت#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#هووڊ جي اونهاري جو وقت#,
				'generic' => q#هووڊ جو وقت#,
				'standard' => q#هووڊ جو معياري وقت#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ڀارت جو معياري وقت#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#انتاناناريوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#چاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ڪرسمس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ڪوڪوس#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ڪومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ڪرگيولين#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماهي#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالديپ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#موريشس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#مياٽي#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ري يونين#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#هند سمنڊ جو وقت#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#انڊو چائنا جو وقت#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#مرڪزي انڊونيشيا جو وقت#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#اوڀر انڊونيشيا جو وقت#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#اولهه انڊونيشيا جو وقت#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ايران جي ڏينهن جو وقت#,
				'generic' => q#ايران جو وقت#,
				'standard' => q#ايران جو معياري وقت#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ارڪتسڪ جي ڏينهن جو وقت#,
				'generic' => q#ارڪتسڪ جو وقت#,
				'standard' => q#ارڪتسڪ جو معياري وقت#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#اسرائيل جي ڏينهن جو وقت#,
				'generic' => q#اسرائيل جو وقت#,
				'standard' => q#اسرائيل جو معياري وقت#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#جاپان جي ڏينهن جو وقت#,
				'generic' => q#جاپان جو وقت#,
				'standard' => q#جاپان جو معياري وقت#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#اوڀر قزاقستان جو وقت#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#اولهه قزاقستان جو وقت#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#ڪوريا جي ڏينهن جو وقت#,
				'generic' => q#ڪوريا جو وقت#,
				'standard' => q#ڪوريا جو معياري وقت#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#ڪوسرائي جو وقت#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#ڪریسنویارسڪ جي ڏينهن جو وقت#,
				'generic' => q#ڪریسنویارسڪ جو وقت#,
				'standard' => q#ڪریسنویارسڪ جو معياري وقت#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#ڪرگزستان جو وقت#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#لائن آئي لينڊ جو وقت#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#لورڊ هووي جي ڏينهن جو وقت#,
				'generic' => q#لورڊ هووي جو وقت#,
				'standard' => q#لورڊ هووي جو معياري وقت#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#مڪوائري آئي لينڊ جو وقت#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#مگادان جي ڏينهن جي وقت#,
				'generic' => q#مگادان جو وقت#,
				'standard' => q#مگادان جو معياري وقت#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#ملائيشيا جو وقت#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#مالديپ جو وقت#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#مرڪيوسس جو وقت#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#مارشل آئي لينڊ جو وقت#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#موريشيس جي اونهاري جو وقت#,
				'generic' => q#موريشيس جو وقت#,
				'standard' => q#موريشيس جو معياري وقت#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#مائوسن جو وقت#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#شمالي مغربي ميڪسيڪو جي ڏينهن جو وقت#,
				'generic' => q#شمالي مغربي ميڪسيڪو جو وقت#,
				'standard' => q#شمالي مغربي ميڪسيڪو جو معياري وقت#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#ميڪسيڪن پيسيفڪ جي ڏينهن جو وقت#,
				'generic' => q#ميڪسيڪن پيسيفڪ وقت#,
				'standard' => q#ميڪسيڪن پيسيفڪ جو معياري وقت#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#اولان باتر جي اونهاري جو وقت#,
				'generic' => q#اولان باتر جو وقت#,
				'standard' => q#اولان باتر جو معياري وقت#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ماسڪو جي ڏينهن جي وقت#,
				'generic' => q#ماسڪو جو وقت#,
				'standard' => q#ماسڪو جو معياري وقت#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#ميانمار جو وقت#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#نائورو جو وقت#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#نيپال جو وقت#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#نيو ڪيليڊونيا جي اونهاري جو وقت#,
				'generic' => q#نيو ڪيليڊونيا جو وقت#,
				'standard' => q#نيو ڪيليڊونيا جو معياري وقت#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#نيوزيلينڊ جي ڏينهن جو وقت#,
				'generic' => q#نيوزيلينڊ جو وقت#,
				'standard' => q#نيوزيلينڊ جو معياري وقت#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#نيو فائونڊ لينڊ جي ڏينهن جو وقت#,
				'generic' => q#نيو فائونڊ لينڊ جو وقت#,
				'standard' => q#نيو فائونڊ لينڊ جو معياري وقت#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#نيووي جو وقت#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#نار فوڪ آئي لينڊ جو وقت#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#فرنانڊو دي نورونها جي اونهاري وقت#,
				'generic' => q#فرنانڊو دي نورونها جو وقت#,
				'standard' => q#فرنانڊو دي نورونها جو معياري وقت#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#نوواسبئيرسڪ جي ڏينهن جو وقت#,
				'generic' => q#نوواسبئيرسڪ جو وقت#,
				'standard' => q#نوواسبئيرسڪ جو معياري وقت#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#اومسڪ جي ڏينهن جو وقت#,
				'generic' => q#اومسڪ جو وقت#,
				'standard' => q#اومسڪ جو معياري وقت#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#اپيا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#آڪلينڊ#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#بوگين ويليا#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چئٿم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ايسٽر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#افاتي#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#اينڊربري#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فڪائوفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فجي#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فنافوٽي#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گالاپاگوز#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گيمبيئر#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گواڊل ڪينال#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گوام#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#هونو لولو#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#جانسٹن#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#ڪريٽمٽي#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#ڪوسرائي#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ڪواجلين#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#مجورو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مرڪيوسس#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#مڊوي#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#نائرو#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نيووي#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نار فوڪ#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نائوميا#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پاگو پاگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پلائو#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پٽڪيرن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پونپیئي#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پورٽ مورسبي#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروٽونگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سيپن#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تاهٽي#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#تراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ٽونگاٽاپو#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#چيوڪ#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ويڪ#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ويلس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#پاڪستان جي اونهاري جو وقت#,
				'generic' => q#پاڪستان جو وقت#,
				'standard' => q#پاڪستان جو معياري وقت#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#پلائو جو وقت#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#پاپوا نيو گني جو وقت#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#پيراگوئي جي اونهاري جو وقت#,
				'generic' => q#پيراگوئي جو وقت#,
				'standard' => q#پيراگوئي جو معياري وقت#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#پيرو جي اونهاري جو وقت#,
				'generic' => q#پيرو جو وقت#,
				'standard' => q#پيرو جو معياري وقت#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#فلپائن جي اونهاري جو وقت#,
				'generic' => q#فلپائن جو وقت#,
				'standard' => q#فلپائن جو معياري وقت#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#فونيڪس آئي لينڊ جو وقت#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#سینٽ پیئر و میڪوئیلون جي ڏينهن جو وقت#,
				'generic' => q#سينٽ پيئر ائن ميڪوئلون جو وقت#,
				'standard' => q#سینٽ پیئر اَئن میڪوئلون جو مانائتو وقت#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#پٽڪيرن جو وقت#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#پوناپي جو وقت#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#شيانگ يانگ جو وقت#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ري يونين جو وقت#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#روٿيرا جو وقت#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#سخالين جي ڏينهن جو وقت#,
				'generic' => q#سخالين جو وقت#,
				'standard' => q#سخالين جو معياري وقت#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ساموا جي ڏينهن جو وقت#,
				'generic' => q#ساموا جو وقت#,
				'standard' => q#ساموا جو معياري وقت#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#شي شلز جو وقت#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#سنگاپور جو معياري وقت#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#سولومن آئي لينڊ جو وقت#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#ڏکڻ جارجيا جو وقت#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#سوري نام جو وقت#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#سائيوا جو وقت#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#تاهيٽي جو وقت#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#تائپي جي ڏينهن جو وقت#,
				'generic' => q#تائپي جو وقت#,
				'standard' => q#تائپي جو معياري وقت#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#تاجڪستان جو وقت#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ٽوڪيلائو جو وقت#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ٽونگا جي اونهاري جو وقت#,
				'generic' => q#ٽونگا جو وقت#,
				'standard' => q#ٽونگا جو معياري وقت#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#چيوڪ جو وقت#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#ترڪمانستان جي اونهاري جو وقت#,
				'generic' => q#ترڪمانستان جو وقت#,
				'standard' => q#ترڪمانستان جو معياري وقت#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#تووالو جو وقت#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#يوروگائي جي اونهاري جو وقت#,
				'generic' => q#يوروگائي جو وقت#,
				'standard' => q#يوروگائي جو معياري وقت#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ازبڪستان جي اونهاري جو وقت#,
				'generic' => q#ازبڪستان جو وقت#,
				'standard' => q#ازبڪستان جو معياري وقت#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#وانواتو جي ڏينهن جو وقت#,
				'generic' => q#وانواتو جو وقت#,
				'standard' => q#وانواتو جو معياري وقت#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#وينزويلا جو وقت#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#اولادووستوڪ جي ڏينهن جو وقت#,
				'generic' => q#ولادووستوڪ جو وقت#,
				'standard' => q#ولادووستوڪ جو معياري وقت#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#وولگوگراد جي ڏينهن جو وقت#,
				'generic' => q#وولگوگراد جو وقت#,
				'standard' => q#وولگوگراد جو معياري وقت#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ووسٽوڪ جو وقت#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ويڪ آئي لينڊ جو وقت#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ويلس ۽ فتونا جو وقت#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ياڪتسڪ جي ڏينهن جو وقت#,
				'generic' => q#ياڪتسڪ جو وقت#,
				'standard' => q#ياڪتسڪ جو معياري وقت#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#يڪاٽيرنبرگ جي ڏينهن جو وقت#,
				'generic' => q#يڪاٽيرنبرگ جو وقت#,
				'standard' => q#يڪاٽيرنبرگ جو معياري وقت#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
