# This Makefile.PL for Mac-FSEvents was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008008;
use ExtUtils::MakeMaker;

use strict;
use warnings;

use ExtUtils::Constant ();
use Config ();

if ($^O ne 'darwin') {
    die "OS unsupported\n";
}

my @c_name = qw(
    kFSEventStreamCreateFlagNone
    kFSEventStreamCreateFlagWatchRoot
    kFSEventStreamCreateFlagIgnoreSelf
    kFSEventStreamCreateFlagFileEvents
);

my @name;
for my $c_name (@c_name) {
    my $perl_name = $c_name;
    $perl_name =~ s/kFSEventStreamCreateFlag//; # strip off leading name
    $perl_name =~ s/([a-z])([A-Z])/"$1_$2"/ge;  # convert camel case to underscores
    $perl_name = uc $perl_name;                 # uppercase
    push @name, {
        name  => $perl_name,
        value => $c_name,
        macro => 1,
    };
}

ExtUtils::Constant::WriteConstants(
    NAME => 'Mac::FSEvents',
    NAMES => \@name,
);

my $lddlflags = join " ", grep { length $_ } (
    $Config::Config{lddlflags},
    "-framework CoreServices",
    "-framework CoreFoundation",
);

my %args = (
    LDDLFLAGS => $lddlflags,
);

my %WriteMakefileArgs = (
  "ABSTRACT" => "Monitor a directory structure for changes",
  "AUTHOR" => "Andy Grundman <andy\@hybridized.org>, Rob Hoelz <rob\@hoelz.ro>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Mac-FSEvents",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008008",
  "NAME" => "Mac::FSEvents",
  "PREREQ_PM" => {},
  "TEST_REQUIRES" => {
    "Test::More" => "0.99"
  },
  "VERSION" => "0.21",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %args,
);

my %FallbackPrereqs = (
  "Test::More" => "0.99"
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
