
package Paws::SageMaker::CreateTrial;
  use Moose;
  has DisplayName => (is => 'ro', isa => 'Str');
  has ExperimentName => (is => 'ro', isa => 'Str', required => 1);
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::Tag]');
  has TrialName => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'CreateTrial');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::SageMaker::CreateTrialResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::CreateTrial - Arguments for method CreateTrial on L<Paws::SageMaker>

=head1 DESCRIPTION

This class represents the parameters used for calling the method CreateTrial on the
L<Amazon SageMaker Service|Paws::SageMaker> service. Use the attributes of this class
as arguments to method CreateTrial.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to CreateTrial.

=head1 SYNOPSIS

    my $api.sagemaker = Paws->service('SageMaker');
    my $CreateTrialResponse = $api . sagemaker->CreateTrial(
      ExperimentName => 'MyExperimentEntityName',
      TrialName      => 'MyExperimentEntityName',
      DisplayName    => 'MyExperimentEntityName',    # OPTIONAL
      Tags           => [
        {
          Key   => 'MyTagKey',      # min: 1, max: 128
          Value => 'MyTagValue',    # max: 256

        },
        ...
      ],    # OPTIONAL
    );

    # Results:
    my $TrialArn = $CreateTrialResponse->TrialArn;

    # Returns a L<Paws::SageMaker::CreateTrialResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/api.sagemaker/CreateTrial>

=head1 ATTRIBUTES


=head2 DisplayName => Str

The name of the trial as displayed. The name doesn't need to be unique.
If C<DisplayName> isn't specified, C<TrialName> is displayed.



=head2 B<REQUIRED> ExperimentName => Str

The name of the experiment to associate the trial with.



=head2 Tags => ArrayRef[L<Paws::SageMaker::Tag>]

A list of tags to associate with the trial. You can use Search API to
search on the tags.



=head2 B<REQUIRED> TrialName => Str

The name of the trial. The name must be unique in your AWS account and
is not case-sensitive.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method CreateTrial in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

