package PDK::Firewall::Element::Interface::Neteye;

#------------------------------------------------------------------------------
# 加载扩展模块
#------------------------------------------------------------------------------
use Moose;
use namespace::autoclean;

#------------------------------------------------------------------------------
# 引用 PDK::Firewall::Element::Interface::Role 角色
#------------------------------------------------------------------------------
with 'PDK::Firewall::Element::Interface::Role';

#------------------------------------------------------------------------------
# PDK::Firewall::Element::Interface::Neteye 通用属性
#------------------------------------------------------------------------------
has accessVlan => (is => 'rw', isa => 'ArrayRef', default => sub { [] },);

#------------------------------------------------------------------------------
# 新增接口 vlan 方法
#------------------------------------------------------------------------------
sub addVlan {
  my ($self, $vlanInt) = @_;

  # 添加接口对象名称
  push @{$self->accessVlan}, $vlanInt->name;
  $self->range->mergeToSet($vlanInt->range);
}

__PACKAGE__->meta->make_immutable;
1;
