package PDK::Firewall::Element::Role;

# ABSTRACT: PDK::Firewall::Element::Role;
#------------------------------------------------------------------------------
# 加载扩展模块
#------------------------------------------------------------------------------
use Moose::Role;
use namespace::autoclean;
use utf8;

our $VERSION = '0.010';

#------------------------------------------------------------------------------
# 定义防火墙配置解析对象通用方法和属性
#------------------------------------------------------------------------------
has fwId => (is => 'ro', isa => 'Int', required => 0,);

#------------------------------------------------------------------------------
# sign 属性签名算法 | 懒加载，确实需要时加载
#------------------------------------------------------------------------------
has sign => (is => 'ro', isa => 'Str', lazy => 1, builder => '_buildSign',);

#------------------------------------------------------------------------------
# config 属性的具体配置
#------------------------------------------------------------------------------
has config => (
  is       => 'ro',
  isa      => 'Str',
  required => 0,
  traits   => ['String'],

  # 代理 String 方法为对象方法
  handles => {addConfig => 'append', insertConfig => 'prepend'}
);

#------------------------------------------------------------------------------
# 继承 PDK::Firewall::Element::Role 必须实现 _buildSign 方法
#------------------------------------------------------------------------------
requires '_buildSign';

#------------------------------------------------------------------------------
# 生成sign的辅助函数，用来统一记录连接符，这样修改的时候会很简单
#------------------------------------------------------------------------------
sub createSign {
  my $self = shift;

  # 边界条件判断
  # confess "ERROR: 用于生成 sign 的参数成员不能是 undefined" if grep { not defined } @_;
  return join('<|>', @_);
}

#------------------------------------------------------------------------------
# 设定 addConfig 钩子函数
#------------------------------------------------------------------------------
around 'addConfig' => sub {
  my $orig = shift;
  my $self = shift;
  if (@_ == 1) {
    chomp $_[0];
    $_[0] .= "\n";
  }
  $self->$orig(@_);
};

1;
