#!/usr/bin/perl
use strict;
use warnings;

use Module::Build;

my %sbin_files = map { $_ => $_ } qw(sbin/lcfgdiff);

my $build = Module::Build->new(
    module_name   => 'LCFG::Utils',
    dist_abstract => 'Perl API for LCFG utilities',
    dist_author   => 'Stephen Quinney <squinney@inf.ed.ac.uk>',
    dist_version  => '1.13.4',
    license => 'gpl',
    requires => {
        'perl'      => '5.16.0',
         'HTML::Entities' => 0,
        'Template'  => 0,
         'Digest::SHA' => 0,
    },
    build_requires => {
        'Test::More'           => 0,
        'Test::File::Contents' => 0,
    },
    configure_requires => {
        'Module::Build' => '0.40',
    },
    add_to_cleanup => [ 'MANIFEST.bak', 'Changes.bak' ],
    create_makefile_pl => 'traditional',
    sbin_files => \%sbin_files,
    install_path => { sbin => '/usr/sbin' },
);
$build->add_build_element('sbin');
$build->create_build_script;
