package Graphics::ColorNamesLite::EN;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-11-30'; # DATE
our $DIST = 'Graphics-ColorNamesLite-EN'; # DIST
our $VERSION = '0.002'; # VERSION

# note: SVG=CSS, WWW=CSS. GrayScale returns coderef. Pantone are numbers.
our $NAMES_RGB_TABLE = {
  "aab"                     => "0066ff",
  "aac"                     => "0099ff",
  "airyblue"                => "92b6d5",
  "aliceblue"               => "f0f8ff",
  "almondbuff"              => "d1b894",
  "almostmauve"             => "eadedb",
  "amazon"                  => "1c734b",
  "amberglow"               => "dc793e",
  "amethystorchid"          => "926aa6",
  "antiquewhite"            => "faebd7",
  "antiquewhite1"           => "ffefdb",
  "antiquewhite2"           => "eedfcc",
  "antiquewhite3"           => "cdc0b0",
  "antiquewhite4"           => "8b8378",
  "applegreen"              => "adba98",
  "apricot"                 => "f7ca83",
  "aqua"                    => "00ffff",
  "aquamarine"              => "7fffd4",
  "aquamarine1"             => "7fffd4",
  "aquamarine2"             => "76eec6",
  "aquamarine3"             => "66cdaa",
  "aquamarine4"             => "458b74",
  "aquasky"                 => "7fcdcd",
  "arcadia"                 => "00a591",
  "arcticwolf"              => "e6decf",
  "arterialbloodred"        => 711518,
  "ash"                     => "a09998",
  "ashgrey"                 => "cbc8b7",
  "asparagusgreen"          => "c2c190",
  "aspengold"               => "ffd662",
  "auriculapurple"          => 533552,
  "aurorared"               => "b93a32",
  "autumnblonde"            => "f2d6b3",
  "autumnmaple"             => "d2691e",
  "azure"                   => "f0ffff",
  "azure-azure-blue"        => "0066ff",
  "azure-azure-cyan"        => "0099ff",
  "azure1"                  => "f0ffff",
  "azure2"                  => "e0eeee",
  "azure3"                  => "c1cdcd",
  "azure4"                  => "838b8b",
  "azureazureblue"          => "0066ff",
  "azureazurecyan"          => "0099ff",
  "azureblue"               => "5c6b8f",
  "b"                       => "0000ff",
  "bakerschocolate"         => "5c3317",
  "balletslipper"           => "f3d6e4",
  "basil"                   => "829f82",
  "bba"                     => "0033ff",
  "bbv"                     => "3300ff",
  "beige"                   => "f5f5dc",
  "berlinblue"              => "7994b5",
  "bikingred"               => "77212e",
  "biscaygreen"             => "56c6a9",
  "bisque"                  => "ffe4c4",
  "bisque1"                 => "ffe4c4",
  "bisque2"                 => "eed5b7",
  "bisque3"                 => "cdb79e",
  "bisque4"                 => "8b7d6b",
  "black"                   => "000000",
  "blackishbrown"           => "453b32",
  "blackishgreen"           => "5d6161",
  "blackishgrey"            => "5b5c61",
  "blanchedalmond"          => "ffebcd",
  "bloomingdahlia"          => "ec9787",
  "blue"                    => "0000ff",
  "blue-blue-azure"         => "0033ff",
  "blue-blue-violet"        => "3300ff",
  "blue1"                   => "0000ff",
  "blue2"                   => "0000ee",
  "blue3"                   => "0000cd",
  "blue4"                   => "00008b",
  "blueblueazure"           => "0033ff",
  "blueblueviolet"          => "3300ff",
  "bluegreen"               => "0083ae",
  "bluegrey"                => "b2bbc0",
  "blueizis"                => "5b5ea6",
  "bluestone"               => 577284,
  "blueturquoise"           => "55b4b0",
  "blueviolet"              => "8a2be2",
  "bluishblack"             => "413f44",
  "bluishgreen"             => "a4b6a7",
  "bluishgrey"              => "9c9d9a",
  "bluishlilacpurple"       => "d0d5d3",
  "bluishpurple"            => "8590ae",
  "bodacious"               => "b76ba3",
  "brass"                   => "b5a642",
  "brightgold"              => "d9d919",
  "brilliantwhite"          => "edf1ff",
  "broccolibrown"           => "9b856b",
  "bronze"                  => "8c7853",
  "bronzeii"                => "a67d3d",
  "brown"                   => "a52a2a",
  "brown1"                  => "ff4040",
  "brown2"                  => "ee3b3b",
  "brown3"                  => "cd3333",
  "brown4"                  => "8b2323",
  "browngranite"            => 615550,
  "brownishorange"          => "92462f",
  "brownishpurplered"       => "8d746f",
  "brownishred"             => "6e3b31",
  "bufforange"              => "ebbc71",
  "burlywood"               => "deb887",
  "burlywood1"              => "ffd39b",
  "burlywood2"              => "eec591",
  "burlywood3"              => "cdaa7d",
  "burlywood4"              => "8b7355",
  "burntcoral"              => "e9897e",
  "burntsienna"             => "bd6638",
  "buttercream"             => "efe1ce",
  "buttercup"               => "fae03c",
  "butterum"                => "c48f65",
  "c"                       => "00ffff",
  "cadetblue"               => "5f9ea0",
  "cadetblue1"              => "98f5ff",
  "cadetblue2"              => "8ee5ee",
  "cadetblue3"              => "7ac5cd",
  "cadetblue4"              => "53868b",
  "campanulapurple"         => "6c6d94",
  "caramelcafe"             => "8b5a3e",
  "carminered"              => "ce536b",
  "carnationpink"           => "fa7fc1",
  "cca"                     => "00ccff",
  "cct"                     => "00ffcc",
  "celadinegreen"           => "b8bfaf",
  "cerulean"                => "9bb7d4",
  "ceruleanblue"            => "98b4d4",
  "cerulian"                => "0071cd",
  "ceylonyellow"            => "d5ae41",
  "chartreuse"              => "7fff00",
  "chartreuse1"             => "7fff00",
  "chartreuse2"             => "76ee00",
  "chartreuse3"             => "66cd00",
  "chartreuse4"             => "458b00",
  "cherrytomato"            => "e94b3c",
  "chestnut"                => 954535,
  "chestnutbrown"           => "7a4b3a",
  "chilioil"                => 944743,
  "chilipepper"             => "9b2335",
  "chinablue"               => 383867,
  "chiseledstone"           => "8f8f93",
  "chive"                   => "4b5335",
  "chocolate"               => "d2691e",
  "chocolate1"              => "ff7f24",
  "chocolate2"              => "ee7621",
  "chocolate3"              => "cd661d",
  "chocolate4"              => "8b4513",
  "chocolatered"            => "4d3635",
  "cinnamonstic"            => "9c4722",
  "classicblue"             => "34568b",
  "clovebrown"              => 766051,
  "cobalt"                  => "3d414c",
  "cocamocha"               => "8c725f",
  "cochinealred"            => "7a4848",
  "coconutmilk"             => "f0ede5",
  "coolcopper"              => "d98719",
  "copper"                  => "b87333",
  "coral"                   => "ff7f50",
  "coral1"                  => "ff7256",
  "coral2"                  => "ee6a50",
  "coral3"                  => "cd5b45",
  "coral4"                  => "8b3e2f",
  "coralpink"               => "e8a798",
  "cornflower"              => "6590d8",
  "cornflowerblue"          => "6495ed",
  "cornsilk"                => "fff8dc",
  "cornsilk1"               => "fff8dc",
  "cornsilk2"               => "eee8cd",
  "cornsilk3"               => "cdc8b1",
  "cornsilk4"               => "8b8878",
  "creamyellow"             => "f3daa7",
  "cremedepeche"            => "f5d6c6",
  "crimson"                 => "dc143c",
  "crimsonred"              => "b7757c",
  "crocuspetal"             => "be9ec9",
  "cyan"                    => "00ffff",
  "cyan-cyan-azure"         => "00ccff",
  "cyan-cyan-teal"          => "00ffcc",
  "cyan1"                   => "00ffff",
  "cyan2"                   => "00eeee",
  "cyan3"                   => "00cdcd",
  "cyan4"                   => "008b8b",
  "cyancyanazure"           => "00ccff",
  "cyancyanteal"            => "00ffcc",
  "dab"                     => "003399",
  "dac"                     => "006699",
  "daffodil"                => "fdc04e",
  "dahliamauve"             => "a64f82",
  "dandelion"               => "edd80b",
  "dark azure-blue"         => "003399",
  "dark azure-cyan"         => "006699",
  "dark blue-azure"         => "0033cc",
  "dark blue-violet"        => "3300cc",
  "dark cyan-azure"         => "0099cc",
  "dark cyan-teal"          => "00cc99",
  "dark dull azure"         => 336699,
  "dark dull blue"          => 333399,
  "dark dull cyan"          => 339999,
  "dark dull green"         => 339933,
  "dark dull magenta"       => 993399,
  "dark dull orange"        => 996633,
  "dark dull pink"          => 993366,
  "dark dull red"           => 993333,
  "dark dull spring"        => 669933,
  "dark dull teal"          => 339966,
  "dark dull violet"        => 663399,
  "dark dull yellow"        => 999933,
  "dark faded blue"         => "000099",
  "dark faded cyan"         => "009999",
  "dark faded green"        => "009900",
  "dark faded magenta"      => 990099,
  "dark faded red"          => 990000,
  "dark faded yellow"       => 999900,
  "dark gray"               => 666666,
  "dark green-spring"       => "33cc00",
  "dark green-teal"         => "00cc33",
  "dark hard azure"         => "0066cc",
  "dark hard blue"          => "0000cc",
  "dark hard cyan"          => "00cccc",
  "dark hard green"         => "00cc00",
  "dark hard magenta"       => "cc00cc",
  "dark hard orange"        => "cc6600",
  "dark hard pink"          => "cc0066",
  "dark hard red"           => "cc0000",
  "dark hard spring"        => "66cc00",
  "dark hard teal"          => "00cc66",
  "dark hard violet"        => "6600cc",
  "dark hard yellow"        => "cccc00",
  "dark magenta-pink"       => "cc0099",
  "dark magenta-violet"     => "9900cc",
  "dark orange-red"         => 993300,
  "dark orange-yellow"      => 996600,
  "dark pink-magenta"       => 990066,
  "dark pink-red"           => 990033,
  "dark red-orange"         => "cc3300",
  "dark red-pink"           => "cc0033",
  "dark spring-green"       => 339900,
  "dark spring-yellow"      => 669900,
  "dark teal-cyan"          => "009966",
  "dark teal-green"         => "009933",
  "dark violet-blue"        => 330099,
  "dark violet-magenta"     => 660099,
  "dark weak blue"          => 333366,
  "dark weak cyan"          => 336666,
  "dark weak green"         => 336633,
  "dark weak magenta"       => 663366,
  "dark weak red"           => 663333,
  "dark weak yellow"        => 666633,
  "dark yellow-orange"      => "cc9900",
  "dark yellow-spring"      => "99cc00",
  "darkazure-blue"          => "003399",
  "darkazure-cyan"          => "006699",
  "darkazureblue"           => "003399",
  "darkazurecyan"           => "006699",
  "darkblue"                => "00008b",
  "darkblue-azure"          => "0033cc",
  "darkblue-violet"         => "3300cc",
  "darkblueazure"           => "0033cc",
  "darkblueviolet"          => "3300cc",
  "darkbrown"               => "5c4033",
  "darkcheddar"             => "e08119",
  "darkcyan"                => "008b8b",
  "darkcyan-azure"          => "0099cc",
  "darkcyan-teal"           => "00cc99",
  "darkcyanazure"           => "0099cc",
  "darkcyanteal"            => "00cc99",
  "darkdullazure"           => 336699,
  "darkdullblue"            => 333399,
  "darkdullcyan"            => 339999,
  "darkdullgreen"           => 339933,
  "darkdullmagenta"         => 993399,
  "darkdullorange"          => 996633,
  "darkdullpink"            => 993366,
  "darkdullred"             => 993333,
  "darkdullspring"          => 669933,
  "darkdullteal"            => 339966,
  "darkdullviolet"          => 663399,
  "darkdullyellow"          => 999933,
  "darkfadedblue"           => "000099",
  "darkfadedcyan"           => "009999",
  "darkfadedgreen"          => "009900",
  "darkfadedmagenta"        => 990099,
  "darkfadedred"            => 990000,
  "darkfadedyellow"         => 999900,
  "darkgoldenrod"           => "b8860b",
  "darkgoldenrod1"          => "ffb90f",
  "darkgoldenrod2"          => "eead0e",
  "darkgoldenrod3"          => "cd950c",
  "darkgoldenrod4"          => "8b6508",
  "darkgray"                => "a9a9a9",
  "darkgreen"               => "006400",
  "darkgreen-spring"        => "33cc00",
  "darkgreen-teal"          => "00cc33",
  "darkgreencopper"         => "4a766e",
  "darkgreenspring"         => "33cc00",
  "darkgreenteal"           => "00cc33",
  "darkgrey"                => "a9a9a9",
  "darkhardazure"           => "0066cc",
  "darkhardblue"            => "0000cc",
  "darkhardcyan"            => "00cccc",
  "darkhardgreen"           => "00cc00",
  "darkhardmagenta"         => "cc00cc",
  "darkhardorange"          => "cc6600",
  "darkhardpink"            => "cc0066",
  "darkhardred"             => "cc0000",
  "darkhardspring"          => "66cc00",
  "darkhardteal"            => "00cc66",
  "darkhardviolet"          => "6600cc",
  "darkhardyellow"          => "cccc00",
  "darkkhaki"               => "bdb76b",
  "darkmagenta"             => "8b008b",
  "darkmagenta-pink"        => "cc0099",
  "darkmagenta-violet"      => "9900cc",
  "darkmagentapink"         => "cc0099",
  "darkmagentaviolet"       => "9900cc",
  "darkolivegreen"          => "556b2f",
  "darkolivegreen1"         => "caff70",
  "darkolivegreen2"         => "bcee68",
  "darkolivegreen3"         => "a2cd5a",
  "darkolivegreen4"         => "6e8b3d",
  "darkorange"              => "ff8c00",
  "darkorange-red"          => 993300,
  "darkorange-yellow"       => 996600,
  "darkorange1"             => "ff7f00",
  "darkorange2"             => "ee7600",
  "darkorange3"             => "cd6600",
  "darkorange4"             => "8b4500",
  "darkorangered"           => 993300,
  "darkorangeyellow"        => 996600,
  "darkorchid"              => "9932cc",
  "darkorchid1"             => "bf3eff",
  "darkorchid2"             => "b23aee",
  "darkorchid3"             => "9a32cd",
  "darkorchid4"             => "68228b",
  "darkpink-magenta"        => 990066,
  "darkpink-red"            => 990033,
  "darkpinkmagenta"         => 990066,
  "darkpinkred"             => 990033,
  "darkpurple"              => "871f78",
  "darkred"                 => "8b0000",
  "darkred-orange"          => "cc3300",
  "darkred-pink"            => "cc0033",
  "darkredorange"           => "cc3300",
  "darkredpink"             => "cc0033",
  "darksalmon"              => "e9967a",
  "darkseagreen"            => "8fbc8f",
  "darkseagreen1"           => "c1ffc1",
  "darkseagreen2"           => "b4eeb4",
  "darkseagreen3"           => "9bcd9b",
  "darkseagreen4"           => "698b69",
  "darkslateblue"           => "483d8b",
  "darkslategray"           => "2f4f4f",
  "darkslategray1"          => "97ffff",
  "darkslategray2"          => "8deeee",
  "darkslategray3"          => "79cdcd",
  "darkslategray4"          => "528b8b",
  "darkslategrey"           => "2f4f4f",
  "darkspring-green"        => 339900,
  "darkspring-yellow"       => 669900,
  "darkspringgreen"         => 339900,
  "darkspringyellow"        => 669900,
  "darktan"                 => "97694f",
  "darkteal-cyan"           => "009966",
  "darkteal-green"          => "009933",
  "darktealcyan"            => "009966",
  "darktealgreen"           => "009933",
  "darkturquoise"           => "00ced1",
  "darkviolet"              => "9400d3",
  "darkviolet-blue"         => 330099,
  "darkviolet-magenta"      => 660099,
  "darkvioletblue"          => 330099,
  "darkvioletmagenta"       => 660099,
  "darkweakblue"            => 333366,
  "darkweakcyan"            => 336666,
  "darkweakgreen"           => 336633,
  "darkweakmagenta"         => 663366,
  "darkweakred"             => 663333,
  "darkweakyellow"          => 666633,
  "darkwood"                => "855e42",
  "darkyellow"              => 808000,
  "darkyellow-orange"       => "cc9900",
  "darkyellow-spring"       => "99cc00",
  "darkyelloworange"        => "cc9900",
  "darkyellowspring"        => "99cc00",
  "dba"                     => "0033cc",
  "dbv"                     => "3300cc",
  "dca"                     => "0099cc",
  "dct"                     => "00cc99",
  "dda"                     => 336699,
  "ddb"                     => 333399,
  "ddc"                     => 339999,
  "ddg"                     => 339933,
  "ddm"                     => 993399,
  "ddo"                     => 996633,
  "ddp"                     => 993366,
  "ddr"                     => 993333,
  "dds"                     => 669933,
  "ddt"                     => 339966,
  "ddv"                     => 663399,
  "ddy"                     => 999933,
  "deeporangecolouredbrown" => 864735,
  "deeppink"                => "ff1493",
  "deeppink1"               => "ff1493",
  "deeppink2"               => "ee1289",
  "deeppink3"               => "cd1076",
  "deeppink4"               => "8b0a50",
  "deepreddishbrown"        => "553d3a",
  "deepreddishorange"       => "bb603c",
  "deepskyblue"             => "00bfff",
  "deepskyblue1"            => "00bfff",
  "deepskyblue2"            => "00b2ee",
  "deepskyblue3"            => "009acd",
  "deepskyblue4"            => "00688b",
  "desertmist"              => "e0b589",
  "dfb"                     => "000099",
  "dfc"                     => "009999",
  "dfg"                     => "009900",
  "dfm"                     => 990099,
  "dfr"                     => 990000,
  "dfy"                     => 999900,
  "dg"                      => 666666,
  "dgs"                     => "33cc00",
  "dgt"                     => "00cc33",
  "dha"                     => "0066cc",
  "dhb"                     => "0000cc",
  "dhc"                     => "00cccc",
  "dhg"                     => "00cc00",
  "dhm"                     => "cc00cc",
  "dho"                     => "cc6600",
  "dhp"                     => "cc0066",
  "dhr"                     => "cc0000",
  "dhs"                     => "66cc00",
  "dht"                     => "00cc66",
  "dhv"                     => "6600cc",
  "dhy"                     => "cccc00",
  "dimgray"                 => 696969,
  "dimgrey"                 => 696969,
  "dmp"                     => "cc0099",
  "dmv"                     => "9900cc",
  "dodgerblue"              => "1e90ff",
  "dodgerblue1"             => "1e90ff",
  "dodgerblue2"             => "1c86ee",
  "dodgerblue3"             => "1874cd",
  "dodgerblue4"             => "104e8b",
  "dor"                     => 993300,
  "doy"                     => 996600,
  "dpm"                     => 990066,
  "dpr"                     => 990033,
  "dro"                     => "cc3300",
  "drp"                     => "cc0033",
  "dsg"                     => 339900,
  "dsy"                     => 669900,
  "dtc"                     => "009966",
  "dtg"                     => "009933",
  "duckgreen"               => "33431e",
  "dustycedar"              => "ad5d5d",
  "dustyrose"               => 856363,
  "dutchorange"             => "dfa837",
  "dvb"                     => 330099,
  "dvm"                     => 660099,
  "dwb"                     => 333366,
  "dwc"                     => 336666,
  "dwg"                     => 336633,
  "dwm"                     => 663366,
  "dwr"                     => 663333,
  "dwy"                     => 666633,
  "dyo"                     => "cc9900",
  "dys"                     => "99cc00",
  "eclipse"                 => 343148,
  "eden"                    => "264e36",
  "emerald"                 => "009b77",
  "emeraldgreen"            => "93b778",
  "emperador"               => "6c4f3d",
  "eveningblue"             => "2a293e",
  "fadeddenim"              => "798ea4",
  "feldspar"                => "d19275",
  "fiesta"                  => "dd4132",
  "firebrick"               => "b22222",
  "firebrick1"              => "ff3030",
  "firebrick2"              => "ee2c2c",
  "firebrick3"              => "cd2626",
  "firebrick4"              => "8b1a1a",
  "firedbrick"              => "6a2e2a",
  "flame"                   => "f2552c",
  "flamescarlet"            => "cd212a",
  "flaxflowerblue"          => "6f88af",
  "flesh"                   => "f5ccb0",
  "fleshred"                => "e9c49d",
  "floralwhite"             => "fffaf0",
  "forestgreen"             => "228b22",
  "frenchblue"              => "0072b5",
  "frenchgrey"              => "bebeb3",
  "fruitdove"               => "ce5b78",
  "fuchsia"                 => "ff00ff",
  "fuchsiarose"             => "c3447a",
  "fuscia"                  => "ff00ff",
  "g"                       => "00ff00",
  "gainsboro"               => "dcdcdc",
  "galaxyblue"              => "2a4b7c",
  "gallstoneyellow"         => "a36629",
  "gambogeyellow"           => "e6d058",
  "ggs"                     => "33ff00",
  "ggt"                     => "00ff33",
  "ghostwhite"              => "f8f8ff",
  "glacierlake"             => "84a2bb",
  "gold"                    => "ffd700",
  "gold1"                   => "ffd700",
  "gold2"                   => "eec900",
  "gold3"                   => "cdad00",
  "gold4"                   => "8b7500",
  "goldenlime"              => "9c9a40",
  "goldenrod"               => "daa520",
  "goldenrod1"              => "ffc125",
  "goldenrod2"              => "eeb422",
  "goldenrod3"              => "cd9b1d",
  "goldenrod4"              => "8b6914",
  "gossamerpink"            => "f9c5c2",
  "grannysmithapple"        => "5cbf64",
  "grapecompote"            => "6b5876",
  "grassgreen"              => "7d8c55",
  "gray"                    => 808080,
  "gray0"                   => "000000",
  "gray1"                   => "030303",
  "gray10"                  => "1a1a1a",
  "gray100"                 => "ffffff",
  "gray11"                  => "1c1c1c",
  "gray12"                  => "1f1f1f",
  "gray13"                  => 212121,
  "gray14"                  => 242424,
  "gray15"                  => 262626,
  "gray16"                  => 292929,
  "gray17"                  => "2b2b2b",
  "gray18"                  => "2e2e2e",
  "gray19"                  => 303030,
  "gray2"                   => "050505",
  "gray20"                  => 333333,
  "gray21"                  => 363636,
  "gray22"                  => 383838,
  "gray23"                  => "3b3b3b",
  "gray24"                  => "3d3d3d",
  "gray25"                  => 404040,
  "gray26"                  => 424242,
  "gray27"                  => 454545,
  "gray28"                  => 474747,
  "gray29"                  => "4a4a4a",
  "gray3"                   => "080808",
  "gray30"                  => "4d4d4d",
  "gray31"                  => "4f4f4f",
  "gray32"                  => 525252,
  "gray33"                  => 545454,
  "gray34"                  => 575757,
  "gray35"                  => 595959,
  "gray36"                  => "5c5c5c",
  "gray37"                  => "5e5e5e",
  "gray38"                  => 616161,
  "gray39"                  => 636363,
  "gray4"                   => "0a0a0a",
  "gray40"                  => 666666,
  "gray41"                  => 696969,
  "gray42"                  => "6b6b6b",
  "gray43"                  => "6e6e6e",
  "gray44"                  => 707070,
  "gray45"                  => 737373,
  "gray46"                  => 757575,
  "gray47"                  => 787878,
  "gray48"                  => "7a7a7a",
  "gray49"                  => "7d7d7d",
  "gray5"                   => "0d0d0d",
  "gray50"                  => "7f7f7f",
  "gray51"                  => 828282,
  "gray52"                  => 858585,
  "gray53"                  => 878787,
  "gray54"                  => "8a8a8a",
  "gray55"                  => "8c8c8c",
  "gray56"                  => "8f8f8f",
  "gray57"                  => 919191,
  "gray58"                  => 949494,
  "gray59"                  => 969696,
  "gray6"                   => "0f0f0f",
  "gray60"                  => 999999,
  "gray61"                  => "9c9c9c",
  "gray62"                  => "9e9e9e",
  "gray63"                  => "a1a1a1",
  "gray64"                  => "a3a3a3",
  "gray65"                  => "a6a6a6",
  "gray66"                  => "a8a8a8",
  "gray67"                  => "ababab",
  "gray68"                  => "adadad",
  "gray69"                  => "b0b0b0",
  "gray7"                   => 121212,
  "gray70"                  => "b3b3b3",
  "gray71"                  => "b5b5b5",
  "gray72"                  => "b8b8b8",
  "gray73"                  => "bababa",
  "gray74"                  => "bdbdbd",
  "gray75"                  => "bfbfbf",
  "gray76"                  => "c2c2c2",
  "gray77"                  => "c4c4c4",
  "gray78"                  => "c7c7c7",
  "gray79"                  => "c9c9c9",
  "gray8"                   => 141414,
  "gray80"                  => "cccccc",
  "gray81"                  => "cfcfcf",
  "gray82"                  => "d1d1d1",
  "gray83"                  => "d4d4d4",
  "gray84"                  => "d6d6d6",
  "gray85"                  => "d9d9d9",
  "gray86"                  => "dbdbdb",
  "gray87"                  => "dedede",
  "gray88"                  => "e0e0e0",
  "gray89"                  => "e3e3e3",
  "gray9"                   => 171717,
  "gray90"                  => "e5e5e5",
  "gray91"                  => "e8e8e8",
  "gray92"                  => "ebebeb",
  "gray93"                  => "ededed",
  "gray94"                  => "f0f0f0",
  "gray95"                  => "f2f2f2",
  "gray96"                  => "f5f5f5",
  "gray97"                  => "f7f7f7",
  "gray98"                  => "fafafa",
  "gray99"                  => "fcfcfc",
  "green"                   => "008000",
  "green-green-spring"      => "33ff00",
  "green-green-teal"        => "00ff33",
  "green1"                  => "00ff00",
  "green2"                  => "00ee00",
  "green3"                  => "00cd00",
  "green4"                  => "008b00",
  "greenash"                => "a0daa9",
  "greencopper"             => 856363,
  "greenflash"              => "79c753",
  "greengreenspring"        => "33ff00",
  "greengreenteal"          => "00ff33",
  "greenishblack"           => 454445,
  "greenishblue"            => "719ba2",
  "greenishgrey"            => "8a8d84",
  "greenishwhite"           => "f2ebcd",
  "greensheen"              => "d9ce52",
  "greenyellow"             => "adff2f",
  "grenadine"               => "dc4c46",
  "grey"                    => 808080,
  "grey0"                   => "000000",
  "grey1"                   => "030303",
  "grey10"                  => "1a1a1a",
  "grey100"                 => "ffffff",
  "grey11"                  => "1c1c1c",
  "grey12"                  => "1f1f1f",
  "grey13"                  => 212121,
  "grey14"                  => 242424,
  "grey15"                  => 262626,
  "grey16"                  => 292929,
  "grey17"                  => "2b2b2b",
  "grey18"                  => "2e2e2e",
  "grey19"                  => 303030,
  "grey2"                   => "050505",
  "grey20"                  => 333333,
  "grey21"                  => 363636,
  "grey22"                  => 383838,
  "grey23"                  => "3b3b3b",
  "grey24"                  => "3d3d3d",
  "grey25"                  => 404040,
  "grey26"                  => 424242,
  "grey27"                  => 454545,
  "grey28"                  => 474747,
  "grey29"                  => "4a4a4a",
  "grey3"                   => "080808",
  "grey30"                  => "4d4d4d",
  "grey31"                  => "4f4f4f",
  "grey32"                  => 525252,
  "grey33"                  => 545454,
  "grey34"                  => 575757,
  "grey35"                  => 595959,
  "grey36"                  => "5c5c5c",
  "grey37"                  => "5e5e5e",
  "grey38"                  => 616161,
  "grey39"                  => 636363,
  "grey4"                   => "0a0a0a",
  "grey40"                  => 666666,
  "grey41"                  => 696969,
  "grey42"                  => "6b6b6b",
  "grey43"                  => "6e6e6e",
  "grey44"                  => 707070,
  "grey45"                  => 737373,
  "grey46"                  => 757575,
  "grey47"                  => 787878,
  "grey48"                  => "7a7a7a",
  "grey49"                  => "7d7d7d",
  "grey5"                   => "0d0d0d",
  "grey50"                  => "7f7f7f",
  "grey51"                  => 828282,
  "grey52"                  => 858585,
  "grey53"                  => 878787,
  "grey54"                  => "8a8a8a",
  "grey55"                  => "8c8c8c",
  "grey56"                  => "8f8f8f",
  "grey57"                  => 919191,
  "grey58"                  => 949494,
  "grey59"                  => 969696,
  "grey6"                   => "0f0f0f",
  "grey60"                  => 999999,
  "grey61"                  => "9c9c9c",
  "grey62"                  => "9e9e9e",
  "grey63"                  => "a1a1a1",
  "grey64"                  => "a3a3a3",
  "grey65"                  => "a6a6a6",
  "grey66"                  => "a8a8a8",
  "grey67"                  => "ababab",
  "grey68"                  => "adadad",
  "grey69"                  => "b0b0b0",
  "grey7"                   => 121212,
  "grey70"                  => "b3b3b3",
  "grey71"                  => "b5b5b5",
  "grey72"                  => "b8b8b8",
  "grey73"                  => "bababa",
  "grey74"                  => "bdbdbd",
  "grey75"                  => "bfbfbf",
  "grey76"                  => "c2c2c2",
  "grey77"                  => "c4c4c4",
  "grey78"                  => "c7c7c7",
  "grey79"                  => "c9c9c9",
  "grey8"                   => 141414,
  "grey80"                  => "cccccc",
  "grey81"                  => "cfcfcf",
  "grey82"                  => "d1d1d1",
  "grey83"                  => "d4d4d4",
  "grey84"                  => "d6d6d6",
  "grey85"                  => "d9d9d9",
  "grey86"                  => "dbdbdb",
  "grey87"                  => "dedede",
  "grey88"                  => "e0e0e0",
  "grey89"                  => "e3e3e3",
  "grey9"                   => 171717,
  "grey90"                  => "e5e5e5",
  "grey91"                  => "e8e8e8",
  "grey92"                  => "ebebeb",
  "grey93"                  => "ededed",
  "grey94"                  => "f0f0f0",
  "grey95"                  => "f2f2f2",
  "grey96"                  => "f5f5f5",
  "grey97"                  => "f7f7f7",
  "grey98"                  => "fafafa",
  "grey99"                  => "fcfcfc",
  "greyishblack"            => 555152,
  "greyishblue"             => "8aa1a6",
  "greyishwhite"            => "e2ddc6",
  "guacamole"               => "797b3a",
  "hairbrown"               => "8b7859",
  "harborblue"              => "16737f",
  "harbormist"              => "b4b7ba",
  "hazelnut"                => "cfb095",
  "honeydew"                => "f0fff0",
  "honeydew1"               => "f0fff0",
  "honeydew2"               => "e0eee0",
  "honeydew3"               => "c1cdc1",
  "honeydew4"               => "838b83",
  "honeysucle"              => "d65076",
  "honeyyellow"             => "a77d35",
  "hotpink"                 => "ff69b4",
  "hotpink1"                => "ff6eb4",
  "hotpink2"                => "ee6aa7",
  "hotpink3"                => "cd6090",
  "hotpink4"                => "8b3a62",
  "huntergreen"             => "8e2323",
  "hyacinthred"             => "a75536",
  "icedcoffee"              => "b18f6a",
  "illuminating"            => "f5df4d",
  "imperialpurple"          => "584c77",
  "indianred"               => "cd5c5c",
  "indianred1"              => "ff6a6a",
  "indianred2"              => "ee6363",
  "indianred3"              => "cd5555",
  "indianred4"              => "8b3a3a",
  "indigo"                  => "4b0082",
  "indigoblue"              => "4f638d",
  "inkblack"                => 252024,
  "inkwell"                 => 363945,
  "innuendo"                => "c43f66",
  "islandparadise"          => "95dee3",
  "ivory"                   => "fffff0",
  "ivory1"                  => "fffff0",
  "ivory2"                  => "eeeee0",
  "ivory3"                  => "cdcdc1",
  "ivory4"                  => "8b8b83",
  "jesterred"               => "9e1030",
  "k"                       => "000000",
  "kale"                    => "5a7247",
  "khaki"                   => "f0e68c",
  "khaki1"                  => "fff68f",
  "khaki2"                  => "eee685",
  "khaki3"                  => "cdc673",
  "khaki4"                  => "8b864e",
  "kingsyellow"             => "ead665",
  "lab"                     => "6699ff",
  "lac"                     => "66ccff",
  "lakered"                 => "b74a70",
  "lapisblue"               => "004b8d",
  "lark"                    => "b89b72",
  "lavafalls"               => "9f383a",
  "lavender"                => "e6e6fa",
  "lavenderblush"           => "fff0f5",
  "lavenderblush1"          => "fff0f5",
  "lavenderblush2"          => "eee0e5",
  "lavenderblush3"          => "cdc1c5",
  "lavenderblush4"          => "8b8386",
  "lavenderpurple"          => "77747f",
  "lawngreen"               => "7cfc00",
  "lba"                     => "3366ff",
  "lbv"                     => "6633ff",
  "lca"                     => "33ccff",
  "lct"                     => "33ffcc",
  "lda"                     => "6699cc",
  "ldb"                     => "6666cc",
  "ldc"                     => "66cccc",
  "ldg"                     => "66cc66",
  "ldm"                     => "cc66cc",
  "ldo"                     => "cc9966",
  "ldp"                     => "cc6699",
  "ldr"                     => "cc6666",
  "lds"                     => "99cc66",
  "ldt"                     => "66cc99",
  "ldv"                     => "9966cc",
  "ldy"                     => "cccc66",
  "leekgreen"               => "979c84",
  "lemonchiffon"            => "fffacd",
  "lemonchiffon1"           => "fffacd",
  "lemonchiffon2"           => "eee9bf",
  "lemonchiffon3"           => "cdc9a5",
  "lemonchiffon4"           => "8b8970",
  "lemonyellow"             => "dbc364",
  "lfb"                     => "6666ff",
  "lfc"                     => "66ffff",
  "lfg"                     => "66ff66",
  "lfm"                     => "ff66ff",
  "lfr"                     => "ff6666",
  "lfy"                     => "ffff66",
  "lg"                      => 999999,
  "lgs"                     => "66ff33",
  "lgt"                     => "33ff66",
  "lha"                     => "3399ff",
  "lhb"                     => "3333ff",
  "lhc"                     => "33ffff",
  "lhg"                     => "33ff33",
  "lhm"                     => "ff33ff",
  "lho"                     => "ff9933",
  "lhp"                     => "ff3399",
  "lhr"                     => "ff3333",
  "lhs"                     => "99ff33",
  "lht"                     => "33ff99",
  "lhv"                     => "9933ff",
  "lhy"                     => "ffff33",
  "light azure-blue"        => "6699ff",
  "light azure-cyan"        => "66ccff",
  "light blue-azure"        => "3366ff",
  "light blue-violet"       => "6633ff",
  "light cyan-azure"        => "33ccff",
  "light cyan-teal"         => "33ffcc",
  "light dull azure"        => "6699cc",
  "light dull blue"         => "6666cc",
  "light dull cyan"         => "66cccc",
  "light dull green"        => "66cc66",
  "light dull magenta"      => "cc66cc",
  "light dull orange"       => "cc9966",
  "light dull pink"         => "cc6699",
  "light dull red"          => "cc6666",
  "light dull spring"       => "99cc66",
  "light dull teal"         => "66cc99",
  "light dull violet"       => "9966cc",
  "light dull yellow"       => "cccc66",
  "light faded blue"        => "6666ff",
  "light faded cyan"        => "66ffff",
  "light faded green"       => "66ff66",
  "light faded magenta"     => "ff66ff",
  "light faded red"         => "ff6666",
  "light faded yellow"      => "ffff66",
  "light gray"              => 999999,
  "light green-spring"      => "66ff33",
  "light green-teal"        => "33ff66",
  "light hard azure"        => "3399ff",
  "light hard blue"         => "3333ff",
  "light hard cyan"         => "33ffff",
  "light hard green"        => "33ff33",
  "light hard magenta"      => "ff33ff",
  "light hard orange"       => "ff9933",
  "light hard pink"         => "ff3399",
  "light hard red"          => "ff3333",
  "light hard spring"       => "99ff33",
  "light hard teal"         => "33ff99",
  "light hard violet"       => "9933ff",
  "light hard yellow"       => "ffff33",
  "light magenta-pink"      => "ff33cc",
  "light magenta-violet"    => "cc33ff",
  "light orange-red"        => "ff9966",
  "light orange-yellow"     => "ffcc66",
  "light pink-magenta"      => "ff66cc",
  "light pink-red"          => "ff6699",
  "light red-orange"        => "ff6633",
  "light red-pink"          => "ff3366",
  "light spring-green"      => "99ff66",
  "light spring-yellow"     => "ccff66",
  "light teal-cyan"         => "66ffcc",
  "light teal-green"        => "66ff99",
  "light violet-blue"       => "9966ff",
  "light violet-magenta"    => "cc66ff",
  "light weak blue"         => "9999cc",
  "light weak cyan"         => "99cccc",
  "light weak green"        => "99cc99",
  "light weak magenta"      => "cc99cc",
  "light weak red"          => "cc9999",
  "light weak yellow"       => "cccc99",
  "light yellow-orange"     => "ffcc33",
  "light yellow-spring"     => "ccff33",
  "lightazure-blue"         => "6699ff",
  "lightazure-cyan"         => "66ccff",
  "lightazureblue"          => "6699ff",
  "lightazurecyan"          => "66ccff",
  "lightblue"               => "add8e6",
  "lightblue-azure"         => "3366ff",
  "lightblue-violet"        => "6633ff",
  "lightblue1"              => "bfefff",
  "lightblue2"              => "b2dfee",
  "lightblue3"              => "9ac0cd",
  "lightblue4"              => "68838b",
  "lightblueazure"          => "3366ff",
  "lightblueviolet"         => "6633ff",
  "lightcoral"              => "f08080",
  "lightcyan"               => "e0ffff",
  "lightcyan-azure"         => "33ccff",
  "lightcyan-teal"          => "33ffcc",
  "lightcyan1"              => "e0ffff",
  "lightcyan2"              => "d1eeee",
  "lightcyan3"              => "b4cdcd",
  "lightcyan4"              => "7a8b8b",
  "lightcyanazure"          => "33ccff",
  "lightcyanteal"           => "33ffcc",
  "lightdullazure"          => "6699cc",
  "lightdullblue"           => "6666cc",
  "lightdullcyan"           => "66cccc",
  "lightdullgreen"          => "66cc66",
  "lightdullmagenta"        => "cc66cc",
  "lightdullorange"         => "cc9966",
  "lightdullpink"           => "cc6699",
  "lightdullred"            => "cc6666",
  "lightdullspring"         => "99cc66",
  "lightdullteal"           => "66cc99",
  "lightdullviolet"         => "9966cc",
  "lightdullyellow"         => "cccc66",
  "lightfadedblue"          => "6666ff",
  "lightfadedcyan"          => "66ffff",
  "lightfadedgreen"         => "66ff66",
  "lightfadedmagenta"       => "ff66ff",
  "lightfadedred"           => "ff6666",
  "lightfadedyellow"        => "ffff66",
  "lightgoldenrod"          => "eedd82",
  "lightgoldenrod1"         => "ffec8b",
  "lightgoldenrod2"         => "eedc82",
  "lightgoldenrod3"         => "cdbe70",
  "lightgoldenrod4"         => "8b814c",
  "lightgoldenrodyellow"    => "fafad2",
  "lightgray"               => "d3d3d3",
  "lightgreen"              => "90ee90",
  "lightgreen-spring"       => "66ff33",
  "lightgreen-teal"         => "33ff66",
  "lightgreenspring"        => "66ff33",
  "lightgreenteal"          => "33ff66",
  "lightgrey"               => "d3d3d3",
  "lighthardazure"          => "3399ff",
  "lighthardblue"           => "3333ff",
  "lighthardcyan"           => "33ffff",
  "lighthardgreen"          => "33ff33",
  "lighthardmagenta"        => "ff33ff",
  "lighthardorange"         => "ff9933",
  "lighthardpink"           => "ff3399",
  "lighthardred"            => "ff3333",
  "lighthardspring"         => "99ff33",
  "lighthardteal"           => "33ff99",
  "lighthardviolet"         => "9933ff",
  "lighthardyellow"         => "ffff33",
  "lightmagenta-pink"       => "ff33cc",
  "lightmagenta-violet"     => "cc33ff",
  "lightmagentapink"        => "ff33cc",
  "lightmagentaviolet"      => "cc33ff",
  "lightorange-red"         => "ff9966",
  "lightorange-yellow"      => "ffcc66",
  "lightorangered"          => "ff9966",
  "lightorangeyellow"       => "ffcc66",
  "lightpink"               => "ffb6c1",
  "lightpink-magenta"       => "ff66cc",
  "lightpink-red"           => "ff6699",
  "lightpink1"              => "ffaeb9",
  "lightpink2"              => "eea2ad",
  "lightpink3"              => "cd8c95",
  "lightpink4"              => "8b5f65",
  "lightpinkmagenta"        => "ff66cc",
  "lightpinkred"            => "ff6699",
  "lightred-orange"         => "ff6633",
  "lightred-pink"           => "ff3366",
  "lightredorange"          => "ff6633",
  "lightredpink"            => "ff3366",
  "lightsalmon"             => "ffa07a",
  "lightsalmon1"            => "ffa07a",
  "lightsalmon2"            => "ee9572",
  "lightsalmon3"            => "cd8162",
  "lightsalmon4"            => "8b5742",
  "lightseagreen"           => "20b2aa",
  "lightskyblue"            => "87cefa",
  "lightskyblue1"           => "b0e2ff",
  "lightskyblue2"           => "a4d3ee",
  "lightskyblue3"           => "8db6cd",
  "lightskyblue4"           => "607b8b",
  "lightslateblue"          => "8470ff",
  "lightslategray"          => 778899,
  "lightslategrey"          => 778899,
  "lightspring-green"       => "99ff66",
  "lightspring-yellow"      => "ccff66",
  "lightspringgreen"        => "99ff66",
  "lightspringyellow"       => "ccff66",
  "lightsteelblue"          => "b0c4de",
  "lightsteelblue1"         => "cae1ff",
  "lightsteelblue2"         => "bcd2ee",
  "lightsteelblue3"         => "a2b5cd",
  "lightsteelblue4"         => "6e7b8b",
  "lightteal-cyan"          => "66ffcc",
  "lightteal-green"         => "66ff99",
  "lighttealcyan"           => "66ffcc",
  "lighttealgreen"          => "66ff99",
  "lightviolet-blue"        => "9966ff",
  "lightviolet-magenta"     => "cc66ff",
  "lightvioletblue"         => "9966ff",
  "lightvioletmagenta"      => "cc66ff",
  "lightweakblue"           => "9999cc",
  "lightweakcyan"           => "99cccc",
  "lightweakgreen"          => "99cc99",
  "lightweakmagenta"        => "cc99cc",
  "lightweakred"            => "cc9999",
  "lightweakyellow"         => "cccc99",
  "lightwood"               => 856363,
  "lightyellow"             => "ffffe0",
  "lightyellow-orange"      => "ffcc33",
  "lightyellow-spring"      => "ccff33",
  "lightyellow1"            => "ffffe0",
  "lightyellow2"            => "eeeed1",
  "lightyellow3"            => "cdcdb4",
  "lightyellow4"            => "8b8b7a",
  "lightyelloworange"       => "ffcc33",
  "lightyellowspring"       => "ccff33",
  "lilacgrey"               => "9896a4",
  "lime"                    => "00ff00",
  "limegreen"               => "32cd32",
  "limelight"               => "f1ea7f",
  "limepunc"                => "bfd641",
  "limpetshell"             => "98ddde",
  "linen"                   => "faf0e6",
  "littleboyblue"           => "6f9fd8",
  "liverbrown"              => "513e32",
  "livingcoral"             => "ff6f61",
  "lmp"                     => "ff33cc",
  "lmv"                     => "cc33ff",
  "lodenfrost"              => "758e77",
  "lor"                     => "ff9966",
  "loy"                     => "ffcc66",
  "lpm"                     => "ff66cc",
  "lpr"                     => "ff6699",
  "lro"                     => "ff6633",
  "lrp"                     => "ff3366",
  "lsg"                     => "99ff66",
  "lsy"                     => "ccff66",
  "ltc"                     => "66ffcc",
  "ltg"                     => "66ff99",
  "lushmeadow"              => "006e51",
  "lvb"                     => "9966ff",
  "lvm"                     => "cc66ff",
  "lwb"                     => "9999cc",
  "lwc"                     => "99cccc",
  "lwg"                     => "99cc99",
  "lwm"                     => "cc99cc",
  "lwr"                     => "cc9999",
  "lwy"                     => "cccc99",
  "lyo"                     => "ffcc33",
  "lys"                     => "ccff33",
  "m"                       => "ff00ff",
  "mab"                     => "3366cc",
  "mac"                     => "3399cc",
  "macaroniandcheese"       => "f6a94b",
  "magenta"                 => "ff00ff",
  "magenta-magenta-pink"    => "ff00cc",
  "magenta-magenta-violet"  => "cc00ff",
  "magenta1"                => "ff00ff",
  "magenta2"                => "ee00ee",
  "magenta3"                => "cd00cd",
  "magenta4"                => "8b008b",
  "magentamagentapink"      => "ff00cc",
  "magentamagentaviolet"    => "cc00ff",
  "magentapurple"           => "6c244c",
  "mahogany"                => "ba4f35",
  "mandarianorange"         => "8e2323",
  "mangomojito"             => "d69c2f",
  "marigold"                => "fdac53",
  "marina"                  => "4f84c4",
  "maroon"                  => 800000,
  "maroon1"                 => "ff34b3",
  "maroon2"                 => "ee30a7",
  "maroon3"                 => "cd2990",
  "maroon4"                 => "8b1c62",
  "marsala"                 => 955251,
  "martiniolive"            => "766f57",
  "mauvelous"               => "d0687e",
  "meadowlark"              => "ecdb54",
  "medium azure-blue"       => "3366cc",
  "medium azure-cyan"       => "3399cc",
  "medium faded blue"       => "3333cc",
  "medium faded cyan"       => "33cccc",
  "medium faded green"      => "33cc33",
  "medium faded magenta"    => "cc33cc",
  "medium faded red"        => "cc3333",
  "medium faded yellow"     => "cccc33",
  "medium orange-red"       => "cc6633",
  "medium orange-yellow"    => "cc9933",
  "medium pink-magenta"     => "cc3399",
  "medium pink-red"         => "cc3366",
  "medium spring-green"     => "66cc33",
  "medium spring-yellow"    => "99cc33",
  "medium teal-cyan"        => "33cc99",
  "medium teal-green"       => "33cc66",
  "medium violet-blue"      => "6633cc",
  "medium violet-magenta"   => "9933cc",
  "medium weak blue"        => 666699,
  "medium weak cyan"        => 669999,
  "medium weak green"       => 669966,
  "medium weak magenta"     => 996699,
  "medium weak red"         => 996666,
  "medium weak yellow"      => 999966,
  "mediumaquamarine"        => "66cdaa",
  "mediumazure-blue"        => "3366cc",
  "mediumazure-cyan"        => "3399cc",
  "mediumazureblue"         => "3366cc",
  "mediumazurecyan"         => "3399cc",
  "mediumblue"              => "0000cd",
  "mediumfadedblue"         => "3333cc",
  "mediumfadedcyan"         => "33cccc",
  "mediumfadedgreen"        => "33cc33",
  "mediumfadedmagenta"      => "cc33cc",
  "mediumfadedred"          => "cc3333",
  "mediumfadedyellow"       => "cccc33",
  "mediumforestgreen"       => "dbdb70",
  "mediumgoldenrod"         => "eaeaae",
  "mediumorange-red"        => "cc6633",
  "mediumorange-yellow"     => "cc9933",
  "mediumorangered"         => "cc6633",
  "mediumorangeyellow"      => "cc9933",
  "mediumorchid"            => "ba55d3",
  "mediumorchid1"           => "e066ff",
  "mediumorchid2"           => "d15fee",
  "mediumorchid3"           => "b452cd",
  "mediumorchid4"           => "7a378b",
  "mediumpink-magenta"      => "cc3399",
  "mediumpink-red"          => "cc3366",
  "mediumpinkmagenta"       => "cc3399",
  "mediumpinkred"           => "cc3366",
  "mediumpurple"            => "9370db",
  "mediumpurple1"           => "ab82ff",
  "mediumpurple2"           => "9f79ee",
  "mediumpurple3"           => "8968cd",
  "mediumpurple4"           => "5d478b",
  "mediumseagreen"          => "3cb371",
  "mediumslateblue"         => "7b68ee",
  "mediumspring-green"      => "66cc33",
  "mediumspring-yellow"     => "99cc33",
  "mediumspringgreen"       => "00fa9a",
  "mediumspringyellow"      => "99cc33",
  "mediumteal-cyan"         => "33cc99",
  "mediumteal-green"        => "33cc66",
  "mediumtealcyan"          => "33cc99",
  "mediumtealgreen"         => "33cc66",
  "mediumturquoise"         => "48d1cc",
  "mediumviolet-blue"       => "6633cc",
  "mediumviolet-magenta"    => "9933cc",
  "mediumvioletblue"        => "6633cc",
  "mediumvioletmagenta"     => "9933cc",
  "mediumvioletred"         => "c71585",
  "mediumweakblue"          => 666699,
  "mediumweakcyan"          => 669999,
  "mediumweakgreen"         => 669966,
  "mediumweakmagenta"       => 996699,
  "mediumweakred"           => 996666,
  "mediumweakyellow"        => 999966,
  "mediumwood"              => "a68064",
  "meerkat"                 => "a9754f",
  "melon"                   => "f6857d",
  "mfb"                     => "3333cc",
  "mfc"                     => "33cccc",
  "mfg"                     => "33cc33",
  "mfm"                     => "cc33cc",
  "mfr"                     => "cc3333",
  "mfy"                     => "cccc33",
  "midnight"                => "315d78",
  "midnightblue"            => 191970,
  "mimosa"                  => "efc050",
  "mint"                    => "00a170",
  "mintcream"               => "f5fffa",
  "mistyrose"               => "ffe4e1",
  "mistyrose1"              => "ffe4e1",
  "mistyrose2"              => "eed5d2",
  "mistyrose3"              => "cdb7b5",
  "mistyrose4"              => "8b7d7b",
  "mmp"                     => "ff00cc",
  "mmv"                     => "cc00ff",
  "moccasin"                => "ffe4b5",
  "mor"                     => "cc6633",
  "mosaicblue"              => "00758f",
  "mountaingreen"           => "b2b599",
  "moy"                     => "cc9933",
  "mpm"                     => "cc3399",
  "mpr"                     => "cc3366",
  "msg"                     => "66cc33",
  "msy"                     => "99cc33",
  "mtc"                     => "33cc99",
  "mtg"                     => "33cc66",
  "mvb"                     => "6633cc",
  "mvm"                     => "9933cc",
  "mwb"                     => 666699,
  "mwc"                     => 669999,
  "mwg"                     => 669966,
  "mwm"                     => 996699,
  "mwr"                     => 996666,
  "mwy"                     => 999966,
  "navajowhite"             => "ffdead",
  "navajowhite1"            => "ffdead",
  "navajowhite2"            => "eecfa1",
  "navajowhite3"            => "cdb38b",
  "navajowhite4"            => "8b795e",
  "navy"                    => "000080",
  "navyblazer"              => "282d3c",
  "navyblue"                => "23238e",
  "navypeony"               => "223a5e",
  "nebulasblue"             => "3f69aa",
  "neonblue"                => "4d4dff",
  "neonpink"                => "ff6ec7",
  "neutralgray"             => "898e8c",
  "newmidnightblue"         => "00009c",
  "newtan"                  => "ebc79e",
  "niagara"                 => "578ca9",
  "northerndroplet"         => "bdc0bf",
  "nosegay"                 => "f0c0d8",
  "obscure dull azure"      => "003366",
  "obscure dull blue"       => "000066",
  "obscure dull cyan"       => "006666",
  "obscure dull green"      => "006600",
  "obscure dull magenta"    => 660066,
  "obscure dull orange"     => 663300,
  "obscure dull pink"       => 660033,
  "obscure dull red"        => 660000,
  "obscure dull spring"     => 336600,
  "obscure dull teal"       => "006633",
  "obscure dull violet"     => 330066,
  "obscure dull yellow"     => 666600,
  "obscure gray"            => 333333,
  "obscure weak blue"       => "000033",
  "obscure weak cyan"       => "003333",
  "obscure weak green"      => "003300",
  "obscure weak magenta"    => 330033,
  "obscure weak red"        => 330000,
  "obscure weak yellow"     => 333300,
  "obscuredullazure"        => "003366",
  "obscuredullblue"         => "000066",
  "obscuredullcyan"         => "006666",
  "obscuredullgreen"        => "006600",
  "obscuredullmagenta"      => 660066,
  "obscuredullorange"       => 663300,
  "obscuredullpink"         => 660033,
  "obscuredullred"          => 660000,
  "obscuredullspring"       => 336600,
  "obscuredullteal"         => "006633",
  "obscuredullviolet"       => 330066,
  "obscuredullyellow"       => 666600,
  "obscuregray"             => 333333,
  "obscureweakblue"         => "000033",
  "obscureweakcyan"         => "003333",
  "obscureweakgreen"        => "003300",
  "obscureweakmagenta"      => 330033,
  "obscureweakred"          => 330000,
  "obscureweakyellow"       => 333300,
  "ochreyellow"             => "efcc83",
  "oda"                     => "003366",
  "odb"                     => "000066",
  "odc"                     => "006666",
  "odg"                     => "006600",
  "odm"                     => 660066,
  "odo"                     => 663300,
  "odp"                     => 660033,
  "odr"                     => 660000,
  "ods"                     => 336600,
  "odt"                     => "006633",
  "odv"                     => 330066,
  "ody"                     => 666600,
  "og"                      => 333333,
  "oilgreen"                => "ab924b",
  "oldgold"                 => "cfb53b",
  "oldlace"                 => "fdf5e6",
  "olive"                   => 808000,
  "olivedrab"               => "6b8e23",
  "olivedrab1"              => "c0ff3e",
  "olivedrab2"              => "b3ee3a",
  "olivedrab3"              => "9acd32",
  "olivedrab4"              => "698b22",
  "olivegreen"              => "8aa845",
  "oor"                     => "ff6600",
  "ooy"                     => "ff9900",
  "orange"                  => "ffa500",
  "orange-orange-red"       => "ff6600",
  "orange-orange-yellow"    => "ff9900",
  "orange1"                 => "ffa500",
  "orange2"                 => "ee9a00",
  "orange3"                 => "cd8500",
  "orange4"                 => "8b5a00",
  "orangecolouredwhite"     => "f3e9ca",
  "orangeorangered"         => "ff6600",
  "orangeorangeyellow"      => "ff9900",
  "orangepeel"              => "fa7a35",
  "orangered"               => "ff4500",
  "orangered1"              => "ff4500",
  "orangered2"              => "ee4000",
  "orangered3"              => "cd3700",
  "orangered4"              => "8b2500",
  "orangetiger"             => "f96714",
  "orchid"                  => "da70d6",
  "orchid1"                 => "ff83fa",
  "orchid2"                 => "ee7ae9",
  "orchid3"                 => "cd69c9",
  "orchid4"                 => "8b4789",
  "orpimentorange"          => "d17c3f",
  "owb"                     => "000033",
  "owc"                     => "003333",
  "owg"                     => "003300",
  "owm"                     => 330033,
  "owr"                     => 330000,
  "owy"                     => 333300,
  "pale dull azure"         => "99ccff",
  "pale dull blue"          => "9999ff",
  "pale dull cyan"          => "99ffff",
  "pale dull green"         => "99ff99",
  "pale dull magenta"       => "ff99ff",
  "pale dull orange"        => "ffcc99",
  "pale dull pink"          => "ff99cc",
  "pale dull red"           => "ff9999",
  "pale dull spring"        => "ccff99",
  "pale dull teal"          => "99ffcc",
  "pale dull violet"        => "cc99ff",
  "pale dull yellow"        => "ffff99",
  "pale gray"               => "cccccc",
  "pale weak blue"          => "ccccff",
  "pale weak cyan"          => "ccffff",
  "pale weak green"         => "ccffcc",
  "pale weak magenta"       => "ffccff",
  "pale weak red"           => "ffcccc",
  "pale weak yellow"        => "ffffcc",
  "paleblackishpurple"      => "4a475c",
  "paledogwood"             => "edcdc2",
  "paledullazure"           => "99ccff",
  "paledullblue"            => "9999ff",
  "paledullcyan"            => "99ffff",
  "paledullgreen"           => "99ff99",
  "paledullmagenta"         => "ff99ff",
  "paledullorange"          => "ffcc99",
  "paledullpink"            => "ff99cc",
  "paledullred"             => "ff9999",
  "paledullspring"          => "ccff99",
  "paledullteal"            => "99ffcc",
  "paledullviolet"          => "cc99ff",
  "paledullyellow"          => "ffff99",
  "palegoldenrod"           => "eee8aa",
  "palegray"                => "cccccc",
  "palegreen"               => "98fb98",
  "palegreen1"              => "9aff9a",
  "palegreen2"              => "90ee90",
  "palegreen3"              => "7ccd7c",
  "palegreen4"              => "548b54",
  "paleturquoise"           => "afeeee",
  "paleturquoise1"          => "bbffff",
  "paleturquoise2"          => "aeeeee",
  "paleturquoise3"          => "96cdcd",
  "paleturquoise4"          => "668b8b",
  "palevioletred"           => "db7093",
  "palevioletred1"          => "ff82ab",
  "palevioletred2"          => "ee799f",
  "palevioletred3"          => "cd6889",
  "palevioletred4"          => "8b475d",
  "paleweakblue"            => "ccccff",
  "paleweakcyan"            => "ccffff",
  "paleweakgreen"           => "ccffcc",
  "paleweakmagenta"         => "ffccff",
  "paleweakred"             => "ffcccc",
  "paleweakyellow"          => "ffffcc",
  "paloma"                  => "9f9c99",
  "pansypurple"             => "39334a",
  "papayawhip"              => "ffefd5",
  "pda"                     => "99ccff",
  "pdb"                     => "9999ff",
  "pdc"                     => "99ffff",
  "pdg"                     => "99ff99",
  "pdm"                     => "ff99ff",
  "pdo"                     => "ffcc99",
  "pdp"                     => "ff99cc",
  "pdr"                     => "ff9999",
  "pds"                     => "ccff99",
  "pdt"                     => "99ffcc",
  "pdv"                     => "cc99ff",
  "pdy"                     => "ffff99",
  "peach"                   => "f5bc89",
  "peachblossomred"         => "eecfbf",
  "peachecho"               => "f7786b",
  "peachnougat"             => "e6af91",
  "peachpink"               => "fa9a85",
  "peachpuff"               => "ffdab9",
  "peachpuff1"              => "ffdab9",
  "peachpuff2"              => "eecbad",
  "peachpuff3"              => "cdaf95",
  "peachpuff4"              => "8b7765",
  "pearlgrey"               => "b7b5ac",
  "pepperstem"              => "8d9440",
  "perfectlypale"           => "d5ccc1",
  "peru"                    => "cd853f",
  "pg"                      => "cccccc",
  "pink"                    => "ffc0cb",
  "pink-pink-magenta"       => "ff0099",
  "pink-pink-red"           => "ff0066",
  "pink1"                   => "ffb5c5",
  "pink2"                   => "eea9b8",
  "pink3"                   => "cd919e",
  "pink4"                   => "8b636c",
  "pinklavender"            => "dbb1cd",
  "pinkpeacock"             => "c62168",
  "pinkpinkmagenta"         => "ff0099",
  "pinkpinkred"             => "ff0066",
  "pinkyarrow"              => "ce3175",
  "pistachiogreen"          => "8e9849",
  "pitchorbrownishblack"    => 423937,
  "plum"                    => "dda0dd",
  "plum1"                   => "ffbbff",
  "plum2"                   => "eeaeee",
  "plum3"                   => "cd96cd",
  "plum4"                   => "8b668b",
  "plumpurple"              => 463759,
  "poinciana"               => "c94235",
  "polarnight"              => 434550,
  "poppyseed"               => "66686c",
  "pottersclay"             => "9e4624",
  "powderblue"              => "b0e0e6",
  "ppm"                     => "ff0099",
  "ppr"                     => "ff0066",
  "primroseyellow"          => "f6d155",
  "princessblue"            => "00539c",
  "prussianblue"            => "1c1949",
  "purple"                  => 800080,
  "purple1"                 => "9b30ff",
  "purple2"                 => "912cee",
  "purple3"                 => "7d26cd",
  "purple4"                 => "551a8b",
  "purplemountainsmajesty"  => "8a6dc1",
  "purplishred"             => 612741,
  "purplishwhite"           => "ece6d0",
  "pwb"                     => "ccccff",
  "pwc"                     => "ccffff",
  "pwg"                     => "ccffcc",
  "pwm"                     => "ffccff",
  "pwr"                     => "ffcccc",
  "pwy"                     => "ffffcc",
  "quartz"                  => "d9d9f3",
  "quetzalgreen"            => "006e6d",
  "quietgray"               => "bcbcbe",
  "r"                       => "ff0000",
  "radiandorchid"           => "b565a7",
  "raspberrysorbet"         => "d2386c",
  "rawsienna"               => "9f6a3b",
  "rebeccapurple"           => 663399,
  "red"                     => "ff0000",
  "red-red-orange"          => "ff3300",
  "red-red-pink"            => "ff0033",
  "red1"                    => "ff0000",
  "red2"                    => "ee0000",
  "red3"                    => "cd0000",
  "red4"                    => "8b0000",
  "reddishblack"            => 433635,
  "reddishorange"           => "be7249",
  "reddishwhite"            => "f2e7cf",
  "redlilacpurple"          => "bfbac0",
  "redorange"               => "f1612a",
  "redpear"                 => "7f4145",
  "redredorange"            => "ff3300",
  "redredpink"              => "ff0033",
  "redviolet"               => "b32f79",
  "richblue"                => "5959ab",
  "riverside"               => "4c6a92",
  "rockyroad"               => "5a3e36",
  "rosequartz"              => "f7cac9",
  "rosered"                 => "eedac3",
  "rosetan"                 => "d19c97",
  "roseviolet"              => "c15391",
  "rosybrown"               => "bc8f8f",
  "rosybrown1"              => "ffc1c1",
  "rosybrown2"              => "eeb4b4",
  "rosybrown3"              => "cd9b9b",
  "rosybrown4"              => "8b6969",
  "royalblue"               => "4169e1",
  "royalblue1"              => "4876ff",
  "royalblue2"              => "436eee",
  "royalblue3"              => "3a5fcd",
  "royalblue4"              => "27408b",
  "rro"                     => "ff3300",
  "rrp"                     => "ff0033",
  "russetorange"            => "e47a2e",
  "rust"                    => "b55a30",
  "rustyred"                => 822007,
  "saddlebrown"             => "8b4513",
  "saffron"                 => "ffa500",
  "saffronyellow"           => "d09b2c",
  "sailorblue"              => "2e4a62",
  "salmon"                  => "fa8072",
  "salmon1"                 => "ff8c69",
  "salmon2"                 => "ee8262",
  "salmon3"                 => "cd7054",
  "salmon4"                 => "8b4c39",
  "samba"                   => "a2242f",
  "samoansun"               => "f5cc72",
  "sanddollar"              => "dfcfbe",
  "sandstone"               => "c48a69",
  "sandybrown"              => "f4a460",
  "sapgreen"                => "7c8635",
  "sargassosea"             => 485167,
  "scarlet"                 => "ed3825",
  "scarletred"              => "b63e36",
  "scotchblue"              => "281f3f",
  "seagreen"                => "2e8b57",
  "seagreen1"               => "54ff9f",
  "seagreen2"               => "4eee94",
  "seagreen3"               => "43cd80",
  "seagreen4"               => "2e8b57",
  "seashell"                => "fff5ee",
  "seashell1"               => "fff5ee",
  "seashell2"               => "eee5de",
  "seashell3"               => "cdc5bf",
  "seashell4"               => "8b8682",
  "semisweetchocolate"      => "6b4226",
  "sepia"                   => "6c4f3c",
  "serenity"                => "91a8d0",
  "shadedspruce"            => "005960",
  "sharkskin"               => 838487,
  "sienna"                  => "a0522d",
  "sienna1"                 => "ff8247",
  "sienna2"                 => "ee7942",
  "sienna3"                 => "cd6839",
  "sienna4"                 => "8b4726",
  "siennayellow"            => "f1d28c",
  "silver"                  => "c0c0c0",
  "siskingreen"             => "c8c76f",
  "skimmedmilkwhite"        => "e6e1c9",
  "skyblue"                 => "87ceeb",
  "skyblue1"                => "87ceff",
  "skyblue2"                => "7ec0ee",
  "skyblue3"                => "6ca6cd",
  "skyblue4"                => "4a708b",
  "skydiver"                => "1e609e",
  "slateblue"               => "6a5acd",
  "slateblue1"              => "836fff",
  "slateblue2"              => "7a67ee",
  "slateblue3"              => "6959cd",
  "slateblue4"              => "473c8b",
  "slategray"               => 708090,
  "slategray1"              => "c6e2ff",
  "slategray2"              => "b9d3ee",
  "slategray3"              => "9fb6cd",
  "slategray4"              => "6c7b8b",
  "slategrey"               => 708090,
  "smokegrey"               => "bfbbb0",
  "snorkelblue"             => "034f84",
  "snow"                    => "fffafa",
  "snow1"                   => "fffafa",
  "snow2"                   => "eee9e9",
  "snow3"                   => "cdc9c9",
  "snow4"                   => "8b8989",
  "snowwhite"               => "f2f0eb",
  "soybean"                 => "d2c29d",
  "spicymustard"            => "d8ae47",
  "spicypink"               => "ff1cae",
  "spring-spring-green"     => "66ff00",
  "spring-spring-yellow"    => "99ff00",
  "springcrocus"            => "bc70a4",
  "springgreen"             => "00ff7f",
  "springgreen1"            => "00ff7f",
  "springgreen2"            => "00ee76",
  "springgreen3"            => "00cd66",
  "springgreen4"            => "008b45",
  "springspringgreen"       => "66ff00",
  "springspringyellow"      => "99ff00",
  "spunsugar"               => "b8deec",
  "ssg"                     => "66ff00",
  "ssy"                     => "99ff00",
  "steelblue"               => "4682b4",
  "steelblue1"              => "63b8ff",
  "steelblue2"              => "5cacee",
  "steelblue3"              => "4f94cd",
  "steelblue4"              => "36648b",
  "strawyellow"             => "f0d696",
  "sugaralmond"             => 935529,
  "sulphuryellow"           => "ccc050",
  "summersky"               => "38b0de",
  "sunlight"                => "edd59e",
  "sweetcorn"               => "f0ead6",
  "sweetlilac"              => "e8b5ce",
  "tan"                     => "d2b48c",
  "tan1"                    => "ffa54f",
  "tan2"                    => "ee9a49",
  "tan3"                    => "cd853f",
  "tan4"                    => "8b5a2b",
  "tangerinetango"          => "dd4124",
  "tawnyport"               => "672e3b",
  "teal"                    => "008080",
  "teal-teal-cyan"          => "00ff99",
  "teal-teal-green"         => "00ff66",
  "tealtealcyan"            => "00ff99",
  "tealtealgreen"           => "00ff66",
  "terrariummoss"           => 616247,
  "thistle"                 => "d8bfd8",
  "thistle1"                => "ffe1ff",
  "thistle2"                => "eed2ee",
  "thistle3"                => "cdb5cd",
  "thistle4"                => "8b7b8b",
  "tigerlily"               => "e15d44",
  "tilered"                 => "c76b4a",
  "timberwolf"              => "adb0aa",
  "toffee"                  => 755139,
  "tofu"                    => "eae6da",
  "tomato"                  => "ff6347",
  "tomato1"                 => "ff6347",
  "tomato2"                 => "ee5c42",
  "tomato3"                 => "cd4f39",
  "tomato4"                 => "8b3626",
  "truered"                 => "bc243c",
  "ttc"                     => "00ff99",
  "ttg"                     => "00ff66",
  "tumbleweed"              => "b98a64",
  "turmeric"                => "fe840e",
  "turquoise"               => "40e0d0",
  "turquoise1"              => "00f5ff",
  "turquoise2"              => "00e5ee",
  "turquoise3"              => "00c5cd",
  "turquoise4"              => "00868b",
  "ultimategray"            => "96999b",
  "ultramarineblue"         => "657abb",
  "ultramarinegreen"        => "006b54",
  "ultraviolet"             => "6b5b95",
  "umberbrown"              => 613936,
  "valiantpoppy"            => "bd3d3a",
  "vanillacustard"          => "f3e0be",
  "veinousbloodred"         => "3f3033",
  "velvetblack"             => "241f20",
  "verdigrisgreen"          => "61ac86",
  "verditterblue"           => "6fb5a8",
  "vermilionred"            => "b5493a",
  "verydarkbrown"           => "5c4033",
  "verylightgrey"           => "cdcdcd",
  "veryperi"                => "696aad",
  "violet"                  => "ee82ee",
  "violet-violet-blue"      => "6600ff",
  "violet-violet-magenta"   => "9900ff",
  "violetpurple"            => "3a2f52",
  "violetred"               => "e82362",
  "violetred1"              => "ff3e96",
  "violetred2"              => "ee3a8c",
  "violetred3"              => "cd3278",
  "violetred4"              => "8b2252",
  "violetvioletblue"        => "6600ff",
  "violetvioletmagenta"     => "9900ff",
  "vvb"                     => "6600ff",
  "vvm"                     => "9900ff",
  "w"                       => "ffffff",
  "warmsand"                => "c0ab8e",
  "warmtaupe"               => "af9483",
  "waterspout"              => "93dbe0",
  "waxyellow"               => "ab9649",
  "webgray"                 => 808080,
  "webgreen"                => "008000",
  "webgrey"                 => 808080,
  "webmaroon"               => 800000,
  "webpurple"               => 800080,
  "wheat"                   => "f5deb3",
  "wheat1"                  => "ffe7ba",
  "wheat2"                  => "eed8ae",
  "wheat3"                  => "cdba96",
  "wheat4"                  => "8b7e66",
  "white"                   => "ffffff",
  "whitesmoke"              => "f5f5f5",
  "willow"                  => "9a8b4f",
  "wineyellow"              => "d7c485",
  "wistera"                 => "b681cf",
  "woodbrown"               => "c39e6d",
  "x11gray"                 => "bebebe",
  "x11green"                => "00ff00",
  "x11grey"                 => "bebebe",
  "x11maroon"               => "b03060",
  "x11purple"               => "a020f0",
  "y"                       => "ffff00",
  "yellow"                  => "ffff00",
  "yellow-yellow-orange"    => "ffcc00",
  "yellow-yellow-spring"    => "ccff00",
  "yellow1"                 => "ffff00",
  "yellow2"                 => "eeee00",
  "yellow3"                 => "cdcd00",
  "yellow4"                 => "8b8b00",
  "yellowgreen"             => "9acd32",
  "yellowishbrown"          => 946943,
  "yellowishgrey"           => "bab191",
  "yellowishwhite"          => "f2eacc",
  "yelloworange"            => "f59506",
  "yellowyelloworange"      => "ffcc00",
  "yellowyellowspring"      => "ccff00",
  "yyo"                     => "ffcc00",
  "yys"                     => "ccff00",
}
;

1;
# ABSTRACT: Lots of English color names and equivalent RGB values (lite version)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesLite::EN - Lots of English color names and equivalent RGB values (lite version)

=head1 VERSION

This document describes version 0.002 of Graphics::ColorNamesLite::EN (from Perl distribution Graphics-ColorNamesLite-EN), released on 2023-11-30.

=head1 DESCRIPTION

This is a merge of various English Graphics::ColorNames::* modules.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesLite-EN>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesLite-EN>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesLite::*> modules.

Other C<Graphics::ColorNames::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesLite-EN>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
