# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IM;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20231210185945;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1624(?:
            230|
            [5-8]\\d\\d
          )\\d{3}
        ',
                'geographic' => '
          1624(?:
            230|
            [5-8]\\d\\d
          )\\d{3}
        ',
                'mobile' => '
          76245[06]\\d{4}|
          7(?:
            4576|
            [59]24\\d|
            624[0-4689]
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          8(?:
            440[49]06|
            72299\\d
          )\\d{3}|
          (?:
            8(?:
              45|
              70
            )|
            90[0167]
          )624\\d{4}
        )|(
          3440[49]06\\d{3}|
          (?:
            3(?:
              08162|
              3\\d{4}|
              45624|
              7(?:
                0624|
                2299
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '808162\\d{4}',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441770", "Isle\ of\ Arran",
"441841", "Newquay\ \(Padstow\)",
"441395", "Budleigh\ Salterton",
"4416974", "Raughton\ Head",
"441300", "Cerne\ Abbas",
"441226", "Barnsley",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441362", "Dereham",
"441234", "Bedford",
"441656", "Bridgend",
"441948", "Whitchurch",
"441382", "Dundee",
"441542", "Keith",
"441530", "Coalville",
"4414237", "Harrogate",
"4414300", "North\ Cave\/Market\ Weighton",
"441938", "Welshpool",
"441691", "Oswestry",
"441244", "Chester",
"44121", "Birmingham",
"4419759", "Alford\ \(Aberdeen\)",
"441380", "Devizes",
"441822", "Tavistock",
"441540", "Kingussie",
"4418474", "Thurso",
"441237", "Bideford",
"4418902", "Coldstream",
"441143", "Sheffield",
"442871", "Londonderry",
"4413882", "Stanhope\ \(Eastgate\)",
"441623", "Mansfield",
"442311", "Southampton",
"441453", "Dursley",
"4418519", "Great\ Bernera",
"441529", "Sleaford",
"44113", "Leeds",
"441772", "Preston",
"441253", "Blackpool",
"4419646", "Patrington",
"442879", "Magherafelt",
"441923", "Watford",
"4418478", "Thurso",
"441302", "Doncaster",
"441593", "Lybster",
"441916", "Tyneside",
"4412290", "Barrow\-in\-Furness\/Millom",
"441638", "Newmarket",
"441360", "Killearn",
"44141", "Glasgow",
"441444", "Haywards\ Heath",
"4415076", "Louth",
"441629", "Matlock",
"4414342", "Bellingham",
"441833", "Barnard\ Castle",
"4414307", "Market\ Weighton",
"441778", "Bourne",
"441787", "Sudbury",
"441993", "Witney",
"441591", "Llanwrtyd\ Wells",
"441308", "Bridport",
"4414230", "Harrogate\/Boroughbridge",
"441885", "Pencombe",
"441865", "Oxford",
"441857", "Sanday",
"441828", "Coupar\ Angus",
"441141", "Sheffield",
"441538", "Ipstones",
"441599", "Kyle",
"441932", "Weybridge",
"441767", "Sandy",
"441704", "Southport",
"441451", "Stow\-on\-the\-Wold",
"441892", "Tunbridge\ Wells",
"441259", "Alloa",
"441621", "Maldon",
"441929", "Wareham",
"4417687", "Keswick",
"4412297", "Millom",
"441548", "Kingsbridge",
"441377", "Driffield",
"441805", "Torrington",
"441388", "Bishop\ Auckland",
"441854", "Ullapool",
"4418518", "Stornoway",
"442886", "Cookstown",
"441942", "Wigan",
"441496", "Port\ Ellen",
"4419758", "Strathdon",
"441764", "Crieff",
"441707", "Welwyn\ Garden\ City",
"441784", "Staines",
"441843", "Thanet",
"4418514", "Great\ Bernera",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441296", "Aylesbury",
"4419641", "Hornsea\/Patrington",
"442866", "Enniskillen",
"441325", "Darlington",
"441630", "Market\ Drayton",
"441368", "Dunbar",
"44287", "Northern\ Ireland",
"441642", "Middlesbrough",
"4419754", "Alford\ \(Aberdeen\)",
"44114703", "Sheffield",
"4418479", "Tongue",
"4415395", "Grange\-over\-Sands",
"441556", "Castle\ Douglas",
"4420", "London",
"4414378", "Haverfordwest",
"4413391", "Aboyne\/Ballater",
"441745", "Rhyl",
"441776", "Stranraer",
"441249", "Chippenham",
"441994", "St\ Clears",
"441834", "Narberth",
"441524", "Lancaster",
"441950", "Sandwick",
"441912", "Tyneside",
"441306", "Dorking",
"4414235", "Harrogate",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441536", "Kettering",
"441420", "Alton",
"4416863", "Llanidloes",
"4418512", "Stornoway",
"441650", "Cemmaes\ Road",
"4418909", "Ayton",
"441449", "Stowmarket",
"441694", "Church\ Stretton",
"441241", "Arbroath",
"441373", "Frome",
"4419752", "Alford\ \(Aberdeen\)",
"441763", "Royston",
"441575", "Kirriemuir",
"441546", "Lochgilphead",
"441422", "Halifax",
"441386", "Evesham",
"442877", "Limavady",
"4414344", "Bellingham",
"442888", "Northern\ Ireland",
"441652", "Brigg",
"441439", "Helmsley",
"441697", "Brampton",
"441997", "Strathpeffer",
"4414348", "Hexham",
"441431", "Helmsdale",
"441298", "Buxton",
"441239", "Cardigan",
"442868", "Kesh",
"441844", "Thame",
"441366", "Downham\ Market",
"442825", "Ballymena",
"441952", "Telford",
"441837", "Okehampton",
"441910", "Tyneside\/Durham\/Sunderland",
"441527", "Redditch",
"441558", "Llandeilo",
"441597", "Llandrindod\ Wells",
"4418904", "Coldstream",
"4414305", "North\ Cave",
"441292", "Ayr",
"4418472", "Thurso",
"441859", "Harris",
"441433", "Hathersage",
"4415242", "Hornby",
"442895", "Belfast",
"441485", "Hunstanton",
"441257", "Coppull",
"441228", "Carlisle",
"4414379", "Haverfordwest",
"441769", "South\ Molton",
"441646", "Milford\ Haven",
"441675", "Coleshill",
"4413396", "Ballater",
"441946", "Whitehaven",
"442882", "Omagh",
"4418908", "Coldstream",
"441789", "Stratford\-upon\-Avon",
"441428", "Haslemere",
"441761", "Temple\ Cloud",
"441457", "Glossop",
"441285", "Cirencester",
"441465", "Girvan",
"441233", "Ashford\ \(Kent\)",
"44115", "Nottingham",
"441492", "Colwyn\ Bay",
"442880", "Carrickmore",
"441454", "Chipping\ Sodbury",
"441405", "Goole",
"4412295", "Barrow\-in\-Furness",
"441624", "Isle\ of\ Man",
"441144", "Sheffield",
"441371", "Great\ Dunmow",
"441243", "Chichester",
"441490", "Corwen",
"441896", "Galashiels",
"441290", "Cumnock",
"441443", "Pontypridd",
"441594", "Lydney",
"441379", "Diss",
"441550", "Llandovery",
"441918", "Tyneside",
"441924", "Wakefield",
"441636", "Newark\-on\-Trent",
"441205", "Boston",
"44247", "Coventry",
"441254", "Blackburn",
"4414349", "Bellingham",
"441709", "Rotherham",
"441566", "Launceston",
"441743", "Shrewsbury",
"441358", "Ellon",
"441884", "Tiverton",
"441327", "Daventry",
"441409", "Holsworthy",
"441209", "Redruth",
"441754", "Skegness",
"4413390", "Aboyne\/Ballater",
"441346", "Fraserburgh",
"441807", "Ballindalloch",
"441864", "Abington\ \(Crawford\)",
"441375", "Grays\ Thurrock",
"442848", "Northern\ Ireland",
"441586", "Campbeltown",
"441790", "Spilsby",
"441971", "Scourie",
"441728", "Saxmundham",
"441269", "Ammanford",
"441489", "Bishops\ Waltham",
"441765", "Ripon",
"441461", "Gretna",
"441573", "Kelso",
"441757", "Selby",
"442838", "Portadown",
"442899", "Northern\ Ireland",
"441792", "Swansea",
"44238", "Southampton",
"441855", "Ballachulish",
"4419753", "Strathdon",
"441878", "Lochboisdale",
"441887", "Aberfeldy",
"441733", "Peterborough",
"441324", "Falkirk",
"441506", "Bathgate",
"442891", "Bangor\ \(Co\.\ Down\)",
"441261", "Banff",
"441481", "Guernsey",
"441785", "Stafford",
"441469", "Killingholme",
"4419645", "Hornsea",
"441289", "Berwick\-upon\-Tweed",
"442823", "Northern\ Ireland",
"4418513", "Stornoway",
"4416862", "Llanidloes",
"441671", "Newton\ Stewart",
"442893", "Ballyclare",
"441350", "Dunkeld",
"4413397", "Ballater",
"441435", "Heathfield",
"441872", "Truro",
"441673", "Market\ Rasen",
"4415075", "Spilsby\ \(Horncastle\)",
"442821", "Martinstown",
"441579", "Liskeard",
"4416973", "Wigton",
"441483", "Guildford",
"441263", "Cromer",
"441394", "Felixstowe",
"441283", "Burton\-on\-Trent",
"441571", "Lochinver",
"441463", "Inverness",
"441722", "Salisbury",
"442829", "Kilrea",
"441798", "Pulborough",
"441606", "Northwich",
"441235", "Abingdon",
"442840", "Banbridge",
"441720", "Isles\ of\ Scilly",
"441403", "Horsham",
"441276", "Camberley",
"441749", "Shepton\ Mallet",
"441245", "Chelmsford",
"442830", "Newry",
"441986", "Bungay",
"442842", "Kircubbin",
"441666", "Malmesbury",
"4418473", "Thurso",
"441352", "Mold",
"44114704", "Sheffield",
"441445", "Gairloch",
"4415396", "Sedbergh",
"441870", "Isle\ of\ Benbecula",
"441476", "Grantham",
"441397", "Fort\ William",
"4416869", "Newtown",
"441484", "Huddersfield",
"441264", "Andover",
"441207", "Consett",
"4414301", "North\ Cave\/Market\ Weighton",
"441502", "Lowestoft",
"441674", "Montrose",
"441908", "Milton\ Keynes",
"441560", "Moscow",
"441809", "Tomdoun",
"4418903", "Coldstream",
"442894", "Antrim",
"441329", "Fareham",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441580", "Cranbrook",
"441974", "Llanon",
"4414236", "Harrogate",
"441796", "Pitlochry",
"441608", "Chipping\ Norton",
"441284", "Bury\ St\ Edmunds",
"441464", "Insch",
"441407", "Holyhead",
"441332", "Derby",
"441340", "Craigellachie\ \(Aberlour\)",
"441889", "Rugeley",
"44116", "Leicester",
"441145", "Sheffield",
"4412291", "Barrow\-in\-Furness\/Millom",
"441455", "Hinckley",
"441278", "Bridgwater",
"441582", "Luton",
"441404", "Honiton",
"441467", "Inverurie",
"441287", "Guisborough",
"441751", "Pickering",
"441625", "Macclesfield",
"441977", "Pontefract",
"441988", "Wigtown",
"441330", "Banchory",
"441668", "Bamburgh",
"441342", "East\ Grinstead",
"441925", "Warrington",
"44291", "Cardiff",
"441677", "Bedale",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441968", "Penicuik",
"441759", "Pocklington",
"441204", "Bolton",
"441267", "Carmarthen",
"441487", "Warboys",
"441255", "Clacton\-on\-Sea",
"441562", "Kidderminster",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"442897", "Saintfield",
"44118", "Reading",
"441869", "Bicester",
"4419647", "Patrington",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441900", "Workington",
"441472", "Grimsby",
"441568", "Leominster",
"441835", "St\ Boswells",
"441525", "Leighton\ Buzzard",
"441962", "Winchester",
"442827", "Ballymoney",
"441356", "Brechin",
"4413395", "Aboyne",
"4414306", "Market\ Weighton",
"441883", "Caterham",
"441737", "Redhill",
"4416868", "Newtown",
"4415077", "Louth",
"441995", "Garstang",
"441744", "St\ Helens",
"441695", "Skelmersdale",
"4414231", "Harrogate\/Boroughbridge",
"441863", "Ardgay",
"4416864", "Llanidloes",
"441348", "Fishguard",
"4414373", "Clynderwen\ \(Clunderwen\)",
"442846", "Northern\ Ireland",
"441982", "Builth\ Wells",
"441600", "Monmouth",
"441588", "Bishops\ Castle",
"441753", "Slough",
"441577", "Kinross",
"441803", "Torquay",
"441726", "St\ Austell",
"4419640", "Hornsea\/Patrington",
"441980", "Amesbury",
"4412296", "Barrow\-in\-Furness",
"4414343", "Haltwhistle",
"441270", "Crewe",
"442824", "Northern\ Ireland",
"441902", "Wolverhampton",
"441876", "Lochmaddy",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441845", "Thirsk",
"441508", "Brooke",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441747", "Shaftesbury",
"441323", "Eastbourne",
"44241", "Coventry",
"441425", "Ringwood",
"441721", "Peebles",
"441572", "Oakham",
"441288", "Bude",
"441277", "Brentwood",
"441655", "Maybole",
"441667", "Nairn",
"441604", "Northampton",
"441987", "Ebbsfleet",
"441978", "Wrexham",
"441879", "Scarinish",
"441793", "Swindon",
"4412293", "Millom",
"44114701", "Sheffield",
"4417683", "Appleby",
"4414346", "Hexham",
"442898", "Belfast",
"4415072", "Spilsby\ \(Horncastle\)",
"441871", "Castlebay",
"441740", "Sedgefield",
"441732", "Sevenoaks",
"44117", "Bristol",
"441955", "Wick",
"442822", "Northern\ Ireland",
"441904", "York",
"441967", "Strontian",
"441687", "Mallaig",
"441678", "Bala",
"441729", "Settle",
"441477", "Holmes\ Chapel",
"441268", "Basildon",
"441488", "Hungerford",
"441225", "Bath",
"4413399", "Ballater",
"442849", "Northern\ Ireland",
"4414376", "Haverfordwest",
"441730", "Petersfield",
"441474", "Gravesend",
"442820", "Ballycastle",
"441208", "Bodmin",
"4413873", "Langholm",
"441684", "Malvern",
"441915", "Sunderland",
"44292", "Cardiff",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441664", "Melton\ Mowbray",
"441984", "Watchet\ \(Williton\)",
"441570", "Lampeter",
"4414303", "North\ Cave",
"441408", "Golspie",
"441274", "Bradford",
"4418901", "Coldstream\/Ayton",
"441359", "Pakenham",
"442841", "Rostrevor",
"441970", "Aberystwyth",
"441584", "Ludlow",
"441337", "Ladybank",
"441460", "Chard",
"441280", "Buckingham",
"441866", "Kilchrenan",
"44131", "Edinburgh",
"441344", "Bracknell",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441756", "Skipton",
"44114702", "Sheffield",
"441748", "Richmond",
"442890", "Belfast",
"441353", "Ely",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441260", "Congleton",
"441480", "Huntingdon",
"44283", "Northern\ Ireland",
"441670", "Morpeth",
"441564", "Lapworth",
"441202", "Bournemouth",
"441799", "Saffron\ Walden",
"4419642", "Hornsea",
"441738", "Perth",
"441295", "Banbury",
"441873", "Abergavenny",
"442892", "Lisburn",
"4414233", "Boroughbridge",
"4416865", "Newtown",
"4413398", "Aboyne",
"441567", "Killin",
"441482", "Kingston\-upon\-Hull",
"441555", "Lanark",
"441262", "Bridlington",
"441326", "Falmouth",
"441672", "Marlborough",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441200", "Clitheroe",
"442828", "Larne",
"441400", "Honington",
"441972", "Glenborrodale",
"441806", "Shetland",
"442885", "Ballygawley",
"441347", "Easingwold",
"441282", "Burnley",
"441578", "Lauder",
"441462", "Hitchin",
"441334", "St\ Andrews",
"4418906", "Ayton",
"441723", "Scarborough",
"4413394", "Ballater",
"441495", "Pontypool",
"442837", "Armagh",
"4419644", "Patrington",
"442844", "Downpatrick",
"441535", "Keighley",
"44281", "Northern\ Ireland",
"441825", "Uckfield",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441981", "Wormbridge",
"441689", "Orpington",
"441343", "Elgin",
"441969", "Leyburn",
"4418511", "Great\ Bernera\/Stornoway",
"441661", "Prudhoe",
"441758", "Pwllheli",
"441271", "Barnstaple",
"441583", "Carradale",
"441479", "Grantown\-on\-Spey",
"441727", "St\ Albans",
"441279", "Bishops\ Stortford",
"441746", "Bridgnorth",
"441563", "Kilmarnock",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"4418476", "Tongue",
"441775", "Spalding",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441989", "Ross\-on\-Wye",
"441669", "Rothbury",
"4419648", "Hornsea",
"441354", "Chatteris",
"441888", "Turriff",
"441305", "Dorchester",
"441877", "Callander",
"4413392", "Aboyne",
"441736", "Penzance",
"441609", "Northallerton",
"441392", "Exeter",
"441503", "Looe",
"441328", "Fakenham",
"441357", "Strathaven",
"441874", "Brecon",
"4415079", "Alford\ \(Lincs\)",
"442826", "Northern\ Ireland",
"442847", "Northern\ Ireland",
"441808", "Tomatin",
"441576", "Lockerbie",
"441545", "Llanarth",
"4416860", "Newtown\/Llanidloes",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441724", "Scunthorpe",
"441909", "Worksop",
"4418516", "Great\ Bernera",
"441466", "Huntly",
"441286", "Caernarfon",
"441945", "Wisbech",
"441794", "Romsey",
"441603", "Norwich",
"441750", "Selkirk",
"4419756", "Strathdon",
"441509", "Loughborough",
"441501", "Harthill",
"441398", "Dulverton",
"442896", "Belfast",
"441903", "Worthing",
"4418471", "Thurso\/Tongue",
"441676", "Meriden",
"441322", "Dartford",
"441880", "Tarbert",
"4419649", "Hornsea",
"441963", "Wincanton",
"441349", "Dingwall",
"4416867", "Llanidloes",
"441683", "Moffat",
"441473", "Ipswich",
"441561", "Laurencekirk",
"4415078", "Alford\ \(Lincs\)",
"441635", "Newbury",
"441206", "Colchester",
"441320", "Fort\ Augustus",
"441882", "Kinloch\ Rannoch",
"441797", "Rye",
"44114709", "Sheffield",
"441862", "Tain",
"441935", "Yeovil",
"441406", "Holbeach",
"4415074", "Alford\ \(Lincs\)",
"441569", "Stonehaven",
"441752", "Plymouth",
"441895", "Uxbridge",
"441581", "New\ Luce",
"441273", "Brighton",
"441341", "Barmouth",
"441663", "New\ Mills",
"441983", "Isle\ of\ Wight",
"441142", "Sheffield",
"441823", "Taunton",
"4412299", "Millom",
"441497", "Hay\-on\-Wye",
"441698", "Motherwell",
"441639", "Neath",
"441931", "Shap",
"441706", "Rochdale",
"441452", "Gloucester",
"442887", "Dungannon",
"441622", "Maidstone",
"441376", "Braintree",
"441922", "Walsall",
"442867", "Lisnaskea",
"441252", "Aldershot",
"441565", "Knutsford",
"441557", "Kirkcudbright",
"441773", "Ripley",
"4418510", "Great\ Bernera\/Stornoway",
"441528", "Laggan",
"441899", "Biggar",
"441838", "Dalmally",
"441939", "Wem",
"4414345", "Haltwhistle",
"441631", "Oban",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441297", "Axminster",
"441303", "Folkestone",
"441592", "Kirkcaldy",
"4418477", "Tongue",
"441505", "Johnstone",
"441554", "Llanelli",
"441920", "Ware",
"441250", "Blairgowrie",
"4416861", "Newtown\/Llanidloes",
"441848", "Thornhill",
"4414309", "Market\ Weighton",
"441641", "Strathy",
"441294", "Ardrossan",
"441949", "Whatton",
"441363", "Crediton",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441786", "Stirling",
"441590", "Lymington",
"4414234", "Boroughbridge",
"441140", "Sheffield",
"441543", "Cannock",
"4413393", "Aboyne",
"441766", "Porthmadog",
"441383", "Dunfermline",
"441494", "High\ Wycombe",
"442884", "Northern\ Ireland",
"441856", "Orkney",
"441450", "Hawick",
"4414238", "Harrogate",
"441335", "Ashbourne",
"44114700", "Sheffield",
"441620", "North\ Berwick",
"441381", "Fortrose",
"4419757", "Strathdon",
"4419467", "Gosforth",
"441690", "Betws\-y\-Coed",
"441369", "Dunoon",
"441943", "Guiseley",
"4418470", "Thurso\/Tongue",
"4412298", "Barrow\-in\-Furness",
"442310", "Portsmouth",
"441424", "Hastings",
"442870", "Coleraine",
"4418517", "Stornoway",
"441654", "Machynlleth",
"441236", "Coatbridge",
"441520", "Lochcarron",
"441842", "Thetford",
"441436", "Helensburgh",
"441917", "Sunderland",
"441830", "Kirkwhelpington",
"441954", "Madingley",
"441905", "Worcester",
"441224", "Aberdeen",
"441549", "Lairg",
"4417684", "Pooley\ Bridge",
"4412294", "Barrow\-in\-Furness",
"441389", "Dumbarton",
"441643", "Minehead",
"441361", "Duns",
"441840", "Camelford",
"441522", "Lincoln",
"441227", "Canterbury",
"441446", "Barry",
"441832", "Clopton",
"441258", "Blandford",
"441475", "Greenock",
"441771", "Maud",
"441685", "Merthyr\ Tydfil",
"441928", "Runcorn",
"441914", "Tyneside",
"441957", "Mid\ Yell",
"441829", "Tarporley",
"441539", "Kendal",
"441598", "Lynton",
"441301", "Arrochar",
"4414308", "Market\ Weighton",
"441992", "Lea\ Valley",
"4416866", "Newtown",
"441633", "Newport",
"4413885", "Stanhope\ \(Eastgate\)",
"441692", "North\ Walsham",
"441933", "Wellingborough",
"441531", "Ledbury",
"441309", "Forres",
"441821", "Kinrossie",
"4414239", "Boroughbridge",
"441985", "Warminster",
"441628", "Maidenhead",
"441665", "Alnwick",
"441275", "Clevedon",
"441458", "Glastonbury",
"441427", "Gainsborough",
"441779", "Peterhead",
"4418905", "Ayton",
"441246", "Chesterfield",
"4414304", "North\ Cave",
"441700", "Rothesay",
"442881", "Newtownstewart",
"441653", "Malton",
"44114707", "Sheffield",
"441559", "Llandysul",
"441937", "Wetherby",
"441795", "Sittingbourne",
"441852", "Kilmelford",
"441491", "Henley\-on\-Thames",
"441944", "West\ Heslerton",
"441299", "Bewdley",
"441499", "Inveraray",
"441438", "Stevenage",
"44161", "Manchester",
"441291", "Chepstow",
"441644", "New\ Galloway",
"441637", "Newquay",
"441223", "Cambridge",
"441782", "Stoke\-on\-Trent",
"4414302", "North\ Cave",
"4418475", "Thurso",
"44239", "Portsmouth",
"4414347", "Hexham",
"441953", "Wymondham",
"442889", "Fivemiletown",
"4418900", "Coldstream\/Ayton",
"441256", "Basingstoke",
"441634", "Medway",
"441926", "Warwick",
"441647", "Moretonhampstead",
"4414377", "Haverfordwest",
"441913", "Durham",
"441780", "Stamford",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441702", "Southend\-on\-Sea",
"441760", "Swaffham",
"441146", "Sheffield",
"441626", "Newton\ Abbot",
"441372", "Esher",
"441947", "Whitby",
"4415073", "Louth",
"441456", "Glenurquhart",
"4412292", "Barrow\-in\-Furness",
"441248", "Bangor\ \(Gwynedd\)",
"441934", "Weston\-super\-Mare",
"441919", "Durham",
"4415394", "Hawkshead",
"4419755", "Alford\ \(Aberdeen\)",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441708", "Romford",
"441242", "Cheltenham",
"4418515", "Stornoway",
"441547", "Knighton",
"4414232", "Harrogate",
"441534", "Jersey",
"441824", "Ruthin",
"441387", "Dumfries",
"442845", "Northern\ Ireland",
"4419643", "Patrington",
"44286", "Northern\ Ireland",
"441355", "East\ Kilbride",
"441367", "Faringdon",
"441304", "Dover",
"441526", "Martin",
"441442", "Hemel\ Hempstead",
"441911", "Tyneside\/Durham\/Sunderland",
"441293", "Crawley",
"441875", "Tranent",
"441364", "Ashburton",
"441307", "Forfar",
"441432", "Hereford",
"441440", "Haverhill",
"441951", "Colonsay",
"441659", "Sanquhar",
"441788", "Rugby",
"441429", "Hartlepool",
"441777", "Retford",
"441553", "Kings\ Lynn",
"441725", "Rockbourne",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441768", "Penrith",
"441651", "Oldmeldrum",
"442883", "Northern\ Ireland",
"441959", "Westerham",
"44114705", "Sheffield",
"441827", "Tamworth",
"441384", "Dudley",
"4418907", "Ayton",
"441858", "Market\ Harborough",
"441493", "Great\ Yarmouth",
"44280", "Northern\ Ireland",
"441544", "Kington",
"44151", "Liverpool",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([25-8]\d{5})$|0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;