/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_Updater({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.util.Observable","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><strong>Ext.Updater</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/UpdateManager.html#Ext-Updater' target='_blank'>UpdateManager.js</a></div></pre><div class='doc-contents'><p>Provides AJAX-style update capabilities for Element objects.  Updater can be used to <a href=\"#!/api/Ext.Updater-event-update\" rel=\"Ext.Updater-event-update\" class=\"docClass\">update</a>\nan <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> once, or you can use <a href=\"#!/api/Ext.Updater-method-startAutoRefresh\" rel=\"Ext.Updater-method-startAutoRefresh\" class=\"docClass\">startAutoRefresh</a> to set up an auto-updating\n<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a> on a specific interval.<br><br>\nUsage:<br></p>\n\n<pre><code>var el = <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>(\"foo\"); // Get <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> object\nvar mgr = el.getUpdater();\nmgr.update({\n        url: \"http://myserver.com/index.php\",\n        params: {\n            param1: \"foo\",\n            param2: \"bar\"\n        }\n});\n...\nmgr.formUpdate(\"myFormId\", \"http://myserver.com/index.php\");\n<br>\n// or directly (returns the same Updater instance)\nvar mgr = new <a href=\"#!/api/Ext.Updater\" rel=\"Ext.Updater\" class=\"docClass\">Ext.Updater</a>(\"myElementId\");\nmgr.startAutoRefresh(60, \"http://myserver.com/index.php\");\nmgr.on(\"update\", myFcnNeedsToKnow);\n<br>\n// short handed call directly from the element object\n<a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>(\"foo\").load({\n        url: \"bar.php\",\n        scripts: true,\n        params: \"param1=foo&amp;param2=bar\",\n        text: \"Loading Foo...\"\n});\n</code></pre>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-listeners' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-defaultUrl' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-defaultUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-defaultUrl' class='name expandable'>defaultUrl</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Cached url to use for refreshes. ...</div><div class='long'><p>Cached url to use for refreshes. Overwritten every time update() is called unless \"discardUrl\" param is set to true.</p>\n</div></div></div><div id='property-disableCaching' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-disableCaching' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-disableCaching' class='name not-expandable'>disableCaching</a><span> : Boolean</span></div><div class='description'><div class='short'><p>Whether to append unique parameter on get request to disable caching (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-disableCaching\" rel=\"Ext.Updater.defaults-property-disableCaching\" class=\"docClass\">Ext.Updater.defaults.disableCaching</a>).</p>\n</div><div class='long'><p>Whether to append unique parameter on get request to disable caching (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-disableCaching\" rel=\"Ext.Updater.defaults-property-disableCaching\" class=\"docClass\">Ext.Updater.defaults.disableCaching</a>).</p>\n</div></div></div><div id='property-el' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-el' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-el' class='name not-expandable'>el</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'><p>The Element object</p>\n</div><div class='long'><p>The Element object</p>\n</div></div></div><div id='property-formUpdateDelegate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-formUpdateDelegate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-formUpdateDelegate' class='name expandable'>formUpdateDelegate</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>Delegate for formUpdate() prebound to \"this\", use myUpdater.formUpdateDelegate.createCallback(arg1, arg2) to bind arg...</div><div class='long'><p>Delegate for formUpdate() prebound to \"this\", use myUpdater.formUpdateDelegate.createCallback(arg1, arg2) to bind arguments</p>\n</div></div></div><div id='property-indicatorText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-indicatorText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-indicatorText' class='name not-expandable'>indicatorText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>Text for loading indicator (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-indicatorText\" rel=\"Ext.Updater.defaults-property-indicatorText\" class=\"docClass\">Ext.Updater.defaults.indicatorText</a>).</p>\n</div><div class='long'><p>Text for loading indicator (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-indicatorText\" rel=\"Ext.Updater.defaults-property-indicatorText\" class=\"docClass\">Ext.Updater.defaults.indicatorText</a>).</p>\n</div></div></div><div id='property-loadScripts' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-loadScripts' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-loadScripts' class='name not-expandable'>loadScripts</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True to process scripts in the output (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-loadScripts\" rel=\"Ext.Updater.defaults-property-loadScripts\" class=\"docClass\">Ext.Updater.defaults.loadScripts</a>).</p>\n</div><div class='long'><p>True to process scripts in the output (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-loadScripts\" rel=\"Ext.Updater.defaults-property-loadScripts\" class=\"docClass\">Ext.Updater.defaults.loadScripts</a>).</p>\n</div></div></div><div id='property-refreshDelegate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-refreshDelegate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-refreshDelegate' class='name not-expandable'>refreshDelegate</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'><p>Delegate for refresh() prebound to \"this\", use myUpdater.refreshDelegate.createCallback(arg1, arg2) to bind arguments</p>\n</div><div class='long'><p>Delegate for refresh() prebound to \"this\", use myUpdater.refreshDelegate.createCallback(arg1, arg2) to bind arguments</p>\n</div></div></div><div id='property-renderer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-renderer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-renderer' class='name not-expandable'>renderer</a><span> : Object</span></div><div class='description'><div class='short'><p>The renderer for this Updater (defaults to <a href=\"#!/api/Ext.Updater.BasicRenderer\" rel=\"Ext.Updater.BasicRenderer\" class=\"docClass\">Ext.Updater.BasicRenderer</a>).</p>\n</div><div class='long'><p>The renderer for this Updater (defaults to <a href=\"#!/api/Ext.Updater.BasicRenderer\" rel=\"Ext.Updater.BasicRenderer\" class=\"docClass\">Ext.Updater.BasicRenderer</a>).</p>\n</div></div></div><div id='property-showLoadIndicator' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-showLoadIndicator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-showLoadIndicator' class='name not-expandable'>showLoadIndicator</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>Whether to show indicatorText when loading (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-showLoadIndicator\" rel=\"Ext.Updater.defaults-property-showLoadIndicator\" class=\"docClass\">Ext.Updater.defaults.showLoadIndicator</a>).</p>\n</div><div class='long'><p>Whether to show indicatorText when loading (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-showLoadIndicator\" rel=\"Ext.Updater.defaults-property-showLoadIndicator\" class=\"docClass\">Ext.Updater.defaults.showLoadIndicator</a>).</p>\n</div></div></div><div id='property-sslBlankUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-sslBlankUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-sslBlankUrl' class='name not-expandable'>sslBlankUrl</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>Blank page URL to use with SSL file uploads (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-sslBlankUrl\" rel=\"Ext.Updater.defaults-property-sslBlankUrl\" class=\"docClass\">Ext.Updater.defaults.sslBlankUrl</a>).</p>\n</div><div class='long'><p>Blank page URL to use with SSL file uploads (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-sslBlankUrl\" rel=\"Ext.Updater.defaults-property-sslBlankUrl\" class=\"docClass\">Ext.Updater.defaults.sslBlankUrl</a>).</p>\n</div></div></div><div id='property-timeout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-timeout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-timeout' class='name not-expandable'>timeout</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Timeout for requests or form posts in seconds (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-timeout\" rel=\"Ext.Updater.defaults-property-timeout\" class=\"docClass\">Ext.Updater.defaults.timeout</a>).</p>\n</div><div class='long'><p>Timeout for requests or form posts in seconds (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-timeout\" rel=\"Ext.Updater.defaults-property-timeout\" class=\"docClass\">Ext.Updater.defaults.timeout</a>).</p>\n</div></div></div><div id='property-transaction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-transaction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-transaction' class='name not-expandable'>transaction</a><span> : Object</span></div><div class='description'><div class='short'><p>Transaction object of the current executing transaction, or null if there is no active transaction.</p>\n</div><div class='long'><p>Transaction object of the current executing transaction, or null if there is no active transaction.</p>\n</div></div></div><div id='property-updateDelegate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-property-updateDelegate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-property-updateDelegate' class='name not-expandable'>updateDelegate</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'><p>Delegate for update() prebound to \"this\", use myUpdater.updateDelegate.createCallback(arg1, arg2) to bind arguments</p>\n</div><div class='long'><p>Delegate for update() prebound to \"this\", use myUpdater.updateDelegate.createCallback(arg1, arg2) to bind arguments</p>\n</div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.Updater-method-constructor' class='name expandable'>Ext.Updater</a>( <span class='pre'>el, [forceNew]</span> ) : <a href=\"#!/api/Ext.Updater\" rel=\"Ext.Updater\" class=\"docClass\">Ext.Updater</a></div><div class='description'><div class='short'>Create new Updater directly. ...</div><div class='long'><p>Create new Updater directly.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The element to update</p>\n</div></li><li><span class='pre'>forceNew</span> : Boolean (optional)<div class='sub-desc'><p>By default the constructor checks to see if the passed element already\nhas an Updater and if it does it returns the same instance. This will skip that check (useful for extending this class).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Updater\" rel=\"Ext.Updater\" class=\"docClass\">Ext.Updater</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-abort' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-abort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-abort' class='name expandable'>abort</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Aborts the currently executing transaction, if any. ...</div><div class='long'><p>Aborts the currently executing transaction, if any.</p>\n</div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-formUpdate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-formUpdate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-formUpdate' class='name expandable'>formUpdate</a>( <span class='pre'>form, [url], [reset], [callback]</span> )</div><div class='description'><div class='short'>Performs an asynchronous form post, updating this element with the response. ...</div><div class='long'><p>Performs an asynchronous form post, updating this element with the response. If the form has the attribute\nenctype=\"<a href=\"http://www.faqs.org/rfcs/rfc2388.html\">multipart/form-data</a>\", it assumes it's a file upload.\nUses this.sslBlankUrl for SSL file uploads to prevent IE security warning.</p>\n\n\n<p>File uploads are not performed using normal \"Ajax\" techniques, that is they are <b>not</b>\nperformed using XMLHttpRequests. Instead the form is submitted in the standard manner with the\nDOM <code>&lt;form></code> element temporarily modified to have its\n<a href=\"http://www.w3.org/TR/REC-html40/present/frames.html#adef-target\">target</a> set to refer\nto a dynamically generated, hidden <code>&lt;iframe></code> which is inserted into the document\nbut removed after the return data has been gathered.</p>\n\n\n<p>Be aware that file upload packets, sent with the content type <a href=\"http://www.faqs.org/rfcs/rfc2388.html\">multipart/form-data</a>\nand some server technologies (notably JEE) may require some custom processing in order to\nretrieve parameter names and parameter values from the packet content.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>form</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'><p>The form Id or form element</p>\n</div></li><li><span class='pre'>url</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The url to pass the form to. If omitted the action attribute on the form will be used.</p>\n</div></li><li><span class='pre'>reset</span> : Boolean (optional)<div class='sub-desc'><p>Whether to try to reset the form after the update</p>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>Callback when transaction is complete. The following\nparameters are passed:<ul>\n<li><b>el</b> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><p class=\"sub-desc\">The Element being updated.</p></li>\n<li><b>success</b> : Boolean<p class=\"sub-desc\">True for success, false for failure.</p></li>\n<li><b>response</b> : XMLHttpRequest<p class=\"sub-desc\">The XMLHttpRequest which processed the update.</p></li></ul></p>\n</div></li></ul></div></div></div><div id='method-getDefaultRenderer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-getDefaultRenderer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-getDefaultRenderer' class='name expandable'>getDefaultRenderer</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>This is an overrideable method which returns a reference to a default\nrenderer class if none is specified when creati...</div><div class='long'><p>This is an overrideable method which returns a reference to a default\nrenderer class if none is specified when creating the <a href=\"#!/api/Ext.Updater\" rel=\"Ext.Updater\" class=\"docClass\">Ext.Updater</a>.\nDefaults to <a href=\"#!/api/Ext.Updater.BasicRenderer\" rel=\"Ext.Updater.BasicRenderer\" class=\"docClass\">Ext.Updater.BasicRenderer</a></p>\n</div></div></div><div id='method-getEl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-getEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-getEl' class='name expandable'>getEl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Get the Element this Updater is bound to ...</div><div class='long'><p>Get the Element this Updater is bound to</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The element</p>\n</div></li></ul></div></div></div><div id='method-getRenderer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-getRenderer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-getRenderer' class='name expandable'>getRenderer</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the current content renderer for this Updater. ...</div><div class='long'><p>Returns the current content renderer for this Updater. See <a href=\"#!/api/Ext.Updater.BasicRenderer-method-render\" rel=\"Ext.Updater.BasicRenderer-method-render\" class=\"docClass\">Ext.Updater.BasicRenderer.render</a> for more details.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-isAutoRefreshing' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-isAutoRefreshing' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-isAutoRefreshing' class='name expandable'>isAutoRefreshing</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Returns true if the Updater is currently set to auto refresh its content (see startAutoRefresh), otherwise false. ...</div><div class='long'><p>Returns true if the Updater is currently set to auto refresh its content (see <a href=\"#!/api/Ext.Updater-method-startAutoRefresh\" rel=\"Ext.Updater-method-startAutoRefresh\" class=\"docClass\">startAutoRefresh</a>), otherwise false.</p>\n</div></div></div><div id='method-isUpdating' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-isUpdating' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-isUpdating' class='name expandable'>isUpdating</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if an update is in progress, otherwise false. ...</div><div class='long'><p>Returns true if an update is in progress, otherwise false.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-refresh' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-refresh' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-refresh' class='name expandable'>refresh</a>( <span class='pre'>[callback]</span> )</div><div class='description'><div class='short'>Refresh the element with the last used url or defaultUrl. ...</div><div class='long'><p>Refresh the element with the last used url or defaultUrl. If there is no url, it returns immediately</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>Callback when transaction is complete - called with signature (oElement, bSuccess)</p>\n</div></li></ul></div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-setDefaultUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-setDefaultUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-setDefaultUrl' class='name expandable'>setDefaultUrl</a>( <span class='pre'>defaultUrl</span> )</div><div class='description'><div class='short'>Sets the default URL used for updates. ...</div><div class='long'><p>Sets the default URL used for updates.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>defaultUrl</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The url or a function to call to get the url</p>\n</div></li></ul></div></div></div><div id='method-setRenderer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-setRenderer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-setRenderer' class='name expandable'>setRenderer</a>( <span class='pre'>renderer</span> )</div><div class='description'><div class='short'>Sets the content renderer for this Updater. ...</div><div class='long'><p>Sets the content renderer for this Updater. See <a href=\"#!/api/Ext.Updater.BasicRenderer-method-render\" rel=\"Ext.Updater.BasicRenderer-method-render\" class=\"docClass\">Ext.Updater.BasicRenderer.render</a> for more details.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>renderer</span> : Object<div class='sub-desc'><p>The object implementing the render() method</p>\n</div></li></ul></div></div></div><div id='method-showLoading' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-showLoading' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-showLoading' class='name expandable'>showLoading</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Display the element's \"loading\" state. ...</div><div class='long'><p>Display the element's \"loading\" state. By default, the element is updated with <a href=\"#!/api/Ext.Updater-property-indicatorText\" rel=\"Ext.Updater-property-indicatorText\" class=\"docClass\">indicatorText</a>. This\nmethod may be overridden to perform a custom action while this Updater is actively updating its contents.</p>\n</div></div></div><div id='method-startAutoRefresh' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-startAutoRefresh' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-startAutoRefresh' class='name expandable'>startAutoRefresh</a>( <span class='pre'>interval, [url], [params], [callback], [refreshNow]</span> )</div><div class='description'><div class='short'>Set this element to auto refresh. ...</div><div class='long'><p>Set this element to auto refresh.  Can be canceled by calling <a href=\"#!/api/Ext.Updater-method-stopAutoRefresh\" rel=\"Ext.Updater-method-stopAutoRefresh\" class=\"docClass\">stopAutoRefresh</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>interval</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>How often to update (in seconds).</p>\n</div></li><li><span class='pre'>url</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>The url for this request, a config object in the same format\nsupported by load, or a function to call to get the url (defaults to the last used url).  Note that while\nthe url used in a load call can be reused by this method, other load config options will not be reused and must be\nsepcified as part of a config object passed as this paramter if needed.</p>\n</div></li><li><span class='pre'>params</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object (optional)<div class='sub-desc'><p>The parameters to pass as either a url encoded string\n\"&amp;param1=1&amp;param2=2\" or as an object {param1: 1, param2: 2}</p>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>Callback when transaction is complete - called with signature (oElement, bSuccess)</p>\n</div></li><li><span class='pre'>refreshNow</span> : Boolean (optional)<div class='sub-desc'><p>Whether to execute the refresh now, or wait the interval</p>\n</div></li></ul></div></div></div><div id='method-stopAutoRefresh' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-stopAutoRefresh' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-stopAutoRefresh' class='name expandable'>stopAutoRefresh</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Stop auto refresh on this element. ...</div><div class='long'><p>Stop auto refresh on this element.</p>\n</div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-update' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-method-update' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-method-update' class='name expandable'>update</a>( <span class='pre'>options</span> )</div><div class='description'><div class='short'>Performs an asynchronous request, updating this element with the response. ...</div><div class='long'><p>Performs an <b>asynchronous</b> request, updating this element with the response.\nIf params are specified it uses POST, otherwise it uses GET.<br><br>\n<b>Note:</b> Due to the asynchronous nature of remote server requests, the Element\nwill not have been fully updated when the function returns. To post-process the returned\ndata, use the callback option, or an <b><code>update</code></b> event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>A config object containing any of the following options:<ul>\n<li>url : <b>String/Function</b><p class=\"sub-desc\">The URL to request or a function which\n<i>returns</i> the URL (defaults to the value of <a href=\"#!/api/Ext.Ajax-property-url\" rel=\"Ext.Ajax-property-url\" class=\"docClass\">Ext.Ajax.url</a> if not specified).</p></li>\n<li>method : <b>String</b><p class=\"sub-desc\">The HTTP method to\nuse. Defaults to POST if the <code>params</code> argument is present, otherwise GET.</p></li>\n<li>params : <b>String/Object/Function</b><p class=\"sub-desc\">The\nparameters to pass to the server (defaults to none). These may be specified as a url-encoded\nstring, or as an object containing properties which represent parameters,\nor as a function, which returns such an object.</p></li>\n<li>scripts : <b>Boolean</b><p class=\"sub-desc\">If <code>true</code>\nany &lt;script&gt; tags embedded in the response text will be extracted\nand executed (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-loadScripts\" rel=\"Ext.Updater.defaults-property-loadScripts\" class=\"docClass\">Ext.Updater.defaults.loadScripts</a>). If this option is specified,\nthe callback will be called <i>after</i> the execution of the scripts.</p></li>\n<li>callback : <b>Function</b><p class=\"sub-desc\">A function to\nbe called when the response from the server arrives. The following\nparameters are passed:<ul>\n<li><b>el</b> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><p class=\"sub-desc\">The Element being updated.</p></li>\n<li><b>success</b> : Boolean<p class=\"sub-desc\">True for success, false for failure.</p></li>\n<li><b>response</b> : XMLHttpRequest<p class=\"sub-desc\">The XMLHttpRequest which processed the update.</p></li>\n<li><b>options</b> : Object<p class=\"sub-desc\">The config object passed to the update call.</p></li></ul>\n</p></li>\n<li>scope : <b>Object</b><p class=\"sub-desc\">The scope in which\nto execute the callback (The callback's <code>this</code> reference.) If the\n<code>params</code> argument is a function, this scope is used for that function also.</p></li>\n<li>discardUrl : <b>Boolean</b><p class=\"sub-desc\">By default, the URL of this request becomes\nthe default URL for this Updater object, and will be subsequently used in <a href=\"#!/api/Ext.Updater-method-refresh\" rel=\"Ext.Updater-method-refresh\" class=\"docClass\">refresh</a>\ncalls.  To bypass this behavior, pass <code>discardUrl:true</code> (defaults to false).</p></li>\n<li>timeout : <b>Number</b><p class=\"sub-desc\">The number of seconds to wait for a response before\ntiming out (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-timeout\" rel=\"Ext.Updater.defaults-property-timeout\" class=\"docClass\">Ext.Updater.defaults.timeout</a>).</p></li>\n<li>text : <b>String</b><p class=\"sub-desc\">The text to use as the innerHTML of the\n<a href=\"#!/api/Ext.Updater.defaults-property-indicatorText\" rel=\"Ext.Updater.defaults-property-indicatorText\" class=\"docClass\">Ext.Updater.defaults.indicatorText</a> div (defaults to 'Loading...').  To replace the entire div, not\njust the text, override <a href=\"#!/api/Ext.Updater.defaults-property-indicatorText\" rel=\"Ext.Updater.defaults-property-indicatorText\" class=\"docClass\">Ext.Updater.defaults.indicatorText</a> directly.</p></li>\n<li>nocache : <b>Boolean</b><p class=\"sub-desc\">Only needed for GET\nrequests, this option causes an extra, auto-generated parameter to be appended to the request\nto defeat caching (defaults to <a href=\"#!/api/Ext.Updater.defaults-property-disableCaching\" rel=\"Ext.Updater.defaults-property-disableCaching\" class=\"docClass\">Ext.Updater.defaults.disableCaching</a>).</p></li></ul></p>\n\n<p>\nFor example:\n    \n<pre><code>    um.update({\n        url: \"your-url.php\",\n        params: {param1: \"foo\", param2: \"bar\"}, // or a URL encoded string\n        callback: yourFunction,\n        scope: yourObject, //(optional scope)\n        discardUrl: true,\n        nocache: true,\n        text: \"Loading...\",\n        timeout: 60,\n        scripts: false // Save time by avoiding RegExp execution.\n    });\n    </code></pre>\n\n</p></div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-updateElement' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-static-method-updateElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-static-method-updateElement' class='name expandable'>updateElement</a>( <span class='pre'>el, url, [params], [options]</span> )<strong class='deprecated signature' >deprecated</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Static convenience method. ...</div><div class='long'><p>Static convenience method. <b>This method is deprecated in favor of el.load({url:'foo.php', ...})</b>.\nUsage:</p>\n\n<pre><code><a href=\"#!/api/Ext.Updater-static-method-updateElement\" rel=\"Ext.Updater-static-method-updateElement\" class=\"docClass\">Ext.Updater.updateElement</a>(\"my-div\", \"stuff.php\");</code></pre>\n\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        \n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The element to update</p>\n</div></li><li><span class='pre'>url</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The url</p>\n</div></li><li><span class='pre'>params</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object (optional)<div class='sub-desc'><p>Url encoded param string or an object of name/value pairs</p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>A config object with any of the Updater properties you want to set - for\nexample: {disableCaching:true, indicatorText: \"Loading data...\"}</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-beforeupdate' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-event-beforeupdate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-event-beforeupdate' class='name expandable'>beforeupdate</a>( <span class='pre'>el, url, params</span> )</div><div class='description'><div class='short'>Fired before an update is made, return false from your handler and the update is cancelled. ...</div><div class='long'><p>Fired before an update is made, return false from your handler and the update is cancelled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'>\n</div></li><li><span class='pre'>url</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-failure' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-event-failure' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-event-failure' class='name expandable'>failure</a>( <span class='pre'>el, oResponseObject</span> )</div><div class='description'><div class='short'>Fired on update failure. ...</div><div class='long'><p>Fired on update failure.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'>\n</div></li><li><span class='pre'>oResponseObject</span> : Object<div class='sub-desc'><p>The response Object</p>\n</div></li></ul></div></div></div><div id='event-update' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Updater'>Ext.Updater</span><br/><a href='source/UpdateManager.html#Ext-Updater-event-update' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Updater-event-update' class='name expandable'>update</a>( <span class='pre'>el, oResponseObject</span> )</div><div class='description'><div class='short'>Fired after successful update is made. ...</div><div class='long'><p>Fired after successful update is made.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'>\n</div></li><li><span class='pre'>oResponseObject</span> : Object<div class='sub-desc'><p>The response Object</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[{"tagname":"method","owner":"Ext.Updater","meta":{"static":true,"deprecated":{"text":""}},"name":"updateElement","id":"static-method-updateElement"}],"event":[],"css_mixin":[]},"files":[{"href":"UpdateManager.html#Ext-Updater","filename":"UpdateManager.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"defaultUrl","id":"property-defaultUrl"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"disableCaching","id":"property-disableCaching"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"el","id":"property-el"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"formUpdateDelegate","id":"property-formUpdateDelegate"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"indicatorText","id":"property-indicatorText"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"loadScripts","id":"property-loadScripts"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"refreshDelegate","id":"property-refreshDelegate"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"renderer","id":"property-renderer"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"showLoadIndicator","id":"property-showLoadIndicator"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"sslBlankUrl","id":"property-sslBlankUrl"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"timeout","id":"property-timeout"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"transaction","id":"property-transaction"},{"tagname":"property","owner":"Ext.Updater","meta":{},"name":"updateDelegate","id":"property-updateDelegate"}],"cfg":[{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"abort","id":"method-abort"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"formUpdate","id":"method-formUpdate"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"getDefaultRenderer","id":"method-getDefaultRenderer"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"getEl","id":"method-getEl"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"getRenderer","id":"method-getRenderer"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"isAutoRefreshing","id":"method-isAutoRefreshing"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"isUpdating","id":"method-isUpdating"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"refresh","id":"method-refresh"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"setDefaultUrl","id":"method-setDefaultUrl"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"setRenderer","id":"method-setRenderer"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"showLoading","id":"method-showLoading"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"startAutoRefresh","id":"method-startAutoRefresh"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"stopAutoRefresh","id":"method-stopAutoRefresh"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"},{"tagname":"method","owner":"Ext.Updater","meta":{},"name":"update","id":"method-update"}],"event":[{"tagname":"event","owner":"Ext.Updater","meta":{},"name":"beforeupdate","id":"event-beforeupdate"},{"tagname":"event","owner":"Ext.Updater","meta":{},"name":"failure","id":"event-failure"},{"tagname":"event","owner":"Ext.Updater","meta":{},"name":"update","id":"event-update"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.Updater","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.Updater","mixins":[],"mixedInto":[]});