#
# This file is part of Task-POE-All
#
# This software is copyright (c) 2014 by Apocalypse.
#
# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
#
use strict; use warnings;
package Task::POE::All;
# git description: 59474b3
$Task::POE::All::VERSION = '1.100';
our $AUTHORITY = 'cpan:APOCAL';

# ABSTRACT: All of POE on CPAN

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Task::POE::All - All of POE on CPAN

=head1 VERSION

version 1.100

=head1 SYNOPSIS

	die 'Not meant to be used directly';

=head1 DESCRIPTION

This task contains all distributions under the L<POE> namespace.

=head1 TASK CONTENTS

=head2 Servers
=pkg POE::Component::Server::Bayeux 0.04
=pkg POE::Component::Server::BigBrother 0.08
=pkg POE::Component::Server::Chargen 1.14
=pkg POE::Component::Server::DNS 0.30
=pkg POE::Component::Server::Daytime 1.14
=pkg POE::Component::Server::Discard 1.14
=pkg POE::Component::Server::Echo 1.64
=pkg POE::Component::Server::FTP 0.08
=pkg POE::Component::Server::HTTP 0.09
=pkg POE::Component::Server::HTTP::KeepAlive 0.0307
=pkg POE::Component::Server::HTTPServer 0.009002
=pkg POE::Component::Server::IRC 1.54
=pkg POE::Component::Server::Ident 1.16
=pkg POE::Component::Server::Inet 0.06
=pkg POE::Component::Server::JSONRPC 0.05
=pkg POE::Component::Server::MySQL 0.02
=pkg POE::Component::Server::NNTP 1.04
=pkg POE::Component::Server::NRPE 0.18
=pkg POE::Component::Server::NSCA 0.08
=pkg POE::Component::Server::POP3 0.10
=pkg POE::Component::Server::PSGI 0.6
=pkg POE::Component::Server::Postfix 0.001
=pkg POE::Component::Server::PreforkTCP 0.11
=pkg POE::Component::Server::Qotd 1.14
=pkg POE::Component::Server::RADIUS 1.08
=pkg POE::Component::Server::SOAP 1.14
=pkg POE::Component::Server::SimpleContent 1.14
=pkg POE::Component::Server::SimpleHTTP 2.18
=pkg POE::Component::Server::SimpleHTTP::PreFork 2.10
=pkg POE::Component::Server::SimpleSMTP 1.50
=pkg POE::Component::Server::SimpleXMLRPC 0.02
=pkg POE::Component::Server::Syslog 1.20
=pkg POE::Component::Server::TacacsPlus 1.11
=pkg POE::Component::Server::Time 1.14
=pkg POE::Component::Server::Twirc 0.17
=pkg POE::Component::Server::XMLRPC 0.05
=pkg POE::Component::Server::eris 1.8

=head2 Clients
=pkg POE::Component::Client::AMQP 0.03
=pkg POE::Component::Client::AirTunes 0.01
=pkg POE::Component::Client::BigBrother 1.00
=pkg POE::Component::Client::CouchDB 0.05
=pkg POE::Component::Client::DNS 1.053
=pkg POE::Component::Client::DNS::Recursive 1.08
=pkg POE::Component::Client::DNSBL 1.08
=pkg POE::Component::Client::FTP 0.22
=pkg POE::Component::Client::Feed 0.901
=pkg POE::Component::Client::HTTPDeferred 0.02
=pkg POE::Component::Client::Halo 0.2
=pkg POE::Component::Client::Icecast 0.6
=pkg POE::Component::Client::Ident 1.16
=pkg POE::Component::Client::Keepalive 0.272
=pkg POE::Component::Client::LDAP 0.04
=pkg POE::Component::Client::Lingr 0.04
=pkg POE::Component::Client::MPD 2.000
=pkg POE::Component::Client::MSN 0.03
=pkg POE::Component::Client::MogileFS 0.02
=pkg POE::Component::Client::NNTP 2.22
=pkg POE::Component::Client::NNTP::Tail 0.03
=pkg POE::Component::Client::NRPE 0.20
=pkg POE::Component::Client::NSCA 0.16
=pkg POE::Component::Client::NTP 0.10
=pkg POE::Component::Client::POP3 0.02
=pkg POE::Component::Client::Pastebot 1.16
=pkg POE::Component::Client::Ping 1.174
=pkg POE::Component::Client::RADIUS 1.04
=pkg POE::Component::Client::Rcon 0.23
=pkg POE::Component::Client::SMTP 0.22
=pkg POE::Component::Client::SOAP 0.01
=pkg POE::Component::Client::SOCKS 1.00
=pkg POE::Component::Client::SimpleFTP 0.003
=pkg POE::Component::Client::Stomp 0.12
=pkg POE::Component::Client::Stomp::Utils 0.02
=pkg POE::Component::Client::TCPMulti 0.0524
=pkg POE::Component::Client::Telnet 0.06
=pkg POE::Component::Client::Traceroute 0.21
=pkg POE::Component::Client::Twitter 0.01
=pkg POE::Component::Client::UserAgent 0.08
=pkg POE::Component::Client::Whois 1.30
=pkg POE::Component::Client::Whois::Smart 0.187
=pkg POE::Component::Client::eris 1.4
=pkg POE::Component::Client::opentick 0.21

=head2 Generic Components
=pkg POE::Component::AI::MegaHAL 1.18
=pkg POE::Component::AIO 1.00
=pkg POE::Component::Algorithm::Evolutionary 0.002001
=pkg POE::Component::Amazon::S3 0.01
=pkg POE::Component::Archive::Any 0.002
=pkg POE::Component::AssaultCube::ServerQuery 0.04
=pkg POE::Component::AtomAggregator 1.0
=pkg POE::Component::Basement 0.01
=pkg POE::Component::BlogCloud 0.01
=pkg POE::Component::Bundle::WebDevelopment 1.001004
=pkg POE::Component::CD::Detect 1.1
=pkg POE::Component::CD::Rip 1.2
=pkg POE::Component::CPAN::Mirror::Multiplexer 0.04
=pkg POE::Component::CPAN::Reporter 0.06
=pkg POE::Component::CPAN::SQLite::Info 0.11
=pkg POE::Component::CPAN::YACSmoke 1.36
=pkg POE::Component::CPANIDX 0.10
=pkg POE::Component::CPANPLUS::YACSmoke 1.62
=pkg POE::Component::Cache 0.001001
=pkg POE::Component::Captcha::reCAPTCHA 0.02
=pkg POE::Component::Child 1.39
=pkg POE::Component::ControlPort 1.0266
=pkg POE::Component::Cron 0.021
=pkg POE::Component::Curl::Multi 0.10
=pkg POE::Component::Curses 0.211
=pkg POE::Component::DBIAgent 0.26
=pkg POE::Component::DHCP::Monitor 1.04
=pkg POE::Component::Daemon 0.1400
=pkg POE::Component::Daemon::Win32 0.01
=pkg POE::Component::DebugShell 1.412
=pkg POE::Component::DebugShell::Jabber 0.04
=pkg POE::Component::DirWatch 0.300001
=pkg POE::Component::DirWatch::Object 0.10
=pkg POE::Component::EasyDBI 1.24
=pkg POE::Component::Enc::Flac 1.01
=pkg POE::Component::Enc::Mp3 1.2
=pkg POE::Component::Enc::Ogg 1.05
=pkg POE::Component::FeedAggregator 0.902
=pkg POE::Component::Fuse 0.05
=pkg POE::Component::Gearman::Client 0.03
=pkg POE::Component::Generic 0.1403
=pkg POE::Component::Github 0.08
=pkg POE::Component::Growl 1.00
=pkg POE::Component::Hailo 0.10
=pkg POE::Component::ICal 0.130020
=pkg POE::Component::IKC 0.2402
=pkg POE::Component::IRC 6.88
=pkg POE::Component::IRC::Object 0.02
=pkg POE::Component::IRC::Plugin::BaseWrap 1.001001
=pkg POE::Component::IRC::Plugin::Blowfish 0.01
=pkg POE::Component::IRC::Plugin::Bollocks 1.00
=pkg POE::Component::IRC::Plugin::CPAN::Info 1.001002
=pkg POE::Component::IRC::Plugin::ColorNamer 2.001003
=pkg POE::Component::IRC::Plugin::CoreList 1.02
=pkg POE::Component::IRC::Plugin::Donuts 0.07
=pkg POE::Component::IRC::Plugin::Eval 0.07
=pkg POE::Component::IRC::Plugin::FTP::EasyUpload 0.002
=pkg POE::Component::IRC::Plugin::Google::Calculator 0.04
=pkg POE::Component::IRC::Plugin::Hailo 0.18
=pkg POE::Component::IRC::Plugin::Hello 0.001002
=pkg POE::Component::IRC::Plugin::IRCDHelp 0.01
=pkg POE::Component::IRC::Plugin::ImageMirror 0.15
=pkg POE::Component::IRC::Plugin::Infobot 0.001002
=pkg POE::Component::IRC::Plugin::Karma 0.003
=pkg POE::Component::IRC::Plugin::Logger::Irssi 0.001002
=pkg POE::Component::IRC::Plugin::MegaHAL 0.46
=pkg POE::Component::IRC::Plugin::MultiProxy 0.01
=pkg POE::Component::IRC::Plugin::OutputToPastebin 0.002
=pkg POE::Component::IRC::Plugin::POE::Knee 1.08
=pkg POE::Component::IRC::Plugin::QueryDNS 1.04
=pkg POE::Component::IRC::Plugin::QueryDNSBL 1.04
=pkg POE::Component::IRC::Plugin::RSS::Headlines 1.08
=pkg POE::Component::IRC::Plugin::RTorrentStatus 0.17
=pkg POE::Component::IRC::Plugin::Role 0.06
=pkg POE::Component::IRC::Plugin::Seen 0.001001
=pkg POE::Component::IRC::Plugin::Thanks 1.001001
=pkg POE::Component::IRC::Plugin::Trac::RSS 0.11
=pkg POE::Component::IRC::Plugin::URI::Find 1.10
=pkg POE::Component::IRC::Plugin::Unicode::UCD 0.004
=pkg POE::Component::IRC::Plugin::WWW::CPANRatings::RSS 0.0106
=pkg POE::Component::IRC::Plugin::WWW::Google::Time 0.0102
=pkg POE::Component::IRC::Plugin::WWW::KrispyKreme::HotLight 0.06
=pkg POE::Component::IRC::Plugin::WWW::OhNoRobotCom::Search 0.002
=pkg POE::Component::IRC::Plugin::WWW::Reddit::TIL 0.07
=pkg POE::Component::IRC::Plugin::WWW::Vim::Tips 0.14
=pkg POE::Component::IRC::Plugin::WWW::Weather::US 0.04
=pkg POE::Component::IRC::Plugin::WWW::XKCD::AsText 0.003
=pkg POE::Component::IRC::Plugin::WubWubWub 0.1
=pkg POE::Component::Jabber 3.00
=pkg POE::Component::JobQueue 0.571
=pkg POE::Component::LaDBI 1.002001
=pkg POE::Component::Lightspeed 0.05
=pkg POE::Component::Lingua::Translate 0.06
=pkg POE::Component::Log4perl 0.03
=pkg POE::Component::Logger 1.10
=pkg POE::Component::MXML 0.03
=pkg POE::Component::MessageQueue 0.3001
=pkg POE::Component::Metabase::Client::Submit 0.12
=pkg POE::Component::Metabase::Relay::Server 0.34
=pkg POE::Component::Net::FTP 0.001
=pkg POE::Component::Net::LastFM::Submission 0.24
=pkg POE::Component::NetSNMP::agent 0.500
=pkg POE::Component::NomadJukebox 0.02
=pkg POE::Component::NonBlockingWrapper::Base 0.002
=pkg POE::Component::OSCAR 0.05
=pkg POE::Component::Omegle 0.02
=pkg POE::Component::OpenSSH 0.10
=pkg POE::Component::Pastebin::Create 0.0
=pkg POE::Component::Pcap 0.04
=pkg POE::Component::Player::Mpg123 1.2
=pkg POE::Component::Player::Musicus 1.32
=pkg POE::Component::Player::Slideshow 1.4
=pkg POE::Component::Player::Xmms 0.04
=pkg POE::Component::Pluggable 1.26
=pkg POE::Component::PluginManager 0.67
=pkg POE::Component::Pool::DBI 0.014
=pkg POE::Component::Pool::Thread 0.015
=pkg POE::Component::PreforkDispatch 0.101
=pkg POE::Component::ProcTerminator 0.03
=pkg POE::Component::Proxy::MySQL 0.04
=pkg POE::Component::Proxy::SOCKS 1.02
=pkg POE::Component::Proxy::TCP 1.2
=pkg POE::Component::RSS 3.01
=pkg POE::Component::RSSAggregator 1.11
=pkg POE::Component::RemoteTail 0.01011
=pkg POE::Component::Rendezvous::Publish 0.01
=pkg POE::Component::Resolver 0.921
=pkg POE::Component::ResourcePool 0.04
=pkg POE::Component::ResourcePool::Resource::TokenBucket 0.01
=pkg POE::Component::SASLAuthd 0.03
=pkg POE::Component::SNMP::Session 0.1202
=pkg POE::Component::SSLify 1.008
=pkg POE::Component::SSLify::NonBlock 0.41
=pkg POE::Component::Schedule 0.95
=pkg POE::Component::Sequence 0.02
=pkg POE::Component::SimpleDBI 1.30
=pkg POE::Component::SimpleLog 1.05
=pkg POE::Component::SmokeBox 0.48
=pkg POE::Component::SmokeBox::Backend::Test::SmokeBox::Mini 0.58
=pkg POE::Component::SmokeBox::Dists 1.08
=pkg POE::Component::SmokeBox::Recent 1.46
=pkg POE::Component::SmokeBox::Uploads::CPAN::Mini 1.00
=pkg POE::Component::SmokeBox::Uploads::NNTP 1.00
=pkg POE::Component::SmokeBox::Uploads::RSS 1.00
=pkg POE::Component::SmokeBox::Uploads::Rsync 1.000
=pkg POE::Component::SubWrapper 2.01
=pkg POE::Component::Supervisor 0.08
=pkg POE::Component::Syndicator 0.06
=pkg POE::Component::TFTPd 0.0302
=pkg POE::Component::TSTP 0.02
=pkg POE::Component::Telephony::CTPort 0.03
=pkg POE::Component::UserBase 0.09
=pkg POE::Component::WWW::CPANRatings::RSS 0.0101
=pkg POE::Component::WWW::DoingItWrongCom::RandImage 0.03
=pkg POE::Component::WWW::Google::Calculator 0.03
=pkg POE::Component::WWW::Google::Time 0.0102
=pkg POE::Component::WWW::OhNoRobotCom::Search 0.002
=pkg POE::Component::WWW::Pastebin::Bot::Pastebot::Create 0.003
=pkg POE::Component::WWW::Pastebin::Many::Retrieve 0.001
=pkg POE::Component::WWW::Shorten 1.20
=pkg POE::Component::WWW::XKCD::AsText 0.002
=pkg POE::Component::WakeOnLAN 1.04
=pkg POE::Component::Win32::ChangeNotify 1.22
=pkg POE::Component::Win32::EventLog 1.24
=pkg POE::Component::Win32::Service 1.24
=pkg POE::Component::XUL 0.02
=pkg POE::Component::YahooMessenger 0.05
=pkg POE::Component::YubiAuth 0.07

=head2 Data Parsers and Wheels
=pkg POE::Filter::Asterisk::Manager 0.08
=pkg POE::Filter::BigBrother 0.13
=pkg POE::Filter::Bzip2 1.58
=pkg POE::Filter::CSV 1.16
=pkg POE::Filter::CSV_XS 1.16
=pkg POE::Filter::DHCPd::Lease 0.0703
=pkg POE::Filter::DNS::TCP 0.06
=pkg POE::Filter::ErrorProof 0.01
=pkg POE::Filter::FSSocket 0.07
=pkg POE::Filter::FastCGI 0.19
=pkg POE::Filter::Finger 0.08
=pkg POE::Filter::HTTP::Parser 1.06
=pkg POE::Filter::HTTPD::Chunked 0.9
=pkg POE::Filter::HTTPHead 0.949
=pkg POE::Filter::Hessian 1.00
=pkg POE::Filter::IASLog 1.08
=pkg POE::Filter::IRC::Hybrid 0.996
=pkg POE::Filter::IRCD 2.44
=pkg POE::Filter::IRCv3 1.001001
=pkg POE::Filter::JSON 0.04
=pkg POE::Filter::JSON::Incr 0.03
=pkg POE::Filter::KennySpeak 1.02
=pkg POE::Filter::LOLCAT 1.10
=pkg POE::Filter::LZF 1.70
=pkg POE::Filter::LZO 1.70
=pkg POE::Filter::LZW 1.72
=pkg POE::Filter::LZW::Progressive 0.1
=pkg POE::Filter::Log::IPTables 0.02
=pkg POE::Filter::Log::Procmail 0.03
=pkg POE::Filter::Ls 0.01
=pkg POE::Filter::PPPHDLC 0.01
=pkg POE::Filter::ParseWords 1.06
=pkg POE::Filter::Postfix 0.003
=pkg POE::Filter::RecDescent 0.02
=pkg POE::Filter::Redis 0.02
=pkg POE::Filter::Regexp 1.0
=pkg POE::Filter::SMTP 1.2
=pkg POE::Filter::SSL 0.28
=pkg POE::Filter::SimpleHTTP 0.091710
=pkg POE::Filter::Slim::CLI 0.02
=pkg POE::Filter::Snort 0.031
=pkg POE::Filter::Spread 0.01
=pkg POE::Filter::SpreadClient 1.002
=pkg POE::Filter::Stomp 0.04
=pkg POE::Filter::Transparent::SMTP 0.2
=pkg POE::Filter::XML 1.140700
=pkg POE::Filter::XML::RPC 0.04
=pkg POE::Filter::Zlib 2.02
=pkg POE::Wheel::Audio::Mad 0.3
=pkg POE::Wheel::GnuPG 0.01
=pkg POE::Wheel::MyCurses 1.2102
=pkg POE::Wheel::Null 0.01
=pkg POE::Wheel::Run::Win32 0.18
=pkg POE::Wheel::Sendfile 0.0200
=pkg POE::Wheel::TermKey 0.02
=pkg POE::Wheel::UDP 0.02
=pkg POE::Wheel::VimColor 0.0

=head2 Event Loops
=pkg POE::Loop::AnyEvent 0.004
=pkg POE::Loop::EV 0.06
=pkg POE::Loop::Event 1.305
=pkg POE::Loop::Glib 0.038
=pkg POE::Loop::Gtk 1.306
=pkg POE::Loop::IO_Async 0.004
=pkg POE::Loop::Kqueue 0.02
=pkg POE::Loop::Prima 1.02
=pkg POE::Loop::Tk 1.305
=pkg POE::Loop::Wx 0.04

=head2 Session Types
=pkg POE::Session::Attribute 0.80
=pkg POE::Session::AttributeBased 0.10
=pkg POE::Session::GladeXML2 0.40
=pkg POE::Session::Irssi 0.50
=pkg POE::Session::MessageBased 0.111
=pkg POE::Session::MultiDispatch 1.3
=pkg POE::Session::Multiplex 0.0600
=pkg POE::Session::PlainCall 0.0301
=pkg POE::Session::YieldCC 0.202

=head2 Debugging and Developing POE
=pkg POE::API::Hooks 2.03
=pkg POE::API::Peek 2.20
=pkg POE::Devel::Benchmarker 0.05
=pkg POE::Devel::ProcAlike 0.02
=pkg POE::Devel::Profiler 0.02
=pkg POE::Devel::Top 0.100
=pkg POE::Test::Helpers 1.11
=pkg POE::Test::Loops 1.359
=pkg POE::XS::Loop::EPoll 1.003
=pkg POE::XS::Loop::Poll 1.000
=pkg POE::XS::Queue::Array 0.006

=head2 POE Extensions
=pkg POEx::HTTP::Server 0.0902
=pkg POEx::IRC::Backend 0.024006
=pkg POEx::IRC::Client::Lite 0.002002
=pkg POEx::Inotify 0.0201
=pkg POEx::Role::PSGIServer 1.110670
=pkg POEx::Tickit 0.02
=pkg POEx::URI 0.0301
=pkg POEx::Weather::OpenWeatherMap 0.002001
=pkg POEx::ZMQ 0.005002

=head2 Uncategorized
=pkg POE::Declarative 0.09
=pkg POE::Declare 0.59
=pkg POE::Declare::HTTP::Client 0.05
=pkg POE::Declare::HTTP::Online 0.02
=pkg POE::Declare::HTTP::Server 0.05
=pkg POE::Declare::Log::File 0.01
=pkg POE::Event::Message 0.11
=pkg POE::Framework::MIDI 0.09
=pkg POE::Future 0.03
=pkg POE::NFA 1.365
=pkg POE::Net::SNMP 1.1006
=pkg POE::Quickie 0.18
=pkg POE::Stage 0.060
=pkg POE::Sugar::Args 1.3
=pkg POE::Sugar::Attributes 0.02
=pkg POE::TIKC 0.02
=pkg POE::XUL::RDF 0.0600
=pkg POE::strict 3.01

=head1 AUTHOR

Apocalypse <APOCAL@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Apocalypse.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
