# Generated by default/object.tt
package Paws::ApplicationInsights::Observation;
  use Moose;
  has CloudWatchEventDetailType => (is => 'ro', isa => 'Str');
  has CloudWatchEventId => (is => 'ro', isa => 'Str');
  has CloudWatchEventSource => (is => 'ro', isa => 'Str');
  has CodeDeployApplication => (is => 'ro', isa => 'Str');
  has CodeDeployDeploymentGroup => (is => 'ro', isa => 'Str');
  has CodeDeployDeploymentId => (is => 'ro', isa => 'Str');
  has CodeDeployInstanceGroupId => (is => 'ro', isa => 'Str');
  has CodeDeployState => (is => 'ro', isa => 'Str');
  has EbsCause => (is => 'ro', isa => 'Str');
  has EbsEvent => (is => 'ro', isa => 'Str');
  has EbsRequestId => (is => 'ro', isa => 'Str');
  has EbsResult => (is => 'ro', isa => 'Str');
  has Ec2State => (is => 'ro', isa => 'Str');
  has EndTime => (is => 'ro', isa => 'Str');
  has HealthEventArn => (is => 'ro', isa => 'Str');
  has HealthEventDescription => (is => 'ro', isa => 'Str');
  has HealthEventTypeCategory => (is => 'ro', isa => 'Str');
  has HealthEventTypeCode => (is => 'ro', isa => 'Str');
  has HealthService => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has LineTime => (is => 'ro', isa => 'Str');
  has LogFilter => (is => 'ro', isa => 'Str');
  has LogGroup => (is => 'ro', isa => 'Str');
  has LogText => (is => 'ro', isa => 'Str');
  has MetricName => (is => 'ro', isa => 'Str');
  has MetricNamespace => (is => 'ro', isa => 'Str');
  has RdsEventCategories => (is => 'ro', isa => 'Str');
  has RdsEventMessage => (is => 'ro', isa => 'Str');
  has S3EventName => (is => 'ro', isa => 'Str');
  has SourceARN => (is => 'ro', isa => 'Str');
  has SourceType => (is => 'ro', isa => 'Str');
  has StartTime => (is => 'ro', isa => 'Str');
  has StatesArn => (is => 'ro', isa => 'Str');
  has StatesExecutionArn => (is => 'ro', isa => 'Str');
  has StatesInput => (is => 'ro', isa => 'Str');
  has StatesStatus => (is => 'ro', isa => 'Str');
  has Unit => (is => 'ro', isa => 'Str');
  has Value => (is => 'ro', isa => 'Num');
  has XRayErrorPercent => (is => 'ro', isa => 'Int');
  has XRayFaultPercent => (is => 'ro', isa => 'Int');
  has XRayNodeName => (is => 'ro', isa => 'Str');
  has XRayNodeType => (is => 'ro', isa => 'Str');
  has XRayRequestAverageLatency => (is => 'ro', isa => 'Int');
  has XRayRequestCount => (is => 'ro', isa => 'Int');
  has XRayThrottlePercent => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationInsights::Observation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationInsights::Observation object:

  $service_obj->Method(Att1 => { CloudWatchEventDetailType => $value, ..., XRayThrottlePercent => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationInsights::Observation object:

  $result = $service_obj->Method(...);
  $result->Att1->CloudWatchEventDetailType

=head1 DESCRIPTION

Describes an anomaly or error with the application.

=head1 ATTRIBUTES


=head2 CloudWatchEventDetailType => Str

The detail type of the CloudWatch Event-based observation, for example,
C<EC2 Instance State-change Notification>.


=head2 CloudWatchEventId => Str

The ID of the CloudWatch Event-based observation related to the
detected problem.


=head2 CloudWatchEventSource => Str

The source of the CloudWatch Event.


=head2 CodeDeployApplication => Str

The CodeDeploy application to which the deployment belongs.


=head2 CodeDeployDeploymentGroup => Str

The deployment group to which the CodeDeploy deployment belongs.


=head2 CodeDeployDeploymentId => Str

The deployment ID of the CodeDeploy-based observation related to the
detected problem.


=head2 CodeDeployInstanceGroupId => Str

The instance group to which the CodeDeploy instance belongs.


=head2 CodeDeployState => Str

The status of the CodeDeploy deployment, for example C<SUCCESS> or C<
FAILURE>.


=head2 EbsCause => Str

The cause of an EBS CloudWatch event.


=head2 EbsEvent => Str

The type of EBS CloudWatch event, such as C<createVolume>,
C<deleteVolume> or C<attachVolume>.


=head2 EbsRequestId => Str

The request ID of an EBS CloudWatch event.


=head2 EbsResult => Str

The result of an EBS CloudWatch event, such as C<failed> or
C<succeeded>.


=head2 Ec2State => Str

The state of the instance, such as C<STOPPING> or C<TERMINATING>.


=head2 EndTime => Str

The time when the observation ended, in epoch seconds.


=head2 HealthEventArn => Str

The Amazon Resource Name (ARN) of the AWS Health Event-based
observation.


=head2 HealthEventDescription => Str

The description of the AWS Health event provided by the service, such
as Amazon EC2.


=head2 HealthEventTypeCategory => Str

The category of the AWS Health event, such as C<issue>.


=head2 HealthEventTypeCode => Str

The type of the AWS Health event, for example,
C<AWS_EC2_POWER_CONNECTIVITY_ISSUE>.


=head2 HealthService => Str

The service to which the AWS Health Event belongs, such as EC2.


=head2 Id => Str

The ID of the observation type.


=head2 LineTime => Str

The timestamp in the CloudWatch Logs that specifies when the matched
line occurred.


=head2 LogFilter => Str

The log filter of the observation.


=head2 LogGroup => Str

The log group name.


=head2 LogText => Str

The log text of the observation.


=head2 MetricName => Str

The name of the observation metric.


=head2 MetricNamespace => Str

The namespace of the observation metric.


=head2 RdsEventCategories => Str

The category of an RDS event.


=head2 RdsEventMessage => Str

The message of an RDS event.


=head2 S3EventName => Str

The name of the S3 CloudWatch Event-based observation.


=head2 SourceARN => Str

The source resource ARN of the observation.


=head2 SourceType => Str

The source type of the observation.


=head2 StartTime => Str

The time when the observation was first detected, in epoch seconds.


=head2 StatesArn => Str

The Amazon Resource Name (ARN) of the step function-based observation.


=head2 StatesExecutionArn => Str

The Amazon Resource Name (ARN) of the step function execution-based
observation.


=head2 StatesInput => Str

The input to the step function-based observation.


=head2 StatesStatus => Str

The status of the step function-related observation.


=head2 Unit => Str

The unit of the source observation metric.


=head2 Value => Num

The value of the source observation metric.


=head2 XRayErrorPercent => Int

The X-Ray request error percentage for this node.


=head2 XRayFaultPercent => Int

The X-Ray request fault percentage for this node.


=head2 XRayNodeName => Str

The name of the X-Ray node.


=head2 XRayNodeType => Str

The type of the X-Ray node.


=head2 XRayRequestAverageLatency => Int

The X-Ray node request average latency for this node.


=head2 XRayRequestCount => Int

The X-Ray request count for this node.


=head2 XRayThrottlePercent => Int

The X-Ray request throttle percentage for this node.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationInsights>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

