# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::MY;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240308154352;

my $formatters = [
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '[4-79]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '
            1(?:
              [02469]|
              [37][1-9]|
              53|
              8(?:
                [1-46-9]|
                5[7-9]
              )
            )|
            8
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3-$4',
                  'leading_digits' => '
            1(?:
              [367]|
              80
            )
          ',
                  'pattern' => '(\\d)(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '1',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              2[0-36-9]|
              3[0-368]|
              4[0-278]|
              5[0-24-8]|
              6[0-467]|
              7[1246-9]|
              8\\d|
              9[0-57]
            )\\d|
            4(?:
              2[0-689]|
              [3-79]\\d|
              8[1-35689]
            )|
            5(?:
              2[0-589]|
              [3468]\\d|
              5[0-489]|
              7[1-9]|
              9[23]
            )|
            6(?:
              2[2-9]|
              3[1357-9]|
              [46]\\d|
              5[0-6]|
              7[0-35-9]|
              85|
              9[015-8]
            )|
            7(?:
              [2579]\\d|
              3[03-68]|
              4[0-8]|
              6[5-9]|
              8[0-35-9]
            )|
            8(?:
              [24][2-8]|
              3[2-5]|
              5[2-7]|
              6[2-589]|
              7[2-578]|
              [89][2-9]
            )|
            9(?:
              0[57]|
              13|
              [25-7]\\d|
              [3489][0-8]
            )
          )\\d{5}
        ',
                'geographic' => '
          (?:
            3(?:
              2[0-36-9]|
              3[0-368]|
              4[0-278]|
              5[0-24-8]|
              6[0-467]|
              7[1246-9]|
              8\\d|
              9[0-57]
            )\\d|
            4(?:
              2[0-689]|
              [3-79]\\d|
              8[1-35689]
            )|
            5(?:
              2[0-589]|
              [3468]\\d|
              5[0-489]|
              7[1-9]|
              9[23]
            )|
            6(?:
              2[2-9]|
              3[1357-9]|
              [46]\\d|
              5[0-6]|
              7[0-35-9]|
              85|
              9[015-8]
            )|
            7(?:
              [2579]\\d|
              3[03-68]|
              4[0-8]|
              6[5-9]|
              8[0-35-9]
            )|
            8(?:
              [24][2-8]|
              3[2-5]|
              5[2-7]|
              6[2-589]|
              7[2-578]|
              [89][2-9]
            )|
            9(?:
              0[57]|
              13|
              [25-7]\\d|
              [3489][0-8]
            )
          )\\d{5}
        ',
                'mobile' => '
          1(?:
            1888[689]|
            4400|
            8(?:
              47|
              8[27]
            )[0-4]
          )\\d{4}|
          1(?:
            0(?:
              [23568]\\d|
              4[0-6]|
              7[016-9]|
              9[0-8]
            )|
            1(?:
              [1-5]\\d\\d|
              6(?:
                0[5-9]|
                [1-9]\\d
              )|
              7(?:
                [0-4]\\d|
                5[0-7]
              )
            )|
            (?:
              [269]\\d|
              [37][1-9]|
              4[235-9]
            )\\d|
            5(?:
              31|
              9\\d\\d
            )|
            8(?:
              1[23]|
              [236]\\d|
              4[06]|
              5(?:
                46|
                [7-9]
              )|
              7[016-9]|
              8[01]|
              9[0-8]
            )
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(1600\\d{6})',
                'toll_free' => '1[378]00\\d{6}',
                'voip' => '
          15(?:
            4(?:
              6[0-4]\\d|
              8(?:
                0[125]|
                [17]\\d|
                21|
                3[01]|
                4[01589]|
                5[014]|
                6[02]
              )
            )|
            6(?:
              32[0-6]|
              78\\d
            )
          )\\d{4}
        '
              };
my %areanames = ();
$areanames{en} = {"604269", "Penang",
"604950", "Kuah",
"609852", "Chukai",
"604618", "Penang",
"6039206", "Kuala\ Lumpur",
"609952", "Machang",
"604850", "Penang",
"6038211", "Semenyih",
"6088613", "Kudat",
"60438", "Penang",
"604427", "Kulim",
"6083324", "Bandar\ Sri\ Aman",
"606350", "Tangga\ Batu",
"6089613", "Elopura",
"607597", "Senai",
"6089729", "Tawau",
"6036101", "Genting",
"6037651", "Kuala\ Lumpur",
"6088609", "Kudat",
"607760", "Keluang",
"6084361", "Sibu",
"605353", "Ipoh",
"6036261", "Kuala\ Lumpur",
"6032780", "Kuala\ Lumpur",
"6036420", "Rawang",
"6082687", "Kuching",
"609279", "Mentakab",
"6032240", "Kuala\ Lumpur",
"605357", "Ipoh",
"609547", "Kuantan",
"6087507", "Labuan",
"604683", "Penang",
"6032788", "Kuala\ Lumpur",
"604255", "Penang",
"604687", "Penang",
"607450", "Senggarang",
"6035879", "Kinrara",
"609543", "Sungai\ Lembing",
"605501", "Ipoh",
"607221", "Johor\ Bahru",
"6036144", "Kuala\ Lumpur",
"6038777", "Mantin",
"606492", "Kuala\ Klawang",
"607923", "Bukit\ Kepong",
"6087234", "Beaufort",
"6089630", "Elopura",
"609606", "Tenang",
"6089670", "Elopura",
"6033855", "Sabak\ Bernam",
"607823", "Penawar",
"607927", "Tenang",
"6087208", "Beaufort",
"6033392", "Kelang",
"609801", "Paka",
"6082659", "Kota\ Samarahan",
"6045960", "Parit\ Buntar",
"6038783", "Mantin",
"6082625", "Kuching",
"608243", "Sejingkat",
"60565", "Langkap",
"605847", "Taiping",
"608247", "Sejingkat",
"605241", "Ipoh",
"6088641", "Kudat",
"6032116", "Kuala\ Lumpur",
"605599", "Chemor",
"607748", "Keluang",
"609412", "Kuala\ Rompin",
"607481", "Kangkar\ Baru",
"6087888", "Membakut",
"604410", "Kulim",
"6082845", "Damai\ Beach",
"605356", "Ipoh",
"607571", "Senai",
"604669", "Penang",
"6032393", "Kuala\ Lumpur",
"606645", "Port\ Dickson",
"6089668", "Elopura",
"6035020", "Kinrara",
"604218", "Penang",
"6088668", "Kota\ Marudu",
"6032382", "Kuala\ Lumpur",
"6032261", "Kuala\ Lumpur",
"605751", "Kuala\ Kangsar",
"607596", "Senai",
"609679", "Jerteh",
"605385", "Bota",
"606465", "Ayer\ Hitam",
"604449", "Baling",
"6085296", "Lawas",
"6082663", "Kota\ Samarahan",
"605728", "Parit\ Buntar",
"604881", "Penang",
"6037666", "Kuala\ Lumpur",
"607910", "Tenang",
"609324", "Kuala\ Lipis",
"605461", "Tapah",
"607658", "Kulai",
"609838", "Merchang",
"604981", "Kangar",
"605829", "Taiping",
"607810", "Paloh",
"6083589", "Lubukantu",
"6085622", "Miri",
"6038988", "Cheras",
"6038321", "Putrajaya",
"604283", "Penang",
"605846", "Taiping",
"608246", "Kuching",
"6083584", "Lubukantu",
"6035525", "Kinrara",
"605641", "Hutan\ Melintang",
"6035740", "Kinrara",
"6038767", "Semenyih",
"609529", "Kuantan",
"6082882", "Serian",
"6089660", "Elopura",
"6039767", "Cheras",
"607365", "Johor\ Bahru",
"607926", "Labis",
"606968", "Pagoh",
"609546", "Gambang",
"6084802", "Sibu",
"604686", "Penang",
"6087880", "Membakut",
"606459", "Serting",
"604368", "Kepala\ Batas",
"604947", "Kangar",
"609914", "Gua\ Musang",
"60465", "Penang",
"606542", "Durian\ Tunggal",
"6038661", "Mantin",
"607711", "Keluang",
"6083545", "Pantu",
"605286", "Ipoh",
"604943", "Kangar",
"609814", "Paka",
"609782", "Bachok",
"604241", "Penang",
"6098710", "Cheneh",
"6032389", "Kuala\ Lumpur",
"6034105", "Kuala\ Lumpur",
"607289", "Johor\ Bahru",
"6085770", "Long\ Lama",
"605683", "Sitiawan",
"605687", "Sitiawan",
"605255", "Ipoh",
"6084870", "Mukah",
"6034265", "Kuala\ Lumpur",
"6084830", "Matu",
"6087765", "Tambunan",
"6052320", "Ipoh",
"609550", "Kuantan",
"6087477", "Labuan",
"607443", "Rengit",
"6088981", "Tenghilan",
"6084809", "Sibu",
"604552", "Tasek\ Gelugor",
"607266", "Johor\ Bahru",
"606228", "Melaka",
"6089981", "Tawau",
"606274", "Melaka",
"6082260", "Kuching",
"607447", "Batu\ Pahat",
"6084804", "Sarikei",
"6087437", "Labuan",
"6082889", "Serian",
"6085738", "Batu\ Niah",
"606420", "Johol",
"603796", "Kuala\ Lumpur",
"606251", "Melaka",
"6038891", "Putrajaya",
"6082323", "Damai\ Beach",
"607663", "Kulai",
"608421", "Sibu",
"605618", "Changkat\ Keruing",
"605850", "Sungai\ Nyior",
"605427", "Tapah",
"6087483", "Labuan",
"605423", "Tapah",
"6036046", "Kampong\ Suharto",
"6087735", "Tenom",
"6082278", "Kuching",
"6088517", "Kota\ Kinabalu",
"604538", "Tasek\ Gelugor",
"607512", "Senai",
"6089517", "Beluran",
"609454", "Bukit\ Ibam",
"609581", "Gebeng",
"6087775", "Tambunan",
"6088747", "Kinarut",
"606524", "Jasin",
"6085760", "Marudi",
"6088602", "Kudat",
"6084698", "Bintangor",
"6082537", "Kuching",
"6089747", "Tawau",
"6032726", "Kuala\ Lumpur",
"609471", "Sungai\ Tekam",
"6036185", "Kuala\ Lumpur",
"6082592", "Kota\ Samarahan",
"605368", "Pusing",
"6089287", "Elopura",
"6039074", "Cheras",
"605881", "Selama",
"6083480", "Betong",
"604461", "Bedong",
"6038079", "Kinrara",
"604929", "Alor\ Setar",
"609700", "Kota\ Bharu",
"6082583", "Kota\ Samarahan",
"6038074", "Kinrara",
"6089273", "Elopura",
"604829", "Penang",
"6083322", "Bandar\ Sri\ Aman",
"6038008", "Putrajaya",
"6089722", "Tawau",
"604702", "Alor\ Setar",
"6033143", "Sepang",
"604946", "Kangar",
"608432", "Sibu",
"607689", "Pontian",
"608887", "Ranau",
"605655", "Kampong\ Gajah",
"605287", "Pusing",
"6036127", "Kuala\ Lumpur",
"606651", "Port\ Dickson",
"6038000", "Putrajaya",
"6082781", "Gedong",
"6083417", "Betong",
"605449", "Tanjung\ Malim",
"607666", "Kulai",
"6086260", "Bintulu",
"607388", "Johor\ Bahru",
"606985", "Muar",
"604599", "Parit\ Buntar",
"607861", "Tiram",
"609764", "Bachok",
"6038656", "Cheras",
"607429", "Senggarang",
"605410", "Tapah",
"607961", "Segamat",
"6085768", "Marudi",
"6084690", "Bintangor",
"6087232", "Beaufort",
"604356", "Tasek\ Gelugor",
"605669", "Sitiawan",
"6087467", "Labuan",
"6086323", "Bintulu",
"606856", "Mantin",
"6036142", "Kuala\ Lumpur",
"607267", "Johor\ Bahru",
"6082270", "Kuching",
"607446", "Senggarang",
"604510", "Tasek\ Gelugor",
"6032274", "Kuala\ Lumpur",
"6036138", "Kuala\ Lumpur",
"6083321", "Bandar\ Sri\ Aman",
"6032279", "Kuala\ Lumpur",
"6036178", "Kuala\ Lumpur",
"6036104", "Genting",
"6034288", "Kuala\ Lumpur",
"6082285", "Kuching",
"6037610", "Kuala\ Lumpur",
"6088535", "Kota\ Kinabalu",
"6088790", "Tuaran",
"6085331", "Miri",
"6034217", "Kuala\ Lumpur",
"6034020", "Kuala\ Lumpur",
"6089790", "Merotai",
"6089535", "Elopura",
"6035566", "Kinrara",
"605812", "Taiping",
"604526", "Kulim",
"605795", "Grik",
"6082520", "Kuching",
"605375", "Bota",
"6088616", "Kudat",
"6084364", "Sibu",
"6088367", "Kota\ Kinabalu",
"608235", "Kuching",
"6089616", "Elopura",
"604549", "Tasek\ Gelugor",
"6083435", "Saratok",
"6087231", "Beaufort",
"60961", "Kuala\ Brang",
"6082227", "Kuching",
"609725", "Kota\ Bharu",
"6083475", "Debak",
"6082793", "Tebedu",
"6085454", "Miri",
"606354", "Tangga\ Batu",
"604331", "Penang",
"6092410", "Telemong",
"606791", "Seremban",
"606233", "Melaka",
"609666", "Kuala\ Brang",
"6036141", "Kuala\ Lumpur",
"606776", "Seremban",
"6034028", "Kuala\ Lumpur",
"6089798", "Tawau",
"6037202", "Kuala\ Lumpur",
"607764", "Felda\ Tenggaroh",
"609961", "Kuala\ Krai",
"6084647", "Sarikei",
"6084702", "Bintangor",
"6088798", "Tuaran",
"605438", "Tapah",
"6034280", "Kuala\ Lumpur",
"609263", "Damak",
"6082782", "Gedong",
"6086422", "Sebauh",
"6036130", "Kuala\ Lumpur",
"609267", "Jerantut",
"6063131", "Melaka",
"605230", "Ipoh",
"6089523", "Telupid",
"6082651", "Kuching",
"6089855", "Kunak",
"6086285", "Bintulu",
"6085463", "Miri",
"607914", "Tenang",
"607782", "Paloh",
"6033630", "Banting",
"6084308", "Sibu",
"604609", "Penang",
"6032109", "Kuala\ Lumpur",
"6036274", "Kuala\ Lumpur",
"6035620", "Kinrara",
"6078710", "Tiram",
"6036279", "Kuala\ Lumpur",
"6082388", "Kuching",
"6082666", "Kota\ Samarahan",
"6089565", "Kinabatangan",
"6085742", "Beluru",
"6085282", "Lawas",
"6032113", "Kuala\ Lumpur",
"6032264", "Kuala\ Lumpur",
"6039173", "Kuala\ Lumpur",
"6034800", "Kuala\ Lumpur",
"6039133", "Kuala\ Lumpur",
"6037882", "Kuala\ Lumpur",
"60743", "Batu\ Pahat",
"609443", "Bandar\ Tun\ Razak",
"605401", "Tapah",
"606637", "Seremban",
"6038324", "Putrajaya",
"604414", "Serdang",
"6038892", "Putrajaya",
"609266", "Jerantut",
"6038329", "Putrajaya",
"6085785", "Marudi",
"606633", "Seremban",
"6082805", "Simunjan",
"609447", "Bandar\ Tun\ Razak",
"604291", "Penang",
"604893", "Penang",
"604673", "Penang",
"604997", "Kangar",
"6089982", "Tawau",
"6082380", "Kuching",
"609663", "Batu\ Rakit",
"6037663", "Kuala\ Lumpur",
"603928", "Kuala\ Lumpur",
"6035628", "Kinrara",
"609667", "Kuala\ Brang",
"6088982", "Tenghilan",
"6084353", "Sibu",
"607305", "Johor\ Bahru",
"6082896", "Serian",
"6083465", "Debak",
"604308", "Tasek\ Gelugor",
"607412", "Batu\ Pahat",
"6037884", "Kuala\ Lumpur",
"6036095", "Rawang",
"6086201", "Bintulu",
"609481", "Kota\ Gelangi",
"605676", "Changkat\ Keruing",
"6032381", "Kuala\ Lumpur",
"609215", "Genting",
"6096830", "Kuala\ Brang",
"6032262", "Kuala\ Lumpur",
"6084844", "Mukah",
"606270", "Melaka",
"609571", "Kuantan",
"6037260", "Kuala\ Lumpur",
"609232", "Karak",
"6085744", "Beluru",
"6033225", "Sabak\ Bernam",
"606424", "Batu\ Kikir",
"6084760", "Kanowit",
"6033259", "Kelang",
"6088405", "Kota\ Kinabalu",
"603404", "Kuala\ Lumpur",
"6085284", "Lawas",
"608877", "Kinarut",
"608873", "Kinarut",
"607899", "Tiram",
"604561", "Kepala\ Batas",
"608977", "Tawau",
"6036272", "Kuala\ Lumpur",
"607679", "Pontian",
"605854", "Sungai\ Nyior",
"6088394", "Kota\ Kinabalu",
"607739", "Kluang",
"608532", "Miri",
"605691", "Sitiawan",
"606335", "Melaka",
"6082326", "Kuching",
"607938", "Tenang",
"606975", "Muar",
"604784", "Lubuk\ Merbau",
"605526", "Ipoh",
"607838", "Penawar",
"606517", "Jasin",
"606695", "Linggi",
"604375", "Penang",
"6084816", "Rejang",
"6087486", "Labuan",
"604835", "Penang",
"6089984", "Tawau",
"6084801", "Sibu",
"606312", "Melaka",
"605549", "Ipoh",
"6037947", "Kuala\ Lumpur",
"605209", "Ipoh",
"609826", "Kerteh",
"604499", "Baling",
"6033085", "Kelang",
"609365", "Dong",
"6038894", "Putrajaya",
"609849", "Dungun",
"6033273", "Batang\ Berjuntai",
"609949", "Ayer\ Lanas",
"6087823", "Sipitang",
"6085621", "Miri",
"6038322", "Putrajaya",
"6084362", "Sibu",
"604390", "Penang",
"609632", "Kuala\ Brang",
"6032603", "Kuala\ Lumpur",
"6037652", "Kuala\ Lumpur",
"6089276", "Elopura",
"6092870", "Kuala\ Krau",
"609772", "Kok\ Lanas",
"608876", "Kinarut",
"609593", "Gambang",
"6036262", "Kuala\ Lumpur",
"608976", "Tawau",
"6032011", "Kuala\ Lumpur",
"609760", "Bachok",
"6084730", "Julau",
"604401", "Kulim",
"608991", "Tawau",
"606662", "Tekok\ Kemang",
"6084770", "Song",
"608891", "Papar",
"604762", "Alor\ Setar",
"605733", "Parit\ Buntar",
"605291", "Tanjung\ Rambutan",
"6039212", "Kuala\ Lumpur",
"605897", "Semanggol",
"6036102", "Genting",
"605677", "Bruas",
"605673", "Bruas",
"6032297", "Kuala\ Lumpur",
"6038071", "Kinrara",
"605893", "Taiping",
"6032272", "Kuala\ Lumpur",
"607279", "Johor\ Bahru",
"6032723", "Kuala\ Lumpur",
"6086424", "Sebauh",
"6087726", "Tenom",
"609450", "Bukit\ Ibam",
"609221", "Bentong",
"6032775", "Kuala\ Lumpur",
"6086326", "Bintulu",
"6039545", "Kuala\ Lumpur",
"6038600", "Kinrara",
"609827", "Paka",
"609823", "Al\ Muktafi\ Billa\ H\ Shah",
"606295", "Melaka",
"6084738", "Julau",
"608521", "Limbang",
"6039056", "Cheras",
"6085452", "Miri",
"6033103", "Pulau\ Ketam",
"605322", "Ipoh",
"60537", "Pusing",
"605609", "Teluk\ Intan",
"605527", "Ipoh",
"607207", "Johor\ Bahru",
"6089631", "Elopura",
"609865", "Kemasik",
"6088671", "Kudat",
"609204", "Jerantut",
"6085403", "Miri",
"609965", "Kuala\ Krai",
"6039085", "Cheras",
"6089671", "Elopura",
"6033322", "Kelang",
"608244", "Kuching",
"6085450", "Miri",
"607707", "Keluang",
"606499", "Batu\ Kikir",
"607924", "Labis",
"609310", "Kuala\ Lipis",
"6086486", "Balingan",
"6034289", "Kuala\ Lumpur",
"6085667", "Miri",
"6089505", "Beluran",
"609721", "Kota\ Bharu",
"6038602", "Kinrara",
"6038588", "Putrajaya",
"604513", "Padang\ Serai",
"6036139", "Kuala\ Lumpur",
"6084235", "Sibu",
"604684", "Penang",
"6036108", "Genting",
"609758", "Pasir\ Putih",
"609544", "Kuantan",
"6037735", "Kuala\ Lumpur",
"6036179", "Kuala\ Lumpur",
"6032278", "Kuala\ Lumpur",
"6082865", "Kota\ Samarahan",
"605354", "Ipoh",
"6032270", "Kuala\ Lumpur",
"609959", "Batu\ Gajah",
"605237", "Ipoh",
"609260", "Jerantut",
"6083496", "Lingga",
"6036100", "Genting",
"609859", "Chukai",
"605791", "Grik",
"604262", "Penang",
"6088794", "Tuaran",
"6084797", "Kapit",
"609468", "Maran",
"6088656", "Kotamarudu",
"6084223", "Sibu",
"6084772", "Song",
"6038210", "Semenyih",
"6038027", "Kinrara",
"605831", "Selama",
"6034024", "Kuala\ Lumpur",
"6088799", "Tuaran",
"6082555", "Kuching",
"605636", "Sabak\ Bernam",
"606230", "Melaka",
"6032241", "Kuala\ Lumpur",
"6036421", "Rawang",
"6032781", "Kuala\ Lumpur",
"607585", "Senai",
"609272", "Lanchang",
"609531", "Kuantan",
"6087201", "Beaufort",
"6037650", "Kuala\ Lumpur",
"607475", "Sri\ Gading",
"6087216", "Beaufort",
"606438", "Simpang\ Empat",
"6034257", "Kuala\ Lumpur",
"6039225", "Kuala\ Lumpur",
"6038320", "Putrajaya",
"6039103", "Cheras",
"607301", "Johor\ Bahru",
"6032268", "Kuala\ Lumpur",
"6085637", "Miri",
"6032108", "Kuala\ Lumpur",
"607706", "Keluang",
"6082389", "Kuching",
"6087881", "Kuala\ Penyu",
"6088661", "Kotamarudu",
"609323", "Kuala\ Lipis",
"6084304", "Sibu",
"6032857", "Kuala\ Lumpur",
"6088307", "Kota\ Kinabalu",
"609327", "Padang\ Tengku",
"6089926", "Tawau",
"607298", "Johor\ Bahru",
"6035021", "Kinrara",
"6034813", "Kuala\ Lumpur",
"608631", "Bintulu",
"6035543", "Kinrara",
"605592", "Lintang",
"609419", "Kuala\ Rompin",
"605637", "Sabak\ Bernam",
"6036270", "Kuala\ Lumpur",
"6035624", "Kinrara",
"609660", "Kuala\ Brang",
"6035629", "Kinrara",
"609508", "Teruntum",
"605633", "Kampong\ Gajah",
"60962", "Kuala\ Brang",
"609248", "Bera",
"6084762", "Kanowit",
"604890", "Penang",
"606770", "Seremban",
"609440", "Bandar\ Tun\ Razak",
"605236", "Ipoh",
"6086555", "Bintulu",
"6032260", "Kuala\ Lumpur",
"606390", "Tangga\ Batu",
"605808", "Taiping",
"609732", "Kota\ Bharu",
"6036241", "Kuala\ Lumpur",
"606630", "Seremban",
"6038328", "Putrajaya",
"604559", "Tasek\ Gelugor",
"606736", "Mantin",
"605478", "Tapah",
"6082491", "Kuching",
"6084302", "Sibu",
"609361", "Raub",
"6036036", "Batuarang",
"6082261", "Kuching",
"6035165", "Kinrara",
"6082382", "Kuching",
"606971", "Bukit\ Kepong",
"606331", "Melaka",
"6085288", "Lawas",
"6085756", "Marudi",
"609766", "Bachok",
"6082393", "Sejingkat",
"606691", "Linggi",
"6033258", "Kelang",
"608862", "Kudat",
"607444", "Senggarang",
"609888", "Kemasik",
"604931", "Changlon",
"606277", "Melaka",
"604371", "Penang",
"6086231", "Bintulu",
"6038890", "Putrajaya",
"6084848", "Kuala\ Igan",
"609789", "Pasir\ Putih",
"609456", "Chini",
"6038996", "Cheras",
"6037880", "Kuala\ Lumpur",
"6084840", "Kuala\ Igan",
"605312", "Ipoh",
"606549", "Durian\ Tunggal",
"6034802", "Kuala\ Lumpur",
"604565", "Kepala\ Batas",
"605684", "Sitiawan",
"6033250", "Kelang",
"6085280", "Lawas",
"605517", "Tanjung\ Rambutan",
"6085740", "Mu",
"6038660", "Mantin",
"6033163", "Kelang",
"6084871", "Mukah",
"609485", "Jengka\ Lapan\ Belas",
"6088886", "Ranau",
"6052321", "Ipoh",
"6035622", "Kinrara",
"6086256", "Bintulu",
"6084831", "Matu",
"609575", "Kuantan",
"609817", "Dungun",
"6087317", "Keningau",
"6033214", "Sabak\ Bernam",
"6085771", "Long\ Lama",
"609913", "Gua\ Musang",
"604944", "Kangar",
"609813", "Paka",
"6032202", "Kuala\ Lumpur",
"606276", "Melaka",
"6082780", "Gedong",
"6032687", "Kuala\ Lumpur",
"605890", "Semanggol",
"6084753", "Kanowit",
"605670", "Sitiawan",
"6089295", "Elopura",
"6033110", "Pulau\ Ketam",
"6089465", "Elopura",
"609767", "Bachok",
"6087782", "Tambunan",
"6038609", "Kinrara",
"604908", "Kangar",
"6032036", "Kuala\ Lumpur",
"6037200", "Kuala\ Lumpur",
"6038724", "Semenyih",
"6084620", "Sarikei",
"609590", "Kuantan",
"6034293", "Kuala\ Lumpur",
"607422", "Kampung\ Parit\ Tengah",
"6033324", "Kelang",
"6082271", "Kuching",
"6087227", "Beaufort",
"604592", "Parit\ Buntar",
"609225", "Bentong",
"6036066", "Kuala\ Kubu\ Baru",
"6089206", "Elopura",
"606737", "Mantin",
"604397", "Penang",
"606733", "Mantin",
"6084691", "Bintangor",
"6088206", "Kota\ Kinabalu",
"609816", "Dungun",
"6099560", "Batu\ Gajah",
"604405", "Padang\ Serai",
"605520", "Ipoh",
"6085761", "Layang\-Layang",
"6035123", "Kinrara",
"6089243", "Elopura",
"607408", "Kampong\ Parit\ Tengah",
"6088783", "Tuaran",
"6084734", "Julau",
"6033187", "Banting",
"6034022", "Kuala\ Lumpur",
"604709", "Alor\ Setar",
"6089792", "Semporna",
"606523", "Jasin",
"6082547", "Kuching",
"609820", "Paka",
"6088792", "Tuaran",
"60497", "Kangar",
"604922", "Kangar",
"6035885", "Kinrara",
"6083337", "Bandar\ Sri\ Aman",
"606527", "Jasin",
"6038526", "Mantin",
"609457", "Chini",
"609611", "Bandar\ Permaisuri",
"609453", "Bukit\ Ibam",
"607682", "Air\ Baloi",
"6086483", "Pelagus",
"6082272", "Kuching",
"605350", "Batu\ Gajah",
"6085265", "Sundar",
"609264", "Mentakab",
"604416", "Sungai\ Petani",
"6036140", "Kuala\ Lumpur",
"6088608", "Kudat",
"6087230", "Beaufort",
"6084692", "Bintangor",
"6089634", "Elopura",
"608845", "Kota\ Kinabalu",
"605245", "Ipoh",
"6085495", "Miri",
"607763", "Ayer\ Hitam",
"6034770", "Kuala\ Lumpur",
"6088674", "Kudat",
"607767", "Mersing",
"6089674", "Elopura",
"6037865", "Kuala\ Lumpur",
"6086381", "Tatau",
"606353", "Tangga\ Batu",
"6084683", "Sarikei",
"607590", "Senai",
"6082650", "Kuching",
"608564", "Miri",
"606357", "Tangga\ Batu",
"6032201", "Kuala\ Lumpur",
"604251", "Penang",
"606234", "Melaka",
"6065350", "Jasin",
"6085406", "Miri",
"6063130", "Melaka",
"607225", "Johor\ Bahru",
"6036131", "Kuala\ Lumpur",
"6089728", "Tawau",
"604953", "Kuah",
"6039236", "Kuala\ Lumpur",
"60464", "Penang",
"604228", "Penang",
"606552", "Simpang\ Empat",
"6088791", "Tuaran",
"6037611", "Kuala\ Lumpur",
"6089965", "Lahad\ Datu",
"607916", "Bekok",
"6034021", "Kuala\ Lumpur",
"6083320", "Bandar\ Sri\ Aman",
"605840", "Taiping",
"6082658", "Kuching",
"605783", "Kuala\ Kangsar",
"609408", "Kuala\ Rompin",
"6087213", "Beaufort",
"607920", "Segamat",
"6082735", "Lundu",
"6082590", "Kuching",
"604347", "Penang",
"6087209", "Beaufort",
"6038707", "Mantin",
"6088653", "Kotamarudu",
"6036156", "Kuala\ Lumpur",
"6036148", "Kuala\ Lumpur",
"604680", "Penang",
"60475", "Lubuk\ Merbau",
"609540", "Kuantan",
"6035878", "Kinrara",
"609682", "Kuala\ Brang",
"6089715", "Tawau",
"605769", "Lenggong",
"605645", "Bagan\ Datoh",
"603271", "Kuala\ Lumpur",
"604956", "Kuah",
"607361", "Johor\ Bharu",
"60450", "Tasek\ Gelugor",
"603337", "Kelang",
"6086297", "Bintulu",
"609664", "Batu\ Rakit",
"603873", "Semenyih",
"6039195", "Kuala\ Lumpur",
"6089923", "Tawau",
"6086232", "Bintulu",
"6089669", "Elopura",
"604885", "Penang",
"605465", "Kampar",
"6088664", "Kota\ Marudu",
"6084301", "Sibu",
"6082492", "Kuching",
"606728", "Seremban",
"604985", "Kangar",
"6088669", "Kota\ Marudu",
"607766", "Mersing",
"6089664", "Elopura",
"604628", "Penang",
"6039106", "Cheras",
"6037875", "Kuala\ Lumpur",
"6087889", "Membakut",
"6082381", "Kuching",
"604417", "Mahang",
"6087490", "Labuan",
"6082826", "Asajaya",
"6038957", "Cheras",
"604413", "Sungai\ Petani",
"606634", "Seremban",
"606385", "Tangga\ Batu",
"6087884", "Kuala\ Penyu",
"6033008", "Banting",
"607789", "Keluang",
"6035621", "Kinrara",
"6084832", "Matu",
"6089894", "Kunak",
"6084872", "Mukah",
"605381", "Batugajah",
"6084897", "Stapang",
"606461", "Ladanggeddes",
"6082765", "Bau",
"6085223", "Limbang",
"609568", "Kuantan",
"6036789", "Genting",
"6034801", "Kuala\ Lumpur",
"6038989", "Cheras",
"604280", "Penang",
"604524", "Tasek\ Gelugor",
"607485", "Batu\ Pahat",
"607211", "Johor\ Bahru",
"609282", "Lanchang",
"6034816", "Kuala\ Lumpur",
"604741", "Alor\ Setar",
"6086590", "Tatau",
"606641", "Port\ Dickson",
"6088347", "Kota\ Kinabalu",
"607913", "Labis",
"604488", "Padang\ Serai",
"607917", "Tenang",
"6088975", "Kota\ Belud",
"604919", "Alor\ Setar",
"6085615", "Miri",
"6092620", "Jerantut",
"604819", "Penang",
"6033243", "Sekinchan",
"608425", "Sibu",
"609301", "Jerantut",
"606319", "Melaka",
"605542", "Ipoh",
"6082499", "Kuching",
"6036087", "Rawang",
"605680", "Sitiawan",
"6088662", "Kota\ Marudu",
"6032388", "Kuala\ Lumpur",
"6036073", "Kuala\ Kubu\ Baru",
"6085620", "Miri",
"6077690", "Paloh",
"609706", "Kota\ Bharu",
"607522", "Senai",
"604783", "Lubuk\ Merbau",
"6082305", "Kuching",
"6086507", "Bintulu",
"606514", "Jasin",
"6036285", "Kuala\ Lumpur",
"604787", "Alor\ Setar",
"604940", "Kangar",
"609842", "Dungun",
"6037261", "Kuala\ Lumpur",
"6033166", "Kelang",
"6086253", "Bintulu",
"608257", "Kuching",
"608685", "Bintulu",
"605857", "Taiping",
"6036242", "Kuala\ Lumpur",
"607660", "Kulai",
"6085628", "Miri",
"609239", "Telemong",
"607508", "Tanjung\ Kupang",
"608828", "Kota\ Kinabalu",
"605853", "Sungai\ Nyior",
"6032380", "Kuala\ Lumpur",
"607892", "Kota\ Tinggi",
"6038993", "Cheras",
"6085739", "Batu\ Niah",
"6047210", "Sungai\ Petani",
"606427", "Kuala\ Pilah",
"605416", "Tapah",
"6082888", "Serian",
"609352", "Sungai\ Koyan",
"606423", "Simpang\ Durian",
"6085779", "Long\ Lama",
"6035022", "Kinrara",
"6088355", "Kota\ Kinabalu",
"609553", "Kuantan",
"607440", "Batu\ Pahat",
"6084874", "Mukah",
"6084808", "Sibu",
"606850", "Mantin",
"6084834", "Matu",
"6087407", "Labuan",
"609557", "Kuantan",
"6084879", "Dalat",
"607865", "Tiram",
"6034296", "Kuala\ Lumpur",
"6038601", "Kinrara",
"6032087", "Kuala\ Lumpur",
"605280", "Ipoh",
"6086880", "Bakun",
"607965", "Kota\ Tinggi",
"6089203", "Elopura",
"604868", "Penang",
"605488", "Tanjung\ Malim",
"609703", "Kota\ Bharu",
"6036063", "Kuala\ Kubu\ Baru",
"604968", "Kuah",
"6039078", "Cheras",
"609707", "Kota\ Bharu",
"6088203", "Kota\ Kinabalu",
"6089672", "Elopura",
"6084699", "Bintangor",
"609978", "Kuala\ Krai",
"6082507", "Kuching",
"6084694", "Bintangor",
"6038790", "Mantin",
"6037717", "Kuala\ Lumpur",
"6089632", "Elopura",
"609824", "Kerteh",
"607721", "Renggam",
"606655", "Port\ Dickson",
"6082279", "Kuching",
"6082274", "Kuching",
"607758", "Ayer\ Hitam",
"6033321", "Kelang",
"606981", "Bakri",
"605885", "Taiping",
"6032242", "Kuala\ Lumpur",
"6032782", "Kuala\ Lumpur",
"6092871", "Kuala\ Krau",
"604465", "Bedong",
"605674", "Bruas",
"6038523", "Kinrara",
"605894", "Taiping",
"609639", "Kuala\ Brang",
"6089867", "Lahad\ Datu",
"609556", "Kuantan",
"6084869", "Kuala\ Igan",
"606426", "Ayer\ Hitam",
"605417", "Tapah",
"607468", "Sri\ Gading",
"6032025", "Kuala\ Lumpur",
"6085769", "Marudi",
"605413", "Cameron\ Highland",
"609779", "Bachok",
"604769", "Alor\ Setar",
"605856", "Taiping",
"6035126", "Kinrara",
"603563", "Kinrara",
"6039070", "Cheras",
"6089557", "Kinabatangan",
"609585", "Gebeng",
"6038070", "Kinrara",
"6084731", "Julau",
"607272", "Johor\ Bahru",
"6089246", "Elopura",
"6033176", "Kelang",
"607531", "Senai",
"6088786", "Tuaran",
"609475", "Maran",
"606410", "Tampin",
"606962", "Bakri",
"6082822", "Asajaya",
"604563", "Sungai\ Bakap",
"608871", "Kinarut",
"6087820", "Sipitang",
"605693", "Sitiawan",
"607299", "Johor\ Bahru",
"6039102", "Cheras",
"6033270", "Batang\ Berjuntai",
"605254", "Ipoh",
"607652", "Kulai",
"604930", "Alor\ Setar",
"609832", "Merchang",
"604370", "Penang",
"604830", "Penang",
"609915", "Gua\ Musang",
"609573", "Kuantan",
"605296", "Tanjung\ Rambutan",
"606970", "Muar",
"6033241", "Sekinchan",
"606330", "Melaka",
"604790", "Pokok\ Sena",
"609815", "Kerteh",
"604406", "Padang\ Serai",
"6083555", "Bandar\ Sri\ Aman",
"609249", "Bera",
"6033169", "Kelang",
"6036048", "Kerling",
"605722", "Parit\ Buntar",
"60577", "Kuala\ Kangsar",
"605809", "Taiping",
"6035542", "Kinrara",
"6039765", "Cheras",
"6038991", "Cheras",
"6033213", "Hutan\ Melintang",
"6034812", "Kuala\ Lumpur",
"6085736", "Batu\ Niah",
"6087828", "Kuala\ Penyu",
"60755", "Senai",
"607742", "Lavang\-Lavang",
"609418", "Nenasi",
"6086251", "Bintulu",
"607906", "Segamat",
"606275", "Melaka",
"6032935", "Kuala\ Lumpur",
"609509", "Kuantan",
"6088881", "Ranau",
"604403", "Kulim",
"6032031", "Kuala\ Lumpur",
"6033323", "Kelang",
"6034299", "Kuala\ Lumpur",
"6039232", "Kuala\ Lumpur",
"605293", "Tanjung\ Rambutan",
"6034294", "Kuala\ Lumpur",
"6082685", "Kuching",
"607699", "Pontian",
"607879", "Linggiu",
"605654", "Kampong\ Gajah",
"6038723", "Semenyih",
"604407", "Serdang",
"6038011", "Kinrara",
"609759", "Pasirputih",
"6039011", "Cheras",
"605891", "Taiping",
"608733", "Keningau",
"6085402", "Miri",
"609486", "Jengka\ Tiga\ Belas",
"605671", "Sitiawan",
"6084696", "Bintangor",
"6038095", "Kinrara",
"6084754", "Kanowit",
"6088201", "Kota\ Kinabalu",
"606525", "Jasin",
"6036061", "Kuala\ Kubu\ Baru",
"6089201", "Elopura",
"6033260", "Kuala\ Selangor",
"609591", "Kuantan",
"604566", "Tasekgelugor",
"607252", "Johor\ Bahru",
"606498", "Batu\ Kikir",
"609455", "Bukit\ Ibam",
"6033884", "Kelang",
"607907", "Labis",
"6084773", "Song",
"6084222", "Sibu",
"605744", "Manong",
"6033268", "Kuala\ Selangor",
"609765", "Bachok",
"6032720", "Kuala\ Lumpur",
"6082627", "Kuching",
"606439", "Simpang\ Empat",
"6085766", "Marudi",
"609958", "Batu\ Gajah",
"6038775", "Mantin",
"6082707", "Kota\ Samarahan",
"6032600", "Kuala\ Lumpur",
"604612", "Penang",
"6039775", "Kuala\ Lumpur",
"609858", "Chukai",
"606984", "Bukit\ Gambir",
"6035124", "Kinrara",
"609223", "Bentong",
"609610", "Bandar\ Permaisuri",
"6033134", "Kelang",
"6088784", "Tuaran",
"6033179", "Kelang",
"6038521", "Sepang",
"6087505", "Labuan",
"6089244", "Elopura",
"609821", "Sri\ Gading",
"6039521", "Kuala\ Lumpur",
"6085395", "Miri",
"6089591", "Telupid",
"6089676", "Elopura",
"6089520", "Telupid",
"605212", "Ipoh",
"6032203", "Kuala\ Lumpur",
"6084681", "Sarikei",
"6084752", "Kanowit",
"6088745", "Kinarut",
"6085404", "Miri",
"6082790", "Tebedu",
"607587", "Senai",
"60463", "Penang",
"6089745", "Merotai",
"6036187", "Kuala\ Lumpur",
"6089285", "Elopura",
"607382", "Johor\ Bahru",
"6087737", "Tenom",
"60477", "Alor\ Setar",
"607477", "Sri\ Gading",
"6034292", "Kuala\ Lumpur",
"6088515", "Kota\ Kinabalu",
"604722", "Kulim",
"60667", "Seremban",
"6089515", "Beluran",
"6039274", "Kuala\ Lumpur",
"6087777", "Tambunan",
"6087465", "Labuan",
"6033197", "Banting",
"6089242", "Elopura",
"609863", "Chukai",
"605370", "Batu\ Gajah",
"6039200", "Kuala\ Lumpur",
"605930", "Sitiawan",
"603894", "Cheras",
"6088782", "Tuaran",
"6033132", "Tk\ Panglima\ Garang",
"609867", "Kemasik",
"6095070", "Kuantan",
"606560", "Simpang\ Empat",
"607705", "Keluang",
"6035122", "Kinrara",
"6082798", "Tebedu",
"605406", "Tapah",
"6085470", "Miri",
"6087211", "Beaufort",
"607518", "Senai",
"6036125", "Kuala\ Lumpur",
"606797", "Mantin",
"6032246", "Kuala\ Lumpur",
"604333", "Penang",
"6032786", "Kuala\ Lumpur",
"604515", "Tasekgelugor",
"6034023", "Kuala\ Lumpur",
"607409", "Parit\ Sulong",
"6084229", "Sibu",
"6084224", "Sibu",
"606793", "Mantin",
"606231", "Melaka",
"604254", "Penang",
"6088793", "Tuaran",
"606464", "Ladang\ Geddes",
"6085298", "Lawas",
"6084350", "Sibu",
"605612", "Sitiawan",
"6082383", "Kuching",
"6037660", "Kuala\ Lumpur",
"605395", "Besout",
"607586", "Senai",
"607300", "Johor\ Bahru",
"6084303", "Sibu",
"6033051", "Kelang",
"606644", "Port\ Dickson",
"6089666", "Elopura",
"604558", "Tasek\ Gelugor",
"6089921", "Balung",
"604744", "Alor\ Setar",
"606222", "Melaka",
"605479", "Tapah",
"6033610", "Kuala\ Selangor",
"6034065", "Kuala\ Lumpur",
"609713", "Kota\ Bharu",
"6034107", "Kuala\ Lumpur",
"6082824", "Asajaya",
"6032118", "Kuala\ Lumpur",
"604521", "Tasek\ Gelugor",
"6083547", "Maludam",
"6082829", "Asajaya",
"6032110", "Kuala\ Lumpur",
"6039130", "Kuala\ Lumpur",
"603228", "Kuala\ Lumpur",
"607364", "Johor\ Bahru",
"6039170", "Kuala\ Lumpur",
"6085221", "Limbang",
"6035544", "Kinrara",
"605403", "Tapah",
"609788", "Kok\ Lanas",
"6037890", "Kuala\ Lumpur",
"606391", "Tangga\ Batu",
"604293", "Penang",
"6034819", "Kuala\ Lumpur",
"606631", "Seremban",
"6085460", "Miri",
"6035549", "Kinrara",
"6087475", "Labuan",
"609966", "Kuala\ Krai",
"6089805", "Lahad\ Datu",
"6039141", "Kuala\ Lumpur",
"6033162", "Kelang",
"606771", "Seremban",
"609866", "Kemasik",
"6085290", "Lawas",
"604891", "Penang",
"6035623", "Kinrara",
"609476", "Maran",
"605681", "Sitiawan",
"6036034", "Rawang",
"606729", "Seremban",
"6085710", "Bekenu",
"6036039", "Kuala\ Lumpur",
"604629", "Penang",
"6089922", "Tawau",
"6082320", "Semantan",
"6085605", "Miri",
"6089567", "Kinabatangan",
"607889", "Kota\ Tinggi",
"6082391", "Kuching",
"609586", "Gebeng",
"6087480", "Labuan",
"609300", "Mentakab",
"6085540", "Miri",
"605855", "Taiping",
"6084810", "Julau",
"6085759", "Marudi",
"6082315", "Kuching",
"605768", "Lenggong",
"604941", "Kangar",
"606425", "Tampin",
"6082493", "Kuching",
"609555", "Kuantan",
"604466", "Bedong",
"609214", "Bentong",
"607661", "Kulai",
"6038999", "Cheras",
"6085733", "Batu\ Niah",
"6085222", "Limbang",
"6083467", "Sebuyau",
"6038994", "Cheras",
"6084833", "Matu",
"6086580", "Tatau",
"606656", "Port\ Dickson",
"6084766", "Kanowit",
"605421", "Besout",
"6033161", "Kelang",
"6084873", "Mukah",
"6088889", "Ranau",
"607788", "Kahang",
"6084818", "Daro",
"6086254", "Bintulu",
"607441", "Senggarang",
"606851", "Seremban",
"6082328", "Serian",
"6085718", "Bekenu",
"606334", "Melaka",
"604351", "Kepala\ Batas",
"606974", "Pagoh",
"606253", "Melaka",
"604794", "Ayer\ Hitam",
"6033216", "Sabak\ Bernam",
"6082807", "Simunjan",
"606694", "Rantau",
"605432", "Trolak",
"604463", "Jeniang",
"6086391", "Bintulu",
"605883", "Taiping",
"6084693", "Bintangor",
"6039019", "Cheras",
"608287", "Serian",
"604467", "Jeniang",
"605281", "Ipoh",
"6032034", "Kuala\ Lumpur",
"6082273", "Kuching",
"608981", "Felda\ Sahabat",
"6034291", "Kuala\ Lumpur",
"6032039", "Kuala\ Lumpur",
"6035198", "Kinrara",
"604229", "Penang",
"605415", "Tapah",
"6086320", "Bintulu",
"6033326", "Kelang",
"6082287", "Damai\ Beach",
"6088537", "Kota\ Kinabalu",
"609587", "Gebeng",
"6038726", "Semenyih",
"609583", "Gebeng",
"606980", "Bukit\ Gambir",
"6039050", "Cheras",
"6089537", "Elopura",
"6084682", "Sarikei",
"609477", "Maran",
"6089209", "Elopura",
"6085485", "Kampung\ Bakam",
"6088204", "Kota\ Kinabalu",
"6084751", "Kanowit",
"605719", "Parit\ Buntar",
"607720", "Mersing",
"6036064", "Kuala\ Kubu\ Baru",
"6089278", "Elopura",
"6033148", "Banting",
"609473", "Bukit\ Ibam",
"6089204", "Elopura",
"6082580", "Kota\ Samarahan",
"6033140", "Banting",
"607863", "Tiram",
"607867", "Tiram",
"6087212", "Beaufort",
"607261", "Johor\ Bahru",
"6039058", "Cheras",
"603831", "Putrajaya",
"6084645", "Sarikei",
"60745", "Sri\ Gading",
"604757", "Alor\ Setar",
"6086328", "Bintulu",
"6088781", "Tuaran",
"607530", "Senai",
"6088652", "Kotamarudu",
"6084736", "Julau",
"606411", "Simpang\ Empat",
"606653", "Port\ Dickson",
"6038529", "Mantin",
"6089241", "Elopura",
"606294", "Melaka",
"6083437", "Saratok",
"6087728", "Tenom",
"6082225", "Kuching",
"6035121", "Kinrara",
"6083477", "Betong",
"605328", "Ipoh",
"6084689", "Bintangor",
"6088618", "Kudat",
"6089202", "Elopura",
"609979", "Machang",
"6038780", "Mantin",
"6032295", "Kuala\ Lumpur",
"6084684", "Sarikei",
"608234", "Kuching",
"605834", "Taiping",
"6089618", "Elopura",
"6035568", "Kinrara",
"605351", "Batu\ Gajah",
"605794", "Grik",
"607759", "Ayer\ Hitam",
"607486", "Batu\ Pahat",
"609534", "Kuantan",
"6039231", "Kuala\ Lumpur",
"6082755", "Kuching",
"6039271", "Kuala\ Lumpur",
"6086484", "Balingan",
"6032032", "Kuala\ Lumpur",
"605756", "Kuala\ Kangsar",
"6039012", "Cheras",
"604869", "Penang",
"6089673", "Elopura",
"609252", "Triang",
"6085401", "Miri",
"6036136", "Kuala\ Lumpur",
"60628", "Melaka",
"604969", "Kuah",
"6089633", "Elopura",
"604250", "Penang",
"608241", "Kuching",
"605841", "Taiping",
"604768", "Alor\ Setar",
"607765", "Endau",
"6032783", "Kuala\ Lumpur",
"6089796", "Merotai",
"604986", "Kangar",
"6034026", "Kuala\ Lumpur",
"6087250", "Beaufort",
"605243", "Ipoh",
"608843", "Kota\ Kinabalu",
"608847", "Kota\ Kinabalu",
"6088796", "Tuaran",
"604886", "Penang",
"6038522", "Semenyih",
"605466", "Kampar",
"6088705", "Kota\ Kinabalu",
"6039547", "Cheras",
"605507", "Ipoh",
"606781", "Sepang",
"607227", "Johor\ Bahru",
"607223", "Johor\ Bahru",
"6036151", "Kuala\ Lumpur",
"6084221", "Sibu",
"609638", "Kuala\ Berang",
"6089705", "Tawau",
"609541", "Sungai\ Lembing",
"605629", "Telukintan",
"6033317", "Kelang",
"606240", "Melaka",
"6087214", "Beaufort",
"604955", "Kuah",
"607921", "Labis",
"607469", "Sri\ Gading",
"605646", "Bagan\ Datoh",
"6086457", "Belaga",
"6066920", "Linggi",
"6087219", "Beaufort",
"609778", "Bachok",
"6089663", "Elopura",
"605757", "Kuala\ Kangsar",
"6084395", "Sibu",
"6088663", "Kotamarudu",
"605753", "Kuala\ Kangsar",
"6087883", "Kuala\ Penyu",
"607360", "Johor\ Bahru",
"6035035", "Kinrara",
"6033242", "Sekinchan",
"608634", "Bintulu",
"607483", "Batu\ Pahat",
"604918", "Alor\ Setar",
"6082821", "Asajaya",
"607832", "Penawar",
"604818", "Penang",
"60668", "Rembau",
"6033010", "Pulau\ Ketam",
"6082668", "Kota\ Samarahan",
"60478", "Pokok\ Sena",
"6036211", "Kuala\ Lumpur",
"606318", "Melaka",
"607915", "Bukit\ Kepong",
"6039101", "Cheras",
"6082890", "Serian",
"6084306", "Sibu",
"6036032", "Rawang",
"6036243", "Kuala\ Lumpur",
"6082898", "Serian",
"605643", "Hutan\ Melintang",
"606460", "Bahau",
"605506", "Ipoh",
"607226", "Johor\ Bahru",
"605380", "Pusing",
"604719", "Sungai\ Petani",
"6086252", "Bintulu",
"607304", "Johor\ Bahru",
"606640", "Port\ Dickson",
"604432", "Kulim",
"604987", "Kangar",
"604740", "Alor\ Setar",
"605246", "Ipoh",
"609430", "Pekan",
"605467", "Kampar",
"6035541", "Kinrara",
"606387", "Kuala\ Sungai\ Baru",
"604281", "Penang",
"606472", "Kuala\ Klawang",
"6085224", "Limbang",
"6037481", "Kuala\ Lumpur",
"6034811", "Kuala\ Lumpur",
"6038992", "Cheras",
"609238", "Karak",
"607509", "Senai",
"604415", "Sungai\ Petani",
"606383", "Tangga\ Batu",
"608829", "Kota\ Kinabalu",
"607210", "Johor\ Bahru",
"6036737", "Kuala\ Kubu\ Baru",
"6098700", "Kemasik",
"6032392", "Kuala\ Lumpur",
"607445", "Batu\ Pahat",
"604240", "Penang",
"6037886", "Kuala\ Lumpur",
"6038990", "Cheras",
"609242", "Bera",
"6085758", "Marudi",
"6086584", "Tatau",
"606681", "Seremban",
"6085286", "Lawas",
"609738", "Kota\ Bharu",
"6033256", "Kelang",
"6039388", "Cheras",
"607710", "Keluang",
"6085635", "Miri",
"607665", "Kulai",
"608542", "Miri",
"607749", "Ayer\ Hitam",
"605598", "Chemor",
"606986", "Bakri",
"6088880", "Ranau",
"6082662", "Kota\ Samarahan",
"604668", "Penang",
"6036078", "Batu\ Arang",
"6032383", "Kuala\ Lumpur",
"604219", "Penang",
"604500", "Kulim",
"6036038", "Kuala\ Lumpur",
"6088396", "Kota\ Kinabalu",
"6087821", "Sipitang",
"6085719", "Bekenu",
"603762", "Kuala\ Lumpur",
"6082329", "Serian",
"6033271", "Batang\ Berjuntai",
"603401", "Kuala\ Lumpur",
"604945", "Kangar",
"6082324", "Asajaya",
"606421", "Bahau",
"606969", "Bukit\ Kepong",
"6089986", "Tawau",
"6089817", "Lahatdatu",
"609551", "Kuantan",
"6088888", "Ranau",
"606458", "Serting",
"6087484", "Labuan",
"604369", "Serdang",
"6084803", "Sibu",
"605685", "Sitiawan",
"6085750", "Marudi",
"607659", "Linggiu",
"609839", "Merchang",
"605253", "Ipoh",
"6038998", "Cheras",
"608251", "Kuching",
"604564", "Kepala\ Batas",
"6084850", "Dalat",
"6089274", "Elopura",
"6032721", "Kuala\ Lumpur",
"6089208", "Elopura",
"60442", "Sungai\ Petani",
"6084237", "Sibu",
"6038073", "Kinrara",
"6088612", "Kudat",
"606415", "Tampin",
"6033149", "Banting",
"6089612", "Elopura",
"609470", "Bukit\ Ibam",
"6089279", "Elopura",
"6035562", "Kinrara",
"606987", "Bakri",
"6033345", "Kelang",
"606432", "Gemencheh",
"609224", "Bentong",
"609580", "Gebeng",
"606983", "Bakri",
"6085665", "Miri",
"609278", "Mentakab",
"603795", "Kuala\ Lumpur",
"608741", "Labuan",
"604268", "Penang",
"6038520", "Kinrara",
"6039520", "Kuala\ Lumpur",
"604619", "Penang",
"603784", "Kuala\ Lumpur",
"6039018", "Cheras",
"604460", "Bedong",
"609701", "Kota\ Bharu",
"607265", "Johor\ Bahru",
"605743", "Manong",
"6032601", "Kuala\ Lumpur",
"605880", "Selama",
"607904", "Tenang",
"60782", "Penggerang",
"6087729", "Tenom",
"6033393", "Kelang",
"6034255", "Kuala\ Lumpur",
"6039010", "Cheras",
"6033101", "Pulau\ Ketam",
"605256", "Ipoh",
"607533", "Senai",
"6032030", "Kuala\ Lumpur",
"609752", "Pasir\ Putih",
"606650", "Port\ Dickson",
"6086324", "Bintulu",
"6039025", "Kuala\ Lumpur",
"6039059", "Cheras",
"6038025", "Kinrara",
"6039054", "Cheras",
"605285", "Ipoh",
"6082867", "Kota\ Samarahan",
"604404", "Mahang",
"607860", "Senai",
"607259", "Johor\ Bahru",
"605294", "Tanjung\ Rambutan",
"6033382", "Kelang",
"607960", "Gemas",
"604685", "Penang",
"606351", "Tangga\ Batu",
"604928", "Changlon",
"6082593", "Kuching",
"6085471", "Miri",
"604253", "Penang",
"606794", "Mantin",
"604828", "Penang",
"6032276", "Kuala\ Lumpur",
"604951", "Kuah",
"6039201", "Kuala\ Lumpur",
"607688", "Pontian",
"6086488", "Balingan",
"6038216", "Kuala\ Lumpur",
"607925", "Labis",
"6095071", "Kuantan",
"6087225", "Beaufort",
"6035192", "Kinrara",
"6035569", "Kinrara",
"606489", "Kuala\ Klawang",
"608245", "Kuching",
"6082639", "Kuching",
"604539", "Tasek\ Gelugor",
"603414", "Kuala\ Lumpur",
"6084366", "Sibu",
"607761", "Ayer\ Hitam",
"609205", "Jerantut",
"6089614", "Elopura",
"609864", "Kemasik",
"603673", "Kuala\ Lumpur",
"603893", "Cheras",
"6032685", "Kuala\ Lumpur",
"6033142", "Sepang",
"6089619", "Elopura",
"6083323", "Bandar\ Sri\ Aman",
"6089272", "Elopura",
"6036195", "Kuala\ Lumpur",
"6088614", "Kudat",
"6082582", "Kota\ Samarahan",
"605369", "Pusing",
"604598", "Parit\ Buntar",
"6089521", "Telupid",
"6082715", "Semantan",
"607428", "Senggarang",
"6087218", "Beaufort",
"606466", "Palong",
"6084680", "Sarikei",
"605668", "Sitiawan",
"607595", "Senai",
"6033185", "Banting",
"6082545", "Kuching",
"6089735", "Semporna",
"607220", "Johor\ Bahru",
"6085456", "Miri",
"6038052", "Kinrara",
"6035887", "Kinrara",
"607451", "Batu\ Pahat",
"6036143", "Kuala\ Lumpur",
"6086322", "Bintulu",
"605240", "Ipoh",
"6082720", "Lundu",
"6086480", "Balingan",
"6085310", "Limbang",
"606646", "Port\ Dickson",
"6082791", "Tebedu",
"607216", "Johor\ Bahru",
"6083567", "Lingga",
"605448", "Tanjung\ Malim",
"6087233", "Beaufort",
"609900", "Gua\ Musang",
"607288", "Johor\ Bahru",
"6032847", "Kuala\ Lumpur",
"607570", "Senai",
"6088928", "Papar",
"6039131", "Kuala\ Lumpur",
"6039171", "Kuala\ Lumpur",
"605404", "Tapah",
"608465", "Sarikei",
"6032106", "Kuala\ Lumpur",
"6082664", "Kota\ Samarahan",
"606757", "Mantin",
"6082669", "Kota\ Samarahan",
"6036276", "Kuala\ Lumpur",
"6089492", "Beluran",
"6039140", "Kuala\ Lumpur",
"605318", "Ipoh",
"607363", "Johor\ Bahru",
"6035167", "Kinrara",
"607562", "Senai",
"6085220", "Limbang",
"6085461", "Miri",
"6032266", "Kuala\ Lumpur",
"605750", "Kuala\ Kangsar",
"6087315", "Keningau",
"6083592", "Lubuk\ Antu",
"607217", "Johor\ Bahru",
"6033050", "Kelang",
"6084351", "Miri",
"607911", "Aver\ Panas",
"606643", "Port\ Dickson",
"609437", "Perwira\ Jaya",
"604747", "Alor\ Setar",
"60695", "Muar",
"6037661", "Kuala\ Lumpur",
"609714", "Kota\ Bharu",
"606647", "Port\ Dickson",
"604980", "Kangar",
"6084812", "Stapang",
"6087482", "Labuan",
"606229", "Melaka",
"603209", "Kuala\ Lumpur",
"6082899", "Serian",
"6089920", "Tawau",
"6082322", "Kuching",
"605640", "Hutan\ Melintang",
"606463", "Palong",
"6087391", "Keningau",
"606467", "Ayer\ Hitam",
"6088920", "Papar",
"6082894", "Serian",
"606697", "Linggi",
"609288", "Bukit\ Tinggi",
"6086581", "Tatau",
"604797", "Ayer\ Hitam",
"606333", "Melaka",
"609570", "Kuantan",
"606973", "Bukit\ Gambir",
"606977", "Tangkak",
"6038955", "Serdang",
"606337", "Melaka",
"6088415", "Kota\ Kinabalu",
"6033160", "Kelang",
"604572", "Tasek\ Gelugor",
"606693", "Rantau",
"6085462", "Miri",
"6032386", "Kuala\ Lumpur",
"609480", "Maran",
"604373", "Penang",
"604933", "Kuah",
"6088393", "Kota\ Kinabalu",
"604377", "Penang",
"606532", "Jasin",
"6037877", "Kuala\ Lumpur",
"6039172", "Kuala\ Lumpur",
"609367", "Dong",
"6086295", "Bintulu",
"605690", "Sitiawan",
"609363", "Fraser\ Hill",
"6037883", "Kuala\ Lumpur",
"6039132", "Kuala\ Lumpur",
"6085283", "Lawas",
"6085743", "Beluru",
"6089491", "Beluran",
"604560", "Kepala\ Batas",
"609217", "Mentakab",
"6088345", "Kota\ Kinabalu",
"6084806", "Kapit",
"6084811", "Mukah",
"6089937", "Luasong",
"609213", "Jengka\ Lapan\ Belas",
"6088977", "Kota\ Belud",
"6087481", "Labuan",
"6037118", "Kuala\ Lumpur",
"6082886", "Serian",
"60473", "Alor\ Setar",
"6033279", "Batang\ Berjuntai",
"6082321", "Kuching",
"6087392", "Keningau",
"6038893", "Putrajaya",
"607882", "Kota\ Tinggi",
"604309", "Sungai\ Petani",
"6085626", "Miri",
"608975", "Tawau",
"608875", "Kinarut",
"6037662", "Kuala\ Lumpur",
"6033168", "Kelang",
"6036044", "Kampong\ Suharto",
"6089983", "Tawau",
"6036049", "Kerling",
"6084352", "Sibu",
"6084895", "Kuala\ Igan",
"6048640", "Penang",
"6035115", "Kinrara",
"6089271", "Elopura",
"609688", "Kuala\ Brang",
"6054620", "Kampar",
"6032724", "Kuala\ Lumpur",
"604391", "Penang",
"6033141", "Sepang",
"6082581", "Kota\ Samarahan",
"606654", "Port\ Dickson",
"604548", "Tasek\ Gelugor",
"606293", "Melaka",
"609825", "Kerteh",
"6085472", "Miri",
"6038076", "Kinrara",
"6032604", "Kuala\ Lumpur",
"604936", "Kangar",
"6039076", "Cheras",
"604376", "Penang",
"6035120", "Kinrara",
"606696", "Linggi",
"604400", "Padang\ Serai",
"605525", "Ipoh",
"6088780", "Kota\ Kinabalu",
"6035191", "Kinrara",
"6038687", "Putrajaya",
"605290", "Tanjung\ Rambutan",
"606976", "Bukit\ Gambir",
"6089240", "Elopura",
"609402", "Chini",
"6039202", "Kuala\ Lumpur",
"6033170", "Kelang",
"606336", "Melaka",
"607964", "Bukit\ Gambir",
"606521", "Jasin",
"6089248", "Elopura",
"6086321", "Bintulu",
"6088788", "Tuaran",
"6084719", "Pakan",
"609474", "Kota\ Gelangi",
"6034290", "Kuala\ Lumpur",
"605439", "Tapah",
"6089717", "Tawau",
"6033109", "Pulau\ Ketam",
"604222", "Penang",
"6082737", "Lundu",
"609595", "Gebeng",
"6086390", "Bintulu",
"609220", "Bentong",
"609584", "Gebeng",
"609451", "Bandar\ Tun\ Razak",
"6038705", "Mantin",
"6084750", "Kanowit",
"6033269", "Kuala\ Selangor",
"6047455", "Alor\ Setar",
"603780", "Kuala\ Lumpur",
"6033264", "Kuala\ Selangor",
"6033396", "Kelang",
"6086423", "Sebauh",
"6038659", "Cheras",
"6038051", "Kinrara",
"604464", "Jeniang",
"605712", "Parit\ Buntar",
"6089967", "Lahad\ Datu",
"6039051", "Cheras",
"607900", "Tenggara",
"605675", "Changkat\ Keruing",
"6088967", "Tenghilan",
"605895", "Taiping",
"6035485", "Kinrara",
"6036263", "Kuala\ Lumpur",
"6084363", "Sibu",
"6082505", "Kuching",
"604511", "Padang\ Serai",
"6086307", "Bintulu",
"6085474", "Miri",
"607224", "Johor\ Bahru",
"6088695", "Kudat",
"6083326", "Bandar\ Sri\ Aman",
"608565", "Miri",
"6032602", "Kuala\ Lumpur",
"6089726", "Tawau",
"607278", "Johor\ Bahru",
"606235", "Melaka",
"6088606", "Kudat",
"6036103", "Genting",
"605622", "Telukintan",
"608844", "Kota\ Kinabalu",
"6089611", "Elopura",
"605244", "Ipoh",
"6032722", "Kuala\ Lumpur",
"6032273", "Kuala\ Lumpur",
"6088611", "Kudat",
"6082596", "Kuching",
"609265", "Jerantut",
"6038213", "Putrajaya",
"6032085", "Kuala\ Lumpur",
"6084220", "Sibu",
"6035561", "Kinrara",
"6036150", "Kuala\ Lumpur",
"6084228", "Sibu",
"604330", "Penang",
"609872", "Cheneh",
"6036158", "Kuala\ Lumpur",
"606790", "Mantin",
"6089524", "Telupid",
"605608", "Teluk\ Intan",
"609315", "Kuala\ Lipis",
"6033381", "Kelang",
"607752", "Lavang\-Lavang",
"6077120", "Keluang",
"605793", "Grik",
"608831", "Kota\ Kinabalu",
"6032027", "Kuala\ Lumpur",
"605837", "Selama",
"608237", "Kuching",
"604962", "Kuah",
"609860", "Chukai",
"6033102", "Pulau\ Ketam",
"6089865", "Lahad\ Datu",
"603745", "Kuala\ Lumpur",
"6085453", "Miri",
"609960", "Kuala\ Krai",
"608233", "Kuching",
"609358", "Raub",
"6032119", "Kuala\ Lumpur",
"6082661", "Kota\ Samarahan",
"6058307", "Selama",
"609445", "Bandar\ Tun\ Razak",
"6032114", "Kuala\ Lumpur",
"6036287", "Kuala\ Lumpur",
"6082828", "Asajaya",
"607898", "Tenggara",
"606384", "Tangga\ Batu",
"607678", "Pontian",
"609321", "Kuala\ Lipis",
"606612", "Kuala\ Klawang",
"6039134", "Kuala\ Lumpur",
"604884", "Penang",
"6039179", "Kuala\ Lumpur",
"6039139", "Kuala\ Lumpur",
"606775", "Seremban",
"607738", "Lavang\-Lavang",
"6032263", "Kuala\ Lumpur",
"6039174", "Kuala\ Lumpur",
"604984", "Kangar",
"609710", "Kota\ Bharu",
"609665", "Kuala\ Brang",
"6034810", "Kuala\ Lumpur",
"6037480", "Kuala\ Lumpur",
"6035540", "Kinrara",
"6032391", "Kuala\ Lumpur",
"607303", "Johor\ Bahru",
"608822", "Kota\ Kinabalu",
"6085299", "Lawas",
"6085617", "Miri",
"609726", "Kota\ Bharu",
"605644", "Hutan\ Melintang",
"608922", "Elopura",
"6036273", "Kuala\ Lumpur",
"606479", "Ayer\ Hitam",
"6088357", "Kota\ Kinabalu",
"608236", "Kuching",
"607528", "Kangkar\ Pulai",
"605836", "Selama",
"605208", "Ipoh",
"6037669", "Kuala\ Lumpur",
"6085680", "Miri",
"6037664", "Kuala\ Lumpur",
"605376", "Bota",
"6087405", "Labuan",
"6036042", "Kampong\ Suharto",
"609848", "Dungun",
"607484", "Batu\ Pahat",
"605796", "Grik",
"6035548", "Kinrara",
"604290", "Penang",
"6039100", "Cheras",
"6033272", "Batang\ Berjuntai",
"6033297", "Kelang",
"6038323", "Putrajaya",
"6038100", "Kinrara",
"6087822", "Sipitang",
"609659", "Batu\ Rakit",
"605771", "Grik",
"609536", "Kuantan",
"603269", "Kuala\ Lumpur",
"608633", "Bintulu",
"6033006", "Sabak\ Bernam",
"605631", "Kampong\ Gajah",
"605548", "Ipoh",
"604703", "Bedong",
"6088797", "Tuaran",
"606529", "Jasin",
"6038690", "Semenyih",
"606603", "Seremban",
"609868", "Chukai",
"6038024", "Kinrara",
"6039055", "Cheras",
"605431", "Besout",
"6034027", "Kuala\ Lumpur",
"6033182", "Banting",
"6082542", "Sejingkat",
"6084799", "Kapit",
"606546", "Durian\ Tunggal",
"6047451", "Alor\ Setar",
"605282", "Ipoh",
"6038966", "Cheras",
"608433", "Sibu",
"6082712", "Semantan",
"609786", "Pasirputih",
"607684", "Pontian",
"6034259", "Kuala\ Lumpur",
"6082228", "Kuching",
"607513", "Tanjung\ Kupang",
"6088360", "Kota\ Kinabalu",
"6087725", "Tenom",
"604924", "Changlon",
"6032776", "Kuala\ Lumpur",
"6086325", "Bintulu",
"6039546", "Cheras",
"604824", "Penang",
"606798", "Mantin",
"609755", "Kota\ Bharu",
"6087773", "Tambunan",
"6087222", "Beaufort",
"6082291", "Kuching",
"6035195", "Kinrara",
"604779", "Pokok\ Sena",
"6087733", "Tenom",
"6088368", "Kota\ Kinabalu",
"604399", "Penang",
"6084671", "Sarikei",
"607262", "Johor\ Bahru",
"6084631", "Selalang",
"6082220", "Kuching",
"6033145", "Banting",
"6036177", "Kuala\ Lumpur",
"6089275", "Elopura",
"605664", "Sitiawan",
"6036192", "Kuala\ Lumpur",
"6039514", "Kuala\ Lumpur",
"604475", "Kupang",
"6036137", "Kuala\ Lumpur",
"604594", "Parit\ Buntar",
"6038749", "Semenyih",
"609769", "Bachok",
"6033344", "Kelang",
"6034287", "Kuala\ Lumpur",
"607424", "Rengit",
"6033349", "Kelang",
"606435", "Tampin",
"6085664", "Miri",
"6087718", "Tenom",
"6038744", "Semenyih",
"6084640", "Sarikei",
"6085720", "Batu\ Niah",
"6033086", "Kelang",
"606901", "Muar",
"605682", "Changkat\ Keruing",
"6084891", "Selangau",
"605540", "Ipoh",
"6088330", "Kota\ Kinabalu",
"6084820", "Daro",
"609919", "Ayer\ Lanas",
"607516", "Tanjung\ Kupang",
"6085791", "Miri",
"6087312", "Keningau",
"609819", "Paka",
"609783", "Bachok",
"609840", "Dungun",
"606547", "Durian\ Tunggal",
"6036736", "Batu\ Arang",
"6087851", "Kuala\ Penyu",
"604298", "Penang",
"6082325", "Serian",
"609787", "Machang",
"607520", "Senai",
"6088341", "Kota\ Kinabalu",
"607295", "Johor\ Bahru",
"6084815", "Rejang",
"6087485", "Labuan",
"6086461", "Belaga",
"607662", "Kulai",
"6034103", "Kuala\ Lumpur",
"6093260", "Padang\ Tengku",
"6086291", "Bintulu",
"6087442", "Labuan",
"609505", "Kuantan",
"6038870", "Putrajaya",
"6082471", "Kuching",
"609245", "Triang",
"606852", "Melaka",
"6084307", "Sibu",
"6088304", "Kota\ Kinabalu",
"6084661", "Sarikei",
"604557", "Tasek\ Gelugor",
"6084828", "Daro",
"6088309", "Kota\ Kinabalu",
"6032859", "Kuala\ Lumpur",
"607442", "Senggarang",
"609718", "Kota\ Bharu",
"609350", "Raub",
"605805", "Taiping",
"607990", "Bakri",
"6088411", "Kota\ Kinabalu",
"6038951", "Cheras",
"607890", "Linggiu",
"607670", "Kulai",
"6089903", "Merotai",
"6088903", "Papar",
"605594", "Chemor",
"6035523", "Kinrara",
"6083466", "Debak",
"609856", "Chukai",
"6039410", "Cheras",
"6087303", "Keningau",
"6089950", "Balung",
"6082895", "Serian",
"6087314", "Keningau",
"6033217", "Sabak\ Bernam",
"609417", "Nenasi",
"603261", "Kuala\ Lumpur",
"6036460", "Kerling",
"609413", "Kuala\ Rompin",
"6033288", "Kuala\ Selangor",
"6087319", "Keningau",
"609651", "Batu\ Rakit",
"6037948", "Kuala\ Lumpur",
"6035030", "Kinrara",
"6089871", "Tungku",
"607791", "Felda\ Tenggaroh",
"6099200", "Ayer\ Lanas",
"6087401", "Labuan",
"6082843", "Damai\ Beach",
"606496", "Kuala\ Klawang",
"604568", "Sungai\ Bakap",
"6089566", "Kinabatangan",
"609602", "Bandar\ Permaisuri",
"6037940", "Kuala\ Lumpur",
"6033280", "Kuala\ Selangor",
"609329", "Padangtengku",
"6036081", "Batu\ Arang",
"605698", "Sitiawan",
"608224", "Kuching",
"6088302", "Kota\ Kinabalu",
"6084398", "Sibu",
"6037971", "Kuala\ Lumpur",
"6035721", "Kinrara",
"607944", "Segamat",
"6089856", "Kunak",
"6037931", "Kuala\ Lumpur",
"6086286", "Bintulu",
"6089848", "Kunak",
"609280", "Lanchang",
"6082665", "Kota\ Samarahan",
"606471", "Simpang\ Durian",
"604282", "Penang",
"6038331", "Putrajaya",
"6085632", "Miri",
"6034821", "Kuala\ Lumpur",
"6088861", "Bongawan",
"6082750", "Kota\ Samarahan",
"6089861", "Lahad\ Datu",
"607908", "Bekok",
"604264", "Penang",
"6034252", "Kuala\ Lumpur",
"606550", "Tampin",
"6033385", "Kelang",
"60458", "Sungai\ Bakap",
"609853", "Chukai",
"609228", "Bilut\ Valley",
"6083436", "Saratok",
"609957", "Batu\ Gajah",
"6049373", "Kangar",
"6089708", "Tawau",
"60447", "Baling",
"6038022", "Kinrara",
"6033184", "Banting",
"6083308", "Bandar\ Sri\ Aman",
"6082544", "Kuching",
"6083339", "Bandar\ Sri\ Aman",
"6082549", "Kuching",
"6084777", "Song",
"604408", "Kulim",
"6085662", "Miri",
"6032081", "Kuala\ Lumpur",
"608242", "Kuching",
"6083300", "Bandar\ Sri\ Aman",
"6035565", "Kinrara",
"6033342", "Kelang",
"604200", "Penang",
"6032298", "Kuala\ Lumpur",
"6089615", "Elopura",
"6088615", "Kudat",
"609680", "Kuala\ Brang",
"609542", "Sungai\ Lembing",
"6082501", "Kuching",
"6037711", "Kuala\ Lumpur",
"604540", "Tasek\ Gelugor",
"606782", "Seremban",
"6038727", "Semenyih",
"606497", "Rembau",
"604314", "Penang",
"60787", "Kota\ Tinggi",
"607822", "Penawar",
"6087229", "Beaufort",
"6089536", "Elopura",
"60769", "Air\ Baloi",
"6035481", "Kinrara",
"6087224", "Beaufort",
"606493", "Kuala\ Klawang",
"6082286", "Kuching",
"607922", "Bekok",
"60733", "Johor\ Bahru",
"6088536", "Kota\ Kinabalu",
"6038655", "Cheras",
"6038090", "Kinrara",
"605732", "Parit\ Buntar",
"606663", "Tekok\ Kemang",
"605440", "Tapah",
"609236", "Bilut\ Valley",
"6088552", "Telupid",
"6047454", "Alor\ Setar",
"606667", "Sepang",
"6033265", "Kuala\ Selangor",
"6039021", "Kuala\ Lumpur",
"6032733", "Kuala\ Lumpur",
"605892", "Semanggol",
"608848", "Kota\ Kinabalu",
"605672", "Sitiawan",
"6038021", "Kinrara",
"6039543", "Cheras",
"6032222", "Kuala\ Lumpur",
"6032773", "Kuala\ Lumpur",
"6089862", "Lahad\ Datu",
"6094310", "Pekan",
"6086351", "Bintulu",
"609637", "Kuala\ Brang",
"609633", "Bandar\ Permaisuri",
"606266", "Sungai\ Rambai",
"607228", "Johor\ Bahru",
"6032247", "Kuala\ Lumpur",
"6032787", "Kuala\ Lumpur",
"607274", "Johor\ Bahru",
"6087508", "Labuan",
"605419", "Tapah",
"607420", "Senggarang",
"609592", "Kuantan",
"6038778", "Mantin",
"607251", "Johor\ Bahru",
"609773", "Kota\ Bharu",
"6038963", "Cheras",
"6034251", "Kuala\ Lumpur",
"605323", "Ipoh",
"6037712", "Kuala\ Lumpur",
"603214", "Kuala\ Lumpur",
"6032605", "Kuala\ Lumpur",
"6084634", "Pakan",
"606316", "Durian\ Tunggal",
"6089677", "Elopura",
"6082502", "Kuching",
"6039770", "Kuala\ Lumpur",
"6082688", "Kuching",
"6035482", "Kinrara",
"609405", "Pekan",
"6082294", "Kuching",
"605522", "Ipoh",
"6035103", "Kinrara",
"6082299", "Kuching",
"604916", "Alor\ Setar",
"603300", "Kelang",
"607680", "Pontian",
"6033341", "Kelang",
"6087776", "Keningau",
"6087736", "Tenom",
"604611", "Penang",
"6087863", "Bongawan",
"6038741", "Semenyih",
"6032082", "Kuala\ Lumpur",
"6085661", "Miri",
"604453", "Kulim",
"6032725", "Kuala\ Lumpur",
"6036186", "Kuala\ Lumpur",
"60969", "Jerteh",
"609822", "Al\ Muktafi\ Billa\ H\ Shah",
"604920", "Kangar",
"604820", "Penang",
"609776", "Bachok",
"605648", "Hutan\ Melintang",
"608872", "Kinarut",
"606429", "Bahau",
"6038768", "Semenyih",
"609559", "Kuantan",
"6087402", "Labuan",
"6084480", "Sibu",
"6087810", "Sipitang",
"6084894", "Stapang",
"605468", "Kampar",
"6088344", "Kota\ Kinabalu",
"6033083", "Kelang",
"604888", "Penang",
"6032938", "Kuala\ Lumpur",
"607734", "Ayer\ Hitam",
"6088349", "Kota\ Kinabalu",
"604625", "Penang",
"607651", "Layang\-Layang",
"609831", "Paka",
"604988", "Kangar",
"607413", "Batu\ Pahat",
"607885", "Kota\ Tinggi",
"609237", "Bilut\ Valley",
"6087854", "Bongawan",
"606666", "Sepang",
"609233", "Genting",
"6033275", "Batang\ Berjuntai",
"605859", "Taiping",
"607674", "Pontian",
"606388", "Kuala\ Sungai\ Baru",
"604766", "Alor\ Setar",
"6093140", "Kuala\ Lipis",
"607894", "Kota\ Tinggi",
"6086294", "Bintulu",
"6037932", "Kuala\ Lumpur",
"6057180", "Parit\ Buntar",
"6037972", "Kuala\ Lumpur",
"6036093", "Rawang",
"605758", "Kuala\ Kangsar",
"6085631", "Miri",
"6088403", "Kota\ Kinabalu",
"6087833", "Menumbok",
"605310", "Ipoh",
"6087766", "Tambunan",
"604789", "Alor\ Setar",
"605721", "Parit\ Buntar",
"609565", "Kuantan",
"6034266", "Kuala\ Lumpur",
"6086469", "Belaga",
"609844", "Dungun",
"604913", "Alor\ Setar",
"607488", "Batu\ Pahat",
"6087818", "Sipitang",
"6038959", "Cheras",
"60929", "Mentakab",
"607741", "Felda\ Kahang\ Timur",
"606512", "Jasin",
"6088414", "Kota\ Kinabalu",
"609944", "Ayer\ Lanas",
"605349", "Batu\ Gajah",
"6087887", "Membakut",
"604917", "Alor\ Setar",
"604485", "Padang\ Serai",
"6082474", "Kuching",
"6038760", "Semenyih",
"607578", "Senai",
"6088301", "Kota\ Kinabalu",
"6088667", "Kota\ Marudu",
"6034106", "Kuala\ Lumpur",
"6089667", "Elopura",
"606317", "Melaka",
"6087852", "Menumbok",
"6082803", "Simunjan",
"603778", "Kuala\ Lumpur",
"6036057", "Kuala\ Kubu\ Baru",
"605920", "Sitiawan",
"607919", "Labis",
"6088342", "Kota\ Kinabalu",
"608220", "Kuching",
"605820", "Taiping",
"6082850", "Serian",
"6087409", "Labuan",
"6033620", "Kelang",
"604323", "Penang",
"607783", "Keluang",
"6084877", "Mukah",
"6087438", "Labuan",
"6084892", "Selangau",
"6033099", "Pulau\ Ketam",
"6037665", "Kuala\ Lumpur",
"607940", "Segamat",
"6088906", "Papar",
"6087478", "Labuan",
"60448", "Kulim",
"6087404", "Labuan",
"607787", "Keluang",
"606221", "Melaka",
"609284", "Mentakab",
"609520", "Kuantan",
"6087311", "Keningau",
"6083463", "Debak",
"6085792", "Mulu",
"6035526", "Kinrara",
"60457", "Kepala\ Batas",
"6085737", "Batu\ Niah",
"604522", "Tasek\ Gelugor",
"604660", "Penang",
"6032303", "Kuala\ Lumpur",
"6088853", "Ranau",
"6036084", "Batu\ Arang",
"609662", "Kuala\ Brang",
"6086283", "Bintulu",
"6082472", "Kuching",
"6084662", "Sarikei",
"6088943", "Kota\ Belud",
"6089853", "Kunak",
"6038952", "Cheras",
"6088412", "Kota\ Kinabalu",
"608825", "Kota\ Kinabalu",
"605225", "Ipoh",
"604419", "Sungai\ Petani",
"607505", "Tanjung\ Kupang",
"6085295", "Lawas",
"6032191", "Kuala\ Lumpur",
"6038308", "Putrajaya",
"605763", "Lenggong",
"606632", "Seremban",
"6085206", "Kampung\ Pahlawan",
"6082846", "Damai\ Beach",
"6032115", "Kuala\ Lumpur",
"6078011", "Mersing",
"6086462", "Bakun",
"605767", "Lenggong",
"6089563", "Kinabatangan",
"604672", "Penang",
"604892", "Penang",
"6035613", "Kinrara",
"604248", "Penang",
"606615", "Kuala\ Klawang",
"6039175", "Kuala\ Lumpur",
"6087441", "Labuan",
"6086292", "Bintulu",
"6082530", "Kuching",
"603806", "Kinrara",
"6083473", "Betong",
"607868", "Tiram",
"6088740", "Kinarut",
"6085767", "Marudi",
"6089280", "Elopura",
"6082626", "Kuching",
"607968", "Gemas",
"6083340", "Bandar\ Sri\ Aman",
"605485", "Cameron\ Highland",
"6089869", "Lahad\ Datu",
"6087468", "Labuan",
"6089864", "Lahad\ Datu",
"6089510", "Beluran",
"607786", "Felda\ Kahang\ Timur",
"605211", "Ipoh",
"6033181", "Banting",
"609975", "Machang",
"609684", "Bukit\ Bading",
"606910", "Muar",
"6032224", "Kuala\ Lumpur",
"6082541", "Sejingkat",
"606658", "Sepang",
"6036128", "Kuala\ Lumpur",
"604758", "Alor\ Setar",
"6047452", "Alor\ Setar",
"6033856", "Sabak\ Bernam",
"6082711", "Semantan",
"604310", "Penang",
"607381", "Johor\ Bahru",
"607755", "Renggam",
"609312", "Kuala\ Lipis",
"6083418", "Bandar\ Sri\ Aman",
"604468", "Bedong",
"6083410", "Kabong",
"6032681", "Kuala\ Lumpur",
"605888", "Taiping",
"605625", "Telukintan",
"6034009", "Kuala\ Lumpur",
"6036191", "Kuala\ Lumpur",
"6089533", "Elopura",
"604260", "Penang",
"604959", "Kuah",
"6032084", "Kuala\ Lumpur",
"6036120", "Kuala\ Lumpur",
"6036303", "Genting",
"6032089", "Kuala\ Lumpur",
"6082283", "Kuching",
"6088533", "Kota\ Kinabalu",
"604859", "Penang",
"605766", "Lenggong",
"606554", "Tampin",
"6089518", "Beluran",
"6039205", "Kuala\ Lumpur",
"6087460", "Labuan",
"6088518", "Kota\ Kinabalu",
"6035484", "Kinrara",
"6087221", "Beaufort",
"6082292", "Kuching",
"609270", "Mentakab",
"6083425", "Roban",
"6033831", "Semenyih",
"6083348", "Bandar\ Sri\ Aman",
"6084632", "Selalang",
"6089748", "Tawau",
"6089288", "Elopura",
"606232", "Melaka",
"6082504", "Kuching",
"6037719", "Kuala\ Lumpur",
"6085475", "Miri",
"609478", "Maran",
"6082538", "Kuching",
"604593", "Parit\ Buntar",
"6087237", "Beaufort",
"60472", "Alor\ Setar",
"607427", "Senggarang",
"6038708", "Mantin",
"6039779", "Kuala\ Lumpur",
"607423", "Rengit",
"6083563", "Engkilili",
"6082221", "Kuching",
"6035125", "Kinrara",
"604597", "Parit\ Buntar",
"6038779", "Mantin",
"604615", "Penang",
"609770", "Bachok",
"6033135", "Kelang",
"6082290", "Kuching",
"6088785", "Tuaran",
"6035892", "Kinrara",
"607950", "Aver\ Panas",
"6087504", "Labuan",
"604392", "Penang",
"6087462", "Labuan",
"607850", "Tiram",
"6087509", "Labuan",
"609630", "Kuala\ Brang",
"605667", "Bruas",
"6035110", "Kinrara",
"6036122", "Kuala\ Lumpur",
"6084641", "Sarikei",
"603551", "Kinrara",
"604760", "Alor\ Setar",
"6032026", "Kuala\ Lumpur",
"606660", "Tekok\ Kemang",
"605443", "Tapah",
"609762", "Pasir\ Putih",
"6038861", "Putrajaya",
"604827", "Penang",
"6084613", "Selalang",
"6038094", "Kinrara",
"60536", "Batu\ Gajah",
"6083327", "Bandar\ Sri\ Aman",
"6084755", "Kanowit",
"604923", "Changlon",
"6085481", "Bekenu",
"6089727", "Tawau",
"604927", "Ayer\ Hitam",
"606522", "Jasin",
"6034032", "Kuala\ Lumpur",
"6047450", "Alor\ Setar",
"607340", "Johor\ Bahru",
"604258", "Penang",
"607683", "Pontian",
"609452", "Bukit\ Ibam",
"6038691", "Semenyih",
"6089463", "Elopura",
"607514", "Tanjung\ Kupang",
"605289", "Pusing",
"60648", "Kuala\ Pilah",
"608989", "Lahad\ Datu",
"607687", "Pontian",
"607255", "Johor\ Bahru",
"6033885", "Kelang",
"6089512", "Beluran",
"6088512", "Kota\ Kinabalu",
"6082684", "Kuching",
"6034295", "Kuala\ Lumpur",
"608434", "Sibu",
"6056340", "Kampong\ Gajah",
"604704", "Pokok\ Sena",
"6033123", "Tk\ Panglima\ Garang",
"605320", "Ipoh",
"6083342", "Bandar\ Sri\ Aman",
"6082597", "Kuching",
"6088361", "Kota\ Kinabalu",
"6088607", "Kudat",
"6088742", "Kinarut",
"6082532", "Kuching",
"6086290", "Bintulu",
"6093261", "Padang\ Tengku",
"607745", "Renggam",
"604571", "Tasek\ Gelugor",
"605446", "Tapah",
"6038871", "Putrajaya",
"607218", "Johor\ Bahru",
"606648", "Port\ Dickson",
"608261", "Kuching",
"604748", "Alor\ Setar",
"604554", "Tasek\ Gelugor",
"6086460", "Belaga",
"606531", "Jasin",
"609438", "Perwira\ Jaya",
"6088356", "Kota\ Kinabalu",
"605429", "Trolak",
"6088348", "Kota\ Kinabalu",
"6084898", "Sibu",
"6087472", "Labuan",
"605388", "Bota",
"6033007", "Kuala\ Selangor",
"6038950", "Cheras",
"6033165", "Kelang",
"6084660", "Sarikei",
"607426", "Parit\ Betak",
"6039769", "Cheras",
"606468", "Ayer\ Hitam",
"609561", "Kuantan",
"605725", "Parit\ Buntar",
"6038769", "Semenyih",
"607283", "Johor\ Bahru",
"6084821", "Daro",
"605689", "Sitiawan",
"6088331", "Kota\ Kinabalu",
"604621", "Penang",
"609835", "Dungun",
"6085790", "Miri",
"607655", "Kulai",
"6082311", "Kuching",
"609784", "Pasirputih",
"6036286", "Kuala\ Lumpur",
"6038958", "Cheras",
"6035163", "Kinrara",
"607881", "Air\ Tawar",
"604810", "Penang",
"606544", "Durian\ Tunggal",
"606758", "Mantin",
"609912", "Gua\ Musang",
"6082306", "Kuching",
"6087803", "Sipitang",
"605535", "Tanjung\ Rambutan",
"6085601", "Miri",
"605313", "Ipoh",
"606965", "Tangkak",
"6086468", "Belaga",
"6085616", "Miri",
"604949", "Kangar",
"607686", "Pontian",
"604826", "Penang",
"604926", "Ayer\ Hitam",
"6087850", "Kuala\ Penyu",
"6086298", "Bintulu",
"6033362", "Kelang",
"6035545", "Kinrara",
"6033281", "Kuala\ Selangor",
"609609", "Bandar\ Permaisuri",
"607241", "Johor\ Bahru",
"6034815", "Kuala\ Lumpur",
"60979", "Kota\ Bharu",
"6082887", "Serian",
"607780", "Kahang",
"6087439", "Labuan",
"604320", "Penang",
"6089936", "Luasong",
"6035653", "Kinrara",
"6088976", "Kota\ Belud",
"6087408", "Labuan",
"607943", "Tenang",
"606611", "Kuala\ Klawang",
"609322", "Kuala\ Lipis",
"6037941", "Kuala\ Lumpur",
"6087479", "Labuan",
"6084807", "Sibu",
"6034820", "Kuala\ Lumpur",
"608223", "Kuching",
"608921", "Elopura",
"6038912", "Semenyih",
"6082766", "Bau",
"604289", "Penang",
"608821", "Kota\ Kinabalu",
"6085627", "Miri",
"6039105", "Cheras",
"6037876", "Kuala\ Lumpur",
"603205", "Kuala\ Lumpur",
"6032387", "Kuala\ Lumpur",
"6089951", "Balung",
"6039411", "Cheras",
"6082825", "Asajaya",
"604447", "Bedong",
"608486", "Dalat",
"6086508", "Bintulu",
"609414", "Kuala\ Rompin",
"608759", "Labuan",
"609276", "Mentakab",
"6087812", "Sipitang",
"6088830", "Tuaran",
"605597", "Chemor",
"6035031", "Kinrara",
"605632", "Kampong\ Gajah",
"6087453", "Labuan",
"6082402", "Kuching",
"6032333", "Kuala\ Lumpur",
"6084391", "Sibu",
"6036461", "Kerling",
"6082810", "Asajaya",
"604667", "Penang",
"6083414", "Kabong",
"604313", "Penang",
"605849", "Taiping",
"606494", "Kuala\ Klawang",
"6082863", "Kota\ Samarahan",
"6036124", "Kuala\ Lumpur",
"6032080", "Kuala\ Lumpur",
"6088701", "Kinarut",
"6089716", "Tawau",
"6089701", "Tawau",
"604512", "Penang",
"6089868", "Lahad\ Datu",
"6087464", "Labuan",
"6083450", "Saratok",
"6088966", "Kota\ Belud",
"609549", "Gambang",
"605621", "Telukintan",
"6089966", "Lahad\ Datu",
"6087502", "Labuan",
"6035480", "Kinrara",
"6082553", "Kuching",
"607929", "Aver\ Panas",
"6039223", "Kuala\ Lumpur",
"6039772", "Kuala\ Lumpur",
"605810", "Taiping",
"6088690", "Kota\ Marudu",
"6037710", "Kuala\ Lumpur",
"6037718", "Kuala\ Lumpur",
"6089289", "Elopura",
"6088744", "Kinarut",
"6085405", "Miri",
"6089749", "Tawau",
"6082539", "Kuching",
"6083344", "Bandar\ Sri\ Aman",
"609277", "Mentakab",
"6039235", "Kuala\ Lumpur",
"6082682", "Kuching",
"605359", "Batu\ Gajah",
"609954", "Machang",
"6089519", "Beluran",
"6082751", "Bau",
"609854", "Chukai",
"6089514", "Beluran",
"606988", "Bakri",
"6088519", "Kota\ Kinabalu",
"607751", "Lavang\-Lavang",
"605596", "Chemor",
"604263", "Penang",
"608832", "Kota\ Kinabalu",
"6039368", "Kuala\ Lumpur",
"6085266", "Lawas",
"6038686", "Putrajaya",
"604267", "Penang",
"6032088", "Kuala\ Lumpur",
"605481", "Tanjung\ Malim",
"6037733", "Kuala\ Lumpur",
"6037866", "Kuala\ Lumpur",
"607599", "Senai",
"604961", "Kuah",
"6038092", "Kinrara",
"6085496", "Ladang\ Tiga",
"6037773", "Kuala\ Lumpur",
"605546", "Ipoh",
"6035886", "Kinrara",
"6089622", "Elopura",
"6087501", "Labuan",
"6038525", "Mantin",
"604471", "Sungai\ Bakap",
"609538", "Kuantan",
"6086449", "Pelagus",
"607510", "Senai",
"605529", "Ipoh",
"6032023", "Kuala\ Lumpur",
"607209", "Johor\ Bahru",
"6034258", "Kuala\ Lumpur",
"6039771", "Kuala\ Lumpur",
"6082224", "Kuching",
"606431", "Gemencheh",
"604454", "Sungai\ Petani",
"609946", "Ayer\ Lanas",
"605798", "Lenggong",
"608742", "Labuan",
"6083566", "Pantu",
"609846", "Kuala\ Brang",
"603620", "Kuala\ Lumpur",
"6089702", "Tawau",
"604700", "Alor\ Setar",
"6088702", "Kinarut",
"6084798", "Kapit",
"6085660", "Miri",
"609829", "Paka",
"6084644", "Sarikei",
"603217", "Kuala\ Lumpur",
"6038740", "Semenyih",
"605838", "Selama",
"6084790", "Kapit",
"6085668", "Miri",
"6038699", "Semenyih",
"609774", "Kota\ Bharu",
"6033348", "Kelang",
"6038020", "Kinrara",
"607277", "Johor\ Bahru",
"6088205", "Kota\ Kinabalu",
"6038091", "Kinrara",
"6033126", "Tk\ Panglima\ Garang",
"605899", "Semanggol",
"6036065", "Kuala\ Kubu\ Baru",
"609634", "Bandar\ Permaisuri",
"605679", "Sitiawan",
"609751", "Kota\ Bharu",
"6089205", "Elopura",
"6087750", "Tenom",
"6089296", "Elopura",
"6088369", "Kota\ Kinabalu",
"6084367", "Sibu",
"6034250", "Kuala\ Lumpur",
"6086303", "Bintulu",
"6088364", "Kota\ Kinabalu",
"6089466", "Elopura",
"607896", "Tenggara",
"604764", "Alor\ Setar",
"605412", "Trolak",
"6094311", "Pekan",
"6086350", "Bintulu",
"609599", "Gambang",
"6032035", "Kuala\ Lumpur",
"606664", "Tekok\ Kemang",
"609356", "Raub",
"6082681", "Kuching",
"6082752", "Kuching",
"605203", "Chemor",
"607523", "Senai",
"6086255", "Bintulu",
"60779", "Mersing",
"604497", "Bedong",
"6085630", "Miri",
"603216", "Kuala\ Lumpur",
"607527", "Kangkar\ Pulai",
"6088885", "Ranau",
"604914", "Alor\ Setar",
"609780", "Kok\ Lanas",
"609947", "Ayer\ Lanas",
"605801", "Taiping",
"6038911", "Semenyih",
"60793", "Segamat",
"606540", "Durian\ Tunggal",
"6088451", "Kinarut",
"606682", "Seremban",
"6038761", "Semenyih",
"606519", "Jasin",
"6033361", "Kelang",
"608541", "Miri",
"6038995", "Cheras",
"6033282", "Kuala\ Selangor",
"605547", "Ipoh",
"605543", "Ipoh",
"6088353", "Kota\ Kinabalu",
"607897", "Tiram",
"607677", "Pontian",
"6082314", "Kuching",
"6036277", "Kuala\ Lumpur",
"6035032", "Kinrara",
"606422", "Tampin",
"609353", "Raub",
"609234", "Karak",
"6087811", "Sipitang",
"6085613", "Miri",
"6032107", "Kuala\ Lumpur",
"6085755", "Marudi",
"6089436", "Kinabatangan",
"607893", "Kota\ Tinggi",
"6082319", "Kuching",
"6088334", "Kota\ Kinabalu",
"60443", "Sungai\ Petani",
"6036462", "Kerling",
"60974", "Kota\ Bharu",
"6088308", "Kota\ Kinabalu",
"6084392", "Sibu",
"6032858", "Kuala\ Lumpur",
"609552", "Kuantan",
"6082401", "Kuching",
"607414", "Rengit",
"607276", "Johor\ Bahru",
"6032267", "Kuala\ Lumpur",
"6038800", "Putrajaya\/Cyberjaya",
"6089952", "Balung",
"6036035", "Batuarang",
"6036075", "Kuala\ Kubu\ Baru",
"6093141", "Kuala\ Lipis",
"6084383", "Sibu",
"6085604", "Miri",
"605852", "Taiping",
"6035166", "Kinrara",
"6082303", "Kuching",
"604305", "Penang",
"6085638", "Miri",
"6085609", "Miri",
"6037949", "Kuala\ Lumpur",
"6039145", "Kuala\ Lumpur",
"6033860", "Sekinchan",
"609669", "Batu\ Rakit",
"6037859", "Kuala\ Lumpur",
"6087431", "Labuan",
"6088801", "Tuaran",
"6085225", "Limbang",
"6082763", "Bau",
"604412", "Penang",
"6033284", "Kuala\ Selangor",
"6033289", "Kuala\ Selangor",
"606475", "Ayer\ Hitam",
"6087318", "Keningau",
"609410", "Pekan",
"6038872", "Putrajaya",
"6093262", "Padang\ Tengku",
"6087440", "Labuan",
"6088973", "Kota\ Belud",
"6079010", "Tenggara",
"607561", "Senai",
"604899", "Penang",
"6078010", "Mersing",
"606978", "Tangkak",
"6084405", "Sibu",
"606698", "Linggi",
"6085287", "Lawas",
"6032336", "Kuala\ Lumpur",
"604324", "Penang",
"6037887", "Kuala\ Lumpur",
"6089959", "Lahad\ Datu",
"607784", "Kahang",
"6089925", "Tawau",
"604938", "Kangar",
"604378", "Penang",
"607795", "Felda\ Tenggaroh",
"607912", "Aver\ Panas",
"6089849", "Kunak",
"609981", "Kuala\ Krai",
"604838", "Penang",
"6089954", "Balung",
"6037873", "Kuala\ Lumpur",
"6084394", "Sibu",
"6088397", "Kota\ Kinabalu",
"609368", "Raub",
"6088332", "Kota\ Kinabalu",
"609686", "Kuala\ Brang",
"6035039", "Kinrara",
"6033868", "Batang\ Berjuntai",
"605581", "Chemor",
"6082312", "Kuching",
"604607", "Penang",
"6083338", "Bandar\ Sri\ Aman",
"6088704", "Kota\ Kinabalu",
"6084642", "Sarikei",
"6083309", "Bandar\ Sri\ Aman",
"609423", "Chini",
"606352", "Tangga\ Batu",
"6089704", "Tawau",
"6088709", "Kinarut",
"6082548", "Kuching",
"609950", "Machang",
"604852", "Penang",
"6087215", "Beaufort",
"6039226", "Kuala\ Lumpur",
"6083411", "Kabong",
"609269", "Damak",
"604952", "Kuah",
"6083406", "Maludam",
"609850", "Chukai",
"6082222", "Kuching",
"6089713", "Tawau",
"6087461", "Labuan",
"6035891", "Kinrara",
"607762", "Renggam",
"6087228", "Beaufort",
"6088511", "Kota\ Kinabalu",
"6089506", "Beluran",
"6089511", "Beluran",
"609340", "Sungai\ Koyan",
"6085263", "Sundar",
"6086485", "Belaga",
"606490", "Rembau",
"6088741", "Kinarut",
"6037863", "Kuala\ Lumpur",
"6088362", "Kota\ Kinabalu",
"6082531", "Kuching",
"6083341", "Bandar\ Sri\ Aman",
"603749", "Kuala\ Lumpur",
"6085493", "Sundar",
"6084236", "Sibu",
"609687", "Bukit\ Bading",
"609255", "Triang",
"6089281", "Elopura",
"6058710", "Semanggol",
"6032299", "Kuala\ Lumpur",
"6034031", "Kuala\ Lumpur",
"6039086", "Cheras",
"6032688", "Kuala\ Lumpur",
"6085482", "Kampung\ Bakam",
"6033180", "Banting",
"605782", "Kuala\ Kangsar",
"6089730", "Tawau",
"609286", "Kuala\ Krau",
"604901", "Changlon",
"603207", "Kuala\ Lumpur",
"6089814", "Tungku",
"609712", "Kota\ Bharu",
"6088931", "Kota\ Belud",
"606958", "Bukit\ Gambir",
"607448", "Batu\ Pahat",
"6089560", "Kinabatangan",
"607781", "Paloh",
"606227", "Melaka",
"6037946", "Kuala\ Lumpur",
"605389", "Bota",
"604710", "Alor\ Setar",
"6088971", "Kota\ Belud",
"607240", "Johor\ Bahru",
"604358", "Tasek\ Gelugor",
"606469", "Kemavan",
"6082808", "Simunjan",
"6085717", "Bekenu",
"609735", "Kota\ Bharu",
"607386", "Johor\ Bahru",
"607668", "Kulai",
"6089850", "Kunak",
"6088940", "Kota\ Belud",
"605595", "Chemor",
"6083468", "Sebuyau",
"605617", "Telukintan",
"605613", "Teluk\ Intan",
"607500", "Tanjung\ Kupang",
"607219", "Johor\ Bahru",
"6088850", "Ranau",
"605220", "Ipoh",
"6082761", "Bau",
"6032300", "Kuala\ Lumpur",
"6035625", "Kinrara",
"6087340", "Keningau",
"6035162", "Kinrara",
"609525", "Kuantan",
"604292", "Penang",
"6085231", "Kampung\ Pahlawan",
"6088858", "Ranau",
"6037831", "Kuala\ Lumpur",
"6084305", "Sibu",
"6087459", "Labuan",
"6083460", "Sebuyau",
"607945", "Tenang",
"6039191", "Kuala\ Lumpur",
"605688", "Sitiawan",
"608225", "Kuching",
"6085240", "Kampung\ Pahlawan",
"6035036", "Kinrara",
"6087802", "Sipitang",
"604536", "Tasek\ Gelugor",
"6089568", "Kinabatangan",
"606759", "Mantin",
"6084880", "Daro",
"606486", "Simpang\ Durian",
"6089706", "Tawau",
"6086327", "Bintulu",
"6089711", "Tawau",
"6087463", "Labuan",
"607387", "Johor\ Bahru",
"6082731", "Lundu",
"604727", "Bedong",
"605616", "Bruas",
"6083438", "Saratok",
"6083562", "Roban",
"606509", "Jasin",
"6039224", "Kuala\ Lumpur",
"6087727", "Tenom",
"6082864", "Kota\ Samarahan",
"603798", "Kuala\ Lumpur",
"6083413", "Kabong",
"605811", "Taiping",
"6082280", "Kuching",
"6035882", "Kinrara",
"607268", "Johor\ Bahru",
"6089570", "Kinabatangan",
"606226", "Melaka",
"6039057", "Cheras",
"6034025", "Kuala\ Lumpur",
"6088961", "Kota\ Belud",
"6036123", "Kuala\ Lumpur",
"605620", "Telukintan",
"6089462", "Elopura",
"6089538", "Elopura",
"6082699", "Kuching",
"604537", "Tasek\ Gelugor",
"6034285", "Kuala\ Lumpur",
"607750", "Lavang\-Lavang",
"6088538", "Kota\ Kinabalu",
"6082288", "Kuching",
"6089277", "Elopura",
"605367", "Pusing",
"606792", "Sepang",
"6084612", "Rejang",
"6084234", "Sibu",
"609970", "Machang",
"6036436", "Genting",
"6084239", "Sibu",
"604332", "Penang",
"6037734", "Kuala\ Lumpur",
"6036135", "Kuala\ Lumpur",
"6032296", "Kuala\ Lumpur",
"604860", "Penang",
"605480", "Tanjung\ Malim",
"6083343", "Bandar\ Sri\ Aman",
"6038084", "Kinrara",
"6033122", "Tk\ Panglima\ Garang",
"6083430", "Saratok",
"6085491", "Miri",
"6083470", "Betong",
"604960", "Kuah",
"609862", "Chukai",
"6088743", "Kinarut",
"6037861", "Kuala\ Lumpur",
"604259", "Penang",
"6038752", "Semenyih",
"605288", "Pusing",
"6089513", "Beluran",
"608988", "Lahad\ Datu",
"6088513", "Kota\ Kinabalu",
"604925", "Ayer\ Hitam",
"604688", "Penang",
"6035889", "Kinrara",
"6039548", "Cheras",
"609548", "Gambang",
"609754", "Bachok",
"609631", "Kuala\ Brang",
"6082226", "Kuching",
"607928", "Aver\ Panas",
"606966", "Bakri",
"607685", "Pontian",
"607257", "Johor\ Bharu",
"6082862", "Kota\ Samarahan",
"607253", "Johor\ Bahru",
"6033318", "Kelang",
"607828", "Penawar",
"609771", "Kota\ Bharu",
"605536", "Tanjung\ Rambutan",
"6038787", "Mantin",
"606661", "Tekok\ Kemang",
"608248", "Kuching",
"605848", "Taiping",
"605292", "Tanjung\ Rambutan",
"6083564", "Engkilili",
"6039222", "Kuala\ Lumpur",
"6083569", "Engkilili",
"6032021", "Kuala\ Lumpur",
"604402", "Kulim",
"6084646", "Sarikei",
"607656", "Kulai",
"609208", "Sungai\ Tekam",
"6082552", "Kuching",
"6087503", "Labuan",
"609936", "Kuala\ Balah",
"605726", "Parit\ Buntar",
"6038725", "Semenyih",
"6044110", "Serdang",
"609222", "Bentong",
"6082683", "Kuching",
"604595", "Parit\ Buntar",
"604451", "Jeniang",
"6033325", "Kelang",
"606434", "Jelai",
"604613", "Penang",
"604220", "Penang",
"607425", "Parit\ Betak",
"6033359", "Kelang",
"6033129", "Tk\ Panglima\ Garang",
"6086301", "Bintulu",
"605665", "Sitiawan",
"6039082", "Cheras",
"607598", "Senai",
"6038082", "Kinrara",
"6033124", "Tk\ Panglima\ Garang",
"607902", "Tangkak",
"6034161", "Kuala\ Lumpur",
"6088366", "Kota\ Kinabalu",
"6089617", "Elopura",
"6037732", "Kuala\ Lumpur",
"605321", "Ipoh",
"605710", "Parit\ Buntar",
"6038093", "Kinrara",
"6037772", "Kuala\ Lumpur",
"6084614", "Rejang",
"6084232", "Sibu",
"6088617", "Kudat",
"605358", "Batu\ Gajah",
"6032770", "Kuala\ Lumpur",
"6038605", "Kinrara",
"6039540", "Kuala\ Lumpur",
"606989", "Bakri",
"6089464", "Elopura",
"6032730", "Kuala\ Lumpur",
"6035567", "Kinrara",
"607746", "Renggam",
"6088469", "Kota\ Kinabalu",
"60645", "Bahau",
"60794", "Gemas",
"606530", "Jasin",
"6088351", "Kota\ Kinabalu",
"6035652", "Kinrara",
"607657", "Kulai",
"609833", "Bukit\ Besi",
"6085555", "Miri",
"609937", "Kuala\ Balah",
"604570", "Tasek\ Gelugor",
"604288", "Penang",
"6036738", "Kuala\ Kubu\ Baru",
"6033363", "Kelang",
"609572", "Kuantan",
"609231", "Karak",
"6036090", "Rawang",
"606967", "Bakri",
"6033291", "Kelang",
"607256", "Johor\ Bahru",
"6038913", "Semenyih",
"605533", "Tanjung\ Rambutan",
"604562", "Kepala\ Batas",
"605537", "Tanjung\ Rambutan",
"6098000", "Kerteh",
"6035270", "Kinrara",
"606963", "Tangkak",
"609560", "Kuantan",
"604367", "Serdang",
"605692", "Sitiawan",
"605872", "Semanggol",
"6036021", "Batuarang",
"6084765", "Kanowit",
"605804", "Taiping",
"607743", "Keluang",
"607880", "Kota\ Tinggi",
"6082301", "Kuching",
"6058301", "Taiping",
"6088408", "Kota\ Kinabalu",
"604911", "Alor\ Setar",
"6082667", "Kota\ Samarahan",
"607980", "Bakri",
"6036281", "Kuala\ Lumpur",
"604811", "Penang",
"6033080", "Kelang",
"607747", "Ayer\ Hitam",
"60444", "Sungai\ Petani",
"609244", "Triang",
"606311", "Melaka",
"604217", "Penang",
"6084381", "Sibu",
"606720", "Seremban",
"604620", "Penang",
"60735", "Johor\ Bahru",
"6034131", "Kuala\ Lumpur",
"6082403", "Kuching",
"6032332", "Kuala\ Lumpur",
"6087452", "Labuan",
"60676", "Seremban",
"605727", "Parit\ Buntar",
"604616", "Penang",
"6085611", "Miri",
"6035164", "Kinrara",
"608544", "Miri",
"605723", "Parit\ Buntar",
"608758", "Labuan",
"6082871", "Baki",
"609285", "Mentakab",
"609653", "Batu\ Rakit",
"6033277", "Kuala\ Selangor",
"609294", "Kuala\ Krau",
"6082831", "Sebangan",
"607482", "Kangkar\ Baru",
"603263", "Kuala\ Lumpur",
"6033292", "Kelang",
"6036022", "Batu\ Arang",
"60449", "Kulim",
"6088979", "Kota\ Belud",
"6087436", "Labuan",
"6087476", "Labuan",
"6088908", "Papar",
"607793", "Endau",
"605752", "Kuala\ Kangsar",
"6036047", "Kerling",
"609256", "Triang",
"6035651", "Kinrara",
"6088352", "Kota\ Kinabalu",
"6085200", "Limbang",
"6082840", "Damai\ Beach",
"607560", "Senai",
"6033283", "Kuala\ Selangor",
"6082764", "Bau",
"604982", "Kangar",
"6037879", "Kuala\ Lumpur",
"6088665", "Kotamarudu",
"604714", "Alor\ Setar",
"6087451", "Labuan",
"6032331", "Kuala\ Lumpur",
"609980", "Kuala\ Krai",
"6084393", "Sibu",
"6089665", "Elopura",
"6037839", "Kuala\ Lumpur",
"606614", "Kuala\ Klawang",
"6037874", "Kuala\ Lumpur",
"606477", "Palong",
"607244", "Johor\ Bahru",
"6035033", "Kinrara",
"6085612", "Miri",
"6087885", "Kuala\ Penyu",
"606473", "Kemavan",
"608978", "Semporna",
"6035591", "Kinrara",
"605642", "Hutan\ Melintang",
"608824", "Kota\ Kinabalu",
"607504", "Tanjung\ Kupang",
"6082302", "Kuching",
"605470", "Kampar",
"6035520", "Kinrara",
"6089843", "Kunak",
"6084382", "Sibu",
"6032022", "Kuala\ Lumpur",
"6082734", "Lundu",
"609951", "Machang",
"607754", "Ayer\ Hitam",
"6082708", "Kota\ Samarahan",
"605799", "Lenggong",
"6039221", "Kuala\ Lumpur",
"609851", "Chukai",
"6082739", "Lundu",
"609928", "Gua\ Musang",
"6082551", "Kuching",
"6089623", "Elopura",
"605379", "Batu\ Gajah",
"609974", "Machang",
"6084717", "Pakan",
"609685", "Kuala\ Brang",
"609828", "Paka",
"6084788", "Kapit",
"6036126", "Kuala\ Lumpur",
"604545", "Sungai\ Bakap",
"6032245", "Kuala\ Lumpur",
"605839", "Selama",
"6032785", "Kuala\ Lumpur",
"6089714", "Tawau",
"609874", "Kemasik",
"6088969", "Kota\ Belud",
"6034051", "Kuala\ Lumpur",
"607400", "Rengit",
"6089703", "Tawau",
"6089969", "Lahad\ Datu",
"6087466", "Labuan",
"604964", "Kuah",
"6088703", "Kinarut",
"6038657", "Cheras",
"609539", "Kuantan",
"605528", "Ipoh",
"607208", "Johor\ Bahru",
"6082628", "Kuching",
"6089746", "Tawau",
"6037771", "Kuala\ Lumpur",
"6032727", "Kuala\ Lumpur",
"6082620", "Kuching",
"6062710", "Sungai\ Rambai",
"6049370", "Kangar",
"6084231", "Sibu",
"6089286", "Elopura",
"607222", "Johor\ Bahru",
"6034162", "Kuala\ Lumpur",
"6088746", "Kinarut",
"6082536", "Kuching",
"6037731", "Kuala\ Lumpur",
"609598", "Gambang",
"6047930", "Pokok\ Sena",
"606491", "Simpang\ Durian",
"6088516", "Kota\ Kinabalu",
"606476", "Ladang\ Geddes",
"6085264", "Sundar",
"6038684", "Putrajaya",
"6084780", "Kapit",
"6038689", "Putrajaya",
"6082700", "Lundu",
"6085494", "Bekenu",
"6032742", "Kuala\ Lumpur",
"6088675", "Pantai\ Pitas",
"6038081", "Kinrara",
"605242", "Ipoh",
"608842", "Kota\ Kinabalu",
"605898", "Semanggol",
"605678", "Bruas",
"6033850", "Banting",
"605624", "Hutan\ Melintang",
"6039081", "Cheras",
"6089675", "Elopura",
"6036433", "Genting",
"607511", "Senai",
"6083485", "Betong",
"6039776", "Kuala\ Lumpur",
"6084555", "Sibu",
"604306", "Penang",
"609582", "Gebeng",
"6038776", "Mantin",
"60655", "Durian\ Tunggal",
"606430", "Gemencheh",
"604224", "Penang",
"60942", "Pekan",
"606906", "Muar",
"6088962", "Papar",
"6087506", "Labuan",
"6034270", "Kuala\ Lumpur",
"605437", "Tapah",
"606601", "Seremban",
"609460", "Maran",
"6087730", "Tenom",
"6089712", "Tawau",
"604701", "Bedong",
"6033198", "Banting",
"6087770", "Tambunan",
"605714", "Parit\ Buntar",
"604462", "Jeniang",
"605433", "Tapah",
"6082797", "Tebedu",
"609268", "Damak",
"6085765", "Marudi",
"6082223", "Kuching",
"6032024", "Kuala\ Lumpur",
"608431", "Sibu",
"6088363", "Kota\ Kinabalu",
"6036188", "Kuala\ Lumpur",
"6037862", "Kuala\ Lumpur",
"6084695", "Bintangor",
"609750", "Kota\ Bharu",
"6085492", "Bekenu",
"6039207", "Kuala\ Lumpur",
"607970", "Segamat",
"6033190", "Banting",
"6035131", "Kinrara",
"6038751", "Semenyih",
"6082275", "Kuching",
"6087738", "Tenom",
"6034278", "Kuala\ Lumpur",
"6083427", "Roban",
"6082686", "Kuching",
"609404", "Pekan",
"607862", "Tiram",
"6089461", "Elopura",
"60549", "Cameron\ Highland",
"607884", "Kota\ Tinggi",
"609355", "Raub",
"606398", "Tangga\ Batu",
"6082762", "Bau",
"609781", "Machang",
"6085735", "Batu\ Niah",
"606638", "Kuala\ Pilah",
"607675", "Pontian",
"607895", "Air\ Tawar",
"6086360", "Bintulu",
"606541", "Durian\ Tunggal",
"605436", "Tapah",
"609240", "Kemayan",
"6084875", "Mukah",
"6034260", "Kuala\ Lumpur",
"604242", "Penang",
"604898", "Penang",
"6087760", "Tenom",
"606907", "Muar",
"6036690", "Batuarang",
"6036055", "Kuala\ Kubu\ Baru",
"6092590", "Karak",
"609668", "Batu\ Rakit",
"6088972", "Kota\ Belud",
"6032180", "Kuala\ Lumpur",
"6038873", "Putrajaya",
"604307", "Penang",
"6039766", "Cheras",
"6038766", "Semenyih",
"6057970", "Grik",
"6034100", "Kuala\ Lumpur",
"606534", "Jasin",
"604551", "Tasek\ Gelugor",
"608264", "Kuching",
"605205", "Ipoh",
"6084384", "Sibu",
"6034108", "Kuala\ Lumpur",
"609369", "Dong",
"6083548", "Maludam",
"609845", "Dungun",
"606252", "Melaka",
"6082304", "Kota\ Samarahan",
"6032117", "Kuala\ Lumpur",
"6082309", "Kuching",
"6087801", "Sipitang",
"609945", "Ayer\ Lanas",
"606979", "Tangkak",
"6085614", "Miri",
"6087768", "Tambunan",
"6035161", "Kinrara",
"603772", "Kuala\ Lumpur",
"604799", "Pokok\ Sena",
"6082313", "Kuching",
"606699", "Linggi",
"6085297", "Lawas",
"6037872", "Kuala\ Lumpur",
"605545", "Ipoh",
"6037832", "Kuala\ Lumpur",
"6088333", "Kota\ Kinabalu",
"6084823", "Daro",
"6082495", "Kuching",
"6083220", "Bandar\ Sri\ Aman",
"607362", "Johor\ Bharu",
"6037870", "Kuala\ Lumpur",
"6087313", "Keningau",
"6083461", "Debak",
"6085270", "Lawas",
"6033167", "Kelang",
"6088904", "Papar",
"6087406", "Labuan",
"6088938", "Kota\ Belud",
"6088909", "Papar",
"607930", "Labis",
"6087304", "Keningau",
"609918", "Gua\ Musang",
"6083585", "Lubukantu",
"607830", "Penggerang",
"609650", "Batu\ Rakit",
"6035524", "Kinrara",
"609818", "Kerteh",
"6085241", "Kampung\ Pahlawan",
"6087443", "Labuan",
"605477", "Kampar",
"6034102", "Kuala\ Lumpur",
"6035611", "Kinrara",
"605473", "Bagan\ Datoh",
"609719", "Kota\ Bharu",
"606701", "Linggi",
"6089561", "Kinabatangan",
"6032182", "Kuala\ Lumpur",
"605614", "Sitiawan",
"606462", "Palong",
"6088970", "Kota\ Belud",
"605583", "Chemor",
"6032193", "Kuala\ Lumpur",
"609281", "Kuala\ Krau",
"6087341", "Keningau",
"6085238", "Limbang",
"604906", "Changlon",
"609415", "Kuala\ Rompin",
"604238", "Penang",
"6086506", "Bintulu",
"6082844", "Damai\ Beach",
"6034262", "Kuala\ Lumpur",
"6089851", "Kunak",
"6086281", "Bintulu",
"6089941", "Tawau",
"6032301", "Kuala\ Lumpur",
"6082760", "Bau",
"6088851", "Ranau",
"6038408", "Cheras",
"606224", "Melaka",
"606642", "Port\ Dickson",
"606278", "Melaka",
"606379", "Tangga\ Batu",
"6082713", "Semantan",
"6082629", "Kuching",
"6089866", "Lahad\ Datu",
"6088968", "Kota\ Belud",
"603892", "Semenyih",
"607407", "Parit\ Sulong",
"604699", "Alor\ Setar",
"6082543", "Kuching",
"6033183", "Banting",
"6089968", "Lahad\ Datu",
"606799", "Mantin",
"6088787", "Tuaran",
"604252", "Penang",
"6089718", "Tawau",
"609869", "Kemasik",
"6033192", "Banting",
"609250", "Triang",
"6089247", "Elopura",
"6033177", "Kelang",
"6036145", "Kuala\ Lumpur",
"6084789", "Kapit",
"606551", "Simpang\ Empat",
"606495", "Simpang\ Durian",
"609458", "Bukit\ Ibam",
"609345", "Raub",
"6082709", "Kota\ Samarahan",
"6065110", "Jasin",
"6083471", "Betong",
"604201", "Penang",
"6082730", "Lundu",
"6082770", "Bau",
"6088605", "Kudat",
"609768", "Bachok",
"6087223", "Beaufort",
"6087772", "Tambunan",
"6085268", "Sundar",
"6083310", "Bandar\ Sri\ Aman",
"604903", "Kuah",
"6034297", "Kuala\ Lumpur",
"6038688", "Putrajaya",
"6082741", "Lundu",
"6082281", "Kuching",
"609955", "Machang",
"6088960", "Tenghilan",
"604778", "Pokok\ Sena",
"606242", "Melaka",
"609855", "Chukai",
"6089531", "Elopura",
"6036193", "Kuala\ Lumpur",
"605476", "Kampar",
"609681", "Kuala\ Brang",
"6083325", "Bandar\ Sri\ Aman",
"604398", "Penang",
"6089725", "Tawau",
"6036419", "Kuala\ Lumpur",
"6082506", "Kuching",
"6047456", "Alor\ Setar",
"6033852", "Banting",
"6038961", "Cheras",
"6032028", "Kuala\ Lumpur",
"6086300", "Bintulu",
"6034253", "Kuala\ Lumpur",
"609229", "Bilut\ Valley",
"608838", "Kota\ Kinabalu",
"605806", "Taiping",
"609467", "Maran",
"609246", "Bera",
"605430", "Besout",
"6032771", "Kuala\ Lumpur",
"607722", "Renggam",
"60777", "Keluang",
"6038023", "Kinrara",
"6036157", "Kuala\ Lumpur",
"6032731", "Kuala\ Lumpur",
"609380", "Jerantut",
"6038706", "Mantin",
"606437", "Johol",
"606433", "Jelai",
"6049372", "Kangar",
"604614", "Penang",
"6082622", "Kuching",
"607296", "Johor\ Bahru",
"6039075", "Cheras",
"604705", "Alor\ Setar",
"603625", "Kuala\ Lumpur",
"6038075", "Kinrara",
"603888", "Putrajaya",
"6086952", "Bintulu",
"6036412", "Kuala\ Lumpur",
"6087861", "Bongawan",
"6085663", "Miri",
"607708", "Keluang",
"6033343", "Kelang",
"6087734", "Tenom",
"607697", "Pontian",
"607515", "Tanjung\ Kupang",
"604409", "Kulim",
"6035101", "Kinrara",
"605299", "Tanjung\ Rambutan",
"6034279", "Kuala\ Lumpur",
"607254", "Johor\ Bahru",
"6087739", "Tenom",
"6087774", "Tambunan",
"6036189", "Kuala\ Lumpur",
"604518", "Tasekgelugor",
"6085407", "Miri",
"607271", "Johor\ Bahru",
"609753", "Bachok",
"6036184", "Kuala\ Lumpur",
"6032020", "Kuala\ Lumpur",
"607532", "Senai",
"6084380", "Sibu",
"6035522", "Kinrara",
"606436", "Johol",
"608543", "Miri",
"6087302", "Keningau",
"6089902", "Merotai",
"6082300", "Kuching",
"6036028", "Batu\ Arang",
"6058300", "Taiping",
"604476", "Kupang",
"6084896", "Stapang",
"6033081", "Kelang",
"605541", "Ipoh",
"6088902", "Papar",
"6036280", "Kuala\ Lumpur",
"609243", "Triang",
"6085610", "Miri",
"60723", "Johor\ Bahru",
"604555", "Tasek\ Gelugor",
"607521", "Senai",
"605201", "Chemor",
"609466", "Maran",
"6088346", "Kota\ Kinabalu",
"6084805", "Kuala\ Igan",
"609247", "Bera",
"607744", "Ayer\ Hitam",
"6087848", "Sipitang",
"609841", "Dungun",
"6082885", "Serian",
"605807", "Taiping",
"608852", "Kota\ Kinabalu",
"609489", "Maran",
"6088303", "Kota\ Kinabalu",
"6086296", "Bintulu",
"607696", "Pontian",
"6088350", "Kota\ Kinabalu",
"6032800", "Kuala\ Lumpur",
"6082842", "Damai\ Beach",
"6085202", "Limbang",
"6034264", "Kuala\ Lumpur",
"6086466", "Sebauh",
"606964", "Tangkak",
"6085618", "Miri",
"609351", "Raub",
"6087871", "Weston",
"6038956", "Serdang",
"6082827", "Asajaya",
"609785", "Pasirputih",
"6083549", "Pantu",
"607891", "Kota\ Tinggi",
"604569", "Kepala\ Batas",
"6085633", "Miri",
"6088401", "Kota\ Kinabalu",
"606545", "Durian\ Tunggal",
"6082308", "Kuching",
"6036020", "Batu\ Arang",
"609794", "Kok\ Lanas",
"6087831", "Menumbok",
"607297", "Johor\ Bahru",
"6033290", "Kelang",
"609328", "Kuala\ Lipis",
"6036091", "Rawang",
"605699", "Sitiawan",
"609834", "Bukit\ Besi",
"6032385", "Kuala\ Lumpur",
"607654", "Linggiu",
"6098001", "Kerteh",
"6034104", "Kuala\ Lumpur",
"605469", "Kampar",
"6087403", "Labuan",
"6033093", "Pulau\ Ketam",
"607302", "Johor\ Bahru",
"608221", "Kuching",
"604989", "Kangar",
"60626", "Melaka",
"607507", "Tanjung\ Kupang",
"6083469", "Sebuyau",
"608827", "Kota\ Kinabalu",
"608923", "Elopura",
"605610", "Telukintan",
"608823", "Kota\ Kinabalu",
"6083464", "Debak",
"6032330", "Kuala\ Lumpur",
"6037910", "Kuala\ Lumpur",
"605858", "Taiping",
"608258", "Kuching",
"6087450", "Labuan",
"6082809", "Simunjan",
"605649", "Hutan\ Melintang",
"605765", "Lenggong",
"6087301", "Keningau",
"609521", "Kuantan",
"6038325", "Putrajaya",
"6087316", "Keningau",
"606428", "Kuala\ Pilah",
"6082878", "Baki",
"6085784", "Bakun",
"6082804", "Simunjan",
"6035521", "Kinrara",
"606474", "Palong",
"609558", "Kuantan",
"6033082", "Kelang",
"6086257", "Bintulu",
"605626", "Telukintan",
"606617", "Kuala\ Klawang",
"6035590", "Kinrara",
"604717", "Pokok\ Sena",
"60741", "Parit\ Sulong",
"6089818", "Lahad\ Datu",
"6089901", "Merotai",
"606613", "Kuala\ Klawang",
"604434", "Padang\ Serai",
"6087832", "Menumbok",
"607756", "Renggam",
"605591", "Lintang",
"6088402", "Kota\ Kinabalu",
"6087872", "Weston",
"605348", "Batu\ Gajah",
"6089569", "Kinabatangan",
"6037933", "Kuala\ Lumpur",
"6032265", "Kuala\ Lumpur",
"6036037", "Rawang",
"6035614", "Kinrara",
"609976", "Machang",
"6082830", "Sebangan",
"6036092", "Rawang",
"6089854", "Kunak",
"604966", "Kuah",
"6086284", "Bintulu",
"607785", "Keluang",
"605486", "Cameron\ Highland",
"6084375", "Sibu",
"6088854", "Ranau",
"6089859", "Kunak",
"607794", "Endau",
"604866", "Penang",
"605759", "Kuala\ Kangsar",
"607934", "Labis",
"6086860", "Bintulu",
"6036275", "Kuala\ Lumpur",
"6087344", "Keningau",
"6085201", "Limbang",
"6035650", "Kinrara",
"6047931", "Pokok\ Sena",
"604716", "Alor\ Setar",
"6032732", "Kuala\ Lumpur",
"6032772", "Kuala\ Lumpur",
"605210", "Ipoh",
"6032223", "Kuala\ Lumpur",
"605623", "Telukintan",
"6082690", "Kuching",
"6049371", "Kangar",
"6082621", "Kuching",
"6037770", "Kuala\ Lumpur",
"605418", "Tapah",
"607467", "Sri\ Gading",
"6082868", "Kota\ Samarahan",
"6038080", "Kinrara",
"607506", "Senai",
"6082701", "Lundu",
"608826", "Kota\ Kinabalu",
"605226", "Ipoh",
"6039080", "Cheras",
"6038962", "Cheras",
"606620", "Port\ Dickson",
"6033851", "Banting",
"6083408", "Maludam",
"6082716", "Semantan",
"6083474", "Debak",
"607380", "Johor\ Bahru",
"6083439", "Saratok",
"6089736", "Tawau",
"6085455", "Miri",
"608849", "Kota\ Kinabalu",
"605249", "Ipoh",
"6089863", "Lahad\ Datu",
"6038527", "Mantin",
"60644", "Tampin",
"6082546", "Kuching",
"6088863", "Bongawan",
"6082550", "Kuching",
"6032037", "Kuala\ Lumpur",
"6035483", "Kinrara",
"604261", "Penang",
"605792", "Grik",
"6035102", "Kinrara",
"6037713", "Kuala\ Lumpur",
"6036196", "Kuala\ Lumpur",
"604967", "Kuah",
"609708", "Kota\ Bharu",
"6084365", "Sibu",
"6082503", "Kuching",
"605487", "Cameron\ Highland",
"604963", "Kuah",
"6032686", "Kuala\ Lumpur",
"6036411", "Kuala\ Lumpur",
"6088207", "Kota\ Kinabalu",
"6082860", "Kota\ Samarahan",
"6032275", "Kuala\ Lumpur",
"6086951", "Bintulu",
"609254", "Triang",
"609977", "Machang",
"6036105", "Genting",
"609873", "Cheneh",
"6084238", "Sibu",
"6089207", "Elopura",
"606480", "Ayer\ Hitam",
"6082698", "Kuching",
"6087226", "Beaufort",
"6082284", "Kuching",
"604530", "Tasek\ Gelugor",
"6088534", "Kota\ Kinabalu",
"6034050", "Kuala\ Lumpur",
"60445", "Bedong",
"607757", "Renggam",
"607753", "Renggam",
"609271", "Mentakab",
"6032083", "Kuala\ Lumpur",
"6087862", "Bongawan",
"6089534", "Elopura",
"6038026", "Kinrara",
"6033191", "Banting",
"606659", "Sepang",
"6084796", "Kapit",
"6088657", "Kotamarudu",
"604759", "Alor\ Setar",
"6038750", "Semenyih",
"606536", "Jasin",
"6038964", "Cheras",
"6038703", "Mantin",
"605441", "Trolak",
"6083472", "Betong",
"6033120", "Tk\ Panglima\ Garang",
"6083568", "Engkilili",
"609566", "Kuantan",
"6087217", "Beaufort",
"6034256", "Kuala\ Lumpur",
"607869", "Senai",
"6047453", "Alor\ Setar",
"607250", "Johor\ Bahru",
"6084610", "Rejang",
"604455", "Sungai\ Petani",
"6089290", "Elopura",
"607421", "Kampung\ Parit\ Tengah",
"6033319", "Kelang",
"607969", "Bukit\ Gambir",
"6035888", "Kuala\ Lumpur",
"606292", "Melaka",
"6039544", "Cheras",
"605661", "Ipoh",
"60951", "Kuantan",
"6039549", "Cheras",
"6089532", "Elopura",
"604765", "Alor\ Setar",
"6088532", "Kota\ Kinabalu",
"6082282", "Kuching",
"6035880", "Kinrara",
"607886", "Penawar",
"604626", "Penang",
"606726", "Seremban",
"605717", "Parit\ Buntar",
"607768", "Paloh",
"6084687", "Sarikei",
"605434", "Tapah",
"609479", "Maran",
"604469", "Jeniang",
"604921", "Kangar",
"6084633", "Selalang",
"605889", "Taiping",
"606358", "Tangga\ Batu",
"6086371", "Sebauh",
"609635", "Kuala\ Brang",
"6036181", "Kuala\ Lumpur",
"604227", "Penang",
"6087731", "Tenom",
"6085666", "Limbang",
"604958", "Kuah",
"6034271", "Kuala\ Lumpur",
"604610", "Penang",
"6033358", "Kelang",
"609775", "Kota\ Bharu",
"6082293", "Kuching",
"6087771", "Tambunan",
"604223", "Penang",
"6033346", "Kelang",
"609362", "Fraser\ Hill",
"6088343", "Kota\ Kinabalu",
"6033084", "Kelang",
"609567", "Kuantan",
"60545", "Tanjung\ Malim",
"6085242", "Limbang",
"6087853", "Kuala\ Penyu",
"605530", "Tanjung\ Rambutan",
"606960", "Bukit\ Gambir",
"604573", "Tasek\ Gelugor",
"6036739", "Kuala\ Kubu\ Baru",
"604915", "Changlon",
"606972", "Bukit\ Gambir",
"606332", "Melaka",
"606533", "Jasin",
"6084893", "Selangau",
"609370", "Dong",
"607918", "Aver\ Panas",
"604483", "Baling",
"606315", "Melaka",
"604932", "Ayer\ Hitam",
"6089985", "Tawau",
"607650", "Layang\-Layang",
"609830", "Paka",
"604487", "Sungai\ Bakap",
"608267", "Kota\ Samarahan",
"606537", "Jasin",
"604226", "Penang",
"605311", "Ipoh",
"6088413", "Kota\ Kinabalu",
"6038953", "Cheras",
"6085636", "Miri",
"605720", "Parit\ Buntar",
"6087761", "Tenom",
"6087342", "Keningau",
"6083570", "Lingga",
"6088852", "Ranau",
"6089942", "Tawau",
"6032302", "Kuala\ Lumpur",
"606265", "Sungai\ Rambai",
"6088395", "Kota\ Kinabalu",
"6089852", "Kunak",
"6082473", "Kuching",
"6086282", "Bintulu",
"604627", "Penang",
"609212", "Maran",
"6035612", "Kinrara",
"6037885", "Kuala\ Lumpur",
"6036094", "Rawang",
"6089927", "Tawau",
"606727", "Seremban",
"605716", "Parit\ Buntar",
"6032848", "Kuala\ Lumpur",
"6036099", "Rawang",
"604210", "Penang",
"6086293", "Bintulu",
"607415", "Batu\ Pahat",
"6034101", "Kuala\ Lumpur",
"6032856", "Kuala\ Lumpur",
"604623", "Penang",
"607883", "Kota\ Tinggi",
"6087874", "Weston",
"607740", "Kahang",
"6089562", "Kinabatangan",
"6033224", "Sabak\ Bernam",
"604418", "Mahang",
"609235", "Genting",
"6088404", "Kota\ Kinabalu",
"607887", "Kota\ Tinggi",
"6085285", "Lawas",
"6032181", "Kuala\ Lumpur",};
my $timezones = {
               '' => [
                       'Asia/Kuching'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+60|\D)//g;
      my $self = bless({ country_code => '60', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '60', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;