#!/usr/bin/perl

use v5.14;
use warnings;

use Test2::V0;

use meta;

# meta's own metapackage
{
   my $metapkg = meta::get_package( "meta" );
   ok( $metapkg, 'meta::get_package for "meta"' );

   is( $metapkg->name, "meta", 'Name of package' );
}

# Test2::V0's metapackage
{
   is( meta::get_package( "Test2::V0" )->name, "Test2::V0",
      'Name of the Test2::V0 package' );
}

# missing gets created
{
   my $metapkg;
   ok( lives { $metapkg = meta::get_package( "this-is-not-a-package" ) },
      'get_package creates a new package' );
   is( $metapkg->name, "this-is-not-a-package" );
}

done_testing;
