package Amazon::API::EC2;

use strict;
use warnings;

use parent qw( Amazon::API );

our $VERSION = '1.3.1';

our @API_METHODS = qw{
  AcceptReservedInstancesExchangeQuote
  AcceptTransitGatewayMulticastDomainAssociations
  AcceptTransitGatewayPeeringAttachment
  AcceptTransitGatewayVpcAttachment
  AcceptVpcEndpointConnections
  AcceptVpcPeeringConnection
  AdvertiseByoipCidr
  AllocateAddress
  AllocateHosts
  AllocateIpamPoolCidr
  ApplySecurityGroupsToClientVpnTargetNetwork
  AssignIpv6Addresses
  AssignPrivateIpAddresses
  AssociateAddress
  AssociateClientVpnTargetNetwork
  AssociateDhcpOptions
  AssociateEnclaveCertificateIamRole
  AssociateIamInstanceProfile
  AssociateInstanceEventWindow
  AssociateRouteTable
  AssociateSubnetCidrBlock
  AssociateTransitGatewayMulticastDomain
  AssociateTransitGatewayRouteTable
  AssociateTrunkInterface
  AssociateVpcCidrBlock
  AttachClassicLinkVpc
  AttachInternetGateway
  AttachNetworkInterface
  AttachVolume
  AttachVpnGateway
  AuthorizeClientVpnIngress
  AuthorizeSecurityGroupEgress
  AuthorizeSecurityGroupIngress
  BundleInstance
  CancelBundleTask
  CancelCapacityReservation
  CancelCapacityReservationFleets
  CancelConversionTask
  CancelExportTask
  CancelImportTask
  CancelReservedInstancesListing
  CancelSpotFleetRequests
  CancelSpotInstanceRequests
  ConfirmProductInstance
  CopyFpgaImage
  CopyImage
  CopySnapshot
  CreateCapacityReservation
  CreateCapacityReservationFleet
  CreateCarrierGateway
  CreateClientVpnEndpoint
  CreateClientVpnRoute
  CreateCustomerGateway
  CreateDefaultSubnet
  CreateDefaultVpc
  CreateDhcpOptions
  CreateEgressOnlyInternetGateway
  CreateFleet
  CreateFlowLogs
  CreateFpgaImage
  CreateImage
  CreateInstanceEventWindow
  CreateInstanceExportTask
  CreateInternetGateway
  CreateIpam
  CreateIpamPool
  CreateIpamScope
  CreateKeyPair
  CreateLaunchTemplate
  CreateLaunchTemplateVersion
  CreateLocalGatewayRoute
  CreateLocalGatewayRouteTableVpcAssociation
  CreateManagedPrefixList
  CreateNatGateway
  CreateNetworkAcl
  CreateNetworkAclEntry
  CreateNetworkInsightsAccessScope
  CreateNetworkInsightsPath
  CreateNetworkInterface
  CreateNetworkInterfacePermission
  CreatePlacementGroup
  CreatePublicIpv4Pool
  CreateReplaceRootVolumeTask
  CreateReservedInstancesListing
  CreateRestoreImageTask
  CreateRoute
  CreateRouteTable
  CreateSecurityGroup
  CreateSnapshot
  CreateSnapshots
  CreateSpotDatafeedSubscription
  CreateStoreImageTask
  CreateSubnet
  CreateSubnetCidrReservation
  CreateTags
  CreateTrafficMirrorFilter
  CreateTrafficMirrorFilterRule
  CreateTrafficMirrorSession
  CreateTrafficMirrorTarget
  CreateTransitGateway
  CreateTransitGatewayConnect
  CreateTransitGatewayConnectPeer
  CreateTransitGatewayMulticastDomain
  CreateTransitGatewayPeeringAttachment
  CreateTransitGatewayPrefixListReference
  CreateTransitGatewayRoute
  CreateTransitGatewayRouteTable
  CreateTransitGatewayVpcAttachment
  CreateVolume
  CreateVpc
  CreateVpcEndpoint
  CreateVpcEndpointConnectionNotification
  CreateVpcEndpointServiceConfiguration
  CreateVpcPeeringConnection
  CreateVpnConnection
  CreateVpnConnectionRoute
  CreateVpnGateway
  DeleteCarrierGateway
  DeleteClientVpnEndpoint
  DeleteClientVpnRoute
  DeleteCustomerGateway
  DeleteDhcpOptions
  DeleteEgressOnlyInternetGateway
  DeleteFleets
  DeleteFlowLogs
  DeleteFpgaImage
  DeleteInstanceEventWindow
  DeleteInternetGateway
  DeleteIpam
  DeleteIpamPool
  DeleteIpamScope
  DeleteKeyPair
  DeleteLaunchTemplate
  DeleteLaunchTemplateVersions
  DeleteLocalGatewayRoute
  DeleteLocalGatewayRouteTableVpcAssociation
  DeleteManagedPrefixList
  DeleteNatGateway
  DeleteNetworkAcl
  DeleteNetworkAclEntry
  DeleteNetworkInsightsAccessScope
  DeleteNetworkInsightsAccessScopeAnalysis
  DeleteNetworkInsightsAnalysis
  DeleteNetworkInsightsPath
  DeleteNetworkInterface
  DeleteNetworkInterfacePermission
  DeletePlacementGroup
  DeletePublicIpv4Pool
  DeleteQueuedReservedInstances
  DeleteRoute
  DeleteRouteTable
  DeleteSecurityGroup
  DeleteSnapshot
  DeleteSpotDatafeedSubscription
  DeleteSubnet
  DeleteSubnetCidrReservation
  DeleteTags
  DeleteTrafficMirrorFilter
  DeleteTrafficMirrorFilterRule
  DeleteTrafficMirrorSession
  DeleteTrafficMirrorTarget
  DeleteTransitGateway
  DeleteTransitGatewayConnect
  DeleteTransitGatewayConnectPeer
  DeleteTransitGatewayMulticastDomain
  DeleteTransitGatewayPeeringAttachment
  DeleteTransitGatewayPrefixListReference
  DeleteTransitGatewayRoute
  DeleteTransitGatewayRouteTable
  DeleteTransitGatewayVpcAttachment
  DeleteVolume
  DeleteVpc
  DeleteVpcEndpointConnectionNotifications
  DeleteVpcEndpoints
  DeleteVpcEndpointServiceConfigurations
  DeleteVpcPeeringConnection
  DeleteVpnConnection
  DeleteVpnConnectionRoute
  DeleteVpnGateway
  DeprovisionByoipCidr
  DeprovisionIpamPoolCidr
  DeprovisionPublicIpv4PoolCidr
  DeregisterImage
  DeregisterInstanceEventNotificationAttributes
  DeregisterTransitGatewayMulticastGroupMembers
  DeregisterTransitGatewayMulticastGroupSources
  DescribeAccountAttributes
  DescribeAddresses
  DescribeAddressesAttribute
  DescribeAggregateIdFormat
  DescribeAvailabilityZones
  DescribeBundleTasks
  DescribeByoipCidrs
  DescribeCapacityReservationFleets
  DescribeCapacityReservations
  DescribeCarrierGateways
  DescribeClassicLinkInstances
  DescribeClientVpnAuthorizationRules
  DescribeClientVpnConnections
  DescribeClientVpnEndpoints
  DescribeClientVpnRoutes
  DescribeClientVpnTargetNetworks
  DescribeCoipPools
  DescribeConversionTasks
  DescribeCustomerGateways
  DescribeDhcpOptions
  DescribeEgressOnlyInternetGateways
  DescribeElasticGpus
  DescribeExportImageTasks
  DescribeExportTasks
  DescribeFastLaunchImages
  DescribeFastSnapshotRestores
  DescribeFleetHistory
  DescribeFleetInstances
  DescribeFleets
  DescribeFlowLogs
  DescribeFpgaImageAttribute
  DescribeFpgaImages
  DescribeHostReservationOfferings
  DescribeHostReservations
  DescribeHosts
  DescribeIamInstanceProfileAssociations
  DescribeIdentityIdFormat
  DescribeIdFormat
  DescribeImageAttribute
  DescribeImages
  DescribeImportImageTasks
  DescribeImportSnapshotTasks
  DescribeInstanceAttribute
  DescribeInstanceCreditSpecifications
  DescribeInstanceEventNotificationAttributes
  DescribeInstanceEventWindows
  DescribeInstances
  DescribeInstanceStatus
  DescribeInstanceTypeOfferings
  DescribeInstanceTypes
  DescribeInternetGateways
  DescribeIpamPools
  DescribeIpams
  DescribeIpamScopes
  DescribeIpv6Pools
  DescribeKeyPairs
  DescribeLaunchTemplates
  DescribeLaunchTemplateVersions
  DescribeLocalGatewayRouteTables
  DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
  DescribeLocalGatewayRouteTableVpcAssociations
  DescribeLocalGateways
  DescribeLocalGatewayVirtualInterfaceGroups
  DescribeLocalGatewayVirtualInterfaces
  DescribeManagedPrefixLists
  DescribeMovingAddresses
  DescribeNatGateways
  DescribeNetworkAcls
  DescribeNetworkInsightsAccessScopeAnalyses
  DescribeNetworkInsightsAccessScopes
  DescribeNetworkInsightsAnalyses
  DescribeNetworkInsightsPaths
  DescribeNetworkInterfaceAttribute
  DescribeNetworkInterfacePermissions
  DescribeNetworkInterfaces
  DescribePlacementGroups
  DescribePrefixLists
  DescribePrincipalIdFormat
  DescribePublicIpv4Pools
  DescribeRegions
  DescribeReplaceRootVolumeTasks
  DescribeReservedInstances
  DescribeReservedInstancesListings
  DescribeReservedInstancesModifications
  DescribeReservedInstancesOfferings
  DescribeRouteTables
  DescribeScheduledInstanceAvailability
  DescribeScheduledInstances
  DescribeSecurityGroupReferences
  DescribeSecurityGroupRules
  DescribeSecurityGroups
  DescribeSnapshotAttribute
  DescribeSnapshots
  DescribeSnapshotTierStatus
  DescribeSpotDatafeedSubscription
  DescribeSpotFleetInstances
  DescribeSpotFleetRequestHistory
  DescribeSpotFleetRequests
  DescribeSpotInstanceRequests
  DescribeSpotPriceHistory
  DescribeStaleSecurityGroups
  DescribeStoreImageTasks
  DescribeSubnets
  DescribeTags
  DescribeTrafficMirrorFilters
  DescribeTrafficMirrorSessions
  DescribeTrafficMirrorTargets
  DescribeTransitGatewayAttachments
  DescribeTransitGatewayConnectPeers
  DescribeTransitGatewayConnects
  DescribeTransitGatewayMulticastDomains
  DescribeTransitGatewayPeeringAttachments
  DescribeTransitGatewayRouteTables
  DescribeTransitGateways
  DescribeTransitGatewayVpcAttachments
  DescribeTrunkInterfaceAssociations
  DescribeVolumeAttribute
  DescribeVolumes
  DescribeVolumesModifications
  DescribeVolumeStatus
  DescribeVpcAttribute
  DescribeVpcClassicLink
  DescribeVpcClassicLinkDnsSupport
  DescribeVpcEndpointConnectionNotifications
  DescribeVpcEndpointConnections
  DescribeVpcEndpoints
  DescribeVpcEndpointServiceConfigurations
  DescribeVpcEndpointServicePermissions
  DescribeVpcEndpointServices
  DescribeVpcPeeringConnections
  DescribeVpcs
  DescribeVpnConnections
  DescribeVpnGateways
  DetachClassicLinkVpc
  DetachInternetGateway
  DetachNetworkInterface
  DetachVolume
  DetachVpnGateway
  DisableEbsEncryptionByDefault
  DisableFastLaunch
  DisableFastSnapshotRestores
  DisableImageDeprecation
  DisableIpamOrganizationAdminAccount
  DisableSerialConsoleAccess
  DisableTransitGatewayRouteTablePropagation
  DisableVgwRoutePropagation
  DisableVpcClassicLink
  DisableVpcClassicLinkDnsSupport
  DisassociateAddress
  DisassociateClientVpnTargetNetwork
  DisassociateEnclaveCertificateIamRole
  DisassociateIamInstanceProfile
  DisassociateInstanceEventWindow
  DisassociateRouteTable
  DisassociateSubnetCidrBlock
  DisassociateTransitGatewayMulticastDomain
  DisassociateTransitGatewayRouteTable
  DisassociateTrunkInterface
  DisassociateVpcCidrBlock
  EnableEbsEncryptionByDefault
  EnableFastLaunch
  EnableFastSnapshotRestores
  EnableImageDeprecation
  EnableIpamOrganizationAdminAccount
  EnableSerialConsoleAccess
  EnableTransitGatewayRouteTablePropagation
  EnableVgwRoutePropagation
  EnableVolumeIO
  EnableVpcClassicLink
  EnableVpcClassicLinkDnsSupport
  ExportClientVpnClientCertificateRevocationList
  ExportClientVpnClientConfiguration
  ExportImage
  ExportTransitGatewayRoutes
  GetAssociatedEnclaveCertificateIamRoles
  GetAssociatedIpv6PoolCidrs
  GetCapacityReservationUsage
  GetCoipPoolUsage
  GetConsoleOutput
  GetConsoleScreenshot
  GetDefaultCreditSpecification
  GetEbsDefaultKmsKeyId
  GetEbsEncryptionByDefault
  GetFlowLogsIntegrationTemplate
  GetGroupsForCapacityReservation
  GetHostReservationPurchasePreview
  GetInstanceTypesFromInstanceRequirements
  GetIpamAddressHistory
  GetIpamPoolAllocations
  GetIpamPoolCidrs
  GetIpamResourceCidrs
  GetLaunchTemplateData
  GetManagedPrefixListAssociations
  GetManagedPrefixListEntries
  GetNetworkInsightsAccessScopeAnalysisFindings
  GetNetworkInsightsAccessScopeContent
  GetPasswordData
  GetReservedInstancesExchangeQuote
  GetSerialConsoleAccessStatus
  GetSpotPlacementScores
  GetSubnetCidrReservations
  GetTransitGatewayAttachmentPropagations
  GetTransitGatewayMulticastDomainAssociations
  GetTransitGatewayPrefixListReferences
  GetTransitGatewayRouteTableAssociations
  GetTransitGatewayRouteTablePropagations
  GetVpnConnectionDeviceSampleConfiguration
  GetVpnConnectionDeviceTypes
  ImportClientVpnClientCertificateRevocationList
  ImportImage
  ImportInstance
  ImportKeyPair
  ImportSnapshot
  ImportVolume
  ListImagesInRecycleBin
  ListSnapshotsInRecycleBin
  ModifyAddressAttribute
  ModifyAvailabilityZoneGroup
  ModifyCapacityReservation
  ModifyCapacityReservationFleet
  ModifyClientVpnEndpoint
  ModifyDefaultCreditSpecification
  ModifyEbsDefaultKmsKeyId
  ModifyFleet
  ModifyFpgaImageAttribute
  ModifyHosts
  ModifyIdentityIdFormat
  ModifyIdFormat
  ModifyImageAttribute
  ModifyInstanceAttribute
  ModifyInstanceCapacityReservationAttributes
  ModifyInstanceCreditSpecification
  ModifyInstanceEventStartTime
  ModifyInstanceEventWindow
  ModifyInstanceMetadataOptions
  ModifyInstancePlacement
  ModifyIpam
  ModifyIpamPool
  ModifyIpamResourceCidr
  ModifyIpamScope
  ModifyLaunchTemplate
  ModifyManagedPrefixList
  ModifyNetworkInterfaceAttribute
  ModifyPrivateDnsNameOptions
  ModifyReservedInstances
  ModifySecurityGroupRules
  ModifySnapshotAttribute
  ModifySnapshotTier
  ModifySpotFleetRequest
  ModifySubnetAttribute
  ModifyTrafficMirrorFilterNetworkServices
  ModifyTrafficMirrorFilterRule
  ModifyTrafficMirrorSession
  ModifyTransitGateway
  ModifyTransitGatewayPrefixListReference
  ModifyTransitGatewayVpcAttachment
  ModifyVolume
  ModifyVolumeAttribute
  ModifyVpcAttribute
  ModifyVpcEndpoint
  ModifyVpcEndpointConnectionNotification
  ModifyVpcEndpointServiceConfiguration
  ModifyVpcEndpointServicePayerResponsibility
  ModifyVpcEndpointServicePermissions
  ModifyVpcPeeringConnectionOptions
  ModifyVpcTenancy
  ModifyVpnConnection
  ModifyVpnConnectionOptions
  ModifyVpnTunnelCertificate
  ModifyVpnTunnelOptions
  MonitorInstances
  MoveAddressToVpc
  MoveByoipCidrToIpam
  ProvisionByoipCidr
  ProvisionIpamPoolCidr
  ProvisionPublicIpv4PoolCidr
  PurchaseHostReservation
  PurchaseReservedInstancesOffering
  PurchaseScheduledInstances
  RebootInstances
  RegisterImage
  RegisterInstanceEventNotificationAttributes
  RegisterTransitGatewayMulticastGroupMembers
  RegisterTransitGatewayMulticastGroupSources
  RejectTransitGatewayMulticastDomainAssociations
  RejectTransitGatewayPeeringAttachment
  RejectTransitGatewayVpcAttachment
  RejectVpcEndpointConnections
  RejectVpcPeeringConnection
  ReleaseAddress
  ReleaseHosts
  ReleaseIpamPoolAllocation
  ReplaceIamInstanceProfileAssociation
  ReplaceNetworkAclAssociation
  ReplaceNetworkAclEntry
  ReplaceRoute
  ReplaceRouteTableAssociation
  ReplaceTransitGatewayRoute
  ReportInstanceStatus
  RequestSpotFleet
  RequestSpotInstances
  ResetAddressAttribute
  ResetEbsDefaultKmsKeyId
  ResetFpgaImageAttribute
  ResetImageAttribute
  ResetInstanceAttribute
  ResetNetworkInterfaceAttribute
  ResetSnapshotAttribute
  RestoreAddressToClassic
  RestoreImageFromRecycleBin
  RestoreManagedPrefixListVersion
  RestoreSnapshotFromRecycleBin
  RestoreSnapshotTier
  RevokeClientVpnIngress
  RevokeSecurityGroupEgress
  RevokeSecurityGroupIngress
  RunInstances
  RunScheduledInstances
  SearchLocalGatewayRoutes
  SearchTransitGatewayMulticastGroups
  SearchTransitGatewayRoutes
  SendDiagnosticInterrupt
  StartInstances
  StartNetworkInsightsAccessScopeAnalysis
  StartNetworkInsightsAnalysis
  StartVpcEndpointServicePrivateDnsVerification
  StopInstances
  TerminateClientVpnConnections
  TerminateInstances
  UnassignIpv6Addresses
  UnassignPrivateIpAddresses
  UnmonitorInstances
  UpdateSecurityGroupRuleDescriptionsEgress
  UpdateSecurityGroupRuleDescriptionsIngress
  WithdrawByoipCidr
};

sub new {
  my ( $class, @options ) = @_;
  $class = ref($class) || $class;

  my %options = ref( $options[0] ) ? %{ $options[0] } : @options;

  return $class->SUPER::new(
    { service     => 'ec2',
      version     => '2016-11-15',
      api_methods => \@API_METHODS,
      %options,
    }
  );
} ## end sub new

1;
