/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.OPFReference;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.DateParser;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.InvalidDateException;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class OPFHandler
implements XMLHandler {
    Hashtable<String, OPFItem> itemMapById = new Hashtable();
    Hashtable<String, OPFItem> itemMapByPath = new Hashtable();
    XMLParser parser;
    Vector<OPFItem> spine = new Vector();
    Vector<OPFItem> items = new Vector();
    Vector<OPFReference> refs = new Vector();
    Report report;
    static HashSet<String> validRoles = new HashSet();
    String path;
    XRefChecker xrefChecker;
    String uniqueIdent;
    boolean uniqueIdentExists = false;
    String uid;
    OPFItem toc;
    boolean opf12PackageFile = false;
    EPUBVersion version;

    public OPFHandler(String path, Report report, XRefChecker xrefChecker, XMLParser parser, EPUBVersion version) {
        this.path = path;
        this.report = report;
        this.xrefChecker = xrefChecker;
        this.parser = parser;
        this.version = version;
    }

    public boolean getOpf12PackageFile() {
        return this.opf12PackageFile;
    }

    public boolean getOpf20PackageFile() {
        return !this.opf12PackageFile;
    }

    public OPFItem getTOC() {
        return this.toc;
    }

    public OPFItem getItemById(String id) {
        return this.itemMapById.get(id);
    }

    public OPFItem getItemByPath(String path) {
        return this.itemMapByPath.get(path);
    }

    public int getSpineItemCount() {
        return this.spine.size();
    }

    public OPFItem getSpineItem(int index) {
        return this.spine.elementAt(index);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public OPFItem getItem(int index) {
        return this.items.elementAt(index);
    }

    public int getReferenceCount() {
        return this.refs.size();
    }

    public OPFReference getReference(int index) {
        return this.refs.elementAt(index);
    }

    public boolean checkUniqueIdentExists() {
        return this.uniqueIdentExists;
    }

    public String getUid() {
        return this.uid;
    }

    private static boolean isValidRole(String role) {
        return validRoles.contains(role) || role.startsWith("oth.");
    }

    @Override
    public void startElement() {
        boolean registerEntry = true;
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        if (ns == null || ns.equals("") || ns.equals("http://openebook.org/namespaces/oeb-package/1.0/") || ns.equals("http://www.idpf.org/2007/opf")) {
            String name = e.getName();
            if (name.equals("package")) {
                String uniqueIdentAttr;
                if (!ns.equals("http://www.idpf.org/2007/opf")) {
                    this.report.warning(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), Messages.OPF_USING_OEBPS12);
                    this.opf12PackageFile = true;
                }
                if ((uniqueIdentAttr = e.getAttribute("unique-identifier")) != null && !uniqueIdentAttr.equals("")) {
                    this.uniqueIdent = uniqueIdentAttr;
                } else {
                    this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), Messages.OPF_MISSING_OR_EMPTY_UNIQUE_ID_ATTRIBUTE);
                }
            } else if (name.equals("item")) {
                String id = e.getAttribute("id");
                String href = e.getAttribute("href");
                if (!(href == null || this.version == EPUBVersion.VERSION_3 && href.matches("^[^:/?#]+://.*"))) {
                    try {
                        href = PathUtil.resolveRelativeReference(this.path, href, null);
                    }
                    catch (IllegalArgumentException ex) {
                        this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), ex.getMessage());
                        href = null;
                    }
                }
                if (href != null && href.matches("^[^:/?#]+://.*")) {
                    this.report.info(this.path, FeatureEnum.REFERENCE, href);
                }
                String mimeType = e.getAttribute("media-type");
                String fallback = e.getAttribute("fallback");
                String fallbackStyle = e.getAttribute("fallback-style");
                String namespace = e.getAttribute("island-type");
                String properties = e.getAttribute("properties");
                if (properties != null) {
                    properties = properties.replaceAll("[\\s]+", " ");
                }
                if (this.version == EPUBVersion.VERSION_3 && href.matches("^[^:/?#]+://.*") && !OPFChecker30.isBlessedAudioType(mimeType) && OPFChecker30.isCoreMediaType(mimeType)) {
                    this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), Messages.OPF_ONLY_AUDIO_VIDEO);
                }
                OPFItem item = new OPFItem(id, href, mimeType, fallback, fallbackStyle, namespace, properties, this.parser.getLineNumber(), this.parser.getColumnNumber());
                if (id != null) {
                    this.itemMapById.put(id, item);
                }
                if (properties != null) {
                    String[] propertyArray = properties.split(" ");
                    for (int i = 0; i < propertyArray.length; ++i) {
                        if (propertyArray[i].equals("nav")) {
                            item.setNav(true);
                        }
                        if (!propertyArray[i].equals("scripted")) continue;
                        item.setScripted(true);
                    }
                }
                if (href != null && registerEntry) {
                    this.itemMapByPath.put(href, item);
                    this.items.add(item);
                }
            } else if (name.equals("reference")) {
                String type = e.getAttribute("type");
                String title = e.getAttribute("title");
                String href = e.getAttribute("href");
                if (href != null && this.xrefChecker != null) {
                    try {
                        href = PathUtil.resolveRelativeReference(this.path, href, null);
                        this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 0);
                    }
                    catch (IllegalArgumentException ex) {
                        this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), ex.getMessage());
                        href = null;
                    }
                }
                if (href != null && href.startsWith("http")) {
                    this.report.info(this.path, FeatureEnum.REFERENCE, href);
                }
                OPFReference ref = new OPFReference(type, title, href, this.parser.getLineNumber(), this.parser.getColumnNumber());
                this.refs.add(ref);
            } else if (name.equals("spine")) {
                String idref = e.getAttribute("toc");
                if (idref != null) {
                    this.toc = this.itemMapById.get(idref);
                    if (this.toc == null) {
                        this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), String.format(Messages.OPF_ITEM_WITH_ID_NOT_FOUND, idref));
                    } else {
                        this.toc.setNcx(true);
                        if (this.toc.getMimeType() != null && !this.toc.getMimeType().equals("application/x-dtbncx+xml")) {
                            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), Messages.OPF_TOC_ITEM_WRONG_MIMETYPE);
                        }
                    }
                }
            } else if (name.equals("itemref")) {
                String idref = e.getAttribute("idref");
                if (idref != null) {
                    OPFItem item = this.getItemById(idref);
                    if (item != null) {
                        this.spine.add(item);
                        item.setInSpine(true);
                        String linear = e.getAttribute("linear");
                        if (linear != null && "no".equals(linear.trim())) {
                            item.setSpineLinear(false);
                        } else {
                            item.setSpineLinear(true);
                        }
                    } else {
                        this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), String.format(Messages.OPF_ITEM_WITH_ID_NOT_FOUND, idref));
                    }
                }
            } else if ((name.equals("dc-metadata") || name.equals("x-metadata")) && !this.opf12PackageFile) {
                this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), String.format(Messages.OPF_DEPRECATED_ELEMENT, name));
            }
        } else if (ns.equals("http://purl.org/dc/elements/1.1/")) {
            String role;
            String name = e.getName();
            if (name.equals("identifier")) {
                String idAttr = e.getAttribute("id");
                if (idAttr != null && !idAttr.equals("") && idAttr.equals(this.uniqueIdent)) {
                    this.uniqueIdentExists = true;
                }
            } else if (name.equals("creator") && (role = e.getAttributeNS("http://www.idpf.org/2007/opf", "role")) != null && !role.equals("") && !OPFHandler.isValidRole(role)) {
                this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), String.format(Messages.OPF_DC_ROLE_VALUE_INVALID, role));
            }
        }
    }

    public boolean isNotRequiredContent(String href) {
        if (href.endsWith(".opf")) {
            return false;
        }
        if (href.endsWith(".html")) {
            return false;
        }
        if (href.endsWith(".ncx")) {
            return false;
        }
        if (href.endsWith(".xpgt")) {
            return false;
        }
        return !href.endsWith(".xhtml");
    }

    @Override
    public void endElement() {
        XMLElement e = this.parser.getCurrentElement();
        if ("http://www.idpf.org/2007/opf".equals(e.getNamespace())) {
            String name = e.getName();
            if ("meta".equals(name)) {
                String attr = e.getAttribute("property");
                if ("dcterms:modified".equals(attr)) {
                    String val = (String)e.getPrivateData();
                    this.report.info(null, FeatureEnum.MODIFIED_DATE, val);
                } else if ("rendition:layout".equals(attr)) {
                    String val = (String)e.getPrivateData();
                    if ("pre-paginated".equals(val)) {
                        this.report.info(null, FeatureEnum.HAS_FIXED_LAYOUT, "pre-paginated");
                    }
                } else {
                    String attr1 = e.getAttribute("name");
                    if ("fixed-layout".equals(attr1) && "true".equals(e.getAttribute("content"))) {
                        this.report.info(null, FeatureEnum.HAS_FIXED_LAYOUT, "fixed-layout");
                    }
                }
            }
        } else if (e.getNamespace().equals("http://purl.org/dc/elements/1.1/")) {
            String value;
            String name = e.getName();
            if (name.equals("identifier")) {
                String idval;
                String idAttr = e.getAttribute("id");
                if (idAttr != null && !idAttr.equals("") && idAttr.equals(this.uniqueIdent) && (idval = (String)e.getPrivateData()) != null) {
                    this.report.info(null, FeatureEnum.UNIQUE_IDENT, idval.trim());
                    this.uid = idval.trim();
                }
            } else if (name.equals("date")) {
                String dateval = (String)e.getPrivateData();
                boolean valid = true;
                String detail = null;
                if (dateval == null || "".equals(dateval)) {
                    valid = false;
                    detail = "zero-length string";
                } else {
                    DateParser dateParser = new DateParser();
                    try {
                        Date date = dateParser.parse(dateval.trim());
                        String year = new SimpleDateFormat("yyyy").format(date);
                        if (year.length() > 4) {
                            throw new InvalidDateException(year);
                        }
                        this.report.info(null, FeatureEnum.DC_DATE, dateval);
                    }
                    catch (InvalidDateException d) {
                        valid = false;
                        detail = d.getMessage();
                    }
                }
                if (!valid) {
                    if (this.version == EPUBVersion.VERSION_3) {
                        this.report.warning(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), String.format(Messages.OPF_EPUB3_META_DATE_INVALID, dateval == null ? "" : dateval, detail));
                    } else {
                        this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), String.format(Messages.OPF_EPUB2_META_DATE_INVALID, dateval == null ? "" : dateval, detail));
                    }
                }
            } else if (name.equals("title") || name.equals("language")) {
                String value2;
                if ("language".equals(name)) {
                    value2 = (String)e.getPrivateData();
                    if (value2 != null) {
                        this.report.info(null, FeatureEnum.DC_LANGUAGE, value2.trim());
                    }
                } else if ("title".equals(name) && (value2 = (String)e.getPrivateData()) != null) {
                    this.report.info(null, FeatureEnum.DC_TITLE, value2.trim());
                }
                if (this.version == EPUBVersion.VERSION_2 && ((value2 = (String)e.getPrivateData()) == null || value2.trim().length() < 1)) {
                    this.report.warning(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), String.format(Messages.OPF_EMPTY_ELEMENT, name));
                }
            } else if (name.equals("creator")) {
                String value3 = (String)e.getPrivateData();
                if (value3 != null) {
                    this.report.info(null, FeatureEnum.DC_CREATOR, value3.trim());
                }
            } else if (name.equals("contributor")) {
                String value4 = (String)e.getPrivateData();
                if (value4 != null) {
                    this.report.info(null, FeatureEnum.DC_CONTRIBUTOR, value4.trim());
                }
            } else if (name.equals("publisher")) {
                String value5 = (String)e.getPrivateData();
                if (value5 != null) {
                    this.report.info(null, FeatureEnum.DC_PUBLISHER, value5.trim());
                }
            } else if (name.equals("rights") && (value = (String)e.getPrivateData()) != null) {
                this.report.info(null, FeatureEnum.DC_RIGHTS, value.trim());
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void characters(char[] chars, int start, int len) {
        boolean keepValue;
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        String ns = e.getNamespace();
        boolean bl = keepValue = "http://www.idpf.org/2007/opf".equals(ns) && "meta".equals(name) || "http://purl.org/dc/elements/1.1/".equals(ns) && (name.equals("identifier") || name.equals("date") || name.equals("title") || name.equals("language") || name.equals("creator") || name.equals("contributor") || name.equals("publisher") || name.equals("rights"));
        if (keepValue) {
            String val = (String)e.getPrivateData();
            String text = new String(chars, start, len);
            val = val == null ? text : val + text;
            e.setPrivateData(val);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }

    public EPUBVersion getVersion() {
        return this.version;
    }

    static {
        String[] list = new String[]{"acp", "act", "adp", "aft", "anl", "anm", "ann", "ant", "app", "aqt", "arc", "ard", "arr", "art", "asg", "asn", "att", "auc", "aud", "aui", "aus", "aut", "bdd", "bjd", "bkd", "bkp", "bnd", "bpd", "bsl", "ccp", "chr", "clb", "cli", "cll", "clr", "clt", "cmm", "cmp", "cmt", "cng", "cnd", "cns", "coe", "col", "com", "cos", "cot", "cov", "cpc", "cpe", "cph", "cpl", "cpt", "cre", "crp", "crr", "csl", "csp", "cst", "ctb", "cte", "ctg", "ctr", "cts", "ctt", "cur", "cwt", "dfd", "dfe", "dft", "dgg", "dis", "dln", "dnc", "dnr", "dpc", "dpt", "drm", "drt", "dsr", "dst", "dtc", "dte", "dtm", "dto", "dub", "edt", "egr", "elg", "elt", "eng", "etr", "exp", "fac", "fld", "flm", "fmo", "fpy", "fnd", "frg", "gis", "grt", "hnr", "hst", "ill", "ilu", "ins", "inv", "itr", "ive", "ivr", "lbr", "lbt", "ldr", "led", "lee", "lel", "len", "let", "lgd", "lie", "lil", "lit", "lsa", "lse", "lso", "ltg", "lyr", "mcp", "mfr", "mdc", "mod", "mon", "mrk", "msd", "mte", "mus", "nrt", "opn", "org", "orm", "oth", "own", "pat", "pbd", "pbl", "pdr", "pfr", "pht", "plt", "pma", "pmn", "pop", "ppm", "ppt", "prc", "prd", "prf", "prg", "prm", "pro", "prt", "pta", "pte", "ptf", "pth", "ptt", "rbr", "rce", "rcp", "red", "ren", "res", "rev", "rps", "rpt", "rpy", "rse", "rsg", "rsp", "rst", "rth", "rtm", "sad", "sce", "scl", "scr", "sds", "sec", "sgn", "sht", "sng", "spk", "spn", "spy", "srv", "std", "stl", "stm", "stn", "str", "tcd", "tch", "ths", "trc", "trl", "tyd", "tyg", "vdg", "voc", "wam", "wdc", "wde", "wit"};
        for (int i = 0; i < list.length; ++i) {
            validRoles.add(list[i]);
        }
    }
}

