#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

ЗАГАЛЬНА ДЕКЛАРАЦІЯ ПРАВ ЛЮДИНІ
ПРЕАМБУЛА
Беручи до уваги, що визнання гідності, яка властива всім членам людскої сім'ї, і рівних та невід'ємних їх прав є основою свободі, справедливості та загального миру; і

беручи до уваги, що зневажання і нехтування правами людини призвели до варварських актів, які обурюють совість людства, і що створення такого світу, в якому люди будуть мати свободу слова і переконань і будуть вільні від страху і нужди, проголошено як високе прагнення людей; і

беручи до уваги, що необхідно, щоб права людини охоронялися силою закону з метою забезпечення того, щоб людина не була змушена вдаватиця як до останнього засобу до повстання проти тиранії і гноблення; і

беручи до уваги, що необхідно сприяти розвиткові дружніх відносин між народами; і

беручи до уваги, що народи Об'єднаних Націй підтвердили в Статуті свою віру в основні права людини, в гідність і цінність людської осови і в рівноправність чоловіків і жінок та вирішили сприяти соціальному прогресові і поліпшенню умов життя при більшій свободі; і

беручи до уваги. що держави-члени зобов'язались сприяти у співробітництві з Організацією Об'єднаних Націй загальній повазі і додержанню прав людини і основних свсбод; і

беручи до уваги, що загальне розуміння характеру цих прав і свобод має величезне значення для повного биконання цього зобов'язання,

ГЕНЕРАЛЬНА АСАМБЛЕЯ

проголошує цю Загальну Декларацію Ппав Людини як завдання, до виконання якого повинні прагнути всі народи і всі держави з тим, щоб кожна людина і кожний орган суспільства, завжди маючи на увазі цю Декларацію, прагнули шляхом освіти сприяти поважанню цих прав і свобод і забезпеченню, шляхом національних і міжнародних прогресивних заходів, загального і ефективного візнання і здійснення їх як серед народів держав - членів Організації, так і серед народів територій, що перебувають під їх юрисдикцією.

Стаття 1.
Всі люди народжуються вільними і рівними у своїй гідності та правах. Вони наділені розумом і совістю і повинні діяти у відношенні один до одного в дусі братерства.

Стаття 2.
Кожна людина повинна мати всі права і всі свободи, проголошені цією Декларацією, незалежно від раси, кольору шкіри, статі, мови, релігії, політичних або інших переконань, національного чи соціального походження, майнового, станового або іншого становища.

Крім того, не повинно проводитися ніякого розрізнення на основі політичного, правового або міжнародного статусу країни або території, до якої людина належить, незалежно від того, чи є ця територія незалежною, підопічною, несамоврядованою або як-небудь інакше обмеженою у своєму суверенітеті.

Стаття 3.
Кожна людина має право на життя, на свободу і на особисту недоторканність.

Стаття 4.
Ніхто не повинен бути в рабстві або у підневільному стані; рабство і работоргівля забороняються в усіх їх видах.

Стаття 5.
Ніхто не повинен зазнавати тортур, або жорстокого, нелюдського, або такого, що принижує його гідність, поводження і покарання.

Стаття 6.
Кожна людина, де б вона не перебувала, має право на визнання ії правосуб'єктності.

Стаття 7.
Всі люди рівні перед законом і мають право, без будь-якої різниці, на рівний їх захист законом. Усі люди мають право на рівний захист від якої б то не було дискримінації, що порушує цю Декларацію, і від якого б то не було підбурювання до такої дискримінації.

Стаття 8.
Кожна людина має право на ефективне поновлення у правах компетентними національними судами в разі порушення її основних прав, наданих їй конституцією або законом.

Стаття 9.
Ніхто не може зазнавати безпідставного арешту, затримання або вигнання.

Стаття 10.
Кожна людина, для визначення її прав і обов'язків і для встановлення обгрунтованості пред'явленого їй кримінального обвинувачення, має право, на основі повної рівності, на те, щоб її справа була розглянута прилюдно і з додержанням усіх вимог справедливості незалежним і безстороннім судом.

Стаття 11.
Кожна людина обвинувачена у вчиненні злочину, має право вважатися невинною доти, поки її бинність не буде встановлена в законномy порядку шляхом прилюдного судового розглядy, при якому їй забезпечують усі можливості для захисту.
Ніхто не може бути засуджений за злочин на підставі вчинення будь-якого діяння або за бездіяльність, які під час їх вчинення не становили злочину за національними законами або за міжнародним правом. Не може також накладатиць покарання тяжче від того, яке могло бути застосоване на час вчинення злочину.
Стаття 12.
Ніхто не може зазнавати безпідставного втручання у його особисте і сімейне життя, безпідставного посягання на недоторканність його житла, тайну його кореспонденції або на його честь і репутацію. Кожна людина має право на захит закому від такого втручання або таких посягань.

Стаття 13.
Кожна людина має право вільно пересуватися і обирати собі місце проживання у межах кожної держави.
Кожна людина має право покинути будь-яку країну, включаючи й свою власну, і повертатиса у свою країну.
Стаття 14.
Кожна людина має право шукати притулку від переслідувань в інших країнах і користуватиса цим притулком.
Це право не може бути використане в разі переслідування, яке в дійсності грунтуєтьса на вчиненні неполітичного злочину, або діяння, що суперечить ці їлям і принципам Організації Об'єднаних Націй.
Стаття 15.
Кожна людина має право на громадянство.
Ніхто не може бути безпідставно позбавлений громадянства або права змінити своє громадянство.
Стаття 16.
Чоловіки і жінки, які досягли повноліття, мають право без будь-яких обмежень за ознакою раси, національності або релігії одружуватися і засновувати сім'ю. Вони користуються однаковими правами щодо одруження під час шлюбy та під час його розірвання.
Шлюб може укладатися тільки при вільній і повній згоді сторін, що одружуються.
Сім'я є приподним і основним осередком суспільства і має право на захит з боку суспільства та держави.
Стаття 17.
Кожна людина має право володіти майном як адноособово, так і разом з іншими.
Ніхто не може бути безпідставно позбавлений свого майна.
Стаття 18.
Кожна людина має право на свободу думки, совісті і релігії; це право включає свободу змінювати свою релігію або переконання і свободу сповідувати свою релігію або переконання як одноособово, так і разом з іншими, прилюдним або приватним порядком в ученні, богослужінні і виконанні релігійних та ритуальних обрядів.

Стаття 19.
Кожна людина має право на свободу переконань і на вільне їх виявлення; це право включає свободу безперешкодно дотримуватися своїх переконань та свободу шукати, одержувати і поширювати інформацію та ідеї будь-якими засобами і незалежно від державних кордонів.

Стаття 20.
Кожна людина має право на свободу мирних зборів і асоціацій.
Ніхто не може бути примушений вступати до будь-якої асоціації.
Стаття 21.
Кожна людина має право брати участь в управлінні своєю країною безпосередньо або через вільно обраних представників.
Кожна людина має право рівного доступу до державної служби в своїй країні.
Воля народу повинна бути основою влади уряду; ця воля повинна виявлятися у періодичних і нефальсифікованих виборах, які повинні провадитись при загальному і рівному виборчому праві шляхом таємного голосування або ж через інші рівнозначні форми, що забезпечують свободу голосування.
Стаття 22.
Кожна людина, як член суспільства, має право на соціальне забезпечення і на здійснення необхідних для підтримання її гідності і для вільного розвитку її особи прав у економічній. Соціальній і культурній галузях за допомогою національних зусиль і міжнародного співробітництва та відповідно до структури і ресурсів кожної держави.

Стаття 23.
Кожна людина має право на працю, на вільний вибір роботи, на справедливі і сприятливі умови праці та на захист від безробіття.
Кожна людина, без будь-якої дискримінації, має право на рівну оплату за рівну працю.
Кожний працюючий має право на справедливу і задовільну винагороду, яка забезпечує гідне людини існування, її самої та її сім'ї, і яка в разі необхідності доповнюється іншими засобами соціального забезпечення.
Кожна людина має право створювати професійні спілки і входити до професійних спілок для захисту своїх інтересів.
Стаття 24.
Кожна людина має право на відпочинок і дозвілля, включаючи право на розумне обмеження робочово дня та на оплачувану періодичну відпустку.

Стаття 25.
Кожна людина має право на такий життєвий рівень, включаючи їжу, житло, медичний догляд та необхідне соціальне обслуговування, який є необхідним для підтримання здоров'я і добробуту її самої та її сім'ї, і право на забезпечення в разі безробіття, хвороби, інвалідності, вдівства, старості чи іншого випадку втрати засобів до існування через незалежні від неї обставини.
Материнство і дитинство дають право на особливе піклування і допомогу. Всі діти, народжені у шлюбі або поза шлюбом, повинні користуватися однаковим соціальним захистом.
Стаття 26.
Кожна людина має право на освіту. Освіта повинна бути безплатною, хоча б початкова і загальна. Початкова освіта повинна бути обов'язковою. Технічна і професійна освіта повинна бути загальнодоступною, а вища освіта повинна бути однаково доступною для всіх на основі здібностей кожного.
Освіта повинна бути спрямована на повний розвиток людської особи і збільшення поваги до прав людини і основних свобод. Освіта повинна сприяти взаєморозумінню, терпимості і дружбі між усіма народами, расовими, або релігійними групами і повинна сприяти діяльності Організації Об'єднаних Націй по підтриманню миру.
Батьки мають право пріоритету у виборі виду освіти для своїх малолітніх дітей.
Стаття 27.
Кожна людина має право вільно брати участь у культурному житті суспільства, втішатися мистецтвом, брати участь у науковому прогресі і користуватися його благами.
Кожна людина має право на захист її моральних і матеріальних інтересів, що є результатом наукових, літературних або художніх праць, автором яких вона є.
Стаття 28.
Кожна людина має право на соціальний і міжнародний порядок, при якому права і свободи, викладені в цій Декларації, можуть бути повністю здійснені.

Стаття 29.
Кожна людина має обов'язки перед суспільством, у якому тільки й можливий вільний і повний розвиток її особи.
При здійсненні своїх прав і свобод кожна людина повинна зазнавати тільки таких обмежень, які встаковлені законом виключно з метою забезпечення належного визнання і поваги прав і свобод інших та забеспечення справедливих вимог моралі, громадського порядку і загального добробуту в демократичному суспільстві.
Здійснення цих прав і свобод ні в якому разі не повинно суперечити цілям і принципам Організації Об'єднаних Націй.
Стаття 30.
Ніщо у цій Декларації не може бути витлумачено як надання будь-якій державі, групі осіб або окремим особам права займатися будь-якою діяльністю або вчиняти дії, спрямовані на знищення прав і свобод, викладених у цій Декларації.
TEXT

#is(Text::Guess::Language->guess($text),'uk','is uk');

done_testing;
