# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::MY;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230903131448;

my $formatters = [
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '[4-79]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '
            1(?:
              [02469]|
              [37][1-9]|
              53|
              8(?:
                [1-46-9]|
                5[7-9]
              )
            )|
            8
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3-$4',
                  'leading_digits' => '
            1(?:
              [367]|
              80
            )
          ',
                  'pattern' => '(\\d)(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '1',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              2[0-36-9]|
              3[0-368]|
              4[0-278]|
              5[0-24-8]|
              6[0-467]|
              7[1246-9]|
              8\\d|
              9[0-57]
            )\\d|
            4(?:
              2[0-689]|
              [3-79]\\d|
              8[1-35689]
            )|
            5(?:
              2[0-589]|
              [3468]\\d|
              5[0-489]|
              7[1-9]|
              9[23]
            )|
            6(?:
              2[2-9]|
              3[1357-9]|
              [46]\\d|
              5[0-6]|
              7[0-35-9]|
              85|
              9[015-8]
            )|
            7(?:
              [2579]\\d|
              3[03-68]|
              4[0-8]|
              6[5-9]|
              8[0-35-9]
            )|
            8(?:
              [24][2-8]|
              3[2-5]|
              5[2-7]|
              6[2-589]|
              7[2-578]|
              [89][2-9]
            )|
            9(?:
              0[57]|
              13|
              [25-7]\\d|
              [3489][0-8]
            )
          )\\d{5}
        ',
                'geographic' => '
          (?:
            3(?:
              2[0-36-9]|
              3[0-368]|
              4[0-278]|
              5[0-24-8]|
              6[0-467]|
              7[1246-9]|
              8\\d|
              9[0-57]
            )\\d|
            4(?:
              2[0-689]|
              [3-79]\\d|
              8[1-35689]
            )|
            5(?:
              2[0-589]|
              [3468]\\d|
              5[0-489]|
              7[1-9]|
              9[23]
            )|
            6(?:
              2[2-9]|
              3[1357-9]|
              [46]\\d|
              5[0-6]|
              7[0-35-9]|
              85|
              9[015-8]
            )|
            7(?:
              [2579]\\d|
              3[03-68]|
              4[0-8]|
              6[5-9]|
              8[0-35-9]
            )|
            8(?:
              [24][2-8]|
              3[2-5]|
              5[2-7]|
              6[2-589]|
              7[2-578]|
              [89][2-9]
            )|
            9(?:
              0[57]|
              13|
              [25-7]\\d|
              [3489][0-8]
            )
          )\\d{5}
        ',
                'mobile' => '
          1(?:
            1888[689]|
            4400|
            8(?:
              47|
              8[27]
            )[0-4]
          )\\d{4}|
          1(?:
            0(?:
              [23568]\\d|
              4[0-6]|
              7[016-9]|
              9[0-8]
            )|
            1(?:
              [1-5]\\d\\d|
              6(?:
                0[5-9]|
                [1-9]\\d
              )|
              7(?:
                [0-4]\\d|
                5[0-7]
              )
            )|
            (?:
              [269]\\d|
              [37][1-9]|
              4[235-9]
            )\\d|
            5(?:
              31|
              9\\d\\d
            )|
            8(?:
              1[23]|
              [236]\\d|
              4[06]|
              5(?:
                46|
                [7-9]
              )|
              7[016-9]|
              8[01]|
              9[0-8]
            )
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(1600\\d{6})',
                'toll_free' => '1[378]00\\d{6}',
                'voip' => '
          15(?:
            4(?:
              6[0-4]\\d|
              8(?:
                0[125]|
                [17]\\d|
                21|
                3[01]|
                4[01589]|
                5[014]|
                6[02]
              )
            )|
            6(?:
              32[0-6]|
              78\\d
            )
          )\\d{4}
        '
              };
my %areanames = ();
$areanames{en} = {"606966", "Bakri",
"6032770", "Kuala\ Lumpur",
"6098710", "Cheneh",
"605848", "Taiping",
"6087478", "Labuan",
"6039766", "Cheras",
"6033166", "Kelang",
"6037651", "Kuala\ Lumpur",
"604571", "Tasek\ Gelugor",
"6088690", "Kota\ Marudu",
"604560", "Kepala\ Batas",
"6049372", "Kangar",
"6084613", "Selalang",
"6036178", "Kuala\ Lumpur",
"6089242", "Elopura",
"609634", "Bandar\ Permaisuri",
"609457", "Chini",
"6035165", "Kinrara",
"609687", "Bukit\ Bading",
"6082708", "Kota\ Samarahan",
"609473", "Bukit\ Ibam",
"6088351", "Kota\ Kinabalu",
"6035613", "Kinrara",
"6035164", "Kinrara",
"6083592", "Lubuk\ Antu",
"6088612", "Kudat",
"606486", "Simpang\ Durian",
"606430", "Gemencheh",
"6082701", "Lundu",
"609266", "Jerantut",
"6034815", "Kuala\ Lumpur",
"606656", "Port\ Dickson",
"6032026", "Kuala\ Lumpur",
"6088702", "Kinarut",
"609468", "Maran",
"6087407", "Labuan",
"6085633", "Miri",
"6082315", "Kuching",
"6032781", "Kuala\ Lumpur",
"604687", "Penang",
"6082314", "Kuching",
"6082592", "Kota\ Samarahan",
"605769", "Lenggong",
"604468", "Bedong",
"60443", "Sungai\ Petani",
"6084834", "Matu",
"606388", "Kuala\ Sungai\ Baru",
"6032788", "Kuala\ Lumpur",
"6087480", "Labuan",
"6085768", "Marudi",
"604988", "Kangar",
"6082537", "Kuching",
"6089634", "Elopura",
"605661", "Ipoh",
"6039170", "Kuala\ Lumpur",
"605670", "Sitiawan",
"607788", "Kahang",
"607415", "Batu\ Pahat",
"609560", "Kuantan",
"6085761", "Layang\-Layang",
"606695", "Linggi",
"6036262", "Kuala\ Lumpur",
"6089942", "Tawau",
"6084789", "Kapit",
"609571", "Kuantan",
"6037260", "Kuala\ Lumpur",
"6035740", "Kinrara",
"6086580", "Tatau",
"6084644", "Sarikei",
"605466", "Kampar",
"6084880", "Daro",
"6085290", "Lawas",
"6084645", "Sarikei",
"6082860", "Kota\ Samarahan",
"6082300", "Kuching",
"604820", "Penang",
"6085456", "Miri",
"6032848", "Kuala\ Lumpur",
"6084807", "Sibu",
"6084367", "Sibu",
"6036135", "Kuala\ Lumpur",
"6086507", "Bintulu",
"6089717", "Tawau",
"6082505", "Kuching",
"604314", "Penang",
"6033349", "Kelang",
"607289", "Johor\ Bahru",
"6082504", "Kuching",
"6089570", "Kinabatangan",
"609214", "Bentong",
"6089730", "Tawau",
"603404", "Kuala\ Lumpur",
"6032110", "Kuala\ Lumpur",
"606720", "Seremban",
"6088411", "Kota\ Kinabalu",
"607448", "Batu\ Pahat",
"6083343", "Bandar\ Sri\ Aman",
"605930", "Sitiawan",
"6034290", "Kuala\ Lumpur",
"6035880", "Kinrara",
"609846", "Kuala\ Brang",
"6093260", "Padang\ Tengku",
"6038213", "Putrajaya",
"6085220", "Limbang",
"608822", "Kota\ Kinabalu",
"607596", "Senai",
"606782", "Seremban",
"609974", "Machang",
"603888", "Putrajaya",
"6083566", "Pantu",
"6033110", "Pulau\ Ketam",
"6089563", "Kinabatangan",
"6084871", "Mukah",
"60472", "Alor\ Setar",
"606681", "Seremban",
"6033122", "Tk\ Panglima\ Garang",
"607532", "Senai",
"607705", "Keluang",
"606790", "Mantin",
"60979", "Kota\ Bharu",
"6038913", "Semenyih",
"6088794", "Tuaran",
"607220", "Johor\ Bahru",
"609820", "Paka",
"6086457", "Belaga",
"604890", "Penang",
"6083300", "Bandar\ Sri\ Aman",
"605368", "Pusing",
"607303", "Johor\ Bahru",
"6035878", "Kinrara",
"6033192", "Banting",
"607382", "Johor\ Bahru",
"6034255", "Kuala\ Lumpur",
"6032380", "Kuala\ Lumpur",
"606274", "Melaka",
"605357", "Ipoh",
"608829", "Kota\ Kinabalu",
"6034800", "Kuala\ Lumpur",
"6084232", "Sibu",
"6089671", "Elopura",
"6082228", "Kuching",
"6032119", "Kuala\ Lumpur",
"6038000", "Putrajaya",
"6084734", "Julau",
"604402", "Kulim",
"6089567", "Kinabatangan",
"6082664", "Kota\ Samarahan",
"6082221", "Kuching",
"605699", "Sitiawan",
"6084840", "Kuala\ Igan",
"6082665", "Kota\ Samarahan",
"6034299", "Kuala\ Lumpur",
"604483", "Baling",
"6035889", "Kinrara",
"6082716", "Semantan",
"607365", "Johor\ Bahru",
"6084684", "Sarikei",
"6082309", "Kuching",
"607763", "Ayer\ Hitam",
"6039224", "Kuala\ Lumpur",
"606617", "Kuala\ Klawang",
"607444", "Senggarang",
"609581", "Gebeng",
"604963", "Kuah",
"6085299", "Lawas",
"6082291", "Kuching",
"6039225", "Kuala\ Lumpur",
"605692", "Sitiawan",
"6032303", "Kuala\ Lumpur",
"6082499", "Kuching",
"6085491", "Miri",
"6084223", "Sibu",
"605636", "Sabak\ Bernam",
"605680", "Sitiawan",
"605791", "Grik",
"604409", "Kulim",
"6083309", "Bandar\ Sri\ Aman",
"6084363", "Sibu",
"6084803", "Sibu",
"6082383", "Kuching",
"607427", "Senggarang",
"605622", "Telukintan",
"6037662", "Kuala\ Lumpur",
"604416", "Sungai\ Petani",
"6085666", "Limbang",
"603745", "Kuala\ Lumpur",
"6085604", "Miri",
"608758", "Labuan",
"6032389", "Kuala\ Lumpur",
"605721", "Parit\ Buntar",
"609978", "Kuala\ Krai",
"6034131", "Kuala\ Lumpur",
"604218", "Penang",
"6085605", "Miri",
"604331", "Penang",
"606476", "Ladang\ Geddes",
"608241", "Kuching",
"606278", "Melaka",
"6084381", "Sibu",
"609402", "Chini",
"609231", "Karak",
"6032686", "Kuala\ Lumpur",
"6088362", "Kota\ Kinabalu",
"605629", "Telukintan",
"6082808", "Simunjan",
"609653", "Batu\ Rakit",
"608521", "Limbang",
"6089713", "Tawau",
"609865", "Kemasik",
"607265", "Johor\ Bahru",
"609638", "Kuala\ Berang",
"6036103", "Genting",
"605533", "Tanjung\ Rambutan",
"605418", "Tapah",
"6085622", "Miri",
"607850", "Tiram",
"609250", "Triang",
"606660", "Tekok\ Kemang",
"609595", "Gebeng",
"6088396", "Kota\ Kinabalu",
"6085610", "Miri",
"609345", "Raub",
"607919", "Labis",
"605897", "Semanggol",
"609706", "Kota\ Bharu",
"604719", "Sungai\ Petani",
"6087403", "Labuan",
"6085637", "Miri",
"608733", "Keningau",
"6088966", "Kota\ Belud",
"6088904", "Papar",
"609937", "Kuala\ Balah",
"6038052", "Kinrara",
"607912", "Aver\ Panas",
"604611", "Penang",
"6039141", "Kuala\ Lumpur",
"6087440", "Labuan",
"6039179", "Kuala\ Lumpur",
"606384", "Tangga\ Batu",
"6088204", "Kota\ Kinabalu",
"6088850", "Ranau",
"6085743", "Beluru",
"607272", "Johor\ Bahru",
"6033051", "Kelang",
"609872", "Cheneh",
"607943", "Tenang",
"6088205", "Kota\ Kinabalu",
"609556", "Kuantan",
"609712", "Kota\ Bharu",
"604464", "Jeniang",
"6084780", "Kapit",
"605431", "Besout",
"6089536", "Elopura",
"6082760", "Bau",
"609611", "Bandar\ Permaisuri",
"6036140", "Kuala\ Lumpur",
"604595", "Parit\ Buntar",
"605209", "Ipoh",
"6089982", "Tawau",
"604250", "Penang",
"606534", "Jasin",
"609350", "Raub",
"609525", "Kuantan",
"6036189", "Kuala\ Lumpur",
"6089745", "Merotai",
"607784", "Kahang",
"6089817", "Lahatdatu",
"609719", "Kota\ Bharu",
"609245", "Triang",
"606337", "Melaka",
"607906", "Segamat",
"6039202", "Kuala\ Lumpur",
"607279", "Johor\ Bahru",
"604984", "Kangar",
"608235", "Kuching",
"6083348", "Bandar\ Sri\ Aman",
"6088938", "Kota\ Belud",
"6087729", "Tenom",
"607751", "Lavang\-Lavang",
"605468", "Kampar",
"604951", "Kuah",
"6033082", "Kelang",
"60961", "Kuala\ Brang",
"605687", "Sitiawan",
"6088931", "Kota\ Belud",
"6088413", "Kota\ Kinabalu",
"605473", "Bagan\ Datoh",
"607482", "Kangkar\ Baru",
"607652", "Kulai",
"604769", "Alor\ Setar",
"6083341", "Bandar\ Sri\ Aman",
"6038726", "Semenyih",
"6082807", "Simunjan",
"607969", "Bukit\ Gambir",
"6038211", "Semenyih",
"6035566", "Kinrara",
"607528", "Kangkar\ Pulai",
"6078010", "Mersing",
"607659", "Linggiu",
"6038070", "Kinrara",
"604762", "Alor\ Setar",
"609414", "Kuala\ Rompin",
"6089951", "Balung",
"606351", "Tangga\ Batu",
"609848", "Dungun",
"6058710", "Semanggol",
"6089660", "Elopura",
"607446", "Senggarang",
"608838", "Kota\ Kinabalu",
"604414", "Serdang",
"609762", "Pasir\ Putih",
"6087215", "Beaufort",
"6082871", "Baki",
"6087214", "Beaufort",
"606633", "Seremban",
"607598", "Senai",
"6033290", "Kelang",
"606251", "Melaka",
"60667", "Seremban",
"6082878", "Baki",
"6089673", "Elopura",
"607420", "Senggarang",
"6086294", "Bintulu",
"6039540", "Kuala\ Lumpur",
"609951", "Machang",
"6038081", "Kinrara",
"6082227", "Kuching",
"6086295", "Bintulu",
"6032082", "Kuala\ Lumpur",
"6084873", "Mukah",
"6089561", "Kinabatangan",
"606474", "Palong",
"6089568", "Kinabatangan",
"609769", "Bachok",
"6038911", "Semenyih",
"6032800", "Kuala\ Lumpur",
"6036739", "Kuala\ Kubu\ Baru",
"6088342", "Kota\ Kinabalu",
"6034770", "Kuala\ Lumpur",
"6088975", "Kota\ Belud",
"606522", "Jasin",
"6037832", "Kuala\ Lumpur",
"6088353", "Kota\ Kinabalu",
"6035611", "Kinrara",
"605846", "Taiping",
"606968", "Pagoh",
"6087854", "Bongawan",
"609949", "Ayer\ Lanas",
"60458", "Sungai\ Bakap",
"606973", "Bukit\ Gambir",
"606242", "Melaka",
"6036020", "Batu\ Arang",
"605889", "Taiping",
"6089818", "Lahad\ Datu",
"6052320", "Ipoh",
"6037949", "Kuala\ Lumpur",
"604913", "Alor\ Setar",
"6084352", "Sibu",
"6036090", "Rawang",
"606667", "Sepang",
"604373", "Penang",
"6038656", "Cheras",
"605890", "Semanggol",
"604554", "Tasek\ Gelugor",
"609466", "Maran",
"606230", "Melaka",
"6085770", "Long\ Lama",
"604368", "Kepala\ Batas",
"6033852", "Banting",
"606658", "Sepang",
"6034026", "Kuala\ Lumpur",
"606529", "Jasin",
"609268", "Damak",
"607868", "Tiram",
"6035522", "Kinrara",
"6084816", "Rejang",
"607742", "Lavang\-Lavang",
"608877", "Kinarut",
"6038529", "Mantin",
"609913", "Gua\ Musang",
"6087460", "Labuan",
"604268", "Penang",
"606330", "Melaka",
"605820", "Taiping",
"6086462", "Bakun",
"6037971", "Kuala\ Lumpur",
"609368", "Raub",
"604466", "Bedong",
"603269", "Kuala\ Lumpur",
"6085631", "Miri",
"6034105", "Kuala\ Lumpur",
"6087812", "Sipitang",
"6082639", "Kuching",
"607786", "Felda\ Kahang\ Timur",
"6036055", "Kuala\ Kubu\ Baru",
"6084777", "Song",
"605517", "Tanjung\ Rambutan",
"604704", "Pokok\ Sena",
"6032783", "Kuala\ Lumpur",
"6034104", "Kuala\ Lumpur",
"607904", "Tenang",
"6047456", "Alor\ Setar",
"604986", "Kangar",
"604930", "Alor\ Setar",
"609815", "Kerteh",
"607749", "Ayer\ Hitam",
"6089706", "Tawau",
"6085638", "Miri",
"606536", "Jasin",
"6087820", "Sipitang",
"6089616", "Elopura",
"609775", "Kota\ Bharu",
"6039021", "Kuala\ Lumpur",
"604949", "Kangar",
"60668", "Rembau",
"60645", "Bahau",
"609450", "Bukit\ Ibam",
"6036099", "Rawang",
"6085767", "Marudi",
"6038691", "Semenyih",
"6037940", "Kuala\ Lumpur",
"605416", "Tapah",
"6082538", "Kuching",
"607921", "Labis",
"609680", "Kuala\ Brang",
"606964", "Tangkak",
"609708", "Kota\ Bharu",
"6088532", "Kota\ Kinabalu",
"6085779", "Long\ Lama",
"606437", "Johol",
"605581", "Chemor",
"6082531", "Kuching",
"609264", "Mentakab",
"6036101", "Genting",
"6039775", "Kuala\ Lumpur",
"6087209", "Beaufort",
"6034051", "Kuala\ Lumpur",
"606654", "Port\ Dickson",
"6087408", "Labuan",
"604629", "Penang",
"604558", "Tasek\ Gelugor",
"6087391", "Keningau",
"6032787", "Kuala\ Lumpur",
"6036108", "Genting",
"6084773", "Song",
"6087401", "Labuan",
"609558", "Kuantan",
"6039100", "Cheras",
"6033610", "Kuala\ Selangor",
"6038324", "Putrajaya",
"6037481", "Kuala\ Lumpur",
"6089514", "Beluran",
"605677", "Bruas",
"6089515", "Beluran",
"6082707", "Kota\ Samarahan",
"6038325", "Putrajaya",
"604264", "Penang",
"604699", "Alor\ Setar",
"6038964", "Cheras",
"6082780", "Gedong",
"6088357", "Kota\ Kinabalu",
"609567", "Kuantan",
"6084760", "Kanowit",
"604680", "Penang",
"6039056", "Cheras",
"605318", "Ipoh",
"6036242", "Kuala\ Lumpur",
"6038520", "Kinrara",
"6087477", "Labuan",
"609721", "Kota\ Bharu",
"6036177", "Kuala\ Lumpur",
"607908", "Bekok",
"609445", "Bandar\ Tun\ Razak",
"6084228", "Sibu",
"6089677", "Elopura",
"6038079", "Kinrara",
"6082734", "Lundu",
"6038751", "Semenyih",
"6082293", "Kuching",
"6082735", "Lundu",
"6032301", "Kuala\ Lumpur",
"6085493", "Sundar",
"6089669", "Elopura",
"6082685", "Kuching",
"604510", "Tasek\ Gelugor",
"6084221", "Sibu",
"608887", "Ranau",
"606727", "Seremban",
"6082840", "Damai\ Beach",
"6082684", "Kuching",
"605743", "Manong",
"604283", "Penang",
"6032299", "Kuala\ Lumpur",
"6089864", "Lahad\ Datu",
"6084869", "Kuala\ Igan",
"608223", "Kuching",
"604827", "Penang",
"609844", "Dungun",
"607244", "Johor\ Bahru",
"6089865", "Lahad\ Datu",
"609785", "Pasirputih",
"6082889", "Serian",
"607297", "Johor\ Bahru",
"6089926", "Tawau",
"609418", "Nenasi",
"6084877", "Mukah",
"6082223", "Kuching",
"605595", "Chemor",
"6082546", "Kuching",
"608543", "Miri",
"605245", "Ipoh",
"60457", "Kepala\ Batas",
"605719", "Parit\ Buntar",
"606983", "Bakri",
"6085736", "Batu\ Niah",
"6082803", "Simunjan",
"6089718", "Tawau",
"607227", "Johor\ Bahru",
"6084383", "Sibu",
"609827", "Paka",
"6039549", "Cheras",
"609976", "Machang",
"604418", "Mahang",
"6089711", "Tawau",
"604309", "Sungai\ Petani",
"6037732", "Kuala\ Lumpur",
"605350", "Batu\ Gajah",
"605525", "Ipoh",
"6032604", "Kuala\ Lumpur",
"6033868", "Batang\ Berjuntai",
"6084801", "Sibu",
"6084361", "Sibu",
"606276", "Melaka",
"6082381", "Kuching",
"6089296", "Elopura",
"6032605", "Kuala\ Lumpur",
"6084808", "Sibu",
"606463", "Palong",
"605872", "Semanggol",
"607883", "Kota\ Tinggi",
"6086508", "Bintulu",
"605712", "Parit\ Buntar",
"6032847", "Kuala\ Lumpur",
"6082388", "Kuching",
"606797", "Mantin",
"6038775", "Mantin",
"6082551", "Kuching",
"607964", "Bukit\ Gambir",
"6082283", "Kuching",
"6083408", "Maludam",
"6088552", "Telupid",
"605632", "Kampong\ Gajah",
"6089986", "Tawau",
"604764", "Alor\ Setar",
"609412", "Kuala\ Rompin",
"6082829", "Asajaya",
"6039206", "Kuala\ Lumpur",
"60745", "Sri\ Gading",
"605640", "Hutan\ Melintang",
"6034821", "Kuala\ Lumpur",
"604291", "Penang",
"6082261", "Kuching",
"6082899", "Serian",
"6082625", "Kuching",
"6032240", "Kuala\ Lumpur",
"609221", "Bentong",
"609541", "Sungai\ Lembing",
"607484", "Batu\ Pahat",
"6089532", "Elopura",
"607654", "Linggiu",
"6083321", "Bandar\ Sri\ Aman",
"609419", "Kuala\ Rompin",
"603209", "Kuala\ Lumpur",
"604406", "Padang\ Serai",
"6034031", "Kuala\ Lumpur",
"6085461", "Miri",
"6082328", "Serian",
"6039520", "Kuala\ Lumpur",
"604391", "Penang",
"6083477", "Betong",
"6088962", "Papar",
"6036690", "Batuarang",
"607891", "Kota\ Tinggi",
"6084393", "Sibu",
"609321", "Kuala\ Lipis",
"6035270", "Kinrara",
"6082650", "Kuching",
"609208", "Sungai\ Tekam",
"606472", "Kuala\ Klawang",
"6082321", "Kuching",
"605485", "Cameron\ Highland",
"6087771", "Tambunan",
"6083469", "Sebuyau",
"604419", "Sungai\ Petani",
"603216", "Kuala\ Lumpur",
"604308", "Tasek\ Gelugor",
"605655", "Kampong\ Gajah",
"6038100", "Kinrara",
"6037610", "Kuala\ Lumpur",
"608433", "Sibu",
"6085626", "Miri",
"609764", "Bachok",
"604412", "Penang",
"6085201", "Limbang",
"609443", "Bandar\ Tun\ Razak",
"6089286", "Elopura",
"6088515", "Kota\ Kinabalu",
"606479", "Ayer\ Hitam",
"6082391", "Kuching",
"6032203", "Kuala\ Lumpur",
"6088402", "Kota\ Kinabalu",
"6033289", "Kuala\ Selangor",
"605626", "Telukintan",
"6082401", "Kuching",
"6088304", "Kota\ Kinabalu",
"604927", "Ayer\ Hitam",
"6087803", "Sipitang",
"6088366", "Kota\ Kinabalu",
"6039410", "Cheras",
"6032727", "Kuala\ Lumpur",
"609944", "Ayer\ Lanas",
"604552", "Tasek\ Gelugor",
"604716", "Alor\ Setar",
"6082755", "Kuching",
"605421", "Besout",
"6038688", "Putrajaya",
"6032732", "Kuala\ Lumpur",
"607916", "Bekok",
"6037666", "Kuala\ Lumpur",
"606524", "Jasin",
"606776", "Seremban",
"604559", "Tasek\ Gelugor",
"604628", "Penang",
"609783", "Bachok",
"6088669", "Kota\ Marudu",
"607570", "Senai",
"605212", "Ipoh",
"6085662", "Miri",
"607561", "Senai",
"608225", "Kuching",
"605837", "Selama",
"6087734", "Tenom",
"606547", "Durian\ Tunggal",
"609559", "Kuantan",
"604702", "Alor\ Setar",
"607902", "Tangkak",
"6087735", "Tenom",
"6037861", "Kuala\ Lumpur",
"6082790", "Tebedu",
"606227", "Melaka",
"605312", "Ipoh",
"6085756", "Marudi",
"604783", "Lubuk\ Merbau",
"606985", "Muar",
"605243", "Ipoh",
"604997", "Kangar",
"6088608", "Kudat",
"6035542", "Kinrara",
"604944", "Kangar",
"6036411", "Kuala\ Lumpur",
"607744", "Ayer\ Hitam",
"6087889", "Membakut",
"6082720", "Lundu",
"607885", "Kota\ Tinggi",
"606465", "Ayer\ Hitam",
"609285", "Mentakab",
"6039132", "Kuala\ Lumpur",
"6087223", "Beaufort",
"607276", "Johor\ Bahru",
"6082712", "Semantan",
"605750", "Kuala\ Kangsar",
"6037883", "Kuala\ Lumpur",
"609552", "Kuantan",
"604709", "Alor\ Setar",
"607862", "Tiram",
"606969", "Bukit\ Kepong",
"6032935", "Kuala\ Lumpur",
"6039070", "Cheras",
"6087871", "Weston",
"6079010", "Tenggara",
"6036049", "Kerling",
"60442", "Sungai\ Petani",
"606490", "Rembau",
"6035125", "Kinrara",
"6084236", "Sibu",
"605888", "Taiping",
"6035124", "Kinrara",
"6037887", "Kuala\ Lumpur",
"6083562", "Roban",
"6087227", "Beaufort",
"6035195", "Kinrara",
"606962", "Bakri",
"6087341", "Keningau",
"604369", "Serdang",
"609269", "Damak",
"607869", "Senai",
"606489", "Kuala\ Klawang",
"6033126", "Tk\ Panglima\ Garang",
"6087232", "Beaufort",
"606659", "Sepang",
"607251", "Johor\ Bahru",
"609851", "Chukai",
"6039081", "Cheras",
"605766", "Lenggong",
"6087880", "Membakut",
"604269", "Penang",
"6032723", "Kuala\ Lumpur",
"609369", "Dong",
"609362", "Fraser\ Hill",
"6096830", "Kuala\ Brang",
"604262", "Penang",
"606420", "Johol",
"607748", "Keluang",
"60449", "Kulim",
"6036078", "Batu\ Arang",
"6085452", "Miri",
"6085791", "Miri",
"60942", "Pekan",
"605404", "Tapah",
"608832", "Kota\ Kinabalu",
"606315", "Melaka",
"6082890", "Serian",
"609842", "Dungun",
"606975", "Muar",
"604757", "Alor\ Setar",
"605469", "Kampar",
"604768", "Alor\ Setar",
"60473", "Alor\ Setar",
"607522", "Senai",
"6083473", "Betong",
"6088333", "Kota\ Kinabalu",
"6033271", "Batang\ Berjuntai",
"607968", "Gemas",
"60793", "Segamat",
"6084480", "Sibu",
"609830", "Paka",
"605805", "Taiping",
"6082596", "Kuching",
"603762", "Kuala\ Lumpur",
"6044110", "Serdang",
"6033010", "Pulau\ Ketam",
"607658", "Kulai",
"607488", "Batu\ Pahat",
"6035480", "Kinrara",
"609849", "Dungun",
"604375", "Penang",
"604915", "Changlon",
"6034260", "Kuala\ Lumpur",
"6086486", "Balingan",
"6035102", "Kinrara",
"607386", "Johor\ Bahru",
"6089275", "Elopura",
"6032037", "Kuala\ Lumpur",
"609204", "Jerantut",
"603414", "Kuala\ Lumpur",
"607599", "Senai",
"606641", "Port\ Dickson",
"6089274", "Elopura",
"604886", "Penang",
"604830", "Penang",
"6032022", "Kuala\ Lumpur",
"609915", "Gua\ Musang",
"6033280", "Kuala\ Selangor",
"6082287", "Damai\ Beach",
"6088616", "Kudat",
"6038021", "Kinrara",
"605714", "Parit\ Buntar",
"6038091", "Kinrara",
"6086284", "Bintulu",
"6033162", "Kelang",
"609773", "Kota\ Bharu",
"6086285", "Bintulu",
"608977", "Tawau",
"6032278", "Kuala\ Lumpur",
"609813", "Paka",
"6036034", "Rawang",
"608826", "Kota\ Kinabalu",
"6083460", "Sebuyau",
"6082473", "Kuching",
"6089246", "Elopura",
"605920", "Sitiawan",
"6036035", "Batuarang",
"609768", "Bachok",
"6082659", "Kota\ Samarahan",
"6089523", "Telupid",
"6038661", "Mantin",
"604485", "Padang\ Serai",
"607363", "Johor\ Bahru",
"605419", "Tapah",
"6088885", "Ranau",
"605541", "Ipoh",
"609639", "Kuala\ Brang",
"608267", "Kota\ Samarahan",
"6084755", "Kanowit",
"607918", "Aver\ Panas",
"608258", "Kuching",
"6037870", "Kuala\ Lumpur",
"6038950", "Cheras",
"6084754", "Kanowit",
"604626", "Penang",
"6087801", "Sipitang",
"608741", "Labuan",
"605412", "Trolak",
"607765", "Endau",
"608425", "Sibu",
"606497", "Rembau",
"609632", "Kuala\ Brang",
"6087228", "Beaufort",
"6038609", "Kinrara",
"6089937", "Luasong",
"6038995", "Cheras",
"6087221", "Beaufort",
"6082542", "Sejingkat",
"6084790", "Kapit",
"6089922", "Tawau",
"6038994", "Cheras",
"606427", "Kuala\ Pilah",
"609965", "Kuala\ Krai",
"605443", "Tapah",
"605208", "Ipoh",
"609863", "Chukai",
"609485", "Jengka\ Lapan\ Belas",
"606265", "Sungai\ Rambai",
"605406", "Tapah",
"609718", "Kota\ Bharu",
"6037863", "Kuala\ Lumpur",
"608564", "Miri",
"607278", "Johor\ Bahru",
"605321", "Ipoh",
"605291", "Tanjung\ Rambutan",
"6089966", "Lahad\ Datu",
"608847", "Kota\ Kinabalu",
"605783", "Kuala\ Kangsar",
"606379", "Tangga\ Batu",
"609212", "Maran",
"6035624", "Kinrara",
"6084695", "Bintangor",
"605698", "Sitiawan",
"6038892", "Putrajaya",
"609593", "Gambang",
"6099560", "Batu\ Gajah",
"6083323", "Bandar\ Sri\ Aman",
"606850", "Mantin",
"6035625", "Kinrara",
"6084694", "Bintangor",
"6034289", "Kuala\ Lumpur",
"6085463", "Miri",
"605535", "Tanjung\ Rambutan",
"6087760", "Tenom",
"607660", "Kulai",
"6085240", "Kampung\ Pahlawan",
"6082553", "Kuching",
"6038027", "Kinrara",
"607950", "Aver\ Panas",
"6082281", "Kuching",
"6089894", "Kunak",
"6089465", "Elopura",
"6092870", "Kuala\ Krau",
"6036274", "Kuala\ Lumpur",
"6085481", "Bekenu",
"604408", "Kulim",
"6089464", "Elopura",
"6035039", "Kinrara",
"6036275", "Kuala\ Lumpur",
"6032031", "Kuala\ Lumpur",
"605385", "Bota",
"6082288", "Kuching",
"6088982", "Tenghilan",
"6088744", "Kinarut",
"609750", "Kota\ Bharu",
"605716", "Parit\ Buntar",
"6088745", "Kinarut",
"6082393", "Sejingkat",
"607587", "Senai",
"608759", "Labuan",
"6032201", "Kuala\ Lumpur",
"604306", "Penang",
"607945", "Tenang",
"609408", "Kuala\ Rompin",
"6088830", "Tuaran",
"604219", "Penang",
"605285", "Ipoh",
"606737", "Mantin",
"604884", "Penang",
"609979", "Machang",
"6082403", "Kuching",
"608824", "Kota\ Kinabalu",
"6082270", "Kuching",
"6089204", "Elopura",
"608233", "Kuching",
"6098000", "Kerteh",
"6033277", "Kuala\ Selangor",
"6035650", "Kinrara",
"6089850", "Kunak",
"6089205", "Elopura",
"606906", "Muar",
"609243", "Triang",
"6084391", "Sibu",
"609312", "Kuala\ Lipis",
"604500", "Kulim",
"6033142", "Sepang",
"6033269", "Kuala\ Selangor",
"60735", "Johor\ Bahru",
"6082323", "Damai\ Beach",
"6084398", "Sibu",
"6087773", "Tambunan",
"6085470", "Miri",
"604593", "Parit\ Buntar",
"6088536", "Kota\ Kinabalu",
"6085280", "Lawas",
"6047452", "Alor\ Setar",
"6086590", "Tatau",
"6034162", "Kuala\ Lumpur",
"6087315", "Keningau",
"607442", "Senggarang",
"6032182", "Kuala\ Lumpur",
"6087314", "Keningau",
"6036286", "Kuala\ Lumpur",
"6062710", "Sungai\ Rambai",
"6089612", "Elopura",
"6035030", "Kinrara",
"6086325", "Bintulu",
"6089702", "Tawau",
"6086324", "Bintulu",
"604766", "Alor\ Setar",
"6084812", "Stapang",
"607486", "Batu\ Pahat",
"607656", "Kulai",
"6087777", "Tambunan",
"6038766", "Semenyih",
"604404", "Mahang",
"6038705", "Mantin",
"607288", "Johor\ Bahru",
"60549", "Cameron\ Highland",
"609888", "Kemasik",
"6035526", "Kinrara",
"6034280", "Kuala\ Lumpur",
"6086466", "Sebauh",
"6088331", "Kota\ Kinabalu",
"6083471", "Betong",
"607511", "Senai",
"6084820", "Daro",
"609475", "Maran",
"6033273", "Batang\ Berjuntai",
"6032260", "Kuala\ Lumpur",
"6032856", "Kuala\ Lumpur",
"6038093", "Kinrara",
"6086555", "Bintulu",
"604888", "Penang",
"6037770", "Kuala\ Lumpur",
"609404", "Pekan",
"6082279", "Kuching",
"6083327", "Bandar\ Sri\ Aman",
"603214", "Kuala\ Lumpur",
"6089859", "Kunak",
"607388", "Johor\ Bahru",
"6088785", "Tuaran",
"6034022", "Kuala\ Lumpur",
"6082471", "Kuching",
"604475", "Kupang",
"6032273", "Kuala\ Lumpur",
"6088784", "Tuaran",
"6033260", "Kuala\ Selangor",
"6089521", "Telupid",
"6033856", "Sabak\ Bernam",
"606415", "Tampin",
"6089591", "Telupid",
"6033182", "Banting",
"605624", "Hutan\ Melintang",
"606693", "Rantau",
"6086350", "Bintulu",
"605369", "Pusing",
"6034278", "Kuala\ Lumpur",
"607413", "Batu\ Pahat",
"609766", "Bachok",
"6038023", "Kinrara",
"6034271", "Kuala\ Lumpur",
"6083480", "Betong",
"608828", "Kota\ Kinabalu",
"605507", "Ipoh",
"604714", "Alor\ Setar",
"605849", "Taiping",
"6088607", "Kudat",
"607914", "Tenang",
"6088346", "Kota\ Kinabalu",
"60929", "Mentakab",
"609946", "Ayer\ Lanas",
"6033216", "Sabak\ Bernam",
"6083435", "Saratok",
"607720", "Mersing",
"6039191", "Kuala\ Lumpur",
"604920", "Kangar",
"6038959", "Cheras",
"6037879", "Kuala\ Lumpur",
"604903", "Kuah",
"606532", "Jasin",
"607451", "Batu\ Pahat",
"605768", "Lenggong",
"6082582", "Kota\ Samarahan",
"6036073", "Kuala\ Kubu\ Baru",
"6089725", "Tawau",
"607782", "Paloh",
"604469", "Jeniang",
"605757", "Kuala\ Kangsar",
"6087490", "Labuan",
"6088671", "Kudat",
"604982", "Kangar",
"608922", "Elopura",
"6087505", "Labuan",
"6033086", "Kelang",
"604989", "Kangar",
"607274", "Johor\ Bahru",
"609874", "Kemasik",
"6086422", "Sebauh",
"607789", "Keluang",
"6087504", "Labuan",
"6038600", "Kinrara",
"605375", "Bota",
"604462", "Jeniang",
"609714", "Kota\ Bharu",
"606540", "Durian\ Tunggal",
"6038687", "Putrajaya",
"6032721", "Kuala\ Lumpur",
"6035562", "Kinrara",
"604946", "Kangar",
"607305", "Johor\ Bahru",
"606390", "Tangga\ Batu",
"607746", "Renggam",
"6084799", "Kapit",
"60782", "Penggerang",
"6036120", "Kuala\ Lumpur",
"6085485", "Kampung\ Bakam",
"605881", "Selama",
"6089461", "Elopura",
"6032034", "Kuala\ Lumpur",
"6033850", "Banting",
"6089277", "Elopura",
"606758", "Mantin",
"6032035", "Kuala\ Lumpur",
"6082284", "Kuching",
"606615", "Kuala\ Klawang",
"6082285", "Kuching",
"6084350", "Sibu",
"6036092", "Rawang",
"606493", "Kuala\ Klawang",
"606521", "Jasin",
"6084691", "Bintangor",
"6036022", "Batu\ Arang",
"6035621", "Kinrara",
"6036037", "Rawang",
"6084698", "Bintangor",
"6084555", "Sibu",
"6089901", "Merotai",
"6035628", "Kinrara",
"603261", "Kuala\ Lumpur",
"6033396", "Kelang",
"6035590", "Kinrara",
"607267", "Johor\ Bahru",
"609867", "Kemasik",
"6087822", "Sipitang",
"6036280", "Kuala\ Lumpur",
"6035036", "Kinrara",
"6089208", "Elopura",
"6084405", "Sibu",
"6039018", "Cheras",
"6084394", "Sibu",
"6085286", "Lawas",
"6084896", "Stapang",
"607686", "Pontian",
"6084395", "Sibu",
"6039011", "Cheras",
"609858", "Chukai",
"6089201", "Elopura",
"6087810", "Sipitang",
"604941", "Kangar",
"6047210", "Sungai\ Petani",
"6086460", "Belaga",
"6032266", "Kuala\ Lumpur",
"607741", "Felda\ Kahang\ Timur",
"6087462", "Labuan",
"6038760", "Semenyih",
"607425", "Parit\ Betak",
"6088741", "Kinarut",
"6033326", "Kelang",
"6088513", "Kota\ Kinabalu",
"6035520", "Kinrara",
"606423", "Simpang\ Durian",
"6089969", "Lahad\ Datu",
"607961", "Segamat",
"604810", "Penang",
"607970", "Segamat",
"6094310", "Pekan",
"606352", "Tangga\ Batu",
"6036196", "Kuala\ Lumpur",
"604959", "Kuah",
"6086252", "Bintulu",
"607759", "Ayer\ Hitam",
"6087250", "Beaufort",
"6088863", "Bongawan",
"6088303", "Kota\ Kinabalu",
"6033362", "Kelang",
"607516", "Tanjung\ Kupang",
"607752", "Lavang\-Lavang",
"604669", "Penang",
"608843", "Kota\ Kinabalu",
"606235", "Melaka",
"6088888", "Ranau",
"6084751", "Kanowit",
"604324", "Penang",
"605895", "Taiping",
"609224", "Bentong",
"609833", "Bukit\ Besi",
"6036126", "Kuala\ Lumpur",
"6033007", "Kuala\ Selangor",
"604952", "Kuah",
"6032222", "Kuala\ Lumpur",
"6088881", "Ranau",
"607651", "Layang\-Layang",
"6037713", "Kuala\ Lumpur",
"6033080", "Kelang",
"6084302", "Sibu",
"607481", "Kangkar\ Baru",
"609544", "Kuantan",
"603673", "Kuala\ Lumpur",
"6082882", "Serian",
"609952", "Machang",
"608237", "Kuching",
"606335", "Melaka",
"604224", "Penang",
"604347", "Penang",
"609324", "Kuala\ Lipis",
"609247", "Bera",
"607894", "Kota\ Tinggi",
"607509", "Senai",
"6036436", "Genting",
"609294", "Kuala\ Krau",
"609669", "Batu\ Rakit",
"6032080", "Kuala\ Lumpur",
"606648", "Port\ Dickson",
"6087733", "Tenom",
"604597", "Parit\ Buntar",
"6037884", "Kuala\ Lumpur",
"6087225", "Beaufort",
"6038991", "Cheras",
"607210", "Johor\ Bahru",
"605856", "Taiping",
"6033292", "Kelang",
"6087224", "Beaufort",
"6037885", "Kuala\ Lumpur",
"609770", "Bachok",
"6038998", "Cheras",
"606252", "Melaka",
"6086952", "Bintulu",
"609662", "Kuala\ Brang",
"609959", "Batu\ Gajah",
"606733", "Mantin",
"6036066", "Kuala\ Kubu\ Baru",
"6083438", "Saratok",
"6035123", "Kinrara",
"6084796", "Kapit",
"6087737", "Tenom",
"6039195", "Kuala\ Lumpur",
"6039236", "Kuala\ Lumpur",
"609685", "Kuala\ Brang",
"609455", "Bukit\ Ibam",
"6036158", "Kuala\ Lumpur",
"604201", "Penang",
"6082842", "Damai\ Beach",
"604432", "Kulim",
"605643", "Hutan\ Melintang",
"6087451", "Labuan",
"609548", "Gambang",
"609301", "Jerantut",
"6036151", "Kuala\ Lumpur",
"609228", "Bilut\ Valley",
"607828", "Penawar",
"604298", "Penang",
"6037876", "Kuala\ Lumpur",
"6088307", "Kota\ Kinabalu",
"6038873", "Putrajaya",
"6087508", "Labuan",
"6038956", "Serdang",
"6032725", "Kuala\ Lumpur",
"604548", "Tasek\ Gelugor",
"6056340", "Kampong\ Gajah",
"6032724", "Kuala\ Lumpur",
"606697", "Linggi",
"606644", "Port\ Dickson",
"605612", "Sitiawan",
"607898", "Tenggara",
"609328", "Kuala\ Lipis",
"6089798", "Tawau",
"6087501", "Labuan",
"604228", "Penang",
"604398", "Penang",
"6088674", "Kudat",
"609440", "Bandar\ Tun\ Razak",
"6088675", "Pantai\ Pitas",
"6085231", "Kampung\ Pahlawan",
"6088349", "Kota\ Kinabalu",
"608486", "Dalat",
"60644", "Tampin",
"6089728", "Tawau",
"6037717", "Kuala\ Lumpur",
"604455", "Sungai\ Petani",
"604685", "Penang",
"6032089", "Kuala\ Lumpur",
"6085238", "Limbang",
"606901", "Muar",
"6083475", "Debak",
"604515", "Tasekgelugor",
"6088334", "Kota\ Kinabalu",
"6083474", "Debak",
"6038708", "Mantin",
"605226", "Ipoh",
"6087833", "Menumbok",
"605546", "Ipoh",
"607929", "Aver\ Panas",
"6086391", "Bintulu",
"6037839", "Kuala\ Lumpur",
"6086321", "Bintulu",
"604722", "Kulim",
"6088517", "Kota\ Kinabalu",
"6087318", "Keningau",
"605255", "Ipoh",
"607922", "Bekok",
"6087311", "Keningau",
"6089856", "Kunak",
"6086328", "Bintulu",
"604621", "Penang",
"609780", "Kok\ Lanas",
"603551", "Kinrara",
"6032859", "Kuala\ Lumpur",
"609854", "Chukai",
"607254", "Johor\ Bahru",
"605520", "Ipoh",
"6038777", "Mantin",
"6087766", "Tambunan",
"6086469", "Belaga",
"605240", "Ipoh",
"6089273", "Elopura",
"6038769", "Semenyih",
"6038522", "Semenyih",
"607980", "Bakri",
"6089524", "Telupid",
"6082627", "Kuching",
"6084762", "Kanowit",
"6033620", "Kelang",
"6088781", "Tuaran",
"605296", "Tanjung\ Rambutan",
"607707", "Keluang",
"6082474", "Kuching",
"6082782", "Gedong",
"6088788", "Tuaran",
"6033358", "Kelang",
"603798", "Kuala\ Lumpur",
"605753", "Kuala\ Kangsar",
"605401", "Tapah",
"604799", "Pokok\ Sena",
"6063130", "Melaka",
"6086283", "Bintulu",
"6039102", "Cheras",
"608891", "Papar",
"6085222", "Limbang",
"606620", "Port\ Dickson",
"6084753", "Kanowit",
"6037718", "Kuala\ Lumpur",
"6093262", "Padang\ Tengku",
"6089727", "Tawau",
"6035882", "Kinrara",
"6034292", "Kuala\ Lumpur",
"60962", "Kuala\ Brang",
"604565", "Kepala\ Batas",
"607674", "Pontian",
"6037711", "Kuala\ Lumpur",
"6085759", "Marudi",
"604447", "Bedong",
"6082492", "Kuching",
"606435", "Tampin",
"6082751", "Bau",
"6088308", "Kota\ Kinabalu",
"6087507", "Labuan",
"607518", "Senai",
"6033382", "Kelang",
"6038684", "Putrajaya",
"6082862", "Kota\ Samarahan",
"6082302", "Kuching",
"6088301", "Kota\ Kinabalu",
"6088861", "Bongawan",
"6088605", "Kudat",
"6034802", "Kuala\ Lumpur",
"6038993", "Cheras",
"609447", "Bandar\ Tun\ Razak",
"6036157", "Kuala\ Lumpur",
"606459", "Serting",
"6032382", "Kuala\ Lumpur",
"6033190", "Banting",
"607381", "Johor\ Bahru",
"6039076", "Cheras",
"604881", "Penang",
"6037669", "Kuala\ Lumpur",
"606646", "Port\ Dickson",
"609565", "Kuantan",
"6083410", "Kabong",
"6037865", "Kuala\ Lumpur",
"608821", "Kota\ Kinabalu",
"606781", "Sepang",
"605858", "Taiping",
"6033120", "Tk\ Panglima\ Garang",
"603893", "Cheras",
"6083437", "Saratok",
"6087738", "Tenom",
"606603", "Seremban",
"60969", "Jerteh",
"607531", "Senai",
"606682", "Seremban",
"6087731", "Tenom",
"6088369", "Kota\ Kinabalu",
"605675", "Changkat\ Keruing",
"6083325", "Bandar\ Sri\ Aman",
"606512", "Jasin",
"6085406", "Miri",
"6084693", "Bintangor",
"605597", "Chemor",
"6083324", "Bandar\ Sri\ Aman",
"6082628", "Kuching",
"6035623", "Kinrara",
"609787", "Machang",
"607295", "Johor\ Bahru",
"6089289", "Elopura",
"6089903", "Merotai",
"603563", "Kinrara",
"6088787", "Tuaran",
"606293", "Melaka",
"6082621", "Kuching",
"6038778", "Mantin",
"6089240", "Elopura",
"609900", "Gua\ Musang",
"604923", "Changlon",
"6089463", "Elopura",
"6083466", "Debak",
"6049370", "Kangar",
"6036273", "Kuala\ Lumpur",
"6082698", "Kuching",
"604572", "Tasek\ Gelugor",
"6082555", "Kuching",
"606519", "Jasin",
"6032772", "Kuala\ Lumpur",
"607467", "Sri\ Gading",
"6038749", "Semenyih",
"6082520", "Kuching",
"607934", "Labis",
"607793", "Endau",
"6087317", "Keningau",
"6088518", "Kota\ Kinabalu",
"605810", "Taiping",
"607256", "Johor\ Bahru",
"609856", "Chukai",
"6039172", "Kuala\ Lumpur",
"6082896", "Serian",
"6083555", "Bandar\ Sri\ Aman",
"6088743", "Kinarut",
"607688", "Pontian",
"609572", "Kuantan",
"6088511", "Kota\ Kinabalu",
"6085266", "Lawas",
"6086327", "Bintulu",
"6086449", "Pelagus",
"605527", "Ipoh",
"6082325", "Serian",
"6087482", "Labuan",
"6038707", "Mantin",
"6087774", "Tambunan",
"6086480", "Balingan",
"6034266", "Kuala\ Lumpur",
"6082324", "Asajaya",
"6087775", "Tambunan",
"6082826", "Asajaya",
"6082590", "Kuching",
"609825", "Kerteh",
"607225", "Johor\ Bahru",
"605294", "Tanjung\ Rambutan",
"605669", "Sitiawan",
"6038780", "Mantin",
"6089203", "Elopura",
"604787", "Alor\ Setar",
"6086323", "Bintulu",
"604860", "Penang",
"6088747", "Kinarut",
"607911", "Aver\ Panas",
"607360", "Johor\ Bahru",
"608251", "Kuching",
"6087313", "Keningau",
"608633", "Bintulu",
"604612", "Penang",
"605548", "Ipoh",
"6089207", "Elopura",
"605685", "Sitiawan",
"6085612", "Miri",
"6088709", "Kinarut",
"6087831", "Menumbok",
"609606", "Tenang",
"6033275", "Batang\ Berjuntai",
"604619", "Penang",
"606771", "Seremban",
"609738", "Kota\ Bharu",
"6085620", "Miri",
"6089280", "Elopura",
"6038703", "Mantin",
"6088783", "Tuaran",
"6039200", "Kuala\ Lumpur",
"607684", "Pontian",
"605439", "Tapah",
"6032274", "Kuala\ Lumpur",
"6065110", "Jasin",
"608862", "Kudat",
"6032275", "Kuala\ Lumpur",
"607938", "Tenang",
"6038095", "Kinrara",
"605440", "Tapah",
"6036038", "Kuala\ Lumpur",
"6038094", "Kinrara",
"6086281", "Bintulu",
"607271", "Johor\ Bahru",
"6082762", "Bau",
"6089278", "Elopura",
"6036142", "Kuala\ Lumpur",
"6038740", "Semenyih",
"605328", "Ipoh",
"6038024", "Kinrara",
"609860", "Chukai",
"6038025", "Kinrara",
"6036277", "Kuala\ Lumpur",
"6084632", "Selalang",
"6089271", "Elopura",
"6047931", "Pokok\ Sena",
"6088852", "Ranau",
"6032246", "Kuala\ Lumpur",
"603796", "Kuala\ Lumpur",
"605201", "Chemor",
"6087442", "Labuan",
"6036461", "Kerling",
"605432", "Trolak",
"609340", "Sungai\ Koyan",
"605691", "Sitiawan",
"6087344", "Keningau",
"6087453", "Labuan",
"604240", "Penang",
"609582", "Gebeng",
"6035198", "Kinrara",
"607678", "Pontian",
"6085750", "Marudi",
"605608", "Teluk\ Intan",
"607663", "Kulai",
"6035191", "Kinrara",
"609590", "Kuantan",
"605792", "Grik",
"609255", "Triang",
"6035121", "Kinrara",
"604401", "Kulim",
"605799", "Lenggong",
"609546", "Gambang",
"6032938", "Kuala\ Lumpur",
"6093140", "Kuala\ Lipis",
"607514", "Tanjung\ Kupang",
"6033342", "Kelang",
"6087874", "Weston",
"6089436", "Kinabatangan",
"608242", "Kuching",
"609753", "Bachok",
"6033129", "Tk\ Panglima\ Garang",
"604332", "Penang",
"6033008", "Banting",
"6088920", "Papar",
"607832", "Penawar",
"609232", "Karak",
"607217", "Johor\ Bahru",
"609817", "Dungun",
"6088360", "Kota\ Kinabalu",
"604226", "Penang",
"6036075", "Kuala\ Kubu\ Baru",
"607896", "Tenggara",
"609240", "Kemayan",
"6038871", "Putrajaya",
"6084239", "Sibu",
"605621", "Telukintan",
"6036046", "Kampong\ Suharto",
"6039085", "Cheras",
"609239", "Telemong",
"604255", "Penang",
"608875", "Kinarut",
"6087503", "Labuan",
"605854", "Sungai\ Nyior",
"6037660", "Kuala\ Lumpur",
"609355", "Raub",
"609520", "Kuantan",
"605722", "Parit\ Buntar",
"6088207", "Kota\ Kinabalu",
"6089619", "Elopura",
"6084614", "Rejang",
"607679", "Pontian",
"6084766", "Kanowit",
"605609", "Teluk\ Intan",
"6033103", "Pulau\ Ketam",
"6039106", "Cheras",
"604238", "Penang",
"6033319", "Kelang",
"6085242", "Limbang",
"605798", "Lenggong",
"6034813", "Kuala\ Lumpur",
"604960", "Kuah",
"6089747", "Tawau",
"607407", "Parit\ Sulong",
"6085331", "Miri",
"607760", "Keluang",
"603401", "Kuala\ Lumpur",
"6038890", "Putrajaya",
"605683", "Sitiawan",
"6088971", "Kota\ Belud",
"6035163", "Kinrara",
"6039050", "Cheras",
"6038526", "Mantin",
"605477", "Kampar",
"6087851", "Kuala\ Penyu",
"6089814", "Tungku",
"6035614", "Kinrara",
"6032333", "Kuala\ Lumpur",
"604499", "Baling",
"605728", "Parit\ Buntar",
"6088653", "Kotamarudu",
"6085472", "Miri",
"6034108", "Kuala\ Lumpur",
"6085784", "Bakun",
"6033140", "Banting",
"6083339", "Bandar\ Sri\ Aman",
"609960", "Kuala\ Krai",
"6039025", "Kuala\ Lumpur",
"6084833", "Matu",
"6085785", "Marudi",
"6082313", "Kuching",
"6038659", "Cheras",
"6085635", "Miri",
"6034101", "Kuala\ Lumpur",
"6089852", "Kunak",
"6035652", "Kinrara",
"6082272", "Kuching",
"6037946", "Kuala\ Lumpur",
"6082831", "Sebangan",
"606637", "Seremban",
"60648", "Kuala\ Pilah",
"607838", "Penawar",
"609238", "Karak",
"609480", "Maran",
"609650", "Batu\ Rakit",
"6089633", "Elopura",
"608248", "Kuching",
"605616", "Bruas",
"604917", "Alor\ Setar",
"608742", "Labuan",
"6036736", "Batu\ Arang",
"609277", "Mentakab",
"606663", "Tekok\ Kemang",
"6085680", "Miri",
"605530", "Tanjung\ Rambutan",
"604377", "Penang",
"607665", "Kulai",
"609505", "Kuantan",
"609732", "Kota\ Bharu",
"6089954", "Balung",
"609631", "Kuala\ Brang",
"605549", "Ipoh",
"607926", "Labis",
"605807", "Taiping",
"6085717", "Bekenu",
"605542", "Ipoh",
"6099200", "Ayer\ Lanas",
"606514", "Jasin",
"6037872", "Kuala\ Lumpur",
"604618", "Penang",
"6083344", "Bandar\ Sri\ Aman",
"6038952", "Cheras",
"6089843", "Kunak",
"605380", "Pusing",
"6033258", "Kelang",
"6082503", "Kuching",
"606977", "Tangkak",
"6089290", "Elopura",
"606317", "Melaka",
"6083589", "Lubukantu",
"605438", "Tapah",
"6088793", "Tuaran",
"607940", "Segamat",
"6036303", "Genting",
"605280", "Ipoh",
"605236", "Ipoh",
"6086298", "Bintulu",
"604740", "Alor\ Setar",
"6082846", "Damai\ Beach",
"608975", "Tawau",
"6082667", "Kota\ Samarahan",
"6089506", "Beluran",
"6086291", "Bintulu",
"605292", "Tanjung\ Rambutan",
"6089565", "Kinabatangan",
"6038084", "Kinrara",
"605322", "Ipoh",
"609755", "Kota\ Bharu",
"6084687", "Sarikei",
"605299", "Tanjung\ Rambutan",
"609353", "Raub",
"6035569", "Kinrara",
"605664", "Sitiawan",
"6034253", "Kuala\ Lumpur",
"6089920", "Tawau",
"6087218", "Beaufort",
"608873", "Kinarut",
"604253", "Penang",
"6039232", "Kuala\ Lumpur",
"6087211", "Beaufort",
"6058300", "Taiping",
"6087726", "Tenom",
"609726", "Kota\ Bharu",
"6037931", "Kuala\ Lumpur",
"6084683", "Sarikei",
"6033134", "Kelang",
"6089868", "Lahad\ Datu",
"6033135", "Kelang",
"6089491", "Beluran",
"6082663", "Kota\ Samarahan",
"604563", "Sungai\ Bakap",
"609981", "Kuala\ Krai",
"605841", "Taiping",
"6089861", "Lahad\ Datu",
"6088797", "Tuaran",
"608991", "Tawau",
"6082681", "Kuching",
"6083549", "Pantu",
"6084224", "Sibu",
"6084661", "Sarikei",
"609470", "Bukit\ Ibam",
"6039546", "Cheras",
"6082688", "Kuching",
"604614", "Penang",
"6034257", "Kuala\ Lumpur",
"6085739", "Batu\ Niah",
"6039223", "Kuala\ Lumpur",
"606433", "Jelai",
"6082731", "Lundu",
"6084647", "Sarikei",
"6082549", "Kuching",
"6036122", "Kuala\ Lumpur",
"608921", "Elopura",
"604461", "Bedong",
"6087437", "Labuan",
"6082886", "Serian",
"6084805", "Kuala\ Igan",
"6084365", "Sibu",
"6038602", "Kinrara",
"6036137", "Kuala\ Lumpur",
"6032601", "Kuala\ Lumpur",
"6084364", "Sibu",
"6084804", "Sarikei",
"6084306", "Sibu",
"607689", "Pontian",
"605434", "Tapah",
"606531", "Jasin",
"6089714", "Tawau",
"6032296", "Kuala\ Lumpur",
"6084719", "Pakan",
"605487", "Cameron\ Highland",
"607682", "Air\ Baloi",
"605673", "Bruas",
"6082507", "Kuching",
"6089715", "Tawau",
"6089666", "Elopura",
"6039388", "Cheras",
"6087862", "Bongawan",
"6087302", "Keningau",
"607781", "Paloh",
"606410", "Tampin",
"6082580", "Kota\ Samarahan",
"604981", "Kangar",
"6036192", "Kuala\ Lumpur",
"6038790", "Mantin",
"6038076", "Kinrara",
"6086300", "Bintulu",
"6086860", "Bintulu",
"605668", "Sitiawan",
"6086256", "Bintulu",
"606295", "Melaka",
"6087404", "Labuan",
"6032262", "Kuala\ Lumpur",
"6087466", "Labuan",
"606550", "Tampin",
"6087405", "Labuan",
"6035892", "Kinrara",
"607512", "Senai",
"607756", "Renggam",
"6033322", "Kelang",
"6036105", "Genting",
"6039771", "Kuala\ Lumpur",
"6039059", "Cheras",
"6088657", "Kotamarudu",
"604956", "Kuah",
"6036104", "Genting",
"6084810", "Julau",
"6032107", "Kuala\ Lumpur",
"6033392", "Kelang",
"609584", "Gebeng",
"607441", "Senggarang",
"6035032", "Kinrara",
"608465", "Sarikei",
"6089622", "Elopura",
"6032180", "Kuala\ Lumpur",
"604925", "Ayer\ Hitam",
"6088903", "Papar",
"605794", "Grik",
"6047450", "Alor\ Setar",
"6085282", "Lawas",
"6084892", "Selangau",
"607506", "Senai",
"6038408", "Cheras",
"609666", "Kuala\ Brang",
"6032392", "Kuala\ Lumpur",
"606458", "Serting",
"607795", "Felda\ Tenggaroh",
"607887", "Kota\ Tinggi",
"606467", "Ayer\ Hitam",
"605852", "Taiping",
"6033180", "Banting",
"6085744", "Beluru",
"6088203", "Kota\ Kinabalu",
"606793", "Mantin",
"608244", "Kuching",
"607300", "Johor\ Bahru",
"6033149", "Banting",
"606987", "Bakri",
"604893", "Penang",
"6088940", "Kota\ Belud",
"609234", "Karak",
"607223", "Johor\ Bahru",
"609823", "Al\ Muktafi\ Billa\ H\ Shah",
"6089518", "Beluran",
"6038328", "Putrajaya",
"6035167", "Kinrara",
"6038961", "Cheras",
"6034020", "Kuala\ Lumpur",
"605859", "Taiping",
"606545", "Durian\ Tunggal",
"6038321", "Putrajaya",
"6089511", "Beluran",
"604537", "Tasek\ Gelugor",
"605370", "Batu\ Gajah",
"6037772", "Kuala\ Lumpur",
"609453", "Bukit\ Ibam",
"6088415", "Kota\ Kinabalu",
"6036042", "Kampong\ Suharto",
"6085660", "Miri",
"605429", "Trolak",
"609477", "Maran",
"609701", "Kota\ Bharu",
"6088414", "Kota\ Kinabalu",
"6082501", "Kuching",
"607928", "Aver\ Panas",
"6089848", "Kunak",
"607562", "Senai",
"609602", "Bandar\ Permaisuri",
"605211", "Ipoh",
"6086381", "Tatau",
"6032730", "Kuala\ Lumpur",
"60536", "Batu\ Gajah",
"6087438", "Labuan",
"609609", "Bandar\ Permaisuri",
"604616", "Penang",
"6036131", "Kuala\ Lumpur",
"6083569", "Engkilili",
"605645", "Bagan\ Datoh",
"604551", "Tasek\ Gelugor",
"6087431", "Labuan",
"6036138", "Kuala\ Lumpur",
"6084641", "Sarikei",
"6089674", "Elopura",
"6034251", "Kuala\ Lumpur",
"6082737", "Lundu",
"6039130", "Kuala\ Lumpur",
"6089675", "Elopura",
"604609", "Penang",
"6036421", "Rawang",
"605436", "Tapah",
"605480", "Tanjung\ Malim",
"6034258", "Kuala\ Lumpur",
"6087213", "Beaufort",
"609551", "Kuantan",
"6033346", "Kelang",
"607697", "Pontian",
"6035540", "Kinrara",
"6082687", "Kuching",
"6037933", "Kuala\ Lumpur",
"603780", "Kuala\ Lumpur",
"604701", "Bedong",
"6089867", "Lahad\ Datu",
"6088791", "Tuaran",
"6092620", "Jerantut",
"604683", "Penang",
"604453", "Kulim",
"6084874", "Mukah",
"6088798", "Tuaran",
"6086293", "Bintulu",
"6084875", "Mukah",
"605311", "Ipoh",
"604292", "Penang",
"607754", "Ayer\ Hitam",
"6037859", "Kuala\ Lumpur",
"6034811", "Kuala\ Lumpur",
"6089517", "Beluran",
"609222", "Bentong",
"6082766", "Bau",
"607822", "Penawar",
"6032242", "Kuala\ Lumpur",
"6088973", "Kota\ Belud",
"6035161", "Kinrara",
"6087853", "Kuala\ Penyu",
"609542", "Sungai\ Lembing",
"604280", "Penang",
"609380", "Jerantut",
"6032331", "Kuala\ Lumpur",
"608532", "Miri",
"6088355", "Kota\ Kinabalu",
"6033099", "Pulau\ Ketam",
"604513", "Padang\ Serai",
"6087475", "Labuan",
"608220", "Kuching",
"605796", "Grik",
"607207", "Johor\ Bahru",
"6087782", "Tambunan",
"605631", "Kampong\ Gajah",
"609549", "Gambang",
"609229", "Bilut\ Valley",
"606354", "Tangga\ Batu",
"6033101", "Pulau\ Ketam",
"605253", "Ipoh",
"609586", "Gebeng",
"605732", "Parit\ Buntar",
"6085765", "Marudi",
"604549", "Tasek\ Gelugor",
"6032108", "Kuala\ Lumpur",
"6035021", "Kinrara",
"6085616", "Miri",
"606980", "Bukit\ Gambir",
"605726", "Parit\ Buntar",
"609329", "Padangtengku",
"604530", "Tasek\ Gelugor",
"603228", "Kuala\ Lumpur",
"6095070", "Kuantan",
"607899", "Tiram",
"607504", "Tanjung\ Kupang",
"6054620", "Kampar",
"605353", "Ipoh",
"609664", "Batu\ Rakit",
"604399", "Penang",
"604229", "Penang",
"6089631", "Elopura",
"609954", "Machang",
"604392", "Penang",
"6033177", "Kelang",
"604222", "Penang",
"609322", "Kuala\ Lipis",
"607892", "Kota\ Tinggi",
"6084831", "Matu",
"605618", "Changkat\ Keruing",
"6082311", "Kuching",
"6033242", "Sekinchan",
"606471", "Simpang\ Durian",
"608246", "Kuching",
"6033169", "Kelang",
"609438", "Perwira\ Jaya",
"6088960", "Tenghilan",
"6034103", "Kuala\ Lumpur",
"60628", "Melaka",
"609280", "Lanchang",
"609236", "Bilut\ Valley",
"607880", "Kota\ Tinggi",
"606460", "Bahau",
"6039769", "Cheras",
"6032785", "Kuala\ Lumpur",
"607767", "Mersing",
"6034262", "Kuala\ Lumpur",
"607400", "Rengit",
"606495", "Simpang\ Durian",
"6082822", "Asajaya",
"604434", "Padang\ Serai",
"6039145", "Kuala\ Lumpur",
"606613", "Kuala\ Klawang",
"6087486", "Labuan",
"604967", "Kuah",
"6088908", "Papar",
"605461", "Tapah",
"6035482", "Kinrara",
"604958", "Kuah",
"6036186", "Kuala\ Lumpur",
"605470", "Kampar",
"6082810", "Asajaya",
"607758", "Ayer\ Hitam",
"604668", "Penang",
"6057180", "Parit\ Buntar",
"608831", "Kota\ Kinabalu",
"60463", "Penang",
"6034107", "Kuala\ Lumpur",
"6036057", "Kuala\ Kubu\ Baru",
"607241", "Johor\ Bahru",
"609841", "Dungun",
"606358", "Tangga\ Batu",
"607521", "Senai",
"604487", "Sungai\ Bakap",
"604673", "Penang",
"606630", "Seremban",
"609668", "Batu\ Rakit",
"607508", "Tanjung\ Kupang",
"6088977", "Kota\ Belud",
"6038963", "Cheras",
"6089748", "Tawau",
"6032776", "Kuala\ Lumpur",
"6089513", "Beluran",
"6033160", "Kelang",
"6038323", "Putrajaya",
"6085310", "Limbang",
"6088969", "Kota\ Belud",
"606425", "Tampin",
"607423", "Rengit",
"6085402", "Miri",
"606642", "Port\ Dickson",
"6032020", "Kuala\ Lumpur",
"6033282", "Kuala\ Selangor",
"605614", "Sitiawan",
"6038988", "Cheras",
"6038011", "Kinrara",
"609958", "Batu\ Gajah",
"6088201", "Kota\ Kinabalu",
"6082683", "Kuching",
"6087230", "Beaufort",
"6085495", "Miri",
"6086232", "Bintulu",
"607924", "Labis",
"606759", "Mantin",
"6037910", "Kuala\ Lumpur",
"609794", "Kok\ Lanas",
"6087217", "Beaufort",
"604852", "Penang",
"6085494", "Bekenu",
"6082294", "Kuching",
"6039221", "Kuala\ Lumpur",
"606970", "Muar",
"606651", "Port\ Dickson",
"605537", "Tanjung\ Rambutan",
"6082225", "Kuching",
"604370", "Penang",
"6084681", "Sarikei",
"6086297", "Bintulu",
"607861", "Tiram",
"6088662", "Kota\ Marudu",
"607710", "Keluang",
"6032386", "Kuala\ Lumpur",
"6082224", "Kuching",
"6084738", "Julau",
"609270", "Mentakab",
"6083496", "Lingga",
"6082661", "Kota\ Samarahan",
"6035115", "Kinrara",
"609835", "Dungun",
"604859", "Penang",
"6084731", "Julau",
"606233", "Melaka",
"6082668", "Kota\ Samarahan",
"605893", "Taiping",
"6089863", "Lahad\ Datu",
"608845", "Kota\ Kinabalu",
"6085450", "Miri",
"6033884", "Kelang",
"609361", "Raub",
"604261", "Penang",
"6033885", "Kelang",
"609370", "Dong",
"6085296", "Lawas",
"6082805", "Simunjan",
"6084384", "Sibu",
"606333", "Melaka",
"604835", "Penang",
"609859", "Chukai",
"6082804", "Simunjan",
"607259", "Johor\ Bahru",
"606509", "Jasin",
"6082306", "Kuching",
"6039139", "Kuala\ Lumpur",
"609852", "Chukai",
"6035886", "Kinrara",
"604794", "Ayer\ Hitam",
"607252", "Johor\ Bahru",
"6034296", "Kuala\ Lumpur",
"604747", "Alor\ Setar",
"604933", "Kuah",
"605287", "Pusing",
"6085601", "Miri",
"6035549", "Kinrara",
"60777", "Keluang",
"6086880", "Bakun",
"607585", "Senai",
"6085718", "Bekenu",
"6089736", "Tawau",
"6032603", "Kuala\ Lumpur",
"6032116", "Kuala\ Lumpur",
"60497", "Kangar",
"6039368", "Kuala\ Lumpur",
"607209", "Johor\ Bahru",
"609547", "Kuantan",
"6037731", "Kuala\ Lumpur",
"6089712", "Tawau",
"604524", "Tasek\ Gelugor",
"6087304", "Keningau",
"6036195", "Kuala\ Lumpur",
"6088363", "Kota\ Kinabalu",
"607283", "Johor\ Bahru",
"6089790", "Merotai",
"6036124", "Kuala\ Lumpur",
"6038999", "Cheras",
"607510", "Senai",
"6036125", "Kuala\ Lumpur",
"6037663", "Kuala\ Lumpur",
"6082382", "Kuching",
"6034217", "Kuala\ Lumpur",
"6084362", "Sibu",
"6084802", "Sibu",
"606552", "Simpang\ Empat",
"6038605", "Kinrara",
"604465", "Bedong",
"6038861", "Putrajaya",
"608287", "Serian",
"6032302", "Kuala\ Lumpur",
"6033197", "Banting",
"6087450", "Labuan",
"6084222", "Sibu",
"606385", "Tangga\ Batu",
"6038752", "Semenyih",
"6036150", "Kuala\ Lumpur",
"6038308", "Putrajaya",
"6084237", "Sibu",
"607302", "Johor\ Bahru",
"606698", "Linggi",
"607533", "Senai",
"6033132", "Tk\ Panglima\ Garang",
"609776", "Bachok",
"6087226", "Beaufort",
"605850", "Sungai\ Nyior",
"607216", "Johor\ Bahru",
"609816", "Dungun",
"604594", "Parit\ Buntar",
"6037886", "Kuala\ Lumpur",
"6036064", "Kuala\ Kubu\ Baru",
"604397", "Penang",
"608823", "Kota\ Kinabalu",
"604985", "Kangar",
"6083430", "Saratok",
"608234", "Kuching",
"604227", "Penang",
"606601", "Seremban",
"609327", "Padang\ Tengku",
"6036065", "Kuala\ Kubu\ Baru",
"605379", "Batu\ Gajah",
"609244", "Triang",
"6087718", "Tenom",
"6088889", "Ranau",
"607897", "Tiram",
"607785", "Keluang",
"6083417", "Betong",
"6088780", "Kota\ Kinabalu",
"6033264", "Kuala\ Selangor",
"605831", "Selama",
"6032036", "Kuala\ Lumpur",
"608981", "Felda\ Sahabat",
"6033265", "Kuala\ Selangor",
"6039019", "Cheras",
"6089209", "Elopura",
"607364", "Johor\ Bahru",
"6084850", "Dalat",
"6088617", "Kudat",
"6063131", "Melaka",
"6082286", "Kuching",
"6089983", "Tawau",
"607445", "Batu\ Pahat",
"6089968", "Lahad\ Datu",
"609479", "Maran",
"605427", "Tapah",
"6083485", "Betong",
"604921", "Kangar",
"6086260", "Bintulu",
"6089247", "Elopura",
"6036241", "Kuala\ Lumpur",
"607721", "Renggam",
"6085742", "Beluru",
"6035035", "Kinrara",
"6036279", "Kuala\ Lumpur",
"6082532", "Kuching",
"607708", "Keluang",
"6086320", "Bintulu",
"605763", "Lenggong",
"604908", "Kangar",
"6085285", "Lawas",
"6084895", "Kuala\ Igan",
"6088538", "Kota\ Kinabalu",
"6084894", "Stapang",
"6085284", "Lawas",
"607791", "Felda\ Tenggaroh",
"607450", "Senggarang",
"607680", "Pontian",
"6035629", "Kinrara",
"604607", "Penang",
"6034285", "Kuala\ Lumpur",
"6087402", "Labuan",
"6032264", "Kuala\ Lumpur",
"6038787", "Mantin",
"6084699", "Bintangor",
"6082597", "Kuching",
"606391", "Tangga\ Batu",
"606221", "Melaka",
"6032265", "Kuala\ Lumpur",
"607699", "Pontian",
"609864", "Kemasik",
"606541", "Durian\ Tunggal",
"6087392", "Keningau",
"6033324", "Kelang",
"6036102", "Genting",
"6086390", "Bintulu",
"6033325", "Kelang",
"6038768", "Semenyih",
"604868", "Penang",
"608631", "Bintulu",
"6086461", "Belaga",
"6037972", "Kuala\ Lumpur",
"605220", "Ipoh",
"6039271", "Kuala\ Lumpur",
"6036263", "Kuala\ Lumpur",
"60733", "Johor\ Bahru",
"6038761", "Semenyih",
"6086468", "Belaga",
"6032858", "Kuala\ Lumpur",
"605540", "Ipoh",
"6035521", "Kinrara",
"607913", "Labis",
"6088740", "Kinarut",
"609215", "Genting",
"606757", "Mantin",
"6036281", "Kuala\ Lumpur",
"6035591", "Kinrara",
"6089287", "Elopura",
"6085474", "Miri",
"605596", "Chemor",
"6033359", "Kelang",
"6087818", "Sipitang",
"6086483", "Pelagus",
"6085627", "Miri",
"6085475", "Miri",
"605389", "Bota",
"609786", "Pasirputih",
"6082275", "Kuching",
"6089855", "Kunak",
"6082593", "Kuching",
"6087811", "Sipitang",
"6039010", "Cheras",
"6038783", "Mantin",
"6085632", "Miri",
"6082274", "Kuching",
"6089854", "Kunak",
"609315", "Kuala\ Lipis",
"605526", "Ipoh",
"6084690", "Bintangor",
"6088703", "Kinarut",
"609975", "Machang",
"6088613", "Kudat",
"6035620", "Kinrara",
"6087765", "Tambunan",
"605289", "Pusing",
"6035612", "Kinrara",
"607930", "Labis",
"605448", "Tanjung\ Malim",
"6037831", "Kuala\ Lumpur",
"6086201", "Bintulu",
"6039207", "Kuala\ Lumpur",
"605246", "Ipoh",
"6049373", "Kangar",
"6084612", "Rejang",
"605290", "Tanjung\ Rambutan",
"6089243", "Elopura",
"605320", "Ipoh",
"6084702", "Bintangor",
"6036270", "Kuala\ Lumpur",
"609868", "Chukai",
"6033851", "Banting",
"605203", "Chemor",
"607268", "Johor\ Bahru",
"60723", "Johor\ Bahru",
"607257", "Johor\ Bharu",
"609873", "Cheneh",
"605282", "Ipoh",
"606275", "Melaka",
"6084351", "Miri",
"6084620", "Sarikei",
"6087319", "Keningau",
"609713", "Kota\ Bharu",
"607661", "Kulai",
"6038990", "Cheras",
"606851", "Seremban",
"604248", "Penang",
"607670", "Kulai",
"607762", "Renggam",
"609635", "Kuala\ Brang",
"605415", "Tapah",
"6087509", "Labuan",
"609598", "Gambang",
"604962", "Kuah",
"605693", "Sitiawan",
"6039235", "Kuala\ Lumpur",
"6038912", "Semenyih",
"6032088", "Kuala\ Lumpur",
"6083413", "Kabong",
"604969", "Kuah",
"6088341", "Kota\ Kinabalu",
"6033123", "Tk\ Panglima\ Garang",
"6038800", "Putrajaya\/Cyberjaya",
"6088348", "Kota\ Kinabalu",
"6089562", "Kinabatangan",
"6032081", "Kuala\ Lumpur",
"604403", "Kulim",
"6089729", "Tawau",
"6038082", "Kinrara",
"6084750", "Kanowit",
"6032726", "Kuala\ Lumpur",
"6038955", "Serdang",
"6037875", "Kuala\ Lumpur",
"6088367", "Kota\ Kinabalu",
"6083342", "Bandar\ Sri\ Aman",
"6037874", "Kuala\ Lumpur",
"6033081", "Kelang",
"609751", "Kota\ Bharu",
"6088880", "Ranau",
"6083439", "Saratok",
"609248", "Bera",
"6087459", "Labuan",
"6094311", "Pekan",
"604598", "Parit\ Buntar",
"6089952", "Balung",
"6032193", "Kuala\ Lumpur",
"609489", "Maran",
"606694", "Rantau",
"605623", "Telukintan",
"606647", "Port\ Dickson",
"607414", "Rengit",
"609659", "Batu\ Rakit",
"6034009", "Kuala\ Lumpur",
"6038741", "Semenyih",
"6083326", "Bandar\ Sri\ Aman",
"6085405", "Miri",
"606491", "Simpang\ Durian",
"6033284", "Kuala\ Selangor",
"6085404", "Miri",
"6032742", "Kuala\ Lumpur",
"6047930", "Pokok\ Sena",
"605883", "Taiping",
"606319", "Melaka",
"609272", "Lanchang",
"6085395", "Miri",
"6082850", "Serian",
"6088519", "Kota\ Kinabalu",
"6036460", "Kerling",
"605465", "Kampar",
"6036243", "Kuala\ Lumpur",
"606979", "Tangkak",
"6083465", "Debak",
"6039201", "Kuala\ Lumpur",
"609784", "Pasirputih",
"609845", "Dungun",
"606972", "Bukit\ Gambir",
"6083464", "Debak",
"604919", "Alor\ Setar",
"6083406", "Maludam",
"607879", "Linggiu",
"609279", "Mentakab",
"606312", "Melaka",
"605547", "Ipoh",
"604850", "Penang",
"605809", "Taiping",
"605594", "Chemor",
"606523", "Jasin",
"608261", "Kuching",
"6089981", "Tawau",
"60450", "Tasek\ Gelugor",
"6084772", "Song",
"609919", "Ayer\ Lanas",
"604906", "Changlon",
"6085628", "Miri",
"607706", "Keluang",
"6037202", "Kuala\ Lumpur",
"604784", "Lubuk\ Merbau",
"6089288", "Elopura",
"605244", "Ipoh",
"6082895", "Serian",
"6085621", "Miri",
"6085206", "Kampung\ Pahlawan",
"6082629", "Kuching",
"6085264", "Sundar",
"603263", "Kuala\ Lumpur",
"607250", "Johor\ Bahru",
"6089281", "Elopura",
"609850", "Chukai",
"6082894", "Serian",
"607595", "Senai",
"6085265", "Sundar",
"6036287", "Kuala\ Lumpur",
"6082824", "Asajaya",
"6082326", "Kuching",
"6034264", "Kuala\ Lumpur",
"6082825", "Asajaya",
"6038767", "Semenyih",
"6082699", "Kuching",
"60475", "Lubuk\ Merbau",
"6087776", "Keningau",
"6034265", "Kuala\ Lumpur",
"6088533", "Kota\ Kinabalu",
"606421", "Bahau",
"6032857", "Kuala\ Lumpur",
"6035484", "Kinrara",
"6038051", "Kinrara",
"604943", "Kangar",
"6085555", "Miri",
"608852", "Kota\ Kinabalu",
"6038779", "Mantin",
"607743", "Keluang",
"609912", "Gua\ Musang",
"6035485", "Kinrara",
"607409", "Parit\ Sulong",
"604778", "Pokok\ Sena",
"6038870", "Putrajaya",
"604818", "Penang",
"6037661", "Kuala\ Lumpur",
"604497", "Bedong",
"6087885", "Kuala\ Penyu",
"605479", "Tapah",
"606965", "Tangkak",
"6087884", "Kuala\ Penyu",
"607677", "Pontian",
"6088368", "Kota\ Kinabalu",
"607483", "Batu\ Pahat",
"6037733", "Kuala\ Lumpur",
"606655", "Port\ Dickson",
"609265", "Jerantut",
"607865", "Tiram",
"603772", "Kuala\ Lumpur",
"6084382", "Sibu",
"6088361", "Kota\ Kinabalu",
"6088928", "Papar",
"6088801", "Tuaran",
"60464", "Penang",
"6087739", "Tenom",
"6038686", "Putrajaya",
"609831", "Paka",
"6088664", "Kota\ Marudu",
"6088606", "Kudat",
"6035120", "Kinrara",
"6093141", "Kuala\ Lipis",
"6088665", "Kotamarudu",
"6032087", "Kuala\ Lumpur",
"609365", "Dong",
"6082222", "Kuching",
"6033217", "Sabak\ Bernam",
"6039074", "Cheras",
"606640", "Port\ Dickson",
"6088347", "Kota\ Kinabalu",
"603337", "Kelang",
"6039075", "Cheras",
"6037719", "Kuala\ Lumpur",
"6037866", "Kuala\ Lumpur",
"609818", "Kerteh",
"607218", "Johor\ Bahru",
"6085492", "Bekenu",
"609778", "Bachok",
"606696", "Linggi",
"603806", "Kinrara",
"608434", "Sibu",
"6088309", "Kota\ Kinabalu",
"6082292", "Kuching",
"604427", "Kulim",
"6085758", "Marudi",
"606632", "Seremban",
"6036084", "Batu\ Arang",
"6089936", "Luasong",
"6083411", "Kabong",
"6088343", "Kota\ Kinabalu",
"60779", "Mersing",
"6033213", "Hutan\ Melintang",
"608542", "Miri",
"6084872", "Mukah",
"6032083", "Kuala\ Lumpur",
"6083418", "Bandar\ Sri\ Aman",
"604289", "Penang",
"604526", "Kulim",
"6087730", "Tenom",
"6033198", "Banting",
"6089672", "Elopura",
"6084231", "Sibu",
"609540", "Kuantan",
"604282", "Penang",
"6084238", "Sibu",
"609220", "Bentong",
"603625", "Kuala\ Lumpur",
"6033191", "Banting",
"604290", "Penang",
"604320", "Penang",
"609539", "Kuantan",
"604555", "Tasek\ Gelugor",
"605641", "Hutan\ Melintang",
"6082750", "Kota\ Samarahan",
"607882", "Kota\ Tinggi",
"606462", "Palong",
"609282", "Lanchang",
"604540", "Tasek\ Gelugor",
"605857", "Taiping",
"606989", "Bakri",
"609555", "Kuantan",
"604539", "Tasek\ Gelugor",
"6032191", "Kuala\ Lumpur",
"607890", "Linggiu",
"604390", "Penang",
"604220", "Penang",
"6036044", "Kampong\ Suharto",
"608236", "Kuching",
"6088412", "Kota\ Kinabalu",
"609246", "Bera",
"604705", "Alor\ Setar",
"6033083", "Kelang",
"6037710", "Kuala\ Lumpur",
"6039086", "Cheras",
"609774", "Kota\ Bharu",
"607889", "Kota\ Tinggi",
"606469", "Kemavan",
"609814", "Paka",
"6036039", "Kuala\ Lumpur",
"604866", "Penang",
"6089557", "Kinabatangan",
"6032782", "Kuala\ Lumpur",
"6086488", "Balingan",
"604623", "Penang",
"603205", "Kuala\ Lumpur",
"609415", "Kuala\ Rompin",
"6089941", "Tawau",
"607560", "Senai",
"605598", "Chemor",
"6036261", "Kuala\ Lumpur",
"607571", "Senai",
"605348", "Batu\ Gajah",
"6088537", "Kota\ Kinabalu",
"605501", "Ipoh",
"6089279", "Elopura",
"6035523", "Kinrara",
"609788", "Kok\ Lanas",
"6082690", "Kuching",
"6049371", "Kangar",
"6089241", "Elopura",
"6032276", "Kuala\ Lumpur",
"6087472", "Labuan",
"605528", "Ipoh",
"604415", "Sungai\ Petani",
"6089967", "Lahad\ Datu",
"6078710", "Tiram",
"6089248", "Elopura",
"6037652", "Kuala\ Lumpur",
"6084353", "Sibu",
"605446", "Tapah",
"605751", "Kuala\ Kangsar",
"607266", "Johor\ Bahru",
"6088701", "Kinarut",
"609866", "Kemasik",
"6038026", "Kinrara",
"6088611", "Kudat",
"60743", "Batu\ Pahat",
"605403", "Tapah",
"607468", "Sri\ Gading",
"6088352", "Kota\ Kinabalu",
"607687", "Pontian",
"6082620", "Kuching",
"606475", "Ayer\ Hitam",
"6088618", "Kudat",
"6032245", "Kuala\ Lumpur",
"609782", "Bachok",
"605536", "Tanjung\ Rambutan",
"6087750", "Tenom",
"606974", "Pagoh",
"6085453", "Miri",
"607920", "Segamat",
"6082581", "Kota\ Samarahan",
"609681", "Kuala\ Brang",
"606517", "Jasin",
"609451", "Bandar\ Tun\ Razak",
"605592", "Lintang",
"6086301", "Bintulu",
"609703", "Kota\ Bharu",
"6085667", "Miri",
"6032687", "Kuala\ Lumpur",
"6085540", "Miri",
"6035561", "Kinrara",
"6032722", "Kuala\ Lumpur",
"6038216", "Kuala\ Lumpur",
"605804", "Taiping",
"605599", "Chemor",
"604914", "Alor\ Setar",
"605349", "Batu\ Gajah",
"6035568", "Kinrara",
"6083570", "Lingga",
"609789", "Pasir\ Putih",
"6032600", "Kuala\ Lumpur",
"6087219", "Beaufort",
"6082844", "Damai\ Beach",
"609205", "Jerantut",
"6087233", "Beaufort",
"605286", "Ipoh",
"605230", "Ipoh",
"6082845", "Damai\ Beach",
"604305", "Penang",
"6084660", "Sarikei",
"605488", "Tanjung\ Malim",
"605529", "Ipoh",
"609553", "Kuantan",
"6089505", "Beluran",
"605667", "Bruas",
"604789", "Alor\ Setar",
"605249", "Ipoh",
"6082730", "Lundu",
"609914", "Gua\ Musang",
"6089566", "Kinabatangan",
"6083563", "Engkilili",
"607469", "Sri\ Gading",
"605313", "Ipoh",
"6033259", "Kelang",
"605242", "Ipoh",
"605522", "Ipoh",
"607990", "Bakri",
"604703", "Bedong",
"604451", "Jeniang",
"604790", "Pokok\ Sena",
"6087725", "Tenom",
"608685", "Bintulu",
"6034021", "Kuala\ Lumpur",
"604511", "Padang\ Serai",
"604449", "Baling",
"6084765", "Kanowit",
"6082472", "Kuching",
"604288", "Penang",
"6039105", "Cheras",
"6089537", "Elopura",
"6083338", "Bandar\ Sri\ Aman",
"6034028", "Kuala\ Lumpur",
"6038320", "Putrajaya",
"6033163", "Kelang",
"6089510", "Beluran",
"607766", "Mersing",
"6032023", "Kuala\ Lumpur",
"604966", "Kuah",
"6033181", "Banting",
"6038525", "Mantin",
"606560", "Simpang\ Empat",
"609538", "Kuantan",
"6035103", "Kinrara",
"605633", "Kampong\ Gajah",
"609413", "Kuala\ Rompin",
"604625", "Penang",
"6089701", "Tawau",
"609966", "Kuala\ Krai",
"6088397", "Kota\ Kinabalu",
"605351", "Batu\ Gajah",
"6089611", "Elopura",
"606988", "Bakri",
"608432", "Sibu",
"6032181", "Kuala\ Lumpur",
"6085636", "Miri",
"604413", "Sungai\ Petani",
"604538", "Tasek\ Gelugor",
"6089708", "Tawau",
"6089618", "Elopura",
"6034161", "Kuala\ Lumpur",
"6047451", "Alor\ Setar",
"606634", "Seremban",
"606473", "Kemavan",
"607475", "Sri\ Gading",
"6088967", "Tenghilan",
"6084818", "Daro",
"6083472", "Betong",
"6088332", "Kota\ Kinabalu",
"606266", "Sungai\ Rambai",
"609486", "Jengka\ Tiga\ Belas",
"609430", "Pekan",
"6039770", "Kuala\ Lumpur",
"6033093", "Pulau\ Ketam",
"605610", "Telukintan",
"6033170", "Kelang",
"6033318", "Kelang",
"6084811", "Mukah",
"6088979", "Kota\ Belud",
"606468", "Ayer\ Hitam",
"609288", "Bukit\ Tinggi",
"604779", "Pokok\ Sena",
"6087465", "Labuan",
"609945", "Ayer\ Lanas",
"607408", "Kampong\ Parit\ Tengah",
"605885", "Taiping",
"6082830", "Sebangan",
"6032202", "Kuala\ Lumpur",
"6087464", "Labuan",
"604819", "Penang",
"605744", "Manong",
"6088403", "Kota\ Kinabalu",
"6087406", "Labuan",
"603778", "Kuala\ Lumpur",
"604950", "Kuah",
"607750", "Lavang\-Lavang",
"606611", "Kuala\ Klawang",
"6088393", "Kota\ Kinabalu",
"605478", "Tapah",
"609587", "Gebeng",
"6088981", "Tenghilan",
"604660", "Penang",
"607523", "Senai",
"609534", "Kuantan",
"606525", "Jasin",
"606350", "Tangga\ Batu",
"6082536", "Kuching",
"6033141", "Sepang",
"608544", "Miri",
"6034100", "Kuala\ Lumpur",
"608224", "Kuching",
"6038329", "Putrajaya",
"6089519", "Beluran",
"6084392", "Sibu",
"6033148", "Banting",
"606638", "Kuala\ Pilah",
"6033167", "Kelang",
"6039058", "Cheras",
"6038891", "Putrajaya",
"6039767", "Cheras",
"609660", "Kuala\ Brang",
"6089533", "Elopura",
"607500", "Tanjung\ Kupang",
"608247", "Sejingkat",
"6033179", "Kelang",
"606984", "Bukit\ Gambir",
"6087850", "Kuala\ Penyu",
"6088970", "Kota\ Belud",
"6039051", "Cheras",
"609772", "Kok\ Lanas",
"609237", "Bilut\ Valley",
"603831", "Putrajaya",
"6039779", "Kuala\ Lumpur",
"6032032", "Kuala\ Lumpur",
"607884", "Kota\ Tinggi",
"606464", "Ladang\ Geddes",
"609284", "Mentakab",
"609819", "Paka",
"607745", "Renggam",
"607219", "Johor\ Bahru",
"604945", "Kangar",
"6085482", "Kampung\ Bakam",
"605727", "Parit\ Buntar",
"609779", "Bachok",
"6036095", "Rawang",
"605376", "Bota",
"6036789", "Genting",
"6082282", "Kuching",
"60695", "Muar",
"6032027", "Kuala\ Lumpur",
"6036094", "Rawang",
"609950", "Machang",
"607421", "Kampung\ Parit\ Tengah",
"606963", "Tangkak",
"604765", "Alor\ Setar",
"6089921", "Balung",
"6083567", "Lingga",
"6037882", "Kuala\ Lumpur",
"6082713", "Semantan",
"6082541", "Sejingkat",
"607965", "Kota\ Tinggi",
"6087222", "Beaufort",
"6039133", "Kuala\ Lumpur",
"6058301", "Taiping",
"606318", "Melaka",
"6087237", "Beaufort",
"606978", "Tangkak",
"6082548", "Kuching",
"6035543", "Kinrara",
"604378", "Penang",
"609476", "Maran",
"609278", "Mentakab",
"605891", "Taiping",
"604918", "Alor\ Setar",
"606231", "Melaka",
"605808", "Taiping",
"607863", "Tiram",
"609263", "Damak",
"6039545", "Kuala\ Lumpur",
"606653", "Port\ Dickson",
"6033224", "Sabak\ Bernam",
"607655", "Kulai",
"6086290", "Bintulu",
"6033225", "Sabak\ Bernam",
"607485", "Batu\ Pahat",
"6039544", "Cheras",
"6085663", "Miri",
"6033250", "Kelang",
"609918", "Gua\ Musang",
"603784", "Kuala\ Lumpur",
"604476", "Kupang",
"606331", "Melaka",
"6089869", "Lahad\ Datu",
"6086506", "Bintulu",
"609363", "Fraser\ Hill",
"605654", "Kampong\ Gajah",
"6084304", "Sibu",
"6084806", "Kapit",
"6082885", "Serian",
"6084366", "Sibu",
"6032224", "Kuala\ Lumpur",
"6084305", "Sibu",
"604263", "Penang",
"6085738", "Batu\ Niah",
"6089664", "Elopura",
"6032733", "Kuala\ Lumpur",
"6032295", "Kuala\ Lumpur",
"6089665", "Elopura",
"609765", "Bachok",
"605437", "Tapah",
"6089716", "Tawau",
"6086254", "Bintulu",
"60545", "Tanjung\ Malim",
"604931", "Changlon",
"6038074", "Kinrara",
"6086360", "Bintulu",
"6082739", "Lundu",
"6086255", "Bintulu",
"607696", "Pontian",
"6083548", "Maludam",
"6038075", "Kinrara",
"6087802", "Sipitang",
"606357", "Tangga\ Batu",
"6038022", "Kinrara",
"607915", "Bukit\ Kepong",
"6036144", "Kuala\ Lumpur",
"6082764", "Bau",
"604667", "Penang",
"6032021", "Kuala\ Lumpur",
"6036145", "Kuala\ Lumpur",
"6082765", "Bau",
"6084634", "Pakan",
"6033183", "Banting",
"604488", "Padang\ Serai",
"6032109", "Kuala\ Lumpur",
"609599", "Gambang",
"6088356", "Kota\ Kinabalu",
"6035101", "Kinrara",
"6032028", "Kuala\ Lumpur",
"606554", "Tampin",
"6088854", "Ranau",
"6088943", "Kota\ Belud",
"6032272", "Kuala\ Lumpur",
"609592", "Kuantan",
"604968", "Kuah",
"6087476", "Labuan",
"605681", "Sitiawan",
"6034023", "Kuala\ Lumpur",
"604522", "Tasek\ Gelugor",
"6033168", "Kelang",
"6039057", "Cheras",
"607768", "Paloh",
"604313", "Penang",
"607757", "Renggam",
"605782", "Kuala\ Kangsar",
"609580", "Gebeng",
"604242", "Penang",
"609536", "Kuantan",
"6038092", "Kinrara",
"606775", "Seremban",
"6082319", "Kuching",
"609213", "Jengka\ Lapan\ Belas",
"6033161", "Kelang",
"6033272", "Batang\ Berjuntai",
"6085615", "Miri",
"606986", "Bakri",
"605720", "Parit\ Buntar",
"6085766", "Marudi",
"6034819", "Kuala\ Lumpur",
"6085614", "Miri",
"604592", "Parit\ Buntar",
"609957", "Batu\ Gajah",
"609242", "Bera",
"604536", "Tasek\ Gelugor",
"6089703", "Tawau",
"609249", "Bera",
"607507", "Tanjung\ Kupang",
"609667", "Kuala\ Brang",
"6089613", "Elopura",
"605205", "Ipoh",
"6033831", "Semenyih",
"609286", "Kuala\ Krau",
"607886", "Penawar",
"607830", "Penggerang",
"606466", "Palong",
"604599", "Parit\ Buntar",
"6033109", "Pulau\ Ketam",
"607304", "Johor\ Bahru",
"6032786", "Kuala\ Lumpur",
"6047453", "Alor\ Setar",
"609529", "Kuantan",
"604330", "Penang",
"6085710", "Bekenu",
"6038723", "Semenyih",
"604869", "Penang",
"6034259", "Kuala\ Lumpur",
"6085737", "Batu\ Niah",
"605413", "Cameron\ Highland",
"6084671", "Sarikei",
"609633", "Bandar\ Permaisuri",
"606661", "Tekok\ Kemang",
"603873", "Semenyih",
"6083547", "Maludam",
"6086423", "Sebauh",
"604351", "Kepala\ Batas",
"6039082", "Cheras",
"6085792", "Mulu",
"605388", "Bota",
"604405", "Padang\ Serai",
"604610", "Penang",
"6088799", "Tuaran",
"6082583", "Kota\ Samarahan",
"607362", "Johor\ Bharu",
"609474", "Kota\ Gelangi",
"6086303", "Bintulu",
"6089871", "Tungku",
"609610", "Bandar\ Permaisuri",
"6089849", "Kunak",
"6084844", "Mukah",
"605486", "Cameron\ Highland",
"6084680", "Sarikei",
"605430", "Besout",
"603749", "Kuala\ Lumpur",
"609405", "Pekan",
"605288", "Pusing",
"604748", "Alor\ Setar",
"6089676", "Elopura",
"609862", "Chukai",
"6084717", "Pakan",
"607262", "Johor\ Bahru",
"605449", "Tanjung\ Malim",
"6087872", "Weston",
"6033344", "Kelang",
"6033345", "Kelang",
"6084730", "Julau",
"6036139", "Kuala\ Lumpur",
"6087231", "Beaufort",
"605625", "Telukintan",
"6039212", "Kuala\ Lumpur",
"609869", "Kemasik",
"6083568", "Engkilili",
"6058307", "Selama",
"6087342", "Keningau",
"6084375", "Sibu",
"6082547", "Kuching",
"609351", "Raub",
"604251", "Penang",
"608871", "Kinarut",
"6087439", "Labuan",
"6089927", "Tawau",
"6085496", "Ladang\ Tiga",
"604561", "Kepala\ Batas",
"6088790", "Tuaran",
"6037862", "Kuala\ Lumpur",
"604570", "Tasek\ Gelugor",
"6083425", "Roban",
"606976", "Bukit\ Gambir",
"606316", "Durian\ Tunggal",
"6098700", "Kemasik",
"604916", "Alor\ Setar",
"6032385", "Kuala\ Lumpur",
"6089923", "Tawau",
"6034250", "Kuala\ Lumpur",
"609276", "Mentakab",
"6082226", "Kuching",
"6085609", "Miri",
"609478", "Maran",
"6036420", "Rawang",
"6035548", "Kinrara",
"604376", "Penang",
"6088602", "Kudat",
"6082711", "Semantan",
"606431", "Gemencheh",
"6039131", "Kuala\ Lumpur",
"6082543", "Kuching",
"6085719", "Bekenu",
"6086371", "Sebauh",
"6036412", "Kuala\ Lumpur",
"60951", "Kuantan",
"604727", "Bedong",
"607927", "Tenang",
"6035541", "Kinrara",
"605806", "Taiping",
"6033385", "Kelang",
"6032731", "Kuala\ Lumpur",
"6032688", "Kuala\ Lumpur",
"6082495", "Kuching",
"6036130", "Kuala\ Lumpur",
"604885", "Penang",
"6082864", "Kota\ Samarahan",
"6082304", "Kota\ Samarahan",
"6035567", "Kinrara",
"608923", "Elopura",
"606383", "Tangga\ Batu",
"604797", "Ayer\ Hitam",
"6085733", "Batu\ Niah",
"6085295", "Lawas",
"604744", "Alor\ Setar",
"6038727", "Semenyih",
"6082865", "Kota\ Samarahan",
"607944", "Segamat",
"6082305", "Kuching",
"6086584", "Tatau",
"6084640", "Sarikei",
"6032681", "Kuala\ Lumpur",
"604463", "Jeniang",
"6085661", "Miri",
"609570", "Kuantan",
"607783", "Keluang",
"6082669", "Kota\ Samarahan",
"6035885", "Kinrara",
"6034295", "Kuala\ Lumpur",
"6085224", "Limbang",
"6086307", "Bintulu",
"609561", "Kuantan",
"605812", "Taiping",
"6092590", "Karak",
"608825", "Kota\ Kinabalu",
"6085225", "Limbang",
"6034294", "Kuala\ Lumpur",
"605237", "Ipoh",
"6083450", "Saratok",
"6084689", "Bintangor",
"605671", "Sitiawan",
"6032114", "Kuala\ Lumpur",
"6085668", "Miri",
"606533", "Jasin",
"6032115", "Kuala\ Lumpur",
"6089735", "Semporna",
"6087772", "Tambunan",
"6087484", "Labuan",
"607208", "Johor\ Bahru",
"6088968", "Kota\ Belud",
"6084830", "Matu",
"6082322", "Kuching",
"6087485", "Labuan",
"6033143", "Sepang",
"6088961", "Kota\ Belud",
"6033317", "Kelang",
"6036185", "Kuala\ Lumpur",
"605476", "Kampar",
"6089749", "Tawau",
"6036184", "Kuala\ Lumpur",
"6092410", "Telemong",
"6035020", "Kinrara",
"6082402", "Kuching",
"60445", "Bedong",
"6088401", "Kota\ Kinabalu",
"6038989", "Cheras",
"607764", "Felda\ Tenggaroh",
"6095071", "Kuantan",
"6039174", "Kuala\ Lumpur",
"6089617", "Elopura",
"6088408", "Kota\ Kinabalu",
"6085202", "Limbang",
"6089630", "Elopura",
"6039175", "Kuala\ Lumpur",
"607443", "Rengit",
"604964", "Kuah",
"6088695", "Kudat",
"606791", "Seremban",
"6033187", "Banting",
"6032775", "Kuala\ Lumpur",
"6088909", "Papar",
"6082552", "Kuching",
"605765", "Lenggong",
"609437", "Perwira\ Jaya",
"607412", "Batu\ Pahat",
"605617", "Telukintan",
"6038657", "Cheras",
"6085462", "Miri",
"6034810", "Kuala\ Lumpur",
"606699", "Linggi",
"6034032", "Kuala\ Lumpur",
"6088469", "Kota\ Kinabalu",
"6038893", "Putrajaya",
"6083322", "Bandar\ Sri\ Aman",
"6089531", "Elopura",
"6034027", "Kuala\ Lumpur",
"604891", "Penang",
"6083310", "Bandar\ Sri\ Aman",
"608565", "Miri",
"6083337", "Bandar\ Sri\ Aman",
"6089538", "Elopura",
"607221", "Johor\ Bahru",
"6032330", "Kuala\ Lumpur",
"609821", "Sri\ Gading",
"6084879", "Dalat",
"6087436", "Labuan",
"604826", "Penang",
"6084380", "Sibu",
"60794", "Gemas",
"6084646", "Sarikei",
"607296", "Johor\ Bahru",
"6083220", "Bandar\ Sri\ Aman",
"607753", "Renggam",
"608842", "Kota\ Kinabalu",
"6085455", "Miri",
"6084307", "Sibu",
"6085454", "Miri",
"609832", "Merchang",
"6036136", "Kuala\ Lumpur",
"6045960", "Parit\ Buntar",
"604953", "Kuah",
"609217", "Mentakab",
"6082887", "Serian",
"606353", "Tangga\ Batu",
"6089667", "Elopura",
"609839", "Merchang",
"605254", "Ipoh",
"6082506", "Kuching",
"608849", "Kota\ Kinabalu",
"607520", "Senai",
"6032297", "Kuala\ Lumpur",
"6086257", "Bintulu",
"607240", "Johor\ Bahru",
"6035879", "Kinrara",
"609840", "Dungun",
"6038872", "Putrajaya",
"606726", "Seremban",
"606253", "Melaka",
"6035192", "Kinrara",
"6083564", "Engkilili",
"605354", "Ipoh",
"606277", "Melaka",
"609663", "Batu\ Rakit",
"6082290", "Kuching",
"607590", "Senai",
"609855", "Chukai",
"6033297", "Kelang",
"607255", "Johor\ Bahru",
"607340", "Johor\ Bahru",
"6088796", "Tuaran",
"606631", "Seremban",
"6087234", "Beaufort",
"6082843", "Damai\ Beach",
"6035110", "Kinrara",
"607428", "Senggarang",
"6033341", "Kelang",
"607226", "Johor\ Bahru",
"609826", "Kerteh",
"6084848", "Kuala\ Igan",
"60974", "Kota\ Bharu",
"604217", "Penang",
"6082220", "Kuching",
"609977", "Machang",
"6038008", "Putrajaya",
"6034256", "Kuala\ Lumpur",
"6035122", "Kinrara",
"6039547", "Cheras",
"6033348", "Kelang",
"6039765", "Cheras",
"606971", "Bukit\ Kepong",
"6039103", "Cheras",
"6086282", "Bintulu",
"606960", "Bukit\ Gambir",
"606311", "Melaka",
"6033165", "Kelang",
"604566", "Tasekgelugor",
"609454", "Bukit\ Ibam",
"609684", "Bukit\ Bading",
"6036032", "Rawang",
"606499", "Batu\ Kikir",
"6038523", "Kinrara",
"6033050", "Kelang",
"6035166", "Kinrara",
"6084788", "Kapit",
"6088851", "Ranau",
"6036462", "Kerling",
"6087441", "Labuan",
"6032336", "Kuala\ Lumpur",
"605801", "Taiping",
"605417", "Tapah",
"6089272", "Elopura",
"6036148", "Kuala\ Lumpur",
"6084631", "Selalang",
"609637", "Kuala\ Brang",
"606492", "Kuala\ Klawang",
"609271", "Mentakab",
"60626", "Melaka",
"605898", "Semanggol",
"6088858", "Ranau",
"604911", "Alor\ Setar",
"6034816", "Kuala\ Lumpur",
"6032024", "Kuala\ Lumpur",
"6036141", "Kuala\ Lumpur",
"6085769", "Marudi",
"6082761", "Bau",
"607860", "Senai",
"606480", "Ayer\ Hitam",
"607711", "Keluang",
"606436", "Johol",
"609260", "Jerantut",
"6037890", "Kuala\ Lumpur",
"606650", "Port\ Dickson",
"6032025", "Kuala\ Lumpur",
"604371", "Penang",
"606645", "Port\ Dickson",
"6036179", "Kuala\ Lumpur",
"606422", "Tampin",
"6087467", "Labuan",
"6088656", "Kotamarudu",
"604260", "Penang",
"60448", "Kulim",
"6039140", "Kuala\ Lumpur",
"6087479", "Labuan",
"60465", "Penang",
"6085618", "Miri",
"605676", "Changkat\ Keruing",
"607738", "Lavang\-Lavang",
"6032106", "Kuala\ Lumpur",
"604938", "Kangar",
"606429", "Bahau",
"6037200", "Kuala\ Lumpur",
"6087832", "Menumbok",
"6085611", "Miri",
"604684", "Penang",
"6082709", "Kota\ Samarahan",
"609566", "Kuantan",
"604454", "Sungai\ Petani",
"6084770", "Song",
"6088512", "Kota\ Kinabalu",
"609256", "Triang",
"6088394", "Kota\ Kinabalu",
"605210", "Ipoh",
"606666", "Sepang",
"6088395", "Kota\ Kinabalu",
"605583", "Chemor",
"609688", "Kuala\ Brang",
"604356", "Tasek\ Gelugor",
"609458", "Bukit\ Ibam",
"6039171", "Kuala\ Lumpur",
"6037947", "Kuala\ Lumpur",
"6088404", "Kota\ Kinabalu",
"609700", "Kota\ Bharu",
"609467", "Maran",
"6085760", "Marudi",
"6087463", "Labuan",
"6088405", "Kota\ Kinabalu",
"6037261", "Kuala\ Lumpur",
"607923", "Bukit\ Kepong",
"603620", "Kuala\ Lumpur",
"609225", "Bentong",
"6036181", "Kuala\ Lumpur",
"606234", "Melaka",
"6088906", "Papar",
"605894", "Taiping",
"605847", "Taiping",
"6032780", "Kuala\ Lumpur",
"6036188", "Kuala\ Lumpur",
"60537", "Pusing",
"6087481", "Labuan",
"6039514", "Kuala\ Lumpur",
"6087823", "Sipitang",
"607895", "Air\ Tawar",
"607787", "Keluang",
"609550", "Kuantan",
"6082622", "Kuching",
"605752", "Kuala\ Kangsar",
"606334", "Melaka",
"60655", "Durian\ Tunggal",
"6088206", "Kota\ Kinabalu",
"6088350", "Kota\ Kinabalu",
"604987", "Kangar",
"605481", "Tanjung\ Malim",
"6089534", "Elopura",
"6033630", "Banting",
"604545", "Sungai\ Bakap",
"6082700", "Lundu",
"606537", "Jasin",
"6089535", "Elopura",
"609356", "Raub",
"605310", "Ipoh",
"6036093", "Rawang",
"604688", "Penang",
"6032771", "Kuala\ Lumpur",
"6089746", "Tawau",
"6037650", "Kuala\ Lumpur",
"608876", "Kinarut",
"607900", "Tenggara",
"606387", "Kuala\ Sungai\ Baru",
"607734", "Ayer\ Hitam",
"604700", "Alor\ Setar",
"6038527", "Mantin",
"605759", "Kuala\ Kangsar",
"6077120", "Keluang",
"604467", "Jeniang",
"6035544", "Kinrara",
"6032388", "Kuala\ Lumpur",
"604281", "Penang",
"6035545", "Kinrara",
"6084736", "Julau",
"60447", "Baling",
"604518", "Tasekgelugor",
"6039134", "Kuala\ Lumpur",
"6032381", "Kuala\ Lumpur",
"605642", "Hutan\ Melintang",
"6034801", "Kuala\ Lumpur",
"6089670", "Elopura",
"6082715", "Semantan",
"6083308", "Bandar\ Sri\ Aman",
"606614", "Kuala\ Klawang",
"607447", "Batu\ Pahat",
"6082666", "Kota\ Samarahan",
"605649", "Hutan\ Melintang",
"609531", "Kuantan",
"6039543", "Cheras",
"6039226", "Kuala\ Lumpur",
"608541", "Miri",
"6084870", "Mukah",
"6082809", "Simunjan",
"609410", "Pekan",
"608221", "Kuching",
"6087727", "Tenom",
"60769", "Air\ Baloi",
"6035888", "Kuala\ Lumpur",
"605367", "Pusing",
"6037712", "Kuala\ Lumpur",
"6032223", "Kuala\ Lumpur",
"6036737", "Kuala\ Kubu\ Baru",
"6084303", "Sibu",
"6034291", "Kuala\ Lumpur",
"603300", "Kelang",
"6085665", "Miri",
"606981", "Bakri",
"6085221", "Limbang",
"604410", "Kulim",
"6033363", "Kelang",
"605358", "Batu\ Gajah",
"6085664", "Miri",
"6032118", "Kuala\ Lumpur",
"6093261", "Padang\ Tengku",
"6082299", "Kuching",
"603795", "Kuala\ Lumpur",
"609281", "Kuala\ Krau",
"607881", "Air\ Tawar",
"6088302", "Kota\ Kinabalu",
"606461", "Ladanggeddes",
"6086581", "Tatau",
"6032685", "Kuala\ Lumpur",
"6038073", "Kinrara",
"6082301", "Kuching",
"6086253", "Bintulu",
"6085298", "Lawas",
"6033381", "Kelang",
"607424", "Rengit",
"6082868", "Kota\ Samarahan",
"6082308", "Kuching",
"6082491", "Kuching",
"6082752", "Kuching",
"6089663", "Elopura",
"605613", "Teluk\ Intan",
"6038521", "Sepang",
"6085740", "Mu",
"6088853", "Ranau",
"6088976", "Kota\ Belud",
"604557", "Tasek\ Gelugor",
"6033185", "Banting",
"604573", "Tasek\ Gelugor",
"6087443", "Labuan",
"605840", "Taiping",
"609936", "Kuala\ Balah",
"609980", "Kuala\ Krai",
"6084633", "Selalang",
"6033184", "Banting",
"609254", "Triang",
"608989", "Lahad\ Datu",
"604922", "Kangar",
"605839", "Selama",
"606664", "Tekok\ Kemang",
"6036143", "Kuala\ Lumpur",
"607722", "Renggam",
"6082763", "Bau",
"604568", "Sungai\ Bakap",
"603928", "Kuala\ Lumpur",
"6037480", "Kuala\ Lumpur",
"6039101", "Cheras",
"6038655", "Cheras",
"606292", "Melaka",
"604929", "Alor\ Setar",
"609471", "Sungai\ Tekam",
"6034024", "Kuala\ Lumpur",
"606438", "Simpang\ Empat",
"6082781", "Gedong",
"609460", "Maran",
"609707", "Kota\ Bharu",
"60438", "Penang",
"6088782", "Tuaran",
"607515", "Tanjung\ Kupang",
"6034025", "Kuala\ Lumpur",
"6034050", "Kuala\ Lumpur",
"6036100", "Genting",
"606222", "Melaka",
"6084815", "Rejang",
"606542", "Durian\ Tunggal",
"604460", "Bedong",
"6085613", "Miri",
"606336", "Melaka",
"607907", "Labis",
"6036187", "Kuala\ Lumpur",
"604471", "Sungai\ Bakap",
"6047454", "Alor\ Setar",
"6034106", "Kuala\ Lumpur",
"604980", "Kangar",
"604936", "Kangar",
"6047455", "Alor\ Setar",
"6087312", "Keningau",
"605678", "Bruas",
"607780", "Kahang",
"606411", "Simpang\ Empat",
"609573", "Kuantan",
"6037941", "Kuala\ Lumpur",
"606549", "Durian\ Tunggal",
"609557", "Kuantan",
"6038690", "Semenyih",
"609568", "Kuantan",
"606229", "Melaka",
"6089705", "Tawau",
"6089614", "Elopura",
"6082530", "Kuching",
"6037948", "Kuala\ Lumpur",
"605855", "Taiping",
"6086322", "Bintulu",
"606530", "Jasin",
"6089704", "Tawau",
"6089615", "Elopura",
"6082770", "Bau",
"604254", "Penang",
"607298", "Johor\ Bahru",
"60565", "Langkap",
"604828", "Penang",
"6087502", "Labuan",
"6086424", "Sebauh",
"6082380", "Kuching",
"6082867", "Kota\ Samarahan",
"6038725", "Semenyih",
"6033256", "Kelang",
"6033860", "Sekinchan",
"6089792", "Semporna",
"6035565", "Kinrara",
"6038724", "Semenyih",
"606551", "Simpang\ Empat",
"605637", "Sabak\ Bernam",
"609801", "Paka",
"6085297", "Lawas",
"603207", "Kuala\ Lumpur",
"609417", "Nenasi",
"6089722", "Tawau",
"605684", "Sitiawan",
"6089569", "Kinabatangan",
"6036738", "Kuala\ Kubu\ Baru",
"6034297", "Kuala\ Lumpur",
"6035887", "Kinrara",
"607440", "Batu\ Pahat",
"6032117", "Kuala\ Lumpur",
"606728", "Seremban",
"6087216", "Beaufort",
"6083585", "Lubukantu",
"606477", "Palong",
"607685", "Pontian",
"6033343", "Kelang",
"6077690", "Paloh",
"606701", "Linggi",
"6083584", "Lubukantu",
"606798", "Mantin",
"6083427", "Roban",
"603892", "Semenyih",
"6087728", "Tenom",
"6089959", "Lahad\ Datu",
"609828", "Paka",
"607228", "Johor\ Bahru",
"6032387", "Kuala\ Lumpur",
"607426", "Parit\ Betak",
"6086296", "Bintulu",
"604898", "Penang",
"6038750", "Semenyih",
"6087452", "Labuan",
"604417", "Mahang",
"6084220", "Sibu",
"6032300", "Kuala\ Lumpur",
"607301", "Johor\ Bahru",
"6038080", "Kinrara",
"607527", "Kangkar\ Pulai",
"606910", "Muar",
"6065350", "Jasin",
"6089560", "Kinabatangan",
"605545", "Ipoh",
"605225", "Ipoh",
"6035131", "Kinrara",
"6082686", "Kuching",
"605395", "Besout",
"6039548", "Cheras",
"604824", "Penang",
"609509", "Kuantan",
"606852", "Melaka",
"6089805", "Lahad\ Datu",
"6082389", "Kuching",
"607662", "Kulai",
"605467", "Kampar",
"604759", "Alor\ Setar",
"609735", "Kota\ Bharu",
"6086951", "Bintulu",
"6084809", "Sibu",
"605793", "Grik",
"6089866", "Lahad\ Datu",
"6082544", "Kuching",
"6033291", "Kelang",
"605256", "Ipoh",
"6032383", "Kuala\ Lumpur",
"608421", "Sibu",
"6089925", "Tawau",
"607810", "Paloh",
"607761", "Ayer\ Hitam",
"604310", "Penang",
"604961", "Kuah",
"6082545", "Kuching",
"609583", "Gebeng",
"605688", "Sitiawan",
"6038992", "Cheras",
"6085735", "Batu\ Niah",
"6032298", "Kuala\ Lumpur",
"6038071", "Kinrara",
"6089950", "Balung",
"6078011", "Mersing",
"609759", "Pasirputih",
"6089668", "Elopura",
"6086251", "Bintulu",
"6082863", "Kota\ Samarahan",
"6082303", "Kuching",
"606794", "Mantin",
"605723", "Parit\ Buntar",
"605356", "Ipoh",
"609310", "Kuala\ Lipis",
"609961", "Kuala\ Krai",
"6084229", "Sibu",
"604210", "Penang",
"6083545", "Pantu",
"6082493", "Kuching",
"609970", "Machang",
"607597", "Senai",
"60787", "Kota\ Tinggi",
"609651", "Batu\ Rakit",
"609481", "Kota\ Gelangi",
"6032113", "Kuala\ Lumpur",
"6089295", "Elopura",
"6084301", "Sibu",
"606270", "Melaka",
"608243", "Sejingkat",
"6083340", "Bandar\ Sri\ Aman",
"6034293", "Kuala\ Lumpur",
"609752", "Pasir\ Putih",
"604333", "Penang",
"6082888", "Serian",
"609233", "Genting",
"6038210", "Semenyih",
"6085223", "Limbang",
"6084308", "Sibu",
"609824", "Kerteh",
"6033361", "Kelang",
"607224", "Johor\ Bahru",
"6084752", "Kanowit",
"605410", "Tapah",
"609456", "Chini",
"604564", "Kepala\ Batas",
"604358", "Tasek\ Gelugor",
"609686", "Kuala\ Brang",
"609630", "Kuala\ Brang",
"6089202", "Elopura",
"6085630", "Miri",
"6039012", "Cheras",
"6087828", "Kuala\ Penyu",
"6085617", "Miri",
"607867", "Tiram",
"609267", "Jerantut",
"6087483", "Labuan",
"6033145", "Banting",
"604367", "Serdang",
"607675", "Pontian",
"6087821", "Sipitang",
"606967", "Bakri",
"6087468", "Labuan",
"6088742", "Kinarut",
"6039776", "Kuala\ Lumpur",
"604613", "Penang",
"6082741", "Lundu",
"606434", "Jelai",
"6033176", "Kelang",
"6039173", "Kuala\ Lumpur",
"605381", "Batugajah",
"6087461", "Labuan",
"606958", "Bukit\ Gambir",
"6038699", "Semenyih",
"6036091", "Rawang",
"6032773", "Kuala\ Lumpur",
"605433", "Tapah",
"605281", "Ipoh",
"604741", "Alor\ Setar",
"6082539", "Kuching",
"6085771", "Long\ Lama",
"6036272", "Kuala\ Lumpur",
"6084610", "Rejang",
"6089462", "Elopura",
"6038966", "Cheras",
"6039055", "Cheras",
"604258", "Penang",
"6089902", "Merotai",
"6036028", "Batu\ Arang",
"604686", "Penang",
"6039054", "Cheras",
"609358", "Raub",
"6087201", "Beaufort",
"6087409", "Labuan",
"609367", "Dong",
"6038894", "Putrajaya",
"605674", "Bruas",
"6035622", "Kinrara",
"6052321", "Ipoh",
"6087208", "Beaufort",
"604267", "Penang",
"6048640", "Penang",
"6036021", "Batuarang",
"6084692", "Bintangor",
"6036193", "Kuala\ Lumpur",
"6088364", "Kota\ Kinabalu",
"6038957", "Cheras",
"606294", "Melaka",
"6087303", "Keningau",
"6087863", "Bongawan",
"6037877", "Kuala\ Lumpur",
"605834", "Taiping",
"605543", "Ipoh",
"607361", "Johor\ Bharu",
"607910", "Tenang",
"606527", "Jasin",
"604710", "Alor\ Setar",
"6085790", "Miri",
"609585", "Gebeng",
"6087881", "Kuala\ Penyu",
"605506", "Ipoh",
"6085720", "Batu\ Niah",
"6039080", "Cheras",
"6036419", "Kuala\ Lumpur",
"6037665", "Kuala\ Lumpur",
"6037664", "Kuala\ Lumpur",
"606770", "Seremban",
"609252", "Triang",
"6087888", "Membakut",
"604924", "Changlon",
"605795", "Grik",
"606662", "Tekok\ Kemang",
"6036123", "Kuala\ Lumpur",
"6036211", "Kuala\ Lumpur",
"6088609", "Kudat",
"609947", "Ayer\ Lanas",
"6039222", "Kuala\ Lumpur",
"6036081", "Batu\ Arang",
"6038689", "Putrajaya",
"605441", "Trolak",
"6087736", "Tenom",
"6084797", "Kapit",
"60477", "Alor\ Setar",
"609352", "Sungai\ Koyan",
"6086231", "Bintulu",
"605725", "Parit\ Buntar",
"6087340", "Keningau",
"604947", "Kangar",
"607747", "Ayer\ Hitam",
"607794", "Endau",
"608872", "Kinarut",
"604252", "Penang",
"6085755", "Marudi",
"6036433", "Genting",
"604259", "Penang",
"609235", "Genting",
"605293", "Tanjung\ Rambutan",
"6088668", "Kota\ Marudu",
"606224", "Melaka",
"608245", "Kuching",
"605323", "Ipoh",
"6036063", "Kuala\ Kubu\ Baru",
"6082662", "Kota\ Samarahan",
"606544", "Durian\ Tunggal",
"607261", "Johor\ Bahru",
"609710", "Kota\ Bharu",
"605756", "Kuala\ Kangsar",
"6084682", "Sarikei",
"6088661", "Kotamarudu",
"6039078", "Cheras",
"6083468", "Sebuyau",
"6089984", "Tawau",
"605682", "Changkat\ Keruing",
"607657", "Kulai",
"6037773", "Kuala\ Lumpur",
"609591", "Kuantan",
"6038776", "Mantin",
"6038090", "Kinrara",
"6089985", "Tawau",
"604521", "Tasek\ Gelugor",
"604241", "Penang",
"605690", "Sitiawan",
"6039205", "Kuala\ Lumpur",
"6083461", "Debak",
"609508", "Teruntum",
"607668", "Kulai",
"6082329", "Serian",
"6032270", "Kuala\ Lumpur",
"6033288", "Kuala\ Selangor",
"604758", "Alor\ Setar",
"605646", "Bagan\ Datoh",
"6032011", "Kuala\ Lumpur",
"6082626", "Kuching",
"6085401", "Miri",
"6032393", "Kuala\ Lumpur",
"6033281", "Kuala\ Selangor",
"6066920", "Linggi",
"6038744", "Semenyih",
"605689", "Sitiawan",
"609423", "Chini",
"604615", "Penang",
"604400", "Padang\ Serai",
"6038020", "Kinrara",
"608978", "Semporna",
"6088902", "Papar",
"6085283", "Lawas",
"6084893", "Selangau",
"6082828", "Asajaya",
"6035481", "Kinrara",
"609758", "Pasir\ Putih",
"6089623", "Elopura",
"609767", "Bachok",
"6033393", "Kelang",
"6035033", "Kinrara",
"6082821", "Asajaya",
"609521", "Kuantan",
"6088516", "Kota\ Kinabalu",
"6033323", "Kelang",
"6089285", "Elopura",
"6082898", "Serian",
"605620", "Telukintan",
"603894", "Cheras",
"6032263", "Kuala\ Lumpur",
"6033270", "Batang\ Berjuntai",
"6085268", "Sundar",
"6084823", "Daro",
"6085200", "Limbang",
"6089632", "Elopura",
"607299", "Johor\ Bahru",
"6037611", "Kuala\ Lumpur",
"604829", "Penang",
"60478", "Pokok\ Sena",
"6084897", "Stapang",
"6085287", "Lawas",
"6035022", "Kinrara",
"6089853", "Kunak",
"6035653", "Kinrara",
"607513", "Tanjung\ Kupang",
"6039521", "Kuala\ Lumpur",
"6082273", "Kuching",
"6032267", "Kuala\ Lumpur",
"6082658", "Kuching",
"6034287", "Kuala\ Lumpur",
"6033241", "Sekinchan",
"6082312", "Kuching",
"6086484", "Balingan",
"6082320", "Semantan",
"6082651", "Kuching",
"606729", "Seremban",
"6084832", "Matu",
"6032279", "Kuala\ Lumpur",
"6086485", "Belaga",
"6088652", "Kotamarudu",
"6087770", "Tambunan",
"6032332", "Kuala\ Lumpur",
"6082260", "Kuching",
"6089276", "Elopura",
"6034820", "Kuala\ Lumpur",
"606907", "Muar",
"6038331", "Putrajaya",
"6035162", "Kinrara",
"607380", "Johor\ Bahru",
"6032241", "Kuala\ Lumpur",
"6083320", "Bandar\ Sri\ Aman",
"604892", "Penang",
"609754", "Bachok",
"6033279", "Batang\ Berjuntai",
"606799", "Mantin",
"6088705", "Kota\ Kinabalu",
"6088614", "Kudat",
"609822", "Al\ Muktafi\ Billa\ H\ Shah",
"607222", "Johor\ Bahru",
"6085460", "Miri",
"6088615", "Kudat",
"6088704", "Kota\ Kinabalu",
"6034812", "Kuala\ Lumpur",
"609829", "Paka",
"6082550", "Kuching",
"605853", "Sungai\ Nyior",
"604899", "Penang",
"605717", "Parit\ Buntar",
"6086286", "Bintulu",
"607586", "Senai",
"607530", "Senai",
"606792", "Sepang",
"605665", "Sitiawan",
"6033102", "Pulau\ Ketam",
"604307", "Penang",
"609575", "Kuantan",
"6089244", "Elopura",
"606736", "Mantin",
"606691", "Linggi",
"6036036", "Batuarang",
"604627", "Penang",
"608634", "Bintulu",
"606432", "Gemencheh",
"605838", "Selama",
"6084235", "Sibu",
"6035126", "Kinrara",
"608988", "Lahad\ Datu",
"6084234", "Sibu",
"604569", "Kepala\ Batas",
"606496", "Kuala\ Klawang",
"6034252", "Kuala\ Lumpur",
"604562", "Kepala\ Batas",
"6082798", "Tebedu",
"6087848", "Sipitang",
"6038588", "Putrajaya",
"604928", "Changlon",
"6082791", "Tebedu",
"606439", "Simpang\ Empat",
"6033124", "Tk\ Panglima\ Garang",
"6088451", "Kinarut",
"6088792", "Tuaran",
"6083414", "Kabong",
"60444", "Sungai\ Petani",
"605771", "Grik",
"609928", "Gua\ Musang",
"6036048", "Kerling",
"605811", "Taiping",
"6082502", "Kuching",
"6038953", "Cheras",
"6037873", "Kuala\ Lumpur",
"604901", "Changlon",
"607477", "Sri\ Gading",
"607683", "Pontian",
"605672", "Sitiawan",
"6033006", "Sabak\ Bernam",
"6036127", "Kuala\ Lumpur",
"6084642", "Sarikei",
"6039411", "Cheras",
"605679", "Sitiawan",
"606398", "Tangga\ Batu",
"606228", "Melaka",
"606426", "Ayer\ Hitam",
"6089965", "Lahad\ Datu",
"607925", "Labis",
"6086351", "Bintulu",
"605733", "Parit\ Buntar",
"6085403", "Miri",
"6032391", "Kuala\ Lumpur",
"606856", "Mantin",
"6033283", "Kuala\ Selangor",
"607666", "Kulai",
"60577", "Kuala\ Kangsar",
"6084696", "Bintangor",
"6034270", "Kuala\ Lumpur",
"6089512", "Beluran",
"6038322", "Putrajaya",
"609543", "Sungai\ Lembing",
"6037771", "Kuala\ Lumpur",
"605648", "Hutan\ Melintang",
"604512", "Penang",
"6085270", "Lawas",
"6033268", "Kuala\ Selangor",
"604293", "Penang",
"608844", "Kota\ Kinabalu",
"609300", "Mentakab",
"604323", "Penang",
"6083463", "Debak",
"6089466", "Elopura",
"6038962", "Cheras",
"6032247", "Kuala\ Lumpur",
"6089520", "Telupid",
"607823", "Penawar",
"609223", "Bentong",
"609834", "Bukit\ Besi",
"604200", "Penang",
"6036276", "Kuala\ Lumpur",
"605710", "Parit\ Buntar",
"6034288", "Kuala\ Lumpur",
"6085263", "Sundar",
"6033321", "Kelang",
"6088746", "Kinarut",
"6084828", "Daro",
"6039772", "Kuala\ Lumpur",
"608976", "Tawau",
"6032268", "Kuala\ Lumpur",
"608827", "Kota\ Kinabalu",
"6088330", "Kota\ Kinabalu",
"6083470", "Betong",
"604223", "Penang",
"6035891", "Kinrara",
"60755", "Senai",
"609323", "Kuala\ Lipis",
"6032261", "Kuala\ Lumpur",
"605359", "Batu\ Gajah",
"607893", "Kota\ Tinggi",
"6084821", "Daro",
"607387", "Johor\ Bahru",
"6084891", "Selangau",
"609725", "Kota\ Bharu",
"6057970", "Grik",
"6035483", "Kinrara",
"6089206", "Elopura",
"6088534", "Kota\ Kinabalu",
"6085288", "Lawas",
"6084898", "Sibu",
"6035031", "Kinrara",
"6032039", "Kuala\ Lumpur",
"608431", "Sibu",
"6088535", "Kota\ Kinabalu",
"6087883", "Kuala\ Penyu",
"6088886", "Ranau",
"6032602", "Kuala\ Lumpur",
"6038601", "Kinrara",
"6036128", "Kuala\ Lumpur",
"605423", "Tapah",
"606494", "Kuala\ Klawang",
"6032720", "Kuala\ Lumpur",
"6087229", "Beaufort",
"6037118", "Kuala\ Lumpur",
"6036047", "Kerling",
"6036191", "Kuala\ Lumpur",
"609781", "Machang",
"604620", "Penang",
"60741", "Parit\ Sulong",
"6087301", "Keningau",
"6087861", "Bongawan",
"6037735", "Kuala\ Lumpur",
"605591", "Lintang",
"609452", "Bukit\ Ibam",
"609682", "Kuala\ Brang",
"607578", "Senai",
"6037734", "Kuala\ Lumpur",
"608264", "Kuching",
"6089862", "Lahad\ Datu",
"605241", "Ipoh",
"6036061", "Kuala\ Kubu\ Baru",
"6082797", "Tebedu",
"6038996", "Cheras",
"6089492", "Beluran",
"6088663", "Kotamarudu",
"605767", "Lenggong",
"606424", "Batu\ Kikir",
"6084662", "Sarikei",
"605758", "Kuala\ Kangsar",
"6082682", "Kuching",
"6032085", "Kuala\ Lumpur",
"604955", "Kuah",
"6088667", "Kota\ Marudu",
"6086292", "Bintulu",
"6036156", "Kuala\ Lumpur",
"606232", "Melaka",
"6032084", "Kuala\ Lumpur",
"605892", "Semanggol",
"6034065", "Kuala\ Lumpur",
"607755", "Renggam",
"6088345", "Kota\ Kinabalu",
"6033214", "Sabak\ Bernam",
"606498", "Batu\ Kikir",
"6082793", "Tebedu",
"6088344", "Kota\ Kinabalu",
"605836", "Selama",
"605880", "Selama",
"606240", "Melaka",
"604926", "Ayer\ Hitam",
"6084798", "Kapit",
"6083436", "Saratok",
"6037932", "Kuala\ Lumpur",
"6087212", "Beaufort",
"6039231", "Kuala\ Lumpur",
"604717", "Pokok\ Sena",
"605899", "Semanggol",
"6035721", "Kinrara",
"6037880", "Kuala\ Lumpur",
"608257", "Kuching",
"607917", "Tenang",
"6036087", "Rawang",
"6089726", "Tawau",
"607253", "Johor\ Bahru",
"609853", "Chukai",
"604932", "Ayer\ Hitam",
"603271", "Kuala\ Lumpur",
"605829", "Taiping",
"607277", "Johor\ Bahru",
"607505", "Tanjung\ Kupang",
"609665", "Kuala\ Brang",
"6087887", "Membakut",
"607739", "Kluang",
"6033085", "Kelang",
"6087506", "Labuan",
"606546", "Durian\ Tunggal",
"6038958", "Cheras",
"6038660", "Mantin",
"606332", "Melaka",
"6033084", "Kelang",
"609955", "Machang",
"6088641", "Kudat",
"6089796", "Merotai",
"607740", "Kahang",
"6038951", "Cheras",
"606428", "Kuala\ Pilah",
"606226", "Melaka",
"604940", "Kangar",
"6035651", "Kinrara",
"6089851", "Kunak",
"6087316", "Keningau",
"6098001", "Kerteh",
"6082271", "Kuching",
"6033243", "Sekinchan",
"6034102", "Kuala\ Lumpur",
"604672", "Penang",
"6086326", "Bintulu",
"6082278", "Kuching",
"604760", "Alor\ Setar",
"604811", "Penang",
"6036285", "Kuala\ Lumpur",
"604407", "Serdang",
"607960", "Gemas",
"6085471", "Miri",
"6035524", "Kinrara",
"6082827", "Asajaya",
"609838", "Merchang",
"6035525", "Kinrara",
"6038706", "Mantin",
"608848", "Kota\ Kinabalu",
"607650", "Layang\-Layang",
"6034279", "Kuala\ Lumpur",
"6039274", "Kuala\ Lumpur",
"605644", "Hutan\ Melintang",
"606612", "Kuala\ Klawang",
"604838", "Penang",
"6085407", "Miri",
"6082280", "Kuching",
"6088786", "Tuaran",
"6092871", "Kuala\ Krau",
"607422", "Kampung\ Parit\ Tengah",
"6033855", "Sabak\ Bernam",
"609679", "Jerteh",
"6032030", "Kuala\ Lumpur",
"606643", "Port\ Dickson",
"607429", "Senggarang",
"6087852", "Menumbok",
"6083467", "Sebuyau",
"6088972", "Kota\ Belud",
"6087768", "Tambunan",
"609771", "Kota\ Bharu",
"60676", "Seremban",
"607211", "Johor\ Bahru",
"6087761", "Tenom",
"609760", "Bachok",
"6085241", "Kampung\ Pahlawan",
"603217", "Kuala\ Lumpur",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+60|\D)//g;
      my $self = bless({ country_code => '60', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '60', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;