package WebService::Freshservice::User::CustomField;

use v5.010;
use strict;
use warnings;
use Method::Signatures 20140224;
use List::MoreUtils qw(any);
use Carp qw( croak );
use JSON qw( encode_json );
use Moo;
use namespace::clean;

# ABSTRACT: Freshservice User Custom Field

our $VERSION = '0.001'; # VERSION: Generated by DZP::OurPkg:Version


my $Ref = sub {
    croak("api isn't a 'WebService::Freshservice::API' object!") unless $_[0]->DOES("WebService::Freshservice::API");
};

has 'api'    => ( is => 'rw', required => 1, isa => $Ref );
has 'id'     => ( is => 'ro', required => 1 );
has 'field'  => ( is => 'rw', required => 1 );
has 'value'  => ( is => 'rw', required => 1 );


method update_custom_field {
  my $data->{user}{custom_field}{$self->field} = $self->value;
  $self->api->put_api( "itil/requesters/".$self->id.".json", $data);
  return 1;
}

# Internal method that returns a clean perl data structure
# for encode_json
method TO_JSON {
  return $self->value;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Freshservice::User::CustomField - Freshservice User Custom Field

=head1 VERSION

version 0.001

=head1 SYNOPSIS

  use WebService::Freshservice::User::CustomField;

  my $customfield = WebService::Freshservice::User::CustomField->new( api => $api, id => '1234567890' raw => $data );

Requires an 'WebService::Freshservice::API' object, id of the user and
'raw' data.

=head1 DESCRIPTION

Provides a Freshservice user custom field object. 

=head1 METHODS

=head2 update_custom_field

=head1 AUTHOR

Leon Wright <techman@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Leon Wright.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
