{-# OPTIONS_GHC -fglasgow-exts -O0 #-}

{-|
    Prelude generator.
-}

{-
I'd do this in Perl, but presumably show escapes nasty things I didn't
think about.

Unfortunately, this doesn't put literal newlines in the output. There's a
bug in any(The Haskell Report, sec. 2.6; GHC; my understanding) regarding
strings with gaps, when beteween the gaps there is an empty line. Fixes
welcome :-)

-}

module Main where
import System (getArgs)

main :: IO ()
main = do
    [moduleName] <- getArgs
    putStr $ preludeIntro moduleName
    str <- getContents
    let lns = filter notComment . lines $ str
    putStrLn . unlines . map (\ln -> "    , " ++ show ln) $ lns
    putStrLn "    ]\n"
    where
    notComment ('#':_)      = False
    notComment (' ':cs)     = notComment cs
    notComment ('\t':cs)    = notComment cs
    notComment _            = True

preludeIntro :: String -> String
preludeIntro moduleName = "\
\{-# OPTIONS -fglasgow-exts #-}\n\
\ \n\
\{-\n\
\    *** NOTE ***\n\
\    DO NOT EDIT THIS FILE.\n\
\    This module is automatically generated by src/gen_prelude.hs.\n\
\-}\n\
\ \n\
\{-|\n\
\    Perl 6 Prelude.\n\
\ \n\
\>   The world was fair, the mountains tall,\n\
\>   In Eldar Days before the fall\n\
\>   Of mighty kings in Nargothrond\n\
\>   And Gondolin, who now beyond\n\
\>   The Western Seas have passed away:\n\
\>   The world was fair in Durin's day.\n\
\ \n\
\-}\n\
\ \n\
\ \n\
\module " ++ moduleName ++ " (\n\
\    preludeStr\n\
\) where\n\
\ \n\
\preludeStr :: String\n\
\preludeStr = unlines\n\
\    [ \"\"\n"
