# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230903131441;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{en} = {"434212", "St\.\ Veit\ an\ der\ Glan",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"437269", "Baumgartenberg",
"433688", "Tauplitz",
"435442", "Landeck",
"436414", "Grossarl",
"436471", "Tweng",
"435559", "Brand",
"433467", "Schwanberg",
"433455", "Arnfels",
"433685", "Gröbming",
"432857", "Bad\ Grosspertholz",
"432873", "Kottes",
"437948", "Hirschbach\ im\ Mühlkreis",
"435288", "Fügen",
"43662", "Salzburg",
"435552", "Bludenz",
"432723", "Rabenstein\ an\ der\ Pielach",
"433581", "Oberwölz",
"437587", "Wartberg\ an\ der\ Krems",
"435574", "Bregenz",
"432865", "Litschau",
"432146", "Nickelsdorf",
"432713", "Spitz",
"437262", "Perg",
"436272", "Oberndorf\ bei\ Salzburg",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"435449", "Fliess",
"435353", "Waidring",
"435285", "Mayrhofen",
"434229", "Krumpendorf\ am\ Wörther\ See",
"432231", "Purkersdorf",
"436565", "Neukirchen\ am\ Grossvenediger",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"4316", "Vienna",
"432742", "St\.\ Pölten",
"432685", "Rust",
"437563", "Spital\ am\ Pyhrn",
"433182", "Wildon",
"437284", "Oberkappel",
"433328", "Kukmirn",
"432256", "Leobersdorf",
"435253", "Längenfeld",
"432688", "Steinbrunn",
"432641", "Kirchberg\ am\ Wechsel",
"432786", "Oberwölbling",
"437754", "Waldzell",
"432164", "Rohrau",
"434243", "Bodensdorf",
"433356", "Markt\ Allhau",
"437614", "Vorchdorf",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"433133", "Nestelbach",
"433868", "Tragöss",
"432215", "Probstdorf",
"432749", "Prinzersdorf",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"433857", "Neuberg\ an\ der\ Mürz",
"434236", "Eberndorf",
"433146", "Modriach",
"433865", "Kindberg",
"435374", "Walchsee",
"437263", "Bad\ Zell",
"435352", "St\.\ Johann\ in\ Tirol",
"433638", "Palfau",
"432621", "Sieggraben",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"433155", "Fehring",
"432854", "Kirchberg\ am\ Walde",
"436466", "Werfenweng",
"432674", "Weissenbach\ an\ der\ Triesting",
"433635", "Radmer",
"437476", "Aschbach\-Markt",
"432872", "Ottenschlag",
"437278", "Neukirchen\ am\ Walde",
"435553", "Raggal",
"432722", "Kirchberg\ an\ der\ Pielach",
"433158", "St\.\ Anna\ am\ Aigen",
"432556", "Grosskrut",
"432712", "Aggsbach",
"435577", "Lustenau",
"437584", "Molln",
"435238", "Zirl",
"433464", "Gross\ St\.\ Florian",
"432245", "Wolkersdorf\ im\ Weinviertel",
"432719", "Dross",
"433126", "Frohnleiten",
"433116", "Kirchbach\ in\ Steiermark",
"434213", "Launsdorf",
"434223", "Maria\ Saal",
"432248", "Markgrafneusiedl",
"432525", "Gnadendorf",
"435443", "Galtür",
"435359", "Hochfilzen",
"436417", "Hüttschlag",
"437956", "Unterweissenbach",
"435338", "Kundl",
"432635", "Neunkirchen",
"432984", "Eggenburg",
"433854", "Langenwang",
"437757", "Gurten",
"432638", "Winzendorf\-Muthmannsdorf",
"435335", "Hopfgarten\ im\ Brixental",
"432167", "Neusiedl\ am\ See",
"434242", "Villach",
"437617", "Traunkirchen",
"433132", "Kumberg",
"437234", "Ottensheim",
"433611", "Johnsbach",
"435412", "Imst",
"437765", "Lambrechten",
"435274", "Gries\ am\ Brenner",
"437287", "Peilstein\ im\ Mühlviertel",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"435252", "Oetz",
"434875", "Matrei\ in\ Osttirol",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"432736", "Paudorf",
"434715", "Kötschach\-Mauthen",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"437666", "Attersee",
"435585", "Dalaas",
"432743", "Böheimkirchen",
"437562", "Windischgarsten",
"434718", "Dellach",
"434286", "Weissbriach",
"434230", "Globasnitz",
"437588", "Ried\ im\ Traunkreis",
"437252", "Steyr",
"437274", "Alkoven",
"433172", "Weiz",
"435287", "Tux",
"437947", "Kefermarkt",
"437733", "Neumarkt\ im\ Hausruckkreis",
"432858", "Moorbad\ Harbach",
"435375", "Kössen",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"432663", "Schottwien",
"433634", "Hieflau",
"437211", "Reichenau\ im\ Mühlkreis",
"437746", "Friedburg",
"437221", "Hörsching",
"433832", "Kraubath\ an\ der\ Mur",
"436583", "Leogang",
"432855", "Waldenstein",
"433473", "Straden",
"432953", "Nappersdorf",
"433687", "Schladming",
"433457", "Gleinstätten",
"433883", "Terz",
"433465", "Pölfing\-Brunn",
"432244", "Langenzersdorf",
"432524", "Kautendorf",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"432826", "Rastenfeld",
"437259", "Sierning",
"437412", "Ybbs\ an\ der\ Donau",
"435234", "Axams",
"43512", "Innsbruck",
"433179", "Passail",
"432816", "Karlstift",
"4319", "Vienna",
"437238", "Mauthausen",
"433867", "Pernegg\ an\ der\ Mur",
"437480", "Langau\,\ Gaming",
"433855", "Krieglach",
"436246", "Grödig",
"4346", "Klagenfurt",
"432985", "Gars\ am\ Kamp",
"432634", "Gutenstein",
"432172", "Frauenkirchen",
"437764", "Riedau",
"437235", "Gallneukirchen",
"433366", "Kohfidisch",
"436233", "Oberwang",
"433858", "Mitterdorf\ im\ Mürztal",
"437443", "Ybbsitz",
"436131", "Obertraun",
"432988", "Neupölla",
"435334", "Westendorf",
"432266", "Stockerau",
"434714", "Dellach\ im\ Drautal",
"433514", "Seckau",
"435263", "Silz",
"434874", "Virgen",
"435275", "Trins",
"434852", "Lienz",
"435476", "Serfaus",
"432687", "Siegendorf",
"433571", "Möderbrugg",
"433327", "St\.\ Michael\ im\ Burgenland",
"435278", "Navis",
"436415", "Schwarzach\ im\ Pongau",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"432527", "Wulzeshofen",
"437413", "Marbach\ an\ der\ Donau",
"436418", "Kleinarl",
"432952", "Hollabrunn",
"433472", "Mureck",
"433684", "St\.\ Martin\ am\ Grimming",
"433454", "Leutschach",
"436589", "Unken",
"433882", "Mariazell",
"436226", "Fuschl\ am\ See",
"432247", "Deutsch\-Wagram",
"436216", "Neumarkt\ am\ Wallersee",
"435575", "Langen\ bei\ Bregenz",
"432864", "Kautzen",
"436456", "Obertauern",
"432662", "Gloggnitz",
"432959", "Sitzendorf\ an\ der\ Schmida",
"433637", "Gams\ bei\ Hieflau",
"434276", "Feldkirchen\ in\ Kärnten",
"433833", "Traboch",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"435578", "Höchst",
"437253", "Wolfern",
"433157", "Kapfenstein",
"433173", "Ratten",
"437277", "Waizenkirchen",
"435284", "Gerlos",
"437732", "Haag\ am\ Hausruck",
"437944", "Sandl",
"433846", "Kalwang",
"436240", "Krispl",
"437486", "Lunz\ am\ See",
"432684", "Schützen\ am\ Gebirge",
"437716", "Münzkirchen",
"437241", "Steinerkirchen\ an\ der\ Traun",
"437288", "Ulrichsberg",
"436564", "Krimml",
"433324", "Strem",
"437353", "Gaflenz",
"434717", "Steinfeld",
"435262", "Telfs",
"434877", "Prägraten\ am\ Grossvenediger",
"437285", "Hofkirchen\ im\ Mühlkreis",
"434853", "Ainet",
"432173", "Gols",
"437767", "Eggerding",
"432271", "Ried\ am\ Riederberg",
"437615", "Scharnstein",
"432165", "Hainburg\ a\.d\.\ Donau",
"436232", "Mondsee",
"432846", "Raabs\ an\ der\ Thaya",
"437442", "Waidhofen\ an\ der\ Ybbs",
"435337", "Brixlegg",
"437755", "Mettmach",
"433864", "St\.\ Marein\ im\ Mürztal",
"437618", "Neukirchen\,\ Altmünster",
"432168", "Mannersdorf\ am\ Leithagebirge",
"432214", "Kopfstetten",
"432637", "Grünbach\ am\ Schneeberg",
"434766", "Millstatt",
"437758", "Obernberg\ am\ Inn",
"433532", "Murau",
"432555", "Herrnbaumgarten",
"436457", "Flachau",
"436473", "Mariapfarr",
"434732", "Gmünd\ in\ Kärnten",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"433636", "Wildalpen",
"434277", "Glanegg",
"433680", "Donnersbachwald",
"437744", "Munderfing",
"434253", "St\.\ Jakob\ im\ Rosental",
"432619", "Lackendorf",
"432282", "Gänserndorf",
"432629", "Warth\,\ Lower\ Austria",
"437276", "Peuerbach",
"437478", "Oed\-Oehling",
"436468", "Werfen",
"433847", "Trofaiach",
"433333", "Sebersdorf",
"433118", "Sinabelkirchen",
"432752", "Melk",
"435523", "Götzis",
"433382", "Fürstenfeld",
"436547", "Kaprun",
"435513", "Hittisau",
"432526", "Stronsdorf",
"432774", "Innermanzing",
"432233", "Pressbaum",
"432824", "Allentsteig",
"432612", "Oberpullendorf",
"432289", "Matzen",
"435280", "Hochfügen",
"435236", "Gries\ im\ Sellrain",
"432814", "Langschlag",
"432622", "Wiener\ Neustadt",
"433115", "Studenzen",
"433125", "Übelbach",
"436227", "St\.\ Gilgen",
"432711", "Dürnstein",
"433583", "Unzmarkt",
"432246", "Gerasdorf\ bei\ Wien",
"436217", "Mattsee",
"434783", "Reisseck",
"435243", "Maurach",
"437766", "Andorf",
"433619", "Oppenberg",
"433364", "Hannersdorf",
"432847", "Gross\-Siegharts",
"435336", "Alpbach",
"432643", "Lichtenegg",
"432532", "Zistersdorf",
"435212", "Seefeld\ in\ Tirol",
"437434", "Haag",
"435633", "Hägerau",
"436244", "Golling\ an\ der\ Salzach",
"432636", "Puchberg\ am\ Schneeberg",
"434767", "Rothenthurn",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"437955", "Königswiesen",
"437673", "Schwanenstadt",
"435474", "Pfunds",
"437487", "Gresten",
"434285", "Tröpolach",
"432738", "Fels\ am\ Wagram",
"437727", "Ach",
"437665", "Unterach\ am\ Attersee",
"434353", "Prebl",
"437717", "St\.\ Aegidi",
"432264", "Rückersdorf\,\ Harmannsdorf",
"434716", "Lesachtal",
"433516", "Kleinlobming",
"432735", "Hadersdorf\ am\ Kamp",
"433622", "Bad\ Aussee",
"434876", "Kals\ am\ Grossglockner",
"433612", "Liezen",
"433686", "Haus",
"433456", "Fresing",
"436224", "Hintersee",
"433582", "Scheifling",
"434782", "Obervellach",
"436214", "Henndorf\ am\ Wallersee",
"435242", "Schwaz",
"436479", "Muhr",
"435522", "Feldkirch",
"432753", "Gansbach",
"436544", "Rauris",
"437261", "Schönau\ im\ Mühlkreis",
"433383", "Burgau",
"433339", "Friedberg",
"435512", "Egg",
"433150", "Paldau",
"432232", "Fischamend",
"432613", "Deutschkreutz",
"432827", "Schönbach",
"432623", "Pottendorf",
"432239", "Breitenfurt\ bei\ Wien",
"432283", "Angern\ an\ der\ March",
"434221", "Gallizien",
"435286", "Ginzling",
"435230", "Sellrain",
"437946", "Gutau",
"435441", "See",
"433332", "Hartberg",
"43732", "Linz",
"435519", "Schröcken",
"433844", "Kammern\ im\ Liesingtal",
"433533", "Turrach",
"436454", "Mandling",
"432145", "Prellenkirchen",
"436472", "Mauterndorf",
"434733", "Malta",
"434274", "Velden\ am\ Wörther\ See",
"437747", "Kirchberg\ bei\ Mattighofen",
"434252", "Wernberg",
"432267", "Sierndorf",
"432649", "Mönichkirchen",
"433623", "Bad\ Mitterndorf",
"433613", "Admont",
"432255", "Deutsch\ Brodersdorf",
"437672", "Vöcklabruck",
"437484", "Göstling\ an\ der\ Ybbs",
"435477", "Tösens",
"432630", "Ternitz",
"432686", "Drassburg",
"437724", "Mauerkirchen",
"437714", "Esternberg",
"434352", "Wolfsberg",
"433326", "Stegersbach",
"432258", "Alland",
"436566", "Bramberg\ am\ Wildkogel",
"433866", "Breitenau\ am\ Hochlantsch",
"434359", "Reichenfels",
"433145", "Edelschrott",
"432533", "Neusiedl\ an\ der\ Zaya",
"434235", "Bleiburg",
"435213", "Scharnitz",
"433358", "Litzelsdorf",
"436247", "Grossgmain",
"435632", "Stanzach",
"435223", "Hall\ in\ Tirol",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"432741", "Flinsbach",
"4317", "Vienna",
"433148", "Kainach\ bei\ Voitsberg",
"432844", "Karlstein\ an\ der\ Thaya",
"434710", "Oberdrauburg",
"434238", "Eisenkappel\-Vellach",
"433355", "Stadtschlaining",
"432642", "Aspangberg\-St\.\ Peter",
"436215", "Strasswalchen",
"436225", "Eugendorf",
"434842", "Sillian",
"437223", "Enns",
"436548", "Niedernsill",
"433127", "Peggau",
"433117", "Eggersdorf\ bei\ Graz",
"437213", "Bad\ Leonfelden",
"432762", "Lilienfeld",
"436228", "Faistenau",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"436416", "Lend",
"433845", "Mautern\ in\ Steiermark",
"434278", "Gnesau",
"432769", "Türnitz",
"432912", "Geras",
"436458", "Hüttau",
"433848", "Eisenerz",
"436467", "Mühlbach\ am\ Hochkönig",
"434275", "Ebene\ Reichenau",
"437477", "St\.\ Peter\ in\ der\ Au",
"437683", "Frankenburg\ am\ Hausruck",
"435672", "Reutte",
"432951", "Guntersdorf",
"432573", "Wilfersdorf",
"434263", "Hüttenberg",
"436455", "Untertauern",
"432557", "Bernhardsthal",
"432144", "Deutsch\ Jahrndorf",
"433460", "Soboth",
"435576", "Hohenems",
"432254", "Ebreichsdorf",
"437286", "Lembach\ im\ Mühlkreis",
"437230", "Altenberg\ bei\ Linz",
"437718", "Waldkirchen\ am\ Wesen",
"432272", "Tulln\ an\ der\ Donau",
"437728", "Schwand\ im\ Innkreis",
"432943", "Obritz",
"436133", "Ebensee",
"437488", "Steinakirchen\ am\ Forst",
"436483", "Göriach",
"437249", "Bad\ Schallerbach",
"437667", "St\.\ Georgen\ im\ Attergau",
"437485", "Gaming",
"434234", "Ruden",
"434823", "Tresdorf\,\ Rangersdorf",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"433144", "Köflach",
"437242", "Wels",
"436432", "Bad\ Hofgastein",
"433573", "Fohnsdorf",
"432784", "Perschling",
"434768", "Kleblach\-Lind",
"432845", "Weikertschlag\ an\ der\ Thaya",
"432166", "Parndorf",
"433354", "Bernstein",
"437616", "Grünau\ im\ Almtal",
"432279", "Kirchberg\ am\ Wagram",
"432856", "Weitra",
"437229", "Traun",
"437474", "Euratsfeld",
"435673", "Ehrwald",
"437682", "Vöcklamarkt",
"437745", "Lochen",
"437219", "Vorderweissenbach",
"432572", "Mistelbach",
"434262", "Treibach",
"437586", "Pettenbach",
"432147", "Zurndorf",
"432554", "Stützenhofen",
"435376", "Thiersee",
"437748", "Eggelsberg",
"432913", "Hötzelsdorf",
"433171", "Gasen",
"432815", "Grossschönau",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"437251", "Schiedlberg",
"432825", "Göpfritz\ an\ der\ Wild",
"434843", "Ausservillgraten",
"432828", "Rappottenstein",
"434269", "Flattnitz",
"433466", "Eibiswald",
"433124", "Gratkorn",
"437212", "Zwettl\ an\ der\ Rodl",
"433114", "Markt\ Hartmannsdorf",
"432949", "Niederfladnitz",
"433357", "Pinkafeld",
"433365", "Deutsch\ Schützen\-Eisenberg",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"437236", "Pregarten",
"432986", "Irnfritz",
"437954", "St\.\ Georgen\ am\ Walde",
"433856", "Veitsch",
"437435", "St\.\ Valentin",
"434237", "Miklauzhof",
"436245", "Hallein",
"434822", "Winklern",
"433147", "Salla",
"437243", "Marchtrenk",
"436433", "Dorfgastein",
"433572", "Judenburg",
"433579", "Pöls",
"437664", "Weyregg\ am\ Attersee",
"434284", "Kirchbach",
"435475", "Feichten",
"432268", "Grossmugl",
"435276", "Gschnitz",
"432257", "Klausen\-Leopoldsdorf",
"432273", "Tulbing",
"432942", "Retz",
"437750", "Andrichsfurt",
"432734", "Langenlois",
"432265", "Hausleiten",
"436132", "Bad\ Ischl",
"432160", "Jois",
"437218", "Grosstraberg",
"432754", "Loosdorf",
"437228", "Kematen\ an\ der\ Krems",
"436543", "Taxenbach",
"435517", "Riezlern",
"432772", "Neulengbach",
"432237", "Gaaden",
"432822", "Zwettl\,\ Lower\ Austria",
"432614", "Kleinwarasdorf",
"437416", "Wieselburg",
"432624", "Ebenfurth",
"432812", "Gross\ Gerungs",
"437215", "Hellmonsödt",
"437225", "Hargelsberg",
"436223", "Anthering",
"433587", "Schönberg\-Lachtal",
"436213", "Oberhofen\ am\ Irrsee",
"433534", "Stadl\ an\ der\ Mur",
"434265", "Weitensfeld\ im\ Gurktal",
"436453", "Filzmoos",
"433461", "Trahütten",
"432575", "Ladendorf",
"436477", "St\.\ Michael\ im\ Lungau",
"434734", "Rennweg",
"434273", "Reifnitz",
"437742", "Mattighofen",
"434257", "Fürnitz",
"432829", "Schweiggers",
"437256", "Ternberg",
"434268", "Friesach",
"432284", "Oberweiden",
"433176", "Stubenberg",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"433337", "Vorau",
"437483", "Oberndorf\ an\ der\ Melk",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"435472", "Prutz",
"432948", "Weitersfeld",
"437723", "Altheim",
"437713", "Schardenberg",
"434357", "St\.\ Paul\ im\ Lavanttal",
"432262", "Korneuburg",
"436135", "Bad\ Goisern",
"432945", "Zellerndorf",
"433624", "Pichl\-Kainisch",
"437231", "Herzogsdorf",
"433614", "Rottenmann",
"432176", "Tadten",
"433578", "Obdach",
"433362", "Grosspetersdorf",
"432269", "Niederfellabrunn",
"432843", "Dobersberg",
"432647", "Krumbach\,\ Lower\ Austria",
"433575", "St\.\ Johann\ am\ Tauern",
"432534", "Niedersulz",
"435214", "Leutasch",
"437432", "Strengberg",
"436242", "Russbach\ am\ Pass\ Gschütt",
"434825", "Grosskirchheim",
"435224", "Wattens",
"432915", "Drosendorf\-Zissersdorf",
"432287", "Strasshof\ an\ der\ Nordbahn",
"437736", "Pram",
"435678", "Weissenbach\ am\ Lech",
"436549", "Piesendorf",
"433334", "Kaindorf",
"433842", "Leoben",
"433537", "St\.\ Georgen\ ob\ Murau",
"436229", "Hof\ bei\ Salzburg",
"436452", "Radstadt",
"436219", "Obertrum\ am\ See",
"436474", "Tamsweg",
"432666", "Reichenau",
"434272", "Pörtschach\ am\ Wörther\ See",
"437743", "Maria\ Schmolln",
"435675", "Tannheim",
"434254", "Faak\ am\ See",
"434279", "Sirnitz",
"433476", "Bad\ Radkersburg",
"432956", "Ziersdorf",
"433886", "Weichselboden",
"433584", "Neumarkt\ in\ Steiermark",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"434784", "Mallnitz",
"436212", "Seekirchen\ am\ Wallersee",
"435244", "Jenbach",
"432757", "Pöchlarn",
"435524", "Satteins",
"436542", "Zell\ am\ See",
"433387", "Söchau",
"432773", "Eichgraben",
"435514", "Bezau",
"433849", "Vordernberg",
"437250", "Maria\ Neustift",
"432234", "Gramatneusiedl",
"432617", "Drassmarkt",
"432823", "Grossglobnitz",
"434848", "Kartitsch",
"433170", "Fischbach",
"432765", "Kaumberg",
"432813", "Arbesbach",
"432627", "Pitten",
"437729", "Neukirchen\ an\ der\ Enknach",
"437245", "Lambach",
"437719", "Taufkirchen\ an\ der\ Pram",
"437433", "Wallsee",
"436243", "Abtenau",
"437489", "Purgstall\ an\ der\ Erlauf",
"435634", "Elbigenalp",
"434762", "Spittal\ an\ der\ Drau",
"433363", "Rechnitz",
"437281", "Aigen\ im\ Mühlkreis",
"437248", "Grieskirchen",
"432842", "Waidhofen\ an\ der\ Thaya",
"432644", "Grimmenstein",
"432849", "Schwarzenau",
"432263", "Grossrussbach",
"435266", "Ötztal\-Bahnhof",
"437751", "St\.\ Martin\ im\ Innkreis",
"432275", "Atzenbrugg",
"433617", "Gaishorn\ am\ See",
"437674", "Attnang\-Puchheim",
"437482", "Scheibbs",
"435473", "Nauders",
"434769", "Möllbrücke",
"437722", "Braunau\ am\ Inn",
"432278", "Absdorf",
"434354", "Preitenegg",
"437712", "Schärding",
"437266", "Bad\ Kreuzen",
"433335", "Pöllau",
"434258", "Gummern",
"436276", "Nussdorf\ am\ Haunsberg",
"436478", "Zederhaus",
"432914", "Japons",
"433338", "Lafnitz",
"434255", "Arnoldstein",
"436463", "Annaberg\-Lungötz",
"437473", "Blindenmarkt",
"435674", "Bichlbach",
"435556", "Schruns",
"436475", "Ramingstein",
"432577", "Asparn\ an\ der\ Zaya",
"434267", "Metnitz",
"432142", "Gattendorf",
"434785", "Ausserfragant",
"435245", "Hinterriss",
"433585", "St\.\ Lambrecht",
"432238", "Kaltenleutgeben",
"435518", "Mellau",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"437227", "Neuhofen\ an\ der\ Krems",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"435248", "Steinberg\ am\ Rofan",
"432764", "Hainfeld",
"434226", "St\.\ Margareten\ im\ Rosental",
"433588", "Katsch\ an\ der\ Mur",
"432235", "Maria\-Lanzendorf",
"435515", "Au",
"435446", "St\.\ Anton\ am\ Arlberg",
"437941", "Neumarkt\ im\ Mühlkreis",
"435525", "Nenzing",
"437953", "Liebenau",
"432648", "Hochneukirchen",
"434232", "Völkermarkt",
"435635", "Elmen",
"437244", "Sattledt",
"433142", "Voitsberg",
"436434", "Bad\ Gastein",
"433577", "Zeltweg",
"432645", "Wiesmath",
"432782", "Herzogenburg",
"433352", "Oberwart",
"432259", "Münchendorf",
"432252", "Baden",
"434358", "St\.\ Andrä",
"432274", "Sieghartskirchen",
"432733", "Schönberg\ am\ Kamp",
"432947", "Theras",
"434240", "Bad\ Kleinkirchheim",
"436137", "Strobl",
"433359", "Loipersdorf\-Kitzladen",
"434355", "Gemmersdorf",
"433149", "Geistthal",
"433861", "Aflenz",
"437663", "Steinbach\ am\ Attersee",
"432746", "Wilhelmsburg",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"437675", "Ampflwang\ im\ Hausruckwald",
"4315", "Vienna",
"434283", "St\.\ Stefan\ im\ Gailtal",
"432625", "Bad\ Sauerbrunn",
"432767", "Hohenberg",
"433151", "Gnas",
"432615", "Lutzmannsburg",
"433385", "Ilz",
"437260", "Waldhausen",
"432755", "Mank",
"432628", "Felixdorf",
"435550", "Thüringen",
"432618", "Markt\ St\.\ Martin",
"434847", "Obertilliach",
"437224", "St\.\ Florian",
"432758", "Pöggstall",
"437479", "Ardagger",
"433631", "Unterlaussa",
"437214", "Reichenthal",
"433112", "Gleisdorf",
"436462", "Bischofshofen",
"437472", "Amstetten",
"435677", "Vils",
"437684", "Frankenmarkt",
"432876", "Els",
"433119", "St\.\ Marein\ bei\ Graz",
"434735", "Kremsbrücke",
"432574", "Gaweinstal",
"432726", "Puchenstuben",
"433535", "Krakaudorf",
"434264", "Klein\ St\.\ Paul",
"432288", "Auersthal",
"432716", "Gföhl",
"432143", "Kittsee",
"432552", "Poysdorf",
"4312", "Vienna",
"435356", "Kitzbühel",
"434220", "Köttmannsdorf",
"432285", "Marchegg",
"436484", "Lessach",
"433618", "Hohentauern",
"437662", "Seewalchen\ am\ Attersee",
"432631", "Pöttsching",
"437566", "Rosenau\ am\ Hengstpass",
"434282", "Hermagor",
"4313", "Vienna",
"432253", "Oberwaltersdorf",
"433615", "Trieben",
"432277", "Zwentendorf",
"435256", "Untergurgl",
"432944", "Haugsdorf",
"435331", "Brandenberg",
"432732", "Krems\ an\ der\ Donau",
"436134", "Hallstatt",
"432783", "Traismauer",
"432739", "Tiefenfucha",
"433353", "Oberschützen",
"434246", "Radenthein",
"432538", "Velm\-Götzendorf",
"433136", "Dobl",
"435225", "Fulpmes",
"437952", "Weitersfelden",
"434233", "Griffen",
"434824", "Heiligenblut",
"433143", "Krottendorf",
"437247", "Kematen\ am\ Innbach",
"432535", "Hohenau\ an\ der\ March",
"433574", "Pusterwald",
"432673", "Altenmarkt\ an\ der\ Triesting",
"432853", "Schrems",
"432877", "Grainbrunn",
"435676", "Jungholz",
"432665", "Prein\ an\ der\ Rax",
"435554", "Sonntag",
"437583", "Kremsmünster",
"436221", "Koppl",
"435572", "Dornbirn",
"432717", "Unter\-Meisling",
"435373", "Ebbs",
"436541", "Saalbach",
"437264", "Windhaag\ bei\ Perg",
"436588", "Lofer",
"437735", "Gaspoltshofen",
"436274", "Lamprechtshausen",
"435357", "Kirchberg\ in\ Tirol",
"432916", "Riegersburg\,\ Hardegg",
"434214", "Brückl",
"432766", "Kleinzell",
"434224", "Pischeldorf",
"435444", "Ischgl",
"432958", "Maissau",
"436412", "St\.\ Johann\ im\ Pongau",
"434846", "Abfaltersbach",
"433463", "Stainz",
"435579", "Alberschwende",
"433885", "Greith",
"432955", "Grossweikersdorf",
"433475", "Hürth",
"434271", "Steuerberg",
"437752", "Ried\ im\ Innkreis",
"436235", "Thalgau",
"432162", "Bruck\ an\ der\ Leitha",
"437445", "Hollenstein\ an\ der\ Ybbs",
"434247", "Afritz",
"437289", "Rohrbach\ in\ Oberösterreich",
"437612", "Gmunden",
"435417", "Roppen",
"437233", "Feldkirchen\ an\ der\ Donau",
"433137", "Söding",
"432983", "Sigmundsherberg",
"437448", "Kematen\ an\ der\ Ybbs",
"433853", "Spital\ am\ Semmering",
"437246", "Gunskirchen",
"437711", "Suben",
"4318", "Vienna",
"432744", "Kasten\ bei\ Böheimkirchen",
"434761", "Stockenboi",
"437282", "Neufelden",
"433184", "Wolfsberg\ im\ Schwarzautal",
"435273", "Matrei\ am\ Brenner",
"437619", "Kirchham",
"432276", "Reidling",
"435265", "Nassereith",
"437759", "Antiesenhofen",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"432841", "Vitis",
"433462", "Deutschlandsberg",
"437226", "Wilhering",
"432859", "Brand\-Nagelberg",
"437216", "Helfenberg",
"437415", "Altenmarkt\,\ Yspertal",
"434227", "Ferlach",
"435447", "Flirsch",
"436413", "Wagrain",
"435372", "Kufstein",
"437267", "Mönchdorf",
"435354", "Fieberbrunn",
"436277", "St\.\ Pantaleon",
"433175", "Anger",
"437255", "Losenstein",
"432852", "Gmünd",
"432672", "Berndorf",
"432874", "Martinsberg",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"435557", "St\.\ Gallenkirch",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"432576", "Ernstbrunn",
"433469", "St\.\ Oswald\ im\ Freiland",
"434266", "Strassburg",
"437258", "Bad\ Hall",
"432714", "Rossatz",
"435573", "Hörbranz",
"437582", "Kirchdorf\ an\ der\ Krems",
"437283", "Sarleinsbach",
"435272", "Steinach\ am\ Brenner",
"437239", "Lichtenberg",
"434855", "Assling",
"435254", "Sölden",
"432946", "Pulkau",
"436136", "Gosau",
"437355", "Weyer",
"434858", "Nikolsdorf",
"437240", "Sipbachzell",
"432747", "Ober\-Grafendorf",
"432989", "Brunn\ an\ der\ Wild",
"437564", "Hinterstoder",
"436241", "St\.\ Koloman",
"433859", "Mürzsteg",
"432982", "Horn",
"433852", "Mürzzuschlag",
"434826", "Mörtschach",
"433576", "Bretstein",
"437753", "Eberschwang",
"432163", "Petronell\-Carnuntum",
"434244", "Bad\ Bleiberg",
"437613", "Laakirchen",
"435279", "St\.\ Jodok\ am\ Brenner",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"433134", "Heiligenkreuz\ am\ Waasen",
"435414", "Wenns",
"432175", "Apetlon",
"433477", "St\.\ Peter\ am\ Ottersbach",
"432957", "Hohenwarth",
"437471", "Neustadtl\ an\ der\ Donau",
"433683", "Donnersbach",
"436461", "Dienten\ am\ Hochkönig",
"433453", "Ehrenhausen",
"432242", "St\.\ Andrä\-Wördern",
"436470", "Atzmannsdorf",
"432756", "St\.\ Leonhard\ am\ Forst",
"433386", "Grosssteinbach",
"432522", "Laa\ an\ der\ Thaya",
"432616", "Lockenhaus",
"433159", "Bad\ Gleichenberg",
"437414", "Weins\-Isperdorf",
"435232", "Kematen\ in\ Tirol",
"437279", "Haibach\ ob\ der\ Donau",
"432626", "Mattersburg",
"432718", "Lichtenau\ im\ Waldviertel",
"432230", "Schwadorf",
"432286", "Obersiebenbrunn",
"437254", "Grossraming",
"433152", "Feldbach",
"432728", "Wienerbruck",
"435239", "Kühtai",
"437272", "Eferding",
"433174", "Birkfeld",
"435283", "Kaltenbach",
"437943", "Windhaag\ bei\ Freistadt",
"435355", "Jochberg",
"432878", "Traunstein",
"435510", "Damüls",
"433536", "St\.\ Peter\ am\ Kammersberg",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"432249", "Gross\-Enzersdorf",
"4314", "Vienna",
"432863", "Eggern",
"432725", "Frankenfels",
"434736", "Innerkrems",
"432667", "Schwarzau\ im\ Gebirge",
"433632", "St\.\ Gallen",
"435358", "Ellmau",
"432875", "Grafenschlag",
"433834", "Wald\ am\ Schoberpass",
"434712", "Greifenburg",
"433512", "Knittelfeld",
"435339", "Wildschönau",
"435255", "Umhausen",
"434872", "Huben",
"433616", "Selzthal",
"437565", "St\.\ Pankraz",
"432683", "Purbach\ am\ Neusiedler\ See",
"432639", "Bad\ Fischau",
"435582", "Klösterle",
"433323", "Eberau",
"436563", "Uttendorf",
"433863", "Turnau",
"435418", "Schönwies",
"43316", "Graz",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"432536", "Drösing",
"434248", "Treffen",
"432213", "Lassee",
"435226", "Neustift\ im\ Stubaital",
"432632", "Pernitz",
"437762", "Raab",
"432174", "Wallern\ im\ Burgenland",
"434879", "St\.\ Veit\ in\ Defereggen",
"433135", "Kalsdorf\ bei\ Graz",
"434245", "Feistritz\ an\ der\ Drau",
"432731", "Idolsberg",
"435332", "Wörgl",
"432862", "Heidenreichstein",
"432664", "Semmering",
"436476", "St\.\ Margarethen\ im\ Lungau",
"433633", "Landl",
"436278", "Ostermiething",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"434256", "Nötsch\ im\ Gailtal",
"437268", "Grein",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"432610", "Horitschon",
"437257", "Grünburg",
"433153", "Riegersburg",
"435558", "Gaschurn",
"432620", "Willendorf",
"433177", "Puch\ bei\ Weiz",
"437273", "Aschach\ an\ der\ Donau",
"435282", "Zell\ am\ Ziller",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"437942", "Freistadt",
"433336", "Waldbach",
"437265", "Pabneukirchen",
"435445", "Kappl",
"437949", "Rainbach\ im\ Mühlkreis",
"435526", "Laterns",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"435516", "Doren",
"432236", "Mödling",
"434225", "Grafenstein",
"434215", "Liebenfels",
"435289", "Häusling",
"432954", "Göllersdorf",
"433474", "Deutsch\ Goritz",
"433682", "Stainach",
"435448", "Pettneu\ am\ Arlberg",
"433452", "Leibnitz",
"433884", "Wegscheid",
"433586", "Mühlen",
"434228", "Feistritz\ im\ Rosental",
"432243", "Klosterneuburg",
"435246", "Achenkirch",
"437763", "Kopfing\ im\ Innkreis",
"432177", "Podersdorf\ am\ See",
"436234", "Zell\ am\ Moos",
"437444", "Opponitz",
"435333", "Söll",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"433862", "Bruck\ an\ der\ Mur",
"433329", "Jennersdorf",
"432212", "Orth\ an\ der\ Donau",
"432689", "Hornstein",
"432633", "Markt\ Piesting",
"437676", "Ottnang\ am\ Hausruck",
"434231", "Mittertrixen",
"432745", "Pyhra",
"432682", "Eisenstadt",
"435583", "Lech",
"434356", "Lavamünd",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"436562", "Mittersill",
"433141", "Hirschegg",
"433322", "Güssing",
"434713", "Techendorf",
"437357", "Kleinreifling",
"435264", "Mieming",
"433513", "Bischoffeld",
"432748", "Kilb",
"434873", "St\.\ Jakob\ in\ Defereggen",
"433185", "Preding",};
$areanames{de} = {"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"433575", "Sankt\ Johann\ am\ Tauern",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"434825", "Großkirchheim",
"433362", "Großpetersdorf",
"432647", "Krumbach\,\ Niederösterreich",
"437218", "Großtraberg",
"432822", "Zwettl\-Niederösterreich",
"432812", "Groß\ Gerungs",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"436477", "Sankt\ Michael\ im\ Lungau",
"432263", "Großrußbach",
"437751", "Sankt\ Martin\ im\ Innkreis",
"433537", "Sankt\ Georgen\ ob\ Murau",
"435678", "Weißenbach\ am\ Lech",
"432617", "Draßmarkt",
"432823", "Großglobnitz",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"4315", "Wien",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"434358", "Sankt\ Andrä",
"436276", "Nußdorf\ am\ Haunsberg",
"434226", "Sankt\ Margareten\ im\ Rosental",
"435446", "Sankt\ Anton\ am\ Arlberg",
"435245", "Hinterriß",
"434785", "Außerfragant",
"433585", "Sankt\ Lambrecht",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"4313", "Wien",
"437566", "Rosenau\ am\ Hengstpaß",
"432618", "Markt\ Sankt\ Martin",
"437224", "Sankt\ Florian",
"4312", "Wien",
"433119", "Sankt\ Marein\ bei\ Graz",
"434264", "Klein\ Sankt\ Paul",
"4318", "Wien",
"432955", "Großweikersdorf",
"436412", "Sankt\ Johann\ im\ Pongau",
"436241", "Sankt\ Koloman",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"435279", "Sankt\ Jodok\ am\ Brenner",
"435557", "Sankt\ Gallenkirch",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"433469", "Sankt\ Oswald\ im\ Freiland",
"434266", "Straßburg",
"436277", "Sankt\ Pantaleon",
"437565", "Sankt\ Pankraz",
"434879", "Sankt\ Veit\ in\ Defereggen",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"432756", "Sankt\ Leonhard\ am\ Forst",
"433386", "Großsteinbach",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"432242", "Sankt\ Andrä\-Wördern",
"432249", "Groß\-Enzersdorf",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"4314", "Wien",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"433632", "Sankt\ Gallen",
"433834", "Wald\ am\ Schoberpaß",
"437254", "Großraming",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"436565", "Neukirchen\ am\ Großvenediger",
"4316", "Wien",
"432742", "Sankt\ Pölten",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"433868", "Tragöß",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"436414", "Großarl",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"435449", "Fließ",
"432857", "Bad\ Großpertholz",
"437956", "Unterweißenbach",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"434286", "Weißbriach",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"432674", "Weißenbach\ an\ der\ Triesting",
"432556", "Großkrut",
"433158", "Sankt\ Anna\ am\ Aigen",
"435352", "Sankt\ Johann\ in\ Tirol",
"432719", "Droß",
"433464", "Groß\ Sankt\ Florian",
"4319", "Wien",
"433327", "Sankt\ Michael\ im\ Burgenland",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"434877", "Prägraten\ am\ Großvenediger",
"433864", "Sankt\ Marein\ im\ Mürztal",
"433684", "Sankt\ Martin\ am\ Grimming",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"432847", "Groß\-Siegharts",
"434876", "Kals\ am\ Großglockner",
"437717", "Sankt\ Aegidi",
"432629", "Warth\,\ Niederösterreich",
"434253", "Sankt\ Jakob\ im\ Rosental",
"436227", "Sankt\ Gilgen",
"434783", "Reißeck",
"432233", "Preßbaum",
"432686", "Draßburg",
"4317", "Wien",
"432642", "Aspangberg\-Sankt\ Peter",
"436247", "Großgmain",
"437667", "Sankt\ Georgen\ im\ Attergau",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"436215", "Straßwalchen",
"437477", "Sankt\ Peter\ in\ der\ Au",
"437954", "Sankt\ Georgen\ am\ Walde",
"437435", "Sankt\ Valentin",
"432268", "Großmugl",
"437219", "Vorderweißenbach",
"434843", "Außervillgraten",
"432815", "Großschönau",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;