use strict;
use warnings;
use Moo;
use Method::Signatures;
use Test::More;
use XML::Lenient;
no warnings "uninitialized";

my $p = XML::Lenient->new();
my $ml = '<a href="www.example.com">Click</a>';
my $val = $p->tagval($ml, 'a');
ok ('href="www.example.com"' eq $val, 'Simple tagval works');
$ml = '<a></a><a href="www.example.com">Click</a>';
$val = $p->tagval($ml, 'a', 2);
ok ('href="www.example.com"' eq $val, 'Indexed tagval works');
$ml = '<a><a href="www.example.com">Click</a></a>';
$val = $p->tagval($ml, 'a', 2);
ok ('href="www.example.com"' eq $val, 'Nested tagval works');
$val = $p->tagval($ml, '');
ok ('' eq $val, 'Returns zero length string with no tag');
$val = $p->tagval($ml, undef);
ok ('' eq $val, 'Returns zero length string with undef tag');
$val = $p->tagval($ml, 'x');
ok ('' eq $val, 'Returns zero length string with valid tag not in ML');

done_testing;