# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..20\n"; }
END {print "not ok 1\n" unless $loaded;}
use GH::Align qw(globalMinDifferences);
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

use lib "../../EditOp/blib/lib";
use lib "../../EditOp/blib/arch";

use GH::EditOp;

sub Not {
  print "not ";
}

sub Ok {
  my($i) = @_;
  print "ok $i\n";
}
  
$i = 2;

my $l;
$aRef = globalMinDifferences("abc", "dbe");

Not() if ($$aRef[0] != 0); Ok($i++);
Not() if ($$aRef[1] != 2); Ok($i++);

$s1 = <<MOOSE;
GGAAGACGAGATCGGAAGTGAGTCATTGTGGTGGGCTCCTCGGGTGTGCTGTCGGAGCGGTTGAA
GGAGTCGGTCCCACATAACTCGCCAACCACCGTGGTGCTTGAGGAAGCTGCTGCTGCAGTCGCAG
CCACAAGCGACAAGCGTCCATTGTTTGTTTGGATTGAACTTTGCTGCTTTAGCTTCGACTGTTTG
TGCTCAAAAAGTTCGAGTTCGCCGAGAGAAGCGTGAAAATCCGATATCGAAACTACGTTTTTTTT
TTAGTCATTATACCGATTGGCTATGCAAATTTAATTGCGGATCTCCCAAATCATCGAAAAGCCAA
CAGGTCGCCCCTCAACCAAAATAAACACAACAATCGAGCCGCAAATGAAACGGGCAAAAACAGCA
AAGGCAACTGGCGAACCGCTTAACCGGTTTCGAAATATCCATCGTAGCACAGTTTCCTCGTCCAT
ATAATATTCCGATTGCAGTGGATCAAAATATACACACACACACTCGCATATAAATTCGCAGATAT
ACGTTGTTTGTGTGAGTTTCTGTTTGTGGTTCGCGTGAAAAATAGTTTTGACAAATAAATACAAA
GCCAGACGCCGACATAACTGTGAAAATAAACCATAAGCCAGACAGCAGCCATGGGTTATTCCATT
AAGAACTGCGAAACGGTGAGTTGGAGTACTTCTACACAGACACCGTCCGCGTTAATAGACCGGC
CTTCGATGAGGAGACCGGTGAACCGATCCACGACCAGGTGACCAAGGTTCACTTCCGCAAACACA
CGAATTTCCATGTACCCAAGCACTATCTCCGCGGAACCATATGCGATGAGGTAGACGACGAGCTG
GCCAATACGGTGAGATATGGGGCAGCCACCGCGATTCCCAACAGGGGAAGACGAGATCGGCACCC
AAAAAGGTCACTCCGGGCTACGAACGCGAGGACTATTGTCAAATGGATGGCGTGAGCAACAACAT
AATCCTGGGCTACAACCGCAACCCCTACTTGCTGTTCCTGGTGCCCACGCTCTTCTGCTACAACT
TCGTCATTGGAGCCACGCTGGCCCTCATCGAGATCGTCCTGCACATGATGTCCCACCACAGGAAC
GGTCTCACCATGCAGAAGAGCCTGTACTTCCGTAGTCCACTCAACGTGCTGTCCTCGCAGTTCTG
CGCCATCTGCCGCACGGAAACCGACAGCAAGTACAACCGCATCTTCGATATCCTTAACAAGCAGA
TGCGCAACGCACATCGCTCCGAGGCGCTGAAGACATGGCCAAGGCAATTGGATAAGCTGGGAGA
GATTCGATTTGATATGGTCCATATATTTAACACAAATGTTTTTGTCACACGGTCAACAAAAAATA
AATGCACTCGTTTATCACTCAAAAAAAAAAAAAAAAA
MOOSE

$s2 = <<MOOSE;
GGAAGACGAGATCGGAAGTGAGTCATTGTGGTGGGCTCCTCGGGTGTGCTGTCGGAGCGGTTGAA
GGAGTCGGTCCCACATAACTCGCCAACCACCGTGGTGCTTGAGGAAGCTGCTGCTGCAGTCGCAG
CCACAAGCGACAAGCGTCCATTGTTTGTTTGGATTGAACTTTGCTGCTTTAGCTTCGACTGTTTG
TGCTCAAAAAGTTCGAGTTCGCCGAGAGAAGCGTGAAAATCCGATATCGAAACTACGTTTTTTTT
TTAGTCATTATACCGATTGGCTATGCAAATTTAATTGCGGATCTCCCAAATCATCGAAAAGCCAA
CAGGTCGCCCCTCAACCAAAATAAACACAACAATCGAGCCGCAAATGAAACGGGCAAAAACAGCA
AAGGCAACTGGCGAACCGCTTAACCGGTTTCGAAATATCCATCGTAGCACAGTTTCCTCGTCCAT
ATAATATTCCGATTGCAGTGGATCAAAATATACACACACACACTCGCATATAAATTCGCAGATAT
ACGTTGTTTGTGTGAGTTTCTGTTTGTGGTTCGCGTGAAAAATAGTTTTGACAAATAAATACAAA
GCCAGACGCCGACATAACTGTGAAAATAAACCATAAGCCAGACAGCAGCCATGGGTTATTCCATT
AAGAACTGCGAAACGGGTGAGTTGGAGTACTTCTACACAGACACCGTCCGCGTTAATAGACCGGC
CTTCGATGAGGAGACCGGTGAACCGATCCACGACCAGGTGACCAAGGTTCACTTCCGCAAACACA
CGAATTTCCATGTACCCAAGCACTATCTCCGCGGAACCATATGCGATGAGGTAGACGACGAGCTG
GCCAATACGGTGAGATATGGGGCAGCCACCGCGATTCCCAACAGGGGAAGACGAGATCGGCACCC
AAAAAGGTCACTCCGGGCTACGAACGCGAGGACTATTGTCAAATGGATGGCGTGAGCAACAACAT
AATCCTGGGCTACAACCGCAACCCCTACTTGCTGTTCCTGGTGCCCACGCTCTTCTGCTACAACT
TCGTCATTGGAGCCACGCTGGCCCTCATCGAGATCGTCCTGCACATGATGTCCCACCACAGGAAC
GGTCTCACCATGCAGAAGAGCCTGTACTTCCGTAGTCCACTCAACGTGCTGTCCTCGCAGTTCTG
CGCCATCTGCCGCACGGAAACCGACAGCAAGTACAACCGCATCTTCGATATCCTTAACAAGCAGA
TGCGCAACGCACATCGCTCCGAGGCGCTGAAGGACATGGCCAAGGCAATTGGATAAGCTGGGAGA
GATTCGATTTGATATGGTCCATATATTTAACACAAATGTTTTTGTCACACGGTCAACAAAAAATA
AATGCACTCGTTTATCACTCAAAAAAAAAAAAAAT
MOOSE

$s1 =~ s/\n//g;
$s2 =~ s/\n//g;

$aRef = globalMinDifferences($s1, $s2);

$status = $$aRef[0];
Not() if ($status != 0); Ok($i++);
$count = $$aRef[1];
Not() if ($count != 5); Ok($i++);

$opsRef = $$aRef[2];

Not() if (scalar(@{$opsRef}) != 7); Ok($i++);

$e = $$opsRef[0];
Not() if ($e->getType != 1); Ok($i++);
Not() if ($e->getCount != 666); Ok($i++);

$e = $$opsRef[1];
Not() if ($e->getType != 4); Ok($i++);
Not() if ($e->getCount != 1); Ok($i++);

$e = $$opsRef[2];
Not() if ($e->getType != 1); Ok($i++);
Not() if ($e->getCount != 600); Ok($i++);

$e = $$opsRef[3];
Not() if ($e->getType != 4); Ok($i++);
Not() if ($e->getCount != 1); Ok($i++);

$e = $$opsRef[4];
Not() if ($e->getType != 1); Ok($i++);
Not() if ($e->getCount != 131); Ok($i++);

$e = $$opsRef[5];
Not() if ($e->getType != 3); Ok($i++);
Not() if ($e->getCount != 2); Ok($i++);

$e = $$opsRef[6];
Not() if ($e->getType != 2); Ok($i++);
Not() if ($e->getCount != 1); Ok($i++);

exit 0;
#foreach $op (@{$opsRef}) {
#  print $op->getOpName, "(", $op->getType, "), ", $op->getCount, "\n";
#}
