use strict;
use warnings;

use Test::More;
use PDL;
use PDL::IO::Image;
use Test::Number::Delta within => 0.0000001;

my $expected_page2 = [
 [
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,223,217,217,215,255,255,255,255,255,255,255,255,255,255,255,255,215,217,217,223,255,255,255,255,255,255],
  [255,255,255,255,213,219,218,218,218,218,218,216,255,255,255,255,255,255,255,255,216,218,218,218,218,218,219,213,255,255,255,255],
  [255,255,255,213,218,218,218,218,218,218,218,218,217,255,255,255,255,255,255,217,218,218,218,218,218,218,218,218,213,255,255,255],
  [255,255,255,219,218,218,218,218,218,218,218,218,218,217,255,255,255,255,217,218,218,218,218,218,218,218,218,218,219,255,255,255],
  [255,255,223,218,218,218,218,218,218,218,218,218,218,219,255,255,255,255,219,218,218,218,218,218,218,218,218,218,218,223,255,255],
  [255,255,217,218,218,218,218,218,218,218,218,218,218,218,255,255,255,255,218,218,218,218,218,218,218,218,218,218,218,217,255,255],
  [255,255,217,218,218,218,218,218,218,218,218,218,218,218,255,255,255,255,218,218,218,218,218,218,218,218,218,218,218,217,255,255],
  [255,255,215,218,218,218,218,218,218,218,218,218,218,218,255,255,255,255,218,218,218,218,218,218,218,218,218,218,218,215,255,255],
  [255,255,255,218,218,218,218,218,218,218,218,218,218,219,255,255,255,255,219,218,218,218,218,218,218,218,218,218,218,255,255,255],
  [255,255,255,216,218,218,218,218,218,218,218,218,219,255,255,255,255,255,255,219,218,218,218,218,218,218,218,218,216,255,255,255],
  [255,255,255,255,217,218,218,218,218,218,218,219,221,255,255,255,255,255,255,221,219,218,218,218,218,218,218,217,255,255,255,255],
  [255,255,255,255,255,217,219,218,218,218,219,255,255,255,255,255,255,255,255,255,255,219,218,218,218,219,217,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,217,219,218,218,218,219,255,255,255,255,255,255,255,255,255,255,219,218,218,218,219,217,255,255,255,255,255],
  [255,255,255,255,217,218,218,218,218,218,218,219,221,255,255,255,255,255,255,221,219,218,218,218,218,218,218,217,255,255,255,255],
  [255,255,255,216,218,218,218,218,218,218,218,218,219,255,255,255,255,255,255,219,218,218,218,218,218,218,218,218,216,255,255,255],
  [255,255,255,218,218,218,218,218,218,218,218,218,218,219,255,255,255,255,219,218,218,218,218,218,218,218,218,218,218,255,255,255],
  [255,255,215,218,218,218,218,218,218,218,218,218,218,218,255,255,255,255,218,218,218,218,218,218,218,218,218,218,218,215,255,255],
  [255,255,217,218,218,218,218,218,218,218,218,218,218,218,255,255,255,255,218,218,218,218,218,218,218,218,218,218,218,217,255,255],
  [255,255,217,218,218,218,218,218,218,218,218,218,218,218,255,255,255,255,218,218,218,218,218,218,218,218,218,218,218,217,255,255],
  [255,255,223,218,218,218,218,218,218,218,218,218,218,219,255,255,255,255,219,218,218,218,218,218,218,218,218,218,218,223,255,255],
  [255,255,255,219,218,218,218,218,218,218,218,218,218,217,255,255,255,255,217,218,218,218,218,218,218,218,218,218,219,255,255,255],
  [255,255,255,213,218,218,218,218,218,218,218,218,217,255,255,255,255,255,255,217,218,218,218,218,218,218,218,218,213,255,255,255],
  [255,255,255,255,213,219,218,218,218,218,218,216,255,255,255,255,255,255,255,255,216,218,218,218,218,218,219,213,255,255,255,255],
  [255,255,255,255,255,255,223,217,217,215,255,255,255,255,255,255,255,255,255,255,255,255,215,217,217,223,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
 ],
 [
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255, 32, 30, 32, 34,  0,255,255,255,255,255,255,255,255,255,255,  0, 34, 32, 30, 32,255,255,255,255,255,255],
  [255,255,255,255, 43, 31, 32, 32, 32, 32, 31, 30,255,255,255,255,255,255,255,255, 30, 31, 32, 32, 32, 32, 31, 43,255,255,255,255],
  [255,255,255, 43, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 43,255,255,255],
  [255,255,255, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 28,255,255,255,255, 28, 32, 32, 32, 32, 32, 32, 32, 32, 32, 31,255,255,255],
  [255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255],
  [255,255, 30, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 31,255,255,255,255, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 30,255,255],
  [255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255],
  [255,255, 34, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 34,255,255],
  [255,255,  0, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33,255,255,255,255, 33, 32, 32, 32, 32, 32, 32, 32, 32, 32, 31,  0,255,255],
  [255,255,255, 30, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 30,255,255,255],
  [255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 34,255,255,255,255,255,255, 34, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255],
  [255,255,255,255,255, 28, 32, 31, 32, 32, 33,255,255,255,255,255,255,255,255,255,255, 33, 32, 32, 31, 32, 28,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255, 28, 32, 31, 32, 32, 33,255,255,255,255,255,255,255,255,255,255, 33, 32, 32, 31, 32, 28,255,255,255,255,255],
  [255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 34,255,255,255,255,255,255, 34, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255],
  [255,255,255, 30, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 30,255,255,255],
  [255,255,  0, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33,255,255,255,255, 33, 32, 32, 32, 32, 32, 32, 32, 32, 32, 31,  0,255,255],
  [255,255, 34, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 34,255,255],
  [255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255],
  [255,255, 30, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 31,255,255,255,255, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 30,255,255],
  [255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255],
  [255,255,255, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 28,255,255,255,255, 28, 32, 32, 32, 32, 32, 32, 32, 32, 32, 31,255,255,255],
  [255,255,255, 43, 32, 32, 32, 32, 32, 32, 32, 32, 32,255,255,255,255,255,255, 32, 32, 32, 32, 32, 32, 32, 32, 32, 43,255,255,255],
  [255,255,255,255, 43, 31, 32, 32, 32, 32, 31, 30,255,255,255,255,255,255,255,255, 30, 31, 32, 32, 32, 32, 31, 43,255,255,255,255],
  [255,255,255,255,255,255, 32, 30, 32, 34,  0,255,255,255,255,255,255,255,255,255,255,  0, 34, 32, 30, 32,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
 ],
 [
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255, 48, 53, 56, 54,  0,255,255,255,255,255,255,255,255,255,255,  0, 54, 56, 53, 48,255,255,255,255,255,255],
  [255,255,255,255, 64, 55, 55, 55, 55, 55, 55, 56,255,255,255,255,255,255,255,255, 56, 55, 55, 55, 55, 55, 55, 64,255,255,255,255],
  [255,255,255, 64, 55, 55, 55, 55, 55, 55, 55, 55, 55,255,255,255,255,255,255, 55, 55, 55, 55, 55, 55, 55, 55, 55, 64,255,255,255],
  [255,255,255, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 57,255,255,255,255, 57, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,255,255,255],
  [255,255, 48, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 54,255,255,255,255, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 48,255,255],
  [255,255, 53, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56,255,255,255,255, 56, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 53,255,255],
  [255,255, 56, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,255,255,255,255, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56,255,255],
  [255,255, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 54,255,255,255,255, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 54,255,255],
  [255,255,  0, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56,255,255,255,255, 56, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,  0,255,255],
  [255,255,255, 56, 55, 55, 55, 55, 55, 55, 55, 55, 55,255,255,255,255,255,255, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56,255,255,255],
  [255,255,255,255, 55, 55, 55, 55, 55, 55, 55, 55, 51,255,255,255,255,255,255, 51, 55, 55, 55, 55, 55, 55, 55, 55,255,255,255,255],
  [255,255,255,255,255, 57, 54, 56, 55, 54, 56,255,255,255,255,255,255,255,255,255,255, 56, 54, 55, 56, 54, 57,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255, 57, 54, 56, 55, 54, 56,255,255,255,255,255,255,255,255,255,255, 56, 54, 55, 56, 54, 57,255,255,255,255,255],
  [255,255,255,255, 55, 55, 55, 55, 55, 55, 55, 55, 51,255,255,255,255,255,255, 51, 55, 55, 55, 55, 55, 55, 55, 55,255,255,255,255],
  [255,255,255, 56, 55, 55, 55, 55, 55, 55, 55, 55, 55,255,255,255,255,255,255, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56,255,255,255],
  [255,255,  0, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56,255,255,255,255, 56, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,  0,255,255],
  [255,255, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 54,255,255,255,255, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 54,255,255],
  [255,255, 56, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,255,255,255,255, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56,255,255],
  [255,255, 53, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56,255,255,255,255, 56, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 53,255,255],
  [255,255, 48, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 54,255,255,255,255, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 48,255,255],
  [255,255,255, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 57,255,255,255,255, 57, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,255,255,255],
  [255,255,255, 64, 55, 55, 55, 55, 55, 55, 55, 55, 55,255,255,255,255,255,255, 55, 55, 55, 55, 55, 55, 55, 55, 55, 64,255,255,255],
  [255,255,255,255, 64, 55, 55, 55, 55, 55, 55, 56,255,255,255,255,255,255,255,255, 56, 55, 55, 55, 55, 55, 55, 64,255,255,255,255],
  [255,255,255,255,255,255, 48, 53, 56, 54,  0,255,255,255,255,255,255,255,255,255,255,  0, 54, 56, 53, 48,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
  [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255],
 ],
 [
  [  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0],
  [  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0],
  [  0,  0,  0,  0,  0,  0, 16, 67, 87, 38,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1, 38, 87, 67, 16,  0,  0,  0,  0,  0,  0],
  [  0,  0,  0,  0, 12,154,255,255,255,255,219, 59,  0,  0,  0,  0,  0,  0,  0,  0, 59,219,255,255,255,255,154, 12,  0,  0,  0,  0],
  [  0,  0,  0, 12,216,255,255,255,255,255,255,253, 88,  0,  0,  0,  0,  0,  0, 88,253,255,255,255,255,255,255,216, 12,  0,  0,  0],
  [  0,  0,  0,154,255,255,255,255,255,255,255,255,239, 27,  0,  0,  0,  0, 27,239,255,255,255,255,255,255,255,255,154,  0,  0,  0],
  [  0,  0, 16,255,255,255,255,255,255,255,255,255,255,127,  0,  0,  0,  0,127,255,255,255,255,255,255,255,255,255,255, 16,  0,  0],
  [  0,  0, 67,255,255,255,255,255,255,255,255,255,255,179,  0,  0,  0,  0,179,255,255,255,255,255,255,255,255,255,255, 67,  0,  0],
  [  0,  0, 87,255,255,255,255,255,255,255,255,255,255,199,  0,  0,  0,  0,199,255,255,255,255,255,255,255,255,255,255, 87,  0,  0],
  [  0,  0, 38,255,255,255,255,255,255,255,255,255,255,150,  0,  0,  0,  0,150,255,255,255,255,255,255,255,255,255,255, 38,  0,  0],
  [  0,  0,  1,219,255,255,255,255,255,255,255,255,255, 77,  0,  0,  0,  0, 77,255,255,255,255,255,255,255,255,255,219,  1,  0,  0],
  [  0,  0,  0, 59,253,255,255,255,255,255,255,255,168,  0,  0,  0,  0,  0,  0,168,255,255,255,255,255,255,255,253, 59,  0,  0,  0],
  [  0,  0,  0,  0, 88,239,255,255,255,255,255,168, 15,  0,  0,  0,  0,  0,  0, 15,168,255,255,255,255,255,239, 88,  0,  0,  0,  0],
  [  0,  0,  0,  0,  0, 27,127,179,199,150, 77,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 77,150,199,179,127, 27,  0,  0,  0,  0,  0],
  [  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0],
  [  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0],
  [  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0],
  [  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0],
  [  0,  0,  0,  0,  0, 27,127,179,199,150, 77,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 77,150,199,179,127, 27,  0,  0,  0,  0,  0],
  [  0,  0,  0,  0, 88,239,255,255,255,255,255,168, 15,  0,  0,  0,  0,  0,  0, 15,168,255,255,255,255,255,239, 88,  0,  0,  0,  0],
  [  0,  0,  0, 59,253,255,255,255,255,255,255,255,168,  0,  0,  0,  0,  0,  0,168,255,255,255,255,255,255,255,253, 59,  0,  0,  0],
  [  0,  0,  1,219,255,255,255,255,255,255,255,255,255, 77,  0,  0,  0,  0, 77,255,255,255,255,255,255,255,255,255,219,  1,  0,  0],
  [  0,  0, 38,255,255,255,255,255,255,255,255,255,255,150,  0,  0,  0,  0,150,255,255,255,255,255,255,255,255,255,255, 38,  0,  0],
  [  0,  0, 87,255,255,255,255,255,255,255,255,255,255,199,  0,  0,  0,  0,199,255,255,255,255,255,255,255,255,255,255, 87,  0,  0],
  [  0,  0, 67,255,255,255,255,255,255,255,255,255,255,179,  0,  0,  0,  0,179,255,255,255,255,255,255,255,255,255,255, 67,  0,  0],
  [  0,  0, 16,255,255,255,255,255,255,255,255,255,255,127,  0,  0,  0,  0,127,255,255,255,255,255,255,255,255,255,255, 16,  0,  0],
  [  0,  0,  0,154,255,255,255,255,255,255,255,255,239, 27,  0,  0,  0,  0, 27,239,255,255,255,255,255,255,255,255,154,  0,  0,  0],
  [  0,  0,  0, 12,216,255,255,255,255,255,255,253, 88,  0,  0,  0,  0,  0,  0, 88,253,255,255,255,255,255,255,216, 12,  0,  0,  0],
  [  0,  0,  0,  0, 12,154,255,255,255,255,219, 59,  0,  0,  0,  0,  0,  0,  0,  0, 59,219,255,255,255,255,154, 12,  0,  0,  0,  0],
  [  0,  0,  0,  0,  0,  0, 16, 67, 87, 38,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1, 38, 87, 67, 16,  0,  0,  0,  0,  0,  0],
  [  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0],
  [  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0],
 ],
];

for my $pg (0..3) {
  my $pimage = PDL::IO::Image->new_from_file('t/mutli-page/metacpan.ico', 'AUTO', 0, $pg);
  is($pimage->get_image_type , "BITMAP", "get_image_type");
}

{
  my $pimage = PDL::IO::Image->new_from_file('t/mutli-page/metacpan.ico', 'AUTO', 0, 2);
  is($pimage->get_color_type , "RGBALPHA", "get_color_type");
  is($pimage->get_colors_used,  0, "get_colors_used");
  is($pimage->get_width      , 32, "get_width");
  is($pimage->get_height     , 32, "get_height");
  is($pimage->get_bpp        , 32, "get_bpp");
  my $pix = $pimage->pixels_to_pdl;
  is($pix->info, 'PDL: Byte D [32,32,4]', "info");
  delta_ok($pix->double->sum, 662796, "sum");
  delta_ok($pix->unpdl, $expected_page2, "pixels");
}

done_testing();