package JIRA::API::FieldReferenceData 0.01;
# DO NOT EDIT! This is an autogenerated file.
use 5.020;
use Moo 2;
use experimental 'signatures';
use Types::Standard qw(Str Bool Num Int Object ArrayRef);
use MooX::TypeTiny;

=head1 NAME

JIRA::API::FieldReferenceData -

=head1 SYNOPSIS

  my $obj = JIRA::API::FieldReferenceData->new();
  ...

=cut

sub as_hash( $self ) {
    return { $self->%* }
}

=head1 PROPERTIES

=head2 C<< auto >>

Whether the field provide auto-complete suggestions.

=cut

has 'auto' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< cfid >>

If the item is a custom field, the ID of the custom field.

=cut

has 'cfid' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< deprecated >>

Whether this field has been deprecated.

=cut

has 'deprecated' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< deprecatedSearcherKey >>

The searcher key of the field, only passed when the field is deprecated.

=cut

has 'deprecatedSearcherKey' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< displayName >>

The display name contains the following:

 *  for system fields, the field name. For example, `Summary`.
 *  for collapsed custom fields, the field name followed by a hyphen and then the field name and field type. For example, `Component - Component[Dropdown]`.
 *  for other custom fields, the field name followed by a hyphen and then the custom field ID. For example, `Component - cf[10061]`.

=cut

has 'displayName' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< operators >>

The valid search operators for the field.

=cut

has 'operators' => (
    is       => 'ro',
    isa      => ArrayRef[Str],
);

=head2 C<< orderable >>

Whether the field can be used in a query's `ORDER BY` clause.

=cut

has 'orderable' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< searchable >>

Whether the content of this field can be searched.

=cut

has 'searchable' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< types >>

The data types of items in the field.

=cut

has 'types' => (
    is       => 'ro',
    isa      => ArrayRef[Str],
);

=head2 C<< value >>

The field identifier.

=cut

has 'value' => (
    is       => 'ro',
    isa      => Str,
);


1;
