# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20231210185942;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{de} = {"433536", "Sankt\ Peter\ am\ Kammersberg",
"436477", "Sankt\ Michael\ im\ Lungau",
"436277", "Sankt\ Pantaleon",
"433834", "Wald\ am\ Schoberpaß",
"434876", "Kals\ am\ Großglockner",
"432815", "Großschönau",
"433386", "Großsteinbach",
"433119", "Sankt\ Marein\ bei\ Graz",
"433575", "Sankt\ Johann\ am\ Tauern",
"432686", "Draßburg",
"437254", "Großraming",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"434264", "Klein\ Sankt\ Paul",
"435245", "Hinterriß",
"4317", "Wien",
"435352", "Sankt\ Johann\ in\ Tirol",
"432263", "Großrußbach",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"433362", "Großpetersdorf",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"432674", "Weißenbach\ an\ der\ Triesting",
"432719", "Droß",
"437956", "Unterweißenbach",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"437219", "Vorderweißenbach",
"434358", "Sankt\ Andrä",
"433632", "Sankt\ Gallen",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"434785", "Außerfragant",
"436565", "Neukirchen\ am\ Großvenediger",
"4318", "Wien",
"433464", "Groß\ Sankt\ Florian",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"432822", "Zwettl\-Niederösterreich",
"437751", "Sankt\ Martin\ im\ Innkreis",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"436412", "Sankt\ Johann\ im\ Pongau",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"432556", "Großkrut",
"432642", "Aspangberg\-Sankt\ Peter",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"434783", "Reißeck",
"432857", "Bad\ Großpertholz",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"436227", "Sankt\ Gilgen",
"432629", "Warth\,\ Niederösterreich",
"4314", "Wien",
"433864", "Sankt\ Marein\ im\ Mürztal",
"433327", "Sankt\ Michael\ im\ Burgenland",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"435449", "Fließ",
"4312", "Wien",
"437717", "Sankt\ Aegidi",
"434843", "Außervillgraten",
"433469", "Sankt\ Oswald\ im\ Freiland",
"432249", "Groß\-Enzersdorf",
"437566", "Rosenau\ am\ Hengstpaß",
"432847", "Groß\-Siegharts",
"432618", "Markt\ Sankt\ Martin",
"434226", "Sankt\ Margareten\ im\ Rosental",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"432233", "Preßbaum",
"434253", "Sankt\ Jakob\ im\ Rosental",
"437435", "Sankt\ Valentin",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"436247", "Großgmain",
"435557", "Sankt\ Gallenkirch",
"433868", "Tragöß",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"4316", "Wien",
"4319", "Wien",
"432823", "Großglobnitz",
"4315", "Wien",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"435446", "Sankt\ Anton\ am\ Arlberg",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"432617", "Draßmarkt",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"432812", "Groß\ Gerungs",
"436241", "Sankt\ Koloman",
"432647", "Krumbach\,\ Niederösterreich",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"437477", "Sankt\ Peter\ in\ der\ Au",
"437667", "Sankt\ Georgen\ im\ Attergau",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"433684", "Sankt\ Martin\ am\ Grimming",
"436414", "Großarl",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"432242", "Sankt\ Andrä\-Wördern",
"434266", "Straßburg",
"432742", "Sankt\ Pölten",
"434286", "Weißbriach",
"435678", "Weißenbach\ am\ Lech",
"432268", "Großmugl",
"432955", "Großweikersdorf",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"433158", "Sankt\ Anna\ am\ Aigen",
"434877", "Prägraten\ am\ Großvenediger",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"434825", "Großkirchheim",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"433537", "Sankt\ Georgen\ ob\ Murau",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"432756", "Sankt\ Leonhard\ am\ Forst",
"436276", "Nußdorf\ am\ Haunsberg",
"436215", "Straßwalchen",
"435279", "Sankt\ Jodok\ am\ Brenner",
"433585", "Sankt\ Lambrecht",
"437565", "Sankt\ Pankraz",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"434879", "Sankt\ Veit\ in\ Defereggen",
"437218", "Großtraberg",
"437224", "Sankt\ Florian",
"437954", "Sankt\ Georgen\ am\ Walde",
"4313", "Wien",};
$areanames{en} = {"433858", "Mitterdorf\ im\ Mürztal",
"433537", "St\.\ Georgen\ ob\ Murau",
"435262", "Telfs",
"435672", "Reutte",
"437619", "Kirchham",
"434718", "Dellach",
"437355", "Weyer",
"432748", "Kilb",
"437442", "Waidhofen\ an\ der\ Ybbs",
"436476", "St\.\ Margarethen\ im\ Lungau",
"437242", "Wels",
"436276", "Nussdorf\ am\ Haunsberg",
"433112", "Gleisdorf",
"437230", "Altenberg\ bei\ Linz",
"434736", "Innerkrems",
"436245", "Hallein",
"433150", "Paldau",
"432756", "St\.\ Leonhard\ am\ Forst",
"433846", "Kalwang",
"435578", "Höchst",
"435282", "Zell\ am\ Ziller",
"434874", "Virgen",
"434357", "St\.\ Paul\ im\ Lavanttal",
"435334", "Westendorf",
"433364", "Hannersdorf",
"437240", "Sipbachzell",
"433513", "Bischoffeld",
"432716", "Gföhl",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"436235", "Thalgau",
"434279", "Sirnitz",
"433619", "Oppenberg",
"433152", "Feldbach",
"434877", "Prägraten\ am\ Grossvenediger",
"436463", "Annaberg\-Lungötz",
"434354", "Preitenegg",
"433355", "Stadtschlaining",
"437229", "Traun",
"435337", "Brixlegg",
"435280", "Hochfügen",
"432723", "Rabenstein\ an\ der\ Pielach",
"432282", "Gänserndorf",
"432262", "Korneuburg",
"432555", "Herrnbaumgarten",
"435515", "Au",
"434825", "Grosskirchheim",
"433387", "Söchau",
"436483", "Göriach",
"433534", "Stadl\ an\ der\ Mur",
"437221", "Hörsching",
"432672", "Berndorf",
"433611", "Johnsbach",
"432873", "Kottes",
"432738", "Fels\ am\ Wagram",
"437432", "Strengberg",
"435353", "Waidring",
"434271", "Steuerberg",
"435474", "Pfunds",
"432687", "Siegendorf",
"437223", "Enns",
"432955", "Grossweikersdorf",
"437953", "Liebenau",
"432268", "Grossmugl",
"433456", "Fresing",
"434273", "Reifnitz",
"433146", "Modriach",
"437216", "Helfenberg",
"432732", "Krems\ an\ der\ Donau",
"434710", "Oberdrauburg",
"433175", "Anger",
"432166", "Parndorf",
"433613", "Admont",
"433158", "St\.\ Anna\ am\ Aigen",
"437416", "Wieselburg",
"433127", "Peggau",
"435359", "Hochfilzen",
"437944", "Sandl",
"437238", "Mauthausen",
"432288", "Auersthal",
"432572", "Mistelbach",
"433634", "Hieflau",
"432277", "Zwentendorf",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"437762", "Raab",
"432667", "Schwarzau\ im\ Gebirge",
"435274", "Gries\ am\ Brenner",
"436461", "Dienten\ am\ Hochkönig",
"437947", "Kefermarkt",
"437248", "Grieskirchen",
"433124", "Gratkorn",
"433118", "Sinabelkirchen",
"432984", "Eggenburg",
"432615", "Lutzmannsburg",
"432173", "Gols",
"435288", "Fügen",
"435572", "Dornbirn",
"432664", "Semmering",
"432274", "Sieghartskirchen",
"433637", "Gams\ bei\ Hieflau",
"437613", "Laakirchen",
"434266", "Strassburg",
"434286", "Weissbriach",
"435678", "Weissenbach\ am\ Lech",
"432684", "Schützen\ am\ Gebirge",
"435477", "Tösens",
"432915", "Drosendorf\-Zissersdorf",
"433852", "Mürzzuschlag",
"435225", "Fulpmes",
"436566", "Bramberg\ am\ Wildkogel",
"437448", "Kematen\ an\ der\ Ybbs",
"437256", "Ternberg",
"432742", "St\.\ Pölten",
"433136", "Dobl",
"434712", "Greifenburg",
"435635", "Elmen",
"432645", "Wiesmath",
"433614", "Rottenmann",
"434274", "Velden\ am\ Wörther\ See",
"432266", "Stockerau",
"436470", "Atzmannsdorf",
"437954", "St\.\ Georgen\ am\ Walde",
"433148", "Kainach\ bei\ Voitsberg",
"435473", "Nauders",
"437224", "St\.\ Florian",
"437218", "Grosstraberg",
"434359", "Reichenfels",
"432168", "Mannersdorf\ am\ Leithagebirge",
"432177", "Podersdorf\ am\ See",
"435273", "Matrei\ am\ Brenner",
"437617", "Traunkirchen",
"433633", "Landl",
"437236", "Pregarten",
"4313", "Vienna",
"432712", "Aggsbach",
"432286", "Obersiebenbrunn",
"433475", "Hürth",
"437943", "Windhaag\ bei\ Freistadt",
"433832", "Kraubath\ an\ der\ Mur",
"432945", "Zellerndorf",
"433685", "Gröbming",
"432752", "Melk",
"432273", "Tulbing",
"437614", "Vorchdorf",
"437665", "Unterach\ am\ Attersee",
"432983", "Sigmundsherberg",
"434732", "Gmünd\ in\ Kärnten",
"435331", "Brandenberg",
"432174", "Wallern\ im\ Burgenland",
"436272", "Oberndorf\ bei\ Salzburg",
"437246", "Gunskirchen",
"436588", "Lofer",
"433116", "Kirchbach\ in\ Steiermark",
"432663", "Schottwien",
"432862", "Heidenreichstein",
"435286", "Ginzling",
"433842", "Leoben",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"434225", "Grafenstein",
"434268", "Friesach",
"434277", "Glanegg",
"435676", "Jungholz",
"432635", "Neunkirchen",
"435266", "Ötztal\-Bahnhof",
"433617", "Gaishorn\ am\ See",
"432683", "Purbach\ am\ Neusiedler\ See",
"435339", "Wildschönau",
"436472", "Mauterndorf",
"437227", "Neuhofen\ an\ der\ Krems",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"437258", "Bad\ Hall",
"434879", "St\.\ Veit\ in\ Defereggen",
"433856", "Veitsch",
"432877", "Grainbrunn",
"435357", "Kirchberg\ in\ Tirol",
"433335", "Pöllau",
"434282", "Hermagor",
"434716", "Lesachtal",
"432160", "Jois",
"432746", "Wilhelmsburg",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"432279", "Kirchberg\ am\ Wagram",
"433132", "Kumberg",
"437252", "Steyr",
"437565", "St\.\ Pankraz",
"433383", "Burgau",
"436478", "Zederhaus",
"436562", "Mittersill",
"432989", "Brunn\ an\ der\ Wild",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"436278", "Ostermiething",
"436455", "Untertauern",
"434873", "St\.\ Jakob\ in\ Defereggen",
"436467", "Mühlbach\ am\ Hochkönig",
"435333", "Söll",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"432689", "Hornstein",
"433363", "Rechnitz",
"432758", "Pöggstall",
"432271", "Ried\ am\ Riederberg",
"434262", "Treibach",
"435576", "Hohenems",
"433848", "Eisenerz",
"432535", "Hohenau\ an\ der\ March",
"432825", "Göpfritz\ an\ der\ Wild",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"432718", "Lichtenau\ im\ Waldviertel",
"433631", "Unterlaussa",
"437412", "Ybbs\ an\ der\ Donau",
"435583", "Lech",
"434353", "Prebl",
"436415", "Schwarzach\ im\ Pongau",
"436135", "Bad\ Goisern",
"437766", "Andorf",
"437941", "Neumarkt\ im\ Mühlkreis",
"433514", "Seckau",
"432576", "Ernstbrunn",
"437949", "Rainbach\ im\ Mühlkreis",
"433452", "Leibnitz",
"433585", "St\.\ Lambrecht",
"435354", "Fieberbrunn",
"433622", "Bad\ Aussee",
"432874", "Martinsberg",
"436215", "Strasswalchen",
"435279", "St\.\ Jodok\ am\ Brenner",
"432162", "Bruck\ an\ der\ Leitha",
"436484", "Lessach",
"433533", "Turrach",
"433142", "Voitsberg",
"437212", "Zwettl\ an\ der\ Rodl",
"432736", "Paudorf",
"437250", "Maria\ Neustift",
"433581", "Oberwölz",
"437676", "Ottnang\ am\ Hausruck",
"432643", "Lichtenegg",
"437266", "Bad\ Kreuzen",
"433174", "Birkfeld",
"437486", "Lunz\ am\ See",
"435633", "Hägerau",
"432954", "Göllersdorf",
"435522", "Feldkirch",
"435446", "St\.\ Anton\ am\ Arlberg",
"433862", "Bruck\ an\ der\ Mur",
"432842", "Waidhofen\ an\ der\ Thaya",
"435475", "Feichten",
"434248", "Treffen",
"434256", "Nötsch\ im\ Gailtal",
"437750", "Andrichsfurt",
"433635", "Radmer",
"435275", "Trins",
"437712", "Schärding",
"436219", "Obertrum\ am\ See",
"432236", "Mödling",
"435246", "Achenkirch",
"433882", "Mariazell",
"432617", "Drassmarkt",
"432943", "Obritz",
"433683", "Donnersbach",
"437286", "Lembach\ im\ Mühlkreis",
"436131", "Obertraun",
"436548", "Niedernsill",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"43512", "Innsbruck",
"433473", "Straden",
"433322", "Güssing",
"432665", "Prein\ an\ der\ Rax",
"437752", "Ried\ im\ Innkreis",
"435418", "Schönwies",
"432985", "Gars\ am\ Kamp",
"432614", "Kleinwarasdorf",
"432628", "Felixdorf",
"437273", "Aschach\ an\ der\ Donau",
"432246", "Gerasdorf\ bei\ Wien",
"437663", "Steinbach\ am\ Attersee",
"435236", "Gries\ im\ Sellrain",
"432275", "Atzenbrugg",
"434782", "Obervellach",
"434223", "Maria\ Saal",
"433339", "Friedberg",
"4315", "Vienna",
"433125", "Übelbach",
"432829", "Schweiggers",
"433177", "Puch\ bei\ Weiz",
"432633", "Markt\ Piesting",
"434762", "Spittal\ an\ der\ Drau",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"433466", "Eibiswald",
"432258", "Alland",
"432522", "Laa\ an\ der\ Thaya",
"437683", "Frankenburg\ am\ Hausruck",
"434238", "Eisenkappel\-Vellach",
"432957", "Hohenwarth",
"437473", "Blindenmarkt",
"435224", "Wattens",
"432685", "Rust",
"432914", "Japons",
"434852", "Lienz",
"434768", "Kleblach\-Lind",
"433333", "Sebersdorf",
"434229", "Krumpendorf\ am\ Wörther\ See",
"4316", "Vienna",
"432631", "Pöttsching",
"433182", "Wildon",
"437279", "Haibach\ ob\ der\ Donau",
"437746", "Friedburg",
"435554", "Sonntag",
"434858", "Nikolsdorf",
"437471", "Neustadtl\ an\ der\ Donau",
"437563", "Spital\ am\ Pyhrn",
"433385", "Ilz",
"434232", "Völkermarkt",
"435517", "Riezlern",
"434240", "Bad\ Kleinkirchheim",
"435212", "Seefeld\ in\ Tirol",
"433576", "Bretstein",
"432252", "Baden",
"432773", "Eichgraben",
"432557", "Bernhardsthal",
"433357", "Pinkafeld",
"437758", "Obernberg\ am\ Inn",
"435412", "Imst",
"435335", "Hopfgarten\ im\ Brixental",
"437583", "Kremsmünster",
"432622", "Wiener\ Neustadt",
"434846", "Abfaltersbach",
"433365", "Deutsch\ Schützen\-Eisenberg",
"436453", "Filzmoos",
"434875", "Matrei\ in\ Osttirol",
"437479", "Ardagger",
"437727", "Ach",
"433328", "Kukmirn",
"432816", "Karlstift",
"436244", "Golling\ an\ der\ Salzach",
"432533", "Neusiedl\ an\ der\ Zaya",
"432142", "Gattendorf",
"432823", "Grossglobnitz",
"434221", "Gallizien",
"432639", "Bad\ Fischau",
"4319", "Vienna",
"433354", "Bernstein",
"432856", "Weitra",
"436413", "Wagrain",
"435585", "Dalaas",
"437724", "Mauerkirchen",
"434355", "Gemmersdorf",
"437718", "Waldkirchen\ am\ Wesen",
"432620", "Willendorf",
"435376", "Thiersee",
"436234", "Zell\ am\ Moos",
"432766", "Kleinzell",
"436133", "Ebensee",
"436542", "Zell\ am\ See",
"436247", "Grossgmain",
"432649", "Mönichkirchen",
"436226", "Fuschl\ am\ See",
"432641", "Kirchberg\ am\ Wechsel",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"432949", "Niederfladnitz",
"43662", "Salzburg",
"432786", "Oberwölbling",
"437357", "Kleinreifling",
"433583", "Unzmarkt",
"436434", "Bad\ Gastein",
"437736", "Pram",
"432212", "Orth\ an\ der\ Donau",
"434230", "Globasnitz",
"432554", "Stützenhofen",
"434242", "Villach",
"435252", "Oetz",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"433535", "Krakaudorf",
"435557", "St\.\ Gallenkirch",
"435514", "Bezau",
"434824", "Heiligenblut",
"436213", "Oberhofen\ am\ Irrsee",
"433868", "Tragöss",
"434766", "Millstatt",
"437260", "Waldhausen",
"432774", "Innermanzing",
"437480", "Langau\,\ Gaming",
"432619", "Lackendorf",
"435553", "Raggal",
"436217", "Mattsee",
"437564", "Hinterstoder",
"437748", "Eggelsberg",
"432526", "Stronsdorf",
"433334", "Kaindorf",
"437353", "Gaflenz",
"433462", "Deutschlandsberg",
"433578", "Obdach",
"433587", "Schönberg\-Lachtal",
"434212", "St\.\ Veit\ an\ der\ Glan",
"435232", "Kematen\ in\ Tirol",
"432242", "St\.\ Andrä\-Wördern",
"432230", "Schwadorf",
"436137", "Strobl",
"434848", "Kartitsch",
"436243", "Abtenau",
"432534", "Niedersulz",
"433326", "Stegersbach",
"432824", "Allentsteig",
"436417", "Hüttschlag",
"437584", "Molln",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"436454", "Mandling",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"436134", "Hallstatt",
"433886", "Weichselboden",
"435242", "Schwaz",
"432858", "Moorbad\ Harbach",
"435230", "Sellrain",
"433179", "Passail",
"432827", "Schönbach",
"432232", "Fischamend",
"437716", "Münzkirchen",
"436233", "Oberwang",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"434252", "Wernberg",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"432725", "Frankenfels",
"433353", "Oberschützen",
"437282", "Neufelden",
"437587", "Wartberg\ an\ der\ Krems",
"436414", "Grossarl",
"436457", "Flachau",
"432959", "Sitzendorf\ an\ der\ Schmida",
"437723", "Altheim",
"435513", "Hittisau",
"436228", "Faistenau",
"434823", "Tresdorf\,\ Rangersdorf",
"436214", "Henndorf\ am\ Wallersee",
"432951", "Guntersdorf",
"437482", "Scheibbs",
"437262", "Perg",
"437672", "Vöcklabruck",
"435355", "Jochberg",
"433337", "Vorau",
"436433", "Dorfgastein",
"433584", "Neumarkt\ in\ Steiermark",
"432846", "Raabs\ an\ der\ Thaya",
"433460", "Soboth",
"435526", "Laterns",
"433866", "Breitenau\ am\ Hochlantsch",
"435442", "Landeck",
"433171", "Gasen",
"432875", "Grafenschlag",
"437955", "Königswiesen",
"432782", "Herzogenburg",
"437477", "St\.\ Peter\ in\ der\ Au",
"437729", "Neukirchen\ an\ der\ Enknach",
"432953", "Nappersdorf",
"437268", "Grein",
"437488", "Steinakirchen\ am\ Forst",
"437225", "Hargelsberg",
"433359", "Loipersdorf\-Kitzladen",
"432644", "Grimmenstein",
"433173", "Ratten",
"435448", "Pettneu\ am\ Arlberg",
"433615", "Trieben",
"435256", "Untergurgl",
"435634", "Elbigenalp",
"434246", "Radenthein",
"432637", "Grünbach\ am\ Schneeberg",
"434275", "Ebene\ Reichenau",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"437732", "Haag\ am\ Hausruck",
"434258", "Gummern",
"435372", "Kufstein",
"434227", "Ferlach",
"433474", "Deutsch\ Goritz",
"432944", "Haugsdorf",
"433684", "St\.\ Martin\ am\ Grimming",
"432238", "Kaltenleutgeben",
"435248", "Steinberg\ am\ Rofan",
"432852", "Gmünd",
"435519", "Schröcken",
"437288", "Ulrichsberg",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"437277", "Waizenkirchen",
"437667", "St\.\ Georgen\ im\ Attergau",
"432762", "Lilienfeld",
"433687", "Schladming",
"432947", "Theras",
"432812", "Gross\ Gerungs",
"436241", "St\.\ Koloman",
"432626", "Mattersburg",
"434842", "Sillian",
"432248", "Markgrafneusiedl",
"434224", "Pischeldorf",
"433477", "St\.\ Peter\ am\ Ottersbach",
"435238", "Zirl",
"437664", "Weyregg\ am\ Attersee",
"437615", "Scharnstein",
"432146", "Nickelsdorf",
"435559", "Brand",
"432613", "Deutschkreutz",
"432175", "Apetlon",
"437274", "Alkoven",
"437474", "Euratsfeld",
"435223", "Hall\ in\ Tirol",
"432913", "Hötzelsdorf",
"437684", "Frankenmarkt",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"433572", "Judenburg",
"432256", "Leobersdorf",
"432634", "Gutenstein",
"434236", "Eberndorf",
"432647", "Krumbach\,\ Lower\ Austria",
"437742", "Mattighofen",
"432259", "Münchendorf",
"437662", "Seewalchen\ am\ Attersee",
"43732", "Linz",
"432767", "Hohenberg",
"432755", "Mank",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"433323", "Eberau",
"436458", "Hüttau",
"436246", "Grödig",
"437588", "Ried\ im\ Traunkreis",
"432621", "Sieggraben",
"437272", "Eferding",
"437753", "Eberschwang",
"434735", "Kremsbrücke",
"432814", "Langschlag",
"432828", "Rappottenstein",
"432538", "Velm\-Götzendorf",
"433845", "Mautern\ in\ Steiermark",
"432865", "Litschau",
"432857", "Bad\ Grosspertholz",
"434783", "Reisseck",
"433680", "Donnersbachwald",
"432632", "Pernitz",
"433574", "Pusterwald",
"433338", "Lafnitz",
"435556", "Schruns",
"437744", "Munderfing",
"434231", "Mittertrixen",
"436227", "St\.\ Gilgen",
"437472", "Amstetten",
"434853", "Ainet",
"436475", "Ramingstein",
"432629", "Warth\,\ Lower\ Austria",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"437682", "Vöcklamarkt",
"432630", "Ternitz",
"434826", "Mörtschach",
"432642", "Aspangberg\-St\.\ Peter",
"435516", "Doren",
"435632", "Stanzach",
"436549", "Piesendorf",
"437747", "Kirchberg\ bei\ Mattighofen",
"433588", "Katsch\ an\ der\ Mur",
"432556", "Grosskrut",
"433577", "Zeltweg",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"432784", "Perschling",
"433863", "Turnau",
"436224", "Hintersee",
"435523", "Götzis",
"432843", "Dobersberg",
"437713", "Schardenberg",
"436418", "Kleinarl",
"433883", "Terz",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"432764", "Hainfeld",
"435374", "Walchsee",
"433472", "Mureck",
"432942", "Retz",
"433682", "Stainach",
"434847", "Obertilliach",
"432854", "Kirchberg\ am\ Walde",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"436541", "Saalbach",
"433356", "Markt\ Allhau",
"434220", "Köttmannsdorf",
"432849", "Schwarzenau",
"436412", "St\.\ Johann\ im\ Pongau",
"437284", "Oberkappel",
"437711", "Suben",
"437415", "Altenmarkt\,\ Yspertal",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"436132", "Bad\ Ischl",
"436543", "Taxenbach",
"435244", "Jenbach",
"432234", "Gramatneusiedl",
"433688", "Tauplitz",
"432948", "Weitersfeld",
"434254", "Faak\ am\ See",
"432247", "Deutsch\-Wagram",
"433455", "Arnfels",
"433582", "Scheifling",
"433467", "Schwanberg",
"435444", "Ischgl",
"432956", "Ziersdorf",
"432648", "Hochneukirchen",
"437215", "Hellmonsödt",
"43316", "Graz",
"435253", "Längenfeld",
"432841", "Vitis",
"433145", "Edelschrott",
"437484", "Göstling\ an\ der\ Ybbs",
"432165", "Hainburg\ a\.d\.\ Donau",
"437264", "Windhaag\ bei\ Perg",
"433176", "Stubenberg",
"433861", "Aflenz",
"437719", "Taufkirchen\ an\ der\ Pram",
"436212", "Seekirchen\ am\ Wallersee",
"437674", "Attnang\-Puchheim",
"432213", "Lassee",
"434243", "Bodensdorf",
"432916", "Riegersburg\,\ Hardegg",
"435447", "Flirsch",
"435226", "Neustift\ im\ Stubaital",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"433332", "Hartberg",
"434285", "Tröpolach",
"434761", "Stockenboi",
"432638", "Winzendorf\-Muthmannsdorf",
"433464", "Gross\ St\.\ Florian",
"4318", "Vienna",
"433135", "Kalsdorf\ bei\ Graz",
"432772", "Neulengbach",
"432253", "Oberwaltersdorf",
"436565", "Neukirchen\ am\ Grossvenediger",
"437759", "Antiesenhofen",
"437267", "Mönchdorf",
"437487", "Gresten",
"435213", "Scharnitz",
"437562", "Windischgarsten",
"437255", "Losenstein",
"437478", "Oed\-Oehling",
"433329", "Jennersdorf",
"434233", "Griffen",
"437278", "Neukirchen\ am\ Walde",
"432623", "Pottendorf",
"437582", "Kirchdorf\ an\ der\ Krems",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"437751", "St\.\ Martin\ im\ Innkreis",
"437287", "Peilstein\ im\ Mühlviertel",
"436452", "Radstadt",
"435234", "Axams",
"434769", "Möllbrücke",
"434228", "Feistritz\ im\ Rosental",
"434214", "Brückl",
"434257", "Fürnitz",
"434265", "Weitensfeld\ im\ Gurktal",
"432244", "Langenzersdorf",
"432616", "Lockenhaus",
"432237", "Gaaden",
"432822", "Zwettl\,\ Lower\ Austria",
"432532", "Zistersdorf",
"432143", "Kittsee",
"436240", "Krispl",
"436232", "Mondsee",
"437235", "Gallneukirchen",
"434253", "St\.\ Jakob\ im\ Rosental",
"436544", "Rauris",
"435243", "Maurach",
"433155", "Fehring",
"432233", "Pressbaum",
"432147", "Zurndorf",
"432627", "Pitten",
"433352", "Oberwart",
"437283", "Sarleinsbach",
"435417", "Roppen",
"437722", "Braunau\ am\ Inn",
"436229", "Hof\ bei\ Salzburg",
"433686", "Haus",
"432946", "Pulkau",
"433476", "Bad\ Radkersburg",
"432285", "Marchegg",
"437673", "Schwanenstadt",
"435550", "Thüringen",
"432214", "Kopfstetten",
"432769", "Türnitz",
"432552", "Poysdorf",
"432265", "Hausleiten",
"434244", "Bad\ Bleiberg",
"432257", "Klausen\-Leopoldsdorf",
"435254", "Sölden",
"437483", "Oberndorf\ an\ der\ Melk",
"437263", "Bad\ Zell",
"435512", "Egg",
"434237", "Miklauzhof",
"436221", "Koppl",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"434822", "Winklern",
"432958", "Maissau",
"432859", "Brand\-Nagelberg",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"435443", "Galtür",
"437435", "St\.\ Valentin",
"436432", "Bad\ Hofgastein",
"435552", "Bludenz",
"435265", "Nassereith",
"435214", "Leutasch",
"434234", "Ruden",
"434247", "Afritz",
"435675", "Tannheim",
"432636", "Puchberg\ am\ Schneeberg",
"432254", "Ebreichsdorf",
"435510", "Damüls",
"433571", "Möderbrugg",
"433463", "Stainz",
"437445", "Hollenstein\ an\ der\ Ybbs",
"437476", "Aschbach\-Markt",
"433184", "Wolfsberg\ im\ Schwarzautal",
"437276", "Peuerbach",
"436242", "Russbach\ am\ Pass\ Gschütt",
"436547", "Kaprun",
"433115", "Studenzen",
"432144", "Deutsch\ Jahrndorf",
"437245", "Lambach",
"434213", "Launsdorf",
"433579", "Pöls",
"437666", "Attersee",
"432243", "Klosterneuburg",
"434226", "St\.\ Margareten\ im\ Rosental",
"432618", "Markt\ St\.\ Martin",
"432624", "Ebenfurth",
"435414", "Wenns",
"435285", "Mayrhofen",
"433469", "St\.\ Oswald\ im\ Freiland",
"434784", "Mallnitz",
"432813", "Arbesbach",
"436456", "Obertauern",
"437586", "Pettenbach",
"434843", "Ausservillgraten",
"432826", "Rastenfeld",
"437717", "St\.\ Aegidi",
"433324", "Strem",
"432536", "Drösing",
"435575", "Langen\ bei\ Bregenz",
"432612", "Oberpullendorf",
"437754", "Waldzell",
"433336", "Waldbach",
"432524", "Kautendorf",
"433867", "Pernegg\ an\ der\ Mur",
"433855", "Krieglach",
"432912", "Geras",
"435558", "Gaschurn",
"432847", "Gross\-Siegharts",
"437566", "Rosenau\ am\ Hengstpass",
"437743", "Maria\ Schmolln",
"432249", "Gross\-Enzersdorf",
"433170", "Fischbach",
"433573", "Fohnsdorf",
"433461", "Trahütten",
"434715", "Kötschach\-Mauthen",
"435239", "Kühtai",
"432745", "Pyhra",
"437261", "Schönau\ im\ Mühlkreis",
"433864", "St\.\ Marein\ im\ Mürztal",
"432952", "Hollabrunn",
"436223", "Anthering",
"435518", "Mellau",
"435524", "Satteins",
"437289", "Rohrbach\ in\ Oberösterreich",
"432844", "Karlstein\ an\ der\ Thaya",
"433586", "Mühlen",
"432783", "Traismauer",
"432527", "Wulzeshofen",
"437733", "Neumarkt\ im\ Hausruckkreis",
"434767", "Rothenthurn",
"435441", "See",
"433172", "Weiz",
"436216", "Neumarkt\ am\ Wallersee",
"432239", "Breitenfurt\ bei\ Wien",
"432735", "Hadersdorf\ am\ Kamp",
"4314", "Vienna",
"432231", "Purkersdorf",
"4312", "Vienna",
"435449", "Fliess",
"436416", "Lend",
"432853", "Schrems",
"435373", "Ebbs",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"432610", "Horitschon",
"432575", "Ladendorf",
"437728", "Schwand\ im\ Innkreis",
"433327", "St\.\ Michael\ im\ Burgenland",
"437714", "Esternberg",
"437269", "Baumgartenberg",
"437489", "Purgstall\ an\ der\ Erlauf",
"437765", "Lambrechten",
"436136", "Gosau",
"437757", "Gurten",
"437281", "Aigen\ im\ Mühlkreis",
"433884", "Wegscheid",
"433358", "Litzelsdorf",
"432235", "Maria\-Lanzendorf",
"435276", "Gschnitz",
"432739", "Tiefenfucha",
"433153", "Riegersburg",
"435245", "Hinterriss",
"437233", "Feldkirchen\ an\ der\ Donau",
"434255", "Arnoldstein",
"433512", "Knittelfeld",
"434267", "Metnitz",
"433636", "Wildalpen",
"432722", "Kirchberg\ an\ der\ Pielach",
"437946", "Gutau",
"432283", "Angern\ an\ der\ March",
"436462", "Bischofshofen",
"437414", "Weins\-Isperdorf",
"437285", "Hofkirchen\ im\ Mühlkreis",
"437485", "Gaming",
"432164", "Rohrau",
"437265", "Pabneukirchen",
"437257", "Grünburg",
"437228", "Kematen\ an\ der\ Krems",
"437214", "Reichenthal",
"432673", "Altenmarkt\ an\ der\ Triesting",
"433144", "Köflach",
"432263", "Grossrussbach",
"433137", "Söding",
"437675", "Ampflwang\ im\ Hausruckwald",
"433454", "Leutschach",
"437433", "Wallsee",
"435352", "St\.\ Johann\ in\ Tirol",
"434278", "Gnesau",
"433618", "Hohentauern",
"433624", "Pichl\-Kainisch",
"435445", "Kappl",
"432872", "Ottenschlag",
"432731", "Idolsberg",
"4317", "Vienna",
"435476", "Serfaus",
"435673", "Ehrwald",
"433134", "Heiligenkreuz\ am\ Waasen",
"435579", "Alberschwende",
"432167", "Neusiedl\ am\ See",
"437254", "Grossraming",
"435263", "Silz",
"436564", "Krimml",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"433147", "Salla",
"437443", "Ybbsitz",
"432686", "Drassburg",
"433457", "Gleinstätten",
"433465", "Pölfing\-Brunn",
"434284", "Kirchbach",
"432741", "Flinsbach",
"434264", "Klein\ St\.\ Paul",
"432245", "Wolkersdorf\ im\ Weinviertel",
"432749", "Prinzersdorf",
"432276", "Reidling",
"434215", "Liebenfels",
"432666", "Reichenau",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"437243", "Marchtrenk",
"432986", "Irnfritz",
"433859", "Mürzsteg",
"433126", "Frohnleiten",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"435283", "Kaltenbach",
"437618", "Neukirchen\,\ Altmünster",
"433366", "Kohfidisch",
"435336", "Alpbach",
"432864", "Kautzen",
"432815", "Grossschönau",
"434876", "Kals\ am\ Grossglockner",
"433844", "Kammern\ im\ Liesingtal",
"437241", "Steinerkirchen\ an\ der\ Traun",
"437612", "Gmunden",
"432754", "Loosdorf",
"432717", "Unter\-Meisling",
"432172", "Frauenkirchen",
"434734", "Rennweg",
"436274", "Lamprechtshausen",
"435573", "Hörbranz",
"436474", "Tamsweg",
"435289", "Häusling",
"433853", "Spital\ am\ Semmering",
"432743", "Böheimkirchen",
"433575", "St\.\ Johann\ am\ Tauern",
"434713", "Techendorf",
"437745", "Lochen",
"437249", "Bad\ Schallerbach",
"433119", "St\.\ Marein\ bei\ Graz",
"433386", "Grosssteinbach",
"432289", "Matzen",
"437952", "Weitersfelden",
"436477", "St\.\ Michael\ im\ Lungau",
"436225", "Eugendorf",
"433159", "Bad\ Gleichenberg",
"432733", "Schönberg\ am\ Kamp",
"433536", "St\.\ Peter\ am\ Kammersberg",
"432878", "Traunstein",
"433612", "Liezen",
"437735", "Gaspoltshofen",
"434272", "Pörtschach\ am\ Wörther\ See",
"435358", "Ellmau",
"437239", "Lichtenberg",
"435375", "Kössen",
"433834", "Wald\ am\ Schoberpass",
"437231", "Herzogsdorf",
"433151", "Gnas",
"432855", "Waldenstein",
"434356", "Lavamünd",
"433847", "Trofaiach",
"437763", "Kopfing\ im\ Innkreis",
"436468", "Werfen",
"436277", "St\.\ Pantaleon",
"432765", "Kaumberg",
"432757", "Pöchlarn",
"432573", "Wilfersdorf",
"432728", "Wienerbruck",
"432714", "Rossatz",
"432269", "Niederfellabrunn",
"435338", "Kundl",
"437767", "Eggerding",
"432982", "Horn",
"437755", "Mettmach",
"434733", "Malta",
"432662", "Gloggnitz",
"437259", "Sierning",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"435574", "Bregenz",
"432272", "Tulln\ an\ der\ Donau",
"432577", "Asparn\ an\ der\ Zaya",
"432753", "Gansbach",
"434785", "Ausserfragant",
"432863", "Eggern",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"432744", "Kasten\ bei\ Böheimkirchen",
"434269", "Flattnitz",
"4346", "Klagenfurt",
"434714", "Dellach\ im\ Drautal",
"432525", "Gnadendorf",
"434855", "Assling",
"436473", "Mariapfarr",
"432682", "Eisenstadt",
"436589", "Unken",
"433854", "Langenwang",
"437251", "Schiedlberg",
"432747", "Ober\-Grafendorf",
"434717", "Steinfeld",
"432734", "Langenlois",
"437211", "Reichenau\ im\ Mühlkreis",
"433141", "Hirschegg",
"435472", "Prutz",
"432845", "Weikertschlag\ an\ der\ Thaya",
"432876", "Els",
"433865", "Kindberg",
"433857", "Neuberg\ an\ der\ Mürz",
"435525", "Nenzing",
"435356", "Kitzbühel",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"433632", "St\.\ Gallen",
"432574", "Gaweinstal",
"432713", "Spitz",
"433516", "Kleinlobming",
"433149", "Geistthal",
"437764", "Riedau",
"433885", "Greith",
"437219", "Vorderweissenbach",
"435272", "Steinach\ am\ Brenner",
"434358", "St\.\ Andrä",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"435577", "Lustenau",
"436466", "Werfenweng",
"433833", "Traboch",
"432726", "Puchenstuben",
"437942", "Freistadt",
"435582", "Klösterle",
"434352", "Wolfsberg",
"435278", "Navis",
"435287", "Tux",
"437413", "Marbach\ an\ der\ Donau",
"432711", "Dürnstein",
"433638", "Palfau",
"432284", "Oberweiden",
"437234", "Ottensheim",
"437948", "Hirschbach\ im\ Mühlkreis",
"433117", "Eggersdorf\ bei\ Graz",
"437247", "Kematen\ am\ Innbach",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"433623", "Bad\ Mitterndorf",
"437226", "Wilhering",
"433453", "Ehrenhausen",
"437956", "Unterweissenbach",
"437434", "Haag",
"432264", "Rückersdorf\,\ Harmannsdorf",
"435677", "Vils",
"434245", "Feistritz\ an\ der\ Drau",
"432719", "Dross",
"432215", "Probstdorf",
"434276", "Feldkirchen\ in\ Kärnten",
"433616", "Selzthal",
"432163", "Petronell\-Carnuntum",
"437213", "Bad\ Leonfelden",
"432674", "Weissenbach\ an\ der\ Triesting",
"433532", "Murau",
"433143", "Krottendorf",
"435255", "Umhausen",
"434283", "St\.\ Stefan\ im\ Gailtal",
"433849", "Vordernberg",
"433185", "Preding",
"437444", "Opponitz",
"433382", "Fürstenfeld",
"437253", "Wolfern",
"434235", "Bleiburg",
"435264", "Mieming",
"436471", "Tweng",
"436563", "Uttendorf",
"432688", "Steinbrunn",
"432267", "Sierndorf",
"435674", "Bichlbach",
"432255", "Deutsch\ Brodersdorf",
"433133", "Nestelbach",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"432278", "Absdorf",
"432287", "Strasshof\ an\ der\ Nordbahn",
"436583", "Leogang",
"434872", "Huben",
"435284", "Gerlos",
"432625", "Bad\ Sauerbrunn",
"433362", "Grosspetersdorf",
"435332", "Wörgl",
"432988", "Neupölla",
"436479", "Muhr",
"433114", "Markt\ Hartmannsdorf",
"432145", "Prellenkirchen",
"437244", "Sattledt",
"432176", "Tadten",
"433157", "Kapfenstein",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"434263", "Hüttenberg",
"437616", "Grünau\ im\ Almtal",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;