use strict;

use Test::More;
BEGIN {
    if (! $ENV{'TEST_AUTHOR'}) {
        plan(skip_all => "TEST_AUTHOR environment variable is not set");
    }
}
use Test::Requires;

test_requires 'Test::Spelling';

my @stopwords;
for (<DATA>) {
    chomp;
    push @stopwords, $_
        unless /\A (?: \# | \s* \z)/msx;    # skip comments, whitespace
}

add_stopwords(@stopwords);
set_spell_cmd('aspell list -l en');

# This prevents a weird segfault from the aspell command - see
# https://bugs.launchpad.net/ubuntu/+source/aspell/+bug/71322
local $ENV{LC_ALL} = 'C';
all_pod_files_spelling_ok();

__DATA__
BerkeleyDB
CGI
Daisuke
Formatter
Gettext
Localizers
Maketext
Maki
Multi
NamedArgs
NONINFRINGEMENT
TODO
UTF
backend
everwhere
isa
ish
ja
localizer
localizer's
localizers
lookup
multi
namespace
namespaces
po
sublicense
utf
