--
-- PostgreSQL database dump
--

SET search_path = public, pg_catalog;

CREATE TABLE products (
    sku character varying(64) NOT NULL,
    description character varying(128),
    title character varying(128),
    template_page character(128),
    "comment" text,
    thumb character varying(128),
    image character varying(64),
    price character varying(12),
    wholesale character(128),
    prod_group character(128),
    category character varying(64),
    tax_category character(128),
    nontaxable character varying(3),
    weight character varying(12),
    size character varying(96),
    color character varying(96),
    gift_cert character(128),
    related text,
    featured character varying(32),
    download character(128),
    dl_type character(128),
    dl_location character(128),
    inactive character(128),
    url character(128),
    sale_price character(128),
    image_large character(128)
);

INSERT INTO products VALUES ('gift_cert', 'Gift Certificate', 'Gift Certificate', '                                                                                                                                ', '', 'gift_cert.gif', 'gift_cert.gif', '1.00', '1                                                                                                                               ', 'Miscellaneous                                                                                                                   ', 'Gift Certificate', '                                                                                                                                ', '', '', '', '', '1                                                                                                                               ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28004', 'Ergo Roller', 'Ergo Roller', '                                                                                                                                ', 'The special ergonomic design of our paint rollers has been recommended by physicians to ease the strain of repetitive movements.  This unique roller design features "pores" to hold and evenly distribute more paint per wetting than any other brush.', 'os28004_b.gif', 'os28004.gif', '21.99', '16                                                                                                                              ', 'Painting Supplies                                                                                                               ', 'Rollers', '                                                                                                                                ', '1', '1', '1'', 1.5''', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '14.95                                                                                                                           ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28005', 'Trim Brush', 'Trim Brush', '                                                                                                                                ', 'Our trim paint brushes are perfectly designed.  The ergonomic look and feel will save hours of pain and the unique brush design allows paint to flow evenly and consistently.', 'os28005_b.gif', 'os28005.gif', '8.99', '6                                                                                                                               ', 'Painting Supplies                                                                                                               ', 'Paintbrushes', '                                                                                                                                ', '1', '1', '1", 2", 3"', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28006', 'Painters Brush Set', 'Painters Brush Set', '                                                                                                                                ', 'This set includes 2" and 3" trim brushes and our ergonomically designer paint roller.  A perfect choice for any painting project.', 'os28006_b.gif', 'os28006.gif', '29.99', '25                                                                                                                              ', 'Painting Supplies                                                                                                               ', 'Paintbrushes', '                                                                                                                                ', '1', '1', 'set', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28007', 'Disposable Brush Set', 'Disposable Brush Set', '                                                                                                                                ', 'This set of disposable foam brushes is ideal for any staining project.  The foam design holds the maximum amount of stain and the wood handle allows you to preview the color before you apply it.  This set includes a brush for all needs. 1/2", 1", 2", 3" are included.', 'os28007_b.gif', 'os28007.gif', '14.99', '10                                                                                                                              ', 'Painting Supplies                                                                                                               ', 'Paintbrushes', '                                                                                                                                ', '1', '1', 'set', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28008', 'Painters Ladder', 'Painters Ladder', '                                                                                                                                ', 'This 6'' painters ladder is perfect for getting around in almost any room.  The paint tray is reinforced to hold up to a 5 gallon paint bucket.  The only time you''ll have to get down is to move your ladder!', 'os28008_b.gif', 'os28008.gif', '29.99', '25                                                                                                                              ', 'Ladders                                                                                                                         ', 'Ladders', '                                                                                                                                ', '1', '3', '6''', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28009', 'Brush Set', 'Brush Set', '                                                                                                                                ', 'This Hand Brush set includes our carpenters hand brush and a flat handled brush for the bigger cleanups.  Both brushes are made of the finest horsehair and are ideal for all surfaces.', 'os28009_b.gif', 'os28009.gif', '9.99', '6                                                                                                                               ', 'Hand Tools                                                                                                                      ', 'Brushes', '                                                                                                                                ', '1', '1', '', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28011', 'Spackling Knife', 'Spackling Knife', '                                                                                                                                ', 'A must have for all painters!  This spackling knife is ergonomically designed for ease of use and boasts a newly designed finish to allow easy clean up.', 'os28011_b.gif', 'os28011.gif', '14.99', '10                                                                                                                              ', 'Painting Supplies                                                                                                               ', 'Putty Knives', '                                                                                                                                ', '1', '1', '2"', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28044', 'Framing Hammer', 'Framing Hammer', '                                                                                                                                ', 'Enjoy the perfect feel and swing of our line of hammers. This framing hammer is ideal for the most discriminating of carpenters.  The handle is perfectly shaped to fit the hand and the head is weighted to get the most out of each swing.', 'os28044_b.gif', 'os28044.gif', '19.99', '12                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Hammers', '                                                                                                                                ', '1', '2', '10oz, 15oz, 20 oz', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28057a', '16 Penny Nails', '16 Penny Nails', '                                                                                                                                ', 'Try our high quality 16 penny titanium nails for a lifetime of holding power. Box count about 100 nails.', 'os28057a_b.gif', 'os28057a.gif', '14.99', '12                                                                                                                              ', 'Hardware                                                                                                                        ', 'Nails', '                                                                                                                                ', '1', '1', '', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28057b', '8 Penny Nails', '8 Penny Nails', '                                                                                                                                ', 'Our 8 penny nails are perfect for those hard to reach spots. Made of titanium they are guaranteed to last as long as your project. Box count about 200 nails.', 'os28057b_b.gif', 'os28057b.gif', '12.99', '10                                                                                                                              ', 'Hardware                                                                                                                        ', 'Nails', '                                                                                                                                ', '1', '1', '', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28057c', '10 Penny Nails', '10 Penny Nails', '                                                                                                                                ', 'Perfect for all situations our titanium 10 Penny nails should be a part of every project.  Box count about 100 nails.', 'os28057c_b.gif', 'os28057c.gif', '13.99', '11                                                                                                                              ', 'Hardware                                                                                                                        ', 'Nails', '                                                                                                                                ', '1', '1', '', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28062', 'Electricians Plier Set', 'Electricians Plier Set', '                                                                                                                                ', 'This electricians set includes heavy duty needle-nose pliers and wire cutters.  The needle-nose pliers have an extended tip making them easy to get into those hard to reach places, and the cutters are equipped with spring action so they bounce back ready for the next cut.', 'os28062_b.gif', 'os28062.gif', '24.99', '19                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Pliers', '                                                                                                                                ', '1', '1', 'set', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28064', 'Mechanics Wrench Set', 'Mechanics Wrench Set', '                                                                                                                                ', 'This 5 piece set is ideal for all mechanics. Available in standard and metric sizes these tools are guaranteed to cover all of your needs.', 'os28064_b.gif', 'os28064.gif', '19.99', '16                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Wrenches', '                                                                                                                                ', '1', '2', 'standard, metric', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28065', 'Mechanics Pliers', 'Mechanics Pliers', '                                                                                                                                ', 'Our Mechanics pliers are available in multiple sizes for all of your needs.  From 1/4" to 3" in diameter.', 'os28065_b.gif', 'os28065.gif', '18.99', '14                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Pliers', '                                                                                                                                ', '1', '2', '1/4", 1/2", 3/4", 1", 2", 3"', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28066', 'Big L Carpenters Square', 'Big L Carpenters Square', '                                                                                                                                ', 'The "Big L"is a must for every carpenter.  Designed for ease of use this square is perfect for measuring and marking cuts, insuring that you get the right cut every time!', 'os28066_b.gif', 'os28066.gif', '14.99', '12                                                                                                                              ', 'Measuring Tools                                                                                                                 ', 'Squares', '                                                                                                                                ', '1', '1', '1'', 3''', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28068a', 'Breathe Right Face Mask', 'Breathe Right Face Mask', '                                                                                                                                ', 'The unique design of our "Breathe Right" face mask is a must for all applications.  Our patented micro-fiber insures that 90% of all dust and harmful materials are filtered out before you breath them in.', 'os28068a_b.gif', 'os28068a.gif', '5.99', '4                                                                                                                               ', 'Safety Equipment                                                                                                                ', 'Breathing Protection', '                                                                                                                                ', '1', '1', '', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28068b', 'The Bug Eye Wear', 'The Bug Eye Wear', '                                                                                                                                ', 'Nothing protects your vision like "The Bug".  The unique design of these safety goggles is practically impenetrable and our special venting technology will make you forget you even have them on.', 'os28068b_b.gif', 'os28068b.gif', '12.00', '10                                                                                                                              ', 'Safety Equipment                                                                                                                ', 'Eye Protection', '                                                                                                                                ', '1', '1', '', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28069', 'Flat Top Toolbox', 'Flat Top Toolbox', '                                                                                                                                ', 'This heavy weight tool box is perfect for any handy person.  The lift out top is perfect for a carry along, and there is plenty of open space for larger tool storage.', 'os28069_b.gif', 'os28069.gif', '44.99', '35                                                                                                                              ', 'Tool Storage                                                                                                                    ', 'Toolboxes', '                                                                                                                                ', '1', '2', '20"x 8.5" x 9"', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28070', 'Electricians Tool Belt', 'Electricians Tool Belt', '                                                                                                                                ', 'This tool belt is perfectly designed for the specialized tools of the electrical trade.  There is even a pocket for your voltage meter in this 100% leather belt!', 'os28070_b.gif', 'os28070.gif', '39.99', '30                                                                                                                              ', 'Tool Storage                                                                                                                    ', 'Tool Belts', '                                                                                                                                ', '1', '1', '', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28072', 'Deluxe Hand Saw', 'Deluxe Hand Saw', '                                                                                                                                ', 'Our deluxe hand saw is perfect for precision work. This saw features an ergonomic handle and carbide tipped teeth.  Available in 2'', 2.5'', and 3'' lengths.', 'os28072_b.gif', 'os28072.gif', '17.99', '14                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Hand Saws', '                                                                                                                                ', '1', '1', '2'', 2.5'', 3''', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28073', 'Mini-Sledge', 'Mini-Sledge', '                                                                                                                                ', 'Our mini-sledge hammer is superior for smaller jobs that require a little more power.  Give this one a try on landscaping stakes and concrete frames.', 'os28073_b.gif', 'os28073.gif', '24.99', '18                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Hammers', '                                                                                                                                ', '1', '3', '20oz, 30oz, 50oz', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28074', 'Rubber Mallet', 'Rubber Mallet', '                                                                                                                                ', 'Perfectly weighted and encased in rubber this mallet is designed for ease of use in all applications.', 'os28074_b.gif', 'os28074.gif', '24.99', '18                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Hammers', '                                                                                                                                ', '1', '2', '30oz', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28075', 'Modeling Hammer', 'Modeling Hammer', '                                                                                                                                ', 'Ideal for the hobbiest this modeling hammer is made for the delicate work. Fits easily into small spaces and the smaller head size is perfect for intricate projects.', 'os28075_b.gif', 'os28075.gif', '14.99', '10                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Hammers', '                                                                                                                                ', '1', '2', '8oz', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28076', 'Digger Hand Trencher', 'Digger Hand Trencher', '                                                                                                                                ', 'The "Digger" is a gardeners dream.  Specially designed for moving dirt it boasts two different styles of blade.  Use the one side for trenching, or use the other side with it''s wider angle to get hard to handle roots out of the ground.  Available in 3" size only.', 'os28076_b.gif', 'os28076.gif', '18.99', '15                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Picks & Hatchets', '                                                                                                                                ', '1', '1', '3"', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28077', 'Carpenter''s Tool Belt', 'Carpenter''s Tool Belt', '                                                                                                                                ', 'Specially designed this tool belt comes with all of the carpenter''s necessities.  Made of 100% leather this tool belt boasts a hammer hockey, tape measure hockey, and cordless drill holster.  Multiple pockets will allow you to eliminate those extra trips back to the tool box.', 'os28077_b.gif', 'os28077.gif', '39.99', '30                                                                                                                              ', 'Tool Storage                                                                                                                    ', 'Tool Belts', '                                                                                                                                ', '1', '1', '', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28080', 'The Blade Hand Planer', 'The Blade Hand Planer', '                                                                                                                                ', 'The perfect precision hand planer.  Our patented blade technology insures that you will never have to change or sharpen the blade.  Available in 1", 1.5", and 2" widths.', 'os28080_b.gif', 'os28080.gif', '19.99', '16                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Hand Planes', '                                                                                                                                ', '1', '1', '1", 1.5", 2"', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28081', 'Steel Wool', 'Steel Wool', '                                                                                                                                ', 'Available in all different weights this steel wool is more durable than any other.  Perfect for stain removal or smoothing hard to reach surfaces.', 'os28081_b.gif', 'os28081.gif', '8.99', '6                                                                                                                               ', 'Painting Supplies                                                                                                               ', 'Sandpaper', '                                                                                                                                ', '1', '1', 'fine, light, course', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28082', '24" Level', '24" Level', '                                                                                                                                ', 'Certified accuracy, High strength, long life, Built-in rubber grips for usefulness. Easy to clean.', 'os28082_b.gif', 'os28082.gif', '34.99', '17.5                                                                                                                            ', 'Measuring Tools                                                                                                                 ', 'Levels', '                                                                                                                                ', '', '1', '24"', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28084', 'Tape Measure', 'Tape Measure', '                                                                                                                                ', 'No matter what you need to measure you are sure to find the ideal tape measure here.  All of our tape measures are spring loaded for fast retraction and all lock in place for extended measuring.  Available in 10'', 16'', 24'', and 36''.', 'os28084_b.gif', 'os28084.gif', '19.99', '15                                                                                                                              ', 'Measuring Tools                                                                                                                 ', 'Tape Measures', '                                                                                                                                ', '1', '1', '10'', 16'', 24'', 36''', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28085', 'Big A A-Frame Ladder', 'Big A A-Frame Ladder', '                                                                                                                                ', 'The "Big A" is the ideal A-Frame ladder.  Available in both 6'' and 12'' heights you are sure to find the one that meets your needs.  The treads of both sides are reinforced for climbing making placement a breeze.', 'os28085_b.gif', 'os28085.gif', '36.99', '30                                                                                                                              ', 'Ladders                                                                                                                         ', 'Ladders', '                                                                                                                                ', '1', '3', '6'', 12''', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28086', 'Folding Ruler', 'Folding Ruler', '                                                                                                                                ', 'This 6'' folding ruler is a perfect fit in almost any toolbox.  Only 12" folded this measuring tool is handy and portable.', 'os28086_b.gif', 'os28086.gif', '12.99', '9                                                                                                                               ', 'Measuring Tools                                                                                                                 ', 'Rulers', '                                                                                                                                ', '1', '1', '6''', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28087', 'Sanders Multi-Pac', 'Sanders Multi-Pac', '                                                                                                                                ', 'This multi-pack of sand paper includes all levels of sand paper from a very fine grit to a very course grit.  Ideal for all applications!', 'os28087_b.gif', 'os28087.gif', '11.99', '8                                                                                                                               ', 'Painting Supplies                                                                                                               ', 'Sandpaper', '                                                                                                                                ', '1', '1', 'set', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28108', 'Hand Brush', 'Hand Brush', '                                                                                                                                ', 'This carpenters hand brush is ideal for the small clean ups needed for precision work. Made of refined horse hair it is perfect for even the most sensitive of materials.', 'os28108_b.gif', 'os28108.gif', '5.99', '3                                                                                                                               ', 'Hand Tools                                                                                                                      ', 'Brushes', '                                                                                                                                ', '1', '1', '3", 5", 10"', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28109', 'Mini-Spade', 'Mini-Spade', '                                                                                                                                ', 'This mini-spade is perfect hole digging, tree planting, or trenching.  The easy grip handle allows more control over thrust and direction.  Available in 4'' only', 'os28109_b.gif', 'os28109.gif', '24.99', '19                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Shovels', '                                                                                                                                ', '1', '2', '4''', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28110', 'Mighty Mouse Tin Snips', 'Mighty Mouse Tin Snips', '                                                                                                                                ', 'Small and ready to go these tin snips are ideal for cutting patches and vent holes.  With the patented blades they are also perfect for cutting aluminum flashing.  Available in 3" length only.', 'os28110_b.gif', 'os28110.gif', '14.99', '12                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Shears', '                                                                                                                                ', '1', '1', '3"', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28111', 'Hedge Shears', 'Hedge Shears', '                                                                                                                                ', 'A perfect fit for all users these 10" hedge shears are designed to make the most out of every cut. The ergonomic handle design will allow hours of cutting time so you can tackle those really big projects.  One size only', 'os28111_b.gif', 'os28111.gif', '19.99', '15                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Shears', '                                                                                                                                ', '1', '1', '10"', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28112', 'Garden Shovel', 'Garden Shovel', '                                                                                                                                ', 'The blade on this garden shovel is 7" inches long making it ideal for the potting enthusiast.  Ergonomic design makes for ease of use with this tool.', 'os28112_b.gif', 'os28112.gif', '13.99', '10                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Shovels', '                                                                                                                                ', '1', '2', '7"', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os28113', 'The Claw Hand Rake', 'The Claw Hand Rake', '                                                                                                                                ', 'Extend the reach of your potting with "The Claw".  Perfect for agitating soil in the most difficult places this 3 tine tool is ideal for every gardener.  Small and Large sizes available.', 'os28113_b.gif', 'os28113.gif', '14.99', '12                                                                                                                              ', 'Hand Tools                                                                                                                      ', 'Picks & Hatchets', '                                                                                                                                ', '1', '1', 'small, large', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');
INSERT INTO products VALUES ('os29000', '3'' Step Ladder', '3'' Step Ladder', '                                                                                                                                ', '', 'os29000_b.gif', 'os29000.gif', '44.99', '22.5                                                                                                                            ', 'Ladders                                                                                                                         ', 'Step Stools', '                                                                                                                                ', '', '', '', '', '                                                                                                                                ', '', '', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ', '                                                                                                                                ');

CREATE INDEX products_sku ON products USING btree (sku);

CREATE INDEX products_description ON products USING btree (description);

CREATE INDEX products_price ON products USING btree (price);

CREATE INDEX products_category ON products USING btree (category);

CREATE INDEX products_prod_group ON products USING btree (prod_group);

ALTER TABLE ONLY products
    ADD CONSTRAINT products_pkey PRIMARY KEY (sku);

CREATE TABLE inventory (
    sku character varying(64) NOT NULL,
    quantity character varying(12),
    stock_message character(128),
    account character varying(128),
    cogs_account character varying(128)
);

INSERT INTO inventory VALUES ('gift_cert', '1', 'In Stock                                                                                                                        ', '', '');
INSERT INTO inventory VALUES ('os28004', '93', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28005', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28006', '90', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28007', '85', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28008', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28009', '95', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28011', '40', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28044', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28057a', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28057b', '29', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28057c', '50', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28062', '88', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28064', '94', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28065', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28066', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28068a', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28068b', '99', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28069', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28070', '0', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28072', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28073', '0', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28074', '95', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28075', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28076', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28077', '97', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28080', '84', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28081', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28082', '99', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28084', '95', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28085', '1', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28086', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28087', '30', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28108', '90', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28109', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28110', '99', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28111', '99', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28112', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os28113', '100', 'Ships in 3-5 days                                                                                                               ', '', '');
INSERT INTO inventory VALUES ('os29000', '97', 'Ships in 3-5 days                                                                                                               ', '', '');

CREATE INDEX inventory_sku ON inventory USING btree (sku);

ALTER TABLE ONLY inventory
    ADD CONSTRAINT inventory_pkey PRIMARY KEY (sku);


