package API::MailboxOrg::API::Validate;

# ABSTRACT: MailboxOrg::API::Validate

# ---
# This class is auto-generated by bin/get_mailbox_api.pl
# ---

use v5.24;

use strict;
use warnings;

use Moo;
use Types::Standard qw(Enum Str Int InstanceOf ArrayRef);
use API::MailboxOrg::Types qw(HashRefRestricted Boolean);
use Params::ValidationCompiler qw(validation_for);

extends 'API::MailboxOrg::APIBase';

with 'MooX::Singleton';

use feature 'signatures';
no warnings 'experimental::signatures';

our $VERSION = '1.0.2'; # VERSION

my %validators = (
    'spf' => validation_for(
        params => {
            domain => { type => Str, optional => 0 },

        },
    ),

);


sub spf ($self, %params) {
    my $validator = $validators{'spf'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'domain.validate.spf', \%params, \%opt );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

API::MailboxOrg::API::Validate - MailboxOrg::API::Validate

=head1 VERSION

version 1.0.2

=head1 SYNOPSIS

    use API::MailboxOrg;

    my $user     = '1234abc';
    my $password = '1234abc';

    my $api      = API::MailboxOrg->new(
        user     => $user,
        password => $password,
    );

=head1 METHODS

=head2 spf

Returns SPF details about a domain

Available for admin, reseller, account, domain

Parameters:

=over 4

=item * domain

=back

returns: array

    $api->validate->spf(%params);

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
