/*
 * jit-symbol.c - Table of registered intrinsic symbols.
 *
 * Copyright (C) 2004  Southern Storm Software, Pty Ltd.
 *
 * This file is part of the libjit library.
 *
 * The libjit library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * The libjit library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the libjit library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "jit-internal.h"

/*
 * This list must be sorted, so that a binary search can be used on it.
 */
typedef struct
{
	const char *name;
	void       *value;

} jit_internalsym;
jit_internalsym const _jit_internal_symbols[] = {
	{"jit_exception_builtin", (void *)jit_exception_builtin},
	{"jit_exception_get_stack_trace", (void *)jit_exception_get_stack_trace},
	{"jit_exception_throw", (void *)jit_exception_throw},
	{"jit_float32_abs", (void *)jit_float32_abs},
	{"jit_float32_acos", (void *)jit_float32_acos},
	{"jit_float32_add", (void *)jit_float32_add},
	{"jit_float32_asin", (void *)jit_float32_asin},
	{"jit_float32_atan", (void *)jit_float32_atan},
	{"jit_float32_atan2", (void *)jit_float32_atan2},
	{"jit_float32_ceil", (void *)jit_float32_ceil},
	{"jit_float32_cmpg", (void *)jit_float32_cmpg},
	{"jit_float32_cmpl", (void *)jit_float32_cmpl},
	{"jit_float32_cos", (void *)jit_float32_cos},
	{"jit_float32_cosh", (void *)jit_float32_cosh},
	{"jit_float32_div", (void *)jit_float32_div},
	{"jit_float32_eq", (void *)jit_float32_eq},
	{"jit_float32_exp", (void *)jit_float32_exp},
	{"jit_float32_floor", (void *)jit_float32_floor},
	{"jit_float32_ge", (void *)jit_float32_ge},
	{"jit_float32_gt", (void *)jit_float32_gt},
	{"jit_float32_ieee_rem", (void *)jit_float32_ieee_rem},
	{"jit_float32_is_finite", (void *)jit_float32_is_finite},
	{"jit_float32_is_inf", (void *)jit_float32_is_inf},
	{"jit_float32_is_nan", (void *)jit_float32_is_nan},
	{"jit_float32_le", (void *)jit_float32_le},
	{"jit_float32_log", (void *)jit_float32_log},
	{"jit_float32_log10", (void *)jit_float32_log10},
	{"jit_float32_lt", (void *)jit_float32_lt},
	{"jit_float32_max", (void *)jit_float32_max},
	{"jit_float32_min", (void *)jit_float32_min},
	{"jit_float32_mul", (void *)jit_float32_mul},
	{"jit_float32_ne", (void *)jit_float32_ne},
	{"jit_float32_neg", (void *)jit_float32_neg},
	{"jit_float32_pow", (void *)jit_float32_pow},
	{"jit_float32_rem", (void *)jit_float32_rem},
	{"jit_float32_rint", (void *)jit_float32_rint},
	{"jit_float32_round", (void *)jit_float32_round},
	{"jit_float32_sign", (void *)jit_float32_sign},
	{"jit_float32_sin", (void *)jit_float32_sin},
	{"jit_float32_sinh", (void *)jit_float32_sinh},
	{"jit_float32_sqrt", (void *)jit_float32_sqrt},
	{"jit_float32_sub", (void *)jit_float32_sub},
	{"jit_float32_tan", (void *)jit_float32_tan},
	{"jit_float32_tanh", (void *)jit_float32_tanh},
	{"jit_float32_to_float64", (void *)jit_float32_to_float64},
	{"jit_float32_to_int", (void *)jit_float32_to_int},
	{"jit_float32_to_int_ovf", (void *)jit_float32_to_int_ovf},
	{"jit_float32_to_long", (void *)jit_float32_to_long},
	{"jit_float32_to_long_ovf", (void *)jit_float32_to_long_ovf},
	{"jit_float32_to_nfloat", (void *)jit_float32_to_nfloat},
	{"jit_float32_to_uint", (void *)jit_float32_to_uint},
	{"jit_float32_to_uint_ovf", (void *)jit_float32_to_uint_ovf},
	{"jit_float32_to_ulong", (void *)jit_float32_to_ulong},
	{"jit_float32_to_ulong_ovf", (void *)jit_float32_to_ulong_ovf},
	{"jit_float32_trunc", (void *)jit_float32_trunc},
	{"jit_float64_abs", (void *)jit_float64_abs},
	{"jit_float64_acos", (void *)jit_float64_acos},
	{"jit_float64_add", (void *)jit_float64_add},
	{"jit_float64_asin", (void *)jit_float64_asin},
	{"jit_float64_atan", (void *)jit_float64_atan},
	{"jit_float64_atan2", (void *)jit_float64_atan2},
	{"jit_float64_ceil", (void *)jit_float64_ceil},
	{"jit_float64_cmpg", (void *)jit_float64_cmpg},
	{"jit_float64_cmpl", (void *)jit_float64_cmpl},
	{"jit_float64_cos", (void *)jit_float64_cos},
	{"jit_float64_cosh", (void *)jit_float64_cosh},
	{"jit_float64_div", (void *)jit_float64_div},
	{"jit_float64_eq", (void *)jit_float64_eq},
	{"jit_float64_exp", (void *)jit_float64_exp},
	{"jit_float64_floor", (void *)jit_float64_floor},
	{"jit_float64_ge", (void *)jit_float64_ge},
	{"jit_float64_gt", (void *)jit_float64_gt},
	{"jit_float64_ieee_rem", (void *)jit_float64_ieee_rem},
	{"jit_float64_is_finite", (void *)jit_float64_is_finite},
	{"jit_float64_is_inf", (void *)jit_float64_is_inf},
	{"jit_float64_is_nan", (void *)jit_float64_is_nan},
	{"jit_float64_le", (void *)jit_float64_le},
	{"jit_float64_log", (void *)jit_float64_log},
	{"jit_float64_log10", (void *)jit_float64_log10},
	{"jit_float64_lt", (void *)jit_float64_lt},
	{"jit_float64_max", (void *)jit_float64_max},
	{"jit_float64_min", (void *)jit_float64_min},
	{"jit_float64_mul", (void *)jit_float64_mul},
	{"jit_float64_ne", (void *)jit_float64_ne},
	{"jit_float64_neg", (void *)jit_float64_neg},
	{"jit_float64_pow", (void *)jit_float64_pow},
	{"jit_float64_rem", (void *)jit_float64_rem},
	{"jit_float64_rint", (void *)jit_float64_rint},
	{"jit_float64_round", (void *)jit_float64_round},
	{"jit_float64_sign", (void *)jit_float64_sign},
	{"jit_float64_sin", (void *)jit_float64_sin},
	{"jit_float64_sinh", (void *)jit_float64_sinh},
	{"jit_float64_sqrt", (void *)jit_float64_sqrt},
	{"jit_float64_sub", (void *)jit_float64_sub},
	{"jit_float64_tan", (void *)jit_float64_tan},
	{"jit_float64_tanh", (void *)jit_float64_tanh},
	{"jit_float64_to_float32", (void *)jit_float64_to_float32},
	{"jit_float64_to_int", (void *)jit_float64_to_int},
	{"jit_float64_to_int_ovf", (void *)jit_float64_to_int_ovf},
	{"jit_float64_to_long", (void *)jit_float64_to_long},
	{"jit_float64_to_long_ovf", (void *)jit_float64_to_long_ovf},
	{"jit_float64_to_nfloat", (void *)jit_float64_to_nfloat},
	{"jit_float64_to_uint", (void *)jit_float64_to_uint},
	{"jit_float64_to_uint_ovf", (void *)jit_float64_to_uint_ovf},
	{"jit_float64_to_ulong", (void *)jit_float64_to_ulong},
	{"jit_float64_to_ulong_ovf", (void *)jit_float64_to_ulong_ovf},
	{"jit_float64_trunc", (void *)jit_float64_trunc},
	{"jit_int_abs", (void *)jit_int_abs},
	{"jit_int_add", (void *)jit_int_add},
	{"jit_int_add_ovf", (void *)jit_int_add_ovf},
	{"jit_int_and", (void *)jit_int_and},
	{"jit_int_cmp", (void *)jit_int_cmp},
	{"jit_int_div", (void *)jit_int_div},
	{"jit_int_eq", (void *)jit_int_eq},
	{"jit_int_ge", (void *)jit_int_ge},
	{"jit_int_gt", (void *)jit_int_gt},
	{"jit_int_le", (void *)jit_int_le},
	{"jit_int_lt", (void *)jit_int_lt},
	{"jit_int_max", (void *)jit_int_max},
	{"jit_int_min", (void *)jit_int_min},
	{"jit_int_mul", (void *)jit_int_mul},
	{"jit_int_mul_ovf", (void *)jit_int_mul_ovf},
	{"jit_int_ne", (void *)jit_int_ne},
	{"jit_int_neg", (void *)jit_int_neg},
	{"jit_int_not", (void *)jit_int_not},
	{"jit_int_or", (void *)jit_int_or},
	{"jit_int_rem", (void *)jit_int_rem},
	{"jit_int_shl", (void *)jit_int_shl},
	{"jit_int_shr", (void *)jit_int_shr},
	{"jit_int_sign", (void *)jit_int_sign},
	{"jit_int_sub", (void *)jit_int_sub},
	{"jit_int_sub_ovf", (void *)jit_int_sub_ovf},
	{"jit_int_to_float32", (void *)jit_int_to_float32},
	{"jit_int_to_float64", (void *)jit_int_to_float64},
	{"jit_int_to_int", (void *)jit_int_to_int},
	{"jit_int_to_int_ovf", (void *)jit_int_to_int_ovf},
	{"jit_int_to_long", (void *)jit_int_to_long},
	{"jit_int_to_long_ovf", (void *)jit_int_to_long_ovf},
	{"jit_int_to_nfloat", (void *)jit_int_to_nfloat},
	{"jit_int_to_sbyte", (void *)jit_int_to_sbyte},
	{"jit_int_to_sbyte_ovf", (void *)jit_int_to_sbyte_ovf},
	{"jit_int_to_short", (void *)jit_int_to_short},
	{"jit_int_to_short_ovf", (void *)jit_int_to_short_ovf},
	{"jit_int_to_ubyte", (void *)jit_int_to_ubyte},
	{"jit_int_to_ubyte_ovf", (void *)jit_int_to_ubyte_ovf},
	{"jit_int_to_uint", (void *)jit_int_to_uint},
	{"jit_int_to_uint_ovf", (void *)jit_int_to_uint_ovf},
	{"jit_int_to_ulong", (void *)jit_int_to_ulong},
	{"jit_int_to_ulong_ovf", (void *)jit_int_to_ulong_ovf},
	{"jit_int_to_ushort", (void *)jit_int_to_ushort},
	{"jit_int_to_ushort_ovf", (void *)jit_int_to_ushort_ovf},
	{"jit_int_xor", (void *)jit_int_xor},
	{"jit_long_abs", (void *)jit_long_abs},
	{"jit_long_add", (void *)jit_long_add},
	{"jit_long_add_ovf", (void *)jit_long_add_ovf},
	{"jit_long_and", (void *)jit_long_and},
	{"jit_long_cmp", (void *)jit_long_cmp},
	{"jit_long_div", (void *)jit_long_div},
	{"jit_long_eq", (void *)jit_long_eq},
	{"jit_long_ge", (void *)jit_long_ge},
	{"jit_long_gt", (void *)jit_long_gt},
	{"jit_long_le", (void *)jit_long_le},
	{"jit_long_lt", (void *)jit_long_lt},
	{"jit_long_max", (void *)jit_long_max},
	{"jit_long_min", (void *)jit_long_min},
	{"jit_long_mul", (void *)jit_long_mul},
	{"jit_long_mul_ovf", (void *)jit_long_mul_ovf},
	{"jit_long_ne", (void *)jit_long_ne},
	{"jit_long_neg", (void *)jit_long_neg},
	{"jit_long_not", (void *)jit_long_not},
	{"jit_long_or", (void *)jit_long_or},
	{"jit_long_rem", (void *)jit_long_rem},
	{"jit_long_shl", (void *)jit_long_shl},
	{"jit_long_shr", (void *)jit_long_shr},
	{"jit_long_sign", (void *)jit_long_sign},
	{"jit_long_sub", (void *)jit_long_sub},
	{"jit_long_sub_ovf", (void *)jit_long_sub_ovf},
	{"jit_long_to_float32", (void *)jit_long_to_float32},
	{"jit_long_to_float64", (void *)jit_long_to_float64},
	{"jit_long_to_int", (void *)jit_long_to_int},
	{"jit_long_to_int_ovf", (void *)jit_long_to_int_ovf},
	{"jit_long_to_long", (void *)jit_long_to_long},
	{"jit_long_to_long_ovf", (void *)jit_long_to_long_ovf},
	{"jit_long_to_nfloat", (void *)jit_long_to_nfloat},
	{"jit_long_to_uint", (void *)jit_long_to_uint},
	{"jit_long_to_uint_ovf", (void *)jit_long_to_uint_ovf},
	{"jit_long_to_ulong", (void *)jit_long_to_ulong},
	{"jit_long_to_ulong_ovf", (void *)jit_long_to_ulong_ovf},
	{"jit_long_xor", (void *)jit_long_xor},
	{"jit_nfloat_abs", (void *)jit_nfloat_abs},
	{"jit_nfloat_acos", (void *)jit_nfloat_acos},
	{"jit_nfloat_add", (void *)jit_nfloat_add},
	{"jit_nfloat_asin", (void *)jit_nfloat_asin},
	{"jit_nfloat_atan", (void *)jit_nfloat_atan},
	{"jit_nfloat_atan2", (void *)jit_nfloat_atan2},
	{"jit_nfloat_ceil", (void *)jit_nfloat_ceil},
	{"jit_nfloat_cmpg", (void *)jit_nfloat_cmpg},
	{"jit_nfloat_cmpl", (void *)jit_nfloat_cmpl},
	{"jit_nfloat_cos", (void *)jit_nfloat_cos},
	{"jit_nfloat_cosh", (void *)jit_nfloat_cosh},
	{"jit_nfloat_div", (void *)jit_nfloat_div},
	{"jit_nfloat_eq", (void *)jit_nfloat_eq},
	{"jit_nfloat_exp", (void *)jit_nfloat_exp},
	{"jit_nfloat_floor", (void *)jit_nfloat_floor},
	{"jit_nfloat_ge", (void *)jit_nfloat_ge},
	{"jit_nfloat_gt", (void *)jit_nfloat_gt},
	{"jit_nfloat_ieee_rem", (void *)jit_nfloat_ieee_rem},
	{"jit_nfloat_is_finite", (void *)jit_nfloat_is_finite},
	{"jit_nfloat_is_inf", (void *)jit_nfloat_is_inf},
	{"jit_nfloat_is_nan", (void *)jit_nfloat_is_nan},
	{"jit_nfloat_le", (void *)jit_nfloat_le},
	{"jit_nfloat_log", (void *)jit_nfloat_log},
	{"jit_nfloat_log10", (void *)jit_nfloat_log10},
	{"jit_nfloat_lt", (void *)jit_nfloat_lt},
	{"jit_nfloat_max", (void *)jit_nfloat_max},
	{"jit_nfloat_min", (void *)jit_nfloat_min},
	{"jit_nfloat_mul", (void *)jit_nfloat_mul},
	{"jit_nfloat_ne", (void *)jit_nfloat_ne},
	{"jit_nfloat_neg", (void *)jit_nfloat_neg},
	{"jit_nfloat_pow", (void *)jit_nfloat_pow},
	{"jit_nfloat_rem", (void *)jit_nfloat_rem},
	{"jit_nfloat_rint", (void *)jit_nfloat_rint},
	{"jit_nfloat_round", (void *)jit_nfloat_round},
	{"jit_nfloat_sign", (void *)jit_nfloat_sign},
	{"jit_nfloat_sin", (void *)jit_nfloat_sin},
	{"jit_nfloat_sinh", (void *)jit_nfloat_sinh},
	{"jit_nfloat_sqrt", (void *)jit_nfloat_sqrt},
	{"jit_nfloat_sub", (void *)jit_nfloat_sub},
	{"jit_nfloat_tan", (void *)jit_nfloat_tan},
	{"jit_nfloat_tanh", (void *)jit_nfloat_tanh},
	{"jit_nfloat_to_float32", (void *)jit_nfloat_to_float32},
	{"jit_nfloat_to_float64", (void *)jit_nfloat_to_float64},
	{"jit_nfloat_to_int", (void *)jit_nfloat_to_int},
	{"jit_nfloat_to_int_ovf", (void *)jit_nfloat_to_int_ovf},
	{"jit_nfloat_to_long", (void *)jit_nfloat_to_long},
	{"jit_nfloat_to_long_ovf", (void *)jit_nfloat_to_long_ovf},
	{"jit_nfloat_to_uint", (void *)jit_nfloat_to_uint},
	{"jit_nfloat_to_uint_ovf", (void *)jit_nfloat_to_uint_ovf},
	{"jit_nfloat_to_ulong", (void *)jit_nfloat_to_ulong},
	{"jit_nfloat_to_ulong_ovf", (void *)jit_nfloat_to_ulong_ovf},
	{"jit_nfloat_trunc", (void *)jit_nfloat_trunc},
	{"jit_uint_add", (void *)jit_uint_add},
	{"jit_uint_add_ovf", (void *)jit_uint_add_ovf},
	{"jit_uint_and", (void *)jit_uint_and},
	{"jit_uint_cmp", (void *)jit_uint_cmp},
	{"jit_uint_div", (void *)jit_uint_div},
	{"jit_uint_eq", (void *)jit_uint_eq},
	{"jit_uint_ge", (void *)jit_uint_ge},
	{"jit_uint_gt", (void *)jit_uint_gt},
	{"jit_uint_le", (void *)jit_uint_le},
	{"jit_uint_lt", (void *)jit_uint_lt},
	{"jit_uint_max", (void *)jit_uint_max},
	{"jit_uint_min", (void *)jit_uint_min},
	{"jit_uint_mul", (void *)jit_uint_mul},
	{"jit_uint_mul_ovf", (void *)jit_uint_mul_ovf},
	{"jit_uint_ne", (void *)jit_uint_ne},
	{"jit_uint_neg", (void *)jit_uint_neg},
	{"jit_uint_not", (void *)jit_uint_not},
	{"jit_uint_or", (void *)jit_uint_or},
	{"jit_uint_rem", (void *)jit_uint_rem},
	{"jit_uint_shl", (void *)jit_uint_shl},
	{"jit_uint_shr", (void *)jit_uint_shr},
	{"jit_uint_sub", (void *)jit_uint_sub},
	{"jit_uint_sub_ovf", (void *)jit_uint_sub_ovf},
	{"jit_uint_to_float32", (void *)jit_uint_to_float32},
	{"jit_uint_to_float64", (void *)jit_uint_to_float64},
	{"jit_uint_to_int", (void *)jit_uint_to_int},
	{"jit_uint_to_int_ovf", (void *)jit_uint_to_int_ovf},
	{"jit_uint_to_long", (void *)jit_uint_to_long},
	{"jit_uint_to_long_ovf", (void *)jit_uint_to_long_ovf},
	{"jit_uint_to_nfloat", (void *)jit_uint_to_nfloat},
	{"jit_uint_to_uint", (void *)jit_uint_to_uint},
	{"jit_uint_to_uint_ovf", (void *)jit_uint_to_uint_ovf},
	{"jit_uint_to_ulong", (void *)jit_uint_to_ulong},
	{"jit_uint_to_ulong_ovf", (void *)jit_uint_to_ulong_ovf},
	{"jit_uint_xor", (void *)jit_uint_xor},
	{"jit_ulong_add", (void *)jit_ulong_add},
	{"jit_ulong_add_ovf", (void *)jit_ulong_add_ovf},
	{"jit_ulong_and", (void *)jit_ulong_and},
	{"jit_ulong_cmp", (void *)jit_ulong_cmp},
	{"jit_ulong_div", (void *)jit_ulong_div},
	{"jit_ulong_eq", (void *)jit_ulong_eq},
	{"jit_ulong_ge", (void *)jit_ulong_ge},
	{"jit_ulong_gt", (void *)jit_ulong_gt},
	{"jit_ulong_le", (void *)jit_ulong_le},
	{"jit_ulong_lt", (void *)jit_ulong_lt},
	{"jit_ulong_max", (void *)jit_ulong_max},
	{"jit_ulong_min", (void *)jit_ulong_min},
	{"jit_ulong_mul", (void *)jit_ulong_mul},
	{"jit_ulong_mul_ovf", (void *)jit_ulong_mul_ovf},
	{"jit_ulong_ne", (void *)jit_ulong_ne},
	{"jit_ulong_neg", (void *)jit_ulong_neg},
	{"jit_ulong_not", (void *)jit_ulong_not},
	{"jit_ulong_or", (void *)jit_ulong_or},
	{"jit_ulong_rem", (void *)jit_ulong_rem},
	{"jit_ulong_shl", (void *)jit_ulong_shl},
	{"jit_ulong_shr", (void *)jit_ulong_shr},
	{"jit_ulong_sub", (void *)jit_ulong_sub},
	{"jit_ulong_sub_ovf", (void *)jit_ulong_sub_ovf},
	{"jit_ulong_to_float32", (void *)jit_ulong_to_float32},
	{"jit_ulong_to_float64", (void *)jit_ulong_to_float64},
	{"jit_ulong_to_int", (void *)jit_ulong_to_int},
	{"jit_ulong_to_int_ovf", (void *)jit_ulong_to_int_ovf},
	{"jit_ulong_to_long", (void *)jit_ulong_to_long},
	{"jit_ulong_to_long_ovf", (void *)jit_ulong_to_long_ovf},
	{"jit_ulong_to_nfloat", (void *)jit_ulong_to_nfloat},
	{"jit_ulong_to_uint", (void *)jit_ulong_to_uint},
	{"jit_ulong_to_uint_ovf", (void *)jit_ulong_to_uint_ovf},
	{"jit_ulong_to_ulong", (void *)jit_ulong_to_ulong},
	{"jit_ulong_to_ulong_ovf", (void *)jit_ulong_to_ulong_ovf},
	{"jit_ulong_xor", (void *)jit_ulong_xor},
};
int const _jit_num_internal_symbols =
	(sizeof(_jit_internal_symbols) / sizeof(jit_internalsym));
