# Generated by default/object.tt
package Paws::LexModelsV2::KendraConfiguration;
  use Moose;
  has KendraIndex => (is => 'ro', isa => 'Str', request_name => 'kendraIndex', traits => ['NameInRequest'], required => 1);
  has QueryFilterString => (is => 'ro', isa => 'Str', request_name => 'queryFilterString', traits => ['NameInRequest']);
  has QueryFilterStringEnabled => (is => 'ro', isa => 'Bool', request_name => 'queryFilterStringEnabled', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::KendraConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::KendraConfiguration object:

  $service_obj->Method(Att1 => { KendraIndex => $value, ..., QueryFilterStringEnabled => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::KendraConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->KendraIndex

=head1 DESCRIPTION

Provides configuration information for the AMAZON.KendraSearchIntent
intent. When you use this intent, Amazon Lex searches the specified
Amazon Kendra index and returns documents from the index that match the
user's utterance.

=head1 ATTRIBUTES


=head2 B<REQUIRED> KendraIndex => Str

The Amazon Resource Name (ARN) of the Amazon Kendra index that you want
the AMAZON.KendraSearchIntent intent to search. The index must be in
the same account and Region as the Amazon Lex bot.


=head2 QueryFilterString => Str

A query filter that Amazon Lex sends to Amazon Kendra to filter the
response from a query. The filter is in the format defined by Amazon
Kendra. For more information, see Filtering queries
(https://docs.aws.amazon.com/kendra/latest/dg/filtering.html).


=head2 QueryFilterStringEnabled => Bool

Determines whether the AMAZON.KendraSearchIntent intent uses a custom
query string to query the Amazon Kendra index.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

