/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.util.concurrent.Future;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;

public class AsyncInvokerImpl
implements AsyncInvoker {
    private WebClient wc;

    public AsyncInvokerImpl(WebClient wc) {
        this.wc = wc;
    }

    @Override
    public Future<Response> get() {
        return this.get(Response.class);
    }

    @Override
    public <T> Future<T> get(Class<T> responseType) {
        return this.method("GET", responseType);
    }

    @Override
    public <T> Future<T> get(GenericType<T> responseType) {
        return this.method("GET", responseType);
    }

    @Override
    public <T> Future<T> get(InvocationCallback<T> callback) {
        return this.method("GET", callback);
    }

    @Override
    public Future<Response> put(Entity<?> entity) {
        return this.put(entity, Response.class);
    }

    @Override
    public <T> Future<T> put(Entity<?> entity, Class<T> responseType) {
        return this.method("PUT", entity, responseType);
    }

    @Override
    public <T> Future<T> put(Entity<?> entity, GenericType<T> responseType) {
        return this.method("PUT", entity, responseType);
    }

    @Override
    public <T> Future<T> put(Entity<?> entity, InvocationCallback<T> callback) {
        return this.method("PUT", entity, callback);
    }

    @Override
    public Future<Response> post(Entity<?> entity) {
        return this.post(entity, Response.class);
    }

    @Override
    public <T> Future<T> post(Entity<?> entity, Class<T> responseType) {
        return this.method("POST", entity, responseType);
    }

    @Override
    public <T> Future<T> post(Entity<?> entity, GenericType<T> responseType) {
        return this.method("POST", entity, responseType);
    }

    @Override
    public <T> Future<T> post(Entity<?> entity, InvocationCallback<T> callback) {
        return this.method("POST", entity, callback);
    }

    @Override
    public Future<Response> delete() {
        return this.delete(Response.class);
    }

    @Override
    public <T> Future<T> delete(Class<T> responseType) {
        return this.method("DELETE", responseType);
    }

    @Override
    public <T> Future<T> delete(GenericType<T> responseType) {
        return this.method("DELETE", responseType);
    }

    @Override
    public <T> Future<T> delete(InvocationCallback<T> callback) {
        return this.method("DELETE", callback);
    }

    @Override
    public Future<Response> head() {
        return this.method("HEAD");
    }

    @Override
    public Future<Response> head(InvocationCallback<Response> callback) {
        return this.method("HEAD", callback);
    }

    @Override
    public Future<Response> options() {
        return this.options(Response.class);
    }

    @Override
    public <T> Future<T> options(Class<T> responseType) {
        return this.method("OPTIONS", responseType);
    }

    @Override
    public <T> Future<T> options(GenericType<T> responseType) {
        return this.method("OPTIONS", responseType);
    }

    @Override
    public <T> Future<T> options(InvocationCallback<T> callback) {
        return this.method("OPTIONS", callback);
    }

    @Override
    public Future<Response> trace() {
        return this.trace(Response.class);
    }

    @Override
    public <T> Future<T> trace(Class<T> responseType) {
        return this.method("TRACE", responseType);
    }

    @Override
    public <T> Future<T> trace(GenericType<T> responseType) {
        return this.method("TRACE", responseType);
    }

    @Override
    public <T> Future<T> trace(InvocationCallback<T> callback) {
        return this.method("TRACE", callback);
    }

    @Override
    public Future<Response> method(String name) {
        return this.method(name, Response.class);
    }

    @Override
    public <T> Future<T> method(String name, Class<T> responseType) {
        return this.wc.doInvokeAsync(name, null, null, null, responseType, responseType, null);
    }

    @Override
    public <T> Future<T> method(String name, GenericType<T> responseType) {
        return this.wc.doInvokeAsync(name, null, null, null, responseType.getRawType(), responseType.getType(), null);
    }

    @Override
    public <T> Future<T> method(String name, InvocationCallback<T> callback) {
        return this.wc.doInvokeAsyncCallback(name, null, null, null, callback);
    }

    @Override
    public Future<Response> method(String name, Entity<?> entity) {
        return this.method(name, entity, Response.class);
    }

    @Override
    public <T> Future<T> method(String name, Entity<?> entity, Class<T> responseType) {
        return this.wc.doInvokeAsync(name, entity, null, null, responseType, responseType, null);
    }

    @Override
    public <T> Future<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.wc.doInvokeAsync(name, entity, null, null, responseType.getRawType(), responseType.getType(), null);
    }

    @Override
    public <T> Future<T> method(String name, Entity<?> entity, InvocationCallback<T> callback) {
        return this.wc.doInvokeAsyncCallback(name, entity, null, null, callback);
    }
}

