##----------------------------------------------------------------------------
## HTML Object - ~/lib/HTML/Object/DOM/Element/BR.pm
## Version v0.1.0
## Copyright(c) 2021 DEGUEST Pte. Ltd.
## Author: Jacques Deguest <jack@deguest.jp>
## Created 2021/12/23
## Modified 2021/12/23
## All rights reserved
## 
## 
## This program is free software; you can redistribute  it  and/or  modify  it
## under the same terms as Perl itself.
##----------------------------------------------------------------------------
package HTML::Object::DOM::Element::BR;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( HTML::Object::DOM::Element );
    our $VERSION = 'v0.1.0';
};

sub init
{
    my $self = shift( @_ );
    $self->{_init_strict_use_sub} = 1;
    $self->SUPER::init( @_ ) || return( $self->pass_error );
    $self->{tag} = 'br' if( !CORE::length( "$self->{tag}" ) );
    return( $self );
}

sub clear : lvalue { return( shift->_set_get_property( 'clear', @_ ) ); }

1;
# XXX POD
__END__

=encoding utf-8

=head1 NAME

HTML::Object::DOM::Element::BR - HTML Object DOM Line Break Class

=head1 SYNOPSIS

    use HTML::Object::DOM::Element::BR;
    my $this = HTML::Object::DOM::Element::BR->new || 
        die( HTML::Object::DOM::Element::BR->error, "\n" );

=head1 VERSION

    v0.1.0

=head1 DESCRIPTION

This interface represents a HTML line break element (<br>). It inherits from L<HTML::Object::Element>.

=head1 INHERITANCE

    +-----------------------+     +---------------------------+     +-------------------------+     +----------------------------+     +--------------------------------+
    | HTML::Object::Element | --> | HTML::Object::EventTarget | --> | HTML::Object::DOM::Node | --> | HTML::Object::DOM::Element | --> | HTML::Object::DOM::Element::BR |
    +-----------------------+     +---------------------------+     +-------------------------+     +----------------------------+     +--------------------------------+

=head1 PROPERTIES

Inherits properties from its parent L<HTML::Object::DOM::Element>

=head2 clear

Is a string indicating the flow of text around floating objects.

See also L<Mozilla documentation|https://developer.mozilla.org/en-US/docs/Web/API/HTMLBRElement/clear>

=head1 METHODS

Inherits methods from its parent L<HTML::Object::DOM::Element>

=head1 AUTHOR

Jacques Deguest E<lt>F<jack@deguest.jp>E<gt>

=head1 SEE ALSO

L<Mozilla documentation|https://developer.mozilla.org/en-US/docs/Web/API/HTMLBRElement>, L<Mozilla documentation on br element|https://developer.mozilla.org/en-US/docs/Web/HTML/Element/br>

=head1 COPYRIGHT & LICENSE

Copyright(c) 2021 DEGUEST Pte. Ltd.

All rights reserved

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=cut
