package Locales::DB::Territory::wae;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::wae::VERSION = '0.09';

$Locales::DB::Territory::wae::cldr_version = '2.0';

%Locales::DB::Territory::wae::code_to_name = (
    '001' => 'Wäld',
    '002' => 'Afrika',
    '003' => 'Nordamerika',
    '005' => 'Südamerika',
    '009' => 'Ozeanie',
    '011' => 'Weštafrika',
    '013' => 'Zentralamerika',
    '014' => 'Oštafrika',
    '015' => 'Nordafrika',
    '017' => 'Mittelafrika',
    '018' => "Südličs\ Afrika",
    '019' => "Amerikaniš\ Kontinänt",
    '021' => "Nördličs\ Amerika",
    '029' => 'Karibik',
    '030' => 'Oštasie',
    '034' => 'Südasie',
    '035' => 'Südoštasie',
    '039' => 'Südeuropa',
    '053' => "Auštralie\ und\ Niwséland",
    '054' => 'Melanesie',
    '057' => "Mikronesišes\ Inselgebiet",
    '061' => 'Polinesie',
    '062' => "South\-Central\ Asia",
    142   => 'Asie',
    143   => 'Zentralasie',
    145   => 'Weštasie',
    150   => 'Europa',
    151   => 'Ošteuropa',
    154   => 'Nordeuropa',
    155   => 'Wešteuropa',
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => 'Latíamerika',
    830   => "Channel\ Islands",
    'ac'  => 'Himmelfártsinsla',
    'ad'  => 'Andorra',
    'ae'  => "Vereinigti\ Arabiše\ Emirat",
    'af'  => 'Afganištan',
    'ag'  => "Antigua\ und\ Barbuda",
    'ai'  => 'Anguilla',
    'al'  => 'Albanie',
    'am'  => 'Armenie',
    'an'  => "Holändiši\ Antillä",
    'ao'  => 'Angola',
    'aq'  => 'Antarktis',
    'ar'  => 'Argentinie',
    'as'  => "Amerikaniš\ Samoa",
    'at'  => 'Öštrič',
    'au'  => 'Australie',
    'aw'  => 'Aruba',
    'ax'  => 'Alandinslä',
    'az'  => 'Aserbaidšan',
    'ba'  => "Bosnie\ und\ Herzegovina",
    'bb'  => 'Barbados',
    'bd'  => 'Bangladeš',
    'be'  => 'Belgie',
    'bf'  => "Burkina\ Faso",
    'bg'  => 'Bulgarie',
    'bh'  => 'Bačrain',
    'bi'  => 'Burundi',
    'bj'  => 'Benin',
    'bl'  => "St\.\ Bartholomäus\-Insla",
    'bm'  => 'Bermuda',
    'bn'  => 'Brunei',
    'bo'  => 'Boliwie',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Brasilie',
    'bs'  => 'Bahamas',
    'bt'  => 'Bhutan',
    'bv'  => 'Bouvetinsla',
    'bw'  => 'Botswana',
    'by'  => 'Wísrussland',
    'bz'  => 'Belize',
    'ca'  => 'Kanada',
    'cc'  => 'Kokosinslä',
    'cd'  => "Kongo\ \[Demokratiši\ Rebublik\]",
    'cf'  => "Zentralafrikaniši\ Rebublik",
    'cg'  => "Kongo\ \[Rebublik\]",
    'ch'  => 'Schwiz',
    'ci'  => "Côte\ d\'Ivoire",
    'ck'  => 'Cookinslä',
    'cl'  => 'Tšile',
    'cm'  => 'Kamerun',
    'cn'  => 'China',
    'co'  => 'Kolumbie',
    'cp'  => "Clipperton\ Insla",
    'cr'  => "Costa\ Rica",
    'cs'  => "Serbia\ and\ Montenegro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Kuba',
    'cv'  => "Kap\ Verde",
    'cx'  => 'Wienäčtsinslä',
    'cy'  => 'Zypre',
    'cz'  => 'Tšečie',
    'dd'  => "East\ Germany",
    'de'  => 'Titšland',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Dšibuti',
    'dk'  => 'Dänemark',
    'dm'  => 'Doninica',
    'do'  => "Dominikaniši\ Rebublik",
    'dz'  => 'Algerie',
    'ea'  => "Ceuta\ und\ Melilla",
    'ec'  => 'Ecuador',
    'ee'  => 'Eštland',
    'eg'  => 'Egypte',
    'eh'  => 'Weštsahara',
    'er'  => 'Eritrea',
    'es'  => 'Schpanie',
    'et'  => 'Ethiopie',
    'eu'  => "Europäiši\ Unio",
    'fi'  => 'Finnland',
    'fj'  => 'Fidši',
    'fk'  => "Falklandinslä\ \[Malwine\]",
    'fm'  => 'Mikronesie',
    'fo'  => 'Färöe',
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Frankrič',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gabon',
    'gb'  => 'England',
    'gd'  => 'Grenada',
    'ge'  => 'Georgie',
    'gf'  => "Französiš\ Guiana",
    'gg'  => 'Guernsey',
    'gh'  => 'Gana',
    'gi'  => 'Gibraltar',
    'gl'  => 'Grönland',
    'gm'  => 'Gambia',
    'gn'  => 'Ginea',
    'gp'  => 'Guadeloupe',
    'gq'  => 'Equatorialginea',
    'gr'  => 'Gričeland',
    'gs'  => "Südgeorgie\ und\ d\'südliče\ Senwičinslä",
    'gt'  => 'Guatemala',
    'gu'  => 'Guam',
    'gw'  => "Ginea\ Bissau",
    'gy'  => 'Guyana',
    'hk'  => 'Hongkong',
    'hm'  => "Heard\-\ und\ McDonald\-Inslä",
    'hn'  => 'Honduras',
    'hr'  => 'Kroatie',
    'ht'  => 'Haiti',
    'hu'  => 'Ungare',
    'ic'  => "Kanariše\ Inslä",
    'id'  => 'Indonesie',
    'ie'  => 'Irland',
    'il'  => 'Israel',
    'im'  => "Isle\ of\ Man",
    'in'  => 'Indie',
    'io'  => "Britišes\ Territorium\ em\ indiše\ Ozean",
    'iq'  => 'Irak',
    'ir'  => 'Iran',
    'is'  => 'Island',
    'it'  => 'Italie',
    'je'  => 'Jersey',
    'jm'  => 'Jamaika',
    'jo'  => 'Jordanie',
    'jp'  => 'Japan',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kenya',
    'kg'  => 'Kirgištan',
    'kh'  => 'Kambodša',
    'ki'  => 'Kiribati',
    'km'  => 'Komore',
    'kn'  => "St\.\ Kitts\ und\ Nevis",
    'kp'  => 'Nordkorea',
    'kr'  => 'Südkorea',
    'kw'  => 'Kuweit',
    'ky'  => 'Kaimaninslä',
    'kz'  => 'Kasačstan',
    'la'  => 'Laos',
    'lb'  => 'Libanon',
    'lc'  => "St\.\ Lucia",
    'li'  => 'Liečteštei',
    'lk'  => "Sri\ Lanka",
    'lr'  => 'Liberia',
    'ls'  => 'Lesotho',
    'lt'  => 'Litaue',
    'lu'  => 'Luxeburg',
    'lv'  => 'Lettland',
    'ly'  => 'Lübie',
    'ma'  => 'Maroko',
    'mc'  => 'Monago',
    'md'  => 'Moldau',
    'me'  => 'Montenegro',
    'mf'  => "St\.\ Martin",
    'mg'  => 'Madagaskar',
    'mh'  => 'Maršalinslä',
    'mi'  => "Midway\ Islands",
    'mk'  => "Mazedonie\ \[EJR\]",
    'ml'  => 'Mali',
    'mm'  => 'Burma',
    'mn'  => 'Mongolei',
    'mo'  => 'Makau',
    'mp'  => "Nördliči\ Mariane",
    'mq'  => 'Martinique',
    'mr'  => 'Mauretanie',
    'ms'  => 'Monserrat',
    'mt'  => 'Malta',
    'mu'  => 'Mauritius',
    'mv'  => 'Malediwe',
    'mw'  => 'Malawi',
    'mx'  => 'Mexiko',
    'my'  => 'Malaysia',
    'mz'  => 'Mosambik',
    'na'  => 'Namibia',
    'nc'  => 'Niwkaledonie',
    'ne'  => 'Niger',
    'nf'  => 'Norfolkinsla',
    'ng'  => 'Nigeria',
    'ni'  => 'Nicaragua',
    'nl'  => 'Holand',
    'no'  => 'Norwäge',
    'np'  => 'Nepal',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => 'Niwséland',
    'om'  => 'Oman',
    'pa'  => 'Panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Peru',
    'pf'  => "Französiš\ Polinesie",
    'pg'  => "Papua\ Niwginea",
    'ph'  => 'Philippine',
    'pk'  => 'Pakištan',
    'pl'  => 'Pole',
    'pm'  => "St\.\ Pierre\ und\ Miquelon",
    'pn'  => 'Pitcairn',
    'pr'  => "Puerto\ Rico",
    'ps'  => 'Paleština',
    'pt'  => 'Portugal',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paraguai',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Katar',
    'qo'  => "Üssers\ Ozeanie",
    're'  => 'Réunion',
    'ro'  => 'Rumänie',
    'rs'  => 'Serbie',
    'ru'  => 'Russland',
    'rw'  => 'Ruanda',
    'sa'  => "Saudi\ Arabie",
    'sb'  => 'Salomone',
    'sc'  => 'Sečelle',
    'sd'  => 'Sudan',
    'se'  => 'Schwede',
    'sg'  => 'Singapur',
    'sh'  => "St\.\ Helena",
    'si'  => 'Slowenie',
    'sj'  => "Svalbard\ und\ Jan\ Mayen",
    'sk'  => 'Slowakei',
    'sl'  => "Sierra\ Leone",
    'sm'  => "San\ Marino",
    'sn'  => 'Senegal',
    'so'  => 'Somalia',
    'sr'  => 'Suriname',
    'st'  => "São\ Tomé\ and\ Príncipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "El\ Salvador",
    'sy'  => 'Sürie',
    'sz'  => 'Swasiland',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Turks\-\ und\ Caicosinslä",
    'td'  => 'Tšad',
    'tf'  => "Französiši\ Süd\-\ und\ Antarktisgebiet",
    'tg'  => 'Togo',
    'th'  => 'Thailand',
    'tj'  => 'Tadšikistan',
    'tk'  => 'Tokelau',
    'tl'  => 'Wešttimor',
    'tm'  => 'Turkmeništan',
    'tn'  => 'Tunesie',
    'to'  => 'Tonga',
    'tr'  => 'Türkei',
    'tt'  => "Trinidad\ und\ Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'Taiwan',
    'tz'  => 'Tansania',
    'ua'  => 'Ukraine',
    'ug'  => 'Uganda',
    'um'  => "Amerikaniš\ Ozeanie",
    'us'  => 'Amerika',
    'uy'  => 'Urugauy',
    'uz'  => 'Usbekištan',
    'va'  => 'Vatikan',
    'vc'  => "St\.\ Vincent\ und\ d\'Grenadine",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuela',
    'vg'  => "Britiši\ Jungfröiwinslä",
    'vi'  => "Amerikaniši\ Jungfröiwinslä",
    'vn'  => 'Vietnam',
    'vu'  => 'Vanuatu',
    'wf'  => "Wallis\ und\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Jéme',
    'yt'  => 'Moyette',
    'za'  => 'Südafrika',
    'zm'  => 'Sambia',
    'zw'  => 'Simbabwe',
    'zz'  => "Unbekannti\ Regio",
);

%Locales::DB::Territory::wae::name_to_code = (
    'afganištan'                               => 'af',
    'afrika'                                    => '002',
    'alandinslä'                               => 'ax',
    'albanie'                                   => 'al',
    'algerie'                                   => 'dz',
    'amerika'                                   => 'us',
    'amerikanišijungfröiwinslä'              => 'vi',
    'amerikaniškontinänt'                     => '019',
    'amerikanišozeanie'                        => 'um',
    'amerikanišsamoa'                          => 'as',
    'andorra'                                   => 'ad',
    'angola'                                    => 'ao',
    'anguilla'                                  => 'ai',
    'antarktis'                                 => 'aq',
    'antiguaundbarbuda'                         => 'ag',
    'argentinie'                                => 'ar',
    'armenie'                                   => 'am',
    'aruba'                                     => 'aw',
    'aserbaidšan'                              => 'az',
    'asie'                                      => 142,
    'australie'                                 => 'au',
    'auštralieundniwséland'                   => '053',
    'bahamas'                                   => 'bs',
    'bangladeš'                                => 'bd',
    'barbados'                                  => 'bb',
    'bačrain'                                  => 'bh',
    'belgie'                                    => 'be',
    'belize'                                    => 'bz',
    'benin'                                     => 'bj',
    'bermuda'                                   => 'bm',
    'bhutan'                                    => 'bt',
    'boliwie'                                   => 'bo',
    'bosnieundherzegovina'                      => 'ba',
    'botswana'                                  => 'bw',
    'bouvetinsla'                               => 'bv',
    'brasilie'                                  => 'br',
    'britishantarcticterritory'                 => 'bq',
    'britišesterritoriumemindišeozean'        => 'io',
    'britišijungfröiwinslä'                  => 'vg',
    'brunei'                                    => 'bn',
    'bulgarie'                                  => 'bg',
    'burkinafaso'                               => 'bf',
    'burma'                                     => 'mm',
    'burundi'                                   => 'bi',
    'cantonandenderburyislands'                 => 'ct',
    'ceutaundmelilla'                           => 'ea',
    'channelislands'                            => 830,
    'china'                                     => 'cn',
    'clippertoninsla'                           => 'cp',
    'commonwealthofindependentstates'           => 172,
    'cookinslä'                                => 'ck',
    'costarica'                                 => 'cr',
    'czechoslovakia'                            => 200,
    'côtedivoire'                              => 'ci',
    'diegogarcia'                               => 'dg',
    'dominikaniširebublik'                     => 'do',
    'doninica'                                  => 'dm',
    'dronningmaudland'                          => 'nq',
    'dänemark'                                 => 'dk',
    'dšibuti'                                  => 'dj',
    'eastgermany'                               => 'dd',
    'ecuador'                                   => 'ec',
    'egypte'                                    => 'eg',
    'elsalvador'                                => 'sv',
    'england'                                   => 'gb',
    'equatorialginea'                           => 'gq',
    'eritrea'                                   => 'er',
    'ethiopie'                                  => 'et',
    'europa'                                    => 150,
    'europäišiunio'                           => 'eu',
    'eštland'                                  => 'ee',
    'falklandinslämalwine'                     => 'fk',
    'fidši'                                    => 'fj',
    'finnland'                                  => 'fi',
    'frankrič'                                 => 'fr',
    'französišguiana'                         => 'gf',
    'französišisüdundantarktisgebiet'        => 'tf',
    'französišpolinesie'                      => 'pf',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'färöe'                                   => 'fo',
    'gabon'                                     => 'ga',
    'gambia'                                    => 'gm',
    'gana'                                      => 'gh',
    'georgie'                                   => 'ge',
    'gibraltar'                                 => 'gi',
    'ginea'                                     => 'gn',
    'gineabissau'                               => 'gw',
    'grenada'                                   => 'gd',
    'gričeland'                                => 'gr',
    'grönland'                                 => 'gl',
    'guadeloupe'                                => 'gp',
    'guam'                                      => 'gu',
    'guatemala'                                 => 'gt',
    'guernsey'                                  => 'gg',
    'guyana'                                    => 'gy',
    'haiti'                                     => 'ht',
    'heardundmcdonaldinslä'                    => 'hm',
    'himmelfártsinsla'                         => 'ac',
    'holand'                                    => 'nl',
    'holändišiantillä'                       => 'an',
    'honduras'                                  => 'hn',
    'hongkong'                                  => 'hk',
    'indie'                                     => 'in',
    'indonesie'                                 => 'id',
    'irak'                                      => 'iq',
    'iran'                                      => 'ir',
    'irland'                                    => 'ie',
    'island'                                    => 'is',
    'isleofman'                                 => 'im',
    'israel'                                    => 'il',
    'italie'                                    => 'it',
    'jamaika'                                   => 'jm',
    'japan'                                     => 'jp',
    'jersey'                                    => 'je',
    'johnstonisland'                            => 'jt',
    'jordanie'                                  => 'jo',
    'jéme'                                     => 'ye',
    'kaimaninslä'                              => 'ky',
    'kambodša'                                 => 'kh',
    'kamerun'                                   => 'cm',
    'kanada'                                    => 'ca',
    'kanarišeinslä'                           => 'ic',
    'kapverde'                                  => 'cv',
    'karibik'                                   => '029',
    'kasačstan'                                => 'kz',
    'katar'                                     => 'qa',
    'kenya'                                     => 'ke',
    'kirgištan'                                => 'kg',
    'kiribati'                                  => 'ki',
    'kokosinslä'                               => 'cc',
    'kolumbie'                                  => 'co',
    'komore'                                    => 'km',
    'kongodemokratiširebublik'                 => 'cd',
    'kongorebublik'                             => 'cg',
    'kroatie'                                   => 'hr',
    'kuba'                                      => 'cu',
    'kuweit'                                    => 'kw',
    'laos'                                      => 'la',
    'latíamerika'                              => 419,
    'lesotho'                                   => 'ls',
    'lettland'                                  => 'lv',
    'libanon'                                   => 'lb',
    'liberia'                                   => 'lr',
    'liečteštei'                              => 'li',
    'litaue'                                    => 'lt',
    'luxeburg'                                  => 'lu',
    'lübie'                                    => 'ly',
    'madagaskar'                                => 'mg',
    'makau'                                     => 'mo',
    'malawi'                                    => 'mw',
    'malaysia'                                  => 'my',
    'malediwe'                                  => 'mv',
    'mali'                                      => 'ml',
    'malta'                                     => 'mt',
    'maroko'                                    => 'ma',
    'martinique'                                => 'mq',
    'maršalinslä'                             => 'mh',
    'mauretanie'                                => 'mr',
    'mauritius'                                 => 'mu',
    'mazedonieejr'                              => 'mk',
    'melanesie'                                 => '054',
    'metropolitanfrance'                        => 'fx',
    'mexiko'                                    => 'mx',
    'midwayislands'                             => 'mi',
    'mikronesie'                                => 'fm',
    'mikronesišesinselgebiet'                  => '057',
    'mittelafrika'                              => '017',
    'moldau'                                    => 'md',
    'monago'                                    => 'mc',
    'mongolei'                                  => 'mn',
    'monserrat'                                 => 'ms',
    'montenegro'                                => 'me',
    'mosambik'                                  => 'mz',
    'moyette'                                   => 'yt',
    'namibia'                                   => 'na',
    'nauru'                                     => 'nr',
    'nepal'                                     => 'np',
    'neutralzone'                               => 'nt',
    'nicaragua'                                 => 'ni',
    'niger'                                     => 'ne',
    'nigeria'                                   => 'ng',
    'niue'                                      => 'nu',
    'niwkaledonie'                              => 'nc',
    'niwséland'                                => 'nz',
    'nordafrika'                                => '015',
    'nordamerika'                               => '003',
    'nordeuropa'                                => 154,
    'nordkorea'                                 => 'kp',
    'norfolkinsla'                              => 'nf',
    'northvietnam'                              => 'vd',
    'norwäge'                                  => 'no',
    'nördličimariane'                         => 'mp',
    'nördličsamerika'                         => '021',
    'oman'                                      => 'om',
    'ozeanie'                                   => '009',
    'oštafrika'                                => '014',
    'oštasie'                                  => '030',
    'ošteuropa'                                => 151,
    'pacificislandstrustterritory'              => 'pc',
    'pakištan'                                 => 'pk',
    'palau'                                     => 'pw',
    'paleština'                                => 'ps',
    'panama'                                    => 'pa',
    'panamacanalzone'                           => 'pz',
    'papuaniwginea'                             => 'pg',
    'paraguai'                                  => 'py',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'peru'                                      => 'pe',
    'philippine'                                => 'ph',
    'pitcairn'                                  => 'pn',
    'pole'                                      => 'pl',
    'polinesie'                                 => '061',
    'portugal'                                  => 'pt',
    'puertorico'                                => 'pr',
    'ruanda'                                    => 'rw',
    'rumänie'                                  => 'ro',
    'russland'                                  => 'ru',
    'réunion'                                  => 're',
    'salomone'                                  => 'sb',
    'sambia'                                    => 'zm',
    'samoa'                                     => 'ws',
    'sanmarino'                                 => 'sm',
    'saudiarabie'                               => 'sa',
    'schpanie'                                  => 'es',
    'schwede'                                   => 'se',
    'schwiz'                                    => 'ch',
    'senegal'                                   => 'sn',
    'serbiaandmontenegro'                       => 'cs',
    'serbie'                                    => 'rs',
    'sečelle'                                  => 'sc',
    'sierraleone'                               => 'sl',
    'simbabwe'                                  => 'zw',
    'singapur'                                  => 'sg',
    'slowakei'                                  => 'sk',
    'slowenie'                                  => 'si',
    'somalia'                                   => 'so',
    'southcentralasia'                          => '062',
    'srilanka'                                  => 'lk',
    "st\.bartholomäusinsla"                    => 'bl',
    "st\.helena"                                => 'sh',
    "st\.kittsundnevis"                         => 'kn',
    "st\.lucia"                                 => 'lc',
    "st\.martin"                                => 'mf',
    "st\.pierreundmiquelon"                     => 'pm',
    "st\.vincentunddgrenadine"                  => 'vc',
    'sudan'                                     => 'sd',
    'suriname'                                  => 'sr',
    'svalbardundjanmayen'                       => 'sj',
    'swasiland'                                 => 'sz',
    'sãotoméandpríncipe'                     => 'st',
    'südafrika'                                => 'za',
    'südamerika'                               => '005',
    'südasie'                                  => '034',
    'südeuropa'                                => '039',
    'südgeorgieunddsüdličesenwičinslä'     => 'gs',
    'südkorea'                                 => 'kr',
    'südličsafrika'                           => '018',
    'südoštasie'                              => '035',
    'sürie'                                    => 'sy',
    'tadšikistan'                              => 'tj',
    'taiwan'                                    => 'tw',
    'tansania'                                  => 'tz',
    'thailand'                                  => 'th',
    'titšland'                                 => 'de',
    'togo'                                      => 'tg',
    'tokelau'                                   => 'tk',
    'tonga'                                     => 'to',
    'trinidadundtobago'                         => 'tt',
    'tristandacunha'                            => 'ta',
    'tunesie'                                   => 'tn',
    'turkmeništan'                             => 'tm',
    'turksundcaicosinslä'                      => 'tc',
    'tuvalu'                                    => 'tv',
    'türkei'                                   => 'tr',
    'tšad'                                     => 'td',
    'tšečie'                                  => 'cz',
    'tšile'                                    => 'cl',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    'uganda'                                    => 'ug',
    'ukraine'                                   => 'ua',
    'unbekanntiregio'                           => 'zz',
    'ungare'                                    => 'hu',
    'unionofsovietsocialistrepublics'           => 'su',
    'urugauy'                                   => 'uy',
    'usbekištan'                               => 'uz',
    'vanuatu'                                   => 'vu',
    'vatikan'                                   => 'va',
    'venezuela'                                 => 've',
    'vereinigtiarabišeemirat'                  => 'ae',
    'vietnam'                                   => 'vn',
    'wakeisland'                                => 'wk',
    'wallisundfutuna'                           => 'wf',
    'weštafrika'                               => '011',
    'weštasie'                                 => 145,
    'wešteuropa'                               => 155,
    'weštsahara'                               => 'eh',
    'wešttimor'                                => 'tl',
    'wienäčtsinslä'                          => 'cx',
    'wäld'                                     => '001',
    'wísrussland'                              => 'by',
    'zentralafrikaniširebublik'                => 'cf',
    'zentralamerika'                            => '013',
    'zentralasie'                               => 143,
    'zypre'                                     => 'cy',
    'Öštrič'                                 => 'at',
    'Üssersozeanie'                            => 'qo',
);

1;

