# Generated by default/object.tt
package Paws::ApplicationMigration::CPU;
  use Moose;
  has Cores => (is => 'ro', isa => 'Int', request_name => 'cores', traits => ['NameInRequest']);
  has ModelName => (is => 'ro', isa => 'Str', request_name => 'modelName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationMigration::CPU

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationMigration::CPU object:

  $service_obj->Method(Att1 => { Cores => $value, ..., ModelName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationMigration::CPU object:

  $result = $service_obj->Method(...);
  $result->Att1->Cores

=head1 DESCRIPTION

Source server CPU information.

=head1 ATTRIBUTES


=head2 Cores => Int

The number of CPU cores on the source server.


=head2 ModelName => Str

The source server's CPU model name.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationMigration>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

