# Generated by default/object.tt
package Paws::Appflow::ConnectorMetadata;
  use Moose;
  has Amplitude => (is => 'ro', isa => 'Paws::Appflow::AmplitudeMetadata');
  has CustomerProfiles => (is => 'ro', isa => 'Paws::Appflow::CustomerProfilesMetadata');
  has Datadog => (is => 'ro', isa => 'Paws::Appflow::DatadogMetadata');
  has Dynatrace => (is => 'ro', isa => 'Paws::Appflow::DynatraceMetadata');
  has EventBridge => (is => 'ro', isa => 'Paws::Appflow::EventBridgeMetadata');
  has GoogleAnalytics => (is => 'ro', isa => 'Paws::Appflow::GoogleAnalyticsMetadata');
  has Honeycode => (is => 'ro', isa => 'Paws::Appflow::HoneycodeMetadata');
  has InforNexus => (is => 'ro', isa => 'Paws::Appflow::InforNexusMetadata');
  has Marketo => (is => 'ro', isa => 'Paws::Appflow::MarketoMetadata');
  has Redshift => (is => 'ro', isa => 'Paws::Appflow::RedshiftMetadata');
  has S3 => (is => 'ro', isa => 'Paws::Appflow::S3Metadata');
  has Salesforce => (is => 'ro', isa => 'Paws::Appflow::SalesforceMetadata');
  has ServiceNow => (is => 'ro', isa => 'Paws::Appflow::ServiceNowMetadata');
  has Singular => (is => 'ro', isa => 'Paws::Appflow::SingularMetadata');
  has Slack => (is => 'ro', isa => 'Paws::Appflow::SlackMetadata');
  has Snowflake => (is => 'ro', isa => 'Paws::Appflow::SnowflakeMetadata');
  has Trendmicro => (is => 'ro', isa => 'Paws::Appflow::TrendmicroMetadata');
  has Upsolver => (is => 'ro', isa => 'Paws::Appflow::UpsolverMetadata');
  has Veeva => (is => 'ro', isa => 'Paws::Appflow::VeevaMetadata');
  has Zendesk => (is => 'ro', isa => 'Paws::Appflow::ZendeskMetadata');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::ConnectorMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::ConnectorMetadata object:

  $service_obj->Method(Att1 => { Amplitude => $value, ..., Zendesk => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::ConnectorMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->Amplitude

=head1 DESCRIPTION

A structure to specify connector-specific metadata such as
C<oAuthScopes>, C<supportedRegions>, C<privateLinkServiceUrl>, and so
on.

=head1 ATTRIBUTES


=head2 Amplitude => L<Paws::Appflow::AmplitudeMetadata>

The connector metadata specific to Amplitude.


=head2 CustomerProfiles => L<Paws::Appflow::CustomerProfilesMetadata>

The connector metadata specific to Amazon Connect Customer Profiles.


=head2 Datadog => L<Paws::Appflow::DatadogMetadata>

The connector metadata specific to Datadog.


=head2 Dynatrace => L<Paws::Appflow::DynatraceMetadata>

The connector metadata specific to Dynatrace.


=head2 EventBridge => L<Paws::Appflow::EventBridgeMetadata>

The connector metadata specific to Amazon EventBridge.


=head2 GoogleAnalytics => L<Paws::Appflow::GoogleAnalyticsMetadata>

The connector metadata specific to Google Analytics.


=head2 Honeycode => L<Paws::Appflow::HoneycodeMetadata>

The connector metadata specific to Amazon Honeycode.


=head2 InforNexus => L<Paws::Appflow::InforNexusMetadata>

The connector metadata specific to Infor Nexus.


=head2 Marketo => L<Paws::Appflow::MarketoMetadata>

The connector metadata specific to Marketo.


=head2 Redshift => L<Paws::Appflow::RedshiftMetadata>

The connector metadata specific to Amazon Redshift.


=head2 S3 => L<Paws::Appflow::S3Metadata>

The connector metadata specific to Amazon S3.


=head2 Salesforce => L<Paws::Appflow::SalesforceMetadata>

The connector metadata specific to Salesforce.


=head2 ServiceNow => L<Paws::Appflow::ServiceNowMetadata>

The connector metadata specific to ServiceNow.


=head2 Singular => L<Paws::Appflow::SingularMetadata>

The connector metadata specific to Singular.


=head2 Slack => L<Paws::Appflow::SlackMetadata>

The connector metadata specific to Slack.


=head2 Snowflake => L<Paws::Appflow::SnowflakeMetadata>

The connector metadata specific to Snowflake.


=head2 Trendmicro => L<Paws::Appflow::TrendmicroMetadata>

The connector metadata specific to Trend Micro.


=head2 Upsolver => L<Paws::Appflow::UpsolverMetadata>

The connector metadata specific to Upsolver.


=head2 Veeva => L<Paws::Appflow::VeevaMetadata>

The connector metadata specific to Veeva.


=head2 Zendesk => L<Paws::Appflow::ZendeskMetadata>

The connector metadata specific to Zendesk.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

