# Generated by default/object.tt
package Paws::NetworkFirewall::StatefulRule;
  use Moose;
  has Action => (is => 'ro', isa => 'Str', required => 1);
  has Header => (is => 'ro', isa => 'Paws::NetworkFirewall::Header', required => 1);
  has RuleOptions => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::RuleOption]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::StatefulRule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::StatefulRule object:

  $service_obj->Method(Att1 => { Action => $value, ..., RuleOptions => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::StatefulRule object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

A single 5-tuple stateful rule, for use in a stateful rule group.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Action => Str

Defines what Network Firewall should do with the packets in a traffic
flow when the flow matches the stateful rule criteria. For all actions,
Network Firewall performs the specified action and discontinues
stateful inspection of the traffic flow.

The actions for a stateful rule are defined as follows:

=over

=item *

B<PASS> - Permits the packets to go to the intended destination.

=item *

B<DROP> - Blocks the packets from going to the intended destination and
sends an alert log message, if alert logging is configured in the
Firewall LoggingConfiguration.

=item *

B<ALERT> - Permits the packets to go to the intended destination and
sends an alert log message, if alert logging is configured in the
Firewall LoggingConfiguration.

You can use this action to test a rule that you intend to use to drop
traffic. You can enable the rule with C<ALERT> action, verify in the
logs that the rule is filtering as you want, then change the action to
C<DROP>.

=back



=head2 B<REQUIRED> Header => L<Paws::NetworkFirewall::Header>

The stateful 5-tuple inspection criteria for this rule, used to inspect
traffic flows.


=head2 B<REQUIRED> RuleOptions => ArrayRef[L<Paws::NetworkFirewall::RuleOption>]





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

