/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.JDBCTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class SQLExec
extends JDBCTask {
    private int goodSql = 0;
    private int totalSql = 0;
    private Connection conn = null;
    private Vector filesets = new Vector();
    private Statement statement = null;
    private File srcFile = null;
    private String sqlCommand = "";
    private Vector transactions = new Vector();
    private String delimiter = ";";
    private String delimiterType = "normal";
    private boolean print = false;
    private boolean showheaders = true;
    private File output = null;
    private String onError = "abort";
    private String encoding = null;
    private boolean append = false;
    private boolean keepformat = false;
    private boolean escapeProcessing = true;

    public void setSrc(File srcFile) {
        this.srcFile = srcFile;
    }

    public void addText(String sql) {
        this.sqlCommand = this.sqlCommand + sql;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public Transaction createTransaction() {
        Transaction t = new Transaction();
        this.transactions.addElement(t);
        return t;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiterType(DelimiterType delimiterType) {
        this.delimiterType = delimiterType.getValue();
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public void setShowheaders(boolean showheaders) {
        this.showheaders = showheaders;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setOnerror(OnError action) {
        this.onError = action.getValue();
    }

    public void setKeepformat(boolean keepformat) {
        this.keepformat = keepformat;
    }

    public void setEscapeProcessing(boolean enable) {
        this.escapeProcessing = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Vector savedTransaction = (Vector)this.transactions.clone();
        String savedSqlCommand = this.sqlCommand;
        this.sqlCommand = this.sqlCommand.trim();
        try {
            if (this.srcFile == null && this.sqlCommand.length() == 0 && this.filesets.isEmpty() && this.transactions.size() == 0) {
                throw new BuildException("Source file or fileset, transactions or sql statement must be set!", this.getLocation());
            }
            if (this.srcFile != null && !this.srcFile.exists()) {
                throw new BuildException("Source file does not exist!", this.getLocation());
            }
            int i = 0;
            while (i < this.filesets.size()) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File srcDir = fs.getDir(this.getProject());
                String[] srcFiles = ds.getIncludedFiles();
                int j = 0;
                while (j < srcFiles.length) {
                    Transaction t = this.createTransaction();
                    t.setSrc(new File(srcDir, srcFiles[j]));
                    ++j;
                }
                ++i;
            }
            Transaction t = this.createTransaction();
            t.setSrc(this.srcFile);
            t.addText(this.sqlCommand);
            this.conn = this.getConnection();
            if (!this.isValidRdbms(this.conn)) {
                Object var15_15 = null;
                this.transactions = savedTransaction;
                this.sqlCommand = savedSqlCommand;
                return;
            }
            try {
                this.statement = this.conn.createStatement();
                this.statement.setEscapeProcessing(this.escapeProcessing);
                PrintStream out = System.out;
                try {
                    if (this.output != null) {
                        this.log("Opening PrintStream to output file " + this.output, 3);
                        out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getAbsolutePath(), this.append)));
                    }
                    Enumeration e = this.transactions.elements();
                    while (e.hasMoreElements()) {
                        ((Transaction)e.nextElement()).runTransaction(out);
                        if (this.isAutocommit()) continue;
                        this.log("Committing transaction", 3);
                        this.conn.commit();
                    }
                    Object var11_18 = null;
                    if (out != null && out != System.out) {
                        out.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    if (out != null && out != System.out) {
                        out.close();
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (!this.isAutocommit() && this.conn != null && this.onError.equals("abort")) {
                    try {
                        this.conn.rollback();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
                throw new BuildException(e, this.getLocation());
            }
            catch (SQLException e) {
                if (!this.isAutocommit() && this.conn != null && this.onError.equals("abort")) {
                    try {
                        this.conn.rollback();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
                throw new BuildException(e, this.getLocation());
            }
            finally {
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException ex) {}
            }
            this.log(this.goodSql + " of " + this.totalSql + " SQL statements executed successfully");
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.transactions = savedTransaction;
            this.sqlCommand = savedSqlCommand;
            throw throwable;
        }
        Object var15_16 = null;
        this.transactions = savedTransaction;
        this.sqlCommand = savedSqlCommand;
    }

    protected void runStatements(Reader reader, PrintStream out) throws SQLException, IOException {
        StringBuffer sql = new StringBuffer();
        String line = "";
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            String token;
            StringTokenizer st;
            if (!this.keepformat) {
                line = line.trim();
            }
            line = this.getProject().replaceProperties(line);
            if (!this.keepformat && (line.startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken()))) continue;
            if (!this.keepformat) {
                sql.append(" " + line);
            } else {
                sql.append("\n" + line);
            }
            if (!this.keepformat && line.indexOf("--") >= 0) {
                sql.append("\n");
            }
            if ((!this.delimiterType.equals("normal") || !sql.toString().endsWith(this.delimiter)) && (!this.delimiterType.equals("row") || !line.equals(this.delimiter))) continue;
            this.execSQL(sql.substring(0, sql.length() - this.delimiter.length()), out);
            sql.replace(0, sql.length(), "");
        }
        if (!sql.equals("")) {
            this.execSQL(sql.toString(), out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execSQL(String sql, PrintStream out) throws SQLException {
        if ("".equals(sql.trim())) {
            return;
        }
        ResultSet resultSet = null;
        try {
            try {
                ++this.totalSql;
                this.log("SQL: " + sql, 3);
                int updateCount = 0;
                int updateCountTotal = 0;
                boolean ret = this.statement.execute(sql);
                updateCount = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
                do {
                    if (!ret) {
                        if (updateCount != -1) {
                            updateCountTotal += updateCount;
                        }
                    } else if (this.print) {
                        this.printResults(resultSet, out);
                    }
                    if (!(ret = this.statement.getMoreResults())) continue;
                    updateCount = this.statement.getUpdateCount();
                    resultSet = this.statement.getResultSet();
                } while (ret);
                this.log(updateCountTotal + " rows affected", 3);
                if (this.print) {
                    StringBuffer line = new StringBuffer();
                    line.append(updateCountTotal + " rows affected");
                    out.println(line);
                }
                SQLWarning warning = this.conn.getWarnings();
                while (true) {
                    if (warning == null) {
                        this.conn.clearWarnings();
                        ++this.goodSql;
                        break;
                    }
                    this.log(warning + " sql warning", 3);
                    warning = warning.getNextWarning();
                }
            }
            catch (SQLException e) {
                this.log("Failed to execute: " + sql, 0);
                if (!this.onError.equals("continue")) {
                    throw e;
                }
                this.log(e.toString(), 0);
                Object var9_10 = null;
                if (resultSet == null) return;
                resultSet.close();
                return;
            }
            Object var9_9 = null;
            if (resultSet == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (resultSet == null) throw throwable;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void printResults(PrintStream out) throws SQLException {
        ResultSet rs = null;
        rs = this.statement.getResultSet();
        try {
            this.printResults(rs, out);
            Object var4_3 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    protected void printResults(ResultSet rs, PrintStream out) throws SQLException {
        if (rs != null) {
            this.log("Processing new result set.", 3);
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            StringBuffer line = new StringBuffer();
            if (this.showheaders) {
                int col = 1;
                while (col < columnCount) {
                    line.append(md.getColumnName(col));
                    line.append(",");
                    ++col;
                }
                line.append(md.getColumnName(columnCount));
                out.println(line);
                line = new StringBuffer();
            }
            while (rs.next()) {
                boolean first = true;
                int col = 1;
                while (col <= columnCount) {
                    String columnValue = rs.getString(col);
                    if (columnValue != null) {
                        columnValue = columnValue.trim();
                    }
                    if (first) {
                        first = false;
                    } else {
                        line.append(",");
                    }
                    line.append(columnValue);
                    ++col;
                }
                out.println(line);
                line = new StringBuffer();
            }
        }
        out.println();
    }

    public class Transaction {
        private File tSrcFile = null;
        private String tSqlCommand = "";

        public void setSrc(File src) {
            this.tSrcFile = src;
        }

        public void addText(String sql) {
            this.tSqlCommand = this.tSqlCommand + sql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTransaction(PrintStream out) throws IOException, SQLException {
            if (this.tSqlCommand.length() != 0) {
                SQLExec.this.log("Executing commands", 2);
                SQLExec.this.runStatements(new StringReader(this.tSqlCommand), out);
            }
            if (this.tSrcFile != null) {
                SQLExec.this.log("Executing file: " + this.tSrcFile.getAbsolutePath(), 2);
                InputStreamReader reader = SQLExec.this.encoding == null ? new FileReader(this.tSrcFile) : new InputStreamReader((InputStream)new FileInputStream(this.tSrcFile), SQLExec.this.encoding);
                try {
                    SQLExec.this.runStatements(reader, out);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    ((Reader)reader).close();
                    throw throwable;
                }
                ((Reader)reader).close();
                {
                }
            }
        }
    }

    public static class OnError
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"continue", "stop", "abort"};
        }
    }

    public static class DelimiterType
    extends EnumeratedAttribute {
        public static final String NORMAL = "normal";
        public static final String ROW = "row";

        public String[] getValues() {
            return new String[]{NORMAL, ROW};
        }
    }
}

