##----------------------------------------------------------------------------
## Stripe API - ~/lib/Net/API/Stripe/Billing/Invoice/BalanceSettings.pm
## Version 0.1
## Copyright(c) 2019-2020 DEGUEST Pte. Ltd.
## Author: Jacques Deguest <jack@deguest.jp>
## Created 2019/11/03
## Modified 2019/11/03
## All rights reserved
## 
## This program is free software; you can redistribute  it  and/or  modify  it
## under the same terms as Perl itself.
##----------------------------------------------------------------------------
package Net::API::Stripe::Billing::Invoice::BalanceSettings;
BEGIN
{
	use strict;
	use parent qw( Net::API::Stripe::Generic );
	our( $VERSION ) = '0.1';
};

sub consume_applied_balance_on_void { return( shift->_set_get_boolean( 'consume_applied_balance_on_void', @_ ) ); }

1;

__END__

=encoding utf8

=head1 NAME

Net::API::Stripe::Billing::Invoice::BalanceSettings - A Stripe Customer Invoice Balance Transaction Upon Voiding

=head1 SYNOPSIS

    my $obj = $sub->invoice_customer_balance_settings({
        # Boolean
        consume_applied_balance_on_void => 1,
    });

=head1 VERSION

    0.1

=head1 DESCRIPTION

This is instantiated by method B<invoice_customer_balance_settings> from L<Net::API::Stripe::Billing::Subscription>

=head1 CONSTRUCTOR

=over 4

=item B<new>( %ARG )

Creates a new L<Net::API::Stripe::Billing::Invoice::BalanceSettings> object.
It may also take an hash like arguments, that also are method of the same name.

=back

=head1 METHODS

=over 4

=item B<consume_applied_balance_on_void>

Controls whether a customer balance applied to this invoice should be consumed and not credited or debited back to the customer if voided.

Stripe support explained me:
"One can void invoices only when they are in either the I<open> or the I<uncollectible> status but never when they are paid status. So voiding an invoice does not result in issuing a credit. 

When an invoice generated by the subscription is voided, the invoice is treated as zero-value and the customer balance isn't be applied."

=back

=head1 API SAMPLE

	{
	  "id": "sub_fake124567890",
	  "object": "subscription",
	  "application_fee_percent": null,
	  "billing_cycle_anchor": 1572739659,
	  "billing_thresholds": null,
	  "cancel_at_period_end": false,
	  "canceled_at": null,
	  "collection_method": "charge_automatically",
	  "created": 1572739659,
	  "current_period_end": 1575331659,
	  "current_period_start": 1572739659,
	  "customer": "cus_fake124567890",
	  "days_until_due": null,
	  "default_payment_method": null,
	  "default_source": null,
	  "default_tax_rates": [

	  ],
	  "discount": null,
	  "ended_at": null,
	  "invoice_customer_balance_settings": {
		"consume_applied_balance_on_void": true
	  },
	  "items": {
		"object": "list",
		"data": [
		  {
			"id": "si_fake124567890",
			"object": "subscription_item",
			"billing_thresholds": null,
			"created": 1572739659,
			"metadata": {
			},
			"plan": {
			  "id": "plan_fake124567890",
			  "object": "plan",
			  "active": true,
			  "aggregate_usage": null,
			  "amount": 999,
			  "amount_decimal": "999",
			  "billing_scheme": "per_unit",
			  "created": 1572736765,
			  "currency": "usd",
			  "interval": "month",
			  "interval_count": 1,
			  "livemode": false,
			  "metadata": {
			  },
			  "nickname": null,
			  "product": "prod_fake124567890",
			  "tiers": null,
			  "tiers_mode": null,
			  "transform_usage": null,
			  "trial_period_days": null,
			  "usage_type": "licensed"
			},
			"quantity": 1,
			"subscription": "sub_fake124567890",
			"tax_rates": [

			]
		  }
		],
		"has_more": false,
		"url": "/v1/subscription_items?subscription=sub_fake124567890"
	  },
	  "latest_invoice": null,
	  "livemode": false,
	  "metadata": {
	  },
	  "next_pending_invoice_item_invoice": null,
	  "pending_invoice_item_interval": null,
	  "pending_setup_intent": null,
	  "plan": {
		"id": "plan_fake124567890",
		"object": "plan",
		"active": true,
		"aggregate_usage": null,
		"amount": 999,
		"amount_decimal": "999",
		"billing_scheme": "per_unit",
		"created": 1572736765,
		"currency": "usd",
		"interval": "month",
		"interval_count": 1,
		"livemode": false,
		"metadata": {
		},
		"nickname": null,
		"product": "prod_fake124567890",
		"tiers": null,
		"tiers_mode": null,
		"transform_usage": null,
		"trial_period_days": null,
		"usage_type": "licensed"
	  },
	  "quantity": 1,
	  "start_date": 1572739659,
	  "status": "active",
	  "tax_percent": null,
	  "trial_end": null,
	  "trial_start": null
	}

=head1 HISTORY

=head2 v0.1

Initial version

=head1 AUTHOR

Jacques Deguest E<lt>F<jack@deguest.jp>E<gt>

=head1 SEE ALSO

Stripe API documentation:

L<https://stripe.com/docs/api/subscriptions/object?lang=node#subscription_object-invoice_customer_balance_settings>, L<https://stripe.com/docs/billing/invoices/workflow#void>, L<https://stripe.com/docs/billing/customer/balance#customer-balance>

=head1 COPYRIGHT & LICENSE

Copyright (c) 2019-2020 DEGUEST Pte. Ltd.

You can use, copy, modify and redistribute this package and associated
files under the same terms as Perl itself.

=cut
