use 5.16.0;
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME               => 'App::Docker::Client',
    AUTHOR             => q{Mario Zieschang <mziescha@cpan.org>},
    VERSION_FROM       => 'lib/App/Docker/Client.pm',
    ABSTRACT_FROM      => 'lib/App/Docker/Client.pm',
    LICENSE            => 'artistic_2',
    PL_FILES           => {},
    MIN_PERL_VERSION   => 5.16.0,
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => 0,
    },
    PREREQ_PM => {
        'Encode::Locale'                     => 1.05,
        'LWP::MediaTypes'                    => 6.02,
        'HTTP::Date'                         => 6.02,
        'URI'                                => 1.71,
        'IO::HTML'                           => 1.001,
        'HTTP::Message'                      => 6.11,
        'HTTP::Cookies'                      => 6.01,
        'HTTP::Daemon'                       => 6.01,
        'Net::HTTP'                          => 6.12,
        'WWW::RobotRules'                    => 6.02,
        'File::Listing'                      => 6.04,
        'HTTP::Negotiate'                    => 6.01,
        'JSON'                               => 2.90,
        'LWP::UserAgent'                     => 6.12,
        'LWP::Protocol::http::SocketUnixAlt' => 0,
        'Carp'                               => 0,
    },
    TEST_REQUIRES => {
        'Test::More' => 0,
        'File::Spec' => 0,
        'FindBin'    => 0,
    },
    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources   => {
            repository => {
                type => 'git',
                url  => 'https://github.com/mziescha/App-Docker-Client.git',
                web  => 'https://github.com/mziescha/App-Docker-Client',
            },
        }
    },
    dist  => { COMPRESS => 'gzip -9f',            SUFFIX => 'gz', },
    clean => { FILES    => 'App-Docker-Client-*', 'cover_db', },
);
