# Generated by default/object.tt
package Paws::IVS::Stream;
  use Moose;
  has ChannelArn => (is => 'ro', isa => 'Str', request_name => 'channelArn', traits => ['NameInRequest']);
  has Health => (is => 'ro', isa => 'Str', request_name => 'health', traits => ['NameInRequest']);
  has PlaybackUrl => (is => 'ro', isa => 'Str', request_name => 'playbackUrl', traits => ['NameInRequest']);
  has StartTime => (is => 'ro', isa => 'Str', request_name => 'startTime', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);
  has ViewerCount => (is => 'ro', isa => 'Int', request_name => 'viewerCount', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IVS::Stream

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IVS::Stream object:

  $service_obj->Method(Att1 => { ChannelArn => $value, ..., ViewerCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IVS::Stream object:

  $result = $service_obj->Method(...);
  $result->Att1->ChannelArn

=head1 DESCRIPTION

Specifies a live video stream that has been ingested and distributed.

=head1 ATTRIBUTES


=head2 ChannelArn => Str

Channel ARN for the stream.


=head2 Health => Str

The streamE<rsquo>s health.


=head2 PlaybackUrl => Str

URL of the master playlist, required by the video player to play the
HLS stream.


=head2 StartTime => Str

ISO-8601 formatted timestamp of the streamE<rsquo>s start.


=head2 State => Str

The streamE<rsquo>s state.


=head2 ViewerCount => Int

Number of current viewers of the stream. A value of -1 indicates that
the request timed out; in this case, retry.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IVS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

