# Generated by default/object.tt
package Paws::Lightsail::InputOrigin;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has ProtocolPolicy => (is => 'ro', isa => 'Str', request_name => 'protocolPolicy', traits => ['NameInRequest']);
  has RegionName => (is => 'ro', isa => 'Str', request_name => 'regionName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::InputOrigin

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::InputOrigin object:

  $service_obj->Method(Att1 => { Name => $value, ..., RegionName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::InputOrigin object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Describes the origin resource of an Amazon Lightsail content delivery
network (CDN) distribution.

An origin can be a Lightsail instance or load balancer. A distribution
pulls content from an origin, caches it, and serves it to viewers via a
worldwide network of edge servers.

=head1 ATTRIBUTES


=head2 Name => Str

The name of the origin resource.


=head2 ProtocolPolicy => Str

The protocol that your Amazon Lightsail distribution uses when
establishing a connection with your origin to pull content.


=head2 RegionName => Str

The AWS Region name of the origin resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

