package App::BPOMUtils::Table::FoodCategory;

use 5.010001;
use strict 'subs', 'vars';
use utf8;
use warnings;
use Log::ger;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-09-03'; # DATE
our $DIST = 'App-BPOMUtils-Table-FoodCategory'; # DIST
our $VERSION = '0.018'; # VERSION

our @EXPORT_OK = qw(
                       bpom_list_food_categories_old
               );

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_bpom_kategori_pangan varname=meta_idn_bpom_kategori_pangan
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_kategori_pangan/meta.yaml
# src-revision: 7d9fb0684b5983e6d55c16bead9f904f783798e3 (Thu Oct 27 17:19:46 2022 +0700)
# generate-date: Fri Jan 20 09:03:11 2023 UTC
# generated-by: update-fragments-in-perl-module
our $meta_idn_bpom_kategori_pangan = {
  "fields" => {
    code    => {
                 filterable_regex => "Yes",
                 pos => 0,
                 schema => ["str*", { match => "^[0-9ABC]+\$" }],
                 sortable => "Yes",
                 summary => "Code",
                 unique => "Yes",
               },
    name    => {
                 filterable_regex => "Yes",
                 pos => 1,
                 schema => "str*",
                 sortable => "Yes",
                 summary => "Name",
                 unique => "Yes",
               },
    status  => {
                 filterable_regex => "Yes",
                 pos => 3,
                 schema => ["str*"],
                 sortable => "Yes",
                 summary => "Status",
                 unique => "No",
               },
    summary => {
                 filterable_regex => "Yes",
                 pos => 2,
                 schema => ["str*"],
                 sortable => "Yes",
                 summary => "Summary",
                 unique => "No",
               },
  },
  "pk" => "code",
  "summary" => "Food categories in BPOM processed food division",
  "summary.alt.lang.id_ID" => "Kategori pangan di BPOM pangan olahan",
};
# END FRAGMENT id=meta-idn_bpom_kategori_pangan

# BEGIN FRAGMENT id=data-idn_bpom_kategori_pangan varname=data_idn_bpom_kategori_pangan
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_kategori_pangan/data.csv
# src-revision: 7d9fb0684b5983e6d55c16bead9f904f783798e3 (Thu Oct 27 17:19:46 2022 +0700)
# generate-date: Fri Jan 20 09:03:11 2023 UTC
# generated-by: update-fragments-in-perl-module
our $data_idn_bpom_kategori_pangan = [
  [
    "0101010102",
    "Susu Segar",
    "Susu segar adalah cairan dari ambing sapi, kerbau, kuda, kambing, domba, dan hewan ternak penghasil susu lainnya yang sehat yang diperoleh dengan cara pemerahan yang benar, yang kandungan alaminya tidak dikurangi atau ditambah sesuatu apapun, belum mendapat perlakuan apapun kecuali pendinginan.<br> Karakteristik dasar Susu Sapi Segar :<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 3%<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 7,8%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,8%<br> Karakteristik dasar Susu Kuda Segar :<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 1,3%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2%",
    "Aktif",
  ],
  [
    "0101010103",
    "Susu Pasteurisasi",
    "Susu pasteurisasi adalah produk susu cair yang diperoleh dari susu segar atau susu rekonstitusi atau susu rekombinasi yang dipanaskan dengan tujuan untuk membunuh semua mikroba pathogen.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 3%;<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 7,8%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,8%",
    "Tidak Aktif",
  ],
  [
    "0101010104",
    "Susu UHT (Ultra High Temperature)",
    "Susu UHT adalah produk susu cair yang diperoleh dari susu segar atau susu rekonstitusi atau susu rekombinasi yang disterilkan pada suhu tidak kurang dari 135\xC2\xB0C dengan F0 tidak kurang dari 3 menit dan dikemas segera dalam kemasan yang steril secara aseptis.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 3%<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 7,8%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,8%",
    "Tidak Aktif",
  ],
  [
    "0101010105",
    "Susu Steril",
    "Susu steril adalah produk susu cair yang diperoleh dari susu segar atau susu rekonstitusi atau susu rekombinasi yang dipanaskan pada suhu tidak kurang dari 1000C selama waktu yang cukup untuk mencapai keadaan steril komersial (dengan F0 tidak kurang dari 3 menit) dan dikemas secara kedap (hermetis).<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 3%<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 7,8%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,8%",
    "Tidak Aktif",
  ],
  [
    "0101010106",
    "Susu Skim",
    "Susu skim adalah produk susu cair yang sebagian besar lemaknya telah dihilangkan, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature).<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak lebih dari 0,5%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,8%",
    "Tidak Aktif",
  ],
  [
    "0101010107",
    "Susu Skim Sebagian (Pasteurisasi)",
    "Susu skim sebagian adalah produk susu cair yang sebagian lemaknya telah dihilangkan, dan dipasteurisasi.<br> Karakteristik dasar:<br> - Kadar lemak susu 0,5% sampai kurang dari 3%<br> - Kadar protein tidak kurang dari 2,8%",
    "Tidak Aktif",
  ],
  [
    "0101010110",
    "Susu Lemak Nabati/Susu Minyak Nabati (Filled Milk)",
    "Susu lemak nabati / susu minyak nabati (filled milk) adalah produk susu cair yang diperoleh dengan cara menggantikan sebagian atau seluruh lemak susu dengan minyak atau lemak nabati, atau campurannya dalam jumlah yang setara. Produk ini mempunyai komposisi umum, penampakan, dan penggunaan yang mirip dengan susu segar.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak tidak kurang dari 3%<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 7,8%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,8%",
    "Tidak Aktif",
  ],
  [
    "0101010113",
    "Susu UHT (Ultra High Temperature) Berperisa",
    "&nbsp;",
    "Tidak Aktif",
  ],
  ["0101010114", "Susu Kuda", "&nbsp;", "Tidak Aktif"],
  [
    "0101010115",
    "Susu Skim Sebagian (Steril atau UHT)",
    "Susu skim sebagian adalah produk susu cair yang sebagian lemaknya telah dihilangkan, dan disterilisasi atau diproses secara UHT (Ultra High Temperature).<br> Karakteristik dasar:<br> - Kadar lemak susu 0,5% sampai kurang dari 3%<br> - Kadar protein tidak kurang dari 2,8%",
    "Tidak Aktif",
  ],
  [
    "0101010201",
    "Buttermilk (Plain)",
    "Buttermilk (plain) adalah produk susu yang diperoleh dari proses penggumpalan krim yang telah dipisahkan dari susu segar atau susu yang telah dipanaskan, dengan atau tanpa penambahan bakteri asam laktat pada susu segar atau susu yang telah dipanaskan. Produk ini dapat dipasteurisasi atau disterilisasi.",
    "Tidak Aktif",
  ],
  [
    "0101010202",
    "Dadih",
    "Dadih adalah produk susu yang diperoleh dari proses fermentasi spontan bakteri asam laktat pada susu kerbau.",
    "Tidak Aktif",
  ],
  [
    "010101A0",
    "Susu Lemak Penuh (Full Cream) Plain (Cair)",
    "Susu Lemak Penuh (Full Cream) adalah produk susu cair yang diperoleh dari susu segar yang tidak dikurangi lemaknya, dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature). Nama jenis produk ini dapat diikuti dengan prosesnya, contohnya susu lemak penuh (full cream) pasteurisasi, susu pasteurisasi.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 3%;<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 7,8%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,7%",
    "Aktif",
  ],
  [
    "010101A1",
    "Susu Skim Plain (Cair)",
    "Susu skim adalah produk susu cair yang sebagian besar lemaknya telah dihilangkan, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature).<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak lebih dari 0,5%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,7%.",
    "Aktif",
  ],
  [
    "010101A2",
    "Susu Skim Sebagian Plain (Cair)",
    "Susu skim sebagian adalah produk susu cair yang sebagian lemaknya telah dihilangkan, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature).<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu 0,6% sampai kurang dari 2,9%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,7%",
    "Aktif",
  ],
  [
    "01010201",
    "Minuman Susu Berperisa",
    "Minuman susu berperisa adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi yang diberi perisa, dapat ditambahkan gula, bahan pangan lain dan disterilisasi atau dipasteurisasi serta dikemas secara kedap (hermetis).",
    "Tidak Aktif",
  ],
  [
    "01010202",
    "Minuman Mengandung Susu (Cair) (Plain)",
    "Minuman mengandung susu adalah minuman yang dibuat dengan menggunakan susu segar, susu rekonstitusi atau susu rekombinasi, dapat ditambahkan bahan pangan lain dan disterilisasi atau dipasteurisasi.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 0,3%;<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 0,78%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 0,27%",
    "Aktif",
  ],
  [
    "01010203",
    "Minuman Susu Fermentasi (Plain)",
    "Minuman susu fermentasi adalah minuman berbahan dasar susu fermentasi, dapat ditambahkan bahan pangan lain dengan atau tanpa proses pemanasan. Penamaan jenis produk berdasarkan bahan dasar yang digunakan, misalnya minuman yogurt, minuman kefir, minuman kumys.<br> Karakteristik Dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 2,6%;<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 0,92%",
    "Aktif",
  ],
  [
    "01010204",
    "Minuman Yogurt (Plain dan Berperisa)",
    "Minuman yogurt adalah minuman berbahan dasar yogurt dengan atau tanpa penambahan perisa atau rasa, dapat ditambahkan gula, bahan pangan lain dengan atau tanpa proses pemanasan, serta dikemas secara kedap (hermetis).<br> Karakteristik Dasar:<br> Total padatan susu bukan lemak tidak kurang dari 3%",
    "Tidak Aktif",
  ],
  [
    "01010205",
    "Lassi (Plain)",
    "Lassi adalah minuman yang diperoleh dari susu yang difermentasi dengan bakteri asam laktat sampai terbentuk curd (gumpalan protein susu) kemudian dikocok.",
    "Aktif",
  ],
  [
    "01010206",
    "Minuman Mengandung Susu Steril",
    "Minuman mengandung susu (steril)<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 0,3%<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 1,2%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 1%",
    "Tidak Aktif",
  ],
  [
    "01010207",
    "Minuman Susu Steril (Plain)",
    "Minuman Susu Steril (Plain) adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi, dapat ditambahkan bahan pangan lain dan disterilisasi<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu 1,2% sampai kurang dari 2%;<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 4,4%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 1%.",
    "Aktif",
  ],
  [
    "01010208",
    "Minuman Susu Pasteurisasi (Plain)",
    "Minuman Susu Pasteurisasi (Plain) adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi, dapat ditambahkan bahan pangan lain dan dipasteurisasi.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu 1,2% sampai kurang dari 2%;<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 4,4%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 1%.",
    "Aktif",
  ],
  [
    "01010209",
    "Minuman Susu Evaporasi (Plain dan Berperisa)",
    "Minuman Susu Evaporasi (Plain dan Berperisa) adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi dengan atau tanpa tambahan perisa atau rasa, dapat ditambahkan gula, bahan pangan lain dan dievaporasi serta dikemas secara kedap (hermetis).<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu 1,2% sampai kurang dari 2%<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 4,4%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 1%",
    "Tidak Aktif",
  ],
  [
    "01010210",
    "Minuman Mengandung Susu (Serbuk)",
    "Minuman mengandung susu bentuk serbuk.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 0,3%<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 1,2%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 1%",
    "Tidak Aktif",
  ],
  [
    "01010211",
    "Susu (Rasa) Steril / UHT",
    "Susu (rasa) steril / UHT adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi dengan penambahan bahan/ekstrak alami yang menimbulkan rasa, dengan atau tanpa penambahan perisa, dapat ditambahkan gula, bahan pangan lain dan disterilisasi pada suhu tidak kurang dari 135\xC2\xB0C dengan F0 tidak kurang dari 3 menit dan dikemas segera dalam kemasan yang steril secara aseptis. Contoh susu cokelat. susu stroberi.<br> <br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 2%<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 8%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2%<br> \xE2\x{20AC}\xA2 Kadar bahan/ekstrak alami tidak kurang dari 0.5%",
    "Tidak Aktif",
  ],
  [
    "01010212",
    "Susu (Rasa) Pasteurisasi",
    "Susu (rasa) pasteurisasi adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi dengan penambahan bahan/ekstrak alami yang menimbulkan rasa, dengan atau tanpa penambahan perisa, dapat ditambahkan gula, bahan pangan lain dan dipasteurisasi serta dikemas secara kedap (hermetis). Contoh susu cokelat, susu stroberi.<br> <br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 2%<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 8%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2%<br> \xE2\x{20AC}\xA2 Kadar bahan/ekstrak alami tidak kurang dari 0.5%",
    "Tidak Aktif",
  ],
  [
    "01010213",
    "Susu Berperisa / Susu Rasa Steril atau UHT",
    "Susu berperisa / susu rasa steril atau UHT adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi dengan penambahan perisa, dapat ditambahkan gula, bahan pangan lain dan disterilisasi pada suhu tidak kurang dari 100\xC2\xB0C selama waktu yang cukup untuk mencapai keadaan steril komersial (dengan F0 tidak kurang dari 3 menit) dan dikemas secara kedap (hermetis). Contoh susu rasa cokelat/susu berperisa cokelat, susu rasa stroberi/susu berperisa stroberi.<br> <br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 2%<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 8%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2%",
    "Tidak Aktif",
  ],
  [
    "01010214",
    "Susu Berperisa / Susu Rasa Pasteurisasi",
    "Susu berperisa / susu rasa pasteurisasi adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi dengan penambahan perisa, dapat ditambahkan gula, bahan pangan lain dan dipasteurisasi serta dikemas secara kedap (hermetis). Contoh susu rasa cokelat/susu berperisa cokelat, susu rasa stroberi/susu berperisa stroberi.<br> <br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 2%<br> \xE2\x{20AC}\xA2 Total padatan susu bukan lemak tidak kurang dari 8%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2%",
    "Tidak Aktif",
  ],
  [
    "01010215",
    "Susu Lemak Penuh Rekombinasi Plain (Cair) / Recombined Full Cream Milk",
    "Susu Lemak Penuh Rekombinasi (Recombined Full Cream Milk) adalah produk susu yang tidak dikurangi lemaknya yang dihasilkan dari penggabungan lemak susu dan padatan susu bukan-lemak dengan atau tanpa penambahan air untuk mendapatkan komposisi susu yang sesuai, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature).<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 3%;<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 7,8%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,7%.",
    "Aktif",
  ],
  [
    "01010216",
    "Susu Lemak Penuh Rekonstitusi Plain (Cair) / Reconstituted Full Cream Milk",
    "Susu Lemak Penuh Rekonstitusi (Reconstituted Full Cream Milk) adalah produk susu yang tidak dikurangi lemaknya yang dihasilkan dari penambahan air pada susu bubuk kering atau produk susu evaporasi untuk mengembalikan rasio air terhadap padatan yang sesuai, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature).<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 3%;<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 7,8%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,7%.",
    "Aktif",
  ],
  [
    "01010217",
    "Susu Skim Rekonstitusi Plain (Cair)",
    "Susu skim rekonstitusi adalah produk susu cair hasil penambahan air pada susu bubuk skim atau susu skim evaporasi, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature).<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak lebih dari 0,5%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,7%.",
    "Aktif",
  ],
  [
    "01010218",
    "Susu Skim Sebagian Rekonstitusi Plain (Cair)",
    "Susu skim sebagian rekonstitusi adalah produk susu cair hasil penambahan air pada susu bubuk skim sebagian atau susu skim sebagian evaporasi untuk mendapatkan komposisi susu skim sebagian yang sesuai, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature).<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu 0,6% sampai kurang dari 2,9%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,7%.",
    "Aktif",
  ],
  [
    "01010219",
    "Susu Skim Sebagian Rekombinasi Plain (Cair)",
    "Susu skim sebagian rekombinasi adalah produk susu cair yang dihasilkan dari penggabungan lemak susu dan padatan susu bukan-lemak dengan atau tanpa penambahan air untuk mendapatkan komposisi susu skim sebagian yang sesuai, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature).<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu 0,6% sampai kurang dari 2,9%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,7%.",
    "Aktif",
  ],
  [
    "01010220",
    "Susu Lemak Nabati Plain (Cair) / Susu Minyak Nabati (Filled Milk)",
    "Susu lemak nabati/susu minyak nabati (filled milk) adalah produk susu cair yang diperoleh dengan cara menggantikan sebagian atau seluruh lemak susu dengan minyak atau lemak nabati, atau campurannya dalam jumlah yang setara. Produk ini mempunyai komposisi umum, penampakan, dan penggunaan yang mirip dengan susu segar.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak total tidak kurang dari 3%;<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 7,8%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 2,7%.",
    "Aktif",
  ],
  [
    "01010301",
    "Buttermilk cair",
    "Buttermilk cair adalah cairan yang hampir bebas lemak susu yang diperoleh dari proses pembuatan mentega (yaitu mengocok susu dan krim fermentasi atau tidak difermentasi). Buttermilk cair juga diproduksi dengan fermentasi susu skim cair, baik dengan pengasaman spontan melalui aktivitas bakteri asam laktat atau bakteri pembentuk aroma, atau dengan inokulasi susu yang dipanaskan dengan kultur bakteri murni (buttermilk terfermentasi).<br> Buttermilk cair dapat dipasteurisasi atau disterilisasi.",
    "Aktif",
  ],
  [
    "01010401",
    "Susu (Rasa) Lemak Penuh (Full Cream Milk)",
    "Susu (rasa) Lemak Penuh (Full Cream Milk) adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi yang tidak dikurangi lemaknya, dengan penambahan bahan/ekstrak alami yang menimbulkan rasa, dengan atau tanpa penambahan perisa, dapat ditambahkan gula, bahan pangan lain dan disterilisasi atau dipasteurisasi. Contoh susu cokelat, susu stroberi.",
    "Aktif",
  ],
  [
    "01010402",
    "Susu Berperisa/Susu Rasa",
    "Susu berperisa/susu rasa adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi dengan penambahan perisa, dapat ditambahkan gula, bahan pangan lain dan disterilisasi atau dipasteurisasi. Contoh susu rasa cokelat/susu berperisa cokelat, susu rasa stroberi/susu berperisa stroberi.",
    "Aktif",
  ],
  [
    "01010403",
    "Minuman Susu Berperisa/Rasa",
    "Minuman susu adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi dengan bahan tambahan pangan perisa atau rasa, dapat ditambahkan gula, bahan pangan lain dan disterilisasi atau dipasteurisasi.",
    "Aktif",
  ],
  [
    "01010404",
    "Minuman Mengandung Susu Berperisa/Rasa",
    "Minuman mengandung susu adalah minuman yang dibuat dengan menggunakan susu segar, susu rekonstitusi atau susu rekombinasi dengan bahan tambahan pangan perisa atau rasa, dapat ditambahkan gula, bahan pangan lain dan disterilisasi atau dipasteurisasi.<br>",
    "Aktif",
  ],
  [
    "01010405",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    "Minuman susu fermentasi adalah minuman berbahan dasar susu fermentasi dengan penambahan perisa atau rasa, dapat ditambahkan gula, bahan pangan lain dengan atau tanpa proses pemanasan. Penamaan jenis produk berdasarkan bahan dasar yang digunakan, misalnya minuman yogurt, minuman kefir, minuman kumys.<br>",
    "Aktif",
  ],
  [
    "01010406",
    "Lassi (Rasa/Berperisa)",
    "Lassi adalah minuman yang diperoleh dari susu yang difermentasi dengan bakteri asam laktat sampai terbentuk curd (gumpalan protein susu) kemudian dikocok dan dicampur dengan gula dan/atau pemanis.",
    "Aktif",
  ],
  [
    "01010407",
    "Minuman Berbasis Whey (Berperisa/Rasa)",
    "Minuman berbasis whey adalah minuman berbahan dasar whey, dapat ditambahkan gula, bahan pangan lain dan disterilisasi atau dipasteurisasi. Contoh minuman berbasis whey rasa cokelat.",
    "Aktif",
  ],
  [
    "01010408",
    "Susu Bubuk (Rasa) (Susu Bubuk Cokelat, Susu Bubuk Stroberi, Susu Bubuk Vanila, Susu Bubuk Madu, dll)",
    "Susu bubuk (rasa) adalah susu bubuk yang ditambah dengan bahan pangan berupa bubuk kakao, ekstrak stroberi, ekstrak vanilla dan atau bahan lain yang sesuai, dapat ditambah gula dan atau perisa. Nama jenis produk ini susu bubuk cokelat, susu bubuk stroberi, susu bubuk vanilla, susu bubuk madu, dan lain-lain.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 26%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 11%<br> \xE2\x{20AC}\xA2 Kadar gula dihitung sebagai sakarosa tidak lebih dari 55%<br> <br>",
    "Aktif",
  ],
  [
    "01010409",
    "Susu Bubuk Skim (Rasa) (Susu Bubuk Skim Cokelat, Susu Skim Bubuk Stroberi, Susu Bubuk Skim Vanila, Susu Bubuk Skim Madu, dll)",
    "Susu bubuk skim (rasa) adalah susu bubuk skim yang ditambah dengan bahan pangan berupa bubuk kakao, ekstrak stroberi, ekstrak vanilla dan atau bahan lain yang sesuai, dapat ditambah gula dan atau perisa. Nama jenis produk ini susu bubuk skim cokelat, susu bubuk skim stroberi, susu bubuk skim vanilla, susu bubuk skim madu, dan lain-lain.",
    "Aktif",
  ],
  [
    "01010410",
    "Susu Bubuk Skim Sebagian (Rasa) (Susu Bubuk Skim Sebagian Cokelat, Susu Skim Sebagian Bubuk Stroberi, Susu Bubuk Skim Sebagian Vanila, Susu Bubuk Skim Sebagian Madu, dll)",
    "Susu bubuk skim sebagian (rasa) adalah susu bubuk skim sebagian yang ditambah dengan bahan pangan berupa bubuk kakao, ekstrak stroberi, ekstrak vanilla dan atau bahan lain yang sesuai, dapat<br> ditambah gula dan atau perisa. Nama jenis produk ini susu bubuk skim sebagian cokelat, susu bubuk skim sebagian stroberi, susu bubuk skim sebagian vanilla, susu bubuk skim sebagian madu, dan<br> lain-lain.<br>",
    "Aktif",
  ],
  [
    "01010411",
    "Susu Bubuk Rasa/Berperisa (Susu Bubuk Rasa Cokelat, Susu Bubuk Rasa Stroberi, Susu Bubuk Rasa Vanila, Susu Bubuk Rasa Madu, dll)",
    "Susu bubuk rasa/berperisa adalah susu bubuk yang ditambah dengan bahan tambahan pangan perisa atau rasa, dan dapat ditambah gula. Nama jenis produk ini susu bubuk rasa cokelat, susu bubuk rasa stroberi, susu bubuk rasa vanilla, susu bubuk rasa madu, dan lain-lain.<br>",
    "Aktif",
  ],
  [
    "01010412",
    "Susu Bubuk Skim Rasa/Berperisa (Susu Bubuk Skim Rasa Cokelat, Susu Bubuk Skim Rasa Stroberi, Susu Bubuk Skim Rasa Vanila, Susu Bubuk Skim Rasa Madu, dll)",
    "Susu bubuk skim rasa/berperisa adalah susu bubuk skim yang ditambah dengan bahan tambahan pangan perisa atau rasa, dan dapat ditambah gula. Nama jenis produk ini susu bubuk skim rasa cokelat, susu bubuk skim rasa stroberi, susu bubuk skim rasa vanilla, susu bubuk skim rasa madu, dan lain-lain.<br>",
    "Aktif",
  ],
  [
    "01010413",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa (Susu Bubuk Skim Sebagian Rasa Cokelat, Susu Bubuk Skim Sebagian Rasa Stroberi, Susu Bubuk Skim Sebagian Rasa Vanila, Susu Bubuk Skim Sebagian Rasa Madu, dll)",
    "Susu bubuk skim sebagian rasa/berperisa adalah susu bubuk skim sebagian yang ditambah dengan bahan tambahan pangan perisa atau rasa, dan dapat ditambah gula. Nama jenis produk ini susu bubuk skim sebagian rasa cokelat, susu bubuk skim sebagian rasa stroberi, susu bubuk skim sebagian rasa vanilla, susu bubuk skim sebagian rasa madu, dan lain-lain.<br>",
    "Aktif",
  ],
  [
    "01010414",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    "Campuran susu dan krim bubuk berperisa atau (dengan) rasa adalah produk susu berbentuk bubuk, dibuat dari susu bubuk dengan penambahan gula dan perisa dalam bentuk kakao bubuk atau kopi bubuk dan lain-lain",
    "Aktif",
  ],
  [
    "01010415",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    "Minuman mengandung susu bubuk berperisa atau dengan (rasa) adalah minuman yang dibuat dengan menggunakan susu, susu rekonstitusi atau susu rekombinasi dengan tambahan perisa atau rasa, dapat ditambahkan gula.<br>",
    "Aktif",
  ],
  [
    "0102010103",
    "Susu Diasamkan (Plain) (Tanpa Pemanasan Setelah Difermentasi)",
    "Susu diasamkan adalah produk susu yang diperoleh dari susu segar atau susu pasteurisasi atau susu rekonstitusi atau susu rekombinasi yang diasamkan, dengan atau tanpa penambahan mikroba, vitamin dan bahan pangan lain. Jenis asam yang dapat digunakan sesuai dengan ketentuan.<br> Karakteristik dasar:<br> Total padatan susu bukan-lemak tidak kurang dari 6.6 %",
    "Aktif",
  ],
  [
    "0102010104",
    "Susu Asidofilus (Acidophilus Milk) (Plain) (Tanpa Pemanasan Setelah Difermentasi)",
    "Susu asidofilus adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Lactobacillus acidophilus, dapat ditambahkan bakteri lain yang sesuai.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6.6 %<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0.5 %",
    "Aktif",
  ],
  [
    "0102010105",
    "Yogurt (Plain) (Tanpa Pemanasan Setelah Difermentasi)",
    "Yogurt adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Lactobacillus bulgaricus dan Streptococcus thermophilus, dapat ditambahkan bakteri lain yang sesuai.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6.6 %<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 2.3 %<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0.5 %<br>",
    "Aktif",
  ],
  [
    "0102010106",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) (Plain) (Tanpa Pemanasan Setelah Difermentasi)",
    "Yogurt kultur lain adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Streptococcus thermophilus dan spesies Lactobacillus, dapat ditambahkan bakteri lain yang sesuai. Penamaan produk mengikuti ketentuan Standar Codex untuk Susu Fermentasi.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6.6 %<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 2.3 %<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0.5 %",
    "Aktif",
  ],
  [
    "0102010107",
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi)",
    "Kefir adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan kultur starter yang dibuat dari biji kefir, Lactobacillus kefiri, spesies dari genus Leuconostoc, Lactococcus dan Acetobacter yang tumbuh saling sinergi. Biji kefir mengandung khamir yang mampu memfermentasi laktosa (Kluyveromyces marxianus) dan khamir yang tidak mampu memfermentasi laktosa (Saccharomyces unisporus, Saccharomyces cerevisiae dan Saccharomyces exiguus), dapat ditambahkan bakteri lain yang sesuai.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6.6 %<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 2.3 %<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0.6 %",
    "Aktif",
  ],
  [
    "0102010108",
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi)",
    "Kumys adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri Lactobacillus delbrueckii subsp. bulgaricus dan Kluyveromyces marxianus, dapat ditambahkan bakteri lain yang sesuai.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6.6 %<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 2.3 %<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0.7 %<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 0.5 %",
    "Aktif",
  ],
  [
    "0102010109",
    "Susu Fermentasi atau Susu Berkultur (Cultured Milk) (Plain) (Tanpa Pemanasan Setelah Difermentasi)",
    "Susu fermentasi atau susu berkultur (cultured milk) adalah produk susu yang dihasilkan dari fermentasi susu segar dengan atau tanpa pasteurisasi, susu rekonstitusi atau susu rekombinasi yang diperoleh dari fermentasi dengan bakteri asam laktat yang sesuai.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6.6 %<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 2.3 %<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0.5 %",
    "Aktif",
  ],
  [
    "0102010203",
    "Susu Diasamkan (Plain) (Dengan Pemanasan Setelah Difermentasi)",
    "Susu diasamkan adalah produk susu yang diperoleh dari susu segar atau susu pasteurisasi atau susu rekonstitusi atau susu rekombinasi yang diasamkan, dengan atau tanpa penambahan mikroba, vitamin dan bahan pangan lain. Jenis asam yang dapat digunakan sesuai dengan ketentuan.<br> Karakteristik dasar:<br> Total padatan susu bukan-lemak tidak kurang dari 6.6 %",
    "Aktif",
  ],
  [
    "0102010204",
    "Susu Asidofilus (Acidophilus Milk) (Plain) (Dengan Pemanasan Setelah Difermentasi)",
    "Susu asidofilus adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Lactobacillus acidophilus, dapat ditambahkan bakteri lain yang sesuai.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6,6%<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0,5%<br>",
    "Aktif",
  ],
  [
    "0102010205",
    "Yogurt (Plain) (Dengan Pemanasan Setelah Difermentasi)",
    "Yogurt adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Lactobacillus bulgaricus dan Streptococcus thermophilus, dapat ditambahkan bakteri lain yang sesuai.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6,6%<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 2,3%<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0,5%<br>",
    "Aktif",
  ],
  [
    "0102010206",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) (Plain) (Dengan Pemanasan Setelah Difermentasi)",
    "Yogurt kultur lain adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Streptococcus thermophilus dan spesies Lactobacillus, dapat ditambahkan bakteri lain yang sesuai. Penamaan produk mengikuti ketentuan Standar Codex untuk Susu Fermentasi.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6,6%<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 2,3%<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0,5%<br>",
    "Aktif",
  ],
  [
    "0102010207",
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi)",
    "Kefir adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan kultur starter yang dibuat dari biji kefir, Lactobacillus kefiri, spesies dari genus Leuconostoc, Lactococcus dan Acetobacter yang tumbuh saling sinergi. Biji kefir mengandung khamir yang mampu memfermentasi laktosa (Kluyveromyces marxianus) dan khamir yang tidak mampu memfermentasi laktosa (Saccharomyces unisporus, Saccharomyces cerevisiae dan Saccharomyces exiguus), dapat ditambahkan bakteri lain yang sesuai.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6,6%<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 2,3%<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0,6%<br>",
    "Aktif",
  ],
  [
    "0102010208",
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi)",
    "Kumys adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri Lactobacillus delbrueckii subsp. bulgaricus dan Kluyveromyces marxianus, dapat ditambahkan bakteri lain yang sesuai.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6,6%<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 2,3%<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0,7%<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 0,5%<br>",
    "Aktif",
  ],
  [
    "0102010209",
    "Susu Fermentasi atau Susu Berkultur (Cultured Milk) (Plain) (Dengan Pemanasan Setelah Difermentasi)",
    "Susu fermentasi atau susu berkultur (cultured milk) adalah produk susu yang dihasilkan dari fermentasi susu segar dengan atau tanpa pasteurisasi, susu rekonstitusi atau susu rekombinasi yang diperoleh dari fermentasi dengan bakteri asam laktat yang sesuai.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 6,6%<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 2,3%<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0,5%<br>",
    "Aktif",
  ],
  [
    "010201A0",
    "Susu Diasamkan",
    "Susu diasamkan adalah produk susu yang diperoleh dari susu segar atau susu pasteurisasi atau susu rekonstitusi atau susu rekombinasi yang diasamkan, dengan atau tanpa penambahan mikroba, vitamin dan bahan pangan lainnya. Jenis asam yang dapat digunakan sesuai dengan ketentuan.<br> Karakteristik dasar:<br> Total padatan susu bukan lemak tidak kurang dari 7,8%",
    "Tidak Aktif",
  ],
  [
    "010201A3",
    "Susu Fermentasi atau Susu Berkultur (Cultured Milk)",
    "Susu fermentasi atau susu berkultur (cultured milk) adalah produk susu yang dihasilkan dari fermentasi susu segar dengan atau tanpa pasteurisasi, susu rekonstitusi atau susu rekombinasi yang diperoleh dari fermentasi dengan bakteri asam laktat yang sesuai.<br> Karakteristik dasar:<br> - Total padatan susu bukan-lemak tidak kurang dari 7,8%<br> - Kadar asam laktat tidak kurang dari 0,5%",
    "Tidak Aktif",
  ],
  [
    "010201A4",
    "Susu Fermentasi Rendah Lemak atau Susu Berkultur (Cultured Milk) Rendah Lemak",
    "Susu fermentasi rendah lemak atau susu berkultur (cultured milk) rendah lemak adalah produk susu fermentasi atau susu berkultur yang sebagian lemaknya telah dihilangkan.",
    "Tidak Aktif",
  ],
  [
    "010201A5",
    "Susu Fermentasi Tanpa Lemak atau Susu Berkultur (Cultured Milk) Tanpa Lemak",
    "Susu fermentasi tanpa lemak atau susu berkultur (cultured milk) tanpa lemak adalah produk susu fermentasi atau susu berkultur yang sebagian besar lemaknya telah dihilangkan.",
    "Tidak Aktif",
  ],
  [
    "010201A6",
    "Yogurt",
    "Yogurt adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Lactobacillus bulgaricus dan Streptococcus thermophilus, dapat ditambahkan bakteri lain yang sesuai.<br> Karakteristik dasar:<br> - Total padatan susu bukan-lemak tidak kurang dari 7,8%<br> - Kadar asam laktat tidak kurang dari 0,5%",
    "Tidak Aktif",
  ],
  [
    "010201A9",
    "Kefir",
    "Kefir adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan kultur starter yang dibuat dari biji kefir, Lactobacillus kefiri, spesies dari genus Leuconostoc, Lactococcus dan Acetobacter yang tumbuh saling sinergi. Biji kefir mengandung khamir yang mampu memfermentasi laktosa (Kluyveromyces marxianus) dan khamir yang tidak mampu memfermentasi laktosa (Saccharomyces unisporus, Saccharomyces cerevisiae dan Saccharomyces exiguus), dapat ditambahkan bakteri lain yang sesuai.<br> Karakteristik dasar:<br> - Total padatan susu bukan-lemak tidak kurang dari 7,8%;<br> - Kadar asam laktat tidak kurang dari 0,6%",
    "Tidak Aktif",
  ],
  [
    "010201B0",
    "Kumys",
    "Kumys adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri Lactobacillus delbrueckii subsp. bulgaricus dan Kluyveromyces marxianus, dapat ditambahkan bakteri lain yang sesuai.<br> Karakteristik dasar:<br> - Total padatan susu bukan-lemak tidak kurang dari 7,8%<br> - Kadar asam laktat tidak kurang dari 0,7%<br> - Kadar etanol tidak kurang dari 0,5%",
    "Tidak Aktif",
  ],
  [
    "010201B1",
    "Yogurt Plain Bubuk",
    "produk susu bentuk bubuk yang diperoleh dari fermentasi susu<br> dengan menggunakan bakteri asam laktat Lactobacillus bulgaricus<br> dan Streptococcus thermophilus, dapat ditambahkan bakteri lain<br> yang sesuai.<br>",
    "Aktif",
  ],
  [
    "010201B3",
    "Yogurt kultur lain (alternate culture yoghurt)",
    "Yogurt kultur lain adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Streptococcus thermophilus dan spesies Lactobacillus, dapat ditambahkan bakteri lain yang sesuai. Penamaan produk mengikuti ketentuan Standar Codex untuk Susu Fermentasi.<br> Karakteristik dasar:<br> - Total padatan susu bukan-lemak tidak kurang dari 7,8%<br> - Kadar asam laktat tidak kurang dari 0,5%",
    "Tidak Aktif",
  ],
  [
    "010202",
    "Susu yang Digumpalkan dengan Enzim Renin (Plain)",
    "Susu yang digumpalkan dengan enzim renin (plain) adalah produk susu yang dihasilkan melalui kerja enzim renin.<br> Karakteristik dasar:<br> Total padatan susu bukan lemak tidak kurang dari 7,8%",
    "Aktif",
  ],
  [
    "0102A0",
    "Dadih",
    "Dadih adalah produk susu yang diperoleh dari proses fermentasi spontan bakteri asam laktat pada susu kerbau.",
    "Aktif",
  ],
  [
    "01030101",
    "Susu Evaporasi",
    "Susu evaporasi adalah produk susu cair yang diperoleh dengan cara menghilangkan sebagian air dari susu segar atau susu rekonstitusi atau susu rekombinasi, dengan menggunakan proses evaporasi hingga diperoleh tingkat kepekatan tertentu. Produk dikemas secara kedap (hermetis) dan diproses dengan pemanasan setelah penutupan pengemas.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 7,5%<br> \xE2\x{20AC}\xA2 Total padatan tidak kurang dari 25%",
    "Aktif",
  ],
  [
    "01030102",
    "Susu Skim Evaporasi",
    "Susu skim evaporasi adalah produk susu cair yang diperoleh dengan cara menghilangkan sebagian air dari susu skim atau susu skim hasil rekonstitusi, dengan menggunakan proses evaporasi sehingga diperoleh tingkat kepekatan tertentu. Produk dikemas secara kedap (hermetis).<br> Karakteristik dasar:<br> -Kadar lemak susu tidak lebih dari 1%<br> -Total padatan tidak kurang dari 20%",
    "Aktif",
  ],
  [
    "01030103",
    "Susu Lemak Nabati Evaporasi/Susu Minyak Nabati Evaporasi",
    "Susu lemak nabati evaporasi / susu minyak nabati evaporasi adalah produk susu berbentuk cair yang diperoleh dengan cara menghilangkan sebagian air dari susu segar, susu rekombinasi, atau susu rekonstitusi yang lemaknya sebagian atau seluruhnya diganti dengan lemak nabati hingga diperoleh tingkat kepekatan tertentu. Produk dikemas secara kedap (hermetis). Susu lemak nabati evaporasi / susu minyak nabati evaporasi memiliki karakter dasar Kadar lemak tidak kurang dari 6% dan Total padatan tidak kurang dari 23,5%.",
    "Tidak Aktif",
  ],
  [
    "01030104",
    "Susu Kental Manis",
    "Susu kental manis adalah produk susu berbentuk cairan kental yang diperoleh dengan menghilangkan sebagian air dari campuran susu dan gula hingga mencapai tingkat kepekatan tertentu; atau merupakan hasil rekonstitusi susu bubuk dengan penambahan gula, dengan atau tanpa penambahan bahan lain. Gula yang ditambahkan harus dapat mencegah kerusakan produk. Produk dipasteurisasi dan dikemas secara kedap (hermetis). Susu kental manis memiliki karakteristik dasar Kadar lemak susu tidak kurang dari 8% dan Kadar protein tidak kurang dari 6,5% (untuk plain).",
    "Aktif",
  ],
  [
    "01030105",
    "Susu Kental Manis Lemak Nabati/Susu Kental Manis Minyak Nabati",
    "Susu kental manis lemak nabati / susu kental manis minyak nabati adalah produk susu berbentuk cairan kental yang diperoleh dari susu segar, susu rekombinasi, atau susu rekonstitusi yang lemaknya sebagian atau seluruhnya diganti dengan lemak nabati, dengan penambahan gula hingga mencapai kepekatan tertentu dengan atau tanpa penambahan bahan lain. Gula yang ditambahkan harus dapat mencegah kerusakan produk. Produk dipasteurisasi dan dikemas secara kedap (hermetis).<br> <br> Karakteristik dasar:<br> Kadar lemak tidak kurang dari 8%",
    "Tidak Aktif",
  ],
  [
    "01030106",
    "Susu Skim Kental Manis",
    "Susu skim kental manis adalah produk susu yang berbentuk cairan kental, yang diperoleh dengan menghilangkan sebagian air dari susu skim yang telah ditambahkan gula hingga mencapai kepekatan tertentu; atau merupakan hasil rekonstitusi susu skim bubuk dengan penambahan gula, dengan atau tanpa penambahan bahan lain. Gula yang ditambahkan harus dapat mencegah kerusakan produk. Produk dipasteurisasi dan dikemas secara kedap (hermetis). Susu skim kental manis memiliki karakteristik dasar kadar lemak susu tidak lebih dari 1%.",
    "Aktif",
  ],
  [
    "01030107",
    "Susu Kental Manis Diperkaya Lemak Nabati/Susu Kental Manis Diperkaya Minyak Nabati",
    "Susu kental manis diperkaya lemak nabati / susu kental manis diperkaya minyak nabati adalah produk susu yang berbentuk cairan kental, yang diperoleh dari susu yang telah ditambahkan gula dan lemak nabati atau minyak nabati yang kemudian sebagian air dihilangkan hingga mencapai kepekatan tertentu; atau merupakan hasil rekonstitusi susu bubuk dengan penambahan gula dan lemak nabati / minyak nabati, dengan atau tanpa penambahan bahan lain. Gula yang ditambahkan harus dapat mencegah pembusukan. Produk dikemas secara kedap (hermetis) dan dipasteurisasi.<br>",
    "Tidak Aktif",
  ],
  [
    "01030108",
    "Krim Kental Manis",
    "Krim kental manis adalah produk susu yang berbentuk cairan<br> kental yang diperoleh dengan merekonstitusi krim dengan<br> penambahan gula hingga mencapai kepekatan tertentu. Gula yang<br> ditambahkan harus dapat mencegah kerusakan produk. Produk<br> dipasteurisasi dan dikemas secara kedap (hermetis).<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 45%<br> \xE2\x{20AC}\xA2 Total padatan tidak kurang dari 65%",
    "Aktif",
  ],
  [
    "01030109",
    "Krimer Kental Manis",
    "Krimer kental manis adalah produk susu yang berbentuk cairan kental, yang diperoleh dari susu yang telah ditambahkan gula dan lemak nabati yang kemudian sebagian air dihilangkan hingga mencapai kepekatan tertentu, atau merupakan hasil rekonstitusi susu bubuk dengan penambahan gula dan lemak nabati/minyak nabati dan bahan lain. Gula yang ditambahkan harus dapat mencegah kerusakan produk. Produk dipasteurisasi dan dikemas secara kedap (hermetis).",
    "Tidak Aktif",
  ],
  [
    "01030110",
    "Khoa",
    "Khoa adalah produk susu yang diperoleh dari susu sapi atau kerbau yang dikentalkan dengan proses perebusan.",
    "Aktif",
  ],
  [
    "01030111",
    "Susu Lemak Nabati Evaporasi / Susu Minyak Nabati Evaporasi (Steril)",
    "Susu lemak nabati evaporasi / susu minyak nabati evaporasi (steril) adalah produk susu berbentuk cair yang diperoleh dengan cara menghilangkan sebagian air dari susu segar, susu rekombinasi, atau susu rekonstitusi yang lemaknya sebagian atau seluruhnya diganti dengan lemak nabati hingga diperoleh tingkat kepekatan tertentu. Produk dikemas secara kedap (hermetis). Susu lemak nabati evaporasi / susu minyak nabati evaporasi memiliki karakteristik dasar Kadar lemak tidak kurang dari 6% dan Total padatan tidak kurang dari 23,5%.",
    "Tidak Aktif",
  ],
  [
    "01030112",
    "Susu Skim Sebagian Evaporasi",
    "Susu skim sebagian evaporasi adalah produk susu cair yang diperoleh dengan cara menghilangkan sebagian air dari susu skim sebagian atau susu skim sebagian hasil rekonstitusi, dengan menggunakan proses evaporasi atau proses lain sehingga diperoleh tingkat kepekatan tertentu.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu lebih dari 1% dan kurang dari 7,5%<br> \xE2\x{20AC}\xA2 Total padatan susu tidak kurang dari 20%<br> \xE2\x{20AC}\xA2 Kadar protein antara 4% sampai 6%<br>",
    "Aktif",
  ],
  [
    "01030201",
    "Krimer Minuman",
    "Krimer minuman adalah produk pengganti susu atau krim yang merupakan produk emulsi lemak dalam air, yang dibuat dari minyak nabati yang dihidrogenasi. Produk dapat berupa cairan atau bubuk dan digunakan untuk minuman seperti kopi dan teh.<br> Karakteristik dasar:<br> Produk cair: mengandung lemak tidak kurang dari 3,25% dan<br> total padatan tidak lebih dari 8,25%<br> Produk bubuk: mengandung lemak tidak kurang dari 26% dan<br> kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "01030202",
    "Susu Lemak Nabati Evaporasi/ Susu Minyak Nabati Evaporasi",
    "Susu lemak nabati evaporasi / susu minyak nabati evaporasi adalah produk susu berbentuk cair yang diperoleh dengan cara menghilangkan sebagian air dari susu segar, susu rekombinasi, atau susu rekonstitusi yang lemaknya sebagian atau seluruhnya diganti dengan lemak nabati hingga diperoleh tingkat kepekatan tertentu.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak tidak kurang dari 6%<br> \xE2\x{20AC}\xA2 Total padatan tidak kurang dari 23,5%<br>",
    "Aktif",
  ],
  [
    "01030203",
    "Susu Kental Manis Lemak Nabati/ Susu Kental Manis Minyak Nabati",
    "Susu kental manis lemak nabati / susu kental manis minyak nabati adalah produk susu berbentuk cairan kental yang diperoleh dari susu segar, susu rekombinasi, atau susu rekonstitusi yang lemaknya sebagian atau seluruhnya diganti dengan lemak nabati, dengan penambahan gula hingga mencapai kepekatan tertentu dengan atau tanpa penambahan bahan lain. Gula yang<br> ditambahkan harus dapat mencegah kerusakan produk.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak total tidak kurang dari 8%;<br> \xE2\x{20AC}\xA2 Kadar protein total tidak kurang dari 2%.",
    "Aktif",
  ],
  [
    "01030204",
    "Krimer Kental Manis",
    "Krimer kental manis adalah produk susu yang berbentuk cairan kental, yang diperoleh dari susu yang telah ditambahkan gula dan lemak nabati yang kemudian sebagian air dihilangkan hingga mencapai kepekatan tertentu, atau merupakan hasil rekonstitusi susu bubuk dengan penambahan gula dan lemak nabati/minyak nabati dan bahan lain. Gula yang ditambahkan harus dapat mencegah kerusakan produk.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak total tidak kurang dari 8%;<br> \xE2\x{20AC}\xA2 Kadar protein total tidak kurang dari 1%.",
    "Aktif",
  ],
  [
    "01040101",
    "Krim Pasteurisasi (Plain)",
    "Krim pasteurisasi (plain) adalah krim yang telah mengalami proses pemanasan untuk membunuh cemaran mikroba patogen.<br> Karakteristik dasar:<br> Kadar lemak susu tidak kurang dari 10%",
    "Aktif",
  ],
  [
    "01040102",
    "Half and Half",
    "Half and half adalah produk susu yang terdiri dari campuran susu dan tidak kurang dari 10,5% krim, dengan kadar lemak susu tidak kurang dari 18%. Produk ini dipasteurisasi atau ultra pasteurisasi dan dapat dihomogenisasi, dengan atau tanpa penambahan gula",
    "Aktif",
  ],
  [
    "01040103",
    "Half and Half (Steril Komersial / Tetrapak)",
    "Half and half adalah produk susu yang terdiri dari campuran susu dan tidak kurang dari 10,5% krim, dengan kadar lemak susu tidak kurang dari 18%. Produk ini diproses dengan sterilisasi komersial.",
    "Tidak Aktif",
  ],
  [
    "01040201",
    "Whipped Cream",
    "Whipped Cream adalah produk krim, krim rekonstitusi dan / atau krim kombinasi yang disertai udara atau gas inert tanpa mempengaruhi lemak dalam emulsi susu skim",
    "Aktif",
  ],
  [
    "01040202",
    "Krim Rendah Lemak",
    "Krim rendah lemak adalah krim yang berisi lemak susu 18% hingga 34%. Produk ini dipasteurisasi atau ultra pasteurisasi.",
    "Tidak Aktif",
  ],
  [
    "01040204",
    "Krim Sterilisasi",
    "Krim sterilisasi adalah krim yang telah mengalami proses sterilisasi untuk membunuh cemaran mikroba patogen.",
    "Aktif",
  ],
  [
    "01040205",
    "Whipping Cream",
    "Whipping cream adalah produk krim, krim rekonstitusi dan/atau krim kombinasi yang khusus digunakan untuk tujuan whipping.<br> Karakteristik dasar:<br> Kadar lemak susu tidak kurang dari 10%.",
    "Aktif",
  ],
  [
    "01040301",
    "Krim Asam",
    "Krim asam adalah produk susu yang diperoleh dari proses pengasaman krim yang telah dipasteurisasi, dengan menggunakan bakteri asam laktat dan dikentalkan dengan enzim.",
    "Aktif",
  ],
  [
    "01040302",
    "Krim yang Diasamkan",
    "Krim yang diasamkan adalah produk susu yang diperoleh dari proses pengasaman krim yang telah dipasteurisasi, dengan menggunakan asam yang sesuai, dengan atau tanpa penggunaan bakteri asam laktat.",
    "Aktif",
  ],
  [
    "01040303",
    "Krim yang Digumpalkan dengan Enzim",
    "Krim yang digumpalkan dengan enzim adalah krim yang digumpalkan dengan enzim rennet.",
    "Aktif",
  ],
  [
    "01040401",
    "Krim Nabati",
    "Krim nabati adalah produk pengganti krim yang merupakan emulsi lemak nabati dalam air.",
    "Aktif",
  ],
  ["01040402", "Krim Nabati Bubuk", "", "Aktif"],
  [
    "0104AA",
    "Krim",
    "Krim adalah produk susu kaya lemak susu yang diperoleh dengan proses pemisahan yang memisahkan lemak susu dari komponen susu lainnya.",
    "Aktif",
  ],
  [
    "0104AA01",
    "Krim UHT",
    "produk susu kaya lemak susu yang diperoleh dengan proses pemisahan yang memisahkan lemak susu dari komponen susu lainnya.",
    "Tidak Aktif",
  ],
  [
    "01050101",
    "Susu Bubuk Lemak Penuh (Full Cream) (Plain)",
    "Susu bubuk lemak penuh (full cream) adalah produk susu berbentuk bubuk yang tidak dikurangi lemaknya, yang diperoleh dari susu cair; atau susu hasil pencampuran susu cair dengan susu kental atau krim bubuk; atau susu hasil pencampuran susu cair dengan susu kental atau susu bubuk, yang telah dipasteurisasi dan melalui proses pengeringan. Nama jenis untuk produk ini susu bubuk full cream.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 26%;<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang 32% dari padatan susu bukanlemak.",
    "Aktif",
  ],
  [
    "01050102",
    "Susu Bubuk Lemak Penuh (Full Cream) Instan (Plain)",
    "Susu bubuk lemak penuh (full cream) instan adalah susu bubuk yang tidak dikurangi lemaknya, yang mengalami proses instanisasi. Nama jenis untuk produk ini susu bubuk full cream instan.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 26%;<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang 32% dari padatan susu bukan lemak.",
    "Aktif",
  ],
  [
    "01050103",
    "Susu Bubuk Rendah Lemak dan Susu Bubuk Kurang Lemak",
    "Susu bubuk rendah lemak dan susu bubuk kurang lemak adalah produk susu berbentuk bubuk yang diperoleh dengan proses pengeringan susu yang sebelumnya telah dipisahkan sebagian lemak susunya dengan alat pemisah krim (cream separator) atau susu hasil pencampuran susu cair dengan susu kental atau krim bubuk; atau susu hasil pencampuran susu cair dengan susu kental atau susu bubuk.<br>",
    "Tidak Aktif",
  ],
  [
    "01050104",
    "Susu Bubuk Skim",
    "Susu bubuk skim adalah produk susu berbentuk bubuk yang diperoleh dengan proses pengeringan susu skim pasteurisasi.",
    "Aktif",
  ],
  [
    "01050105",
    "Krim Bubuk",
    "Krim bubuk adalah susu berbentuk bubuk yang diperoleh dengan menghilangkan sebagian air dari susu krim dengan pengering semprot.",
    "Aktif",
  ],
  ["01050106", "Susu Bubuk", "Susu Bubuk", "Tidak Aktif"],
  ["01050107", "Susu Bubuk untuk Kue", "-", "Tidak Aktif"],
  ["01050108", "Susu Bubuk Berperisa", "", "Tidak Aktif"],
  [
    "01050109",
    "Susu Bubuk Skim Sebagian",
    "Susu bubuk skim sebagian adalah produk susu berbentuk bubuk yang diperoleh dengan proses pengeringan susu yang sebelumnya telah dipisahkan sebagian lemak susunya dengan alat pemisah krim (cream separator) atau susu hasil pencampuran susu cair dengan susu kental atau susu skim bubuk.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu lebih dari 1,5% dan kurang dari 26%<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang 32% dari padatan susu bukan lemak",
    "Aktif",
  ],
  [
    "01050110",
    "Campuran Susu dan Krim Bubuk (Plain)",
    "Campuran susu dan krim bubuk (plain2) adalah produk susu berbentuk bubuk yang diperoleh dengan proses pengeringan susu<br> yang telah dipasteurisasi; atau susu hasil pencampuran susu cair dengan susu kental atau krim bubuk; atau susu hasil pencampuran susu cair dengan susu kental atau susu bubuk; atau rekombinasi susu bubuk dan krim bubuk.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 26%;<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "01050111",
    "Bubuk Buttermilk",
    "Bubuk buttermilk adalah produk susu yang diperoleh dari krim yang telah dipisahkan lemaknya, kemudian dikeringkan.",
    "Aktif",
  ],
  [
    "01050112",
    "Minuman Mengandung Susu Bubuk (Plain)",
    "Minuman mengandung susu bubuk (plain) adalah minuman yang dibuat dengan menggunakan susu, susu rekonstitusi atau susu rekombinasi, dapat ditambahkan gula.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 2,6%;<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%;<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang 3,2% dari padatan susu bukan lemak.",
    "Aktif",
  ],
  [
    "01050201",
    "Campuran Susu dan Krim Bubuk (Plain)",
    "Campuran susu dan krim bubuk (plain) adalah produk susu berbentuk bubuk yang diperoleh dengan proses pengeringan susu yang telah dipasteurisasi; atau susu hasil pencampuran susu cair dengan susu kental atau krim bubuk; atau susu hasil pencampuran susu cair dengan susu kental atau susu bubuk; atau rekombinasi susu bubuk dan krim bubuk.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu tidak kurang dari 26%<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%",
    "Tidak Aktif",
  ],
  [
    "01050202",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    "Campuran susu dan krim bubuk berperisa atau (dengan) rasa adalah produk susu berbentuk bubuk, dibuat dari susu bubuk dengan penambahan gula dan perisa dalam bentuk kakao bubuk atau kopi bubuk dan lain-lain.<br>",
    "Tidak Aktif",
  ],
  [
    "01050203",
    "Susu Bubuk Lemak Nabati/Susu Bubuk Minyak Nabati",
    "Susu bubuk lemak nabati / susu bubuk minyak nabati adalah produk susu berbentuk bubuk yang sebagian lemaknya telah dihilangkan dan digantikan dengan minyak nabati/lemak nabati dalam jumlah yang setara.",
    "Aktif",
  ],
  ["01050204", "Bubuk Buttermilk", "", "Tidak Aktif"],
  [
    "01050205",
    "Susu Bubuk (Rasa) (Susu Bubuk Cokelat, Susu Bubuk Stroberi, Susu Bubuk Vanila, Susu Bubuk Madu, dll)",
    "Susu bubuk yang ditambah dengan bahan pangan berupa bubuk kakao, ekstrak stroberi, ekstrak vanilla dan atau bahan lain yang sesuai, dapat ditambah gula dan atau perisa. Nama jenis produk ini susu bubuk cokelat, susu bubuk stroberi, susu bubuk vanilla, susu bubuk madu, dan lain-lain.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 11%<br> \xE2\x{20AC}\xA2 Kadar gula dihitung sebagai sakarosa tidak lebih dari 55%",
    "Tidak Aktif",
  ],
  [
    "01050206",
    "Susu Bubuk Rasa atau Berperisa (Susu Bubuk Rasa Cokelat, Susu Bubuk Rasa Stroberi, Susu Bubuk Rasa Vanila, Susu Bubuk Rasa Madu, dll)",
    "Susu bubuk yang ditambah dengan bahan tambahan pangan perisa, dan dapat ditambah gula. Nama jenis produk ini susu bubuk rasa cokelat, susu bubuk rasa stroberi, susu bubuk rasa vanilla, susu bubuk rasa madu, dan lain-lain.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 11%<br> \xE2\x{20AC}\xA2 Kadar gula dihitung sebagai sakarosa tidak lebih dari 55%",
    "Tidak Aktif",
  ],
  [
    "01060101",
    "Keju Cottage (Cottage Cheese)",
    "Keju cottage (cottage cheese) adalah keju lunak tanpa pemeraman yang dibuat dari susu segar atau susu segar yang dihilangkan lemaknya atau susu rekombinasi.<br> <br> Karakteristik dasar:<br> Padatan susu bukan lemak tidak kurang dari 18%",
    "Aktif",
  ],
  [
    "01060102",
    "Keju Krim (Cream Cheese)",
    "Keju krim (cream cheese) adalah keju lunak tanpa pemeraman yang dibuat dari krim atau susu yang ditambah dengan krim dengan penambahan kultur bakteri asam laktat dan enzim penggumpal (rennet, atau enzim penggumpal lainnya).<br> <br> Karakteristik dasar:<br> - Lemak susu dari total padatan tidak kurang dari 25%<br> - Kadar air terhadap bahan tanpa lemak tidak kurang dari 67%<br> - Total padatan tidak kurang dari 22%",
    "Aktif",
  ],
  [
    "01060103",
    "Keju Mozzarella",
    "Keju mozzarella adalah keju lunak yang dibuat dengan starter Lactobacillus bulgaricus dan Steptococcus thermophilus atau bakteri asam laktat lainnya yang sesuai.<br> <br> Karakteristik dasar:<br> Lemak susu dihitung terhadap bahan kering tidak kurang dari 20% (dengan kelembaban tinggi), tidak kurang dari 18% (dengan kelembaban rendah)",
    "Aktif",
  ],
  [
    "01060104",
    "Keju Bocconcini",
    "Keju Bocconcini adalah keju lunak, segar, yang tidak mudah putus (stretch curd), plastis, dengan rasa sedikit ringan dan aroma segar",
    "Aktif",
  ],
  [
    "01060105",
    "Keju Tanpa Pemeraman (Keju Mentah)",
    "&nbsp;",
    "Aktif",
  ],
  [
    "01060106",
    "Keju Cottage yang ditambah krim (Creamed Cottage Cheese)",
    "Keju cottage yang ditambah krim (creamed cottage cheese) adalah keju lunak tanpa pemeraman yang dibuat dari susu segar atau susu segar yang dihilangkan lemaknya atau susu rekombinasi dan ditambahkan krim.",
    "Aktif",
  ],
  [
    "0106020101",
    "Keju Biru (Blue cheese)",
    "Keju biru (blue cheese) adalah keju keras yang dibuat dengan starter<br> Lactobacillus lactis subsp. lactis biovar diacetylactis dan cremoris,<br> diperam dengan Penicillium roqueforti tidak kurang dari 60 hari,<br> ditandai dengan adanya kapang hijau kebiruan di seluruh bagian<br> keju.",
    "Aktif",
  ],
  [
    "0106020102",
    "Keju Bata (Brick Cheese)",
    "Keju bata (brick cheese) adalah keju keras yang diperoleh dari susu dan ingredien lainnya, jika dibuat dari susu segar maka pemeraman dilakukanpada suhu tidak kurang dari 35\\xB0C dan waktu tidak kurang dari 60 hari. Keju bata dapat juga diproses pada suhu da",
    "Aktif",
  ],
  [
    "0106020103",
    "Keju Gouda",
    "Keju gouda adalah keju khas Belanda, yang dibuat dengan starter bakteri asam laktat yang sesuai, tergolong keju agak keras (semi hard) dengan kulit keras dan dilapis lilin atau bahan lainnya.",
    "Aktif",
  ],
  [
    "0106020104",
    "Keju Havarti",
    "Keju havarti adalah keju khas Denmark yang tergolong keju agak keras (semi hard), dengan atau tanpa kulit hasil pengentalan bakteri asam laktat, rennet atau penggumpal lainnya dan difermentasi dengan bakteri asam laktat dan kapang dengan penambahan garam.",
    "Aktif",
  ],
  [
    "0106020105",
    "Keju Brie",
    "Keju brie adalah keju yang dihasilkan dengan starter Lactobacillus lactis subsp. lactis dan cremoris, dan diperam dengan Penicillium caseicolum atau kapang, kamir, bakteri lain yang sesuai.",
    "Aktif",
  ],
  [
    "0106020106",
    "Keju Parmesan",
    "Keju parmesan adalah keju khas Italia (Parma) yang diperoleh dari<br> susu yang dipanaskan dan digumpalkan sebelum semua krim<br> dipisahkan. Gumpalan dipotong dan dipanaskan pada suhu 52\xBAC,<br> dimasak sampai suhu 55\xBAC, dibentuk lalu diperam dalam air garam.<br> Keju parmesan dapat juga diproses pada suhu dan lama<br> pemeraman yang berbeda, tergantung dari teknologi yang dipakai.",
    "Aktif",
  ],
  [
    "0106020107",
    "Keju Swiss",
    "Keju swiss adalah keju dengan kulit keras dan berlubang-lubang di bagian dalamnya karena gas yang terbentuk selama pemeraman.",
    "Aktif",
  ],
  [
    "0106020108",
    "Keju Edam",
    "Keju edam adalah keju semi keras khas Belanda. Keju edam juga dibuat di berbagai negara. Tekstur keju ini elastis, liat, lebih lembut dari keju gouda. Lubang gasnya (gas holes) sedikit.<br> Karakteristik dasar:<br> Lemak susu dihitung terhadap bahan kering tidak kurang dari 30%",
    "Aktif",
  ],
  [
    "0106020109",
    "Keju Cheddar",
    "Keju cheddar adalah keju keras yang dibuat dari susu sapi dengan pemeraman pada suhu tidak kurang dari 35\xBAC dan waktu tidak kurang dari 60 hari. Keju cheddar dapat juga diproses pada suhu dan lama pemeraman yang berbeda, tergantung dari teknologi yang dipakai.<br> Karakteristik dasar:<br> Lemak susu dihitung terhadap bahan kering tidak kurang dari 22%.",
    "Aktif",
  ],
  [
    "0106020110",
    "Keju Camembert",
    "Keju camembert adalah keju lunak yang diperam dengan kapang Penicillium candidum, dan/atau Penicillium camembertii dan Penicillium caseicolum.<br> Karakteristik dasar:<br> Lemak susu dihitung terhadap bahan kering tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "0106020111",
    "Keju Bath",
    "Keju bath adalah keju lunak khas Inggris. Keju ini dibuat dari susu<br> sapi yang tidak dipasteurisasi.",
    "Aktif",
  ],
  [
    "0106020112",
    "Keju Bondard",
    "Keju bondard adalah keju khas Perancis. Keju ini dibuat dari susu<br> sapi yang tidak dipasteurisasi",
    "Aktif",
  ],
  [
    "0106020113",
    "Keju Bougon",
    "Keju bougon adalah keju lunak khas Perancis. Keju ini dibuat dari<br> susu kambing",
    "Aktif",
  ],
  [
    "0106020114",
    "Keju Bouquet des moines",
    "Keju bouquet des moines adalah keju khas Belgia. Dibuat dari susu<br> sapi",
    "Aktif",
  ],
  [
    "0106020115",
    "Keju Peram Lainnya",
    "Keju peram lainnya adalah keju peram yang tidak termasuk keju<br> peram di atas, misalnya keju feta",
    "Aktif",
  ],
  [
    "01060202",
    "Kulit Keju Peram",
    "Kulit keju peram adalah kulit keju yang telah mengalami proses<br> pemeraman dan perendaman dalam larutan garam. Kulit keju<br> adalah bagian terluar dari keju yang dapat saja memiliki komposisi<br> yang sama dari bagian dalam keju, namun dapat kering setelah<br> proses pemeraman dan perendaman dalam larutan garam.<br> Beberapa jenis keju menggunakan pelapis lilin untuk kulit yang<br> mungkin ditambah pewarna yang diizinkan untuk melindungi keju.",
    "Aktif",
  ],
  [
    "01060203",
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju)",
    "Keju bubuk adalah hasil pengeringan dari aneka jenis keju olahan. Keju bubuk direkonstitusi dengan air atau susu untuk pembuatan saus, atau digunakan sebagai ingredien (misalnya untuk makaroni dan keju), termasuk keju yang diproses dengan pengering semprot.",
    "Aktif",
  ],
  [
    "010602A0",
    "Keju Peram",
    "Keju peram adalah keju yang tidak dapat dikonsumsi setelah pembuatannya tetapi diperam pada kondisi tertentu agar terjadi perubahan fisik dan biokimiawi yang diinginkan. Untuk keju yang diperam dengan kapang maka pemeraman dicapai dengan menumbuhkan kapang di seluruh bagian dalam dan atau luar keju tersebut. Termasuk keju cheddar, keju cheddar untuk bahan baku, keju edam, keju camembert dan keju feta.",
    "Tidak Aktif",
  ],
  [
    "010602A1",
    "Keju Cheddar",
    "Keju cheddar adalah keju keras yang dibuat dari susu sapi dengan pemeraman pada suhu tidak kurang dari 35\xBAC dan waktu tidak kurang dari 60 hari. Keju cheddar dapat juga diproses pada suhu dan lama pemeraman yang berbeda, tergantung dari teknologi yang dipakai.<br> <br> Karakteristik dasar:<br> Lemak susu dihitung terhadap bahan kering tidak kurang dari 22%",
    "Tidak Aktif",
  ],
  [
    "010602A3",
    "Keju Edam",
    "Keju edam adalah keju semi keras khas Belanda. Keju edam juga dibuat di berbagai negara. Tekstur keju ini elastis, liat, lebih lembut dari keju gouda. Lubang gasnya (gas holes) sedikit.<br> <br> Karakteristik dasar:<br> Lemak susu dihitung terhadap bahan kering tidak kurang dari 30%",
    "Tidak Aktif",
  ],
  [
    "010602A4",
    "Keju Camembert",
    "Keju camembert adalah keju lunak yang diperam dengan kapang Penicillium candidum, dan atau Penicillium camembertii dan Penicillium caseicolum. Karakteristik dasar : Lemak susu dihitung terhadap bahan kering tidak kurang dari 30%",
    "Tidak Aktif",
  ],
  [
    "010602A5",
    "Keju Bath",
    "Keju bath adalah keju lunak khas Inggris. Keju ini dibuat dari susu sapi yang tidak dipasteurisasi.",
    "Aktif",
  ],
  [
    "010602A6",
    "Keju Bondard",
    "Keju bondard adalah keju khas Perancis. Keju ini dibuat dari susu sapi yang tidak dipasteurisasi.",
    "Tidak Aktif",
  ],
  [
    "010602A7",
    "Keju Bougon",
    "Keju bougon adalah keju lunak khas Perancis. Keju ini dibuat dari susu kambing.",
    "Tidak Aktif",
  ],
  [
    "010602A8",
    "Keju Bouquet des moines",
    "Keju bouquet des moines adalah keju khas Belgia. Dibuat dari susu sapi.",
    "Tidak Aktif",
  ],
  [
    "010602A9",
    "Keju Boursault",
    "Keju boursault adalah keju lunak khas Perancis. Dibuat dari susu sapi.",
    "Aktif",
  ],
  [
    "010603",
    "Keju Whey",
    "Keju whey adalah produk padat atau semipadat yang diperoleh dari pemekatan whey dengan atau tanpa penambahan susu, krim susu atau komponen susu lainnya dan dibentuk.<br> Termasuk didalamnya adalah keju whey berkrim, keju whey, dan keju whey berskim.",
    "Aktif",
  ],
  [
    "0106040102",
    "Keju Amerika (American Cheese)",
    "",
    "Tidak Aktif",
  ],
  [
    "0106040104",
    "Keju Olahan Plain",
    "Keju olahan plain adalah produk olahan keju tanpa penambahan perisa, bumbu, buah, sayur atau daging. Contoh meliputi American cheese, requeson",
    "Aktif",
  ],
  [
    "0106040201",
    "Keju Neufchatel dan Sayuran Untuk Olesan",
    "",
    "Tidak Aktif",
  ],
  [
    "0106040203",
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging",
    "Keju olahan berperisa adalah produk olahan keju yang mengandung bahan tambahan perisa, pewarna, dan pengemulsi, bumbu, buah, sayur dan atau daging.",
    "Aktif",
  ],
  [
    "010604A0",
    "Keju Olahan",
    "Keju olahan adalah produk yang diperoleh dengan menggiling,<br> mencampur, melelehkan dan mengemulsikan dengan pemanasan<br> dan pengemulsi dari satu atau lebih jenis keju dengan atau tanpa<br> penambahan komponen susu dan atau bahan pangan lainnya<br> seperti bumbu dan buah, sayur atau daging. Produk ini dapat<br> berbentuk olesan atau diiris menjadi irisan.",
    "Tidak Aktif",
  ],
  [
    "010604A1",
    "Keju Cheddar Olahan",
    "Keju cheddar olahan adalah keju yang diperoleh dengan mencampurkan keju cheddar.",
    "Tidak Aktif",
  ],
  [
    "010605",
    "Analog keju",
    "Analog keju adalah produk keju yang sebagian atau seluruh lemak susunya digantikan dengan lemak lain.",
    "Aktif",
  ],
  [
    "010606",
    "Keju Protein Whey (Misal Keju Ricotta)",
    "Keju protein whey adalah keju yang dibuat dari protein yang diekstrak dari whey. Produk ini pada prinsipnya dibuat dari koagulasi protein whey. Contohnya adalah keju ricotta. Tidak sama dengan keju whey (kategori pangan 01.6.3)",
    "Aktif",
  ],
  ["010607", "Keju Haloumy", "-", "Tidak Aktif"],
  ["0106A3", "Keju Haloumy", "", "Tidak Aktif"],
  [
    "010701",
    "Es Krim",
    "Es krim adalah produk beku yang diperoleh dari susu atau produk susu atau campurannya yang sebagian lemak susu diganti dengan lemak nabati, dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak total tidak kurang dari 5%;<br> \xE2\x{20AC}\xA2 Total padatan susu tidak kurang dari 5%;<br> \xE2\x{20AC}\xA2 Total padatan tidak kurang dari 31%.",
    "Aktif",
  ],
  [
    "010702",
    "Yogurt Berperisa/Rasa",
    "Yogurt berperisa/rasa adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Lactobacillus bulgaricus dan Streptococcus thermophilus, dapat ditambahkan bakteri lain yang sesuai, dengan penambahan perisa/rasa.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 4,6%;<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 1,6%;<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0,5%.",
    "Aktif",
  ],
  [
    "010703",
    "Es Susu",
    "Es susu adalah produk beku yang dibuat dari campuran susu dan/atau produk susu dengan air, dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 1%",
    "Aktif",
  ],
  [
    "010704",
    "Junket",
    "Junket adalah makanan pencuci mulut seperti custard manis yang dibuat dari susu berperisa yang diatur dengan rennet.",
    "Aktif",
  ],
  [
    "010705",
    "Dulce de leche",
    "Dulce de leche adalah susu yang telah dimasak dengan gula dan bahan pangan lainnya seperti kelapa atau cokelat.",
    "Aktif",
  ],
  [
    "010706",
    "Puding Butterscotch atau Puding Susu",
    "Puding Butterscotch atau Puding Susu adalah makanan pencuci mulut berbentuk padat lunak yang terbuat dari susu segar atau produk susu atau campurannya yang ditambah dengan pati atau bahan pembentuk gel dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar:<br> Kandungan susu dan atau turunannya tidak kurang dari 50%",
    "Aktif",
  ],
  ["010707", "Mousse Cokelat", "", "Tidak Aktif"],
  [
    "010708",
    "Kembang Gula Susu/Permen Susu",
    "Kandungan susu tidak kurang dari 5%",
    "Aktif",
  ],
  ["010709", "Non Dairy Pudding", "", "Tidak Aktif"],
  [
    "010710",
    "Puding berbahan dasar susu",
    "Puding berbahan dasar susu.<br> <br> Status diubah menjadi TIDAK AKTIF, sudah ada kategori baru : Puding Butterscotch atau Puding Susu (010706)",
    "Tidak Aktif",
  ],
  [
    "010711",
    "Bubuk Puding Butterscotch/Puding Susu",
    "Bubuk Puding Butterscotch/Puding Susu adalah makanan pencuci mulut berbentuk bubuk yang terbuat dari susu segar atau produk susu atau campurannya yang ditambah dengan pati atau bahan pembentuk gel dengan atau tanpa penambahan bahan pangan lain dan harus ditambahkan air sebelum diolah lebih lanjut menjadi puding.<br> <br> Kandungan padatan susu dan atau turunannya tidak kurang dari<br> 5%\"<br>",
    "Aktif",
  ],
  [
    "010712",
    "Premiks Es Krim (Bubuk)",
    "Premiks es krim bubuk adalah produk berbentuk bubuk dengan bahan dasar susu atau produk susu atau campurannya dengan penambahan bahan pangan lain yang dapat ditambahkan air sebelum diolah lebih lanjut menjadi es krim.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 4.5%<br> \xE2\x{20AC}\xA2 Kadar lemak total tidak kurang dari 15% dan kadar lemak susu tidak kurang dari 4.8%<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  ["010713", "Topping Berbasis Susu", "-", "Tidak Aktif"],
  [
    "010714",
    "Makanan Pencuci Mulut Berbahan Dasar Susu",
    "Termasuk produk pencuci mulut berbasis susu dan bubuk instan<br> pencuci mulut, confectionery susu beku, bahan isian berbasis susu, yogurt berperisa. Produk ini berbeda dari kategori pangan 03.0 (es<br> yang dapat dimakan, termasuk sherbet dan sorbet), dimana pro",
    "Aktif",
  ],
  [
    "010715",
    "Premiks Es Krim (Cair)",
    "Premiks es krim cair adalah produk berbentuk cair dengan bahan dasar susu atau produk susu atau campurannya dengan penambahan bahan pangan lain yang dapat ditambahkan air sebelum diolah lebih lanjut menjadi es krim.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak total tidak kurang dari 5%<br> \xE2\x{20AC}\xA2 Total padatan susu tidak kurang dari 5%<br> \xE2\x{20AC}\xA2 Total padatan tidak kurang dari 31%<br>",
    "Aktif",
  ],
  ["010716", "Yogurt Berperisa/Rasa Bubuk", "-", "Aktif"],
  [
    "010717",
    "Es Mengandung Susu",
    "Es mengandung susu adalah produk beku yang dibuat dari campuran susu dengan air dan gula, dapat ditambahkan bahan pangan lain.<br> Karakteristik dasar :<br> - Kadar lemak susu lebih dari 0.5% dan kurang dari 2%<br> - Total padatan susu bukan lemak tidak kurang dari 1.1%",
    "Tidak Aktif",
  ],
  [
    "010718",
    "Kefir Berperisa/rasa",
    "Kefir berperisa/rasa adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan kultur starter yang dibuat dari biji kefir, Lactobacillus kefiri, spesies dari genus Leuconostoc, Lactococcus dan Acetobacter yang tumbuh saling sinergi. Biji kefir mengandung khamir yang mampu memfermentasi laktosa (Kluyveromyces marxianus) dan khamir yang tidak mampu memfermentasi laktosa (Saccharomyces unisporus, Saccharomyces cerevisiaem, dan Saccharomyces exiguus), dapat ditambahkan bakteri lain yang sesuai, dengan penambahan perisa/rasa.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 4.6%<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 1.6%<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0.6%<br>",
    "Aktif",
  ],
  ["010719", "Es Krim Modifikasi", "-", "Tidak Aktif"],
  [
    "010720",
    "Es Krim Susu (Dairy Ice Cream)",
    "Es Krim Susu (Dairy Ice Cream) adalah produk beku yang diperoleh dari susu atau produk susu atau campurannya, tanpa penambahan lemak selain lemak susu, dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik Dasar :<br> Kadar protein susu tidak kurang dari 2.7%<br> Kadar lemak susu tidak kurang dari 5%<br> Total padatan tidak kurang dari 31%",
    "Aktif",
  ],
  [
    "010721",
    "Premiks Es Susu (Bubuk)",
    "Premiks Es Susu (bubuk) adalah produk berbentuk bubuk dengan bahan dasar susu atau produk susu atau campurannya dengan atau tanpa penambahan bahan pangan lain yang dapat ditambahkan air sebelum diolah lebih lanjut menjadi es susu.<br> <br> Karakteristik Dasar :<br> Bentuk Bubuk<br> - kadar protein susu tidak kurang dari 3%<br>",
    "Aktif",
  ],
  [
    "010722",
    "Premiks Es Susu (Cair)",
    "Premiks Es Susu (cair) adalah produk berbentuk cair dengan bahan dasar susu atau produk susu atau campurannya dengan atau tanpa penambahan bahan pangan lain yang dapat ditambahkan air sebelum diolah lebih lanjut menjadi es susu.<br> <br> Karakteristik Dasar :<br> Bentuk Cair<br> - kadar protein susu tidak kurang dari 1%",
    "Aktif",
  ],
  [
    "010723",
    "Yogurt Kultur Lain Berperisa/Rasa (alternate culture yogurt)",
    "Yogurt kultur lain adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Streptococcus thermophilus dan spesies Lactobacillus, dapat ditambahkan bakteri lain yang sesuai. Penamaan produk mengikuti ketentuan Standar Codex untuk Susu Fermentasi, dengan penambahan perisa/rasa.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 4.6%<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 1.6%<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0.5%<br>",
    "Aktif",
  ],
  [
    "010724",
    "Susu Fermentasi atau Susu Berkultur Berperisa/Rasa",
    "Susu fermentasi atau susu berkultur berperisa/rasa adalah produk susu yang dihasilkan dari fermentasi susu segar dengan atau tanpa pasteurisasi, susu rekonstitusi atau susu rekombinasi yang diperoleh dari fermentasi dengan mikroba yang sesuai, dengan penambahan perisa/rasa.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan susu bukan-lemak tidak kurang dari 4,6%;<br> \xE2\x{20AC}\xA2 Kadar protein susu tidak kurang dari 1,6%;<br> \xE2\x{20AC}\xA2 Kadar asam laktat tidak kurang dari 0,5%.",
    "Aktif",
  ],
  [
    "010725",
    "Makanan Pencuci Mulut Berbahan Dasar Susu (Bubuk)",
    "",
    "Aktif",
  ],
  [
    "01080101",
    "Whey",
    "Whey adalah cairan yang dipisahkan dari susu setelah penggumpalan susu, krim, susu skim atau buttermilk dengan rennet atau enzim lainnya dalam pembuatan keju, kasein dan produk lain yang sejenis.",
    "Aktif",
  ],
  [
    "01080102",
    "Whey Asam",
    "Whey asam adalah cairan yang dipisahkan setelah penggumpalan susu dengan asam, khususnya dalam pembuatan keju mentah (tanpa pemeraman).",
    "Aktif",
  ],
  [
    "01080201",
    "Bubuk Whey",
    "Bubuk whey adalah produk whey yang diperoleh dari pengeringan (baik oleh pengering semprot atau drum) whey atau whey asam yang sebagian besar lemaknya telah diambil.",
    "Aktif",
  ],
  [
    "01080202",
    "Bubuk Whey yang Telah Didemineralisasi",
    "Bubuk whey yang telah didemineralisasi adalah produk whey yang diperoleh dari pengeringan (baik pengering semprot atau drum) whey atau whey asam yang sebagian besar lemaknya telah diambil dan telah dilakukan pengurangan pada kandungan mineralnya sesuai dengan kebutuhan.",
    "Aktif",
  ],
  [
    "01080203",
    "Bubuk Whey Permeate",
    "Bubuk whey permeate adalah produk whey yang diperoleh dari<br> pengeringan whey yang telah dipisahkan proteinnya.",
    "Aktif",
  ],
  [
    "02010101",
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil)",
    "Lemak susu anhidrat (AMF), minyak mentega (butter oil) adalah produk lemak dan minyak yang diperoleh secara khusus dari susu,<br> krim, atau mentega melalui proses pengolahan untuk menghilangkan air dan padatan bukan-lemak sampai hampir sempurna.<br> <br> Karakteristik dasar :<br> - Lemak susu anhidrat :<br> Kadar lemak susu tidak kurang dari 99,8%;<br> - Minyak mentega anhidrat :<br> Kadar lemak susu tidak kurang dari 99,8%;<br> - Minyak mentega :<br> Kadar lemak susu tidak kurang dari 99,3%.",
    "Aktif",
  ],
  [
    "02010102",
    "Ghee",
    "Ghee adalah produk khusus dari susu, krim atau mentega yang<br> diperoleh melalui proses pengolahan untuk menghilangkan air dan<br> padatan bukan-lemak sampai hampir sempurna, serta mempunyai<br> aroma dan tekstur yang khas.<br> <br> Karakteristik dasar :<br> - Kadar air tidak lebih dari 0,1%;<br> - Kadar asam lemak bebas (sebagai asam oleat) tidak lebih dari 0,4%.",
    "Aktif",
  ],
  [
    "02010201",
    "Lemak dan Minyak Nabati",
    "Lemak dan minyak nabati adalah lemak dan minyak yang diperoleh dari tanaman. Produk lemak dan minyak ini dapat berasal dari sumber tunggal atau campuran, dan dipasarkan dengan istilah minyak makan, minyak masak atau minyak sayur, minyak goreng, minyak meja atau minyak salad, minyak nabati dan lemak nabati.<br> <br> Karakteristik dasar :<br> - Lemak dan Minyak yang telah dimurnikan/rafinasi (refined oil)<br> a. Kadar air tidak lebih dari 0,15%;<br> b. Kadar asam lemak bebas tidak lebih dari 0,3%;<br> - Minyak mentah (crude oil)<br> a. Kadar air tidak lebih dari 0,5%;<br> b. Kadar asam lemak bebas tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "02010202",
    "Virgin Oil",
    "Virgin oil adalah produk minyak yang diperoleh secara mekanis (contohnya dengan pengepresan atau dikempa) tanpa pemanasan atau dengan pemanasan api kecil pada suhu kurang dari 60\xB0C dan tanpa penggunaan bahan kimia. Minyak dapat dimurnikan dengan pencucian menggunakan air, pengendapan, penyaringan dan atau sentrifugasi. Virgin oil dapat berasal dari berbagai bahan (zaitun, kelapa, wijen, dan lain-lain), contoh Virgin Coconut Oil (VCO)<br> <br> Karakteristik dasar :<br> - Bilangan peroksida tidak lebih dari 10 mek O2/kg;<br> - Lihat tabel komposisi asam lemak minyak nabati sesuai asalnya.",
    "Aktif",
  ],
  [
    "02010203",
    "Cold Pressed Oils",
    "Cold pressed oils adalah produk minyak yang diperoleh secara mekanis tanpa pemanasan. Minyak dapat dimurnikan dengan pencucian menggunakan air, pengendapan, penyaringan dan atau sentrifugasi. Contohnya adalah minyak zaitun, minyak biji kapas, minyak kacang tanah, minyak kelapa, dan minyak inti sawit.",
    "Aktif",
  ],
  [
    "02010204",
    "Minyak Goreng (Frying oil atau frying fat)",
    "Minyak goreng (frying oil atau frying fat) adalah minyak dan lemak yang digunakan untuk menggoreng yang diperoleh dari proses rafinasi /pemurnian (refining/purifying) minyak nabati, dalam bentuk tunggal atau campuran.",
    "Tidak Aktif",
  ],
  [
    "02010205",
    "Minyak Masak atau Minyak Sayur (Cooking Oil)",
    "Minyak masak atau minyak sayur (cooking oil) adalah minyak yang digunakan untuk memasak (seperti menumis atau shallow frying/stirfry/ pan frying), diperoleh dari proses rafinasi /pemurnian minyak nabati, dapat berasal dari sumber tunggal atau campuran.<br> <br> Karakteristik dasar :<br> - Kadar air tidak lebih dari 0,15%;<br> - Kadar asam lemak bebas tidak lebih dari 0,3%;<br> - Bilangan peroksida tidak lebih dari 10 mek O2/kg.",
    "Aktif",
  ],
  [
    "02010206",
    "Minyak Salad (Salad Oil)",
    "Minyak salad adalah minyak yang diperoleh dari proses rafinasi/pemurnian (refining/purifying) minyak nabati, digunakan untuk pembuatan mayonais, salad dressing dan saus.<br> <br> Karakteristik dasar :<br> - Cair pada temperatur ruang;<br> - Kadar air tidak lebih dari 0,15%;<br> - Kadar asam lemak bebas tidak lebih dari 0,2%.",
    "Aktif",
  ],
  [
    "02010207",
    "Serbuk Minyak",
    "Serbuk minyak adalah produk minyak yang dikeringkan menjadi serbuk dengan tambahan tepung atau sejenisnya.",
    "Tidak Aktif",
  ],
  [
    "02010208",
    "Vanaspati atau Minyak Samin (Vegetable Ghee)",
    "Vanaspati atau minyak samin (vegetable ghee) adalah produk semi padat/padat yang diperoleh dari proses rafinasi/pemurnian minyak dan atau lemak nabati.<br> <br> Karakteristik dasar :<br> - Kadar lemak nabati tidak kurang dari 97%;<br> - Tidak mengandung lemak atau minyak hewani;<br> - Titik leleh/lebur 30oC hingga 48\\xB0C;<br> - Kadar air tidak lebih dari 0,25%;<br> - Kadar bahan tak tersabunkan tidak lebih dari 12,5 g/kg;<br> - Kadar asam lemak bebas (sebagai asam oleat) tidak lebih dari 0,5%.",
    "Aktif",
  ],
  [
    "02010209",
    "Lemak Reroti (Shortening)",
    "Lemak reroti (shortening) adalah produk hasil olahan lemak/minyak nabati dengan atau tanpa penambahan lemak hewani dan atau lemak susu yang berbentuk semi padat/padat.<br> <br> Karakteristik dasar :<br> - Kadar air tidak lebih dari 0,15%;<br> - Kadar asam lemak bebas (dihitung sebagai asam lemak dominan dari minyak nabati yang digunakan) tidak lebih dari 0,3%, yaitu :<br> a. Jika berasal dari minyak sawit, asam lemak bebas dihitung sebagai asam palmitat;<br> b. Jika berasal dari minyak kelapa atau minyak inti sawit, asam lemak bebas dihitung sebagai asam laurat;<br> c. Jika berasal dari minyak nabati lainnya, asam lemak bebas dihitung sebagai asam oleat.",
    "Aktif",
  ],
  [
    "02010210",
    "Pengganti Minyak Mentega (Butter Oil Substitute)",
    "Pengganti minyak mentega (butter oil substitute) adalah minyak nabati dengan atau tanpa penambahan lemak hewani dan atau lemak susu yang digunakan sebagai pengganti minyak mentega dengan sifat fisik dan rasa seperti mentega.<br> <br> Karakteristik dasar :<br> - Kadar air tidak lebih dari 0,15%;<br> - Kadar asam lemak bebas (dihitung sebagai asam lemak dominan<br> dari minyak nabati yang digunakan) tidak lebih dari 0,3%, yaitu :<br> a. Jika berasal dari minyak sawit, asam lemak bebas dihitung sebagai asam palmitate;<br> b. Jika berasal dari minyak kelapa atau minyak inti sawit, asam lemak bebas dihitung sebagai asam laurat;<br> c. Jika berasal dari minyak nabati lainnya, asam lemak bebas dihitung sebagai asam oleat.",
    "Aktif",
  ],
  [
    "02010214",
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO)",
    "Minyak kelapa sawit adalah minyak yang diperoleh dari hasil proses rafinasi / pemurnian minyak kelapa sawit mentah.<br> <br> Karakteristik dasar:<br> - Kadar air dan kotoran tidak lebih dari 0.1%;<br> - Bilangan iod 50 - 55 g I2/100 g;<br> - Bilangan peroksida tidak lebih dari 10 mek O2/kg;<br> - Kadar asam lemak bebas dihitung sebagai asam palmitat tidak lebih dari 0.1%.",
    "Aktif",
  ],
  [
    "02010215",
    "Serbuk Minyak Kelapa Sawit",
    "Serbuk minyak kelapa sawit adalah minyak kelapa sawit yang dikeringkan menjadi serbuk dengan tambahan tepung atau sejenisnya.",
    "Tidak Aktif",
  ],
  [
    "02010218",
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein)",
    "Minyak olein kelapa sawit adalah fraksi cair minyak kelapa sawit yang berwarna kekuningan yang diperoleh dari hasil proses rafinasi / pemurnian minyak olein kelapa sawit mentah (Crude Palm Oil / CPO) atau fraksinasi minyak kelapa sawit yang sudah dirafina",
    "Aktif",
  ],
  [
    "02010219",
    "Minyak Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin)",
    "Minyak stearin kelapa sawit adalah fraksi padat minyak kelapa sawit yang berwarna kekuningan yang diperoleh dari hasil proses rafinasi /<br> pemurnian stearin kelapa sawit mentah (crude palm stearin), atau fraksinasi minyak kelapa sawit (RBD palm oil).",
    "Aktif",
  ],
  [
    "02010221",
    "Serbuk Minyak Kelapa Virgin",
    "Serbuk minyak kelapa virgin adalah minyak kelapa virgin yang dikeringkan menjadi serbuk dengan tambahan tepung atau sejenisnya.",
    "Tidak Aktif",
  ],
  [
    "02010222",
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil )",
    "Minyak kelapa adalah minyak yang diperoleh dari hasil proses rafinasi / pemurnian dari minyak kelapa mentah (crude coconut oil).",
    "Aktif",
  ],
  [
    "02010223",
    "Serbuk Minyak Kelapa",
    "Serbuk minyak kelapa adalah minyak kelapa yang dikeringkan menjadi serbuk dengan tambahan tepung atau sejenisnya.",
    "Tidak Aktif",
  ],
  [
    "02010224",
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/<br> Refined Bleached Deodorized Groundnut Oil)",
    "Minyak kacang tanah adalah minyak makan yang diperoleh dari biji kacang tanah (Arachis hypogea L.) dan telah mengalami proses rafinasi / pemurnian.",
    "Aktif",
  ],
  [
    "02010225",
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil)",
    "Minyak jagung adalah minyak makan yang diperoleh dari biji jagung (Zea mays L.) dan telah mengalami proses rafinasi / pemurnian.",
    "Aktif",
  ],
  [
    "02010226",
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil)",
    "Minyak kemiri adalah minyak yang diperoleh dari biji kemiri (Aleurites mollucana Wild) dan telah mengalami proses rafinasi / pemurnian.",
    "Aktif",
  ],
  [
    "02010227",
    "Minyak Kedelai (Refined Bleached Deodorized Soyabean Oil)",
    "Minyak kedelai adalah minyak makan yang diperoleh dari biji kedelai (Glycine max (L) Merr.) dan telah mengalami proses rafinasi / pemurnian.",
    "Aktif",
  ],
  [
    "02010228",
    "Minyak Wijen (Sesame Oil)",
    "Minyak wijen adalah minyak yang diperoleh dari biji wijen (Sesamum indicum L) dengan atau tanpa mengalami proses sangrai (roasted).",
    "Aktif",
  ],
  [
    "02010229",
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil)",
    "Minyak zaitun adalah minyak yang diperoleh dari buah Zaitun (Olea europaea) dan telah mengalami proses rafinasi / pemurnian.",
    "Aktif",
  ],
  [
    "02010230",
    "Minyak Safflower",
    "Minyak safflower adalah minyak makan yang diperoleh dari biji Carthamus tintorius dan telah mengalami proses rafinasi / pemurnian.",
    "Aktif",
  ],
  [
    "02010231",
    "Minyak Biji Bunga Matahari",
    "Minyak biji bunga matahari adalah minyak makan yang diperoleh dari biji bunga matahari (Helianthus annuus L.) dan telah mengalami proses rafinasi / pemurnian.",
    "Aktif",
  ],
  [
    "02010232",
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached<br> Deodorized Rice Brand Oil)",
    "Minyak dedak atau minyak bekatul atau minyak katul adalah minyak dari katul beras pecah kulit tanaman padi (Oryza sativa) dan telah mengalami proses rafinasi / pemurnian.",
    "Aktif",
  ],
  [
    "02010233",
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil)",
    "Minyak biji kapas adalah minyak yang diperoleh dari biji kapas (Gossypium sp.) dan telah mengalami proses rafinasi / pemurnian.",
    "Aktif",
  ],
  [
    "02010234",
    "Minyak Kanola (Refined Bleached Deodorized Rapeseed Oil)",
    "Rapeseed oil adalah minyak yang dihasilkan dari biji Brassica<br> napus L., Brassica rapa L., Brassica juncea L. dan Brassica<br> tournefortii Gouan",
    "Aktif",
  ],
  [
    "02010235",
    "Mustardseed Oil (Refined Bleached Deodorized Mustardseed Oil)",
    "Mustardseed oil adalah minyak yang diperoleh dari biji Brassica juncea atau Brassica nigra dan telah mengalami proses rafinasi / pemurnian.",
    "Aktif",
  ],
  [
    "02010236",
    "Extra Virgin Olive Oil",
    "Extra virgin olive oil adalah virgin olive oil dengan kadar asam<br> lemak bebas sebagai asam oleat tidak lebih dari 0,8 gram per 100<br> gram",
    "Aktif",
  ],
  [
    "02010237",
    "Minyak Goreng Sawit",
    "Bahan pangan dengan komposisi utama trigliserida berasal dari minyak sawit, dengan atau tanpa perubahan kimiawi, pendinginan dan telah melalui proses pemurnian dengan penambahan vitamin A.",
    "Aktif",
  ],
  [
    "02010239",
    "Virgin olive oil",
    "Virgin olive oil adalah virgin olive oil dengan kadar asam lemak bebas sebagai asam oleat tidak lebih dari 2 gram per 100 gram",
    "Aktif",
  ],
  [
    "02010240",
    "Ordinary Virgin olive oil",
    "Ordinary virgin olive oil adalah virgin olive oil dengan kadar asam<br> lemak bebas sebagai asam oleat tidak lebih dari 3,3 gram per 100<br> gram",
    "Aktif",
  ],
  [
    "02010241",
    "Minyak Goreng Padat (Frying Fat)",
    "Minyak goreng yang dalam suhu ruang berbentuk padat atau semi padat atau semi liquid yang berasal dari minyak sawit dan atau dicampur dengan minyak nabati lainnya, dengan atau tanpa perubahan kimiawi, hidrogenasi penuh, pendinginan dan telah melalui proses pemurnian<br> <br> Karakteristik dasar :<br> - Kadar air tidak lebih dari 0,1%;<br> - Kadar asam lemak bebas sebagai asam palmitat tidak lebih dari<br> 0.3%;<br> - Bilangan peroksida tidak lebih dari 10 mek O2/kg;<br> - Kadar asam lemak trans 0%<br>",
    "Aktif",
  ],
  [
    "02010242",
    "Serbuk Lemak (Fat Powder)",
    "Serbuk lemak adalah produk lemak nabati dan atau lemak hewani yang berbentuk serbuk dengan atau tanpa penambahan bahan pengisi. Contoh : Serbuk Lemak Kelapa Sawit, Serbuk Lemak Kelapa Virgin, Serbuk Lemak Kelapa, Serbuk Minyak Ikan.",
    "Aktif",
  ],
  [
    "02010243",
    "Rapeseed oil - low erucic acid (low erucic acid turnip rape oil/low erucic acid colza oil/canola oil)",
    "Rapeseed oil\xE2\x{20AC}\x{201C}low erucic acid adalah minyak yang dihasilkan dari minyak rendah asam erusat biji Brassica napus L., Brassica rapa L. and Brassica juncea L.",
    "Aktif",
  ],
  [
    "02010244",
    "Minyak Goreng (Frying oil)",
    "Minyak Goreng (Frying oil) adalah bahan pangan dengan komposisi utama trigliserida berasal dari bahan nabati kecuali kelapa sawit, dengan atau tanpa perubahan kimiawi, termasuk hidrogenasi, pendinginan dan telah melalui proses rafinasi/pemurnian yang digunakan untuk menggoreng.<br> <br> Karakteristik dasar :<br> - Kadar air tidak lebih dari 0,15%;<br> - Bilangan asam tidak lebih dari 0,6%;<br> - Bilangan peroksida tidak lebih dari 10 mek O2/kg;<br> - Kadar asam lemak linolenat tidak lebih dari 2%;<br> - Kadar asam lemak trans 0%.<br>",
    "Aktif",
  ],
  [
    "02010245",
    "Serbuk Lemak Nabati (Fat Powder)",
    "Serbuk lemak adalah produk lemak nabati yang berbentuk serbuk dengan atau tanpa penambahan bahan pengisi. Contoh : Serbuk Lemak Kelapa Sawit, Serbuk Lemak Kelapa Virgin, dan Serbuk Lemak Kelapa.",
    "Aktif",
  ],
  [
    "02010248",
    "Rapeseed oil (turnip rape oil/colza oil/ravison oil/sarson oil/toria oil)",
    "Rapeseed oil adalah minyak yang dihasilkan dari biji Brassica napus L., Brassica rapa L., Brassica juncea L. dan Brassica tournefortii Gouan.<br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Bilangan penyabunan 168 mg KOH/g hingga 181 mg KOH/g<br> \xE2\x{20AC}\xA2 Bilangan iod 94 Wijs hingga 120 Wijs<br> \xE2\x{20AC}\xA2 Komposisi asam lemak minyak rapeseed lihat pada tabel komposisi asam lemak<br>",
    "Aktif",
  ],
  [
    "02010249",
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil",
    "Minyak biji rami/flaxseed oil/linseed oil merupakan minyak yang diperoleh dari biji tanaman Linum usitatissimum.",
    "Aktif",
  ],
  [
    "02010301",
    "Lemak Hewani",
    "Lemak hewani adalah lemak yang diperoleh dari hewan yang sehat pada saat disembelih dan aman untuk dikonsumsi manusia.",
    "Aktif",
  ],
  [
    "02010302",
    "Lemak Babi atau Lard",
    "Lemak babi atau lard adalah lemak yang diperoleh dari pelelehan (rendered) jaringan lemak babi (Sus scorfa) yang bersih dan segar, yang diperoleh dari babi yang sehat pada saat sticking (penusukan) dan aman untuk dikonsumsi manusia.",
    "Aktif",
  ],
  [
    "02010303",
    "Rendered Pork Fat",
    "Rendered pork fat adalah lemak yang diperoleh dari pelelehan (rendered) jaringan dan tulang babi (Sus scorfa) yang bersih dan segar, yang diperoleh dari babi yang sehat pada saat sticking (penusukan) dan aman untuk dikonsumsi manusia.",
    "Aktif",
  ],
  [
    "02010304",
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock))",
    "Lemak sapi utama atau (prime beef fat (premier jus atau oleo stock)) adalah lemak yang diperoleh dari pelelehan pada suhu rendah (50\\xB0C-55\\xB0C), lemak ini disayat dari jantung, caul, ginjal, mesentary yang diperoleh dari sapi yang sehat pada saat disembelih",
    "Aktif",
  ],
  [
    "02010305",
    "Lemak Sapi (Edible Beef Fat)",
    "Lemak sapi adalah lemak yang diperoleh dari pelelehan jaringan lemak sapi, bagian perut dan sekitar ginjal dan jantung serta bagian jaringan lemak lain yang utuh dari sapi yang sehat pada saat disembelih dan aman untuk dikonsumsi manusia.",
    "Aktif",
  ],
  [
    "02010306",
    "Dripping atau Edible Tallow",
    "Dripping atau edible tallow adalah lemak yang diperoleh dari pelelehan jaringan lemak sapi, domba atau kambing atau campurannya yang sehat pada saat disembelih dan aman untuk dikonsumsi manusia.",
    "Aktif",
  ],
  [
    "02010307",
    "Secunda Beef Fat",
    "Secunda beef fat adalah lemak yang memiliki bau dan rasa khas lemak sapi yang diperoleh dari pelelehan pada suhu 60\\xB0C-65\\xB0C dan penyaringan / pemisahan.",
    "Aktif",
  ],
  [
    "02010308",
    "Suet",
    "Suet adalah lemak yang diperoleh dari pelelehan jaringan lemak bagian ginjal, atau daging daerah pinggang atau caul dari sapi, kambing atau domba atau campurannya yang sehat pada saat disembelih dan aman untuk dikonsumsi manusia.",
    "Aktif",
  ],
  [
    "02010309",
    "Minyak Ikan",
    "Minyak ikan adalah minyak yang diperoleh dari ikan segar yang sesuai seperti ikan herring, sarden/tuna, sprat dan teri.",
    "Aktif",
  ],
  [
    "02010312",
    "Serbuk Lemak Hewani (Fat Powder)",
    "Serbuk lemak hewani adalah produk lemak hewani yang berbentuk serbuk dengan atau tanpa penambahan bahan pengisi. Contoh: Serbuk Minyak Ikan.<br>",
    "Aktif",
  ],
  [
    "0202010101",
    "Mentega",
    "Mentega adalah produk emulsi lemak berbentuk padat atau semi padat yang dibuat dari susu atau krim susu atau campurannya, dengan atau tanpa penambahan bahan makanan lain seperti garam.",
    "Aktif",
  ],
  [
    "0202010102",
    "Mentega Rekombinasi",
    "Mentega rekombinasi adalah produk emulsi lemak yang dibuat dari lemak susu anhidrat (AMF), air dan padatan susu atau susu skim, dengan atau tanpa penambahan bahan makanan lain seperti garam.",
    "Aktif",
  ],
  [
    "0202010201",
    "Margarin",
    "Margarin adalah produk emulsi lemak berbentuk padat atau semi padat, yang dibuat dari minyak atau lemak nabati dan air, dengan atau tanpa penambahan bahan makanan lain seperti garam.",
    "Tidak Aktif",
  ],
  [
    "02020103",
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    "produk emulsi lemak berbentuk<br> padat/ semi padat yang dibuat dari campuran minyak/ lemak<br> nabati & lemak susu anhidrat (AMF)/ minyak mentega (butteroil)<br> & air, dengan/ tanpa penambahan bahan lain seperti garam",
    "Tidak Aktif",
  ],
  [
    "02020201",
    "Minarin (Minarine), Margarin krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound",
    "Minarin, margarin krim, fat spread (margarin oles), margarine compound,bread compound dan bakery compound adalah produk emulsi lemak berbentuk padat atau semi padat dibuat dari minyak atau lemak dan airdengan atau tanpa penambahan bahan makanan lain seper",
    "Tidak Aktif",
  ],
  [
    "02020202",
    "Lemak Oles Loyang (Pan Release)",
    "Lemak oles loyang adalah produk emulsi lemak dan atau minyak<br> yang bersifat dapat dioles atau di spray pada loyang, berbentuk<br> emulsi air dalam minyak dan atau lemak, dapat digunakan untuk<br> melepaskan roti dan kue dari loyang.",
    "Aktif",
  ],
  [
    "02020203",
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound",
    "Margarin krim, fat spread (margarin oles), margarine compound,<br> bread compound dan bakery compound adalah produk emulsi<br> lemak berbentuk padat atau semi padat dibuat dari minyak atau<br> lemak dan air dengan atau tanpa penambahan bahan makanan<br> lain seperti garam",
    "Aktif",
  ],
  [
    "02020204",
    "Minarin atau Halvarine",
    "Minarin atau Halvarine adalah produk emulsi lemak berbentuk<br> padat atau semi padat dibuat dari minyak atau lemak dan air<br> dengan atau tanpa penambahan bahan makanan lain seperti<br> garam.",
    "Aktif",
  ],
  [
    "02020205",
    "Margarin",
    "Margarin adalah produk emulsi lemak berbentuk padat atau semi padat atau cair, yang dibuat dari minyak atau lemak nabati dan air, dengan atau tanpa penambahan bahan makanan lain seperti garam. Contoh : margarin meja, margarin dapur, margarin industri. Karakteristik dasar: Kandungan lemak tidak kurang dari 80%; Kadar air tidak lebih dari 18%; Untuk margarin meja harus ditambahkan vitamin A berkisar 2500 IU/100 g hingga 3500 IU/100 g dan vitamin D berkisar 250 IU/100 g hingga 350 IU/100 g.",
    "Aktif",
  ],
  [
    "02020206",
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    "Campuran margarin dan mentega adalah produk emulsi lemak berbentuk padat atau semi padat atau cair yang dibuat dari campuran minyak atau lemak nabati dan lemak susu anhidrat (AMF) atau minyak mentega (butter oil) dan air, dengan atau tanpa penambahan bahan makanan lain seperti garam. Karakteristik dasar: Kandungan lemak tidak kurang dari 80%; Kadar air tidak lebih dari 18%; Untuk margarin meja harus ditambahkan vitamin A berkisar 2500 IU/100 g hingga 3500 IU/100 g dan vitamin D berkisar 250 IU/100 g hingga 350 IU/100 g.",
    "Aktif",
  ],
  [
    "02020207",
    "Margarin Meja",
    "Margarin meja adalah produk emulsi lemak berbentuk padat atau semi padat atau cair, yang dibuat dari minyak atau lemak nabati dan air, dengan atau tanpa penambahan bahan makanan lain seperti garam, dan peruntukannya sebagai margarin meja.",
    "Aktif",
  ],
  [
    "02020208",
    "Campuran Margarin Meja dan Mentega",
    "Campuran margarin meja dan mentega adalah produk emulsi lemak berbentuk padat atau semi padat atau cair yang dibuat dari campuran minyak atau lemak nabati dan lemak susu anhidrat (AMF) atau minyak mentega (butter oil) dan air, dengan atau tanpa penambahan bahan makanan lain seperti garam. Peruntukan margarin sebagai margarin meja.",
    "Aktif",
  ],
  [
    "02020209",
    "Minarin Meja atau Halvarine",
    "Minarin atau Halvarine adalah produk emulsi lemak berbentuk<br> padat atau semi padat dibuat dari minyak atau lemak dan air<br> dengan atau tanpa penambahan bahan makanan lain seperti<br> garam. Peruntukannya sebagai minarin meja.",
    "Aktif",
  ],
  [
    "020301",
    "Non-Dairy Toppings, Fillings, Frostings",
    "Non-dairy toppings, fillings, frostings adalah produk emulsi lemak<br> berbentuk semi padat atau cair yang terbuat dari minyak nabati<br> yang digunakan untuk topping, filling, dan frosting pada produk<br> makanan dan minuman.",
    "Aktif",
  ],
  [
    "020302",
    "Non-Dairy Whipped Cream",
    "Non-Dairy Whipped Cream adalah produk emulsi lemak yang<br> terbuat dari minyak tumbuhan berbentuk semi padat/semi cair,<br> yang siap dipakai atau dapat mengembang setelah dikocok.",
    "Aktif",
  ],
  ["020303", "Hasil Olahan Sawit - Pengganti Santan", "-", "Aktif"],
  [
    "020401",
    "Melorin atau Non-Dairy Ice Cream",
    "Melorin atau non-dairy ice cream adalah produk sejenis es krim yang dibuat dari minyak atau lemak makan nabati.",
    "Aktif",
  ],
  [
    "020402",
    "Non-Dairy Mousse",
    "Non-dairy mousse adalah produk mousse yang dibuat dari minyak atau lemak nabati.",
    "Aktif",
  ],
  [
    "0301",
    "Water Ices",
    "Water ices adalah pangan beku yang dibuat dari campuran air dan gula, dengan atau tanpa bahan pangan lain.",
    "Aktif",
  ],
  [
    "0302",
    "Es Buah (Fruit Ice)",
    "Es buah (fruit ice) adalah produk beku yang dibuat dari campuran air, sari buah/bubur buah/puree buah/potongan buah, gula, dengan atau tanpa bahan pangan lain.",
    "Aktif",
  ],
  [
    "0303",
    "Es Mambo",
    "Es mambo adalah produk beku yang dibuat dari campuran air dan gula, dengan atau tanpa bahan pangan lain, dikemas, berbentuk kecil panjang atau bentuk lain.",
    "Aktif",
  ],
  [
    "0304",
    "Es Jepit atau Es Serut atau Es Gusruk/Gosrok",
    "Es jepit atau es serut atau es gusruk /gosrok adalah es batu yang diserut, diberi gagang (stick), dijepit dan ditekan dalam batok kelapa atau cetakan yang bentuknya macam-macam lalu dibaluri sirup gula warna-warni.",
    "Tidak Aktif",
  ],
  [
    "0305",
    "Es Puter",
    "Es puter adalah produk beku yang dibuat dari pati dan/atau tepung, air, gula, santan, dengan atau tanpa bahan pangan lain yang proses pembekuannya sambil diaduk atau diputar sehingga teksturnya menyerupai es krim.",
    "Aktif",
  ],
  [
    "0306",
    "Es Lilin Goyang",
    "Es lilin goyang adalah campuran santan dengan pemanis, pewarna, perisa, dengan atau tanpa penambahan bahan pangan lainnya, dicetak dalam cetakan persegi panjang yang direndam dalam es batu dan garam dalam<br> gerobak atau yang lainnya. Campuran ingredien dibe",
    "Aktif",
  ],
  [
    "0307",
    "Es Lilin",
    "Es lilin adalah produk beku yang dibuat dari campuran air, santan, gula, dengan atau tanpa bahan pangan lain yang dicetak dan dikemas.",
    "Aktif",
  ],
  [
    "0308",
    "Es Kue",
    "Es kue adalah produk beku yang dibuat dari pati kacang hijau atau pati lain yang dimasak dengan gula, dengan atau tanpa bahan pangan lain, dicetak dan dikemas.",
    "Aktif",
  ],
  [
    "0309",
    "Sherbet",
    "Produk beku yang dibuat dari campuran air, sari buah/sayur dan/atau bubur buah/sayur (puree buah/sayur), gula, dan susu atau produk susu, dengan atau tanpa bahan pangan lain, melalui proses pembekuan sambil diaduk atau diputar sehingga memiliki<br> tekstur seperti es krim.",
    "Aktif",
  ],
  [
    "0310",
    "Sorbet",
    "Produk beku yang dibuat dari campuran air, sari buah/sayur dan/atau bubur buah/sayur (puree buah/sayur), gula, dengan atau tanpa bahan pangan lain, melalui proses pembekuan sambil diaduk atau diputar sehingga memiliki tekstur seperti es krim.",
    "Aktif",
  ],
  [
    "0311",
    "Es Stik (Ice Stick) atau Es Loli",
    "Es stik (ice stick) atau es loli adalah produk beku yang dibuat dari bahan utama air dan gula, dengan atau tanpa bahan pangan lain dan dilengkapi dengan gagang (stik).",
    "Aktif",
  ],
  ["0312", "Es Pelangi", "", "Tidak Aktif"],
  ["0313", "Es Tebak", "", "Tidak Aktif"],
  ["0314", "Es Loli", "", "Tidak Aktif"],
  [
    "0315",
    "Sediaan Cair Yang Akan Dikonsumsi Dalam Keadaan Beku",
    "Sediaan cair yang akan dikonsumsi dalam keadaan beku adalah sediaan cair dari produk es kategori 03.0 yang akan dikonsumsi dalam keadaan beku.",
    "Aktif",
  ],
  [
    "0316",
    "Es Batu Untuk Konsumsi",
    "Es batu untuk konsumsi adalah massa padat hasil pembekuan air<br> minum, tanpa bahan pangan lain, dikemas, serta aman untuk<br> dikonsumsi. Es batu dapat dalam bentuk kubus, tabung, keping, pelat, serut, atau bentuk lain",
    "Aktif",
  ],
  [
    "0317",
    "Sediaan Cair Yang Akan Dikonsumsi Dalam Keadaan Beku Steril",
    "-",
    "Aktif",
  ],
  [
    "0318",
    "Es Rasa Susu",
    "Es rasa susu adalah produk beku yang dibuat dari campuran air, gula, dan susu, dan dapat ditambahkan bahan pangan lain.<br> Karakteristik dasar :<br> - Kadar lemak susu kurang dari 0.5%<br> - Total padatan susu bukan lemak tidak kurang dari 1.1%",
    "Aktif",
  ],
  [
    "0320",
    "Es Mengandung Susu",
    "Es mengandung susu adalah produk beku yang dibuat dari campuran air, susu dan/atau produk susu, dengan atau tanpa penambahan bahan pangan lain.<br> Karakteristik dasar:<br> Kadar protein susu 0,3% sampai kurang dari 1%.",
    "Aktif",
  ],
  [
    "0321",
    "Premiks Es Bentuk Bubuk",
    "Premiks es bentuk bubuk adalah produk berbentuk bubuk yang digunakan untuk membuat produk es kategori 03.0.",
    "Aktif",
  ],
  [
    "0322",
    "Premiks Es Bentuk Cair",
    "Premiks es bentuk cair adalah produk berbentuk cair yang digunakan untuk membuat produk es kategori 03.0.",
    "Aktif",
  ],
  ["04010201", "Buah Beku", "", "Aktif"],
  [
    "0401020101",
    "Buah Beku",
    "Buah beku adalah produk buah yang diperoleh dari buah segar dan bersih dengan kematangan sesuai dengan tujuan penggunaan, dalam keadaan utuh atau potongan dengan atau tanpa penambahan gula atau sirup, yang dikemas dan dibekukan.<br> Sebelum pembekuan buah dapat diblansir. Pembekuan harus dilakukan sedemikian rupa sehingga kisaran suhu pembentukan kristal es dilalui secara cepat. Pembekuan cepat dianggap selesai apabila suhu pusat telah mencapai -18oC. Pengemasan ulang produk beku diperbolehkan dalam kondisi yang terkontrol.",
    "Tidak Aktif",
  ],
  [
    "0401020102",
    "Buah beku dalam gula kering",
    "Buah beku adalah produk buah yang diperoleh dari buah segar dan bersih dengan kematangan sesuai dengan tujuan penggunaan, dalam keadaan utuh atau potongan dengan atau tanpa penambahan gula atau sirup, yang dikemas dan dibekukan.<br> Sebelum pembekuan buah dapat diblansir. Pembekuan harus dilakukan sedemikian rupa sehingga kisaran suhu pembentukan kristal es dilalui secara cepat. Pembekuan cepat dianggap selesai apabila suhu pusat telah mencapai -18oC. Pengemasan ulang produk beku diperbolehkan dalam kondisi yang terkontrol.",
    "Tidak Aktif",
  ],
  [
    "0401020103",
    "Buah beku dalam sirup",
    "Buah beku adalah produk buah yang diperoleh dari buah segar dan bersih dengan kematangan sesuai dengan tujuan penggunaan, dalam keadaan utuh atau potongan dengan atau tanpa penambahan gula atau sirup, yang dikemas dan dibekukan.<br> Sebelum pembekuan buah dapat diblansir. Pembekuan harus dilakukan sedemikian rupa sehingga kisaran suhu pembentukan kristal es dilalui secara cepat. Pembekuan cepat dianggap selesai apabila suhu pusat telah mencapai -18oC. Pengemasan ulang produk beku diperbolehkan dalam kondisi yang terkontrol.",
    "Tidak Aktif",
  ],
  [
    "0401020104",
    "Buah Goreng Beku",
    "Untuk memfasilitasi pendaftaran pangan olahan selain PSAT",
    "Aktif",
  ],
  [
    "0401020201",
    "Buah Kering",
    "Buah kering adalah produk buah yang diperoleh dari buah yang segar dan bersih yang dikeringkan dengan pengeringan alami atau pengering buatan untuk mencegah terjadinya pertumbuhan mikroba, dengan atau tanpa penambahan gula, glukosa, gliserol, sorbitol, lemak dan minyak makan.",
    "Tidak Aktif",
  ],
  [
    "0401020202",
    "Buah Kering Campur",
    "Buah kering campur adalah produk buah yang diperoleh dari campuran dua jenis atau lebih buah kering dengan kandungan buah kering tidak kurang dari 70%.",
    "Tidak Aktif",
  ],
  [
    "0401020203",
    "Buah Kering Asin",
    "Buah kering asin adalah produk buah yang diperoleh dari proses penggaraman buah dengan atau tanpa gula, dan dikeringkan dengan pengering alami atau pengering buatan.",
    "Tidak Aktif",
  ],
  [
    "0401020204",
    "Kopra",
    "Kopra adalah daging buah tanaman kelapa Cocos nucifera Linn yang dikeringkan dengan penjemuran, pengasapan atau pengeringan mekanis lainnya.",
    "Tidak Aktif",
  ],
  [
    "0401020205",
    "Kelapa Parut Kering dengan Proses Pemanasan/ Oven",
    "Kelapa parut kering adalah produk pangan yang diperoleh dari proses pemarutan daging buah kelapa tua yang segar tanpa kulit ari.",
    "Aktif",
  ],
  ["0401020206", "-", "-", "Tidak Aktif"],
  [
    "0401020207",
    "Buah Kering dengan Penambahan Bahan Lain",
    "Memfasilitasi pendaftaran pangan olahan selain PSAT",
    "Aktif",
  ],
  [
    "0401020208",
    "Buah Kering (Freeze Dried)",
    "Memfasilitasi pendaftaran pangan olahan selain PSAT",
    "Aktif",
  ],
  [
    "0401020209",
    "Santan Bubuk",
    "Santan bubuk adalah produk berbentuk bubuk yang diperoleh dari pengeringan santan encer, santan, krim kelapa, dan/atau konsentrat krim kelapa.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%<br> \xE2\x{20AC}\xA2 Kadar lemak kelapa tidak kurang dari 5% dihitung setelah rekonstitusi",
    "Aktif",
  ],
  [
    "0401020210",
    "Tepung Buah",
    "Tepung buah adalah produk tepung yang diperoleh dari proses pengeringan dan penggilingan atau penumbukan buah. Nama produk untuk kategori ini misal tepung kelapa.",
    "Aktif",
  ],
  [
    "0401020301",
    "Buah Asin",
    "Buah asin adalah produk buah yang diperoleh dari proses penggaraman buah atau perendaman buah dalam larutan garam.",
    "Tidak Aktif",
  ],
  [
    "0401020302",
    "Asinan Buah",
    "Asinan buah adalah produk buah yang diperoleh dari satu jenis atau lebih buah segar dan/atau manisan buah, dengan atau tanpa bahan pangan yang diberi kuah yang dibuat dari gula, cuka dan bahan pangan lain.",
    "Aktif",
  ],
  [
    "0401020303",
    "Rujak",
    "Rujak adalah produk buah yang diperoleh dari satu jenis atau lebih buah segar, dengan atau tanpa bahan pangan lain, yang diberi kuah kental yang terbuat dari gula merah dan/atau bahan pangan lain.",
    "Aktif",
  ],
  [
    "0401020401",
    "Buah Dalam Kaleng",
    "Buah dalam kemasan adalah produk buah yang diperoleh dari satu atau dua jenis buah yang bersih, baik yang berbentuk utuh atau potongan, dengan atau tanpa penambahan gula dan medium yang sesuai (seperti air, campuran air dan jus buah atau jus buah), yang dikemas secara kedap (hermetis) dan diproses dengan pemanasan (pasteurisasi/ sterilisasi) untuk mencegah kebusukan",
    "Aktif",
  ],
  [
    "0401020402",
    "Kolang Kaling Dalam Kemasan",
    "Kolang kaling dalam kemasan adalah produk buah yang diperoleh dari inti buah aren (Arenga pinnata MERR atau Arenga saccharifera LABELL) yang diolah dengan penambahan larutan gula dan dikemas secara kedap (hermetis).",
    "Tidak Aktif",
  ],
  [
    "0401020403",
    "Koktil Buah Dalam Kemasan",
    "Koktil buah dalam kemasan adalah produk buah yang diperoleh dari dua jenis atau lebih buah yang bersih, baik yang berbentuk utuh atau potongan, dengan medium yang sesuai (seperti air, campuran air dan jus buah, atau jus buah), dengan atau tanpa penambahan gula, yang dikemas secara kedap (hermetis) dan diproses dengan pasteurisasi/sterilisasi.",
    "Aktif",
  ],
  [
    "0401020404",
    "Buah dalam Kemasan",
    "Buah dalam kemasan adalah produk buah yang diperoleh dari satu jenis atau lebih buah yang bersih, baik yang berbentuk utuh atau potongan, dengan medium yang sesuai (seperti air, campuran air dan jus buah, atau jus buah), dengan atau tanpa penambahan gula yang dikemas secara kedap (hermetis) dan diproses (pasteurisasi/ sterilisasi). Nama jenis untuk kategori ini mengacu pada jenis buah yang digunakan.",
    "Aktif",
  ],
  [
    "0401020501",
    "Jem Buah atau Selai Buah",
    "Jem buah atau selai buah adalah produk buah yang kental dan dapat dioles, dibuat dari pendidihan satu jenis atau lebih buah utuh, potongan buah, bubur atau puree buah dengan tambahan gula dan/atau pemanis lain, dengan atau tanpa penambahan pektin. Termasuk dalam kategori ini preserve dan conserve.",
    "Aktif",
  ],
  [
    "0401020502",
    "Jeli Buah",
    "Jeli buah adalah produk buah berbentuk jel yang dapat dioles yang diperoleh dari pendidihan satu jenis buah atau lebih sari buah atau ekstrak air dari buah, dengan tambahan gula dan/atau pemanis lain, dengan atau tanpa penambahan pektin.",
    "Aktif",
  ],
  [
    "0401020503",
    "Marmalad",
    "Marmalad adalah produk bubur buah kental dan dapat dioles yang diperoleh dari pendidihan buah utuh, bubur buah atau puree buah dengan gula untuk mengentalkan. Dapat ditambahkan pektin, irisan buah dan irisan kulit buah. Termasuk dalam kategori ini marmalad sitrus dan jeli marmalad.",
    "Aktif",
  ],
  [
    "0401020601",
    "Chutney Mangga (Mango Chutney)",
    "Chutney mangga (mango chutney) adalah produk buah yang<br> diperoleh dari buah mangga yang bersih, yang telah dikupas,<br> dipotong, dirajang, diiris atau dihancurkan dengan penambahan bahan lain dan dipanaskan sebelum atau sesudah penutupan pengemas. Bahan lain terdiri dari gula, madu, buah lain dan sayur, garam, dan kondimen (seperti cuka, bawang putih, bawang bombay, jahe, dan lain-lain).<br> <br> Karakteristik dasar:<br> \x{2022}Kandungan buah mangga tidak kurang dari 40%;<br> \x{2022}Total padatan terlarut 50%;<br> \x{2022}Produk harus memiliki flavor chutneymangga.",
    "Aktif",
  ],
  [
    "0401020602",
    "Sambal Buah",
    "Antara lain sambal nanas, sambal mangga, sambal kueni, sambal gandaria, sambal tempoyak.",
    "Tidak Aktif",
  ],
  [
    "0401020603",
    "Produk Buah Oles",
    "Produk buah oles adalah produk yang diperoleh dari pencampuran hasil olahan buah dengan bahan pangan lain, dan diolah menjadi produk yang dapat dioles, Nama jenis produk ini misal olesan berbasis kelapa.<br>",
    "Aktif",
  ],
  [
    "0401020701",
    "Buah Bergula atau Buah Bersalut Gula",
    "Buah bergula atau buah bersalut gula adalah produk buah yang diperoleh dari pemberian gula, gliserol atau sorbitol terhadap bagian buah yang dapat dimakan atau campuran buah. Ceri (Cherry) bergula dapat mengandung pewarna.",
    "Tidak Aktif",
  ],
  [
    "0401020702",
    "Buah Berkristal",
    "Buah berkristal adalah buah yang dilumuri dengan tepung gula atau gula kristal dan dikeringkan sehingga permukaannya terdapat kristal gula.",
    "Aktif",
  ],
  [
    "0401020703",
    "Kulit Buah Bergula",
    "Kulit buah bergula adalah kulit buah yang diperoleh dengan memperlakukan (antara lain dicelupkan, direndam, disemprot) kulit buah dalam larutan gula dan dikeringkan.",
    "Aktif",
  ],
  [
    "0401020704",
    "Buah Bergula",
    "Buah bergula adalah buah bersalut yang dicelupkan dalam larutan gula dan dikeringkan sehingga buah tertutupi lapisan seperti permen.<br>",
    "Aktif",
  ],
  [
    "0401020705",
    "Buah Bersalut",
    "Buah bersalut adalah buah yang diperoleh dengan memperlakukan buah (antara lain dicelupkan, direndam, disemprot) dalam larutan gula dan dikeringkan.",
    "Aktif",
  ],
  [
    "0401020801",
    "Bubur Buah (Fruit Pulp)",
    "Bubur buah (fruit pulp) adalah produk buah yang diperoleh dari buah segar yang dihancurkan tanpa mengekstrak jusnya.",
    "Aktif",
  ],
  [
    "0401020802",
    "Puree Buah",
    "Puree buah adalah produk buah yang diperoleh dari buah segar atau buah yang didinginkan atau dibekukan dengan kematangan yang cukup yang dihancurkan tanpa mengekstrak sari buahnya.",
    "Aktif",
  ],
  [
    "0401020803",
    "Pasta Buah",
    "Pasta buah adalah produk buah yang dibuat dari puree buah yang telah mengalami pemekatan.",
    "Aktif",
  ],
  [
    "0401020804",
    "Saus Buah",
    "Saus buah adalah produk buah yang diperoleh dari pendidihan bubur buah dengan atau tanpa penambahan gula dan dapat mengandung potongan buah. Saus buah dapat digunakan sebagai topping untuk produk roti dan es krim sundaes.",
    "Aktif",
  ],
  [
    "0401020805",
    "Saus Apel (Applesauce)",
    "Saus apel (applesauce) adalah produk buah yang diperoleh dari buah apel yang dirajang atau dihancurkan, dengan atau tanpa kulit yang telah dipisahkan dari bijinya, dapat ditambahkan bahan lain. Saus apel mengandung air, jus apel, garam, gula dan asam orga",
    "Tidak Aktif",
  ],
  [
    "0401020806",
    "Topping Buah",
    "Topping buah adalah produk buah yang diperoleh dari pendidihan bubur buah, lebih encer dari pada saus buah dan dapat digunakan sebagai topping panekuk.",
    "Aktif",
  ],
  [
    "0401020807",
    "Santan/Santan Encer/Krim Kelapa/Konsentrat Krim Kelapa",
    "Santan adalah produk emulsi yang diperoleh dari ekstraksi daging buah kelapa (Cocos nucifera) yang cukup tua dan segar; atau rekonstitusi krim kelapa bubuk dengan air; atau dispersi endosperm kelapa kering halus dengan air; atau kombinasi ekstraksi daging buah kelapa yang cukup tua dan segar dengan dispersi endosperm kelapa kering halus dengan air. Bahan baku santan dapat terdiri dari krim kelapa bubuk, endosperm kelapa (Cocos nucifera), dan air.<br> <br> Karakteristik dasar:<br> \x{2022}Santan encer : kadar lemak kelapa tidak kurang dari 5%; total padatan 6,6-12,6%<br> \x{2022}Santan : kadar lemak kelapa tidak kurang dari 10%;total padatan 12,7-25,3%<br> \x{2022}Krim kelapa : kadar lemak kelapa tidak kurang dari 20%; total padatan 25,4-37,3%<br> \x{2022}Konsentrat krim kelapa : kadar lemak kelapa tidak kurang dari 29%, total padatan tidak kurang dari 37,4%",
    "Aktif",
  ],
  [
    "0401020808",
    "Santan Ekstraksi Air",
    "Santan ekstraksi air adalah adalah produk emulsi buah dengan proses ekstraksi air dari daging buah kelapa (Cocos nucifera) yang cukup tua dan sehat.",
    "Tidak Aktif",
  ],
  [
    "0401020809",
    "Krim Kelapa",
    "Krim kelapa adalah produk yang diperoleh dari santan atau santan ekstraksi air yang diambil krimnya dengan pemisahan airnya.",
    "Tidak Aktif",
  ],
  [
    "0401020810",
    "Pasta Kelapa",
    "Pasta kelapa adalah produk buah kelapa yang diperoleh dari ekstraksi air parutan kelapa atau kelapa kering dengan cara evaporasi sampai membentuk pasta.",
    "Tidak Aktif",
  ],
  [
    "0401020811",
    "Nata",
    "Nata merupakan selulosa mikrobia yang dihasilkan oleh bakteri<br> asam cuka (Acetobacter xilynum) dari hasil fermentasi air kelapa,<br> santan kelapa dan/atau bahan lainnya.",
    "Aktif",
  ],
  [
    "0401020812",
    "Konsentrat Asam Jawa/Tamarin",
    "Konsentrat asam jawa/tamarin adalah produk tamarin yang diperoleh dari ekstrak bersih buah tamarin dengan total padatan terlarut tidak kurang dari 65%.",
    "Aktif",
  ],
  [
    "0401020813",
    "Bubuk Asam Jawa/Tamarin",
    "Bubuk asam jawa/tamarin adalah produk tamarin yang diperoleh dari pasta tamarin yang dicampur dengan pati.",
    "Aktif",
  ],
  [
    "0401020814",
    "Toffee Asam Jawa/Tamarin",
    "Toffee asam jawa/tamarin adalah produk tamarin yang diperoleh dari hancuran buah tamarin yang dicampur dengan gula, padatan susu, dan lain-lain.",
    "Tidak Aktif",
  ],
  [
    "0401020815",
    "Bars Buah",
    "Bars buah adalah produk buah yang diperoleh dari hancuran buahbuahan (mangga, nanas atau jambu) yang dicampur dengan gula, lalu dikeringkan sampai berbentuk lembaran.",
    "Aktif",
  ],
  [
    "0401020816",
    "Tepung Buah",
    "Tepung buah adalah produk halus dan bersih yang diperoleh dari penggilingan atau penumbukan buah.",
    "Tidak Aktif",
  ],
  [
    "0401020817",
    "Saus Buah dalam Kaleng",
    "Saus buah adalah produk buah yang diperoleh dari pendidihan<br> bubur buah dengan atau tanpa penambahan gula dan dapat<br> mengandung potongan buah. Saus buah dapat digunakan sebagai<br> topping untuk produk roti dan es krim sundaes. Produk dikemas dalam kaleng.",
    "Aktif",
  ],
  ["0401020818", "Tepung Kelapa", "-", "Aktif"],
  [
    "0401020901",
    "Manisan Buah",
    "Manisan buah adalah produk buah yang diperoleh dari potongan<br> buah atau buah utuh segar yang sehat dengan penambahan gula.<br> Selain itu dapat ditambahkan bahan pangan lain. Manisan buah<br> dapat dikeringkan ataupun tidak.",
    "Aktif",
  ],
  [
    "0401020902",
    "Nata Dalam Kemasan",
    "Nata dalam kemasan adalah produk nata bertekstur kenyal yang dikemas dalam medium air dengan atau tanpa penambahan gula dengan atau tanpa penambahan bahan pangan lain, kemudian dilakukan proses pasteurisasi atau sterilisasi. Termasuk dalam kategori ini nata de coco dalam sirup.<br> <br> Karakteristik dasar:Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "0401020903",
    "Jeli Agar",
    "Jeli agar adalah produk gel buah yang diperoleh dari ekstrak atau<br> sari rumput laut dengan atau tanpa penambahan bahan pangan<br> lain.",
    "Aktif",
  ],
  [
    "0401020904",
    "Sale Pisang",
    "Sale pisang adalah produk buah semi basah yang diperoleh dari buah pisang segar dengan cara pengeringan dan atau pengasapan dan dikemas secara kedap (hermetis).",
    "Aktif",
  ],
  [
    "0401020905",
    "Cincau Hijau",
    "Cincau hijau adalah produk gel buah tradisional yang diperoleh dari<br> ekstrak atau sari daun tanaman jenis Premna oblongifolia, Cyclea<br> barbata, Melastoma polyanthum dan Stephania hermandifolia. Gel<br> cincau hijau terbentuk dalam kondisi dingin dan tidak<br> membutuhkan komponen pati. Cincau hijau dikonsumsi sebagai<br> makanan atau minuman pencuci mulut.",
    "Aktif",
  ],
  [
    "0401020906",
    "Cincau Hitam",
    "Cincau hitam adalah produk gel buah tradisional yang diperoleh<br> dari ekstrak tanaman janggelan (Mesona palustris, Mesona sinensis).<br> Gel cincau hitam terbentuk melalui proses panas dan<br> membutuhkan komponen pati. Cincau hitam dikonsumsi sebagai<br> makanan atau minuman pencuci mulut.",
    "Aktif",
  ],
  [
    "0401020907",
    "Siwalan",
    "Siwalan adalah daging buah tanaman palma Borassus flabellifer. Buah dapat diolah menjadi daging buah siwalan dalam kaleng dengan medium sirup atau air yang mengandung gula dan mengikuti kaidah proses pengalengan.",
    "Aktif",
  ],
  [
    "0401020908",
    "Mitsumame",
    "Mitsumame adalah produk makanan pencuci mulut yang berbentuk jeli agar serupa gelatin dengan potongan buah dan sirup.",
    "Aktif",
  ],
  [
    "0401020909",
    "Tepung Agar-Agar/Jeli Agar Bubuk/Tepung Gelatin",
    "",
    "Tidak Aktif",
  ],
  [
    "0401020910",
    "Puding Rasa/Berperisa",
    "Puding rasa/berperisa adalah produk gel siap konsumsi yang dibuat dari bahan pembentuk gel selain tepung atau pati, dan dapat ditambahkan bahan pangan lain.<br>",
    "Aktif",
  ],
  [
    "0401020911",
    "Makanan Pencuci Mulut (Dessert) Berbasis Buah Termasuk Makanan Pencuci Mulut Berbasis Air Berflavor Buah",
    "Makanan Pencuci Mulut (Dessert) Berbasis Buah Termasuk Makanan Pencuci Mulut Berbasis Air Berflavor Buah<br> Termasuk : Makanan Pencuci Mulut Berbahan Baku Kelapa",
    "Aktif",
  ],
  [
    "0401020913",
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar)",
    "Bubuk agar (agar-agar tepung/tepung agar-agar) adalah polisakarida berupa tepung yang diperoleh dari ekstraksi rumput laut alga merah Agarophyte, bersifat koloid bila dilarutkan dalam air mendidih dan menjedal bila didinginkan (reversible).",
    "Aktif",
  ],
  [
    "0401020914",
    "Agar-Agar Kertas",
    "Agar-agar kertas adalah produk olahan hasil perikanan dengan bahan baku rumput laut kering Gracilaria spp. atau Gelidium spp. yang mengalami perebusan, penyaringan, penjendalan, pemotongan, pengepresan, dan pengeringan.",
    "Aktif",
  ],
  [
    "0401020915",
    "Tepung Gelatin (Bubuk Gelatin)",
    "Tepung gelatin adalah tepung pembentuk gel yang dibuat dari gelatin.",
    "Aktif",
  ],
  [
    "0401020916",
    "Tepung Karagenan (Bubuk Karagenan)",
    "Tepung karagenan (bubuk karagenan) adalah produk bubuk pembentuk gel yang dibuat dari karagenan.",
    "Aktif",
  ],
  [
    "0401020917",
    "Jeli Agar Bubuk",
    "Jeli agar bubuk adalah produk bubuk pembentuk gel yang dibuat dari rumput laut dengan campuran bahan pembentuk gel lainnya.",
    "Aktif",
  ],
  [
    "0401020918",
    "Bubuk Puding Rasa/Berperisa",
    "Bubuk puding rasa/berperisa adalah produk bubuk yang dibuat<br> dari bahan pembentuk gel selain tepung atau pati, dapat<br> ditambahkan bahan pangan lain, dan digunakan untuk membuat puding rasa atau berperisa.",
    "Aktif",
  ],
  [
    "0401021001",
    "Pikel Pir (Pear Pickles)",
    "Pikel pir (pear pickles) adalah produk buah yang diperoleh dari buah pir /pear yang dikupas, dibuang bagian hatinya, diiris dan dipotong-potong, diberi larutan vinegar dengan atau tanpa bahan lain hingga larutan menyerupai sirup dan dikemas secara kedap (",
    "Tidak Aktif",
  ],
  [
    "0401021002",
    "Pikel Persik (Plum Pickles)",
    "Pikel persik (plum pickels) adalah produk buah diperoleh dari buah persik /plum yang dikupas, dibuang bagian hatinya, diiris dan dipotong-potong, diberi larutan vinegar dengan atau tanpa bahan lain hingga larutan menyerupai sirup, dan dikemas secara kedap",
    "Tidak Aktif",
  ],
  [
    "0401021003",
    "Tempoyak / Pakasam",
    "Tempoyak / pakasam adalah produk buah yang diperoleh dari daging buah durian yang melalui proses fermentasi asam laktat secara alami.",
    "Aktif",
  ],
  [
    "0401021004",
    "Fermentasi Buah (termasuk sari buah fermentasi)",
    "-",
    "Aktif",
  ],
  [
    "0401021005",
    "Pikel Buah",
    "Pikel buah adalah produk buah yang diperoleh dari buah yang dikupas, dan dibersihkan, dalam bentuk utuh, diiris, atau potongan, diberi larutan dan difermentasi dengan bakteri asam laktat.",
    "Aktif",
  ],
  ["04010211", "Produk Buah Untuk Isi Pastri", "", "Aktif"],
  [
    "0401021201",
    "Keripik Apel",
    "Keripik apel adalah produk buah yang diperoleh dari daging buah apel masak yang diiris dan digoreng secara vakum atau freeze drying, atau proses lain, dengan atau tanpa penambahan bahan lain.",
    "Tidak Aktif",
  ],
  [
    "0401021202",
    "Keripik Nangka",
    "Keripik nangka adalah produk buah yang diperoleh dari buah nangka yang diiris dan digoreng secara vakum atau freeze drying, atau proses lain, dengan atau tanpa penambahan bahan lain.",
    "Tidak Aktif",
  ],
  [
    "0401021203",
    "Keripik Nenas",
    "Keripik nenas adalah produk buah yang diperoleh dari daging buah nenas masak yang diiris dan digoreng secara vakum atau freeze drying, atau proses lain, dengan atau tanpa penambahan bahan lain.<br> Karakteristik dasar: Bertekstur renyah<br>",
    "Tidak Aktif",
  ],
  [
    "0401021204",
    "Keripik Pisang",
    "Keripik pisang adalah produk buah yang diperoleh dari daging buah pisang yang diiris dan digoreng atau proses lain, dengan atau tanpa penambahan bahan lain.<br> Karakteristik dasar:<br> - Memiliki rasa khas<br> - Bertekstur renyah",
    "Tidak Aktif",
  ],
  [
    "0401021205",
    "Keripik Salak",
    "Keripik salak adalah produk buah yang diperoleh dari daging buah salak masak yang diiris dan digoreng secara vakum atau freeze drying, atau proses lain, dengan atau tanpa penambahan bahan lain.<br> Karakteristik dasar:<br> - Memiliki rasa khas<br> - Bertekstur renyah",
    "Tidak Aktif",
  ],
  [
    "0401021206",
    "Keripik Sukun",
    "Keripik sukun adalah produk buah yang diperoleh dari buah sukun yang diiris dan digoreng atau proses lain, dengan atau tanpa penambahan garam atau bahan lain.<br> Karakteristik dasar:<br> - Tekstur renyah<br> - Keutuhan tidak kurang dari 90%<br> <br>",
    "Tidak Aktif",
  ],
  [
    "0401021207",
    "Keripik Buah Simulasi",
    "Keripik buah simulasi adalah produk buah yang diperoleh dari buah yang dibuat tepung dan digoreng, dengan atau tanpa penambahan bahan lain.",
    "Aktif",
  ],
  [
    "0401021208",
    "Dodol atau Lempok Buah",
    "Dodol atau lempok buah adalah produk buah yang diperoleh dari daging buah matang yang dihancurkan dan dimasak dengan atau tanpa penambahan gula.",
    "Aktif",
  ],
  [
    "0401021209",
    "Wajit Buah",
    "Wajit buah adalah produk buah yang diperoleh dari campuran buah, tepung ketan, kelapa parut dan gula.",
    "Aktif",
  ],
  [
    "0401021210",
    "Geplak",
    "Geplak adalah produk buah yang diperoleh dari campuran kelapa parut dan gula yang dikeringkan.",
    "Aktif",
  ],
  [
    "0401021211",
    "Keripik Buah",
    "Keripik buah adalah produk buah yang diperoleh dari buah yang digoreng secara vakum atau freeze drying atau proses lain, dengan atau tanpa penambahan bahan lain.",
    "Aktif",
  ],
  [
    "0402020101",
    "Sayur Beku",
    "Sayur beku adalah produk sayur yang diperoleh dari sayur segar,<br> sehat dan bersih, disimpan dalam keadaan beku dengan suhu<br> dibawah -18\xEF\x{201A}\xB0C dan tidak dicairkan (thawing) sebelum dijual.<br> Sebelum pembekuan, dilakukan blansir secukupnya untuk<br> mempertahankan warna dan flavor, dan ditiriskan. Produk dapat<br> mengandung kondimen2, daun atau minyak mint, garam dan bahan<br> lain.<br> Pengemasan ulang produk beku diperbolehkan pada kondisi yang<br> terkontrol.",
    "Tidak Aktif",
  ],
  [
    "0402020102",
    "Buncis Beku",
    "Buncis beku adalah produk sayur beku yang diperoleh dari polong buncis (Phaseolus vulgaris L.) yang segar, bersih, sehat, tanpa tangkai, dicuci dan diblansir untuk mempertahankan warna dan flavor selama penyimpanan.",
    "Tidak Aktif",
  ],
  [
    "0402020103",
    "Kacang Kapri Beku",
    "Kacang kapri beku adalah produk sayur beku yang diperoleh dari kacang kapri (Pisum sativum L.) yang segar, bersih dan sehat, dicuci dan diblansir untuk mempertahankan warna dan flavor selama penyimpanan.",
    "Tidak Aktif",
  ],
  [
    "0402020104",
    "Brokoli Beku",
    "Brokoli beku adalah produk sayur beku yang diperoleh dari brokoli (Brassica oleracea L. var. italica Plenck) yang segar, bersih, sehat, dibersihkan, dicuci dan diblansir sebelum pembekuan untuk mempertahankan warna dan flavor selama penyimpanan.",
    "Tidak Aktif",
  ],
  [
    "0402020105",
    "Brussel Sprout Beku",
    "Brussel sprout beku adalah produk sayur beku yang diperoleh dari brussel sprout (Brassica oleracea L. var gemmifera (DC) Schultz) yang segar, bersih, sehat, dibersihkan, dicuci dan diblansir sebelum pembekuan untuk mempertahankan warna dan flavor selama penyimpanan",
    "Tidak Aktif",
  ],
  [
    "0402020106",
    "Bayam Beku",
    "Bayam beku adalah produk sayur beku yang diperoleh dari daun bayam yang segar, bersih, sehat, dibersihkan, dicuci dan diblansir sebelum pembekuan untuk mempertahankan warna dan flavor selama penyimpanan.",
    "Tidak Aktif",
  ],
  [
    "0402020107",
    "Wortel Beku",
    "Wortel beku adalah produk sayur beku yang diperoleh dari umbi wortel (Daucus carrota L.) yang segar, bersih dan sehat, tanpa daun, tanpa bagian atas yang berwarna hijau, tanpa akar-akar sekunder, serta dikupas dan dicuci, dengan terlebih dahulu diblansir ataupun tidak sebelum pembekuan",
    "Tidak Aktif",
  ],
  [
    "0402020108",
    "Jamur Beku",
    "Jamur beku adalah produk sayur beku yang diperoleh dari satu jenis jamur yang dapat dimakan, setelah terlebih dahulu dibersihkan, dicuci dan diblansir sebelum pembekuan untuk mempertahankan warna dan flavor selama penyimpanan.",
    "Tidak Aktif",
  ],
  [
    "0402020109",
    "Biji Jagung Beku",
    "Biji jagung beku adalah produk sayur beku yang diperoleh dari biji jagung manis (Zea mays L. convar saccharata Koern) varietas kuning atau putih yang segar, bersih dan sehat, yang telah mengalami pemipilan biji dari tongkol, dicuci dan diblansir sebelum pembekuan untuk mempertahankan warna dan flavor selama penyimpanan",
    "Tidak Aktif",
  ],
  [
    "0402020110",
    "Jagung Bertongkol Beku",
    "Jagung bertongkol beku adalah produk sayur beku yang diperoleh dari jagung utuh (Zea mays L. convar saccharata Koern) yang dikupas dan dihilangkan rambutnya, dicuci dan diblansir sebelum pembekuan untuk mempertahankan warna dan flavor selama penyimpanan.",
    "Tidak Aktif",
  ],
  [
    "0402020111",
    "Kentang Goreng Beku (Frozen French Fries)",
    "Kentang goreng beku atau frozen french fries adalah produk sayur beku yang diperoleh dari kentang (Solanum tuberosum L.) yang bersih, tua dan sehat. Kentang telah mengalami pemilihan, pencucian, pengupasan dan pengirisan menjadi berbentuk batang dan diberi perlakuan untuk mempertahankan warna dan digoreng dalam minyak atau lemak makan. Proses pengolahan awal dan penggorengan harus mempertahankan warna dan flavor. Dapat ditambahkan gula, garam, dan rempah-rempah.",
    "Aktif",
  ],
  [
    "0402020112",
    "Terong Beku",
    "Terong beku adalah produk sayur beku yang diperoleh dari jenis terong (Solanum melongena) yang dapat dibekukan. Sebelum dibekukan, terong dibersihkan, dipotong, diblansir atau dikukus, didinginkan kemudian dibekukan cepat.",
    "Tidak Aktif",
  ],
  [
    "0402020113",
    "Ubi Beku",
    "Ubi beku adalah produk sayur beku yang diperoleh dari umbi tanaman Ipomea batatas yang dibekukan. Sebelum dibekukan, umbi dibersihkan, dipanggang atau direbus atau dikukus, didinginkan (kalau sebelumnya direbus, maka perlu ditiriskan sesegera mungkin), kulit dikupas, umbi dikemas dengan kemasan untuk produk beku kemudian dibekukan secara cepat.",
    "Tidak Aktif",
  ],
  [
    "0402020114",
    "Sayur Beku (Termasuk Jamur, Akar dan Umbi, Polong-polongan dan Aloe Vera) Rumput Laut, Kacang Serta Biji-Bijian Beku yang Diproses dengan Pemasakan dan atau Penambahan Bahan Pangan Lain",
    "Memfasilitasi pendaftaran pangan olahan selain PSAT",
    "Aktif",
  ],
  [
    "0402020115",
    "Sayur Goreng Beku",
    "Memfasilitasi pendaftaran pangan olahan selain PSAT",
    "Aktif",
  ],
  [
    "0402020116",
    "Perkedel Kentang Beku",
    "Perkedel kentang beku adalah produk kentang beku yang diperoleh dari kentang (Solanum tuberosum L.), yang telah mengalami pengolahan (pengukusan/perebusan/penggorengan) dan penghancuran dengan atau tanpa penambahan bahan pangan lain dan dibekukan secara cepat.",
    "Aktif",
  ],
  [
    "0402020201",
    "Sayur Kering",
    "Sayur kering adalah produk sayur yang diperoleh dari proses pengeringan sayur, dengan atau tanpa penambahan gula, daun atau minyak mint dan pemanis, pengawet dan pewarna. Pengeringan dilakukan secara alami atau buatan. Produk dapat direhidrasi atau tidak sebelum dikonsumsi.",
    "Tidak Aktif",
  ],
  [
    "0402020202",
    "Cabe Kering",
    "Cabe kering adalah produk sayur yang diperoleh dari proses pengeringan cabe (Capsicum sp) secara alami atau pengeringan buatan.",
    "Tidak Aktif",
  ],
  [
    "0402020203",
    "Jamur Kering",
    "Jamur kering adalah produk sayur yang diperoleh melalui proses pengeringan termasuk pengeringan beku dari jamur yang dapat dimakan, baik dalam bentuk utuh maupun irisan.",
    "Tidak Aktif",
  ],
  [
    "0402020204",
    "Rumput Laut Kering",
    "Rumput laut kering adalah produk rumput laut jenis Euchema, Gellidium, Gracillaria dan Hypenea yang telah dibersihkan dan dikeringkan.",
    "Tidak Aktif",
  ],
  [
    "0402020205",
    "Nori",
    "Nori adalah produk hasil perikanan yang dibuat dari rumput laut jenis Pyropia yang mengalami perlakukan pengeringan, dan setelah dikeringkan produk akan dipanggang dan/atau diberi penambahan bumbu. Bentuk produk akhir meliputi: serpihan, lembaran, lembar gulungan, gumpalan bulat. Jenis produk antara lain: nori kering, nori panggang, nori bumbu.",
    "Aktif",
  ],
  [
    "0402020206",
    "Sayur Asin Kering",
    "Sayur asin kering adalah produk sayur yang diperoleh dari bagian sayur yang diberi garam dan dikeringkan dengan pengeringan alami atau buatan.",
    "Tidak Aktif",
  ],
  [
    "0402020207",
    "Kacang Kering dan Polong Kacang Kering",
    "Kacang kering dan polong kacang kering adalah produk kering yang<br> diperoleh dari biji tanaman leguminosa yang dibedakan dari biji<br> leguminosa sumber minyak berdasarkan kadar minyaknya yang<br> rendah. Polong kacang adalah bagian dari kacang yang telah dilepas<br> kulitnya.<br> Jenis yang termasuk dalam kelompok ini: Beans dari Phaseolus spp<br> (termasuk Phaseolus mungo L.syn. Vigna mungo (L.) Hepper dan<br> Phaseolus aureus Roxb.syn.Phaseolus radiatur L.Vigna radiata (L.)<br> Wilczek; Lentils dari Lens culinaris Medic.Syn.Lens esculenta<br> Moench; Peas dari Pisum sativum L.; Chick peas dari Cicer<br> arientinum L.; Kacang tanah dari Arachis hypogaea L. Kacang koro<br> dari Vicia faba L.; Cow peas dari Vigna unguiculata (L.) Walp., syn.<br> Vigna sesquipedalis Fruhw., Vigna sinensis (L.) Savi exd Hassk.",
    "Tidak Aktif",
  ],
  [
    "0402020208",
    "Biji Bunga Matahari",
    "Biji bunga matahari adalah produk kering yang diperoleh dari biji bunga matahari yang dapat dimakan, dapat digunakan untuk pangan dan pakan sebagai sumber minyak.",
    "Tidak Aktif",
  ],
  [
    "0402020209",
    "Biji Saga",
    "Biji saga adalah produk kering yang diperoleh dari biji tanaman saga yang dikeringkan dan dibersihkan.",
    "Tidak Aktif",
  ],
  [
    "0402020210",
    "Biji Wijen",
    "Biji wijen adalah produk kering yang diperoleh dari biji tanaman wijen (Sesamun indicum L) yang dikeringkan dan dibersihkan.",
    "Tidak Aktif",
  ],
  [
    "0402020211",
    "Kuaci",
    "Kuaci adalah produk kering yang diperoleh dari biji semangka, biji labu parang, biji bunga matahari yang telah dikeringkan dan ditambah garam.",
    "Aktif",
  ],
  [
    "0402020212",
    "Emping Melinjo",
    "Emping melinjo adalah produk kering yang diperoleh dari pemipihan daging melinjo tua (Gnetum gnemon).",
    "Aktif",
  ],
  [
    "0402020213",
    "Emping Jengkol",
    "Emping jengkol adalah produk kering yang diperoleh dari daging buah jengkol segar yang diolah melalui proses perebusan dan pemipihan kemudian dikeringkan, dengan atau tanpa bumbu-bumbu.",
    "Tidak Aktif",
  ],
  [
    "0402020214",
    "Mete Gelondong",
    "Mete gelondong adalah produk kering yang diperoleh dari buah tanaman jambu mede (Anacardium occidaentale Linn.) yang telah dikeringkan.",
    "Tidak Aktif",
  ],
  [
    "0402020215",
    "Kentang Kering Serpih (Flakes)",
    "Kentang kering serpih (flakes) adalah produk kering yang diperoleh dari mashed potato (puree kentang) yang dikeringkan dan dibentuk serpihan.",
    "Tidak Aktif",
  ],
  [
    "0402020216",
    "Tepung Tomat/Bubur Tomat Kering/ Pasta Tomat Kering",
    "Tepung tomat adalah produk tepung yang diperoleh dari buah tomat yang dihancurkan / dihaluskan dengan atau tanpa serangkaian proses ekstraksi untuk memperoleh sari tomat, pemekatan, penghilangan busa (defoaming), pengeringan dan pengemasan. Selama proses dapat ditambahkan bahan lain yang sesuai",
    "Tidak Aktif",
  ],
  [
    "0402020217",
    "Tepung Bit",
    "Tepung bit adalah produk tepung bit berwarna merah gelap yang<br> diperoleh dari proses pengeringan umbi bit yang sehat, masak dan<br> bermutu baik.",
    "Aktif",
  ],
  [
    "0402020218",
    "Kelp / Kombu",
    "Kelp / kombu adalah sea tangle kering.",
    "Tidak Aktif",
  ],
  [
    "0402020219",
    "Shio-Kombu",
    "Shio-kombu adalah sea tangle kering dengan bumbu.",
    "Tidak Aktif",
  ],
  [
    "0402020220",
    "Tororo-Kombu",
    "Tororo-kombu adalah rumput laut kering.",
    "Tidak Aktif",
  ],
  [
    "0402020221",
    "Kampyo",
    "Kampyo adalah labu (manis) kupas kering.",
    "Tidak Aktif",
  ],
  [
    "0402020222",
    "Wakame",
    "Wakame adalah laminariales kering.",
    "Tidak Aktif",
  ],
  [
    "0402020223",
    "Acar Sayur",
    "Status tidak aktif, diperbaiki ke kategori pangan : Acar Sayur (0402020320).",
    "Tidak Aktif",
  ],
  ["0402020224", "Biji Selasih", "-", "Tidak Aktif"],
  [
    "0402020225",
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia)",
    "-",
    "Tidak Aktif",
  ],
  [
    "0402020226",
    "Bubur Kacang ..... Bubuk / Instan",
    "-",
    "Tidak Aktif",
  ],
  ["0402020227", "Tepung Melinjo", "-", "Tidak Aktif"],
  [
    "0402020228",
    "Sayur (Termasuk Jamur, Akar dan Umbi, Polong-polongan, dan Aloe Vera), Rumput Laut, Kacang Serta Biji-Bijian Kering dengan penambahan bahan lain",
    "-",
    "Aktif",
  ],
  [
    "0402020229",
    "Tepung Daun Kelor",
    "Tepung daun kelor adalah produk tepung daun kelor yang diperoleh<br> dari proses pengeringan daun kelor yang sehat, masak dan bermutu<br> baik",
    "Aktif",
  ],
  [
    "0402020230",
    "Sayur Kering (Freeze Dried/Microwave Dried/Roasting)",
    "Memfasilitasi pendaftaran pangan olahan selain PSAT",
    "Aktif",
  ],
  [
    "0402020232",
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (Roasting, Sangrai, Panggang, dll) (Khusus Registrasi Ulang)",
    "Memfasilitasi Registrasi Ulang",
    "Aktif",
  ],
  [
    "0402020301",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    "Jamur dalam minyak zaitun atau jamur dalam minyak nabati lain adalah produk jamur yang diperoleh dari jamur segar, ataupun dari jamur yang telah diasinkan, baik bentuk utuh maupun irisan, dimasukkan dalam minyak zaitun atau minyak nabati lain, dikemas secara kedap (hermetis), disterilisasi dengan pemanasan untuk mencegah kerusakan.<br> Karakteristik dasar: Kadar garam tidak lebih dari 1% (jika produk jamur diasinkan).<br>",
    "Aktif",
  ],
  [
    "0402020302",
    "Sayur Asin",
    "Sayur asin adalah produk sayur yang diperoleh dari sayur yang diberi garam.",
    "Aktif",
  ],
  [
    "0402020303",
    "Jamur Asin",
    "Jamur asin adalah produk jamur yang diperoleh dari satu jenis jamur segar, berbentuk utuh atau irisan, yang dibersihkan, dicuci, diblansir dan diawetkan dalam air garam.",
    "Aktif",
  ],
  [
    "0402020304",
    "Acar Jamur",
    "Acar jamur adalah produk acar yang diperoleh dari jamur dari satu spesies atau lebih yang dibersihkan, dicuci, diblansir, dan diawetkan dalam larutan cuka dengan atau tanpa penambahan garam, rempah-rempah, gula, minyak makan, asam asetat, asam laktat, asam sitrat atau asam askorbat, dikemas secara kedap (hermetis) dan dipasteurisasi.",
    "Tidak Aktif",
  ],
  [
    "0402020305",
    "Acar Timun Mentah",
    "Acar timun mentah adalah produk acar yang diperoleh dari mentimun yang dibersihkan, diawetkan dalam larutan cuka dengan atau tanpa penambahan garam, dikemas secara kedap (hermetis) dan dipasteurisasi.",
    "Tidak Aktif",
  ],
  [
    "0402020306",
    "Acar Bawang Putih",
    "Acar bawang putih adalah produk acar yang diperoleh dari bawang putih yang dibersihkan, dikupas kulitnya, diawetkan dalam larutan cuka dengan atau tanpa penambahan garam, dikemas secara kedap (hermetis) dan dipasteurisasi.",
    "Tidak Aktif",
  ],
  [
    "0402020307",
    "Acar Jahe",
    "Acar jahe adalah produk acar yang diperoleh dari jahe matang dan sehat yang dibersihkan, dikupas, diiris dan diawetkan dalam larutan cuka dengan atau tanpa penambahan garam, dikemas secara kedap (hermetis) dan dipasteurisasi.",
    "Tidak Aktif",
  ],
  [
    "0402020308",
    "Acar Cabe",
    "Acar cabe adalah produk acar yang diperoleh dari cabe yang bersih dan sehat diawetkan dalam larutan cuka dengan atau tanpa penambahan garam, dikemas secara kedap (hermetis) dan dipasteurisasi.",
    "Tidak Aktif",
  ],
  [
    "0402020309",
    "Acar Lobak",
    "Acar lobak adalah produk acar yang diperoleh dari umbi lobak sehat yang dibersihkan, dikupas, diiris dan diawetkan dalam larutan cuka dengan atau tanpa penambahan garam, dikemas secara kedap (hermetis) dan dipasteurisasi.",
    "Tidak Aktif",
  ],
  [
    "0402020310",
    "Jantung Artichoke yang Diasinkan",
    "",
    "Tidak Aktif",
  ],
  ["0402020311", "Picalili", "", "Tidak Aktif"],
  [
    "0402020312",
    "Tsukemono",
    "Tsukemono adalah sayur pikel dengan kulit nasi (nuka-zuke).",
    "Tidak Aktif",
  ],
  [
    "0402020313",
    "Vegetable Koji-zuke",
    "Vegetable koji-zuke adalah sayur pikel-koji.",
    "Tidak Aktif",
  ],
  [
    "0402020314",
    "Vegetable Kasu-zuke",
    "Vegetable kasu-zuke adalah sayur pikel-sedikit sake.",
    "Tidak Aktif",
  ],
  [
    "0402020315",
    "Vegetable Miso-zuke",
    "Vegetable miso-zuke adalah sayur pikel-miso.",
    "Tidak Aktif",
  ],
  [
    "0402020316",
    "Vegetable Shoyu-zuke",
    "Vegetable shoyu-zuke adalah sayur pikel-saus kedelai.",
    "Tidak Aktif",
  ],
  [
    "0402020317",
    "Vegetable Su-zuke",
    "Vegetable su-zuke adalah sayur pikel-vinegar.",
    "Tidak Aktif",
  ],
  [
    "0402020318",
    "Vegetable Shio-zuke",
    "Vegetable shio-zuke adalah sayur pikel-garam.",
    "Tidak Aktif",
  ],
  [
    "0402020319",
    "Acar (Sweet Pickle)...Steril",
    "-",
    "Tidak Aktif",
  ],
  ["0402020320", "Acar Sayur", "-", "Tidak Aktif"],
  [
    "0402020322",
    "Acar (Sweet Pickle)",
    "Acar adalah produk acar yang diperoleh dari sayur yang<br> dibersihkan, dicuci, diblansir, dan diawetkan dalam larutan cuka<br> dengan atau tanpa penambahan garam, rempah-rempah, gula,<br> minyak makan, asam asetat, asam laktat, asam sitrat atau asam<br> askorbat, dapat dipanaskan atau dipasteurisasi. Contohnya adalah acar jamur, acar timun, acar bawang putih, acar jahe, acar cabe,<br> dan acar lobak.",
    "Aktif",
  ],
  [
    "0402020323",
    "Asinan Jahe",
    "Asinan jahe adalah produk jahe (Zingiber officinale atau Zingiber officinale var Rubrum) yang diperoleh dari proses pengawetan jahe dengan penambahan garam dan larutan cuka atau larutan asam sitrat, atau asam lain yang sesuai. Dapat ditambahkan gula atau bahan pangan lain.",
    "Aktif",
  ],
  [
    "04020204",
    "Sayur Dalam Kemasan, Botol atau Dalam Retort Pouch",
    "Sayur dalam kemasan, botol atau dalam retort pouch adalah produk awetan dari sayur yang dibersihkan, diblansir dan ditempatkan dalam kemasan dengan penambahan air dan dipasteurisasi atau disterilisasi dengan pemanasan.",
    "Aktif",
  ],
  [
    "0402020401",
    "Sayur Dalam Kemasan",
    "Sayur dalam kemasan adalah produk sayur yang diperoleh dari sayur yang telah disterilisasi atau dipasteurisasi dan dikemas secara kedap (hermetis).",
    "Aktif",
  ],
  [
    "0402020402",
    "Tomat Dalam Kemasan",
    "Tomat dalam kemasan adalah produk tomat yang diperoleh dari<br> tomat matang yang bersih dan sehat yang dicuci, dimasukkan ke<br> dalam medium dan bahan lain yang sesuai, diproses dengan<br> pemanasan sebelum atau sesudah kemasan ditutup untuk<br> mencegah pembusukan.<br> Medium yang digunakan dapat berupa air, jus tomat, puree atau<br> bubur tomat dan pasta tomat. Bahan lain yang ditambahkan<br> adalah rempah-rempah, minyak dan pati.",
    "Aktif",
  ],
  [
    "0402020403",
    "Jagung Manis Dalam Kemasan",
    "Produk jagung yg diperoleh dari pipilan jagung manis (Zea mays L.) yang bersih, dimasukkan ke dalam medium sesuai dan diproses dengan pemanasan sebelum atau sesudah kemasan ditutup untuk mencegah pembusukan. Medium yang digunakan dapat berupa larutan yang mengandung pati jagung, gula, bumbu dan bahan lain yang sesuai.",
    "Aktif",
  ],
  [
    "0402020404",
    "Jamur Dalam Kemasan",
    "Jamur dalam kemasan adalah produk jamur yang diperoleh dari<br> jamur sehat yang dapat dimakan yang dibersihkan dalam keadaan<br> utuh atau diiris, serpihan, dan akar, diblansir, dimasukkan ke<br> dalam medium dengan penambahan bumbu yang sesuai, diproses<br> dengan pemanasan sebelum dan sesudah penutupan pengemas<br> untuk mencegah pembusukan. Medium yang digunakan dapat<br> berupa air, larutan garam, jus jamur, mentega, saus krim, vinegar,<br> dan minyak.",
    "Aktif",
  ],
  [
    "0402020405",
    "Asparagus Dalam Kemasan",
    "Asparagus dalam kemasan adalah produk asparagus yang diperoleh dari batang tanaman asparagus (Asparagus officinales L) dengan atau tanpa dikupas yang dimasukkan ke dalam air atau medium cair lain yang cocok, dikemas secara kedap (hermetis) dan diproses dengan panas untuk mencegah kerusakan.",
    "Aktif",
  ],
  [
    "0402020406",
    "Wortel Dalam Kemasan",
    "Wortel dalam kemasan adalah produk wortel yang diperoleh dari<br> wortel (Daucus carota Linn.) yang bersih, sehat, daun dan bagian<br> atas yang hijau telah dihilangkan, dikupas, dan dimasukkan ke<br> dalam air atau medium yang sesuai, diproses dengan pemanasan<br> sebelum atau setelah penutupan pengemas untuk mencegah<br> pembusukan. Medium yang digunakan adalah air, bumbu dan<br> bahan lain yang sesuai dengan produk. Jika ditambahkan mentega atau minyak dan lemak nabati atau lemak hewani maka kadarnya<br> tidak kurang dari 3% berat produk akhir.",
    "Aktif",
  ],
  [
    "0402020407",
    "Rebung Bambu Dalam Kemasan",
    "Rebung bambu dalam kemasan adalah produk rebung bambu yang<br> diperoleh dari irisan rebung bambu (Bambusa, Dendroclamus,<br> Gigantochola dan Phyllostachys) yang dimasukkan ke dalam air atau<br> medium yang sesuai, dikemas secara kedap (hermetis) dan<br> disterilisasi dengan pemanasan. Medium yang digunakan adalah air,<br> atau larutan garam.",
    "Aktif",
  ],
  [
    "0402020408",
    "Kacang Kapri (Green Peas) Dalam Kemasan",
    "Kacang kapri (green peas) dalam kemasan adalah produk kacang<br> kapri yang diperoleh dari kacang kapri (Pisum sativum L.) tetapi<br> tidak meliputi subsp. Macrocarpum, yang telah dikupas, bersih,<br> dimasukkan ke dalam medium yang sesuai, dikemas secara kedap<br> (hermetis) dan disterilkan dengan pemanasan. Medium yang<br> digunakan adalah air atau medium lain yang sesuai. Dapat<br> ditambahkan gula, bumbu dan bahan lain yang sesuai dengan<br> produk.",
    "Aktif",
  ],
  [
    "0402020409",
    "Buncis Dalam Kemasan",
    "Buncis dalam kemasan adalah produk buncis yang diperoleh dari<br> polong buncis segar (Phaseolus vulgaris) tanpa batang dan<br> tangkainya, yang dimasukkan ke dalam medium, dan disterilkan<br> dengan pemanasan. Medium yang digunakan adalah air atau<br> medium lainnya. Dapat ditambahkan gula, bumbu dan bahan lain yang sesuai dengan produk. Jika ditambahkan mentega, maka<br> kadarnya tidak kurang dari 3% dari produk akhir.",
    "Aktif",
  ],
  [
    "0402020410",
    "Manisan Rumput Laut Dalam Kemasan",
    "Manisan rumput laut dalam kemasan adalah produk rumput laut jenis Euchema sp yang ditambahkan larutan gula serta dikemas secara kedap (hermetis) dan dipasteurisasi.",
    "Aktif",
  ],
  [
    "0402020411",
    "Lidah Buaya Dalam Kemasan",
    "Lidah buaya dalam kemasan adalah produk pangan yang diperoleh dari daun lidah buaya (Aloe vera) dengan medium sirup atau air atau larutan garam dengan asidulan. Dikemas secara kedap (hermetis) dan dipasteurisasi atau disterilisasi.",
    "Aktif",
  ],
  ["0402020412", "Chesnut Dalam Kaleng", "", "Tidak Aktif"],
  ["0402020413", "Puree Chestnut Dalam Kaleng", "", "Tidak Aktif"],
  [
    "0402020414",
    "Pink Beans yang telah Dimasak Dalam Kaleng",
    "",
    "Tidak Aktif",
  ],
  ["0402020415", "Sayur dalam Kaleng", "&nbsp;", "Aktif"],
  ["0402020416", "Kacang Ginko Dalam Kemasan", "&nbsp;", "Aktif"],
  [
    "0402020417",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    "Akar/umbi/polong-polongan dalam kemasan adalah produk akar/umbi/polong-polongan yang diperoleh dari akar/umbi/polong-polongan sehat yang dapat dimakan yang dibersihkan dalam keadaan utuh atau diiris, serpihan, dan akar, diblansir, dimasukkan ke dalam medium dengan penambahan bumbu yang sesuai, diproses dengan pemanasan sebelum dan sesudah penutupan pengemas untuk mencegah pembusukan. Medium yang digunakan dapat berupa air, larutan garam, jus jamur, mentega, saus krim, vinegar dan minyak. Contohnya chestnut dalam kaleng, puree chestnut dalam kaleng, pink beans yang telah dimasak dalam kaleng.",
    "Aktif",
  ],
  [
    "0402020501",
    "Puree Tomat",
    "Puree tomat adalah produk tomat yang diperoleh dari proses penguapan air dari sari tomat yang diperoleh dari tomat bersih, sehat dan matang yang biji dan kulitnya telah dihilangkan. Produk dikemas dalam kemasan kedap (hermetis) dan diproses dengan pemanasan",
    "Aktif",
  ],
  [
    "0402020502",
    "Selai Kacang",
    "Selai kacang adalah produk kacang tanah atau kacang lainnya yang<br> diperoleh dari penggilingan kacang kupas yang bersih dan bermutu<br> baik, disangrai dan/atau digoreng dan/atau dipanggang, serta<br> dihilangkan lembaganya. Dapat ditambahkan bahan pangan lain.<br> Produk dapat digunakan sebagai olesan atau isian pangan lainnya.<br> Nama jenis mengikuti sumber kacangnya seperti selai kacang<br> (peanut butter), selai kacang mede (cashew butter), selai almond<br> (almond butter), selai kacang tanah dan almond.",
    "Aktif",
  ],
  [
    "0402020503",
    "Selai Kacang Mede (Cashew Butter)",
    "",
    "Tidak Aktif",
  ],
  ["0402020504", "Selai Kacang Lainnya", "", "Tidak Aktif"],
  ["0402020505", "Selai Labu (Pumpkin Butter)", "", "Tidak Aktif"],
  ["0402020506", "Olesan Berbasis Sayur", "&nbsp;", "Aktif"],
  [
    "0402020507",
    "Puree dan Produk Oles Sayur, Kacang dan Biji-Bijian dalam Kaleng",
    "-",
    "Aktif",
  ],
  ["0402020508", "Olesan Berbasis Kacang", "-", "Tidak Aktif"],
  [
    "0402020509",
    "Olesan Kacang",
    "Olesan kacang adalah produk olesan yang diperoleh dari<br> penggilingan satu jenis kacang atau lebih yang dikupas, bersih dan<br> bermutu baik, direbus dan/atau dikukus dan/atau disangrai<br> dan/atau digoreng dan/atau dipanggang (oven). Dapat ditambahkan<br> bahan pangan lain. Produk dapat digunakan sebagai olesan atau<br> isian pangan lainnya. Nama jenis produk ini misal olesan kacang<br> mede (cashew spread), olesan kacang merah, olesan (kacang)<br> almond (almond spread), olesan (kacang) kenari, olesan kacang<br> tanah dan mede.<br> <br> Karakteristik dasar:<br> Kandungan total kacang tidak kurang dari 40%.",
    "Aktif",
  ],
  [
    "0402020510",
    "Olesan Mengandung Kacang",
    "Olesan mengandung kacang adalah produk olesan yang diperoleh dari pencampuran bahan pangan dan kacang. Produk dapat digunakan sebagai olesan atau isian pangan lainnya. Nama jenis produk ini misalnya olesan mengandung kacang mede, olesan mengandung kacang tanah, olesan mengandung almond,olesan mengandung kacang tanah dan kacang mede.<br> <br> Karakteristik dasar:<br> Kandungan total kacang tidak kurang dari 15%",
    "Aktif",
  ],
  [
    "0402020511",
    "Selai Sayur",
    "Selai sayur adalah produk yang diperoleh dari proses penghancuran satu atau lebih jenis sayur yang bersih dan bermutu baik, dan diolah sehingga bisa dioles. Dapat ditambahkan bahan pangan lain. Contohnya selai labu (pumpkin butter).",
    "Aktif",
  ],
  [
    "0402020601",
    "Pasta Tomat",
    "Pasta tomat adalah produk tomat yang diperoleh dari proses<br> pemekatan sari buah tomat atau bubur buah tomat dapat<br> ditambahkan bahan pangan lain yang sesuai.",
    "Aktif",
  ],
  [
    "0402020602",
    "Bubur (Pulp) Tomat",
    "Bubur (pulp) tomat adalah produk tomat yang diperoleh dari tomat utuh, matang atau tomat yang sudah dibersihkan (trimming), diproses dengan pemanasan dan dipekatkan. Produk ini dikemas secara kedap (hermetis) dan dipanaskan.",
    "Tidak Aktif",
  ],
  ["0402020603", "Bubur (Pulp) Kentang", "", "Tidak Aktif"],
  ["0402020604", "Bubur (Pulp) Horseadish", "", "Tidak Aktif"],
  ["0402020605", "Ekstrak Aloe", "", "Tidak Aktif"],
  [
    "0402020606",
    "Salsa",
    "Contohnya adalah potongan kentang, bawang, lada (pepper),<br> rempah-rempah dan herba.",
    "Tidak Aktif",
  ],
  ["0402020607", "Pasta Kacang Merah Manis", "", "Tidak Aktif"],
  [
    "0402020608",
    "Pasta Biji Kopi Manis (Untuk Bahan Pengisi)",
    "",
    "Tidak Aktif",
  ],
  ["0402020609", "Jahe Kristalisasi", "", "Tidak Aktif"],
  [
    "0402020610",
    "Namagashi",
    "Namagashi adalah makanan pencuci mulut sayur berbasis kacang.",
    "Tidak Aktif",
  ],
  ["0402020611", "Topping Berbasis Sayur dan Kacang", "-", "Aktif"],
  [
    "0402020612",
    "Hasil Olah Iles-iles Dalam Bentuk Jeli",
    "-",
    "Aktif",
  ],
  [
    "0402020613",
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kaleng",
    "&nbsp;",
    "Aktif",
  ],
  [
    "0402020614",
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kemasan",
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kemasan selain Kemasan Kaleng",
    "Aktif",
  ],
  [
    "0402020615",
    "Pasta Umbi",
    "Pasta umbi adalah produk berbentuk pasta yang dibuat dari umbi yang direbus atau dikukus atau proses lain yang sesuai, kemudian dihancurkan, dapat ditambahkan bahan pangan lain yang sesuai.<br> Nama produk untuk kategori ini misal pasta talas, pasta wortel, dan pasta ubi.",
    "Aktif",
  ],
  [
    "0402020616",
    "Bubur (Pulp) Sayur",
    "Bubur sayur adalah produk sayur yang diperoleh dari sayur yang sudah dibersihkan, dihancurkan dan diolah lebih lanjut seperti pemanasan, pemekatan dan/atau pengeringan.",
    "Aktif",
  ],
  [
    "0402020617",
    "Produk Jeli Tidak Siap Konsumsi",
    "Produk jeli tidak siap konsumsi adalah produk jeli berupa lembaran atau bentuk lainnya yang dibuat dari bahan hidrokoloid dan masih harus diolah untuk menjadi produk siap konsumsi. Contoh produk ini jeli dari iles iles.",
    "Aktif",
  ],
  [
    "0402020701",
    "Pikel (fermentasi)",
    "Pikel adalah produk sayur yang diperoleh dari sayur yang<br> difermentasi dalam larutan garam, dengan atau tanpa penambahan<br> gula dan rempah-rempah, dapat dilakukan pasteurisasi atau proses<br> pemanasan. Contohnya pikel mentimun (Cucumis sativus L.), jahe,<br> dan zaitun. Ada 3 jenis produk pikel zaitun, yaitu :<br> \xE2\x{20AC}\xA2 Pikel Zaitun Hitam (Black Ripe Olives) dibuat dari zaitun yang<br> masak dan sebelum disimpan dalam larutan garam diproses<br> dengan basa dan dilanjutkan dengan aerasi untuk membuat<br> kulit buah menjadi gelap<br> \xE2\x{20AC}\xA2 Pikel Zaitun Hijau (Green Olives) dibuat dari zaitun yang sehat<br> dan masak dan dipanen pada saat buah berwarna ungu muda<br> atau pada tahap semburat kuning (straw-yellow), selama proses<br> pencucian dihindari terjadinya proses penggelapan kulit buah<br> (darkening) dan difermentasi dengan larutan garam encer<br> \xE2\x{20AC}\xA2 Pikel Zaitun Ala Yunani (Greek-Style Olives) dibuat dari zaitun<br> yang sehat dan masak dan dipanen pada saat buah telah<br> berwarna ungu atau hitam, tanpa diproses dengan basa sebelum<br> fermentasi.",
    "Aktif",
  ],
  [
    "0402020702",
    "Sawi Asin",
    "Sawi asin adalah produk sayur yang diperoleh dari daun sawi yang difermentasi oleh bakteri asam laktat dalam larutan garam.",
    "Aktif",
  ],
  [
    "0402020703",
    "Sauerkraut",
    "Sauerkraut adalah produk sayur berupa irisan atau cincangan kubis<br> dalam garam yang difermentasi oleh bakteri asam laktat. Produk<br> dapat diawetkan dalam larutan garam atau cairan kubis hasil<br> fermentasi, dikemas, dan dipanaskan.<br> <br> Karakteristik dasar:<br> \x{2022} Bau, rasa, warna dan tekstur khas sauerkraut;<br> \x{2022} Bobot tuntas tidak kurang dari 60%.",
    "Aktif",
  ],
  [
    "0402020704",
    "Jamur Fermentasi",
    "Jamur fermentasi adalah produk sayur yang diperoleh dari jamur<br> segar yang dapat dimakan, berbentuk utuh atau irisan yang<br> dibersihkan, dicuci, dan difermentasi oleh bakteri asam laktat dalam<br> larutan garam.<br> <br> Karakteristik dasar:<br> Kadar asam laktat sebagai hasil fermentasi 1%.",
    "Aktif",
  ],
  [
    "0402020705",
    "Pikel Mentimun",
    "Pikel mentimun adalah produk sayur yang diperoleh dari buah mentimun (Cucumis sativus L.) yang bersih, sehat, dengan atau tanpa pengupasan, dengan atau tanpa penghilangan biji, yang dikemas dengan atau tanpa medium yang sesuai dan bumbu yang sesuai dengan jenis produk, dan diawetkan. Pengawetan meliputi pengasaman sampai PH 4,6 atau kurang dengan fermentasi alami atau terkontrol atau dengan penambahan cuka atau asam yang dapat dimakan dan dapat dilakukan pasteurisasi",
    "Tidak Aktif",
  ],
  [
    "0402020706",
    "Pikel Jahe",
    "Pikel jahe adalah produk sayur yang diperoleh dari rimpang jahe sehat dan bersih yang telah dikupas, berbentuk utuh atau irisan dikemas dengan atau tanpa medium dan bumbu yang sesuai dengan jenis produk, yang diawetkan sebelum atau setelah penutupan pengemas. Pengawetan meliputi pengasaman sampai PH 4,6 atau kurang dengan fermentasi alami atau terkontrol atau dengan penambahan cuka atau asam yang dapat dimakan dan dapat dilakukan pasteurisasi",
    "Tidak Aktif",
  ],
  [
    "0402020707",
    "Pikel Zaitun (Olives)",
    "Pikel zaitun (olives) adalah produk yang diperoleh dari buah zaitun yang sehat dan bersih, yang difermentasi dengan penambahan garam. Produk dikemas dalam larutan garam dan diawetkan dengan pemanasan atau pasteurisasi.",
    "Tidak Aktif",
  ],
  [
    "0402020708",
    "Kimchi",
    "Kimchi adalah produk sayur yang diperoleh dari kubis cina yang difermentasi dan dicampur dengan sayur atau bahan lain.",
    "Aktif",
  ],
  [
    "0402020709",
    "Gochujang",
    "Gochujang adalah produk pangan fermentasi tradisional khas Korea Selatan berbentuk pasta berwarna merah atau merah gelap yang dibuat dengan mencampurkan bubuk cabai merah dengan kedelai yang difermentasi dan pati. Rasa manis dan pedas yang muncul disebabkan karena adanya hidrolisis pati, dan rasa gurih muncul karena hidrolisis protein.",
    "Aktif",
  ],
  [
    "0402020710",
    "Tempe Selain Kedelai",
    "Tempe Selain Kedelai adalah produk yang diperoleh dari fermentasi polong-polongan (leguminosae) dengan menggunakan kapang Rhizopus spp., produk ini berbentuk padatan kompak dan berbau khas serta berwarna putih atau sedikit keabu-abuan. Nama jenis produk disesuaikan dengan jenis polong-polongan (leguminosae) yang digunakan. Misalnya : Tempe Koro Pedang dan Tempe Koro Benguk.",
    "Aktif",
  ],
  [
    "0402020801",
    "Keripik Bayam",
    "Keripik bayam adalah produk keripik yang diperoleh dari daun bayam yang bersih dan bermutu baik, yang dilapis dengan adonan encer tepung berbumbu, kemudian digoreng.",
    "Aktif",
  ],
  [
    "0402020802",
    "Keripik Jamur Kancing",
    "Keripik jamur kancing adalah produk keripik yang diperoleh dari jamur kancing genus agaricus (A. bisforus, A.campesfris, A. biforqis) yang dikukus, diiris tipis sehingga berbentuk lempeng, diberi bumbu, kemudian digoreng dengan atau tanpa penambahan tepung.",
    "Aktif",
  ],
  [
    "0402020803",
    "Getuk Singkong",
    "Getuk singkong adalah produk singkong semi basah yang diperoleh dari singkong yang dikukus, dicampur dengan gula, digiling/dilumatkan kemudian dibentuk dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  ["0402020804", "Simmered Beans", "-", "Tidak Aktif"],
  ["0402020805", "Pre-Fried Potatoes", "-", "Tidak Aktif"],
  ["0402020806", "Okra yang Digoreng", "-", "Tidak Aktif"],
  [
    "0402020807",
    "Vegetable Tsukudani",
    "Vegetable tsukudani adalah produk sayur yang diperoleh dari sayur yang direbus dalam saus kedelai.",
    "Aktif",
  ],
  [
    "0402020808",
    "Kerupuk Jengkol",
    "Kerupuk jengkol adalah produk yang diperoleh dari buah jengkol segar yang dicampur dengan adonan tepung, dikukus, dibentuk, dan dikeringkan.",
    "Aktif",
  ],
  [
    "0402020809",
    "Sayur Olahan Yang Dibentuk (Meat Analog / Fish Analog / Seafood Analog)",
    "-",
    "Aktif",
  ],
  [
    "0402020810",
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya",
    "Dodol rumput laut adalah produk olahan dengan bahan baku rumput laut kering atau bahan baku setengah jadi, dicampur gula dengan atau tanpa santan, dengan atau tanpa tepung beras ketan dan bahan lainnya yang selanjutnya mengalami pemasakan, pencetakan, pemotongan, dan pengeringan. Termasuk jenang rumput laut, gelamai rumput laut, lempok rumput laut, dan produk rumput laut sejenis lainnya.",
    "Aktif",
  ],
  [
    "0402020811",
    "Keripik Bonggol Pisang",
    "Keripik bonggol pisang adalah produk keripik yang dibuat dari bonggol pohon pisang yang bersih dan bermutu baik, melalui proses pengolahan tertentu (misal: pengirisan, pencucian, perendaman), dengan atau tanpa pelapisan tepung dan/atau bumbu, kemudian digoreng sampai kering.<br>",
    "Aktif",
  ],
  [
    "05010101",
    "Kakao Bubuk",
    "Kakao Bubuk dihasilkan dari pengurangan lemak yang terkandung pada kakao massa (cocoa liquor) dan pencetakan menjadi keik kakao.<br> Keik kakao (cocoa cake) dihancurkan dan dihaluskan menjadi kakao bubuk.",
    "Aktif",
  ],
  [
    "05010102",
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa)",
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) adalah kakao bubuk yang ditambahkan susu, mentega, bumbu dan rempah lain.",
    "Tidak Aktif",
  ],
  [
    "05010105",
    "Debu Kakao (Cocoa Dust)",
    "Debu Kakao (Cocoa Dust) adalah fraksi dari biji kakao yang didapatkan dari proses pengupasan dan pemisahan kulit biji kakao (winnowing).",
    "Aktif",
  ],
  [
    "05010107",
    "Nib Kakao",
    "Nib kakao adalah produk yang diperoleh dari pemisahan kulit melalui proses kuring, pembersihan, pengeringan dan peretakan biji kakao. Kakao nib, atau biji kakao disini dapat diproses dengan pemanasan dengan satu atau lebih jenis alkali.",
    "Aktif",
  ],
  [
    "05010108",
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat",
    "Massa kakao dan cairan kental (liquor) cokelat adalah produk yang diperoleh dari penggilingan nib kakao dengan atau tanpa penyanggraian, dan dengan atau tanpa pemisahan atau penambahan bahan lain.",
    "Tidak Aktif",
  ],
  [
    "05010109",
    "Keik Kakao/Bungkil Kakao",
    "Keik kakao/bungkil kakao adalah produk kakao yang diperoleh dari pemisahan sebagian lemak dari keping biji kakao atau kakao massa.<br> <br> PerBPOM Nomor 34 Tahun 2019 tentang Kategori Pangan",
    "Aktif",
  ],
  [
    "05010110",
    "Minuman Kakao (Drinking Cocoa)",
    "Minuman kakao (drinking cocoa) adalah campuran bubuk kakao dengan atau tanpa penambahan perisa, rempah-rempah atau oleoresin serta bahan lainnya.",
    "Tidak Aktif",
  ],
  [
    "05010112",
    "Cokelat Instan",
    "Dibuat dari kakao massa, yang ditambahkan edible wetting agent (humektan), atau telah dilakukan proses instanisasi, dengan atau<br> tanpa penambahan bahan pangan lain.<br>",
    "Aktif",
  ],
  [
    "05010114",
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes)",
    "Bubuk minuman kakao (drinking cocoa mixes) adalah produk minuman dalam bentuk bubuk yang dibuat dari kakao bubuk dengan penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    "05010115",
    "Bubuk Minuman Cokelat (Drinking Chocolate)",
    "Bubuk minuman cokelat (drinking chocolate) adalah produk<br> minuman dalam bentuk bubuk yang dibuat dari kakao bubuk dengan/atau tanpa penambahan kakao massa, lemak kakao, dapat<br> ditambahkan bahan pangan lain.",
    "Aktif",
  ],
  [
    "05010116",
    "Lemak Kakao (Cocoa Butter)",
    "Lemak kakao (cocoa butter) adalah lemak yang diperoleh dari biji kakao.<br>",
    "Aktif",
  ],
  [
    "05010117",
    "Campuran kakao-gula (cocoa-sugar mixtures)",
    "Campuran kakao-gula (cocoa-sugar mixtures) hanya terdiri dari bubuk kakao dan gula.",
    "Tidak Aktif",
  ],
  [
    "05010118",
    "Kakao Instan",
    "Kakao instan adalah produk minuman dalam bentuk bubuk yang dibuat dari kakao bubuk yang diproses sedemikian rupa sehingga mudah larut air, dengan atau tanpa penambahan gula atau bahan pangan lain.<br> Karakteristik dasar :<br> Kandungan kakao (total cocoa solids) tidak kurang dari 10% dihitung sebagai berat kering.",
    "Aktif",
  ],
  [
    "05010119",
    "Cokelat Bubuk",
    "Cokelat bubuk adalah campuran kakao bubuk dan gula, mengandung tidak kurang dari 32% kakao bubuk (29% dihitung terhadap basis kering).",
    "Aktif",
  ],
  [
    "05010120",
    "Kakao Massa (Cocoa liquor)",
    "Kakao massa (Cocoa liquor) adalah produk kakao berupa pasta yang diperoleh dari kakao nib (keping biji kakao) melalui penggilingan tanpa menghilangkan kandungan lemaknya.",
    "Aktif",
  ],
  [
    "05010121",
    "Biji cokelat yang disangrai atau roasting",
    "Untuk memfasilitasi pendaftaran pangan olahan selain PSAT",
    "Aktif",
  ],
  [
    "05010201",
    "Sirup Cokelat",
    "Sirup cokelat adalah produk yang terbuat dari campuran gula dengan atau tanpa bahan pemanis lainnya, satu atau lebih produk kakao, dengan atau tanpa penambahan air dengan atau tanpa penambahan bahan pangan lain.<br> Karakteristik dasar : Kandungan kakao (total cocoa solids) tidak kurang dari 8%",
    "Aktif",
  ],
  [
    "05010301",
    "Cokelat Pasta",
    "Cokelat pasta adalah produk makanan yang berbentuk pasta yang dibuat dari campuran kakao bubuk, gula dan lemak.",
    "Tidak Aktif",
  ],
  [
    "05010302",
    "Olesan Berbasis Kacang-Cokelat (Nut-Chocolate Based Spread)",
    "Olesan berbasis kacang-cokelat (nut-chocolate based spread) adalah jenis olesan berbahan dasar lemak cokelat yang ditambahkan kacang (kacang tanah, hazelnut, almond).",
    "Aktif",
  ],
  [
    "05010303",
    "Olesan Cokelat Berbasis Air (Chocolate Water-Based Spread)",
    "Olesan cokelat berbasis air (chocolate water-based spread) adalah produk yang terbuat dari bubuk kakao yang didispersikan dalam sirup gula, gula invert dan kadang-kadang sirup glukosa.",
    "Tidak Aktif",
  ],
  [
    "05010304",
    "Cokelat Pasta (berbasis minyak)",
    "Cokelat pasta (berbasis minyak) adalah produk yang berbentuk pasta berbasis lemak yang dibuat dari campuran satu atau lebih produk kakao dengan atau tanpa bahan pangan lain. Produk tersebut dapat digunakan sebagai olesan atau isian, misalnya olesan kakao-kacang, olesan kakao-susu.<br> Karakteristik dasar :<br> \x{2022} Kadar air tidak lebih dari 2%;<br> \x{2022} Kadar lemak tidak kurang dari 25%.",
    "Aktif",
  ],
  [
    "05010305",
    "Cokelat Pasta (berbasis air)",
    "Cokelat pasta (berbasis air) adalah produk yang berbentuk pasta, berbasis air, yang dibuat dari campuran satu atau lebih produk kakao dengan atau tanpa bahan pangan lain.",
    "Aktif",
  ],
  [
    "05010401",
    "Cokelat",
    "Cokelat adalah produk homogen yang dihasilkan melalui proses pencampuran produk kakao (kakao massa dan atau lemak kakao dan atau kakao bubuk) dengan atau tanpa penambahan susu, dan gula.",
    "Tidak Aktif",
  ],
  [
    "05010402",
    "Lemak Kakao (Cocoa Butter)",
    "Lemak kakao (cocoa butter) adalah lemak yang diperoleh dari biji kakao.",
    "Tidak Aktif",
  ],
  [
    "05010403",
    "Bonbon Cokelat/Permen Isi Cokelat",
    "Bonbon coklat/permen coklat adalah produk permen yang bagian dalamnya lunak dan terbuat dari campuran cairan kental (liquor) kakao, susu dan sirup gula. Kandungan susu tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "05010404",
    "Truffles",
    "Truffles adalah produk permen yang dibuat dari campuran cokelat hitam atau cokelat susu dengan lemak kakao, minyak nabati dan bahan lainnya. Tipe Eropa mengkombinasikan sirup dengan bahan-bahan berbasis cokelat (bubuk kakao, susu bubuk, lemak, gula, sirup",
    "Aktif",
  ],
  [
    "05010406",
    "Cokelat Putih",
    "Cokelat putih adalah produk padat atau semiplastis yang diperoleh dari hasil pencampuran dan penggilingan lemak kakao dengan satu atau lebih produk susu dan satu atau lebih pemanis nutritif karbohidrat dan bahan-bahan lain.",
    "Tidak Aktif",
  ],
  [
    "05010407",
    "Cokelat Drop atau Chip",
    "Cokelat drop atau chip adalah produk yang dibuat dari adonan kental cokelat dan dibentuk dengan cara melewatkannya melalui nozzle kecil dan dijatuhkan pada ban berjalan sehingga membentuk piramid atau kubah kecil.",
    "Tidak Aktif",
  ],
  [
    "05010408",
    "Cokelat Susu",
    "Cokelat susu adalah produk yang dibuat dari campuran cairan kental cokelat, gula atau pemanis lain, lemak kakao atau lemak lain dan produk susu (susu bubuk penuh dan susu bubuk tanpa lemak). Kandungan susu tidak lebih dari 5%.",
    "Tidak Aktif",
  ],
  [
    "05010409",
    "Cokelat Krim",
    "Coklat krim adalah cokelat dengan penambahan gula, krim dan padatan susu.",
    "Tidak Aktif",
  ],
  [
    "05010410",
    "Cokelat Manis",
    "Cokelat manis adalah produk padat atau semiplastis yang diperoleh dari proses pencampuran dan penggilingan cokelat liquor dengan satu atau lebih pemanis karbohidat nutritif. Dapat ditambahkan bahan lainnya.",
    "Tidak Aktif",
  ],
  [
    "05010411",
    "Bahan Pelapis Dari Kakao Manis dan Lemak Nabati",
    "produk yang sama dg definisi & standar untuk cokelat manis, kecuali dalam penyiapan produk, kakao atau campuran dari kakao dan cokelat liquor digunakan dlm jumlah tertentu sehingga produk akhir mengandung tidak kurang dari 6.8% pada padatan kakao bkn lema",
    "Tidak Aktif",
  ],
  [
    "05010412",
    "Cokelat Semi-Manis atau Cokelat Pahit-Manis atau Cokelat Hitam",
    "Cokelat semi-manis atau cokelat pahit-manis atau cokelat hitam adalah cokelat manis yang mengandung tidak kurang dari 35% cokelat liquor.",
    "Tidak Aktif",
  ],
  [
    "05010413",
    "Cokelat Isi (Filled Chocolate)",
    "Cokelat Isi (filled chocolate) adalah produk yang dilapisi dengan satu atau lebih lapisan cokelat dan cokelat berperisa dimana bagian tengah dapat dibedakan dengan lapisan luarnya. Cokelat isi tidak termasuk produk tepung confectionery, pastri dan biskuit",
    "Tidak Aktif",
  ],
  [
    "05010414",
    "Cokelat Tawar (Unsweetened Chocolate)",
    "Cokelat tawar (unsweetened chocolate) adalah cokelat tanpa penambahan gula.",
    "Tidak Aktif",
  ],
  [
    "05010416",
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel",
    "Meses/cokelat butir/cokelat vermicelli/streusel adalah butiran atau kepingan dari salah satu atau campuran dari kakao massa, kakao bubuk termasuk<br> kakao bubuk yang dikurangi lemaknya dengan atau tanpa penambahan lemak kakao, dan bahan pangan lain.",
    "Aktif",
  ],
  [
    "05010417",
    "Cokelat Serpih",
    "Cokelat serpih adalah cokelat dengan penambahan gula dan dibentuk menjadi serpihan.",
    "Tidak Aktif",
  ],
  [
    "05010418",
    "Cokelat Susu Serpih",
    "Cokelat susu serpih adalah susu dengan penambahan gula dan lemak susu dan dibentuk menjadi bentuk serpihan atau batangan.",
    "Tidak Aktif",
  ],
  [
    "05010419",
    "Cokelat Berperisa",
    "Cokelat berperisa adalah produk cokelat yang diberi senyawa perisa seperti kopi atau senyawa perisa lain untuk klaim sesuai dengan karakteristik organoleptik.",
    "Tidak Aktif",
  ],
  [
    "05010420",
    "Cokelat Aerasi",
    "Cokelat aerasi adalah produk cokelat yang mengalami proses aerasi sehingga terbentuk rongga-rongga kecil di dalamnya.",
    "Aktif",
  ],
  [
    "05010421",
    "Cokelat Laminasi",
    "Cokelat laminasi adalah produk cokelat yang berlapis-lapis dibuat dengan menggunakan roller dan dalam kondisi plastis dipotong-potong menjadi batangan atau serpihan.",
    "Tidak Aktif",
  ],
  [
    "05010422",
    "Cokelat Komposit",
    "Cokelat komposit adalah produk cokelat berperisa yang ditambah dengan bahan lain yang dapat dimakan tidak termasuk tepung, pati dan lemak kecuali jika telah ada di dalam ingredien yang digunakan.",
    "Aktif",
  ],
  [
    "05010423",
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ...",
    "Cokelat hitam, diperhitungkan dalam kondisi tanpa kandungan air, mengandung tidak kurang dari 35% padatan kakao, tidak kurang dari 18% lemak kakao, dan tidak kurang dari 14% padatan kakao tanpa lemak.<br> <br> Untuk Cokelat Hitam Isi : jumlah komponen cokelat untuk pelapisan tidak kurang dari 25% dari berat total produk akhir (dari 25% tsb min 60% merupakan komponen cokelat). Sehingga jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).<br>",
    "Aktif",
  ],
  [
    "05010424",
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ...",
    "Cokelat hitam manis, diperhitungkan dalam kondisi tanpa kandungan air, mengandung tidak kurang dari 30% padatan kakao, tidak kurang dari 18% lemak kakao, dan tidak kurang dari 12% padatan kakao tanpa lemak.<br> <br> Untuk Cokelat Hitam Manis Isi : jumlah komponen cokelat untuk pelapisan tidak kurang dari 25% dari berat total produk akhir (dari 25% tsb min 60% merupakan komponen cokelat). Sehingga jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Aktif",
  ],
  [
    "05010425",
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ...",
    "Cokelat hitam kovertur, diperhitungkan dalam kondisi tanpa kandungan air, mengandung tidak kurang dari 35% padatan kakao, tidak kurang dari 31% lemak kakao, dan tidak kurang dari 2.5% padatan kakao tanpa lemak.<br> <br> Untuk Cokelat Hitam Kovertur Isi : jumlah komponen cokelat untuk pelapisan tidak kurang dari 25% dari berat total produk akhir (dari 25% tsb min 60% merupakan komponen cokelat). Sehingga jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Aktif",
  ],
  [
    "05010426",
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ...",
    "Cokelat susu kovertur, diperhitungkan dalam kondisi tanpa kandungan air, semestinya mengandung tidak kurang dari 25% padatan kakao, tidak kurang dari 15% lemak kakao, tidak kurang dari 2,5% padatan kakao tanpa lemak, tidak kurang dari 12% padatan susu, dan tidak kurang dari 31% total lemak.<br> <br> Untuk Cokelat Susu Kovertur Isi : jumlah komponen cokelat untuk pelapisan tidak kurang dari 25% dari berat total produk akhir (dari 25% tsb min 60% merupakan komponen cokelat). Sehingga jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Aktif",
  ],
  [
    "05010427",
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ...",
    "Cokelat putih kovertur, diperhitungkan dalam kondisi tanpa kandungan air, semestinya mengandung tidak kurang dari 20% lemak kakao, tidak kurang dari 14% padatan susu dan tidak kurang dari 25% total lemak.<br> <br> Untuk Cokelat Putih Kovertur Isi : jumlah komponen cokelat untuk pelapisan tidak kurang dari 25% dari berat total produk akhir (dari 25% tsb min 60% merupakan komponen cokelat). Sehingga jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Aktif",
  ],
  [
    "05010428",
    "Praline",
    "Praline adalah produk cokelat (real chocolate) dengan ukuran satu suapan penuh, dimana dapat berupa cokelat isi (filled chocolate), atau kombinasi dari berbagai tipe cokelat dengan bahan makanan lain.",
    "Aktif",
  ],
  [
    "05010429",
    "Cokelat Putih (white chocolate) / Cokelat Putih Isi ...",
    "Cokelat putih, diperhitungkan dalam kondisi tanpa kandungan air, semestinya mengandung tidak kurang dari 20% lemak kakao, dan tidak kurang dari 14% padatan susu.<br> <br> Untuk Cokelat Putih Isi : jumlah komponen cokelat untuk pelapisan tidak kurang dari 25% dari berat total produk akhir (dari 25% tsb min 60% merupakan komponen cokelat). Sehingga jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Aktif",
  ],
  [
    "05010430",
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ...",
    "Cokelat susu, diperhitungkan dalam kondisi tanpa kandungan air, mengandung tidak kurang dari 25% padatan kakao, tidak kurang dari 2,5% padatan kakao tanpa lemak, dan tidak kurang dari 12% padatan susu.<br> <br> Untuk Cokelat Susu Isi : jumlah komponen cokelat untuk pelapisan tidak kurang dari 25% dari berat total produk akhir (dari 25% tsb min 60% merupakan komponen cokelat). Sehingga jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Aktif",
  ],
  [
    "05010431",
    "Cokelat Isi (Filled Chocolate)",
    "Cokelat Isi (filled chocolate) adalah produk yang dilapisi dengan satu atau lebih lapisan cokelat dan cokelat berperisa dimana bagian tengah dapat dibedakan dengan lapisan luarnya. Cokelat isi tidak termasuk produk tepung confectionery, pastri dan biskuit.",
    "Tidak Aktif",
  ],
  [
    "05010432",
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli",
    "Meses susu/cokelat susu butir/cokelat susu vermicelli adalah butiran atau kepingan dari salah satu atau campuran dari kakao massa, kakao bubuk termasuk kakao bubuk yang dikurangi lemaknya dengan atau tanpa penambahan lemak kakao, susu, dan bahan pangan lain.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Padatan kakao tanpa lemak tidak kurang dari 2.5%;<br> \xE2\x{20AC}\xA2 Total padatan kakao tidak kurang dari 20%;<br> \xE2\x{20AC}\xA2 Padatan susu tidak kurang dari 12%.",
    "Aktif",
  ],
  [
    "05010501",
    "Cocoa Butter Equivalent",
    "Cocoa butter equivalent adalah lemak yang memiliki seluruh sifat fisik dan kimia lemak kakao tetapi komponen gliserida penyusunnya diturunkan dari sumber selain biji kakao. Karakter flavor tidak harus sama dengan lemak kakao. Produk ini terbuat dari lemak",
    "Aktif",
  ],
  [
    "05010502",
    "Pengganti Lemak Kakao Laurat (Lauric Cocoa Butter Replacer/<br> Substitute=CBS Lauric)",
    "Pengganti lemak kakao laurat (lauric cocoa butter replacer/ substitute=CBS lauric) adalah lemak yang memiliki sifat mirip dengan lemak kakao, tetapi tidak sama dengan lemak kakao. Produk ini terutama berbasis minyak sawit dan minyak inti sawit.",
    "Aktif",
  ],
  [
    "05010503",
    "Pengganti Lemak Kakao Non-Laurat (Nonlauric Cocoa Butter Replacer/<br> Substitute = CBS Non-Lauric)",
    "Pengganti lemak kakao non-laurat (nonlauric cocoa butter replacer/ substitute = CBS non-lauric) adalah lemak yang kesetaraan fase lemaknya 20% hingga 25% dengan lemak kakao. Teksturnya menyerupai lilin (waxy).",
    "Aktif",
  ],
  [
    "05010504",
    "Carob Coatings",
    "Carob coatings adalah produk pengganti lemak cokelat yang berasal dari sejenis kacang (locus bean) dengan dominasi kandungan karbohidrat tetapi tidak mengandung kafein dan teobromin.",
    "Aktif",
  ],
  [
    "05010505",
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ<br> Coating)",
    "Coating dari lembaga gandum bebas lemak (deffated wheat germ coating) adalah pengganti lemak cokelat dari lembaga gandum bebas lemak yang melalui proses penyangraian dan proses spesifik lainnya.",
    "Aktif",
  ],
  [
    "05010506",
    "Cokelat Compound Butir/Cokelat Paduan Butir",
    "Cokelat compound butir/cokelat paduan butir adalah cokelat paduan/cokelat compound dengan penambahan gula dan dibentuk menjadi butiran.",
    "Aktif",
  ],
  [
    "05010508",
    "Cokelat Paduan/Cokelat Compound Hitam Pahit (bitter dark compound chocolate) / Cokelat Compound Hitam Pahit Isi ...",
    "Cokelat Paduan/Cokelat compound hitam pahit (bitter dark compound chocolate) adalah produk cokelat dimana sebagian atau seluruh lemak kakaonya diganti dengan lemak nabati. Padatan kakao tidak kurang dari 20%.<br> <br> Untuk Cokelat Compound Hitam Pahit Isi : jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Aktif",
  ],
  [
    "05010509",
    "Minuman Cokelat Paduan (Bubuk)",
    "Minuman Cokelat Paduan (Bubuk) dibuat dari kakao bubuk dan/atau padatan kakao dengan penambahan bahan pangan lainnya. Kandungan kakao (total cocoa solid) tidak kurang dari 5% (dihitung dari basis berat kering)",
    "Aktif",
  ],
  [
    "05010510",
    "Cokelat Imitasi",
    "Cokelat imitasi adalah produk serupa cokelat paduan/cokelat<br> compound dimana karakteristik dasarnya tidak memenuhi<br> karakteristik dasar cokelat paduan/cokelat compound.",
    "Aktif",
  ],
  [
    "05010511",
    "Cokelat Paduan / Cokelat Compound Hitam (dark compound chocolate) / Cokelat Compound Hitam Isi ...",
    "Cokelat paduan/Cokelat compound hitam (dark compound chocolate) adalah produk cokelat dimana sebagian atau seluruh lemak kakaonya diganti dengan lemak nabati. Padatan kakao tidak kurang dari 13,0%.<br> <br> Untuk Cokelat Compound Hitam Isi : jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Aktif",
  ],
  [
    "05010512",
    "Cokelat Paduan / Cokelat Compound Hitam Manis (Sweet Dark Compound Chocolate) / Cokelat Compound Hitam Manis Isi ...",
    "Cokelat paduan/Cokelat compound hitam manis (sweet dark compound chocolate) adalah produk cokelat dimana sebagian atau seluruh lemak kakaonya diganti dengan lemak nabati. Padatan kakao tidak kurang dari 7,0%, diperhitungkan atas dasar berat kering dalam produk.<br> <br> Untuk Cokelat Compound Hitam Manis Isi : jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Aktif",
  ],
  [
    "05010513",
    "Cokelat Paduan / Cokelat Compound Susu (Milk Compound Chocolate) / Cokelat Compound Susu Isi ...",
    "Cokelat paduan/Cokelat compound susu (milk compound chocolate) adalah produk cokelat dimana sebagian atau seluruh lemak kakaonya diganti dengan lemak nabati. Padatan kakao tidak kurang dari 5,0% dan padatan susu tidak kurang dari 9,0%, diperhitungkan atas dasar berat kering dalam produk.<br> <br> Untuk Cokelat Compound Susu Isi : jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Aktif",
  ],
  [
    "05010514",
    "Cokelat Paduan / Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) / Cokelat Compound Susu Manis Isi ...",
    "Cokelat Paduan/Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) adalah produk cokelat dimana sebagian atau seluruh kakaonya diganti dengan lemak nabati. Padatan kakao tidak kurang dari 5% dan padatan susu tidak kurang dari 5%. Persentase diperhitungkan atas dasar berat kering dalam produk.<br> <br> Untuk Cokelat Compound Susu Manis Isi : jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).<br>",
    "Aktif",
  ],
  [
    "05010515",
    "Cokelat Paduan / Cokelat Compound Putih (White Compound Chocolate) / Cokelat Compound Putih Isi ...",
    "Cokelat Paduan/Cokelat Compound Putih (White Compound Chocolate) adalah produk cokelat dimana sebagian atau seluruh kakaonya diganti dengan lemak nabati. Padatan susu tidak kurang dari 14%. Persentase diperhitungkan atas dasar berat kering dalam produk.<br> <br> Untuk Cokelat Compound Putih Isi : jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Tidak Aktif",
  ],
  [
    "05010516",
    "Cokelat Paduan / Cokelat Compound Putih Manis (Sweet White Compound Chocolate) / Cokelat Compound Putih Manis Isi ...",
    "Cokelat Paduan/Cokelat Compound Putih Manis (Sweet White Compound Chocolate) adalah produk cokelat dimana sebagian atau seluruh kakaonya diganti dengan lemak nabati. Padatan susu tidak kurang dari 5%. Persentase diperhitungkan atas dasar berat kering dalam produk.<br> <br> Untuk Cokelat Compound Putih Manis Isi : jumlah maksimal bahan isian adalah 75% (tidak termasuk produk tepung, confectionery, pastry dan biskuit).",
    "Tidak Aktif",
  ],
  [
    "05010517",
    "Minuman Cokelat Paduan (Siap minum, Konsentrat)",
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) dibuat dari kakao bubuk dan/atau padatan kakao dengan penambahan bahan pangan lainnya. Kandungan kakao (total cocoa solid) tidak kurang dari 5% (dihitung dari basis berat kering)",
    "Aktif",
  ],
  [
    "05010518",
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (Steril Komersial)",
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) yang diproses steril komersial.",
    "Tidak Aktif",
  ],
  [
    "05020101",
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet",
    "Kembang gula keras/permen keras / hard candy / boiled sweet adalah produk berbentuk padat yang terbuat dari gula atau pemanis bukan gula (non nutritif) dengan atau tanpa pemanis lain, sirup glukosa dengan atau tanpa penambahan bahan pangan lain. Produk in",
    "Aktif",
  ],
  [
    "05020102",
    "Pastiles",
    "Pastiles adalah produk confectionery yang mengikutsertakan gelatin selain gom arab dan sirup glukosa yang lebih banyak sehingga berpengaruh pada tekstur permen yang lebih lunak. Pastiles biasanya berlapis granula atau tepung gula.",
    "Aktif",
  ],
  [
    "05020103",
    "Pressed Candy/Lozenges",
    "Pressed candy/lozenges adalah sejenis permen yang terbuat dari tepung gula yang dibentuk menjadi pasta dapat ditambahkan gom, larutan gelatin atau keduanya.",
    "Aktif",
  ],
  [
    "05020104",
    "Kembang Gula Isi Susu/Permen Isi Susu",
    "",
    "Aktif",
  ],
  [
    "05020105",
    "Hasil Olah Gula (Butiran, dll)",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    "05020106",
    "Kembang Gula/Permen Isi lainnya",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    "05020201",
    "Kembang Gula Lunak/Permen Lunak",
    "Kembang gula lunak/permen lunak adalah kembang gula/permen yang bertekstur relatif lunak apabila dikunyah. Dapat dilapisi dengan pelapis gula atau cokelat atau bahan lainnya.<br> Karakteristik dasar :<br> \x{2022} Kadar air permen lunak tidak lebih dari 7,5%;<br> \x{2022} Kadar air permen lunak jeli tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "05020202",
    "Kembang Gula Karamel/Permen Karamel",
    "Kembang gula karamel/permen karamel adalah kembang gula/permen yang terbuat dengan tambahan susu lemak penuh dan sumber lemak lain dari lemak nabati atau hewani dan terjadi reaksi pencoklatan (reaksi maillard) pada produk. Dari teksturnya dibedakan menjadi tiga jenis yaitu lunak, medium dan keras tergantung dari suhu pendidihan. Karamel lunak biasanya digunakan untuk pelapisan confectionery batangan dan untuk pelapisan dengan ekstrusi.",
    "Aktif",
  ],
  [
    "05020203",
    "Fudge",
    "Fudge adalah kembang gula karamel / permen karamel yang memiliki tekstur lebih berpasir akibat proses kristalisasi karena kandungan gula yang lebih tinggi dari kembang gula karamel/ permen karamel.",
    "Aktif",
  ],
  [
    "05020204",
    "Butterscotch",
    "Butterscotch adalah kembang gula karamel/permen karamel yang hanya menggunakan butter sebagai sumber lemak di luar bahan dasar gula dan glukosa.",
    "Aktif",
  ],
  [
    "05020205",
    "Licorice",
    "Licorice adalah kembang gula lunak/permen lunak yang dibuat dari ekstrak tanaman licorice (leguminous weed), tepung terigu, gula, sirup glukosa, gelatin, serta air. Proses utama adalah pemanasan sampai tergelatinisasi sempurna dengan kadar air rendah, pencetakan dengan ekstruder dan pengeringan.",
    "Aktif",
  ],
  [
    "05020206",
    "Toffee",
    "Toffee adalah kembang gula/permen dengan tekstur yang keras dan agak chewy yang dibuat dari campuran gula, susu, mentega atau lemak lain, garam, lesitin dengan atau tanpa penambahan kacang. Kandungan lemak dari permen toffee lebih rendah dari permen karamel.",
    "Aktif",
  ],
  [
    "05020207",
    "Krokant/Nugat (Praline)/Brittles",
    "Krokant / nugat (praline)/ brittles adalah kembang gula /permen sejenis toffee tetapi tidak menggunakan susu dalam formulasinya dan didominasi oleh rasa kacang (almond, hazelnut atau kacang tanah) yang ditambahkan pada adonan dalam bentuk hancuran agak ka",
    "Tidak Aktif",
  ],
  [
    "05020208",
    "Marshmallow",
    "Marshmallow adalah kembang gula /permen lunak dan beraerasi yang dibuat dari gelatin/pektin/agar/gom arab, albumin telur, gula, glukosa dan gula invert.",
    "Aktif",
  ],
  [
    "05020209",
    "Kembang Gula Jeli Pati (Starch Jelly)",
    "Kembang gula jeli pati (starch jelly) adalah kembang gula jeli/permen jeli yang menggunakan pati (pati jagung, pati gandum atau pati lainnya) sebagai salah satu bahan selain bahan-bahan lain yang biasa digunakan untuk produk confectionery.<br> Karakteristik dasar :<br> Kadar air tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "05020210",
    "Kembang Gula Jeli Agar dan Gelatin",
    "Kembang gula jeli agar dan gelatin adalah kembang gula jeli/permen jeli yang dibuat dari bahan dasar agar, gelatin atau pektin sehingga merupakan produk gel yang kenyal.<br> Jeli agar lebih keras dan menyerupai karet (rubbery) dari jeli gelatin tetapi tekstur jeli gelatin tergantung dari jumlah gelatin yang digunakan. Jeli pektin lebih lunak dan lebih mudah terdispersi di dalam mulut.<br> Karakteristik dasar :<br> Kadar air tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "05020211",
    "Gula Kapas (Cotton Candy)/Arumanis",
    "Gula kapas (cotton candy) / arumanis adalah kembang gula /permen yang terbuat dari 100% gula yang dilelehkan dan diputar dengan mesin pemutar (spin) dimana cairan gula dilewatkan pada lubang kecil yang berputar sehingga membentuk massa seperti kapas.",
    "Aktif",
  ],
  [
    "05020212",
    "Krokant/Brittles",
    "Krokant/brittles adalah kembang gula/permen sejenis toffee menggunakan susu dalam formulasinya dan didominasi oleh rasa kacang (almond, hazelnut atau kacang tanah) yang ditambahkan pada adonan dalam bentuk hancuran agak kasar (chopped).",
    "Aktif",
  ],
  [
    "05020213",
    "Gulali",
    "Gulali adalah produk yang terbuat dari gula dan air yang dipanaskan membentuk adonan pasta atau semi plastis dan dicetak menjadi berbagai macam bentuk.",
    "Aktif",
  ],
  [
    "05020301",
    "Nougat",
    "Nougat adalah produk yang berbahan dasar gula dan whipping agent atau putih telur, dengan atau tanpa penambahan bahan pangan lain misalnya madu, kakao, kacang-kacangan, buah kering, yang dibentuk untuk langsung dikonsumsi, atau dapat digunakan sebagai bahan pengisi untuk produk cokelat. Nougat dapat bertekstur keras atau lunak.",
    "Aktif",
  ],
  [
    "05020302",
    "Gulali",
    "Gulali adalah produk yang terbuat dari gula, air dan pewarna yang dipanaskan membentuk adonan pasta atau semiplastis dan dicetak menjadi berbagai macam bentuk.",
    "Tidak Aktif",
  ],
  [
    "05020303",
    "Permen Enting-Enting atau Nut Brittles",
    "Nut brittles atau permen enting-enting adalah permen keras dengan kandungan lemak dan susu lebih rendah dari karamel yang terbuat dari gula, mentega dan hancuran kacang-kacangan.",
    "Aktif",
  ],
  [
    "05020304",
    "Enting-Enting Kacang Gepuk",
    "Enting-enting kacang gepuk adalah makanan ringan berbentuk lempengan padat, prisma atau bentuk lainnya, dibuat dari kacang tanah (Arachis hypogeae L), dan gula pasir dan atau gula merah.",
    "Aktif",
  ],
  [
    "05020305",
    "Raw Marzipan, Base Almond Paste",
    "Raw marzipan, base almond paste adalah massa yang diproduksi dari almond yang diblansir, mengandung tidak lebih dari 17% air dan 35% gula, dan 10% dari keseluruhan massa adalah gula invert.<br> Kadar minyak almond tidak kurang dari 28%, mengandung tidak lebih dari 12% komponen pahit dari almond. Tanpa penghilangan rasa pahit.",
    "Aktif",
  ],
  [
    "05020306",
    "Marzipan, Almond Paste",
    "Marzipan, almond paste adalah campuran dari raw marzipan dengan komposisi tidak melebihi proporsi gula. Gula dapat digantikan dengan sirup glukosa hingga 3,5% dan/atau larutan sorbitol 70% hingga 5% dari total berat marzipan.",
    "Aktif",
  ],
  [
    "050301",
    "Kembang Gula Karet/Permen Karet",
    "Kembang gula karet/permen karet adalah produk yang terbuat dari bahan dasar gom alami atau sintetis, pemanis, dan bahan pangan lain.<br> Karakteristik dasar :<br> \x{2022} Kadar air tidak lebih dari 5%;<br> \x{2022} Gom tidak kurang dari 12%.",
    "Aktif",
  ],
  [
    "050401",
    "Icing",
    "Icing adalah bahan pelapis kue atau kukis yang terbuat dari bahan dasar gula, susu dan bahan lain dan lapisan membentuk massa yang keras setelah beberapa saat setelah dilapiskan.",
    "Aktif",
  ],
  [
    "050402",
    "Frosting",
    "Frosting adalah bahan pelapis berbentuk krim untuk kue yang terbuat dari bahan dasar gula, susu, lemak dan bahan lain.",
    "Aktif",
  ],
  [
    "050403",
    "Saus Butterscotch",
    "Saus butterscotch adalah sejenis sirup untuk dekorasi puding, baking product dan es krim yang terbuat dari gula, gula merah, cokelat, sirup jagung, margarin.",
    "Aktif",
  ],
  [
    "050404",
    "Saus/Topping/Olesan Cokelat",
    "Saus/topping/olesan cokelat adalah produk yang terbuat dari campuran gula, air dan atau minyak/lemak, satu atau lebih produk kakao, dengan atau tanpa bahan pangan lain, yang digunakan sebagai topping atau dekorasi.",
    "Aktif",
  ],
  [
    "050405",
    "Bahan pengisi roti berbasis cokelat",
    "Bahan pengisi roti berbasis cokelat",
    "Tidak Aktif",
  ],
  [
    "050406",
    "Bahan pengisi roti berbasis selain cokelat dan kacang",
    "Produk oles untuk salad (misalnya salad makaroni, salad kentang) dan sandwich, tidak termasuk produk oles berbasis cokelat dan kacang",
    "Tidak Aktif",
  ],
  [
    "050407",
    "Dekorasi (Misalnya Untuk Bakery) dan Topping (Non-Buah)",
    "-",
    "Aktif",
  ],
  [
    "050408",
    "Saus/Topping/Olesan Manis",
    "Saus/topping/olesan manis adalah produk yang terbuat dari<br> campuran gula, air dan atau minyak/lemak, dengan atau tanpa<br> bahan pangan lain, yang digunakan sebagai topping atau dekorasi.",
    "Aktif",
  ],
  ["050409", "Premiks Pengisi Roti (Serbuk)", "&nbsp;", "Aktif"],
  [
    "050410",
    "Taburan Berbasis Gula",
    "Taburan berbasis gula adalah produk pangan berbentuk butiran atau kepingan dibuat dari gula dan lemak dengan atau tanpa penambahan bahan pangan lain, digunakan sebagai dekorasi atau topping es krim, kue atau pangan lain.",
    "Aktif",
  ],
  [
    "050411",
    "Saus/Topping/Olesan (non buah)",
    "Saus/topping/olesan (non buah) adalah produk untuk dekorasi/topping makanan atau minuman yang dibuat dengan gula dan/atau pemanis lain, dan bahan pangan lain. Topping (non buah) tidak termasuk non-dairy topping dari kategori pangan 02.3, topping buah dari kategori pangan 04.1.2.8, dan sirup cokelat dari kategori 05.1.2.",
    "Aktif",
  ],
  [
    "060101",
    "Biji-Bijian dan Kacang-Kacangan Utuh (Serealia)",
    "Biji-bijian dan kacang- kacangan utuh adalah biji-bijian atau<br> serealia utuh, serta kacang-kacangan baik yang berkulit atau tidak<br> dan belum mengalami proses pengolahan.",
    "Tidak Aktif",
  ],
  [
    "060106",
    "Beras Diperkaya",
    "Beras diperkaya adalah beras giling yang telah mengalami penambahan zat gizi.",
    "Aktif",
  ],
  [
    "060109",
    "Emping Beras",
    "Emping beras adalah produk beras ketan yang diperoleh dari beras ketan sosoh yang direndam dalam air dan dipanaskan hingga patinya tergelatinisasi sempurna, lalu dipipihkan dan dikeringkan.",
    "Tidak Aktif",
  ],
  [
    "060111",
    "Gandum Patah (Cracked Wheat)",
    "Gandum patah (cracked wheat) adalah biji tanaman gandum yang mengalami pemecahan atau pemotongan, tetapi tidak termasuk gandum durum dan gandum durum merah.<br> Karakteristik dasar:<br> - Kadar air tidak lebih dari 15%<br> - Kehalusan : tidak kurang dari 90% lolos ayakan 8 mesh dan tidak lebih dari 20% lolos ayakan 20 mesh",
    "Tidak Aktif",
  ],
  [
    "060112",
    "Gandum Hancur (Crushed Wheat)",
    "Gandum hancur (crushed wheat) adalah biji tanaman gandum yang bersih dan telah mengalami penghancuran, tetapi tidak termasuk gandum durum dan gandum durum merah.<br> Karakteristik dasar:<br> - Kadar air tidak lebih dari 15%<br> - Kehalusan : lebih dari 40% lolos ayakan 8 mesh dan kurang dari 50% lolos ayakan 20 mesh",
    "Tidak Aktif",
  ],
  [
    "060113",
    "Jagung Pipil",
    "Jagung pipil adalah biji utuh tanaman jagung yang berasal dari tanaman Zea mays indentata L.,atau Zea mays indurata L., serta hasil hibridanya.",
    "Tidak Aktif",
  ],
  [
    "060119",
    "Bubur Instan",
    "Bubur Instan adalah produk bubur yang dibuat dari beras atau tepung beras yang mengalami proses pemasakan dan pengeringan. Dapat ditambahkan bumbu dan bahan pangan lain.<br> Karakteristik dasar:<br> Kadar air tidak lebih dari 14%",
    "Aktif",
  ],
  [
    "060120",
    "Nasi Instan",
    "Nasi Instan adalah nasi yang diperoleh dari beras sosoh yang direndam dalam air dan dipanaskan hingga patinya tergelatinisasi sempurna lalu dikeringkan. Dapat ditambahkan bumbu dan bahan pangan lainnya.<br> <br> Karakteristik dasar:<br> Kadar air tidak lebih dari 14%<br>",
    "Aktif",
  ],
  [
    "060121",
    "Biji-Bijian Utuh, Patahan, atau Serpihan, Termasuk Beras dengan Pemanasan dan/atau Penambahan Bahan Lain",
    "-",
    "Aktif",
  ],
  [
    "06020101",
    "Tepung Beras",
    "Tepung beras adalah tepung yang diperoleh dari penggilingan atau penumbukan beras (Oryza sativa L) yang telah maupun belum disosoh.",
    "Aktif",
  ],
  [
    "06020102",
    "Tepung Beras Ketan",
    "Tepung beras ketan adalah tepung yang diperoleh dari penggilingan atau penumbukan beras ketan (varietas putih maupun hitam). Pati beras ketan hampir seluruhnya terdiri dari amilopektin.",
    "Aktif",
  ],
  [
    "06020103",
    "Tepung Jagung",
    "Tepung jagung adalah tepung yang diperoleh dari penggilingan atau penumbukan biji jagung (Zea mays Linn) dari berbagai varietas. Termasuk tepung jagung putih dan tepung jagung kuning.",
    "Aktif",
  ],
  [
    "06020105",
    "Tepung Kacang Hijau Utuh",
    "Tepung kacang hijau utuh adalah tepung yang diperoleh dari penggilingan atau penumbukan biji tanaman kacang hijau (Phaseolus radiatus L.) yang belum dihilangkan kulitnya.",
    "Aktif",
  ],
  [
    "06020106",
    "Tepung Kacang Merah",
    "Tepung kacang merah adalah tepung yang diperoleh dari penggilingan atau penumbukan biji tanaman kacang merah yang sudah dihilangkan kulitnya.",
    "Aktif",
  ],
  [
    "06020107",
    "Tepung Kedelai (Soybean Flour)",
    "Tepung kedelai adalah tepung yang diperoleh dari penggilingan atau penumbukan kedelai (Glycine max L).",
    "Aktif",
  ],
  [
    "06020108",
    "Semolina Gandum Durum dan Tepung Gandum Durum",
    "Semolina gandum durum dan tepung gandum durum adalah tepung dan semolina yang diperoleh dari penggilingan atau penumbukan biji gandum durum (Triticum durum Desf) yang bersih, bebas dari kulit ari dan lembaga.",
    "Aktif",
  ],
  [
    "06020109",
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh",
    "Semolina gandum durum utuh dan tepung gandum durum utuh adalah tepung yang diperoleh dari penggilingan atau penumbukan biji gandum durum (Triticum durum Desf) yang bersih, tetapi masih mengandung kulit ari dan lembaga.",
    "Aktif",
  ],
  [
    "06020110",
    "Tepung Jewawut (Pearl Millet Flour)",
    "Tepung jewawut (pearl millet flour) adalah tepung yang diperoleh dari penggilingan atau penumbukan endosperm biji pearl millet (Pennisetum americanum L.) yang telah dikupas dan dipisahkan dari lembaganya.",
    "Aktif",
  ],
  [
    "06020111",
    "Tepung Sorgum",
    "Tepung sorgum adalah tepung yang diperoleh dari hasil penggilingan atau penumbukan endosperm biji Shorgum bicolor (L.) Moench yang telah dikupas dan dipisahkan dari lembaganya.",
    "Aktif",
  ],
  [
    "06020112",
    "Tepung Terigu",
    "Tepung terigu adalah tepung yang dibuat dari hasil penggilingan atau penumbukan endosperma biji gandum Triticum aestivum L (club wheat) dan atau Triticum compactum Host atau campuran keduanya dengan penambahan Fe, Zn, vitamin B1, vitamin B2, dan asam folat sebagai fortifikan.",
    "Aktif",
  ],
  [
    "06020113",
    "Tepung Terigu Self-Raising",
    "Tepung terigu self-raising adalah tepung terigu atau tepung terigu terklorinasi atau campurannya, dengan bahan pengembang kue/leavening agent atau ingredien lain maupun kombinasinya.",
    "Aktif",
  ],
  [
    "06020114",
    "Tepung Terigu Terklorinasi",
    "Tepung terigu terklorinasi adalah tepung terigu yang telah diberi perlakuan dengan klorin.",
    "Tidak Aktif",
  ],
  [
    "06020115",
    "Tepung Gluten Terigu (Wheat Gluten Powder)",
    "Tepung gluten terigu adalah tepung yang diperoleh dari tepung terigu yang telah mengalami pemisahan sebagian besar patinya.",
    "Aktif",
  ],
  [
    "06020116",
    "Tepung Terigu dengan Penambahan Protein",
    "Tepung terigu dengan penambahan protein adalah tepung yang diperoleh dari tepung terigu dengan penambahan protein hingga kandungan nitrogen tidak kurang dari 2,7% (bk).",
    "Aktif",
  ],
  [
    "06020117",
    "Tepung Terigu Utuh (Wholemeal Wheat Flour)",
    "Tepung terigu utuh (wholemeal wheat flour) adalah tepung yang bersih dan baik, diperoleh dari gandum utuh yang bersih dan baik yang telah digiling.",
    "Aktif",
  ],
  [
    "06020118",
    "Tepung Kulit Ari (Fine Bran)",
    "Tepung kulit ari (fine bran) adalah tepung yang diperoleh dari penggilingan atau penumbukan kulit ari biji-bijian seperti beras, gandum, oats, dan lain-lain yang terpisah dari endospermanya dan dalam keadaan bersih dan baik, dengan tingkat kehalusan tertentu",
    "Aktif",
  ],
  [
    "06020119",
    "Tepung Singkong",
    "Tepung singkong adalah tepung yang diperoleh dari penggilingan atau penumbukan umbi singkong (Manihot sp.) Umbi singkong yang digunakan adalah yang aman dikonsumsi.",
    "Aktif",
  ],
  [
    "06020120",
    "Tepung Gaplek",
    "Tepung gaplek adalah tepung yang diperoleh dari penggilingan atau penumbukan gaplek (umbi singkong kering utuh atau dipotong-potong). Umbi singkong yang digunakan adalah yang aman dikonsumsi.",
    "Aktif",
  ],
  [
    "06020121",
    "Tepung Umbi Lainnya (Tepung Kentang, Tepung Ubi Jalar, Tepung Garut, Tepung Ganyong dan lain-lain.)",
    "Tepung umbi lainnya (tepung kentang, tepung ubi jalar, tepung garut, tepung ganyong dan lain-lain) adalah tepung yang diperoleh dari penggilingan atau penumbukan umbi. Umbi yang digunakan adalah yang aman dikonsumsi.",
    "Aktif",
  ],
  [
    "06020122",
    "Tepung Aren",
    "Tepung aren adalah tepung yang diperoleh dari penggilingan atau penumbukan empulur pohon aren (Arenga pinnata Merr).",
    "Aktif",
  ],
  [
    "06020123",
    "Kinako",
    "Kinako adalah tepung kedelai panggang.",
    "Aktif",
  ],
  [
    "06020124",
    "Konjac Flour",
    "Tepung konjac adalah tepung glukomanan yang diperoleh hasil<br> ekstraksi umbi iles-iles (Amorphophallus konjac).",
    "Aktif",
  ],
  [
    "06020126",
    "Tepung Iles-iles",
    "Tepung iles-iles adalah tepung yang diperoleh dari penggilingan atau penumbukan umbi tanaman Amorphophallus muelleri.",
    "Aktif",
  ],
  ["06020127", "Tepung Ceshnut", "-", "Aktif"],
  ["06020128", "Tepung Almond", "&nbsp;", "Aktif"],
  ["06020129", "Tepung Flaxseed", "-", "Aktif"],
  ["06020130", "Tepung Hazelnut", "-", "Aktif"],
  [
    "06020131",
    "Tepung Mokaf",
    "Tepung Mokaf adalah Tepung yang diperoleh dari ubi kayu (Manihot sp.) dengan proses fermentasi asam laktat.<br> <br> Karakteristik dasar:<br> \xB7 Kadar air tidak lebih dari 13%<br> \xB7 Kehalusan: tidak kurang dari 90% lolos ayakan 100 mesh, dan 100% lolos ayakan 80 mesh<br>",
    "Aktif",
  ],
  ["06020132", "Tepung Kacang Lainnya", "-", "Aktif"],
  [
    "06020133",
    "Tepung Campur",
    "Tepung campur adalah produk campuran 2 (dua) atau lebih jenis tepung dan/atau pati.",
    "Aktif",
  ],
  ["06020134", "Tepung Buckwheat", "", "Aktif"],
  [
    "06020201",
    "Pati Garut",
    "Pati garut adalah pati yang diperoleh dari sari umbi garut (Maranta arundinaceace L).",
    "Aktif",
  ],
  [
    "06020202",
    "Pati Jagung atau Maizena",
    "Pati jagung atau maizena adalah pati yang diperoleh dari biji jagung (Zea mays Linn) berbagai varietas.<br> <br> Karakteristik dasar:<br> Kadar air tidak lebih dari 14%",
    "Aktif",
  ],
  [
    "06020203",
    "Pati Sagu",
    "Pati sagu adalah pati yang diperoleh dari sari empulur pohon sagu (Metroxylon sp).",
    "Aktif",
  ],
  [
    "06020204",
    "Pati Kacang Hijau/Hunkwee",
    "Pati kacang hijau atau hunkwee adalah pati yang diperoleh dari kacang hijau (Phaseolusradiatus).",
    "Aktif",
  ],
  [
    "06020205",
    "Tapioka/Pati Singkong/Pati Ubi Kayu",
    "Tapioka/pati singkong/pati ubi kayu adalah pati yang diperoleh dari singkong/ubi kayu (Manihot sp.)",
    "Aktif",
  ],
  [
    "06020206",
    "Dekstrin",
    "Dekstrin adalah produk pati yang diperoleh dari pati yang dihidrolisis dengan pemanasan kering, perlakuan asam atau enzimatik.",
    "Aktif",
  ],
  [
    "06020207",
    "Pati Termodifikasi",
    "Pati termodifikasi adalah pati yang diperoleh dari modifikasi molekuler pati baik secara fisik, kimia, enzimatis maupun genetis untuk memperoleh sifat fungsional pati yang unggul.",
    "Aktif",
  ],
  ["06020209", "Pati Gandum", "-", "Aktif"],
  [
    "06020210",
    "Pati Lainnya (Biji-Bijian, Umbi-Umbian, dll)",
    "-",
    "Aktif",
  ],
  [
    "060302",
    "Keping Jagung (Corn Flake)",
    "Keping jagung (corn flake) adalah produk jagung yang diperoleh dari proses gelatinisasi pati jagung dengan berbagai teknik misalnya ekstrusi, lalu dikeringkan.",
    "Aktif",
  ],
  [
    "060303",
    "Meal",
    "Meal adalah produk serealia yang diperoleh dari penggilingan serealia. Produk ini dapat berupa campuran serealia.",
    "Aktif",
  ],
  [
    "060304",
    "Meal Lembaga Gandum (Wheat Germ Meal)",
    "Meal lembaga gandum (wheat germ meal) adalah produk meal yang diperoleh dari lembaga atau embrio biji gandum, bersama dengan kulit ari dan bagian lain. Kandungan lembaga tidak kurang dari 60%<br>",
    "Aktif",
  ],
  [
    "060305",
    "Oatmeal",
    "Oatmeal adalah produk meal yang diperoleh dari penggilingan atau penumbukan biji oat dan telah dipisahkan dari kulitnya. Kandungan lemak tidak kurang dari 5%<br>",
    "Aktif",
  ],
  [
    "060306",
    "Whole Maize (Corn) Meal",
    "Whole maize (corn) meal adalah produk meal yang diperoleh dari penggilingan atau penumbukan biji jagung (Zea mays L.) yang telah tua, belum berkecambah, sampai tingkat kehalusan tertentu. Pada persiapan penggilingan, partikel kasar dapat dipisahkan, digiling ulang, dan dikombinasi kembali dengan bahan asalnya. Kadar air tidak lebih dari 15%, Kehalusan: tidak kurang dari 95% lolos ayakan 10 mesh dan 45% lolos ayakan 24 mesh dan tidak kurang dari 35% lolos ayakan 65 mesh",
    "Aktif",
  ],
  [
    "060307",
    "Degermed Maize (Corn) Meal",
    "Degermed maize (corn) meal adalah produk meal yang diperoleh dari penggilingan atau penumbukan biji jagung (Zea mays L.) yang telah tua, bersih dari jamur, bersih dari biji gulma dan bersih dari serealia lain, sampai tingkat kehalusan tertentu dan selanjutnya dipisahkan lembaga dan kulit ari. Pada persiapan penggilingan, partikel kasar dapat dipisahkan, digiling ulang, dan dikombinasi kembali dengan bahan asalnya. Kadar air tidak lebih dari 15%, Kehalusan: tidak kurang dari 95% lolos ayakan 0,85 mm dan tidak kurang dari 45% lolos ayakan 24 mesh dan tidak kurang dari 25% lolos ayakan 65 mesh",
    "Aktif",
  ],
  [
    "060308",
    "Nasi Jagung",
    "Nasi jagung adalah produk jagung yang diperoleh dari penggilingan atau penumbukan kasar jagung pipil yang kemudian diolah lebih lanjut seperti memasak nasi.",
    "Aktif",
  ],
  [
    "060309",
    "Sereal Siap Santap termasuk Sereal Sarapan",
    "Produk serealia yang diperoleh dari satu atau campuran beberapa jenis serealia baik yang belum dimasak, telah dimasak sebagian, atau dimasak sempurna dengan ditambahkan bahan lain seperti : gula, malt, madu, garam, dan bahan pangan lain. Produk biasa dikonsumsi untuk sarapan dan/atau untuk tujuan lain. Bentuk produk dapat berupa<br> flake, keping, batang, dan bubur.<br> Karakteristik dasar:<br> Kandungan serealia tidak kurang dari 50%",
    "Aktif",
  ],
  [
    "060310",
    "Tiwul",
    "Produk yang diperoleh dari tepung gaplek kemudian direndam dalam air dan dikukus.",
    "Aktif",
  ],
  [
    "060311",
    "Degermed Maize (Corn) Grits",
    "Produk jagung yang diperoleh dari penggilingan atau penumbukan biji jagung (Zea mays<br> L.) yang telah tua, bersih dari jamur, bersih dari biji gulma dan bersih dari serealia lain; sampai tingkat kehalusan tertentu dan selanjutnya dipisahkan seluruh lembaga dan kulit ari. Karakteristik dasar:<br> - Kadar air tidak lebih dari 15%<br> - Kehalusan : tidak kurang dari 95% lolos ayakan 9 mesh dan tidak kurang dari 20% lolos ayakan 24 mesh",
    "Aktif",
  ],
  [
    "060313",
    "Serbuk Minuman Sereal",
    "Serbuk minuman/minuman serbuk serealia adalah produk minuman serealia dalam bentuk bubuk yang diperoleh dari satu atau lebih serealia dengan atau tanpa tambahan bahan pangan lain.<br> <br> Karakteristik dasar:<br> Kandungan serealia tidak kurang dari 25%",
    "Aktif",
  ],
  ["060314", "Sereal untuk Sarapan dengan Susu", "&nbsp;", "Aktif"],
  [
    "060315",
    "Sereal Siap Saji (Steril Komersial)",
    "&nbsp;",
    "Aktif",
  ],
  [
    "060316",
    "Sereal Siap Santap dengan Serealia Utuh (Whole Grain Ready To Eat Cereal) termasuk Sereal Sarapan dengan Serealia Utuh",
    "Sereal Sarapan dengan Serealia Utuh adalah produk sereal siap santap yang diperoleh dari serealia sebagai bahan baku utama dimana sebagian atau keseluruhannya adalah serealia utuh dan dapat dicampur beberapa serealia yang belum dimasak, telah dimasak sebagian, atau dimasak sempurna dengan<br> ditambahkan bahan lain seperti : gula, malt, madu, garam, dan bahan pangan lain, dimana produk akhirnya dapat berbentuk flake<br> , keping, batang, atau bubur.<br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Kandungan serealia utuh tidak kurang dari 25%<br> \xE2\x{20AC}\xA2 Kadar serat pangan tidak kurang dari 3 g/100g",
    "Aktif",
  ],
  [
    "060317",
    "Granola",
    "Granola adalah produk sereal yang merupakan campuran gandum, kacang-kacangan, madu, buah kering dan dapat ditambahkan dengan ingredient lainnya. Produk ini dapat dikonsumsi dengan susu maupun yoghurt.",
    "Aktif",
  ],
  [
    "06040101",
    "Mi Basah Mentah",
    "Mi basah mentah adalah produk pangan yang diperoleh dari tepung terigu dengan atau tanpa penambahan bahan lain, berbentuk khas mi yang yang diperoleh melalui proses sheeting dan slittering (belum dipanaskan, direbus, dikukus, dimasak, di-pragelatinisasi,a",
    "Aktif",
  ],
  [
    "06040102",
    "Kulit Pangsit/Risol/Lumpia",
    "Kulit pangsit adalah produk tepung yang diperoleh dari adonan tepung dengan air dengan atau tanpa penambahan bahan pangan lain. Produk ini berbentuk lembaran tipis, dan dapat digunakan sebagai pembungkus pangsit, siomay, atau risol.",
    "Aktif",
  ],
  ["06040103", "Tortilla", "-", "Tidak Aktif"],
  [
    "06040104",
    "Mi Basah Mentah lainnya",
    "Mi basah mentah lainnya adalah mi basah mentah yang dibuat dari selain tepung terigu. Nama jenis untuk kategori ini misalnya mi basah mentah jagung",
    "Aktif",
  ],
  [
    "06040105",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    "Pangsit/pastel/lumpia/risol/samosa mentah adalah produk yang dibuat dari adonan tepung dengan air dengan atau tanpa penambahan bahan pangan lain, dan belum dimasak. Produk ini dapat diisi dengan daging, ikan, sayuran, atau bahan pangan lain. Termasuk dalam kategori ini adalah produk lain yang sejenis.",
    "Aktif",
  ],
  [
    "06040201",
    "Kuetiaw Kering",
    "Kuetiaw kering adalah produk pangan kering yang diperoleh dari tepung beras, berbentuk khas kuetiaw.",
    "Aktif",
  ],
  [
    "06040202",
    "Makaroni",
    "Makaroni adalah produk pangan yang diperoleh dari adonan semolina, tepung durum, farina, tepung terigu dan kombinasinya, dengan air dan bahan pangan lain seperti putih telur, putih telur beku, tepung putih telur dan kombinasinya dengan padatan 0,5% hingga",
    "Aktif",
  ],
  [
    "06040205",
    "Produk Pasta Gandum Utuh",
    "Produk pasta gandum utuh adalah pasta yang diperoleh dari tepung<br> gandum utuh atau tepung gandum durum utuh, dan dapat<br> ditambahkan bahan pangan lain. Karakteristik dasar:<br> \xEF\x{201A}\xB7 Kadar air tidak lebih dari 12,5%<br> \xEF\x{201A}\xB7 Kadar protein tidak kurang dari 10%",
    "Aktif",
  ],
  [
    "06040206",
    "Produk Pasta Gandum dan Kedelai",
    "Produk pasta gandum dan kedelai adalah pasta yang diberi<br> tambahan tepung kedelai, dan dapat ditambahkan bahan pangan<br> lain.<br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 Penambahan tepung kedelai tidak kurang dari 12,5%<br> \xEF\x{201A}\xB7 Kadar protein tidak kurang dari 13%",
    "Aktif",
  ],
  [
    "06040207",
    "Produk Pasta Susu",
    "Produk pasta susu adalah pasta yang menggunakan susu atau<br> ingredien susu sebagai pelarut adonannya, dengan atau tanpa<br> penambahan air.<br> Susu yang digunakan berupa susu konsentrat, susu bubuk, susu<br> evaporasi, dan campuran butter dengan susu skim, konsentrat susu<br> skim, susu skim evaporasi, susu bubuk tanpa lemak atau<br> campuran dua atau lebih komponen tersebut dengan proporsi berat<br> padatan susu tanpa lemak dalam campuran tidak lebih dari 2,275<br> kali berat lemak susu.<br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 Total padatan susu tidak kurang dari 3,8%<br> \xEF\x{201A}\xB7 Kadar protein tidak kurang dari 11%<br>",
    "Tidak Aktif",
  ],
  [
    "06040208",
    "Produk Pasta Sayur",
    "Produk pasta sayur adalah pasta yang diberi tambahan sayur<br> seperti tomat, artichoke (Cynara cardunculus), bit, wortel, atau<br> bayam, dan dapat ditambahkan bahan pangan lain.<br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 Penambahan sayur tidak kurang dari 3% (dihitung sebagai bahan<br> segar)<br> \xEF\x{201A}\xB7 Kadar protein tidak kurang dari 9%",
    "Aktif",
  ],
  [
    "06040213",
    "Produk Mi Gandum dan Kedelai",
    "Produk mi gandum dan kedelai adalah mi dari tepung gandum<br> dengan penambahan tepung kedelai.<br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 Penambahan tepung kedelai tidak kurang dari 12,5%<br> \xEF\x{201A}\xB7 Kadar protein tidak kurang dari 13%",
    "Aktif",
  ],
  [
    "06040214",
    "Produk Mi Sayur",
    "Produk mi sayur adalah mi yang diberi tambahan sayur seperti tomat, artichoke, bit, wortel, bayam atau sayur lainnya. Sayur yang ditambahkan dapat berupa sayuran segar, kering, tepung, hancuran, ekstrak, atau konsentrat.<br> Karakteristik dasar:<br> Sayur yang ditambahkan tidak kurang dari 3% dihitung sebagai sayuran segar.",
    "Aktif",
  ],
  [
    "06040216",
    "Sohun",
    "Sohun adalah produk kering yang diperoleh dari tepung ubi kayu.<br> <br> Kategori Pangan Sohun (06040216) ini statusnya diubah menjadi Tidak Aktif karena sudah digantikan dengan Kategori Pangan : Sohun (06040318), menyesuaikan dengan PerKBPOM No.21 Tahun 2016.",
    "Tidak Aktif",
  ],
  ["06040217", "Mi Kering", "-", "Tidak Aktif"],
  [
    "06040218",
    "Pasta",
    "Pasta adalah produk yang dibuat dari semolina gandum durum sebagai bahan utama dan dapat mengandung pangan sumber karbohidrat lain, tepung, telur, garam, dan bahan pangan lain, yang diperoleh melalui ekstrusi atau pencetakan adonan. Produk dicetak menjadi berbagai bentuk dan dikeringkan. Produk pasta mengandung bahan dari gandum tidak kurang dari 80%. Termasuk makaroni, spagheti, fettuccini, penne, farfale, fusilli, ravioli, lasagna, cannelloni, rigatoni.<br> Karakteristik dasar : Kadar air tidak lebih dari 12,5%. Kadar protein tidak kurang dari 10%",
    "Aktif",
  ],
  [
    "06040219",
    "Pasta lainnya",
    "Pasta lainnya adalah produk pasta yang dibuat dari selain gandum sebagai bahan utama dan bahan pangan lainnya, yang diperoleh melalui ekstrusi atau pencetakan adonan. Nama jenis untuk kategori ini misalnya pasta jagung. Karakteristik dasar : Kadar air tidak lebih dari 12.5%",
    "Aktif",
  ],
  ["06040220", "Kuetiaw Lainnya", "-", "Aktif"],
  [
    "06040301",
    "Bihun",
    "Bihun adalah produk pangan kering yang diperoleh dari tepung beras dengan atau tanpa bahan lain.<br> Karakteristik dasar:<br> Kadar air tidak lebih dari 13%",
    "Aktif",
  ],
  [
    "06040302",
    "Makaroni",
    "Makaroni adalah produk pangan yang diperoleh dari adonan semolina, tepung durum, farina, tepung terigu dan kombinasinya, dengan air dan bahan pangan lain seperti utih telur, putih telur beku, tepung putih telur dan kombinasinya 0,5% hingga 2% dari produk",
    "Tidak Aktif",
  ],
  [
    "06040303",
    "Mi Kering Gandum",
    "Mi kering gandum adalah produk mi kering yang diperoleh dari tepung terigu dengan atau tanpa penambahan bahan lain dan telah mengalami pengeringan atau penggorengan. Produk mi kering gandum mengandung tidak kurang dari 60% bahan dari gandum. Karakteristik dasar kadar air tidak lebih dari 11% dan kadar protein tidak kurang dari 6%.",
    "Aktif",
  ],
  [
    "06040304",
    "Mi Kering Lainnya",
    "Mi kering lainnya adalah produk mi kering yang diperoleh dari bahan selain tepung terigu seperti tepung jagung, ubi jalar dan lain-lain, dengan atau tanpa penambahan bahan lain dan telah mengalami pengeringan atau penggorengan. Nama jenis untuk kategori ini misalnya mi kering jagung dan mi kering ubi jalar. Karakteristik dasar produk ini adalah kadar air tidak lebih dari 10%.",
    "Aktif",
  ],
  [
    "06040305",
    "Bihun Instan",
    "Bihun instan adalah produk bihun kering yang sebelumnya telah mengalami proses pemasakan sehingga patinya tergelatinisasi. Bihun instan akan matang setelah dimasak dengan air mendidih dalam waktu 4 menit. Karakteristik dasar: Kadar air tidak lebih dari 13%.",
    "Aktif",
  ],
  [
    "06040306",
    "Kuetiaw Instan",
    "Kuetiaw instan adalah kuetiaw kering yang sebelumnya telah mengalami proses pemasakan sehingga patinya tergelatinisasi. Kuetiaw instan akan matang setelah dimasak atau diseduh dengan air mendidih dalam waktu 4 menit.",
    "Aktif",
  ],
  [
    "06040307",
    "Makaroni Instan",
    "Makaroni instan adalah makaroni kering yang sebelumnya telah mengalami proses pemasakan sehingga patinya tergelatinisasi. Makaroni instan akan matang setelah dimasak atau diseduh dengan air mendidih dalam waktu 4 menit.",
    "Aktif",
  ],
  [
    "06040308",
    "Mi Basah Matang",
    "Mi basah matang adalah produk makanan yang dibuat dari tepung terigu dengan atau tanpa penambahan bahan pangan lain, yang telah mengalami pengukusan atau perebusan.",
    "Aktif",
  ],
  [
    "06040309",
    "Mi Instan",
    "Mi instan adalah produk yang dibuat dari bahan baku utama tepung terigu dengan atau tanpa penambahan bahan pangan lainnya, dikukus, dan digoreng atau dikeringkan, dan matang<br> setelah dimasak atau diseduh menggunakan air mendidih atau air panas dalam waktu singkat beserta bumbu dan atau tanpa pelengkapnya yang terdapat dalam kemasan.<br> Karakteristik dasar:<br> - Kadar air tidak lebih dari 10% jika diolah dengan proses<br> penggorengan<br> - Kadar air tidak lebih dari 14% jika diolah dengan proses<br> pengeringan",
    "Aktif",
  ],
  [
    "06040310",
    "Mi Instan Lainnya",
    "Mi instan lainnya adalah produk yang diperoleh dari selain tepung<br> terigu seperti tepung jagung, dan lainnya, dengan atau tanpa<br> penambahan bahan pangan lain, dengan atau tanpa dikukus,<br> digoreng atau dikeringkan, dan matang setelah dimasak atau<br> diseduh dengan air mendidih atau air panas dalam waktu singkat<br> beserta bumbu dan atau tanpa pelengkap pangan yang terdapat dalam kemasan<br>",
    "Aktif",
  ],
  [
    "06040311",
    "Nasi Instan",
    "Nasi instan adalah produk nasi instan yang hanya mengandung bumbu dan tidak mengandung kacang, daging, sayur dan bahan pangan lainnya.",
    "Tidak Aktif",
  ],
  ["06040312", "Bubur Serealia Instan", "", "Aktif"],
  [
    "06040313",
    "Bubur Instan",
    "Kategori Pangan Bubur Instan (06040313) ini statusnya diubah menjadi Tidak Aktif karena sudah digantikan dengan Kategori Pangan : Bubur Instan (060119), menyesuaikan dengan PerKBPOM No.21 Tahun 2016.",
    "Tidak Aktif",
  ],
  [
    "06040314",
    "Nasi Instan Steril",
    "Nasi instan adalah produk nasi instan yang hanya mengandung bumbu dan tidak mengandung kacang, daging, sayur dan bahan pangan lainnya serta diproses secara steril.",
    "Tidak Aktif",
  ],
  ["06040315", "Bubur Siap Saji Dalam Kemasan", "&nbsp;", "Aktif"],
  [
    "06040316",
    "Mi Basah Matang Lainnya",
    "Mi basah matang lainnya adalah mi basah matang yang dibuat selain dari tepung terigu.",
    "Aktif",
  ],
  [
    "06040317",
    "Bihun Lainnya",
    "Bihun lainnya adalah bihun yang dibuat dari tepung selain dari tepung beras dengan atau tanpa bahan lain. Nama jenis untuk produk ini misalnya bihun jagung.<br> Karakteristik dasar:<br> Kadar air tidak lebih dari 13%",
    "Aktif",
  ],
  [
    "06040318",
    "Sohun",
    "Sohun adalah produk berbentuk untaian kering yang diperoleh dari<br> pati kacang hijau (hunkwee).<br> Karakteristik dasar:<br> Kadar air tidak lebih dari 13 %.",
    "Aktif",
  ],
  [
    "06040319",
    "Sohun Lainnya",
    "Sohun lainnya adalah produk berbentuk mi kering yang diperoleh dari pati sagu, pati aren, pati jagung (maizena), dan pati lainnya.<br> Karakteristik dasar:<br> Kadar air tidak lebih dari 13 %",
    "Aktif",
  ],
  [
    "06040320",
    "Pasta Instan Lainnya",
    "Pasta instan lainnya adalah produk pasta yang dibuat dari selain gandum<br> sebagai bahan utama dan bahan pangan lainnya, melalui proses pemasakan (gelatinisasi pati) dan pengeringan. Nama jenis untuk kategori ini misalnya makaroni jagung dan makaroni ubi jalar. Karakteristik dasar: Kadar air tidak lebih dari 12,5%.",
    "Aktif",
  ],
  [
    "06040321",
    "Pasta Instan",
    "Pasta instan adalah produk pasta yang telah dimasak lalu dikeringkan dan dapat ditambah bumbu.<br> Karakteristik dasar:<br> Kadar air tidak lebih dari 12,5%<br> Kadar protein tidak kurang dari 10%",
    "Aktif",
  ],
  [
    "06040322",
    "Mi Soa",
    "Mi Soa adalah mi kering dengan diameter untaian yang kecil dibuat dari tepung terigu dengan penambahan bahan pangan lain dan berwarna putih<br>",
    "Aktif",
  ],
  ["06040323", "Sohun Instan", "&nbsp;", "Aktif"],
  ["06040324", "Kerupuk Mentah", "-", "Aktif"],
  [
    "06040325",
    "Tepung Olahan / Pati Olahan / Protein Olahan (Meat Analog / Fish Analog / Seafood Analog)",
    "",
    "Aktif",
  ],
  [
    "06040326",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    "Pangsit/pastel/lumpia/risol/samosa pramasak adalah produk yang dibuat dari adonan tepung dengan air dengan atau tanpa penambahan bahan pangan lain, dan dimasak. Produk ini dapat diisi dengan daging, ikan, sayuran, atau bahan pangan lain. Termasuk dalam kategori ini adalah produk lain yang sejenis.",
    "Aktif",
  ],
  [
    "0604A0",
    "Pasta",
    "Pasta adalah produk yang dibuat dari meal serealia seperti semolina sebagai bahan utama dan dapat mengandung pangan sumber karbohidrat, tepung, telur, garam, dan bahan pangan lain, yang diperoleh melalui ekstrusi atau pencetakan adonan. Termasuk mi, makar",
    "Aktif",
  ],
  [
    "060501",
    "Tepung Custard Tanpa Telur (Eggless Custard)",
    "Tepung custard tanpa telur (eggless custard) adalah tepung yang dibuat dari campuran tapioka, pati jagung atau pati sagu, dengan maupun tanpa bahan lain.",
    "Aktif",
  ],
  ["060509", "Brem", "", "Aktif"],
  [
    "060510",
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati",
    "Premiks untuk makanan pencuci mulut berbasis serealia dan pati adalah produk berbentuk bubuk dengan bahan dasar tepung<br> serealia atau pati atau campurannya dengan penambahan gula dan bahan pangan lain. Dalam penyiapannya harus ditambahkan air atau susu dan/atau krim sebelum diolah lebih lanjut menjadi makanan pencuci mulut.",
    "Aktif",
  ],
  [
    "060511",
    "Sagu/Pati Mutiara",
    "Sagu/pati mutiara adalah produk dengan tekstur kenyal terbuat dari tepung sagu atau tepung serealia atau pati dengan campuran bahan pangan lain.",
    "Aktif",
  ],
  [
    "060601",
    "Tepung Bumbu",
    "Tepung bumbu adalah campuran tepung, serpihan atau hancuran serealia atau biji-bijian yang jika dikombinasikan dengan bahan lain dapat digunakan sebagai pelapis ikan, daging unggas, dan pangan lainnya. Tidak termasuk adonan (contohnya untuk produk bakeri)",
    "Aktif",
  ],
  [
    "060602",
    "Tepung Bakso",
    "Tepung bakso adalah campuran tepung (dapat berupa tepung gandum atau pati tapioka) dengan atau penambahan bahan pangan lain. Digunakan untuk membuat adonan bakso dengan<br> penambahan daging giling.",
    "Aktif",
  ],
  [
    "060603",
    "Tepung Pelapis",
    "Tepung Pelapis adalah campuran tepung, serpihan atau hancuran serealia atau biji-bijian, yang dapat dikombinasikan dengan bahan lain (seperti telur, air, susu) dapat digunakan sebagai pelapis bahan pangan hewani (daging sapi, daging unggas, daging ikan atau hasil laut lainnya (udang, cumi, dan lainnya), dan bahan pangan nabati (pisang, umbi-umbian, sayur-sayuran).",
    "Aktif",
  ],
  [
    "060604",
    "Tepung Bakwan",
    "Tepung bakwan adalah campuran tepung (dapat berupa tepung gandum atau tepung tapioka) dengan bahan pangan dan bahan tambahan pangan lainnya. Digunakan untuk membuat bakwan dengan penambahan bahan pangan lainnya seperti telur, air, sayuran (wortel, tauge, kubis, dan lainnya).",
    "Aktif",
  ],
  [
    "060605",
    "Tepung Bakso",
    "Tepung bakso adalah campuran tepung (dapat berupa tepung gandum atau pati tapioka) dengan atau penambahan bahan pangan lainnya. Digunakan untuk membuat adonan bakso dengan penambahan daging giling.",
    "Tidak Aktif",
  ],
  [
    "060701",
    "Dodol/Jenang/Gelamai",
    "Dodol/jenang /gelamai adalah produk pangan yang diperoleh dari tepung beras ketan, santan kelapa dan gula dengan atau tanpa penambahan bahan makanan lain dimasak hingga mencapai tekstur yang diinginkan.",
    "Aktif",
  ],
  [
    "06070101",
    "Nasi Beku",
    "Nasi instan adalah produk olahan beras yang telah dimasak menjadi nasi kemudian disimpan pada suhu dingin/beku. Produk ini tidak ditambahkan kacang-kacangan, ikan, daging, sayur dan/atau bahan pelengkap lainnya.",
    "Aktif",
  ],
  [
    "060703",
    "Kue Mochi",
    "Kue mochi adalah produk khas Jepang yang terbuat dari tepung beras ketan, dibentuk, dan ditaburi dengan tepung maizena atau wijen.",
    "Aktif",
  ],
  [
    "060704",
    "Kue Teuck/Tteok",
    "Kue teuck/tteok adalah kue khas Korea yang dibuat dari serealia terutama beras atau beras ketan.",
    "Aktif",
  ],
  [
    "060709",
    "Kue Mangkok (dari Tepung Beras)",
    "Kue mangkok adalah produk roti kukus berbentuk mangkok yang dibuat dari tepung beras yang terlebih dahulu difermentasi dengan ragi atau air soda atau tape.",
    "Aktif",
  ],
  [
    "060710",
    "Jongkong Kelapa Muda",
    "Jongkong kelapa muda adalah produk pangan berbahan dasar tepung beras dalam bentuk adonan, dimasak, dibungkus bersama daun pandan, gula merah, daging buah kelapa dan santan dengan daun pisang atau lainnya dan dikukus hingga matang.",
    "Aktif",
  ],
  [
    "060711",
    "Talam Ebi",
    "Talam ebi adalah produk pangan berbahan dasar tepung beras yang dimasak dengan santan, gula dan bahan lainnya hingga membentuk adonan. Adonan terdiri dari 2 lapisan, dicetak, dikukus dan diberi taburan ebi diatasnya.",
    "Aktif",
  ],
  [
    "060712",
    "Kue Lapis Beras",
    "Kue lapis beras adalah produk pangan berbahan dasar tepung beras<br> yang dimasak dengan tepung sagu, santan, gula pasir, dan bahan<br> lainnya hingga membentuk adonan. Adonan dibagi menjadi<br> beberapa bagian yang berbeda warna, dicetak didalam loyang,<br> dikukus dengan beberapa tahap pelapisan.",
    "Aktif",
  ],
  [
    "060713",
    "Juadah Kering/Mayang Papan",
    "Juadah kering/mayang papan adalah produk pangan berbahan<br> dasar tepung beras yang telah disanggrai dan digoreng hingga<br> matang. Pelapis juadah dibuat dari campuran air, gula merah/gula<br> palem, gula pasir, vanili, durian dan bahan lainnya yang dimasak<br> sampai kental. Juadah kemudian dimasukkan ke dalamnya, diaduk<br> cepat sampai gula menempel pada juadah.",
    "Aktif",
  ],
  [
    "060714",
    "Petah",
    "Petah adalah produk pangan berbahan dasar tepung beras yang<br> dimasak dengan air, campuran air daun suji dan air kapur sirih dan<br> bahan lainnya hingga matang dan kental. Adonan kemudian<br> dituang dalam loyang, dikukus hingga matang dan dipotong<br> menurut selera. Petah disajikan dengan saus yang dibuat dari<br> santan yang direbus sampai matang.<br>",
    "Aktif",
  ],
  [
    "060727",
    "Kekicak/Gegicak",
    "Kekicak/gegicak adalah produk pangan berbahan dasar tepung ketan putih yang dimasak dengan air kapur sirih hingga membentuk adonan licin, dibentuk bulatan kecil, dalam loyang, bagian tengah dilubangi kemudian dikukus hingga matang. Kekicak<br> disajikan dengan taburan parutan kelapa muda dan saus gula merah.",
    "Aktif",
  ],
  [
    "060728",
    "Lalampa",
    "Lalampa adalah produk pangan berbahan dasar beras ketan putih yang dikukus bersama santan hingga matang kemudian dibungkus dengan daun pisang atau lainnya dengan isian ikan tongkol kemudian dipanggang hingga matang.",
    "Aktif",
  ],
  [
    "060729",
    "Katrisolo",
    "Katrisolo adalah produk pangan berbahan dasar beras ketan putih<br> yang dikukus dengan santan kental, daun pandan, garam dan<br> bahan lainnya. Setelah beras ketan putih dalam loyang cukup<br> panas, tuangkan kocokan tepung, gula, tepung beras dan dikukus<br> hingga matang. Dapat dipotong sesuai selera.",
    "Aktif",
  ],
  [
    "060730",
    "Eko Tukir",
    "Eko tukir adalah produk pangan berbahan dasar beras ketan putih yang dikukus dengan santan, dengan penambahan bawang merah, merica dengan atau tanpa bahan pangan lain.",
    "Tidak Aktif",
  ],
  [
    "060731",
    "Lapek Bugis",
    "Lapek bugis adalah produk pangan berbahan dasar tepung beras ketaLapek bugis adalah produk pangan berbahan dasar tepung beras<br> ketan hitam dan tepung ketan hitam yang dimasak dengan santan<br> sebagai adonan utama. Adonan isi dibuat dari kelapa parut, gula<br> pasir,vanili dan bahan lainnya yang dimasak sampai kelapa matang.<br> Adonan utama yang telah diiisi dengan adonan isi, diberi kuah<br> santan kelapa matang, dibungkus dengan daun pisang atau lainnya<br> dan dikukus. pangan lain.",
    "Aktif",
  ],
  [
    "060732",
    "Lamang",
    "Lamang adalah kue berbahan dasar beras dengan penambahan santan, garam dengan atau tanpa bahan lain, dimasukkan kedalam bambu yang berlapis daun pisang muda dan dibakar.",
    "Aktif",
  ],
  [
    "060733",
    "Kue Berbahan Dasar Beras Lainnya",
    "Kue berbahan dasar beras lainnya adalah kue yang berbahan dasar beras dan beras ketan baik dalam bentuk utuh maupun tepung. Contohnya : uli, buras, lontong, arem-arem, lupis, gendar, wingko, yangko, krasikan, dan lainnya.",
    "Aktif",
  ],
  [
    "060734",
    "Ombus-ombus",
    "Ombus-ombus adalah produk pangan berbahan dasar tepung beras putih yang dicampur dengan kelapa parut dan gula merah/gula putih. Campuran tersebut kemudian dimasukkan dalam helai daun pisang membentuk kerucut dan dikukus hingga matang.",
    "Aktif",
  ],
  [
    "060735",
    "Legomoro",
    "Legomoro adalah produk pangan berbahan dasar beras ketan putih yang dimasak dengan santan dan bahan pangan lain hingga membentuk adonan. Adonan kemudian diisi dengan daging cincang, dibungkus dengan daun pisang, diikat dan dikukus hingga matang.",
    "Aktif",
  ],
  [
    "06080101",
    "Sari Kedelai",
    "Sari kedelai adalah produk emulsi yang diekstrak dari kedelai yang telah direbus dan digiling dengan penambahan air. Kadar minimum protein (N x 6.25) tidak kurang dari 2% (b/v)",
    "Aktif",
  ],
  [
    "06080102",
    "Sari Kedelai Steril (Khusus Registrasi Ulang)",
    "\"Sari kedelai adalah produk emulsi yang diekstrak dari kacang kedelai<br> yang telah direbus dan digiling dengan penambahan air serta diproduksi secara steril komersil.\"<br>",
    "Aktif",
  ],
  [
    "06080103",
    "Serbuk Minuman Kedelai",
    "Serbuk minuman kedelai adalah produk berbentuk bubuk berbahan baku kedelai dengan atau tanpa penambahan bahan pangan lain, yang digunakan untuk minuman. Kadar minimum protein (N x 6.25) tidak kurang dari 0.8g/100g.",
    "Aktif",
  ],
  [
    "06080104",
    "Konsentrat Sari Kedelai",
    "Produk konsentrat dari emulsi yang diekstrak dari kedelai yang telah direbus dan digiling dengan penambahan air dan/atau penambahan bahan pangan lain. Cara mengkonsumsinya adalah cukup ditambahkan air.",
    "Aktif",
  ],
  [
    "06080201",
    "Kembang Tahu",
    "Kembang tahu adalah produk berupa lapisan tipis kering yang diperoleh dari pemanasan cairan yang didapat dari kedelai yang digiling dengan penambahan air.",
    "Aktif",
  ],
  ["06080202", "Kembang Tahu dalam Kaleng", "&nbsp;", "Aktif"],
  [
    "06080301",
    "Tahu",
    "Tahu adalah produk berupa padatan yang dibuat dari ekstrak kedelai melalui proses penggumpalan protein dengan penambahan koagulan. Tahu dapat memiliki tekstur yang beragam (seperti lembut, semi keras dan keras). Dapat ditambahkan bahan pangan lain. Kadar protein tidak kurang dari 9%",
    "Aktif",
  ],
  [
    "06080401",
    "Tahu Semi-Kering Yang Diolah Dengan Saus Kental",
    "Tahu semi kering yang dimasak (ditumis) dengan saus kental (misal saus miso). Tahu semi kering ini menyerap saus, sehingga memiliki tekstur seperti aslinya.",
    "Aktif",
  ],
  [
    "0608040203",
    "Tahu Semi-Kering Yang Digoreng Dengan Minyak Banyak (Deep Fried)",
    "Tahu semi kering yang digoreng dengan minyak banyak (deep fried). Tahu ini dapat langsung dikonsumsi atau dimasak lagi (contohnya dengan direndam dalam saus) setelah penggorengan. Termasuk dalam kategori ini tahu Sumedang dan tahu yang digunakan untuk pembuatan tahu isi.<br>",
    "Aktif",
  ],
  [
    "06080403",
    "Tahu semi-kering, selain dari kategori 06.8.4.1 dan 06.8.4.2",
    "",
    "Aktif",
  ],
  [
    "060805",
    "Tahu Kering",
    "Tahu yang seluruh kandungan airnya telah dikeluarkan. Dapat direkonstitusi dengan air atau saus untuk dapat dikonsumsi, atau dapat digunakan secara langsung dalam sebuah masakan. Selain itu dapat pula digoreng deep fried atau direndam dalam saus.",
    "Aktif",
  ],
  [
    "06080601",
    "Dou chi",
    "Dou chi adalah produk yang dibuat dari fermentasi dan penggaraman kedelai hitam dengan rasa dan aroma yang khas.<br>",
    "Aktif",
  ],
  [
    "06080602",
    "Natto",
    "Natto adalah produk kedelai yang diperoleh dari fermentasi kedelai yang memiliki penampakan berlendir, lengket dengan aroma khas.<br>",
    "Aktif",
  ],
  [
    "06080603",
    "Tempe",
    "Tempe kedelai adalah produk kedelai yang diperoleh dari fermentasi kedelai dengan menggunakan kapang Rhizopus sp, produk ini berbentuk padatan kompak dan berbau khas serta berwarna putih atau sedikit keabu-abuan.<br>",
    "Aktif",
  ],
  [
    "06080604",
    "Tauco",
    "Tauco adalah produk kedelai yang diperoleh dari hasil fermentasi kacang kedelai dalam larutan garam, berbau khas dengan atau tanpa penambahan bahan pangan lain.",
    "Tidak Aktif",
  ],
  [
    "06080605",
    "Tauco Steril",
    "Tauco adalah produk kedelai yang diperoleh dari kacang kedelai hasil fermentasi kacang kedelai dalam larutan garam, berbau khas dengan atau tanpa penambahan bahan pangan lainnya dan diproses secara steril.",
    "Tidak Aktif",
  ],
  [
    "06080606",
    "Tauco",
    "Tauco adalah produk kedelai yang diperoleh dari hasil fermentasi kacang kedelai dalam larutan garam, berbau khas dengan atau tanpa penambahan bahan pangan lain.",
    "Tidak Aktif",
  ],
  [
    "060807",
    "Tahu Fermentasi (Contohnya Keju Kedelai)",
    "",
    "Aktif",
  ],
  [
    "06080801",
    "Produk Protein Kedelai",
    "Produk protein kedelai adalah produk yang diperoleh dari proses pengurangan atau penghilangan komponen-komponen utama nonprotein (air, minyak, pati dan karbohidrat lain) dari kacang kedelai untuk mencapai kadar protein (N \xC3\x{2014} 5,71):<br> (1) Tepung protein kedelai 50% hingga 65%;<br> (2) Konsentrat protein kedelai 65% hingga 90%;<br> (3) Isolat protein 90% atau lebih;<br> Kadar protein dihitung terhadap bobot kering tanpa vitamin dan mineral yang ditambahkan. Ingredien yang dapat digunakan adalah karbohidrat termasuk gula, lemak dan minyak makan, produk protein lain, vitamin dan mineral, garam, herba dan rempah.<br> Karakteristik dasar:<br> Kadar air tidak lebih dari 10% (bk)",
    "Aktif",
  ],
  [
    "06080802",
    "Texturized Vegetable Protein (TVP)",
    "Texturized Vegetable Protein (TVP) adalah produk yang dibuat dari tepung protein kedelai, konsentrat protein kedelai, atau isolat protein kedelai melalui proses ekstrusi untuk menghasilkan tekstur mirip seperti daging.",
    "Aktif",
  ],
  [
    "0701010101",
    "Roti Buah/Roti Kismis/Roti Chocochips",
    "Roti buah/roti kismis/roti chocochips adalah produk roti dengan atau tanpa rempah, dengan penambahan buah kering, misalnya kismis, dan chocochips. Mengandung buah kering atau kismis tidak kurang dari 10% jumlah adonan.",
    "Aktif",
  ],
  [
    "0701010103",
    "Roti Kadet",
    "Roti kadet adalah produk roti yang dibuat untuk membuat roti lapis<br> (sandwich) atau untuk membuat roti isi (burger, hotdog, atau sosis).",
    "Aktif",
  ],
  [
    "0701010104",
    "Roti Tawar",
    "Roti tawar adalah produk roti yang adonannya terbuat dari tepung terigu, lemak, gula dan air yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang.<br> <br> Karakteristik dasar:<br> Kadar gula total tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "0701010105",
    "Roti Putih",
    "Roti putih adalah produk roti yang adonannya terbuat dari tepung gandum (sosoh penuh) dan air yang mengalami fermentasi oleh ragi (kamir) sebagai senyawa pengembang.",
    "Aktif",
  ],
  [
    "0701010106",
    "Roti Tawar Kupas",
    "Roti tawar kupas adalah roti tawar yang telah dikupas seluruh bagian kulitnya.<br> <br> Karakteristik dasar:<br> Kadar gula total tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "0701010107",
    "Roti Susu, Roll Susu, Bun Susu",
    "Roti susu, roll susu, bun susu adalah produk roti yang adonannya terbuat dari tepung terigu atau tepung terigu utuh, atau campurannya, padatan susu bukan lemak, lemak dan air yang mengalami fermentasi oleh ragi (kamir) sebagai senyawa pengembang dan atau bahan pengembang lain. Mengandung padatan susu bukan lemak tidak kurang dari 4% dari jumlah terigu.",
    "Aktif",
  ],
  [
    "0701010108",
    "Roti Wheat-Germ",
    "Roti wheat-germ adalah produk roti yang adonannya terbuat dari tepung terigu atau tepung terigu utuh atau campurannya, lemak, wheat germ (lembaga gandum), air dan yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang dan atau bahan pengembang lain. Kandungan wheatgerm tidak kurang dari 5% dari total tepung.",
    "Aktif",
  ],
  [
    "0701010109",
    "Roti Meal",
    "Roti meal adalah produk roti yang adonannya terbuat dari tepung serealia (meal) atau campuran tepung meal atau tepung terigu yang mengandung tidak kurang dari 60% tepung meal, lemak dan air yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang dan atau bahan pengembang lain.",
    "Aktif",
  ],
  [
    "0701010110",
    "Roti Meal Utuh (Whole Meal)",
    "Roti meal utuh (whole meal) adalah produk roti yang adonannya terbuat dari tepung serealia (meal) utuh, lemak dan air yang mengalami fermentasi oleh ragi (kamir) sebagai senyawa pengembang dan atau bahan pengembang lain.",
    "Aktif",
  ],
  [
    "0701010111",
    "Roti Gandum Utuh (WholeWheat)",
    "Roti gandum utuh (wholewheat) adalah produk roti yang adonannya terbuat dari tepung gandum utuh, lemak, gula, dan air yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang.<br> <br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Kadar gula total tidak lebih dari 5%<br> \xE2\x{20AC}\xA2 Kadar tepung gandum utuh tidak kurang dari 10% dari total tepung<br>",
    "Aktif",
  ],
  [
    "0701010112",
    "Roti Rye",
    "Roti rye adalah produk roti yang adonannya terbuat dari campuran tepung rye dan tepung terigu, lemak dan air yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang dan atau bahan pengembang lain. Tepung rye tidak lebih dari 70% tepung terigu.",
    "Aktif",
  ],
  [
    "0701010113",
    "Roti Pumpernickel",
    "Roti pumpernickel adalah produk roti yang yang adonannya terbuat dari campuran tepung terigu, tepung cornmeal, tepung rye, dan/atau tepung lain dengan penambahan rempah fennel atau biji jinten (caraway), lemak dan air yang mengalami fermentasi oleh ragi (kamir) dan atau bahan pengembang lain.",
    "Aktif",
  ],
  ["0701010114", "Bread Stick", "-", "Aktif"],
  [
    "0701010115",
    "Roti Tawar dengan penambahan bahan pangan lain",
    "Roti tawar adalah produk roti yang adonannya terbuat dari tepung terigu, lemak, gula dan air yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang dengan penambahan bahan pangan lain.<br> Nama jenis untuk kategori ini misalnya roti tawar pandan (yang ditambahkan ekstrak pandan dan berwarna hijau), roti tawar cokelat (yang diberi bubuk cokelat), roti tawar dengan chocochips, roti tawar dengan kismis.<br> <br> Karakteristik dasar :<br> Kadar gula total tidak lebih dari 5%<br> Bahan pangan lain yang ditambahkan tidak lebih dari 10%<br>",
    "Aktif",
  ],
  [
    "0701010116",
    "Roti Campuran Tepung Terigu dan Kulit Gandum / Roti dengan Kulit Gandum (Fine Bran)",
    "Roti Campuran Tepung Terigu dan Kulit Gandum / Roti dengan Kulit Gandum adalah produk roti yang adonannya terbuat dari campuran tepung terigu, kulit gandum (fine bran), lemak, gula, dan air yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang.<br> <br> Karakteristik dasar :<br> Kadar gula total tidak lebih dari 5%<br> Kulit gandum yang ditambahkan tidak kurang dari 2% dari total tepung<br>",
    "Aktif",
  ],
  [
    "0701010117",
    "Roti Perancis (Baguette/pain courant francais)",
    "Roti Perancis adalah produk roti berbentuk memanjang dengan tekstur keras yang adonannya terbuat dari tepung terigu atau terigu yang dicampur dengan kulit gandum, lemak, gula dan air yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang.<br> Karakteristik dasar :<br> Kadar gula total tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "0701010118",
    "Roti Malt",
    "Roti Malt adalah produk roti yang adonannya terbuat dari tepung gandum, ekstrak malt, lemak, gula dan air yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang.",
    "Aktif",
  ],
  [
    "0701010119",
    "Roti Kadet Gandum",
    "Roti kadet gandum adalah produk roti kadet yang dibuat dari tepung gandum utuh atau campuran tepung terigu dan kulit gandum (fine bran).",
    "Aktif",
  ],
  [
    "0701010120",
    "Roti Kadet Susu",
    "Roti kadet susu adalah produk roti yang adonannya terbuat dari tepung terigu atau tepung terigu utuh, atau campurannya, padatan susu bukan lemak, lemak dan air yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang dan atau bahan pengembang lain.<br> <br> Karakteristik dasar:<br> Mengandung padatan susu bukan lemak tidak kurang dari 4% dari jumlah terigu",
    "Aktif",
  ],
  [
    "0701010201",
    "Roti Soda",
    "Roti soda adalah produk roti yang dibuat dengan bahan pengembang selain ragi (kamir) yaitu senyawa pengembang kimia seperti baking powder atau baking soda, juga disebut sebagai quickbread.",
    "Aktif",
  ],
  [
    "070101A0",
    "Roti",
    "Roti adalah produk pangan yang diperoleh dengan memanggang adonan yang diperoleh dari tepung terigu dan/atau tepung lain, air, lemak dan bahan lainnya yang mengalami fermentasi oleh ragi (kamir).",
    "Tidak Aktif",
  ],
  [
    "07010201",
    "Krekers",
    "Krekers adalah jenis biskuit yang dalam pembuatannya memerlukan proses fermentasi atau tidak, serta melalui proses laminasi sehingga menghasilkan bentuk pipih dan bila dipatahkan penampangnya tampak berlapis-lapis.<br> Karakteristik dasar :<br> Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "07010202",
    "Krekers Krim",
    "Krekers krim adalah jenis krekers fermentasi yang pada proses laminasinya menggunakan cracker dust di antara lapisan-lapisannya.<br> <br> Karakteristik dasar :<br> Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "07010203",
    "Krekers Sandwich",
    "Krekers sandwich adalah jenis krekers dengan menggunakan krim filling (rasa keju, rasa coklat, rasa buah, dan lain-lain) sedikitnya terdiri dari 2 (dua) keping krekers.",
    "Tidak Aktif",
  ],
  [
    "07010204",
    "Malkist",
    "Malkist adalah krekers krim yang permukaannya ditaburi gula.",
    "Tidak Aktif",
  ],
  [
    "07010205",
    "Water Biscuit",
    "Water biscuit adalah jenis krekers non-fermentasi yang pada proses laminasinya tidak menggunakan cracker dust, lemak atau pengisi apapun di antara lapisan-lapisannya.",
    "Aktif",
  ],
  [
    "07010206",
    "Krekers Soda",
    "Krekers soda adalah produk bakeri tipis, renyah dan tidak manis yang adonannya terbuat dari tepung terigu dan air yang dibuat dengan bahan pengembang selain ragi (kamir) yaitu senyawa pengembang kimia seperti baking powder atau baking soda, dan melalui proses laminasi berlapis-lapis lalu dipanggang sehingga ada rongga didalamnya",
    "Aktif",
  ],
  [
    "07010207",
    "Krekers Gurih (Savoury Cracker), Snack Cracker",
    "Krekers gurih (savoury cracker), snack cracker adalah jenis krekers sedikit manis atau asin, yang pada proses pembuatannya menggunakan enzim, sehingga memiliki tekstur yang berongga, sangat renyah dan produk akhirnya dapat divariasikan dengan disemprot mi",
    "Aktif",
  ],
  [
    "07010301",
    "Biskuit",
    "Biskuit adalah sejenis roti soda atau shortened bread atau quickbread yang adonannya terbuat dari tepung terigu, mentega/margarin, telur, susu dan sedikit gula pasir. Biskuit berukuran kecil, ringan, berserpih (flaky) dengan crust (kulit) berwarna emas.",
    "Tidak Aktif",
  ],
  [
    "07010302",
    "Bagel",
    "Bagel adalah sejenis roti berbentuk cincin dengan tekstur liat dan padat dengan rasa tawar yang adonannya dapat dibuat dari tepung terigu atau rye. Bagel juga dapat ditambah antara lain kismis dan buah kecil atau kacang, sayur, bawang, dan sebagainya.",
    "Aktif",
  ],
  [
    "07010303",
    "Roti Pita",
    "Roti pita adalah roti berbentuk lingkaran atau oval dan relatif tipis (pipih), lembut, dan bagian tengahnya berongga.",
    "Aktif",
  ],
  [
    "07010304",
    "Muffin Inggris (English Muffin)",
    "Muffin inggris (english muffin) adalah sejenis roti yang menggunakan kamir sebagai bahan pengembang, dibentuk bulat dimasak diatas pemanggang lalu dibelah dua. Permukaannya datar dengan warna kecoklatan di bagian luar dan berpori di dalamnya.",
    "Aktif",
  ],
  [
    "07010305",
    "Shortened Bread",
    "Shortened bread atau quickbread adalah produk sejenis biskuit yang<br> adonannya terbuat dari tepung terigu, mentega/margarin, telur,<br> susu dan sedikit gula pasir, dibuat dengan baking powder atau<br> baking soda, berukuran kecil, ringan, berserpih (flaky) dengan crust<br> (kulit) berwarna emas",
    "Aktif",
  ],
  [
    "07010306",
    "Roti Canai/Roti Cane/Roti Kane/Roti Kanai/Roti Maryam",
    "Roti canai/roti cane/roti kane/roti kanai/roti maryam adalah roti<br> berbentuk lingkaran, tipis (pipih), lembut, dibuat dengan cara<br> diputar hingga tipis, atau bisa pula dengan menebarkan adonan<br> setipis mungkin di atas panggangan, dapat dilipat, dipanggang<br> dengan sedikit minyak atau margarin. Roti ini biasanya dikonsumsi<br> dengan kari atau dikonsumsi langsung dengan penambahan bahan<br> pangan lain seperti cokelat, stroberi, keju, dan lain-lain",
    "Aktif",
  ],
  [
    "07010307",
    "Roti Jala",
    "Roti Jala adalah roti yang dibuat dengan cara menyemprotkan adonan membentuk jala atau renda, dipanggang dengan sedikit minyak atau margarin, dilipat, digulung, atau dibentuk lain. Roti ini biasanya dikonsumsi dengan kari atau masakan lain.<br>",
    "Aktif",
  ],
  ["07010308", "Tortilla", "-", "Aktif"],
  [
    "07010401",
    "Crouton",
    "Crouton adalah potongan roti tawar berbentuk kubus atau bentuk lain, dapat dioles mentega atau bahan pangan lain, lalu dipanggang hingga kering. Pada umumnya disajikan bersama sup",
    "Aktif",
  ],
  [
    "07010402",
    "Tepung Panir",
    "Tepung panir adalah produk yang diperoleh dari roti tawar yang dikeringkan dengan oven lalu digiling. Umumnya digunakan untuk menyalut bahan pangan lain untuk digoreng.",
    "Aktif",
  ],
  [
    "07010403",
    "Tepung Roti / Bread Crumb",
    "Tepung Roti/Bread crumb adalah roti tawar yang dihancurkan menjadi serpihan lalu dikeringkan, berukuran kasar (lebih kasar dari tepung panir) untuk menyalut bahan pangan lain dengan formulasi yang sesuai peruntukannya.",
    "Aktif",
  ],
  [
    "07010404",
    "Roti Untuk Stuffing",
    "Roti untuk stuffing adalah semacam crouton yang digunakan untuk mengisi karkas kalkun/karkas unggas atau karkas lain untuk dipanggang.",
    "Aktif",
  ],
  [
    "07010405",
    "Premiks Untuk Stuffing",
    "Premiks untuk stuffing adalah campuran tepung dan bahan pangan lain untuk pembuatan roti untuk stuffing.",
    "Aktif",
  ],
  [
    "07010406",
    "Adonan Shortened Bread",
    "Adonan Shortened Bread adalah adonan siap panggang untuk membuat Shortened Bread seperti dimaksud dalam kategori 07.1.3.",
    "Aktif",
  ],
  [
    "07010501",
    "Mantao",
    "Mantao adalah produk roti kukus tanpa isi.",
    "Aktif",
  ],
  [
    "07010502",
    "Bakpao/Pao",
    "Bakpao / pao adalah produk roti kukus yang diisi dengan daging, kacang, atau bahan pangan lain.",
    "Aktif",
  ],
  [
    "07010503",
    "Apem",
    "Apem adalah roti kukus yang dibuat dari tepung beras dan gula yang terlebih dahulu difermentasi dengan ragi atau tape.",
    "Aktif",
  ],
  [
    "07010504",
    "Bolu Kukus",
    "Bolu kukus adalah produk bakeri kukus berbentuk mangkok yang dibuat dari tepung terigu yang terlebih dahulu difermentasi dengan ragi atau tape atau dengan penambahan bahan pengembang.",
    "Tidak Aktif",
  ],
  [
    "07010505",
    "Bun Kukus",
    "Bun kukus adalah roti oriental yang diperoleh dari tepung terigu atau tepung beras yang diolah dengan pengukusan. Dengan atau tanpa isi (daging, jam)<br>",
    "Aktif",
  ],
  [
    "07010601",
    "Premiks Untuk Roti Tawar Dan Produk Bakeri Tawar",
    "Premiks untuk roti dan produk bakeri tawar adalah campuran bahan kering yang bisa ditambahkan dengan ingredien basah (seperti air, susu, minyak, mentega, telur) untuk membuat adonan untuk produk bakeri dari kategori 07.1.1, 07.1.2, 07.1.3, 07.1.4 dan 07.1.5<br>",
    "Aktif",
  ],
  [
    "07020101",
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie)",
    "Keik (cake), kukis (cookies) dan pai (pie) adalah produk bakeri yang dapat digunakan sebagai hidangan penutup atau pencuci mulut.",
    "Aktif",
  ],
  [
    "07020102",
    "Keik (Cake)",
    "Keik (cake) adalah produk bakeri manis yang dibuat dari adonan yang terdiri dari tepung terigu, gula, telur, dan bahan pangan lainnya. Adonan umumnya dituang ke dalam cetakan untuk dipanggang atau dikukus.",
    "Aktif",
  ],
  [
    "07020103",
    "Keik Mentega (Butter Cake)",
    "Keik mentega (butter cake) adalah keik yang mengandung mentega atau lemak lainnya (margarin, shortening), berperisa, dengan tekstur dan volume yang baik. Keik mentega merupakan bentuk pengembangan dari pound cake. Keik mentega dapat juga ditambah dengan taburan gula, frosting (icing), kacang dan sebagainya.",
    "Aktif",
  ],
  [
    "07020104",
    "Keik Keju (Cheese Cake)",
    "Keik keju (cheese cake) adalah keik yang dibuat dengan keju, keju krim (cream cheese), keju cottage atau keju ricotta yang dicampur dengan telur, gula, dan bahan pangan lainnya. Kulitnya dapat dibuat dari gilingan krekers, kacang atau pastri.",
    "Aktif",
  ],
  [
    "07020105",
    "Keik Pound (Pound Cake Atau Quatre Quarts)",
    "Keik pound (pound cake atau quatre quarts) adalah keik yang dibuat dari 1 pound (lbs=454 g) tepung terigu, 1 pound gula, 1 pound mentega dan 1 pound telur.",
    "Aktif",
  ],
  [
    "07020107",
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers",
    "Biskuit (manis) atau kukis atau sweet crackers adalah produk bakeri kering yang dibuat dengan cara memanggang adonan yang terbuat dari lemak dan bahan pengembang dengan atau tanpa bahan pangan lainnya. Termasuk snack biscuit atau biskuit yang bentuknya ke",
    "Aktif",
  ],
  [
    "07020108",
    "Biskuit Marie",
    "Biskuit marie adalah sejenis biskuit manis dengan penambahan<br> perisa khas marie, dibuat dari tepung terigu, air atau susu, dan<br> dapat ditambahkan bahan pangan lainnya.<br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Rasa dan warna normal<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "07020109",
    "Biskuit Marie Salut / Biskuit Salut",
    "Biskuit marie salut / biskuit salut adalah biskuit marie / biskuit yang diberi salutan coklat atau bahan pangan lain di bagian luarnya.",
    "Aktif",
  ],
  [
    "07020110",
    "Roti Bagelen",
    "Roti bagelen adalah roti yang dipanggang setelah dioles dengan lemak dan gula atau krim, dan dapat ditambahkan bahan pangan lainnya.",
    "Aktif",
  ],
  [
    "07020112",
    "Wafer",
    "Wafer adalah sejenis biskuit5 manis yang dibuat dari adonan cair, berporipori kasar, renyah dan bila dipatahkan penampang potongannya berongga.",
    "Aktif",
  ],
  [
    "07020113",
    "Wafer Roll / Wafer Stick",
    "Wafer roll/wafer stick adalah sejenis biskuit manis yang dibuat dari adonan cair, berbentuk roll dengan atau tanpa isi, dan renyah.",
    "Aktif",
  ],
  [
    "07020114",
    "Wafer Salut",
    "Wafer salut adalah sejenis wafer yang diberi salutan cokelat atau<br> bahan pangan lain di bagian luarnya",
    "Aktif",
  ],
  [
    "07020115",
    "Kukis",
    "Kukis adalah jenis biskuit yang terbuat dari adonan lunak, renyah dan bila dipatahkan penampangnya tampak bertekstur kurang padat.<br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Rasa dan warna normal<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "07020116",
    "Kukis Gula",
    "Kukis gula adalah jenis biskuit manis yang terbuat dari adonan lunak, berkadar lemak tinggi, renyah dan bila dipatahkan penampang potongannya bertekstur kurang padat serta pada permukaan terdapat taburan gula.",
    "Aktif",
  ],
  ["07020117", "Kukis Oatmeal", "", "Aktif"],
  [
    "07020118",
    "Bika Ambon",
    "Bika ambon adalah sejenis kue yang dibuat dari pati sagu atau tapioka dan tepung terigu serta santan yang difermentasi dengan<br> kamir atau bahan lain melalui proses pemanggangan",
    "Aktif",
  ],
  ["07020119", "Serabi", "", "Aktif"],
  [
    "07020126",
    "Egg Roll",
    "Egg roll adalah jenis kukis gulung dengan kadar telur tidak kurang dari 35%.",
    "Aktif",
  ],
  [
    "07020127",
    "Biskuit Colek",
    "Biskuit Colek adalah biskuit yang dilengkapi dengan krim cokelat atau krim lainnya yang dikonsumsi dengan cara dicolek",
    "Aktif",
  ],
  [
    "07020128",
    "Biskuit Lapis/Biskuit Sandwich",
    "Biskuit lapis/Biskuit Sandwich adalah biskuit yang terdiri dari 2 lapis atau lebih dan diantara lapisan diberi isi. Jika produknya disalut, nama jenisnya adalah biskuit lapis salut. Contoh dari produk ini biskuit lapis salut cokelat.",
    "Aktif",
  ],
  ["07020129", "Kue Berbahan Dasar Terigu", "-", "Aktif"],
  [
    "07020130",
    "Biskuit Bar Sereal Isi",
    "Biskuit bar sereal isi adalah sejenis biskuit manis berbentuk bar yang diisi dengan hasil olahan buah, cokelat, kacang atau lainnya.",
    "Aktif",
  ],
  [
    "07020131",
    "Brownies",
    "Brownies adalah jenis keik yang dibuat dari adonan tepung terigu atau tepung lainnya, gula, telur, cokelat, dan bahan pangan lainnya. Adonan dipanggang atau dikukus.",
    "Aktif",
  ],
  [
    "07020132",
    "Biskuit non terigu",
    "Biskuit non terigu adalah produk bakeri kering yang dibuat dengan cara memanggang adonan yang terbuat dari non terigu, minyak/lemak, dengan atau tanpa penambahan bahan pangan lain.<br> Nama jenis untuk produk ini, misalnya biskuit beras, biskuit jagung, dan lain-lain.<br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Rasa dan warna normal<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%<br>",
    "Aktif",
  ],
  [
    "07020133",
    "Kukis Lunak (Soft Cookies)",
    "Kukis lunak adalah jenis kukis yang bertekstur lunak.<br> Karakteristik dasar :<br> Kadar air berkisar lebih dari 5 % dan tidak lebih dari 10 %",
    "Aktif",
  ],
  [
    "07020134",
    "Nastar",
    "Nastar adalah jenis kukis yang berbentuk bulat atau bentuk lainnya dan diisi dengan selai nanas atau bahan pangan lainnya.<br> Karakteristik dasar :<br> Kadar air berkisar lebih dari 5% dan tidak lebih dari 10%",
    "Aktif",
  ],
  [
    "07020135",
    "Kastengel",
    "Kastengel adalah jenis kukis yang dibuat dengan penambahan keju, baik dalam adonannya atau ditaburkan.<br> Karakteristik dasar :<br> Kadar air tidak lebih dari 10%",
    "Aktif",
  ],
  [
    "07020136",
    "Pai",
    "Pai adalah jenis biscuit berserpih (flaky) yang dibuat dari adonan<br> dilapis dengan lemak padat atau emulsi lemak, sehinga<br> mengembang selama pemanggangan dan bila dipatahkan<br> penampangnya tampak berlapis-lapis. Yang termasuk pai adalah<br> puff.<br> Karakteristik dasar:<br> Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "07020137",
    "Pai Isi",
    "Pai isi adalah jenis pai yang diisi dengan selai, cokelat atau bahan pangan lainnya.<br> Karakteristik dasar : Kadar air berkisar lebih dari 5 % dan tidak lebih dari 10 %",
    "Aktif",
  ],
  [
    "07020138",
    "Bolu Kukus",
    "Bolu kukus adalah produk bakeri kukus berbentuk mangkok,<br> ataubentuk lainnya yang dibuat dari tepung terigu dengan<br> penambahan bahan pengembang.<br>",
    "Aktif",
  ],
  [
    "07020139",
    "Biskuit",
    "Biskuit adalah produk bakeri kering yang dibuat dengan cara memanggang adonan yang terbuat dari tepung terigu dengan atau tanpa substitusinya, minyak/lemak, dengan atau tanpa penambahan bahan pangan lain.<br> Karakteristik dasar :<br> Rasa dan warna normal<br> Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "07020142",
    "Crepes",
    "Crepes adalah produk sejenis panekuk tipis, dapat digulung atau dilipat, terbuat dari terigu, renyah, diberi isi atau tidak.",
    "Aktif",
  ],
  [
    "07020201",
    "Pastri",
    "Pastri adalah produk bakeri yang ringan dan berserpih (flaky) yang dibuat dari adonan dilapis dengan mentega atau lemak padat lainnya secara berulang-ulang sehingga mengembang selama pemanggangan di oven.",
    "Aktif",
  ],
  [
    "07020202",
    "Roti Manis",
    "Roti manis adalah produk roti yang memiliki rasa manis, adonannya terbuat dari tepung terigu, garam dan gula, yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang.",
    "Aktif",
  ],
  [
    "07020203",
    "Roti Isi",
    "Roti isi adalah produk roti dengan kadar gula tidak kurang dari 15% dan diisi dengan bahan lain seperti keju, cokelat, selai, krim dan lain-lain.",
    "Aktif",
  ],
  [
    "07020204",
    "Scone",
    "Scone adalah biskuit (definisi Codex) yang adonannya mengandung lebih banyak gula.",
    "Aktif",
  ],
  [
    "07020205",
    "Donat",
    "Donat adalah kue berbentuk cincin atau bentuk bulat lainnya yang adonannya difermentasi dengan ragi atau bahan pengembang lainnya kemudian digoreng.",
    "Aktif",
  ],
  [
    "07020206",
    "Muffin Amerika (American Muffin)",
    "Muffin amerika (american muffin) atau muffin (di Indonesia) adalah sejenis quickbread berbentuk mangkok.",
    "Aktif",
  ],
  [
    "07020207",
    "Roti Buaya",
    "Roti buaya adalah produk roti khas Betawi yang berbentuk seperti buaya",
    "Aktif",
  ],
  [
    "07020208",
    "Kue Tambang",
    "Kue berbentuk seperti untaian tali yang dibuat dari adonan terigu<br> yang digoreng.",
    "Aktif",
  ],
  ["07020209", "Pizza", "-", "Aktif"],
  [
    "07020210",
    "Bakpia",
    "Produk bakeri yang adonannya dibuat dari tepung terigu, air, lemak/minyak, dan isinya terbuat dari campuran gula dan kacang hijau yang dihaluskan, lalu dipanggang. Isi bakpia dapat diganti dengan cokelat, selai buah, atau bahan pangan lainnya.",
    "Aktif",
  ],
  [
    "07020211",
    "Wafel",
    "Wafel adalah kue yang dibuat dari adonan terigu yang dicetak diantara dua plat logam yang umumnya bermotif persegi.",
    "Aktif",
  ],
  [
    "07020212",
    "Stroopwafel",
    "Stroopwafel adalah sejenis wafel yang terdiri dari dua lapisan tipis berisi sirup karamel.",
    "Aktif",
  ],
  [
    "07020213",
    "Cone untuk Es Krim",
    "Cone untuk es krim adalah sejenis wafer yang berbentuk corong digunakan sebagai wadah es krim.<br>",
    "Aktif",
  ],
  [
    "07020214",
    "Panekuk",
    "Panekuk adalah kue berbentuk bundar tipis yang umumnya dibuat dari tepung terigu, gula, telur, susu dan dipanaskan pada permukaan yang panas.<br>",
    "Aktif",
  ],
  [
    "07020215",
    "Bolu Emprit",
    "Kue kering tradisional yang terbuat dari adonan tapioka, gula pasir, kelapa parut dan pengembang yang dicetak dan dipanggang.<br>",
    "Aktif",
  ],
  ["07020216", "Remahan Biskuit", "-", "Aktif"],
  ["07020217", "Nopia", "", "Tidak Aktif"],
  [
    "07020301",
    "Premiks Untuk Produk Bakeri Istimewa",
    "Premiks untuk produk bakeri istimewa adalah campuran bahan kering yang dapat ditambahkan dengan ingredien basah (seperti air, susu, minyak, mentega, telur) untuk membuat adonan untuk pembuatan produk bakeri.",
    "Aktif",
  ],
  [
    "08010201",
    "Patties Daging Sapi Segar (Burger)",
    "Patties daging sapi segar (burger) adalah produk yang terbuat dari hasil pencincangan daging mamalia dengan atau tanpa tambahan bahan tambahan pangan lain (seperti tepung, air, bumbu dan rempah, dan bahan tambahan pangan seperti bahan pengikat dan sebagai<br>",
    "Tidak Aktif",
  ],
  ["08010202", "Boerewors", "", "Tidak Aktif"],
  [
    "08010203",
    "Sosis Mentah Daging Babi",
    "Sosis mentah daging babi adalah sosis yang dibuat dari hasil penghalusan tetelan daging babi, dengan penambahan garam dan rempah-rempah.",
    "Aktif",
  ],
  [
    "08010204",
    "Sosis Mentah (Breakfast Sausage)",
    "Sosis mentah (breakfast sausage) adalah sosis yang dibuat dari hasil penghalusan daging selain daging babi dan bahan-bahan lain selain babi, dengan penambahanan garam dan rempah-rempah.",
    "Tidak Aktif",
  ],
  [
    "08010205",
    "Daging Cincang",
    "Daging cincang adalah daging mentah yang telah dikecilkan ukurannya dengan dicincang atau dicacah.",
    "Aktif",
  ],
  [
    "08010206",
    "Daging Giling",
    "Daging giling adalah daging yang dikecilkan ukurannya dengan alat grinder/mincer.",
    "Aktif",
  ],
  [
    "08010207",
    "Daging Murni Giling Tanpa Lemak",
    "Daging murni giling tanpa lemak adalah daging murni (lean meat)<br> yang dikecilkan ukurannya dengan alat grinder/mincer. Daging<br> cincang atau daging giling yang dinyatakan sebagai daging murni<br> giling tanpa lemak tidak boleh mengandung total lemak lebih dari 7%.<br> Misal Breakfast Sausage<br>",
    "Aktif",
  ],
  [
    "08010208",
    "Sosis Mentah Tanpa Fermentasi (Loganiza)",
    "Sosis mentah tanpa fermentasi (loganiza) adalah sosis yang dibuat dari daging tanpa fermentasi dan dikonsumsi dalam keadaan mentah.",
    "Tidak Aktif",
  ],
  ["08010209", "Bakso Daging Mentah", "", "Tidak Aktif"],
  [
    "08010210",
    "Potongan Daging Unggas dan Daging Hewan Buruan Yang Dilepaskan Dari Tulangnya, Digiling Mekanik dan Dibentuk (Dengan atau Tanpa Pembaluran atau Pelapisan)",
    "",
    "Aktif",
  ],
  [
    "08010211",
    "MDM (Mechanically Deboned Meat)",
    "MDM (Mechanically Deboned Meat) adalah daging yang dihasilkan dari pemisahan daging yang menempel pada tulang dengan perlakuan mekanis.",
    "Aktif",
  ],
  [
    "08010212",
    "Sosis Segar",
    "Sosis segar adalah sosis yang terbuat dari daging mentah dengan kadar daging tidak kurang dari 50%, tidak dikuring dengan nitrit, dihaluskan (umumnya kasar), tidak diemulsifikasi, diberi garam fosfat dan bumbu dan dikemas dalam selongsong sosis, tidak har",
    "Tidak Aktif",
  ],
  [
    "08010213",
    "Sosis Mentah (Sosis Daging)",
    "Sosis mentah adalah sosis yang dibuat dari hasil penghalusan daging<br> mamalia dan atau unggas, selain daging babi dengan penambahan<br> garam dan rempah-rempah antara lain : sosis breakfast mentah<br>",
    "Aktif",
  ],
  [
    "08010214",
    "Sosis Mentah (Sosis Daging Kombinasi)",
    "Sosis mentah adalah sosis yang dibuat dari hasil penghalusan daging<br> mamalia dan atau unggas, selain daging babi dengan penambahan<br> garam dan rempah-rempah antara lain : sosis breakfast mentah<br>",
    "Aktif",
  ],
  [
    "08010215",
    "DMM (Desinewed Minced Meat)",
    "DMM (Desinewed Minced Meat) adalah daging yang dihasilkan dari<br> pemisahan daging yang menempel pada tulang dengan perlakuan<br> mekanis, menghasilkan produk yang lebih kasar dari MDM.",
    "Aktif",
  ],
  [
    "08010216",
    "Patties",
    "Patties adalah produk yang terbuat dari hasil pencincangan daging mamalia dan atau unggas dengan atau tanpa penambahan bahan pangan lain (seperti tepung, air, bumbu dan rempah). Campuran dicetak atau diisikan dalam selongsong plastik dan didinginkan atau dibekukan sebagian sebelum diiris membentuk bulat atau bentuk lainnya.",
    "Aktif",
  ],
  [
    "0802010101",
    "Bacon",
    "Bacon (yang di-curing, di-curing kering, di-curing rendam, di-curing<br> injeksi) adalah daging babi yang di-curing dari bagian iga (belly bacon).<br> Bacon dapat diasap maupun tidak diasap.",
    "Aktif",
  ],
  [
    "0802010102",
    "Bacon Sapi",
    "Bacon sapi adalah produk olahan daging sapi yang dilakukan curing,<br> pengasapan yang berasal dari bagian sandung lamur (brisket) sapi,<br> dapat diasap maupun tidak diasap.",
    "Aktif",
  ],
  [
    "0802010104",
    "Daging Kornet Mentah",
    "Daging kornet mentah adalah produk yang dibuat dari potongan daging sapi segar atau beku (yang telah memenuhi persyaratan dan peraturan yang berlaku), tanpa tulang, boleh dicampur dengan daging bagian kepala dan hati dengan atau tanpa penambahan bahan lai",
    "Tidak Aktif",
  ],
  [
    "0802010105",
    "Daging Sapi yang Dimarinasi",
    "Daging sapi yang dimarinasi adalah potongan daging sapi yang direndam/dimarinasi dengan bumbu seperti garam dan rempah-rempah dengan cara perendaman, pengadukan atau injeksi.",
    "Aktif",
  ],
  [
    "0802010106",
    "Daging (Ayam, Bebek, Unggas lainnya) yang Dimarinasi",
    "Daging ayam yang dimarinasi adalah potongan daging ayam dengan atau tanpa tulang yang direndam / dimarinasi dengan bumbu seperti garam dan rempah-rempah dengan cara perendaman, pengadukan atau injeksi.",
    "Tidak Aktif",
  ],
  [
    "0802010107",
    "Berbagai Tipe Produk Pikel Daging Oriental : Daging Pikel Miso (Miso- Zuke), Daging Pikel Koji (Koji-Zuke), dan Daging Pikel Kecap (Shoyu-Zuke).",
    "",
    "Tidak Aktif",
  ],
  [
    "0802010108",
    "Daging Asap",
    "Daging asap adalah produk yang diperoleh dengan mengasapi daging<br> dan/atau daging curing atau olahannya dengan sumber asap yang<br> diizinkan (batangan kayu, serbuk gergaji, atau berupa pelet kayu dan<br> lainnya, cairan asap natural) yang bebas dari cat atau bahan<br> pengawet kayu.<br> Produk yang diasapkan juga dapat terbuat dari bagian selain daging,<br> misalnya lidah sapi.",
    "Aktif",
  ],
  [
    "0802010110",
    "Daging Sei",
    "Daging sei adalah produk olahan daging sapi tradisonal khas Kupang,<br> Nusa Tenggara Timur yang diolah dengan cara dicuring dan<br> dilanjutkan dengan pengasapan menggunakan bahan bakar kayu<br> kusambi (Scheiechera oleosa, Merr).",
    "Aktif",
  ],
  [
    "0802010111",
    "Daging Marinasi",
    "Daging marinasi adalah potongan daging yang berasal dari mamalia<br> dan unggas dengan atau tanpa tulang yang dimarinasi dengan<br> bumbu seperti garam dan rempah-rempah. Proses marinasi<br> dilakukan dengan cara perendaman, pengadukan atau injeksi.<br> Contohnya : sayap ayam marinasi, steik sapi marinasi, sate ayam<br> marinasi.",
    "Aktif",
  ],
  [
    "0802010112",
    "Daging Ayam yang Dimarinasi",
    "Daging ayam yang dimarinasi adalah potongan daging ayam dengan atau tanpa tulang yang direndam/dimarinasi dengan bumbu seperti garam dan rempah-rempah dengan cara perendaman, pengadukan atau injeksi. Termasuk yang ditusuk sate.",
    "Aktif",
  ],
  ["0802010201", "Daging Babi Asin Kering", "", "Tidak Aktif"],
  ["0802010202", "Jerky", "", "Tidak Aktif"],
  [
    "0802010203",
    "Daging Sapi Kering (Dried Beef)",
    "Daging sapi kering (dried beef) adalah daging sapi yang dikuring,<br> dikeringkan dan dapat diasap, tetapi tidak dimasak, dengan kadar air rendah (25% hingga 35%). Umumnya daging sapi dikuring dengan garam, gula, nitrat dan nitrit.",
    "Tidak Aktif",
  ],
  [
    "0802010204",
    "Ham Tipe Prosciutto (Italian Style Ham)",
    "Ham tipe proscuitto (Italian style ham) adalah ham yang terbuat dari daging babi dengan berat antara 5,4 kg hingga 6.8 kg, dengan lapisan lemak dibawah kulit tidak lebih dari 1,3 hingga 5,1 cm. Ham dibalur dengan campuran garam-rempah mengandung gula, garam, lada hitam, lada putih, allspice, pala, biji mustard, coriander, Na-nitrat dan Na-nitrit. 113,4 hingga 184,3 g campuran garam rempah digunakan untuk 45,4 kg ham. Mula-mula ham dengan posisi kulit di bawah dikuring pada suhu 2 C hingga 3 C selama 10 hari , kemudian dibalik sehingga bagian daging ada di bawah dan dikuring lagi selama 10 hari. Ham dikuring dengan total waktu selama 40 hari 45 hari. Sesudah kuring, ham direndam dalam air bersuhu 21 C selama tidak lebih dari 15 jam, dengan air diganti 1 kali selama perendaman. Ham kemudian diasap di ruang asap pada suhu 54 C selama 24 jam, 60 C selama 2 jam, lalu suhunya diturunkan menjadi 49 C selama 8 jam. Pemanasan dihentikan dan ham dibiarkan dalam ruang asap hingga suhu di dalam ham mencapai 38 C. Produk ini dimakan mentah.",
    "Tidak Aktif",
  ],
  [
    "0802010205",
    "Daging Paha Babi Kuring Mentah",
    "Daging paha babi curing mentah adalah produk yang diproses dari<br> daging paha babi belakang, baik utuh maupun deboning, atau berupa<br> potongan, di-curing, diasap maupun tanpa asap, tanpa pemasakan.<br> Semua tulang dan tulang rawan, urat dan jaringan ikat harus<br> dibuang. Kulit dan lemak dapat dibuang atau tidak. Daging harus<br> di-curing dan dapat diasap, diberi bumbu dan/atau perisa.",
    "Aktif",
  ],
  [
    "0802010206",
    "Daging Paha Babi Kuring Matang",
    "Daging paha babi kuring matang adalah produk yang diolah dari daging paha babi belakang, dibelah melintang dari sisa bagian sisi pada suatu titik yang tidak lebih ke depan (arah anterior) dari ujung tulang pinggang. Semua tulang dan tulang rawan, urat dan",
    "Tidak Aktif",
  ],
  [
    "0802010207",
    "Dendeng Daging (tanpa perlakuan panas)",
    "Dendeng daging adalah produk makanan yang berbentuk lempengan<br> terbuat dari irisan atau gilingan daging segar yang berasal dari hewan<br> sehat yang telah diberi bumbu dan dikeringkan.<br> Daging yang dapat diolah menjadi dendeng dapat berupa daging sapi,<br> daging kerbau, daging babi, daging rusa, daging ayam dan lain-lain.",
    "Aktif",
  ],
  [
    "0802010301",
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef)",
    "Daging sapi yang difermentasi dalam keramik (potted beef) adalah daging yang dicacah kasar, dimasukkan ke dalam wadah keramik dan difermentasi.",
    "Aktif",
  ],
  [
    "0802010303",
    "Daging Cangkuk",
    "Daging cangkuk adalah produk olahan daging tradisional khas Jambi berupa daging sapi atau kerbau yang difermentasi bersama garam dan rebung, di dalam suatu wadah bambu yang tertutup rapat selama tujuh hari, sehingga terjadi fermentasi spontan.",
    "Aktif",
  ],
  [
    "08020201",
    "Daging Paha Babi Kuring Matang",
    "Daging paha babi curing matang adalah produk yang diolah dari<br> daging paha babi belakang-dibelah melintang dari sisa bagian sisi<br> pada suatu titik yang tidak lebih ke depan (arah anterior) dari ujung<br> tulang pinggang. Semua tulang dan tulang rawan, urat dan jaringan<br> ikat harus dibuang. Kulit dan lemak dapat dibuang atau tidak.<br> Daging harus di-curing dan dapat diasap, diberi bumbu dan atau<br> perisa.",
    "Aktif",
  ],
  [
    "08020203",
    "Ham Sapi (Daging Paha Sapi Kuring) Matang",
    "Ham sapi (daging paha sapi curing) matang adalah produk yang diolah dari daging paha sapi belakang-dibelah melintang dari sisa bagian sisi pada suatu titik yang tidak lebih ke depan (arah anterior) dari ujung tulang pinggang. Semua tulang dan tulang rawan, urat dan jaringan ikat harus dibuang. Kulit dan lemak dapat dibuang atau tidak. Daging harus dicuring dan dapat diasap, diberi bumbu dan atau perisa.",
    "Aktif",
  ],
  [
    "08020204",
    "Bahu Babi Curing Matang",
    "Bahu babi kuring matang adalah produk yang terbuat dari daging kaki depan babi. Tidak mengandung tulang dan urat, dapat mengandung kulit dan lemak. Daging dicuring dan diasap, serta dapat dibumbui.",
    "Aktif",
  ],
  [
    "08020205",
    "Bahu Sapi Curing Matang",
    "Bahu sapi kuring matang adalah produk yang terbuat dari daging kaki depan sapi. Tidak mengandung tulang dan urat, dapat mengandung kulit dan lemak. Daging dicuring dan diasap, serta dapat dibumbui.",
    "Aktif",
  ],
  [
    "08020206",
    "Daging Ayam Yang Dikalengkan",
    "Daging ayam yang dikalengkan adalah daging ayam segar yang dikemas dalam wadah bersih, yang ditutup secara kedap (hermetis), dan diproses panas untuk menjamin keawetannya. Dapat mengandung garam, air dan air garam.",
    "Tidak Aktif",
  ],
  [
    "08020208",
    "Daging Olahan Khas Indonesia Berbentuk Potongan",
    "Daging olahan khas indonesia berbentuk potongan adalah berbagai jenis olahan/masakan khas Indonesia dengan bahan utama berupa daging, daging unggas maupun daging hewan buruan, berbentuk potongan yang dimasak dengan suhu tinggi hingga matang, dengan atau t",
    "Tidak Aktif",
  ],
  [
    "08020210",
    "Daging Kuah Dalam Kemasan",
    "Daging kuah dalam kemasan adalah hasil olahan daging yang berbentuk potongan atau irisan dengan atau tanpa penambahan bahan makanan lain, bumbu, dikemas secara kedap (hermetis) dalam kemasan kaleng, aluminium foil atau pengemas lain yang sesuai dan dister",
    "Aktif",
  ],
  [
    "08020211",
    "Daging Dalam Kaleng (Tanpa Kuah)",
    "Daging dalam kaleng (tanpa kuah) adalah daging segar atau daging asapyang dikemas dalam wadah bersih, yang ditutup secara kedap (hermetis), dan diproses panas untuk menjamin keawetannya. Dapat mengandung garam, dan air.",
    "Tidak Aktif",
  ],
  [
    "08020213",
    "Abon Daging",
    "Abon daging adalah makanan kering berbentuk khas dibuat dari daging, direbus, disayat-sayat / disuwir, dibumbui, digoreng dan dapat juga dipres. Abon terbuat dari daging berbagai jenis hewan seperti sapi, ayam, babi, dan lain-lain.",
    "Aktif",
  ],
  [
    "08020214",
    "Kerupuk Kulit/Rambak",
    "Kerupuk kulit/rambak adalah produk makanan ringan dibuat dari kulit sapi atau kerbau melalui tahap pembuangan bulu, pengembangan kulit, perebusan, pengeringan, dan diungkep untuk kerupuk kulit mentah atau dilanjutkan dengan penggorengan untuk kerupuk kul",
    "Aktif",
  ],
  [
    "08020215",
    "Keripik Paru",
    "Keripik paru adalah makanan kering yang dibuat dari paru hewan yang diolah dengan cara perebusan, diiris tipis sehingga berbentuk lempeng, diberi bumbu kemudian digoreng dengan atau tanpa penambahan tepung. Keripik paru dapat dibuat dari paru beberapa je",
    "Aktif",
  ],
  [
    "08020216",
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan",
    "Kerupuk berbasis daging, daging unggas dan daging hewan buruan adalah makanan kering yang terbuat dari bagian yang diperoleh dari hewan mamalia maupun unggas, yang kering dan renyah setelah proses penggorengan, dengan atau tanpa penambahan tepung. Contoh",
    "Aktif",
  ],
  ["08020217", "Kerupuk Kulit Ayam", "", "Tidak Aktif"],
  [
    "08020222",
    "Dendeng Daging dengan Perlakuan Panas",
    "Dendeng daging adalah produk makanan yang berbentuk lempengan terbuat dari irisan atau gilingan daging segar yang berasal dari hewan sehat yang telah diberi garam atau bumbu dan dikeringkan. Daging yang dapat diolah menjadi dendeng dapat berupa daging sap",
    "Tidak Aktif",
  ],
  [
    "08020223",
    "Nasi Dengan Lauk Daging Dalam Kaleng",
    "-",
    "Tidak Aktif",
  ],
  [
    "08020224",
    "Usus Ayam Goreng",
    "Usus ayam goreng adalah usus ayam yang dipotong-potong, dicampur bumbu, kemudian digoreng dengan atau tanpa tepung pelapis<br>",
    "Aktif",
  ],
  [
    "08020225",
    "Daging Olahan Berbumbu",
    "Daging olahan berbumbu adalah berbagai jenis olahan dengan bahan utama berupa daging berbentuk utuh atau potongan yang dimasak hingga matang, dengan maupun tanpa penambahan bahan pangan dan bumbu-bumbu lainnya, dengan maupun tanpa kuah/saus. Contohnya adalah rendang daging, gulai ayam, gepuk daging sapi, sate ayam, sate kambing, ayam bumbu sukabumi, ayam bumbu gudeg, ayam bakakak, ayam goreng rica-rica, sambal goreng hati, ayam betutu, pepes ayam, daging sie reuboh, ayam bolognes, daging sapi saus lada hitam, daging ayam saus barbekyu dan lain lain.<br>",
    "Aktif",
  ],
  [
    "08020226",
    "Daging dalam Kaleng",
    "Daging dalam kaleng (tanpa kuah) adalah daging segar atau daging asapyang dikemas dalam wadah bersih, yang ditutup secara kedap (hermetis), dan diproses panas untuk menjamin keawetannya. Dapat mengandung garam dan air/saus/minyak.<br>",
    "Aktif",
  ],
  [
    "08020227",
    "Foie Gras and Pates",
    "Foie gras and pates adalah pasta daging yang dapat dioles",
    "Aktif",
  ],
  [
    "08020228",
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll)",
    "-",
    "Aktif",
  ],
  [
    "08020301",
    "Ayam Katsu (Chicken Katsu)",
    "Ayam katsu adalah dada ayam dengan atau tanpa marinasi, dengan atau tanpa tepung pelapis (predust), kemudian dilapis batter dan bread crumb/tepung panir/tepung roti, digoreng dan dibekukan.",
    "Aktif",
  ],
  [
    "08020303",
    "Ayam Goreng (Fried Chicken)",
    "Ayam goreng adalah potongan ayam dengan atau tanpa marinasi, dengan atau tanpa melalui proses breading, digoreng dan dibekukan.<br> Contohnya drumstick, popcorn chicken, dan lain-lain.",
    "Aktif",
  ],
  [
    "08020305",
    "Sayap Beku Marinasi",
    "Sayap beku marinasi adalah produk potongan daging sayap yang<br> dimarinasi dan dibekukan.",
    "Tidak Aktif",
  ],
  [
    "08020306",
    "Ayam Pop-Corn Beku",
    "Ayam pop-corn beku adalah daging ayam tanpa tulang yang dipotongpotong berbentuk dadu, dimarinasi, di-coating dan digoreng sebelum dibekukan.",
    "Tidak Aktif",
  ],
  [
    "08020307",
    "Chicken Strip Beku",
    "Chicken strip beku adalah daging ayam tanpa tulang yang dipotong-potong memanjang, dimarinasi, di-coating dan digoreng sebelum dibekukan.",
    "Aktif",
  ],
  [
    "08020308",
    "Ayam Cordon Bleu (Chicken Cordon Bleu)",
    "Ayam Cordon Bleu adalah daging ayam tanpa tulang yang utuh dari dada, dimarinasi dan diberi isi (filling) dengan keju dan irisan daging ayam asap atau daging sapi asap. Produk ini kemudian melalui proses breading dan digoreng sebelum dibekukan.",
    "Aktif",
  ],
  [
    "08020309",
    "Ayam Karage (Chicken karage)",
    "Ayam karage adalah dada ayam atau paha ayam dengan atau tanpa marinasi,dengan atau tanpa tepung pelapis (predust), kemudian dilapis batter dan breader, digoreng dan dibekukan.",
    "Aktif",
  ],
  [
    "08020310",
    "Daging Marinasi (Beku)",
    "Daging marinasi adalah potongan ayam atau daging yang dimarinasi, dimasak dan dibekukan. Contohnya sayap ayam marinasi, spicy wing, spicy chick, drumstick marinasi, dan lain-lain.<br>",
    "Aktif",
  ],
  [
    "08020311",
    "Kulit Ayam Goreng",
    "Kulit ayam goreng adalah kulit ayam yang dipotong-potong, dicampur bumbu bumbu, kemudian digoreng dengan atau tanpa tepung pelapis, dibekukan dan dikemas.<br>",
    "Aktif",
  ],
  [
    "08020312",
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan",
    "Potongan daging dengan saus dalam kemasan yang dibekukan adalah hasil olahan potongan daging, daging unggas maupun daging hewan buruan yang ditambah saus dengan atau tanpa penambahan rempah-rempah dan atau bumbu-bumbu, dimasak dengan perlakuan panas, dikemas secara kedap atau hermetis dalam kemasan kaleng, alumunium foil atau pengemas lain yang sesuai dan dibekukan. Contoh: potongan daging sapi dengan saus Bolognese, potongan daging ayam dengan saus carbonara, potongan daging sapi dengan saus blackpepper, potongan daging ayam dengan saus barbeque, potongan daging dada asap dengan bumbu nasi goreng, dll<br>",
    "Aktif",
  ],
  [
    "08020313",
    "Daging Olahan Berbumbu Beku",
    "Daging olahan berbumbu beku adalah berbagai jenis olahan/masakan khas dengan bahan utama daging, daging unggas maupun daging hewan buruan, berbentuk potongan yang dimasak dengan suhu tinggi hingga matang, dengan atau tanpa penambahan bahan pangan dan bumbu-bumbu lainnya, dengan atau tanpa kuah dikemas secara aseptik; kemudian dibekukan. Contohnya adalah rendang daging, gulai ayam, gepuk daging sapi, sate ayam, sate kambing, ayam bumbu sukabumi, ayam bumbu gudeg, ayam bakakak, ayam goreng rica-rica, sambal goreng hati, ayam betutu, pepes ayam, daging sie reuboh, ayam bolognes, daging sapi saus lada hitam, daging ayam saus barbekyu, dan lain lain.<br>",
    "Aktif",
  ],
  [
    "0803010102",
    "Salami dan Produk Sejenisnya",
    "Salami dan produk sejenisnya adalah daging giling kasar, difermentasi dengan starter bakteri pada suhu 26\\xB0C, kelembaban 95% selama 3 hari hingga 7 hari, kemudian dilanjutkan dengan fermentasi pada suhu 16\\xB0C, kelembaban 75% hingga mengering selama 3 minggu",
    "Tidak Aktif",
  ],
  [
    "0803010106",
    "Sosis Asap",
    "Sosis asap adalah sosis yang mengalami pengasapan dalam ruang asap (smoked house) untuk menghasilkan cita rasa asap yang khas.",
    "Aktif",
  ],
  [
    "0803010107",
    "Titiles",
    "Titiles adalah produk khas Bali.",
    "Tidak Aktif",
  ],
  [
    "0803010108",
    "Sosis Asap Kombinasi",
    "Sosis asap adalah sosis yang mengalami pengasapan dalam ruang asap (smoked house) untuk menghasilkan cita rasa asap yang khas.<br>",
    "Aktif",
  ],
  [
    "0803010109",
    "Sosis Daging (Tanpa Perlakuan Panas)",
    "Sosis daging adalah produk berbahan baku daging yang dihaluskan dengan atau tanpa penambahan bahan pangan lain dan dimasukkan ke dalam selongsong sosis. Daging yang digunakan dapat berupa daging sapi, kerbau, kambing, domba, ayam, babi atau daging hewan ternak lainnya yang layak dimakan, dan atau hewan unggas, dengan menyebut jenis dagingnya.<br>",
    "Aktif",
  ],
  [
    "0803010110",
    "Sosis Daging Kombinasi (Tanpa Perlakuan Panas)",
    "Sosis daging adalah produk berbahan baku daging yang dihaluskan dengan atau tanpa penambahan bahan pangan lain dan dimasukkan ke dalam selongsong sosis. Daging yang digunakan dapat berupa daging sapi, kerbau, kambing, domba, ayam, babi atau daging hewan ternak lainnya yang layak dimakan, dan atau hewan unggas, dengan menyebut jenis dagingnya.<br>",
    "Aktif",
  ],
  [
    "0803010111",
    "Kornet Daging non sterilisasi",
    "Kornet daging non sterilisasi adalah produk yang dibuat dari potongan daging ternak tanpa tulang, segar atau beku, dapat dicampur dengan daging bagian kepala dan atau jantung, dengan proses curing, dengan atau tanpa penambahan bahan pangan lain, diproses tanpa sterilisasi dan dikemas dalam wadah tertutup.<br>",
    "Aktif",
  ],
  [
    "0803010112",
    "Kornet Daging Kombinasi non sterilisasi",
    "Kornet daging kombinasi non sterilisasi adalah produk yang dibuat dari potongan daging ternak tanpa tulang, segar atau beku, dapat dicampur dengan daging bagian kepala dan atau jantung, dengan proses curing, dengan atau tanpa penambahan bahan pangan lain, diproses tanpa sterilisasi dan dikemas dalam wadah tertutup.<br>",
    "Aktif",
  ],
  [
    "0803010113",
    "Kornet Unggas non sterilisasi",
    "Kornet unggas non sterilisasi adalah produk yang dibuat dari potongan daging unggas tanpa tulang, segar atau beku, dapat dicampur dengan daging bagian kepala dan atau jantung, dengan proses curing, dengan atau tanpa penambahan bahan pangan lain, diproses tanpa sterilisasi dan dikemas dalam wadah tertutup.<br>",
    "Aktif",
  ],
  [
    "0803010114",
    "Kornet Unggas Kombinasi non sterilisasi",
    "Kornet unggas kombinasi non sterilisasi adalah produk yang dibuat dari potongan daging unggas tanpa tulang, segar atau beku, dapat dicampur dengan daging bagian kepala dan atau jantung, dengan proses curing, dengan atau tanpa penambahan bahan pangan lain, diproses tanpa sterilisasi dan dikemas dalam wadah tertutup.<br>",
    "Aktif",
  ],
  [
    "0803010115",
    "Urutan",
    "Urutan adalah sosis tradisional khas Bali yang terbuat dari daging babi yang dihaluskan, yang difermentasi dengan bakteri alami pada usus babi, dikemas dalam selongsong usus halus babi.",
    "Aktif",
  ],
  [
    "0803010203",
    "Sosis yang Dikuring dan Dikeringkan",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    "0803010205",
    "Sosis Cina (Termasuk Sosis Tradisional Yang Dikuring atau Diasap) atau Lup Cheong",
    "Sosis cina (termasuk sosis tradisional yang dikuring atau diasap) atau lup cheong adalah sosis dari daging babi, ayam atau kalkun. Daging dipotong manual menjadi irisan tipis dan lemak dari bagian punggung (backfat) dipotong kubus 10 mm. Daging dan lemak",
    "Tidak Aktif",
  ],
  [
    "0803010207",
    "Sosis Cina - Sosis Daging (Termasuk Sosis Tradisional yang Dicuring atau Diasap)",
    "Sosis cina (termasuk sosis tradisional yang dicuring atau diasap) atau lup cheong adalah sosis dari daging babi, ayam atau kalkun. Daging dipotong manual menjadi irisan tipis dan lemak dari bagian punggung (backfat) dipotong. Daging dan lemak kemudian dicampur merata dengan campuran bumbu (yang khas: kecap dan gula) dan dibiarkan terendam dalam bumbu selama beberapa jam sebelum diisi. Selongsong sosis yang digunakan umumnya usus halus babi. Sosis kemudian dikeringkan.",
    "Aktif",
  ],
  [
    "0803010208",
    "Sosis Cina - Sosis Kombinasi (Termasuk Sosis Tradisional yang Dicuring atau Diasap)",
    "Sosis cina (termasuk sosis tradisional yang dicuring atau diasap) atau lup cheong adalah sosis kombinasi dengan daging babi, ayam atau kalkun. Daging dipotong manual menjadi irisan tipis dan lemak dari bagian punggung (backfat) dipotong. Daging dan lemak kemudian dicampur merata dengan campuran bumbu (yang khas: kecap dan gula) dan dibiarkan terendam dalam bumbu selama beberapa jam sebelum diisi. Selongsong sosis yang digunakan umumnya usus halus babi. Sosis kemudian dikeringkan.",
    "Aktif",
  ],
  [
    "0803010301",
    "Urutan",
    "Urutan adalah sosis tradisional khas Bali yang terbuat dari daging babi yang dihaluskan, yang difermentasi dengan bakteri alami pada usus babi, dikemas dalam selongsong usus halus babi.",
    "Tidak Aktif",
  ],
  [
    "0803010302",
    "Chorizos",
    "Chorizos adalah sosis daging babi yang menggunakan rempah rempah. Rempah yang digunakan dan bentuk olahannya dapat bervariasi misalnya sosis babi yang kering, semi kering, pedas, sedang, dicuring, berwarna merah hingga oranye pucat, dari daging yang digiling halus maupun kasar.<br>",
    "Aktif",
  ],
  [
    "0803010303",
    "Salami",
    "Salami adalah daging giling kasar, difermentasi dengan starter bakteri dengan atau tanpa penambahan bahan pangan lain. Dapat diasap sebelum atau selama pengeringan, dapat terjadi pertumbuhan kapang di permukaannya maupun tidak.<br>",
    "Aktif",
  ],
  [
    "08030201",
    "Patties Daging Panggang Setengah Matang",
    "Patties daging panggang setengah matang adalah produk yang terbuat dari hasil pencincangan daging mamalia maupun unggas, dengan bahan tambahan berupa tepung serealia, bahan pengikat, air, bumbu, dan bawang. Daging dicampur dengan bahan lain, dan campuran dicetak membentuk patties atau diisikan dalam selongsong plastik dan didinginkan atau dibekukan sebagian sebelum diiris membentuk patties. Patties kemudian dipanggang setengah matang.",
    "Aktif",
  ],
  [
    "08030202",
    "Foie Gras and Pates",
    "Foie gras and pates adalah pasta daging yang dapat dioles.",
    "Tidak Aktif",
  ],
  [
    "08030203",
    "Brawn and Head Cheese",
    "Brawn and head cheese adalah produk yang dibuat dengan merebus tulang-tulang, kulit, tulang rawan, daging dari bagian kepala, telinga, kaki, serta tetelan lain yang banyak mengandung jaringan ikat tetapi rendah lemak. Dapat mengandung daging matang, rusk,",
    "Aktif",
  ],
  ["08030204", "Daging Kuring Cacahan Matang", "", "Tidak Aktif"],
  [
    "08030206",
    "Kornet Daging Sapi (Corned Beef) dalam Kemasan",
    "Kornet daging sapi (corned beef) dalam kemasan adalah produk yang dibuat dari potongan daging sapi segar atau beku, tanpa tulang, boleh dicampur dengan daging bagian kepala dan hati dengan atau tanpa penambahan bahan lain, dibuat dengan proses kuring, dik",
    "Tidak Aktif",
  ],
  [
    "08030207",
    "Daging Luncheon Matang",
    "Daging luncheon matang adalah produk yang terbuat dari daging atau campuran dua jenis daging atau lebih yang telah dihaluskan, dicuring dan dapat dimasak /dipanggang / telah diasap.",
    "Aktif",
  ],
  [
    "08030208",
    "Pasta Daging",
    "Pasta daging adalah daging yang dihaluskan menyerupai pasta dengan tekstur sedang. Dapat mengandung bagian non daging seperti rusk, air, atau bahan pengisi lain yang sesuai seperti konsentrat kedelai/Na-kaseinat. Produk disterilisasi setelah dikemas dalam",
    "Aktif",
  ],
  [
    "08030209",
    "Patties Daging Matang",
    "Patties Daging Matang adalah produk yang terbuat dari hasil pencincangan daging mamalia maupun unggas, dengan bahan tambahan berupa tepung serealia, bahan pengikat, air, bumbu, dan bawang. Daging dicampur dengan bahan lain, dan campuran dicetak membentuk",
    "Tidak Aktif",
  ],
  [
    "08030211",
    "Bakso Daging",
    "produk yang diperoleh dari campuran daging ternak<br> (kdr daging tidak kurang dari 50%) & pati/serealia dan bumbu2, dlm kondisi matang. Biasanya berbentuk bulat. Daging yang digunakan dpt berupa daging sapi, ayam, babi/daging lainnya dg menyebut jns dagingny",
    "Tidak Aktif",
  ],
  ["08030212", "Bakso Daging Kering", "", "Tidak Aktif"],
  [
    "08030214",
    "Sosis Sarapan Matang (Sosis Daging Babi Matang)",
    "Sosis sarapan matang (sosis daging babi matang) adalah sosis yang dibuat dari hasil penghalusan tetelan daging babi, dengan penambahanan garam dan rempah-rempah.",
    "Tidak Aktif",
  ],
  [
    "08030215",
    "Sosis Daging (sapi, ayam, babi, atau daging lainnya)",
    "Sosis daging adalah produk dari campuran daging halus (mengandung<br> daging tidak kurang dari 75%) dengan tepung atau pati dengan atau tanpa<br> penambahan bumbu dan dimasukkan ke dalam selubung (selongsong)<br> sosis. Daging yang digunakan dapat berupa daging sapi, ayam, babi atau daging<br> lainnya dengan menyebut jenis dagingnya.",
    "Tidak Aktif",
  ],
  [
    "08030216",
    "Sosis Variasi",
    "Sosis variasi adalah sosis dari campuran daging halus dengan tambahan pangan lain seperti keju, sayur dan bahan lain-lain.",
    "Tidak Aktif",
  ],
  [
    "08030217",
    "Sosis Analog/Daging Analog/ Produk Analog",
    "Sosis analog adalah sosis dari campuran protein nabati dengan atau tanpa tambahan pangan lain seperti keju, sayur dan bahan lain-lain.",
    "Tidak Aktif",
  ],
  [
    "08030218",
    "Terrines (Campuran Cacahan Daging Matang)",
    "Terrines (campuran cacahan daging matang) adalah campuran daging cacahan yang dimasak di dalam wadah (vessel) dari tanah liat.",
    "Aktif",
  ],
  [
    "08030219",
    "Rolade Daging",
    "Rolade daging adalah produk dari lumatan daging atau daging giling dapat ditambah sayur, jamur diberi bumbu-bumbu, digulung dengan telur dadar atau bahan lainnya. Dimasak dan dapat diiris.",
    "Aktif",
  ],
  ["08030220", "Sosis Siap Santap", "-", "Tidak Aktif"],
  [
    "08030221",
    "Sosis Analog/Daging Analog/ Produk Analog Steril",
    "-",
    "Tidak Aktif",
  ],
  ["08030222", "Otak - Otak Ayam", "&nbsp;", "Tidak Aktif"],
  [
    "08030223",
    "Kornet Daging Ayam (Corned Chicken) dalam Kemasan",
    "-",
    "Tidak Aktif",
  ],
  [
    "08030224",
    "Sosis Daging (sapi, ayam, babi, atau daging lainnya) Steril",
    "-",
    "Tidak Aktif",
  ],
  [
    "08030225",
    "Daging Luncheon Matang dalam Kaleng",
    "Daging luncheon matang dalam kaleng adalah produk yang terbuat dari daging atau campuran dua jenis daging atau lebih yang telah dihaluskan, dicuring dan dapat dimasak /dipanggang / telah diasap dan dikemas dalam kaleng.",
    "Aktif",
  ],
  [
    "08030226",
    "Sosis Daging (sapi, ayam, babi, atau daging lainnya) Kaleng",
    "-",
    "Tidak Aktif",
  ],
  [
    "08030227",
    "Kornet Daging (Sapi/ Kambing/ Babi) Kombinasi",
    "-",
    "Tidak Aktif",
  ],
  [
    "08030228",
    "Kornet Daging Unggas Kombinasi",
    "-",
    "Tidak Aktif",
  ],
  [
    "08030229",
    "Salami Matang / Pepperoni Matang",
    "Produk daging giling, difermentasi dengan starter kultur, kemudian dimasak hingga matang. Salami matang dan produk sejenisnya adalah daging giling yang ditambah rempah-rempah dan memiliki rasa yang kuat, sudah dimasak yang mempunyai karakter khas salami.<br>",
    "Aktif",
  ],
  [
    "08030230",
    "Bakso Daging Kombinasi",
    "Bakso daging adalah produk olahan daging yang dibuat dari daging hewan ternak yang dicampur pati dan bumbu-bumbu, dengan atau tanpa penambahan bahan pangan lainnya, yang berbentuk bulat atau bentuk lainnya dan dimatangkan. Daging yang digunakan dapat berupa daging sapi, kerbau, kambing, domba, ayam, babi atau daging hewan ternak lainnya yang layak dimakan, dan atau hewan unggas, dengan menyebut jenis dagingnya.; serta dapat mengandung bagian bukan daging seperti urat dan hati.<br>",
    "Aktif",
  ],
  [
    "08030231",
    "Sosis Daging Kombinasi (dengan Perlakuan Panas)",
    "Sosis daging adalah produk berbahan baku daging yang dihaluskan dengan atau tanpa penambahan bahan pangan lain dan dimasukkan ke dalam selongsong sosis dengan proses pemasakan. Daging yang digunakan dapat berupa daging sapi, kerbau, kambing, domba, ayam, babi atau daging hewan ternak lainnya yang layak dimakan, dan atau hewan unggas, dengan menyebut jenis dagingnya.",
    "Aktif",
  ],
  [
    "08030232",
    "Pate Daging",
    "Pate daging adalah daging direbus, digiling, dimasukkan hati segar halus, digiling lagi, dimasukkan selongsong/kaleng/jar, dipanaskan.<br> Contohnya pate angsa.",
    "Aktif",
  ],
  [
    "08030233",
    "Daging Cincang Olahan Berbumbu",
    "Daging cincang olahan berbumbu adalah berbagai jenis olahan dengan bahan utama berupa daging cincang atau daging giling yang dimasak hingga matang, dengan atau tanpa penambahan bahan pangan dan bumbu-bumbu lainnya, dengan atau tanpa kuah/saus, dikemas secara aseptis dan disterilkan. Contoh : daging ayam dengan saus Bolognese, daging ayam dengan saus carbonara, daging sapi dengan saus blackpepper, daging ayam dengan saus barbekyu, daging curing cacahan matang.",
    "Aktif",
  ],
  [
    "08030234",
    "Kornet Daging Sterilisasi",
    "Produk yang dibuat dari potongan daging ternak atau unggas dan atau campurannya tanpa tulang, segar atau beku, dapat dicampur dengan daging bagian kepala dan atau jantung, dengan proses curing, dengan atau tanpa penambahan bahan pangan lain, dikemas dalam wadah tertutup, kedap udara atau secara hermetis dan diproses dengan sterilisasi.",
    "Aktif",
  ],
  [
    "08030235",
    "Kornet Daging Kombinasi Sterilisasi",
    "Produk yang dibuat dari potongan daging ternak atau unggas dan atau campurannya tanpa tulang, segar atau beku, dapat dicampur dengan daging bagian kepala dan atau jantung, dengan proses curing, dengan atau tanpa penambahan bahan pangan lain, dikemas dalam wadah tertutup, kedap udara atau secara hermetis dan diproses dengan sterilisasi.",
    "Aktif",
  ],
  [
    "08030236",
    "Kornet Unggas Sterilisasi",
    "Produk yang dibuat dari potongan daging ternak atau unggas dan atau campurannya tanpa tulang, segar atau beku, dapat dicampur dengan daging bagian kepala dan atau jantung, dengan proses curing, dengan atau tanpa penambahan bahan pangan lain, dikemas dalam wadah tertutup, kedap udara atau secara hermetis dan diproses dengan sterilisasi.",
    "Aktif",
  ],
  [
    "08030237",
    "Kornet Unggas Kombinasi Sterilisasi",
    "&nbsp;",
    "Aktif",
  ],
  [
    "08030238",
    "Sosis Daging Non Casing",
    "Sosis daging non casing adalah produk dari campuran daging halus yang diemulsikan, dengan penambahan tepung atau pati dengan atau tanpa penambahan bumbu dan bahan pangan lain yang diizinkan dan dicetak berbentuk sosis.",
    "Aktif",
  ],
  [
    "08030239",
    "Sosis Daging Kombinasi Non Casing",
    "Sosis daging kombinasi non casing adalah produk dari campuran daging halus yang diemulsikan, dengan penambahan tepung atau pati dengan atau tanpa penambahan bumbu dan bahan pangan lain yang diizinkan dan dicetak berbentuk sosis.<br>",
    "Aktif",
  ],
  [
    "08030240",
    "Daging Halus Olahan Berbumbu",
    "Daging halus olahan berbumbu adalah berbagai jenis olahan dengan bahan utama berupa daging, daging unggas maupun daging hewan buruan, yang dihaluskan yang dimasak dengan suhu tinggi hingga matang, dengan maupun tanpa penambahan bahan makanan dan bumbu-bumbu lainnya. Contohnya adalah perkedel daging, sambal goreng cincang, dll.<br> <br> <br> <br> <br> <br> <br>",
    "Aktif",
  ],
  [
    "08030241",
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan",
    "Potongan daging/daging cincang/daging giling dengan saus dalam kemasan adalah hasil olahan potongan daging, daging cincang atau daging giling yang ditambah saus dengan atau tanpa penambahan rempah-rempah dan dengan atau tanpa penambahan bumbu-bumbu, dimasak dengan perlakuan panas, dikemas secara kedap atau hermetis dalam kemasan kaleng, aluminium foil atau pengemas lain yang sesuai dan disterilkan.<br> Contoh: saus Bolognese untuk spaghetti, saus carbonara, daging sapi saus blackpepper, daging ayam saus barbeque, dll.",
    "Aktif",
  ],
  [
    "08030242",
    "Dendeng Daging (dengan perlakuan panas)",
    "Dendeng daging adalah produk dari lumatan daging, diberi bumbu dengan atau tanpa penambahan bahan tambahan pangan, dicetak dan dimasak. Daging yang dapat diolah menjadi dendeng dapat berupa daging sapi,<br> daging kerbau, daging babi, daging rusa, daging ayam dan lain lain.",
    "Aktif",
  ],
  [
    "08030243",
    "Pepperoni",
    "Pepperoni adalah daging giling yang ditambah rempah-rempah dan memiliki rasa yang kuat, sudah dimasak yang mempunyai karakter khas Pepperoni",
    "Aktif",
  ],
  [
    "08030244",
    "Bakso Daging",
    "Bakso daging adalah produk olahan daging yang dibuat dari daging hewan ternak yang dicampur pati dan bumbu-bumbu, dengan atau tanpa penambahan bahan pangan lainnya, yang berbentuk bulat atau bentuk lainnya dan dimatangkan.<br>",
    "Aktif",
  ],
  [
    "08030245",
    "Sosis Daging Siap Makan",
    "Sosis daging siap makan adalah produk dari campuran daging halus yang diemulsikan, dengan tambahan tepung atau pati dengan atau tanpa penambahan bumbu dan bahan pangan lain dan dimasukkan ke dalam kemasan yang kedap udara dan dilakukan sterilisasi, dapat dimakan langsung tanpa dimasak.",
    "Aktif",
  ],
  ["08030246", "Sosis Daging Kombinasi Siap Makan", "-", "Aktif"],
  [
    "08030247",
    "Sosis Daging (dengan Perlakuan Panas)",
    "Sosis daging adalah produk berbahan baku daging yang dihaluskan dengan atau tanpa penambahan bahan pangan lain dan dimasukkan ke dalam selongsong sosis dengan proses pemasakan. Daging yang digunakan dapat berupa daging sapi, kerbau, kambing, domba, ayam, babi atau daging hewan ternak lainnya yang layak dimakan, dan atau hewan unggas, dengan menyebut jenis dagingnya.",
    "Aktif",
  ],
  [
    "08030302",
    "Naget Ayam",
    "Naget ayam adalah produk olahan ayam yang dicetak, dimasak dan dibekukan, dibuat dari campuran daging ayam giling yang diberi bahan pelapis dengan atau tanpa penambahan bahan pangan lain.",
    "Tidak Aktif",
  ],
  ["08030303", "Naget Daging", "", "Tidak Aktif"],
  [
    "08030304",
    "Gyoza",
    "Gyoza adalah produk yang terbuat dari daging ayam, sapi, dan/atau daging hewan ternak lainnya yang dihaluskan, dengan atau tanpa hasil perikanan yang dihaluskan atau potongan, bumbu-bumbu, dan bahan pangan lain, dilapis dengan kulit yang terbuat dari adonan terigu dan air dan dibentuk, dimasak, dikemas, dan dibekukan. Jenis gyoza diantaranya Gyoza Ayam, Gyoza Daging, Gyoza Ayam dan Sayuran.",
    "Aktif",
  ],
  ["08030305", "Samosa Ayam", "&nbsp;", "Tidak Aktif"],
  ["08030306", "Naget Ayam Kombinasi", "-", "Aktif"],
  [
    "08030307",
    "Naget Daging Sapi Kombinasi",
    "Naget daging adalah produk olahan daging sapi yang dicetak dalam berbagai bentuk, dimasak, dan dibekukan, dibuat dari campuran daging sapi giling yang diberi bahan pelapis dengan atau tanpa penambahan bahan pangan lain; dengan atau tanpa isi di bagian tengahnya. Naget daging sapi kombinasi merupakan naget dengan kandungan daging sapi minimal 15%. Kadar protein naget daging sapi tidak kurang dari 9% dan kadar lemak tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "08030308",
    "Kornet Daging (Beku)",
    "Kornet daging adalah produk yang dibuat dari potongan daging ternak atau unggas dan atau campurannya tanpa tulang, segar atau beku, dapat dicampur dengan daging bagian kepala dan atau jantung, dengan proses curing, dengan atau tanpa penambahan bahan pangan lain, diproses, dikemas dalam wadah tertutup dan dibekukan.",
    "Aktif",
  ],
  ["08030309", "Kornet Daging Kombinasi (Beku)", "-", "Aktif"],
  ["08030310", "Kornet Unggas (Beku)", "-", "Aktif"],
  ["08030311", "Kornet Unggas Kombinasi (Beku)", "-", "Aktif"],
  [
    "08030312",
    "Smoked Chicken Breast (Daging Dada Ayam Asap)",
    "Smoked Chicken Breast (Daging Dada Ayam Asap) adalah produk yang terbuat dari hasil daging dada ayam, baik yang tidak dihaluskan maupun dihaluskan, dengan bahan tambahan berupa berbagai bumbu dan melalui proses curing; diisikan ke dalam selongsong plastik dan dimasak dengan pengasapan, didinginkan sebelum diiris membentuk potongan, lembaran atau gelondongan dan dibekukan.",
    "Aktif",
  ],
  [
    "08030313",
    "Swikiau/Kuotieh Daging",
    "Swikiau/Kuotieh daging adalah produk yang terbuat dari daging yang dihaluskan, dicampur dengan hasil perikanan yang dihaluskan atau potongan, sayuran, bumbu-bumbu, dan bahan tambahan, dilapis dengan kulit yang terbuat dari adonan terigu dan air dan dibentuk , dimasak, dikemas, dan dibekukan.",
    "Aktif",
  ],
  [
    "08030314",
    "Lumpia Daging",
    "Lumpia daging adalah produk yang terbuat dari daging yang dihaluskan, dicampur dengan hasil perikanan yang dihaluskan atau potongan, sayuran, bumbu-bumbu, dan bahan tambahan, dilapis<br> dengan kulit yang terbuat dari adonan terigu dan air dan dibentuk silinder, dimasak, dikemas, dan dibekukan.",
    "Aktif",
  ],
  [
    "08030315",
    "Pangsit Daging",
    "Pangsit daging adalah produk yang terbuat dari daging yang dihaluskan, dicampur dengan hasil perikanan yang dihaluskan atau potongan, bumbu-bumbu, dan bahan tambahan, dilapis dengan kulit pangsit, dimasak, dikemas, dan dibekukan.",
    "Aktif",
  ],
  [
    "08030316",
    "Ebi Katsu",
    "Ebi Katsu adalah produk yang terbuat dari daging ayam yang dihaluskan, dicampur dengan hasil perikanan yang dihaluskan atau potongan, bumbu-bumbu, dan bahan tambahan, dicetak, diberi tepung pelapis, dimasak, dan dibekukan.",
    "Aktif",
  ],
  [
    "08030317",
    "Keecho/Heecho",
    "Keecho/heecho adalah produk yang terbuat dari daging ayam yang dihaluskan, dicampur dengan hasil perikanan yang dihaluskan atau potongan, bumbu-bumbu, sayuran, dan bahan tambahan lainnya, dilapis dengan kulit tahu, dimasak, dikemas, dan dibekukan.",
    "Aktif",
  ],
  [
    "08030318",
    "Bakso Goreng",
    "Bakso goreng adalah produk yang terbuat dari daging yang dihaluskan, dapat dicampur dengan hasil perikanan yang dihaluskan atau potongan, bumbu-bumbu dan bahan tambahan lainnya, lalu dibentuk bulat atau bentuk lainnya, digoreng, dibekukan, dikemas dan disimpan beku.<br> Bakso goreng merupakan bakso dengan kandungan daging minimal 45 %.<br> Karakteristik dasar :<br> \xEF\x{201A}\xB7 Kadar protein bakso goreng tidak kurang dari 11 %;<br> \xEF\x{201A}\xB7 Kadar lemak tidak lebih dari 10%;",
    "Aktif",
  ],
  [
    "08030319",
    "Bakso Goreng Kombinasi",
    "Bakso goreng adalah produk yang terbuat dari daging yang dihaluskan, dapat dicampur dengan hasil perikanan yang dihaluskan atau potongan, bumbu-bumbu dan bahan tambahan lainnya, lalu dibentuk bulat atau bentuk lainnya, digoreng, dibekukan, dikemas dan disimpan beku. Bakso goreng kombinasi merupakan bakso dengan kandungan daging minimal 20 %.<br> Karakteristik dasar :<br> \xEF\x{201A}\xB7 Kadar protein bakso goreng kombinasi tidak kurang dari 8 %;<br> \xEF\x{201A}\xB7 Kadar lemak tidak lebih dari 10%;",
    "Aktif",
  ],
  [
    "08030320",
    "Burger Daging",
    "Produk yang terbuat dari daging giling, dengan penambahan air, bumbu, dengan atau tanpa penambahan bahan pangan lain, kemudian dicetak, dibreading, dimasak, dan didinginkan",
    "Aktif",
  ],
  [
    "08030321",
    "Naget Ayam",
    "Naget ayam adalah produk olahan ayam yang dicetak, dimasak dan dibekukan, dibuat dari campuran daging ayam giling yang diberi bahan pelapis dengan atau tanpa penambahan bahan pangan lain dengan atau tanpa isi di bagian tengahnya.",
    "Aktif",
  ],
  [
    "08030322",
    "Naget Daging Sapi",
    "Naget daging adalah produk olahan daging sapi yang dicetak dalam berbagai bentuk, dimasak, dan dibekukan, dibuat dari campuran daging sapi giling yang diberi bahan pelapis dengan atau tanpa penambahan bahan pangan lain; dengan atau tanpa isi di bagian tengahnya. Naget daging sapi merupakan naget dengan kandungan daging sapi minimal 35%. Kadar protein naget daging sapi tidak kurang dari 12% dan kadar lemak tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "08030323",
    "Siomay Daging",
    "Siomay daging adalah produk yang terbuat dari daging ayam yang dihaluskan, dicampur dengan hasil perikanan yang dihaluskan atau potongan, bumbu-bumbu, dan bahan tambahan lainnya, dilapis dengan kulit yang terbuat dari adonan terigu dan air dan dibentuk seperti cup, dimasak, dikemas, dan dibekukan. Persyaratan meat content minimal 30% (dengan kadar daging &gt;50%, kadar ikan &lt;50%).",
    "Aktif",
  ],
  [
    "08030324",
    "Ekado/ Moneybag",
    "Ekado adalah produk yang terbuat dari daging ayam yang dihaluskan, dicampur maupun tidak dengan hasil perikanan yang dihaluskan atau potongan, bumbu-bumbu, sayuran, dan bahan tambahan lainnya, dibentuk bulat seperti bakso dengan bagian tengahnya berisi telur; dilapis dengan kulit tahu, dimasak, dikemas, dan dibekukan.",
    "Aktif",
  ],
  [
    "08030325",
    "Daging Halus Olahan Berbumbu (Beku)",
    "Daging halus olahan berbumbu adalah berbagai jenis olahan dengan bahan utama berupa daging, daging unggas maupun daging hewan buruan yang dihaluskan, dalam bentuk mentah, setengah matang atau matang penuh, dengan maupun tanpa penambahan bahan makanan dan bumbu-bumbu lainnya. Contohnya adalah perkedel daging, sambal goreng cincang, dll.",
    "Aktif",
  ],
  [
    "09020116",
    "Udang Beku",
    "Udang beku adalah produk yang diperoleh dari spesies udang yang tergolong famili : (a) Penaeidae; (b) Pandalidae; (c) Crangonidae; (d)Palaemonidae dalam keadaan baik dan segar kemudian dicuci bersih, dan dibekukan dengan cepat hingga suhu pusat mencapai -18oC atau lebih rendah.",
    "Aktif",
  ],
  [
    "09020117",
    "Udang Kupas Mentah Beku",
    "Udang kupas mentah beku adalah produk dari udang segar yang mengalami perlakuan pencucian, dengan atau tanpa penyiangan, dengan atau tanpa pembelahan dan pembekuan hingga suhu pusat mencapai -18oC atau lebih rendah.",
    "Aktif",
  ],
  [
    "09020121",
    "Cumi-Cumi / Kerang / Ikan / ... Beku",
    "Cumi-Cumi / Kerang / Ikan / ... beku adalah produk spesies cumi-cumi, kerang, ikan segar dari famili (i) Loliginidae; (ii)Ommastrephidae atau bagiannya yang telah mengalami proses pencucian, dengan atau tanpa penyiangan, dengan atau tanpa pencucian, dan d",
    "Tidak Aktif",
  ],
  [
    "09020130",
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain",
    "Memfasilitasi pendaftaran pangan olahan selain PSAH",
    "Aktif",
  ],
  [
    "09020131",
    "Sidat Panggang Beku",
    "Sidat panggang beku adalah produk perikanan dengan bahan baku sidat (Anguilla spp.) yang mengalami perlakuan menjadi filet, pemanggangan, pengukusan, dan pemanggangan kembali dengan atau tanpa penambahan bahan peningkat aroma dan rasa, dan dibekukan.",
    "Aktif",
  ],
  [
    "09020132",
    "Pempek Ikan Rebus Beku",
    "Pempek ikan rebus beku adalah produk perikanan dengan bahan baku lumatan daging ikan segar dan/atau surimi dengan penambahan tepung, air, garam, dengan atau tanpa bahan pangan lain, yang mengalami perlakuan perebusan dan pembekuan.<br> Karakeristik dasar:<br> Kandungan lumatan daging ikan segar dan/atau surimi tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "09020133",
    "Bakso Ikan Beku",
    "Bakso ikan beku adalah produk ikan yang menggunakan lumatan daging ikan atau surimi dicampur tepung, dan bahan pangan lain bila diperlukan, yang mengalami pembentukan, perebusan, dan pembekuan. Bahan baku ikan yang digunakan dapat berupa semua jenis ikan dari kelas Pisces hasil penangkapan atau budidaya.<br> Karakteristik dasar:<br> Kandungan lumatan daging ikan atau surimi tidak kurang dari 40%.<br>",
    "Aktif",
  ],
  [
    "09020201",
    "Stik Ikan, Bagian Ikan dan Filet Ikan Berlapis Tepung (Breaded atau in Batter) yang Dibekukan",
    "Stik ikan, bagian ikan dan filet ikan berlapis tepung (breaded atau in batter) yang dibekukan adalah produk stik ikan, bagian ikan dan filet yang dilapisi dengan tepung roti atau tepung lain dengan atau tanpa penggorengan serta dibekukan.",
    "Aktif",
  ],
  [
    "09020202",
    "Stik Ikan (Fish Finger) Berlapis Tepung",
    "Stik ikan (fish finger) adalah produk perikanan yang dilapisi dengan tepung roti atau tepung lain dengan atau tanpa penggorengan yang memiliki berat antara 20 g hingga 50 g dengan panjang tidak lebih dari tiga kali lebar dan memiliki ketebalan 10 mm, atau",
    "Aktif",
  ],
  [
    "09020203",
    "Udang Lapis Tepung Beku",
    "Udang lapis tepung beku adalah produk dengan bahan baku udang (Penaeus Sp) segar atau jenis lain yang mengalami perlakuan sortasi, pengupasan, pembersihan, pemilihan ukuran, penyayatan dan pembentukan, dilapisi dengan tepung roti atau tepung lain dengan a",
    "Aktif",
  ],
  [
    "09020204",
    "Naget Ikan/Udang/Cumi/Kerang Beku",
    "Naget ikan/udang/cumi/kerang beku adalah produk perikanan dengan menggunakan lumatan daging ikan/udang/cumi/kerang dan/atau surimi, dicampur tepung dan bahanpangan lain, dikukus,<br> dicetak, dibaluri dengan tepung pengikat (predust6), dimasukkan dalam adonan batter5, kemudian dilapisi tepung roti/parutan kelapa kering, dengan atau tanpa penggorengan, dan dibekukan.<br> <br> Bahan baku yang digunakan meliputi ikan segar; udang segar; ikan beku; udang beku; lumatan daging ikan; surimi dengan mutu sesuai spesifikasi. Nama jenis produk ini diantaranya naget ikan, naget udang, naget ikan dan udang, kroket udang.",
    "Aktif",
  ],
  [
    "09020205",
    "Naget Udang",
    "Naget udang adalah produk dari daging udang giling yang dicampur dengan bumbu-bumbu dan bahan pengikat dan dicetak, dikukus, dilapisi dengan tepung roti atau tepung lain, dengan atau tanpa digoreng, dibekukan dan disimpan dalam keadaan beku.",
    "Tidak Aktif",
  ],
  [
    "09020206",
    "Tempura Beku",
    "Tempura beku adalah daging udang utuh yang dilapisi dengan bahan pengikat dan tepung roti atau tepung lainnya, dengan atau tanpa digoreng, dibekukan dan disimpan dalam keadaan beku.",
    "Aktif",
  ],
  [
    "0902040101",
    "Ikan dan Produk Ikan Kukus atau Rebus",
    "Ikan dan produk ikan kukus atau rebus adalah ikan dan produk ikan yang dimasak dengan cara pengukusan atau perebusan.",
    "Aktif",
  ],
  [
    "0902040104",
    "Ikan Pindang Garam",
    "Ikan pindang garam adalah produk ikan dengan bahan baku ikan yang mengalami perlakuan pengukusan dan setiap lapisannya ditaburi garam.",
    "Aktif",
  ],
  [
    "0902040105",
    "Bandeng Presto",
    "Bandeng presto adalah produk ikan dengan bahan baku ikan bandeng (Chanos chanos) utuh yang mengalami perlakuan perendaman dalam larutan garam atau bumbu dan pengukusan dengan tekanan tinggi.",
    "Aktif",
  ],
  [
    "0902040106",
    "Kamaboko",
    "Kamaboko adalah produk olahan dari daging ikan (atau dari surimi) yang mengalami proses pencucian, penggilingan dengan garam dan pemanasan sehingga membentuk tekstur yang kenyal (gel).",
    "Aktif",
  ],
  [
    "0902040107",
    "Bakso Ikan",
    "Bakso ikan adalah produk ikan yang menggunakan lumatan daging ikan atau surimi dicampur tepung dan bahan pangan lain bila diperlukan, yang mengalami pembentukan dan perebusan. Bahan baku ikan yang digunakan dapat berupa semua jenis ikan dari kelas Pisces hasil penangkapan atau budidaya.<br> <br> Karakteristik dasar:<br> Kandungan lumatan daging ikan atau surimi tidak kurang dari 40%.",
    "Aktif",
  ],
  ["0902040108", "Bakso Ikan Kering", "", "Tidak Aktif"],
  [
    "0902040109",
    "Otak-Otak Ikan",
    "Otak-otak ikan adalah produk perikanan yang menggunakan<br> lumatan daging ikan dan/atau surimi dicampur tepung/pati dengan atau tanpa bahan pangan lain, yang mengalami pembentukan, dengan atau tanpa dibungkus daun atau bahan lain yang sesuai, dan pemasakan. Bahan baku yang digunakan ikan segar; ikan beku; lumatan daging ikan; surimi dengan mutu sesuai spesifikasi.<br> <br> Karakteristik dasar:<br> Kandungan daging ikan dan/atau surimi tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "0902040110",
    "Kue Ikan Kukus (Steamed Fish Cake)",
    "Fish cake atau kue ikan adalah produk olahan dari bahan baku surimi yang telah mengalami pengukusan, dapat diberi potongan sayuran atau bahan pangan lain.",
    "Aktif",
  ],
  [
    "0902040111",
    "Siomay Ikan",
    "Siomay ikan adalah produk olahan ikan yang dibuat dari daging ikan giling, tapioka, terigu, telur dan bumbu-bumbu, dibentuk kotak atau bentuk lainnya, dapat ditempatkan pada lembaran tipis kulit pangsit atau bahan lainnya yang dapat dimakan, dan dikukus.",
    "Tidak Aktif",
  ],
  [
    "0902040112",
    "Pempek Ikan (Rebus)",
    "Definisi :<br> Pempek ikan (rebus) adalah produk perikanan dengan bahan baku lumatan daging ikan segar dan/atau surimi dengan penambahan tepung, air, garam, dengan atau tanpa bahan pangan lain, yang mengalami perlakuan perebusan.<br> Karakeristik dasar:<br> Kandungan lumatan daging ikan segar dan/atau surimi tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "0902040113",
    "Empek-Empek Palembang",
    "Empek-empek Palembang adalah produk olahan ikan yang dibuat dari daging ikan belida yang digiling, dicampur dengan tapioka atau campuran dengan tepung sagu, air dan garam dan dibentuk, kemudian direbus, digoreng atau dipanggang.",
    "Tidak Aktif",
  ],
  [
    "0902040114",
    "Pepes Ikan/Pepes Teri",
    "Pepes ikan/pepes teri adalah ikan/teri segar utuh yang telah mengalami penyiangan dan pembersihan, pelumuran bumbu-bumbu, dan pengemasan (daun) serta mengalami perebusan, penirisan, dengan atau tanpa pemanggangan.",
    "Aktif",
  ],
  ["0902040115", "Sosis Ikan", "", "Aktif"],
  ["0902040116", "Sosis Udang", "", "Tidak Aktif"],
  [
    "0902040117",
    "Palai Bada/Teri",
    "Palai bada/teri adalah ikan teri yang dicampur dengan kelapa giling dengan daun kunyit, daun mangkok, dan bumbu lainnya, dibungkus daun pisang dan dipanggang.",
    "Aktif",
  ],
  [
    "0902040118",
    "Otak-Otak Ikan Analog/Produk ikan Analog",
    "",
    "Tidak Aktif",
  ],
  [
    "0902040119",
    "Pangsit Seafood (Ikan, Udang, Cumi, dll)",
    "",
    "Aktif",
  ],
  ["0902040120", "Sosis Siap Santap", "&nbsp;", "Aktif"],
  [
    "0902040121",
    "Ikan / Cumi-Cumi / Kerang / ... Analog dalam Kaleng",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    "0902040122",
    "Olahan Ikan Berbumbu",
    "Olahan ikan berbumbu adalah berbagai jenis olahan ikan dengan bahan utama berupa daging ikan berbentuk potongan atau hancuran dengan bumbu, dengan atau tanpa penambahan bahan pangan lain, dimasak, dan dikemas.",
    "Aktif",
  ],
  [
    "0902040123",
    "Stik Kepiting Analog atau Imitation Crab Stick",
    "Stik kepiting analog atau imitation crab stick adalah produk berbahan baku surimi dengan warna pada permukaan atas menyerupai warna kepiting yang direbus, dan putih di bagian dalam, mempunyai tekstur berfilamen seperti daging kepiting, beraroma dan rasa khas kepiting.<br>",
    "Aktif",
  ],
  [
    "0902040124",
    "Bakwan Ikan (Rebus Atau Kukus)",
    "Bakwan ikan (rebus atau kukus) adalah produk ikan dari daging<br> ikan atau dari surimi yang mengalami proses pencucian; pengadonan<br> dengan garam, tepung, bumbu, dengan atau tanpa bahan pangan<br> lain; pencetakan (forming); dan perebusan atau pengukusan.<br> <br> Karakteristik dasar:<br> Kandungan daging ikan atau surimi tidak kurang dari 10%.",
    "Aktif",
  ],
  [
    "0902040125",
    "Bandeng Isi",
    "Bandeng isi adalah produk perikanan dengan bahan baku ikan<br> bandeng (Chanos chanos) yang diolah dari lumatan daging berbumbu<br> dan diisikan kembali ke dalam selubung (selongsong) kulit bandeng<br> dengan atau tanpa pelapisan daging berbumbu. Nama lain: otak-otak<br> bandeng.",
    "Aktif",
  ],
  [
    "0902040126",
    "Dimsum Ikan",
    "Dimsum ikan adalah produk perikanan dengan menggunakan<br> lumatan daging ikan dan/atau surimi, cacahan dan/atau potongan<br> daging ikan, tepung dan bahan pangan lain, dibentuk dan dibungkus<br> dengan kulit pangsit atau bahan pangan lain yang dapat dimakan<br> yang mengalami perlakuan pengukusan. Termasuk dalam produk ini<br> adalah siomay ikan, pangsit ikan, pastel ikan, samosa ikan, gyoza,<br> dan produk sejenis lainnya.<br> <br> Karakeristik dasar:<br> Kandungan lumatan daging ikan dan/atau surimi, cacahan<br> dan/atau potongan daging ikan tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "0902040127",
    "Tekwan Ikan",
    "Tekwan ikan adalah produk perikanan dengan bahan baku lumatan<br> daging ikan segar dan/atau surimi dengan penambahan tepung, air,<br> garam, dengan atau tanpa bahan pangan lain, yang dicampur dan<br> dibentuk potongan kecil-kecil dan mengalami perlakuan perebusan.<br> <br> Karakeristik dasar:<br> Kandungan lumatan daging ikan segar dan/atau surimi tidak kurang<br> dari 30%.",
    "Aktif",
  ],
  [
    "0902040128",
    "Sosis Ikan Kombinasi",
    "Sosis ikan kombinasi adalah produk perikanan dengan bahan baku<br> lumatan daging ikan atau surimi, dicampur tepung dan bahan<br> pangan lain, pengisian ke dalam selongsong sosis dan mengalami<br> perebusan atau pengukusan.<br> <br> Karakeristik dasar:<br> Kandungan lumatan daging ikan atau surimi tidak kurang dari 20%.",
    "Aktif",
  ],
  [
    "0902040129",
    "Rolade Ikan",
    "Rolade ikan adalah produk perikanan dengan bahan baku lumatan daging ikan atau surimi dengan penambahan tepung, bumbu, garam, dengan atau tanpa penambahan bahan pangan lain, dicetak, ditambahkan pelapis lalu digulung dan dikukus.<br> <br> Karakeristik dasar:<br> Kandungan lumatan daging ikan dan/atau surimi tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "0902040130",
    "Burger Ikan",
    "Burger ikan adalah produk perikanan yang dibuat dari daging ikan yang telah dilumatkan dan ditambah dengan tepung, bumbu, garam, dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakeristik dasar:<br> Kandungan lumatan daging ikan tidak kurang dari 30%.<br>",
    "Aktif",
  ],
  [
    "0902040131",
    "Tsukudani",
    "Tsukudani adalah produk perikanan yang diperoleh dengan cara perebusan dalam kecap atau bahan pangan lain, kemudian dikeringkan dengan dioven atau cara lain untuk mengurangi kadar airnya.<br>",
    "Aktif",
  ],
  [
    "0902040132",
    "Telur Ikan Masak",
    "Telur ikan masak adalah produk perikanan dengan bahan baku telur ikan segar melalui proses perebusan atau pengukusan.",
    "Aktif",
  ],
  [
    "0902040201",
    "Daging Rajungan Rebus Dingin",
    "Daging rajungan rebus dingin adalah produk yang diolah dari rajungan segar yang mengalami pencucian, perebusan, pengambilan daging, pendinginan dan pengemasan.",
    "Aktif",
  ],
  [
    "0902040202",
    "Daging Kepiting Rebus Beku",
    "Daging kepiting rebus beku adalah kepiting segar dari spesies Portunnus pelagicus, Podopthalmus vigil, Scylla serrata yang mengalami pencucian, perebusan, pembekuan dan pengemasan.",
    "Aktif",
  ],
  [
    "0902040203",
    "Lobster Rebus Beku",
    "Lobster rebus beku adalah lobster segar dari spesies Panulirus dengan atau tanpa kepala yang mengalami pencucian, perebusan, pembekuan hingga suhu pusatnya mencapai -18 C atau lebih rendah dan pengemasan.",
    "Aktif",
  ],
  [
    "0902040204",
    "Udang Kupas Rebus Beku untuk Sushi Ebi",
    "Udang kupas rebus beku untuk sushi ebi adalah produk yang diolah dari udang segar yang mengalami perlakuan pemotongan kepala, perebusan dan pengupasan kulit dengan atau tanpa ekor sebelum atau sesudah pembelahan daging sehingga membentuk kupu-kupu, dan di",
    "Aktif",
  ],
  ["0902040205", "Bakso Udang / Bakso Cumi", "-", "Aktif"],
  ["0902040206", "Siomay Udang", "&nbsp;", "Aktif"],
  [
    "0902040207",
    "Pepes Udang",
    "pepes udang adalah udang segar utuh yang telah mengalami penyiangan dan pembersihan, pelumuran bumbu-bumbu, dan pengemasan (daun) serta mengalami perebusan, penirisan, dengan atau tanpa pemanggangan.",
    "Aktif",
  ],
  [
    "0902040208",
    "Sosis Udang",
    "Sosis udang adalah produk perikanan dengan bahan baku lumatan daging udang, dicampur tepung dan bahan pangan lain, pengisian ke dalam selongsong sosis dan mengalami perebusan atau pengukusan.<br> Bahan baku yang digunakan adalah udang segar; udang beku; dan lumatan daging udang sesuai dengan spesifikasi.",
    "Aktif",
  ],
  [
    "0902040209",
    "Udang dalam Saus (Tomat, Kari, Pedas, ...)",
    "-",
    "Aktif",
  ],
  [
    "0902040210",
    "Udang dalam Saus (Tomat, Kari, Pedas, ...) (Steril)",
    "-",
    "Aktif",
  ],
  [
    "0902040211",
    "Udang dalam Saus (Tomat, Kari, Pedas, ...) dikemas Kaleng",
    "-",
    "Aktif",
  ],
  [
    "0902040212",
    "Kue Cumi/Sotong/Udang Kukus",
    "Kue cumi/sotong/udang kukus adalah produk olahan dari bahan baku lumatan daging cumi/sotong/udang yang telah mengalami pengukusan, dapat diberi potongan sayuran atau bahan pangan lain.",
    "Aktif",
  ],
  [
    "0902040213",
    "Dimsum Udang",
    "Dimsum udang adalah produk perikanan yang menggunakan udang kupas utuh, lumatan, cacahan dan/atau potongan, tepung dan bahan pangan lain, dibentuk dan dibungkus dengan kulit pangsit atau bahan pangan lainyang dapat dimakan yang mengalami perlakuan pengukusan. Termasuk dalam produk ini adalah siomay udang,pangsit udang, pastel udang, gyoza, hakau, dan produk sejenis lainnya.<br> <br> Karakeristik dasar: Kandungan udang kupas utuh, lumatan, cacahan dan/atau potongan tidak kurang dari 30%",
    "Aktif",
  ],
  [
    "0902040214",
    "Siomay Udang (Khusus Registrasi Ulang)",
    "",
    "Aktif",
  ],
  [
    "0902040301",
    "Sambal Goreng Udang",
    "Sambal goreng udang adalah makanan yang dibuat dengan<br> mengolah udang, cabai, dengan atau tanpa penambahan bahan<br> pangan lain. Bau, rasa dan warna normal khas udang.",
    "Aktif",
  ],
  [
    "0902040302",
    "Sambal Goreng Udang Kering (Ebi)",
    "Sambal goreng udang kering (ebi) adalah makanan kering yang dibuat dengan mengolah udang kering (ebi) dengan bumbu-bumbu. Bau, rasa dan warna normal khas udang.",
    "Tidak Aktif",
  ],
  [
    "0902040303",
    "Keripik Kulit Ikan Goreng",
    "Keripik kulit ikan goreng adalah produk perikanan yang dibuat dari kulit ikan segar yang mengalami proses pencucian, blansir, perendaman dalam larutan garam, penjemuran, dan penggorengan.",
    "Aktif",
  ],
  [
    "0902040304",
    "Abon Ikan",
    "Abon ikan adalah makanan kering berbentuk khas dibuat dari daging ikan, direbus, disayat-sayat / disuwir, dibumbui, digoreng dan dapat juga dipres. Abon terbuat dari berbagai jenis ikan.",
    "Aktif",
  ],
  ["0902040305", "Ikan Panggang", "-", "Aktif"],
  [
    "0902040306",
    "Cireng Seafood",
    "Cireng (singkatan dari aci digoreng, bahsa sunda untuk 'tepung kanji goreng') merupakan makanan ringan yang banyak dijumpai di daerah Jawa Barat, Cireng dibuat dengan cara menggoreng campuran adonan yang berbahan dasar tepung kanji/tapioka",
    "Aktif",
  ],
  ["0902040307", "Abon Udang", "-", "Aktif"],
  [
    "0902040308",
    "Olahan Ikan dan Produk Perikanan Termasuk Moluska, Krustase, Ekinodermata Goreng atau Panggang (Oven atau Bara)",
    "&nbsp;",
    "Aktif",
  ],
  [
    "0902040309",
    "Udang Popcorn",
    "Udang popcorn adalah makanan terbuat dari udang yang dikupas kulitnya dalam bentuk potongan kecil, yang direndam atau dibalur dengan bumbu halus kemudian dilapisi tepung dan digoreng.",
    "Aktif",
  ],
  [
    "0902040310",
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering)",
    "Bakso ikan/ moluska/ krustase/ ekinodermata (kering) adalah produk perikanan yang menggunakan lumatan daging ikan/ moluska/ krustase/ ekinodermata atau surimi, dicampur tepung, dan bahan pangan lainnya bila diperlukan, yang mengalami pembentukan, perebusan, dan penggorengan atau proses pengeringan lainnya. Bahan baku ikan yang digunakan adalah semua jenis ikan dari kelas Pisceshasil penangkapan atau budidaya. Contohnya meliputi bakso ikan kering, bakso cumi kering, bakso udang kering.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2Kandungan lumatan daging ikan atau surimi tidak kurang dari 40% (untuk bakso ikan kering);<br> \xE2\x{20AC}\xA2Kandungan lumatan daging moluska/ krustase/ ekinodermata tidak kurang dari 30% (untuk bakso moluska/ krustase/ ekinodermata kering).",
    "Aktif",
  ],
  [
    "0902040311",
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang)",
    "Kue ikan/ kamaboko/ fish cake (goreng atau panggang) adalah produk perikanan yang menggunakandaging ikan atau surimi yang mengalami proses pencucian; pengadonan dengan garam, tepung, dan bumbu; pencetakan (forming); dengan atau tanpa pengukusan, kemudian digoreng atau dipanggang sehingga membentuk tekstur yang kenyal (gel). Jenis kamaboko: kamabokogoreng, chikuwa panggang.<br> <br> Karakteristik dasar: Kandungan surimi tidak kurang dari 30%",
    "Aktif",
  ],
  [
    "0902040312",
    "Sambal Goreng Ikan",
    "Sambal goreng ikan adalah produk perikanan berupa makanan kering yang dibuat dengan mengolah ikan yang dihaluskan dengan cabai dan atau bumbu-bumbu dan digoreng. Contoh produk diantaranya sambal goreng ikan roa.<br> <br> Karakteristik dasar:<br> Kandungan ikan tidak kurang dari 30%",
    "Aktif",
  ],
  [
    "0902040313",
    "Pempek Ikan (Goreng atau Panggang)",
    "Pempek ikan (goreng atau panggang) adalah produk perikanan dengan bahan baku lumatan daging ikan segar dan/atau surimi dengan penambahan tepung, air, garam, dengan atau tanpa bahan pangan lain, yang mengalami perlakuan perebusan dan penggorengan atau pemanggangan<br> <br> Karakeristik dasar:<br> Kandungan lumatan daging ikan segar dan/atau surimi tidak kurang dari 30%",
    "Aktif",
  ],
  [
    "0902040314",
    "Ikan Renyah",
    "Ikan renyah adalah produk perikanan dengan bahan baku ikan yang mengalami penambahan bumbu dengan dan atau tanpa tepung dan digoreng hingga renyah. Bahan baku adalah semua jenis ikan utuh segar. Contoh produk adalah ikan wader goreng, ikan bilis goreng.",
    "Aktif",
  ],
  [
    "0902040315",
    "Keripik Ikan",
    "Keripik ikan adalah produk perikanan dengan bahan baku ikan hidup atau bagian ikan yang mengalami perlakuan penambahan bumbu, dengan atau tanpa penambahan tepung dan digoreng. Produk sejenis lainnya antara lain keripik ikan teri, keripik kulit ikan, keripik lele, keripik patin, dan produk sejenis lainnya.<br> <br> Note: Keripik adalah produk buah, ubi, sayur, atau bahan lainnya berbentuk pipih atau bentuk lainnya dicampur atau tanpa dicampur dengan adonan tepung dan bumbu serta langsung digoreng.",
    "Aktif",
  ],
  [
    "0902040316",
    "Keripik Belut",
    "Keripik belut adalah produk perikanan dengan bahan baku belut (Monopterus albus) hidup yang mengalami perlakuan penambahan bumbu, dengan atau tanpa penambahan tepung dan digoreng.<br> <br> Note: Keripik adalah produk buah, ubi, sayur, atau bahan lainnya berbentuk pipih atau bentuk lainnya dicampur atau tanpa dicampur dengan adonan tepung dan bumbu serta langsung digoreng.",
    "Aktif",
  ],
  [
    "0902040317",
    "Tortila Ikan",
    "Tortila ikan adalah produk perikanan dengan bahan baku ikan,<br> dengan penambahan tepung, bumbu, pencetakan, dan digoreng.",
    "Aktif",
  ],
  [
    "0902040318",
    "Rendang Ikan Tuna",
    "Rendang ikan tuna adalah produk perikanan dengan bahan baku ikan tuna yang dimasak dalam santan dan bumbu rendang dengan atau tanpa penambahan bahan pangan lain.<br> Bumbu rendang terdiri dari campuran cabe merah, bawang merah, bawang putih, jahe,lengkuas, ketumbar, kunyit, dan sereh yang dihaluskan. Daun jeruk, daun kunyit dan asam kandis ditambahkan dalam bentuk utuh atau dihaluskan.",
    "Aktif",
  ],
  [
    "0902040319",
    "Rendang Kerang",
    "Rendang kerang adalah produk perikanan dengan bahan baku kerang lokan (Polymesoda expansa) yang dimasak dalam santan dan bumbu rendang dengan atau tanpa penambahan bahan pangan lain.<br> <br> Bumbu rendang terdiri dari campuran cabe merah, bawang merah, bawang putih, jahe, lengkuas, ketumbar, kunyit, dan sereh yang dihaluskan. Daun jeruk, daun kunyit dan asam kandis ditambahkan dalam bentuk utuh atau dihaluskan.<br>",
    "Aktif",
  ],
  [
    "09020501",
    "Ikan Asap",
    "Ikan asap adalah ikan segar yang mengalami perlakuan penyiangan, pencucian dengan atau tanpa perendaman dalam larutan garam, penirisan, pemberian rempah dan pengasapan menggunakan kayu, sabut atau tempurung kelapa.",
    "Aktif",
  ],
  [
    "09020503",
    "Ikan Asin Kering",
    "Ikan asin kering adalah produk olahan yang berasal dari ikan segar dalam bentuk utuh atau disiangi, dengan atau tanpa mengalami perlakuan (perebusan, pemasakan dengan penambahan garam, gula, vinegar atau rempah-rempah), selanjutnya dilakukan penggaraman d",
    "Aktif",
  ],
  [
    "09020504",
    "Ikan Teri Asin Kering",
    "Ikan teri asin kering adalah produk olahan ikan teri dengan perlakuan pencucian, penggaraman, dengan atau tanpa perebusan, pengeringan, pengemasan dan penyimpanan.",
    "Aktif",
  ],
  [
    "09020506",
    "Kerupuk Ikan",
    "Kerupuk ikan adalah produk pangan kering yang dibuat dari tepung pati atau tepung lainnya, daging ikan dengan atau tanpa penambahan bahan lainnya.",
    "Aktif",
  ],
  [
    "09020508",
    "Udang Kering",
    "Udang kering adalah produk olahan udang dengan perlakuan pencucian, perebusan dengan atau tanpa garam, pengeringan, pelepasan kulit dan kaki serta kepala udang, pengemasan dan penyimpanan.",
    "Aktif",
  ],
  [
    "09020510",
    "Kerupuk Udang Mentah",
    "Kerupuk udang adalah hasil olahan dari campuran yang terdiri dari udang segar, tepung tapioka dan bahan lain yang dicetak, dikukus dan dikeringkan.",
    "Aktif",
  ],
  [
    "09020517",
    "Terasi Udang",
    "Terasi udang adalah daging udang atau rebon segar atau campurannya yang dicampur dengan adonan dan bahan tambahan lainnya membentuk pasta kemudian dikeringkan dan difermentasi.",
    "Aktif",
  ],
  [
    "09020518",
    "Pasta Ikan",
    "Pasta ikan adalah produk bentuk pasta yang diperoleh dari fermentasi ikan.",
    "Aktif",
  ],
  [
    "09020521",
    "Masin",
    "Masin adalah produk yang diperoleh dari hasil fermentasi udang kecil segar atau rebon dari spesies Acetes dengan atau penambahan nasi atau karbohidrat lain (gula) serta bumbu.",
    "Aktif",
  ],
  [
    "09020522",
    "Tepung Ikan",
    "Tepung ikan adalah produk pangan yang dihasilkan dengan<br> mengeluarkan sebagian atau seluruh lemak dari daging ikan, dikeringkan dan digiling membentuk bubuk tepung kering.",
    "Aktif",
  ],
  [
    "09020523",
    "Pasta Gonad Bulu Babi",
    "Pasta gonad bulu babi adalah pasta yang diperoleh dari hasil fermentasi gonad atau telur bulu babi (baik jantan maupun betina) dengan penambahan garam 30% hingga 34%.",
    "Aktif",
  ],
  [
    "09020524",
    "Ikan Kering",
    "Ikan kering adalah produk olahan ikan dengan perlakukan penyiangan, pencucian, pengeringan dengan cara pengasapan dan atau penjemuran.",
    "Aktif",
  ],
  ["09020525", "Kitosan (Chitosan)", "-", "Aktif"],
  [
    "09020527",
    "Kerupuk Kulit Ikan Mentah",
    "Kerupuk kulit ikan mentah adalah produk perikanan yang dibuat dari kulit ikan segar yang mengalami proses pencucian, blansir, perendaman dalam larutan garam, dan pengeringan.",
    "Aktif",
  ],
  [
    "09020528",
    "Dendeng Ikan",
    "Dendeng ikan adalah produk perikanan dengan bahan baku ikan segar yang mengalami perlakukan penambahan bumbu-bumbu dengan rasa yang khas dan pengeringan.",
    "Aktif",
  ],
  [
    "09020529",
    "Ebi Bubuk",
    "Ebi bubuk adalah produk perikanan dengan bahan baku udang kering tanpa kulit yang digiling menjadi bentuk bubuk.",
    "Aktif",
  ],
  [
    "09020530",
    "Ikan Asin Jambal Roti",
    "Ikan asin jambal roti adalah produk perikanan hasil fermentasi dari bahan baku ikan manyung (genus Arius sp., Perciformes sp.) sehingga produk akhir mempunyai tekstur masir (berlapis berbutirbutir) dan aroma yang spesifik. Bentuk produk akhir: belah dengan atau tanpa kepala, dengan atau tanpa tulang belakang potongan daging, serta bentuk lain selain bentuk di atas.",
    "Aktif",
  ],
  [
    "09020531",
    "Ikan Peda",
    "Ikan peda adalah produk perikanan dari bahan baku ikan kembung (genus Rastrelliger) yang mengalami penggaraman dan fermentasi.",
    "Aktif",
  ],
  [
    "09020532",
    "Rusip",
    "Rusip adalah produk perikanan yang dibuat dari ikan teri melalui proses fermentasi dengan atau tanpa penambahan karbohidrat. Dapat mengandung bumbu dan bahan pangan lain untuk mendapatkan flavor yang diinginkan. Rusip berfungsi sebagai kondimen.",
    "Aktif",
  ],
  [
    "09020533",
    "Rebon",
    "Rebon adalah produk perikanan dengan bahan baku udang (Acetes sp.) yang telah mengalami perlakuan dengan atau tanpa perebusan atau pengukusan, dan pengeringan.",
    "Aktif",
  ],
  [
    "09020534",
    "Cumi dan Sotong Kering",
    "Cumi dan sotong kering adalah produk perikanan dari bahan baku cumi-cumi (Loligo spp) dan sotong (Sephia spp) dengan karakteristik produk akhir yang kering, rasa asin atau tawar, dan aroma spesifik.",
    "Aktif",
  ],
  [
    "09030101",
    "Rollmops",
    "Rollmops adalah suatu jenis ikan haring yang direndam dalam bumbu.",
    "Aktif",
  ],
  [
    "09030102",
    "Sea Gel",
    "Sea gel adalah dogfish dalam jeli",
    "Aktif",
  ],
  ["09030103", "Aspic Ikan", "", "Aktif"],
  ["09030104", "Fish Tsukudani", "", "Aktif"],
  [
    "09030201",
    "Fish Koji-zuke",
    "Fish koji-zuke adalah ikan pikel koji.",
    "Aktif",
  ],
  [
    "09030202",
    "Fish Kasu-zuke",
    "Fish kasu-zuke adalah ikan pikel lees.",
    "Aktif",
  ],
  [
    "09030203",
    "Fish Miso-zuke",
    "Fish miso-zuke adalah ikan pikel miso.",
    "Aktif",
  ],
  [
    "09030204",
    "Fish Shoyu-zuke",
    "Fish shoyu-zuke adalah ikan pikel saus kedelai.",
    "Aktif",
  ],
  [
    "09030205",
    "Fish Su-zuke",
    "Fish su-zuke adalah ikan pikel vinegar.",
    "Aktif",
  ],
  [
    "09030206",
    "Pikel Daging Anjing Laut (Pickled Whale)",
    "",
    "Aktif",
  ],
  [
    "09030301",
    "Telur Ikan",
    "Telur ikan dihasilkan dari pencucian, penggaraman dan pemeraman sampai dihasilkan produk yang transparan.",
    "Aktif",
  ],
  [
    "09030307",
    "Ikura",
    "Ikura adalah ikan salmon yang diolah dan digarami.",
    "Aktif",
  ],
  ["09030311", "Telur Ikan dalam Kaleng", "&nbsp;", "Aktif"],
  [
    "090401",
    "Ikan Kalengan",
    "Ikan kalengan adalah produk yang diperoleh dari ikan segar atau<br> potongan ikan segar dan dihilangkan isi perutnya, dicuci dengan air bersih, disusun dalam kaleng, dengan atau tanpa diberi media, dengan atau tanpa bumbu-bumbu atau bahan lainnya, kemudian di",
    "Aktif",
  ],
  [
    "090402",
    "Tuna Dalam Kemasan",
    "Tuna dalam kemasan adalah produk yang terdiri dari daging yang diolah dari jenis tuna (Thunnus spp.), tongkol (Euthynnus spp., Auxis spp.), cakalang (Katsuwonnus spp.), dan bonito (Sarda spp.) yang<br> dikemas secara hermetis dan menerima perlakuan proses yang cukup untuk menjamin sterilitas komersial.<br> Wujud produk akhir:<br> \x{2022} Solid \x{2013} potongan daging tuna yang utuh dan memenuhi seluruh penampang kemasan. Proporsi lempengan (flake) atau chunk tidak lebih dari 18% dari bobot tuntas.<br> \x{2022} Chunk \x{2013} potongan daging tuna dengan dimensi minimum 1,2 cm. Proporsi serpihan daging tuna dengan diameter kurang dari 1,2 cm tidak melebihi 30% dari bobot tuntas.<br> \x{2022} Flake atau flakes \x{2013} serpihan daging tuna dengan dimensi kurang dari 1,2 cm.<br> \x{2022} Grated atau shredded \x{2013} daging tuna yang lebih kecil dari serpihan.<br> <br> Karakteristik dasar:<br> Bobot tuntas tidak kurang dari 60%.",
    "Aktif",
  ],
  [
    "090404",
    "Kerang Dalam Kaleng",
    "Kerang dalam kaleng adalah kerang (arca spesies) segar tanpa kulit dalam larutan garam yang disterilisasi atau pasteurisasi dengan cara pemanasan.",
    "Aktif",
  ],
  [
    "090405",
    "Daging Rajungan Dalam Kaleng",
    "Daging rajungan dalam kaleng adalah produk dari daging bagian kaki, cakar, badan dan bahu rajungan segar dari sub ordo Brachyura dari ordo Decapoda dan semua spesies dari famili Lithodidae yang mengalami proses pencucian, perebusan, pengambilan daging, de",
    "Aktif",
  ],
  [
    "090408",
    "Sarden dan Makerel dalam Kemasan Kaleng",
    "Sarden dan makerel dalam kemasan kaleng diolah dari ikan segar atau beku dari genus berikut :<br> - Sardinella spp.<br> - Clupea spp.<br> - Scomber spp.<br> - Decapterus spp.<br> Produk mengacu pada SNI 8222 : 2016<br> Ruang lingkup : standar ini hanya berlaku untuk jenis ikan sarden dan makerel dalam medium air atau minyak atau medium lain yang sesuai yang dikemas dalam kaleng dengan bobot tuntas minimum 50%.<br>",
    "Aktif",
  ],
  [
    "090409",
    "Sarden Media Saus Tomat",
    "Sarden media saus tomat adalah produk yang dibuat dari jenis sarden segar maupun beku dari spesies: Sardina pilchardus; Sardinops melanostictus, S. neopilchardus, S. ocellatus, S. sagax S. caeruleus,; Sardinella aurita, S. brasiliensis, S. maderensis, S.",
    "Tidak Aktif",
  ],
  [
    "090410",
    "Moluska (Kerang, Bekicot, Siput Laut\xE2\x{20AC}\xA6.) dalam Kaleng",
    "Moluska (Kerang, Bekicot, Siput Laut\xE2\x{20AC}\xA6.) dalam kaleng adalah produk yang dibuat dari moluska segar, seperti bekicot segar dari spesies Achatina fulica, Helix aspersa, H. pomatia yang dikemas secara kedap (hermetis) dengan media air atau larutan garam, disterilkan dengan cara pemanasan.",
    "Aktif",
  ],
  ["090411", "Kornet Ikan", "-", "Aktif"],
  [
    "090412",
    "Nasi Dengan Lauk Ikan Dalam Kaleng",
    "-",
    "Tidak Aktif",
  ],
  [
    "090413",
    "Ikan dan Produk Perikanan (Termasuk Moluska, Krustase, dan Ekinodermata) dalam Kemasan (Sterilisasi)",
    "-",
    "Aktif",
  ],
  [
    "090414",
    "Sosis Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    "Sosis ikan/moluska/krustase/ekinodermata siap santap adalah produk dari lumatan daging ikan/moluska/krustase/ ekinodermata atau surimi, dengan tambahan tepung atau pati, dengan atau tanpa<br> penambahan bumbu dan bahan pangan lain dan dimasukkan ke dalam selongsong sosis yang kedap udara dan dilakukan sterilisasi, dapat dimakan langsung tanpa dimasak.<br> <br> Karakteristik dasar:<br> Kandungan lumatan daging ikan/moluska/krustase/ekinodermata<br> atau surimi tidak kurang dari 30%.<br>",
    "Aktif",
  ],
  [
    "090415",
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    "Otak-otak ikan/moluska/krustase/ekinodermata siap santap adalah produk perikanan yang menggunakan lumatan daging ikan/moluska/krustase/ekinodermata dicampur tepung/pati dengan atau tanpa bahan pangan lain, dikemas dengan bahan yang sesuai, dan dilakukan sterilisasi, dapat dimakan langsung tanpa dimasak.<br> <br> Karakteristik dasar:<br> Kandungan daging ikan/moluska/krustase/ekinodermata tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "090416",
    "Cumi-cumi Dalam Kemasan",
    "Cumi-cumi dalam kemasan adalah produk perikanan dengan bahan<br> baku cumi (Loligo spp.) yang dikemas dalam suatu wadah hermetis<br> yang mengalami perlakuan pengolahan untuk menjamin sterilitas<br> komersial.",
    "Aktif",
  ],
  [
    "090417",
    "Sotong Dalam Kemasan",
    "Sotong dalam kemasan adalah produk perikanan dengan bahan<br> baku sotong segar yang mengalami perlakuan perebusan,<br> perendaman dalam air dingin, pengisian dan penimbangan,<br> pengisian media, penutupan kaleng secara hermetis, dan sterilisasi.",
    "Aktif",
  ],
  [
    "090418",
    "Ikan Dalam Kemasan",
    "Ikan dalam kemasan adalah produk perikanan yang dikemas secara<br> hermetis (misalnya plastik/laminat autoclavable/retortable) dalam<br> media air garam, minyak, atau media lain yang sesuai, dan<br> menerima perlakuan proses yang cukup untuk menjamin sterilitas<br> komersial. Kategori ini mencakup semua produk ikan dalam<br> kemasan yang tidak termasuk kategori di atas.",
    "Aktif",
  ],
  [
    "090419",
    "Olahan Ikan Dalam Kemasan",
    "Olahan ikan dalam kemasan adalah berbagai jenis olahan ikan<br> dengan bahan utama berupa daging ikan/ moluska/ krustase/<br> ekinodermata yang berbentuk potongan atau hancuran, dengan atau<br> tanpa penambahan bahan pangan lain, dikemas dalam kaleng atau<br> kemasan lain secara hermetis (misalnya plastik/laminat<br> autoclavable/retortable) dan diproses dengan perlakuan panas yang<br> cukup untuk menjamin stabilitas dan keamanan produk, dengan<br> bentuk akhir padat atau semi-padat. Jenis produk untuk kategori ini<br> antara lain tuna dalam mayonais, tuna berbumbu, kornet tuna.",
    "Aktif",
  ],
  [
    10020104,
    "Telur Cair Campuran /Premiks Telur Cair",
    "Telur cair campuran /premiks telur cair adalah produk dengan bahan utama telur cair (telur utuh, putih telur, kuning telur, atau campurannya) atau tepung telur (utuh, putih telur, atau kuning telur) dan ditambah bahan pangan lain. Nama jenis produk antara lain telur cair utuh campuran, putih telur cair campuran, kuning telur cair campuran.<br> <br> Karakteristik dasar:<br> Kandungan telur tidak kurang dari 50% dihitung sebagai telur cair atau tidak kurang dari 11,5% dihitung sebagai tepung telur.<br>",
    "Aktif",
  ],
  [
    10020201,
    "Telur Beku Utuh",
    "Telur beku utuh adalah produk telur yang diperoleh dari proses pembekuan telur cair utuh dengan atau tanpa penambahan bahan pangan lain. Termasuk produk tamagoyaki moto.",
    "Aktif",
  ],
  [
    10020202,
    "Putih Telur Beku",
    "Putih telur beku adalah produk telur yang diperoleh dari proses<br> pembekuan putih telur cair. Dapat ditambahkan ingredien lain untuk membantu pengembangan telur (whipping aids).",
    "Aktif",
  ],
  [
    10020203,
    "Kuning Telur Beku",
    "Kuning telur beku adalah produk telur yang diperoleh dari proses pembekuan kuning telur cair.",
    "Aktif",
  ],
  [
    10020204,
    "Telur Campuran Beku/Premiks Telur Beku",
    "Telur campuran beku/premiks telur beku adalah produk dengan bahan utama telur cair (telur utuh, putih telur, kuning telur, atau campurannya) atau tepung telur (utuh, putih telur, atau kuning telur) ditambah bahan pangan lain, kemudian dibekukan. Nama jenis produk antara lain telur utuh campuran beku, putih telur campuran beku, kuning telur campuran beku.<br> Karakteristik dasar:<br> Kandungan telur tidak kurang dari 50% dihitung sebagai telur cair atau tidak kurang dari 11,5% dihitung sebagai tepung telur.",
    "Aktif",
  ],
  [
    10020301,
    "Tepung Telur Utuh",
    "Tepung telur utuh adalah produk telur yang diperoleh dari proses pengeringan telur utuh cair dalam bentuk tepung atau granula.",
    "Aktif",
  ],
  [
    10020303,
    "Tepung Kuning Telur",
    "Tepung kuning telur adalah produk telur yang diperoleh dari proses pengeringan kuning telur cair. Sebelum proses pengeringan, kandungan glukosa kuning telur cair dapat dikurangi.",
    "Aktif",
  ],
  [10020304, "Produk Olahan Telur Bentuk Sosis", "-", "Aktif"],
  [
    10020305,
    "Rendang Telur",
    "Rendang telur adalah produk telur yang diperoleh dengan mencampurkan telur utuh atau telur dadar dengan bumbu rendang dan santan, dengan atau tanpa penambahan bahan pangan lain, dimasak sampai berminyak dan kering. Produk ini berwarna coklat kehitaman.<br>",
    "Aktif",
  ],
  [
    10020306,
    "Telur Matang/Setengah Matang",
    "Telur matang/setengah matang adalah telur utuh dalam kerabang yang dipanaskan sampai terkoagulasi sebagian (setengah matang) atau terkoagulasi seluruhnya (matang).",
    "Aktif",
  ],
  [
    10020307,
    "Tepung Telur Campuran/Premiks Tepung Telur",
    "Tepung telur campuran/premiks tepung telur adalah produk dengan bahan utama tepung telur (utuh, putih telur, atau kuning telur) dan bahan pangan lain. Nama jenis produk antara lain tepung telur utuh campuran, tepung putih telur campuran, tepung kuning telur campuran.<br> <br> Karakteristik dasar:<br> Kandungan tepung telur tidak kurang dari 11,5%",
    "Aktif",
  ],
  [
    100301,
    "Telur Asin Mentah",
    "Telur asin mentah adalah produk telur yang diperoleh dari telur itik yang telah diasinkan dengan proses tertentu sehingga kadar garam tidak kurang dari 2%, dan belum dimasak.",
    "Aktif",
  ],
  [
    100302,
    "Telur Asin Matang",
    "Telur asin matang adalah produk telur yang diperoleh dari telur itik yang telah diasinkan dengan proses tertentu sehingga kadar garam tidak kurang dari 2%, dibersihkan dan direbus hingga matang.",
    "Aktif",
  ],
  [
    100303,
    "Telur Pindang",
    "Telur pindang adalah produk telur yang diperoleh dari proses pengawetan telur tradisional dengan cara perebusan telur dalam air yang ditambahkan daun jambu biji/daun jati/daun teh, kulit bawang merah dan daun salam. Telur direbus dalam larutan yang ditambahkan garam untuk rasa gurih. Kerabang telur berwarna coklat kemerahan.",
    "Aktif",
  ],
  [
    100304,
    "Pidan atau Telur Hitam",
    "Pidan atau telur hitam adalah produk telur yang diperoleh dari proses pengawetan telur dengan cara diperam dalam adonan yang mengandung alkali sebagai bahan pengawet. Putih telur berbentuk padat seperti jeli, berwarna coklat kehitaman transparan. Kuning telur berwarna abu-abu kehijauan.",
    "Aktif",
  ],
  [
    100305,
    "Halidan",
    "Halidan adalah produk telur yang diperoleh dari proses pengawetan telur dengan cara pembungkusan telur dalam campuran tanah liat atau serbuk gergaji, garam, kapur yang kemudian dicampur dengan air teh.",
    "Aktif",
  ],
  [
    100306,
    "Dsaudan",
    "Dsaudan adalah produk telur yang diperoleh dari proses pengawetan dengan cara pembungkusan dengan nasi dan garam.",
    "Aktif",
  ],
  [100307, "Telur Diawetkan Dengan Cara Lain", "", "Aktif"],
  [100308, "Telur Fermentasi", "", "Aktif"],
  [
    100309,
    "Telur Olahan Steril",
    "Telur olahan steril adalah produk telur dengan atau tanpa kerabang, dengan atau tanpa bumbu, dikemas secara kedap (hermetis), dan diawetkan melalui proses sterilisasi. Contoh produk meliputi telur gulai steril, telur pindang steril, telur balado steril, telur asin steril.",
    "Aktif",
  ],
  [
    100401,
    "Selai Kaya",
    "Selai kaya adalah produk telur yang diperoleh dari pengolahan campuran telur, gula, santan dengan atau tanpa penambahan pati dan bahan pangan lain.",
    "Aktif",
  ],
  [
    100402,
    "Custard",
    "Custard adalah produk telur yang diperoleh dari campuran telur, susu dan lemak lain yang dikentalkan dengan bahan pengental, disajikan langsung maupun digunakan sebagai topping dan pengisi. Dapat berasa manis maupun asin.",
    "Aktif",
  ],
  [
    100403,
    "Custard Beku",
    "Custard beku adalah produk telur yang diperoleh dari custard yang dibekukan, sehingga memiliki karakteristik seperti es krim, tetapi dengan kadar air lebih rendah.",
    "Aktif",
  ],
  [
    100404,
    "Tepung Custard",
    "Tepung custard adalah produk tepung yang diperoleh dari custard yang dikeringkan.",
    "Aktif",
  ],
  [
    100405,
    "Martabak Telur",
    "Martabak telur adalah produk telur yang diperoleh dari penggorengan campuran telur ayam atau bebek dengan daging dan sayuran lain yang dibungkus dalam lapisan adonan tepung.",
    "Aktif",
  ],
  [100406, "Selai Kaya (Steril)", "", "Aktif"],
  [
    11010101,
    "Dekstrosa Anhidrat",
    "Dekstrosa anhidrat adalah D-glukosa yang dimurnikan dan dikristalkan tanpa kristalisasi air, mengandung D-glukosa tidak kurang dari 99,5% dan kadar total padatan tidak kurang dari 98%.",
    "Aktif",
  ],
  [
    11010102,
    "Dekstrosa Monohidrat",
    "Dekstrosa monohidrat adalah D-glukosa yang dimurnikan dan dikristalkan dengan kristalisasi satu molekul air, mengandung D-glukosa tidak kurang dari 99,5% dan kadar total padatan tidak kurang dari 90%.",
    "Aktif",
  ],
  [
    11010103,
    "Fruktosa",
    "Fruktosa adalah D-fruktosa yang dimurnikan dan dikristalkan, mengandung D-fruktosa tidak kurang dari 95% dan glukosa tidak lebih dari 0,5%.",
    "Aktif",
  ],
  [
    11010201,
    "Gula Serbuk (Icing Sugar) / Tepung Gula / Gula Halus",
    "Gula serbuk (icing sugar) adalah gula putih yang digiling sampai halus dengan atau tanpa penambahan antikempal.",
    "Aktif",
  ],
  [
    11010202,
    "Dektrosa Serbuk (Icing Dextrose)",
    "Dektrosa serbuk (icing dextrose) adalah dekstrosa anhidrat atau dekstrosa monohidrat, atau campuran keduanya yang digiling sampai halus, dengan atau tanpa penambahan antikempal.",
    "Aktif",
  ],
  [
    11010302,
    "Gula Merah Lunak",
    "Gula merah lunak atau soft brown sugar adalah kristal halus gula yang telah dimurnikan dan berwarna coklat terang hingga coklat gelap. Gula merah lunak mengandung sukrosa dan gula invert tidak kurang dari 88%.",
    "Aktif",
  ],
  [
    11010303,
    "Sirup Glukosa",
    "Sirup glukosa adalah cairan kental dan jernih yang komposisi utamanya glukosa diperoleh dari hidrolisa pati dan/atau inulin. Kadar gula tidak kurang dari 20% dihitung sebagai D-glukosa.",
    "Aktif",
  ],
  [
    11010305,
    "Gula Pasir Mentah",
    "Gula pasir mentah adalah kristal sukrosa yang sebagian dimurnikan yang diperoleh dari cairan gula yang dimurnikan sebagian tanpa proses pemurnian lebih lanjut.",
    "Aktif",
  ],
  [
    11010306,
    "Glukosa",
    "Glukosa adalah padatan yang diperoleh dari proses hidrolisis pati. Mengandung gula pereduksi tidak kurang dari 70% yang dihitung sebagai dekstrosa anhidrat.",
    "Aktif",
  ],
  [11010309, "Sirup Maltosa", "&nbsp;", "Aktif"],
  [11010310, "Gula Kastor", "-", "Tidak Aktif"],
  [
    11010311,
    "Gula Tebu Mentah",
    "Gula tebu mentah adalah sukrosa yang peroleh dari proses pemurnian sebagian dari sari tebu dan dikristalkan.",
    "Aktif",
  ],
  [
    11010401,
    "Laktosa",
    "Laktosa adalah gula alami yang terdapat dalam susu dan diperoleh dari whey, dapat berbentuk anhidrat atau monohidrat atau campuran keduanya. Kandungan laktosa tidak kurang dari 99%.",
    "Aktif",
  ],
  [
    11010501,
    "Gula Kristal Putih atau Gula Pasir",
    "Gula kristal putih atau gula pasir adalah gula sukrosa kristal yang diproduksi dari bahan baku tebu atau bit melalui tahapan proses yang meliputi penggilingan, klarifikasi, penguapan, kristalisasi, fugalisasi, pengeringan dan pengemasan. Nilai polarisasi",
    "Tidak Aktif",
  ],
  [
    11010502,
    "Gula Kristal Putih (GKP1)",
    "Gula kristal yang dibuat dari tebu atau bit melalui proses sulfitasi/karbonatasi/fosfatasi atau proses lainnya sehingga langsung dapat dikonsumsi. Persyaratan mutu sesuai dengan syarat mutu gula kristal putih GKP1 sesuai SNI 3140.3:2010.",
    "Aktif",
  ],
  [
    11010503,
    "Gula Kristal Putih (GKP2)",
    "Gula kristal yang dibuat dari tebu atau bit melalui proses sulfitasi/karbonatasi/fosfatasi atau proses lainnya sehingga langsung dapat dikonsumsi. Persyaratan mutu sesuai dengan syarat mutu gula kristal putih GKP2 sesuai SNI 3140.3:2010.",
    "Aktif",
  ],
  [
    110201,
    "Gula Aren",
    "Gula aren adalah produk yang diperoleh dari pengolahan air nira pohon aren (Arenga pinnata Merr). Kadar gula tidak kurang dari 77% dihitung sebagai sakarosa.",
    "Aktif",
  ],
  [
    110202,
    "Gula Palma",
    "Gula palma adalah gula yang dihasilkan dari pengolahan nira pohon palma yaitu aren (Arenga pinata Merr), kelapa (Cocos nucifera), siwalan (Barassus flabellifer L) atau jenis palma lainnya, dan berbentuk sesuai cetakannya atau serbuk/granula.",
    "Aktif",
  ],
  [
    110203,
    "Gula Merah Tebu/Saka",
    "Gula merah tebu adalah gula yang berasal dari pengolahan air tebu melalui pemasakan dan berwarna kecoklatan bentuknya sesuai cetakan.",
    "Aktif",
  ],
  [
    110204,
    "Gula Kelapa",
    "Gula kelapa adalah produk yang diperoleh dari pengolahan air nira pohon kelapa (Cocos nucifera Linn) yang berbentuk hablur. Kadar gula tidak kurang dari 77% dihitung sebagai sakarosa.",
    "Aktif",
  ],
  [
    110205,
    "Gula Semut",
    "Gula semut adalah gula yang diperoleh dari pengolahan nira pohon palma (Famili Palmae) yang berbentuk hablur. Kadar gula tidak kurang dari 80% dihitung sebagai sakarosa",
    "Aktif",
  ],
  [
    110206,
    "Gula Coklat Sukrosa",
    "Gula Coklat Sukrosa adalah gula yang dihasilkan dari pengolahan gula sukrosa dengan atau tanpa penambahan nira pohon palma atau gula merah palma atau tetes tebu (molases) atau campurannya, berbentuk padat serbuk atau kristal dan berwarna coklat.",
    "Aktif",
  ],
  [
    110207,
    "Gula Palma Serbuk (Gula Semut)",
    "Gula palma (gula semut) adalah gula yang dihasilkan dari pengolahan nira pohon palma yaitu aren (Arenga pinata Merr), kelapa (Cocos nucifera), siwalan (Barassus flabellifer L) atau jenis palma lainnya, dan berbentuk serbuk/granula. Contoh nama jenis gula semut atau gula palma serbuk. Karakteristik dasar: Kadar air tidak lebih dari 3%.",
    "Aktif",
  ],
  [
    11030101,
    "Sirup Fruktosa (High Fructose Syrup/HFS) 42",
    "Sirup fruktosa (high fructose syrup/HFS) adalah cairan kental jernih dengan<br> kadar fruktosa tinggi, umumnya diperoleh dengan proses enzimatik pati.",
    "Aktif",
  ],
  [
    11030102,
    "Sirup Fruktosa (High Fructose Syrup/HFS) 55",
    "Sirup fruktosa (high fructose syrup/HFS) adalah cairan kental jernih dengan<br> kadar fruktosa tinggi, umumnya diperoleh dengan proses enzimatik pati.",
    "Aktif",
  ],
  [
    11030103,
    "Sirup Fruktosa (High Fructose Syrup/HFS) 42 dan HFS 55",
    "Sirup fruktosa (high fructose syrup/HFS) adalah cairan kental jernih dengan<br> kadar fruktosa tinggi, umumnya diperoleh dengan proses enzimatik pati.",
    "Aktif",
  ],
  [
    110302,
    "Tetes Tebu atau Molases",
    "Tetes tebu atau molases adalah hasil ikutan pabrik gula berupa cairan kental berwarna coklat kehitaman, berbau khas, memiliki rasa sepat manis sebagai produk dari proses pemisahan terakhir gula kristal dari masakan tebu (Saccharum officinarum L) tanpa pen",
    "Aktif",
  ],
  [
    110303,
    "Gula Invert",
    "Gula invert adalah campuran glukosa dan fruktosa dalam konsentrasi ekimolar yang sama dan merupakan hasil hidrolisis sukrosa.",
    "Aktif",
  ],
  [
    110305,
    "Sirup Jagung",
    "Sirup jagung adalah cairan gula kental yang dibuat dari hidrolisis pati jagung.<br>",
    "Aktif",
  ],
  [
    110306,
    "Sirup Tebu (Cane Syrup)",
    "Sirup tebu (cane syrup) adalah produk cair yang diperoleh dengan proses pemekatan dan pemanasan sari tebu (Saccharum officinarum L.) atau dari pelarutan pekatan gula tebu yang terbuat dari sari tebu.",
    "Aktif",
  ],
  [
    110307,
    "Gula Sukrosa Cair",
    "Gula sukrosa cair adalah produk gula berupa cairan jernih mengandung sukrosa yang diperoleh melalui proses pemekatan cairan dari tebu atau umbi bit, atau proses pelarutan gula pasir dalam air. Gula pasir (kristal sukrosa) dapat berupa gula kristal mentah, gula kristal putih, atau gula kristal rafinasi.<br> <br> Karakteristik dasar:<br> Kadar sukrosa minimal 65% \xBA Brix",
    "Aktif",
  ],
  [
    110401,
    "Sirup Tebu (Cane Syrup)",
    "Sirup tebu (cane syrup) adalah produk cair yang diperoleh dengan proses pemekatan dan pemanasan sari tebu (Saccharum officinarum L.) atau dari pelarutan pekatan gula tebu yang terbuat dari sari tebu.",
    "Tidak Aktif",
  ],
  [
    110402,
    "Sirup Maple (Maple Syrup)",
    "Sirup maple (maple syrup) adalah produk cairan yang diperoleh dengan proses pemekatan cairan eksudat (sap) pohon maple (Acer) atau larutan gula maple (maple concrete) yang dibuat dari cairan sap.",
    "Aktif",
  ],
  [
    110404,
    "Sirup/Sirup Meja (Table Syrup)",
    "Sirup meja (table syrup) adalah larutan 65% gula (sakarosa, gula invert dan fruktosa).",
    "Aktif",
  ],
  [
    110405,
    "Sirup Untuk Hiasan Produk Bakeri dan Es (Sirup Karamel, Sirup Beraroma)",
    "Sirup Untuk Hiasan Produk Bakeri dan Es (Sirup Karamel, Sirup Beraroma)",
    "Aktif",
  ],
  [110406, "Gula Batu", "-", "Aktif"],
  [
    110407,
    "Sirup Agave",
    "Sirup Agave adalah sirup yang diperoleh dari tanaman Agave.",
    "Aktif",
  ],
  [
    110408,
    "Gula Hias",
    "Gula hias adalah gula untuk hiasan kue (contohnya kristal gula berwarna untuk kukis).",
    "Aktif",
  ],
  [110409, "Gula Aren Cair", "-", "Aktif"],
  [
    110501,
    "Madu",
    "Madu adalah cairan manis yang dihasilkan oleh lebah madu berasal dari berbagai sumber nektar. Aktivitas enzim diastase tidak kurang dari 3 DN.",
    "Aktif",
  ],
  [
    110502,
    "Serbuk Madu",
    "Serbuk madu adalah produk yang diperoleh dari campuran madu dengan tepung atau bahan lainnya yang dikeringkan.",
    "Aktif",
  ],
  [
    110503,
    "Madu Sarang (Comb Honey)",
    "Madu Sarang (Comb Honey) adalah madu yang disimpan dalam sarang madu (honeycomb) yang diproduksi oleh lebah dan belum mengalami pengolahan apapun untuk memisahkan madu dari lilin madu (beeswax). Madu Sarang (Comb Honey) harus bebas dari lebah atau potongannya (cemaran fisik).",
    "Aktif",
  ],
  [
    110601,
    "Gula Pasir dengan Pemanis Buatan",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [110602, "Sediaan Pemanis Alami", "-", "Aktif"],
  [110603, "Sediaan Pemanis Buatan", "-", "Aktif"],
  [110604, "Sediaan Pemanis Alami dan Buatan", "-", "Aktif"],
  [
    110605,
    "Sediaan Pemanis Campuran : Gula / Pemanis Alami / Pemanis Buatan / Bahan Lainnya",
    "-",
    "Aktif",
  ],
  [
    12010103,
    "Garam Konsumsi Beriodium",
    "Garam Konsumsi Beriodium adalah produk bahan makanan yang berbentuk padat dengan komponen utamanya klorida (NaCl) dengan penambahan/fortifikasi kalium iodat (KIO3)",
    "Aktif",
  ],
  [
    12010106,
    "Garam Campuran",
    "Garam campuran adalah campuran garam dengan bahan pangan lain. Produk garam campuran dapat mengandung monosodium<br> glutamat (MSG). Nama jenis produk diantaranya garam campur<br> gula, garam campur MSG.<br> <br> Karakteristik dasar :<br> \x{2022} Kadar NaCl tidak kurang dari 50%;<br> \x{2022} Kadar iodium dihitung sebagai KIO3 tidak kurang dari 15,95 mg/kg.",
    "Aktif",
  ],
  [12010107, "Garam Gurih", "&nbsp;", "Aktif"],
  [
    12010108,
    "Garam Cair",
    "Garam cair adalah campuran garam dengan air dengan kadar NaCl tidak kurang dari 23%.",
    "Aktif",
  ],
  [
    12010109,
    "Garam Kurang Natrium",
    "Peraturan BPOM nomor 34 tahun 2019 tentang Kategori Pangan",
    "Aktif",
  ],
  [
    12010110,
    "Garam Berbumbu",
    "Garam berbumbu adalah campuran garam dengan rempah, dengan atau bahan pangan lain.<br> <br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Kadar NaCl tidak kurang dari 50%;<br> \xE2\x{20AC}\xA2 Kadar iodium dihitung sebagai KIO3 tidak kurang dari 15,95 mg/kg.",
    "Aktif",
  ],
  [
    12010111,
    "Garam Industri Aneka Pangan",
    "Garam industri aneka pangan adalah garam beriodium yang digunakan sebagai bahan baku untuk industri aneka pangan.<br> <br> Karakteristik dasar :<br> \x{2022} Kadar NaCl tidak kurang dari 97% (basis kering);<br> \x{2022} Kadar iodium dihitung sebagai KIO3 tidak kurang dari 30 mg/kg.",
    "Aktif",
  ],
  [
    12010112,
    "Garam Diet",
    "Garam diet adalah garam beriodium yang mengandung natrium<br> klorida (NaCl) yang disesuaikan dengan keperluan.<br> Karakteristik dasar :<br> \x{2022} Kadar natrium klorida (NaCl) adbk (atas dasar bahan kering)<br> tidak lebih dari 60%;<br> \x{2022} Kadar klorida (KCl) adbk tidak lebih dari 40%;<br> \x{2022} Kadar iodium sebagai KIO3 tidak kurang dari 30 mg/kg.",
    "Aktif",
  ],
  [
    120102,
    "Pengganti Garam atau Garam Substitusi (Salt Substitute)",
    "Pengganti garam adalah bumbu dengan kandungan natrium yang<br> dikurangi dan digunakan untuk menggantikan garam.<br> Syarat mutu :<br> - kandungan Na tidak lebih dari 0.12 g/100 g produk pengganti garam (sesuai dengan Codex Stan 53-1981 - Codex Standard for Special Dietary Food with Low-Sodium Content (including Salt Subtitutes) dan Australia New Zealand Food Standard, Standard 2.10.2 - Salt and Salt Products)<br> - Bahan Baku yang dapat digunakan antaran lain :<br> Garam Kalsium<br> Garam Kalium<br> Garam Magnesium<br> Garam Amonium<br> atau campurannya<br> - Kadar iodium dalam KIO3 minimal 30 mg/kg<br> - Uji organoleptik normal<br> - Analisis dilakukan terhadap kandungan natrium total pada produk akhir<br>",
    "Aktif",
  ],
  [
    12020102,
    "Rempah",
    "Rempah adalah bagian tanaman yang dapat berupa biji, buah, bunga, kulit batang dan rimpang untuk memberi aroma dan rasa pada pangan atau dapat mewarnai dan digunakan untuk meningkatkan selera makan; dapat berbentuk utuh, irisan, bubuk, pasta, baik segar maupun yang sudah dikeringkan, tunggal atau campuran tanpa penambahan bahan pangan lain.",
    "Tidak Aktif",
  ],
  [
    12020103,
    "Rempah Bubuk",
    "Rempah bubuk adalah rempah yang dihaluskan baik tunggal maupun campuran untuk memberikan rasa dan aroma yang khas bagi makanan tertentu.",
    "Tidak Aktif",
  ],
  [
    12020104,
    "Adas, Adas Pedas, Fennel, Jinten Manis",
    "Adas, adas pedas, fennel, jinten manis adalah produk rempah yang diperoleh dari buah kering dan masak dari tanaman Foeniculum vulgare atau Foeniculum officinale.",
    "Tidak Aktif",
  ],
  [
    12020105,
    "Adas Bubuk",
    "Adas bubuk adalah produk bubuk yang diperoleh dengan cara menggiling buah masak dan kering dari tanaman Foeniculum vulgare.",
    "Tidak Aktif",
  ],
  [12020106, "Asam Glugur", "", "Tidak Aktif"],
  [
    12020107,
    "Asam Jawa",
    "Asam jawa adalah produk rempah-rempah yang diperoleh dari buah tanaman Tamarindus indica atau T.officinalis.",
    "Tidak Aktif",
  ],
  [12020108, "Asam Kandis", "", "Tidak Aktif"],
  [
    12020109,
    "Allspice",
    "Allspice adalah produk rempah-rempah berbentuk utuh atau serbuk yang diperoleh dari buah Pimmento dioica (L) Merr yang belum matang dan dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020110,
    "Asinan Jahe",
    "Asinan jahe adalah produk jahe (Zingiber officinale) yang diperoleh dari proses pengawetan jahe dengan penambahan garam, dan larutan cuka atau larutan asam sitrat, atau asam lain yang sesuai. Dapat ditambahkan gula atau bahan pangan lain.",
    "Tidak Aktif",
  ],
  [
    12020112,
    "Basilla",
    "Basilla adalah herba berbentuk utuh atau bubuk yang diperoleh dari daun Deimun basilicum yang dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020113,
    "Bay Leaves",
    "Bay leaves adalah herba berbentuk utuh atau bubuk yang diperoleh dari daun Lurus nobilis L yang dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020114,
    "Bawang Putih",
    "Bawang putih adalah umbi dari tanaman Allium sativum. Bisa dalam bentuk segar, pasta, kering, irisan kering, bubuk dengan atau tanpa campuran dengan garam.",
    "Tidak Aktif",
  ],
  [
    12020115,
    "Bawang Merah (Shallot)",
    "Bawang merah (shallot) adalah umbi dari tanaman Allium cepa L. atau A.ascalonicum. Bisa dalam bentuk segar, kering, bubuk, atau irisan yang digoreng.",
    "Tidak Aktif",
  ],
  [
    12020116,
    "Bawang Batak/Lokio",
    "Bawang Batak/Lokio adalah daun dan umbi tanaman allium chinense",
    "Tidak Aktif",
  ],
  [
    12020117,
    "Bawang Daun",
    "Bawang daun adalah tanaman onion (Allium cepa) yang belum terbentuk umbinya (green onion) atau umbi baru terbentuk sedikit (spring onion) dan tanaman Allium porrum (leek). Bisa dalam bentuk segar, bubuk, atau irisan.",
    "Tidak Aktif",
  ],
  [
    12020118,
    "Biji Seledri",
    "Biji seledri adalah biji kering dari tanaman Apium graveolens.",
    "Tidak Aktif",
  ],
  [
    12020119,
    "Biji Sawi/Biji Mustard",
    "Biji sawi/biji mustard adalah biji kering dari beberapa spesies tanaman Brassica.",
    "Tidak Aktif",
  ],
  [
    12020120,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk",
    "Biji sawi atau biji mustard bubuk adalah produk bubuk yang diperoleh dari beberapa biji-bijian kering spesies Brassica.",
    "Tidak Aktif",
  ],
  [12020121, "Cabe Jawa", "", "Tidak Aktif"],
  [
    12020122,
    "Cabe Merah Segar",
    "Cabe merah segar adalah produk rempah yang diperoleh dari buah tanaman Capsicum annum L. yang dipetik pada tingkat ketuaan optimal.",
    "Tidak Aktif",
  ],
  [
    12020123,
    "Bubur Cabe",
    "Bubur cabe adalah produk bubur yang diperoleh dari proses penggilingan buah cabe (Capsicum annum atau C. fructessen) segar atau buah kering yang baik dengan penambahan air bersih. Dapat mengandung garam dan vinegar.",
    "Aktif",
  ],
  [
    12020124,
    "Cabe Bubuk",
    "Cabe bubuk adalah produk bubuk yang diperoleh dari proses<br> penggilingan buah cabe (Capsicum annum atau C. fructessen) kering yang baik.",
    "Tidak Aktif",
  ],
  [
    12020126,
    "Cengkeh",
    "Cengkeh adalah produk yang diperoleh dari bunga yang belum mekar dari tanaman cengkeh Eugenia caryophyllus famili Myrtaceae, yang telah dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020127,
    "Cengkeh Bubuk",
    "Cengkeh bubuk adalah produk bubuk yang diperoleh dari bunga yang belum mekar dari tanaman cengkeh Eugenia caryopyllus famili Myrtaceae, yang telah dikeringkan dan digiling.",
    "Tidak Aktif",
  ],
  [
    12020128,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender",
    "Biji dill (dill seed), adas manis, adas sowa, adas cina, ender adalah produk yang diperoleh dari buah tanaman Anethum graveolens yang telah dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020133,
    "Fenugreek, Kelabat, Kelabet, Klabat",
    "Fenugreek, kelabat, kelabet, klabat adalah produk yang diperoleh dari biji matang dan kering dari tanaman Trigonella foenumgraecum.",
    "Tidak Aktif",
  ],
  [
    12020134,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk",
    "Fenugreek bubuk, kelabat bubuk, kelabet bubuk, klabat bubuk adalah produk bubuk yang diperoleh dengan cara menggiling biji matang dan kering dari tanaman Trigonella foenumgraecum.",
    "Tidak Aktif",
  ],
  [
    12020135,
    "Fuli Kering",
    "Fuli kering adalah arillus yang berwarna merah yang terdapat diantara daging dan biji buah tanaman Myristica fragrans Hout yang telah dibersihkan kotorannya dan dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020136,
    "Fuli Bubuk",
    "Fuli bubuk adalah produk bubuk yang diperoleh dari arillus biji tanaman Myristica fragrans Hout yang telah dikeringkan dan digiling.",
    "Tidak Aktif",
  ],
  [
    12020137,
    "Jahe Segar",
    "Jahe segar adalah rimpang dari tanaman jahe (Zingiber officinale) yang sudah tua, berbentuk utuh dan segar serta dibersihkan.",
    "Tidak Aktif",
  ],
  [
    12020138,
    "Jahe Kering",
    "Jahe kering adalah produk rempah-rempah yang diperoleh dari rimpang dari tanaman jahe (Zingiber officinalle) yang telah dibersihkan berbentuk utuh atau irisan dan dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020139,
    "Bubur Jahe",
    "Bubur jahe adalah produk bubur yang diperoleh dari proses penggilingan rimpang dari tanaman jahe (Zingiber officinalle) segar atau kering yang baik dengan penambahan air bersih. Dapat mengandung garam dan vinegar.",
    "Aktif",
  ],
  [
    12020140,
    "Jahe Bubuk",
    "Jahe bubuk adalah produk bubuk yang diperoleh dari rimpang bersih tanaman Zingiber officinale yang telah dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020141,
    "Jintan/Caraway",
    "Jintan / caraway adalah biji kering yang diperoleh dari tanaman Carum carvi.",
    "Tidak Aktif",
  ],
  [
    12020142,
    "Jintan Bubuk",
    "Jintan bubuk adalah produk rempah-rempah yang diperoleh dari biji tanaman Carum carvi yang bersih, kering dan telah digiling.",
    "Tidak Aktif",
  ],
  [
    12020143,
    "Jintan Manis",
    "Jintan manis adalah produk rempah-rempah yang diperoleh dari buah matang tanaman Pimpinella anisum yang telah dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020144,
    "Jintan Hitam",
    "Jintan hitam adalah produk rempah-rempah yang diperoleh dari biji tanaman Nigella sativa yang bersih dan dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020145,
    "Jintan Hitam Bubuk",
    "Jintan hitam bubuk adalah produk bubuk yang diperoleh dengan<br> menggilling biji kering yang bersih dari tanaman Nigella sativa.",
    "Tidak Aktif",
  ],
  [
    12020146,
    "Jintan Putih, Cumin",
    "Jintan putih, cumin adalah produk rempah-rempah yang diperoleh dari buah kering tanaman Cuminum cyminum.",
    "Tidak Aktif",
  ],
  [
    12020147,
    "Jintan Putih Bubuk",
    "Jintan putih bubuk adalah produk bubuk yang diperoleh dari proses penggilingan biji kering tanaman Cuminum cyminum.",
    "Tidak Aktif",
  ],
  [
    12020148,
    "Kapulaga",
    "Kapulaga adalah rempah yang diperoleh dari buah kering yang masak dari tanaman Elettaria cardamomum.",
    "Tidak Aktif",
  ],
  [
    12020149,
    "Biji Kapulaga",
    "Biji kapulaga adalah rempah yang diperoleh dari biji kering yang diperoleh dengan pemisahan dari kapsul tanaman Elettaria cardamomum.",
    "Tidak Aktif",
  ],
  [
    12020150,
    "Kapulaga Lokal",
    "Kapulaga lokal adalah produk rempah yang diperoleh dari buah tanaman kapulaga lokal (Amomum cardamomum) yang sudah tua, telah dibuang tangkai buahnya, dibersihkan dan dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020151,
    "Kapulaga (Cardamom) Amomum",
    "Kapulaga (cardamom) amomum adalah rempah yang diperoleh dari buah tanaman Amomum subulatum yang telah matang dan dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020152,
    "Biji Kapulaga (Cardamom) Amomum",
    "Biji kapulaga (cardamom) amomum adalah rempah yang diperoleh dari biji buah Amomum subulatum yang telah dipisahkan dari kapsulnya.",
    "Tidak Aktif",
  ],
  [
    12020153,
    "Kapulaga Bubuk",
    "Kapulaga bubuk adalah produk bubuk yang diperoleh dari penggilingan biji kering bersih Elettaria cardamomum yang telah dipisahkan dari kapsulnya.",
    "Tidak Aktif",
  ],
  [
    12020154,
    "Kapulaga (Cardamom) Amomum Bubuk",
    "Kapulaga (cardamom) amomum bubuk adalah produk bubuk yang diperoleh dari penggilingan biji Amomum subulatum yang telah dipisahkan dari kapsulnya dan dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020155,
    "Kayu Manis",
    "Kayu manis adalah produk kering yang diperoleh dari kulit kayu bagian dalam tanaman Cinnamomum zeylanicum atau C. cassia atau C. burmanii atau C. sintok BI atau Cassia vera.",
    "Tidak Aktif",
  ],
  [
    12020156,
    "Kayu Manis Bubuk",
    "Kayu manis bubuk adalah produk bubuk yang diperoleh dari proses penggilingan kulit kayu bagian dalam tanaman Cinnamomum zeylanicum atau C. cassia atau C. burmanii atau C. sintok BI atau Cassia vera yang telah dikeringkan.",
    "Tidak Aktif",
  ],
  [12020157, "Kemiri Dengan Tempurung", "", "Tidak Aktif"],
  [
    12020158,
    "Kemiri",
    "Kemiri adalah rempah yang diperoleh dari daging biji kemiri (Alleurites mellucana (L) Wild) yang telah dipisahkan dari<br> tempurungnya.",
    "Tidak Aktif",
  ],
  [
    12020159,
    "Kencur",
    "Kencur adalah rimpang tanaman Kaempferia galanga L.",
    "Tidak Aktif",
  ],
  [
    12020160,
    "Kencur Bubuk",
    "Kencur bubuk adalah produk bubuk yang diperoleh dari rimpang tanaman kencur yang telah dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020161,
    "Ketumbar",
    "Ketumbar adalah buah tanaman Coriandrum sativum masak yang kering.",
    "Tidak Aktif",
  ],
  [
    12020162,
    "Daun Ketumbar",
    "Daun ketumbar adalah herba yang diperoleh dari daun tanaman Coriandrum sativum Linn.",
    "Tidak Aktif",
  ],
  [
    12020163,
    "Ketumbar Bubuk",
    "Ketumbar bubuk adalah produk bubuk yang diperoleh dari proses penggilingan buah kering tanaman Coriandrum sativum Linn. yang dibersihkan.",
    "Tidak Aktif",
  ],
  [
    12020164,
    "Picung",
    "Picung adalah produk buah tanaman Pangium edule.",
    "Tidak Aktif",
  ],
  [
    12020165,
    "Kluwek",
    "Kluwek adalah produk buah tanaman Pangium edule yang telah mengalami pengolahan dan pematangan.",
    "Tidak Aktif",
  ],
  [
    12020166,
    "Kunyit",
    "Kunyit adalah rimpang Curcuma domestica atau Curcuma longa.",
    "Tidak Aktif",
  ],
  [
    12020167,
    "Kunyit Bubuk",
    "Kunyit bubuk adalah produk bubuk yang diperoleh dari proses penggiligan rimpang kering Curcuma longa atau Curcuma domestica.",
    "Tidak Aktif",
  ],
  [
    12020168,
    "Lada Hitam",
    "Lada hitam adalah rempah yang diperoleh dari buah tanaman Piper nigrum Linn yang dipetik setelah sebagian besar buah lada matang dan telah dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020169,
    "Lada Hitam Bubuk",
    "Lada hitam bubuk adalah produk rempah yang diperoleh dari proses penggilingan lada hitam.",
    "Tidak Aktif",
  ],
  [
    12020170,
    "Lada Putih",
    "Lada putih adalah rempah buah tanaman Piper nigrum Linn. yang dipetik setelah sebagian besar buah lada matang penuh, kemudian dihilangkan kulit luarnya, dikeringkan dan dibersihkan.",
    "Tidak Aktif",
  ],
  [
    12020171,
    "Lada Putih Bubuk",
    "Lada putih bubuk adalah produk rempah yang diperoleh dari lada putih yang telah digiling.",
    "Tidak Aktif",
  ],
  [
    12020172,
    "Lada Bubuk Campuran",
    "Lada bubuk campuran adalah produk rempah yang diperoleh dari<br> campuran lada bubuk hitam dan lada bubuk putih.",
    "Tidak Aktif",
  ],
  [12020173, "Andaliman", "", "Tidak Aktif"],
  [
    12020174,
    "Lengkuas/Laos",
    "Lengkuas/laos adalah rimpang tanaman Alpinia galanga, Linn Sw.",
    "Tidak Aktif",
  ],
  [
    12020175,
    "Lengkuas/Laos Bubuk",
    "Lengkuas / laos bubuk adalah produk bubuk yang diperoleh dari rimpang bersih tanaman lengkuas yang telah dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020176,
    "Kecombrang/Sambuang/Kincong/Honje",
    "adalah bunga tanaman<br> Etlingera elatior (jack) R.M Sm.",
    "Tidak Aktif",
  ],
  [
    12020177,
    "Marjoram",
    "Marjoram adalah produk berbentuk utuh atau bubuk yang diperoleh dari daun Marjoram hortensis Moench yang dikeringkan, dengan atau tanpa pucuk bunga.",
    "Tidak Aktif",
  ],
  [
    12020178,
    "Mint",
    "Mint adalah produk herba yang diperoleh dari tanaman Mentha<br> arvensis atau Mentha piperit",
    "Tidak Aktif",
  ],
  [
    12020179,
    "Onion/Bawang Bombay",
    "Onion / bawang bombay adalah umbi dari tanaman bawang bombay Allium sp.",
    "Tidak Aktif",
  ],
  [12020180, "Onion Bubuk/Bawang Bombay Bubuk", "", "Tidak Aktif"],
  [
    12020181,
    "Oregano",
    "Oregano adalah produk herba berbentuk utuh atau bubuk yang diperoleh dari daun Origantum vulgare sp. yang telah dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020182,
    "Pala",
    "Pala adalah biji kering tanaman Myristica fragrans Hout dan dikupas kulit batoknya, berbentuk bulat atau lonjong dengan panjang 20 mm hingga 40 mm.",
    "Tidak Aktif",
  ],
  [
    12020183,
    "Pala Untuk Destilasi",
    "Pala untuk destilasi adalah produk rempah biji yang berasal dari buah tanaman Myristica fragrans yang dipetik pada waktu muda (berumur 2 hingga 5 bulan).",
    "Tidak Aktif",
  ],
  [
    12020184,
    "Pala Bubuk",
    "Pala bubuk adalah produk bubuk yang diperoleh dari biji kering tanaman Myristica fragrans",
    "Tidak Aktif",
  ],
  [
    12020185,
    "Parsley",
    "Parsley adalah daun dari tanaman Petroselinum hortense yang telah dikeringkan. Daun berwarna hijau terang.",
    "Tidak Aktif",
  ],
  [
    12020186,
    "Paprika Bubuk",
    "Paprika bubuk adalah produk rempah yang diperoleh dari buah matang tanaman Capsicum annuum yang telah dibersihkan, dikeringkan dan digiling.",
    "Tidak Aktif",
  ],
  [
    12020187,
    "Sweet Paprika Bubuk",
    "Sweet paprika bubuk adalah produk rempah yang diperoleh dari<br> campuran buah matang tanaman Capsicum annuum dan Capsicum longum yang telah dibersihkan, dikeringkan dan digiling.",
    "Tidak Aktif",
  ],
  [
    12020188,
    "Rosemari",
    "Rosemari adalah produk berbentuk utuh atau bubuk yang diperoleh dari daun Rosemarinus officinalis L yang dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020189,
    "Saga",
    "Saga adalah produk berbentuk utuh atau bubuk yang diperoleh dari<br> daun saga atau tanaman Abrus precatorius, Linn atau Salvia<br> officinalis L atau Salvia triloba L atau Salvia lavandulaefolia Vahl.",
    "Tidak Aktif",
  ],
  [
    12020190,
    "Saffron",
    "Saffron adalah stigmata atau pucuk bunga dari tanaman Crocus sativus yang telah dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020191,
    "Pekak/Bunga Lawang/Star Anise",
    "Pekak / bunga lawang /star anise adalah buah dari tanaman Illicium verum yang telah dikeringkan.",
    "Tidak Aktif",
  ],
  [
    12020192,
    "Temu Kunci",
    "Temu kunci adalah rimpang dari tanaman Gastrochillus panduratum yang telah dibersihkan.",
    "Tidak Aktif",
  ],
  [
    12020194,
    "Thymi/Thyme",
    "Thymi / thyme adalah herba yang diperoleh dari daun pucuk kering thymi dari tanaman Thymus vulgaris atau Thymus zugis L baik dalam bentuk utuh atau bubuk.",
    "Tidak Aktif",
  ],
  [12020195, "Bawang Goreng", "-", "Aktif"],
  [
    12020196,
    "Daun Jeruk Purut (Kaffir lime)",
    "Daun jeruk purut adalah produk herba yang diperoleh dari daun tanaman Citrus aerauntifolia.",
    "Tidak Aktif",
  ],
  [
    12020197,
    "Daun Pandan",
    "Daun pandan adalah produk herba yang diperoleh dari tanaman<br> Pandanus amaryllifolius Roxb.",
    "Tidak Aktif",
  ],
  [
    12020198,
    "Akar Chicory",
    "Akar chicory adalah produk herba yang diperoleh dari akar tanaman Cichorium intybus L.",
    "Tidak Aktif",
  ],
  [
    12020199,
    "Asam Sunti",
    "Asam sunti adalah produk rempah yang diperoleh dari buah masak tanaman Averrhoa bilimbi yang dikeringkan.",
    "Tidak Aktif",
  ],
  [
    "120201A1",
    "Bergamot",
    "Bergamot adalah produk herba yang diperoleh dari daun tanaman Monarda didyma.",
    "Tidak Aktif",
  ],
  [
    "120201A2",
    "Daun Peterseli",
    "Daun peterseli adalah produk herba yang diperoleh dari tanaman Petroselinum crispum",
    "Tidak Aktif",
  ],
  [
    "120201A3",
    "Daun Sembung",
    "Daun sembung adalah produk herba yang diperoleh dari tanaman<br> Blumea balsamifera (L) Dc.",
    "Tidak Aktif",
  ],
  [
    "120201A4",
    "Daun Suji",
    "Daun suji adalah produk herba yang diperoleh dari tanaman<br> Pleomele angustifolia N.E. Brown.",
    "Tidak Aktif",
  ],
  [
    "120201A5",
    "Lempuyang",
    "Lempuyang adalah produk yang diperoleh dari rimpang tanaman<br> Zingiber zerumbet.",
    "Tidak Aktif",
  ],
  [
    "120201A6",
    "Mesoyi",
    "Mesoyi adalah produk herba yang diperoleh dari biji tanaman<br> Cinnamomum sintoc atau Masoya aromatica",
    "Tidak Aktif",
  ],
  [
    "120201A7",
    "Sereh",
    "Sereh adalah produk herba yang diperoleh dari batang tanaman<br> Cymbopogon citrates (DC) Stapt",
    "Tidak Aktif",
  ],
  [
    "120201A8",
    "Wasabi",
    "Wasabi adalah produk yang diperoleh dari rimpang tanaman<br> Wasabia japonica",
    "Tidak Aktif",
  ],
  [
    "120201A9",
    "Wijen",
    "Wijen adalah produk yang diperoleh dari biji tanaman Sesamum<br> indicum L. syn./Sesamum orientalis L.",
    "Tidak Aktif",
  ],
  [
    "120201B3",
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan",
    "Memfasilitasi pendaftaran pangan olahan selain PSAT",
    "Aktif",
  ],
  [
    12020203,
    "Bubuk Ngohyang",
    "Bubuk ngohyang adalah campuran dari 5 macam rempah antara lain : bunga lawang, kayu manis, lada hitam, jintan dan cengkeh.",
    "Aktif",
  ],
  [
    12020205,
    "Bumbu Siap Pakai",
    "Bumbu siap pakai adalah produk bumbu yg diperoleh dari campuran rempah dg atau tanpa penambahan minyak untuk membuat masakan tertentu. Produk dapat ditambahkan bahan pangan lain. Produk dapat dikemas dalam kemasan plastik atau botol plastik atau botol kaca atau kemasan lainnya dan dapat diawetkan dengan pemanasan. bumbu siap pakai dapat berukuran basah atau kering",
    "Aktif",
  ],
  [
    12020206,
    "Furikake",
    "Furikake adalah taburan diatas nasi yang antara lain mengandung serpihan rumput laut kering, biji sesame dan bumbu lain.",
    "Tidak Aktif",
  ],
  [12020208, "Bumbu Mi Instan", "", "Tidak Aktif"],
  [12020209, "Bumbu Siap Pakai (Steril)", "&nbsp;", "Tidak Aktif"],
  [
    12020210,
    "Ragi Kering (Tidak Aktif)",
    "Regi Kering (Tidak Aktif) adalah produk yang dibuat dengan cara membiakkan kamir jenis Saccharomyces cerevisiae, Saccharomyces fragilis, dan Candida utilis dalam media serealia atau bahan lain yang sesuai, dalam keadaan bersih, kering, tidak aktif serta berfungsi sebagai bumbu dan kondimen.<br> Kadar air tidak lebih dari 7%.",
    "Aktif",
  ],
  [
    12020211,
    "Bawang Hitam",
    "Bawang hitam adalah produk yang diperoleh dari bawang putih<br> segar (Allium sativum L.) yang dipanaskan pada suhu umumnya 60-90\\xB0C dan kelembaban tinggi dalam waktu kurang lebih 1 bulan<br> sehingga dihasilkan siung bawang dengan warna gelap/hitam, rasa<br> manis, dan tekstur yang kenyal.<br> <br> Karakteristik Dasar:<br> Kadar air tidak lebih dari 50%",
    "Aktif",
  ],
  [
    12020212,
    "Bumbu Ekstrak Daging Sapi",
    "Bumbu ekstrak daging sapi adalah produk bumbu yang mengandung ekstrak daging sapi, dengan penambahan bahan pangan lain dalam bentuk bubuk atau blok/kubus.<br> <br> Karakteristik dasar :<br> \x{2022} Kadar air tidak lebih dari 4%<br> \x{2022} Kadar protein tidak kurang dari 7%",
    "Aktif",
  ],
  [
    12020213,
    "Bumbu Rasa Sapi",
    "Bumbu rasa sapi adalah produk bumbu yang mengandung perisa daging sapi, dengan penambahan bahan pangan lain dan dalam bentuk bubuk atau blok/kubus.",
    "Aktif",
  ],
  [
    12020214,
    "Bumbu Ekstrak Daging Ayam",
    "Bumbu ekstrak daging ayam adalah produk bumbu yang mengandung ekstrak daging ayam baik dalam bentuk bubuk atau blok/kubus.<br> <br> Karakteristik dasar :<br> \x{2022} Kadar air tidak lebih dari 4%<br> \x{2022} Kadar protein tidak kurang dari 6%",
    "Aktif",
  ],
  [
    12020215,
    "Bumbu Ekstrak Udang",
    "Bumbu ekstrak udang adalah produk bumbu yang mengandung udang baik dalam bentuk bubuk atau blok/kubus.<br> <br> Karakteristik dasar:<br> \x{2022} Kadar air tidak lebih dari 4%<br> \x{2022} Kadar udang tidak kurang dari 15%",
    "Aktif",
  ],
  [
    12020216,
    "Bumbu Ekstrak Cumi",
    "Bumbu ekstrak cumi adalah produk bumbu yang mengandung cumi dalam bentuk bubuk atau blok/kubus.<br> <br> Karakteristik dasar :<br> \x{2022} Kadar air tidak lebih dari 4%<br> \x{2022} Kadar cumi tidak kurang dari 15%",
    "Aktif",
  ],
  [
    12020217,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam)",
    "Karakteristik dasar :<br> Kadar air tidak lebih dari 12,5%.<br>",
    "Aktif",
  ],
  [
    12020218,
    "Bumbu Rasa Ikan",
    "Bumbu rasa ikan adalah produk bumbu yang mengandung perisa ikan baik dalam bentuk bubuk atau blok/kubus.",
    "Aktif",
  ],
  [
    12020219,
    "Bumbu Rasa Udang",
    "Bumbu rasa udang adalah produk bumbu yang mengandung perisa udang baik dalam bentuk bubuk atau blok/kubus.",
    "Aktif",
  ],
  [
    12020220,
    "Bumbu Rasa Ayam",
    "Bumbu rasa ayam adalah produk bumbu yang mengandung perisa ayam baik dalam bentuk bubuk atau blok/kubus.",
    "Aktif",
  ],
  [
    12020221,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju",
    "Bubuk/blok/kubus/pasta ekstrak ayam/sapi/udang/keju adalah produk yang mengandung ayam/sapi/udang/keju baik dalam bentuk bubuk/blok/kubus/pasta dengan atau tanpa penambahan bahan pangan lain. Produk ini tanpa penambahan rempah",
    "Aktif",
  ],
  [
    120301,
    "Cuka Fermentasi, Vinegar",
    "Cuka fermentasi, vinegar adalah produk cair yang mengandung asam asetat, yang diperoleh melalui proses fermentasi bahan-bahan yang mengandung karbohidrat atau alkohol. Contoh : cuka apel,<br> cuka anggur.<br> <br> Karakteristik dasar :<br> Total asam tidak kurang dari 4 g/100 ml",
    "Aktif",
  ],
  [
    120302,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Meja)",
    "Cuka hasil pengenceran asam asetat glasial adalah produk cair yang diperoleh dari pengenceran asam asetat glasial (untuk makanan dan farmasi) dengan air minum.<br> Contoh : Cuka makan.<br> <br> Karakteristik dasar :<br> \x{2022} Bentuk cairan encer, jernih, tidak berwarna, bau khas asam asetat<br> \x{2022} Cuka meja : kadar asam asetat tidak kurang dari 4% dan tidak lebih dari 12,5 % v/b",
    "Aktif",
  ],
  [
    120303,
    "Arak Masak (Angciu)",
    "Arak masak adalah produk yang diperoleh dari hasil fermentasi beras, dapat diikuti dengan proses penyulingan, berwarna bening hingga bening kecoklatan dengan aroma ragi yang tajam, ditambahkan garam dan/atau rempah-rempah dan/atau bahan pangan lain yang menimbulkan rasa, digunakan sebagai penambah rasa pada hidangan oriental. Pada label wajib dicantumkan kadar alkohol dan keterangan 'hanya untuk memasak'.",
    "Aktif",
  ],
  [
    120304,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Dapur)",
    "Cuka hasil pengenceran asam asetat glasial adalah produk cair yang diperoleh dari pengenceran asam asetat glasial (untuk makanan dan farmasi) dengan air minum. Contoh : Cuka makan.<br> <br> Karakteristik dasar :<br> \x{2022} Bentuk cairan encer, jernih, tidak berwarna, bau khas asam asetat<br> \x{2022} Cuka dapur : kadar asam asetat tidak kurang dari 12,5 % v/b<br>",
    "Aktif",
  ],
  [
    1204,
    "Mustard",
    "Produk kondimen yang disiapkan<br> dari biji mustard yang ditumbuk, umumnya dari biji mustard yang<br> telah ditumbuk dan dihilangkan minyaknya, yang dicampur/diolah<br> dengan menambahkan air, vinegar/cuka, garam, dan rempah-rempah<br> menjadi saus/pasta yang berwarna kuning cerah sampai kecoklatan.<br> Contoh : mustard Dijon dan mustard pedas (hot mustard) yang diperoleh dari biji dan kulit mustard.",
    "Aktif",
  ],
  [
    12050101,
    "Sari Pati Ayam",
    "Sari pati ayam adalah ekstrak karkas ayam pedaging dengan atau tanpa penambahan garam, sari simplisia, dalam bentuk siap dikonsumsi.<br> <br> Karakteristik dasar:<br> \x{2022} Bentuk cairan jernih<br> \x{2022} Kadar protein tidak kurang dari 7,7%<br>",
    "Aktif",
  ],
  [
    12050102,
    "Kaldu dan Konsome",
    "produk yang diperoleh dari daging sapi,<br> daging unggas, atau daging lainnya dengan cara memasak bahan kaya protein atau sarinya dan atau hidrolisatnya dengan air dengan atau tanpa penambahan bumbu dan atau bahan penyedap, lemak yang dapat dimakan, natrium klorida, rempah-rempah dan sari-sari alami atau destilatnya atau bahan makanan lain untuk meningkatkan rasa, atau dengan rekonstitusi dari campuran<br> komponen kering yang sesuai dengan petunjuk penggunaan.",
    "Aktif",
  ],
  [
    12050103,
    "Kaldu dan Konsome Produk Perikanan (Seperti Kaldu Udang, Kaldu Ikan, dll)",
    "",
    "Aktif",
  ],
  [12050105, "Sup Siap Saji", "", "Aktif"],
  [
    12050201,
    "Sup Instan",
    "Sup instan adalah produk pangan olahan kering instan yang dapat dibuat dari daging, ikan, sayuran, serealia atau campurannya, yang siap dikonsumsi setelah diseduh dengan air mendidih. Dapat ditambahkan bahan pangan lain.",
    "Aktif",
  ],
  [
    12050202,
    "Sup Pasta Instan (Misalnya Sup Makaroni Instan)",
    "Karakteristik dasar : Kadar air tidak lebih dari 12,5%",
    "Aktif",
  ],
  [
    12050203,
    "Sup Krim Instan",
    "Sup krim instan adalah produk pangan olahan kering instan yang dibuat dari tepung nabati dan atau hewani, yang siap dikonsumsi setelah diseduh dengan air mendidih menjadi larutan kental. Dapat ditambahkan bahan pangan lain.<br> Karakteristik dasar :Kadar air tidak lebih dari 8%",
    "Aktif",
  ],
  [
    12050204,
    "Sup Krim Pasta Instan (Misalnya Sup Krim Makaroni Instan)",
    "Karakteristik dasar :Kadar air tidak lebih dari 12,5%",
    "Aktif",
  ],
  [
    12050205,
    "Bumbu Ekstrak Daging Sapi",
    "Bumbu ekstrak daging sapi adalah produk bumbu yang mengandung ekstrak daging sapi, dengan penambahan bahan pangan lain dalam bentuk bubuk atau blok/kubus.",
    "Tidak Aktif",
  ],
  [
    12050206,
    "Bumbu Rasa Sapi",
    "Bumbu rasa sapi adalah produk bumbu yang mengandung perisa daging sapi, dengan penambahan bahan pangan lain dan dalam bentuk bubuk atau blok/kubus.",
    "Tidak Aktif",
  ],
  [
    12050207,
    "Bumbu Ekstrak Daging Ayam",
    "Bumbu ekstrak daging ayam adalah produk bumbu yang mengandung ekstrak daging ayam baik dalam bentuk bubuk atau blok/kubus.",
    "Tidak Aktif",
  ],
  [
    12050208,
    "Bumbu Rasa Ayam",
    "Bumbu rasa ayam adalah produk bumbu yang mengandung perisa daging ayam baik dalam bentuk bubuk atau blok/kubus.",
    "Tidak Aktif",
  ],
  [
    12050209,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam)",
    "Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Bau dan rasa normal<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 12,5%",
    "Tidak Aktif",
  ],
  [12050210, "Bumbu Lainnya (Basah)", "&nbsp;", "Tidak Aktif"],
  [12050211, "Bumbu Lainnya (Kering)", "&nbsp;", "Tidak Aktif"],
  [
    12050212,
    "Bumbu Penguat Rasa dan Garam",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    12050213,
    "Sup Instan (Steril)",
    "Sup instan adalah produk pangan olahan kering instan yang dapat dibuat dari daging, ikan, sayuran, serealia atau campurannya, yang siap dikonsumsi setelah diseduh dengan air mendidih diproses secara steril. Dapat ditambahkan bahan pangan lain.",
    "Tidak Aktif",
  ],
  [
    12050214,
    "Sup Instan Dalam Kaleng",
    "Sup instan adalah produk pangan olahan kering instan yang dapat dibuat dari daging, ikan, sayuran, serealia atau campurannya, yang siap dikonsumsi setelah diseduh dengan air mendidih diproses secara steril (dalam kaleng). Dapat ditambahkan bahan pangan lain.",
    "Tidak Aktif",
  ],
  [
    12050215,
    "Bumbu Rasa Ikan",
    "Bumbu rasa ikan adalah produk bumbu yang mengandung perisa<br> ikan baik dalam bentuk bubuk atau blok/kubus.<br>",
    "Tidak Aktif",
  ],
  [
    12050216,
    "Bumbu Rasa Udang",
    "Bumbu rasa udang adalah produk bumbu yang mengandung perisa<br> udang baik dalam bentuk bubuk atau blok/kubus.",
    "Tidak Aktif",
  ],
  [
    12060101,
    "Mayonais, Mayonnaise",
    "Mayonais adalah saus kondimen yang diperoleh dengan cara mengemulsikan minyak nabati dalam fase air yang mengandung<br> vinegar atau asam cuka atau pengasam lainnya dengan penambahan telur dalam bentuk segar, cair, bubuk, atau beku<br> untuk menghasilkan emulsi, dengan atau tanpa penambahan bahan pangan lain.<br> Bahan pangan lain yang dapat digunakan antara lain gula, garam, kondimen, rempah-rempah dan herba, buah dan sayuran termasuk jus buah dan jus sayuran, biji sawi/biji mustard, produk-produk susu, air.<br> <br> Karakteristik dasar :<br> Kadar lemak total tidak kurang dari 65%",
    "Aktif",
  ],
  [
    12060102,
    "Salad Dressing (Misalnya Thousand Island, Blue Cheese, Burger Dressing, dll)",
    "Salad dressing adalah produk emulsi semisolid yang dibuat dari minyak nabati dengan penambahan bahan pengasam, dengan satu atau lebih ingredien yang mengandung kuning telur, putih telur dan pasta berpati. Ingredien mengandung kuning telur meliputi kuning",
    "Aktif",
  ],
  [
    12060103,
    "Saus Tar Tar (Tar Tar Sauce)",
    "Saus Tar Tar adalah saus yang berasal dari mayonais yang<br> ditambahkan bawang bombay dan acar mentimun, dengan atau<br> tanpa penambahan mentimun segar.<br> Karakteristik dasar :<br> Kadar lemak total tidak kurang dari 50%",
    "Aktif",
  ],
  [
    12060104,
    "French Dressing",
    "French dressing adalah saus kondimen yang merupakan produk<br> cairan yang dapat dipisahkan atau emulsi cairan yang dibuat dari<br> minyak makan dan satu atau lebih pengasam. Ingredien yang dapat<br> digunakan adalah vinegar atau vinegar encer atau vinegar, jus<br> lemon dan atau jus jeruk nipis, garam, pemanis nutritif rempah<br> atau perisa alami, pasta tomat, puree tomat, saus tomat, sherry<br> wine, telur.<br> Karakteristik dasar :<br> Kadar lemak total tidak kurang dari 35%",
    "Aktif",
  ],
  [12060105, "Sweet Mayo", "", "Tidak Aktif"],
  [12060106, "Saus Bumbu Teremulsi", "&nbsp;", "Aktif"],
  [
    12060107,
    "(Saus Teremulsi) untuk Saus Mayo",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    12060108,
    "Sandwich Spread",
    "Sandwich Spread adalah produk oles sandwich yang dibuat dari mayonais sebagai bahan dasar, paprika, dan acar mentimun.",
    "Aktif",
  ],
  [
    12060201,
    "Saus Cabe",
    "Saus cabe adalah produk saus siap konsumsi yang dibuat dari cabe<br> (Capsicum sp) atau turunannya, berbentuk cairan kental homogen,<br> yang telah mengalami proses pemanasan.",
    "Aktif",
  ],
  [12060202, "Sambal Kecap/Saus Sambal Kecap", "", "Tidak Aktif"],
  [
    12060203,
    "Saus Sambal Cabe Hijau",
    "Sambal adalah produk campuran cabe dengan bahan pangan lain yang<br> digunakan sebagai penyedap makanan<br> Sambal Siap Dikonsumsi : Termasuk diantaranya sambal bajak, sambal terasi, sambal kemiri, sambal rujak, sambal seafood, dan sambal lainnya.<br> Saus protein na",
    "Tidak Aktif",
  ],
  [
    12060205,
    "Sambal Siap Dikonsumsi",
    "Sambal Siap Dikonsumsi adalah produk siap konsumsi yang dibuat dari bahan<br> utama cabe (Capsicum sp) dengan penambahan bahan pangan lain,<br> berbentuk semi padat, dan telah mengalami proses pemasakan atau<br> pengawetan lain. Meliputi semua jenis sambal antara lain sambal<br> terasi, sambal bajak, sambal petai, sambal cabai hijau, tidak<br> termasuk cabe bubuk, cabe giling, saus cabe dan sambal yang<br> digunakan sebagai bumbu masak. Termasuk diantaranya sambal bajak, sambal terasi, sambal kemiri, sambal rujak, sambal seafood, dan sambal lainnya.",
    "Aktif",
  ],
  [
    12060208,
    "Saus Gado-gado",
    "Saus gado-gado adalah produk saus yang diperoleh dari kacang tanah yang telah digoreng atau disangrai dan dihaluskan dengan penambahan garam, gula atau bahan pangan lain dan rempah-rempah tertentu yang sesuai.",
    "Tidak Aktif",
  ],
  [
    12060209,
    "Saus Keju (Cheese Sauce)",
    "Saus keju adalah produk saus yang diperoleh dari keju dengan<br> penambahan garam, mustard dan bumbu.",
    "Aktif",
  ],
  [
    12060210,
    "Saus Lobak",
    "Saus lobak adalah produk saus yang diperoleh dari lobak yang diiris atau dihancurkan, dicampur dengan jus orange, air jeruk nipis, cilantro, minyak, garam dan lada.",
    "Aktif",
  ],
  [
    12060211,
    "Saus Panggang/Saus Barbekue (BBQ Sauce)",
    "Saus panggang/saus barbekue (BBQ sauce) adalah produk saus yang diperoleh dari campuran vinegar, gula, garam, saus worchester dan rempah-rempah seperti bawang putih, onion, paprika dan lada hitam dengan atau tanpa saus tomat atau pasta tomat, bahan pangan lainnya",
    "Aktif",
  ],
  [
    12060212,
    "Saus Pizza",
    "Saus pizza adalah produk saus yang diperoleh dari pasta tomat, saus tomat yang diberi garam dan rempah-rempah seperti biji anis, lada, bubuk bawang putih, oregano dan parsley.",
    "Aktif",
  ],
  [12060213, "Saus Sate", "", "Tidak Aktif"],
  [
    12060214,
    "Saus Spagheti (Spaghetti Sauce)",
    "Saus spagheti (spaghetti sauce) adalah produk saus yang diperoleh campuran rempah-rempah seperti bawang putih, bawang bombay, lada hitam, daun basil, oregano, thymi, gula, garam, vinegar dengan atau tanpa saus tomat atau pasta tomat, dan bahan pangan lainnya",
    "Aktif",
  ],
  [
    12060215,
    "Saus Tiram",
    "Saus tiram adalah produk cairan kental berwarna coklat sampai coklat kehitam-hitaman, diperoleh dari hasil olahan daging tiram (Crassostera calculata sp.) dengan penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    12060216,
    "Saus Perendam/Saus Marinasi (Marinated Sauce)",
    "Saus perendam/saus marinasi adalah produk saus yang digunakan untuk merendam ikan, daging, ayam, atau bahan pangan lainnya untuk memberi rasa dan aroma tertentu sebelum diolah lebih lanjut.",
    "Aktif",
  ],
  [
    12060217,
    "Saus Tomat",
    "Saus tomat adalah produk saus yang diperoleh dari buah segar, bubur tomat, pasta tomat, puree tomat atau padatan tomat, yang dicampur dengan gula, bahan pengasam, garam dan dengan atau tanpa penambahan bahan pangan lain.<br> Karakteristik dasar :<br> Bau, rasa dan warna khas",
    "Aktif",
  ],
  [
    12060218,
    "Kecap Inggeris, Saus Worchester",
    "Kecap Inggeris, saus worchester adalah produk saus yang terdiri dari air, vinegar, garam dan rempah atau bahan pangan lainnya. Digunakan untuk memberi flavor dan saus barbekue serta saus asam manis.",
    "Aktif",
  ],
  [12060219, "Kecap Kelapa", "", "Aktif"],
  [12060220, "Sambal Terasi", "&nbsp;", "Aktif"],
  [
    12060221,
    "Saus Asam Manis",
    "Saus asam manis adalah produk saus yang terbuat dari tomat dan atau buah lain, gula dan bahan pengasam, dengan atau tanpa penambahan bahan pangan lain. Produk ini mempunyai rasa asam dan manis.",
    "Aktif",
  ],
  [12060222, "Saus Bumbu Non-Emulsi Lainnya", "-", "Aktif"],
  [
    12060223,
    "Saus Tomat Steril Komersial",
    "Saus tomat adalah produk saus yang diperoleh dari buah segar, bubur tomat, pasta tomat, puree tomat atau padatan tomat, yang dicampur dengan gula, bahan pengasam, garam dan dengan atau tanpa penambahan bahan pangan lain, diolah dengan proses sterilisai komersial.<br> Karakteristik dasar :<br> Bau, rasa dan warna khas",
    "Tidak Aktif",
  ],
  [
    12060224,
    "Saus Bumbu Non-Emulsi Steril (Aseptis)",
    "-",
    "Tidak Aktif",
  ],
  [
    12060225,
    "Saus Bumbu Non-Emulsi dalam Kaleng",
    "",
    "Tidak Aktif",
  ],
  [
    12060226,
    "Gochujang (Saus Fermentasi)",
    "Gochujang adalah pangan fermentasi berbentuk pasta yang berwarna merah atau warna gelap yang dihasilkan melalui fermentasi terhadap campuran bahan hasil sakarifikasi dengan garam, bubuk cabai merah, dan bahan pangan lain, yang dikemas secara kedap (hermetis) dan diproses dengan pemanasan untuk mencegah kebusukan. Bahan hasil sakarifikasi dihasilkan melalui sakarifikasi pati dengan malt atau dengan menumbuhkan Aspergillus sp (yang tidak patogen dan tidak menghasilkan toksin) pada biji-bijian.<br> <br> Kategori Pangan ini statusnya diubah menjadi Tidak Aktif, berdasarkan kajian terbaru dari Direktorat Standarisasi Pangan maka produk Gochujang masuk ke dalam kategori pangan Gochujang (0402020709).",
    "Tidak Aktif",
  ],
  [
    12060227,
    "Bumbu Kacang",
    "Bumbu kacang adalah bumbu yang terbuat dari kacang tanah yang telah digoreng atau disangrai dan dihaluskan dengan penambahan garam, gula atau bahan pangan lain dan rempah-rempah tertentu yang sesuai, dan langsung digunakan tanpa ditambah air terlebih dahulu. Nama jenis untuk produk ini antara lain bumbu gado-gado, bumbu pecel, bumbu sate, bumbu siomay, bumbu batagor, dan lain-lain.<br>",
    "Aktif",
  ],
  [
    12060228,
    "Saus Teriyaki",
    "Saus teriyaki adalah produk saus yang diperoleh dari campuran<br> kecap dengan bahan pangan yang sesuai.<br> Karakteristik dasar :<br> Bau dan rasa normal<br>",
    "Aktif",
  ],
  [
    12060229,
    "Saus Toping/Saus Siram",
    "Saus toping/saus siram adalah produk saus yang diperoleh dari campuran rempah-rempah dengan atau tanpa penambahan saus tomat atau pasta tomat dan dengan atau tanpa penambahan bahan pangan lain untuk digunakan sebagai toping atau siram pada masakan dengan atau tanpa dimasak terlebih dahulu. Misalnya: saus jamur, dan saus lainnya.<br>",
    "Aktif",
  ],
  [
    12060230,
    "Saus Salsa",
    "Saus salsa adalah saus yang mengandung cacahan tomat dan cabe, serta dapat ditambahkan bahan pangan lain.<br>",
    "Aktif",
  ],
  [12060231, "Saus Tinta Cumi", "-", "Aktif"],
  [
    12060232,
    "Saus Putih (Berbasis Krim)",
    "Saus putih (berbasis krim) adalah saus yang mengandung bahan<br> utama susu atau krim dengan sedikit penambahan lemak dan<br> tepung dengan atau tanpa bumbu atau rempah.",
    "Aktif",
  ],
  [
    120603,
    "Campuran Untuk Saus, Gravies, dan Dressing",
    "\"Produk konsentrat, biasanya berbentuk bubuk, untuk nantinya<br> dicampurkan dengan air, susu, minyak ataupun cairan lain untuk<br> menghasilkan produk siap saji berupa saus, gravies dan dressing.<br> Termasuk di dalamnya konsentrat dari saus teremulsi ataupun saus<br> non emulsi. Termasuk dalam kategori ini antara lain bumbu kacang<br> yang harus ditambah air sebelum digunakan\"<br>",
    "Aktif",
  ],
  [
    12060401,
    "Kecap Ikan",
    "Kecap ikan adalah produk cair yang diperoleh dari hasil fermentasi ikan atau hidrolisis dengan atau tanpa penambahan pangan lain.",
    "Aktif",
  ],
  [
    12060402,
    "Saus Tiram Bening",
    "Saus tiram bening adalah produk cairan bening, diperoleh dari hasil<br> olahan daging tiram (Crassostrea calculata sp.) dengan penambahan<br> bahan pangan lain<br>",
    "Aktif",
  ],
  [
    120701,
    "Produk Oles Untuk Salad",
    "Termasuk bahan-bahan salad, produk oles sandwich berbasis susu, produk oles sandwich menyerupai mayonais, dan dressing untuk<br> coleslaw (salad kubis), olesan roti rasa pedas, saus rasa bawang<br> (French onion dip), saus untuk salad (guacamole style dip), saus<br> savoury.",
    "Aktif",
  ],
  [
    120703,
    "Olesan/Saus",
    "Olesan/saus adalah produk berupa emulsi atau non emulsi yang<br> tidak termasuk kategori 12.6, mempunyai rasa savoury (gurih<br> manis), pedas, asam, atau rasa lain dan digunakan untuk olesan<br>",
    "Aktif",
  ],
  [
    120801,
    "Ragi Roti Kering",
    "Ragi roti kering adalah produk yang dibuat dengan cara membiakkan kamir jenis Saccharomyces cereviceae dalam media serealia atau bahanlain yang sesuai, dalam keadaan bersih, kering dan mempunyai kemampuan meragikan adonan tepung terigu dengan atau tanpa campuran tepung lain pada pembuatan roti dan kue. Ragi roti kering berbentuk serbuk atau butiran, berwarna kekuningan sampai kecoklatan.<br> Karakteristik dasar:Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    120802,
    "Ragi Tape",
    "Ragi tape adalah produk yang dibuat dari tepung beras yang telah<br> dicampur dengan beberapa rempah-rempah untuk menstimulir<br> pertumbuhan kapang dan kamir yang telah dikeringkan dan<br> berperan dalam pembuatan tape.",
    "Aktif",
  ],
  [
    120803,
    "Ragi Tempe",
    "Ragi tempe adalah produk yang dibuat dari bahan sumber<br> karbohidrat (pati) yang mengandung kapang Rhizopus oligosporus<br> yang telah dikeringkan dan digunakan dalam pembuatan tempe.",
    "Aktif",
  ],
  [
    120804,
    "Ragi Roti Semi Kering",
    "Ragi roti semi kering adalah produk yang dibuat dengan cara membiakkan kamir jenis Saccharomyces cereviceae dalam media serealia atau bahan lain yang sesuai, dalam keadaan bersih, semi kering dan mempunyai kemampuan meragikan adonan tepung terigu dengan atau tanpa campuran tepung lain pada pembuatan roti dan kue. Ragi roti semi kering berbentuk serbuk atau butiran, berwarna kekuningan sampai kecoklatan.<br> Karakteristik dasar :<br> Kadar air lebih dari 5% sampai dengan 20%",
    "Aktif",
  ],
  [
    120805,
    "Ragi Roti Padat (compressed yeast)",
    "Ragi roti padat adalah produk yang dibuat dengan cara membiakkan kamir jenis Saccharomyces cereviceae dalam media serealia atau bahan lain yang sesuai, dalam keadaan bersih, berbentuk padat dan mempunyai kemampuan meragikan adonan tepung terigu dengan atau tanpa campuran tepung lain pada pembuatan roti dan kue. Ragi roti padat berwarna kekuningan sampai kecoklatan.<br> Karakteristik dasar :<br> Kadar air 63% - 70%",
    "Aktif",
  ],
  [
    120806,
    "Ragi Roti Cair (cream yeast)",
    "Ragi roti cair adalah produk yang dibuat dengan cara membiakkan<br> kamir jenis Saccharomyces cereviceae dalam media serealia atau<br> bahan lain yang sesuai, dalam keadaan bersih, berbentuk cairan<br> kental dan mempunyai kemampuan meragikan adonan tepung<br> terigu dengan atau tanpa campuran tepung lain pada pembuatan<br> roti dan kue. Ragi roti cair berwarna kekuningan sampai<br> kecoklatan<br> Karakteristik dasar :<br> Kadar air lebih dari 70% sampai dengan 80%<br>",
    "Aktif",
  ],
  [
    120807,
    "Koji atau Ragi Tauco atau Ragi Kecap",
    "Koji atau ragi tauco atau ragi kecap adalah produk yang dibuat dari serealia yang ditumbuhi Aspergillus oryzae, yang telah dikeringkan dan digunakan untuk pembuatan kecap/tauco/miso.",
    "Aktif",
  ],
  [
    120808,
    "Ragi Untuk Minuman Beralkohol",
    "Ragi untuk minuman beralkohol adalah produk yang dibuat dari bahan sumber karbohidrat (pati) yang mengandung kamir yang telah dikeringkan dan digunakan dalam pembuatan minuman beralkohol.",
    "Aktif",
  ],
  [
    12090101,
    "Doujiang",
    "produk yang dibuat dari kedelai, garam, air dan ingredien lainnya dengan proses fermentasi yang dapat digunakan dalam persiapan sup, dressing atau bumbu.",
    "Aktif",
  ],
  [
    12090102,
    "Doenjang",
    "produk yang dibuat dari kedelai, garam, air dan ingredien lainnya dengan proses fermentasi yang dapat digunakan dalam persiapan sup, dressing atau bumbu<br>",
    "Aktif",
  ],
  [
    12090103,
    "Miso",
    "Miso adalah produk yang dibuat dari kedelai, beras/barley/koji, garam, air, dengan atau tanpa penambahan bahan pangan lain, dengan proses fermentasi, dan menghasilkan tekstur pasta yang halus, serta rasa, warna, aroma khas miso. Dapat digunakan untuk soup base, kondimen, maupun penyedap rasa.",
    "Aktif",
  ],
  [
    12090104,
    "Tauco",
    "Tauco adalah produk kedelai yang diperoleh dari kacang kedelai hasil fermentasi kacang kedelai dalam larutan garam, berbau khas dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [12090201, "Saus Kedelai Fermentasi", "", "Aktif"],
  [
    1209020101,
    "Kecap Kedelai Asin (Salty Soy Sauce)",
    "Kecap kedelai asin (salty soy sauce) adalah produk berbentuk cair yang diperoleh dari hasil fermentasi kacang kedelai (Glycine max L.) atau bungkil kedelai dengan atau tanpa penambahan bahan pangan lain.<br> Karakteristik dasar :<br> - Bau dan rasa normal khas<br> - Kadar protein (N x 6,25) tidak kurang dari 4,0%",
    "Aktif",
  ],
  [
    1209020102,
    "Tauco",
    "Tauco adalah produk kedelai yang diperoleh dari kacang kedelai hasil fermentasi kacang kedelai dalam larutan garam, berbau khas dengan atau tanpa penambahan bahan pangan lainnya.",
    "Tidak Aktif",
  ],
  [
    1209020201,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat",
    "Kecap kedelai asin non fermentasi/hidrolisat adalah produk cair yang diperoleh dari hasil pengolahan dan atau cara kimia (hidrolisis) kacang kedelai (Glycine max L.) dengan atau tanpa penambahan bahan pangan lain.<br> Karakteristik dasar :<br> - Kadar protein (N x 6,25) tidak kurang dari 4,0%",
    "Aktif",
  ],
  [
    1209020202,
    "Saus Kedelai Non-Fermentasi",
    "Saus kedelai non-fermentasi, yang sering disebut juga sebagai saus nonbrewed, dapat dibuat dari protein sayuran, seperti kedelai nonfermentasi yang dihidrolisis dengan asam (misalnya asam hidroklorat), dinetralkan (contohnya dengan natrium karbonat), dan disaring.",
    "Aktif",
  ],
  [
    1209020203,
    "Saus Protein Nabati Terhidrolisis",
    "Saus protein nabati terhidolisis adalah produk saus yang diperoleh dari protein nabati terhidrolisis.<br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Total nitrogen tidak kurang dari 2,75%<br> \xE2\x{20AC}\xA2 Kadar garam tidak kurang dari 10%",
    "Aktif",
  ],
  [
    1209020301,
    "Kecap Kedelai Manis (Sweet Soy Sauce)",
    "Kecap kedelai manis adalah produk berbentuk cair yang diperoleh dari hasil fermentasi kacang kedelai (Glycine max L.) atau bungkil kedelai ditambah gula dengan atau tanpa penambahan bahan pangan lain.<br>",
    "Aktif",
  ],
  [
    1209020302,
    "Kecap Asin (Salty Soy Sauce)",
    "Kecap asin (salty soy sauce) adalah produk cair yang diperoleh dari hasil fermentasi kacang kedelai (Glycine max L.) dan gula, gula merah, dengan atau tanpa proses karamelisasi dengan atau tanpa penambahan bahan pangan lain.",
    "Tidak Aktif",
  ],
  [
    1209020303,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder)",
    "Kecap yang dikeringkan/ bubuk kecap (fermented soy sauce powder) adalah produk kering yang diperoleh dari pengeringan hasil fermentasi kedelai. Dapat mengandung bahan pangan atau bahan tambahan yang sesuai.",
    "Aktif",
  ],
  [
    1209020304,
    "Saus Kedelai Lainnya",
    "Saus kedelai lainnya adalah saus yang bukan emulsi, dibuat dengan saus kedelai fermentasi atau tanpa fermentasi, dengan atau tanpa penambahan gula, dengan atau tanpa proses karamelisasi, dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    1209020305,
    "Kecap Pedas",
    "Kecap pedas adalah produk campuran kecap manis dengan cabe dengan atau tanpa penambahan bahan pangan lain.<br>",
    "Aktif",
  ],
  [
    1209020306,
    "Kecap Bumbu",
    "Kecap bumbu adalah produk campuran kecap dan rempah-rempah dengan atau tanpa penambahan bahan pangan lain.<br>",
    "Aktif",
  ],
  [
    1209020307,
    "Saus Campuran Protein Nabati Terhidrolisis",
    "Saus campuran protein nabati terhidrolisis adalah produk saus yang diperoleh dari campuran protein nabati terhidrolisis dengan cairan bening yang diperoleh dari fermentasi kacang kedelai (Glycine max) dan serealia atau tepung.<br> <br> Karakteristik dasar:<br> Total nitrogen tidak kurang dari 0,3%<br> Kadar garam tidak kurang dari 3%<br>",
    "Aktif",
  ],
  [
    1209020308,
    "Saus Kedelai Lainnya dalam Kaleng",
    "Saus kedelai lainnya adalah saus yang bukan emulsi, dibuat dengan<br> saus kedelai fermentasi atau tanpa fermentasi, dengan atau tanpa<br> penambahan gula, dengan atau tanpa proses karamelisasi, dengan<br> atau tanpa penambahan bahan pangan lain, dikemas dalam kaleng.",
    "Tidak Aktif",
  ],
  [
    12090204,
    "Saus Kedelai Fermentasi dalam Kaleng",
    "Saus dengan bahan dasar kedelai yang jernih, bukan emulsi, dengan campuran gandum, tepung, garam dan air melalui proses fermentasi",
    "Tidak Aktif",
  ],
  [
    121001,
    "Produk Protein Gandum",
    "Produk protein gandum adalah produk yang diperoleh dengan cara pengurangan atau penghilangan komponen-komponen utama nonprotein (air, minyak, pati dan karbohidrat lain) dari gandum atau tepung gandum. Ingredien yang dapat digunakan adalah karbohidrat termasuk gula, lemak dan minyak makan, produk protein lain, vitamin dan mineral, garam, herbadan rempah.",
    "Aktif",
  ],
  [
    121002,
    "Produk Protein Kedelai",
    "Produk protein kedelai adalah produk yang diperoleh dari proses pengurangan atau penghilangan komponen-komponen utama non-protein (air, minyak, pati dan karbohidrat lain) dari kacang kedelai untuk mencapai kadar protein (Nx6,25) :<br> (1) Tepung protein kedel",
    "Tidak Aktif",
  ],
  [
    121003,
    "Hydrolised Vegetable Protein (HVP)",
    "Hydrolised vegetable protein (HVP) adalah produk protein mengandung asam amino yang diperoleh dari hidrolisis protein kedelai atau lainnya, dapat berbentuk cair atau bubuk.",
    "Aktif",
  ],
  [121005, "Protein Susu", "-", "Aktif"],
  [
    121006,
    "Produk Olahan Gluten",
    "Produk olahan gluten adalah produk protein yang diperoleh dari ekstraksi/isolasi protein gandum, rye, barley,dan triticale atau lainnya, dapat berbentuk cair atau padat.",
    "Aktif",
  ],
  [
    121007,
    "Produk Protein Nabati (Vegetable Protein Products)",
    "-",
    "Aktif",
  ],
  [
    13010101,
    "Formula Bayi Bubuk",
    "Formula sebagai pengganti ASI untuk bayi (sampai umur 6 (enam) bulan, tidak lebih dari umur 12 (dua belas) bulan) yang secara khusus diformulasikan untuk menjadi satu-satunya sumber zat gizi dalam bulan-bulan pertama kehidupannya sampai bayi diperkenalkan",
    "Tidak Aktif",
  ],
  [
    13010102,
    "Formula Bayi Cair",
    "Formula sebagai pengganti ASI untuk bayi (sampai umur 6 (enam) bulan, tidak lebih dari umur 12 (dua belas) bulan) yang secara khusus diformulasikan untuk menjadi satu-satunya sumber zat gizi dalam bulan-bulan pertama kehidupannya sampai bayi diperkenalkan",
    "Tidak Aktif",
  ],
  [
    13010201,
    "Formula Lanjutan Bubuk",
    "Formula lanjutan adalah produk yang diperoleh dari susu sapi atau susu hewan lain dan atau bagian yang dapat dimakan dari hewan termasuk ikan, dan atau berasal dari tumbuh-tumbuhan yang semuanya telah dibuktikan cocok untuk digunakan sebagai makanan bayi",
    "Tidak Aktif",
  ],
  [13010202, "Formula Lanjutan Cair", "", "Tidak Aktif"],
  [13010401, "Formula Pertumbuhan Bubuk", "", "Tidak Aktif"],
  [13010402, "Formula Pertumbuhan Cair", "", "Tidak Aktif"],
  [
    130305,
    "Biskuit Diet Diabetes",
    "Biskuit diet diabetes adalah makanan yang diperoleh dengan memanggang adonan yang mengandung bahan dasar tepung terigu dan atau tepung pati lainnya, dengan atau tanpa tambahan bahan pemanis alami/buatan yang sesuai dengan penderita diabetes, serta tambaha",
    "Tidak Aktif",
  ],
  [
    130318,
    "Makanan Diet Diabetes Berbasis Susu (Padat)",
    "",
    "Tidak Aktif",
  ],
  [
    130319,
    "Makanan Diet Diabetes Berbasis Susu (Cair)",
    "",
    "Tidak Aktif",
  ],
  [
    130320,
    "Makanan Diet Diabetes Siap Masak (Padat)",
    "",
    "Tidak Aktif",
  ],
  [
    130321,
    "Makanan Diet Diabetes Siap Masak (Cair)",
    "",
    "Tidak Aktif",
  ],
  [
    130322,
    "Makanan Diet Diabetes Siap Santap (Padat)",
    "",
    "Tidak Aktif",
  ],
  [
    130323,
    "Makanan Diet Diabetes Siap Santap (Cair)",
    "",
    "Tidak Aktif",
  ],
  [130324, "Makanan Diet Diabetes Bubuk Instan", "", "Tidak Aktif"],
  [
    1304010101,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat",
    "-",
    "Tidak Aktif",
  ],
  [
    1304010102,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Cair (Steril)",
    "-",
    "Tidak Aktif",
  ],
  [
    1304010201,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat",
    "-",
    "Tidak Aktif",
  ],
  [
    1304010202,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Cair (Steril)",
    "-",
    "Tidak Aktif",
  ],
  [
    13050101,
    "Minuman untuk Ibu Hamil Pasteurisasi",
    "",
    "Tidak Aktif",
  ],
  [
    13050102,
    "Minuman untuk Ibu Hamil Sterilisasi",
    "",
    "Tidak Aktif",
  ],
  [13050103, "Minuman untuk Ibu Menyusui Bubuk", "", "Tidak Aktif"],
  [
    13050104,
    "Minuman untuk Ibu Menyusui Pasteurisasi",
    "",
    "Tidak Aktif",
  ],
  [
    13050105,
    "Minuman untuk Ibu Menyusui Sterilisasi",
    "",
    "Tidak Aktif",
  ],
  [13050106, "Minuman untuk Ibu Hamil Bubuk", "", "Tidak Aktif"],
  [
    13050501,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat",
    "-",
    "Tidak Aktif",
  ],
  [
    13050502,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Cair (Steril)",
    "-",
    "Tidak Aktif",
  ],
  [
    13050503,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat",
    "-",
    "Tidak Aktif",
  ],
  [
    13050504,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Cair (Steril)",
    "-",
    "Tidak Aktif",
  ],
  [
    13050505,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat",
    "-",
    "Tidak Aktif",
  ],
  [
    13050506,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Cair (Steril)",
    "-",
    "Tidak Aktif",
  ],
  [
    13050507,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat",
    "-",
    "Tidak Aktif",
  ],
  [
    13050508,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Cair (Steril)",
    "-",
    "Tidak Aktif",
  ],
  [1307, "Formula Bayi Padat", "", "Aktif"],
  [1308, "Formula Bayi Cair", "", "Aktif"],
  [1309, "Formula Lanjutan Padat", "-", "Aktif"],
  [1310, "Formula Lanjutan Cair", "", "Aktif"],
  [1311, "Formula Pertumbuhan Padat", "", "Aktif"],
  [1312, "Formula Pertumbuhan Cair", "", "Aktif"],
  [
    1313,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat",
    "&nbsp;",
    "Aktif",
  ],
  [
    1314,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair",
    "&nbsp;",
    "Aktif",
  ],
  [
    1315,
    "MP ASI Pokok usia sampai 2 tahun Padat",
    "&nbsp;",
    "Aktif",
  ],
  [
    1316,
    "MP ASI Pokok usia sampai 2 tahun Cair",
    "&nbsp;",
    "Aktif",
  ],
  [
    1317,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat",
    "&nbsp;",
    "Aktif",
  ],
  [
    1318,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair",
    "&nbsp;",
    "Aktif",
  ],
  [
    1319,
    "MP ASI Kudapan usia sampai 2 tahun Padat",
    "&nbsp;",
    "Aktif",
  ],
  [
    1320,
    "MP ASI Kudapan usia sampai 2 tahun Cair",
    "&nbsp;",
    "Aktif",
  ],
  [1321, "Pangan Ibu Hamil Padat", "", "Aktif"],
  [1322, "Pangan Ibu Hamil Cair", "", "Aktif"],
  [1323, "Pangan Ibu Menyusui Padat", "", "Aktif"],
  [1324, "Pangan Ibu Menyusui Cair", "", "Aktif"],
  [1325, "Pangan Ibu Hamil dan Menyusui Padat", "", "Aktif"],
  [1326, "Pangan Ibu Hamil dan Menyusui Cair", "", "Aktif"],
  [
    1327,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat",
    "",
    "Tidak Aktif",
  ],
  [
    1328,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Cair",
    "",
    "Tidak Aktif",
  ],
  [
    1329,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat",
    "",
    "Tidak Aktif",
  ],
  [
    1330,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair",
    "",
    "Tidak Aktif",
  ],
  [
    1331,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat",
    "",
    "Tidak Aktif",
  ],
  [
    1333,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat",
    "",
    "Tidak Aktif",
  ],
  [
    1334,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair",
    "",
    "Tidak Aktif",
  ],
  [1335, "Pangan Untuk Kontrol Berat Badan Padat", "", "Aktif"],
  [1336, "Pangan Untuk Kontrol Berat Badan Cair", "", "Aktif"],
  [1337, "Pangan Diet Penurun Berat Badan Padat", "", "Aktif"],
  [1338, "Pangan Diet Penurun Berat Badan Cair", "", "Aktif"],
  [
    1339,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat",
    "",
    "Aktif",
  ],
  [
    1340,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Cair",
    "",
    "Aktif",
  ],
  [
    1341,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat",
    "",
    "Aktif",
  ],
  [
    1342,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair",
    "",
    "Aktif",
  ],
  [1343, "Human Milk Fortifier (HMF) Padat", "", "Aktif"],
  [1344, "Human Milk Fortifier (HMF) Cair", "", "Aktif"],
  [
    1345,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat",
    "",
    "Aktif",
  ],
  [
    1346,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Cair",
    "",
    "Aktif",
  ],
  [
    1347,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat",
    "",
    "Aktif",
  ],
  [
    1348,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair",
    "",
    "Aktif",
  ],
  [
    1349,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat",
    "",
    "Aktif",
  ],
  [
    1350,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair",
    "",
    "Aktif",
  ],
  [
    1351,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat",
    "",
    "Aktif",
  ],
  [
    1352,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair",
    "",
    "Aktif",
  ],
  [
    1353,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat",
    "",
    "Aktif",
  ],
  [
    1354,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair",
    "",
    "Aktif",
  ],
  [
    1355,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat",
    "",
    "Aktif",
  ],
  [
    1356,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Cair",
    "",
    "Aktif",
  ],
  [
    1357,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat",
    "",
    "Aktif",
  ],
  [
    1358,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Cair",
    "",
    "Aktif",
  ],
  [
    1363,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat",
    "",
    "Aktif",
  ],
  [
    1364,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair",
    "",
    "Aktif",
  ],
  [
    1365,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat",
    "",
    "Aktif",
  ],
  [
    1366,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair",
    "",
    "Aktif",
  ],
  [
    1367,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat",
    "",
    "Aktif",
  ],
  [
    1368,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Cair",
    "",
    "Aktif",
  ],
  [
    1369,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat",
    "",
    "Aktif",
  ],
  [
    1370,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Cair",
    "",
    "Aktif",
  ],
  [
    1371,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat",
    "",
    "Aktif",
  ],
  [
    1372,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Cair",
    "",
    "Aktif",
  ],
  [
    1373,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat",
    "",
    "Aktif",
  ],
  [
    1374,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair",
    "",
    "Aktif",
  ],
  [
    1375,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat",
    "",
    "Aktif",
  ],
  [
    1376,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair",
    "",
    "Aktif",
  ],
  [
    1377,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat",
    "Padat dan Cair",
    "Aktif",
  ],
  [
    1378,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair)",
    "-",
    "Tidak Aktif",
  ],
  [
    1379,
    "Pangan Tambahan untuk Olahragawan Berbasis Protein",
    "Padat dan Cair",
    "Aktif",
  ],
  [1381, "Formula Khusus Untuk Anak", "-", "Aktif"],
  [
    1382,
    "PKMK Program Pemerintah Untuk Anak (Padat)",
    "-",
    "Aktif",
  ],
  [
    1383,
    "PKMK Program Pemerintah Untuk Dewasa (Padat)",
    "-",
    "Aktif",
  ],
  [
    1388,
    "Pangan Tambahan untuk Olahragawan Tinggi Energi Protein",
    "Padat dan Cair",
    "Aktif",
  ],
  [
    1390,
    "Makanan Selingan untuk Anak (Padat)",
    "Untuk anak usia 1-3 tahun",
    "Aktif",
  ],
  [
    1391,
    "Makanan Selingan untuk Anak - Cair (Steril)",
    "Untuk anak usia 1-3 tahun",
    "Aktif",
  ],
  [
    1392,
    "Minuman Olahraga (Padat)",
    "Minuman Olahraga diperuntukkan bagi orang yang melakukan olahraga endurance dengan mempertimbangkan kandungan cairan, elektrolit, dan energi digunakan untuk secara cepat menggantikan cairan tubuh, elektrolit dan energi sehingga dapat meningkatkan, mempertahankan dan memulihkan tenaga pada olahraga endurance.",
    "Aktif",
  ],
  [
    1393,
    "Minuman Olahraga (Cair)",
    "Minuman Olahraga diperuntukkan bagi orang yang melakukan olahraga endurance dengan mempertimbangkan kandungan cairan, elektrolit, dan energi digunakan untuk secara cepat menggantikan cairan tubuh, elektrolit dan energi sehingga dapat meningkatkan, mempertahankan dan memulihkan tenaga pada olahraga endurance.",
    "Aktif",
  ],
  [
    1394,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat)",
    "-",
    "Aktif",
  ],
  [
    1395,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair)",
    "-",
    "Aktif",
  ],
  [
    1396,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat)",
    "PKMK untuk Bayi Intoleransi Laktosa adalah pangan yang diformulasikan secara khusus bagi bayi yang mengalami intoleransi laktosa. PKMK untuk bayi intoleransi laktosa dapat digunakan sebagai makanan pengganti atau makanan tambahan, sehingga dapat memenuhi kebutuhan gizi bayi yang mengalami intoleransi laktosa.",
    "Aktif",
  ],
  [
    1397,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair)",
    "PKMK untuk Bayi Intoleransi Laktosa adalah pangan yang diformulasikan secara khusus bagi bayi yang mengalami intoleransi laktosa. PKMK untuk bayi intoleransi laktosa dapat digunakan sebagai makanan pengganti atau makanan tambahan, sehingga dapat memenuhi kebutuhan gizi bayi yang mengalami intoleransi laktosa.",
    "Aktif",
  ],
  [
    1398,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat)",
    "Pangan yang diformulasikan secara khusus bagi pasien penyakit ginjal kronik, dapat digunakan sebagai makanan pengganti ataupun makanan tambahan, dengan memperhitungkan kebutuhan dan asupan gizi per hari pasien penyakit ginjal kronik.",
    "Aktif",
  ],
  [
    1401010101,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water)",
    "Air mineral alami terkarbonasi secara alami adalah air mineral alami yang mengandung karbondioksida yang sama dengan kandungan karbondioksida yang terdapat pada sumber airnya dan jika kurang dapat diganti atau ditambah karbondioksida dari sumber airnya.",
    "Tidak Aktif",
  ],
  [
    1401010102,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian",
    "Air mineral alami dikarbonasi adalah air mineral alami yang dikarbonasi dengan karbondioksida dari sumber air lain.",
    "Tidak Aktif",
  ],
  [
    1401010103,
    "Air Mineral Alami yang Diperkaya",
    "Air mineral alami yang diperkaya adalah air mineral alami yang mengandung karbondioksida lebih tinggi dari sumbernya, dengan cara menambahkan gas karbondioksida dari mata air yang berasal dari sumbernya.",
    "Tidak Aktif",
  ],
  [
    1401010104,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water)",
    "Air mineral alami dikarbonasi adalah air mineral alami yang dikarbonasi dengan karbondioksida dari sumber air lain.",
    "Tidak Aktif",
  ],
  [
    1401010105,
    "Air Mineral Alami",
    "Air mineral alami adalah air minum yang diperoleh langsung dari air sumber alami atau di bor dari sumur dalam dengan proses terkendali yang menghindari pencemar atau pengaruh luar atas sifat kimia, fisika, dan mikrobiologi air mineral alami.<br> Klasifikasi air mineral alami yaitu:<br> a. Air mineral alami berkarbonasi alami<br> Air mineral alami yang secara alami mengandung karbondioksida pada suhu dan tekanan normal.<br> b. Air mineral alami tanpa karbonasi<br> Air mineral alami yang tidak mengandung karbondioksida bebas setelah dikemas.<br> c. Air mineral alami dekarbonasi<br> Air mineral alami yang mengandung karbondioksida lebih rendah dari sumbernya setelah dikemas.<br> d. Air mineral alami fortifikasi dengan karbon dioksida dari sumbernya<br> Air mineral alami dengan penambahan karbondioksida yang berasal dari sumbernya dan kandungan karbondioksida setelah dikemas lebih tinggi dari sumbernya.<br> e. Air mineral alami dikarbonasi<br> Air mineral alami yang ditambahkan karbondioksida dari sumber lain.",
    "Aktif",
  ],
  [
    1401010204,
    "Air Bermineral",
    "Air bermineral adalah air minum yang ditambahkan mineral.",
    "Tidak Aktif",
  ],
  [
    1401010205,
    "Air Soda",
    "Air soda adalah air minum yang mengandung gas karbondioksida, tidak berwarna, tidak berbau.<br> <br> Karakteristik dasar :<br> Kadar CO2 tidak kurang dari 5.890 mg/L",
    "Aktif",
  ],
  [
    1401010206,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen)",
    "Air yang dikemas di dalam botol atau bentuk kemasan lainnya dan ditambahkan gas oksigen.",
    "Aktif",
  ],
  [1401010207, "Air Minum Bervitamin", "", "Tidak Aktif"],
  [
    1401010209,
    "Air minum dalam kemasan (Air Demineral)",
    "Air minum dalam kemasan adalah air baku yang telah diproses, dikemas, dan aman diminum mencakup air mineral dan air demineral.<br> Air demineral adalah air minum dalam kemasan yang diperoleh melalui proses pemurnian seperti destilasi, deionisasi, reverse osmosis, dan proses setara.",
    "Aktif",
  ],
  [
    1401010211,
    "Air Minum Dalam Kemasan (Air Mineral)",
    "Air minum dalam kemasan adalah air baku yang telah diproses, dikemas, dan aman diminum mencakup air mineral dan air demineral.<br> Air mineral adalah air minum dalam kemasan yang mengandung mineral dalam jumlah tertentu tanpa menambahkan mineral.",
    "Aktif",
  ],
  [1401010212, "Air Embun", "-", "Aktif"],
  [
    1401010213,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen)",
    "Air yang dikemas di dalam botol atau bentuk kemasan lainnya dan ditambahkan gas oksigen.",
    "Aktif",
  ],
  [
    1401010214,
    "Air Minum pH Tinggi",
    "Air minum pH tinggi adalah air minum yang mengandung mineral dalam jumlah tertentu tanpa menambahkan mineral, dengan atau tanpa penambahan oksigen (O2) atau karbondioksida (CO2), dan memiliki pH tinggi.<br> <br> Karakteristik dasar :<br> \x{2022} pH antara 8,6 \x{2013} 9,5<br> \x{2022} memenuhi persyaratan mutu air mineral (selain pH)",
    "Aktif",
  ],
  [
    1401010215,
    "Air Mineral Berkarbonat",
    "Air mineral yang dikemas di dalam botol atau bentuk kemasan lainnya dan ditambahkan gas karbondioksida.",
    "Aktif",
  ],
  [
    1401010216,
    "Air Demineral Berkarbonat",
    "Air demineral yang dikemas di dalam botol atau bentuk kemasan lainnya dan ditambahkan gas karbondioksida.",
    "Aktif",
  ],
  [
    1401020101,
    "Sari Buah",
    "Sari buah adalah cairan yang diperoleh dari bagian buah yang dapat dimakan yang dicuci, dihancurkan, dijernihkan (jika dibutuhkan), dengan atau tanpa pasteurisasi dan dikemas untuk dapat dikonsumsi langsung.<br> <br> Karakteristik dasar :<br> \x{2022} Kadar etanol tidak lebih dari 0,5%, kecuali sari buah yang ditetapkan kadar etanolnya sendiri;<br> \x{2022} Dapat ditambahkan konsentrat ke dalam sari buah dari jenis buah yang sama;<br> \x{2022} Dapat ditambahkan gula, tidak lebih dari 50 g/kg.",
    "Aktif",
  ],
  [
    1401020102,
    "Sari Buah Campuran",
    "Sari buah campuran adalah produk buah yang diperoleh dari dua atau lebih jenis buah segar yang masak atau daging buah yang diawetkan secara fisik, tidak difermentasi tetapi dapat terfermentasi, berisi hancuran buah, keruh atau jernih, ditujukan untuk dikonsumsi langsung. Sari buah diperoleh dengan proses mekanik atau dapat diperoleh dari rekonstitusi sari buah konsentrat. Sari buah dapat dipekatkan dan direkonstitusi dengan air untuk mempertahankan komposisi esensial dan faktor mutu dari sari buah.",
    "Aktif",
  ],
  [
    1401020103,
    "Sari Jeruk Nipis (Lime Juice)",
    "Sari jeruk nipis adalah produk sari buah yang diperoleh dari jeruk<br> nipis masak spesies Citrus aurantifolia atau varietas turunannya.<br> <br> Karakteristik dasar:<br> Total padatan tidak kurang dari 8 % (b/v)<br> Total asam (sebagai asam sitrat anhidrat) tidak kurang dari 6%<br> (b/v)<br> Dengan level brix untuk sari buah rekonstitusi dan puree<br> rekonstitusi tidak kurang dari 8,0\xB0Brix (20\xB0C).",
    "Aktif",
  ],
  [
    1401020104,
    "Sari Buah Apel",
    "Sari buah apel adalah produk sari buah yang keruh atau jernih<br> yang diperoleh dari buah apel (Pyrus malus L) masak tanpa<br> fermentasi, diawetkan secara fisik. Sari buah apel juga dapat<br> diperoleh dengan rekonstitusi konsentrat sari apel. Total asam<br> (sebagai asam sitrat anhidrat) sesuai dengan ketentuan standar dan<br> atau persyaratan yang berlaku.<br> <br> Karakteristik dasar :<br> Total padatan tidak kurang dari 10% (b/v).",
    "Aktif",
  ],
  [
    1401020105,
    "Sari Buah Jeruk Bali",
    "Sari buah jeruk Bali adalah produk sari buah yang diperoleh dari jeruk Bali masak spesies Citrus grandis dan varietasnya.<br> <br> Karakteristik dasar:<br> Total padatan tidak kurang dari 9,5% (b/v)<br> Total asam (sebagai asam sitrat anhidrat) 1 g hingga 2 g<br> Total padatan terlarut tidak kurang dari 7 g untuk setiap gram asam yang dihitung sebagai asam sitrat anhidrat",
    "Aktif",
  ],
  [
    1401020106,
    "Sari Buah Jeruk Orange, Valencia",
    "Sari buah jeruk orange, Valencia adalah produk sari buah yang diperoleh dari endokarp buah jeruk (Citrus sinensis L Osbeck) yang masak tanpa fermentasi, diawetkan secara fisik. Sari jeruk juga dapat diperoleh dengan rekonstitusi konsentrat sari buah jeruk.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan tidak kurang dari 10%<br> \xE2\x{20AC}\xA2 Jika sari buah diperoleh dari padatan sari buah yang diencerkan<br> dengan air, maka total padatan tidak kurang dari 11%<br> \xE2\x{20AC}\xA2 Kadar etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    1401020107,
    "Sari Buah Jeruk Siam, Tangerine, Jeruk Pontianak",
    "Sari buah jeruk siam, tangerine adalah produk sari buah yang<br> diperoleh dari endokarp buah jeruk tangerine (Citrus reticulata<br> Blanco) yang masak, tanpa fermentasi, diawetkan secara fisik. Sari<br> jeruk juga dapat diperoleh dengan rekonstitusi konsentrat sari buah<br> jeruk.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan tidak kurang dari 10%<br> \xE2\x{20AC}\xA2 Jika sari buah diperoleh dari padatan sari buah yang diencerkan<br> dengan air, maka total padatan tidak kurang dari 11% \xE2\x{20AC}\xA2 Kadar etanol tidak lebih dari 0,3%<br>",
    "Aktif",
  ],
  [
    1401020108,
    "Minuman Citrus Comminutes",
    "Minuman citrus comminutes adalah minuman ringan yang diperoleh dari proses yang melibatkan kelompok buah citrus utuh.",
    "Tidak Aktif",
  ],
  [
    1401020109,
    "Sari Buah Nanas",
    "Sari buah nanas adalah produk sari buah yang diperoleh dari buah<br> nanas (Ananas comocsus L Merril, Ananas sativus L Lindii) yang<br> masak, tanpa fermentasi, diawetkan secara fisik. Sari nanas juga<br> dapat diperoleh dengan rekonstitusi konsentrat sari nanas.<br> <br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 Total padatan tidak kurang dari 10%<br> \xEF\x{201A}\xB7 Jika sari buah diperoleh dari padatan sari buah yang diencerkan<br> dengan air, total padatan tidak kurang dari 13,5%.",
    "Aktif",
  ],
  [
    1401020110,
    "Sari Buah Lemon",
    "Sari buah lemon adalah produk sari buah yang diperoleh dari<br> endokarp buah lemon (Lemon burf) yang masak, tanpa fermentasi,<br> diawetkan secara fisik. Sari buah lemon juga dapat diperoleh<br> dengan rekonstitusi konsentrat sari lemon.<br> <br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 Total padatan tidak kurang dari 6%<br> \xEF\x{201A}\xB7 Total asam tertritasi (sebagai asam sitrat anhidrat) tidak kurang<br> dari 4,5%",
    "Aktif",
  ],
  [
    1401020111,
    "Sari Buah Markisa",
    "Sari buah markisa adalah produk sari buah yang diperoleh dari<br> buah markisa masak dari spesies Passiflora sp.<br> <br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 Total padatan tidak kurang dari 12% (b/v)<br> \xEF\x{201A}\xB7 Total asam (sebagai asam sitrat anhidrat) 1,5% hingga 4,5% (b/v)",
    "Aktif",
  ],
  [
    1401020112,
    "Sari Buah Anggur",
    "Sari buah anggur adalah sari buah yang diperoleh dari buah anggur<br> (Vitis sp.) matang atau dari pengenceran konsentrat sari buah<br> anggur, tanpa fermentasi, dan diawetkan.<br> <br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 pH tidak lebih dari 4<br> \xEF\x{201A}\xB7 Total padatan terlarut tidak kurang dari 15%",
    "Aktif",
  ],
  [
    1401020114,
    "Sari Buah Blackcurrant",
    "Sari buah blackcurrant adalah produk sari buah cair yang keruh<br> atau jernih yang diperoleh dari buah blackcurrant (Ribes nigrum L.)<br> yang masak tanpa fermentasi, diawetkan secara fisika.<br> Sari blackcurrant juga dapat diperoleh dengan rekonstitusi<br> konsentrat sari blackcurrant.<br> <br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 Total padatan terlarut tidak kurang dari 11% yang diukur dengan<br> refraktometer pada 20\xC2\xB0C, dibaca sebagai \xC2\xB0Brix dalam skala<br> sukrosa internasional tanpa koreksi keasaman<br> \xEF\x{201A}\xB7 Kadar etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    1401020115,
    "Sari Buah Mangga",
    "Sari buah mangga adalah produk sari buah yang diperoleh dari buah mangga (Mangifera indica L.)<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 13,0",
    "Aktif",
  ],
  [
    1401020116,
    "Sari Buah Sirsak",
    "Sari buah sirsak adalah produk sari buah yang diperoleh dari buah sirsak (Annona muricata L.)<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 12,0",
    "Aktif",
  ],
  [
    1401020117,
    "Sari Buah Pisang",
    "Sari buah pisang adalah produk sari buah yang diperoleh dari buah pisang (Mangifera indica L.)",
    "Tidak Aktif",
  ],
  [
    1401020118,
    "Sari Buah Belimbing",
    "Sari buah belimbing adalah produk sari buah yang diperoleh dari buah belimbing (Averrhoa carambola L.)<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 7,5",
    "Aktif",
  ],
  [
    1401020120,
    "Sari Buah Plum",
    "Sari buah plum adalah produk sari buah yang diperoleh dari buah plum (Prunus domestica L. Subsp. Domestica.)<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 12,0",
    "Aktif",
  ],
  [
    1401020121,
    "Sari Buah Peach",
    "Sari buah peach adalah produk sari buah yang diperoleh dari buah peach (Prumus persica (L) Batch var. nucipersica)<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 10,5",
    "Aktif",
  ],
  [
    1401020122,
    "Sari Buah Jambu Biji",
    "Sari buah jambu biji adalah produk sari buah yang diperoleh dari buah jambu biji (Psidium guajava L.)<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 7,5 untuk jambu biji merah dan 9,0 untuk jambu biji putih",
    "Aktif",
  ],
  [
    1401020123,
    "Sari Buah Delima",
    "Sari buah delima adalah produk sari buah yang diperoleh dari buah delima (Punica sp.).<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 12,0",
    "Aktif",
  ],
  [
    1401020124,
    "Sari Buah Pir",
    "Sari buah pir adalah produk sari buah yang diperoleh dari buah pir (Pyrus communis.).<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 12,0",
    "Aktif",
  ],
  [
    1401020125,
    "Sari Buah Redcurrant",
    "Sari buah redcurrant adalah produk sari buah yang diperoleh dari buah redcurrant (Ribes rubrum).<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 10,0",
    "Aktif",
  ],
  [
    1401020126,
    "Sari Buah Blackberry",
    "Sari buah blackberry adalah produk sari buah yang diperoleh dari buah blackberry (Rubus fruitcosus L.).<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 9,0",
    "Aktif",
  ],
  [
    1401020127,
    "Sari Buah Raspberry",
    "Sari buah raspberry adalah produk sari buah yang diperoleh dari buah raspberry (Rubus occidentalis L.).<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 11,0",
    "Aktif",
  ],
  [
    1401020128,
    "Sari Buah Stroberi",
    "Sari buah stroberi adalah produk sari buah yang diperoleh dari buah stroberi (Fragaria rosaceae).<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 7,0",
    "Aktif",
  ],
  [
    1401020129,
    "Sari Buah Manggis",
    "Sari buah manggis adalah produk sari buah yang diperoleh dari<br> buah manggis (Garcinia mangostana L).",
    "Aktif",
  ],
  [
    1401020130,
    "Sari Buah Terong Belanda",
    "Sari buah terong belanda adalah produk sari buah yang diperoleh<br> dari buah terong belanda (Solanum betaceum).",
    "Aktif",
  ],
  [
    1401020131,
    "Sari Buah (Kemasan Tetrapack)",
    "Sari buah adalah cairan yang diperoleh dari bagian buah yang dapat dimakan yang dicuci, dihancurkan, dijernihkan (jika dibutuhkan), dengan atau tanpa pasteurisasi dan dikemas untuk dapat dikonsumsi langsung",
    "Aktif",
  ],
  [
    1401020132,
    "Sari Buah dan Sari Sayur",
    "Sari buah dan sari sayur adalah produk yang terdiri dari campuran<br> sari buah dan sari sayur. Kandungan sari buah lebih banyak<br> daripada sari sayur.",
    "Aktif",
  ],
  [
    1401020133,
    "Sari Buah Jeruk Garut",
    "Sari buah jeruk Garut adalah produk sari buah yang diperoleh dari<br> endokarp buah jeruk Garut (Citrus nobilis) yang masak, tanpa<br> fermentasi, diawetkan secara fisik. Sari jeruk juga dapat diperoleh<br> dengan rekonstitusi konsentrat sari buah jeruk.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan tidak kurang dari 10%<br> \xE2\x{20AC}\xA2 Jika sari buah diperoleh dari padatan sari buah yang diencerkan<br> dengan air, maka total padatan tidak kurang dari 11%<br> \xE2\x{20AC}\xA2 Kadar etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    1401020134,
    "Sari Buah Jeruk Medan",
    "Sari buah jeruk Medan adalah produk sari buah yang diperoleh dari endokarp buah jeruk Medan (Citrus sinensis (L)) yang masak, tanpa fermentasi, diawetkan secara fisik. Sari jeruk juga dapat diperoleh dengan rekonstitusi konsentrat sari buah jeruk.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Total padatan tidak kurang dari 10%<br> \xE2\x{20AC}\xA2 Jika sari buah diperoleh dari padatan sari buah yang diencerkan<br> dengan air, maka total padatan tidak kurang dari 11%<br> \xE2\x{20AC}\xA2 Kadar etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    1401020135,
    "Sari Buah Prune (Prune Juice)",
    "Sari buah prune adalah produk sari buah yang diperoleh dari<br> ekstrak air buah prune (Prunus domestica L. Subsp. domestica)<br> kering. Jumlah padatan terlarut dari buah prune dapat dicapai<br> dengan pemekatan, pengenceran dari ekstrak buah atau<br> rekonstitusi konsentrat.<br> <br> Karakteristik dasar:<br> Total padatan terlarut tidak kurang dari 18,5%<br>",
    "Aktif",
  ],
  [
    1401020136,
    "Sari Buah Blueberry",
    "Sari buah blueberry adalah produk sari buah yang diperoleh dari buah blueberry (Vaccinium myrtillus L. atau Vaccinium corymbosum L. atau Vaccinium angustifolium L.).<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 10,0",
    "Aktif",
  ],
  [
    1401020137,
    "Sari Buah Leci",
    "Sari buah leci adalah produk sari buah yang diperoleh dari buah leci (Litchi chinensis Sonn.)<br> Karakteristik dasar:<br> Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 11,0",
    "Aktif",
  ],
  [
    1401020138,
    "Sari Buah Kiwi",
    "Sari buah kiwi adalah produk sari buah yang diperoleh dari buah<br> kiwi (Actinidia deliciosa).",
    "Aktif",
  ],
  [
    1401020139,
    "Sari Buah Naga",
    "Sari buah naga adalah produk sari buah yang diperoleh dari buah<br> naga (Hylocereus undatus).",
    "Aktif",
  ],
  [
    1401020201,
    "Sari Sayur",
    "Sari sayur adalah cairan yang diperoleh dari bagian tanaman sayur yang dapat dimakan yang dicuci, dihancurkan, dijernihkan (jika dibutuhkan), dengan atau tanpa pasteurisasi dan dikemas untuk dapat dikonsumsi.",
    "Aktif",
  ],
  [
    1401020202,
    "Sari Tomat",
    "Sari tomat adalah produk sari sayur yang diperoleh dari bagian yang dapat dimakan dari buah tomat (Lycopersicum esculentum L.) merah atau kemerahan, yang diawetkan secara fisik (tidak termasuk iradiasi), tidak difermentasi tetapi merupakan sari sayur yang dapat difermentasi, ditujukan untuk dapat dikonsumsi langsung. Sari tomat bebas dari kulit, biji dan bagian berupa partikel besar lain dari tomat.<br> Karakteristik dasar: Total padatan terlarut tomat tidak kurang dari 4,5% yang diukur dengan refraktometer pada 20\xB0C",
    "Aktif",
  ],
  [
    1401020203,
    "Sari Wortel",
    "Sari wortel adalah produk sari sayur yang diperoleh dari bagian<br> yang dapat dimakan dari buah wortel (Daucus carota L.), yang<br> diawetkan secara fisik (tidak termasuk iradiasi), tidak difermentasi<br> tetapi merupakan sari sayur yang dapat difermentasi, ditujukan<br> untuk dapat dikonsumsi langsung.",
    "Aktif",
  ],
  [
    1401020204,
    "Sari Sayur (Kemasan Tetrapack)",
    "Sari sayur adalah cairan yang diperoleh dari bagian tanaman sayur yang dapat dimakan yang dicuci, dihancurkan, dijernihkan (jika dibutuhkan), dengan atau tanpa pasteurisasi dan dikemas untuk dapat dikonsumsi.",
    "Aktif",
  ],
  [1401020205, "Sari Lidah Buaya", "&nbsp;", "Tidak Aktif"],
  [
    1401020206,
    "Sari Sayur Campuran",
    "Sari Sayur Campuran adalah produk sayur yang diperoleh dari dua<br> atau lebih jenis sayur segar atau sayur yang diawetkan secara fisik,<br> tidak difermentasi tetapi dapat terfermentasi, berisi hancuran sayur,<br> berwarna keruh atau jernih, ditujukan untuk dikonsumsi langsung.<br> Sari sayur diperoleh dengan proses mekanik.",
    "Aktif",
  ],
  [
    1401020207,
    "Sari Sayur dan Sari Buah",
    "Sari sayur dan sari buah adalah produk yang terdiri dari campuran<br> sari sayur dan sari buah. Kandungan sari sayur lebih banyak<br> daripada sari buah.",
    "Aktif",
  ],
  [
    1401020301,
    "Konsentrat Sari Buah Jeruk Orange, Valencia",
    "Konsentrat sari buah jeruk orange, valencia adalah produk yang<br> belum difermentasi, dapat difermentasi setelah direkonstitusi,<br> diawetkan secara fisik (tidak termasuk iradiasi), diperoleh melalui<br> proses konsentrasi, yaitu penghilangan air hingga produk<br> mempunyai total padatan tidak kurang dari 20% yang diukur<br> dengan refraktometer pada suhu 20\xB0C.",
    "Aktif",
  ],
  [
    1401020302,
    "Konsentrat Sari Buah Jeruk Siam, Tangerine",
    "Konsentrat sari buah jeruk siam, tangerine adalah produk buah<br> yang belum difermentasi, dapat difermentasi setelah direkonstitusi,<br> diawetkan secara fisik (tidak termasuk iradiasi), diperoleh melalui<br> proses konsentrasi, yaitu penghilangan air hingga produk<br> mempunyai total padatan tidak kurang dari dari 20% yang diukur<br> dengan refraktometer pada suhu 20\xB0C.",
    "Aktif",
  ],
  [
    1401020303,
    "Konsentrat Sari Buah Apel",
    "Konsentrat sari buah apel adalah produk buah yang belum<br> difermentasi, dapat difermentasi setelah direkonstitusi, diawetkan<br> secara fisik (tidak termasuk iradiasi), diperoleh melalui proses<br> konsentrasi yaitu penghilangan air hingga produk mempunyai total<br> padatan tidak kurang dari 20% yang diukur dengan refraktometer<br> pada suhu 20\xB0C.",
    "Aktif",
  ],
  [
    1401020304,
    "Konsentrat Sari Buah Anggur",
    "Konsentrat sari buah anggur adalah produk buah yang belum<br> difermentasi, dapat difermentasi setelah direkonstitusi, diawetkan<br> secara fisik (tidak termasuk iradiasi), diperoleh melalui proses<br> konsentrasi yaitu penghilangan air hingga produk mempunyai total<br> padatan tidak kurang dari 20% yang diukur dengan refraktometer<br> pada suhu 20oC.",
    "Aktif",
  ],
  [
    1401020305,
    "Konsentrat Sari Buah Anggur Manis",
    "Konsentrat sari buah anggur manis adalah produk konsentrat yang<br> belum difermentasi, dapat difermentasi setelah direkonstitusi,<br> diawetkan secara fisik (tidak termasuk iradiasi), diperoleh melalui<br> proses konsentrasi yaitu penghilangan air hingga produk<br> mempunyai total padatan tidak kurang dari 30% yang diukur<br> dengan refraktometer pada suhu 20\xB0C tanpa koreksi keasaman.",
    "Aktif",
  ],
  [
    1401020306,
    "Konsentrat Sari Buah Blackcurrant",
    "Konsentrat sari buah blackcurrant adalah produk buah yang belum<br> difermentasi, dapat difermentasi setelah direkonstitusi, diawetkan<br> secara fisik (tidak termasuk iradiasi), diperoleh melalui proses<br> konsentrasi yaitu penghilangan air hingga produk mempunyai total<br> padatan tidak kurang dari 20% yang diukur dengan refraktometer<br> pada suhu 20\xB0C.",
    "Aktif",
  ],
  [
    1401020307,
    "Konsentrat Sari Buah Nanas",
    "Konsentrat sari buah nanas adalah produk buah yang belum<br> difermentasi, dapat difermentasi setelah direkonstitusi, diawetkan<br> secara fisik (tidak termasuk radiasi ionisasi), diperoleh melalui<br> proses konsentrasi yaitu penghilangan air hingga produk<br> mempunyai total padatan tidak kurang dari 40% yang diukur<br> dengan refraktometer pada suhu 20\xB0C.",
    "Aktif",
  ],
  [
    1401020308,
    "Konsentrat Sari Buah Nanas dengan Pengawet untuk Keperluan Industri Pangan",
    "Konsentrat sari buah nanas dengan pengawet untuk keperluan industri pangan adalah produk buah tanpa fermentasi yang diperoleh dari proses konsentrasi yaitu penghilangan air hingga produk mempunyai total padatan tidak kurang dari 20% yang diukur dengan ref",
    "Tidak Aktif",
  ],
  [
    1401020309,
    "Konsentrat Minuman Sari Buah",
    "Konsentrat minuman sari buah adalah sari buah atau campuran<br> dua atau lebih sari buah yang dijadikan konsentrat dengan<br> mengurangi kadar airnya, dengan penambahan gula dan bahan<br> pangan lainnya. Konsentrat minuman sari buah dapat dikonsumsi<br> setelah diencerkan. Setelah diencerkan mengandung tidak kurang<br> dari 35% sari buah.",
    "Aktif",
  ],
  [1401020310, "Konsentrat Sari Buah ...", "&nbsp;", "Tidak Aktif"],
  [
    1401020311,
    "Konsentrat Minuman Buah",
    "Konsentrat minuman buah adalah sari buah atau campuran dua<br> atau lebih sari buah yang dijadikan konsentrat dengan mengurangi<br> kadar airnya, dengan penambahan gula dan bahan pangan lainnya.<br> Konsentrat minuman buah dapat dikonsumsi setelah diencerkan.<br> Setelah diencerkan mengandung tidak kurang dari 10% sari buah.",
    "Aktif",
  ],
  [
    1401020312,
    "Konsentrat Sari Buah dan Sari Sayur",
    "Konsentrat sari buah dan sari sayur adalah konsentrat yang berasal<br> dari campuran sari buah atau puree buah dan sari sayur.",
    "Aktif",
  ],
  [
    1401020401,
    "Konsentrat Sari Tomat",
    "Konsentrat sari tomat adalah produk yang diperoleh dari cairan<br> tomat matang (Lycopersicum esculentum P. Will). Cairan tersebut<br> dipisahkan dari kulit, biji dan bagian yang tidak diperlukan pada<br> produk akhir. Garam dan bumbu-bumbu yang sesuai lainnya dapat<br> ditambahkan, kecuali gula atau pemanis lainnya dan sari buah<br> jeruk sebagai pengatur keasaman. Produk mengandung kadar 8%<br> atau lebih buah tomat berupa padatan terlarut tetapi tidak<br> dikeringkan menjadi suatu bubuk kering atau bentuk kepingan.<br> Karakteristik dasar:<br> Kandungan tomat :<br> \xE2\x{20AC}\xA2 Pasta tomat tidak kurang dari 24%<br> \xE2\x{20AC}\xA2 Puree tomat 8% hingga 24%",
    "Aktif",
  ],
  [
    1401020402,
    "Konsentrat Sari Buah dan Sari Sayuran",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    1401020403,
    "Konsentrat Sari Sayur",
    "Konsentrat sari sayur adalah produk sayur yang dibuat dari sari<br> sayur yang berasal dari satu atau lebih jenis sayur, yang dipekatkan<br> dengan menghilangkan sebagian airnya. Konsentrat sari sayur<br> terdapat dalam bentuk serbuk, cairan, sirup dan bentuk beku<br> sebagai bahan untuk tujuan persiapan dari sari sayur siap minum<br> dengan penambahan air.",
    "Aktif",
  ],
  [14010205, "Sari Buah dan Sari Sayuran", "&nbsp;", "Tidak Aktif"],
  [
    1401030101,
    "Nektar Buah Kecil",
    "Nektar buah kecil adalah hancuran buah yang dibuat dari buah<br> berries species atau turunan spesies: bilberries (Vaccinium myrtillus<br> L.); blackberries (Rubus procerus P.J. Muell., etc.); blackcurrants<br> (Ribes nigrum L.); cloudberries (Rubus chamaemorus L.); cranberries<br> (Vaccinium oxycoccus L., V. macrocarpon Ait.); redcurrants dan<br> whitecurrants (kultivar dari Ribes rubrum L., R. pallidum, Otto, and<br> Dietr., R. sylvestre (Lam.) Mert. and W.D.J. Kock, etc.); elderberries<br> (Sambucus nigra); gooseberries (Ribes uva-crispa L. dan hibridanya);<br> raspberries (Rubus idaeus L.); rose hips (Cynorrhoda of Rosa spp.);<br> rowanberries (Sorbus aucuparia L.); sea buckthorn (Hippophaea<br> rhamnoides L.); strawberi (kultivar dan hibrida dari Fragaria spp.);<br> whortleberries (Vaccinium vitis idaea L.).<br> Produk hancuran buah tersebut, dapat dipasteurisasi atau tidak,<br> dan ditujukan untuk dikonsumsi langsung, diperoleh dengan<br> mencampur hasil saringan hancuran buah yang dapat dimakan<br> atau hasil gilingan dan dihomogenisasi, produk berasal dari buah<br> berri yang bersih, masak, dipekatkan, dengan air dan gula atau<br> madu, diawetkan secara fisik.",
    "Aktif",
  ],
  [
    1401030102,
    "Nektar Buah Campuran",
    "Nektar buah campuran adalah produk buah yang dapat dipasteurisasi atau tidak, dan produk hancuran buah ditujukan untuk dikonsumsi langsung, diperoleh dengan mencampur hasil saringan hancuran buah yang dapat dimakan atau hasil gilingan dan dihomogenisasi, produk berasal dari dua atau lebih jenis buah<br> yang masak, dengan atau tanpa pemekatan atau tidak, dengan air<br> dan gula atau madu, diawetkan secara fisik. Pada buah yang<br> mengandung gula tinggi, penambahan gula dapat diabaikan.<br>",
    "Aktif",
  ],
  [
    1401030103,
    "Nektar Aprikot, Nektar Peach atau Nektar Pir/Pear",
    "Nektar aprikot, nektar peach atau nektar pir/pear adalah produk buah yang dapat dipasteurisasi atau tidak, dan produk hancuran buah ditujukan untuk dikonsumsi langsung, diperoleh dengan mencampur hasil saringan hancuran buah yang dapat dimakan atau hasil gilingan dan dihomogenisasi, produk berasal dari buah aprikot, peach atau pir/pear yang bersih, masak, dipekatkan,<br> dengan air dan gula atau madu, diawetkan secara fisik.<br>",
    "Aktif",
  ],
  [
    1401030104,
    "Nektar Blackcurrant",
    "Nektar blackcurrant adalah produk buah yang dapat dipasteurisasi<br> atau tidak, dan produk hancuran buah ditujukan untuk dikonsumsi<br> langsung, diperoleh dengan mencampur hasil saringan hancuran<br> buah yang dapat dimakan atau hasil gilingan dan dihomogenisasi,<br> produk berasal dari buah blackcurrant yang bersih, masak,<br> dipekatkan, dengan air dan gula atau madu, diawetkan secara fisik.<br> Produk dapat keruh atau jernih.",
    "Aktif",
  ],
  [
    1401030105,
    "Nektar Buah Citrus",
    "Nektar buah citrus adalah nektar hancuran buah yang dibuat dari<br> buah spesies citrus Orange (Citrus sinensis L. Osbeck); Mandarine,<br> tangerine, (Citrus reticulata) dan Grapefruit (Citrus paradisi Mcfayden)<br> dan lain-lain. Dapat dipasteurisasi atau tidak, dan ditujukan untuk<br> dikonsumsi langsung, diperoleh dengan mencampur hasil saringan<br> hancuran endokarp buah atau hasil gilingan dan dihomogenisasi,<br> produk berasal dari buah citrus masak, dipekatkan, dengan air dan<br> gula atau madu, diawetkan secara fisik.",
    "Aktif",
  ],
  [
    1401030106,
    "Nektar Jambu Biji",
    "Nektar jambu biji adalah produk buah yang dapat dipasteurisasi<br> atau tidak, dan ditujukan untuk dikonsumsi langsung, diperoleh<br> dengan mencampur hasil saringan hancuran endokarp buah atau<br> hasil gilingan dan dihomogenisasi, produk berasal dari buah jambu<br> biji (Psidium guajava), segar dan masak, dipekatkan atau tidak,<br> dengan air dan gula atau madu, diawetkan secara fisik.",
    "Aktif",
  ],
  [
    1401030107,
    "Nektar Buah",
    "Nektar buah adalah produk buah tanpa fermentasi tetapi dapat difermentasi, mengandung hancuran buah atau tidak, ditujukan untuk dikonsumsi langsung, diperoleh dengan mencampur sari<br> buah dan atau hancuran bagian buah yang dapat dimakan dan atau hasil saringan hancuran buah dari buah masak, dengan atau<br> tanpa pemekatan, dengan air, gula atau madu, dan diawetkan secara fisik. Pada buah yang mengandung gula tinggi, penambahan gula dapat diabaikan.",
    "Aktif",
  ],
  [
    1401030108,
    "Nektar Mangga",
    "Nektar Mangga adalah bubur buah yang mengandung hancuran<br> buah (pulpy atau pur\xE9e) yang dapat dipasteurisasi atau tidak, dan<br> ditujukan untuk dikonsumsi langsung, diperoleh dengan<br> mencampur hasil saringan hancuran endokarp buah atau hasil<br> gilingan dan dihomogenisasi, produk berasal dari buah mangga<br> (Mangifera indica L), segar dan masak, dipekatkan atau tidak,<br> dengan air dan gula atau madu, diawetkan secara fisik. Dapat<br> ditambahkan bahan tambahan pangan yang diizinkan.",
    "Aktif",
  ],
  [
    1401030109,
    "Nektar Sirsak",
    "Nektar Sirsak adalah bubur buah yang mengandung hancuran buah<br> (pulpy atau pur\xE9e) yang dapat dipasteurisasi atau tidak, dan<br> ditujukan untuk dikonsumsi langsung, diperoleh dengan<br> mencampur hasil saringan hancuran endokarp buah atau hasil<br> gilingan dan dihomogenisasi, produk berasal dari buah Sirsak<br> (Annona muricata L.), masak, dipekatkan atau tidak, dengan air dan<br> gula atau madu, diawetkan secara fisik.",
    "Aktif",
  ],
  [
    1401030201,
    "Nektar Sayur",
    "Nektar sayur adalah produk bubur sayur yang berupa hancuran sayur (pulpy) homogen dapat dipasteurisasi atau tidak, dan dikemas untuk siap dijual. Dapat berasal dari satu jenis sayur atau campuran dari beberapa jenis sayur.",
    "Aktif",
  ],
  [
    14010303,
    "Konsentrat Nektar Buah",
    "Konsentrat nektar buah diperoleh dari penguapan atau pembekuan dari nektar buah atau bahan pembuatnya. Konsentrat nektar buah terdapat dalam bentuk tepung, cairan, sirup dan beku untuk tujuan persiapan dari nektar buah siap minum dengan penambahan air. Contohnya adalah konsentrat nektar pir/pear dan konsentrat nektar-persik.",
    "Aktif",
  ],
  [
    14010304,
    "Konsentrat Nektar Sayur",
    "Konsentrat nektar sayur adalah konsentrat yang diperoleh dari penguapan atau pembekuan dari nektar sayur atau bahan pembuatnya. Konsentrat nektar sayur terdapat dalam bentuk tepung, cairan, sirup dan beku untuk tujuan persiapan dari nektar sayur siap minum dengan penambahan air.",
    "Aktif",
  ],
  [
    1401040101,
    "Minuman Elektrolit Berkarbonat",
    "Minuman elektrolit berkarbonat adalah minuman formulasi berkarbonasi yang ditujukan untuk menggantikan cairan, karbohidrat, elektrolit dan mineral tubuh dengan cepat. Dapat<br> mengandung kalsium fosfat, kalium fosfat, kalsium sitrat, kalium sitrat, kalium karbonat termasuk kalium bikarbonat, kalium klorida, kalsium klorida, natrium klorida, kalsium laktat,<br> magnesium laktat dan magnesium sulfat.",
    "Tidak Aktif",
  ],
  [
    1401040103,
    "Minuman Isotonik Berkarbonat",
    "Minuman isotonik berkarbonat adalah minuman ringan karbonasi yang mengandung elektrolit, gula, asam sitrat dan mineral-mineral garam.",
    "Tidak Aktif",
  ],
  [1401040106, "Serbuk Minuman Berkarbonat", "", "Tidak Aktif"],
  [
    1401040108,
    "Minuman Berkarbonat",
    "Minuman berkarbonat adalah produk minuman yang diperoleh dari proses pencampuran air minum dengan bahan perisa dengan atau tanpa penambahan gula, glukosa atau bagian yang dapat dimakan, sari buah, dan karbondioksida.",
    "Tidak Aktif",
  ],
  [
    1401040109,
    "Ginger Ale",
    "Ginger ale adalah minuman berkarbonat yang dibuat dari perisa ginger ale (konsentrat perisa dengan jahe sebagai komponen utama, dengan atau tanpa bahan pemberi aroma dan penyengat, minyak citrus, sari buah dan pewarna karamel), asam organik, air minum, dan sirup gula, dengan atau tanpa pewarna karamel.<br> <br> Karakteristik dasar :<br> Kandungan tidak lebih dari 14o Brix",
    "Aktif",
  ],
  [
    1401040110,
    "Sarsaparilla",
    "Sarsaparilla adalah minuman berkarbonat yang diperoleh dari perisa sarsaparila (konsentrat perisa yang mengandung pengganti sassafras/sassafras substitute dan metil salisilat sebagai komponen<br> utama, dengan atau tanpa bahan pemberi aroma dan penyengat, dan atau tanpa pewarna karamel); asam organik; air minum dan sirup gula dengan atau tanpa pewarna karamel.<br> <br> Karakteristik dasar :<br> Kandungan tidak lebih dari 14o Brix",
    "Aktif",
  ],
  [
    1401040111,
    "Root Beer",
    "Root beer adalah minuman berkarbonat yang diperoleh dari perisa root beer (konsentrat perisa yang mengandung pengganti sassafras/sassafras substitute dan metil salisilat sebagai komponen utama, mengandung komponen perisa lainnya dan atau tanpa pewarna karamel); asam organik; air minum dan sirup gula dengan atau tanpa pewarna karamel.<br> <br> Karakteristik dasar :<br> Kandungan tidak lebih dari 14o Brix",
    "Aktif",
  ],
  [
    1401040112,
    "Birch Beer",
    "Birch beer adalah minuman berkarbonat yang diperoleh dari perisa birch beer (konsentrat perisa seperti root beer, tetapi dengan metil salisilat sebagai komponen utama), asam organik, air minum, dan sirup gula dengan atau tanpa pewarna karamel.<br> <br> Karakteristik dasar :<br> Kandungan tidak lebih dari 14o Brix",
    "Aktif",
  ],
  [
    1401040113,
    "Soda Krim (Cream soda)",
    "Soda krim (cream soda) adalah minuman berkarbonat yang diperoleh dari perisa cream soda water (konsentrat perisa vanila atau vanilin atau kombinasi keduanya sebagai komponen utama,<br> dengan bahan pemberi aroma lain, dan atau tanpa pewarna karamel); asam organik; air minum; dan sirup gula dengan atau tanpa pewarna karamel.<br> <br> Karakteristik dasar:<br> Kandungan tidak lebih dari 14o Brix",
    "Aktif",
  ],
  [
    1401040114,
    "Minuman Citrus",
    "Minuman citrus adalah minuman yang diperoleh dari sari buah citrus (konsentrasi 10 - 15%), atau perisa buah, asam organik, sirup gula dan pewarna.<br> <br> Karakteristik dasar :<br> Kandungan tidak lebih dari 14o Brix",
    "Aktif",
  ],
  [
    1401040115,
    "Minuman Kola",
    "Minuman kola adalah minuman yang diperoleh dari bahan dasar sirup gula, kafein, ekstrak buah kola (cola nut extract), asam fosfat, dan pewarna karamel.<br> <br> Karakteristik dasar :<br> Kandungan gula tidak lebih dari 14 o Brix.",
    "Aktif",
  ],
  [
    1401040116,
    "Limun",
    "Limun adalah produk minuman ringan yang mengandung gula, karbondioksida.",
    "Aktif",
  ],
  [1401040117, "Minuman Kedelai", "-", "Tidak Aktif"],
  [1401040118, "Minuman Kedelai Steril", "-", "Tidak Aktif"],
  [
    1401040119,
    "Minuman Sari Buah Berkarbonat",
    "Minuman sari buah berkarbonat adalah minuman yang diperoleh dengan mencampur air minum; sari buah atau campuran sari buah yang tidak difermentasi, dengan bagian lain dari satu jenis buah atau lebih, yang ditambahkan karbondioksida. Total sari buah tidak kurang dari 35% (b/v).<br> <br> Karakteristik dasar:<br> Kadar CO2 tidak lebih dari 5.890 mg/L",
    "Aktif",
  ],
  [
    1401040120,
    "Minuman Rasa Susu (Cair) (Berkarbonat)",
    "Minuman rasa susu adalah produk minuman yang diperoleh dari pencampuran air minum dengan susu untuk memberikan rasa, dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar lemak susu kurang dari 0.3%;<br> \xE2\x{20AC}\xA2 Kadar CO2 tidak lebih dari 5.890 mg/L.",
    "Aktif",
  ],
  [
    1401040121,
    "Minuman Berperisa Berkarbonat",
    "Minuman berperisa berkarbonat adalah produk minuman yang diperoleh dari pencampuran air minum dengan bahan perisa dan gula yang mengandung karbondioksida dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik Dasar:<br> Kadar CO2 tidak lebih dari 5.890 mg/L",
    "Aktif",
  ],
  [
    1401040122,
    "Minuman Buah Berkarbonat",
    "Minuman buah berkarbonat adalah minuman yang terdiri dari satu<br> atau lebih jenis buah, yang ditambahkan karbondioksida. Total sari<br> buah 10% sampai 35% (b/v).<br> <br> Karakteristik Dasar:<br> Kadar CO2 tidak lebih dari 5.890 mg/L",
    "Aktif",
  ],
  [
    1401040123,
    "Minuman Citrus Comminutes (Berkarbonat)",
    "Minuman citrus comminutes adalah minuman ringan yang diperoleh dari proses yang melibatkan kelompok buah citrus utuh.<br> Karakteristik dasar:<br> - Kandungan buah dalam minuman 7% hingga 10% tergantung jenisnya sebelum diencerkan, dan 1,5% hingga 2% untuk minuman yang dikonsumsi tanpa pengenceran<br> - Dapat ditambahkan gula tidak lebih dari 100 g/kg",
    "Aktif",
  ],
  [
    1401040201,
    "Punches/Ades",
    "Punches / ades adalah produk minuman yang diperoleh dari campuran sari buah dengan atau tanpa penambahan perisa.",
    "Aktif",
  ],
  [
    1401040202,
    "Crush",
    "Crush adalah minuman ringan yang mengandung sari buah, bukan untuk minuman citrus comminutes, ditujukan untuk dikonsumsi tanpa diencerkan, termasuk cordial yang dikonsumsi tanpa pengenceran.<br> <br> Karakteristik dasar:<br> Kandungan buah tidak kurang dari 3% dan tidak lebih dari 5% tergantung jenisnya",
    "Aktif",
  ],
  [
    1401040203,
    "Cordials",
    "Cordials adalah minuman yang belum mempunyai status arti yang umum, tetapi dapat diaplikasikan untuk semua jenis squash jeruk yang jernih atau crush.",
    "Tidak Aktif",
  ],
  [
    1401040204,
    "Minuman Sari Buah",
    "Minuman sari buah adalah minuman yang diperoleh dengan mencampur air minum; sari buah atau campuran sari buah yang tidak difermentasi, dengan bagian lain dari satu jenis buah atau lebih, dengan atau tanpa penambahan gula. Total sari buah tidak kurang dari 35% (b/v).",
    "Aktif",
  ],
  [
    1401040205,
    "Minuman Rasa Buah",
    "Minuman berperisa/rasa buah adalah minuman yang terdiri dari satu atau lebih jenis buah, dengan total sari buah kurang dari 10% (b/v)",
    "Aktif",
  ],
  [
    1401040206,
    "Sirup Berperisa",
    "Sirup berperisa adalah produk minuman berupa larutan 65% gula yang berperisa. Dapat ditambahkan bahan pangan lain, susu tidak lebih dari 5% dihitung sebagai susu segar.",
    "Tidak Aktif",
  ],
  [
    1401040207,
    "Sirup Buah",
    "Sirup buah adalah produk yang diperoleh dengan mencampur sirup dan sari buah dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah atau lebih.",
    "Tidak Aktif",
  ],
  [
    1401040208,
    "Sirup Cokelat, Sirup Karamel, Sirup Kopi",
    "",
    "Tidak Aktif",
  ],
  [
    1401040209,
    "Minuman Berperisa...",
    "Minuman berperisa adalah produk minuman yang diperoleh dari pencampuran air minum dengan bahan perisa dan gula dengan atau tanpa penambahan bahan pangan lain melalui proses pemanasan.",
    "Tidak Aktif",
  ],
  [
    1401040210,
    "Squash",
    "Squash adalah minuman yang diperoleh dari campuran sirup atau gula dan sari buah dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah atau lebih dan dalam penggunaannya diencerkan dengan air.",
    "Tidak Aktif",
  ],
  [
    1401040211,
    "Squash Berperisa",
    "Squash berperisa adalah produk yang diperoleh dari proses pencampuran sirup dan bahan penyedap rasa dan perisa dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah-buahan atau lebih dan dalam penggunaannya harus diencerkan terlebih dahulu.",
    "Tidak Aktif",
  ],
  [
    1401040212,
    "Lemonade dan \x{2018}Fruit-Ades\x{2019} Lainnya",
    "Lemonade dan \x{2018}fruit-ades\x{2019} lainnya adalah minuman ringan yang tidak mengikuti kandungan buah didalamnya.",
    "Tidak Aktif",
  ],
  [
    1401040213,
    "Serbuk Minuman Berperisa",
    "Serbuk minuman berperisa adalah produk serbuk minuman yang diperoleh dari campuran tepung, dengan perisa (alami, identik alami, tiruan) dengan atau tanpa pemanis.",
    "Tidak Aktif",
  ],
  [
    1401040214,
    "Serbuk Minuman Rasa Jeruk",
    "Serbuk minuman rasa jeruk adalah produk serbuk minuman yang diperoleh dari campuran tepung gula pasir dengan perisa jeruk (alami, identik alami, tiruan).",
    "Tidak Aktif",
  ],
  [
    1401040215,
    "Minuman Elektrolit Tidak Berkarbonat",
    "Minuman elektrolit tidak berkarbonat adalah minuman formulasi tidak berkarbonasi yang ditujukan untuk menggantikan cairan, karbohidrat, elektrolit dan mineral tubuh dengan cepat. Dapat mengandung kalsium fosfat, kalium fosfat, kalsium sitrat, kalium sitrat, kalium karbonat termasuk kalium bikarbonat, kalium klorida, kalsium klorida, natrium klorida, kalsium laktat, magnesium laktat dan magnesium sulfat.<br> <br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 Kandungan natrium tidak kurang dari 10 mmol/l<br> \xEF\x{201A}\xB7 Kadar gula 50 g/l hingga 100 g/l, gula tersebut merupakan jumlah total dekstrosa, fruktosa, sirup glukosa, maltodekstrin dan sukrosa, dan mengandung fruktosa tidak lebih dari 50 g/l.",
    "Tidak Aktif",
  ],
  [
    1401040216,
    "Minuman Hipotonik Tidak Berkarbonat",
    "Minuman hipotonik tidak berkarbonat adalah minuman ringan tidak berkarbonasi yang mengandung elektrolit, gula, asam sitrat dan mineral-mineral garam.",
    "Tidak Aktif",
  ],
  [
    1401040217,
    "Minuman Isotonik Tidak Berkarbonat",
    "Minuman isotonik tidak berkarbonat adalah minuman ringan tidak berkarbonasi yang mengandung elektrolit, gula, asam sitrat dan mineral-mineral garam.",
    "Tidak Aktif",
  ],
  [
    1401040218,
    "Minuman Hipertonik Tidak Berkarbonat",
    "Minuman hipertonik tidak berkarbonat adalah minuman ringan tidak berkarbonasi yang mengandung elektrolit, gula, asam sitrat dan mineral-mineral garam.",
    "Tidak Aktif",
  ],
  [
    1401040219,
    "Minuman Dasar Elektrolit (Electrolyte Drinks Base) Tidak Berkarbonat",
    "Minuman dasar elektrolit (electrolyte drinks base) tidak berkarbonat adalah minuman formulasi tidak berkarbonasi berbentuk bubuk atau cair yang dikonsumsi dengan penambahan air ditujukan untuk membuat minuman elektrolit.",
    "Tidak Aktif",
  ],
  [1401040220, "Minuman Asam Jawa", "", "Tidak Aktif"],
  [1401040225, "Nata De Coco Dalam Minuman", "", "Tidak Aktif"],
  [
    1401040226,
    "Minuman Air Kelapa",
    "Minuman Air Kelapa",
    "Tidak Aktif",
  ],
  [1401040227, "Minuman Lidah Buaya", "&nbsp;", "Tidak Aktif"],
  [1401040228, "Minuman Nata De Coco", "&nbsp;", "Aktif"],
  [
    1401040229,
    "Minuman Jeli",
    "Minuman jeli adalah minuman yang menggunakan bahan baku berupa hidrokoloid sebagai komponen utama. Produk akhir berupa<br> cairan semi liquid (gel) diperoleh dari proses pencampuran air, hidrokoloid dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Memiliki tekstur/konsistensi gel semi liquid ;<br> \xE2\x{20AC}\xA2 Kandungan hidrokoloid tidak kurang dari 0,1%.",
    "Aktif",
  ],
  [1401040230, "Minuman Madu", "&nbsp;", "Tidak Aktif"],
  [
    1401040231,
    "Minuman Sari Buah (Steril Komersial)",
    "Minuman sari buah adalah minuman yang diperoleh dengan mencampur air minum; sari buah atau campuran sari buah yang tidak difermentasi, dengan bagian lain dari satu jenis buah atau lebih, dengan atau tanpa penambahan gula, karbondioksida",
    "Aktif",
  ],
  [1401040232, "Sirup Madu", "&nbsp;", "Tidak Aktif"],
  [
    1401040233,
    "Minuman Rasa Buah (Steril Komersial)",
    "Minuman rasa buah adalah minuman yang terdiri dari satu atau lebih jenis buah, dengan total sari buah kurang dari 10% (b/v).",
    "Aktif",
  ],
  [1401040234, "Minuman Nata de Coco (Steril)", "&nbsp;", "Aktif"],
  [
    1401040235,
    "Minuman Buah",
    "Minuman buah adalah minuman yang terdiri dari satu atau lebih jenis buah, dengan total sari buah 10% sampai 35% (b/v).",
    "Aktif",
  ],
  [
    1401040236,
    "Minuman Buah (Steril Komersial)",
    "Minuman buah adalah minuman yang terdiri dari satu atau lebih jenis buah, dengan total sari buah 10% sampai 35% (b/v).",
    "Aktif",
  ],
  [
    1401040237,
    "Minuman Asam Jawa (Steril Komersil)",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    1401040238,
    "Minuman Kopi Dalam Kemasan",
    "Minuman kopi dalam kemasan adalah minuman yang dibuat dari kopi bubuk, gula dan air minum melalui pemanasan, kandungan kafein tidak kurang dari 20 mg/kg dengan atau tanpa penambahan bahan pangan lain, dan dikemas secara kedap (hermetis).",
    "Tidak Aktif",
  ],
  [
    1401040239,
    "Minuman Teh Dalam Kemasan",
    "Minuman teh adalah minuman hasil seduhan daun teh atau ekstrak teh dalam air minuman dengan penambahan gula dan dikemas secara kedap (hermetis).<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Bau dan rasa khas teh<br> \xE2\x{20AC}\xA2 Mengandung kafein dan tanin",
    "Aktif",
  ],
  [
    1401040240,
    "Minuman Teh dalam Kemasan (Steril Komersial)",
    "Minuman teh dalam kemasan (Steril Komersial)",
    "Aktif",
  ],
  [
    1401040241,
    "Squash Berperisa (Steril)",
    "Squash berperisa adalah produk yang diperoleh dari proses pencampuran sirup dan bahan penyedap rasa dan perisa dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah-buahan atau lebih dan dalam penggunaannya harus diencerkan terlebih dahulu.",
    "Tidak Aktif",
  ],
  [
    1401040242,
    "Serbuk Minuman Isotonik Tidak Berkarbonasi",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    1401040243,
    "Minuman Kopi",
    "Minuman kopi adalah minuman yang dibuat dari kopi bubuk, kopi instan, dan/atau ekstrak kopi, air minum, dengan atau tanpa penambahan gula dan bahan pangan lain.<br> <br> Karakteristik dasar :<br> Kadar kopi tidak kurang dari 4% (dihitung dari basis berat kering).",
    "Aktif",
  ],
  [
    1401040244,
    "Minuman Teh",
    "Minuman teh adalah minuman hasil seduhan daun teh atau ekstrak teh dalam air minuman dengan penambahan gula dan dikemas secara kedap (hermetis)",
    "Tidak Aktif",
  ],
  [
    1401040245,
    "Kapucino",
    "Kapucino adalah minuman yang dibuat dari espresso dan susu, yang merupakan minuman khas Italia.",
    "Aktif",
  ],
  [
    1401040246,
    "Minuman Berperisa Tidak Berkarbonat",
    "Minuman berperisa adalah produk minuman yang diperoleh dari pencampuran air minum dengan bahan perisa dan gula dengan atau tanpa penambahan bahan pangan lain melalui proses pemanasan.<br> Minuman berperisa ini tidak ditambahkan karbondioksida (Tidak Berkarbonat)",
    "Aktif",
  ],
  [
    1401040247,
    "Minuman Kopi (Steril Komersial)",
    "Minuman kopi (steril komersial) adalah minuman yang dibuat dari kopi bubuk, gula dan air minum melalui pemanasan, kandungan kafein tidak kurang dari 250 mg/kg dengan atau tanpa penambahan bahan pangan lain, dan dikemas secara kedap (hermetis) dan steril komersial.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Warna, aroma dan rasa normal<br> \xE2\x{20AC}\xA2 Kadar kopi minimum 4% (dihitung dari basis berat kering)",
    "Aktif",
  ],
  [
    1401040248,
    "Minuman Rasa Susu (Cair) (Tidak Berkarbonat)",
    "Minuman Rasa Susu (Cair) adalah minuman rasa susu berbentuk cair<br> <br> Karakteristik dasar:<br> Mengandung susu kurang dari 10% dihitung sebagai susu segar<br> Kadar lemak susu kurang dari 0.3%",
    "Aktif",
  ],
  [
    1401040249,
    "Minuman Citrus Comminutes (Tidak Berkarbonat)",
    "Minuman citrus comminutes adalah minuman ringan yang diperoleh<br> dari proses yang melibatkan kelompok buah citrus utuh.<br> Karakteristik dasar:<br> - Kandungan buah dalam minuman 7% hingga 10% tergantung<br> jenisnya sebelum diencerkan, dan 1,5% hingga 2% untuk<br> minuman yang dikonsumsi tanpa pengenceran<br> - Dapat ditambahkan gula tidak lebih dari 100 g/kg<br>",
    "Aktif",
  ],
  [
    1401040250,
    "Minuman Rasa Susu (Serbuk) (Tidak Berkarbonat)",
    "Minuman Rasa Susu (Serbuk) adalah minuman rasa susu berbentuk serbuk.<br> <br> Karakteristik dasar:<br> Mengandung susu kurang dari 10% dihitung sebagai susu segar;<br> Kadar lemak susu kurang dari 0.3%.",
    "Tidak Aktif",
  ],
  [1401040251, "Minuman Fermentasi", "-", "Tidak Aktif"],
  [1401040252, "Minuman Ringan (Plain)", "", "Aktif"],
  [
    1401040301,
    "Konsentrat Lemonade Beku",
    "Konsentrat lemonade beku adalah produk beku disiapkan dari satu atau dua sari buah jeruk lemon dengan satu atau lebih pemanis nutritif.",
    "Aktif",
  ],
  [1401040302, "Konsentrat untuk Minuman", "&nbsp;", "Tidak Aktif"],
  [
    1401040303,
    "Minuman Konsentrat Rasa ...",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    1401040304,
    "Sirup Encer Berperisa",
    "Sirup encer berperisa adalah produk minuman berupa larutan gula minimal 55% dan tidak lebih dari 65% yang berperisa. Dapat ditambahkan bahan pangan lain. Dalam penggunaanya diencerkan dengan air.",
    "Aktif",
  ],
  [
    1401040305,
    "Minuman Serbuk Berperisa (Berkarbonat)",
    "Serbuk minuman/minuman serbuk berperisa (berkarbonat) adalah produk minuman dalam bentuk bubuk yang diperoleh dari campuran bahan pangan, dengan perisa (alami, identik alami, tiruan) dengan atau tanpa pemanis, berkarbonat",
    "Aktif",
  ],
  [
    1401040306,
    "Minuman Serbuk Berperisa (Tidak Berkarbonat)",
    "Serbuk minuman/minuman serbuk berperisa (tidak berkarbonat) adalah produk minuman dalam bentuk bubuk yang diperoleh dari campuran bahan pangan, dengan perisa (alami, identik alami, tiruan) dengan atau tanpa pemanis, tidak berkarbonat",
    "Aktif",
  ],
  [
    1401040307,
    "Squash",
    "Squash adalah minuman yang diperoleh dari campuran sirup atau gula dan sari buah dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah atau lebih dan dalam penggunaannya diencerkan dengan air.<br>",
    "Aktif",
  ],
  [
    1401040308,
    "Squash Berperisa/Rasa",
    "Squash berperisa/rasa adalah produk yang diperoleh dari proses pencampuran sirup atau gula dan perisa dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah-buahan atau lebih dan dalam penggunaannya harus diencerkan terlebih dahulu.",
    "Aktif",
  ],
  [
    1401040309,
    "Sirup Buah",
    "Sirup buah adalah produk yang diperoleh dengan mencampur sirup dan sari buah dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah atau lebih.",
    "Aktif",
  ],
  [
    1401040310,
    "Sirup Berperisa",
    "Sirup berperisa adalah produk minuman berupa larutan yang berperisa dengan kadar gula tidak kurang dari 65%. Dapat ditambahkan bahan pangan lain. Dalam penggunaannya diencerkan dengan air.",
    "Aktif",
  ],
  [
    1401040311,
    "Sirup Teh",
    "Sirup teh adalah produk minuman yang mengandung gula dan ekstrak teh (Camellia sinensis) dengan atau tanpa penambahan bahan pangan lain. Dalam penggunaannya diencerkan dengan air.",
    "Aktif",
  ],
  [
    1401040312,
    "Sirup Kopi",
    "Sirup kopi adalah produk minuman yang mengandung gula dan ekstrak kopi dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    1401040313,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Serbuk)",
    "Minuman dasar elektrolit berkarbonat (electrolyte drinks base) (serbuk) adalah minuman formulasi berbentuk serbuk yang dikonsumsi dengan penambahan air ditujukan untuk membuat minuman elektrolit berkarbonat.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Saat minuman elektrolit dibuat maka kadar natrium minuman tersebut tidak kurang dari 10 mmol/l;<br> \xE2\x{20AC}\xA2 Kadar gula 50 g/l hingga 100 g/l, dan merupakan jumlah total dekstrosa, fruktosa, sirup glukosa, maltodekstrin dan sukrosa, dan kadar fruktosa tidak lebih dari 50 g/l.<br> \xE2\x{20AC}\xA2 Dapat mengandung kalsium fosfat, kalium fosfat, kalsium sitrat, kalium sitrat, kalium karbonat termasuk kalium bikarbonat, kalium klorida, kalsium klorida, natrium klorida, kalsium laktat, magnesium laktat dan magnesium sulfat.",
    "Tidak Aktif",
  ],
  [
    1401040314,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Cair)",
    "Minuman dasar elektrolit berkarbonat (electrolyte drinks base)(cair) adalah minuman formulasi berbentuk cair yang dikonsumsi dengan penambahan air ditujukan untuk membuat minuman elektrolit berkarbonat.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Saat minuman elektrolit dibuat maka kadar natrium minuman tersebut tidak kurang dari 10 mmol/l;<br> \xE2\x{20AC}\xA2 Kadar gula 50 g/l hingga 100 g/l, dan merupakan jumlah total dekstrosa, fruktosa, sirup glukosa, maltodekstrin dan sukrosa, dan kadar fruktosa tidak lebih dari 50 g/l.<br> \xE2\x{20AC}\xA2 Dapat mengandung kalsium fosfat, kalium fosfat, kalsium sitrat, kalium sitrat, kalium karbonat termasuk kalium bikarbonat, kalium klorida, kalsium klorida, natrium klorida, kalsium laktat, magnesium laktat dan magnesium sulfat.",
    "Tidak Aktif",
  ],
  [
    1401040315,
    "Squash Berperisa (Steril)",
    "Squash berperisa (Steril) adalah produk steril yang diperoleh dari proses pencampuran sirup atau gula dan perisa dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah-buahan atau lebih dan dalam penggunaannya harus diencerkan terlebih dahulu.",
    "Aktif",
  ],
  [
    1401040316,
    "Konsentrat Minuman Cuka (Konsentrat Minuman Vinegar)",
    "Definisi : Produk ini dibuat dari vinegar (cuka fermentasi) yang diencerkan dengan air atau bahan pangan lain. Produk harus diencerkan sebelum dikonsumsi.<br> Karakteristik Dasar :<br> Kadar asam total dihitung sebagai asam asetat tidak lebih dari 3% (b/v).<br>",
    "Aktif",
  ],
  [
    1401040317,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Serbuk)",
    "Minuman dasar elektrolit tidak berkarbonat (electrolyte drinks base) (serbuk) adalah minuman formulasi berbentuk serbuk yang dikonsumsi dengan penambahan air ditujukan untuk membuat minuman elektrolit tidak berkarbonat.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Saat minuman elektrolit dibuat maka kadar natrium minuman tersebut tidak kurang dari 10 mmol/l;<br> \xE2\x{20AC}\xA2 Kadar gula 50 g/l hingga 100 g/l, dan merupakan jumlah total dekstrosa, fruktosa, sirup glukosa, maltodekstrin dan sukrosa, dan kadar fruktosa tidak lebih dari 50 g/l.<br> \xE2\x{20AC}\xA2 Dapat mengandung kalsium fosfat, kalium fosfat, kalsium sitrat, kalium sitrat, kalium karbonat termasuk kalium bikarbonat, kalium klorida, kalsium klorida, natrium klorida, kalsium laktat, magnesium laktat dan magnesium sulfat.",
    "Tidak Aktif",
  ],
  [
    1401040318,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Cair)",
    "Minuman dasar elektrolit tidak berkarbonat (electrolyte drinks base) (cair) adalah minuman formulasi berbentuk cair yang dikonsumsi dengan penambahan air ditujukan untuk membuat minuman elektrolit tidak berkarbonat.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Saat minuman elektrolit dibuat maka kadar natrium minuman tersebut tidak kurang dari 10 mmol/l;<br> \xE2\x{20AC}\xA2 Kadar gula 50 g/l hingga 100 g/l, dan merupakan jumlah total dekstrosa, fruktosa, sirup glukosa, maltodekstrin dan sukrosa, dan kadar fruktosa tidak lebih dari 50 g/l.<br> \xE2\x{20AC}\xA2 Dapat mengandung kalsium fosfat, kalium fosfat, kalsium sitrat, kalium sitrat, kalium karbonat termasuk kalium bikarbonat, kalium klorida, kalsium klorida, natrium klorida, kalsium laktat, magnesium laktat dan magnesium sulfat.",
    "Tidak Aktif",
  ],
  [
    1401040319,
    "Konsentrat Minuman Rasa/Berperisa (Steril Komersial)",
    "Konsentrat Minuman Rasa/Berperisa (Steril Komersial)",
    "Tidak Aktif",
  ],
  [
    1401040320,
    "Konsentrat Minuman Rasa/Berperisa",
    "Konsentrat Minuman Rasa/Berperisa",
    "Aktif",
  ],
  [
    "140104A1",
    "Minuman Rasa Susu (Cair)",
    "Minuman Rasa Susu (Cair) adalah minuman rasa susu berbentuk cair<br> <br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 Mengandung susu kurang dari 10% dihitung sebagai susu segar;<br> \xEF\x{201A}\xB7 Kadar lemak susu kurang dari 0.3%.",
    "Tidak Aktif",
  ],
  [
    "140104A2",
    "Minuman Berperisa",
    "Minuman berperisa adalah produk minuman yang diperoleh dari pencampuran air minum dengan bahan perisa dan gula dengan atau tanpa penambahan bahan pangan lain melalui proses pemanasan.",
    "Tidak Aktif",
  ],
  [
    "140104A3",
    "Minuman Citrus Comminutes",
    "Minuman citrus comminutes adalah minuman ringan yang diperoleh dari proses yang melibatkan kelompok buah citrus utuh.",
    "Aktif",
  ],
  [
    "140104A4",
    "Minuman Rasa Susu (Serbuk)",
    "Minuman Rasa Susu (Serbuk) adalah minuman rasa susu berbentuk serbuk.<br> <br> Karakteristik dasar:<br> \xEF\x{201A}\xB7 Mengandung susu kurang dari 10% dihitung sebagai susu segar;<br> \xEF\x{201A}\xB7 Kadar lemak susu kurang dari 0.3%.",
    "Tidak Aktif",
  ],
  [
    140105,
    "Kopi, Kopi Substitusi, Teh, Seduhan Herbal, dan Minuman Biji-Bijian dan Sereal Panas, kecuali Cokelat",
    "",
    "Aktif",
  ],
  [
    14010501,
    "Teh Hitam",
    "Teh hitam adalah teh kering hasil pengolahan pucuk dan daun muda termasuk tangkainya dari tanaman teh (Camellia sinensis L.) melalui proses fermentasi.",
    "Aktif",
  ],
  [
    14010502,
    "Teh Hijau",
    "Teh hijau adalah pucuk dan daun muda tanaman teh Camellia sinensis yang telah diolah tanpa melalui proses fermentasi.",
    "Aktif",
  ],
  [
    14010503,
    "Teh Putih",
    "Teh putih adalah produk teh yang dibuat dari daun teh yang memiliki buluh-buluh putih kecil pada daun mudanya.",
    "Aktif",
  ],
  [
    14010504,
    "Teh Wangi",
    "Teh wangi adalah teh yang telah mengalami pengolahan lebih lanjut, ditambah dengan bunga melati (Jasminum sambac), bunga melati gambir (Jasminum officinale), bunga culan (Aglaia odorata), atau bagian tanaman lain dalam bentuk bahan alaminya atau ekstraknya.<br> Kadar air tidak lebih dari 8%.",
    "Aktif",
  ],
  [
    14010505,
    "Teh Wangi Tradisional",
    "Teh wangi tradisional adalah teh hijau yang telah mengalami pengolahan lebih lanjut, pewangian dengan menggunakan melati (Jasminum sambac), bunga melati gambir (Officinale var grandiflorum), atau bunga culan (Aglaia odorata).",
    "Tidak Aktif",
  ],
  [
    14010506,
    "Teh Olong atau Teh Semi Fermentasi",
    "Teh olong atau teh semi fermentasi adalah teh yang difermentasi dengan cepat, sesudah dan sebelum penggulungan. Warna daunnya setengah coklat.",
    "Aktif",
  ],
  [
    14010507,
    "Teh Hijau Bubuk",
    "Teh hijau bubuk adalah bubuk kering dihasilkan dari pengolahan pucuk dan daun muda tanaman Camellia sinensis tanpa proses fermentasi.<br> Kadar air tidak lebih dari 8%.",
    "Aktif",
  ],
  [
    14010508,
    "Teh Kering",
    "Teh kering adalah berbagai jenis teh kering (teh hitam, teh hijau, teh olong, teh wangi melati dan teh beraroma) yang dikemas dengan berat tertentu dan siap seduh.<br> Kadar air tidak lebih dari 8%.",
    "Aktif",
  ],
  [
    14010509,
    "Teh Hitam Celup",
    "Teh hitam celup adalah teh kering hasil pengolahan pucuk daun muda dan daun muda dari tanaman teh (Camellia sinensis L.) yang telah melalui proses oksidasi enzimatis dan dikemas dalam kantong dengan atau tanpa tali maupun perekat untuk dicelup dengan atau tanpa bahan pangan lain.<br> Kadar air tidak lebih dari 10%.",
    "Aktif",
  ],
  [
    14010510,
    "Teh Wangi Celup",
    "Teh wangi celup adalah teh wangi yang dikemas dalam kantong khusus untuk dicelup.",
    "Aktif",
  ],
  [
    14010511,
    "Teh Hijau Celup",
    "Teh hijau celup adalah teh kering hasil pengolahan pucuk daun muda dan daun muda dari tanaman teh (Camellia sinensis L.) tanpa melalui proses oksidasi enzimatis dan dikemas dalam kantong dengan atau tanpa tali maupun perekat untuk dicelup dengan atau tanpa bahan pangan lain.",
    "Aktif",
  ],
  [
    14010512,
    "Minuman Teh Dalam Kemasan",
    "Minuman teh dalam kemasan adalah minuman hasil seduhan daun teh atau ekstrak teh dalam air minuman dengan penambahan gula dan dikemas secara kedap (hermetis).",
    "Tidak Aktif",
  ],
  [
    14010513,
    "Teh Instan",
    "Teh instan adalah teh berbentuk serbuk yang mudah larut dalam air diperoleh melalui proses ekstraksi teh (Camellia sinensis L.), penyaringan, pemekatan dan pengeringan dengan atau tanpa penambahan bahan pangan lain, dan dikemas secara kedap.",
    "Aktif",
  ],
  [
    14010514,
    "Konsentrat Minuman Teh",
    "Produk yang dibuat dari ekstrak teh pekat atau ekstrak teh yang dipekatkan dengan atau tanpa penambahan bahan pangan lain. Cara mengkonsumsinya adalah cukup ditambahkan air.",
    "Aktif",
  ],
  [
    14010515,
    "Biji Kopi yang Disangrai atau Roasting",
    "Biji kopi adalah biji dari tanaman Coffea sp dalam bentuk utuh dan sudah di sangrai.<br> Kadar air tidak lebih dari 12%",
    "Aktif",
  ],
  [
    14010516,
    "Kopi Bubuk",
    "Kopi bubuk adalah biji kopi yang disangrai kemudian digiling, kandungan kafein anhidrat tidak lebih dari 2.5%.<br> <br> Karakteristik dasar :<br> Kadar air tidak lebih dari 7%.",
    "Aktif",
  ],
  [
    14010517,
    "Kopi Instan",
    "Kopi instan adalah produk kopi berbentuk serbuk atau granula atau flake yang diperoleh dari proses pemisahan biji kopi tanpa dicamput dengan bahan lain, disangrai, digiling, diekstrak dengan air, dikeringkan dengan proses spray drying (dengan atau tanpa aglomerasi) atau freeze drying atau fluidized bed drying menjadi produk yang mudah larut dalam air.",
    "Aktif",
  ],
  [
    14010518,
    "Kopi Campur",
    "Kopi campur adalah produk kopi giling dicampur dengan gandum, jagung atau wijen, margarin atau gula. Kadar kopi tidak kurang dari 50%",
    "Aktif",
  ],
  [
    14010519,
    "Minuman Kopi Dalam Kemasan",
    "Minuman kopi dalam kemasan adalah minuman yang dibuat dari kopi bubuk, gula dan air minum melalui pemanasan, kandungan kafein tidak kurang dari 20 mg/kg dengan atau tanpa penambahan bahan pangan lain, dan dikemas secara kedap (hermetis).",
    "Tidak Aktif",
  ],
  [
    14010520,
    "Konsentrat Minuman Kopi",
    "Konsentrat minuman kopi adalah produk kopi yang diperoleh melalui proses penyeduhan kopi bubuk, kopi instan, dan/atau ekstrak kopi, dilanjutkan dengan pemekatan, dengan atau tanpa penambahan bahan pangan lain. Cara mengonsumsinya adalah diencerkan dengan penambahan air. Produk ini dapat disimpan dan didistribusikan dalam bentuk beku atau tidak beku.",
    "Aktif",
  ],
  [
    14010521,
    "Minuman Botanikal/Minuman Rempah (Cair)",
    "Minuman botanikal/minuman rempah adalah produk minuman yang dibuat dari bagian tanaman (contoh daun, bunga, biji, akar, rimpang, batang) atau ekstraknya atau cairan yang berasal dari tanaman (contoh nira, air kelapa), dengan atau tanpa penambahan bahan pangan lain. Produk dapat berbentuk padat atau cair.<br> Nama jenis produk disesuaikan dengan bahan baku yang digunakan, misalnya minuman chrysanthemum, minuman rosela, serbuk minuman jahe, serbuk bandrek, serbuk bajigur, nira kelapa.<br> <br> Karakteristik dasar :<br> Jika mengandung kinina, kadar kinina tidak lebih dari 40 mg/kg",
    "Aktif",
  ],
  [
    14010522,
    "Serbuk Minuman Tradisional",
    "Serbuk minuman tradisional adalah produk minuman berbentuk serbuk atau granula yang diperoleh dari campuran gula dan rempah-rempah dengan atau tanpa penambahan bahan pangan lain.",
    "Tidak Aktif",
  ],
  [
    14010523,
    "Serbuk Minuman Jahe",
    "Serbuk minuman jahe adalah produk minuman berbentuk serbuk atau granula yang diperoleh dari campuran gula dan jahe dengan atau tanpa penambahan bahan pangan lain.",
    "Tidak Aktif",
  ],
  [
    14010524,
    "Serbuk Sekoteng",
    "Serbuk sekoteng adalah produk minuman berbentuk serbuk atau granula yang diperoleh dari campuran gula dan rempah dengan penambahan bahan pangan lain (biji delima, buah kolang-kaling, kacang hijau, kacang tanah, roti tawar).",
    "Tidak Aktif",
  ],
  [
    14010525,
    "Serbuk Bandrek/Serbat/Sorbat",
    "Serbuk bandrek / serbat/ sorbat adalah minuman berbentuk serbuk atau granula yang dibuat dari campuran gula atau gula merah dan jahe dengan penambahan bahan pangan lain (sereh, merica dsb).",
    "Tidak Aktif",
  ],
  [
    14010529,
    "Minuman Sari Kacang Hijau",
    "Minuman sari kacang hijau adalah minuman yang diperoleh dari sari kacang hijau dengan penambahan air, gula dan bahan pangan lainnya, melalui pemanasan dan dikemas secara kedap (hermetis).",
    "Aktif",
  ],
  [
    14010531,
    "Serbuk Minuman",
    "Serbuk minuman adalah produk minuman yang diperoleh dari campuran satu atau lebih bahan pangan yang berbentuk serbuk.",
    "Tidak Aktif",
  ],
  [
    14010532,
    "Minuman Serbuk Kopi",
    "Minuman serbuk kopi adalah produk berbentuk bubuk yang terdiri dari campuran kopi dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Kadar kafein tidak kurang dari 1500 mg/kg;<br> \xE2\x{20AC}\xA2 Kandungan kopi tidak kurang dari 4% (dihitung dari basis berat<br> kering).",
    "Aktif",
  ],
  [
    14010533,
    "Seduhan Herbal (Daun Pepermint, dll)/Seduhan Biji-bijian",
    "",
    "Tidak Aktif",
  ],
  [14010535, "Minuman Bandrek", "&nbsp;", "Tidak Aktif"],
  [14010536, "Minuman Sekoteng", "&nbsp;", "Tidak Aktif"],
  [
    14010537,
    "Minuman Serbuk",
    "serbuk minuman adalah produk minuman yang diperoleh dari campuran satu atau lebih bahan pangan yang berbentuk serbuk. (KP)",
    "Tidak Aktif",
  ],
  [14010538, "Minuman Jahe", "&nbsp;", "Tidak Aktif"],
  [14010539, "Minuman Rosella", "&nbsp;", "Tidak Aktif"],
  [14010540, "Minuman Cincau", "&nbsp;", "Tidak Aktif"],
  [
    14010541,
    "Minuman Cincau (Steril Komersial)",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    14010542,
    "Minuman ... (Steril Komersial)",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [14010543, "Minuman Krisanthemum", "&nbsp;", "Tidak Aktif"],
  [
    14010544,
    "Kopi Dekafein",
    "Kopi bubuk dekafein adalah kopi yang sebagian besar kafeinnya telah dihilangkan. Mengandung tidak lebih dari 1 g/kg kafein anhidrat dihitung terhadap bobot kering",
    "Aktif",
  ],
  [
    14010545,
    "Kopi Instan Dekafein",
    "Kopi instan dekafein adalah kopi instan yang sebagian besar telah dikurangi kandungan kafeinnya melalui proses ekstraksi tertentu.",
    "Aktif",
  ],
  [
    14010546,
    "Minuman Teh dalam Kemasan Tetrapak",
    "minuman teh dalam kemasan tetrapak adalah minuman hasil seduhan daun teh atau ekstrak teh dalam air minuman dengan penambahan gula dan didalam kemasan tetrapak<br>",
    "Tidak Aktif",
  ],
  [
    14010547,
    "Kopi, Kopi Substitusi, Teh, Seduhan Herbal, dan Minuman Biji-Bijian dan Sereal Panas, kecuali Cokelat",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    14010548,
    "Minuman botanikal/minuman rempah (Steril Komersial)",
    "Minuman botanikal/minuman rempah adalah produk minuman yang dibuat dari bagian tanaman (contoh daun, bunga, biji, akar, rimpang, batang) atau ekstraknya atau cairan yang berasal dari tanaman (contoh nira, air kelapa), dengan atau tanpa penambahan bahan pangan lain. Produk dapat berbentuk padat atau cair.<br> Nama jenis produk disesuaikan dengan bahan baku yang digunakan, misalnya minuman chrysanthemum, minuman rosela, serbuk minuman jahe, serbuk bandrek, serbuk bajigur, nira kelapa.<br> <br> Karakteristik dasar :<br> Jika mengandung kinina, kadar kinina tidak lebih dari 40 mg/kg",
    "Tidak Aktif",
  ],
  [
    14010549,
    "Minuman Sari Kacang Hijau (Kemasan Tetrapack)",
    "&nbsp;",
    "Aktif",
  ],
  [
    14010550,
    "Kopi Celup",
    "Kopi celup adalah kopi bubuk hasil dari biji kopi yang disangraikemudian digiling, dengan atau tanpa penambahan bahan laindalam kadar tertentu yang tidak membahayakan kesehatan, dan dikemas dalam kantong khusus untuk dicelup.<br> Karakteristik dasar:<br> Bau, rasa, dan warna normal.<br> Mutu I: mengandung sari kopi 20-36% b/b, sedangkan mutu II : mengandung sari kopi tidak lebih dari 60% b/b.",
    "Aktif",
  ],
  [
    14010551,
    "Minuman Tradisional (Cair)",
    "Minuman Tradisional (Cair) adalah produk minuman berbentuk cair yang diperoleh dari campuran gula dan rempah-rempah dengan atau tanpa penambahan bahan pangan lain<br> Karakteristik dasar:<br> Aroma dan rasa normal khas rempah-rempah.<br>",
    "Tidak Aktif",
  ],
  [
    14010553,
    "Minuman Serbuk Kopi Susu",
    "Minuman serbuk kopi susu adalah produk berbentuk bubuk, yang terdiri dari campuran kopi bubuk dan atau kopi instan, susu, dengan atau tanpa penambahan bahan pangan lain dan dikemas secara kedap.<br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Kadar kafein tidak kurang dari 1500 mg/kg<br> \xE2\x{20AC}\xA2 Kadar protein (N x 6,38) tidak kurang dari 2,0 % (b/b)",
    "Aktif",
  ],
  [
    14010554,
    "Minuman Serbuk Kopi Krimer",
    "Minuman serbuk kopi krimer adalah produk berbentuk bubuk, yang terdiri dari campuran kopi bubuk dan atau kopi instan, krimer, dengan atau tanpa penambahan bahan pangan lain dan dikemas secara kedap.<br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Kadar kafein tidak kurang dari 1500 mg/kg;<br> \xE2\x{20AC}\xA2 Kadar lemak tidak kurang dari 6,0 % (b/b).",
    "Aktif",
  ],
  [
    14010555,
    "Minuman Serbuk Kopi Gula",
    "Minuman serbuk kopi gula adalah produk minuman berbentuk serbuk yang diperoleh dari campuran kopi dan gula dengan atau tanpa penambahan pangan lain.<br> \xEF\x{201A}\xB7 Kadar kafein 1500 \xE2\x{20AC}\x{201C} 6000 mg/kg<br> \xEF\x{201A}\xB7 Kandungan kopi minimum 4% (dihitung dari basis berat kering)",
    "Tidak Aktif",
  ],
  [
    14010556,
    "Teh Instan Dekafein",
    "Teh instan dekafein adalah teh instan yang sebagian besar kafeinnya telah dihilangkan. Mengandung tidak lebih dari 4 g/kg kafein anhidrat dihitung terhadap bobot kering",
    "Aktif",
  ],
  [
    14010557,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Serbuk)",
    "Minuman berkafein formulasi (formulated caffeinated beverages) adalah minuman berperisa tidak beralkohol dalam bentuk serbuk yang mengandung kafein, dapat mengandung karbohidrat, asam amino, vitamin dan zat lain, termasuk bahan pangan lain.<br> Karakteristik dasar: Kadar kafein 145 mg/l hingga 320 mg/l.",
    "Aktif",
  ],
  [
    14010558,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Cair)",
    "Minuman berkafein formulasi (formulated caffeinated beverages) adalah minuman berperisa tidak beralkohol berbasis air yang mengandung kafein, dapat mengandung karbohidrat, asam amino, vitamin dan zat lain, termasuk bahan pangan lain.<br> Karakteristik dasar: Kadar kafein 145 mg/l hingga 320 mg/l.",
    "Aktif",
  ],
  [
    14010559,
    "Minuman botanikal/minuman rempah (Serbuk)",
    "Minuman botanikal/minuman rempah adalah produk minuman yang dibuat dari bagian tanaman (contoh daun, bunga, biji, akar, rimpang, batang) atau ekstraknya atau cairan yang berasal dari tanaman (contoh nira, air kelapa), dengan atau tanpa penambahan bahan pangan lain. Produk dapat berbentuk padat atau cair.<br> Nama jenis produk disesuaikan dengan bahan baku yang digunakan, misalnya minuman chrysanthemum, minuman rosela, serbuk minuman jahe, serbuk bandrek, serbuk bajigur, nira kelapa.<br> <br> Karakteristik dasar :<br> Jika mengandung kinina, kadar kinina tidak lebih dari 40 mg/kg",
    "Aktif",
  ],
  [
    14010560,
    "Minuman botanikal/minuman rempah (Seduhan)",
    "Minuman botanikal/minuman rempah adalah produk minuman yang dibuat dari bagian tanaman (contoh daun, bunga, biji, akar, rimpang, batang) atau ekstraknya atau cairan yang berasal dari tanaman (contoh nira, air kelapa), dengan atau tanpa penambahan bahan pangan lain. Produk dapat berbentuk padat atau cair.<br> Nama jenis produk disesuaikan dengan bahan baku yang digunakan, misalnya minuman chrysanthemum, minuman rosela, serbuk minuman jahe, serbuk bandrek, serbuk bajigur, nira kelapa.<br> <br> Karakteristik dasar :<br> Jika mengandung kinina, kadar kinina tidak lebih dari 40 mg/kg",
    "Aktif",
  ],
  [
    14010561,
    "Minuman Tradisional (Serbuk)",
    "Minuman Tradisional (Serbuk) adalah produk minuman berbentuk serbuk atau granula yang diperoleh dari campuran gula dan rempah-rempah dengan atau tanpa penambahan bahan pangan lain<br> Karakteristik dasar:<br> Aroma dan rasa normal khas rempah-rempah.",
    "Tidak Aktif",
  ],
  [
    14010562,
    "Minuman Tradisional (Seduhan)",
    "Minuman Tradisional (Seduhan) adalah produk minuman berbentuk seduhan yang diperoleh dari campuran gula dan rempah-rempah dengan atau tanpa penambahan bahan pangan lain<br> Karakteristik dasar:<br> Aroma dan rasa normal khas rempah-rempah.",
    "Tidak Aktif",
  ],
  [
    14010563,
    "Minuman Tradisional (Steril Komersial)",
    "Minuman Tradisional (Steril Komersial) adalah produk minuman berbentuk cair yang diproses secara steril komersial, yang diperoleh dari campuran gula dan rempah-rempah dengan atau tanpa penambahan bahan pangan lain<br> Karakteristik dasar:<br> Aroma dan rasa normal khas rempah-rempah.",
    "Tidak Aktif",
  ],
  [14010564, "Serealia Celup", "-", "Aktif"],
  [14010565, "Minuman Serealia", "-", "Aktif"],
  [
    14010566,
    "Minuman Asam Jawa",
    "Pindahan kategori pangan 1401040220",
    "Aktif",
  ],
  [
    14010567,
    "Minuman Serbuk Teh",
    "Minuman serbuk teh adalah produk minuman berbentuk serbuk yang dibuat dari teh bubuk, teh instan, dan/atau ekstrak teh, dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    14010569,
    "Serbuk Sekoteng",
    "Serbuk sekoteng adalah produk minuman berbentuk serbuk atau granula yang diperoleh dari campuran gula dan rempah dengan penambahan bahan pangan lain (biji delima, buah kolang-kaling, kacang hijau, kacang tanah, roti tawar).",
    "Aktif",
  ],
  [
    14010571,
    "Serbuk Minuman Kacang Almond/Serbuk Minuman Sari Almond",
    "-",
    "Aktif",
  ],
  [
    14010572,
    "Minuman Serbuk Biji Salak",
    "Minuman Serbuk Biji Salak adalah produk berupa serbuk yang diperoleh dari biji salak melalui proses pengeringan, pemanasan dan/atau penyangraian, dan penggilingan. Dapat ditambahkan bahan pangan lain.",
    "Aktif",
  ],
  [
    14020101,
    "Bir",
    "Bir adalah minuman mengandung etanol sebagai hasil proses fermentasi khamir (yeast) terhadap bahan baku utama malt, hops (humulus lupulus) dan air yang memberikan aroma, rasa, dan sifat khas bir dapat ditambahkan bahan pangan lain seperti: beras, jagung, gula, tapioka, barley, barley yang disangrai. Malt adalah barley (Hordeum vulgare), gandum (Triticum sp. ), atau rye (Secale cereale) yang telah melalui proses pengecambahan/germinasi.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 0,5% hingga 8%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020102,
    "Bir Hitam (Stout)",
    "Bir hitam (stout) adalah minuman hasil fermentasi kamir yang mengapung darimalt dan biji barley (Hordeum vulgare) yang disangrai dan ditambahkan hops (Lupuli glandulae) dengan aroma hops yang kuat,berwarna hitam kecoklatan, dengan atau tanpa bahan pangan lain.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 2% hingga 8%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020103,
    "Ale",
    "Ale adalah minuman hasil fermentasi kamir dari gilingan malt atau kecambah barley dan hops, aromanya lebih kuat dan rasanya lebih pahit daripada bir.",
    "Aktif",
  ],
  [
    14020104,
    "Malt Liqueur",
    "Malt liqueur adalah bir dengan kadar etanol 5% hingga 9%.",
    "Tidak Aktif",
  ],
  [
    14020201,
    "Cider atau Anggur Apel",
    "Cider atau anggur apel adalah minuman hasil fermentasi lumatan buah apel dan atau produk yang berasal dari buah apel (sari buah apel, konsentrat apel), dengan kadar etanol tidak lebih dari 8,5%.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak lebih dari 8,5%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020202,
    "Perry",
    "Perry adalah minuman yang dibuat melalui fermentasi sari buah pir/pear atau campuran sari buah pir/pear dan apel dimana jumlah sari buah apel tidak lebih dari 25% v/v dari total jumlah sari buah, dengan kadar etanol tidak kurang dari 8,5%.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 8,5%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    140203,
    "Anggur (Grape Wine)",
    "Anggur (Grape Wine) Anggur (Grape wine) adalah minuman beralkohol hasil peragian sari buah anggur Vitis sp.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 7%-24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020301,
    "Still Grape Wine",
    "Still Grape Wine<br> Still grape wine (putih/white, merah/red, merah jambu/ros\xC3\xA9 atau blush, dry atau sweet) adalah anggur dengan kandungan karbondioksida tidak lebih dari 0,4 g/100 ml pada suhu 20\xC2\xB0C.<br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 7%-24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br> \xE2\x{20AC}\xA2 Kadar karbondioksida tidak lebih dari 0,4 g/100 ml pada suhu 20\xC2\xB0C<br> <br> catatan :<br> Kategori pangan ini sudah digantikan (sesuai jenisnya) :<br> - 1402030101 Still Grape Wine Merah / Anggur Merah (Red Wine)<br> - 1402030102 Still Grape Wine Putih / Anggur Putih (White Wine)<br> - 1402030104 Still Grape Wine Merah Jambu / Anggur Merah Jambu (Rose Wine atau Blush Wine)<br> - 1402030104 Still Grape Wine Dry atau Sweet (Dry Wine atau Sweet Wine)<br>",
    "Tidak Aktif",
  ],
  [
    1402030101,
    "Still Grape Wine Merah / Anggur Merah (Red Wine)",
    "Still Grape Wine Merah / Anggur Merah (Red Wine) adalah anggur dengan kandungan karbondioksida tidak lebih dari 0,4 g/100 ml pada suhu 20\xC2\xB0C.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 7%-24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br> \xE2\x{20AC}\xA2 Kadar karbondioksida tidak lebih dari 0,4 g/100 ml pada suhu 20\xC2\xB0C<br>",
    "Aktif",
  ],
  [
    1402030102,
    "Still Grape Wine Putih / Anggur Putih (White Wine)",
    "Still Grape Wine Putih / Anggur Putih (White Wine) adalah anggur dengan kandungan karbondioksida tidak lebih dari 0,4 g/100 ml pada suhu 20\xC2\xB0C.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 7%-24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br> \xE2\x{20AC}\xA2 Kadar karbondioksida tidak lebih dari 0,4 g/100 ml pada suhu 20\xC2\xB0C<br>",
    "Aktif",
  ],
  [
    1402030103,
    "Stillwine",
    "Stillwine adalah anggur dengan kandungan karbondioksida tidak<br> lebih dari 0,4 g/ml pada suhu 20\xB0C.<br> <br> catatan :<br> Kategori pangan ini sudah digantikan (sesuai jenisnya) :<br> - 1402030101 Still Grape Wine Merah / Anggur Merah (Red Wine)<br> - 1402030102 Still Grape Wine Putih / Anggur Putih (White Wine)<br> - 1402030104 Still Grape Wine Merah Jambu / Anggur Merah Jambu (Rose Wine atau Blush Wine)<br> - 1402030104 Still Grape Wine Dry atau Sweet (Dry Wine atau Sweet Wine)<br>",
    "Tidak Aktif",
  ],
  [
    1402030201,
    "Anggur Sparkling dan Semi Sparkling",
    "Anggur sparkling dan semi sparkling adalah anggur yang menghasilkan karbondioksida selama fermentasinya, baik fermentasi dalam botol atau tangki tertutup. Termasuk di dalamnya anggur berkarbonasi dimana karbondioksidanya sebagian atau seluruhnya ditambahkan dari luar. Contohnya termasuk spumante dan anggur \"cold duck\".<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 7%-24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br> \xE2\x{20AC}\xA2 Kadar karbondioksida tidak kurang dari 0,3 g/100 ml pada suhu 20\xC2\xB0C<br>",
    "Aktif",
  ],
  [
    1402030301,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis",
    "Anggur fortifikasi, anggur liqueur dan anggur manis adalah anggur buah yang dihasilkan dari fermentasi sari buah anggur yang tinggi kandungan gulanya, atau dengan mencampurkan konsentrat sari buah anggur dengan anggur buah atau campuran dari sari buah anggur yang difermentasi dan alkohol. Contohnya termasuk grape dessert wine.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020401,
    "Anggur Buah",
    "Anggur buah adalah minuman hasil fermentasi buah-buahan (selain buah anggur, apel, pir) dan hasil pertanian lainnya dengan atau tanpa bahan pangan lain. Buah-buahan dan hasil pertanian lainnya dapat dicampur dengan anggur dan atau apel dan atau pir.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020402,
    "Anggur Beras",
    "Anggur beras adalah minuman beralkohol hasil fermentasi beras yang telah dimasak, dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br> <br> <br>",
    "Aktif",
  ],
  [
    14020403,
    "Anggur Beras Ketan",
    "Anggur beras ketan adalah minuman beralkohol hasil fermentasi beras ketan yang telah dimasak, dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020404,
    "Anggur Brem Bali",
    "Anggur brem bali adalah minuman hasil fermentasi beras ketan. Merupakan produk khas daerah Bali.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020405,
    "Anggur Sayur (Vegetable Wine)",
    "Anggur sayur (vegetable wine) adalah minuman beralkohol yang diperoleh dari fermentasi sari sayur dan bagian lain dari sayur.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020406,
    "Tuak",
    "Tuak adalah minuman beralkohol yang diperoleh dari hasil fermentasi nira kelapa atau aren.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020407,
    "Anggur Tonikum Kinina",
    "Anggur tonikum kinina adalah minuman beralkohol yang terbuat dari anggur yang ditambah dengan kinina atau senyawa dari kinina.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br> \xE2\x{20AC}\xA2 Kadar kinina (sebagai kinina hidroklorida) 0,6 g/l hingga 2,5 g/l<br>",
    "Aktif",
  ],
  [
    14020408,
    "Sake",
    "Sake adalah minuman beralkohol khas Jepang yang terbuat dari hasil fermentasi beras, dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v",
    "Aktif",
  ],
  [
    140205,
    "Mead, Anggur Madu",
    "Mead, anggur madu adalah minuman beralkohol yang diperoleh dari fermentasi campuran madu dengan air, atau dengan sari buah atau campuran madu, air dan sari buah dengan atau tanpa penambahan herbal atau rempah.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020601,
    "Minuman Spirit",
    "Minuman spirit adalah minuman beralkohol dari penyulingan cairan beralkohol hasil fermentasi biji-bijian, buah atau gula tebu.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol lebih dari 15% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020602,
    "Brandy",
    "Brandy adalah hasil penyulingan dari fermentasi buah anggur yang dimatangkan dalam tong kayu selama tidak kurang dari 1 tahun dengan ukuran tong kayu tidak lebih dari 1000 L.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 36% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)<br> \xE2\x{20AC}\xA2 Dapat mengandung gula, glukosa, fruktosa, jus anggur maupun anggur<br>",
    "Aktif",
  ],
  [
    14020603,
    "Brandy Buah",
    "Brandy buah adalah spirit yang diperoleh dari penyulingan cairan beralkohol (liqueur) hasil fermentasi buah selain buah anggur.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 36% v/v;<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0,01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020604,
    "Cognac",
    "Cognac adalah brandy yang dibuat dari penyulingan hasil fermentasi buah anggur yang tumbuh di daerah tertentu di Perancis.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kandungan etanol tidak kurang dari 40% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020605,
    "Rum",
    "Rum merupakan minuman beralkohol hasil destilasi dari fermentasi sari tebu, sirup tebu, molase tebu atau produk tebu lainnya.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 37.5% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020606,
    "Whisky",
    "Whisky adalah minuman beralkohol dari spirit hasil peragian lumatan serealia atau biji-bijian atau hasil olahannya, dan dimatangkan dalam tong kayu selama tidak kurang dari 2 tahun.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 40% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020607,
    "Gin",
    "Gin adalah hasil penyulingan fermentasi dari biji-bijian, kentang, molases, atau bahan pertanian lainnya, penyulingan ulang dari spirit hasil penyulingan atau pencampuran beberapa spirit asli dan penambahan aroma Juniper berries (Juniperus communis L. dan atau Juniperus oxicedrus L.) dengan atau tanpa penambahan gula.<br> Umumnya gin tidak berwarna meskipun kadang-kadang berwarna emas atau coklat muda.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 37.5%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020608,
    "Vodka",
    "Vodka adalah hasil penyulingan produk fermentasi biji-bijian, kentang, molases, atau bahan pertanian lainnya dan setelah penyulingan ditambahkan arang atau karbon aktif atau absorben lainnya.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 37.5%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020609,
    "Tequila",
    "Tequila adalah hasil penyulingan produk fermentasi getah pohon century atau hasil destilasi produk fermentasi jus tanaman blue agave. Disebut juga cactus whiskey.<br> Catatan : Kategori Pangan ini sudah tidak aktif, digantikan dengan Tequila (14020613) dan Tequila \"100%\" Agave (14020614).",
    "Tidak Aktif",
  ],
  [
    14020610,
    "Arak",
    "Arak adalah minuman beralkohol yang diperoleh dari penyulingan cairan beralkohol hasil fermentasi bahan pangan misalnya beras, shorgum, molases, nira, dan atau buah-buahan.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Bau dan rasa normal dan khas<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 30% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020611,
    "Genever",
    "Genever adalah hasil penyulingan fermentasi dari biji-bijian, kentang, molases, atau bahan pertanian lainnya, penyulingan ulang dari spirit hasil penyulingan atau pencampuran beberapa spirit asli dan penambahan aroma Juniper berries (Juniperus communis L. dan atau Juniperus oxicedrus L.) dengan atau tanpa penambahan gula.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 30% v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020612,
    "Liqueur",
    "Liqueur adalah minuman beralkohol yang diperoleh dengan mencampur atau menyuling spirit dengan atau bersama buah, bunga, daun atau sayur lain atau sarinya, tunggal atau campuran atau dengan ekstrak yang berasal dari penyulingan, seduhan, perkolasi atau maserasi bahan tersebut di atas dengan atau tanpa penambahan gula.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol tidak kurang dari 15 % v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)<br> \xE2\x{20AC}\xA2 Kadar gula tidak kurang dari 2.5 % b/b dihitung terhadap berat produk akhir<br>",
    "Aktif",
  ],
  [
    14020613,
    "Tequila",
    "Tequila adalah minuman beralkohol yang berasal dari Meksiko, yang dihasilkan dari varietas tanaman agave tequilana Weber blue, yang hanya ditanam di wilayah yang telah ditentukan dalamthe Declaration for the Protection of the Appellation of Origin of Tequila dan memenuhi spesifikasi bahan baku, proses produksi, sifat fisiko kimia serta telah memenuhi persyaratan Regulasi Teknis Meksiko (Mexican Technical Regulation). Dapat ditambahkan gula dari sumber lain, sebelum fermentasi hingga kadar gula pereduksi tidak lebih dari 49%<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 35% - 55%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020614,
    "Tequila 100% Agave",
    "Tequila adalah minuman beralkohol yang berasal dari Meksiko, yang dihasilkan dari varietas tanaman agave tequilana Weber blue, yang hanya ditanam di wilayah yang telah ditentukan oleh The Declaration for the Protection of Appellation of Origin of Tequila dan memenuhi spesifikasi meliputi bahan baku, proses produksi, sifat fisika kimia dan telah memenuhi persyaratan Regulasi Teknis Meksiko (Mexican Technical Regulation), tidak boleh ditambahkan gula dari sumber lain.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 35% - 55%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020615,
    "Soju",
    "Soju adalah minuman beralkohol hasil destilasi dari fermentasi beras, gandum, barley, kentang, ubi, tapioka, atau pati lainnya.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 20-35 % v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020701,
    "Minuman Ringan Beralkohol",
    "Minuman ringan beralkohol adalah minuman ringan berkarbonasi yang diberi aroma dan mengandung etanol kurang dari 1%.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol kurang dari 1%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020702,
    "Anggur Rendah Alkohol",
    "Anggur rendah alkohol adalah anggur yang dikurangi kadar etanolnya dengan cara selain pengenceran dengan air.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol : reduced alcohol wine 1,2% hingga 6,5% v/v dan low alcohol wine tidak lebih dari 1.2 % v/v<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020703,
    "Koktail Anggur (Wine Cocktail)",
    "Koktail anggur (wine cocktail) adalah anggur atau anggur fortifikasi yang ditambah dengan salah satu atau campuran dari \"vegetable bitters\", bahan aroma, buah, sari buah atau bahan aroma buah, herbal kering dan atau aromanya.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 7% hingga 24%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020704,
    "Shandy",
    "Shandy adalah produk minuman yang mengandung etanol tidak lebih dari 1% dibuat dari konsentrat shandy, dengan atau tanpa dicampur bir, ditambah gula, air berkarbondioksida. Umumnya shandy diperoleh dari campuran bir dan minuman tidak beralkohol.<br> <br> Karakteristik dasar:<br> Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020705,
    "Meat Wine",
    "Meat wine adalah anggur yang ditambah dengan sari daging sapi.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar protein tidak kurang dari 20 g/l<br> \xE2\x{20AC}\xA2 Kadar etanol 7% hingga 24%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)",
    "Aktif",
  ],
  [
    14020706,
    "Anggur Mengandung Temulawak",
    "Anggur mengandung temulawak adalah anggur ditambah dengan sari temulawak.",
    "Tidak Aktif",
  ],
  [
    14020707,
    "Arak Anggur Mengandung Ginseng",
    "Arak anggur mengandung ginseng adalah anggur ditambah dengan sari ginseng.",
    "Tidak Aktif",
  ],
  [
    14020708,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak)",
    "Anggur mengandung bahan pangan lain adalah anggur ditambah dengan sari atau bahan pangan lain.<br> <br> Karakteristik dasar:<br> \xE2\x{20AC}\xA2 Kadar etanol 7% hingga 24%<br> \xE2\x{20AC}\xA2 Kadar metanol tidak lebih dari 0.01% v/v (dihitung terhadap volume produk)<br>",
    "Aktif",
  ],
  [
    14020709,
    "Minuman Beralkohol Golongan A",
    "Kadar alkohol 1% sampai dengan 5%",
    "Aktif",
  ],
  [
    14020710,
    "Minuman Beralkohol Golongan B",
    "Kadar alkohol lebih dari 5% sampai dengan 20%",
    "Aktif",
  ],
  [
    14020711,
    "Minuman Beralkohol Golongan C",
    "Kadar alkohol lebih dari 20% sampai dengan 55%",
    "Aktif",
  ],
  [140208, "Minuman Beralkohol Golongan A", "-", "Tidak Aktif"],
  [140209, "Minuman Beralkohol Golongan B", "-", "Tidak Aktif"],
  [140210, "Minuman Beralkohol Golongan C", "-", "Tidak Aktif"],
  [
    "1402A1",
    "Minuman Beralkohol Golongan A",
    "Kadar alkohol 1% sampai dengan 5%",
    "Tidak Aktif",
  ],
  [
    "1402B1",
    "Minuman Beralkohol Golongan B",
    "Kadar alkohol lebih dari 5% sampai dengan 20%",
    "Tidak Aktif",
  ],
  [
    "1402C1",
    "Minuman Beralkohol Golongan C",
    "Kadar alkohol lebih dari 20% sampai dengan 55%",
    "Tidak Aktif",
  ],
  [
    150101,
    "Keripik Kentang",
    "Keripik3 kentang adalah makanan ringan yang dibuat dari umbi kentang (Solanum tuberosum) berbentuk irisan tipis dari kentang utuh atau irisan dari kentang yang sudah dipotong dan diolah dengan proses penggorengan atau pemanggangan atau proses lain yang sesuai sehingga diperoleh produk bertekstur renyah siap konsumsi dengan atau tanpa penambahan bahan pangan lain.<br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Tekstur renyah;<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 3%. (dusty), tidak lebih dari 7% (salut).",
    "Aktif",
  ],
  [
    150102,
    "Keripik Gadung",
    "Keripik2 gadung adalah makanan kering yang dibuat dari gadung (Dioscorea hispida) berbentuk irisan tipis yang digoreng dengan atau tanpa penambahan bahan lainnya.",
    "Aktif",
  ],
  [
    150103,
    "Krekers Beras (Senbei)",
    "Kreker beras (senbei) adalah makanan ringan yang terbuat dari beras atau tepung beras dengan campuran bahan atau pati lain dan bahan lainnya.",
    "Aktif",
  ],
  [
    150104,
    "Keripik Singkong",
    "Keripik3 singkong adalah makanan ringan yang dibuat dari umbi singkong (Manihot sp.) berbentuk irisan tipis dari singkong utuh atau<br> irisan singkong yang sudah dipotong dan diolah dengan proses penggorengan atau pemanggangan atau proses lain yang sesuai, sehingga diperoleh produk bertekstur renyah siap konsumsi dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Tekstur renyah;<br> \xE2\x{20AC}\xA2 Kadar air maksimal 6% (dusty), 7% (salut)",
    "Aktif",
  ],
  [150106, "Keripik Sanjai", "", "Aktif"],
  [
    150108,
    "Keripik Ubi Jalar",
    "Keripik ubi jalar adalah makanan kering yang dibuat dari ubi jalar (Manihot esculenta) berbentuk irisan tipis yang digoreng dengan atau tanpa penambahan bahan lainnya.",
    "Aktif",
  ],
  [
    150109,
    "Keripik Tempe",
    "Keripik3 tempe adalah makanan ringan yang dibuat dari tempe kedelai (Glycine max) berbentuk lempengan/irisan tipis dengan proses penggorengan atau pengeringan sehingga diperoleh produk bertekstur renyah dengan atau tanpa penambahan bahan pangan lain.<br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Tekstur renyah;<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 4%.",
    "Aktif",
  ],
  [
    150110,
    "Keripik Oncom",
    "Keripik oncom adalah makanan khas dari Bandung yang umumnya terbuat dari oncom merah, yang merupakan hasil fermentasi bungkil kacang kedelai. Keripik oncom terbuat dari oncom yang diiris tipis-tipis, kemudian dilapisi dengan campuran tepung dan bahan lain",
    "Aktif",
  ],
  [
    150111,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu",
    "Keripik3 tahu/keripik3 produk tahu/keripik3 kembang tahu adalah makanan kering yang dibuat dari tahu atau produk olahan tahu dengan proses penggorengan atau pengeringan sehingga diperoleh produk bertekstur renyah dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar :<br> Kadar air tidak lebih dari 10%.",
    "Aktif",
  ],
  [
    150112,
    "Keripik Talas",
    "Keripik3 talas adalah makanan ringan yang dibuat dari umbi talas (Colocasia esculenta L) berbentuk irisan tipis yang digoreng dengan atau tanpa penambahan bahan pangan lain.<br> <br> Karakteristik dasar :<br> \xE2\x{20AC}\xA2 Tekstur renyah;<br> \xE2\x{20AC}\xA2 Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    150113,
    "Makanan Ringan Simulasi",
    "Makanan ringan simulasi adalah makanan ringan yang terbuat dari<br> tepung dan/atau pati (serealia, umbi, kacang-kacangan) dengan<br> pencampuran bahan lain, dibentuk atau dipotong,<br> dijemur/dikeringkan atau langsung digoreng/dioven.<br> Produk ini tidak termasuk keripik3 kentang, keripik3 singkong atau<br> keripik3 umbi-umbian lainnya.",
    "Aktif",
  ],
  [
    150114,
    "Kecimpring",
    "Kecimpring adalah makanan ringan yang terbuat dari singkong (ubi<br> kayu), bumbu. Pembuatan meliputi pemarutan singkong untuk<br> dicampur dengan bumbu. Kemudian adonan dipres hingga tipis,<br> dilanjutkan dengan pengukusan dan penjemuran. Setelah kering,<br> cetakan (pelat pres) dilepas, dipotong dan digoreng.",
    "Aktif",
  ],
  [
    150115,
    "Opak",
    "Opak adalah makanan ringan yang terbuat dari tepung beras atau singkong atau umbi-umbi lainnya yang diparut dengan penambahan bahan lain, dibentuk dan dipanggang.",
    "Aktif",
  ],
  [
    150116,
    "Simping",
    "Simping adalah makanan ringan khas Jawa Barat dengan rasa asin<br> dan citarasa khas. Simping terbuat dari bahan tapioka, garam dan<br> kencur halus yang dicampur menjadi adonan, kemudian dimasak<br> pada cetakan khusus (dipres diantara dua pelat tebal) dan proses<br> pemasakan melibatkan pembakaran kedua pelat tersebut pada api<br> secara langsung.",
    "Aktif",
  ],
  [
    150117,
    "Slondok",
    "Slondok adalah makanan ringan terbuat dari tepung singkong atau tapioka dengan campuran bahan dan pati lain.",
    "Aktif",
  ],
  [
    150118,
    "Pilus",
    "Pilus adalah makanan ringan terbuat dari tepung singkong/tapioka<br> dengan campuran bahan atau pati lain dan bumbu rempah; yang<br> diproses dengan atau tanpa menggunakan mesin ekstrusi kemudian<br> dipotong menjadi ukuran kecil dan digoreng atau dipanggang.",
    "Aktif",
  ],
  [
    150119,
    "Jagung Berondong",
    "Jagung berondong adalah makanan ringan terbuat dari jagung (Zea<br> mays) varietas popping corn, diolah dengan pemanasan hingga<br> menyebabkan peletupan dan pengembangan dengan atau tanpa<br> penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    150120,
    "Jagung Marning",
    "Jagung marning adalah makanan ringan yang dibuat dari biji jagung<br> (Zea mays) tua, direbus, dikeringkan dan digoreng dengan atau tanpa<br> penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    150121,
    "Jipang Jagung",
    "Jipang jagung adalah makanan ringan dibuat dari jagung (Zea mays)<br> yang diolah sampai mengembang dengan proses penggorengan atau<br> pemanggangan atau puffing/ekstrusi atau terlebih dahulu dikukus,<br> dikeringkan dan digoreng sampai mengembang, dicampur dengan<br> gula, kemudian dicetak, dengan atau tanpa penambahan bahan<br> pangan lain.",
    "Aktif",
  ],
  [
    150122,
    "Jipang Beras",
    "Jipang beras adalah produk makanan ringan yang dibuat dari beras<br> (Oryza sativa L.) dan/atau beras ketan (Oryza sativa var. glutinosa)<br> yang diolah dengan proses penggorengan atau pemanggangan atau<br> puffing/ekstrusi atau terlebih dahulu dikukus, dikeringkan dan<br> digoreng sampai mengembang, dicampur dengan gula, kemudian<br> dicetak, dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    150123,
    "Kerupuk Beras",
    "Kerupuk4 beras adalah makanan ringan terbuat dari bahan tepung<br> beras atau tepung beras ketan yang dengan atau tanpa penambahan<br> bahan pangan lain, dibentuk, direbus/dikukus, dicetak lempengan<br> tipis, dikeringkan dan digoreng.",
    "Aktif",
  ],
  [
    150124,
    "Kerupuk Puli",
    "Kerupuk puli adalah makanan ringan terbuat dari tepung beras yang dicampur dengan bahan lain, dibentuk, direbus/dikukus, dicetak lempengan tipis, dikeringkan dan digoreng. Umumnya ditambahkan udang.",
    "Aktif",
  ],
  [
    150125,
    "Kerupuk Karak",
    "Kerupuk4 karak adalah makanan ringan terbuat dari hasil<br> pemasakan nasi, ditumbuk yang kemudian dikeringkan kembali<br> untuk digoreng.",
    "Aktif",
  ],
  [
    150126,
    "Kerupuk Intip",
    "Kerupuk4 intip adalah makanan ringan terbuat dari bagian/lapisan<br> yang diperoleh dari hasil pemasakan nasi yang menempel pada<br> bagian dasar wadah, dikeringkan kembali untuk digoreng dengan<br> atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    150127,
    "Rengginang/ Batiah",
    "Rengginang/batiah adalah makanan ringan terbuat dari beras ketan<br> yang telah dimasak menjadi nasi ketan terlebih dahulu, dengan atau<br> tanpa penambahan bahan pangan lain, dibentuk, dijemur hingga<br> kering dan digoreng.",
    "Aktif",
  ],
  [
    150128,
    "Rempeyek",
    "Rempeyek adalah makanan ringan berbentuk tipis dan renyah,<br> terbuat dari tepung beras dengan atau tanpa campuran tepung lain,<br> dicampur dengan bahan pangan lain seperti kacang tanah, kacang<br> kedelai, kacang hijau, ikan atau bahan pangan lain kemudian<br> digoreng. Nama jenis untuk produk ini misalnya rempeyek kacang,<br> rempeyek kacang kedelai.",
    "Aktif",
  ],
  [
    150129,
    "Makanan Ringan Ekstrudat",
    "Makanan ringan siap makan yang dibuat dari bahan pangan sumber<br> karbohidrat dan/atau protein melalui proses ekstrusi dengan atau<br> tanpa penambahan bahan pangan lain, dengan atau tanpa melalui<br> proses lainnya seperti penggorengan/ pemanggangan.",
    "Aktif",
  ],
  [
    150130,
    "Emping Melinjo Goreng",
    "Emping melinjo goreng adalah produk keripik yang diperoleh dari emping melinjo yang digoreng dengan atau tanpa penambahan bahan lain.",
    "Aktif",
  ],
  [150131, "Keripik Lainnya", "&nbsp;", "Aktif"],
  [150132, "Kerupuk Lainnya", "&nbsp;", "Aktif"],
  [150133, "Makanan Ringan Lain", "&nbsp;", "Aktif"],
  [
    150134,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati",
    "-",
    "Aktif",
  ],
  [
    150135,
    "Krekers Rasa",
    "Krekers rasa adalah jenis krekers dari terigu dan/atau non terigu yang dalam pembuatannya memerlukan proses fermentasi atau tidak, serta melalui proses laminasi sehingga menghasilkan bentuk pipih dan bila dipatahkan penampangnya tampak berlapis-lapis, diberi bahan sebagai sumber rasa misalnya gula, keju, abon, cokelat. Nama jenis untuk kategori ini disesuaikan dengan bahan sumber rasanya, misalnya krekers abon, krekers cokelat, krekers manis, krekers gurih.<br> Karakteristik dasar :<br> Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    150136,
    "Krekers Sandwich",
    "Krekers sandwich adalah jenis krekers dari terigu dan/atau non terigu dengan menggunakan krim filling (rasa keju, rasa coklat, rasa buah, dan lain-lain) sedikitnya terdiri dari 2 (dua) keping krekers.",
    "Aktif",
  ],
  [
    150137,
    "Malkist",
    "Malkist adalah jenis krekers dari terigu dan/atau non terigu fermentasi yang pada proses laminasinya menggunakan cracker dust di antara lapisan-lapisannya yang permukaannya disalut atau ditaburi gula.<br> Karakteristik dasar :<br> Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    150138,
    "Jipang Melinjo",
    "Jipang melinjo adalah makanan ringan dibuat dari melinjo (Gnetum gnemon) yang diolah dengan proses penggorengan atau pemanggangan atau puffing/ekstrusi atau terlebih dahulu dikukus, dikeringkan dan digoreng sampai mengembang, dicampur dengan gula, kemudian dicetak, dengan atau tanpa penambahan bahan pangan lain. Karakteristik dasar: Kadar air tidak lebih dari 8%.",
    "Aktif",
  ],
  [
    150139,
    "Patilo / Rengginang Singkong",
    "Patilo/rengginang singkong adalah makanan ringan sejenis rengginang yang terbuat dari singkong, dengan atau tanpa penambahan bahan pangan lain, dibentuk, dijemur hingga kering dan digoreng.",
    "Aktif",
  ],
  [
    150140,
    "Makanan Ringan Berbentuk Batang/Bar",
    "Makanan ringan terbuat dari campuran bahan sumber karbohidrat dan/atau protein, dengan atau tanpa penambahan gula, lemak, dan bahan pangan lain seperti cokelat, buah kering, serealia, dan dibentuk batang (bar).",
    "Aktif",
  ],
  [
    150201,
    "Kacang Garing/Kacang Kulit",
    "Kacang garing/kacang kulit adalah kacang tanah atau kacang lainnya yang masih dalam kulitnya, direndam, direbus dengan atau tanpa penambahan bahan pangan lain, ditiriskan kemudian dipanggang/dioven.",
    "Aktif",
  ],
  [
    150204,
    "Kacang Panggang",
    "Kacang panggang adalah kacang tanah yang telah dihilangkan kulit<br> arinya, kemudian dipanggang/dioven. Dengan atau tanpa pelapisan<br> bumbu. Nama jenis untuk produk ini misalnya kacang Bali.",
    "Aktif",
  ],
  [
    150205,
    "Kacang Mede",
    "Kacang mede adalah biji dari buah tanaman jambu mete (Anacardium occidentale) yang telah dikupas kulitnya, dikeringkan dan dapat dipanggang atau digoreng.",
    "Tidak Aktif",
  ],
  [150206, "Kipang Kacang Mete", "", "Aktif"],
  [
    150207,
    "Kacang Atom/Sukro",
    "Kacang atom/sukro adalah makanan ringan yang terbuat dari kacang tanah dan disalut dengan adonan tepung dan/atau pati, dan digoreng atau dipanggang. Dapat ditambahkan bumbu atau bahan pangan lain.",
    "Aktif",
  ],
  [
    150208,
    "Kacang Telur",
    "Kacang telur adalah makanan ringan yang terbuat dari kacang tanah (Arachis hypogea L) dan disalut dengan adonan tepung dan/atau pati dan telur yang telah dibumbui dan digoreng.",
    "Aktif",
  ],
  [
    150209,
    "Kacang Goyang",
    "Kacang goyang adalah kacang tanah (Arachis hypogea L) yang telah dihilangkan kulit arinya, disalut dengan adonan bergula, kemudian diproses dengan penggoyangan secara panas.",
    "Aktif",
  ],
  [
    150210,
    "Jipang/Kipang Kacang",
    "Jipang/kipang kacang adalah makanan ringan, dibuat dari kacang tanah (Arachis hypogea L) atau kacang lainnya, disangrai, dihilangkan kulit arinya, dicampur dengan gula, dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [150211, "Kacang Kapri", "", "Tidak Aktif"],
  [150212, "Kacang Koro", "", "Tidak Aktif"],
  [150213, "Kacang Bogor", "", "Tidak Aktif"],
  [150214, "Kacang Pistacio", "-", "Tidak Aktif"],
  [150215, "Makanan Ringan Berbahan Dasar Kacang", "-", "Aktif"],
  [
    150216,
    "Kacang Atom Lainnya",
    "PERATURAN BADAN PENGAWAS OBAT DAN MAKANAN NOMOR 34 TAHUN 2019 TENTANG KATEGORI PANGAN<br> <br> Kacang atom lainnya adalah makanan ringan yang terbuat dari kacang selain kacang tanah dan disalut dengan adonan tepung<br> dan/atau pati, dan digoreng atau dipanggang. Dapat ditambahkan bumbu atau bahan pangan lain. Nama jenis untuk produk ini misalnya kacang atom kedelai.",
    "Aktif",
  ],
  [
    150217,
    "Kacang Sangrai",
    "Kacang sangrai adalah kacang tanah yang masih dalam kulitnya dan disangrai.<br> <br> Karakteristik dasar:<br> Kadar air tidak lebih dari 3%",
    "Aktif",
  ],
  [
    150218,
    "Kacang Goreng Lainnya",
    "Kacang goreng lainnya adalah kacang selain kacang tanah dengan atau tanpa kulit ari, yang telah digoreng, dengan atau tanpa penambahan bahan pangan lain. Nama jenis untuk produk ini misalnya kacang kedelai goreng, kacang koro goreng, kacang kapri goreng, kacang bogor goreng.",
    "Aktif",
  ],
  [
    150219,
    "Kacang Panggang Lainnya",
    "Kacang panggang lainnya adalah kacang selain kacang tanah yang telah dihilangkan kulit arinya, kemudian dipanggang/dioven. Dengan atau tanpa pelapisan bumbu. Nama jenis untuk produk ini misalnya kacang mede panggang, kacang koro panggang.",
    "Aktif",
  ],
  [
    150220,
    "Kacang Bersalut",
    "Kacang bersalut adalah makanan ringan, dibuat dari kacang yang<br> dilapisi dengan tepung/pati, gula atau bahan lainnya. Kacang<br> bersalut termasuk di dalamnya kacang atom/sukro, kacang telur,<br> kacang goyang, dan lain-lain.",
    "Aktif",
  ],
  [
    150221,
    "Kacang Goreng",
    "Kacang goreng adalah kacang tanah dengan atau tanpa kulit ari, yang telah digoreng, dengan atau tanpa penambahan bahan pangan lain",
    "Aktif",
  ],
  [150222, "Kacang Alas (Biji Sengon)", "&nbsp;", "Aktif"],
  [
    150301,
    "Kerupuk Ikan",
    "Kerupuk ikan adalah makanan ringan, dibuat dari campuran ikan laut atau ikan air tawar, beku atau segar dengan tepung tapioka, sagu atau tepung pati dan atau bahan lainnya. Dapat mengandung gula dan rempah. Digoreng, dikemas dalam kemasan kedap.",
    "Aktif",
  ],
  [
    150302,
    "Kerupuk Udang Matang",
    "Kerupuk udang adalah makanan ringan dibuat dari campuran udang beku atau segar dengan tepung tapioka, sagu atau tepung pati lainnya. Dapat mengandung gula dan rempah. Digoreng, dikemas dalam kemasan kedap.",
    "Aktif",
  ],
  [
    150303,
    "Kerupuk Cumi",
    "Kerupuk cumi adalah makanan ringan dibuat dari cumi-cumi beku atau segar dengan tepung tapioka, sagu atau tepung pati lainnya. Dapat ditambahkan rempah atau bahan lainnya. Digoreng, dikemas dalam kemasan kedap.",
    "Aktif",
  ],
  [
    150304,
    "Kemplang",
    "Kemplang adalah makanan ringan dibuat dari campuran produk perikanan beku atau segar dengan tepung tapioka, sagu atau tepung pati lainnya. Dapat mengandung gula dan rempah. Dipanggang, dikemas dalam kemasan kedap.",
    "Aktif",
  ],
  [
    150305,
    "Rempeyek Ikan",
    "Rempeyek ikan adalah makanan ringan dibuat dari tepung beras dengan atau tanpa campuran pati lain, dicampur dengan bahan lain seperti teri, udang atau bahan lainnya kemudian digoreng.",
    "Aktif",
  ],
  [
    150306,
    "Sumpia Udang",
    "Sumpia udang adalah makanan ringan yang berbentuk seperti lumpia dengan ukuran kecil yang dibuat dari adonan tepung terigu dan/atau tepung lainnya, diisi udang dengan atau tanpa bahan pangan lain dan digoreng.",
    "Aktif",
  ],
  [150307, "Getas", "", "Aktif"],
  [150308, "Makanan Ringan Berbasis Ikan, dll", "&nbsp;", "Aktif"],
  [1606, "Nasi Goreng Instan", "", "Tidak Aktif"],
  [1609, "Nasi Kuning Instan", "", "Tidak Aktif"],
  [1611, "Nasi Kunyit Instan", "", "Tidak Aktif"],
  [1613, "Nasi Liwet Instan", "", "Tidak Aktif"],
  [1615, "Nasi Uduk Instan", "", "Tidak Aktif"],
  [
    1657,
    "Pengembang Roti/Kue (Bread Improver)",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [1658, "Pangsit Isi Sayuran", "&nbsp;", "Tidak Aktif"],
  [1659, "Sup Jamur", "&nbsp;", "Tidak Aktif"],
  [1660, "Sup Sayuran", "&nbsp;", "Tidak Aktif"],
  [1661, "Lumpia Isi", "-", "Tidak Aktif"],
  [1662, "Kroket Isi", "-", "Tidak Aktif"],
  [
    1663,
    "Nasi Campur Lauk (daging, ikan, dll)",
    "-",
    "Tidak Aktif",
  ],
  [
    1664,
    "Nasi Campur Lauk (Daging atau Unggas dengan Sayur) (Steril)",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    1665,
    "Nasi Campur Lauk (Daging atau Unggas dengan Sayur)",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    1666,
    "Nasi Campur Lauk (Ikan dan Hasil Olahnya dengan Sayur) (Steril)",
    "",
    "Tidak Aktif",
  ],
  [
    1667,
    "Nasi Campur Lauk (Ikan dan Hasil Olahnya dengan Sayur)",
    "&nbsp;",
    "Tidak Aktif",
  ],
  [
    1668,
    "Nasi Instan Dengan ....",
    "Nasi instan dengan \xE2\x{20AC}\xA6 adalah produk nasi instan yang mengandung bumbu, kacang, daging, sayur dan atau bahan pangan lainnya.",
    "Tidak Aktif",
  ],
  [
    1669,
    "Kebab/Roti Isi Daging/Tortilla Isi Daging",
    "",
    "Tidak Aktif",
  ],
  [
    1670,
    "Pasta (Spagheti, Makaroni,...) dengan Saus dan Daging (Sapi, Babi, Ayam, ....)",
    "-",
    "Tidak Aktif",
  ],
  [
    1671,
    "Kombinasi Pangan Olahan (Produk Bakeri Istimewa dan Minuman Serbuk)",
    "Kategori pangan ini mengakomodir pendaftaran dari produk kombinasi, di mana dalam satu kemasan terdiri dari 2 macam produk. Untuk kategori pangan ini produk terdiri dari produk bakeri istimewa (wafer, biskuit, kukis dll) dan minuman serbuk.",
    "Tidak Aktif",
  ],
  [
    1672,
    "Olahan Gluten (Diolah dengan Perlakuan Panas)",
    "-",
    "Tidak Aktif",
  ],
  [1673, "Nasi Instan Dengan .... (Steril)", "-", "Tidak Aktif"],
  [1674, "Kolak", "-", "Tidak Aktif"],
  [1675, "Bakso Campur dan Batagor", "-", "Tidak Aktif"],
  [
    1676,
    "Makanan Siap Saji Berbasis Nasi (Terkemas)",
    "Makanan cepat saji berbasis nasi, misalnya nasi goreng, nasi uduk, nasi kuning, nasi opor ayam, nasi rendang ayam, ketupat sayur, pecel lele, lontong sate ayam, bubur ayam.<br> Pangan siap saji, tidak termasuk Kategori Pangan 01 - 15. Terdiri dari campuran produk pangan dari Kategori Pangan 01 \xE2\x{20AC}\x{201C} 15, minimal 2 Kategori Pangan yang berbeda. Masing-masing produk pangan penyusun dapat diidentifikasi (terlihat jelas) sesuai jenis pangan. Apabila dilakukan pemanasan hanya untuk tujuan menghangatkan.",
    "Aktif",
  ],
  [
    1677,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas)",
    "Makanan cepat saji berbasis mi/bihun, kecuali mi instan dengan<br> bahan pelengkap/garnish yang kering. Misalnya mi/bihun goreng<br> dengan ayam, mi/bihun ayam jamur, mi rendang, ramen ayam.<br> <br> Pangan siap saji, tidak termasuk Kategori Pangan 01 - 15. Terdiri dari campuran produk pangan dari Kategori Pangan 01 \xE2\x{20AC}\x{201C} 15, minimal 2 Kategori Pangan yang berbeda. Masing-masing produk pangan penyusun dapat diidentifikasi (terlihat jelas) sesuai jenis pangan. Apabila dilakukan pemanasan hanya untuk tujuan menghangatkan.",
    "Aktif",
  ],
  [
    1678,
    "Makanan Siap Saji Berbasis Kentang (Terkemas)",
    "Makanan cepat saji berbasis kentang, misalnya steak.<br> Pangan siap saji, tidak termasuk Kategori Pangan 01 - 15. Terdiri dari campuran produk pangan dari Kategori Pangan 01 \xE2\x{20AC}\x{201C} 15, minimal 2 Kategori Pangan yang berbeda. Masing-masing produk pangan penyusun dapat diidentifikasi (terlihat jelas) sesuai jenis pangan. Apabila dilakukan pemanasan hanya untuk tujuan menghangatkan.",
    "Aktif",
  ],
  [
    1679,
    "Makanan Siap Saji Berbasis Pasta (Terkemas)",
    "Makanan cepat saji berbasis pasta, misalnya makaroni dan keju, lasagna, spaghetti marinara.<br> Pangan siap saji, tidak termasuk Kategori Pangan 01 - 15. Terdiri dari campuran produk pangan dari Kategori Pangan 01 \xE2\x{20AC}\x{201C} 15, minimal 2 Kategori Pangan yang berbeda. Masing-masing produk pangan penyusun dapat diidentifikasi (terlihat jelas) sesuai jenis pangan. Apabila dilakukan pemanasan hanya untuk tujuan menghangatkan.",
    "Aktif",
  ],
  [
    1680,
    "Makanan Siap Saji Berbasis Umbi (Terkemas)",
    "Makanan cepat saji berbasis umbi, seperti tiwul dengan lauk.<br> Pangan siap saji, tidak termasuk Kategori Pangan 01 - 15. Terdiri dari campuran produk pangan dari Kategori Pangan 01 \xE2\x{20AC}\x{201C} 15, minimal 2 Kategori Pangan yang berbeda. Masing-masing produk pangan penyusun dapat diidentifikasi (terlihat jelas) sesuai jenis pangan. Apabila dilakukan pemanasan hanya untuk tujuan menghangatkan.",
    "Aktif",
  ],
  [
    1681,
    "Makanan Siap Saji Berbasis Roti (Terkemas)",
    "Makanan cepat saji berbasis roti, seperti burger, pizza, hotdog, kebab, panini, tortilla, roti canai dan kare.<br> Pangan siap saji, tidak termasuk Kategori Pangan 01 - 15. Terdiri dari campuran produk pangan dari Kategori Pangan 01 \xE2\x{20AC}\x{201C} 15, minimal 2 Kategori Pangan yang berbeda. Masing-masing produk pangan penyusun dapat diidentifikasi (terlihat jelas) sesuai jenis pangan. Apabila dilakukan pemanasan hanya untuk tujuan menghangatkan.",
    "Aktif",
  ],
  [
    1682,
    "Makanan Siap Saji Berbasis Kuah (Terkemas)",
    "Makanan cepat saji berkuah, misalnya soto bersantan, soto tanpa<br> santan, sop, rawon, sambal tumpang, dan brongkos.<br> Pangan siap saji, tidak termasuk Kategori Pangan 01 - 15. Terdiri dari campuran produk pangan dari Kategori Pangan 01 \xE2\x{20AC}\x{201C} 15, minimal 2 Kategori Pangan yang berbeda. Masing-masing produk pangan penyusun dapat diidentifikasi (terlihat jelas) sesuai jenis pangan. Apabila dilakukan pemanasan hanya untuk tujuan menghangatkan.",
    "Aktif",
  ],
  [
    1683,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas)",
    "Makanan cepat saji berbasis sayuran, misalnya pecel, lotek, cap cay,<br> gado-gado, karedok, rujak cingur, sayur nangka, dan gudeg.<br> <br> Pangan siap saji, tidak termasuk Kategori Pangan 01 - 15. Terdiri dari campuran produk pangan dari Kategori Pangan 01 \xE2\x{20AC}\x{201C} 15, minimal 2 Kategori Pangan yang berbeda. Masing-masing produk pangan penyusun dapat diidentifikasi (terlihat jelas) sesuai jenis pangan. Apabila dilakukan pemanasan hanya untuk tujuan menghangatkan.",
    "Aktif",
  ],
  [99, "Bahan Tambahan Pangan", "", "Aktif"],
];
# END FRAGMENT id=data-idn_bpom_kategori_pangan

my $res = gen_read_table_func(
    name => 'bpom_list_food_categories_old',
    summary => 'List food categories in BPOM processed food division (old, pre-RBA version)',
    table_data => $data_idn_bpom_kategori_pangan,
    table_spec => $meta_idn_bpom_kategori_pangan,
    description => <<'_',
_
    extra_props => {
        examples => [
            {
                summary => 'Print active categories codes matching "cokelat"',
                src_plang => "bash",
                src => "[[prog]] --status-is Aktif 'cokelat hitam'",
                test => 0,
            },
            {
                summary => 'Print active records matching "cokelat hitam" in a formatted text table',
                src_plang => "bash",
                src => "[[prog]] --status-is Aktif 'cokelat hitam' -l --format text-pretty",
                test => 0,
            },
            {
                summary => 'Print all category records with code 14.1.4.2',
                src_plang => "bash",
                src => "[[prog]] --code-matches '^14010402' -l --format text-pretty",
                test => 0,
            },
            {
                summary => 'How many categories are active vs inactive?',
                src_plang => "bash",
                src => "echo -n 'Aktif: '; [[prog]] --status-is Aktif | wc -l; echo -n 'Tidak Aktif: '; [[prog]] --status-isnt Aktif | wc -l",
                test => 0,
            },
        ],
    },
);
die "Can't generate function: $res->[0] - $res->[1]" unless $res->[0] == 200;

# ABSTRACT: List food categories in BPOM processed food division (old, pre-RBA version)

__END__

=pod

=encoding UTF-8

=head1 NAME

App::BPOMUtils::Table::FoodCategory - List food categories in BPOM processed food division (old, pre-RBA version)

=head1 VERSION

This document describes version 0.018 of App::BPOMUtils::Table::FoodCategory (from Perl distribution App-BPOMUtils-Table-FoodCategory), released on 2023-09-03.

=head1 DESCRIPTION

This distribution contains the following CLIs:

=over

=item * L<bpom-daftar-kategori-pangan-lama>

=item * L<bpom-daftar-kategori-pangan-rba>

=item * L<bpom-list-food-categories-old>

=item * L<bpom-list-food-categories-rba>

=back

=head1 FUNCTIONS


=head2 bpom_list_food_categories_old

Usage:

 bpom_list_food_categories_old(%args) -> [$status_code, $reason, $payload, \%result_meta]

List food categories in BPOM processed food division (old, pre-RBA version).

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<code> => I<str>

Only return records where the 'code' field equals specified value.

=item * B<code.contains> => I<str>

Only return records where the 'code' field contains specified text.

=item * B<code.in> => I<array[str]>

Only return records where the 'code' field is in the specified values.

=item * B<code.is> => I<str>

Only return records where the 'code' field equals specified value.

=item * B<code.isnt> => I<str>

Only return records where the 'code' field does not equal specified value.

=item * B<code.matches> => I<str>

Only return records where the 'code' field matches specified regular expression pattern.

=item * B<code.max> => I<str>

Only return records where the 'code' field is less than or equal to specified value.

=item * B<code.min> => I<str>

Only return records where the 'code' field is greater than or equal to specified value.

=item * B<code.not_contains> => I<str>

Only return records where the 'code' field does not contain specified text.

=item * B<code.not_in> => I<array[str]>

Only return records where the 'code' field is not in the specified values.

=item * B<code.not_matches> => I<str>

Only return records where the 'code' field does not match specified regular expression.

=item * B<code.xmax> => I<str>

Only return records where the 'code' field is less than specified value.

=item * B<code.xmin> => I<str>

Only return records where the 'code' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<exclude_fields> => I<array[str]>

Select fields to return.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<name> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.contains> => I<str>

Only return records where the 'name' field contains specified text.

=item * B<name.in> => I<array[str]>

Only return records where the 'name' field is in the specified values.

=item * B<name.is> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.isnt> => I<str>

Only return records where the 'name' field does not equal specified value.

=item * B<name.matches> => I<str>

Only return records where the 'name' field matches specified regular expression pattern.

=item * B<name.max> => I<str>

Only return records where the 'name' field is less than or equal to specified value.

=item * B<name.min> => I<str>

Only return records where the 'name' field is greater than or equal to specified value.

=item * B<name.not_contains> => I<str>

Only return records where the 'name' field does not contain specified text.

=item * B<name.not_in> => I<array[str]>

Only return records where the 'name' field is not in the specified values.

=item * B<name.not_matches> => I<str>

Only return records where the 'name' field does not match specified regular expression.

=item * B<name.xmax> => I<str>

Only return records where the 'name' field is less than specified value.

=item * B<name.xmin> => I<str>

Only return records where the 'name' field is greater than specified value.

=item * B<queries> => I<array[str]>

Search.

This will search all searchable fields with one or more specified queries. Each
query can be in the form of C<-FOO> (dash prefix notation) to require that the
fields do not contain specified string, or C</FOO/> to use regular expression.
All queries must match if the C<query_boolean> option is set to C<and>; only one
query should match if the C<query_boolean> option is set to C<or>.

=item * B<query_boolean> => I<str> (default: "and")

Whether records must match all search queries ('and') or just one ('or').

If set to C<and>, all queries must match; if set to C<or>, only one query should
match. See the C<queries> option for more details on searching.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<array[str]>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<status> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.contains> => I<str>

Only return records where the 'status' field contains specified text.

=item * B<status.in> => I<array[str]>

Only return records where the 'status' field is in the specified values.

=item * B<status.is> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.isnt> => I<str>

Only return records where the 'status' field does not equal specified value.

=item * B<status.matches> => I<str>

Only return records where the 'status' field matches specified regular expression pattern.

=item * B<status.max> => I<str>

Only return records where the 'status' field is less than or equal to specified value.

=item * B<status.min> => I<str>

Only return records where the 'status' field is greater than or equal to specified value.

=item * B<status.not_contains> => I<str>

Only return records where the 'status' field does not contain specified text.

=item * B<status.not_in> => I<array[str]>

Only return records where the 'status' field is not in the specified values.

=item * B<status.not_matches> => I<str>

Only return records where the 'status' field does not match specified regular expression.

=item * B<status.xmax> => I<str>

Only return records where the 'status' field is less than specified value.

=item * B<status.xmin> => I<str>

Only return records where the 'status' field is greater than specified value.

=item * B<summary> => I<str>

Only return records where the 'summary' field equals specified value.

=item * B<summary.contains> => I<str>

Only return records where the 'summary' field contains specified text.

=item * B<summary.in> => I<array[str]>

Only return records where the 'summary' field is in the specified values.

=item * B<summary.is> => I<str>

Only return records where the 'summary' field equals specified value.

=item * B<summary.isnt> => I<str>

Only return records where the 'summary' field does not equal specified value.

=item * B<summary.matches> => I<str>

Only return records where the 'summary' field matches specified regular expression pattern.

=item * B<summary.max> => I<str>

Only return records where the 'summary' field is less than or equal to specified value.

=item * B<summary.min> => I<str>

Only return records where the 'summary' field is greater than or equal to specified value.

=item * B<summary.not_contains> => I<str>

Only return records where the 'summary' field does not contain specified text.

=item * B<summary.not_in> => I<array[str]>

Only return records where the 'summary' field is not in the specified values.

=item * B<summary.not_matches> => I<str>

Only return records where the 'summary' field does not match specified regular expression.

=item * B<summary.xmax> => I<str>

Only return records where the 'summary' field is less than specified value.

=item * B<summary.xmin> => I<str>

Only return records where the 'summary' field is greater than specified value.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hashE<sol>associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).


=back

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-BPOMUtils-Table-FoodCategory>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-BPOMUtils-Table-FoodCategory>.

=head1 SEE ALSO

L<App::BPOMUtils::Table::FoodCategoryRBA>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-BPOMUtils-Table-FoodCategory>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
