use Test::More tests => 3;
use B::Hooks::OP::Check::LeaveEval;
use lib 't/lib';

BEGIN {    # to catch use
    my %to_wrap = map { $_ => undef } qw[
        Foo::foo
        Bar::bar
        Eval::gen
    ];
    B::Hooks::OP::Check::LeaveEval::register(sub {
        foreach my $sub (keys %to_wrap) {
            next unless defined &$sub;

            no strict 'refs';
            my $orig = \&{ $sub };
            *$sub = sub { return '[' . $orig->() . ']' };
            
            delete $to_wrap{$sub};
        }
    });
}

use Foo;
require Bar;
eval 'sub Eval::gen { return "eval" }';

is Foo::foo(),  '[foo]',  'sub from used module wrapped';
is Bar::bar(),  '[bar]',  'sub from required module wrapped';
is Eval::gen(), '[eval]', 'sub generated by eval wrapped';
